#ifndef BTOCL_KERNELS_CONTINUOUS_H
#define BTOCL_KERNELS_CONTINUOUS_H

#ifdef BTOCL

const char * STRING_CHOLUPDCOL_PURE = 
"#pragma OPENCL EXTENSION cl_khr_fp64: enable \n"
"// used by cholesky blocked version - kernel use; unblocked, no workgroups\n"
"// No use of local or private memory to pre-load rows/arrows\n"
"// Backward (or forward) substitution\n"
"                                      \n"
"__kernel void btocl_cholupdcol_pure(__global double* matrix, int c_idx, int nrows, int diag_idx, int nb, int lda) {\n"
"	int row,col,i;\n"
"	int l_start, l_idx;\n"
"	int c_start, c_iter;\n"
"	double sum;\n"
"                 \n"
"	row = get_global_id(0); // solving this row\n"
"                        \n"
"	l_start = diag_idx;\n"
"	c_start = c_idx + row; // beginning of row   \n"
"	                                             \n"
"	for(col=0; col < nb; col++) {  // col:[0,nb-1] \n"
"	                                               \n"
"		sum = 0.0;                                 \n"
"		c_iter = c_start;                          \n"
"		//compute sum                              \n"
"		l_idx = l_start;                            \n"
"		for(i=0; i < col;i++) {                     \n"
"			sum+= matrix[l_idx]*matrix[c_iter];      \n"
"			c_iter += lda;                           \n"
"			l_idx += lda;                            \n"
"		}                                             \n"
"		// compute unknown (row,col)                  \n"
"			                                           \n"
"		// matrix[c_iter] = (matrix[c_iter] - sum)/matrix[l_idx];\n"
"		matrix[c_iter] -= sum;                         \n"
"		matrix[c_iter] /= matrix[l_idx];                \n"
"		                                                \n"
"		// we could transpose it here if we think this will benefit access  \n"
"		// in updmat                                      \n"
"		                                                  \n"
"		l_start++;                                        \n"
"	}                                                     \n"
"}                                                        \n"
;


const char*  STRING_CHOLUPDMAT_PURE = 
"                  \n"
"#pragma OPENCL EXTENSION cl_khr_fp64: enable  \n"
//"                                             \n"
"__kernel void btocl_cholupdmat_pure(__global double* matrix, int mat_idx, \n"
"                           int mat_dim, int blockcol_idx, int cbs, int lda) {\n"
"	double sum; \n"
"	int row, col, i,diag,size; \n"
"	int idx_col, idx_row;      \n"
"	                            \n"
"	i = get_global_id(0);       \n"
"                              \n"
"	// ---- find(row,col)	   \n"
"	// This code was used to compute (row,col) in the case when n*(n+1)/2 workitems were created, that is,\n"
"	// a workitem per cell in the lower triangular matrix.\n"
"	// It was replaced by the version that uses n*n workitems because it was causing, for some special\n"
"	// cases, kernel timeout. It performed better for the tiled version but, still, was too unreliable.\n"
"	//size = 1;   \n"
"	//diag = 0;    \n"
"	//row = 0;     \n"
"	//while(i > diag) {  \n"
"	//	row++;           \n"
"	//	size++;          \n"
"	//	diag += size;     \n"
"	//}                   \n"
"	//col = i - (diag-size+1);   \n"
"	// ----- end find(row,col)   \n"
"	                              \n"
"	row = i / mat_dim;            \n"
"	col = i % mat_dim;            \n"
"	if (col > row) return;        \n"
"	                               \n"
"	// (row,col) computed.         \n"
"	idx_col = blockcol_idx + col;   \n"
"	idx_row = blockcol_idx + row;   \n"
"	                                \n"
"	sum = 0.0;                      \n"
"	for(i=0; i < cbs; i++) {		\n"	
"		sum += matrix[idx_col]*matrix[idx_row];  \n"
"		idx_col += lda;                          \n"
"		idx_row += lda;                          \n"
"	}	                                         \n"
"	matrix[mat_idx+ lda*col+row] -= sum;         \n"
 "                                               \n"
"}                                               \n"
;

const char* STRING_LTRI_LBYM = 
"                                              \n"
"#pragma OPENCL EXTENSION cl_khr_fp64: enable  \n"
//"                                              \n"
//"// used by Lower triangular inverse blocked version\n"
//"// The result, MT = LxM, is located at the other side of the diagonal,\n"
//"// in the position corresponding to the 90-degree anti-clockwise rotation of M.\n"
//"                                 \n"
//"// The kernel assumes that there's a workitem per M element, with workitems group by rows\n"
//"// into workgroups. Thus, workgroup size = n.\n"
//"                                              \n"
"__kernel void btocl_ltri_LbyM(__global double* matrix, double alpha,\n" 
"			int L_idx, int M_idx, int MT_idx,\n"
"			int m, int n, int lda) \n"
"{                                 \n"
"	// Consider using local memory to store row  \n"
"                                                \n"
"	int colM, rowM;                              \n"
"	int l_worker_idx, m_worker_idx,i;            \n"
"	double v;                                    \n"
"	                                             \n"
"	colM = get_local_id(0);                      \n"
"	rowM = get_group_id(0);                      \n"
"	                                             \n"
"	v = 0.0;                                     \n"
"	l_worker_idx = L_idx + rowM;                 \n"
"	m_worker_idx = M_idx + lda*colM;             \n"
"	for(i=0; i <= rowM; i++) {                   \n"
"		v += matrix[l_worker_idx] * matrix[m_worker_idx];\n"
"		l_worker_idx += lda;      \n"
"		m_worker_idx++;            \n"
"	}                              \n"
"		                            \n"
"	// Using transpose position - better considering just the rotation?\n"
"	matrix[MT_idx + rowM*lda - n + 1 + colM] = v*alpha;   // transpose\n"
"		  \n"
"}\n"
;

const char* STRING_LTRI_MBYL =
"                                            \n"
"#pragma OPENCL EXTENSION cl_khr_fp64: enable \n"
"                                                \n"
// used by Lower triangular inverse blocked version
// M = MxL. MT is located at the other side of the diagonal,
// in the position corresponding to the 90-degree anti-clockwise rotation of M.

// The kernel assumes that there's a workitem per M element, with workitems group by rows
// into workgroups. Thus, workgroup size = n.
"                             \n"
"__kernel void btocl_ltri_MbyL(__global double* matrix, double alpha, \n" 
"			int MT_idx, int L_idx, int M_idx, \n"
"			int m, int n, int lda \n"
"			)      \n"
"{                 \n"
"                  \n"
"// Consider using local memory to store row \n"
"                              \n"
"	int colM, rowM;             \n"
"	int l_worker_idx, m_worker_idx, i;   \n"
"	double v;    \n"
"	               \n"
"	colM = get_local_id(0);  \n"
"	rowM = get_group_id(0);   \n"
"	                           \n"
"	v = 0.0;                    \n"
"	l_worker_idx = L_idx + (n-1) +lda*colM; \n"
"	m_worker_idx = MT_idx + lda*rowM;   // using transpose \n"
"	for(i=colM; i < n; i++) {    \n"
"		v += matrix[l_worker_idx] * matrix[m_worker_idx];   \n"
"		//v = fma(matrix[l_worker_idx], matrix[m_worker_idx], v);  \n"
"		l_worker_idx--;      \n"
"		m_worker_idx--;      \n"
"	}                        \n"
"	                         \n"
"	// Using M transpose position \n"
"	matrix[M_idx + colM*lda + rowM] = alpha*v; \n"
"	 \n"
"}   \n"
;

const char* STRING_LTRI_LTBYL_B0 = 
"                             \n"
"#pragma OPENCL EXTENSION cl_khr_fp64: enable \n"
"                                             \n"
"__kernel void btocl_ltri_LTbyL_b0(__global double* matrix, __global double* diag, \n"
"									int mat_dim, int lda, int bsize,int is_first) \n"
"{  \n"
"    \n"
"	double sum,sq; \n"
"	int row, col, i, length; \n"
"	int idx_col, idx_row;    \n"
"	int trans_idx;           \n"
"	__global double *prow;    \n"
"	__global double *pcol;    \n"
"	                          \n"
"	i = get_global_id(0);     \n"
"	                           \n"
"	sq = (sqrt(1.0+8.0*i)-1)/2.0;\n"
"	row = convert_int(sq);\n"
"	col = (row*(row+1)) >> 1;\n"
"	col = i - col;\n"
"	                         \n"
"	length = bsize;          \n"
"	if (length > (mat_dim-row))\n"
"		length = mat_dim-row;\n"
"	if (length > (mat_dim-col))\n"
"		length = mat_dim-col;\n"
"		                       \n"
"	trans_idx = row*lda + col;  // swapped row,col -> col,row\n"
"		                        \n"
"	idx_col = lda*col + mat_dim - length;\n"
"	idx_row = lda*row + mat_dim - length;\n"
"	                                \n"
"	// Compute dot product           \n"
"	sum = 0.0;\n"
"	            \n"
"	prow = matrix + idx_row;\n"
"	pcol = matrix + idx_col;\n"
"	for(i=0; i < length; i++) {\n"						
"		sum += (*prow)*(*pcol);\n"
"		prow++; pcol++;\n"
"	}\n"
"		\n"
"	if (row==col) {\n"
"		diag[row] = sum;\n"
"	} else {\n"
"		matrix[trans_idx] = sum;\n"
"	}\n"
"    \n"
"}   \n"
;

const char* STRING_LTRI_LTBYL_B = 
"                                              \n"
"#pragma OPENCL EXTENSION cl_khr_fp64: enable  \n"
"                                                \n"
"__kernel void btocl_ltri_LTbyL_b(__global double* matrix, __global double* diag,  \n"
"									int mat_dim, int lda, int bsize, int is_first)  \n"
"{ \n"
"   \n"
"	double sum,sq; \n"
"	int row, col, i, length; \n"
"	int idx_col, idx_row; \n"
"	int trans_idx; \n"
"	__global double *prow; \n"
"	__global double *pcol;  \n"
"	 \n"
"	i = get_global_id(0); \n"
"	 \n"
"	sq = (sqrt(1.0+8.0*i)-1)/2.0; \n"
"	row = convert_int(sq); \n"
"	col = (row*(row+1)) >> 1; \n"
"	col = i - col; \n"
"	 \n"
"	length = min(bsize,mat_dim - row); \n"
" \n"
"	length = min(length,mat_dim - col); \n"
"	 \n"
"	trans_idx = row*lda + col;  // swapped row,col -> col,row \n"
"		 \n"
"	idx_col = lda*col + mat_dim - length; \n"
"	idx_row = lda*row + mat_dim - length; \n"
"	 \n"
"	// Compute dot product \n"
"	sum = 0.0; \n"
"	 \n"
"	prow = matrix + idx_row; \n"
"	pcol = matrix + idx_col; \n"
"	for(i=0; i < length; i++) {	 \n"
"		sum += (*prow)*(*pcol); \n"
"		prow++; pcol++; \n"
"	} \n"
"		 \n"
"	if (row==col) { \n"
"		diag[row] += sum; \n"
"	} else { \n"
"		matrix[trans_idx] += sum; \n"
"	} \n"
" \n"
"} \n"
;


const char *STRING_WRITEUTOL_DIAG = 
"                                              \n"
"#pragma OPENCL EXTENSION cl_khr_fp64: enable \n"
" \n"
"__kernel void btocl_writeUtoL_diag(__global double* matrix, __global double* diag,  \n"
"				int mat_idx, int mat_dim, int lda) \n"
"{ \n"
"	double v; \n"
"	int row, col, i; \n"
"	int idx_col, idx_row; \n"
"	 \n"
"	i = get_global_id(0); \n"
"	 \n"
"	row = i / mat_dim; \n"
"	col = i % mat_dim; \n"
"	 \n"
"	if (row > col) return; \n"
"	 \n"
"	if (row==col) { \n"
"		v = diag[row]; \n"
"	} else { \n"
"		v = matrix[mat_idx + row + lda*col]; \n"
"	} \n"
" \n"
"	matrix[mat_idx + col + lda*row] = v; \n"
"} \n"
;

#endif // if BTOCL defined

#endif


const char* STRING_KRON_TILES1 =
"                                               \n"
"#pragma OPENCL EXTENSION cl_khr_fp64: enable    \n" 
"  \n"
"__kernel void btocl_kron_tiles1(__global double* vres, __global double* v, double sigma,  \n"
"                          __global double* mat,  int mat_dim,  \n"
"						   // __local double* local_v,   \n"
"						   __local double* local_mat, int LS) {  \n"
"						  \n"   						   
"	int id,col, local_mat_start, mat_idx, local_mat_idx, idx;  \n"
"	// int local_v_idx;  \n"
"	int v_idx, start_tile, i;  \n"
"	double accum, l;  \n"
"	   \n"
"	id = get_global_id(0);  \n"
"	col = id / LS;	  \n"
"	local_mat_idx = get_local_id(0);  \n"
"	local_mat_start = (local_mat_idx / LS) * LS;  \n"
"	v_idx = local_mat_idx % LS;;	  \n"
"	//local_v_idx = local_mat_idx % LS;  \n"
"	mat_idx = col*mat_dim + v_idx;  \n"
"	//v_idx = local_v_idx;  \n"
"	start_tile = 0;  // row where tile starts  \n"
"  \n"
"	if (col >= mat_dim) {  \n"
"		return;  \n"
"	}  \n"
"		  \n"
"	accum = 0.0;  \n"
"	  \n"
"	while(start_tile < mat_dim) {  // Complete tile	  \n"
"		l = (v_idx < mat_dim) ? v[v_idx]: 0.0;  \n"
"		  \n"
"		local_mat[local_mat_idx] =  (v_idx < mat_dim) ? mat[mat_idx]*l: 0.0;  \n"
"							  \n"
"		barrier(CLK_LOCAL_MEM_FENCE);  \n"
"	  \n"
"		if (v_idx == start_tile) {  \n"
"			idx = local_mat_start;  \n"
"			for(i=0; i < LS; i++) {  \n"
"				accum += local_mat[idx++];  \n"
"			}  \n"
"		}  \n"
"	  \n"
"		start_tile += LS;  \n"
"		mat_idx += LS;  \n"
"		v_idx += LS;  \n"
"		  \n"
"	}  \n"
"  \n"
"	if (v_idx == start_tile)  \n"
"		vres[col] = accum*sigma;		  \n"		  
"	  \n"
"}  \n"
;



const char* STRING_KRON_LOG1 =
"                                                 \n"
"#pragma OPENCL EXTENSION cl_khr_fp64: enable  \n"
"  \n"
"__kernel void btocl_kron_log1(__global double* vres, __global double* v, __global double* sigma,  \n"
"                          int sigma_dim, __global double* mat,  int mat_dim,   \n"
"						  __local double* local_accum, int LS) {  \n"
"						    \n"
"	int id, i, j, mat_idx, mat_rowcol, v_idx,local_idx;  \n"
"	double accum;  \n"
"	int number_blocks, missing_cells, local_offset, block_offset;  \n"
"	  \n"
"	id = get_global_id(0);  \n"
"	  \n"
"	mat_rowcol = (id / LS);  // row beginning (symmetric)  \n"
"	local_idx = id % LS;  \n"
"	v_idx = local_idx;  \n"
"	mat_idx = mat_rowcol * mat_dim + local_idx;  \n"
"	  \n"
"	number_blocks = mat_dim / LS;  \n"
"	if ((mat_dim % LS) != 0)  \n"
"		number_blocks++;  \n"
"  \n"
"	for(i = 1; i < number_blocks; i++) {  \n"
"		accum += v[v_idx] * mat[mat_idx];  // product	  \n"
"		mat_idx += LS;  \n"
"		v_idx += LS;		  \n"
"	}  \n"
"	  \n"
"	// Last round - last block  \n"
"	if (v_idx < mat_dim)  \n"
"		accum += v[v_idx] * mat[mat_idx];  // product	  \n"
"	  \n"
"	local_accum[local_idx] = accum;  \n"
"	  \n"
"	// log accum  \n"
"	j = LS / 2;  \n"
"	while (j > 0) {  \n"
"		if (local_idx < j)  \n"
"			local_accum[local_idx] += local_accum[local_idx+j];  \n"
"			j = j / 2;  \n"
"	}	  \n"
"	// result  \n"
"	  \n"
"	if (local_idx == 0)  \n"
"		vres[mat_rowcol] = local_accum[0] * sigma[0];  \n"
"	  \n"
"}  \n"
;





const char* STRING_KRON_ACCUM =
"  \n"
"#pragma OPENCL EXTENSION cl_khr_fp64: enable  \n"
"  \n"
"__kernel void btocl_kron_accum(__global double* vres, __global double* v, __global double* sigma,  \n"
"                          int sigma_dim, __global double* mat,  int mat_dim,   \n"
"						  __local double* local_accum) {  \n"
"						    \n"
"	int id, i, sigma_rowcol, mat_idx, mat_rowcol, idx;  \n"
"	double accum;  \n"
"	  \n"
"	id = get_global_id(0);  \n"
"	  \n"
"	mat_rowcol = (id / sigma_dim);  // row beginning (symmetric)  \n"
"	mat_idx = mat_rowcol * mat_dim;  \n"
"	sigma_rowcol = id % sigma_dim;  \n"
"	idx = mat_dim * sigma_rowcol;  \n"
"	  \n"
"	accum = 0.0;  \n"
"	for(i=0; i < mat_dim; i++) {  \n"
"		accum += v[idx++] * mat[mat_idx++];  \n"
"	}	  \n"
"	  \n"
"	local_accum[sigma_rowcol] = accum;  \n"
"	  \n"
"	barrier(CLK_LOCAL_MEM_FENCE);  \n"
"	  \n"
"	accum = 0.0;  \n"
"	idx = sigma_rowcol * sigma_dim;  \n"
"	for(i=0; i < sigma_dim; i++) {  \n"
"		accum += local_accum[i] * sigma[idx++] ;  \n"
"	}  \n"
"	  \n"
"	vres[mat_dim*sigma_rowcol + mat_rowcol] = accum;  \n"
"	  \n"
"}  \n"
;




