CREATE TABLE proteininfo (GINum varchar(100), RefNum varchar(200), InfoComment varchar(5000), proteinseq varchar(50000) );
INSERT INTO proteininfo VALUES ('52788585', 'YP_087119.1','Note: YLR156W, YLR159W, and YLR161W are identical.; Ylr161wp [Saccharomyces cerevisiae]','MKFQYALAKEQLGSNSRSGVKKLISKHHWLPEYYFSDLSFSVVQQWDSRAIEKTTIISCMRPANQEIYPLRHCETLRSQPCSLFSSLYARSFQSSCTLHVAEPSPGFHMYGCHT');
INSERT INTO proteininfo VALUES ('52788584', 'YP_087118.1','Cell-wall L-asparaginase II, involved in asparagine catabolism; expression is induced during nitrogen starvation; four copies of ASP3 are present in the genome reference strain S288C; Asp3-4p [Saccharomyces cerevisiae]','MRSLNTLLLSLFVAMSSGAPLLKIREEKNSSLPSIKIFGTGGTIASKGSTSATTAGYSVGLTVNDLIEAVPSLAEKANLDYLQVSNVGSNSLNYTHLIPLYHGISEALASDDYAGAVVTHGTDTMEETAFFLDLTINSEKPVCIAGAMRPATATSADGPMNLYQAVSIAASEKSLGRGTMITLNDRIASGFWTTKMNANSLDTFRADEQGYLGYFSNDDVEFYYPPVKPNGWQFFDISNLTDPSEIPEVIILYSYQGLNPELIVKAVKDLGAKGIVLAGSGAGSWTATGSIVNEQLYEEYGIPIVHSRRTADGTVPPDDAPEYAIGSGYLNPQKSRILLQLCLYSGYGMDQIRSVFSGVYGG');
INSERT INTO proteininfo VALUES ('52788583', 'YP_087117.1','Identified by fungal homology and RT-PCR; Ylr159c-ap [Saccharomyces cerevisiae]','MYSCAKKKTTAAPEFRVWSPTTLLGQALTSLTTVDRTGNGAFW');
INSERT INTO proteininfo VALUES ('52788582', 'YP_087116.1','Note: YLR156W, YLR159W, and YLR161W are identical.; Ylr159wp [Saccharomyces cerevisiae]','MKFQYALAKEQLGSNSRSGVKKLISKHHWLPEYYFSDLSFSVVQQWDSRAIEKTTIISCMRPANQEIYPLRHCETLRSQPCSLFSSLYARSFQSSCTLHVAEPSPGFHMYGCHT');
INSERT INTO proteininfo VALUES ('52788581', 'YP_087115.1','Cell-wall L-asparaginase II, involved in asparagine catabolism; expression is induced during nitrogen starvation; four copies of ASP3 are present in the genome reference strain S288C; Asp3-3p [Saccharomyces cerevisiae]','MRSLNTLLLSLFVAMSSGAPLLKIREEKNSSLPSIKIFGTGGTIASKGSTSATTAGYSVGLTVNDLIEAVPSLAEKANLDYLQVSNVGSNSLNYTHLIPLYHGISEALASDDYAGAVVTHGTDTMEETAFFLDLTINSEKPVCIAGAMRPATATSADGPMNLYQAVSIAASEKSLGRGTMITLNDRIASGFWTTKMNANSLDTFRADEQGYLGYFSNDDVEFYYPPVKPNGWQFFDISNLTDPSEIPEVIILYSYQGLNPELIVKAVKDLGAKGIVLAGSGAGSWTATGSIVNEQLYEEYGIPIVHSRRTADGTVPPDDAPEYAIGSGYLNPQKSRILLQLCLYSGYGMDQIRSVFSGVYGG');
INSERT INTO proteininfo VALUES ('52788580', 'YP_087114.1','Identified by fungal homology and RT-PCR; Ylr157c-cp [Saccharomyces cerevisiae]','MYSCAKKKTTAAPEFRVWSPTTLLGQALTSLTTVDRTGNGAFW');
INSERT INTO proteininfo VALUES ('52788579', 'YP_087113.1','Cell-wall L-asparaginase II, involved in asparagine catabolism; expression is induced during nitrogen starvation; four copies of ASP3 are present in the genome reference strain S288C; Asp3-2p [Saccharomyces cerevisiae]','MRSLNTLLLSLFVAMSSGAPLLKIREEKNSSLPSIKIFGTGGTIASKGSTSATTAGYSVGLTVNDLIEAVPSLAEKANLDYLQVSNVGSNSLNYTHLIPLYHGISEALASDDYAGAVVTHGTDTMEETAFFLDLTINSEKPVCIAGAMRPATATSADGPMNLYQAVSIAASEKSLGRGTMITLNDRIASGFWTTKMNANSLDTFRADEQGYLGYFSNDDVEFYYPPVKPNGWQFFDISNLTDPSEIPEVIILYSYQGLNPELIVKAVKDLGAKGIVLAGSGAGSWTATGSIVNEQLYEEYGIPIVHSRRTADGTVPPDDAPEYAIGSGYLNPQKSRILLQLCLYSGYGMDQIRSVFSGVYGG');
INSERT INTO proteininfo VALUES ('52788578', 'YP_087112.1','Identified by fungal homology and RT-PCR; Ylr156c-ap [Saccharomyces cerevisiae]','MYSCAKKKTTAAPEFRVWSPTTLLGQALTSLTTVDRTGNGAFW');
INSERT INTO proteininfo VALUES ('52788577', 'YP_087111.1','YLR156W, YLR159W, and YLR161W are three identical open reading frames encoded near the ribosomal DNA region of chromosome 12.; Ylr156wp [Saccharomyces cerevisiae]','MKFQYALAKEQLGSNSRSGVKKLISKHHWLPEYYFSDLSFSVVQQWDSRAIEKTTIISCMRPANQEIYPLRHCETLRSQPCSLFSSLYARSFQSSCTLHVAEPSPGFHMYGCHT');
INSERT INTO proteininfo VALUES ('52788576', 'YP_087110.1','Cell-wall L-asparaginase II, involved in asparagine catabolism; expression is induced during nitrogen starvation; four copies of ASP3 are present in the genome reference strain S288C; Asp3-1p [Saccharomyces cerevisiae]','MRSLNTLLLSLFVAMSSGAPLLKIREEKNSSLPSIKIFGTGGTIASKGSTSATTAGYSVGLTVNDLIEAVPSLAEKANLDYLQVSNVGSNSLNYTHLIPLYHGISEALASDDYAGAVVTHGTDTMEETAFFLDLTINSEKPVCIAGAMRPATATSADGPMNLYQAVSIAASEKSLGRGTMITLNDRIASGFWTTKMNANSLDTFRADEQGYLGYFSNDDVEFYYPPVKPNGWQFFDISNLTDPSEIPEVIILYSYQGLNPELIVKAVKDLGAKGIVLAGSGAGSWTATGSIVNEQLYEEYGIPIVHSRRTADGTVPPDDAPEYAIGSGYLNPQKSRILLQLCLYSGYGMDQIRSVFSGVYGG');
INSERT INTO proteininfo VALUES ('52788575', 'YP_087109.1','Identified by fungal homology and RT-PCR; Ylr154c-hp [Saccharomyces cerevisiae]','MYSCAKKKTTAAPEFRVWSPTTLLGQALTSLTTVDRTGNGAFW');
INSERT INTO proteininfo VALUES ('52788574', 'YP_087108.1','Metallothionein, binds copper and mediates resistance to high concentrations of copper and cadmium; locus is variably amplified in different strains, with two copies, CUP1-1 and CUP1-2, in the genomic sequence reference strain S288C; Cup1-2p [Saccharomyces cerevisiae]','MFSELINFQNEGHECQCQCGSCKNNEQCQKSCSCPTGCNSDDKCPCGNKSEETKKSCCSGK');
INSERT INTO proteininfo VALUES ('52788573', 'YP_087107.1','Metallothionein, binds copper and mediates resistance to high concentrations of copper and cadmium; locus is variably amplified in different strains, with two copies, CUP1-1 and CUP1-2, in the genomic sequence reference strain S288C; Cup1-1p [Saccharomyces cerevisiae]','MFSELINFQNEGHECQCQCGSCKNNEQCQKSCSCPTGCNSDDKCPCGNKSEETKKSCCSGK');
INSERT INTO proteininfo VALUES ('52788572', 'YP_087106.1','Ygr161w-cp [Saccharomyces cerevisiae]','MSGYFNHLSSNAHFANIQADQGFIGDATGTSSDHGSSGMVDFALQLGELSLEEKILKEFTLFQSKNMDLLQETATACPSTNPSLRQSRIQGW');
INSERT INTO proteininfo VALUES ('52788571', 'YP_087105.1','Ribosomal protein L47 of the large (60S) ribosomal subunit, identical to Rpl41Ap and has similarity to rat L41 ribosomal protein; comprised of only 25 amino acids; rpl41a rpl41b double null mutant is viable; Rpl41bp [Saccharomyces cerevisiae]','MRAKWRKKRTRRLKRKRRKVRARSK');
INSERT INTO proteininfo VALUES ('52788570', 'YP_087104.1','Protein component of the large (60S) ribosomal subunit, identical to Rpl35Ap and has similarity to rat L35 ribosomal protein; Rpl35bp [Saccharomyces cerevisiae]','MAGVKAYELRTKSKEQLASQLVDLKKELAELKVQKLSRPSLPKIKTVRKSIACVLTVINEQQREAVRQLYKGKKYQPKDLRAKKTRALRRALTKFEASQVTEKQRKKQIAFPQRKYAIKA');
INSERT INTO proteininfo VALUES ('52788569', 'YP_087103.1','Ribosomal protein L47 of the large (60S) ribosomal subunit, identical to Rpl41Bp and has similarity to rat L41 ribosomal protein; comprised of only 25 amino acids; rpl41a rpl41b double null mutant is viable; Rpl41ap [Saccharomyces cerevisiae]','MRAKWRKKRTRRLKRKRRKVRARSK');
INSERT INTO proteininfo VALUES ('52788568', 'YP_087102.1','Protein component of the large (60S) ribosomal subunit, identical to Rpl35Bp and has similarity to rat L35 ribosomal protein; Rpl35ap [Saccharomyces cerevisiae]','MAGVKAYELRTKSKEQLASQLVDLKKELAELKVQKLSRPSLPKIKTVRKSIACVLTVINEQQREAVRQLYKGKKYQPKDLRAKKTRALRRALTKFEASQVTEKQRKKQIAFPQRKYAIKA');
INSERT INTO proteininfo VALUES ('52788567', 'YP_087101.1','Ycr095w-ap [Saccharomyces cerevisiae]','MTVLIKLGLRILHVYKGFFRKVILKYFFFSSEHTKVNKKSSMHAFLCKIYKR');
INSERT INTO proteininfo VALUES ('52788566', 'YP_087100.1','transcription factor involved in the regulation of alpha-specific genes; Matalpha1p [Saccharomyces cerevisiae]','MFTSKPAFKIKNKASKSYRNTAVSKKLKEKRLAEHVRPSCFNIIRPLKKDIQIPVPSSRFLNKIQIHRIASGSQNTQFRQFNKTSIKSSKKYLNSFMAFRAYYSQFGSGVKQNVLSSLLAEEWHADKMQHGIWDYFAQQYNFINPGFGFVEWLTNNYAEVRGDGYWEDVFVHLAL');
INSERT INTO proteininfo VALUES ('52788565', 'YP_087099.1','Homeobox-domain containing protein which, in haploid cells, acts with Mcm1p to repress a-specific genes; in diploid cells Alpha2p acts together with A1p to repress transcription of haploid-specific genes; Matalpha2p [Saccharomyces cerevisiae]','MNKIPIKDLLNPQITDEFKSSILDINKKLFSICCNLPKLPESVTTEEEVELRDILGFLSRANKNRKISDEEKKLLQTTSQLTTTITVLLKEMRSIENDRSNYQLTQKNKSADGLVFNVVTQDMINKSTKPYRGHRFTKENVRILESWFAKNIENPYLDTKGLENLMKNTSLSRIQIKNWVSNRRRKEKTITIAPELADLLSGEPLAKKKE');
INSERT INTO proteininfo VALUES ('52788564', 'YP_087098.1','Silenced copy of ALPHA1, encoding a transcriptional coactivator involved in the regulation of mating-type alpha-specific gene expression; Hmlalpha1p [Saccharomyces cerevisiae]','MFTSKPAFKIKNKASKSYRNTAVSKKLKEKRLAEHVRPSCFNIIRPLKKDIQIPVPSSRFLNKIQIHRIASGSQNTQFRQFNKTSIKSSKKYLNSFMAFRAYYSQFGSGVKQNVLSSLLAEEWHADKMQHGIWDYFAQQYNFINPGFGFVEWLTNNYAEVRGDGYWEDVFVHLAL');
INSERT INTO proteininfo VALUES ('52788563', 'YP_087097.1','Silenced copy of ALPHA2, encoding a homeobox-domain containing protein that associates with Mcm1p in haploid cells to repress a-specific gene expression and interacts with A1p in diploid cells to repress haploid-specific gene expression; Hmlalpha2p [Saccharomyces cerevisiae]','MNKIPIKDLLNPQITDEFKSSILDINKKLFSICCNLPKLPESVTTEEEVELRDILGFLSRANKNRKISDEEKKLLQTTSQLTTTITVLLKEMRSIENDRSNYQLTQKNKSADGLVFNVVTQDMINKSTKPYRGHRFTKENVRILESWFAKNIENPYLDTKGLENLMKNTSLSRIQIKNWVSNRRRKEKTITIAPELADLLSGEPLAKKKE');
INSERT INTO proteininfo VALUES ('52788562', 'YP_087096.1','Protein component of the large (60S) ribosomal subunit, nearly identical to Rpl19Bp and has similarity to rat L19 ribosomal protein; rpl19a and rpl19b single null mutations result in slow growth, while the double null mutation is lethal; Rpl19ap [Saccharomyces cerevisiae]','MANLRTQKRLAASVVGVGKRKVWLDPNETSEIAQANSRNAIRKLVKNGTIVKKAVTVHSKSRTRAHAQSKREGRHSGYGKRKGTREARLPSQVVWIRRLRVLRRLLAKYRDAGKIDKHLYHVLYKESKGNAFKHKRALVEHIIQAKADAQREKALNEEAEARRLKNRAARDRRAQRVAEKRDALLKEDA');
INSERT INTO proteininfo VALUES ('52788561', 'YP_087095.1','Protein component of the large (60S) ribosomal subunit, nearly identical to Rpl19Bp and has similarity to rat L19 ribosomal protein; rpl19a and rpl19b single null mutations result in slow growth, while the double null mutation is lethal; Rpl19bp [Saccharomyces cerevisiae]','MANLRTQKRLAASVVGVGKRKVWLDPNETSEIAQANSRNAIRKLVKNGTIVKKAVTVHSKSRTRAHAQSKREGRHSGYGKRKGTREARLPSQVVWIRRLRVLRRLLAKYRDAGKIDKHLYHVLYKESKGNAFKHKRALVEHIIQAKADAQREKALNEEAEARRLKNRAARDRRAQRVAEKRDALLKEDA');
INSERT INTO proteininfo VALUES ('50882584', 'NP_011999.2','Hypothetical ORF; Yhr131cp [Saccharomyces cerevisiae]','MALPIEGKLSMANNRIERLKSPSSSSTCSMDEVLITSSNNSSSICLETMRQLPREGVSGQINIIKETAASSSSHAALFIKQDLYEHIDPLPAYPPSYDLVNPNKEVRFPIFGDTAPCPKSSLPPLYAPAVYELTLISLKLERLSPYEISSNRSWRNFIIEINSTQLNFYHIDESLTKHIRNYSSGETKSEKEDRIHSDLVHRSDQSQHLHHRLFTLPTRSASEFKKADQERISYRVKRDRSRYLTDEALYKSFTLQNARFGIPTDYTKKSFVLRMSCESEQFLLRFSHIDDMIDWSMYLSIGISVSLDLEVREYPDYRIVPRRRRRRRRRRRRRRHTHRSESSMGSFSQRFIRSNSRPDLIQRYSTGSSTNNNTTIRERSNTFTAGLLDHYCTGLSKTPTEALISSAASGESSDNSTLGSTRSLSGCSASRSIASRSLKFKIKNFFRPKNSSRTEKLHRLRSNSSNLNSVIETEEDDEHHESSGGDHPEPGVPVNTTIKVERPMHRNRAISMPQRQSLRRAISEEVVPIKFPNSTVGESVHSPSPIEHLSVDGCEIMLQSQNAVMKEELRSVASNLVANERDEASIRPKPQSSSIYLSGLAPNGESATDLSQSSRSLCLTNRDAEINDDESATETDEDENDGETDEYAGDDTNDDTDDSNIGYAYGSESDYSCLIEERIRNRRRASSTLSCFSNIPYGTDDIKWKPAIKEISRRRYLRDSLKCIKPFLDSNDCLGKVIYIPVSGPTFETSNKIHFSNRQSLQKQKNHFLKGFIVGPTALIELNCKNKNAIVGTTKDAEDHGEDDGDGDDGEDDDDDDDDDDDDDDDEDDDDDDDDDDDDDDDDDDGQITA');
INSERT INTO proteininfo VALUES ('50593504', 'NP_015216.3','Hypothetical ORF; Ypl109cp [Saccharomyces cerevisiae]','MSFLKFAYRNSWRYYSKSTRHFHKIPIRQFIIPTSIAFYLTQNSFPKQNCLIYNDSLKPDPKGDTFEMGLYVSSENELQEKLKSFRSAKITESRNKLIRYLRIFWFGFNDNIVEPVCTILRFLEISAIFLPLLLLYPISWFGHKLKITDTNITETRGSLIWCQLLRKALELAGPSFIKLGQWAGSRTDIFSHALCHELGKLHSNVTAHSLSFTLEKLSQALKVDKIEDAFDEFNRTPIGVGSIAQVYVGELSQKYIDKYDNIQIGKDGNRWCAIKILHPNVRSQIRRDLKIMKFCADAINWIPTMEWLSLPSEVDQFSILMNIQLDLRIEALNLERFNENFKNSIQVKFPKPFLPLSNRDVMFEEHVYGLSMEKFLSTKKQINDVELCKKVSDPFVDAFLQMLILDDFVHADLHPGNVIIRFVKTNKYGTNIISSELESYRITHDLRKKIEEDQDQDFVGKLKSVLTNYTPQICFIDTGIITELNEKNRINFIALFNALARFDGYRAGELMIERSRTPETAIDKEVFAFKVEKLVDKVKQRTFTLGTVSIGDLLDQMLSMVRSHHVRMESDFVSVVVAILLLEGIGRQLDPNLDLFESSLPILREFGFKREAKSLLKDASTLSMLKIWVGLEVRQLMHLSMKQIYDLVRTDQLCPNY');
INSERT INTO proteininfo VALUES ('50593426', 'NP_013017.2','Cytoplasmic protein that, when overexpressed, suppresses the lethality of a rad53 null mutation; potential Cdc28p substrate; Srl3p [Saccharomyces cerevisiae]','MFLKTPNWETVNETPKSRVLTINELISPNLDTESNSLLATPARKYFKTSISEAQDSPTSAPSPDGNEDPTYQYNVQFHFPGPITPTTPRSKNAEMFPSPTPPLVSPTAVIEEENDDSVREFSRTLKSRLNCAMVKLSKEHEQVALIPPPPTEKIRKGSYSNKFAAKHRRCHSLDESKKFLSSLEDSSAHAAFLKAISSKHAKSNRVDNVNVSPLRWSSHRRTQSTQENSLQEVVAIDTLLKMSSSD');
INSERT INTO proteininfo VALUES ('50593425', 'NP_013013.2','Metalloendopeptidase of the mitochondrial inner membrane, involved in turnover of membrane-embedded proteins; member of a family of predicted membrane-bound metallopeptidases in prokaryotes and higher eukaryotes; Oma1p [Saccharomyces cerevisiae]','MLRNIIRFKGFGKGTSGGFLKPVSFRVQLTRCYRYDNGPSYRRFNNGEYSQKSSFKSILLDKSSRKYLALLFGGCSLFYYTHLDKAPVSDRSRFIWVSRPLELTIGNYTYKSIWRQTQQEILPPQHPLSIKIENIFMKIVEAAYKDPSVDNSLLDGIKWEIHVVNDPTASPNAFVLPGGKVFIFSSILPICANDDGIATVLAHEFAHQLARHTAENLSKAPIYSLLGLVLYTVTGAHAINNILLDGFLRMPASRQMETEADYIGLMIMSRACFQPQESIKVWERMANFEKQMNRGGVVNMEFLSTHPASTRRIENMSKWLPKANEIYEQSDCSSMGNYYKSFFSM');
INSERT INTO proteininfo VALUES ('50593217', 'NP_011747.2','Possible role in aging; mitochondrial protein, prohibitin homolog; homolog of mammalian BAP37 and S. cerevisiae Phb1p; Phb2p [Saccharomyces cerevisiae]','MNRSPGEFQRYAKAFQKQLSKVQQTGGRGQVPSPRGAFAGLGGLLLLGGGALFINNALFNVDGGHRAIVYSRIHGVSSRIFNEGTHFIFPWLDTPIIYDVRAKPRNVASLTGTKDLQMVNITCRVLSRPDVVQLPTIYRTLGQDYDERVLPSIVNEVLKAVVAQFNASQLITQREKVSRLIRENLVRRASKFNILLDDVSITYMTFSPEFTNAVEAKQIAQQDAQRAAFVVDKARQEKQGMVVRAQGEAKSAELIGEAIKKSRDYVELKRLDTARDIAKILASSPNRVILDNEALLLNTVVDARIDGRGK');
INSERT INTO proteininfo VALUES ('50593216', 'NP_011319.2','Hypothetical ORF; Ygl196wp [Saccharomyces cerevisiae]','MSDVLSQYKGCSVRDLPTPNFVINEEKFDKNCTTMLNNVEKLSQECGVPIKFRAHVKTHKTAKGTLKQLGHGLPLAKRTTRAILVSTLKEAEELLNYQDRQCSDYIDDITYSLPCCVPEFIPLLSNLSRRVNNFQVFVDNIEHLENLKNFGRPASGKKWSVFIKVDMGTKRAGLAFDSPEFLSLLKKLTSSEIKEVIEPYGFYAHAGHSYSSTSINDTQNLLMEEVKAVNSAAKVLCSVDPQFDPSKLTLSVGATPTSNSLKLDNKSTLVKFITTQLVSTLEIHCGNYCMYDLQQVATGCVQDHELSGFVLGTVLSSYPSRGELLSNTGVMCLTREASSIKGFGICADLEHVLKSESFSREWYVARVSQEHGILRPIRNWNETTPLKLGSKIAVLPQHACITMGQFPYYFVVNSEGIVNDVWLPFQKW');
INSERT INTO proteininfo VALUES ('50593215', 'NP_011304.2','Protein with a role in urmylation and in invasive and pseudohyphal growth; inhibits replication of Brome mosaic virus in S. cerevisiae, which is a model system for studying replication of positive-strand RNA viruses in their natural hosts; Ncs6p [Saccharomyces cerevisiae]','MSFTAPSDPVNKPTKVKVSQLCELCHSRKALIRRPKNLSKLCKQCFCLVFETEIHNTIVANNLFQRGEKVAVGASGGKDSTVLAHMLKLLNDRYDYGIEIVLLSIDEGIIGYRDDSLATVKRNQQQYGLPLEIFSFKDLYDWTMDEIVSVAGIRNSCTYCGVFRRQSLDRGAAKLGISHVVTGHNADDMAETVLMNILRGDVARLEKSTAIITQSSGSPIKRSKPFKYSYQKEIVLYAHYMKLDYFSTECTYAPEAFRGTAREYMKNLEAVRPSCIIDIIQSGENLALKAKKSNAGKRVVKFVDGNRCARCGYLSSNNICKACMLLEGLEKSRAQVAIENDTSADGAALKLRALEKLSF');
INSERT INTO proteininfo VALUES ('50593214', 'NP_011278.2','Mitochondrial Translation Optimization; Strong similarity to E. coli GidA; Mto1p [Saccharomyces cerevisiae]','MLRVTTLASSCTSFPLQVLRRRLTISSLTSFQPTTKTQVVVIGAGHAGCEAAAASSRTGAHTTLITPSLTDIGKCSCNPSIGGVGKGILVKEIDALDGLMGKVTDLAGVQFKMLNRSKGPAVWGPRAQIDRELYKKYMQRELSDKKAHPNLSLLQNKVADLILYDPGCGHKVIKGVVLDDGTQVGADQVIITTGTFLSAEIHIGDKRIAAGRIGEQPTYGISNTLQNEVGFQLGRLKTGTPARLAKESIDFSALEVQKGDALPVPMSFLNETVSVEPTKQLDCFGTHTTPQMHDFLRNNLHQSIHIQDTTIKGPRYCPSIEAKILRFPDRSSHKIWLEPEGFNSDVIYPNGISNSMPEDVQLQMMRLIPGMANVEILQPAYGVEYDYVDPRQLKPSLETKLVDGLFLAGQINGTTGYEEAAAQGIIAGINAGLLSRQEREQLVLKRSEAYIGVLIDDLINNGVIEPYRMFTSRSEFRISVRADNADFRLTPIGAQLGIISPVRLSQYSRDKHLYDETIRALQNFKLSSQKWSSLLQANIAPQAENRSAWEIFRFKDMDLHKLYECIPDLPINLLDIPMHVVTKINIQGKYEPYIVKQNQFVKAFQADENMLLPQDYDYRQLPTLSTECKLLLNRVQPLTIGQARRIQGITAAALFELYRVARKPSQPVM');
INSERT INTO proteininfo VALUES ('50593140', 'NP_010465.2','Hypothetical ORF; Ydr179w-ap [Saccharomyces cerevisiae]','MPTILYNTNSSLITKYRRPNASNQYKGFLSKKGHTRLNSKSSGDIWEKDCSHTKNSGNDVSFESEFEKDSVEYLRDLCFSIYPNSLHQKIRSIEALPDLQVNTFIALIFQNFVKSWYGIKIPTDDSKFLTELYNLVQDLITYLKSSKINYHALLLDYIPCLLSSHLKALNDSSQNNDLVYEQYCKLTLYDSKRYPMLFTEIIQSKMSTKSLLQRSFLDSFLNELVFGHIFNSIAEPYYLLEGLNKICIRIKLNSAGNTRNEVTHGKPKCDPWLFVSNVKHKILQMTRLLAYSTSTEAANMNTAEIQETAFLQRYIFTFFTDDFFKLSMRKPFLFSICRTLQHWISKLNALNRVMYRTFDNIVQTKITSPVTIGNLFSLLRHSLFPNDNMMGPPRVLPVGDAFLEFREECISNLWDVCMTYKLDHILAIKRSDIADLIICISKNRDCNKLLIYRIIDCVIAQLP');
INSERT INTO proteininfo VALUES ('50593139', 'NP_010314.2','Hypothetical ORF; Ydr031wp [Saccharomyces cerevisiae]','MSDILDEIVIEDVVANCPQEFLQYHKCIRDNEENPGKCKDGRMILSTCIREKVPSVKSIMSECSEPMKKYDQCIRDNMGTRTINENCLGFLQDLRKCAELQVKNKNIKPSINGVNLELIKD');
INSERT INTO proteininfo VALUES ('50593118', 'NP_009618.2','Hypothetical ORF; Ybr062cp [Saccharomyces cerevisiae]','MSTYEEEHGIQQNSRDYQEVGGTSQEEQRRQVRSQLQGLFQNFGNTSGEGDAHSDSTLLLRLLSQMLPESLQEEWLQEMDKGKSAGCPDTFAASLPRINKKKLKATDNCSICYTNYLEDEYPLVVELPHCHHKFDLECLSVWLSRSTTCPLCRDNVMGHRIINEIDTTEAELEEDWGMYG');
INSERT INTO proteininfo VALUES ('50593117', 'NP_009487.2','Suppressor of Essential Function; putative transcription factor; Sef1p [Saccharomyces cerevisiae]','MVKDNRDSDQDQDFSSAHMKRQPEQQQLQQHQFPSKKQRISHHDDSHQINHRPVTSCTHCRQHKIKCDASQNFPHPCSRCEKIGLHCEINPQFRPKKGSQLQLLRQDVDEIKSKLDTLLANDSVFVHLLQQIPMGNSLLNKLNLHPTPTPGTIIPNPDSSPSSGSPTSSAAQRDSKVSVQTYLSREPQLLQANQGSNTNKFKANNEASSHMTLRASSLAQDSKGLVATEPNKLPPLLNDSALPNNSKESLPPALQMAFYKNNSAGNTPNGPFSPIQKTYSPHTTSTTVTTTTNQPPFAATSHVATNNNADRTKTPVVATTTTMPLLPSPHANVDEFVLGDISISIEKANRLHHIFVTRYLPYFPIMYSNNATELYSQSQLLFWTVMLTACLSDPEPTMYCKLSSLIKQLAIETCWIRTPRSTHISQALLILCIWPLPNQKVLDDCSYRFVGLAKSLSYQLGLHRGEFISEFTRTQTSMPNAEKWRTRTWLGIFFAELCWASILGLPPTSQTDYLLEKALSCGDEESEEDNNDSIDNNNNDKRNKKDEPHVESKYKLPGSFRRLLSLANFQAKLSHIIGSSTSSPDGLLEPKYRAETLSILGKELDLLAKTLNFQSDDTVNIYFLYVKLTVCCFAFLPETPPTDQIPYVTEAYLTATKIVTLLNNLLETHQLIELPIYIRQAATFSALILFKLQLTPLLPDKYFDSARQSVVTIHRLYRNQLTAWATSVENDISRTASMLEKLNFVLIMHPEVFVEEDGIISRMRSHLTGSLFYDLVWCVHEARRREMDPEYNKQALEKAAKKRKFSSNGIYNGTSSTGGITDRKLYPLPLYNHISRDDFETVTKTTPSGTTVTTLVPTKNALKQAEKLAKTNNGDSDGSIMEINGIPLSMLGETGSVKFQSLFANTSNSNDYNNNRTLLDASNDISIPSNSIYPVASVPASNNNPQSTKVDYYSNGPSVIPDLSMKRSVSTPVNHFPASVPGLRNHPVGNLSNNVTLGIDHPIPREHSNLQNVTMNYNNQFSNANAIGRSQSSMSHSRTPIASKSNNMTDLHSVVSDPGSSKSTAYPPLSLFSKSNDINSNKTNQRFSTGTNTVTSSNFQTIDNENNVKTPGNKLTDFFQQQSAGWIEGNSSNDDFFGWFDMNMEQGF');
INSERT INTO proteininfo VALUES ('50593116', 'NP_009486.2','Putative ubiquitin-specific protease; Ubp13p [Saccharomyces cerevisiae]','MIRRWLTISKSGKKKKAVNDTITEEVEKVDFKPVNHDINDELCYSESSDNPSSSLFVSNLDTKETFLNEDNNLQISSGLDYSSETCNQGSNYSQDGIFYISNAKAINAYGGIITQGPEAPILAMKVSDSMPYGDGSNKVFGYENFGNTCYCNSVLQCLYNLSSLRENILQFPKKSRESDHPRKKEMRGKKPRIFTEASFEKSIAGTNGHLPNPKPQSVDDGKPTPVNSVNSNTAGPSEKKSKFFKSFSAKHVQDNNKKEGSPAILTTGKPSSRPQDAPPLIVETPNEPGAPSRLSFENVTDRPPDVPRKIIVGRVLNYENPSRGSSNSNNLDLKGESNSSLSTPLDKKDTRRSSSSSQISPEHRKKSALIRGPVLNIDHSLNGSDKATLYSSLRDIFECITENTYLTGVVSPSSFVDVLKRENVLFNTTMHQDAHEFFNFLLNELSEYIERENKKIAASDINSDSEPSKSKNFISDLFQGTLTNQIKCLTCDNITSRDEPFLDFPIEVQGDEETDIQEILKSYHQREMLNGSNKFYCDECCGLQEAERLVGLKQLPDTLTLHLKRFKYSEKQNCNIKLFNNIHYPLTLNVCSSINSKVCQKYELAGIVVHMGGGPQHGHYVSLCKHEKFGWLLFDDETVEAVKEETVLEFTGESPNMATAYVLFYKAMYSNAVEKNDRENMAKEQDDNIDNLIKYDDWLRTCNSGQKKKEELPIADDLDTAIDDSFVSNTPIKSSKKKSRMFSFRKS');
INSERT INTO proteininfo VALUES ('50593114', 'NP_009349.2','Oleate-activated transcription factor, acts alone and as a heterodimer with Pip2p; activates genes involved in beta-oxidation of fatty acids and peroxisome organization and biogenesis; Oaf1p [Saccharomyces cerevisiae]','MVENSTQKAPHAGNDDNSSTKPYSEAFFLGFNNPTPGLEAEHSSTSPAPENSETHNRKRNRILFVCQACWKSKTKCDREKPECGRCVKHGLKCVYDVSKQPAPRIPSKDAIISRLEKDMFYWKDKAMKLLTEREVNESGKRSASPINTNNASGDSPDTKKQHKMEPIYEQSGNGDINNGTRNDIEINLYRSHPTMIMSKVMKREVKPLSENYIIIQDCFLKILVTSVFLDTSKNTMIPALTANANITRAQPSVANNLLKLKEMLIRQCQTEDEKNRVNEFTDRILQNTNSNRNLKIGMLLSMLYNSVGYQYLEDHCPQGGEYSDLLRNLINECEAILPSYEIIERYKNHFYEYVYPSLPFIELEIFEESLSQTIFPDPNNPSKVQIRMGSTHLRAKVENLSLLLVILKLSYMSIRFLDHSTADSSFYLSKEIIDKYPIPNDFILLSPRCLASENWCACANENIISCLLYIWSFFAFSPEEGDFFLEHPTDVISSLIMMLSTSIGLHRDPSDFPQLISPSTSDKRTLNHRRILWLSIVTVCSFEASLKGRHSVSPISLMALFLNIKDPDSLTVYMNRVRGDLSDINNHTLLRIHKFTFKRAQLALLLSDLDNLTMTYYGSFHLHSIEFIREKIEIFVEENFPIVPLKSVAQDKSDLDDMNVISEMNILSSENSSSFHNRIMNKLLMLRTSMAVFLHFETLITKDKSIFPFYKKYFMVSCMDALSLINYFNKFFNGEYRHAISSLTSFNVTKFIQLALSSTIFSLLGIILRIGLAIHMLSSEVQKLSGTTDPRIKELNTKVEKFSTLQRDLESALEGIYCSASEHLRFTYFPVFKMLALFDVIVQRMRKGELWHGIFTMIQMEQMHSRIIKTLSITLGVKLDKKDRLLEELMACNHVANFSVEDIDELNRNIKKEIQISSGLKPPVNTIDLTNGEPFGNAVPTFTKTWSSSLDNLEKLSSAAAVGQSLDYNSGLRQGPLAGGGSKEQTPIAGMNNLNNSINATPIVDNSSGSQLPNGFDRGQANNTPFPGYFGGLDLFDYDFLFGNDFA');
INSERT INTO proteininfo VALUES ('50234882', 'NP_009666.2','Hypothetical ORF; Ybr108wp [Saccharomyces cerevisiae]','MGFWENNKDSITSGLKSAGKYGYQGTKYVAKTGYKASKKHYNNSKARRERKSGKKNSSDEEYDSEDEMEYERKPTDIRSLKDPKSFPPPPLKPGQKTYTGQQQQQMPNGQASYAFQGAYQGQPGAGSTEQSQYAQPQYNQYPQQQLQQGVMPQQQQLQQGVVPQQPPIYGEQVPPYGSNSNATSYQSLPQQNQPQNAIPSQVSLNSASQQSTGFVSQNLQYGTQSSNPAPSPSFQNGLQCHQQPQYVSHGSTNLGQSQFPSGQQQQPTTQFGQQVLPSPAQPQQQQQGQPLPPPRGQVILPAPGEPLSNGFGQQQQQQQQQQQPLNQNNALLPQMNVEGVSGMAAVQPVYGQAMSSTTNMQDSNPSYGASPMQGQPPVGGQPPVPVRMQPQPPQPMQQGNIYPIEPSLDSTGSTPHFEVTPFDPDAPAPKPKIDIPTVDVSSLPPPPTHRDRGAVVHQEPAPSGKIQPNTTSSAASLPAKHSRTTTADNERNSGNKENDESTSKSSILGHYDVDANIMPPPKPFRHGLDSVPSEHTTKNAPERAVPILPPRNNVEPPPPPSRGNFERTESVLSTNAANVQEDPISNFLPPPKPFRHTETKQNQNSKASPVEMKGEVLPGHPSEEDRNVEPSLVPQSKPQSQSQFRRAHMETQPIQNFQPPPKPFRRSQSSNSSDSSYTIDGPEANHGRGRGRIAKHHDGDEYNPKSENSTENGRLGDAPNSFIRKRAPTPPAPSRSEKLHEGTITSEVDSSKDANKYEKSIPPVTSSIQAQQSTKKAPPPVVKPKPRNFSLKANEYPKELTREATGQDEVLNSITNELSHIKLRKTNVNLEKLGGSKKVKDSSPVPSDLDEKYVSASGSITPPRPPPSRSSPKKVPPVVPKKNDNLKKKPPVVPKKKPLLKSLEPRPIEMERAYSGDISAADDNLNPFERYKRNVVPQEDDRLHKLK');
INSERT INTO proteininfo VALUES ('46562125', 'NP_014712.2','Component of the retromer coat that retrieves proteins from late endosomes; sorting nexin I homolog; Vps5p [Saccharomyces cerevisiae]','MDYEDNLEAPVWDELNHEGDKTQSLVSNSIESIGQISTNEERKDNELLETTASFADKIDLDSAPEWKDPGLSVAGNPQLEEHDNSKADDLINSLAPEQDPIADLKNSTTQFIATRESGGALFTGNANSPLVFDDTIYDANTSPNTSKSISGRRSGKPRILFDSARAQRNSKRNHSLKAKRTTASDDTIKTPFTDPLKKAEKENEFVEEPLDDRNERRENNEGKFTASVEKNILEQVDRPLYNLPQTGANISSPAEVEENSEKFGKTKIGSKVPPTEKAVAFKVEVKDPVKVGELTSIHVEYTVISESSLLELKYAQVSRRYRDFRWLYRQLQNNHWGKVIPPPPEKQSVGSFKENFIENRRFQMESMLKKICQDPVLQKDKDFLLFLTSDDFSSESKKRAFLTGSGAINDSNDLSEVRISEIQLLGAEDAAEVLKNGGIDAESHKGFMSISFSSLPKYNEADEFFIEKKQKIDELEDNLKKLSKSLEMVDTSRNTLAASTEEFSSMVETLASLNVSEPNSELLNNFADVHKSIKSSLERSSLQETLTMGVMLDDYIRSLASVKAIFNQRSKLGYFLVVIENDMNKKHSQLGKLGQNIHSEKFREMRKEFQTLERRYNLTKKQWQAVGDKIKDEFQGFSTDKIREFRNGMEISLEAAIESQKECIELWETFYQTNL');
INSERT INTO proteininfo VALUES ('46562124', 'NP_014317.2','Required for mismatch repair in mitosis and meiosis, low levels of postmeiotic segregation, and high spore viability, dispensable for homeologous recombination; MutL homolog, similar to Mlh1p, associates with Mlh1p, possibly forming a heterodimer, Pms1p and Msh1p act in concert to bind to a Msh2p-heteroduplex complex containing a G-T mismatch; Pms1p [Saccharomyces cerevisiae]','MTQIHQINDIDVHRITSGQVITDLTTAVKELVDNSIDANANQIEIIFKDYGLESIECSDNGDGIDPSNYEFLALKHYTSKIAKFQDVAKVQTLGFRGEALSSLCGIAKLSVITTTSPPKADKLEYDMVGHITSKTTTSRNKGTTVLVSQLFHNLPVRQKEFSKTFKRQFTKCLTVIQGYAIINAAIKFSVWNITPKGKKNLILSTMRNSSMRKNISSVFGAGGMRGLEEVDLVLDLNPFKNRMLGKYTDDPDFLDLDYKIRVKGYISQNSFGCGRNSKDRQFIYVNKRPVEYSTLLKCCNEVYKTFNNVQFPAVFLNLELPMSLIDVNVTPDKRVILLHNERAVIDIFKTTLSDYYNRQELALPKRMCSQSEQQAQKRLKTEVFDDRSTTHESDNENYHTARSESNQSNHAHFNSTTGVIDKSNGTELTSVMDGNYTNVTDVIGSECEVSVDSSVVLDEGNSSTPTKKLPSIKTDSQNLSDLNLNNFSNPEFQNITSPDKARSLEKVVEEPVYFDIDGEKFQEKAVLSQADGLVFVDNECHEHTNDCCHQERRGSTDTEQDDEADSIYAEIEPVEINVRTPLKNSRKSISKDNYRSLSDGLTHRKFEDEILEYNLSTKNFKEISKNGKQMSSIISKRKSEAQENIIKNKDELEDFEQGEKYLTLTVSKNDFKKMEVVGQFNLGFIIVTRKVDNKYDLFIVDQHASDEKYNFETLQAVTVFKSQKLIIPQPVELSVIDELVVLDNLPVFEKNGFKLKIDEEEEFGSRVKLLSLPTSKQTLFDLGDFNELIHLIKEDGGLRRDNIRCSKIRSMFAMRACRSSIMIGKPLNKKTMTRVVHNLSELDKPWNCPHGRPTMRHLMELRDWSSFSKDYEI');
INSERT INTO proteininfo VALUES ('46562091', 'NP_012625.2','Protein involved in bud-site selection and required for axial budding pattern; localizes with septins to bud neck in mitosis and may constitute an axial landmark for next round of budding; potential Cdc28p substrate; Bud4p [Saccharomyces cerevisiae]','MHDAESTVDSLLKEIDNEMEQTKSNITQNGSEDTPHNWKLPLQEIGDDTMEMLVKHNTRSNATENSRGRSPSKMSTISNESLNLGLLRVNSELEESPAAVHQERIKNSVANGALGHANSPKVLNNLKNMAQDIDKLARDEEKPVKLSSSPLKFTLKSTQPLLSYPESPIHRSSIEIETNYDDEDEEEEDAYTCLTQSPQILHSPSRIPITNAVSINKLNLDFTLNPNESDKSLVSDTSVDSTGRELDTKTIPELPFCMSSTPEMTPVDEKCNLPSKLLNTSNNSHSDSRSANSLCGGFKHFNESSRVLIPAKIIQSLLMRMRLLKTMLCRDLQQNMEHIDEAFDEKKVLDEGCSNEPVTFLGENDTRSIVYSNKGTNANVQEFSQEDSLAHSEPKFKDLNATSDDVWNEDKETDANISTSTKSEESYIADYKVTRQEDWDTKKLHQESEHANEQPAIIPQKDSSEETFTELNNESEFQRNFKDGEEYRIVQHEESLYGQRTKSPEENIINGSEIGVDHGEAAEVNEPLAKTSAEEHDLSSSCEDQSVSEARNKDRIEEKEVETKDENIETEKDESEYHKVEENEEPEHVPLLPPLPRWEEIQFNEPFIDENDTSNDSIDLTRSMKPSDYISIWHIQEEEIKSNSPESIANSQFSQQSSITTASTVDSKKDNGSTSFKFKPRIVSRSRIYNPKSRVSSLNYYDNEDYILSNSEWNALDPMRRNTLISKRIQDNIRTQKGHAPLIRPSIMKLNGEDSGFQNHFLEVEQPQEHENIPLSTHLSEQDITTNVGLDEQKLPTNTQDEAEISIREIESAGDITFNRGDLLSLSFDEELGQDFANFLDALDHDSTSFNHGPDDSSSFQRDSSKKSFNSLWESSYELKPPPSIRKQPIAPDVLQKLLESDTKDDADLEKIREERITEPRTGLGIGMLKTPVKDVSIALAASIKGYEASFSDTDSRPEGMNNSDAITLNMFDDFEEDKMTPSTPVRSISPIKRHVSSPFKVVKAGNKQENNEINIKAEEEIEPMTQQETDGLKQDIPPLLAQTKDNVEAKEETITQLEEPQDVEQEFPDMGTLYLSIKAISTLALYGTKSHRATYAIVFDNGENVVQTPWESLPYDGNIRINKEFELPIDFKGKAETSSASSERDSYKKCVITLKCKYEKPRHELVEIVDKVPVGKSFFGKTKYKFEKKYVQKKPKQDEWDYLFAQDGSFARCEIEINEEFLKNVAFNTSHMHYNMINKWSRIADKIHGSKRLYELPRKAPHKVASLDVEACFLERTSAFEQFPKQFSLVNKIVSKYKLQQNIYKEGYLLQDGGDLKGKIENRFFKLHGSQLSGYHEISRKAKIDINLLKVTKVLRNEDIQADNGGQRNFTDWVLFNECFQLVFDDGERITFNAECSNEEKSDWYNKLQEVVELNVFHQPWVKKYCEKLAEEEKTRTTGHNLKQDFN');
INSERT INTO proteininfo VALUES ('46411187', 'YP_006999.1','Ybr230w-ap [Saccharomyces cerevisiae]','MRNELYQLWCVASAARGVAKSSFVRANSAMCEYVRTSNVLSRWTRDRQWEAAKALSQRVKKEYAAN');
INSERT INTO proteininfo VALUES ('44829555', 'NP_013996.2','protein possibly involved in protein synthesis; Ymr269wp [Saccharomyces cerevisiae]','MDSKEYLISYGWKEGEAFREGGLKRPILVKHKRDKKGLGNAPGGNDGEAWWERLFDGHLKNLDVSTDSNNGSIKFTQNEAVATAVSKSSSPLYRWFVKGEGLKGTITNLGKKEEASFVVSSASSSKGKKRRRRDEDDNKVKRKKLKKDKKTSNDSESKKKKKKKSKKESKKGKKSKHSSDEGDKSKHKKSKKSKKHKKEESSARRDRKEHI');
INSERT INTO proteininfo VALUES ('44829553', 'NP_010168.3','Interacts with RNA Polymerase II; Iwr1p [Saccharomyces cerevisiae]','MVNDYLKLNKGVEKTERKKPSRKYFTGDSAKIASLPSLDYVFDIYHLEKIHDDEVARYNNEKNIGFVKIIEHIDLALDEESDPNEARSDDEDSNDENYYQNDYPEDEDDDRSILFGSEGEDIAALGEEIVIGVNKSRFSSWNDDKIQGSNGYHDVEEEYGDLFNRLGGKSDVLKSINSSNFIDLDGQEGEIEISDNEDDSDEGDDIEYPRNEFFPTDVDDPLAHHRDRIFHQLQKKINRS');
INSERT INTO proteininfo VALUES ('42759863', 'NP_013026.2','Protein of unknown function; green fluorescent protein (GFP)-fusion protein localizes to the cell periphery and bud; Skg1p [Saccharomyces cerevisiae]','MTASTSVAVGCAVGIPVGVGIIIAVCFWFNLQKRYKREEQDDRELERAIYDESGFVSFDNFGPLRDSKDEAALASSELKNPDHTSGSSEGSAHPEEKDGKSRDQEKPLGKKNSKYYVPAYRRKINLLQVRNNNYGNNARQKSVVDLPSINNSSNVSLSSSQRHITKRQISVYDQMVPVISDEGPNFFADPSSDTNTSNDQNKASMIELKHNTRQSSNENLIRNLQNQDFGSYYPRRASSSFLNGNISNASFHTRNSSITSVNKRDALEDVFATPKSAAQSQLPNTFDKDNEGMDADHSVKDSRSAITDKDKDLYKLQNNYDVGNIGEIAEEDQYENEFTNYSQSKREFIESLRPK');
INSERT INTO proteininfo VALUES ('42759862', 'NP_012982.2','tRNA methyltransferase, 5-methylates the uridine residue at position 54 of tRNAs and may also have a role in tRNA stabilization or maturation; previously thought to be an endo-exonuclease; Trm2p [Saccharomyces cerevisiae]','MYEQFEFSFFFFENSDNKVKYKAHLISSIKRWSIITCMRCFWTVQKSIFKARFFACRNFVKKHNYKLISTMTGSTEMVPPTMKHTVDNKRLSSPLTDSGNRRTKKPKLRKYKAKKVETTSPMGVLEFEVNDLLKSQNLSREQVLNDVTSILNDKSSTDGPIVLQYHREVKNVKVLEITSNGNGLALIDNPVETEKKQVVIIPFGLPGDVVNIKVFKTHPYYVESDLLDVVEKSPMRRDDLIRDKYFGKSSGSQLEFLTYDDQLELKRKTIMNAYKFFAPRLVAEKLLPPFDTTVASPLQFGYRTKITPHFDMPKRKQKELSVRPPLGFGQKGRPQWRKDTLDIGGHGSILDIDECVLATEVLNKGLTNERRKFEQEFKNYKKGATILLRENTTILDPSKPTLEQLTEEASRDENGDISYVEVEDKKNNVRLAKTCVTNPRQIVTEYVDGYTFNFSAGEFFQNNNSILPIVTKYVRDNLQAPAKGDDNKTKFLVDAYCGSGLFSICSSKGVDKVIGVEISADSVSFAEKNAKANGVENCRFIVGKAEKLFESIDTPSENTSVILDPPRKGCDELFLKQLAAYNPAKIIYISCNVHSQARDVEYFLKETENGSAHQIESIRGFDFFPQTHHVESVCIMKRI');
INSERT INTO proteininfo VALUES ('42759861', 'NP_012891.2','Similar to S. pombe hypothetical proteins; Ykl033w-ap [Saccharomyces cerevisiae]','MTHPVAVKACLFDMDGLLINTEDIYTETLNETLAEFGKGPLTWDVKIKLQGLPGPEAGKRVIEHYKLPITLDEYDERNVALQSLKWGTCEFLPGALNLLKYLKLKNIPIALCTSSNKTKFRGKTSHLEEGFDLFDTIVTGDDPRIAKGRGKPFPDIWQLGLKELNEKFHTDIKPDECIVFEDGIPGVKSAKAFGAHVIWVPHPEAHAVLGDTEALLAGKGELLSSLEKLEMSKYGL');
INSERT INTO proteininfo VALUES ('42759860', 'NP_012719.2','putative protein/phosphatidylinositol kinase involved in signaling activation of translation initiation, distribution of the actin cytoskeleton, and meiosis; phosphatidylinositol kinase homolg; Tor2p [Saccharomyces cerevisiae]','MNKYINKYTTPPNLLSLRQRAEGKHRTRKKLTHKSHSHDDEMSTTSNTDSNHNGPNDSGRVITGSAGHIGKISFVDSELDTTFSTLNLIFDKLKSDVPQERASGANELSTTLTSLAREVSAEQFQRFSNSLNNKIFELIHGFTSSEKIGGILAVDTLISFYLSTEELPNQTSRLANYLRVLIPSSDIEVMRLAANTLGRLTVPGGTLTSDFVEFEVRTCIDWLTLTADNNSSSSKLEYRRHAALLIIKALADNSPYLLYPYVNSILDNIWVPLRDAKLIIRLDAAVALGKCLTIIQDRDPALGKQWFQRLFQGCTHGLSLNTNDSVHATLLVFRELLSLKAPYLRDKYDDIYKSTMKYKEYKFDVIRREVYAILPLLAAFDPAIFTKKYLDRIMVHYLRYLKNIDMNAANNSDKPFILVSIGDIAFEVGSSISPYMTLILDNIREGLRTKFKVRKQFEKDLFYCIGKLACALGPAFAKHLNKDLLNLMLNCPMSDHMQETLMILNEKIPSLESTVNSRILNLLSISLSGEKFIQSNQYDFNNQFSIEKARKSRNQSFMKKTGESNDDITDAQILIQCFKMLQLIHHQYSLTEFVRLITISYIEHEDSSVRKLAALTSCDLFIKDDICKQTSVHALHSVSEVLSKLLMIAITDPVAEIRLEILQHLGSNFDPQLAQPDNLRLLFMALNDEIFGIQLEAIKIIGRLSSVNPAYVVPSLRKTLLELLTQLKFSNMPKKKEESATLLCTLINSSDEVAKPYIDPILDVILPKCQDASSAVASTALKVLGELSVVGGKEMTRYLKELMPLIINTFQDQSNSFKRDAALTTLGQLAASSGYVVGPLLDYPELLGILINILKTENNPHIRRGTVRLIGILGALDPYKHREIEVTSNSKSSVEQNAPSIDIALLMQGVSPSNDEYYPTVVIHNLMKILNDPSLSIHHTAAIQAIMHIFQNLGLRCVSFLDQIIPGIILVMRSCPPSQLDFYFQQLGSLISIVKQHIRPHVEKIYGVIREFFPIIKLQITIISVIESISKALEGEFKRFVPETLTFFLDILENDQSNKRIVPIRILKSLVTFGPNLEDYSHLIMPIVVRMTEYSAGSLKKISIITLGRLAKNINLSEMSSRIVQALVRILNNGDRELTKATMNTLSLLLLQLGTDFVVFVPVINKALLRNRIQHSVYDQLVNKLLNNECLPTNIIFDKENEVPERKNYEDEMQVTKLPVNQNILKNAWYCSQQKTKEDWQEWIRRLSIQLLKESPSACLRSCSSLVSVYYPLARELFNASFSSCWVELQTSYQEDLIQALCKALSSSENPPEIYQMLLNLVEFMEHDDKPLPIPIHTLGKYAQKCHAFAKALHYKEVEFLEEPKNSTIEALISINNQLHQTDSAIGILKHAQQHNELQLKETWYEKLQRWEDALAAYNEKEAAGEDSVEVMMGKLRSLYALGEWEELSKLASEKWGTAKPEVKKAMAPLAAGAAWGLEQWDEIAQYTSVMKSQSPDKEFYDAILCLHRNNFKKAEVHIFNARDLLVTELSALVNESYNRAYNVVVRAQIIAELEEIIKYKKLPQNSDKRLTMRETWNTRLLGCQKNIDVWQRILRVRSLVIKPKEDAQVRIKFANLCRKSGRMALAKKVLNTLLEETDDPDHPNTAKASPPVVYAQLKYLWATGLQDEALKQLINFTSRMAHDLGLDPNNMIAQSVPQQSKRVPRHVEDYTKLLARCFLKQGEWRVCLQPKWRLSNPDSILGSYLLATHFDNTWYKAWHNWALANFEVISMLTSVSKKKQEGSDASSVTDINEFDNGMIGVNTFDAKEVHYSSNLIHRHVIPAIKGFFHSISLSESSSLQDALRLLTLWFTFGGIPEATQAMHEGFNLIQIGTWLEVLPQLISRIHQPNQIVSRSLLSLLSDLGKAHPQALVYPLMVAIKSESLSRQKAALSIIEKMRIHSPVLVDQAELVSHELIRMAVLWHEQWYEGLDDASRQFFGEHNTEKMFAALEPLYEMLKRGPETLREISFQNSFGRDLNDAYEWLMNYKKSKDVSNLNQAWDIYYNVFRKIGKQLPQLQTLELQHVSPKLLSAHDLELAVPGTRASGGKPIVKISKFEPVFSVISSKQRPRKFCIKGSDGKDYKYVLKGHEDIRQDSLVMQLFGLVNTLLQNDAECFRRHLDIQQYPAIPLSPKSGLLGWVPNSDTFHVLIREHREAKKIPLNIEHWVMLQMAPDYDNLTLLQKVEVFTYALNNTEGQDLYKVLWLKSRSSETWLERRTTYTRSLAVMSMTGYILGLGDRHPSNLMLDRITGKVIHIDFGDCFEAAILREKFPEKVPFRLTRMLTYAMEVSGIEGSFRITCENVMKVLRDNKGSLMAILEAFAFDPLINWGFDLPTKKIEEETGIQLPVMNANELLSNGAITEEEVQRVENEHKNAIRNARAMLVLKRITDKLTGNDIRRFNDLDVPEQVDKLIQQATSVENLCQHYIGWCPFW');
INSERT INTO proteininfo VALUES ('42759859', 'NP_012715.2','Hypothetical ORF; Ykl207wp [Saccharomyces cerevisiae]','MTINQHLQQLLFNRIDKTTSSIQQARAPQMLLDDQLKYWVLLPISIVMVLTGVLKQYIMTLITGSSANEAQPRVKLTEWQYLQWAQLLIGNGGNLSSDAFAAKKEFLVKDLTEERHLAKAKQQDGSQAGEVPNPFNDPSMSNAMMNMAKGNMASFIPQTIIMWWVNHFFAGFILMQLPFPLTAKFKEMLQTGIICQDLDVRWVSSISWYFISVLGLNPVYNLIGLNDQDMGIQAGIGGPQGPQGPPQSQVDKAMHAMANDLTIIQHETCLDNVEQRVLKQYM');
INSERT INTO proteininfo VALUES ('42759857', 'NP_976247.1','Yhr199c-ap [Saccharomyces cerevisiae]','MIPALTPEERQKLRSAILHRMQLELETTEKLIENIKEETLKKLNLLQQPDATSAPQSKELIREVLEQEGRRIE');
INSERT INTO proteininfo VALUES ('42759852', 'NP_009919.3','Protein homologous to the mouse and human Tsg101 tumor susceptibility gene; mutants exhibit a Class E Vps phenotype; Stp22p [Saccharomyces cerevisiae]','MSANGKISVPEAVVNWLFKVIQPIYNDGRTTFHDSLALLDNFHSLRPRTRVFTHSDGTPQLLLSIYGTISTGEDGSSPHSIPVIMWVPSMYPVKPPFISINLENFDMNTISSSLPIQEYIDSNGWIALPILHCWDPAAMNLIMVVQELMSLLHEPPQDQAPSLPPKPNTQLQQEQNTPPLPPKPKSPHLKPPLPPPPPPQPASNALDLMDMDNTDISPTNHHEMLQNLQTVVNELYREDVDYVADKILTRQTVMQESIARFHEIIAIDKNHLRAVEQAIEQTMHSLNAQIDVLTANRAKVQQFSSTSHVDDEDVNSIAVAKTDGLNQLYNLVAQDYALTDTIECLSRMLHRGTIPLDTFVKQGRELARQQFLVRWHIQRITSPLS');
INSERT INTO proteininfo VALUES ('42759851', 'NP_976246.1','Nonessential protein of unknown function; orthologs are present in S. bayanus, S. paradoxus and Ashbya gossypii.; Ycl012cp [Saccharomyces cerevisiae]','MKSLFYLKLLLWVVLLSLCLLMAHRKTKVADKFRALRSRIQLRFNRHIRLNDSFADDLENGLHSRNFDIISENSNDVRGGLDDVSKNEIKQIMENDNVDFDKARLLYMERKFGQNGIAPDGTPIDPKAFTFDSR');
INSERT INTO proteininfo VALUES ('42742310', 'NP_014942.2','bridges the DNA-binding region of GCN4 and TBP; similar to multiprotein bridging factor 1 of Bombyx mori; multiprotein bridging factor; Mbf1p [Saccharomyces cerevisiae]','MSDWDTNTIIGSRARAGGSGPRANVARSQGQINAARRQGLVVSVDKKYGSTNTRGDNEGQRLTKVDRETDIVKPKKLDPNVGRAISRARTDKKMSQKDLATKINEKPTVVNDYEAARAIPNQQVLSKLERALGVKLRGNNIGSPLGAPKKK');
INSERT INTO proteininfo VALUES ('42742308', 'NP_014316.2','Probable transporter, member of the Ca2+-binding subfamily of the mitochondrial carrier family, with two EF-hand motifs; Pet9p and Sal1p have an overlapping function critical for viability; polymorphic in different S. cerevisiae strains; Sal1p [Saccharomyces cerevisiae]','MLLKNCETDKQRDIRYACLFKELDVKGNGQVTLDNLISAFEKNDHPLKGNDEAIKMLFTAMDVNKDSVVDLSDFKKYASNAESQIWNGFQRIDLDHDGKIGINEINRYLSDLDNQSICNNELNHELSNEKMNKFSRFFEWAFPKRKANIALRGQASHKKNTDNDRSKKTTDSDLYVTYDQWRDFLLLVPRKQGSRLHTAYSYFYLFNEDVDLSSEGDVTLINDFIRGFGFFIAGGISGVISRTCTAPFDRLKVFLIARTDLSSILLNSKTDLLAKNPNADINKISSPLAKAVKSLYRQGGIKAFYVGNGLNVIKVFPESSIKFGSFEVTKKIMTKLEGCRDTKDLSKFSTYIAGGLAGMAAQFSVYPIDTLKFRVQCAPLDTKLKGNNLLFQTAKDMFREGGLRLFYRGVTVGIVGIFPYAALDLGTFSALKKWYIAKQAKTLNLPQDQVTLSNLVVLPMGAFSGTVGASVVYPINLLRTRLQAQGTYAHPYVYNGFKDVLLKTLEREGYQGLFKGLVPTLAKVCPAVSISYLCYENLKKFMNLE');
INSERT INTO proteininfo VALUES ('42742307', 'NP_014269.2','Cholinephosphotransferase, required for phosphatidylcholine biosynthesis and for inositol-dependent regulation of EPT1 transcription; Cpt1p [Saccharomyces cerevisiae]','MGFFIPQSSLGNLKLYKYQSDDRSFLSNHVLRPFWRKFATIFPLWMAPNLVTLLGFCFIIFNVLTTLYYDPYFDQESPRWTYFSYAIGLFLYQTFDACDGMHARRTGQQGPLGELFDHCIDSINTTLSMIPVCSMTGMGYTYMTIFSQFAILCSFYLSTWEEYHTHKLYLAEFCGPVEGIIVLCISFIAVGIYGPQTIWHTKVAQFSWQDFVFDVETVHLMYAFCTGALIFNIVTAHTNVVRYYESQSTKSATPSKTAENISKAVNGLLPFFAYFSSIFTLVLIQPSFISLALILSIGFSVAFVVGRMIIAHLTMQPFPMVNFPFLIPTIQLVLYAFMVYVLDYQKGSIVSALVWMGLGLTLAIHGMFINDIIYDITTFLDIYALSIKHPKEI');
INSERT INTO proteininfo VALUES ('42742306', 'NP_014204.2','Hypothetical ORF; Ynl195cp [Saccharomyces cerevisiae]','MLGLGQSAQAYASDDALNMNQAKDKTYSVPGCGRASDLKYPHRDGHSSSHEQRSGILPTECPGPTLNTGAGSIGIPGCGKVTNRVVSDYNKNARSTLANFDSSKMTEARMNSKNVPIGCQDTSDPHFNGPIDQHVPGAGSPQSQPHHIDAWNSVSSRRADNNNQDMMDPQTASSDRYNEKMMREENSGVSASSYTTKVQGYPASIPSFNQETEEKETYAYGVGDRHNVPRNQIMDETNPSANVLNATDHSISHPENKVLHK');
INSERT INTO proteininfo VALUES ('42742305', 'NP_014191.2','Hypothetical ORF; Ynl208wp [Saccharomyces cerevisiae]','MSANEFYSSGQQGQYNQQNNQERTGAPNNGQYGADNGNPNGERGLFSTIVGGSAGAYAGSKVSNNHSKLSGVLGAIGGAFLANKISDERKEHKQQEQYGNSNFGGAPQGGHNNHHRQDNNNNNGGFGGPGGPGGQGFGRQGPQGFGGPGPQEFGGPGGQGFGGPNPQEFGGPGGQGFGGPNPQEFGGQGRQGFNGGSRW');
INSERT INTO proteininfo VALUES ('42742290', 'NP_013550.2','Hypothetical ORF; Ylr445wp [Saccharomyces cerevisiae]','MSDTTEVPRQSSENDQDNNLERTNSLKSPDVTNNIPSLFKLAAEWQINNPQETFQNHILENDVLKKINEITHLIRESYKDLSSQDGMMSKQQQEKMDWDLFCTVPVNIIEQYTKDMDEIYEKMERLAKQQRLWCESAFQIDVERCGDSILNAETWMKKKERHLEYKNIEMERSANEIKETIQRLTDDR');
INSERT INTO proteininfo VALUES ('42742289', 'NP_013493.2','involved in a-factor processing; Ste23p [Saccharomyces cerevisiae]','MGVSLLASSSAFVTKPLLTQLVHLSPISLNFTVRRFKPFTCLSRYYTTNPYNMTSNFKTFNLDFLKPDLDERSYRFIELPNKLKALLIQDPKADKAAASLDVNIGAFEDPKNLPGLAHFCEHLLFMGSEKFPDENEYSSYLSKHGGSSNAYTASQNTNYFFEVNHQHLFGALDRFSGFFSCPLFNKDSTDKEINAVNSENKKNLQNDIWRIYQLDKSLTNTKHPYHKFSTGNIETLGTLPKENGLNVRDELLKFHKNFYSANLMKLCILGREDLDTLSDWTYDLFKDVANNGREVPLYAEPIMQPEHLQKIIQVRPVKDLKKLEISFTVPDMEEHWESKPPRILSHLIGHEGSGSLLAHLKKLGWANELSAGGHTVSKGNAFFAVDIDLTDNGLTHYRDVIVLIFQYIEMLKNSLPQKWIFNELQDISNATFKFKQAGSPSSTVSSLAKCLEKDYIPVSRILAMGLLTKYEPDLLTQYTDALVPENSRVTLISRSLETDSAEKWYGTAYKVVDYPADLIKNMKSPGLNPALTLPRPNEFVSTNFKVDKIDGIKPLDEPVLLLSDDVSKLWYKKDDRFWQPRGYIYLSFKLPHTHASIINSMLSTLYTQLANDALKDVQYDAACADLRISFNKTNQGLAITASGFNEKLIILLTRFLQGVNSFEPKKDRFEILKDKTIRHLKNLLYEVPYSQMSNYYNAIINERSWSTAEKLQVFEKLTFEQLINFIPTIYEGVYFETLIHGNIKHEEALEVDSLIKSLIPNNIHNLQVSNNRLRSYLLPKGKTFRYETALKDSQNVNSCIQHVTQLDVYSEDLSALSGLFAQLIHEPCFDTLRTKEQLGYVVFSSSLNNHGTANIRILIQSEHTTPYLEWRINNFYETFGQVLRDMPEEDFEKHKEALCNSLLQKFKNMAEESARYTAAIYLGDYNFTHRQKKAKLVANITKQQMIDFYENYIMSENASKLILHLKSQVENKELNENELDTAKYPTGQLIEDVGAFKSTLFVAPVRQPMKDFEISAPPKLNNSSESE');
INSERT INTO proteininfo VALUES ('42742288', 'NP_013417.2','Protein involved in shmoo formation and required for bipolar bud site selection,  homologous to Spa2p, localizes to sites of polarized growth; Sph1p [Saccharomyces cerevisiae]','MISSELTNDQIIDLISDYKNFKRIIEASVPEDDRRRNQNRQNRNKDLTKLSNVQFWQLTTDVNDELMKRLTDSGADASLNDLDLKRGKAQSKLSRLKDAKFHKLILDIFTEIERRNLHHLDMGTHNNGLDEGDLNFYLNDTLFESFKINDDFMSVNGIISIEVFRELKTQFTLYFQNTLHRIDPVDTTTTRLPILLETIIKIAKLIGDLLPVLSSVSLQSSLENEIVYLKSALSHAITSTRYFLTYGDLIPRIVAQSSISEVIFAFCNIAQIVKIKSTSRDDISRNEGELSDIEAGMKPLKIIEKVKNEKNGKDISSLGDSGSTAVSFPSSGKPITKKSDMPVVVASPSISIIEKSESSIRESGKVRNNTSGETNLASVSPLKNTKNSSRITSEPSPREGLPLKVVSNSRSPSPQGNTLPLIGKFRQDYQASPPKKVITKPVAETAKPYANIPPAADVLYSPTVTKMRKFREKVQKFAPNSGLGLRISTSEENLNNSDVNSTTHNANINNLVEFVESKSMVVLPMAQGILNDVQASKSKLFKSARSVSRLCQNSIEIIPILESVIDMTTKAMVQKSFKLDLGEHCKEIIERLTDCSQKLSELCTYGCDSTKLGKKRFYQKLADILMEVTKRTRELVECVKMANRQTLSQDLSSFFNYRSVQ');
INSERT INTO proteininfo VALUES ('42742287', 'NP_013306.2','ER localized, heme-binding peroxidase involved in the degradation of heme; does not exhibit heme oxygenase activity despite similarity to heme oxygenases; expression regulated by AFT1; Hmx1p [Saccharomyces cerevisiae]','MEDSSNTIIPSPTDVGALANRINFQTRDAHNKINTFMGIKMAIAMRHGFIYRQGILAYYYVFDAIEQEIDRLLNDPVTEEELQTSTILKQFWLEDFRRSTQIYKDLKLLYSNTFKSTESLNEFLATFQKPPLLQQFINNIHENIHKEPCTILSYCHVLYLALFAGGKLIRSNLYRRLGLFPNFEKLSQKELVKKGTNFFTFSDLGPTEETRLKWEYKKNYELATRTELTEAQKLQIISVAEGIFDWNFNIVAEIGELNRRELMGKFSFKCITYLYEEWMFNKDSATRRALHTVMLLVLSIIAIWVLYFLVKSFLSIV');
INSERT INTO proteininfo VALUES ('42742257', 'NP_012547.2','Protein required for cell viability; Pmh1p [Saccharomyces cerevisiae]','MTGEEWGLTVLSFLVRVGFFLFGIYQDANFKVRYTDIDYFVFHDAAKYVYEGKSPYARDTYRYTPLLSWLLVPNHYFGWFHLGKVIFVIFDLVTGLIIMKLLNQAISRKRALILESIWLLNPMVITISTRGNAESVLCCLIMFTLFFLQKSRYTLAGILYGLSIHFKIYPIIYCIPIAIFIYYNKRNQGPRTQLTSLLNIGLSTLTTLLGCGWAMYKIYGYEFLDQAYLYHLYRTDHRHNFSVWNMLLYLDSANKENGESNLSRYAFVPQLLLVLVTGCLEWWNPTFDNLLRVLFVQTFAFVTYNKVCTSQYFVWYLIFLPFYLSRTHIGWKKGLLMATLWVGTQGIWLSQGYYLEFEGKNVFYPGLFIASVLFFVTNVWLLGQFITDIKIPTQPTVSNKKNN');
INSERT INTO proteininfo VALUES ('42742256', 'NP_012522.2','Phosphate metabolism; transcription is regulated by PHO system; polyphosphate synthetase (putative); Vtc4p [Saccharomyces cerevisiae]','MKFGEHLSKSLIRQYSYYYISYDDLKTELEDNLSKNNGQWTQELETDFLESLEIELDKVYTFCKVKHSEVFRRVKEVQEQVQHTVRLLDSNNPPTQLDFEILEEELSDIIADVHDLAKFSRLNYTGFQKIIKKHDKKTGFILKPVFQVRLDSKPFFKENYDELVVKISQLYDIARTSGRPIKGDSSAGGKQQNFVRQTTKYWVHPDNITELKLIILKHLPVLVFNTNKEFEREDSAITSIYFDNENLDLYYGRLRKDEGAEAHRLRWYGGMSTDTIFVERKTHREDWTGEKSVKARFALKERHVNDFLKGKYTVDQVFAKMRKEGKKPMNEIENLEALASEIQYVMLKKKLRPVVRSFYNRTAFQLPGDARVRISLDTELTMVREDNFDGVDRTHKNWRRTDIGVDWPFKQLDDKDICRFPYAVLEVKLQTQLGQEPPEWVRELVGSHLVEPVPKFSKFIHGVATLLNDKVDSIPFWLPQMDVDIRKPPLPTNIEITRPGRSDNEDNDFDEDDEDDAALVAAMTNAPGNSLDIEESVGYGATSAPTSNTNHVVESANAAYYQRKIRNAENPISKKYYEIVAFFDHYFNGDQISKIPKGTTFDTQIRAPPGKTICVPVRVEPKVYFATERTYLSWLSISILLGGVSTTLLTYGSPTAMIGSIGFFITSLAVLIRTVMVYAKRVVNIRLKRAVDYEDKIGPGMVSVFLILSILFSFFCNLVAK');
INSERT INTO proteininfo VALUES ('42742255', 'NP_012376.2','O-mannosylated heat shock protein that is secreted and covalently attached to the cell wall via beta-1,3-glucan and disulfide bridges; required for cell wall stability; induced by heat shock, oxidative stress, and nitrogen limitation; Hsp150p [Saccharomyces cerevisiae]','MQYKKTLVASALAATTLAAYAPSEPWSTLTPTATYSGGVTDYASTFGIAVQPISTTSSASSAATTASSKAKRAASQIGDGQVQAATTTASVSTKSTAAAVSQIGDGQIQATTKTTAAAVSRDGQIQATTKTTSAKTTAAAVSQISDGQIQATTTTLAPKSTAAAVSQIGDGQVQATTKTTAAAVSQIGDGQVQATTKTTAAAVSQIGDGQVQATTKTTAAAVSQIGDGQVQATTKTTAAAVSQITDGQVQATTKTTQAASQVSDGQVQATTATSASAAATSTDPVDAVSCKTSGTLEMNLKGGILTDGKGRIGSIVANRQFQFDGPPPQAGAIYAAGWSITPDGNLAIGDNDVFYQCLSGTFYNLYDEHIGSQCTPVHLEAIDLIDC');
INSERT INTO proteininfo VALUES ('42742254', 'NP_012375.2','Hypothetical ORF; Yjl160cp [Saccharomyces cerevisiae]','MHYKKAFLASLLSSIALTAYAPPEPWATLTPSSKMDGGTTEYRTSFGLAVIPFTVTESKVKRNVISQINDGQVQVTTQKLPHPVSQIGDGQIQVTTQKVPPVVSHIVSQIGDGQLQITTAKNVVTKSTIAVPSKTVTATATSTATAVSQIHDGQVQVTISSASSSSVLSKSKLEPTKKPNNEKVIKVQACKSSGTLAITLQGGVLIDSSGRIGSIVANRQFQFDGPPPQAGAIYAGGWSITKHGTLAIGDNDVFYQCLSGTFYNLYDQSIGGQCNPVHLQTVGLVDC');
INSERT INTO proteininfo VALUES ('42742253', 'NP_012357.2','Type II membrane protein that binds phosphatidylinositol 3-phosphate, required for the cytoplasm-to-vacuole targeting (Cvt) pathway; Atg27p [Saccharomyces cerevisiae]','MVSKTWICGFISIITVVQALSCEKHDVLKKYQVGKFSSLTSTERDTPPSTTIEKWWINVCEEHNVEPPEECKKNDMLCGLTDVILPGKDAITTQIIDFDKNIGFNVEETESALTLTLKGATWGANSFDAKLEFQCNDNMKQDELTSHTWADKSIQLTLKGPSGCLKSKDDDKKNGDGDNGKDGDSEGKKPAKKAGGTSWFTWLFLYALLFTLIYLMVVSFLNTRGGSFQDFRAEFIQRSTQFLTSLPEFCKEVVSRILGRSTAQRGGYSAV');
INSERT INTO proteininfo VALUES ('42742174', 'NP_116703.2','Hypothetical ORF; Yfr045wp [Saccharomyces cerevisiae]','MTYPFEYLKTGLQLQPKGTAFEIILPQIKSYFVGCSALNVAAFGKTILRFVTFDKLCHSLNNNIDNNDNFQRLTGYNLLIAGTLTGIVESLFIIPFENIKTTLIQSAMIDHKKLEKNQPVVNAKATFHKVATKSTPVARIEKLLPAVKHMYQTRGPAAFVQGTTATIFRQIANTSIQFTAYTAFKRLLQARNDKASSVITGLATSFTLVAMTQPIDVVKTRMMSQNAKTEYKNTLNCMYRIFVQEGMATFWKGSIFRFMKVGISGGLTFTVYEQVSLLLGFSSRS');
INSERT INTO proteininfo VALUES ('42742173', 'NP_116696.2','Hypothetical ORF; Yfr038wp [Saccharomyces cerevisiae]','MSRCSNAALMTVVEDAVGARVAARTRNMSNGVNYREKEVNDLTADISDSDSDLDSEDNKHGKGDNDTAPIWLQDDVHSDEDIQLDSEDDSDTEAVQAQVVDKLAKDTKSEQKSLDDELSEMDTKTVSLKLKKLNEFVRQSQVYSSIIADTLLHRSNEVANANTKDNSNSDDEEHSSKKRKTKKKSITDFFKKQKKNEDTTTQNGAPDDAAIKQPRLLKNCILKPYQLEGLNWLITLYENGLNGILADEMGLGKTVQSIALLAFIYEMDTKGPFLVTAPLSTLDNWMNEFAKFAPDLPVLKYYGTNGYKERSAKLKNFFKQHGGTGIVITSYEIILRDTDLIMSQNWKFLIVDEGHRLKNINCRLIKELKKINTSNRLLLTGTPLQNNLAELWSLLNFIMPDIFADFEIFNKWFDFDSLNLGSGSNSEALNKLINDELQKNLISNLHTILKPFLLRRLKKVVLANILPPKREYIINCPMTSAQEKFYKAGLNGKLKKTMFKELIKDFFTLNDEYIGHVSNRSIRDFINYKLSGNETSNTDNKINPTLLQMDKLYKKNLQMEISNKKLQNMMMQLRQIIDSTFLFYFPYLHPEDLTLETLLKTSGKLQILQKLIPPLISEGHKVLIYSQFVNMLDLIEDWCDLNSFATFRIDGSVNNETRKDQLEKFNSSKDKHNIFLLSTRAAGLGINLVGADTVVLFDSDWNPQVDLQAMDRCHRIGQESPVIVYRLCCDNTIEHVILTRAANKRNLERMVIQMGKFNNLKKLALNEGSFLKANKAGVNVTNKDLVQELSMLLMSDESNIGFENGGQKENKATEGQLTDKEVEELTNRSLEAYKANRVVDLPHVKLFETTSGL');
INSERT INTO proteininfo VALUES ('42742058', 'NP_010646.2','Component of the NuA4 histone acetyltransferase complex; Vid21p [Saccharomyces cerevisiae]','MSSRPSSAVPNSASLSEDQSSDRSKFPKADDLIDERDRKLTELYCVSRLNQLLELTDENKLRKEIDAFLKKNDIRRGIRFDEASLPKLLHTAATPITKKKLKDVNLINVPNQRLSDSKMSRELPENSENVSVKSESHFVPSHDNSIRENMMDSLRPAEKTGGMWNKRPLESTMGGEEERHEKRQKMQSQSLESSNNSEMASLPISPRPPVPNALAHYTYYENIEYPPADPTEVQPAVKFKDPLIKNIMAKEIDTSDHYNENNVDALETVFLLMNDYIPSKIPQALPLAELKYMSQTLPLINLIPRAHKALTTNIINNALNEARITVVGSRIEELRRLGLWSLRQPKRFIDPWKQHNTHQNILLEEAKWMQADFKEGHKYKVAICTAMAQAIKDYWTYGEICCVKRKTLLPGKENKLSDDGRISEKSGRPSDTSRNDSDISIAGKDDIGIIANVDDITEKESAAANDNDENGKNEAGAKSDFDFADGLLSQEGAHDQIISSIDTKLLLKKPSSSSEVVLIQHEVAASSALIETEESKKELAPPFKLSIFVDELNTFEKTLIQDLPLYNGINEERPKKDDSLPFIPISKSVVSLDDNGFYKLLERQLIDEEPSISQLSKRRGMFYGNRRNHYLRPPAVPSLRYLQNRTPTIWLSEDDQELVKNINTYGYNWELISAHMTHRLTYSYLSNIERRTPWQCFERFVQLNERFNFSDLKGPRAHSAQQWLIEAHKFQQRQNRRISPLGVNTESIQRGHRRLRWASMFEAIRKCMKKRENTPRPNPTQPRKPLDCKNMKVPTPAEMSLLKAQRDEALRRDIQLRRTVKNRLQQRQQQSQQAHSSRAQSPIPSNGKSSSNLARNGQASAPRPNQKQYTEQDIIESYSRKLLEQKPDIGPEMALKAAKNYYRTLREQQQQLKQHQIQQQRQQLQEESSHVQQLQQLQPGSQAPPPKSSPSQSSLSNISNINSAPRIKSPTPQEILQRFQKQ');
INSERT INTO proteininfo VALUES ('42742057', 'NP_010156.2','G1 cyclin, associates with Pho85p cyclin-dependent kinase (Cdk) to contribute to entry into the mitotic cell cycle, essential for cell morphogenesis; localizes to sites of polarized cell growth; Pcl2p [Saccharomyces cerevisiae]','MSNYEALLKFNRKAVSKEMVQYLASTTASIIKIKKTNSMIDIALPAPPLTKFINRLIKHSNVQTPTLMATSVYLAKLRSIIPSNVYGIETTRHRIFLGCLILAAKTLNDSSPLNKHWAEYTDGLLILREVNTIERELLEYFDWDVTISTDDLITCLSPFLKPIKEEQLYKSQRDCRTLKNFSAQEKDIVNKTSISHSRSSSNMSIPSLASTSTLSTLESRRSNLSNYSNRIRTLPELHESNNISDKFSPRTYNIDSKHDNKENRPIPTIKPFNFSKARPVILKTGLNKQIIKEDTKVKKSNWSNYFKS');
INSERT INTO proteininfo VALUES ('41629697', 'NP_878113.2','Protein of unknown function, conserved in Ashbya gossypii; Pcc1p [Saccharomyces cerevisiae]','MTSKREKSLDHTLELKIPFETERQATIATKVLSPDPILKPQDFQVDYSSEKNVMLVQFRSIDDRVLRVGVSSIIDSIKTIVEAMDVLS');
INSERT INTO proteininfo VALUES ('41629695', 'NP_219495.2','Hypothetical ORF identified by homology. See FEBS Letters [2000]487:31-36.; Ydr381c-ap [Saccharomyces cerevisiae]','MSNPFQNIGKNLLYISAAGIASIYVVKTIVKARRDAKFIPKARGNNGEVNEKNYYDNLAQVKPGFPIPKDGGDNIDCSEDHQLVRKSKYEGSGLSAVTRKRGDKLGFLDRRRNE');
INSERT INTO proteininfo VALUES ('41629693', 'NP_011520.2','Splicing factor involved in the positioning of the 3' splice site during the second catalytic step of splicing, recruited to the spliceosome by Slu7p; Prp18p [Saccharomyces cerevisiae]','MDLDLASILKGEISKKKKELANSKGVQPPCTEKFQPHESANIDETPRQVEQESTDEENLSDNQSDDIRTTISKLENRPERIQEAIAQDKTISVIIDPSQIGSTEGKPLLSMKCNLYIHEILSRWKASLEAYHPELFLDTKKALFPLLLQLRRNQLAPDLLISLATVLYHLQQPKEINLAVQSYMKLSIGNVAWPIGVTSVGIHARSAHSKIQGGRNAANIMIDERTRLWITSIKRLITFEEWYTSNHDSLA');
INSERT INTO proteininfo VALUES ('41629692', 'NP_011317.2','Protein that interacts with Rab GTPases; computational analysis of large-scale protein-protein interaction data suggests a possible role in vesicle-mediated transport; Yip4p [Saccharomyces cerevisiae]','MSYGREDTTIEPDFIEPDAPLAASGGVADNIGGTMQNSGSRGTLDETVLQTLKRDVVEINSRLKQVVYPHFPSFFSPSDDGIGAADNDISANCDLWAPLAFIILYSLFVSHARSLFSSLFVSSWFILLVMALHLRLTKPHQRVSLISYISISGYCLFPQVLNALVSQILLPLAYHIGKQNRWIVRVLSLVKLVVMALCLMWSVAAVSWVTKSKTIIEIYPLALCLFGMAWLSTIL');
INSERT INTO proteininfo VALUES ('41629691', 'NP_011314.2','Member of the MCM/P1 family of proteins involved in DNA replication; component of MCM initiator complex involved in DNA replication; Mcm6p [Saccharomyces cerevisiae]','MSSPFPADTPSSNRPSNSSPPPSSIGAGFGSSSGLDSQIGSRLHFPSSSQPHVSNSQTGPFVNDSTQFSSQRLQTDGSATNDMEGNEPARSFKSRALNHVKKVDDVTGEKVREAFEQFLEDFSVQSTDTGEVEKVYRAQIEFMKIYDLNTIYIDYQHLSMRENGALAMAISEQYYRFLPFLQKGLRRVVRKYAPELLNTSDSLKRSEGDEGQADEDEQQDDDMNGSSLPRDSGSSAAPGNGTSAMATRSITTSTSPEQTERVFQISFFNLPTVHRIRDIRSEKIGSLLSISGTVTRTSEVRPELYKASFTCDMCRAIVDNVEQSFKYTEPTFCPNPSCENRAFWTLNVTRSRFLDWQKVRIQENANEIPTGSMPRTLDVILRGDSVERAKPGDRCKFTGVEIVVPDVTQLGLPGVKPSSTLDTRGISKTTEGLNSGVTGLRSLGVRDLTYKISFLACHVISIGSNIGASSPDANSNNRETELQMAANLQANNVYQDNERDQEVFLNSLSSDEINELKEMVKDEHIYDKLVRSIAPAVFGHEAVKKGILLQMLGGVHKSTVEGIKLRGDINICVVGDPSTSKSQFLKYVVGFAPRSVYTSGKASSAAGLTAAVVRDEEGGDYTIEAGALMLADNGICCIDEFDKMDISDQVAIHEAMEQQTISIAKAGIHATLNARTSILAAANPVGGRYNRKLSLRGNLNMTAPIMSRFDLFFVILDDCNEKIDTELASHIVDLHMKRDEAIEPPFSAEQLRRYIKYARTFKPILTKEARSYLVEKYKELRKDDAQGFSRSSYRITVRQLESMIRLSEAIARANCVDEITPSFIAEAYDLLRQSIIRVDVDDVEMDEEFDNIESQSHAASGNNDDNDDGTGSGVITSEPPADIEEGQSEATARPGTSEKKKTTVTYDKYVSMMNMIVRKIAEVDREGAEELTAVDIVDWYLLQKENDLGSLAEYWEERRLAFKVIKRLVKDRILMEIHGTRHNLRDLENEENENNKTVYVIHPNCEVLDQLEPQDSS');
INSERT INTO proteininfo VALUES ('41629689', 'NP_015231.2','membrane component of ER protein translocation apparatus; Sec62p [Saccharomyces cerevisiae]','MSAVGPGSNAGASVNGGSATAIATLLRNHKELKQRQGLFQAKQTDFFRYKRFVRALHSEEYANKSARQPEIYPTIPSNKIEDQLKSREIFIQLIKAQMVIPVKKLHSQECKEHGLKPSKDFPHLIVSNKAQLEADEYFVWNYNPRTYMDYLIVIGVVSIILALVCYPLWPRSMRRGSYYVSLGAFGILAGFFAVAILRLILYVLSLIVYKDVGGFWIFPNLFEDCGVLESFKPLYGFGEKDTYSYKKKLKRMKKKQAKRESNKKKAINEKAEQN');
INSERT INTO proteininfo VALUES ('41629688', 'NP_013695.2','Protein with a possible role in mitochondrial mRNA splicing; suppressor of group II intron-splicing defect; Psp2p [Saccharomyces cerevisiae]','MGTNNTSNNNGTTKKMSLEEFLGNDTLGESVWDEEDINLDAISNTTNIDILKQTKAGEHQRDGHQQHPHGGHGPMNRSRFSNAGPFGGGSMGDFANHHHPLQHQQGPPYIVKFSDLPPRFSNFDIEDLFQAKFTKFIKFKLFWEINKNPSISTLKSGSIFDQNFKRDSKVAFVELYTSRDMDKILNYWTTPLKEIYHITTAPAEFEDFKDYSTKVKLLTDPKDDAGKPFITKTQRSKSNPFGSAKPVDTQSKILDIEEKMENLHVEDTTTLRASLIPSSDSMATTATGSKITILKKQTPTEEESHSATPTPKPLSYSEVVERSVVNETSKKGTPLSKLDSPALELQSKPDKSDEFKGGDEQGFEKGGDDKAQLDVSNDKDKGSETDVDKQFTFKNVEREHSMSRTKYNGNHNNNNGNFRGSNRYRGGPNGSSYKGGHNNRGNRGGYRGGSSYNNNNNNTNDNNNNNNNSSSNNNNGSRYHDRQNNEEGLTSDSSLDASGNKKNDFTNSTSNTQQYSIFKPASGFLGQGNNDSIRNNGRGNYNSSGMNGGSRGRGFGRGRGFGRGAYNNRGSRGGRGSSGNYSNYNNRTTDMPL');
INSERT INTO proteininfo VALUES ('41629687', 'NP_012503.2','Alpha subunit of Type II geranylgeranyltransferase required for vesicular transport between the endoplasmic reticulum and the Golgi; provides a membrane attachment moiety to Rab-like proteins Ypt1p and Sec4p; Bet4p [Saccharomyces cerevisiae]','MHGIKRKQWTKELLRQKRVQDEKKIYDYRSLTENVLNMRDEKIYSIEALKKTSELLEKNPEFNAIWNYRRDIIASLASELEIPFWDKELVFVMMLLKDYPKVYWIWNHRLWVLKHYPTSSPKVWQTELAVVNKLLEQDARNYHGWHYRRIVVGNIESITNKSLDKEEFEYTTIKINNNISNYSAWHQRVQIISRMFQKGEVGNQKEYIRTEISYIINAMFTDAEDQSVWFYIKWFIKNDIVCKTLDEQEYLKMLKDLRENILLINNDEIEFSGKQNIWCLKILLVLEDILEEKEALTERSSEQYLVQLIDADPLRKNRYLHLLEQHK');
INSERT INTO proteininfo VALUES ('41629686', 'NP_012046.2','Flavin-containing monooxygenase, localized to the cytoplasmic face of the ER membrane; catalyzes oxidation of biological thiols to maintain the ER redox buffer ratio for correct folding of disulfide-bonded proteins; Fmo1p [Saccharomyces cerevisiae]','MTVNDKKRLAIIGGGPGGLAAARVFSQSLPNFEIEIFVKDYDIGGVWHYPEQKSDGRVMYDHLETNISKKLMQFSGFPFEENVPLYPSRRNIWEYLKAYYKTFIANKDAISIHFSTEVTYLKKKNSQWEITSKDELRTTKSDFDFVIVASGHYSVPKLPTNIAGLDLWFDNKGAFHSKDFKNCEFAREKVVIVVGNGSSGQDIANQLTTVAKKVYNSIKEPASNQLKAKLIETVQTIDSADWKNRSVTLSDGRVLQNIDYIIFATGYYYSFPFIEPSVRLEVLGEGVTGDKHSSVNLHNLWEHMIYVKDPTLSFILTPQLVIPFPLSELQAAIMVEVFCKSLPITTTFDSNACGTHNFPKGKDLEYYAELQELLNSIPRRVGHFEPVVWDDRLIDLRNSSYTDKEERNVLLAEHAQALKKKKAPYFLPAPHT');
INSERT INTO proteininfo VALUES ('41629685', 'NP_011923.2','RSC complex component; Rsc30p [Saccharomyces cerevisiae]','MMDMQVRKVRKPPACTQCRKRKIGCDRAKPICGNCVKYNKPDCFYPDGPGKMVAVPSASGMSTHGNGQGSNHFSQGNGVNQKNVMIQTQYPIMQTSIEAFNFSFNPSVDTAMQWTKAASYQNNNTNNNTAPRQNSSTVSSNVHGNTIVRSDSPDVPSMDQIREYNTRLQLVNAQSFDYTDNPYSFNVGINQDSAVFDLMTSPFTQEEVLIKEIDFLKNKLLDLQSLQLKSLKEKSNLNADNTTANKINKTGENSKKGKVDGKRAGFDHQTSRTSQSSQKYFTALTITDVQSLVQVKPLKDTPNYLFTKNFIIFRDHYLFKFYNILHDICHINQFKVSPPNNKNHQQYMEVCKVNFPPKAIIIETLNSESLNNLNIEEFLPIFDKTLLLEFVHNSFPNGDTCPSFSTVDLPLSQLTKLGELTVLLLLLNDSMTLFNKQAINNHVSALMNNLRLIRSQITLINLEYYDQETIKFIAITKFYESLYMHDDHKSSLDEDLSCLLSFQIKDFKLFHFLKKMYYSRHSLLGQSSFMVPAAENLSPIPASIDTNDIPLIANDLKLLETQAKLINILQGVPFYLPVNLTKIESLLETLTMGVSNTVDLYFHDNEVRKEWKDTLNFINTIVYTNFFLFVQNESSLSMAVQHSSNNNKTSNSERCAKDLMKIISNMHIFYSITFNFIFPIKSIKSFSSGNNRFHSNGKEFLFANHFIEILQNFIAITFAIFQRCEVILYDEFYKNLSNEEINVQLLLIHDKILEILKKIEIIVSFLRDEMNSNGSFKSIKGFNKVLNLIKYMLRFSKKKQNFARNSDNNNVTDYSQSAKNKNVLLKFPVSELNRIYLKFKEISDFLMEREVVQRSIIIDKDLESDNLGITTANFNDFYDAFYN');
INSERT INTO proteininfo VALUES ('41629684', 'NP_011857.2','Protein involved in recombination; Shu1p [Saccharomyces cerevisiae]','MQFEERLQQLVESDWSLDQSSPNVLVIVLGDTARKYVELGGLKEHVTTNTVAGHVASRERVSVVFLGRVKYLYMYLTRMQAQANGPQYSNVLVYGLWDLTATQDGPQQLRLLSLVLRQCLSLPSKVEFYPEPPSSSVPARLLRFWDHIIR');
INSERT INTO proteininfo VALUES ('41629682', 'NP_219496.2','Hypothetical ORF identified by homology. See FEBS Letters [2000]487:31-36.; Yer074w-ap [Saccharomyces cerevisiae]','MVLFGLGRLFYVILLLINAVAVLSEERFLRRIGLGRSNDETPVFGQDQNTTKSKVVQLIGAVQTLLRIPLIGINILVIVYELLLG');
INSERT INTO proteininfo VALUES ('41629681', 'NP_958835.1','Vacuolar H+ ATPase subunit e of the V0 (membrane) sector, essential for vacuolar acidification; Vma9p [Saccharomyces cerevisiae]','MSSFYTVVGVFIVVSAMSVLFWIMAPKNNQAVWRSTVILTLAMMFLMWAITFLCQLHPLVAPRRSDLRPEFAE');
INSERT INTO proteininfo VALUES ('41629680', 'NP_009828.2','The authentic, non-tagged protein was localized to the mitochondria; Fmp21p [Saccharomyces cerevisiae]','MLCAIKSTGYRYPRTGALNLLRGRPFNMATRKITTERIPGPPKLPREEQEEFERLQRIATSQEAIDQYNAQATGDRTKESLNSPLLTKNDIGSFSPEFSKTIPEFEGDVNPKTGEVGGPKQDPLRHGDYSFNGRVTDF');
INSERT INTO proteininfo VALUES ('41629679', 'NP_116328.2','Hypothetical ORF identified by homology. See FEBS Letters [2000] 487:31-36.; Ybr255c-ap [Saccharomyces cerevisiae]','MGGNVLPIHYDPKTVKQLTKEITVASCIGAAQGALFSIASALLLRRFSSVYRNVRTQVRVFYHCSWISMGAVFRADKQLLKFQTNYYREEQKRREKIMDEAAERGLFLEDESLNSSRSTT');
INSERT INTO proteininfo VALUES ('41629678', 'NP_009715.2','Protein of unknown function; null mutation does not confer any obvious defects in growth, spore germination, viability, or carbohydrate utilization; Ics2p [Saccharomyces cerevisiae]','MGKFEQKERERISTFSFPTTGSQSSTSIKSLGSPLYGRFSSLSSTESQFDSSKQPHEYEKSFYFEESQGEALFNKLKTYSFPGDKDGVKTRRNSSICPRKPNAVSPLRVESNELSSHSHSRSLSHELTKPSGRRKSYHRKSHAISFSRSCKPNFIDGYDSNSSIGVNSRKTSLASSFLDKEYHSSPDTSYTHQMSPKNTIMNTNEQLRRNASGRFGSLKEFAEKNQINIEGKIFAHKVETGDILQPLIDLDIDNK');
INSERT INTO proteininfo VALUES ('41629677', 'NP_878049.2','Protein involved in mRNA export coupled transcription activation; component of the SAGA histone acetylase complex; Sus1p [Saccharomyces cerevisiae]','MTMDTAQLKSQIQQYLVESGNYELISNELKARLLQEGWVDKVKDLTKSEMNINESTNFTQILSTVEPKALEMVSDSTRETVLKQIREFLEEIVDTQ');
INSERT INTO proteininfo VALUES ('41629676', 'NP_009597.2','Fatty acid transporter and very long-chain fatty acyl-CoA synthetase, may form a complex with Faa1p or Faa4p that imports and activates exogenous fatty acids; Fat1p [Saccharomyces cerevisiae]','MSPIQVVVFALSRIFLLLFRLIKLIITPIQKSLGYLFGNYFDELDRKYRYKEDWYIIPYFLKSVFCYIIDVRRHRFQNWYLFIKQVQQNGDHLAISYTRPMAEKGEFQLETFTYIETYNIVLRLSHILHFDYNVQAGDYVAIDCTNKPLFVFLWLSLWNIGAIPAFLNYNTKGTPLVHSLKISNITQVFIDPDASNPIRESEEEIKNALPDVKLNYLEEQDLMHELLNSQSPEFLQQDNVRTPLGLTDFKPSMLIYTSGTTGLPKSAIMSWRKSSVGCQVFGHVLHMTNESTVFTAMPLFHSTAALLGACAILSHGGCLALSHKFSASTFWKQVYLTGATHIQYVGEVCRYLLHTPISKYEKMHKVKVAYGNGLRPDIWQDFRKRFNIEVIGEFYAATEAPFATTTFQKGDFGIGACRNYGTIIQWFLSFQQTLVRMDPNDDSVIYRNSKGFCEVAPVGEPGEMLMRIFFPKKPETSFQGYLGNAKETKSKVVRDVFRRGDAWYRCGDLLKADEYGLWYFLDRMGDTFRWKSENVSTTEVEDQLTASNKEQYAQVLVVGIKVPKYEGRAGFAVIKLTDNSLDITAKTKLLNDSLSRLNLPSYAMPLFVKFVDEIKMTDNHKILKKVYREQKLPKGLDGNDTIFWLKNYKRYEVLTAADWEAIDAQTIKL');
INSERT INTO proteininfo VALUES ('41629675', 'NP_009547.2','Protein of unknown function; null mutant shows a reduced affinity for the alcian blue dye suggesting a decreased net negative charge of the cell surface; Ldb7p [Saccharomyces cerevisiae]','MSGSNMGYYDVLAGLSALEKSSQVVFSATELQQLTQQSHATDKGIEGSENSKAKVSKPKRVAVHGYLGGKVSLADAAQVEYEVGHSLLGSYVPRQQLEALSSVDFSHHFHRTLECKAALETHDVFLAGAGQLSLPFQSHIESPRNSEAKRKRKVIICKRCQSRFIGSHRRSQLREHACVD');
INSERT INTO proteininfo VALUES ('41629674', 'NP_009540.2','Methionyl-tRNA formyltransferase, catalyzes the formylation of initiator Met-tRNA in mitochondria; potential Cdc28p substrate; Fmt1p [Saccharomyces cerevisiae]','MVKMRRITPTRLLFTCRYISNNASPPVQPLNVLFFGSDTFSNFSLQALNELRQNNGSCGIVDNIQVVTRSPKWCGRQKSILKYPPIFDMAEKLQLPRPITCDTKQEMLALSKLTPSRQGNPENDGSGAPFNAIIAVSFGKLIPGDLIRAVPLALNVHPSLLPRHKGSAPIQRALLEGDTYTGVTIQTLHPDRFDHGAIVAQTEPLAIATMLSKGRVNDSTADFNSEGLPRRTAILMDQLGALGAQLLGQTLRERLYLPQNRVQAPTAYKPSYAHRITTEDKRIHWARDSAAELLNKLETLGPLHAFKEATAARKDAQNSVLKRILFHECKVMRDARLDNGSKPGMFKYDDIKDCILVTCRGNLLLCVSRLQFEGFAVERAGQFMARLRKRCGALSEKLVFL');
INSERT INTO proteininfo VALUES ('41629673', 'NP_009461.2','SCS2 homologue; Similar to D. melanogaster inturned protein; Scs22p [Saccharomyces cerevisiae]','MRIVPEKLVFKAPLNKQSTEYIKLENDGEKRVIFKVRTSAPTKYCVRPNVAIIGAHESVNVQIVFLGLPKSTADDEMDQKRDKFLIVTLPIPAAYQNVEDGELLSDWPNLEEQYKDDIVFKKIKIFHSVLPKRKPSGNHDAESARAPSAGNGQSLSSRALLIITVIALLVGWIYY');
INSERT INTO proteininfo VALUES ('41629672', 'NP_009455.2','BaRreN, a gene with sequence similarity to Drosophila barren and Xenopus XCAP-H, and a functional homolog of human BRRN1; involved in chromosome maintenance; similar to Drosophila barren, Xenopus XCAP-H, and human BRRN1; Brn1p [Saccharomyces cerevisiae]','MTTQLRYENNDDDERVEYNLFTNRSTMMANFEEWIKMATDNKINSRNSWNFALIDYFYDLDVLKDGENNINFQKASATLDGCIKIYSSRVDSVTTETGKLLSGLAQRKTNGASNGDDSNGGNGEGLGGDSDEANIEIDPLTGMPISNDPDVNNTRRRVYNRVLETTLVEFETIKMKELDQELIIDPLFKKALVDFDEGGAKSLLLNTLNIDNTARVIFDASIKDTQNVGQGKLQRKEEELIERDSLVDDENEPSQSLISTRNDSTVNDSVISAPSMEDEILSLGMDFIKFDQIAVCEISGSIEQLRNVVEDINQAKDFIENVNNRFDNFLTEEELQAAVPDNAEDDSDGFDMGMQQELCYPDENHDNTSHDEQDDDNVNSTTGSIFEKDLMAYFDENLNRNWRGREHWKVRNFKKANLVNKESDLLEETRTTIGDTTDKNTTDDKSMDTKKKHKQKKVLEIDFFKTDDSFEDKVFASKGRTKIDMPIKNRKNDTHYLLPDDFHFSTDRITRLFIKPAQKMSLFSHRKHTRGDVSSGLFEKSTVSANHSNNDIPTIADEHFWADNYERKEQEEKEKEQSKEVGDVVGGALDNPFEDDMDGVDFNQAFEGTDDNEEASVKLDLQDDEDHKFPIRENKVTYSRVSKKVDVRRLKKNVWRSINNLIQEHDSRKNREQSSNDSETHTEDESTKELKFSDIIQGISKMYSDDTLKDISTSFCFICLLHLANEHGLQITHTENYNDLIVNYEDLATTQAAS');
INSERT INTO proteininfo VALUES ('41629671', 'NP_009446.2','Hypothetical ORF; Ybl104cp [Saccharomyces cerevisiae]','MGLIKKVTHWSYDNLIDYLSVNPTRDEVTHYKVDPENESDESIIKLHTVKDFGSITCLDYSESEIGMIGVGEKNGYLRIFNISGQNSSSPASHAPVGLNANNETSMTNASGGKAAQAENIVGSVSNLKDTQGYPVSETNYDIRVRAKKQRCINSLGINTNGLIAMGLDRNKHDSSLQIWDMNYHDDSHETINPMFSYCTNESIVSLKFLNDTSVLAASTKFLKEIDVRSPNPIYQHPTRLTYDIKLNPFNDWQFSTYGDDGTLAIWDRRKLSDQASLGDLNVASPLLTFEKLVGSGAASRKYMNSCFRWSCVRNNEFATLHRGDTIKRWRLGYYCDSNRDIAADDDNEMNIENLFVSSVHDTNTMYDRVATFDYIPRSNNGTSLICMRQSGTIYRMPISEVCSKAILNNRNSLLLSNFENTEIDEIRVNNEHEKSNLENVKTILKNLSFEDLDVSEDYFPSGHDEPNNEIEYSELSEEENEGSNDVLDSKRGFELFWKPEKLLEKDISVIMRTRASLGYGLDPMNTVEMIDSSKNLQNNAYIRNTWRWIAIAKASVDDGTMVSGDLDLGYEGVIGIWNGINGISNQDRYRQETILSDKQLNKEMEKIIKLRRKNRDRNSPIANAAGSPKYVQRRLCLIISGWDLSRSDYEDKYNIIMKNGHYEKAAAWAVFFGDIPKAVEILGSAKKERLRLIATAIAGYLAYKDLPGNNAWRQQCRKMSSELDDPYLRVIFAFIADNDWWDILYEPAISLRERLGVALRFLNDTDLTTFLDRTSSTVIENGELEGLILTGITPNGIDLLQSYVNKTSDVQSAALISIFGSPRYFRDQRVDEWIQTYRDMLKSWELFSMRARFDVLRSKLSRTKTGVLTADIKPRQIYIQCQNCKQNINTPRTSSPSSAVSTSAGNYKNGEAYRRNNADYKKFNTGSSEAQAADEKPRHKYCCPHCGSSFPRCAICLMPLGTSNLPFVINGTQSRDPMQTEDSQDGANRELVSRKLKLNEWFSFCLSCNHGMHAGHAEEWFDRHNVCPTPGCTCQCNK');
INSERT INTO proteininfo VALUES ('41629669', 'NP_009408.2','Protein involved in bud-site selection; diploid mutants display a random budding pattern instead of the wild-type bipolar pattern; Bud14p [Saccharomyces cerevisiae]','MSNKEEHVDETSASGVKEVSSIAARHDNGYAPSLITSTSGMDSFQSHALLNDPTLIEDYSDIINNRPTSGSKLTLGNEDSESMGGSVVVTPTSNKSSPFNSKLNILSNAAEKGHDVLRNRDDDKELEEENVEKHMHSNSKRDQRHYKENSSELPDSYDYSDSEFEDNLERRLQEIETDSVDSADKDEVHFSVNNTMNPDVDDFSDGLKYAISEDEDEEENYSDDDDFDRKFQDSGFQGEKDDLEEENDDYQPLSPPRELDPDKLYALYAFNGHDSSHCQLGQDEPCILLNDQDAYWWLVKRITDGKIGFAPAEILETFPERLARLNCWKNENMSSQSVASSDSKDDSISSGNKNQSDAESIIPTPALNGYGKGNKSVSFNDVVGYADRFIDDAIEDTSLDSNDDGGEGNGQSYDDDVDNDKETKVTHRDEYTEAKLNFAKFQDDDTSDVVSDVSFSTSLNTPLNVKKVRRQDNKNESEPKTSSSKDREDDYNANRYVGQEKSEPVDSDYDTDLKKVFEAPRMPFANGMAKSDSQNSLSTIGEFSPSSSEWTNESPSTPIVEESSSIPSSRAIRTFTYIMQNRKLRDNKRGKHRGQIQASLGSSGGMPNQTDAEQPKEELEKHHSTPEEEKQSTLSLHSSSEEDFYMDEQRAVSSASINSSLSGSRALSNTNMSDPASKPNSLVQHLYAPVFDRMDVLMKQLDEIIRK');
INSERT INTO proteininfo VALUES ('41629668', 'NP_009399.2','involved in vacuolar protein sorting; required for localization and trafficking of the CPY sorting receptor; Vps8p is a membrane-associated hydrophilic protein which contains a C-terminal cysteine-rich region that conforms to the H2 variant of the RING finger Zn2+ binding motif.; Vps8p [Saccharomyces cerevisiae]','MEQNGLDHDSRSSIDTTINDTQKTFLEFRSYTQLSEKLASSSSYTAPPLNEDGPKGVASAVSQGSESVVSWTTLTHVYSILGAYGGPTCLYPTATYFLMGTSKGCVLIFNYNEHLQTILVPTLSEDPSIHSIRSPVKSIVICSDGTHVAASYETGNICIWNLNVGYRVKPTSEPTNGMTPTPALPAVLHIDDHVNKEITGLDFFGARHTALIVSDRTGKVSLYNGYRRGFWQLVYNSKKILDVNSSKEKLIRSKLSPLISREKISTNLLSVLTTTHFALILLSPHVSLMFQETVEPSVQNSLVVNSSISWTQNCSRVAYSVNNKISVISISSSDFNVQSASHSPEFAESILSIQWIDQLLLGVLTISHQFLVLHPQHDFKILLRLDFLIHDLMIPPNKYFVISRRSFYLLTNYSFKIGKFVSWSDITLRHILKGDYLGALEFIESLLQPYCPLANLLKLDNNTEERTKQLMEPFYNLSLAALRFLIKKDNADYNRVYQLLMVVVRVLQQSSKKLDSIPSLDVFLEQGLEFFELKDNAVYFEVVANIVAQGSVTSISPVLFRSIIDYYAKEENLKVIEDLIIMLNPTTLDVDLAVKLCQKYNLFDLLIYIWNKIFDDYQTPVVDLIYRISNQSEKCVIFNGPQVPPETTIFDYVTYILTGRQYPQNLSISPSDKCSKIQRELSAFIFSGFSIKWPSNSNHKLYICENPEEEPAFPYFHLLLKSNPSRFLAMLNEVFEASLFNDDNDMVASVGEAELVSRQYVIDLLLDAMKDTGNSDNIRVLVAIFIATSISKYPQFIKVSNQALDCVVNTICSSRVQGIYEISQIALESLLPYYHSRTTENFILELKEKNFNKVLFHIYKSENKYASALSLILETKDIEKEYNTDIVSITDYILKKCPPGSLECGKVTEVIETNFDLLLSRIGIEKCVTIFSDFDYNLHQEILEVKNEETQQKYLDKLFSTPNINNKVDKRLRNLHIELNCKYKSKREMILWLNGTVLSNAESLQILDLLNQDSNFEAAAIIHERLESFNLAVRDLLSFIEQCLNEGKTNISTLLESLRRAFDDCNSAGTEKKSCWILLITFLITLYGKYPSHDERKDLCNKLLQEAFLGLVRSKSSSQKDSGGEFWEIMSSVLEHQDVILMKVQDLKQLLLNVFNTYKLERSLSELIQKIIEDSSQDLVQQYRKFLSEGWSIHTDDCEICGKKIWGAGLDPLLFLAWENVQRHQDMISVDLKTPLVIFKCHHGFHQTCLENLAQKPDEYSCLICQTESNPKIV');
INSERT INTO proteininfo VALUES ('41629667', 'NP_009389.2','Transcriptional modulator involved in the regulation of structural genes involved in phospholipid biosynthesis, also participates in regulation of metabolically unrelated genes as well as maintenance of mating efficiency and sporulation; Dep1p [Saccharomyces cerevisiae]','MSQQTPQESEQTTAKEQDLDQESVLSNIDFNTDLNHNLNLSEYCISSDAGTEKMDSDEEKSLANLPELKYAPKLSSLVKQETLTESLKRPHEDEKEAIDEAKKMKVPGENEDESKEEEKSQELEEAIDSKEKSTDARDEQGDEGDNEEENNEEDNENENEHTAPPALVMPSPIEMEEQRMTALKEITDIEYKFAQLRQKLYDNQLVRLQTELQMCLEGSHPELQVYYSKIAAIRDYKLHRAYQRQKYELSCINTETIATRTFIHQDFHKKVTDLRARLLNRTTQTWYDINKERRDMDIVIPDVNYHVPIKLDNKTLSCITGYASAAQLCYPGEPVAEDLACESIEYRYRANPVDKLEVIVDRMRLNNEISDLEGLRKYFHSFPGAPELNPLRDSEINDDFHQWAQCDRHTGPHTTSFCYS');
INSERT INTO proteininfo VALUES ('41629666', 'NP_009345.2','Proposed beta subunit of the heterotrimeric G protein that interacts with the receptor Grp1p, has signaling role in response to nutrients; involved in regulation of pseudohyphal growth through cAMP levels; homolog of Gpb1p; Gpb2p [Saccharomyces cerevisiae]','MEISSSPWNDGGYSPYERNRVAVSPFSSALEGEERIETSRSLGDHCFEPLPYVTNYLSIFALFGKEIFGDKGNVSSRNEYLLKKYYSLKKPFVLRHNGHALKNPDMPLQRNDILQTNFMVDKFLNRTVRSVNFNNFKIISDMQSKSGRGTKSGTNQNQSADAIQNICLPSIPSALPYFQYYRKLLTVNTKEWDILKLHSLWVPKLRKDFKDFSLYGDKNSLKPIDSHYDEDNTMKKNLFFERSPSRQTLDGKGCASKGYDISSGNMIIPSLFSEDKLPALTYHCSVELNGNIYIFGGLMPCYSYEEDAPMLNDFFVDGIKNLPPPLLPQVINNPSMVNNPHLYVASIPSCRFSKPKMGGYIPPPLLCVQGSKLTDRHIFFYGGFEIRTETRGDENGKYHLKKRLYVNNTGYILDIMSFKFTKIDIIVQPSKYNAYPTMSSRFGHLQISIDNPNRRASVHSSSMNEIHKMGSASMKQGSSITSGRLEKAAVLSSLPHNTVHTVIIFGGYRQTGDDRYEAMNDLWKIEIPVIRRGKKGYCKFSETANAILLTPSEKDKSDWPEERAFSAFSVHGTSLMDRSSLDMRLLNNLKNHFVLKPSYISQDRVVSPKPVFPMMVHGTHQDLFNSGSAAQESPKAGASASSASAASFDPDMDDNLENYIINPGRKSSSIPMTAIGRQRLILSQEKPVGKTVVLHGGSNGLNVLDDMWLMDLECETWTPIETFAKADSSEDGDEKLDSVNVGLVGHRMESIGRICVCIGGMVQEDVDQFYSENDDEPPRKRKVDTLPLGGNFLNTIDLSTQFWEEHKITLSKKAADEDRQDSENEDTNSNIVVGVGGTSLQCDKSIILIGGLISRRSNVKEIYLHGTITKSIFPSVNPSA');
INSERT INTO proteininfo VALUES ('37362708', 'NP_015501.2','Second largest subunit of DNA polymerase II (DNA polymerase epsilon), required for normal yeast chromosomal replication; expression peaks at the G1/S phase boundary; potential Cdc28p substrate; Dpb2p [Saccharomyces cerevisiae]','MFGSGNVLPVKIQPPLLRPLAYRVLSRKYGLSIKSDGLSALAEFVGTNIGANWRQGPATIKFLEQFAAVWKQQERGLFIDQSGVKEVIQEMKEREKVEWSHEHPIQHEENILGRTDDDENNSDDEMPIAADSSLQNVSLSSPMRQPTERDEYKQPFKPESSKALDWRDYFKVINASQQQRFSYNPHKMQFIFVPNKKQNGLGGIAGFLPDIEDKVQMFLTRYYLTNDRVMRNENFQNSDMFNPLSSMVSLQNELSNTNRQQQSSSMSITPIKNLLGRDAQNFLLLGLLNKNFKGNWSLEDPSGSVEIDISQTIPTQGHYYVPGCMVLVEGIYYSVGNKFHVTSMTLPPGERREITLETIGNLDLLGIHGISNNNFIARLDKDLKIRLHLLEKELTDHKFVILGANLFLDDLKIMTALSKILQKLNDDPPTLLIWQGSFTSVPVFASMSSRNISSSTQFKNNFDALATLLSRFDNLTENTTMIFIPGPNDLWGSMVSLGASGTLPQDPIPSAFTKKINKVCKNVVWSSNPTRIAYLSQEIVIFRDDLSGRFKRHRLEFPFNESEDVYTENDNMMSKDTDIVPIDELVKEPDQLPQKVQETRKLVKTILDQGHLSPFLDSLRPISWDLDHTLTLCPIPSTMVLCDTTSAQFDLTYNGCKVINPGSFIHNRRARYMEYVPSSKKTIQEEIYI');
INSERT INTO proteininfo VALUES ('37362707', 'NP_015423.2','Hypothetical ORF; Ypr098cp [Saccharomyces cerevisiae]','MCLVKTTAHLLFYSFVFGGTTFYSYVASPIAFKVLEKDQFSALQNKIFPYFFQMQAASPVILALTAPIALTTGPLSSLVVASVSGLTNLFWLLPWTHKVKEQRKNIAKKYTGSELEAKDAILRKEFGKSHGLSLLFNLSNVCGMLAYGVCLSGGLLRKIPK');
INSERT INTO proteininfo VALUES ('37362706', 'NP_015418.2','Hypothetical ORF; Ypr093cp [Saccharomyces cerevisiae]','MEECPICLADDQEGEQFGCLNVCGHKFHLNCIREWHKYSINLKCPICRVESTHLEVGEGQHALSINLKMGFMIKNAIDYVGAETTNERNEDDTGEQDQEIEFLSERLRGTLVMDTIKIIQCSICGDTDVSRLSLYCQDCEAIYHETCLRGLACEVGDRNTWQECTDCRSNALLELRMGAISSQLASYDSRNSMIFAGELRDKHSVKTQQMYEQIRNAKHKIQMHVRRALDRYPLPLLRFKDAYKHVNKQVSRKLYRLSDNKYLPDQYDYDSLARTGVHTELLIYCHDE');
INSERT INTO proteininfo VALUES ('37362705', 'NP_015414.2','Hypothetical ORF; Ypr089wp [Saccharomyces cerevisiae]','MNSVWDDARIEDRTVDKPVGSSHAQEKLALVKSTLFKLDQEDRPECDSWVQLVKLICDEDREEEFTTFKELLREVKNVNDKSVTGVALIHYIIVFDRADYIELLHDNPSGAKLDLNLVDDIVGYTPLMWSFSLQRRNCCLELFNAFDEINFNMTNKAGLTAWDMVPPYSPLSEFLEQNNMFRYRTEVKHEIPQISQPKDTSLLMSNEDSTTKETFDNIDLQVAGLTLSPGANDNMFLDSDEKNMNHSQGAATLIDPTYTEDYHGTFDYDKLSPDQYLEFSDFDIPQILNLLISLPQKEPHMTTYPAGLIYQCIRYADHKIKSKPLVESLINLSLTKILTSVSSNGAAGLVSTEASLQAGDIVLQSYWLSCLSFLYYYLCRDDSFFKRHPSVLQELINTIHSIIIELTSSIHCRLISLIDSTLLAYTTIQDVKQTLYKRDWNFFKKRKQAKLLLKEKNRKQLKEQQKKELHRKSQGQENHEEEEGQQDGNDSDDRASTNDDNNSSVSLFYDKEILRHLYPPSFEEQMKPSPLKIVQIFGALSYVLNLHQTHPIFQQQCLSISVNWFATTLFNKILKDKKKRSLSRAHAIQIRLNLSTLESWIQNNDFCVPKPMLIDDFMWQRFPMTLIRDVGEIDLSDPILRNVATYKPIDENNKDLIYDTSNSLFYYQPFHKIAQIHLEPVFQLLQWLQVATTLDSEESLISTMNLLPRITPVQLLKSMEKYNYELNENKFNSKLKKFLNNKIKDSKMSKADAYLQEHEIPYLVLPTIPEMTDLYSKGPDSHSFQPFLPGSIQDDVYEIHDVNFKQRQNEPQISRTNSGTSDFTGDEDKAQYETEGVGESIDINETVEPESNAFNVGNDDYFKELNIPSSTAQRPAWSNNDDMEQNPW');
INSERT INTO proteininfo VALUES ('37362704', 'NP_015410.2','Protein required for cell viability; Ypr085cp [Saccharomyces cerevisiae]','MRGFSNEIILKRTLTLSDFTLRYHKRGITALQVIKAPSVSNVPVLLSGDNYGYFVMWDLVTKRPITHIEIEGNSHIIAFWWVETTNVLYILSKDSMLRIFELDSSTQLSIDLVRKLSQANKTDHLQWTKIYEMPINTLNFANFIIEAEVKPTKDNKSYRLVCCHTDDSETIDIYQIIEDSTFKLKRPFNNINFPRFLKQQNFLGISKDSKFGIIMRFAKLNDVIFLGYENGFVVGFKITFDEGLQRDIAELVHVSNDHYPNPILDMCVSGDELYSCSTDDFITKYKIPVNLQLETKYLRDDALLIKCPSSLRVSEPSKVHLPLKNIGHIDKVKDDYLVVSSWSGMTIVYNMRTSEVEQTFVKSKNNLVVSDSSMGDLTNGSGSNTESSSKSHNYKVGAMTCLESFDVQSDGLRLGQLRRIKALAKCNWCLIGYEDGTIKLNKI');
INSERT INTO proteininfo VALUES ('37362703', 'NP_015372.2','alpha subunit of yeast mitochondrial phenylalanyl-tRNA synthetase; Msf1p [Saccharomyces cerevisiae]','MFLNRMMKTRTGLYRLYSTLKVPHVEINGIKYKTDPQTTNVTDSIIKLTDRSLHLKESHPVGILRDLIEKKLNSVDNTFKIFNNFKPVVTTMENFDSLGFPKDHPGRSKSDTYYINETHLLRTHTSAHELECFQKIRNDSDNIKSGFLISADVYRRDEIDKTHYPVFHQMEGATIWKRTKADVGVKEPMYIEKIREDIRQVENLLNKENVKITVDDDTIPLKENNPKQEYMSDLEVDLCSQHLKRSIELIVSEVFNKKISSMIKNKANNTPKELKVRWINAYFPWTAPSWEIEVWWQGEWLELCGCGLIRQDVLLRAGYKPSETIGWAFGLGLDRIAMLLFEIPDIRLLWSRDERFSRQFSKGLITSFKPYSKHPGSFRDVAFWLPEDKPDIHQVHENDLMEIIRNIAGDLVESVKLVDSFTHPKTGRKSMCYRINYQSMDRNLTNAEVNTLQDMVCSKLVKEYSVELR');
INSERT INTO proteininfo VALUES ('37362701', 'NP_015177.2','Phosphopantetheine:protein transferase (PPTase), activates mitochondrial acyl carrier protein (Acp1p) by phosphopantetheinylation; Ppt2p [Saccharomyces cerevisiae]','MSFASRNIGRKIAGVGVDIVYLPRFAHILEKYSPFDPCGRSTLNKITRKFMHEKERFHFSNLLIEENCLTPRLHEYIAGVWALKECSLKALCCCVSKHDLPPAQVLYAGMLYKTQTDTGVPQLEFDKMFGKKYPKYQQLSKNYDSLFSTHEFLVSLSHDKDYLIAVTNLVERE');
INSERT INTO proteininfo VALUES ('37362700', 'NP_015114.2','Component of the signal recognition particle (SRP) ribonucleoprotein (RNP) complex that functions in protein targeting to the endoplasmic reticulum (ER) membrane; Srp72p [Saccharomyces cerevisiae]','MAKDNLTNLLSQLNIQLSQDEHSQVEQTCVKLLDSGCENPADVFRRCLVAVIQQDKYQKALHYLKKFKHIDDKYGRKFALEKLYIFYKLNMPDEFNTLYTAIITDDLDTVLKKDIESLRGILHVRAQYCYKNGLYQEAFKIYQHLASHNEKDQDSQIELSCNERVPLSVATELMNRSPLVTPMDESSYDLLFNESFIMASVGKYDKAIELLEKALQGATNEGYQNDINTIKLQLSFVLQMVGKTAQSKEILKGLLQELKADSPFSLICQNNLNAFVDFSKYNTNFNLLLRELNVEKLNTFNLQTFTHEQWSNIQRNVLFLRLFNNVKIHSQESLLSRTFDKYSKLVDNVTLESYKTQAKKLYHHTTKTILSGTDGSTIGILLLTIQLLIIEKEWENAIRIGELFLNESWKSSFEKFNDSQAIVCYILFELYKIKGRNNSKSVLLKKLGSVRVQLSGKIQENIPFWKHVGFELLSMGNAKESKALLREISNFSKGDADVLVDRVVSSDSLDIAQGIDLVRDIDIDKLIQLGVKPLESSAKRSKNTAVSKVQKRKVLELKKKRKIKRLEKFLQGRDTSKLPDPERWLPLRDRSTYRPKKKQQGAKQTQGGAMNKKSEQALDISKKGKPTVNKKPKNKKKGRK');
INSERT INTO proteininfo VALUES ('37362699', 'NP_015053.2','ATP-binding cassette (ABC) transporter family member; Mdl2p [Saccharomyces cerevisiae]','MLNGRLPLLRLGICRNMLSRPRLAKLPSIRFRSLVTPSSSQLIPLSRLCLRSPAVGKSLILQSFRCNSSKTVPETSLPSASPISKGSARSAHAKEQSKTDDYKDIIRLFMLAKRDWKLLLTAILLLTISCSIGMSIPKVIGIVLDTLKTSSGSDFFDLKIPIFSLPLYEFLSFFTVALLIGCAANFGRFILLRILSERVVARLRANVIKKTLHQDAEFFDNHKVGDLISRLGSDAYVVSRSMTQKVSDGVKALICGVVGVGMMCSLSPQLSILLLFFTPPVLFSASVFGKQIRNTSKDLQEATGQLTRVAEEQLSGIKTVQSFVAEGNELSRYNVAIRDIFQVGKTAAFTNAKFFTTTSLLGDLSFLTVLAYGSYLVLQSQLSIGDLTAFMLYTEYTGNAVFGLSTFYSEIMQGAGAASRLFELTDRKPSISPTVGHKYKPDRGVIEFKDVSFSYPTRPSVQIFKNLNFKIAPGSSVCIVGPSGRGKSTIALLLLRYYNPTTGTITIDNQDISKLNCKSLRRHIGIVQQEPVLMSGTIRDNITYGLTYTPTKEEIRSVAKQCFCHNFITKFPNTYDTVIGPHGTLLSGGQKQRIAIARALIKKPTILILDEATSALDVESEGAINYTFGQLMKSKSMTIVSIAHRLSTIRRSENVIVLGHDGSVVEMGKFKELYANPTSALSQLLNEKAAPGPSDQQLQIEKVIEKEDLNESKEHDDQKKDDNDDNDNNHDNDSNNQSPETKDNNSDDIEKSVEHLLKDAAKEANPIKITPQP');
INSERT INTO proteininfo VALUES ('37362697', 'NP_014881.2','Hypothetical ORF; Yor238wp [Saccharomyces cerevisiae]','MDEKVELILVPCHSIWKSSSHPSDNSVNLGQLPEYWHLAPFQYEGNDHLAFIKHGLTAIKLLLQRFDTATVIFSGSQTKKEAGAISEAQSYYFLFEKLIRYVMSNDNIDVPNFDNELRLLLKEVKNLLSSQNVNVDELFYGGSITTEEFSLDSFDNLIYSIYRFEEVNKKFPQKITIIGFAFKMPRFISCHAKAIDYPQSNITYIGIDPKPANYNQTQLSKYYDDLVQMEDKNALSLFSSDWYATKDRLLTKKRSRNPFNRTAPYAQNIFCKENGKRIEGIEDDEEYFETKIKCKMPWSSPRQ');
INSERT INTO proteininfo VALUES ('37362696', 'NP_014768.2','may encode a protein involved in one or more monoxygenase or hydroxylase steps of ubiquinone biosynthesis; Cat5p [Saccharomyces cerevisiae]','MLSRVSVFKPASRGFSVLSSLKITEHTSAKHTEKPEHAPKCQNLSDAQAAFLDRVIRVDQAGELGADYIYAGQYFVLAHRYPHLKPVLKHIWDQEIHHHNTFNNLQLKRRVRPSLLTPLWKAGAFAMGAGTALISPEAAMACTEAVETVIGGHYNGQLRNLANQFNLERTDGTKGPSEEIKSLTSTIQQFRDDELEHLDTAIKHDSYMAVPYTVITEGIKTICRVAIWSAERI');
INSERT INTO proteininfo VALUES ('37362695', 'NP_014746.2','Epsilon subunit of the oligosaccharyltransferase complex of the ER lumen, which catalyzes aspargine-linked glycosylation of newly synthesized proteins; Ost2p [Saccharomyces cerevisiae]','MAKAPKANTPKVTSTSSAVLTDFQETFKTSKRAYFAQIEKYPKLKLIDTFCFFLVLLGVIQCTFIILIRDNFPFNAFLAGFIICVGQFVLLMSLRLQLCNSFPGISKNRAFAEFIVASLILHFVCLHFIN');
INSERT INTO proteininfo VALUES ('37362694', 'NP_014680.2','Mitochondrial protein required for normal abundance of mitochondrial cytochrome c (Cyc1p) and for mitochondrial osmotic stability; may be involved in regulating the activity of cytochrome c heme lyase (Cyc3p); potential Cdc28p substrate; Cyc2p [Saccharomyces cerevisiae]','MLWKNYVLSSSRITRRLHKSPRKSSFSKNFFITGCLLTVGAVSSYLTYRYTSERENKHELSPSYFVKYKISHKRDIDSSHFLLEVTPLFKQKVNIWSLMTAENLWSVEIKQPEVMVVRNYTPLPLKFNPASKEIEILKDGDNADGKLSFYIKKYENGEVARWLHHLPKGHIIEIRGPFIDYEFPHLPNELKRSRDCLYMDNRNERGNNVRENSQFIYQPYDIMMFTAGTGIVTALQLLLTESPFRGTIKLFHTDKNIKQLGPLYPILLRLQASNRVQLKIFETDRQTKQDVLKSIQKSITKPYPYKGLLPFSNVNNKNIMPVLALVCGPESYISSISGRKYDLNQGPVGGLLSKEGWNSDNVYKLS');
INSERT INTO proteininfo VALUES ('37362693', 'NP_014594.2','Hypothetical ORF; Yol048cp [Saccharomyces cerevisiae]','MKAGIELISHSQASHATYANSMTLAEKGPQRLKRQFKEHSSSKESNVSRWLKIFIRQFDIWFPETIPTMKVRYELLRKNFIKEIFNSRAFIYPFLGFYEVLTNPVYWKHILLFAVCYALIFVTIAGLFYVTLVPLLVTWAILLLGPLGVILVHIQWILQTNVLTAFVCRTLVLTHITNQIFDISLVLQDQDEFLNEVKVLPKPQKPHRKIDEPDAVRNFNTIKGSRIFKIPRLLFRMFFKVSNFTSLTLLSLIPIVGPILANQLMAPKRTFTYLQRYFLLKGFSKKQAKDFQYEHYASFICFGMSAGLLELIPFFTIVTISSNTVGAAKWCTSLLKGERKKE');
INSERT INTO proteininfo VALUES ('37362692', 'NP_014545.2','O-methyltransferase, catalyzes two different O-methylation steps in ubiquinone (Coenzyme Q) biosynthesis; Coq3p [Saccharomyces cerevisiae]','MLLRSRFLKVIHVRKQLSACSRFAIQTQTRCKSTDASEDEVKHFQELAPTWWDTDGSQRILHKMNLTRLDFVQRTVRNQVKIQNPEIFVPGFNYKEFLPEYVCDNIQREMQESIETNLDKRPEVSVLDVGCGGGILSESLARLKWVKNVQGIDLTRDCIMVAKEHAKKDPMLEGKINYECKALEDVTGQFDIITCMEMLEHVDMPSEILRHCWSRLNPEKGILFLSTINRDLISWFTTIFMGENVLKIVPKGTHHLSKYINSKEILAWFNDNYSGQFRLLDLKGTMYLPYQGWVEHDCSDVGNYFMAIQRLN');
INSERT INTO proteininfo VALUES ('37362691', 'NP_014538.2','member of sugar transporter superfamily; myo-inositol transporter; Itr2p [Saccharomyces cerevisiae]','MKNSTAASSRWTKSRLSHFFPSYTNSSGMGAASTDQSSTQGEELHHRKHCEEDNDGQKPKKSPVSTSTMQIKSRQDEDEDDGRIVIKPVNDEDDTSVIITFNQSISPFIITLTFVASISGFMFGYDTGYISSALISINRDLDNKVLTYGEKELITAATSLGALITSVGAGTAADVFGRRPCLMFSNLMFLIGAILQITAHKFWQMAAGRLIMGFGVGIGSLISPLFISEIAPKMIRGRLTVINSLWLTGGQLIAYGCGAGLNHVKNGWRILVGLSLIPTVLQFSFFCFLPDTPRYYVMKGDLKRAKMVLKRSYVNTEDEIIDQKVEELSSLNQSIPGKNPITKFWNMVKELHTVPSNFRALIIGCGLQAIQQFTGWNSLMYFSGTIFETVGFKNSSAVSIIVSGTNFVFTLIAFFCIDKIGRRYILLIGLPGMTVALVICAIAFHFLGIKFNGADAVVASDGFSSWGIVIIVFIIVYAAFYALGIGTVPWQQSELFPQNVRGVGTSYATATNWAGSLVIASTFLTMLQNITPTGTFSFFAGVACLSTIFCYFCYPELSGLELEEVQTILKDGFNIKASKALAKKRKQQVAEGAAHHKLKFEPTQEIVES');
INSERT INTO proteininfo VALUES ('37362690', 'NP_014495.2','Subunit of the GINS complex (Sld5p, Psf1p, Psf2p, Psf3p), which binds to DNA replication origins and facilitates assembly of the DNA replication machinery; Psf3p [Saccharomyces cerevisiae]','MGYYDIDDVLADGTEFPCKFQYDIPGLGYLENNPGRPITKNTKLSLPLWLARILAIVGGDEALVDEEPVPFVELLPPDMFSTKVMNAIKTDPVALDLHSINSHFFSLAIKWIMLFSEKELANVVSELLLQRAQELNHHASSLSIDLNADSTGKNSANTNIATSTFLLKLEEMEKEIYKKSHESYKDTKRWMFKK');
INSERT INTO proteininfo VALUES ('37362689', 'NP_014360.2','Protein involved in the synthesis of N-acetylglucosaminyl phosphatidylinositol (GlcNAc-PI), the first intermediate in the synthesis of glycosylphosphatidylinositol (GPI) anchors; homologous to the human PIG-H protein; Gpi15p [Saccharomyces cerevisiae]','MISKEYEFGKTSILNRKKYTLVIDEDKNGNFIRFTVLPVSNRKFKKVKQNGRVEINMGIQYHQIVLILLLNILFYVICLRSRFLEHINRTFEVTIARSFQILIIMGLFALGTIILVRGPSVETVTIFKESGLQLSRVKGMVIFPQQWNRKFFEQVEFISNERIIDVVINEGFCRGFRVIFYLAAIVRKSSTLKLLFPSNLPSIDDQRLIYNISRKYLSKQEKPLSRPKD');
INSERT INTO proteininfo VALUES ('37362688', 'NP_014176.2','Anchor protein involved in autophagy and required for sporulation; interacts with Tub1p and Tub2p and forms a complex with Aut7p; mediates attachment of autophagosomes to microtubules; Atg4p [Saccharomyces cerevisiae]','MQRWLQLWKMDLVQKVSHGVFEGSSEEPAALMNHDYIVLGEVYPERDEESGAEQCEQDCRYRGEAVSDGFLSSLFGREISSYTKEFLLDVQSRVNFTYRTRFVPIARAPDGPSPLSLNLLVRTNPISTIEDYIANPDCFNTDIGWGCMIRTGQSLLGNALQILHLGRDFRVNGNESLERESKFVNWFNDTPEAPFSLHNFVSAGTELSDKRPGEWFGPAATARSIQSLIYGFPECGIDDCIVSVSSGDIYENEVEKVFAENPNSRILFLLGVKLGINAVNESYRESICGILSSTQSVGIAGGRPSSSLYFFGYQGNEFLHFDPHIPQPAVEDSFVESCHTSKFGKLQLSEMDPSMLIGILIKGEKDWQQWKLEVAESAIINVLAKRMDDFDVSCSMDDVESVSSNSMKKDASNNENLGVLEGDYVDIGAIFPHTTNTEDVDEYDCFQDIHCKKQKIVVMGNTHTVNANLTDYEVEGVLVEKETVGIHSPIDEKC');
INSERT INTO proteininfo VALUES ('37362687', 'NP_014143.2','Multifunctional enzyme of the folic acid biosynthesis pathway, has dihydropteroate synthetase, dihydro-6-hydroxymethylpterin pyrophosphokinase, and dihydroneopterin aldolase activities; Fol1p [Saccharomyces cerevisiae]','MSKLFSTVNSARHSVPLGGMRDYVHIKKLEMNTVLGPDSWNQLMPQKCLLSLDMGTDFSKSAATDDLKYSLNYAVISRDLTNFVSKKKNWGSVSNLAKSVSQFVMDKYSGVECLNLEVQADTTHIRSDHISCIIQQERGNPESQEFDVVRISELKMLTLIGVFTFERLKKQYVTLDIKLPWPKKAELPPPVQSIIDNVVKFVEESNFKTVEALVESVSAVIAHNEYFQKFPDSPLVVKVLKLNAITATEGVGVSCIREPREIAMVNIPYLSSIHESSDIKFQLSSSQNTPIEGKNTWKRAFLAFGSNIGDRFKHIQMALQLLSREKTVKLRNISSIFESEPMYFKDQTPFMNGCVEVETLLTPSELLKLCKKIEYEELQRVKHFDNGPRTIDLDIVMFLNSAGEDIIVNEPDLNIPHPRMLERTFVLEPLCELISPVHLHPVTAEPIVDHLKQLYDKQHDEDTLWKLVPLPYRSGVEPRFLKFKTATKLDEFTGETNRITVSPTYIMAIFNATPDSFSDGGEHFADIESQLNDIIKLCKDALYLHESVIIDVGGCSTRPNSIQASEEEEIRRSIPLIKAIRESTELPQDKVILSIDTYRSNVAKEAIKVGVDIINDISGGLFDSNMFAVIAENPEICYILSHTRGDISTMNRLAHYENFALGDSIQQEFVHNTDIQQLDDLKDKTVLIRNVGQEIGERYIKAIDNGVKRWQILIDPGLGFAKTWKQNLQIIRHIPILKNYSFTMNSNNSQVYVNLRNMPVLLGPSRKKFIGHITKDVDAKQRDFATGAVVASCIGFGSDMVRVHDVKNCSKSIKLADAIYKGLE');
INSERT INTO proteininfo VALUES ('37362686', 'NP_014090.2','Protein with a role in regulation of MBF-specific transcription at Start, phosphorylated by Cln-Cdc28p kinases in vitro; unphosphorylated form binds Swi6p and binding is required for Stb1p function; expression is cell-cycle regulated; Stb1p [Saccharomyces cerevisiae]','MSQPQMSPEKEQELASKILHRAELAQMTRQLKLGLSNVPSTKRKQDSTTKKRSGEDAEDVDEDHKTLLEAISPAKKPLHDDTNKMTVISPVKFVEKPNTPPSSRQRKAEDRSQQIKPRKEDTPSTPRASATPIILPHASSHYQRPHDKNFMTPKRNNNNSSNHSNNNNNIKKKAAGSKDAPQDSDNTAGADLLMYLATSPYNKSSHHGTPMAVRMPTTPRSYHYASQLSLNGNTASTSNDAVRFSHIKPSASSPQSTFKSNLLPNFPDESLMDSPSLYLSNNNGSVQATLSPQQRRKPTTNTLHPPSNVPTTPSRELNGTNFNLLRTPNFNMGDYLHNLFSPSPRVPAQQGASNTSASIPSVPAMVPGSSSNTSAIATAAISSHTTNNFLDMNANGIPLIVGPGTDRIGEGESIDDKLTD');
INSERT INTO proteininfo VALUES ('37362685', 'NP_014083.2','prephenate dehydratase; Pha2p [Saccharomyces cerevisiae]','MASKTLRVLFLGPKGTYSHQAALQQFQSTSDVEYLPAASIPQCFNQLENDTSIDYSVVPLENSTNGQVVFSYDLLRDRMIKKALSLPAPADTNRITPDIEVIAEQYVPITHCLISPIQLPNGIASLGNFEEVIIHSHPQVWGQVECYLRSMAEKFPQVTFIRLDCSSTSESVNQCIRSSTADCDNILHLAIASETAAQLHKAYIIEHSINDKLGNTTRFLVLKRRENAGDNEVEDTGLLRVNLLTFTTRQDDPGSLVDVLNILKIHSLNMCSINSRPFHLDEHDRNWRYLFFIEYYTEKNTPKNKEKFYEDISDKSKQWCLWGTFPRNERYYHK');
INSERT INTO proteininfo VALUES ('37362684', 'NP_013969.2','Protein component of the large (60S) ribosomal subunit, nearly identical to Rpl20Bp and has similarity to rat L18a ribosomal protein; Rpl20ap [Saccharomyces cerevisiae]','MPQKWKMAHFKEYQVIGRRLPTESVPEPKLFRMRIFASNEVIAKSRYWYFLQKLHKVKKASGEIVSINQINEAHPTKVKNFGVWVRYDSRSGTHNMYKEIRDVSRVAAVETLYQDMAARHRARFRSIHILKVAEIEKTADVKRQYVKQFLTKDLKFPLPHRVQKSTKTFSYKRPSTFY');
INSERT INTO proteininfo VALUES ('37362683', 'NP_013941.2','dnaJ homolog; Scj1p [Saccharomyces cerevisiae]','MIPKLYIHLILSLLLLPLILAQDYYAILEIDKDATEKEIKSAYRQLSKKYHPDKNAGSEEAHQKFIEVGEAYDVLSDPEKKKIYDQFGADAVKNGGGGGGPGGPGAGGFHDPFDIFERMFQGGHGGPGGGFGQRQRQRGPMIKVQEKLSLKQFYSGSSIEFTLNLNDECDACHGSGSADGKLAQCPDCQGRGVIIQVLRMGIMTQQIQQMCGRCGGTGQIIKNECKTCHGKKVTKKNKFFHVDVPPGAPRNYMDTRVGEAEKGPDFDAGDLVIEFKEKDTENMGYRRRGDNLYRTEVLSAAEALYGGWQRTIEFLDENKPVKLSRPAHVVVSNGEVEVVKGFGMPKGSKGYGDLYIDYVVVMPKTFKSGQNMLKDEL');
INSERT INTO proteininfo VALUES ('37362682', 'NP_013916.2','Protein required for survival at high temperature during stationary phase; Spg5p [Saccharomyces cerevisiae]','MAVGGNNWSMWLRMSRVHLRQITKSLDRTLISLSHGNFSHQYNRNIFVTWWKSLFEASTAFRRASGLTVSPLTRRGIARFDHFRPVPNVSKFASFPRVPKGAPRGLFTNWNMTTSKRLLGQRAYSTSSIKFTQEAVNNMTISLRCFFNSLGGLNQCSHSNSCKAYQNASNVTSKQDHVQPVALKKLSQKDINFIRNLELFKIMKTQNEVVDETSAYYMEKPGSYIEFTISEFNVNGTFSAPLSFLDPSLLADLDEMIRNYKYELKSIYSSVDMILQNYGSLPITFHRNKIRIHFPNSTVVETEKLIAGLNIATGVIYADTSPDISLEGTNLNALVNVDNSGSVWSFVKEPSFPSRSAFSPILSDASYDTYELV');
INSERT INTO proteininfo VALUES ('37362681', 'NP_013600.2','Protein of unknown function; green fluorescent protein (GFP)-fusion protein localizes to the nuclear periphery; Yml107cp [Saccharomyces cerevisiae]','MEKDALEVRLKSIRHSLDKNTKLLPGKYRNTLGERLITKWRYKKKSHNGSSMLPEKCKSHVQLYDDLVQESSKHFVGFRLHDLRALLKRICSIQNYTRHVLIEWDVRWVNPLTLASKGWEPYQSASQSQVPFKCCCCHAIMTIPLLKNGDDVADYTMKLNEKIWNSNIIGNHLQKCPWRENQVDLNKEYYLSSQNLIREIERIHTEIDRIVSGSNEFSLKRNSSRIFHYLSEKEIQKLAFFFDCKDYSLVGLLLLGYTKFQKDDLVQCTACFHRASLKKLEYTEFNGHALWCRYYNKELLPTMLLELIGKEDKLITKLGVGERLNKLEAVLQTL');
INSERT INTO proteininfo VALUES ('37362680', 'NP_013539.2','Protein with a potential role in pre-rRNA processing; Tsr2p [Saccharomyces cerevisiae]','MSTQYIDETAFVQAEQGKTNLMFSDEKQQARFELGVSMVIYKWDALDVAVENSWGGPDSAEKRDWITGIVVDLFKNEKVVDAALIEETLLYAMIDEFETNVEDDSALPIAVEVINIYNDCFNLNYNKVEKLYLEWQEKQRTKKSKRVVHIEGDDDEDDEDVEDYDDEDEDEEMDEVVPDLVSSKPEPIVDEDGFELVQPKGRRKH');
INSERT INTO proteininfo VALUES ('37362679', 'NP_013300.2','Hypothetical ORF; Ylr199cp [Saccharomyces cerevisiae]','MLFKQWNDLPEPKHLLDLPEISKNLQSLEVCPVPKVEFPQDLDVPQYSTAVITTKIMNPLFPKNLLQLTSIGEIKTTLTVKSPSLPQSSGKHSWNYDENFPNEVDPDQKNDTADETVYGFSFPIYSFGKTLLFSMEENFISISPIFGNMISRSIISQLAQFSPDIIVIGTSDKIASMKVMTENECTLQPPEFITGFIGSVLTQLIVGPSKGLKFKCLVAPSEGPNGFEKLSLSDMGSLVDLCGQWLGFEPSRYSEECYRLWRCDSAAIGAQSGLYI');
INSERT INTO proteininfo VALUES ('37362678', 'NP_013155.2','Non-essential protein required for construction of the outer spore wall layers; Osw2p [Saccharomyces cerevisiae]','MEENQLTCLIVGETPAAQFLGWRLSLSNSFIILVSQYVSSDELVAWKSTKLGANFYTPNILTKDIKELHHKLKHNGANTYSIDIVLVSAISLQSFETTCRLLSDYTNDNTTVLISTDFGCELEPIAISYFGGKCKCVISISCEVECRQLSLGSYALVNDDQCVITLGLTYCDANFEASPTILENTKAASLELQGIKGSNVRRFLLGLTVAKWMKSKLILDPKQMALKMWELLIPKISLNILSIIYEQFDYEKMLENKSTEIIFKDLVKELLGICFAQCGSKIARFLLVKSQGEEEINFGKIVEYCKGKKLQLINSTANEHPEYLSLPFEPYCFYHRFEYPAQILLHQPIILAKKYGVSCSNLNFLYGFYTRLLTLSGLSINGGRCEHALSMLDSRIGGGINVASGINSGQDFTDGDNEDQDKGKNRVDKNVKEGSFISLTQRFTMTSPLGVNDPALPADLEKLYLGAEYISNCDANTSGGQKRVKSPTKADTGYDDKHLPDDTIHTFEDEYLADEDDFSCLGIDKRSSTKPTKPLEKFGVVAVPHFIRRFSIKRSSKDKSNDMKRPYTTSSLELQLRSNHFMFAKEYQDLHRQLYYEVKPRTQSELDARRRNYSELESQMWKIKHRFNIHRGALPRPRTNPYELLLDHIDVLNRGNTGDILRFTTSRYGGVDTYDSILRDQSTIMELLDKRCAYSPPVLFDNEAKERDHDRDCYQDYNHDHRSH');
INSERT INTO proteininfo VALUES ('37362677', 'NP_013127.2','Cytosolic aspartate aminotransferase, involved in nitrogen metabolism; localizes to peroxisomes in oleate-grown cells; Aat2p [Saccharomyces cerevisiae]','MSATLFNNIELLPPDALFGIKQRYGQDQRATKVDLGIGAYRDDNGKPWVLPSVKAAEKLIHNDSSYNHEYLGITGLPSLTSNAAKIIFGTQSDAFQEDRVISVQSLSGTGALHISAKFFSKFFPDKLVYLSKPTWANHMAIFENQGLKTATYPYWANETKSLDLNGFLNAIQKAPEGSIFVLHSCAHNPTGLDPTSEQWVQIVDAIASKNHIALFDTAYQGFATGDLDKDAYAVRLGVEKLSTVSPVFVCQSFAKNAGMYGERVGCFHLALTKQAQNKTIKPAVTSQLAKIIRSEVSNPPAYGAKIVAKLLETPELTEQWHKDMVTMSSRITKMRHALRDHLVKLGTPGNWDHIVNQCGMFSFTGLTPQMVKRLEETHAVYLVASGRASIAGLNQGNVEYVAKAIDEVVRFYTIEAKL');
INSERT INTO proteininfo VALUES ('37362676', 'NP_013112.2','Hypothetical ORF; Ylr012cp [Saccharomyces cerevisiae]','MKTVYYKEITYQQYLQLQPEQQEKYLALCQKDFEQETERIAFDRQGGVPGIARKFAQEEVAWFDRVTTWSYMNAYIPSYRRRRNLLKIDMLKMSNAEEY');
INSERT INTO proteininfo VALUES ('37362675', 'NP_012971.2','Hypothetical ORF; Ykr045cp [Saccharomyces cerevisiae]','MSNSHHTSQGRRNKLSVWVKKIINTTTTTNASVSSSKPRRGTRAGPTRVKRAELDPDGTTISSSLRPLVDRNSLHSSESDDEGDRRVAWDEPPTGKVRQQQQQQQQQQNDNASVIPLVSFCSSSVKSSTFSDIHSIQSTRPTIFSNRTFETNSSVLAIPPQSILDRSRTLPPSNASNTTTRRP');
INSERT INTO proteininfo VALUES ('37362674', 'NP_012964.2','Putative glycoprotease that interacts with Bud32p, which is a member of the novel protein kinase piD261 family; Kae1p [Saccharomyces cerevisiae]','MVNLNTIPPKNGRDYYIALGLEGSANKLGVGIVKHPLLPKHANSDLSYDCEAEMLSNIRDTYVTPPGEGFLPRDTARHHRNWCIRLIKQALAEADIKSPTLDIDVICFTKGPGMGAPLHSVVIAARTCSLLWDVPLVGVNHCIGHIEMGREITKAQNPVVLYVSGGNTQVIAYSEKRYRIFGETLDIAIGNCLDRFARTLKIPNEPSPGYNIEQLAKKAPHKENLVELPYTVKGMDLSMSGILASIDLLAKDLFKGNKKNKILFDKTTGEQKVTVEDLCYSLQENLFAMLVEITERAMAHVNSNQVLIVGGVGCNVRLQEMMAQMCKDRANGQVHATDNRFCIDNGVMIAQAGLLEYRMGGIVKDFSETVVTQKFRTDEVYAAWRD');
INSERT INTO proteininfo VALUES ('37362673', 'NP_012931.2','Mitochondrial ribosomal protein of the large subunit, not essential for mitochondrial translation; Mrpl13p [Saccharomyces cerevisiae]','MSSLLKLHCIRPLPQRSVWLSGYKQKARCIHSSAANGDFMSWFKRKKQEEHQEPVKDTKQLIKDIEEGTNEASSQSSSNNKNRLELIPENFIGEGSRRCKRQKELKLAVSSAPFNQWLSRDKITSDNQLDDMILQATEKTLGKVDQDVQFSDLVAKFQFTKFLQSKSGYLIPDYELTTLSTPLQFKRYIKEKILPSANDPKLAYKEAEPNAIHPFSDNYASPNIYVVNDVTSKEQKSKYDTIMKEIQKLEDDATRKALETARSA');
INSERT INTO proteininfo VALUES ('37362672', 'NP_012929.2','Non-essential protein of unknown function; Ecm9p [Saccharomyces cerevisiae]','MQSSLPLCREFFEKITAYLDYHDFRLTITANQPSITLPYYVDEKAHSIELIIFKTTFLSLFQEAHTYFNKTFSDQSGISNENIYYMTVGFLLTTPENKTVYNVHEDLLKRYFQDNSVLVIPDLLVKEVRLIQRLLCSSNNRINKSSSLWILYRKLFVLSLDANTLVLPDILFVFHSSGSQHFSNYYCWNTARWFYDNLPYNKRIELFNLTKRFCFQNVKDCSSWSALAYMVCQQEEKKTDNIRDFQRLTSSFNVPFKINKVDLNFQVQPADAFTQELVKWIDRTYAADWPPYLCLLQITKFNITLRIEMDSVLLTWRNEILNFEENSGHIKMINNTPIVPEKFSNDLLTSVNFAHFGYKKLFLNKFLDKNKKEQSDS');
INSERT INTO proteininfo VALUES ('37362671', 'NP_012726.2','Essential protein of the mitochondrial intermembrane space, involved in import and assembly of intermembrane space proteins; Mia40p [Saccharomyces cerevisiae]','MLRNLVVRNACRNRPSIQVARGLCRHQTRRLMASSPQFGRNSNQEKTAGFIMGILSMAGALYFIAPNRKPLFASRKVESDKTAEEELSSGGEQSPENEDDNNSKSDENGDDNDSKNDETEAGPQLGGDKIGASKVAEDGELVVLAEEDNKSSEDKDTDESKVSTKDDEQSNEDNATANNQKDENISSENSEENTSDKTLDNNAGSSEKKDPEHSDDEKSQQGQSDDKTTTEDNNGEEESSKKTVSDSENSAKQSESSDEEKEELRKQEEKQMGPTEEEVQHEGAYNPDTGEINWDCPCLGGMAHGPCGEEFKSAFSCFVYSEAEPKGIDCVEKFQHMQDCFRKYPEHYAEQLKETSDDEEPQDKVKVNTIESAPNVSSAKENAAKKAEQSDVKKEPLNEESKP');
INSERT INTO proteininfo VALUES ('37362670', 'NP_012556.2','Like Sm-B protein; Sm-like protein; Lsm8p [Saccharomyces cerevisiae]','MSATLKDYLNKRVVIIKVDGECLIASLNGFDKNTNLFITNVFNRISKEFICKAQLLRGSEIALVGLIDAENDDSLAPIDEKKVPMLKDTKNKIENEHVIWEKVYESKTK');
INSERT INTO proteininfo VALUES ('37362669', 'NP_012551.2','Peptidylprolyl-cis/trans-isomerase (PPIase) specific for phosphorylated serine and threonine residues N-terminal to proline; regulates phosphorylation of the RNA polymerase II large subunit (Rpo21p) C-terminal domain; Ess1p [Saccharomyces cerevisiae]','MPSDVASRTGLPTPWTVRYSKSKKREYFFNPETKHSQWEEPEGTNKDQLHKHLRDHPVRVRCLHILIKHKDSRRPASHRSENITISKQDATDELKTLITRLDDDSKTNSFEALAKERSDCSSYKRGGDLGWFGRGEMQPSFEDAAFQLKVGEVSDIVESGSGVHVIKRVG');
INSERT INTO proteininfo VALUES ('37362668', 'NP_012518.2','Hypothetical ORF; Yjl016wp [Saccharomyces cerevisiae]','MGILDSLKKPVNIKSSLPKFSRSATSINLSSHPVSSRSFLELPPELFSITKPIFKLLQAHANKIYFQSSDAEAVWNVKDSSGHVFEAESISLLGSHIIITNSSVQVADVAIIDSPSNINQCEISSVGEFLQFNNGQLSITCNDFGLLEKFKRLCMISIFEFISIYKALTGTVISSYGLRMSDMHIILNSPFNFKDWCEVYLDGQGWVKVWCHIDKVSKTNNSKSSSDNDAKGKYQIRFYRDDKSTSSKNCVFFIPDNEYVQDIFFYNINAAEPSKNMNDFFQGLQMIKLVGNVRFCSDTDFNDVVDSGSIYSSANNGSGDSSSTALNNESPNTTPKSRTFFSPKGHRRNSSHVSSLTSRSTKKPITNFTTRTNGLLIRPLPHHGVHHLEAMIRFIIPLMDCARLYGRPVQFKTERTDINSLMFGLPKLPSVDYFAEEEIAHLMTQEFNPLKEKDTDDTMALTMSRFSSYLQERMTKVSKRNTELNFRTFSDVMGMYNTTRDHSKLNCMSDKDNSVKEFSLSDKSNVSSETTNMMNQLQVNAHEYKSSMCERPIVASTSPIA');
INSERT INTO proteininfo VALUES ('37362667', 'NP_012444.2','Protein involved in the inositol acylation of glucosaminyl phosphatidylinositol (GlcN-PI) to form glucosaminyl(acyl)phosphatidylinositol (GlcN(acyl)PI), an intermediate in the biosynthesis of glycosylphosphatidylinositol (GPI) anchors; Gwt1p [Saccharomyces cerevisiae]','MSTLKQRKEDFVTGLNGGSITEINAVTSIALVTYISWNLLKNSNLMPPGISSVQYIIDFALNWVALLLSITIYASEPYLLNTLILLPCLLAFIYGKFTSSSKPSNPIYNKKKMITQRFQLEKKPYITAYRGGMLILTAIAILAVDFPIFPRRFAKVETWGTSLMDLGVGSFVFSNGIVSSRALLKNLSLKSKPSFLKNAFNALKSGGTLLFLGLLRLFFVKNLEYQEHVTEYGVHWNFFITLSLLPLVLTFIDPVTRMVPRCSIAIFISCIYEWLLLKDDRTLNFLILADRNCFFSANREGIFSFLGYCSIFLWGQNTGFYLLGNKPTLNNLYKPSTQDVVAASKKSSTWDYWTSVTPLSGLCIWSTIFLVISQLVFQYHPYSVSRRFANLPYTLWVITYNLLFLTGYCLTDKIFGNSSEYYKVAECLESINSNGLFLFLLANVSTGLVNMSMVTIDSSPLKSFLVLLAYCSFIAVISVFLYRKRIFIKL');
INSERT INTO proteininfo VALUES ('37362666', 'NP_012439.2','Mitochondrial ribosomal protein of the large subunit; Mrpl49p [Saccharomyces cerevisiae]','MLQLKFIWPVARITPIYRPFTSHPFRNLATSSSISSTKAKTTKTDTTPLKLSNELYAIFKIHNRPYLVTEGDRVILPFKLKQAEVGDILNMTDVTTLGSRNYKLVGHPINTSLYTLKATVVGKTKRAFQTREVTKRRNRRVRHAKSKGDLTILRISELSMN');
INSERT INTO proteininfo VALUES ('37362665', 'NP_012382.2','Inositol 1-phosphate synthase, involved in synthesis of inositol phosphates and inositol-containing phospholipids; transcription is coregulated with other phospholipid biosynthetic genes by Ino2p and Ino4p, which bind the UASINO DNA element; Ino1p [Saccharomyces cerevisiae]','MTEDNIAPITSVKVVTDKCTYKDNELLTKYSYENAVVTKTASGRFDVTPTVQDYVFKLDLKKPEKLGIMLIGLGGNNGSTLVASVLANKHNVEFQTKEGVKQPNYFGSMTQCSTLKLGIDAEGNDVYAPFNSLLPMVSPNDFVVSGWDINNADLYEAMQRSQVLEYDLQQRLKAKMSLVKPLPSIYYPDFIAANQDERANNCINLDEKGNVTTRGKWTHLQRIRRDIQNFKEENALDKVIVLWTANTERYVEVSPGVNDTMENLLQSIKNDHEEIAPSTIFAAASILEGVPYINGSPQNTFVPGLVQLAEHEGTFIAGDDLKSGQTKLKSVLAQFLVDAGIKPVSIASYNHLGNNDGYNLSAPKQFRSKEISKSSVIDDIIASNDILYNDKLGKKVDHCIVIKYMKPVGDSKVAMDEYYSELMLGGHNRISIHNVCEDSLLATPLIIDLLVMTEFCTRVSYKKVDPVKEDAGKFENFYPVLTFLSYWLKAPLTRPGFHPVNGLNKQRTALENFLRLLIGLPSQNELRFEERLL');
INSERT INTO proteininfo VALUES ('37362663', 'NP_012279.2','Hypothetical ORF; Yir014wp [Saccharomyces cerevisiae]','MLHLEDDNGRQRSVIANLQKFVYCCLYLRFIKDGSLFLILLGWIISSLCDFIQELTLRYLKKNYLEVGRDNDQEDDESLAIRGLETPIVRMIINKAIRYYQGLILLETAYCIVYHIRLDVSRDICSKPYGFVIMLLIREFTCPVPTAFPSKLLLVLLDILLLFCQIVIINGSLSSSLQNVKLIVKELNAEEEGALNILKLNTWHMDATGPELIVLKNHDKSIPQQADGDDATEITPLLNIAE');
INSERT INTO proteininfo VALUES ('37362662', 'NP_012192.2','Meiosis-specific protein with similarity to phospholipase A2, involved in completion of nuclear divisions during meiosis; induced early in meiosis; Spo22p [Saccharomyces cerevisiae]','MSDHNVNSTFRKTLVELCETATWITSQVYAAKNLEKNDLITVDNKISALYPIAEKYDRSFRTTTVILDEELILKLENAASSLWNSLTIAMKAEKASDKYFNEVFCKCKIFATKLLSIHEALFRTNTNLLRNFKCYISSFKSASEYRFDDLITNTQQHSEKYLQIINENVESFSNEEKTEFKKLTFEFYLVNFQLYLSENDLDTANIYTAKVNITDNSKYMDADLLIELCRMIYNSTVMLKEINNPETQLVDVNIISFLKDVEKYLELPVENLKSHTDYSNLKYSVLIFMANCLVEGHPQASELEQCDHYLSLLQNEYPNKVDPFILAINLTKRRNIVNPAETIEEILMRMIMSVDVISNFQAVIASINDLSKMNTKFSIVCLDYLLINKLNSKNDSKFLGKAICSRFLITTQSKTMNDSEIAESLENFSTQMERIVSEPLTKHAISCIITLLWNTGKKLEKMEKYVVSIRFYKLALKDIISQNYSDRGKIQRALQVVYNKIEDYSNTVRVYQDMDEVDRQSPLCQLLMLQSFLADDKTEEALTCLQKIKSSEDEKSTDALILAVAECKRKTDLSVQGLLMIFDKLQSKSNSQTISSTSSSQTLSILRYTLQMIVKVSEEEPLETFINYLPTVQKLLQKAVEFLKTVKLLNQLPPDVEKEAIYQQSVAVNEIEWFASFSYNVAVKCLVDQSCESISEFPQYCIQFIDLIPVQDFTFPKMYHFTYWRFKATILQLIIAKEKAKQDQHQKDWDIYEKSEELVNSINVMKKSSEFKDGSSLEDRNTLHECFLEALTIHLESALMMPDQTRILDILKKTELYQDSRVDALLIDISSNMEDLPKGVLIEILETVLKRNMGPEVKERELCSWLRILLENAINLNHEVELRILDRVLKILNINQSSLQDTDGVLQTELETIATYCWNIGVNYIIKDNKSNGIVWCKHSMGFANMVNEGLQEQLYSLWESLASSANIDINSIAK');
INSERT INTO proteininfo VALUES ('37362661', 'NP_012121.2','Pan6p [Saccharomyces cerevisiae]','MKIFHTVEEVVQWRTQELRETRFRETIGFVPTMGCLHSGHASLISQSVKENTYTVVSIFVNPSQFAPTEDLDNYPRTLPDDIKLLESLKVDVLFAPNAHVMYPQGIPLDIEEQKGPFVSVLGLSEKLEGKTRPNFFRGVATVVTKLFNIVMADVAYFGQKDIQQFIVLQCMVDELFVNTRLQMMPIVRNNNGLALSSRNKYLCPESLKISENLYRGLKAAENAIRRLAPGGRLSRSEIIDTVTQIWAPYVDSHDFKIDYVSLADFKTLDELSDVENTSEQQPIVISCAVYVTDREKPDTVVRLIDNIVI');
INSERT INTO proteininfo VALUES ('37362660', 'NP_011996.2','Uracil phosphoribosyltransferase, synthesizes UMP from uracil; involved in the pyrimidine salvage pathway; Fur1p [Saccharomyces cerevisiae]','MSSEPFKNVYLLPQTNQLLGLYTIIRNKNTTRPDFIFYSDRIIRLLVEEGLNHLPVQKQIVETDTNENFEGVSFMGKICGVSIVRAGESMEQGLRDCCRSVRIGKILIQRDEETALPKLFYEKLPEDISERYVFLLDPMLATGGSAIMATEVLIKRGVKPERIYFLNLICSKEGIEKYHAAFPEVRIVTGALDRGLDENKYLVPGLGDFGDRYYCV');
INSERT INTO proteininfo VALUES ('37362659', 'NP_011932.2','Required for maturation of the 35S primary transcript of pre-rRNA and is required for cleavages leading to mature 18S RNA; RRP3 is a DEAD box gene homologous to eIF-4a which encodes an RNA-dependent ATPase possessing helicase activity which is not specific for RNA; Rrp3p [Saccharomyces cerevisiae]','MSKIVKRKEKKANDELTSLAEKIRAKALENQKKLIEAEKEGGSESDSEEDATAEKKKVLKSKSKSTVSTQNENTNEDESFESFSELNLVPELIQACKNLNYSKPTPIQSKAIPPALEGHDIIGLAQTGSGKTAAFAIPILNRLWHDQEPYYACILAPTRELAQQIKETFDSLGSLMGVRSTCIVGGMNMMDQARDLMRKPHIIIATPGRLMDHLENTKGFSLRKLKFLVMDEADRLLDMEFGPVLDRILKIIPTQERTTYLFSATMTSKIDKLQRASLTNPVKCAVSNKYQTVDTLVQTLMVVPGGLKNTYLIYLLNEFIGKTMIIFTRTKANAERLSGLCNLLEFSATALHGDLNQNQRMGSLDLFKAGKRSILVATDVAARGLDIPSVDIVVNYDIPVDSKSYIHRVGRTARAGRSGKSISLVSQYDLELILRIEEVLGKKLPKESVDKNIILTLRDSVDKANGEVVMEMNRRNKEKIARGKGRRGRMMTRENMDMGER');
INSERT INTO proteininfo VALUES ('37362658', 'NP_011931.2','DnaK homolog, interacts with Zuo1p (DnaJ homolog) to form a ribosome-associated complex (RAC) that is bound to the ribosome via the Zuo1p subunit; Hsp70 Protein; Ssz1p [Saccharomyces cerevisiae]','MSSPVIGITFGNTSSSIAYINPKNDVDVIANPDGERAIPSALSYVGEDEYHGGQALQQLIRNPKNTIINFRDFIGLPFDKCDVSKCANGAPAVEVDGKVGFVISRGEGKEEKLTVDEVVSRHLNRLKLAAEDYIGSAVKEAVLTVPTNFSEEQKTALKASAAKIGLQIVQFINEPSAALLAHAEQFPFEKDVNVVVADFGGIRSDAAVIAVRNGIFTILATAHDLSLGGDNLDTELVEYFASEFQKKYQANPRKNARSLAKLKANSSITKKTLSNATSATISIDSLADGFDYHASINRMRYELVANKVFAQFSSFVDSVIAKAELDPLDIDAVLLTGGVSFTPKLTTNLEYTLPESVEILGPQNKNASNNPNELAASGAALQARLISDYDADELAEALQPVIVNTPHLKKPIGLIGAKGEFHPVLLAETSFPVQKKLTLKQAKGDFLIGVYEGDHHIEEKTLEPIPKEENAEEDDESEWSDDEPEVVREKLYTLGTKLMELGIKNANGVEIIFNINKDGALRVTARDLKTGNAVKGEL');
INSERT INTO proteininfo VALUES ('37362657', 'NP_011791.2','Regulator of Ty1 Transposition; regulator of Ty1 transposition; Rtt102p [Saccharomyces cerevisiae]','MDPQTLITKANKVSYYGNPTSKESWRYDWYQPSKVSSNVQQPQQQLGDMENNLEKYPFRYKTWLRNQEDEKNLQRESCEDILDLKEFDRRILKKSLMTSHTKGDTSKATGAPSANQGDEALSVDDIRGAVGNSEAIPGLSAGVNNDNTKESKDVKMN');
INSERT INTO proteininfo VALUES ('37362656', 'NP_011717.2','Hypothetical ORF; Ygr201cp [Saccharomyces cerevisiae]','MSDGTLFTDLKERKLIRTIVPRGLVRSLKLDVKLADPSDAQQLYEREFPLRKYPTFVGPHDEWTLTEAMAIDYYLIHLSSDKEAVRQLLGPEGDFKTRADILRWESLSNSDFLNEVCEVFFPLIGVKPYNATEFKAARENVDTIVSLYEKRLKKQQYLVCDDHETLADLISAAAFSLGFISFFDETWRSKHPEVTRWFNRVIKSRFFEGEFESFKMCETEMQPIK');
INSERT INTO proteininfo VALUES ('37362655', 'NP_011635.2','Component of the conserved oligomeric Golgi complex; peripheral membrane protein involved in secretion; Cog2p [Saccharomyces cerevisiae]','MDFLNDDELDLDLPVTAEISKELFATEIEKYRESETNGTDVDNFDVDRFLVQKNFHYLPLDSLIRDLSGLSQKMVQTLLEQIRSNYDDYLTFSNTYTDEENETLINLEKTQSDLQKFMTQLDHLIKDDISNTQEIIKDVLEYLKKLDEIYGSLRNHSQLTEALSLGKRLSKSLHEMCGIEPLEEEICSGLIEQLYKLITASRRILESCADSNSPYIHHLRNDYQDLLQEFQISLKILTEKCLENPSSLQNLSLTLVSIIKTA');
INSERT INTO proteininfo VALUES ('37362654', 'NP_011609.2','Ribosomal RNA Processing; Putative 3'->5' exoribonuclease; component of exosome complex of 3'->5' exonucleases; Rrp46p [Saccharomyces cerevisiae]','MSVQAEIGILDHVDGSSEFVSQDTKVICSVTGPIEPKARQELPTQLALEIIVRPAKGVATTREKVLEDKLRAVLTPLITRHCYPRQLCQITCQILESGEDEAEFSLRELSCCINAAFLALVDAGIALNSMCASIPIAIIKDTSDIIVDPTAEQLKISLSVHTLALEFVNGGKVVKNVLLLDSNGDFNEDQLFSLLELGEQKCQELVTNIRRIIQDNISPRLVV');
INSERT INTO proteininfo VALUES ('37362653', 'NP_011571.2','Required for amino acid permease transport from the Golgi to the cell surface; involved in transport of nitrogen-regulated permeases; Lst7p [Saccharomyces cerevisiae]','MSSTVISLAHFCDKHGPRIISVTQSAEKGTLGEELLVPDYPTESYCESCLLQFPEESTRSMRCFIEDVPFITTQYSSIRYQLLNSIIKRAFSEETMIYDNMPFIFFDDLRGLNLVIGFKLYDENARGNERRYCFILTVDSRSHDDSMKMLSEHWNFIIGGFDKMIAYIKNIHKSEFLGKNKTVENNLETLNNNAFIGSYLRANKSKFGRNLVSLTDDKFLFVRIHKWNSFLLHTVMNENKLP');
INSERT INTO proteininfo VALUES ('37362652', 'NP_011490.2','Probable transcription factor, polyglutamine domain protein; RNA polymerase II mediator subunit; Pgd1p [Saccharomyces cerevisiae]','MDSIIPAGVKLDDLQVILAKNENETRDKVCKQINEARDEILPLRLQFNEFIQIMANIDQEGSKQADRMAKYLHIRDKILQLNDRFQTLSSHLEALQPLFSTVPEYLKTADNRDRSFQLLEPLSTYNKNGNAVCSTATVVSTNHSAAASTPTTTATPHANPITHAHSLSNPNSTATMQHNPLAGKRGPKSGSTMGTPTVHNSTAAAPIAAPKKPRKPRQTKKAKAQAQAQAQAQAQVYAQQSTVQTPITASMAAALPNPTPSMINSVSPTNVMGTPLTNMMSPMGNAYSMGAQNQGGQVSMSQFNGSGNGSNPNTNTNSNNTPLQSQLNLNNLTPANILNMSMNNDFQQQQQQQQQQQQPQPQYNMNMGMNNMNNGGKELDSLDLNNLELGGLNMDFL');
INSERT INTO proteininfo VALUES ('37362651', 'NP_011387.2','Component of a complex containing Cef1p, putatively involved in pre-mRNA splicing; has similarity to E.coli DnaJ and other DnaJ-like proteins and to S. pombe Cwf23p; Cwc23p [Saccharomyces cerevisiae]','MPGHELEDVINQRLNLYDVLELPTPLDVHTIYDDLPQIKRKYRTLALKYHPDKHPDNPSIIHKFHLLSTATNILTNADVRPHYDRWLIEFLRKTNDIERNKLIQKLEESESSTIPTTTPHPDLLQIQRHGELLRKLKHFNLPYGDWKHLNTQDQENASQHPYYDCSTLRIVLDNFLQSNNKSNCLSHLRNQVFITLSANEIYDIYFSERNNYSKDDSIIIYTVFDTPITAQHVFRNWSSGNLIPTVKDISPLIPLHYYSDFNLETELNDDIARLVSNEPILLD');
INSERT INTO proteininfo VALUES ('37362650', 'NP_011274.2','Processivity factor required for the ubiquitination activity of the anaphase promoting complex (APC), mediates the activity of the APC by contributing to substrate recognition; involved in cyclin proteolysis; Doc1p [Saccharomyces cerevisiae]','MDPIGINKVLDHLAPSELIKPVKSCHNKPSVLVLDDRIVDAATKDLYVNGFQEEIQYQNPTPENLQHMFHQGIEILDSARMINVTHLALWKPSSFKLGNPVDFALDDNYDTFWQSDGGQPHQLDIMFSKRMDICVMAIFFSMIADESYAPSLVKVYAGHSPSDARFYKMLEVRNVNGWVALRFLDNREDDQLLKCQFIRLLFPVNHENGKDTHLRGIRLYVPSNEPHQDTHEWAQTLPETNNVFQDAILR');
INSERT INTO proteininfo VALUES ('37362649', 'NP_011269.2','Glutamyl-tRNA synthetase (GluRS), forms a complex with methionyl-tRNA synthetase (Mes1p) and Arc1p; complex formation increases the catalytic efficiency of both tRNA synthetases and ensures their correct localization to the cytoplasm; Gus1p [Saccharomyces cerevisiae]','MPSTLTINGKAPIVAYAELIAARIVNALAPNSIAIKLVDDKKAPAAKLDDATEDVFNKITSKFAAIFDNGDKEQVAKWVNLAQKELVIKNFAKLSQSLETLDSQLNLRTFILGGLKYSAADVACWGALRSNGMCGSIIKNKVDVNVSRWYTLLEMDPIFGEAHDFLSKSLLELKKSANVGKKKETHKANFEIDLPDAKMGEVVTRFPPEPSGYLHIGHAKAALLNQYFAQAYKGKLIIRFDDTNPSKEKEEFQDSILEDLDLLGIKGDRITYSSDYFQEMYDYCVQMIKDGKAYCDDTPTEKMREERMDGVASARRDRSVEENLRIFTEEMKNGTEEGLKNCVRAKIDYKALNKTLRDPVIYRCNLTPHHRTGSTWKIYPTYDFCVPIVDAIEGVTHALRTIEYRDRNAQYDWMLQALRLRKVHIWDFARINFVRTLLSKRKLQWMVDKDLVGNWDDPRFPTVRGVRRRGMTVEGLRNFVLSQGPSRNVINLEWNLIWAFNKKVIDPIAPRHTAIVNPVKIHLEGSEAPQEPKIEMKPKHKKNPAVGEKKVIYYKDIVVDKDDADVINVDEEVTLMDWGNVIITKKNDDGSMVAKLNLEGDFKKTKHKLTWLADTKDVVPVDLVDFDHLITKDRLEEDESFEDFLTPQTEFHTDAIADLNVKDMKIGDIIQFERKGYYRLDALPKDGKPYVFFTIPDGKSVNKYGAKK');
INSERT INTO proteininfo VALUES ('37362648', 'NP_011264.2','Hypothetical ORF; Ygl250wp [Saccharomyces cerevisiae]','MSEEEAHKTVEVDDVGVQLDEGDEEDLLEYDDELVEEQPSDARIRNVAETLMKSELPKVTVEYKDTTFLLFTSDDKNESNNPIICENAALYQRPMGEFMESIRKFMGNRFGRLAFATKELVLQLKSLDLTLFEDNVYNNHISFSDVYTIFKILKERSESNFETDIPTHLAIELSTRPRFVSRYNALVELTESSATLKNIKPFSNDETHPLIVDDNDQYTHQNTSEVIVMDIDDDVGEDSED');
INSERT INTO proteininfo VALUES ('37362647', 'NP_116698.2','Protein that forms a complex with the Sit4p protein phosphatase and is required for its function; member of a family of similar proteins including Sap4p, Sap185p, and Sap190p; Sap155p [Saccharomyces cerevisiae]','MSFWPFGQNLNHSNINKILDEYFHVLHELERINPSVGKAIPAIFNNVQERGTSDSLDSIPEEYSHGDEVKTARGDQKSRFEKDDQQERYEKEEEERSMNSSESSTTSFSSGSTSKTDLDEEDISNATAPMMVTTKNLDNSFIERMLVETELLNELSRQNKTLLDFICFGFFFDKKTNKKVNNMEYLVDQLMECISKIKTATTVDLNNLIDYQEQQQLDDSSQEDVYVESDTEQEEEKEDDNNSNNKKRRKRGSSSFGNDDINNNDDDDDANEDDESAYLTKATIISEIFSLDIWLISESLVKNQSYLNKIWSIINQPNFNSENSPLVPIFLKINQNLLLTRQDQYLNFIRTERSFVDDMLKHVDISLLMDFFLKIISTDKIESPTGIIELVYDQNLISKCLSFLNNKESPADIQACVGDFLKALIAISANAPLDDISIGPNSLTRQLASPESIAKLVDIMINQRGAALNTTVSIVIELIRKNNSDYDQVNLLTTTIKTHPPSNRDPIYLGYLLRKFSNHLSDFFQIILDIENDANIPLHENQLHEKFKPLGFERFKVVELIAELLHCSNMGLMNSKRAERIARRRDKVRSQLSHHLQDALNDLSIEEKEQLKTKHSPTRDTDHDLKNNNGKIDNDNNDNDDESDYGDEIDESFEIPYINMKQTIKLRTDPTVGDLFKIKLYDTRIVSKIMELFLTHPWNNFWHNVIFDIIQQIFNGRMDFSYNSFLVLSLFNLKSSYQFMTDIVISDEKGTDVSRFSPVIRDPNFDFKITTDFILRGYQDSYKFYELRKMNLGYMGHIVLIAEEVVKFSKLYKVELISPDIQVILQTEEWQYYSEEVLNETRMMYSKILGGGSYIDDGNGNIIPQLPDNTTVLTPNGDASNNNEILDSDTGSSNGTSGGGQLINVESLEEQLSLSTESDLHNKLREMLINRAQEDVDNKNTENGVFILGPPEDKNSNSNINNTNHNSNNSNNNDNNDNNDNDNDNTRNYNEDADNDNDYDHE');
INSERT INTO proteininfo VALUES ('37362646', 'NP_116648.2','Protein required for normal resistance to bleomycin, may be involved in protection against oxidative damage; Blm3p [Saccharomyces cerevisiae]','MTANNDDDIKSPIPITNKTLSQLKRFERSPGRPSSSQGEIKRKKSRLYAADGRPHSPLRARSATPTLQDQKLFNGMDSTSLLNERLQHYTLDYVSDRAQHMKNIYDPSSRWFSRSVRPEFPIEEFLPYKTESHEDQAKYLCHVLVNLYIAISSLDIQGLISISSKDLADLKKEVDDLALKTDLFRLSNNTAENDLLGNDIADYDDAEGLEDELDEYFDLAGPDFNATGKITAKSATIVNVNHWTNELKNCLHFDFPVALRKSLATVYYYLSLVQGQKVYRQMHVDMFERLVSLDDDRTNFTELLQKQGLLLDHQIMLNFLCEFLPYPDPDYARYELSSKEDLQLFRLLLKHAHNAKPFFDKSKESLLVDTMNFLLSSLAPSTMMAVMPIVTSVVPYHYHIHSKIIDYFPFCYSIWSSVSANVAIDTHMYDFVGSISKDVHNKILSSEHEKDVVGVEFGEFGIFTDDQMTFMFNRLQGHLRTDGQIHSYSRTVKPFVYAINGSKKDRFFEKLVSLAKAIETFIHPSNNGFWTKPNAKFVHAFIKSYHGRVKYEEDICARGVTNGICLTSFCHEEIVEIFLNIISLGSQNKNPDIANYYISCFAYLLELDPSNAYLIYDKILIDLYDTLADQFINSRHRIISSLKQFTRVIRFIVMDKLYRVHITNVLSMLVSKLDMNDTNLTSNLINGIVSIAAFIPIQDLTGEDDYISFESDTLPLVQQHFYHIKCGESSKTFRVDDELLNNAFKASTTVFQSMLKVYVEKIFQLVDVDLEDSLVTKINQTTMILQESMDDKIFNYFASLLQRNFWSNDSFKEKDPNYELVTIPLAALVRRNNGLSKELVRTLLFHIKEQIKRGAGSVRSTSEIQQRDVKLVLYLTALNDVLRQCHESLLEYSDELITFMKYLYDNVTNPPLDVITSIVIHSALATLCTTEITDCRLFPEDSKIPEKDRWGGLQFDPRRFDKQHLSFQWHVPSSDEITLSISILESLSEYCINNVEELMKAPRHDSEYGDMIQKYVLVMTHTLSGSSLLFDPDFNKYRTQSNLSYREKLILLKNIRENNCDPQELDIDIEQIRSGKDDEDYIESKDIEAGLNAGVSDVVQLRDEFPDELIVDEEVVSEMPSGVNTPIAGTHGTDNSAMSSDLAFRDLDIYTCNYYFGNTTEEKLQNPQYLQVHRVRARIGHFFHKLYVFLSTNFENNTNMFQILLHGLKVWFTDLGQETVFNEDPNAFIDVDFLENVQSLSHVNEPFTRTNFAIRANSLHQSRVLLHSTNRKASKLENLLLVDIIQLATSLYPDIYKPAQGTLVHCMKQLVGSYGVVINKIIPSLEKAIKDHDYMKIQVILNVLLIKKIHRKLMTDYKDIGRLIFLLIECCRVNELEIGMYADKILTDIVIGIKIPSSVCVISDQAFLPLAPPDGTINLQVEAVKLAKKKKREYYLSLLVDLQDKLLDKLDNEKDMGWKIRMFILRFVTQIQSNLESKPDKRAVFSIISQISTKHPEIIHLVVKSLLSTCNKIISLSDYEYDITRAYKNEFNPSFVEILDTSTTSFPKTFTEEMNNFDNPKYFIDLRAYVGWLCWGRLMYVMSPKALKLNLRENELEVLKTAGHLLTREFLRDVTMNLVQDNETRGVFSSGNVSFFSLVILLISSGFCELNMSDLFELCESYYNKDDKASMIMSVEIVAGLVCGSKFMSVSDLDKRDTFIENFLAKCLDYELNHDAFEIWSTLAWWLPAVVDLRRSKTFFCHFINADGMFDRESDAATHQTSKIYMLRSILMSMEFRAPDVGKLFDELVFDHPYDQVRQAVAKLLTTLVQNQSNPSISDPTTLLEAERNDPDGLGLPLKSVPEKVDAYIKKQFEIIKNLEDSVVGLNPQQFIKTDYFYRTSTIFYWIKEMARGPNKVLLVPYLVDYVLPFLIGLVKHKDVCALASLDPVRLYAGLGYMPIRKNHVAAIVDYVCSSNVALSSNQTKLQLAFIQHFLSAELLQLTEEEKNKILEFVVSNLYNEQFVEVRVRAASILSDIVHNWKEEQPLLSLIERFAKGLDVNKYTSKERQKLSKTDIKIHGNVLGLGAIISAFPYVFPLPPWIPKQLSNLSSWARTSGMTGQAAKNTISEFKKVRADTWKFDRASFNTEELEDLEGVLWRSYYA');
INSERT INTO proteininfo VALUES ('37362644', 'NP_011105.2','alpha subunit of pyruvate dehydrogenase (E1 alpha); Pda1p [Saccharomyces cerevisiae]','MLAASFKRQPSQLVRGLGAVLRTPTRIGHVRTMATLKTTDKKAPEDIEGSDTVQIELPESSFESYMLEPPDLSYETSKATLLQMYKDMVIIRRMEMACDALYKAKKIRGFCHLSVGQEAIAVGIENAITKLDSIITSYRCHGFTFMRGASVKAVLAELMGRRAGVSYGKGGSMHLYAPGFYGGNGIVGAQVPLGAGLAFAHQYKNEDACSFTLYGDGASNQGQVFESFNMAKLWNLPVVFCCENNKYGMGTAASRSSAMTEYFKRGQYIPGLKVNGMDILAVYQASKFAKDWCLSGKGPLVLEYETYRYGGHSMSDPGTTYRTRDEIQHMRSKNDPIAGLKMHLIDLGIATEAEVKAYDKSARKYVDEQVELADAAPPPEAKLSILFEDVYVKGTETPTLRGRIPEDTWDFKKQGFASRD');
INSERT INTO proteininfo VALUES ('37362643', 'NP_011006.2','Required for Meiotic nuclear Division; functions in DNA replication and damage response; Protein involved in cell wall function; Rmd7p [Saccharomyces cerevisiae]','MSELTEAEKRRLLRERRQKKFSNGGASSRLNKITGQASSHLNAESPLDAPSAAKTTPPASVHSATPDIKEDSNVAPQLDLLKQLAAMQGQGTGKSTPQDSSTPDLLSLLSSMNTGMPSAEGTPSFGQAAPAAPINQAALDYHDYLLNRLKAWTILVKWVFFLLPYLYLITRPNSSVWPAYAFTQSAWFAPLRNPSNFTRIFATFEFLSISIYYQLLKNVEHKSKIKNLQDTNKLVKLVSLVPEGVIPVANLKGKLITLLQYWDLLSMLITDISFVLIVLGLLTYL');
INSERT INTO proteininfo VALUES ('37362642', 'NP_010949.2','Protein involved in 3' mRNA processing, interacts with Ref2p; potential Cdc28p substrate; Fir1p [Saccharomyces cerevisiae]','MSLPVTPVKSKVCSTLSIQHEMDHDQCRDVLCPRENLLAINRTNNIESVAIPRQRSSKNKKPHEHTQSQVRFSIPDPNEISQDSPLKIVFPKSGNETERRMSTSSLLMNSHGHLVDMHSKILVDVPKEVWKFHHNRRKKCESRHRKTRSDVRSNTSSSGKEPNHSRSKSLQSIIVDTMNTYRATEVETSINENTSNISQVSPLNLSFDRPPPLTPEKNLYLTPESPLNRYHLPVPLEISLPPYLSPQNKDKKRSSLVYDGDGYSQFQEGNTSSSTESSLEQPSSSYSDEDDSIPYAHHDVSFELNNADADKLLGIDENANVNLKIQRRNLKNPQHIKSKTDRECEEKNTEKNVSLKILSTPNKLIDIPDLEHMKSPPSTGLNGTLKFFQQFEPSEEPTSPTRQVNPESLDKLDMSFKFPSSTTNNNVDKVHENRNSGDTNNEDFLKVDTSPVNQSFESRRQMLIDLQKSPTNNNPRIHKHRRSRSVHNIDDISLNFEATSTPPAPTSAPSIPVEHSNPCTSIEIPKRSPLRFTSSPKTSDIPPEAQSPKNGSFLQEISVPSIQIIPDESISHTREPSPSLIECPEDENEAFSTEVADHSIAIISETKSVPSIEPFKPLSSFNSFGQEIQNKEPTPLNQTPTDLIGKQRNCVNPHSIPFSVLSSNSQSSQSGSSKSSYNSEFSSNTAITDTTSQPSVTINRSTLEHNFIEEKRSIKNLGHGPPSQKNNYSFPRNKNTPSNRHDLDFNTIYEKRDGKMVEVILLDEDEDVGLKNNDISRTRVCHAQKAKNEQQKKRLSHCNEILGMCDKTADDAKRIIYQLVNEKHKFSEKGQQTKPKKSRVLPPLPFPLYDEKGNSLIPNKYQSSIHNDIPSHRKLK');
INSERT INTO proteininfo VALUES ('37362641', 'NP_010853.2','Kinesin motor protein involved in mitotic spindle assembly and chromosome segregation; Cin8p [Saccharomyces cerevisiae]','MPAENQNTGQDRSSNSISKNGNSQVGCHTVPNEELNITVAVRCRGRNEREISMKSSVVVNVPDITGSKEISINTTGDTGITAQMNAKRYTVDKVFGPGASQDLIFDEVAGPLFQDFIKGYNCTVLVYGMTSTGKTYTMTGDEKLYNGELSDAAGIIPRVLLKLFDTLELQQNDYVVKCSFIELYNEELKDLLDSNSNGSSNTGFDGQFMKKLRIFDSSTANNTTSNSASSSRSNSRNSSPRSLNDLTPKAALLRKRLRTKSLPNTIKQQYQQQQAVNSRNNSSSNSGSTTNNASSNTNTNNGQRSSMAPNDQTNGIYIQNLQEFHITNAMEGLNLLQKGLKHRQVASTKMNDFSSRSHTIFTITLYKKHQDELFRISKMNLVDLAGSENINRSGALNQRAKEAGSINQSLLTLGRVINALVDKSGHIPFRESKLTRLLQDSLGGNTKTALIATISPAKVTSEETCSTLEYASKAKNIKNKPQLGSFIMKDILVKNITMELAKIKSDLLSTKSKEGIYMSQDHYKNLNSDLESYKNEVQECKREIESLTSKNALLVKDKLKSKETIQSQNCQIESLKTTIDHLRAQLDKQHKTEIEISDFNNKLQKLTEVMQMALHDYKKRELDLNQKFEMHITKEIKKLKSTLFLQLNTMQQESILQETNIQPNLDMIKNEVLTLMRTMQEKAELMYKDCVKKILNESPKFFNVVIEKIDIIRVDFQKFYKNIAENLSDISEENNNMKQYLKNHFFKNNHQELLNRHVDSTYENIEKRTNEFVENFKKVLNDHLDENKKLIMQNLTTATSAVIDQEMDLFEPKRVKWENSFDLINDCDSMNNEFYNSMAATLSQIKSTVDTSSNSMNESISVMKGQVEESENAISLLKNNTKFNDQFEQLINKHNMLKDNIKNSITSTHSHITNVDDIYNTIENIMKNYGNKENATKDEMIENILKEIPNLSKKMPLRLSNINSNSVQSVISPKKHAIEDENKSSENVDNEGSRKMLKIE');
INSERT INTO proteininfo VALUES ('37362640', 'NP_010852.2','Regulator of nitrogen permeases; transcription is induced in response to proline and urea; contains two PEST sequences; Npr2p [Saccharomyces cerevisiae]','MLSYFQGFVPIHTIFYSVFHPTEGSKIKYEFPPNNLKNHGINFNTFKNYIIPKPILCHKLITFKYGTYRIVCYPVTINSPIYARNFFSFNFVFVFPYDCETSPYEPAITRLGKMFKVLEEQNQLLSKSERDPVFFDLKVLENSTTTPSTAGPSSTPNPSSNTTPTHPTSEKDTKDMRSSRYSDLIKDLGLPQSAFSIQDLLMRIFQDLNNYSECLIPIDEGNAVDIKIFPLLRPPTTCVSLEDVPLSSVNLKKIIDVNWDPTMMSIVPYIDGLNSIAKISKLSNSDPGLVIECIRHLIYYKCVTLSDIFQFSNIYAPSSLIRNFLTDPLMASDCQSYVTFPEVSKISNLPLNKSLGSGDQDSPSFSVRRKSKSSSIPSNPDSRTTSFSSTSRVSQNSSLNSSFSSIYKDWRQSQTSCSSSNIHVINNRNRFLPTRSCLFDLYRSLSQGQTLKTWYESKYMILKENNIDIRRFITFGLEKRIIYRCYSFPVMINAGSREPKEMTPIITKDLVNNDKLLEKRNHNHLLSATGSRNTAQSGNLKPERPSKVSFEMQRVSSLATGKSTMPKLSDEEEGILEESIRNAETFDKICVLLSKPKLEVESYLNELGEFKVINS');
INSERT INTO proteininfo VALUES ('37362639', 'NP_010774.2','vacuolar protein sorting (putative); Vps60p [Saccharomyces cerevisiae]','MNRIFGYGNKKSHDQLLQESNQSMNQAQQSLSNRISQLDTQIAQLNFQLQNIQKNLQRSNNKQPSLRKQALKILNKRKQLENMKDSLDSQSWSMTQAQLTNDNLQNTMITINALKQTNNAMKAQYGKINIDKLQDMQDEMLDLIEQGDELQEVLAMNNNSGELDDISDAELDAELDALAQEDFTLPTSENSLGNDMPSYLLGANAPPAFIDEEPNLDTEDKNKALESAQ');
INSERT INTO proteininfo VALUES ('37362638', 'NP_010773.2','Protein of unknown function, component of the Swr1p complex that incorporates Htz1p into chromatin; required for vacuolar protein sorting; Vps72p [Saccharomyces cerevisiae]','MSDEGADKSLDTNTEFIIQTRSRRSNAGNKLQKLLEQELRDIESTKRQISSYKNGNDDEEDEIGLLFQEDEDDEDFEMMAKDDDDEGEEKEDETQSIRKEPSQASSEQAADDLMFSSSESEDSSNENDEDAEEKEIRRQELLSRKKRNKRLQKGPVVIKKQKPKPKSGEAIPRSHHTHEQLNAETLLLNTRRTSKRSSVMENTMKVYEKLSKAEKKRKIIQERIRKHKEQESQHMLTQEERLRIAKETEKLNILSLDKFKEQEVWKKENRLALQKRQKQKFQPNETILQFLSTAWLMTPAMELEDRKYWQEQLNKRDKKKKKYPRKPKKNLNLGKQDASDDKKRESEESIKNDGDVNSLGENSSSVHNQKRIEETSTNDTVEGESSPDAAVSRVNSDELKPTALPDVTLDAIANKQSTVDEAPNSQPQKNIITNEQKITNVGEPIQNLHNEEIKDEMVSALESRENTFENSSPAAQVVSQRDNSATPTPSNSTGTEDTILISPDTDIKGEPEPCLKTEGIENLSHNVPQETKSNTDVSFLKQVTFTDHPQVAIIDTEESPSKKDTANVDESSAENSLSTQTYEGPEQLTSRNFVTLYDFPNAPPNLKDFNTNLFGDRWSYTNGLSATQRPQDMKTVFHSILPSPPQSSVPSPTVDISLDLSALANFPSFGEYDKKIVHQINTEINKDLEIKIKTQPPTGVFLANGIRKKCLITNKECQYFDPRTGVPYSDVEAYKIIQRIQDPISKEEGRSDIKRDETTNEDSDDQVRFKWFGFKNGGIYLDLSQRPAKGVPEGF');
INSERT INTO proteininfo VALUES ('37362637', 'NP_010763.2','Jumonji Interacting Protein; Jip4p [Saccharomyces cerevisiae]','MVVRDQDEALRNSYKYVKLYVRQDQLEDTVDILAKQDEDKSNNDDRRSLASILDSSSSVKKKGKGSNEKYLPCVSFNTVPRSRVSSPLDEEKREFPGVQISADYTMEEYYDDESGFTSDNNADYFSGNSYSSRREGSASPGRYSSPPPASKRNIKIGKMFKISENGKIVREDYPTTPTDINDALVISRAYANWRQLWIKKKNQIDHRLEQKRDFFNYPTILFPPNKKKSSEGATPTIKFNPPIEDGFTPLTKSQKRKERVLSEKVGFPNTPRTILCHISGRKHTWVALDWALRTLIQNTDHIVVLANLPRLTKNNFEDNDSMSERKRMLMMMDDSRSVSSARRSRSRSRSRSICTRRALSLGPEESDNKLKHQNFIEWTSGYTQNEIERKLQDLFDYVTLIIPQDRSVKVTVEILIGKTKKTLLEAINIYLPDFFVSSTLRWERTDSLVRWKSNFLTDKLCTNFPIPTFIVPAKRMFDLEIDLQKEFKEPEVTKQKNTSGPKPGFSHSKSADASIPTISNIKRKQDNDYSIDSLCYAPEANGANNSSREEASDDELNAFKDDENDVMSVKSLTSNISVKEKLCTMARKRRKSMAQQLNDADHDSSIPPGQRHLKKLNIILESSLKFSLEIDSITDSIENGDVDEKRAHSMESGFEELKRVITGGAPPRHVATPQRSMLDVLDNPSSSRSKSKSRSSSKSRIRDKSKPSSPTATDINSSASASRSRSPQIKFASSVKNVDGNAALGAIKSRHSLDSPGDQQQQHHHHHHRDTDQLSVPGLPHLAPSKSYSVSSGNKDSSLRKVSSSSSLRKVKSNDSNSGKRIKKPVVTSAHLKPSSGGGGLFSFFKSKSRSPSSFRKEDESKNTPKRGGLFGFGRL');
INSERT INTO proteininfo VALUES ('37362636', 'NP_010751.2','Transcription factor, activated by proteolytic processing in response to signals from the SPS sensor system for external amino acids; activates transcription of amino acid permease genes and may have a role in tRNA processing; Stp1p [Saccharomyces cerevisiae]','MPSTTLLFPQKHIRAIPGKIYAFFRELVSGVIISKPDLSHHYSCENATKEEGKDAADEEKTTTSLFPESNNIDRSLNGGCSVIPCSMDVSDLNTPISITLSPENRIKSEVNAKSLLGSRPEQDTGAPIKMSTGVTSSPLSPSGSTPEHSTKVLNNGEEEFICHYCDATFRIRGYLTRHIKKHAIEKAYHCPFFNSATPPDLRCHNSGGFSRRDTYKTHLKARHVLYPKGVKPQDRNKSSGHCAQCGEYFSTIENFVENHIESGDCKALPQGYTKKNEKRSGKLRKIKTSNGHSRFISTSQSVVEPKVLFNKDAVEAMTIVANNSSGNDIISKYGNNKLMLNSENFKVDIPKRKRKYIKKKQQQVSGSTVTTPEVATQNNQEVAPDEISSATIFSPFDTHLLEPVPSSSSESSAEVMFHGKQMKNFLIDINSFTNQQQQAQDNPSFLPLDIEQSSYDLSEDAMSYPIISTQSNRDCTQYDNTKISQILQSQLNPEYLSENHMRETQQYLNFYNDNFGSQF');
INSERT INTO proteininfo VALUES ('37362635', 'NP_010688.2','uridine nucleosidase (uridine ribohydrolase); EC 3.2.2.3; Urh1p [Saccharomyces cerevisiae]','MTVSKIPIWLDCDPGHDDAIAILLGCFHPAFNLLGISTCFGNAPPENTDYNARSLLTAMGKAQAIPVYKGAQRPWKREPHYAPDIHGISGLDGTSLLPKPTFEARTDKTYIEAIEEAILANNGEISFVSTGALTTLATVFRCKPYLKKSVKYISIMGGGLHGLGNCNPNLSAEFNVWIDPDAANYIFRDPDVKDKCIVVPLNLTHKAIATYKVNEMIYNEKNNSKLRELFLELFQFFAHTYKDMQGFESGPPIHDPVALMPLLEFYGWDPSSAVGFRYKRMDISCIDDVFNENSGKIIIEKEYPNDSDVGTIIGLDLNIQYFWDQIFEALNRADKMSTIG');
INSERT INTO proteininfo VALUES ('37362634', 'NP_010671.2','Nkp1p [Saccharomyces cerevisiae]','MTDTYNSISNFIENELTALLSSDDYLMDDLAGELPNEVCRLLKAQVIEKRKDAMSRGKQDLLSKEIYDNESELRASQSQQIMELVGDIPKYSLGSELRNRVEGEPQSTSIERLIEDVLKLPQMEVADEEEVEVENDLKVLSEYSNLRKDLILKCQALQIGESKLSDILSQTNSINSLTTSIKEASEDDDISEYFATYNGKLVVALEEMKLLLEEAVKTFGNSPEKREKIKKILSELKK');
INSERT INTO proteininfo VALUES ('37362633', 'NP_010604.2','Involved in minichromosome maintenance; involved in minichromosome maintenance; Mcm21p [Saccharomyces cerevisiae]','MSRIDDLQQDIESLLSEINSLEESREKLKAKIKDKRKNEESANPIVQEFEDLFDQFPQLNNFLFNEHPELEETDDKDISRAQADIPATPIPYEPKKRAKLENEEILPEQEWVLKTQPMVQHQMFDPGVADLLDTDILTSPSKRKRKLKIDDISTSDRSELEDYIVLENVYRMFGITFFPLVDPIDLKIKDASGEIFVDREMLGIRLEVFSERTSQFEKPHYVLLKKRIKSNSWFLFKHTIPSFIDVQGIFDDTNGGLVISHDDAYLFAKRVFLQLVEVQKRRQIFKDLEAKKIIHDLDLDLESSMVSFFVKDIKVELFVKQNEIVSCSILDDIHDFSQNNKSKWEIALLGSLDDLELKLNHSFATIFK');
INSERT INTO proteininfo VALUES ('37362632', 'NP_010491.2','Member of the cation diffusion facilitator family, localizes to the endoplasmic reticulum and nucleus; mutations affect the cellular distribution of zinc and also confer defects in meiotic recombination between homologous chromatids; Msc2p [Saccharomyces cerevisiae]','MNLQELLAKVPLLLSYPTIILSSNLIVPSHNDLISRAASTSAAEYADEKLIFFSTDHAIRLIFLPTFVASSFNLFAHYFNFINYSSRRKYYVLFTAIYFLSILTAIFHPIQSTCITLLIIKLLTTADESSPKIALNFKTILKTFVPFITLTLVILRWDPSFDASSGDVNKISTSLAAYALLILTLRYASPLILSTLSSSIGVVSKDTSVAQHSISRNKRFPLILVLPIFSFVLLYLMTIVNKTYNIQLLMVFVFFGCLSIFFLSLKDLFTEDGNQKKGGQEDEYCRMFDIKYMISYLWLTRFTILLTGIMAIVVHFLSFNEITSSIKTDLLSLLFVVVAEYVSSFSNKQPDSHSHNHAHHHSHLTDSLPLENESMFKQMALNKDTRSIFSFLLLNTAFMFVQLLYSFRSKSLGLLSDSLHMALDCTSLLLGLIAGVLTKKPASDKFPFGLNYLGTLAGFTNGVLLLGIVCGIFVEAIERIFNPIHLHATNELLVVATLGLLVNLVGLFAFDHGAHDHGGTDNENMKGIFLHILADTLGSVGVVISTLLIKLTHWPIFDPIASLLIGSLILLSALPLLKSTSANILLRLDDKKHNLVKSALNQISTTPGITGYTTPRFWPTESGSSGHSHAHTHSHAENHSHEHHHDQKNGSQEHPSLVGYIHVQYVDGENSTIIKKRVEKIFENVSIKAWVQVEPQNSTCWCRATSMNTISANPNSLPLQPIAN');
INSERT INTO proteininfo VALUES ('37362631', 'NP_010368.2','Rrp8p [Saccharomyces cerevisiae]','MALFNVEGWSIKTKTVAFDNKTNKSSKDKKKNNRKNGKLTREQKLKEETEAELKEQVEDIPSEGSVAKDIPKKNQEKSDQNETSKKRKHDEEAPLMQVKENIEKPTKKQLTPLQQKMMAKLTGSRFRWINEQLYTISSDEALKLIKEQPQLFDEYHDGFRSQVQAWPENPVDVFVDQIRYRCMKPVNAPGGLPGLKDSKEIVIADMGCGEAQLALEINNFFKNYNKKAKKYLKRRHKVHSFDLKKANERITVADIRNVPLPDESCTIVVFCLALMGTNFLDFIKEAYRILAPRGELWIAEIKSRFSDGKGNEFVDALKLMGFFHKKTFDENKMFTRFEFFKPPAEIIEERRQKLERRQKFIEVETEKEELEKKRRKIAEENGS');
INSERT INTO proteininfo VALUES ('37362630', 'NP_010214.2','translational activator of cytochrome b; Cbs1p [Saccharomyces cerevisiae]','MLRTKVFATTVARISGIRRYIPIRTINTVTKKNISKIEKLCEVLEVNPDGYKGKERIPTKELTKLLYTTSRNMLVRVPMTGDLSTGNTFETRNETLQKLGEQLIHLEINKMLTITFTNFNQFNIMNKNFNYIHNLDRARVVNMDSISWLIKNSLKINQLAHLRIPANLPKEMGLTSSSNDFQNLNDWKVILSFIGYLKLLEIKNDNKKFIESIIKTICIPLINYHLRKS');
INSERT INTO proteininfo VALUES ('37362629', 'NP_010142.2','Suppressor of chromosome missegregation; Scm3p [Saccharomyces cerevisiae]','MKTNKKISKRRSLKNLHGALKGLLKESGKKSESKIRKHSDCNPVHRVYPPNIEKRKTKKDDGISRPIAERNGHVYIMSKENHIIPKLTDDEVMERHKLADENMRKVWSNIISKYESIEEQGDLVDLKTGEIVEDNGHIKTLTANNSTKDKRTKYTSVLRDIIDISDEEDGDKNDEYTLWANDSEASDSEVDADNDTEEEKDEKLIDADFKKYEAKLSKRILRD');
INSERT INTO proteininfo VALUES ('37362628', 'NP_010137.2','Hypothetical ORF; Ydl144cp [Saccharomyces cerevisiae]','MSRILVIGAGGVGVITALSLWLKKESDVSLVVRSDYDRVLKHGYTIESCDYGRLEGWRPHHIYSSVEDAASAADNQGYNYIVVTTKNIIDGPVNSRVSNIIRPVLEKNKELHGPQLTTHILLVQNGIDIEKEIWAEFPREQYRYTVLSGIQLIGSTKIGSGHISQVGQDHLSCGAFDPQDAAAIQAANDFVRMYSNEGQNFVEFDPRVRYSRWKKLLYNAAINTSTALVGLDVPRCLEFGVNKKSTEIEVFHPAMREIIAIAASEGIIIEEEFITMFTEITRKKVFKPSMCVDCEKGQLMELEVILGNPIRIAKRNGVATPTLSILYNLLVLVQAKLKERKGLLKFDEKTATLVDE');
INSERT INTO proteininfo VALUES ('37362626', 'NP_009924.3','Hypothetical ORF; Ycl002cp [Saccharomyces cerevisiae]','MLVIVLQGLAGFLSIIAILCQKRYNKLHRSIYGLSYDLFLLDFVGNGLYLYCALHYCYSSLVREQLSQRFPLFYPLNDARSIPISSFLILKDFCVSCCCMMVLRQLYYYRSTKHIYQGISITSIIIISVFLVLGIFTYGCSISNLPLKNSGKFGVFYLEHINYLWVMANLLKCFKYVPQMSINWMGCSTVGLSSKFALISFLAESIDLLGRLVIPTNALFYEIPFNSTPFWVKLIQFVTYWSYFVKFSMFT');
INSERT INTO proteininfo VALUES ('37362625', 'NP_009893.2','Associates with translating ribosomes; may function in the cytoplasm to modulate mRNA translation; may be involved in organization of actin filaments; RNA binding protein with La motif; Sro9p [Saccharomyces cerevisiae]','MSAETAAANTATAPVPEVQEQESSKSKQVNLTPAPLPTSSPWKLAPTEIPVSTISIEDLDATRKKKNRTPTPKSSTATKWVPIKASITVSGTKRSGSKNGASNGNSNKSKNNKTAASSTSSSNANRKKKHHQHNAKKQQQMKKDGFESAVGEEDSKDATSQENGQSTQQQQPPHHRNHHHSHHHNSNGPQRRKFHNSNNAGMPQNQGFPPQFKPYQGRNARNNNNNRSKYHNHFHHNQQHPQQPMVKLQQQFYPVQPVLMAINNIARQIEYYFSEENLTVDNYLRSKLSKDGFAPLSLISKFYRVVNMSFGGDTNLILAALREIVANEAATVNVAEGTLAAKEGDNVTGEAKEPSPLDKYFVRSKSWSNWLPETFETEINIEKELVGDALDQFMISLPPVPQQEEESSTELASQEQETKEDSAPVAAGESESSL');
INSERT INTO proteininfo VALUES ('37362624', 'NP_009839.2','Hypothetical ORF; Ybr280cp [Saccharomyces cerevisiae]','MSEVESREKEPDAGLSPDIVQATLPFLSSDDIKNLSQTNKYYNTLLDFDHSKILWHELFHKAFGTLKTNDEPFQGRNSAEFKTCTETILREAFPTLSWQEVYQLRAYDAKFYSWGYLKHGRLGYTASSNNELVATSLNGPSPRFKYGVNTPTEVPWFNSRTTSRTSNFTPSEDPLSAIKKDGDEIIAQVSSGGFSFQILTESGNLYSSGSTFSGGLKGPGPSGSQHDYNPFREMIHNMERSYPRITSRSNGSTVNTTGTFSGRRMSGSHPSTAYEPGNATTAQHITIDSGGAPAASPGGSHSGVPRTTMPSMGPHENIYSQIEMLERSANKAVPGNNHIRRMFARNSFPLYSGRDENLGSFNDIQFVAVSSGRSHFLAMDTDNNIYSWDSTESDQGVKIEFANLPSRATNPILKIASGWNFNCCYIYKVGLVAWKERDAIQKGESFAFAKYEIVPNTNDVNGDSRIVDFACLQDNCVFFINNNGDKLWKYHNGLNQIVDLNIVGKLCKINACFASLVLFTDTHCYTLKVTNGDVDKDSLTELDINENVISVASGDYHTVALTERGHLYSWGIESQDCGCLGLGPSEKIVNELHIGNWEGQRNIRVVKPTKIELPEDYICVSVTAGGWQTGALIIKKH');
INSERT INTO proteininfo VALUES ('37362623', 'NP_009823.2','similar to Rab proteins and other small GTP-binding proteins; Ypt10p [Saccharomyces cerevisiae]','MEATIKVVLLGDSSVGKTSIVTRLKSGKFLAKHAATIGAAFITKTIEVPSNDSSTEKRIHMEIWDTAGQERYKSLVPMYYRDANIALIVFELGDVSSLQCAKTWFQDLQDRAQGTQVIIVGNKYDLVCEEHSGEVTIPAELQGLPYVAVSAKTGYNFDTLNKIIISLVPESQFKTLSKNNEQGNILEINKKKSGSGCIC');
INSERT INTO proteininfo VALUES ('37362622', 'NP_009822.2','Serine hydroxymethyltransferase, mitochondrial; Shm1p [Saccharomyces cerevisiae]','MFPRASALAKCMATVHRRGLLTSGAQSLVSKPVSEGDPEMFDILQQERHRQKHSITLIPSENFTSKAVMDLLGSELQNKYSEGYPGERYYGGNEIIDKSESLCQARALELYGLDPAKWGVNVQPLSGAPANLYVYSAIMNVGERLMGLDLPDGGHLSHGYQLKSGTPISFISKYFQSMPYHVDHTTGLIDYDNLQVLAKAFRPKVIVAGTSAYSRLIDYARFKEISQGCGAYLMSDMAHISGLVAANVVPSPFEHSDIVTTTTHKSLRGPRGAMIFFRKGIKSVTKKGKEIPYELEKKINFSVFPGHQGGPHNHTIGAMAVALKQAMSPEFKEYQQKIVDNSKWFAQELTKMGYKLVSGGTDNHLIVIDLSGTQVDGARVETILSALNIAANKNTIPGDKSALFPSGLRIGTPAMTTRGFGREEFSQVAKYIDSAVKLAENLKTLEPTTKLDARSRLNEFKKLCNESSEVAALSGEISKWVGQYPVPGDI');
INSERT INTO proteininfo VALUES ('37362621', 'NP_009731.2','partial suppressor of myo2-66; Kinesin-related protein suppressing myosin defects (MYO2); Smy2p [Saccharomyces cerevisiae]','MIAPDSQRLFGSFDEQFKDLKLDSVDTENNNTHGVSTILDSSPASVNNNTNGAVAASVNTVPGSTFRSNTPLLGGRHPLSRTSSLIDSIGIQRAASPFSSMKEPFIPQSSGVMSSSFWHGDHPESRVSTPVQQHPLLQRNESSSSFSYAANLGVNLSTHSLAVDITPLSTPTAAQSHVNLFPSSDIPPNMSMNGMSQLPAPVSVESSWRYIDTQGQIHGPFTTQMMSQWYIGGYFASTLQISRLGSTPETLGINDIFITLGELMTKLEKYDTDPFTTFDKLHVQTTSSDSINLNLAPYASGVAATGTIKATENDIFKPLTHDNIWDMDGGTTSKGVDIKLASATTISQTDESHKQEYKSTTMLEKGKKEKSESVAKALLDEQEKRNRELKRKEEARLSKKQKQKEDDLLKKQKEQKEQKEKEALEAEKQKKSEKTKKDTQTQTEGFKTSKDLPSLNSSSANPAPWASKVKVNNAIETSIKNGVSSTGKKKGEPLGLQQRNSKEEKQKEELKSVLNWANKSSLPSNQTIDIKSQFQKSPKGMKESSPLKELEDPNFIEEQKKLWEKVQSSSKQVKSTSSASTTTSSWTTVTSKGKAPIGTVVSPYSKTNTSLNSSLTAKTSTTSTTTTFASMNNVSPRQEFIKWCKSQMKLNSGITNNNVLELLLSLPTGPESKELIQETIYANSDVMDGRRFATEFIKRRVACEKQGDDPLSWNEALALSGNDDDGWEFQVVSKKKGRKH');
INSERT INTO proteininfo VALUES ('37362620', 'NP_009680.2','Mitochondrial ribosomal protein of the large subunit; overproduction suppresses mutations in the COX2 leader peptide-encoding region; Mrpl36p [Saccharomyces cerevisiae]','MLKSIFAKRFASTGSYPGSTRITLPRRPAKKIQLGKSRPAIYHQFNVKMELSDGSVVIRRSQYPKGEIRLIQDQRNNPLWNPSRDDLVVVDANSGGSLDRFNKRYSSLFSVDSTTPNSSSETVELSEENKKKTQIKKEEKEDVSEKAFGMDDYLSLLDDSEQQIKSGKLASKKRDKK');
INSERT INTO proteininfo VALUES ('37362619', 'NP_009653.2','Hypothetical ORF; Rxt2p [Saccharomyces cerevisiae]','MTIRSSMKNNAELESKSVLANESNIISTFTRRIIKEKSGNYQVLKRSLDGKLIYPEATGISSNRGNKLLQRSEVVTRRDLNNSKPMIEQTVFYNGSEHRLLQTNIVTDSRRKRIKFTPDINVEPVLVGDENDIDGSEKEDENITDEYYGEEDDDDLSKLVNVKEILTPILSLGDIINHKTISRTFSSPILKNLALQIILMIEKEQMSVVRYSQFLEVFLGDHPEPIYESNLNLPSYNHNLTLPEDRGASDEDDINNKNNINEVNSNSLSTEAGHINNGMEEFGEEDPFFALPRLEQSNALLSLLPSSSGSASISTLTAAEQQQLNEEIESARQLSQIALQRNKEFIRNLQKIRKSVIKANRIRGRILNWSREYLGISDDDITIPVALRVVKRGLISATTNKTTNFEEEIENTMEDGVVDDNEPDEEANRA');
INSERT INTO proteininfo VALUES ('37362618', 'NP_009630.2','Hypothetical ORF; Ybr074wp [Saccharomyces cerevisiae]','MKLKSVFRSVLKYRKTNLSLLLLITYSIITLLYIFDHERYKLNLPKEDEHPEFNDLLETAWGDLQIITASFHPYTSKENDKVHDYLLKRVLEITGNSSFASVSDDKESERSILFQQQDPFNESSRFSRVTYFESSNILVKLEGKNPEEEGLLLSAHFDSVPTGYGATDDGMGVVSLLANLKYHIKHRPNRTLIFNFNNNEEFGLLGASTYFDHSWSNLTKYVINLEGTGAGGKAVLFRTSDTSTARIYQQSVKENPFGNSIYQQGFYSRYVRSETDYKIYEENGMRGWDVAFYKPRNLYHTIKDSIQYTSKASLWHMLHTSLQLSAYVASNSLDTADQTPACYFDFIGLKFFVISAKTLFYWNCIFLLVSPVVAIGLYLISRDRMTWKSYSWLSWTRFPLSLAAGIIVQKLFSNDIIRSNPLTFSRNYFWPISAFFTQVIFTSYVLINCSNFFFPCADMKSLSIIELFIILWTILLFTSKLLYSSDYRYTGLYPLSIFFLLSTIAAILRLLALALGMRTRKRLGRECRDHHSNYSSHSQIDMERDGQENLEQPQDQLTSSQDDQASIQDDNVSTTSAGPSHNVDEDHGMDSSSQQHDERVPLLKGSNSMEEGLSTRENSLKLEYTDYAWIIQFLLIVPIPSFILFNSVDVIMDALNHTVQEGSKATFDVLRFGMVGSILIALPILPFFYKVNYITISLTALLFLISASKTLLVHPFTNSNPLKVRFSQNIDLSQGNAASVHVLGREGNFLKPMLQDLPSIKYSSTHINCTSVTNGMELCMYDGMQPNLLSTNGNTNISSMVKVHVLHNNRNSTERSPYEPIVAELLLEVKEFRACTLTFESRHQAKSPVREITVYQKKNSAPQKANITKTIKSASGINELQLHKLDFDQETYHIGVQWFPKLLTDGNVEDDKLGTKDELSVSISCYWGEYDSESVVNGTAVRKIPAFDELINYAPLSFSFTNEQKGLVIVKDAIIL');
INSERT INTO proteininfo VALUES ('37362617', 'NP_009629.2','genetic interaction with DMC1; Putative helicase similar to RAD54; Rdh54p [Saccharomyces cerevisiae]','MQIPKYENKPFKPPRRVGSNKYTQLKPTATAVTTAPISKAKVTVNLKRSISAGPTLNLAKKPNNLSSNENTRYFTIMYRKPTTKKHKTWSGDGYATLKASSDKLCFYNEAGKFLGSSMLPSDSDSLFETLFKAGSNEVQLDYELKENAEIRSAKEALSQNMGNPSPPTTSTTETVPSTKNDGGKYQMPLSQLFSLNTVKRFKSVTKQTNEHMTTVPKTSQNSKAKKYYPVFDVNKIDNPIVMNKNAAAEVDVIVDPLLGKFLRPHQREGVKFMYDCLMGLARPTIENPDIDCTTKSLVLENDSDISGCLLADDMGLGKTLMSITLIWTLIRQTPFASKVSCSQSGIPLTGLCKKILVVCPVTLIGNWKREFGKWLNLSRIGVLTLSSRNSPDMDKMAVRNFLKVQRTYQVLIIGYEKLLSVSEELEKNKHLIDMLVCDEGHRLKNGASKILNTLKSLDIRRKLLLTGTPIQNDLNEFFTIIDFINPGILGSFASFKRRFIIPITRARDTANRYNEELLEKGEERSKEMIEITKRFILRRTNAILEKYLPPKTDIILFCKPYSQQILAFKDILQGARLDFGQLTFSSSLGLITLLKKVCNSPGLVGSDPYYKSHIKDTQSQDSYSRSLNSGKLKVLMTLLEGIRKGTKEKVVVVSNYTQTLDIIENLMNMAGMSHCRLDGSIPAKQRDSIVTSFNRNPAIFGFLLSAKSGGVGLNLVGRSRLILFDNDWNPSVDLQAMSRIHRDGQKKPCFIYRLVTTGCIDEKILQRQLMKNSLSQKFLGDSEMRNKESSNDDLFNKEDLKDLFSVHTDTKSNTHDLICSCDGLGEEIEYPETNQQQNTVELRKRSTTTWTSALDLQKKMNEAATNDDAKKSQYIRQCLVHYKHIDPARQDELFDEVITDSFTELKDSITFAFVKPGEICLREQ');
INSERT INTO proteininfo VALUES ('37362616', 'NP_009614.2','Ubiquitin-specific protease that specifically disassembles unanchored ubiquitin chains; involved in fructose-1,6-bisphosphatase (FBPase) degradation; Ubp14p [Saccharomyces cerevisiae]','MAEAVLENVNVPAVVSKDECIYCFESPYNEPLALNASPKHSLNICLNCFQATCNRHVPLHIRVTEYACDTIHSNYLTIAKVEKPKQENVEENNNNKKIKLQVIETSEDDTHNTIWSLQRFNGENVPRTVLSKSTDSDISSTALEKIEKILKAKSQDFEDKKNSWVLEISTCPHTENFQIPSKPENTVNLNQCSSCDLTQNLWLCLHCGNIGCGREQIGIDGHSHALDHYRSNNNHPLAIKLGSLSSSTYDLYCYACDDETRFPDNVNLGSALQIYGINIQEKIADEKTLVQLQVEQNENWQFRMVDSSGKEFEKLSASKNYGCGLINLGNSCYLNSVIQSLVNGGVPNWSLDFLGSKFPLDVVYPDNNLKCQWIKLLNAMKCEPELYPNGIKPTTFKKCIGQNHQEFSSNRQQDAMEFLTFLLDLLDKKFFSSSSSGIPNPNDLVRFMMEDRLQCNICGKVKYSYEPTEAIQIPLEENDEPQDMLERIKAYFEGQTIEFKCANCKEKVTANKKPGFKSLPQTLILNPIRIRLQNWIPVKTSNELSLPGLIDRDDMLDVSSYLSQGFDPQTENLLPDEDENRSSFTPNQCSISQLIEMGFTQNASVRALFNTGNQDAESAMNWLFQHMDDPDLNDPFVPPPNVPKKDKREVDEVSLTSMLSMGLNPNLCRKALILNNGDVNRSVEWVFNNMDDDGTFPEPEVPNEEQQQKKDLGYSTAKPYALTAVICHKGNSVHSGHYVVFIRKLVADKWKWVLYNDEKLVAADSIEDMKKNGYIYFYTRC');
INSERT INTO proteininfo VALUES ('37362615', 'NP_009485.2','5-phospho-ribosyl-1(alpha)-pyrophosphate synthetase, involved in nucleotide, histidine, and tryptophan biosynthesis; one of a five related enzymes, which are active as heteromultimeric complexes; Prs4p [Saccharomyces cerevisiae]','MNSESREDMAINSIKLLAGNSHPDLAEQISKKLGIPLSKVGVYQYSNKETSVTIGESLRDEDVYIIQTGIGEQEINDFLMELLILIHACQIASARKITTVIPNFPYARQDKKDKSRAPITAKLVANLLQTAGADHVITMDLHASQIQGFFHIPVDNLYAEPSVLNYIRARKTDFDNAILVSPDAGGAKRVAALADKLDLNFALIHKERQKANEVSKMVLVGDVTNKSCLLVDDMADTCGTLVKACDTLMEHGAKEVIAIVTHGIFSGSAREKLRNSRLSRIVCTNTVPVDLDLPIADQIDISPTFAEAIRRLHNGESVSYLFTHAPV');
INSERT INTO proteininfo VALUES ('37362614', 'NP_009464.2','Putative transporter, member of a family of seven S. cerevisiae genes (AVT1-7) related to vesicular GABA-glycine transporters; Avt5p [Saccharomyces cerevisiae]','MPSNVRSGVLTLLHTACGAGVLAMPFAFKPFGLMPGLITLTFCGICSLCGLLLQTRIAKYVPKSENASFAKLTQLINPSISVVFDFAIAVKCFGVGVSYLIIVGDLVPQIVQSIFYRNDDNMSGSQEHHMFLDRRLYITLIIVFVISPLCFKRSLNSLRYASMIAIVSVAYLSGLIIYHFVNRHQLERGQVYFMVPHGDSQSHSPLTTLPIFVFAYTCHHNMFSVINEQVDKSFKVIRRIPIFAIVLAYFLYIIIGGTGYMTFGENIVGNILTLYPNSISTTIGRLAMLLLVMLAFPLQCHPCRSSVKNIIIFIENFRKGKLYDNRASFIPLDNFNSEDPQEAPTQQNNEEPNLRSESLRHINIITLCILLFSYLLAISITSLAKVLAIVGATGSTSISFILPGLFGYKLIGSEFTGTNERVPTSIKIFKYLSLSLFIWGIAVMVASLSAIVFLGTSSH');
INSERT INTO proteininfo VALUES ('37362612', 'NP_009421.2','Similar to mammalian oxysterol-binding protein; ankyrin repeat; Swh1p [Saccharomyces cerevisiae]','MEQPDLSSVAISKPLLKLKLLDALRQGSFPNLQDLLKKQFQPLDDPNVQQVLHLMLHYAVQVAPMAVIKEIVHHWVSTTNTTFLNIHLDLNERDSNGNTPLHIAAYQSRGDIVAFLLDQPTINDCVLNNSHLQAIEMCKNLNIAQMMQVKRSTYVAETAQEFRTAFNNRDFGHLESILSSPRNAELLDINGMDPETGDTVLHEFVKKRDVIMCRWLLEHGADPFKRDRKGKLPIELVRKVNENDTATSTKIAIDIELKKLLERATREQSVIDVTNNNLHEAPTYKGYLKKWTNFAQGYKLRWFILSSDGKLSYYIDQADTKNACRGSLNMSSCSLHLDSSEKLKFEIIGGNNGVIRWHLKGNHPIETNRWVWAIQGAIRYAKDREILLHNGPYSPSLALSHGLSSKVSNKENLHATSKRLTKSPHLSKSTLTQNDHDNDDDSTNNNNNKSNNDYDDNNNNNNNDDDDYDDDDESRPLIEPLPLISSRSQSLSEITPGPHSRKSTVSSTRAADIPSDDEGYSEDDSDDDGNSSYTMENGGENDGDEDLNAIYGPYIQKLHMLQRSISIELASLNELLQDKQQHDEYWNTVNTSIETVSEFFDKLNRLTSQREKRMIAQMTKQRDVNNVWIQSVKDLEMELVDKDEKLVALDKERKNLKKMLQKKLNNQPQVETEANEESDDANSMIKGSQESTNTLEEIVKFIEATKESDEDSDADEFFDAEEAASDKKANDSEDLTTNKETPANAKPQEEAPEDESLIVISSPQVEKKNQLLKEGSFVGYEDPVRTKLALDEDNRPKIGLWSVLKSMVGQDLTKLTLPVSFNEPTSLLQRVSEDIEYSHILDQAATFEDSSLRMLYVAAFTASMYASTTNRVSKPFNPLLGETFEYARTDGQYRFFTEQVSHHPPISATWTESPKWDFYGECNVDSSFNGRTFAVQHLGLWYITIRPDHNISVPEETYSWKKPNNTVIGILMGKPQVDNSGDVKVTNHTTGDYCMLHYKAHGWTSAGAYEVRGEVFNKDDKKLWVLGGHWNDSIYGKKVTARGGELTLDRIKTANSATGGPKLDGSKFLIWKANERPSVPFNLTSFALTLNALPPHLIPYLAPTDSRLRPDQRAMENGEYDKAAAEKHRVEVKQRAAKKEREQKGEEYRPKWFVQEEHPVTKSLYWKFNGEYWNKRKNHDFKDCADIF');
INSERT INTO proteininfo VALUES ('37362611', 'NP_009391.2','Protein of unknown function, component of the Swr1p complex that incorporates Htz1p into chromatin; required for formation of nuclear-associated array of smooth endoplasmic reticulum known as karmellae; Swc3p [Saccharomyces cerevisiae]','MPAVLRTRSKESSIEQKPASRTRTRSRRGKRGRDDDDDDDDEESDDAYDEVGNDYDEYASRAKLATNRPFEIVAGLPASVELPNYNSSLTHPQSIKNSGVLYDSLVSSRRTWVQGEMFELYWRRPKKIVSESTPAATESPTSGTIPLIRDKMQKMCDCVMSGGPHTFKVRLFILKNDKIEQKWQDEQELKKKEKELKRKNDAEAKRLRMEERKRQQMQKKIAKEQKLQLQKENKAKQKLEQEALKLKRKEEMKKLKEQNKNKQGSPSSSMHDPRMIMNLNLMAQEDPKLNTLMETVAKGLANNSQLEEFKKFIEIAKKRSLEENPVNKRPSVTTTRPAPPSKAKDVAEDHRLNSITLVKSSKTAATEPEPKKADDENAEKQQSKEAKTTAESTQVDVKKEEEDVKEKGVKSEDTQKKEDNQVVPKRKRRKNAIKEDKDMQLTAFQQKYVQGAEIILEYLEFTHSRYYLPKKSVVEFLEDTDEIIISWIVIHNSKEIEKFKTKKIKAKLKADQKLNKEDAKPGSDVEKEVSFNPLFEADCPTPLYTPMTMKLSGIHKRFNQIIRNSVSPMEEVVKEMEKILQIGTRLSGYNLWYQLDGYDDEALSESLRFELNEWEHAMRSRRHKR');
INSERT INTO proteininfo VALUES ('37362610', 'NP_009368.2','Protein of unknown function; Fun19p [Saccharomyces cerevisiae]','MGLYSPESEKSQLNMNYIGKDDSQSIFRRLNQNLKASNNNNDSNKNGLNMSDYSNNSPYGRSYDVRINQNSQNNGNGCFSGSIDSLVDEHIIPSPPLSPKLESKISHNGSPRMASSVLVGSTPKGAVENVLFVKPVWPNGLSRKRYRYATYGFLSQYKIFSNLAQPYSKNIINRYNNLAYNARHKYSKYNDDMTPPPLPSSSSRLPSPLASPNLNRQARYNMRKQALYNNNLGKFESDTEWIPRKRKVYSPQRRTMTTSPHRAKKFSPSASTPHTNIASIEAIHDAPQYIPNVSWKKLPDYSPPLSTLPTDSNKSLKIEWKGSPMDLSTDPLRNELHPAELVLAQTLRLPCDLYLDSKRRLFLEKVYRLKKGLPFRRTDAQKACRIDVNKASRLFQAFEKVGWLQDSNFTKYL');
INSERT INTO proteininfo VALUES ('37362609', 'NP_009355.2','H subunit of the mitochondrial glycine decarboxylase complex, required for the catabolism of glycine to 5,10-methylene-THF; expression is regulated by levels of levels of 5,10-methylene-THF in the cytoplasm; Gcv3p [Saccharomyces cerevisiae]','MLRTTRLWTTRMPAVSKLFLRNSSGNALNKNKLPFLYSSQGPQAVRYTSQHEWIAVHQDKTAFVGITKYATDSLGDATYVELPEVGTEISQGESLGSIESVKSASEIYQPADGTVEEINTNLEENPGVVNEDPMGDGWLVKMKLGEGVNVEQVEGLMSLEQYEKTLVHDD');
INSERT INTO proteininfo VALUES ('33578048', 'NP_878111.1','Identified by homology to Ashbya gossypii; Ykl068w-ap [Saccharomyces cerevisiae]','MQANHSVSYLYESSTSKRSNGLFSQTQKQGSFQKALSQTQEEIEDEDLMVDLNTGSLTPVKLKYWTQMSAMTEKFGKL');
INSERT INTO proteininfo VALUES ('33578047', 'NP_878110.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Ykl096c-bp [Saccharomyces cerevisiae]','MKLFILDYEKKRTKIGKGMARRELKMMNKKPDLYTIIVSYFSIFSLFFF');
INSERT INTO proteininfo VALUES ('33578046', 'NP_878109.1','Identified by fungal homology and RT-PCR; Ykl183c-ap [Saccharomyces cerevisiae]','MYSKILLYRSNVLFMNFFSVFVCTIGTLFLVFADVYVLASAFFQSKKEKETKFKHLHYQKRSCFFLANIH');
INSERT INTO proteininfo VALUES ('33438896', 'NP_878184.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Ypr159c-ap [Saccharomyces cerevisiae]','MATLDFTTKPLALVIYMSVVLLLMVGVPLLFSS');
INSERT INTO proteininfo VALUES ('33438895', 'NP_878183.1','Identified by fungal homology and RT-PCR; Ypr108w-ap [Saccharomyces cerevisiae]','MKSLHDSLSVTDIKRSRLQISMQTLCPFLEDTLQCKSLLSLVVERCTCNAKVVSSILTGGKIFSLKLTLI');
INSERT INTO proteininfo VALUES ('33438894', 'NP_878182.1','Identified by fungal homology and RT-PCR; Ypl038w-ap [Saccharomyces cerevisiae]','MVCRFVHHSRVIFISIYDFLSTKGKKNMYNYTQEKKTKQKNTFTQASIYYENFFESYRTISCL');
INSERT INTO proteininfo VALUES ('33438893', 'NP_878181.1','Identified by expression profiling and mass spectrometry; Ypl119c-ap [Saccharomyces cerevisiae]','MHPLVDELTLSRYLTHGTSVLSSSLYSVAFFLFFFPNFLFFCSCPNHKWVSLPFIGMDILEALCFYREGKIRNIFEIGGLLLQSFYN');
INSERT INTO proteininfo VALUES ('33438892', 'NP_878180.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Ypl152w-ap [Saccharomyces cerevisiae]','MMVHLTLKSHLIKEELLWHALSPSYSCRYHGR');
INSERT INTO proteininfo VALUES ('33438891', 'NP_878179.1','Identified by homology to Ashbya gossypii; Ypl189c-ap [Saccharomyces cerevisiae]','MRAVTRNKIVNNLYFSTFLIAFASVAIGSVLPCPAHSVDSDSPAVQQHKLQLAHEQELKRKDALSKKI');
INSERT INTO proteininfo VALUES ('33438890', 'NP_878178.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Yor394c-ap [Saccharomyces cerevisiae]','MIVNNTHILTLPPHAVSTLTCILIWHRHTDATVYIISSYPTLTFHSMAHLSLHQY');
INSERT INTO proteininfo VALUES ('33438889', 'NP_878177.1','Identified by fungal homology and RT-PCR; Yor381w-ap [Saccharomyces cerevisiae]','MFNVALPSQDKKSEFYKQKRLSLRTNILDEFLRVAKTQDNRQNNFVSQYRNDEIY');
INSERT INTO proteininfo VALUES ('33438888', 'NP_878176.1','Identified by fungal homology and RT-PCR; Yor376w-ap [Saccharomyces cerevisiae]','MTFHLGWTILWYNQAYLEVWATVFQDEMHKYSLHPQSRDAKTKFCCCIPFK');
INSERT INTO proteininfo VALUES ('33438887', 'NP_878175.1','Identified by fungal homology and RT-PCR; Yor316c-ap [Saccharomyces cerevisiae]','MLVPMHNSPTAANGRLSLTVASSGLRKGKKNRVYTIHSYIRSPVSSSEFSFSVRRQYKLTIRIKQKTHL');
INSERT INTO proteininfo VALUES ('33438886', 'NP_878174.1','Identified by expression profiling and mass spectrometry; Yor293c-ap [Saccharomyces cerevisiae]','MKLLFLNIIVVRRHLHCKSYRLSPWYIYIYGDYLLYTTEIPYKPFTRQP');
INSERT INTO proteininfo VALUES ('33438885', 'NP_878173.1','Identified by expression profiling and mass spectrometry; Yor192c-cp [Saccharomyces cerevisiae]','MMIIIFIELCRIADSLSWIPKSLRRTSSTFYIPNIIALLKMESQQLSQNSPTFQKHTPIGHINHDQYNSDSGSYYTLM');
INSERT INTO proteininfo VALUES ('33438884', 'NP_878172.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Yor161c-cp [Saccharomyces cerevisiae]','MSYTRVDHPTGKMACHLRQILASPLFFANYVLHAAIHYPSSDIRGDIL');
INSERT INTO proteininfo VALUES ('33438883', 'NP_878171.1','Identified by expression profiling and mass spectrometry; Yor072w-bp [Saccharomyces cerevisiae]','MILALGDFLTNRKTKHARGPGFNSQLAPFIFDYLFPIGRVTDFFYFFQGPFVL');
INSERT INTO proteininfo VALUES ('33438882', 'NP_878170.1','Identified by expression profiling and mass spectrometry; Yor034c-ap [Saccharomyces cerevisiae]','MNTQELCKIFVAREYPLVVVPFIYFVLFLHQKYHTTLNYVWYPTCSKRIWVREKGRKCSFFFFSKVPRSDGFANNRCQRK');
INSERT INTO proteininfo VALUES ('33438881', 'NP_878169.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Yor032w-ap [Saccharomyces cerevisiae]','MRRALFIAGQTYLWLNLTHLLLIFSWSSTMAFSQSRRLLTPTVPCPTLLGIDFLILVLRHFDEIFI');
INSERT INTO proteininfo VALUES ('33438880', 'NP_878168.1','Identified by homology to Ashbya gossypii; Yor020w-ap [Saccharomyces cerevisiae]','MGAAYKVFGKTVQPHVLAISTFIATAAVASYFTTKPKTKNEGKNSSALSQQKSGESSNSDAMGKDDDVVKSIEGFLNDLEKDTRQDTKAN');
INSERT INTO proteininfo VALUES ('33438879', 'NP_878167.1','Identified by fungal homology and RT-PCR; Yor011w-ap [Saccharomyces cerevisiae]','MAKSVFNFFHFEILEYLNRFVYHSQYFLPYYCSLEVLGKSRKNWTFQYWCLYITTDKKIIKKKDFYHR');
INSERT INTO proteininfo VALUES ('33438878', 'NP_878166.1','Identified by SAGE; Yol013w-bp [Saccharomyces cerevisiae]','MMCIINSESFHGSQKRSGVWSSGMILALGDFLINRGTKHARGPGFNSQLAPFFTIEKYSVRRS');
INSERT INTO proteininfo VALUES ('33438877', 'NP_878165.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Yol019w-ap [Saccharomyces cerevisiae]','MSNTFVAVEFSWLYAISLILPCETIRVAWAPKRAYHGTSEEKRRLAPADI');
INSERT INTO proteininfo VALUES ('33438876', 'NP_878164.1','Identified by SAGE; Yol038c-ap [Saccharomyces cerevisiae]','MKYMGSFLRKAATTNLFNSIKKRKVQNRAMS');
INSERT INTO proteininfo VALUES ('33438875', 'NP_878163.1','Identified by expression profiling and mass spectrometry; Yol097w-ap [Saccharomyces cerevisiae]','MQSMICSSEHENLTCKYWPVSFLASWCENGSGTLMQKDGSLLYAVKNFSHIFEKKIFHTNL');
INSERT INTO proteininfo VALUES ('33438874', 'NP_878162.1','Identified by expression profiling and mass spectrometry; Yol155w-ap [Saccharomyces cerevisiae]','MFYGSFNKCVTGYSCRMAIHYYVYRIIKSATRPDYKSNTQILVL');
INSERT INTO proteininfo VALUES ('33438873', 'NP_878161.1','Identified by fungal homology and RT-PCR; Yol164w-ap [Saccharomyces cerevisiae]','MFAKLYRGLTYVTNKILSTLLSHHSIHYCINSFKPTTLAIIILLHPCCRCNVYIIRCIHH');
INSERT INTO proteininfo VALUES ('33438872', 'NP_878160.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Yol166w-ap [Saccharomyces cerevisiae]','MHGACLSGLYPLPFTHKFHDYLHFNIYISFGGPKYCITALNTYVILFYTVY');
INSERT INTO proteininfo VALUES ('33438871', 'NP_878159.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Ynr075c-ap [Saccharomyces cerevisiae]','MPIIGVPRCLENPFCAPAKFPLSVKKKIRI');
INSERT INTO proteininfo VALUES ('33438870', 'NP_878158.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Ynl024c-ap [Saccharomyces cerevisiae]','MSALFNFRSLLQVILLLICSCSYVHGQWPSLLDRYKNHEVLGAFWKMARVGERASPYVSLACILMAISQFNS');
INSERT INTO proteininfo VALUES ('33438869', 'NP_878157.1','Identified by expression profiling and mass spectrometry; Ynl042w-bp [Saccharomyces cerevisiae]','MILALGDFLPKQEDKACERPWVQFPARPVIFFHHQGGIFLFSINQPNLSCFSKLKEVNSLYVRVATYICQKNESRFRTNRLKGDQ');
INSERT INTO proteininfo VALUES ('33438868', 'NP_878156.1','Ynl067w-bp [Saccharomyces cerevisiae]','MCKLMWCTGVVSKTALLTGNFFFSSSEFFFKATHRKSENYLNGRQT');
INSERT INTO proteininfo VALUES ('33438867', 'NP_878155.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Ynl097c-ap [Saccharomyces cerevisiae]','MTAKTKQSWNKGIWENGKQGSHQQTFLPKIWVNIYSTPTS');
INSERT INTO proteininfo VALUES ('33438866', 'NP_878154.1','Identified by fungal homology and RT-PCR; Ynl130c-ap [Saccharomyces cerevisiae]','MQVGFVSQTNCRSFPACIVFLFQMSQRQRSFNANLRVFKSKCKKIYIG');
INSERT INTO proteininfo VALUES ('33438865', 'NP_878153.1','Component of the U2 snRNP, associated with the SF3b complex; conserved in Ashbya gossypii; Rcp10p [Saccharomyces cerevisiae]','MAEKQRQLKLQKIYKQKYIGLGDESTTREQWQRNVRNDTLNTLQGHSASLEYVSLSRGDLSIRDTRIHLLKSMSPGYKAYLREER');
INSERT INTO proteininfo VALUES ('33438864', 'NP_878152.1','Identified by expression profiling and mass spectrometry; Ynl146c-ap [Saccharomyces cerevisiae]','MISVCFVFPHSLALDFKSRCKKNRTKLCSAYYVSQVLRICKEMPYRDLILFSTVRKGVYMRLYY');
INSERT INTO proteininfo VALUES ('33438863', 'NP_878151.1','Identified by expression profiling and mass spectrometry; Ynl277w-ap [Saccharomyces cerevisiae]','MTLAYYGQPVKMCHILPPLRSLPVLVGKKKLKKKKSQTTNNHVIFLFTLFIKLLKTHNRMSL');
INSERT INTO proteininfo VALUES ('33438862', 'NP_878150.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Ymr315w-ap [Saccharomyces cerevisiae]','MTERKLLQLLRRPFISLSLFTALRACPLRPKSLIA');
INSERT INTO proteininfo VALUES ('33438861', 'NP_878149.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Ymr272w-bp [Saccharomyces cerevisiae]','MRSLVFVQLSLLSWEIFCGERSFVSMKAIFSCMYV');
INSERT INTO proteininfo VALUES ('33438860', 'NP_878148.1','Identified by expression profiling and mass spectrometry; Ymr247w-ap [Saccharomyces cerevisiae]','MAHKCASAKLLSGIMALLFNGKSLLRPICLHVHNHLVSNSDTNIVWP');
INSERT INTO proteininfo VALUES ('33438859', 'NP_878147.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Ymr242w-ap [Saccharomyces cerevisiae]','MFKMKFGDTLPRSDFGTGGNKQAPGLELG');
INSERT INTO proteininfo VALUES ('33438858', 'NP_878146.1','Identified by fungal homology and RT-PCR; Ymr230w-ap [Saccharomyces cerevisiae]','MCIIVKYSQCNLFFQDVLRCRHVLCMLFSIVVHFRLSSFVSVCGVRIMCNCINCSRFIHNIN');
INSERT INTO proteininfo VALUES ('33438857', 'NP_878145.1','Identified based on homology to Ashbya gossypii; Ymr194c-bp [Saccharomyces cerevisiae]','MSNPCQKEACAIQDCLLSHQYDDAKCAKVIDQLYICCSKFYNDNGKDSRSPCCPLPSLLELKMKQRKLTPGDS');
INSERT INTO proteininfo VALUES ('33438856', 'NP_878144.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Ymr182w-ap [Saccharomyces cerevisiae]','MRKPSAFHACNIIFLPLVKCASATIMLN');
INSERT INTO proteininfo VALUES ('33438855', 'NP_878143.1','Identified by expression profiling and mass spectrometry; Ymr175w-ap [Saccharomyces cerevisiae]','MNCLCLCSLYSKSISAYFSEFSSTNIYKSYLRLPSVLYYVCMMHTMMPNQLDAVGIQSSESLLM');
INSERT INTO proteininfo VALUES ('33438854', 'NP_878142.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Ymr105w-ap [Saccharomyces cerevisiae]','MILVHTGNVLYPRFIVVAFTFEQRQGGRCKGGKATCMASVQSYKVTMQISSMTIIYPLFIFFSL');
INSERT INTO proteininfo VALUES ('33438853', 'NP_878141.1','Identified by fungal homology and RT-PCR; Ymr030w-ap [Saccharomyces cerevisiae]','MYINFTSFLIKEKKYNVRFLLSRNRKIYAAVGEGHLSGFVTKNHKISRLSFIFSKKKKVFFTIFDTIITIIVRSGIPFPLLCSFGRNKIYILFNVL');
INSERT INTO proteininfo VALUES ('33438852', 'NP_878140.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Ymr001c-ap [Saccharomyces cerevisiae]','MIFECTSFETRHILNSYSCATQLSYNTYRITEKVNPIQAAVSKNNKPFVSNSDSAFFPIFSSFNFVAYTTLTFKKT');
INSERT INTO proteininfo VALUES ('33438851', 'NP_878139.1','Identified by fungal homology and RT-PCR; Yml054c-ap [Saccharomyces cerevisiae]','MIPFPAQHEIFHAYIGRITPHSSRCIANMWHSAHFFHENSLSIMKTLVPWTL');
INSERT INTO proteininfo VALUES ('33438850', 'NP_878138.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Yml100w-ap [Saccharomyces cerevisiae]','MYKCVPSYYSKAGTIVVTYCEISALLVSLKNRVQGKRGETEGQIEISRKAGHPAPAF');
INSERT INTO proteininfo VALUES ('33438849', 'NP_878137.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Ylr466c-bp [Saccharomyces cerevisiae]','MSLRPCLTPSSMQYSDIYIPTHSLTSTSTLAVIPYPAF');
INSERT INTO proteininfo VALUES ('33438848', 'NP_878136.1','Identified by fungal homology and RT-PCR; Ylr412c-ap [Saccharomyces cerevisiae]','MHLCQNGHYYKPHRASAEKVPYLKKKKKNSRNEGKAKKKNEKKKIGTVEFFQQKKKEKKRVLNAVCGL');
INSERT INTO proteininfo VALUES ('33438847', 'NP_878135.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Ylr406c-ap [Saccharomyces cerevisiae]','MIQKPILLSSFLFLYIRALLHSIHPYIRTSVHLYTKKITSYNFLGVPFK');
INSERT INTO proteininfo VALUES ('33438846', 'NP_878134.1','Identified by expression profiling and mass spectrometry; Ylr361c-ap [Saccharomyces cerevisiae]','MAVSNNNNNNNSKERTQNIKEVEEKLGENPKITLKGGGKTKIMDFEQLRKPHCVRPSARFPVEDTAGGLLRTGGHRPQISDEEVSKRHHEQSHGQEDH');
INSERT INTO proteininfo VALUES ('33438845', 'NP_878133.1','Identified by fungal homology and RT-PCR; Ylr342w-ap [Saccharomyces cerevisiae]','MNVFMPIRVFLYSYVIINSLLSSFFHQYRPLFIKNGAAFGVSNSEKICVTLIVNELI');
INSERT INTO proteininfo VALUES ('33438844', 'NP_878132.1','Identified by fungal homology and RT-PCR; Ylr312c-bp [Saccharomyces cerevisiae]','MTTKAMVQKSFKLDLGEHCKEIIERLTDCSQKLSELCTYGCDSTKLGKKRFYQKLADILMEVTKRTRELVECVKMANRQTLSQDLSSFFNYRSVQ');
INSERT INTO proteininfo VALUES ('33438843', 'NP_878131.1','Identified by homology to Ashbya gossypii; Ylr307c-ap [Saccharomyces cerevisiae]','MSLRNISMITKNLQTTAKCYVPKSSPTSTTIPVIRDASTTQCRRITTVINITSLKGYSPSPRTVHDKPIVICTDNEEVETVSEHVKV');
INSERT INTO proteininfo VALUES ('33438842', 'NP_878130.1','Identified by fungal homology and RT-PCR; Ylr285c-ap [Saccharomyces cerevisiae]','MFLRFYNRLLYIYNELFNFLRFTVFLPFCEFVPHHDLFYLIVTYQRTLVYKHKNDC');
INSERT INTO proteininfo VALUES ('33438841', 'NP_878129.1','Identified by SAGE; Ylr264c-ap [Saccharomyces cerevisiae]','MNVIFKLYLTIDAPKKKKVTVRDFLSIRYSMPYRLASN');
INSERT INTO proteininfo VALUES ('33438840', 'NP_878128.1','Identified by fungal homology and RT-PCR; Ylr162w-ap [Saccharomyces cerevisiae]','MVCIHTENQNQGDFYPFVLLEISVLHESPLGHLRYRLTDVPPQPNSPGEIYCFYINCIMNRR');
INSERT INTO proteininfo VALUES ('33438837', 'NP_878125.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Ylr157w-cp [Saccharomyces cerevisiae]','MIVDFYSNTLRHCETLRSQPCSLFSSLYARSFQSSCTLHVAEPSPGFHMYGCHT');
INSERT INTO proteininfo VALUES ('33438836', 'NP_878124.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Ylr157w-ap [Saccharomyces cerevisiae]','MKFQYALAKEQLGSNSRSGVKKLISKHHWLPEYYFSDLSFSVVQQWDSRAIEKTTIISCMRPANQEIYPL');
INSERT INTO proteininfo VALUES ('33438833', 'NP_878121.1','Identified by fungal homology and RT-PCR; Ylr154c-gp [Saccharomyces cerevisiae]','MWRRRREPWEELSFLLNSLSPRNWFIRRWGLMAGRGQHLCWLRCACDGP');
INSERT INTO proteininfo VALUES ('33438832', 'NP_878120.1','Identified by expression profiling and mass spectrometry; Ylr154w-fp [Saccharomyces cerevisiae]','MLLPKQKNPFSKLLNFFNDPSAGSPTETLLRLLVPLNDQVCPNSPL');
INSERT INTO proteininfo VALUES ('33438831', 'NP_878119.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Ylr154w-ep [Saccharomyces cerevisiae]','MPPGIPRGAMCVQRFDDSRNSAIHITYRISLRSSSMREPRDPLLKVFNILKFPVTKILVFDKNLMNR');
INSERT INTO proteininfo VALUES ('33438830', 'NP_878118.1','Identified by fungal homology and RT-PCR; Ylr154w-bp [Saccharomyces cerevisiae]','MLLLKSIRRHQDRSIVHLLRGPNLRSLSLRVWVLHPNTRIDVRLLGPCFKTGGI');
INSERT INTO proteininfo VALUES ('33438829', 'NP_878117.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Ylr154w-cp [Saccharomyces cerevisiae]','MVCIHTENQNQGGFYPFVLLEISVLHEPPLGHLRYRLTDVPPQPNSPPDNVFNPDQPRMGP');
INSERT INTO proteininfo VALUES ('33438828', 'NP_878116.1','Identified by fungal homology and RT-PCR; Yll006w-ap [Saccharomyces cerevisiae]','MTQLSQSNVERVALVYISVYFFSCISLIVYFFTFCLSVSIPKNRQHPIKIIYNNKCPS');
INSERT INTO proteininfo VALUES ('33438827', 'NP_878115.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Yll066w-bp [Saccharomyces cerevisiae]','MSLRPCLTPSSMQYSDIYIHHTHTPHPHHTHTHTHHTPTHSLTSTFTLAVTPYPAF');
INSERT INTO proteininfo VALUES ('33438826', 'NP_878108.1','Identified by fungal homology and RT-PCR; Yjr151w-ap [Saccharomyces cerevisiae]','MLSLIFYLRFPSYIRG');
INSERT INTO proteininfo VALUES ('33438825', 'NP_878107.1','Identified based on homology to Ashbya gossypii; Yjr112w-ap [Saccharomyces cerevisiae]','MVQLRRTITTNKVFQAITSTNDKVAHFVVFMWESWLFVKMFAEDIVTFRKLQANKYVLGVLICSLCASVTSEFAQSVVSRGQRVFDVKDIICNFWGSLLGVGIAFYQDR');
INSERT INTO proteininfo VALUES ('33438824', 'NP_878106.1','Identified by homology to Ashbya gossypii; Yjr005c-ap [Saccharomyces cerevisiae]','MHNTGKRYSETAKKVAAGRARKRRQAYEKDQLEKQQLEAQEAQRWEEGARTPNQKKLIMEQKKTEKLRAKKERDQLLAAEEEALGKGGRGKRY');
INSERT INTO proteininfo VALUES ('33438823', 'NP_878105.1','Yjl047c-ap [Saccharomyces cerevisiae]','MKIKISIEISLSLLSEHYKRNENCISNMLVIGEGPRGETIVERF');
INSERT INTO proteininfo VALUES ('33438822', 'NP_878104.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Yjl077w-bp [Saccharomyces cerevisiae]','MPILVWQLPKSKKLKTLKYRICFREFFDRVET');
INSERT INTO proteininfo VALUES ('33438821', 'NP_878103.1','Identified by homology to Ashbya gossypii; Yjl127c-bp [Saccharomyces cerevisiae]','MIFFFNQIRSIFTALHTPTQQIQLSRRAFFQFLGYLGSCVVISLAAQSKYVQ');
INSERT INTO proteininfo VALUES ('33438820', 'NP_878102.1','Yjl133c-ap [Saccharomyces cerevisiae]','MIAQSTRLAAAVSSSAASAGVSRIAASAMASTIFKRSPGNSFNSFKEYRENAKTYGPLSASLATRRHLAHAPKL');
INSERT INTO proteininfo VALUES ('33438819', 'NP_878101.1','Identified by SAGE; Yjl136w-ap [Saccharomyces cerevisiae]','MTRCISKKMLLEVDALSLIYSPHLYMS');
INSERT INTO proteininfo VALUES ('33438818', 'NP_878100.1','Identified by expression profiling and mass spectrometry; Yir021w-ap [Saccharomyces cerevisiae]','MSFSVSCKTPKTTKLLVSSISESAVALIIITIRILFSIGKSDFKKIISKEINGAETIYYRNIPESKPQGS');
INSERT INTO proteininfo VALUES ('33438817', 'NP_878099.1','Identified by expression profiling and mass spectrometry; Yir018c-ap [Saccharomyces cerevisiae]','MPSDYTSHYPVILIKKKKKKIAGMYRHSKRYLEIMSTASAQFVGN');
INSERT INTO proteininfo VALUES ('33438816', 'NP_878098.1','Identified by expression profiling and mass spectrometry; Yil002w-ap [Saccharomyces cerevisiae]','MTRDTPEDVSTAGAKDILDVLNLLKGGEEKISEVELKLDEMEKKMDSLLVQLEDLHRDNNDLAKSSSQK');
INSERT INTO proteininfo VALUES ('33438815', 'NP_878097.1','Identified by expression profiling and mass spectrometry; Yil046w-ap [Saccharomyces cerevisiae]','MMCVCIPKKKLMDWRVYYIYSYVVCLYMCGSDCACICVLACVVQCVCFNVEMRL');
INSERT INTO proteininfo VALUES ('33438814', 'NP_878096.1','Identified by fungal homology and RT-PCR; Yil134c-ap [Saccharomyces cerevisiae]','MVVGSEFNNTADVDVVAILLTLLNADYFVIKQRLVSACFTKRIKWYFIYAIALLSLFSSRNTVCAPY');
INSERT INTO proteininfo VALUES ('33438813', 'NP_878095.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Yhr214c-ep [Saccharomyces cerevisiae]','MYKITTIYLWLKSYLSFFIGLDNLDFLTLIRFFQCRLQNKLGLQDILDFFCNLCGHSMVRTCNMVEAAQKQNRITFGSIYVKLHPLVKLCTGIVWAPRV');
INSERT INTO proteininfo VALUES ('33438812', 'NP_878094.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Yhr214c-dp [Saccharomyces cerevisiae]','MEDHTLVAIVVFFGNGEPFHVSLSVEMVFVLLLSSTRIHEVVVLICYKLQHATWSWGNMSKNFSLKPDISLSFLLDIISINDICIYGCIALTVVFIL');
INSERT INTO proteininfo VALUES ('33438811', 'NP_878093.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Yhr213w-bp [Saccharomyces cerevisiae]','MLIDFCCSYIAGTHGRERAPSFTGTFVSHVSAENNCRPRRSEITQPCASGTEKKHFAATEKQCTNSLEGSRKDFLSLPLGHSYLFLFCFWRMICSEPKL');
INSERT INTO proteininfo VALUES ('33438810', 'NP_878092.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Yhr213w-ap [Saccharomyces cerevisiae]','MLAKTGDVVVQKVPVIRLSVFLHFFFVFPFCLLHRLYMGMKQVQEFIMEPKGSVFVVRATLRVSLENAGKIFFNETE');
INSERT INTO proteininfo VALUES ('33438809', 'NP_878091.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Yhr212w-ap [Saccharomyces cerevisiae]','MPYHYLFLALFTYLATSNVVSGSTQACLPVGPRKNGMNVNFYKYSLLDSTTYSYPQYMTSGYASNWN');
INSERT INTO proteininfo VALUES ('33438808', 'NP_878090.1','Identified by fungal homology and RT-PCR; Yhr175w-ap [Saccharomyces cerevisiae]','MINYVNITCIIFSTRTLLVFDTSLYIPPFMLSFIGYSLSNQNSPLFLYH');
INSERT INTO proteininfo VALUES ('33438807', 'NP_878089.1','Identified by fungal homology and RT-PCR; Yhr086w-ap [Saccharomyces cerevisiae]','MRLSLYSCCLCIGARRIPTPCLFSYIFTPNLAHFHSPLRSSGFRPAGATRFYS');
INSERT INTO proteininfo VALUES ('33438806', 'NP_878088.1','Identified by expression profiling and mass spectrometry; Yhr050w-ap [Saccharomyces cerevisiae]','MKRDLIGPVKALIKINNCSCLSRCQISRLPHFFTFHPHFSTLIYYYNLKNCITSET');
INSERT INTO proteininfo VALUES ('33438805', 'NP_878087.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Yhr022c-ap [Saccharomyces cerevisiae]','MKIKFSRGARFSATFSFDKYPFLLYEVVR');
INSERT INTO proteininfo VALUES ('33438804', 'NP_878086.1','Identified by expression profiling and mass spectrometry; Yhr007c-ap [Saccharomyces cerevisiae]','MHRKKRKKEKKRTEKDNTTNLPPLFLFPCSLSLPTLLAPVHYIPTRLTHHQAENQLFLLLFQPIIVKPLRS');
INSERT INTO proteininfo VALUES ('33438803', 'NP_878085.1','Identified by expression profiling and mass spectrometry; Yhl015w-ap [Saccharomyces cerevisiae]','MTAFASLREPLVLANLKIKVHIYRMKR');
INSERT INTO proteininfo VALUES ('33438802', 'NP_878084.1','Identified by expression profiling and mass spectrometry; Yhl048c-ap [Saccharomyces cerevisiae]','MHDIWVITTSPACFEILYKYCKQKGRARMGGLIVKIIRFNHASV');
INSERT INTO proteininfo VALUES ('33438801', 'NP_878083.1','Identified by fungal homology and RT-PCR; Ygr240c-ap [Saccharomyces cerevisiae]','MILSKHVNFTYHTYNLIYNFYPDLTNFGMPGSIYGLQSSLKTMEKHVEIPQSIHHYSPFYQLPLIF');
INSERT INTO proteininfo VALUES ('33438800', 'NP_878082.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Ygr204c-ap [Saccharomyces cerevisiae]','MQWNAFSFVSYVYLRYFISFRPNIVLASVRLSWYSII');
INSERT INTO proteininfo VALUES ('33438799', 'NP_878081.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Ygr174w-ap [Saccharomyces cerevisiae]','MNLNAYFEAYQAIFPFLLEAFLRKEQKV');
INSERT INTO proteininfo VALUES ('33438798', 'NP_878080.1','Identified by homology to Ashbya gossypii; Ygr169c-ap [Saccharomyces cerevisiae]','MGKRFSESAAKKAAGLARKRDQAHAKQRAQMEQLEAEEASKWEQGSRKENAKKLEEEQKRQEKARAKKERDALLTAEEEQLGKGGKGKRKMK');
INSERT INTO proteininfo VALUES ('33438797', 'NP_878079.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Ygr146c-ap [Saccharomyces cerevisiae]','MGFLPECNLTCAFLLHSFTFPIAHCPSFSWASFFFTIRPPFFPKLALVCTIFS');
INSERT INTO proteininfo VALUES ('33438796', 'NP_878078.1','Identified by fungal homology and RT-PCR; Ygr121w-ap [Saccharomyces cerevisiae]','MSRHKYKLWMCIAKGKRGVGERNTFVPKCSYAPFCASEVLDQLLRGDNSIVYNFYLKNGSGSVYIGSVFLI');
INSERT INTO proteininfo VALUES ('33438795', 'NP_878077.1','Identified by expression profiling and mass spectrometry; Ygr035w-ap [Saccharomyces cerevisiae]','MLLYLYILYIALKTVSHLFFCNPCFRNLSVGDMLNPRLSLSFFTNHLLCPEAPLIIRGKGSYSAVGNFFSRKK');
INSERT INTO proteininfo VALUES ('33438794', 'NP_878076.1','Identified by SAGE; Ygl006w-ap [Saccharomyces cerevisiae]','MLIFIIHYHRHLALHLMGAFQKHSNSISPPPRKGFI');
INSERT INTO proteininfo VALUES ('33438793', 'NP_878075.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Ygl007c-ap [Saccharomyces cerevisiae]','MLPSISFDYIKRPNIVLFSNVLSLSSNI');
INSERT INTO proteininfo VALUES ('33438792', 'NP_878074.1','Identified by fungal homology and RT-PCR; Ygl041c-bp [Saccharomyces cerevisiae]','MFDSSIERVTLELCFHITLSIMCGCSIYFLLLVFILTFYSSVLLHLKLYFFSSDRAIFNA');
INSERT INTO proteininfo VALUES ('33438791', 'NP_878073.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Ygl188c-ap [Saccharomyces cerevisiae]','MLTTQKCESREGKNDEIFELGESNSDKILLKHGKCNLFSERKPVNH');
INSERT INTO proteininfo VALUES ('33438790', 'NP_878072.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Yfr032c-bp [Saccharomyces cerevisiae]','MVASRARENQRYSQCRKSTIFPLGFAIISGYIQFQNISILHISRFNPLFYNIFHSIFKNPGTTIQLESTLYYHEVPISPIGNAGSQI');
INSERT INTO proteininfo VALUES ('33438789', 'NP_878071.1','Identified by fungal homology and RT-PCR; Yfl041w-ap [Saccharomyces cerevisiae]','MKMWGPSQRDSFREITYKVKFKYDDGDYSLAIDLMSRDCINVYELITDRLLVDFLSKKLLKLR');
INSERT INTO proteininfo VALUES ('33438788', 'NP_878070.1','Yer188c-ap [Saccharomyces cerevisiae]','MAHLSLNQYKCTHIIMHGTCLSGLYPVPFTHKAHDYPHFNIYISFGGPKYCITALNTYVIPLFHHLLSTQFIYTYVNITKKSPLKSPKHKNILSFNDNT');
INSERT INTO proteininfo VALUES ('33438787', 'NP_878069.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Yer175w-ap [Saccharomyces cerevisiae]','MRLHKTFICFSQNKRGCRNILQENSRMIFENKILIMILRQGIFFNISVSTKISF');
INSERT INTO proteininfo VALUES ('33438786', 'NP_878068.1','Identified by fungal homology and RT-PCR; Yer078w-ap [Saccharomyces cerevisiae]','MVRLSYLRLILPPCRLSELSSLAILYQPVIPILISTITFQHFFKCVHTPCNVYI');
INSERT INTO proteininfo VALUES ('33438785', 'NP_878067.1','Ydr524c-bp [Saccharomyces cerevisiae]','MQFKTIVAAFATVAAVQAANVSTNGSNRTNGSNTTSTKISTGAAASNALGAGVFGAAVAAGVAFLF');
INSERT INTO proteininfo VALUES ('33438784', 'NP_878066.1','Identified by SAGE; Ydr524w-ap [Saccharomyces cerevisiae]','MKRSYKTLPTYFFSFFGPFKERAVFLLVL');
INSERT INTO proteininfo VALUES ('33438783', 'NP_878065.1','Identified by fungal homology and RT-PCR; Ydr246w-ap [Saccharomyces cerevisiae]','MRRLYRHLASFFLLPSCPGNTIQSITSYPANALLRSFRHVSTETPVRNRVHNRDSQSCPFFPLMDD');
INSERT INTO proteininfo VALUES ('33438782', 'NP_878064.1','Identified by fungal homology and RT-PCR; Ydr194w-ap [Saccharomyces cerevisiae]','MKQMMIEASISKDTLRLLICFFEIKQCHISLQPTCYYQNWVRYSSIYYQL');
INSERT INTO proteininfo VALUES ('33438781', 'NP_878063.1','Identified by fungal homology and RT-PCR; Ydr182w-ap [Saccharomyces cerevisiae]','MNKRYKLYRVWYYYAHQTVCITSTGFALCFVVQAKTAGLGVTPITSLYGDKKEHLGKLLVPLVLYQI');
INSERT INTO proteininfo VALUES ('33438780', 'NP_878062.1','Identified by fungal homology and RT-PCR; Ydr169c-ap [Saccharomyces cerevisiae]','MMRMSLKQMQSQRFSATSRVRMLLIGASGLRSSSSKLECPRFSNKHGRN');
INSERT INTO proteininfo VALUES ('33438779', 'NP_878061.1','Identified by expression profiling and mass spectrometry; Ydr003w-ap [Saccharomyces cerevisiae]','MTCGIENSYKSAEKKKKYRSFRFFESRDYSELCIIVGTYY');
INSERT INTO proteininfo VALUES ('33438778', 'NP_878060.1','Identified by homology to Ashbya gossypii; Ydl160c-ap [Saccharomyces cerevisiae]','MLSKEALIKILSQNEGGNDMKIADEVVPMIQKYLDIFIDEAVLRSLQSHKDINGERGDKSPLELSHQDLERIVGLLLMDM');
INSERT INTO proteininfo VALUES ('33438777', 'NP_878059.1','Identified by fungal homology and RT-PCR; Ycr108cp [Saccharomyces cerevisiae]','MPYSPSLILMGHTHTDATVYTTLKLPYSHTPIHGPFSLNQYQMHPHHYARHLPQRSIPCAIYP');
INSERT INTO proteininfo VALUES ('33438776', 'NP_878058.1','Identified by homology to Ashbya gossypii; Ycr075w-ap [Saccharomyces cerevisiae]','MEAEKQSDIKGTIAFDTHGNVIESTGVGSQRIEDIGDLSKVTLDAEGFAQVQGDSLLVHLYKRNDITLAVYTSAQ');
INSERT INTO proteininfo VALUES ('33438775', 'NP_878057.1','Identified by expression profiling and mass spectrometry; Ycr024c-bp [Saccharomyces cerevisiae]','MCVCAIPFFEFFLPFIPHYAFLLFVSSVRFTVNERCYYLVCVLKLNCAFFFMVMIFELKRVCVSYLDRSRKIQIVSFFPFITIIFFHS');
INSERT INTO proteininfo VALUES ('33438774', 'NP_878056.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Ybr298c-ap [Saccharomyces cerevisiae]','MELFIPCPERLKKMMLKEELRKELLILRCLYHPTIQIMLPTLGTLGTEKRKEKYALSLFEPILNCVGSAKTSG');
INSERT INTO proteininfo VALUES ('33438773', 'NP_878055.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Ybr296c-ap [Saccharomyces cerevisiae]','MKVLDDWFSRKFSKAVHGNNHGTISLSTLSYIRVHKLVK');
INSERT INTO proteininfo VALUES ('33438772', 'NP_878054.1','Identified by expression profiling and mass spectrometry; Ybr221w-ap [Saccharomyces cerevisiae]','MFSHFEVSENRPRKQPRRKRISLGMINTVVSLDR');
INSERT INTO proteininfo VALUES ('33438771', 'NP_878053.1','Identified by fungal homology and RT-PCR; Ybr200w-ap [Saccharomyces cerevisiae]','MLLCFHMCQRIMWLPFDLMKWRRFHCGAVLVGTLSLRNRSPKILSLYFISDRTG');
INSERT INTO proteininfo VALUES ('33438770', 'NP_878052.1','Identified by expression profiling and mass spectrometry; Ybr196c-bp [Saccharomyces cerevisiae]','MWVVLSKEKILLKKAYYAKTILFSALVLRGVRGE');
INSERT INTO proteininfo VALUES ('33438769', 'NP_878051.1','Identified by fungal homology and RT-PCR; Ybr196c-ap [Saccharomyces cerevisiae]','MSRVYIYPLTVFYFFAIEMSVFCYYNWFYRRNFPYLFRPIFPFLIVLIS');
INSERT INTO proteininfo VALUES ('33438768', 'NP_878050.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Ybr182c-ap [Saccharomyces cerevisiae]','MKIFTLYTMIQQYFFDNGGVYSIKNFYSAVPKEKMNIILVSLDCELQKLALKLSKKTSGTHTTH');
INSERT INTO proteininfo VALUES ('33438766', 'NP_878048.1','Identified by fungal homology and RT-PCR; Ybr072c-ap [Saccharomyces cerevisiae]','MHILTRSSKNAFPRSRSRQDIHISSHIHRDTSNSALLKILVITRTRLDSFVKT');
INSERT INTO proteininfo VALUES ('33438765', 'NP_878047.1','Ybr056w-ap [Saccharomyces cerevisiae]','MRHQYYQPQPMYYQPQPQPIYIQQGPPPPRNDCCCCCNCGDCCSAIANVLCCLCLIDLCCSCAGGM');
INSERT INTO proteininfo VALUES ('33438764', 'NP_878046.1','Identified by fungal homology and RT-PCR; Ybl008w-ap [Saccharomyces cerevisiae]','MKMNPCTVILCKSLFFFCLFQVDCYCNRKNIQNQSSRIATKIKRSYWFRWQKHIILANIHKIIKAYQRSIIKLPVTKGL');
INSERT INTO proteininfo VALUES ('33438763', 'NP_878045.1','Identified by homology to Ashbya gossypii; Ybl039w-ap [Saccharomyces cerevisiae]','MGFFNNNPVIEFFHRITRKPSTIAMWVFAGLICSSTFYLMFMSSPTIDFNSKSKKKNDK');
INSERT INTO proteininfo VALUES ('33438762', 'NP_878044.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Ybl071c-bp [Saccharomyces cerevisiae]','MELFHIRYLQAYLKVIGNYTCHLLFGTHKKTL');
INSERT INTO proteininfo VALUES ('33438761', 'NP_878043.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Ybl101w-cp [Saccharomyces cerevisiae]','MSRSIFFFSSLFLSPLNKIRNIGGKVENPWKSQIRDWKN');
INSERT INTO proteininfo VALUES ('33438758', 'NP_878042.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Yar035c-ap [Saccharomyces cerevisiae]','MRLNYSRCYYSSQRRRQSLPKRFPLI');
INSERT INTO proteininfo VALUES ('33438757', 'NP_878041.1','Identified by fungal homology and RT-PCR; Yal016c-bp [Saccharomyces cerevisiae]','MLYFYHINILIKERKYILIYSYLNRENYQLITEESKKNDIPSIVSTGYFFAFSFPITNVLE');
INSERT INTO proteininfo VALUES ('33438756', 'NP_878040.1','Identified by SAGE; Yal037c-ap [Saccharomyces cerevisiae]','MSISFPKMQHLIVMTTIGDKKVNNNIILFL');
INSERT INTO proteininfo VALUES ('33438755', 'NP_878039.1','Identified by expression profiling and mass spectrometry; Yal063c-ap [Saccharomyces cerevisiae]','MCPRTVLLIININHWFYDKNIVRIILTFRLDSGHISDICFINKNLANALITADISLLKRHDIRCTKYIITYYQRYRNKEKGKFISLCKNTIISSSV');
INSERT INTO proteininfo VALUES ('33438754', 'NP_878038.1','Identified by gene-trapping, microarray-based expression analysis, and genome-wide homology searching; Yal067w-ap [Saccharomyces cerevisiae]','MPIIGVPRCLIKPFSVPVTFPFSVKKNIRILDLDPRTEAYCLSLNSVCFKRLPRRKYFHLLNSYNIKRVLGVVYC');
INSERT INTO proteininfo VALUES ('31126970', 'NP_015456.2','Catalytic subunit of the NatB N-terminal acetyltransferase, which catalyzes acetylation of the amino-terminal methionine residues of all proteins beginning with Met-Asp or Met-Glu and of some proteins beginning with Met-Asn or Met-Met; N-terminal acetyltransferase; Nat3p [Saccharomyces cerevisiae]','MTTIQPFEPVDLFKTNNVNLDILTENFPLEFYFEYMIIWPDLFFKSSEMTVDPTFKHNISGYMMAKTEGKTTEWHTHITAVTVAPRFRRISLASKLCNTLETMTDVMPHEVNFIDLFVKCNNQLAIKLYEKLGYSVYRRVVGYYNSAEDGYPDTLKKVDDNKDAFDMRKAMARDRNRSVRPDGRSHKCYPHDVRF');
INSERT INTO proteininfo VALUES ('28913320', 'NP_796378.1','SCOCO like ORF; Slo1p [Saccharomyces cerevisiae]','MSAENISTGSPTGKQPSSEVNLGEREAGTKNERMMRQTKLLKDTLDLLWNKTLEQQEVCEQLKQENDYLEDYIGNLMRSSNVLEK');
INSERT INTO proteininfo VALUES ('27808717', 'NP_014730.2','Vacuolar cation channel, mediates release of Ca(2+) from the vacuole in response to hyperosmotic shock; Yvc1p [Saccharomyces cerevisiae]','MVSANGDLHLPISNEQCMPENNGSLGFEAPTPRQILRVTLNLKYLIDKVVPIVYDPNDIVCDHSEILSPKVVKLAYEACGGNPKDKANKRKYQSVIIFSLLKVCEWYSILATMEVHNAKLYETRNLASQQLCKLLIEREETRDLQFLFMQLLLRRYVINENDEDQEPLNALELATDMHCTTVIGSSGFQRCLKWIWRGWIVQNGLDPTTFIKDDSLAEVSLISHFNPVRLKAPVYQNYLQMIFSFLFLGLYTLVVNGKDSERVQSFDLLESIFYVFNTGFILDELTKLYYIGYAHLSFWNLFNDTTYLIITFAMGFRAMSVTPLNAKYSSEDWDKISYRVLSCAAPFVWSRLLLYLESQRFIGIMLVILKHMMKESIVFFFLLFLIMIGFTQGFLGLDSADGKRDITGPILGNLTITVLGLGSFDVFEEFAPPYAAILYYGYYFIVSVILLNILIALYSTAYQKVIDNADDEYMALMSQKTLRYIRAPDEDVYVSPLNLIEVFMTPIFRILPPKRAKDLSYTVMTIVYSPFLLLISVKETREARRIKYNRMKRLNDDANEYDTPWDLTDGYLDDDDGLFSDNRNSGMRATQLKNSRSLKLQRTAEQEDVHFKVPKKWYKNVKKCSPSFEQYDNDDTEDDAGEDKDEVKELTKKVENLTAVITDLLEKLDIKDKKE');
INSERT INTO proteininfo VALUES ('27808716', 'NP_014641.2','Membrane protein involved in zinc metabolism, member of the four-protein IZH family, direct target of the Zap1p transcription factor, expression induced by zinc deficiency and fatty acids, deletion increases sensitivity to elevated zinc; Izh2p [Saccharomyces cerevisiae]','MSTLLERTKSVQELKKRAAGKTSANPAEVAKAKKVLRRLYSWDEIPEWQRDNDFILHGYVKETSSFIETFKSLFYLHNESVNIYSHLIPALGFFTVLLLDKSTIKVFATTTWLDHMVIDLFYSGAFACLILSSSFHCLKSHSLRIATLGNKLDYLGICILIVTSMVSILYYGYFEKFSLFCLFALITVSFGIACSIVSLKDKFRKREWRPYRAGLFVCFGLSSIIPIFSGLYCYSFSEIWTQIQLFWVLLGGVLYIIGAVLYGMRFPEKICPGKFDIWGHSHQLFHFLVVIAALCHLRGLLNSYELVHIKMENGIVS');
INSERT INTO proteininfo VALUES ('27808714', 'NP_014160.2','Aminopeptidase of cysteine protease family, has a DNA binding activity and acts as bleomycin hydrolase in vitro; transcription is regulated by galactose via Gal4p; Lap3p [Saccharomyces cerevisiae]','MSSSIDISKINSWNKEFQSDLTHQLATTVLKNYNADDALLNKTRLQKQDNRVFNTVVSTDSTPVTNQKSSGRCWLFAATNQLRLNVLSELNLKEFELSQAYLFFYDKLEKANYFLDQIVSSADQDIDSRLVQYLLAAPTEDGGQYSMFLNLVKKYGLIPKDLYGDLPYSTTASRKWNSLLTTKLREFAETLRTALKERSADDSIIVTLREQMQREIFRLMSLFMDIPPVQPNEQFTWEYVDKDKKIHTIKSTPLEFASKYAKLDPSTPVSLINDPRHPYGKLIKIDRLGNVLGGDAVIYLNVDNETLSKLVVKRLQNNKAVFFGSHTPKFMDKKTGVMDIELWNYPAIGYNLPQQKASRIRYHESLMTHAMLITGCHVDETSKLPLRYRVENSWGKDSGKDGLYVMTQKYFEEYCFQIVVDINELPKELASKFTSGKEEPIVLPIWDPMGALAK');
INSERT INTO proteininfo VALUES ('27808713', 'NP_013680.2','Protein that stimulates strand exchange by facilitating Rad51p binding to single-stranded DNA; anneals complementary single-stranded DNA; involved in the repair of double-strand breaks in DNA during vegetative growth and meiosis; Rad52p [Saccharomyces cerevisiae]','MNEIMDMDEKKPVFGNHSEDIQTKLDKKLGPEYISKRVGFGTSRIAYIEGWRVINLANQIFGYNGWSTEVKSVVIDFLDERQGKFSIGCTAIVRVTLTSGTYREDIGYGTVENERRKPAAFERAKKSAVTDALKRSLRGFGNALGNCLYDKDFLAKIDKVKFDPPDFDENNLFRPTDEISESSRTNTLHENQEQQQYPNKRRQLTKVTNTNPDSTKNLVKIENTVSRGTPMMAAPAEANSKNSSNKDTDLKSLDASKQDQDDLLDDSLMFSDDFQDDDLINMGNTNSNVLTTEKDPVVAKQSPTASSNPEAEQITFVTAKAATSVQNERYIGEESIFDPKYQAQSIRHTVDQTTSKHIPASVLKDKTMTTARDSVYEKFAPKGKQLSMKNNDKELGPHMLEGAGNQVPRETTPIKTNATAFPPAAAPRFAPPSKVVHPNGNGAVPAVPQQRSTRREVGRPKINPLHARKPT');
INSERT INTO proteininfo VALUES ('27808712', 'NP_012875.2','Centromere protein that resembles histones, required for proper kinetochore function; homolog of human CENP-A; Cse4p [Saccharomyces cerevisiae]','MSSKQQWVSSAIQSDSSGRSLSNVNRLAGDQQSINDRALSLLQRTRATKNLFPRREERRRYESSKSDLDIETDYEDQAGNLEIETENEEEAEMETEVPAPVRTHSYALDRYVRQKRREKQRKQSLKRVEKKYTPSELALYEIRKYQRSTDLLISKIPFARLVKEVTDEFTTKDQDLRWQSMAIMALQEASEAYLVGLLEHTNLLALHAKRITIMKKDMQLARRIRGQFI');
INSERT INTO proteininfo VALUES ('27808711', 'NP_012723.2','Putative serine/threonine protein kinase; probable serine/threonine-specific protein kinase (EC 2.7.1.-); Ptk1p [Saccharomyces cerevisiae]','MTVSHNHSTKISQQPISSVSAFKFFGKKLLSSSHGNKLKKKASLPPDFHSTSTNDSESSSPKLPNSLKTSRRANSFAHTTNSKRSLSSASTKILPPAGSSTSISRGNRHSSTSRNLSNSKFSSERLVYNPYGVSTPSTSLSSVSTSMKKDPDLGFYLHDGDSKIRMLPIPIVDPNEYLPDEMKEASIQLSDNFVFDDENKTIGWGGSCEVRKIRSKYRKKDVFALKKLNMIYNETPEKFYNAAPKEFIIAKQLSHHVHITNTFLLVKVPTTVYTTRGWGFVMELGLRDLFAMIQKSGWRHVALAEKFCIFKQVACGVKFCHDQGIAHRDLKPENVLLSPDGVCKLTDFGISDWYHTDPHDLSSPVKKCAGMIGSPPYAPPEVMFYDSKKHYDTELQQPYDPRALDCYGLGIILMTLVNNVIPFLESCSFDTGFRDYCDAYENFIRLHDRAFRNRGNYRPGPGMEYHLARNFKNGHASRVAWRLADPEAATRYTIDDLFEDPWFQGIETCVDANDKYVCKKPIIKTTTYENPRGFHIATDVAATTPTSNPFLKNRVPIRSMVDIAAHPSPTATVLASSPPPPPPATHVPAEALFTLRETPPPQLATLTLSEEPPATPAPSAPSAPSARVRGHSPHRVGASPSEHCQQLGP');
INSERT INTO proteininfo VALUES ('27808709', 'NP_012515.2','Essential integral membrane protein required for spindle pole body duplication and for nuclear fusion, localizes to the spindle pole body half bridge, interacts with DnaJ-like chaperone Jem1p and with centrin homolog Cdc31p; Mps3p [Saccharomyces cerevisiae]','MNNSNEHRREEAGAANEQMPYNKAVKSAYADVLKDKMNREQEISLRAIKKGIYTDGGETDNYDMDKENDSAYEMFKKNLDFPLDQHNDDDDDDPYIEDNGQETDGYSDEDYTDEADKSFIEDSDSDSYDLESNSDFEENLESSGEAKKLKWRTYIFYGGLFFVFYFFGSFLMTTVKNNDLESHSSGATSSPGKSFSNLQKQVNHLYSELSKRDEKHSSELDKTVKIIVSQFEKNIKRLLPSNLVNFENDINSLTKQVETISTSMSELQRRNHKFTVENVTQWQDQLVKQLDTHLPQEIPVVINNSSSLLIIPELHNYLSALISDVIESPGIGTAGSAESRWEYDLNRYVKEILSNELQYIDKDYFIQEMNRRLQSNKQEIWEEITNRLETQQQQQQQQVQQDYSNVPQQYSSILMKRLIHQIYNSNQHQWEDDLDFATYVQGTKLLNHLTSPTWRQGSGVQPIELLTDSKQSSSTYWQCENEPGCSWAIRFKTPLYLTKISYMHGRFTNNLHIMNSAPRLISLYVKLSQTKEIKALQTLANQYGFGQHHKRDRNYIKIAKFEYRLTDSRIRQQMYLPPWFIQLKPLVRSIVFQVDENYGNKKFISLRKFIINGVTPQDLQIIENNEFPVLLGDTPEYGVTQNTDEGKRKVLLSKPPYASSSTSTKFHPASNVPSFGQDELDQ');
INSERT INTO proteininfo VALUES ('27808707', 'NP_011470.2','Involved in proteolytic processing of Rim1p; Rim8p [Saccharomyces cerevisiae]','MSLLRLWNKESRAPSKIKSHGIVGSYGNSMLAHNNVKQFRIDIDEPHRVWKPNESITGEAVIDIKRDITNVAIKLSLVCEVRVKTGNSPTSKNKRIEKTLEKSTFLYGQDYVKTAFSAKEKKPHVDKTTILNGLSKGEHRFPFRIRIPRGRGMLSSIKFERGSITYFLSCTLESLNNINGLKKPEARCEREFAVIVPLDVSRLPKPKTKTVVLQSASMVQNKKNKSTEDESSSYTQLTQKSTTSNSSSSSVNSKTSPLPNKTVTISVDIPQAGFMIGEIIPIDVKIDHYKPFYAPAGLTTTLVRICRVGGAGKDDPMETFRKDICQSISPIYINPETLQFQSRVYLKVPLDAFSTLTTVGKFFSFQYYIEVMVNLSKKNVVYTESNRIIGTPIGEQNGLGVENNINRIQRKMLRMVNPETLENDSEGYESSIFFKDMVNVEKLKRLRNVTGMSIETVIGTTRSEQQQSDASIPSQSSITAPQNSPSNLRDWLAPLNAYDSDDVPVPKYSPNDKVSVPSEDKQELEQKRLQQLESDPPPCDDY');
INSERT INTO proteininfo VALUES ('27808706', 'NP_011456.2','Hypothetical ORF; Ygl059wp [Saccharomyces cerevisiae]','MSKYQINCIRYRHFLRTSNISQIPDFTKYCIGPVNEELAPYIMETMKAYPSNSEYINPQHYYHNRTVLVENYLKRSPNPVSLTQLAQYYDDSTKLTRTKIINSGKFVKEELVIRIAHKLNQLQQLPFNVVNNFHFVQVYESYYNIFESFRKYPTIRTLEDASQFADFIKNMLEGFNTLNLPHLIMGALECTILDLYPREKMDQLLSDLLRARISRRLIVEEHVVYTANYTSGKEENTLVLGDIFQECSAKKYLLEASEESQKFIQDMYFKDIPMPEFIIEGDTQLSFYFLPTHLKYLLGEILRNTYEATMKHYIRKGLEKPEPIIVTVVSNDESYLFRISDKAGGVLHDDENLWSFGKSKERAQESLNNFHKLPGLQTVSIYDEVHSHTKYNSKLKSLQSITLKPYMHTSLEPMSYPSIINGHIKYETPLIELLKRSFRYKLGIGLAMCKVYAEYWNGDLSLHSMPGYGTDVVLKLGNLMKHTKKLQLDKV');
INSERT INTO proteininfo VALUES ('27808705', 'NP_011390.2','Isozyme of methylenetetrahydrofolate reductase, catalyzes the reduction of 5,10-methylenetetrahydrofolate to 5-methyltetrahydrofolate in the methionine biosynthesis pathway; Met13p [Saccharomyces cerevisiae]','MKITEKLEQHRQTSGKPTYSFEYFVPKTTQGVQNLYDRMDRMYEASLPQFIDITWNAGGGRLSHLSTDLVATAQSVLGLETCMHLTCTNMPISMIDDALENAYHSGCQNILALRGDPPRDAENWTPVEGGFQYAKDLIKYIKSKYGDHFAIGVAGYPECHPELPNKDVKLDLEYLKQKIDAGGDFIITQMFYDVDNFINWCSQVRAAGMDVPIIPGIMPITTYAAFLRRAQWGQISIPQHFSSRLDPIKDDDELVRDIGTNLIVEMCQKLLDSGYVSHLHIYTMNLEKAPLMILERLNILPTESEFNAHPLAVLPWRKSLNPKRKNEEVRPIFWKRRPYSYVARTSQWAVDEFPNGRFGDSSSPAFGDLDLCGSDLIRQSANKCLELWSTPTSINDVAFLVINYLNGNLKCLPWSDIPINDEINPIKAHLIELNQHSIITINSQPQVNGIRSNDKIHGWGPKDGYVYQKQYLEFMLPKTKLPKLIDTLKNNEFLTYFAIDSQGDLLSNHPDNSKSNAVTWGIFPGREILQPTIVEKISFLAWKEEFYHILNEWKLNMNKYDKPHSAQFIQSLIDDYCLVNIVDNDYISPDDQIHSILLSL');
INSERT INTO proteininfo VALUES ('27808704', 'NP_011332.2','needed for Meiotic Nuclear Divisions; Mnd1p [Saccharomyces cerevisiae]','MGPKRQTVSLQEKKNRILNFFQETYTFYNIKELEKSIPKKCGISPMIVKDLVQQMIDEDGVISVEKCGNINIYWCFKNQTLQKLYDSSELIKKKIQEVKCDIATYKQELDKTLATGRRKKFTVGQKSYNREALLEKRKKIQDEIKKKSNSLQKIESIRWDAAKIQENKQQIRLKKVHLEKTTDNIEILIDYLYKKFFLKPEQIRKEFGIPEEFKEFTEV');
INSERT INTO proteininfo VALUES ('27808702', 'NP_009656.2','endonuclease; Mms4p [Saccharomyces cerevisiae]','MSQIVDFVEDKDSRNDASIQIIDGPSNVEIIALSESMDQDECKRAHVSSAEMIPSSPQRKSVSNDVENVDLNKSIELSAPFFQDISISKLDDFSTTVNSIIDSSLRNENNAKGNAKKLLDDLISDEWSADLESSGKKHNKSQYNLRDIAEKWGVQSLKNPEPIAVDCEYKTQGIGKTNSDISDSPKSQIGAADILFDFPLSPVKHENPTEEKHNSIANENSSPDNSLKPAGKQNHGEDGTSMAKRVYNKGEDEQEHLPKGKKRTIALSRTLINSTKLPDTVELNLSKFLDSSDSITTDVLSTPAKGSNIVRTGSQPIFSNANCFQEAKRSKTLTAEDPKCTKNTAREVSQLENYIAYGQYYTREDSKNKIRHLLKENKNAFKRVNQIYRDNIKARSQMIIEFSPSLLQLFKKGDSDLQQQLAPAVVQSSYNDSMPLLRFLRKCDSIYDFSNDFYYPCDPKIVEENVLILYYDAQEFFEQYTSQKKELYRKIRFFSKNGKHVILILSDINKLKRAIFQLENEKYKARVEQRLSGTEEALRPRSKKSSQVGKLGIKKFDLEQRLRFIDREWHVKIHTVNSHMEFINSLPNLVSLIGKQRMDPAIRYMKYAHLNVKSAQDSTETLKKTFHQIGRMPEMKANNVVSLYPSFQSLLEDIEKGRLQSDNEGKYLMTEAVEKRLYKLFTCTDPNDTIE');
INSERT INTO proteininfo VALUES ('27808701', 'NP_009643.2','Plasma membrane protein that may be involved in osmotolerance, localizes to the mother cell in small-budded cells and to the bud in medium- and large-budded cells; mRNA is transported to the bud tip by an actomysin-driven process; Ist2p [Saccharomyces cerevisiae]','MSQTITSLDPNCVIVFNKTSSANEKSLNVEFKRLNIHSIIEPGHDLQTSYAFIRIHQDNAKPLFSFLQNLDFIESIIPYHDTELSDDLHKLISISKSKILEAPKQYELYNLSNLTNNPKQSLYFAFLQNYIKWLIPFSFFGLSIRFLSNFTYEFNSTYSLFAILWTLSFTAFWLYKYEPFWSDRLSKYSSFSTIEFLQDKQKAQKKASSVIMLKKCCFIPVALLFGAILLSFQLYCFALEIFIKQIYNGPMISILSFLPTILICTFTPVLTVIYNKYFVEPMTKWENHSSVVNAKKSKEAKNFVIIFLSSYVPLLITLFLYLPMGHLLTAEIRTKVFNAFSILARLPTHDSDFIIDTKRYEDQFFYFIVINQLIQFSMENFVPSLVSIAQQKINGPNPNFVKAESEIGKAQLSSSDMKIWSKVKSYQTDPWGATFDLDANFKKLLLQFGYLVMFSTIWPLAPFICLIVNLIVYQVDLRKAVLYSKPEYFPFPIYDKPSSVSNTQKLTVGLWNSVLVMFSILGCVITATLTYMYQSCNIPGVGAHTSIHTNKAWYLANPINHSWINIVLYAVFIEHVSVAIFFLFSSILKSSHDDVANGIVPKHVVNVQNPPKQEVFEKIPSPEFNSNNEKELVQRKGSANEKLHQELGEKQPASSANGYEAHAATHANNDPSSLSSASSPSLSSSSSSSKTGVVKAVDNDTAGSAGKKPLATESTEKRNSLVKVPTVGSYGVAGATLPETIPTSKNYYLRFDEDGKSIRDAKSSAESSNATNNNTLGTESKLLPDGDAVDALSRKIDQIPKIAVTGGENNENTQAKDDAATKTPLIKDANIKPVVNAAVNDNQSKVSVATEQTKKTEVSTKNGPSRSISTKETKDSARPSNNNTTTTTTTDATQPHHHHHHHRHRDAGVKNVTNNSKTTESSSSSSAAKEKPKHKKGLLHKLKKKL');
INSERT INTO proteininfo VALUES ('27469362', 'NP_010782.2','Mitochondrial ribosomal protein of the small subunit; Rsm28p [Saccharomyces cerevisiae]','MRSSMFRCVSRAHYSTSVTEDFINSILARAQEATAKASSNALKLDKMKEGRMQNKRRNGNQNRNSMNNKESRGREGNQGERNMRLKNRSSDSVRANKQQWNKGANTSFVKNPTGNTVVMQPQFKKMQNGKNNLKGDARVEDDLLDVFNSSMEQKPVNFNGTPKSKARFQKKSHILTASKRRKAPQQQLQKVIKRPVSSEYVLEEPTPLSLLEYTPQVFPTKESRLVNFTLDSLKKSNYPIYRSPNLGILKVHDFTLNTPNFGKYTPGSSLIFAKEPQLQNLLIEEDPEDFHRQVTGEYQLLKPYVKKDFEKLTKSKDTVSKLVQNSQVVRLSLQSVVMGSEEKKLVYDVCSGMKPISELQQ');
INSERT INTO proteininfo VALUES ('27469361', 'NP_010612.2','Yeast Condensin G; Ycg1p [Saccharomyces cerevisiae]','MQDPDGIDINTKIFNSVAEVFQKAQGSYAGHRKHIAVLKKIQSKAVEQGYEDAFNFWFDKLVTKILPLKKNEIIGDRIVKLVAAFIASLERELILAKKQNYKLTNDEEGIFSRFVDQFIRHVLRGVESPDKNVRFRVLQLLAVIMDNIGEIDESLFNLLILSLNKRIYDREPTVRIQAVFCLTKFQDEEQTEHLTELSDNEENFEATRTLVASIQNDPSAEVRRAAMLNLINDNNTRPYILERARDVNIVNRRLVYSRILKSMGRKCFDDIEPHIFDQLIEWGLEDRELSVRNACKRLIAHDWLNALDGDLIELLEKLDVSRSSVCVKAIEALFQSRPDILSKIKFPESIWKDFTVEIAFLFRAIYLYCLDNNITEMLEENFPEASKLSEHLNHYILLRYHHNDISNDSQSHFDYNTLEFIIEQLSIAAERYDYSDEVGRRSMLTVVRNMLALTTLSEPLIKIGIRVMKSLSINEKDFVTMAIEIINDIRDDDIEKQEQEEKIKSKKINRRNETSVDEEDENGTHNDEVNEDEEDDNISSFHSAVENLVQGNGNVSESDIINNLPPEKEASSATIVLCLTRSSYMLELVNTPLTENILIASLMDTLITPAVRNTAPNIRELGVKNLGLCCLLDVKLAIDNMYILGMCVSKGNASLKYIALQVIVDIFSVHGNTVVDGEGKVDSISLHKIFYKVLKNNGLPECQVIAAEGLCKLFLADVFTDDDLFETLVLSYFSPINSSNEALVQAFAFCIPVYCFSHPAHQQRMSRTAADILLRLCVLWDDLQSSVIPEVDREAMLKPNIIFQQLLFWTDPRNLVNQTGSTKKDTVQLTFLIDVLKIYAQIEKKEIKKMIITNINAIFLSSEQDYSTLKELLEYSDDIAENDNLDNVSKNALDKLRNNLNSLIEEINERSETQTKDENNTANDQYSSILGNSFNKSSNDTIEHAADITDGNNTELTKTTVNISAVDNTTEQSNSRKRTRSEAEQIDTSKNLENMSIQDTSTVAKNVSFVLPDEKSDAMSIDEEDKDSESFSEVC');
INSERT INTO proteininfo VALUES ('27469359', 'NP_009388.2','Endosomal SNARE related to mammalian syntaxin 8; Syn8p [Saccharomyces cerevisiae]','MDVLKLGYELDQLSDLVEERTRLVSVLKLAPTSNDNVTLKRQLGSILELLQKCAPNDELISRYNTILDKIPDTAVDKELYRFQQQVARNTDEVSKESLKKVRFKNDDELTVMYKDDDEQDEESPLPSTHTPYKDEPLQSQLQSQSQPQPPQPMVSNQELFINQQQQLLEQDSHLGALSQSIGRTHDISLDLNNEIVSQNDSLLVDLENLIDNNGRNLNRASRSMHGFNNSRFKDNGNCVIILVLIVVLLLLLLVL');
INSERT INTO proteininfo VALUES ('27469358', 'NP_009379.2','Transfers mannosyl residues from dolichyl phosphate-D-mannose to seryl and threonyl residues in proteins; acts in complex with Pmt1p; dolichyl phosphate-D-mannose:protein O-D-mannosyltransferase; Pmt2p [Saccharomyces cerevisiae]','MSSSSSTGYSKNNAAHIKQENTLRQRESSSISVSEELSSADERDAEDFSKEKPAAQSSLLRLESVVMPVIFTALALFTRMYKIGINNHVVWDEAHFGKFGSYYLRHEFYHDVHPPLGKMLVGLSGYLAGYNGSWDFPSGEIYPDYLDYVKMRLFNASFSALCVPLAYFTAKAIGFSLPTVWLMTVLVLFENSYSTLGRFILLDSMLLFFTVASFFSFVMFHNQRSKPFSRKWWKWLLITGISLGCTISVKMVGLFIITMVGIYTVIDLWTFLADKSMSWKTYINHWLARIFGLIIVPFCIFLLCFKIHFDLLSHSGTGDANMPSLFQARLVGSDVGQGPRDIALGSSVVSIKNQALGGSLLHSHIQTYPDGSNQQQVTCYGYKDANNEWFFNRERGLPSWSENETDIEYLKPGTSYRLVHKSTGRNLHTHPVAAPVSKTQWEVSGYGDNVVGDNKDNWVIEIMDQRGDEDPEKLHTLTTSFRIKNLEMGCYLAQTGNSLPEWGFRQQEVVCMKNPFKRDKRTWWNIETHENERLPPRPEDFQYPKTNFLKDFIHLNLAMMATNNALVPDPDKFDYLASSAWQWPTLNVGLRLCGWGDDNPKYFLLGTPASTWASSVAVLAFMATVVILLIRWQRQYVDLRNPSNWNVFLMGGFYPLLAWGLHYMPFVIMSRVTYVHHYLPALYFALIILAYCFDAGLQKWSRSKCGRIMRFVLYAGFMALVIGCFWYFSPISFGMEGPSSNFRYLNWFSTWDIADKQEA');
INSERT INTO proteininfo VALUES ('24416034', 'NP_710144.1','Essential protein, component of the DASH complex; involved in spindle integrity and kinetochore function; interacts with Duo1p and Dam1p; localizes to intranuclear spindles and kintechore; Dad4p [Saccharomyces cerevisiae]','MENPHEQVQANILSRIIGNVKRLNESVAILNQELVTINNRNKNLEIMGAICDNYHSSVQFNLEATNNKKPPL');
INSERT INTO proteininfo VALUES ('23270401', 'NP_690847.1','Ypr036w-ap [Saccharomyces cerevisiae]','MVAFLELTSDVSQPFVIPSLSPVSQPSSRKNSDANVDDLNLAIANAALLDASASSRSHSRKNSLSLL');
INSERT INTO proteininfo VALUES ('23270400', 'NP_690846.1','Endoplasmic reticulum membrane protein that binds to and inhibits GTP-bound Ras2p at the ER; component of the GPI-GnT complex which catalyzes the first step in GPI-anchor biosynthesis; Eri1p [Saccharomyces cerevisiae]','MRPRDQGFLVLGFTYSVLLISLATFYWLRNNDSFLHYWCVLLLCPATLWLWALIAWCDSEMFASSKDE');
INSERT INTO proteininfo VALUES ('23270399', 'NP_690845.1','Mitochondrial protein of unknown function, overexpression suppresses an rpo41 mutation affecting mitochondrial RNA polymerase; encoded within the the 25S rRNA gene on the opposite strand; Tar1p [Saccharomyces cerevisiae]','MRDSPTHKEQRAQNTMSDQMPFPFNNFTYFFTLFSKFFSSFHHCTCSLSVSRQYLALDGIYHPLRAAFPNNSTLRRHFTKNRTPRHTGFSPSMTSCSKEHRQGTAPKLPSPNYNSGTEGTRFQI');
INSERT INTO proteininfo VALUES ('23270398', 'NP_690844.1','Protein of unknown function; Hsk3p [Saccharomyces cerevisiae]','MNANKQRQYNQLAHELRELQTNLQETTKQLDIMSKQCNENLVGQLGKVHGSWLIGSYIYYMEQMLGKTQ');
INSERT INTO proteininfo VALUES ('22532998', 'NP_683716.1','Cytosolic protein required for sporulation; Rmd8p [Saccharomyces cerevisiae]','MSYKANQPSPGEMPKRSPSILVTDARTSKNRMSAPFAGHAAGSRKNMENAGVTKSQGVRSSAIGPSPLQSFTHPRRRSSGRFSDISIDNILSDNSDIPSARREERLSSSSSDRPRQYERLSSRRKMINPLPPRTSKTSQKLVLIPEDDNLNHFQTLPTNALDRQRPKVGSMKSNSFDRLPRYSKEKSMARITAYNVADGFNLNQLYKFLQETHEVSPRLYDECLYVAYTLPLLPGKGGFRIKSNLSKKTMGGKTLIDNLIDTSEQRDHHYEYYSGVETVEDANNNYELETSGNNNNANQDTTTVPDHLPNPVGQQDSFNPMEPQFFAEETPLEIEKRERTERINMLKKEENDSDASCGNDNNNKNNDKSKLYAVEGNDQYVQSSRSPASPSSISTPSPPSSSQNDFDRVYKMHRDNDHEGNDRHAEIFIFHYGVIVFWNFTEIQEKNILGDITFADYKNLMIRPLDEQDIETEQFHFEYDRDTERPRIFNDIVTLRSGDHIIELTLSHAIAQSSKLSRFESRISPILISVTKLPKRLALYGTLGLKREQLLKKSGKLFKLRVDVNLSSTILDTPEFFWSFEPSLHPLYVAMREYLEIDQRVQVLNDRCKVFLEFFDICVDSVAERNMARVTWWFILVILFGVIFSLTEIFVRYVIIHRHTST');
INSERT INTO proteininfo VALUES ('22532997', 'NP_683715.1','Protein involved in bud-site selection, nutrient signaling, and gene expression controlled by the TOR kinase; diploid mutants display a random budding pattern instead of the wild-type bipolar pattern; Bud27p [Saccharomyces cerevisiae]','MDLLAASVESTLKNLQDKRNFLSEQREHYIDIRSRLVRFINDNDDGEEEGEGQGMVFGDIIISTSKIYLSLGYEYYVEKTKEEAITFVDDKLKLMEDAIEQFNLKIEEAKKTLDNLNHMEDGNGIEEDEANNDEDFLPSMEIREELDDEGNVISSSVTPTTKQPSQSNSKKEQTPAVGPKEKGLAKEKKSKSFEENLKGKLLKRNDEVKKKVQPSKVDTENVYTFADLVQQMDQQDELEDGYIETDEINYDYDAFENSNFKVNDNYEEDDEDEDEEEYLNHSIIPGFEAQSSFLQQIQRLRAQKQSQDHEREEGDVNKSLKPILKKSSFAENSDKKQKKKQVGFASSLEIHEVENLKEENKRQMQSFAVPMYETQESTGIANKMTSDEFDGDLFAKMLGVQEADEVHEKYKEELINQERLEGEASRSNRRTRVSRFRKDRASKKENTLSTFKQETTRSVENEVVEKEPVVGDIIEKEPVVGDVIEKEPVVGDVIEKEPAVTDIVEREPAVNDIVERKPVVGDIIEKEPTINDIVEKEPEINSKSEFETPFKKKKLKSLQKPRSSKSMKKKFDPKILENISDDDYDDDDDGNKKLLSNKSKNNTDEQDKFPSKIQEVSRSMAKTGATVGSEPVRITNVDYHALGGNLDDMVKAYSLGLYDDDLEEDPGTIVEKLEDFKEYNKQVELLRDEIRDFQLENKPVTMEEEENDGNVMNDIIEHEFPESYTNDEDEVALHPGRLQEEVAIEYRRLKEATASKWQSSSPAAHTEGELEPIDKFGNPVKTSRFRSQRLHMDSKP');
INSERT INTO proteininfo VALUES ('21648335', 'NP_660100.1','Similar to Hemiascomycetous yeast protein (FEBS Lett. 487(1): 31-36 (2000)).; Kti11p [Saccharomyces cerevisiae]','MSTYDEIEIEDMTFEPENQMFTYPCPCGDRFQIYLDDMFEGEKVAVCPSCSLMIDVVFDKEDLAEYYEEAGIHPPEPIAAAA');
INSERT INTO proteininfo VALUES ('21450619', 'NP_631876.1','Essential protein, component of the DASH complex; involved in spindle integrity and kinetochore function; interacts with Duo1p and Dam1p; localizes to intranuclear spindles and kintechore; Dad3p [Saccharomyces cerevisiae]','MEHNLSPLQQEVLDKYKQLSLDLKALDETIKELNYSQHRQQHSQQETVSPDEILQEMRDIEVKIGLVGTLLKGSVYSLILQRKQEQESLGSNSK');
INSERT INTO proteininfo VALUES ('20336770', 'NP_620389.1','TyB Gag-Pol protein; proteolytically processed to make the Gag, RT, PR, and IN proteins that are required for retrotransposition; Yor343w-bp [Saccharomyces cerevisiae]','MESQQLHQNPHCPHGSAYASVTSKEVPSNQDPLAVSASNLPEFDRDSTKVNSQEETTPGTSAVPENHHHVSPQPASVPPPQNGQYQQHGMMTPNKAMASNWAHYQQPSMMTCSHYQTSPAYYQPDPHYPLPQYIPPLSTSSPDPIDSQDQHSEVPQAKTKVRNNVLPPHPHTSEENFSTWVKFYIRFLKNSNLGDIIPNDQGEIKRQMTYEEHAYIYNTFQAFAPFHLLPTWVKQILEINYSDILTVLCKSVSKMQTNNQELKDWIALANLEYNGSTSADTFEITVSTIIQRLKENNINVSDRLACQLILKGLSGDFKYLRNQYRTKTNMKLSQLFAEIQLIYDENKIMNLNKPSQYKQHSEYKNVSRTSPNTTNTKVTTRNYHRTNSSKPRAAKAHNIATSSKFSRVNNDHINESTVSSQYLSDDNELSLSQQQKESKPTRTIDSNDELPDHLLIDSGASQTLVRSAHYLHHATPNSEINIVDAQKQDIPINAIGNLHFNFQNGTKTSIKALHTPNIAYDLLSLSELTNQNITACFTRNTLERSDGTVLAPIVKHGDFYWLSKKYLIPSHISKLTINNVNKSKSVNKYPYPLIHRMLGHANFRSIQKSLKKNAVTYLKESDIEWSNASTYQCPDCLIGKSTKHRHVKGSRLKYQESYEPFQYLHTDIFGPVHHLPKSAPSYFISFTDEKTRFQWVYPLHDRREESILNVFTSILAFIKNQFNARVLVIQMDRGSEYTNKTLHKFFTNRGITACYTTTADSRAHGVAERLNRTLLNDCRTLLHCSGLPNHLWFSAVEFSTIIRNSLVSPKNDKSARQHAGLAGLDITTILPFGQPVIVNNHNPDSKIHPRGIPGYALHPSRNSYGYIIYLPSLKKTVDTTNYVILQNNQTKLDQFDYDTLTFDDDLNRLTAHNQSFIEQNETEQSYDQNTESDHDYQSEIEINSDPLVNDFSSQSLNPLQLDKEPVQKVRAPKEVDADISEYNILPSTIRSRTPHIINKESTEMGGTIESDTTSPRHSSTFTARNQKRPGSPNDMIDLTSQDRVNYGLENIKTTRLGGTEEPYIQRNSDTNIKYRTTNSTPSIDDRSSNSDSTTPIISIETKAACDNTPSIDTDPPEYRSSDHATPNIMPDKSSKNVTADSILDDLPLPDLTHKSPTDTSDVSKDIPHIHSRQTNSSLGGMDDSNVLTTTKSKKRSLEDNETEIEVSRDTWNNKNMRSLEPPRSKKRINLIAAIKGVKSIKPVRTTLRYDEAITYNKDNKEKDRYVEAYHKEISQLLKMNTWDTNKYYDRNDIDPKKVINSMFIFNKKRDGTHKARFVARGDIQHPDTYDSDMQSNTVHHYALMTSLSIALDNDYYITQLDISSAYLYADIKEELYIRPPPHLGLNDKLLRLRKSLYGLKQSGANWYETIKSYLINCCDMQEVRGWSCVFKNSQVTICLFVDDMILFSKDLNANKKIITTLKKQYDTKIINLGEGDNEIQYDILGLEIKYQRSKYMKLGMEKSLTEKLPKLNVPLNPKGKKLRAPGQPGHYIDQDELEIDEDEYKEKVHEMQKLIGLASYVGYKFRFDLLYYINTLAQHILFPSRQVLDMTYELIQFMWDTRDKQLIWHKNKPTKPDNKLVAISDASYGNQPYYKSQIGNIFLLNGKVIGGKSTKASLTCTSTTEAEIHAVSEAIPLLNNLSHLVQELNKKPIIKGLLTDSRSTISIIKSTNEEKFRNRFFGTKAMRLRDEVSGNNLYVYYIETKKNIADVMTKPLPIKTFKLLTNKWIH');
INSERT INTO proteininfo VALUES ('20336769', 'NP_620390.1','TyA Gag protein; the main structural constituent of virus-like particles (VLPs); Yor343w-ap [Saccharomyces cerevisiae]','MESQQLHQNPHCPHGSAYASVTSKEVPSNQDPLAVSASNLPEFDRDSTKVNSQEETTPGTSAVPENHHHVSPQPASVPPPQNGQYQQHGMMTPNKAMASNWAHYQQPSMMTCSHYQTSPAYYQPDPHYPLPQYIPPLSTSSPDPIDSQDQHSEVPQAKTKVRNNVLPPHPHTSEENFSTWVKFYIRFLKNSNLGDIIPNDQGEIKRQMTYEEHAYIYNTFQAFAPFHLLPTWVKQILEINYSDILTVLCKSVSKMQTNNQELKDWIALANLEYNGSTSADTFEITVSTIIQRLKENNINVSDRLACQLILKGLSGDFKYLRNQYRTKTNMKLSQLFAEIQLIYDENKIMNLNKPSQYKQHSEYKNVSRTSPNTTNTKVTTRNYHRTNSSKPRAAKAHNIATSSKFSRVNNDHINESTVSSQYLSDDNELSLRPATERI');
INSERT INTO proteininfo VALUES ('20336768', 'NP_620388.1','TyA Gag protein; the main structural constituent of virus-like particles (VLPs); Ydr210c-cp [Saccharomyces cerevisiae]','MESQQLSNYPHISHGSACASVTSKEVHTNQDPLDVSASKIQEYDKASTKANSQQTTTPASSAVPENPHHASPQPASVPPPQNGPYPQQCMMTQNQANPSGWSFYGHPSMIPYTPYQMSPMYFPPGPQSQFPQYPSSVGTPLSTPSPESGNTFTDSSSADSDMTSTKKYVRPPPMLTSPNDFPNWVKTYIKFLQNSNLGGIIPTVNGKPVRQITDDELTFLYNTFQIFAPSQFLPTWVKDILSVDYTDIMKILSKSIEKMQSDTQEANDIVTLANLQYNGSTPADAFETKVTNIIDRLNNNGIHINNKVACQLIMRGLSGEYKFLRYTRHRHLNMTVAELFLDIHAIYEEQQGSRNSKPNYRRNRSDEKNDSRSYTNTTKPKVIARNPQKTNNSKSKTARAHNVSTSINSPSTDNDSISKSTTEPIQLNNKHDLHLRPETY');
INSERT INTO proteininfo VALUES ('20336767', 'NP_620387.1','TyB Gag-Pol protein; proteolytically processed to make the Gag, RT, PR, and IN proteins that are required for retrotransposition; Ydr210c-dp [Saccharomyces cerevisiae]','MESQQLSNYPHISHGSACASVTSKEVHTNQDPLDVSASKIQEYDKASTKANSQQTTTPASSAVPENPHHASPQPASVPPPQNGPYPQQCMMTQNQANPSGWSFYGHPSMIPYTPYQMSPMYFPPGPQSQFPQYPSSVGTPLSTPSPESGNTFTDSSSADSDMTSTKKYVRPPPMLTSPNDFPNWVKTYIKFLQNSNLGGIIPTVNGKPVRQITDDELTFLYNTFQIFAPSQFLPTWVKDILSVDYTDIMKILSKSIEKMQSDTQEANDIVTLANLQYNGSTPADAFETKVTNIIDRLNNNGIHINNKVACQLIMRGLSGEYKFLRYTRHRHLNMTVAELFLDIHAIYEEQQGSRNSKPNYRRNRSDEKNDSRSYTNTTKPKVIARNPQKTNNSKSKTARAHNVSTSINSPSTDNDSISKSTTEPIQLNNKHDLHLGQKLTESTVNHTNHSDDELPGHLLLDSGASRTLIRSAHHIHSASSNPDINVVDAQKRNIPINAIGDLQFHFQDNTKTSIKVLHTPNIAYDLLSLNELAAVDITACFTKNVLERSDGTVLAPIVKYGDFYWVSKKYLLPSNISVPTINNVHTSESTRKYPYPFIHRMLAHANAQTIRYSLKNNTITYFNESDVDWSSAIDYQCPDCLIGKSTKHRHIKGSRLKYQNSYEPFQYLHTDIFGPVHNLPNSAPSYFISFTDETTKFRWVYPLHDRREDSILDVFTTILAFIKNQFQASVLVIQMDRGSEYTNRTLHKFLEKNGITPCYTTTADSRAHGVAERLNRTLLDDCRTQLQCSGLPNHLWFSAIEFSTIVRNSLASPKSKKSARQHAGLAGLDISTLLPFGQPVIVNDHNPNSKIHPRGIPGYALHPSRNSYGYIIYLPSLKKTVDTTNYVILQGKDSRLDQFNYDALTFDEDLNRLTASYQSFIASNEIQQSNDLNIESDHDFQSDIELYPEQPRNVLSKAVSPTDSTPPSTHTEDSKRVSKTNIRAPREVDPNISESNILPSKKRSSTPQISDIESTDSGGMHRLDVPLLAPMSQSNTHESSYASKSKDFRHSDSYSENETNHTNVPISSTGGTNNKTVPQISDQETEKRIIHRSPSIDASPPENNSSHNIVPIKTPTTVSEQNTEESIIADLPLPDLPPESPTEFPDPFKELPPINSHQTNSSLGGIGDSNAYTTINSKKRSLEDNETEIKVSRDTWNTKNMRSLEPPRSKKRIHLIAAVKAVKSIKPIRTTLRYDEAITYNKDIKEKEKYIEAYHKEVNQLLKMNTWDTDKYYDRKEIDPKRVINSMFIFNKKRDGTHKARFVARGDIQHPDTYDTGMQSNTVHHYALMTSLSLALDNNYYITQLDISSAYLYADIKEELYIRPPPHLGMNDKLIRLKKSLYGLKQSGANWYETIKSYLIKQCGMEEVRGWSCVFKNSQVTICLFVDDMILFSKDLNANKKIITTLKKQYDTKIINLGESDNEIQYDILGLEIKYQRGKYMKLGMEKSLTEKLPKLNVPLNPKGKKLRAPGQPGHYIDQDELEIDEDEYKEKVHEMQKLIGLASYVGYKFRFDLLYYINTLAQHILFPSRQVLDMTYELIQFMWDTRDKQLIWHKNKPTKPDNKLVAISDASYGNQPYYKSQIGNIFLLNGKVIGGKSTKASLTCTSTTEAEIHAVSEAIPLLNNLSHLVQELNKKPIIKGLLTDSRSTISIIKSTNEEKFRNRFFGTKAMRLRDEVSGNNLYVYYIETKKNIADVMTKPLPIKTFKLLTNKWIH');
INSERT INTO proteininfo VALUES ('19705600', 'NP_602317.1','Quinolinate phosphoribosyl transferase, required for biosynthesis of nicotinic acid from tryptophan via kynurenine pathway; Bna6p [Saccharomyces cerevisiae]','MPVYEHLLPVNGAWRQDVTNWLSEDVPSFDFGGYVVGSDLKEANLYCKQDGMLCGVPFAQEVFNQCELQVEWLFKEGSFLEPSKNDSGKIVVAKITGPAKNILLAERTALNILSRSSGIATASHKIISLARSTGYKGTIAGTRKTTPGLRRLEKYSMLVGGCDTHRYDLSSMVMLKDNHIWATGSITNAVKNARAVCGFAVKIEVECLSEDEATEAIEAGADVIMLDNFKGDGLKMCAQSLKNKWNGKKHFLLECSGGLNLDNLEEYLCDDIDIYSTSSIHQGTPVIDFSLKLAH');
INSERT INTO proteininfo VALUES ('18702303', 'NP_570898.1','WW domain containing protein interacting with Metacaspase (MCA1); Wwm1p [Saccharomyces cerevisiae]','MAQSKSNPPQVPSGWKAVFDDEYQTWYYVDLSTNSSQWEPPRGTTWPRPKGPPPGVNNEKSSRQQADQAPPPYSSQSTPQVQAGAQAQQPRYYQPQQPQYPQYPQQQRYYPQQAPMPAAAPQQAYYGTAPSTSKGSGHGGAMMGGLLGVGAGLLGGAMLEHAFDDHNYDGPDTVVVENNYYGDDAGGSDGGFDDAGGFDGGFDDGFDGSDF');
INSERT INTO proteininfo VALUES ('16740527', 'NP_444297.1','Phosphatidylinositol 3,5-bisphosphate-binding protein of the vacuolar membrane, predicted to fold as a seven-bladed beta-propeller; required for recycling of Atg9p through the pre-autophagosomal structure; Atg18p [Saccharomyces cerevisiae]','MSDSSPTINFINFNQTGTCISLGTSKGFKIFNCEPFGKFYSEDSGGYAIVEMLFSTSLLALVGIGDQPALSPRRLRIINTKKHSIICEVTFPTSILSVKMNKSRLVVLLQEQIYIYDINTMRLLHTIETNPNPRGLMAMSPSVANSYLVYPSPPKVINSEIKAHATTNNITLSVGGNTETSFKRDQQDAGHSDISDLDQYSSFTKRDDADPTSSNGGNSSIIKNGDVIVFNLETLQPTMVIEAHKGEIAAMAISFDGTLMATASDKGTIIRVFDIETGDKIYQFRRGTYATRIYSISFSEDSQYLAVTGSSKTVHIFKLGHSMSNNKLDSDDSNMEEAAADDSSLDTTSIDALSDEENPTRLAREPYVDASRKTMGRMIRYSSQKLSRRAARTLGQIFPIKVTSLLESSRHFASLKLPVETNSHVMTISSIGSPIDIDTSEYPELFETGNSASTESYHEPVMKMVPIRVVSSDGYLYNFVMDPERGGDCLILSQYSILMD');
INSERT INTO proteininfo VALUES ('16740526', 'NP_444296.1','GTPase-activating protein for yeast Rab family members; Ypt1p is the preferred in vitro substrate but also acts on Sec4p, Ypt31p and Ypt32p; involved in the regulation of ER to Golgi vesicle transport; Gyp8p [Saccharomyces cerevisiae]','MPLRSLFHTNQSSHDKDALTRGGYNAYLESLSRCDSGKAEEQKGKVISKLLEKKDVRALRYIGLGPLGFVNNSLRKDCWYELLASQLLIDDATEYITPVEKHKDEGQVILDAERSFGGIVDKNLKLQLRKLLVELITRVLRKYPTLNYYQGYHDIVSVFIMCFSWNVTKENGLELENLSLQEEIDMERLFYCIEAFTLLYLRDFMMNSLDFSFEQLRVISSLIKESNMKFYNLFKFDENEPLFAIGSILTIFAHNLKPIDSGDNNLHKILFQIFDMTISMQSMRLPLIIYKNLLLQNASEISKQIEANSDFFENDFDLRHGAIQTVLQKKLYDEALWEEVLQITRKDATTASKKALKRVSLNKYSALLNTACGKPGCFDMSTIIFYLSEQTKMNEHYKEEKYHGVAARSKTRALVQRLGHFLPSKYNRWSKISLLIGIVAILYQLRTTRSLSLVLNLRYMISTKLKDLSHININLHHVSHIWVDPIRDILKLGHPTR');
INSERT INTO proteininfo VALUES ('16198342', 'NP_428268.1','specific GTPase activating protein (RhoGAP); Rgd2p [Saccharomyces cerevisiae]','MLSFCDYFWSEDLVSGLDVLFDRLYHGCEQCDLFIQLFASRMQFEVSHGRQLFGIEAGMDNLKAVQEDEDEGVTVSRALRGILQEMSQEGTHHLTIASNIESLVLQPFSKWCIEHRERIQYSEKTLLTNVNNFRKSKKYVGKLEKEYFNKCRQLEEFKRTHFNEDELANAMKSLKIQNKYEEDVAREKDHRFFNRIAGIDFDYKTMKETLQLLLTKLPKTDYKLPLISYSLSNTNNGGEITKFLLDHMSLKDIDQAETFGQDLLNLGFLKYCNGVGNTFVNSKKFQYQWKNTAYMFANVPMPGSEEPTTGESLISRFNNWDGSSAKEIIQSKIGNDQGAAKIQAPHISDNERTLFRMMDALAASDKKYYQECFKMDALRCSVEELLIDHLSFMEKCESDRLNAIKKATLDFCSTLGNKISSLRLCIDKMLTLENDIDPTADLLQLLVKYKTGSFKPQAIVYNNYYNPGSFQNFGVDLETRCRLDKKVVPLIISSIFSYMDKIYPDLPNDKVRTSIWTDSVKLSLTHQLRNLLNKQQFHNEGEIFDILSTSKLEPSTIASVVKIYLLELPDPLIPNDVSDILRVLYLDYPPLVETALQNSTSSPENQQDDDNEEGFDTKRIRGLYTTLSSLSKPHIATLDAITTHFYRLIKILKMGENGNEVADEFTVSISQEFANCIIQSKITDDNEIGFKIFYDLLTHKKQIFHELKRQNSKN');
INSERT INTO proteininfo VALUES ('15530185', 'NP_219498.1','Protein involved in the Mec1p-mediated checkpoint pathway that responds to DNA damage or replication arrest, transcription is induced by DNA damage; Hug1p [Saccharomyces cerevisiae]','MTMDQGLNPKQFFLDDVVLQDTLCSMSNRVNKSVKTGYLFPKDHVPSANIIAVERRGGLSDIGKNTSN');
INSERT INTO proteininfo VALUES ('15530184', 'NP_219497.1','LAs17 Binding protein; Lsb3p [Saccharomyces cerevisiae]','MGINNPIPRSLKSETNFVKPNQVFGADQVIPPDVLKRAKGLAIITILKAGFLFSGRAGSGVIVARLKDGTWSAPSAIAMAGAGAGGMVGIELTDFVFILNTQDAVKSFSEFGTITLGGNVSVSAGPLGRSAEAAASASAGGVAAVFAYSKSKGLFAGVSVEGSAIIERREANRKFYGDNCTAKMILSGRIRPPPAVDPLFRVLESRAFNYRPSNGGRGSFDDDEDDYYDDDDYYNDIPSSFSSTDASSTRPNTRSTRRRAQSGSRYTFDDDDDDDDYGTGYSRNSRLAPTNSGGSGGKLDDPSGASSYYASHRRSGTAQSRARSSRNRWADDEYDDYDDDYESGYRRGNGRDRTKDREVDDLSNRFSKSRISSASTPQTSQGRFTAPTSPSTSSPKAVALYSFAGEESGDLPFRKGDVITILKKSDSQNDWWTGRVNGREGIFPANYVELV');
INSERT INTO proteininfo VALUES ('14627173', 'NP_012514.2','Protein possibly involved in assembly of actin patches; interacts with an actin assembly factor Las17p and with the SH3 domains of Type I myosins Myo3p and Myo5p; localized predominantly to cortical actin patches; Bbc1p [Saccharomyces cerevisiae]','MSEPEVPFKVVAQFPYKSDYEDDLNFEKDQEIIVTSVEDAEWYFGEYQDSNGDVIEGIFPKSFVAVQGSEVGKEAESSPNTGSTEQRTIQPEVEQKDLPEPISPETKKETLSGPVPVPAATVPVPAATVPVPAATAVSAQVQHDSSSGNGERKVPMDSPKLKARLSMFNQDITEQVPLPKSTHLDLENIPVKKTIVADAPKYYVPPGIPTNDTSNLERKKSLKENEKKIVPEPINRAQVESGRIETENDQLKKDLPQMSLKERIALLQEQQRLQAAREEELLRKKAKLEQEHERSAVNKNEPYTETEEAEENEKTEPKPEFTPETEHNEEPQMELLAHKEITKTSREADEGTNDIEKEQFLDEYTKENQKVEESQADEARGENVAEESEIGYGHEDREGDNDEEKEEEDSEENRRAALRERMAKLSGASRFGAPVGFNPFGMASGVGNKPSEEPKKKQHKEKEEEEPEQLQELPRAIPVMPFVDPSSNPFFRKSNLSEKNQPTETKTLDPHATTEHEQKQEHGTHAYHNLAAVDNAHPEYSDHDSDEDTDDHEFEDANDGLRKHSMVEQAFQIGNNESENVNSGEKIYPQEPPISHRTAEVSHDIENSSQNTTGNVLPVSSPQTRVARNGSINSLTKSISGENRRKSINEYHDTVSTNSSALTETAQDISMAAPAAPVLSKVSHPEDKVPPHPVPSAPSAPPVPSAPSVPSAPPVPPAPPALSAPSVPPVPPVPPVSSAPPALSAPSIPPVPPTPPAPPAPPAPLALPKHNEVEEHVKSSAPLPPVSEEYHPMPNTAPPLPRAPPVPPATFEFDSEPTATHSHTAPSPPPHQNVTASTPSMMSTQQRVPTSVLSGAEKESRTLPPHVPSLTNRPVDSFHESDTTPKVASIRRSTTHDVGEISNNVKIEFNAQERWWINKSAPPAISNLKLNFLMEIDDHFISKRLHQKWVVRDFYFLFENYSQLRFSLTFNSTSPEKTVTTLQERFPSPVETQSARILDEYAQRFNAKVVEKSHSLINSHIGAKNFVSQIVSEFKDEVIQPIGARTFGATILSYKPEEGIEQLMKSLQKIKPGDILVIRKAKFEAHKKIGKNEIINVGMDSAAPYSSVVTDYDFTKNKFRVIENHEGKIIQNSYKLSHMKSGKLKVFRIVARGYVGW');
INSERT INTO proteininfo VALUES ('14318582', 'NP_116715.1','Hypothetical ORF; Yfr057wp [Saccharomyces cerevisiae]','MIFGPTSVYSKCSAKSSGIIKDTAKLPISRVRIKVMLEITVSFLFFDRFPRSFLNHNLYDSICPFFAWQYTSYYLSIYRQSFLFHFLQKDFSNDFVSEELIYALVALGAKNSFDNSLSKHTYEYYNHSKRNLLEDSTNKNSAFSSASVTKP');
INSERT INTO proteininfo VALUES ('14318580', 'NP_116714.1','Hypothetical ORF; Yfr055wp [Saccharomyces cerevisiae]','MIDRTELSKFGITTQLSVIGRNPDEQSGFVNPPLYKGSTIILKKLSDLEQRKGRFYGTAGSPTIDNLENAWTHLTGGAGTVLSASGLGSISLALLALSKAGDHILMTDSVYVPTRMLCDGLLAKFGVETDYYDPSIGKDIEKLVKPNTTVIFLESPGSGTMEVQDIPALVSVAKKHGIKTILDNTWATPLFFDAHAHGIDISVEAGTKYLGGHSDLLIGLASANEECWPLLRSTYDAMAMLPGAEDCQLALRGMRTLHLRLKEVERKALDLAAWLGNRDEVEKVLHPAFEDCPGHEYWVRDYKGSSGLFSIVLKNGFTRAGLEKMVEGMKVLQLGFSWGG');
INSERT INTO proteininfo VALUES ('14318578', 'NP_116711.1','Hexokinase isoenzyme 1, cytosolic protein that catalyzes phosphorylation of glucose during glucose metabolism, expression is highest during growth on non-glucose carbon sources and is repressed by Hxk2p; Hxk1p [Saccharomyces cerevisiae]','MVHLGPKKPQARKGSMADVPKELMDEIHQLEDMFTVDSETLRKVVKHFIDELNKGLTKKGGNIPMIPGWVMEFPTGKESGNYLAIDLGGTNLRVVLVKLSGNHTFDTTQSKYKLPHDMRTTKHQEELWSFIADSLKDFMVEQELLNTKDTLPLGFTFSYPASQNKINEGILQRWTKGFDIPNVEGHDVVPLLQNEISKRELPIEIVALINDTVGTLIASYYTDPETKMGVIFGTGVNGAFYDVVSDIEKLEGKLADDIPSNSPMAINCEYGSFDNEHLVLPRTKYDVAVDEQSPRPGQQAFEKMTSGYYLGELLRLVLLELNEKGLMLKDQDLSKLKQPYIMDTSYPARIEDDPFENLEDTDDIFQKDFGVKTTLPERKLIRRLCELIGTRAARLAVCGIAAICQKRGYKTGHIAADGSVYNKYPGFKEAAAKGLRDIYGWTGDASKDPITIVPAEDGSGAGAAVIAALSEKRIAEGKSLGIIGA');
INSERT INTO proteininfo VALUES ('14318577', 'NP_116710.1','Subunit of the 19S regulatory particle of the 26S proteasome lid; synthetically lethal with RPT1, which is an ATPase component of the 19S regulatory particle; physically interacts with Nob1p and Rpn3p; Rpn12p [Saccharomyces cerevisiae]','MPSLAELTKSLSIAFENGDYAACEKLLPPIKIELIKNNLLIPDLSIQNDIYLNDLMITKRILEVGALASIQTFNFDSFENYFNQLKPYYFSNNHKLSESDKKSKLISLYLLNLLSQNNTTKFHSELQYLDKHIKNLEDDSLLSYPIKLDRWLMEGSYQKAWDLLQSGSQNISEFDSFTDILKSAIRDEIAKNTELSYDFLPLSNIKALLFFNNEKETEKFALERNWPIVNSKVYFNNQSKEKADYEDEMMHEEDQKTNIIEKAMDYAISIENIV');
INSERT INTO proteininfo VALUES ('14318576', 'NP_116709.1','coatomer (COPI) complex delta subunit; vesicle coat component; Ret2p [Saccharomyces cerevisiae]','MVVLAASITTRQGKPLLSRQFKDLSKDRVLELLSNFQNLVSEISSDHTFVEDKHVRYVYRPFDNYYIILITNRQSNIIKDLATLNLFSQTINSYLSSFQDQEIFHNAFEILSSFDEIVSMGGYKENLSFTQVQTYLSMESHEERIQEIIERNKEIEATEERKRRAKEIARKEHERKHGFMSSNGDYDGANRFMGSKDPNVTNAINSYYSHASPAAQQSYLQSSHAAAAEVAPVASPMATSQRAGHSATGGMKLGGGAGRRAGAAPRPSAISSASSGTPPPPEEDVPENNGILISIKEVINAEFSRDGTIHSSELKGVLELRINDHDLSHSNLKLADSIDVRDKSFQFKTHPNIDKQSFLSTKLISLRDKSKAFPANDQSLGVLRWRKVAPAEDDSLIPLTLTTWVSPSESQQGFDVIIEYESVLETELADVIFTIPVFPQEPVDINTESSTCSDAEVVNMDQEMGTSIKISKIAANDAGALAFTIEAPYEDALYPMTVSFQESTRDKLAKSFTGMAIQSVVMANDHDQELPYDVITSLKSDEYLVQ');
INSERT INTO proteininfo VALUES ('14318575', 'NP_116708.1','20S proteasome beta-type subunit; Pre4p [Saccharomyces cerevisiae]','MNHDPFSWGRPADSTYGAYNTQIANAGASPMVNTQQPIVTGTSVISMKYDNGVIIAADNLGSYGSLLRFNGVERLIPVGDNTVVGISGDISDMQHIERLLKDLVTENAYDNPLADAEEALEPSYIFEYLATVMYQRRSKMNPLWNAIIVAGVQSNGDQFLRYVNLLGVTYSSPTLATGFGAHMANPLLRKVVDRESDIPKTTVQVAEEAIVNAMRVLYYRDARSSRNFSLAIIDKNTGLTFKKNLQVENMKWDFAKDIKGYGTQKI');
INSERT INTO proteininfo VALUES ('14318574', 'NP_116707.1','Mitochondrial ribosomal protein of the small subunit, has similarity to human mitochondrial ribosomal protein MRP-S36; Ymr31p [Saccharomyces cerevisiae]','MIATPIRLAKSAYEPMIKFVGTRHPLVKHATEVVVHPCATNGMLPGSKECIPVSKFMENYKPFRVVPIKHSANAGLSSSKTSVFVNRPLQKDELASIFELPARFRYKPINEHELESINSGGAW');
INSERT INTO proteininfo VALUES ('14318571', 'NP_116704.1','Kinetochore protein that co-purifies with Nnf1p; Cnn1p [Saccharomyces cerevisiae]','MSTPRKAAGNNENTEVSEIRTPFRERALEEQRLKDEVLIRNTPGYRKLLSASTKSHDILNKDPNEVRSFLQDLSQVLARKSQGNDTTTNKTQARNLIDELAYEESQPEENELLRSRSEKLTDNNIGNETQPDYTSLSQTVFAKLQERDKGLKSRKIDPIIIQDVPTTGHEDELTVHSPDKANSISMEVLRTSPSIGMDQVDEPPVRDPVPISITQQEEPLSEDLPSDDKEETEEAENEDYSFENTSDENLDDIGNDPIRLNVPAVRRSSIKPLQIMDLKHLTRQFLNENRIILPKQTWSTIQEESLNIMDFLKQKIGTLQKQELVDSFIDMGIINNVDDMFELAHELLPLELQSRIESYLF');
INSERT INTO proteininfo VALUES ('14318569', 'NP_116702.1','Hypothetical ORF; Yfr044cp [Saccharomyces cerevisiae]','MSHSLTSVFQKIDSLKPQFFSRLTKAIQIPAVSSDESLRSKVFDKAKFISEQLSQSGFHDIKMVDLGIQPPPISTPNLSLPPVILSRFGSDPSKKTVLVYGHYDVQPAQLEDGWDTEPFKLVIDEAKGIMKGRGVTDDTGPLLSWINVVDAFKASGQEFPVNLVTCFEGMEESGSLKLDELIKKEANGYFKGVDAVCISDNYWLGTKKPVLTYGLRGCNYYQTIIEGPSADLHSGIFGGVVAEPMIDLMQVLGSLVDSKGKILIDGIDEMVAPLTEKEKALYKDIEFSVEELNAATGSKTSLYDKKEDILMHRWRYPSLSIHGVEGAFSAQGAKTVIPAKVFGKFSIRTVPDMDSEKLTSLVQKHCDAKFKSLNSPNKCRTELIHDGAYWVSDPFNAQFTAAKKATKLVYGVDPDFTREGGSIPITLTFQDALNTSVLLLPMGRGDDGAHSINEKLDISNFVGGMKTMAAYLQYYSESPEN');
INSERT INTO proteininfo VALUES ('14318568', 'NP_116701.1','Hypothetical ORF; Yfr043cp [Saccharomyces cerevisiae]','MVLQYPQNKILVLSDHPHNFLKTQFLQDLFHCSSTGISIVKDQTWENRYYKVHFDLYIDSCKEIPVWVEEFITPECEPLRNVMAGIILITDIRQTKPQELLHQFMIAAHRNTFVVLANVNEEVEQDEIDELNEIWSNAFTNVIEFVNWKRSKPTVNHNDYGEKLGLDRIQEIIDTHDWLNCEVQPATKIREEIPNEMPLEQIIRNLQSARLKYKSIENSSEADAFANEMADELSRYL');
INSERT INTO proteininfo VALUES ('14318567', 'NP_116700.1','Protein required for cell viability; Yfr042wp [Saccharomyces cerevisiae]','MAGIKLTHKLYQYYQLATSFLYAALLIRWLILMPLVGSRFLPGGIHEFLIYLMFYSSIMEVIWLLRFHGFKYGLLSRTFLKDLNFIYLVSVIHFYDDYEHALILKNASYSSFIISLSLSQAYCHWCKLFKRKGVKERTLVWKVNTFVTLPILYLSEFALLLLNIQVKNYHSTPTLDIINRVVLLAYFPVLLTAYKKLLTK');
INSERT INTO proteininfo VALUES ('14318566', 'NP_116699.1','Endoplasmic reticulum protein that may function as a cochaperone, as suggested by the presence of a DnaJ-like domain; Erj5p [Saccharomyces cerevisiae]','MNGYWKPALVVLGLVSLSYAFTTIETEIFQLQNEISTKYGPDMNFYKFLKLPKLQNSSTKEITKNLRKLSKKYHPDKNPKYRKLYERLNLATQILSNSSNRKIYDYYLQNGFPNYDFHKGGFYFSRMKPKTWFLLAFIWIVVNIGQYIISIIQYRSQRSRIENFISQCKQQDDTNGLGVKQLTFKQHEKDEGKSLVVRFSDVYVVEPDGSETLISPDTLDKPSVKNCLFWRIPASVWNMTFGKSVGSAGKEEIITDSKKYDGNQTKKGNKVKKGSAKKGQKKMELPNGKVIYSRK');
INSERT INTO proteininfo VALUES ('14318564', 'NP_116697.1','Hypothetical ORF; Yfr039cp [Saccharomyces cerevisiae]','MKAVFKVTTALLACVFIARYLVCQQNGLGSFATDLQPICRHTEFSVGSLFDSKLVEGSAVSDYLVGKYSQSIKPLIERYPNSSLKRIMGYFYRFWYNIFSFLRLNELCCSLHSKLGPLLNHLRIAWYYLKPYTDNVKNVLENPFNSSTDWMKYGSFSADGTLTKPIFETDSETEDYEDDENENEDEDEDEDEDDVGIEDENKEYEFDGVQDGHGNSQLVTAAILQDLSKIIIGSNSHAELETYEAESLKMEYEAWIKAIDSKIHSAMALLDSEIQSVFEAEVQNKSIEITRNLDDLNTTVNEQLVFLDSKIKDINCTSKFDPVQNKIKYFDESGQVELEAYITKSSITSILKNYKIHLLDFEKSLFHSLDSFLTEMAKLAESIRLENVEVYEEWGDVMISQWSQRMAYMDVRGLHLEDQYDPAYIEENHSNWLRFMELKKKVISERNRLVKHDLDMTLILEWITKLKADFQNTKNNIQDTFLQRMNTADTLFKNRELKEQLEEEFVRQEH');
INSERT INTO proteininfo VALUES ('14318562', 'NP_116695.1','Subunit of the RSC complex, which remodels the structure of chromatin; mediates multiple RSC complex interactions, undergoes dimerization via the C-term coiled-coil segment, associates with SWI2/SNF2 ATPase Sth1p, forms a complex with Rsc6p; Rsc8p [Saccharomyces cerevisiae]','MSDTEKDKDVPMVDSHEATEEPPTTSTNTPSFPHLAQEQAKEESATLGAEVAHKKINYEQEAQKLEEKALRFLAKQTHPVIIPSFASWFDISKIHEIEKRSNPDFFNDSSRFKTPKAYKDTRNFIINTYRLSPYEYLTITAVRRNVAMDVASIVKIHAFLEKWGLINYQIDPRTKPSLIGPSFTGHFQVVLDTPQGLKPFLPENVIKQEVEGGDGAEPQVKKEFPVNLTIKKNVYDSAQDFNALQDESRNSRQIHKVYICHTCGNESINVRYHNLRARDTNLCSRCFQEGHFGANFQSSDFIRLENNGNSVKKNWSDQEMLLLLEGIEMYEDQWEKIADHVGGHKRVEDCIEKFLSLPIEDNYIREVVGSTLNGKGGDSRDGSVSGSKLMECVNDAVQTLLQGDDKLGKVSDKSREISEKYIEESQAIIQELVKLTMEKLESKFTKLCDLETQLEMEKLKYVKESEKMLNDRLSLSKQILDLNKSLEELNVSKKLVLISEQVDSGIQLVEKDQEGDDEDGNTATGHGVKRVGKEGEEVGEGDSIAKLQPQVYKPWSL');
INSERT INTO proteininfo VALUES ('14318561', 'NP_116694.1','Subunit of the Anaphase-Promoting Complex/Cyclosome (APC/C), which is a ubiquitin-protein ligase required for degradation of anaphase inhibitors, including mitotic cyclins, during the metaphase/anaphase transition; Cdc26p [Saccharomyces cerevisiae]','MIRRAPTTLQLSHDDVTSLIDDLNEQKLKQQLNIEKTKYFQGKNGGSLHSNTDFQDTSQNIEDNNNDNDNDIDEDDDMSSYNDKAASVAHTRVLNSLHLSTDSNTAHETSNANDNHNPFYIREE');
INSERT INTO proteininfo VALUES ('14318560', 'NP_116693.1','Hypothetical ORF; Yfr035cp [Saccharomyces cerevisiae]','MSASDKTKLCNKGMSRTSRTTTFVITPAFRERDDEGANSLCKAFLNTFSNLKSGMFKCLLGVGAVGTFISTFPQFFLLPCLLCVRCVCVCLCASISYAASAIFSFSIFFFFCLA');
INSERT INTO proteininfo VALUES ('14318559', 'NP_116692.1','Basic helix-loop-helix (bHLH) transcription factor; binds cooperatively with Pho2p to the PHO5 promoter; function is regulated by phosphorylation at multiple sites and by phosphate availability; Pho4p [Saccharomyces cerevisiae]','MGRTTSEGIHGFVDDLEPKSSILDKVGDFITVNTKRHDGREDFNEQNDELNSQENHNSSENGNENENEQDSLALDDLDRAFELVEGMDMDWMMPSHAHHSPATTATIKPRLLYSPLIHTQSAVPVTISPNLVATATSTTSANKVTKNKSNSSPYLNKRRGKPGPDSATSLFELPDSVIPTPKPKPKPKQYPKVILPSNSTRRVSPVTAKTSSSAEGVVVASESPVIAPHGSSHSRSLSKRRSSGALVDDDKRESHKHAEQARRNRLAVALHELASLIPAEWKQQNVSAAPSKATTVEAACRYIRHLQQNVST');
INSERT INTO proteininfo VALUES ('14318558', 'NP_116691.1','ubiquinol-cytochrome c oxidoreductase subunit 6 (17 kDa); Qcr6p [Saccharomyces cerevisiae]','MGMLELVGEYWEQLKITVVPVVAAAEDDDNEQHEEKAAEGEEKEEENGDEDEDEDEDEDDDDDDDEDEEEEEEVTDQLEDLREHFKNTEEGKALVHHYEECAERVKIQQQQPGYADLEHKEDCVEEFFHLQHYLDTATAPRLFDKLK');
INSERT INTO proteininfo VALUES ('14318557', 'NP_116690.1','Protein component of the large (60S) ribosomal subunit, has similarity to rat L29 ribosomal protein; not essential for translation, but required for proper joining of the large and small ribosomal subunits and for normal translation rate; Rpl29p [Saccharomyces cerevisiae]','MAKSKNHTAHNQTRKAHRNGIKKPKTYKYPSLKGVDPKFRRNHKHALHGTAKALAAAKK');
INSERT INTO proteininfo VALUES ('14318556', 'NP_116689.1','Hypothetical ORF; Yfr032cp [Saccharomyces cerevisiae]','MTEQVNNDTTSDTTTTITTVYISNLPFTASERDLHAFLNNYGASSVLIPTQTVRRFSKRHNSNPRKPLGIAFAQFANNTLALKAIQDLNGTVFQNQKLFLKLHVPYEADSTPDTDVKKPKEKNKVKKTPETAADTVYCHDLPDDITDSEIRELFQLYSPQEIWIYRSKVYRRKCIPFAPHQITAALVTLQSETPIGDICDSVAKTATLRGKSIIVKPAYVSKIQEIKQLVKDNLTNARDPPPAALAEPAPAPAPVEPAEQVQEGQDNAETNDVPPPPASSSDRPTVAAT');
INSERT INTO proteininfo VALUES ('14318555', 'NP_116688.1','Protein component of the large (60S) ribosomal subunit, identical to Rpl2Bp and has similarity to E. coli L2 and rat L8 ribosomal proteins; Rpl2ap [Saccharomyces cerevisiae]','MGRVIRNQRKGAGSIFTSHTRLRQGAAKLRTLDYAERHGYIRGIVKQIVHDSGRGAPLAKVVFRDPYKYRLREEIFIANEGVHTGQFIYAGKKASLNVGNVLPLGSVPEGTIVSNVEEKPGDRGALARASGNYVIIIGHNPDENKTRVRLPSGAKKVISSDARGVIGVIAGGGRVDKPLLKAGRAFHKYRLKRNSWPKTRGVAMNPVDHPHGGGNHQHIGKASTISRGAVSGQKAGLIAARRTGLLRGSQKTQD');
INSERT INTO proteininfo VALUES ('14318554', 'NP_116687.1','Chromosome segregation and condensation; SMC chromosomal ATPase family member; Smc2p [Saccharomyces cerevisiae]','MKVEELIIDGFKSYATRTVITDWDPQFNAITGLNGSGKSNILDAICFVLGIASMSTVRASSLQDLIYKRGQAGVTKASVTIVFDNTDKSNSPIGFTNSPQISVTRQVVLGGTSKYLINGHRAPQQSVLQLFQSVQLNINNPNFLIMQGKITKVLNMKPSEILSLIEEAAGTKMFEDRREKAERTMSKKETKLQENRTLLTEEIEPKLEKLRNEKRMFLEFQSTQTDLEKTERIVVSYEYYNIKHKHTSIRETLENGETRMKMLNEFVKKTSEEIDSLNEDVEEIKLQKEKELHKEGTISKLENKENGLLNEISRLKTSLSIKVENLNDTTEKSKALESEIASSSAKLIEKKSAYANTEKDYKMVQEQLSKQRDLYKRKEELVSTLTTGISSTGAADGGYNAQLAKAKTELNEVSLAIKKSSMKMELLKKELLTIEPKLKEATKDNELNVKHVKQCQETCDKLRARLVEYGFDPSRIKDLKQREDKLKSHYYQTCKNSEYLKRRVTNLEFNYTKPYPNFEASFVHGVVGQLFQIDNDNIRYATALQTCAGGRLFNVVVQDSQTATQLLERGRLRKRVTIIPLDKIYTRPISSQVLDLAKKIAPGKVELAINLIRFDESITKAMEFIFGNSLICEDPETAKKITFHPKIRARSITLQGDVYDPEGTLSGGSRNTSESLLVDIQKYNQIQKQIETIQADLNHVTEELQTQYATSQKTKTIQSDLNLSLHKLDLAKRNLDANPSSQIIARNEEILRDIGECENEIKTKQMSLKKCQEEVSTIEKDMKEYDSDKGSKLNELKKELKLLAKELEEQESESERKYDLFQNLELETEQLSSELDSNKTLLHNHLKSIESLKLENSDLEGKIRGVEDDLVTVQTELNEEKKRLMDIDDELNELETLIKKKQDEKKSSELELQKLVHDLNKYKSNTNNMEKIIEDLRQKHEFLEDFDLVRNIVKQNEGIDLDTYRERSKQLNEKFQELRKKVNPNIMNMIENVEKKEAALKTMIKTIEKDKMKIQETISKLNEYKRETLVKTWEKVTLDFGNIFADLLPNSFAKLVPCEGKDVTQGLEVKVKLGNIWKESLIELSGGQRSLIALSLIMALLQFRPAPMYILDEVDAALDLSHTQNIGHLIKTRFKGSQFIVVSLKEGMFANANRVFRTRFQDGTSVVSIM');
INSERT INTO proteininfo VALUES ('14318553', 'NP_116686.1','Subunit alpha of assimilatory sulfite reductase, which is responsible for the conversion of sulfite into sulfide; Met10p [Saccharomyces cerevisiae]','MPVEFATNPFGEAKNATSLPKYGTPVTAISSVLFNNVDSIFAYKSFSQPDLLHQDLKKWSEKRGNESRGKPFFQELDIRSGAGLAPLGFSHGLKNTTAIVAPGFSLPYFINSLKTVSHDGKFLLNVGALNYDNATGSVTNDYVTALDAASKLKYGVVTPISANEVQSVALLALAIATFSNNSGAINLFDGLNYSKTVLPLVESVPEASILAKLSKVIAPDAAFDDVLDKFNELTGLRLHNFQYFGAQDAETVFITYGSLESELFNSAISGNNSKIGLINVRVPLPFNVAKFVTHVPSTTKQIVVIGQTLDGSSPSFLRSQVSAALFYHGRTSISVSEYIYQPDFIWSPKAVKSIVSSFIPEFTYNADSSFGEGFIYWASDKSINIDVASKLVKALSLEDGKFVSLRTKFDNLANAGTFQAQFVTSKEQIPVSNIDSTKLSVVEDVSLLKHLDVAATVAEQGSIALVSQKAVKDLDLNSVESYVKNLGIPESFLISIAKKNIKLFIIDGETTNDESKLSLFIQAVFWKLAFGLDVAECTNRIWKSIDSGADISAASISEFLTGAFKNFLSEVPLALYTKFSEINIEKKEDEEEPAALPIFVNETSFLPNNSTIEEIPLPETSEISDIAKKLSFKEAYEVENKLRPDLPVKNFVVKVKENRRVTPADYDRYIFHIEFDISGTGMTYDIGEALGIHARNNESLVKEFLTFYGLNESDVVLVPNKDNHHLLETRTVLQAFVENLDIFGKPPKRFYESLIPYASNEEEKKKLEDLVTPAGAVDLKRFQDVEYYTYADIFELFPSVRPSLEELVTIIEPLKRREYSIASSQKVHPNEVHLLIVVVDWVDNKGRKRYGQASKYISDLAVGSELVVSVKPSVMKLPPSPKQPVIMSGLGTGLAPFKAIVEEKLWQKQQGYEIGEVFLYLGSRHKREEYLYGELWEAYKDAGIITHIGAAFSRDQPQKIYIQDRIKENLDELKTAMIDNKGSFYLCGPTWPVPDITQALQDILAKDAEERGIKVDLDAAIEELKEASRYILEVY');
INSERT INTO proteininfo VALUES ('14318552', 'NP_116685.1','Component of the SPS plasma membrane amino acid sensor system (Ssy1p-Ptr3p-Ssy5p), which senses external amino acid concentration and transmits intracellular signals that result in regulation of expression of amino acid permease genes; Ptr3p [Saccharomyces cerevisiae]','MHSHRQKWGRQTDIARVLDDIEHDLYLPQRLSLDGATGTDESHVQYGIVKDCSVLTCGCCISESLFNDLCRETSNKQTACPICQRENVRLLSAIKPLRDLARQIDFFRSTTGQGESESDELPAIVKTSPSSSSLSLTPSRSSSTAGLEADNKTLSDPTVKEKSSLLELFHIVASKMHNANTEVGSDHPLTTGTTRDQEEHTTKENYSSSLLEPNYDDHANWKILDNASNTRTVPIDNNFSLMSTDVTIPSTANYQTNSAHDLDEEKEYFFANCFPMYRKKFQFNTHPKFLGTKSKLFINQSISPDCTKFALITEHKWEIYSINPKDNSPQLVSCGKSSGEYGPNFNQLTEQSSSSLSTTSQASKKKKKNWSQRFCKLSNDFLIISGSQNILNVHDIHQNGKLIYTYVSRFPIRCIDIDPRSQIIAYGITGKDRHTGAEQALVVIQQITRNKVTLEPEFPPPITITLPYRDPINTIQLSHDAKYLTCSTALESRFLIISLQKINEPRLIMKSVRSIDTSLESEGITDTKLFPGNPNLMCITSTAFNSSPLVINTKITQINGVRTVAQPSMLIRVDEIGCKIHKCEISPRNDAIAFLDRNGSVYIMCAPTMMDNNEKRRTILVETVANAYRAYESATLRFNPEGNKLYILDRKGTFFVEDFAYGLPQSREITKCKQIFHK');
INSERT INTO proteininfo VALUES ('14318551', 'NP_116684.1','Protein phosphatase required for mitotic exit; located in the nucleolus until liberated by the FEAR and Mitotic Exit Network in anaphase, enabling it to act on key substrates to effect a decrease in CDK/B-cyclin activity and mitotic exit; Cdc14p [Saccharomyces cerevisiae]','MRRSVYLDNTIEFLRGRVYLGAYDYTPEDTDELVFFTVEDAIFYNSFHLDFGPMNIGHLYRFAVIFHEILNDPENANKAVVFYSSASTRQRANAACMLCCYMILVQAWTPHQVLQPLAQVDPPFMPFRDAGYSNADFEITIQDVVYGVWRAKEKGLIDLHSFNLESYEKYEHVEFGDFNVLTPDFIAFASPQEDHPKGYLATKSSHLNQPFKSVLNFFANNNVQLVVRLNSHLYNKKHFEDIGIQHLDLIFEDGTCPDLSIVKNFVGAAETIIKRGGKIAVHCKAGLGRTGCLIGAHLIYTYGFTANECIGFLRFIRPGMVVGPQQHWLYLHQNDFREWKYTTRISLKPSEAIGGLYPLISLEEYRLQKKKLKDDKRVAQNNIEGELRDLTMTPPSNGHGALSARNSSQPSTANNGSNSFKSSAVPQTSPGQPRKGQNGSNTIEDINNNRNPTSHANRKVVIESNNSDDESMQDTNGTSNHYPKVSRKKNDISSASSSRMEDNEPSATNINNAADDTILRQLLPKNRRVTSGRRTTSAAGGIRKISGSIKK');
INSERT INTO proteininfo VALUES ('14318550', 'NP_116683.1','Acetyltransferase required for the establishment of sister chromatid cohesion during DNA replication, but not for its maintenance during G2 and M phases; also required for postreplicative double-strand break repair; Eco1p [Saccharomyces cerevisiae]','MKARKSQRKAGSKPNLIQSKLQVNNGSKSNKIVKCDKCEMSYSSTSIEDRAIHEKYHTLQLHGRKWSPNWGSIVYTERNHSRTVHLSRSTGTITPLNSSPLKKSSPSITHQEEKIVYVRPDKSNGEVRAMTEIMTLVNNELNAPHDENVIWNSTTEEKGKAFVYIRNDRAVGIIIIENLYGGNGKTSSRGRWMVYDSRRLVQNVYPDFKIGISRIWVCRTARKLGIATKLIDVARENIVYGEVIPRYQVAWSQPTDSGGKLASKYNGIMHKSGKLLLPVYI');
INSERT INTO proteininfo VALUES ('14318549', 'NP_116682.1','Hypothetical ORF; Yfr026cp [Saccharomyces cerevisiae]','MTPYAVAITVALLIVTVSALQVNNSCVAFPPSNLRGKNGDGTNEQYATALLSIPWNGPPESLRDINLIELEPQVALYLLENYINHYYNTTRDNKCPNNHYLMGGQLGSSSDNRSLNDPQTMLWPEKKEDEKNCQETFKGACSCTKRFCKGYFSVNIFGINLNISYSSGK');
INSERT INTO proteininfo VALUES ('14318548', 'NP_116681.1','Histidinolphosphatase, catalyzes the eighth step in histidine biosynthesis; mutations cause histidine auxotrophy and sensitivity to Cu, Co, and Ni salts; transcription is regulated by general amino acid control; His2p [Saccharomyces cerevisiae]','MHSHHSHSGDYSAHGTDPLDSVVDQVVNLNFHTYCLTEHIPRIEAKFIYPEEQSLGKNPEEVITKLETSFKNFMSHAQEIKTRYADRPDVRTKFIIGMEIESCDMAHIEYAKRLMKENNDILKFCVGSVHHVNGIPIDFDQQQWYNSLHSFNDNLKHFLLSYFQSQYEMLINIKPLVVGHFDLYKLFLPNDMLVNQKSGNCNEETGVPVASLDVISEWPEIYDAVVRNLQFIDSYGGAIEINTSALRKRLEEPYPSKTLCNLVKKHCGSRFVLSDDAHGVAQVGVCYDKVKKYIVDVLQLEYICYLEESQSPENLLTVKRLPISQFVNDPFWANI');
INSERT INTO proteininfo VALUES ('14318545', 'NP_116678.1','Suppressor of DNA polymerase epsilon mutation; similar to YHR015W; poly(A) binding protein; related to PES4 protein homolog YHR015w; Pes4p [Saccharomyces cerevisiae]','MYSISNKKPSILSMVPLNILKNQDLKVKKDQEKKISFNPVVTPIRPDDYHEKTSRSSSSSHSDSPEFLRINNNKSGHKNGKLKSFESKKLVPLFIGDLHETVTEETLKGIFKKYPSFVSAKVCLDSVTKKSLGHGYLNFEDKEEAEKAMEELNYTKVNGKEIRIMPSLRNTTFRKNFGTNVFFSNLPLNNPLLTTRVFYDTFSRYGKILSCKLDSRKDIGFVYFEDEKTARNVIKMYNNTSFFGKKILCGIHFDKEVRSVPNFETQKSRLDAETIIEKEQSLNEKHSKGNDKESKNIYSSSQNSIFIKNLPTITTRDDILNFFSEVGPIKSIYLSNATKVKYLWAFVTYKNSSDSEKAIKRYNNFYFRGKKLLVTRAQDKEERAKFIESQKISTLFLENLSAVCNKEFLKYLCHQENIRPFKIQIDGYDENSSTYSGFIKFRNFEDATRIFNFLNNRLVGGSIVTTSWERQNNAPKYHDGYGMRNIHTSSHPQITPYYQYSHANSLNSPHMRDLSSMNSSTRSLIKNKNFNKKVLETFEKQVRRGIDFMRFPSATRDENVHGIAEYIFDTYWNRDVLILDKFLSLLNSSPYHEGVLQKQIEEAASSLGFKR');
INSERT INTO proteininfo VALUES ('14318544', 'NP_116677.1','Hypothetical ORF; Yfr022wp [Saccharomyces cerevisiae]','MGFSSGKSTKKKPLLFDIRLKNVDNDVILLKGPPNEAPSVLLSGCIVLSINEPMQIKSISLRLYGKIQIDVPLERPQDASSSSLSSSPPKIRKYNKVFYNYAWDNVNLKEYLSGLRGQSGLAGSSSSSNILGTRQRAQSTSSLKSLKGSSSPSSCTLDKGNYDFPFSAILPGSLPESVESLPNCFVTYSMESVIERSKNYSDLICRKNIRVLRTISPAAVELSETVCVDNSWPDKVDYSISVPNKAVAIGSATPINISIVPLSKGLKLGSIKVVLFENYQYCDPFPPVISENRQVTELNLEDPLNESSGEFNGNGCFVNNPFFQPDHSFQDKWEIDTILQIPNSLSNCVQDCDVRSNIKVRHKLKFFIILINPDGHKSELRASLPIQLFISPFVALSIKPLSSSNLYSLFSTTNQKDENSSQEEEEEYLFSRSASVTGLELLADMRSGGSVPTISDLMTPPNYEMHVYDRLYSGSFTRTAVETSGTCTPLGSECSTVEDQQQDLEDLRIRLTKIRNQRDNLGLPPSASSAAASRSLSPLLNVPAPEDGTERILPQSALGPNSGSVPGVHSNVSPVLLSRSPAPSVSAHEVLPVPSGLNYPETQNLNKVPSYGKAMKYDIIGEDLPPSYPCAIQNVQPRKPSRVHSRNSSTTLSSSIPTSFHSSSFMSSTASPISIINGSRSSSSGVSLNTLNELTSKTSNNPSSNSMKRSPTRRRATSLAGFMGGFLSKGNKR');
INSERT INTO proteininfo VALUES ('14318541', 'NP_116674.1','1-phosphatidylinositol-3-phosphate 5-kinase; vacuolar membrane kinase that generates phosphatidylinositol (3,5)P2, which is involved in vacuolar sorting and homeostasis; Fab1p [Saccharomyces cerevisiae]','MSSEEPHASISFPDGSHVRSSSTGTSSVNTIDATLSRPNYIKKPSLHIMSTSTTSTTTDLVTNPILSNISVPKISPPTSSSIATATSTSHVTGTASHSNIKANANTSTSVNKKNLPPTTSGRIPSSTIKRYPSRYKPSHSLQLPIKNDSNFKRSSIYASKSTVTAIPIRNNRPISMQNSYARTPDSDHDDVGDEVSSIKSASSSLTASLSKSFLFAFYNNRKKDKTSNNGVLSKEYWMKDESSKECFSCGKTFNTFRRKHHCRICGQIFCSSCTLLIDGDRFGCHAKMRVCYNCYEHADTYEDSSDEENDSTMQLNEPRSRSRSRSSNTNPYSHSHSHLHLISQDNHNGTDLHDPVAATDNPQQQNEVYLLNDDDVQSIMTSGEDSKLFISTPPPPPKMAIPATKQGGSLEISFDSENDRALHYQDDNPGRHHHLDSVPTRYTIRDMDNISHYDTNSNSTLRPHYNTNNSTITINNLNNTTSNNSNYNNTNSNSNINNPAHSLRRSIFHYVSSNSVNKDSNNSSATPASSAQSSSILDPANRIIGNYAHRNYKFKFNYNSKGPSQQNDTANGNNDNNNNNNNNNNNNNNNSASGIADNNNIPSNDNGTTFTLDKKKRNPLTKSKSTSAYLEYPLNEEDSSEDEGSMSIYSVLNDDHKTDNPIRSMRNSTKSFQRAQASLQRMRFRRKSKSKHFPNNSKSSIYRDLNFLTNSTPNLLSVVSDDNLYDDSSPLQDKASSSAASRLTDRKFSNSSGSNNNSNSNSNINTDPWKRIASISGFKLKKEKKRELNEVSLLHMHALLKQLLNDQEISNLQEWITLLDGALRKVLRTILNARDLNTLDFRQTYVKIKRISGGSPQNSEYIDGVVFSKALPSKTMPRHLKNPRILLIMFPLEYQKNNNHFLSIESVFRQEREYLDKLVSRLKSLHPDIIYVGANVSGYALELLNDSGIVVQFNMKPQVIERIAKLTEADIAISVDKLATNIKMGECETFEVKSYIYGNISKTYTFLRGCNPELGGTILLRGDSLENLRKIKQVSEFMVYAIFSLKLESSFFNDNFIQLSTDVYLKRAESKKLQVFEGYFADFLIKFNNRILTVSPTVDFPIPFLLEKARGLEKKLIERINQYESESDLDRQTQLNMLQGLESTITKKHLGNLIKFLHEMEIENLELEFQKRSRQWEVSYSSSQNLLGTGSHQSITVLYSMVSTKTATPCVGPQIVTIDYFWDSDISIGQFIENVVGTARYPCQQGCNGLYLDHYRSYVHGSGKVDVLIEKFQTRLPKLKDIILTWSYCKKCGTSTPILQISEKTWNHSFGKYLEVMFWSYKDSVTGIGKCPHDFTKDHVKYFGYNDLVVRLEYSDLEVHELITPPRKIKWKPHIDIKLKVELYYKILEKINNFYGSVLSRLERIKLDSMTKDKVLSGQAKIIELKSNATEEQKLMLQDLDTFYADSPCDQHLPLNLVIKSLYDKAVNWNSTFAIFAKSYLPSETDISRITAKQLKKLFYDSSRKDSEDKKSLHDEKAKTRKPEKNELPLEGLKDVEKPKIDSKNTTENRDRTNEPQNAVTITTFKDDTPIIPTSGTSHLTVTPSASSVSSSLTPQTEERPPISRSGTGISMTHDKSTRPNIRKMSSDSSLCGLASLANEYSKNNKVSKLATFFDQMHFDALSKEFELERERERLQLNKDKYQAIRLQTSTPIVEIYKNVKDAVDEPLHSRSSGNNLSSANVKTLEAPVGEHSRANNCNPPNLDQNLETELENSISQWGENILNPSGKTTASTHLNSKPVVKETSENPKSIVRESDNSKSEPLPPVITTTTVNKVESTPQPEKSLLMKTLSNFWADRSAYLWKPLVYPTCPSEHIFTDSDVIIREDEPSSLIAFCLSTSDYRNKMMNLNVQQQQQQQTAEAAPAKTGGNSGGTTQTGDPSVNISPSVSTTSHNKGRDSEISSLVTTKEGLLNTPPIEGARDRTPQESQTHSQANLDTLQELEKIMTKKTATHLRYQFEEGLTVMSCKIFFTEHFDVFRKICDCQENFIQSLSRCVKWDSNGGKSGSGFLKTLDDRFIIKELSHAELEAFIKFAPSYFEYMAQAMFHDLPTTLAKVFGFYQIQVKSSISSSKSYKMDVIIMENLFYEKKTTRIFDLKGSMRNRHVEQTGKANEVLLDENMVEYIYESPIHVREYDKKLLRASVWNDTLFLAKMNVMDYSLVIGIDNEGYTLTVGIIDFIRTFTWDKKLESWVKEKGLVGGASVIKQPTVVTPRQYKKRFREAMERYILMVPDPWYWEGN');
INSERT INTO proteininfo VALUES ('14318540', 'NP_116673.1','Hypothetical ORF; Yfr018cp [Saccharomyces cerevisiae]','MGMKYVLPLRLIGLAYLLVLFQVHRVTGWELSYEQYHAAHLNEAINPDSGWNKSTKNLLLPFNRTRVPGSEGSREIQRFIIEHFNNTLAGEWAVETQAFEENGYRFNNLVMTLQNNASEYLVLAAHYDTKIAPTGMVGAIDSAASCAALLYTAQFLTHIACHERTKEYNDLESNTVVSNSTLGVKIVFFDGEEAIEEWGPEDSIYGARRLAAQWLADGTMTRIRLLFLLDLLGSGEEEPLVPSYYAETHQEYQLLNRIEDDLLFRRGDEINGESALAAEVARQRKHLDPTDYRFLGLGHSVIGDDHTPFLAAGVPVLHAIPLPFPSTWHTVDDDFRHLDAAETRHWALLVCEFVVQSLRSRNQ');
INSERT INTO proteininfo VALUES ('14318539', 'NP_116672.1','Hypothetical ORF; Yfr017cp [Saccharomyces cerevisiae]','MTDPHLNTPQVSTSPTFERSQDFLNIDEPPCAQETPSVSTFNLPGPSAPAQSVDKPVPMIRRRSTNYMDALNSREQARERESSIGEHAPGAERRSSGPMDFQNTIHNMQYRTTNDSDLSHAGVDMGDSISHTPICSRAGNRPIFKNSYLDNNSNGNSARVPHGSPPQLGTRRKSSFKYEDFKKDIYNQLHMFGEK');
INSERT INTO proteininfo VALUES ('14318538', 'NP_116671.1','Hypothetical ORF; Yfr016cp [Saccharomyces cerevisiae]','MVESLTVENQEHNVQPPSVTSAGDSYSTLATDLPLPSTNDIIESRDQLTESDLDEAINATENFAQELSSQRKSSKLKGHKKKNQGQIKANRDRDTIVKLSSSVGETEEASTRDAISHDLERKDDVIEIATDTINDATESPTQIPIDVNVVIKETSTNNVAEGTENVPPIKESTGIEVGNSPITRRKKNKKKKTTNRRGRNSSNPADTTDLSKQSTLDSILVGIEEYLQEDGSKNEDIKVNIVQDEPVNVEKMDIRTRNESSDKTFDIDVPNKDNVDETSSKSENNINEEKAEHTLPREENEILNVNEGNAASFKHQLEPHGLEAGDENGQASTKDVESESLTKNGFNFKENESKHLKAGEKQQTESDRDGISPSVLAKNQKETEIGKEDHVFEQKDKEDEKCRKELSVNHENNMSHNFNAAGSDSIIPPETERETYDDETMGPTKRISDNEKNLQHGTNDISVEVEKEEEEEEEEEENSTFSKVKKENVTGEQEAVRNNEVSGTEEESTSKGEEIMGGDEKQSEAGEKSSIIEIEGSANSAKISKDNLVLEDEAEAPTQENKPTEVVGEIDIPDAPRDDVEIVEAVEKNIIPEDLEVAKEDQEGEQVKLDEPVKAMKDDKIAMRGAESISEDMKKKQEGTAELSNEKAKKEVDETARESAEGVEVEKSKTPESPKVVKRCTSGRPEDLQINERDPEVLKEDVRVPDEDVKPEIATTIENSEEEDPKSQRVQISTEQAETTQKDMGDVGSTTSFKEEEKPKRFEITQEGDKITGKDTNHEHGEATEAASENSKASDVGTAEKYIEPSSESVKKDTEEDAEVENSEKTEFIKVKAELENLDAPKEAEVTAELNKENEDVEVDTEEDAEVENSEKTEFIKVKAELGNLDAPKEAEVTAELNKENEDVEVAATSKEDIETKCSEPAETPIEDGTCTEAEVSKKDAEAVTKEDENMENSKIAEALKDVTGDQEIDDINISDEFQRTVELPELEKQDIKDNKGEDKELEVEETEKETSLPDLVVEENITEEKNEIKQEEEEVSQLDFNETESISKEAPNNDENGFEDQSTRENPKKASADDIFKDILDETNEFLEQLKIVDDSELNALLQSLDAKDSTTQTTEQSKKNNDKPQDVITTSEIRKLNEKEPVYIYTSLAGGGFHMIPRTNRLSTILTANRIPFTYRDLGTDDEARKVWKTFSKGRSLPGVVRGHNDLIGNWEEIEEANEDYKLRELIYDTI');
INSERT INTO proteininfo VALUES ('14318537', 'NP_116670.1','Glycogen synthase with similarity to Gsy2p, the more highly expressed yeast homolog; expression induced by glucose limitation, nitrogen starvation, enviromental stress, and entry into stationary phase; Gsy1p [Saccharomyces cerevisiae]','MARDLQNHLLFEVATEVTNRVGGIYSVLKSKAPVTVAQYGDNYTLLGPLNKATYESEVEKLDWEDESIFPEELLPIQKTLMSMREKGVNFVYGNWLIEGAPRVILFELDSVRHFLNEWKADLWSLVGIPSPEHDHETNDAILLGYVVVWFLGEVSKLDSSHAIIGHFHEWLAGVALPLCRKKRIDVVTIFTTHATLLGRYLCAAGDVDFYNNLQYFDVDQEAGKRGIYHRYCIERAAAHTADVFTTVSQITALEAEHLLKRKPDGILPNGLNVVKFQAVHEFQNLHALKKDKINDFVRGHFHGCFDFDLDNTVYFFIAGRYEYKNKGADMFIESLARLNYRLKVSGSKKTVVAFLIMPAKTNSFTVEALKSQAIVKSLENTVNEVTASIGKRIFEHTMRYPHNGLESELPTNLDELLKSSEKVLLKKRVLALRRPYGELPPVVTHNMCDDANDPILNQIRHVRLFNDSSDRVKVIFHPEFLNANNPILGLDYDEFVRGCHLGVFPSYYEPWGYTPAECTVMGVPSITTNVSGFGAYMEDLIETDQAKDYGIYIVDRRFKSPDESVEQLADYMEEFVNKTRRQRINQRNRTERLSDLLDWKRMGLEYVKARQLGLRRAYPEQFKQLVGETISDANMNTLAGGKKFKIARPLSVPGSPKVRSNSTVYMTPGDLGTLQDANNADDYFNLSTNGAIDNDDDDNDTSAYYEDN');
INSERT INTO proteininfo VALUES ('14318536', 'NP_116669.1','Calmodulin-dependent protein kinase; Cmk1p [Saccharomyces cerevisiae]','MDDKVSEKESSPKQTEEDSEGKMAHVQPASYVNKKKYVFGKTLGAGTFGVVRQAKNTETGEDVAVKILIKKALKGNKVQLEALYDELDILQRLHHPNIVAFKDWFESKDKFYIITQLAKGGELFDRILKKGKFTEEDAVRILVEILSAVKYMHSQNIVHRDLKPENLLYIDKSDESPLVVADFGIAKRLKSDEELLYKPAGSLGYVAPEVLTQDGHGKPCDIWSIGVITYTLLCGYSAFRAERVQDFLDECTTGEYPVKFHRPYWDSVSNKAKQFILKALNLDPSKRPTAAELLEDPWIICTELKTHNLLPGLKEGLDARQKFRNSVERVRLNMKIQKLRDLYLEQTESDSDFDEGSQANGSVPPLKATDTSQLSKKLSEEEQSKLKSELTSKAFAQLVNTVLAEKEKFLNINRVCSSDSDLPGSDIKSLDEAKEKPEGKDTKTEE');
INSERT INTO proteininfo VALUES ('14318535', 'NP_116668.1','Member of a complex (Isw1a) with Isw1p that has nucleosome-stimulated ATPase activity and represses transcription initiation by specific positioning of a promoter proximal dinucleosome; has homology to Esc8p, which is involved in silencing; Ioc3p [Saccharomyces cerevisiae]','MDSPSNSIQNLQQEAQGSSSAQLADHDHDRVSMAMPLQTDQSVSVSQSSDNLRRSRRVPKPRTSIYDEYEEELKERANKPKRKRPAPPKKKAPSTQNSKSNDKVEKKKTTSIAKDGKPTLKTNDKKVAPKPKPAHEQVEPALIPSNWTSVIPLLTSDFKNQYSVISRLKNPNMKPVPYAGDIIKLMAFINKFSSFFHSDLQNLSFQDFEVGLDLYPGDPNGSAAGIVKGPEDTSLLLYPDFMAIKDIVYCQDKMNLLFLSLLDLTFTENFDGKSAKKKGPLTTWENLKSSSKKVFSNPLYRLRLVAREWGYPREWRQQLPSDQDISKPKTALFEQDEQTPVVDPSHPEILTPNIYTWNANEPLPLESNPLYNREMDKNGILALKPMDRVVLLRALTDWCASHSSAIHDEIYKLTHGKKDPVFGIQTQQVPRYTIEGVDNTINQFKKLCSLIQSRYEIRSKKKHFVKQLKEGKKPDLSRKLEILKEIKAELKNAVKSEKDELLFSLYDKWVPLFEGELPDQPLANPFSERLYKLRLQEFFLGRVPHIGDFYMPRLHSYGDSLEMSTFTDLRNLQALLSKFKNNEYNAFTLFENDGQSMSAQFKLFYHDTPSLAHDVARGRNTSGKVYWYELCHDSATLLEFLEFLDYKIVKPQDEKKEGNEKEKEALNNEAHILEQKSTTDNNPSINTNPLPKDAKYNTARKKLQILKEFLSDYYFILRQFEQMKVQFADMKPGKRQLRRIQRQTVNYNTEYDSEEYVDDEEDDEADIYDDNDNDSSFDDGRVKRQRT');
INSERT INTO proteininfo VALUES ('14318534', 'NP_116667.1','Hypothetical ORF; Yfr012wp [Saccharomyces cerevisiae]','MLNYKLILLFSSFLQLISFSGFMICCLTSPIIRNWGLAQAAGVSYGTFGYCKTLNSFSCSRVRLIYNTSKEILPGPSLERWWLSPKARHTIGGLLISIPVATCLTFISFALPLVIIFLFQTGGTNVSLITSNAILHILTLLSTIFACTVILLLCMHRDPVTISSLYDLVWLANCSLFPLLVIGVHFLSFRFDTSAQSDRKHS');
INSERT INTO proteininfo VALUES ('14318533', 'NP_116666.1','Hypothetical ORF; Yfr011cp [Saccharomyces cerevisiae]','MGSNTSKVGAGAEKQQVYTPLTQIDFSQSLVSQLDSSKESDYVTKQNAEKFIEKKVSQRLSNLEVETLKKFEDTLNNSLLSDDDKDAVDGISSSSLNNQIESLNKKLTLFDQLELQKLEKYGGAKGKSDKKTDNGSISIKAKLTECLLANKGKPLNCYEEMEEFKKLVMG');
INSERT INTO proteininfo VALUES ('14318532', 'NP_116665.1','Ubiquitin-specific protease situated in the base subcomplex of the 26S proteasome, releases free ubiquitin from branched polyubiquitin chains; deletion causes hypersensitivity to cycloheximide and other toxic compounds; Ubp6p [Saccharomyces cerevisiae]','MSGETFEFNIRHSGKVYPITLSTDATSADLKSKAEELTQVPSARQKYMVKGGLSGEESIKIYPLIKPGSTVMLLGTPDANLISKPAKKNNFIEDLAPEQQVQQFAQLPVGFKNMGNTCYLNATLQALYRVNDLRDMILNYNPSQGVSNSGAQDEEIHKQIVIEMKRCFENLQNKSFKSVLPIVLLNTLRKCYPQFAERDSQGGFYKQQDAEELFTQLFHSMSIVFGDKFSEDFRIQFKTTIKDTANDNDITVKENESDSKLQCHISGTTNFMRNGLLEGLNEKIEKRSDLTGANSIYSVEKKISRLPKFLTVQYVRFFWKRSTNKKSKILRKVVFPFQLDVADMLTPEYAAEKVKVRDELRKVEKEKNEKEREIKRRKFDPSSSENVMTPREQYETQVALNESEKDQWLEEYKKHFPPNLEKGENPSCVYNLIGVITHQGANSESGHYQAFIRDELDENKWYKFNDDKVSVVEKEKIESLAGGGESDSALILMYKGFGL');
INSERT INTO proteininfo VALUES ('14318531', 'NP_116664.1','Positive regulator of the Gcn2p kinase activity, forms a complex with Gcn1p; proposed to stimulate Gcn2p activation by an uncharged tRNA; Gcn20p [Saccharomyces cerevisiae]','MASIGSQVRKAASSIDPIVTDYAVGYFNHLSGITFDAVQSKQVDLSTEVQFVSDLLIDAGASKAKVKELSESILKQLTTQLKENEAKLELTGDTSKRLLDINVLKSHNSKSDINVSLSMLGVNGDIEHTGRKMETRVDLKKLAKAEQKIAKKVAKRNNKFVKYEASKLINDQKEEDYDSFFLQINPLEFGSSAGKSKDIHIDTFDLYVGDGQRILSNAQLTLSFGHRYGLVGQNGIGKSTLLRALSRRELNVPKHVSILHVEQELRGDDTKALQSVLDADVWRKQLLSEEAKINERLKEMDVLRQEFEEDSLEVKKLDNEREDLDNHLIQISDKLVDMESDKAEARAASILYGLGFSTEAQQQPTNSFSGGWRMRLSLARALFCQPDLLLLDEPSNMLDVPSIAYLAEYLKTYPNTVLTVSHDRAFLNEVATDIIYQHNERLDYYRGQDFDTFYTTKEERRKNAQREYDNQMVYRKHLQEFIDKYRYNAAKSQEAQSRIKKLEKLPVLEPPEQDKTIDFKFPECDKLSPPIIQLQDVSFGYDENNLLLKDVNLDVQMDSRIALVGANGCGKTTLLKIMMEQLRPLKGFVSRNPRLRIGYFTQHHVDSMDLTTSAVDWMSKSFPGKTDEEYRRHLGSFGITGTLGLQKMQLLSGGQKSRVAFAALCLNNPHILVLDEPSNHLDTTGLDALVEALKNFNGGVLMVSHDISVIDSVCKEIWVSEQGTVKRFEGTIYDYRDYILQSADAAGVVKKH');
INSERT INTO proteininfo VALUES ('14318530', 'NP_116663.1','Protein involved in G1 cell cycle arrest in response to pheromone, in a pathway different from the Far1p-dependent pathway; interacts with Far3p, Far8p, Far9p, Far10p, and Far11p; Far7p [Saccharomyces cerevisiae]','MSDQINVLSMQQQQQQQQQQQQVYMSPQAENLNHMYLLVNKLVKQLRENQAEKAKILRNIDILSGSLNKYETSEEPHDTTENIALFNRFLEQRGKAPITEKEQLSNNLDENAKDDVMLGVLKRQNSMLRKSLQESKQVTLESMDLLSYSEDSLNYIVAQLRGNILMHHKETIKLIRQKFQTETIPLEDEEFKMYLENVNGLQKLTDISHTYRLLLRLHAQD');
INSERT INTO proteininfo VALUES ('14318529', 'NP_116662.1','Hypothetical ORF; Yfr007wp [Saccharomyces cerevisiae]','MVDTHKLADDVLQLLDNRIEDNYRVCVILVGSPGSGKSTIAEELCQIINEKYHTFLSEHPNVIEVNDRLKPMVNLVDSLKTLQPNKVAEMIENQGLFKDHVEDVNFQPVKYSALTSNNEECTAVVARGGTANAIRIAAVDNPVNVNKLAQDSINIAQIVPMDGFHLSRRCLDLFKDPQTAHKRRGSPSTFDSNNFLQLCKILAKTSLCKVSSHHKFYSTSSVFEKLSKTFSQTIPDIFVPGFNHALKDPTPDQYCISKFTRIVILEGLYLLYDQENWKKIYKTLADTGALLVYKIDIDYEATEERVAKRHLQSGLVTTIAEGREKFRSNDLLNGRDIDNHLIKVDNIVHIRND');
INSERT INTO proteininfo VALUES ('14318528', 'NP_116661.1','Hypothetical ORF; Yfr006wp [Saccharomyces cerevisiae]','MCLEPISLVVFGSLVFFFGLVKYFKRGERQRTRGILQPEYKDKYYYSKEKGEEMGEVANVNEIPVKIRNHKYPAKEHNLRVKDLLLNRNPKLSKISTAFFIAGEELEGNKYCDTNKDFRQNRYFYHLSGVDIPASAILFNCSTDKLTLFLPNIDEEDVIWSGMPLSLDEAMRVFDIDEALYISDLGKKFKELQDFAIFTTDLDNVHDENIARSLIPSDPNFFYAMDETRAIKDWYEIESIRKACQISDKSHLAVMSALPIELNELQIQAEFEYHATRQGGRSLGYDPICCSGPACGTLHYVKNSEDIKGKHSILIDAGAEWRQYTSDITRCFPTSGKFTAEHREVYETVLDMQNQAMERIKPGAKWDDLHALTHKVLIKHFLSMGIFKKEFSEDEIFKRRASCAFYPHGLGHMLGLDVHDVGGNPNYDDPDPMFRYLRIRRPLKENMVITNEPGCYFNQFLIKEFLEKHPERLEVVDMSVLKRYMYVGGVRIEDDILVTKDGYENLTGITSDPDEIEKIVQKGLKKPRSGFHVIV');
INSERT INTO proteininfo VALUES ('14318527', 'NP_116660.1','Conserved zinc-finger domain protein involved in pre-mRNA splicing, required for assembly of U4 snRNA into the U4/U6 particle; Sad1p [Saccharomyces cerevisiae]','MEVDNKRRHSEDELKQEAVKKIKSQEPNYAYLETVVREKLDFDSEKICCITLSPLNVYCCLVCGHYYQGRHEKSPAFIHSIDENHHVFLNLTSLKFYMLPQNVQILHDGEVQLLNSIKFAAYPTYCPKDLEDFPRQCFDLSNRTYLNGFIGFTNAATYDYAHSVLLLISHMVPVRDHFLLNHFDNQGEFIKRLSICVKKIWSPKLFKHHLSVDDFVSYLKVREGLNLNPIDPRLFLLWLFNKICSSSNDLKSILNHSCKGKVKIAKVENKPEASESVTGKVIVKPFWVLTLDLPEFSPFEDGNSVDDLPQINITKLLTKFTKSRSSSTSTVFELTRLPQFLIFHFNRFDRNSDHPVKNRNQTLVEFSSELEILHVKYRLKANVVHVVIKQPSTDGNAFNGDEKSHWITQLYDNKSEKWIEIDGINTTEREAELLFLKETFIQVWEKQE');
INSERT INTO proteininfo VALUES ('14318526', 'NP_116659.1','Metalloprotease subunit of the 19S regulatory particle of the 26S proteasome lid; couples the deubiquitination and degradation of proteasome substrates; Rpn11p [Saccharomyces cerevisiae]','MERLQRLMMNSKVGSADTGRDDTKETVYISSIALLKMLKHGRAGVPMEVMGLMLGEFVDDYTVNVVDVFAMPQSGTGVSVEAVDDVFQAKMMDMLKQTGRDQMVVGWYHSHPGFGCWLSSVDVNTQKSFEQLNSRAVAVVVDPIQSVKGKVVIDAFRLIDTGALINNLEPRQTTSNTGLLNKANIQALIHGLNRHYYSLNIDYHKTAKETKMLMNLHKEQWQSGLKMYDYEEKEESNLAATKSMVKIAEQYSKRIEEEKELTEEELKTRYVGRQDPKKHLSETADETLENNIVSVLTAGVNSVAIK');
INSERT INTO proteininfo VALUES ('14318525', 'NP_116658.1','Inhibitor of the type I protein phosphatase Glc7p, which is involved in regulation of a variety of metabolic processes; overproduction causes decreased cellular content of glycogen; Ypi1p [Saccharomyces cerevisiae]','MSGNQMAMGSEQQQTVGSRTVSVEEVPAVLQLRATQDPPRSQEAMPTRHNVRWEENVIDNENMNKKKTKICCIFHPQNEDEEECNHHSDDDGSSSSGSSSSESENEKDLDFNERRQRRLERRHRKLEKKRSYSPNAYEIQPDYSEYRRKQQEKKD');
INSERT INTO proteininfo VALUES ('14318524', 'NP_116657.1','Part of complex at nuclear pore containing in addition NSP1p, NUP49p, and p54; 96 kDa nucleoporin-interacting component; Nic96p [Saccharomyces cerevisiae]','MLETLRGNKLHSGTSKGANKKLNELLESSDNLPSASSELGSIQVSINELRRRVFQLRSKNKASKDYTKAHYLLANSGLSFEDVDAFIKDLQTNQFLEPNPPKIIESEELEFYIRTKKEENILMSIEQLLNGATKDFDNFINHNLNLDWAQHKNEVMKNFGILIQDKKTVDHKKSISSLDPKLPSWGNKGNNILNSNESRLNVNENNILREKFENYARIVFQFNNSRQANGNFDIANEFISILSSANGTRNAQLLESWKILESMKSKDINIVEVGKQYLEQQFLQYTDNLYKKNMNEGLATNVNKIKSFIDTKLKKADKSWKISNLTVINGVPIWALIFYLLRAGLIKEALQVLVENKANIKKVEQSFLTYFKAYASSKDHGLPVEYSTKLHTEYNQHIKSSLDGDPYRLAVYKLIGRCDLSRKNIPAVTLSIEDWLWMHLMLIKEKDAENDPVYERYSLEDFQNIIISYGPSRFSNYYLQTLLLSGLYGLAIDYTYTFSEMDAVHLAIGLASLKLFKIDSSTRLTKKPKRDIRFANILANYTKSFRYSDPRVAVEYLVLITLNEGPTDVELCHEALRELVLETKEFTVLLGKIGRDGARIPGVIEERQPLLHVRDEKEFLHTITEQAARRADEDGRIYDSILLYQLAEEYDIVITLVNSLLSDTLSASDLDQPLVGPDDNSETNPVLLARRMASIYFDNAGISRQIHVKNKEICMLLLNISSIRELYFNKQWQETLSQMELLDLLPFSDELSARKKAQDFSNLDDNIVKNIPNLLIITLSCISNMIHILNESKYQSSTKGQQIDSLKNVARQCMIYAGMIQYRMPRETYSTLINIDVSL');
INSERT INTO proteininfo VALUES ('14318523', 'NP_116656.1','Nuclear protein involved in asymmetric localization of ASH1 mRNA; binds double-stranded RNA in vitro; Loc1p [Saccharomyces cerevisiae]','MAPKKPSKRQNLRREVAPEVFQDSQARNQLANVPHLTEKSAQRKPSKTKVKKEQSLARLYGAKKDKKGKYSEKDLNIPTLNRAIVPGVKIRRGKKGKKFIADNDTLTLNRLITTIGDKYDDIAESKLEKARRLEEIRELKRKEIERKEALKQDKLEEKKDEIKKKSSVARTIRRKNKRDMLKSEAKASESKTEGRKVKKVSFAQ');
INSERT INTO proteininfo VALUES ('14318522', 'NP_116655.1','Non-essential tRNA:pseudouridine synthase, introduces pseudouridines at position 38 or 39 in tRNA, important for maintenance of translation efficiency and normal cell growth, localizes to both the nucleus and cytoplasm; Deg1p [Saccharomyces cerevisiae]','MSNFIRRLVGKMKAISTGTNAIVSKKDSIYANWSKEQLIRRITELENANKPHSEKFQHIEDNKKRKISQEEVTRSKAKKAPKKFDFSKHNTRFIALRFAYLGWNYNGLAVQKEYTPLPTVEGTILEAMNKCKLVPSMVLQDYKFSRCGRTDKGVSAMNQVISLEVRSNLTDEEQRDPTNDSREIPYVHVLNQLLPDDIRISAVCLRPPPNFDARFSCVHRHYKYIFNGKNLNIEKMSKAASYFVGERDFRNFCKLDGSKQITNFKRTIISSKILPLSETFYCFDLVGSAFLWHQVRCMMAILFLVGQSLEVPEIVLRLTDIEKTPQRPVYEMANDIPLLLYDCKFPEMDWQEPTVDDYKAIKFTTATEALTLHYELKAAVCNIFKDVLPTANTNNFSKTIINLGDGRGKVVGTYVKLEDRSVMEPVEVVNAKYSKKKNNKNK');
INSERT INTO proteininfo VALUES ('14318521', 'NP_116654.1','involved in the maturation of 25S ribosomal RNA; ATP-dependent RNA helicase; Spb4p [Saccharomyces cerevisiae]','MSKSLEWDNLGFSLLPWIRTGLDVMGFETMTPVQASTIPMLAGNKDVVVDSVTGSGKTAAFVIPVLEKVVKEEANTSKFKKAHFHSLIIAPTRELSRQIESVVLSFLEHYPSDLFPIKCQLLVGTNEATVRDDVSNFLRNRPQILIGTPGRVLDFLQMPAVKTSACSMVVMDEADRLLDMSFIKDTEKILRLLPKQRRTGLFSATMRSAGSDIFKTGLRNPVRITVNSKNQAPSSLKLNYCVVNPAEKLQLLVSILNNYKFKKCIVYFPTCVSVSYFYSFIQYLGKRNILVNEVEIFSLHGKLQTSARTKTLTAFTDSLSNSVLFTTDVAARGIDIPDVDLVIQLDPPTNTDMFMHRCGRTGRANRVGKAITFLNEGREEDFIPFMQVKNVELEELDLEVKGITTNFYEDFRNWILEDRDRFDKGVKAYVAFIKYYSNHSATSIFRLQSLDYVGIAKLYGLFRLPRMPEITKYLATEKQEGIFPGNWLVDPPVNMDEYKYKDKKREKERQETLKNISLINDKKKLKSELKKKNLAWSDKTLTKERKLERKEKMSLKRKAIEEELKAEELDENAEEERIKEDWKEIVLQNKRKKVSSKAIQGNFDDL');
INSERT INTO proteininfo VALUES ('14318520', 'NP_116653.1','TyB Gag-Pol protein; proteolytically processed to make the Gag, RT, PR, and IN proteins that are required for retrotransposition; Yfl002w-ap [Saccharomyces cerevisiae]','MESQQLHQNPHSLHGSAYASVTSKEVPSNQDPLAVSASNLPEFDRDSTKVNSQQETTPGTSAVPENHHHVSPQPASVPPPQNGQYQQHGMMTPNKAMASNWAHYQQPSMMTCSHYQTSPAYYQPDPHYPLPQYIPPLSTSSPDPIDSQNQHSEVPQAETKVRNNVLPPHTLTSEENFSTWVKFYIRFLKNSNLGDIIPNDQGEIKSQMTYEEHAYIYNTFQAFAPFHLLPTWVKQILEINYADILTVLCKSVSKMQTNNQELKDWIALANLEYDGSTSADTFEITVSTIIQRLKENNINVSDRLACQLILKGLSGDFKYLRNQYRTKTNMKLSQLFAEIQLIYDENKIMNLNKPSQYKQHSEYKNVSRTSPNTTNTKVTTRNYHRTNSSKPRAAKAHNIATSSKFSRVNNDHINESTVSSQYLSDDNELSLGQQQKESKPTHTIDSNDELPDHLLIDSGASQTLVRSAHYLHHATPNSEINIVDAQKQDIPINAIGNLHFNFQNGTKTSIKALHTPNIAYDLLSLSELANQNITACFTRNTLERSDGTVLAPIVKHGDFYWLSKKYLIPSHISKLTINNVNKSKSVNKYPYPLIHRMLGHANFRSIQKSLKKNAVTYLKESDIEWSNASTYQCPDCLIGKSTKHRHVKGSRLKYQESYEPFQYLHTDIFGPVHHLPKSAPSYFISFTDEKTRFQWVYPLHDRREESILNVFTSILAFIKNQFNARVLVIQMDRGSEYTNKTLHKFFTNRGITACYTTTADSRAHGVAERLNRTLLNDCRTLLHCSGLPNHLWFSAVEFSTIIRNSLVSPKNDKSARQHAGLAGLDITTILPFGQPVIVNNHNPDSKIHPRGIPGYALHPSRNSYGYIIYLPSLKKTVDTTNYVILQDKQSKLDQFNYDTLTFDDDLNRLTAHNQSFIEQNETEQSYDQNTESDHDYQSEIEINSDPLVNDFSSQSINPLQLDKEPVQKVRAPKEVDADISEYNILPSTIRSRTPHIINKESTEMGGTVESDTTSPRHSSTFTARNQNRPGSTNEMIDLTSQDRVNYGLENIKTTRLGGTEEPYIQRNSDTNIKYRTTNSTPSIDDRSSNSESTTPIISIETKAVCDNTPSIDTDPPEYRSSDHATPNIMPDKSSKNVTADSILDDLPLPDLTHKSPTDTSDVSKDIPHIHSRQTNSSLGGMDDSNVLTTTKSKKRSLEDNETEIEVSRDTWNNKNMRSLEPPRSKKRINLIAAIKGVKSIKPVRTTLRYDEAITYNKDNKEKDRYVEAYHKEISQLLKMNTWDTNKYYDRNDIDPKKVINSMFIFNKKRDGTHKARFVARGDIQHPDTYDSDMQSNTVHHYALMTSLSIALDNDYYITQLDISSAYLYADIKEELYIRPPPHLGLNDKLLRLRKSLYGLKQSGANWYETIKSYLINCCDMQEVRGWSCVFKNSQVTICLFVDDMILFSKDLNANKKIITTLKKQYDTKIINLGESDNEIQYDILGLEIKYQRSKYMKLGMEKSLTEKLPKLNVPLNPKGKKLRAPGQPGHYIDQDELEIDEDEYKEKVHEMQKLIGLASYVGYKFRFDLLYYINTLAQHILFPSRQVLDMTYELIQFMWDTRDKQLIWHKNKPTKPDNKLVAISDASYGNQPYYKSQIGNIFLLNGKVIGGKSTKASLTCTSTTEAEIHAVSEAIPLLNNLSHLVQELNKKPIIKGLLTDSRSTISIIKSTNEEKFRNRFFGTKAMRLRDEVSGNNLYVYYIETKKNIADVMTKPLPIKTFKLLTNKWIH');
INSERT INTO proteininfo VALUES ('14318519', 'NP_116652.1','dispensable for DNA repair, required for full levels of reciprocal exchange and spore viability; meiosis specific protein, E.coli MutS protein, localizes to discrete sites on meiotic chromosomes; Msh4p [Saccharomyces cerevisiae]','MSESNLSSFISTNYFNLRSAANSSNSISKPSTKKSIRNQKSPTNISSWALKKKTLQIAETTWENNEKDSTHSHYLMTGSMASRTATSLSRYSTNASLLGPSIDCVLCCIYEVPRDISTRIGLCIINCNTGQMYLSDFMDSQIYIRVVHKLQIYQPTEILIPSSSLAPTVSKLATMIKFNVAETVKIEEGSRKCFNSQDGLAAITKYLMDDTKKDLKIEEIIDKTFALCAASAAISYMEEIISKSSRNLNAFRKLRIQFEGTENTMLIDSKTVRGLELVENKLDKNGISLWKFLDTTSTKMGQRSLRNSILQPLTDRGSIEMRLEALEELKANDDLLQKLRLEMKSLPDLDKLFSRLLCINHSAIKPDQRINYVLLLKETLQSVKSLKDALNDQLIQSRLISETKKIFNNDAIMEIEKLINSCINEDCVWASSAIQLLNQRSYAVKSDSNGLLDVSRQIYKEVKEEFFREVEDLTAKNKINLDHNYDSARGFYLRIKRQEFTDDVATLPDVFISRTIKKNYIECTTLNIIKKNARLKEVMEEILLLSEETVDELLDKIATHISELFMIAEAVAILDLVCSFTYNLKENNYTIPIFTNNLLIRDSRHPLLEKVLKNFVPNTISSTKHSSSLQIITGCNMSGKSVYLKQVALICIMAQMGSGIPALYGSFPVFKRLHARVCNDSMELTSSNFGFEMKEMAYFLDDINTETLLILDELGRGSSIADGFCVSLAVTEHLLRTEATVFLSTHFQDIPKIMSKKPAVSHLHMDAVLLNDNSVKMNYQLTQKSVAIENSGIRVVKKIFNPDIIAEAYNIHSLLKIAKARTENEDSNGVVDQKTINQMKRIHNLVAILKECAGNEKEPLTLGKLKEINSDFIENFEE');
INSERT INTO proteininfo VALUES ('14318518', 'NP_116651.1','Phosphate metabolism; transcription is regulated by PHO system; polyphosphate synthetase (putative); Vtc2p [Saccharomyces cerevisiae]','MLFGVKLANEVYPPWKGSYINYEGLKKFLKEDSVKDGSNDKKARWDDSDESKFVEELDKELEKVYGFQLKKYNNLMERLSHLEKQTDTEAAIKALDADAFQRVLEELLSESTELDNFKRLNFTGFAKIVKKHDKLYPKYPSVKSLLEVRLKELPSHSEEYSPLLYRISFLYNILRSNFNTASEPLASASKFSSIVSNDIDMNFRSFKFWVHNDNLMEVKTRILRHLPVLVYANVPSENDDLVNRFESDISNNDEIVGSSSSTSSVEHGLGARSFDPLINTLYFDNEHFELYNDKLLKLNSAPTLRLRWTGQLSDKPDIFLEKKTLIEDEATGKSEFDLTKLQLKQKFINGFIFEGDKKFKEQTLKKLKESGTAGRDLERLEEDFSEIQNFIIKNELQPVFRTVYTRTAFQIPGDDKIRVTIDSNIVFIKEDSFDRERPIRDPNTWHRTDIDANVANPLKFLRGGEYAKFPYSVMEIKVKSSLDSSMSASSMISNVKLPKKHGQWLNDLTNSHLVKEIPKFSIFVQGVASLYGDDEKLDILPFWLPDLETDIRQDPKQAYEEEKKKLLKQKEIQKKIDGMRRLSNLKEPQHQAAVPVSQEENERITSQGDLEADGSSDEETEQEPHSKRSKKVRRRKPKATFLRILAGRDPKLMGVDSEEEEIELPPGVKKPLNLLKNAGPVNVEAKVWLANERTFNRWLSVTSLLSVLTFSIYNSVKKAEYPTLANYMAYVYFGLTIFCALWSYSIYMKRVDIIQQRSGQHLDAPLGPVLVSIVLFVTLVVNFVMAFRNAAKSRQELQIQNLEVPERIPEVLRPLQNYLFKLMGPSSD');
INSERT INTO proteininfo VALUES ('14318517', 'NP_116650.1','Secretory vesicle associated Rab GTPase that binds to Sec15p and is essential for exocytosis; Ras-like small GTP-binding protein; Sec4p [Saccharomyces cerevisiae]','MSGLRTVSASSGNGKSYDSIMKILLIGDSGVGKSCLLVRFVEDKFNPSFITTIGIDFKIKTVDINGKKVKLQLWDTAGQERFRTITTAYYRGAMGIILVYDVTDERTFTNIKQWFKTVNEHANDEAQLLLVGNKSDMETRVVTADQGEALAKELGIPFIESSAKNDDNVNEIFFTLAKLIQEKIDSNKLVGVGNGKEGNISINSGSGNSSKSNCC');
INSERT INTO proteininfo VALUES ('14318514', 'NP_116647.1','coiled-coil protein involved in chromosome structure or segregation; SMC chromosomal ATPase family member; Smc1p [Saccharomyces cerevisiae]','MGRLVGLELSNFKSYRGVTKVGFGESNFTSIIGPNGSGKSNMMDAISFVLGVRSNHLRSNILKDLIYRGVLNDENSDDYDNEGAASSNPQSAYVKAFYQKGNKLVELMRIISRNGDTSYKIDGKTVSYKDYSIFLENENILIKAKNFLVFQGDVEQIAAQSPVELSRMFEEVSGSIQYKKEYEELKEKIEKLSKSATESIKNRRRIHGELKTYKEGINKNEEYRKQLDKKNELQKFQALWQLYHLEQQKEELTDKLSALNSEISSLKGKINNEMKSLQRSKSSFVKESAVISKQKSKLDYIFKDKEKLVSDLRLIKVPQQAAGKRISHIEKRIESLQKDLQRQKTYVERFETQLKVVTRSKEAFEEEIKQSARNYDKFKLNENDLKTYNCLHEKYLTEGGSILEEKIAVLNNDKREIQEELERFNKRADISKRRITEELSITGEKLDTQLNDLRVSLNEKNALHTERLHELKKLQSDIESANNQEYDLNFKLRETLVKIDDLSANQRETMKERKLRENIAMLKRFFPGVKGLVHDLCHPKKEKYGLAVSTILGKNFDSVIVENLTVAQECIAFLKKQRAGTASFIPLDTIETELPTLSLPDSQDYILSINAIDYEPEYEKAMQYVCGDSIICNTLNIAKDLKWKKGIRGKLVTIEGALIHKAGLMTGGISGDANNRWDKEEYQSLMSLKDKLLIQIDELSNGQRSNSIRAREVENSVSLLNSDIANLRTQVTQQKRSLDENRLEIKYHNDLIEKEIQPKITELKKKLDDLENTKDNLVKEKEALQNNIFKEFTSKIGFTIKEYENHSGELMRQQSKELQQLQKQILTVENKLQFETDRLSTTQRRYEKAQKDLENAQVEMKSLEEQEYAIEMKIGSIESKLEEHKNHLDELQKKFVTKQSELNSSEDILEDMNSNLQVLKRERDGIKEDIEKFDLERVTALKNCKISNINIPISSETTIDDLPISSTDNEAITISNSIDINYKGLPKKYKENNTDSARKELEQKIHEVEEILNELQPNARALERYDEAEGRFEVINNETEQLKAEEKKILNQFLKIKKKRKELFEKTFDYVSDHLDAIYRELTKNPNSNVELAGGNASLTIEDEDEPFNAGIKYHATPPLKRFKDMEYLSGGEKTVAALALLFAINSYQPSPFFVLDEVDAALDITNVQRIAAYIRRHRNPDLQFIVISLKNTMFEKSDALVGVYRQQQENSSKIITLDLSNYAE');
INSERT INTO proteininfo VALUES ('14318513', 'NP_116585.1','F-box protein which associates with and directs SCF complexes (ubiquitin-protein ligases) to substrates; Cdc4p [Saccharomyces cerevisiae]','MGSFPLAEFPLRDIPVPYSYRVSGGIASSGSVTALVTAAGTHRNSSTAKTVETEDGEEDIDEYQRKRAAGSGESTPERSDFKRVKHDNHKTLHPVNLQNTGAASVDNDGLHNLTDISNDAEKLLMSVDDGSAAPSTLSVNMGVASHNVAAPTTVNAATITGSDVSNNVNSATINNPMEEGALPLSPTASSPGTTTPLAKTTKTINNNNNIADLIESKDSIISPEYLSDEIFSAINNNLPHAYFKNLLFRLVANMDRSELSDLGTLIKDNLKRDLITSLPFEISLKIFNYLQFEDIINSLGVSQNWNKIIRKSTSLWKKLLISENFVSPKGFNSLNLKLSQKYPKLSQQDRLRLSFLENIFILKNWYNPKFVPQRTTLRGHMTSVITCLQFEDNYVITGADDKMIRVYDSINKKFLLQLSGHDGGVWALKYAHGGILVSGSTDRTVRVWDIKKGCCTHVFKGHNSTVRCLDIVEYKNIKYIVTGSRDNTLHVWKLPKESSVPDHGEEHDYPLVFHTPEENPYFVGVLRGHMASVRTVSGHGNIVVSGSYDNTLIVWDVAQMKCLYILSGHTDRIYSTIYDHERKRCISASMDTTIRIWDLENIWNNGECSYATNSASPCAKILGAMYTLQGHTALVGLLRLSDKFLVSAAADGSIRGWDANDYSRKFSYHHTNLSAITTFYVSDNILVSGSENQFNIYNLRSGKLVHANILKDADQIWSVNFKGKTLVAAVEKDGQSFLEILDFSKASKINYVSNPVNSSSSSLESISTSLGLTRTTIIP');
INSERT INTO proteininfo VALUES ('14318511', 'NP_116645.1','Protein required for the negative regulation by ammonia of Gap1p, which is a general amino acid permease; Aua1p [Saccharomyces cerevisiae]','MDRSLQVYICMYPYLDGSKQYRFDELISFYRPCPKSLDNIKSHYRQIHHQIRRRTHQHHQIRRRTHQHHHRSNCSRQRQCLVRHSCGRQMRVLA');
INSERT INTO proteininfo VALUES ('14318510', 'NP_116644.1','Putative hexose transporter, expressed at low levels and expression is repressed by glucose; Hxt10p [Saccharomyces cerevisiae]','MVSSSVSILGTSAKASTSLSRKDEIKLTPETREASLDIPYKPIIAYWTVMGLCLMIAFGGFIFGWDTGTISGFINQTDFKRRFGELQRDGSFQLSDVRTGLIVGIFNIGCALGGLTLGRLGDIYGRKIGLMCVILVYVVGIVIQIASSDKWYQYFIGRIVSGMGVGGVAVLSPTLISEISPKHLRGTCVSFYQLMITLGIFLGYCTNYGTKKYSNSIQWRVPLGLCFAWAIFMVIGMVMVPESPRYLVEKGKYEEARRSLAKSNKVTVTDPGVVFEFDTIVANMELERAVGNASWHELFSNKGAILPRVIMGIVIQSLQQLTGCNYFFYYGTTIFNAVGMQDSFETSIVLGAVNFASTFVALYIVDKFGRRKCLLWGSASMAICFVIFATVGVTRLWPQGKDQPSSQSAGNVMIVFTCFFIFSFAITWAPIAYVIVAETYPLRVKNRAMAIAVGANWMWGFLIGFFTPFITRSIGFSYGYVFMGCLIFSYFYVFFFVCETKGLTLEEVNEMYEERIKPWKSGGWIPSSRRTPQPTSSTPLVIVDSK');
INSERT INTO proteininfo VALUES ('14318509', 'NP_116643.1','Hypothetical ORF; Yfl012wp [Saccharomyces cerevisiae]','MPKSRPKRTIASSSSVFYGSSPFQNDGYIKVMELVSHIVIEINHSPTATTDETRKQNNPELKVKEPVCNLKKWENNTNFILEDHTKNKTKLSSTDRIRKWFRRHILKEEIEILSHGKQLSSIDEDYCPSNVLVGCSRDLNKLRSFQNF');
INSERT INTO proteininfo VALUES ('14318508', 'NP_116641.1','Subunit of the INO80 chromatin remodeling complex; Ies1p [Saccharomyces cerevisiae]','MGKRVYDPIHDTFQLREDNSDETKADSPMQSVKSGSQEEASPSSIQSETETVTTKSIPVIHEIEIDDKNDDDSTQSEEENTNILLNFEPSTVPEATGASTATGPVTTNTVRRKPKESNASKYNRHLKKPDGEPFNRKDIQFSFMQELLMDKRQIFTNVLKPLYKNSIVPINIDGDKLSINVTDKEYDARTFVFNDKLTFAQLYVLTIATSIKCSKILRDKLLLDQQVAFSTCVLALLVNIGRLNTTINFYLEMTSQLRTFHSVPVLQLHANDPKLLQDTPRLKSILKNLPWGNEQLSLMETYKKVDQNDGEVDTVNKFNIINMLFSICDNSGLIDKRFLSKYVEVESKAQEQDMVDEQNEVKETEAENEKQESKAAYATTLFDILDYSKYEPKDRSNILIWLLYIHLETNLSQEEVEESVRFFNGLEDGAPAGKFILRCTERSYDTDPEDELEFGANQRIKRREFMSKMEEGRKRERTNVTEVKKPSIGGDKSEEDGEGEDDKSEETVEETRSLLTPTPILESSSPMTLNRKKVTPQLPKVTPAAPTETEEEITSAAIIDKNDLNLTPLKKYNSSATVNKVDKLISLDLNKHVSENGKTQEEFLADLKKSQVPNRLKRRDIGLIKIFNEFEDIPVASVLGIRGKKRKKFKDNLLGFETDFMKNLGASKKVLLNKIERAEIDDEEATAMFKLE');
INSERT INTO proteininfo VALUES ('14318506', 'NP_116640.1','Plasma membrane localized protein that protects membranes from dessication; induced by heat shock, oxidative stress, osmostress, stationary phase entry, glucose depletion, oleate and alcohol; regulated by the HOG and Ras-Pka pathways; Hsp12p [Saccharomyces cerevisiae]','MSDAGRKGFGEKASEALKPDSQKSYAEQGKEYITDKADKVAGKVQPEDNKGVFQGVHDSAEKGKDNAEGQGESLADQARDYMGAAKSKLNDAVEYVSGRVHGEEDPTKK');
INSERT INTO proteininfo VALUES ('14318504', 'NP_116638.1','involved in protection against heat-induced protein aggregation but not necessary for protein import into the mitochondrion; DnaJ homolog involved in mitochondrial biogenesis and protein folding; Mdj1p [Saccharomyces cerevisiae]','MAFQQGVLSRCSGVFRHHVGHSRHINNILYRHAIAFASIAPRIPKSSFHTSAIRNNEAFKDPYDTLGLKKSATGAEIKKAYYKLAKKYHPDINKEPDAEKKFHDLQNAYEILSDETKRQQYDQFGPAAFGGGGAAGGAGGGSGSPFGSQFHDFSGFTSAGGSPFGGINFEDLFGAAFGGGGRGSGGASRSSSMFRQYRGDPIEIVHKVSFKDAVFGSKNVQLRFSALDPCSTCSGTGMKPNTHKVSCSTCHGTGTTVHIRGGFQMMSTCPTCNGEGTMKRPQDNCTKCHGEGVQVNRAKTITVDLPHGLQDGDVVRIPGQGSYPDIAVEADLKDSVKLSRGDILVRIRVDKDPNFSIKNKYDIWYDKEIPITTAALGGTVTIPTVEGQKIRIKVAPGTQYNQVISIPNMGVPKTSTIRGDMKVQYKIVVKKPQSLAEKCLWEALADVTNDDMAKKTMQPGTAAGTAINEEILKKQKQEEEKHAKKDDDNTLKRLENFITNTFRKIKGDKKN');
INSERT INTO proteininfo VALUES ('14318503', 'NP_116637.1','involved in UDP-N-acetylglucosamine biosynthesis; glucosamine-phosphate N-acetyltransferase; Gna1p [Saccharomyces cerevisiae]','MSLPDGFYIRRMEEGDLEQVTETLKVLTTVGTITPESFSKLIKYWNEATVWNDNEDKKIMQYNPMVIVDKRTETVAATGNIIIERKIIHELGLCGHIEDIAVNSKYQGQGLGKLLIDQLVTIGFDYGCYKIILDCDEKNVKFYEKCGFSNAGVEMQIRK');
INSERT INTO proteininfo VALUES ('14318502', 'NP_116636.1','snRNP G protein (the homologue of the human Sm-G); Smx2p [Saccharomyces cerevisiae]','MVSTPELKKYMDKKILLNINGSRKVAGILRGYDIFLNVVLDDAMEINGEDPANNHQLGLQTVIRGNSIISLEALDAI');
INSERT INTO proteininfo VALUES ('14318501', 'NP_116635.1','Dihydrolipoamide dehydrogenase, the lipoamide dehydrogenase component (E3) of the pyruvate dehydrogenase and 2-oxoglutarate dehydrogenase multi-enzyme complexes; Lpd1p [Saccharomyces cerevisiae]','MLRIRSLLNNKRAFSSTVRTLTINKSHDVVIIGGGPAGYVAAIKAAQLGFNTACVEKRGKLGGTCLNVGCIPSKALLNNSHLFHQMHTEAQKRGIDVNGDIKINVANFQKAKDDAVKQLTGGIELLFKKNKVTYYKGNGSFEDETKIRVTPVDGLEGTVKEDHILDVKNIIVATGSEVTPFPGIEIDEEKIVSSTGALSLKEIPKRLTIIGGGIIGLEMGSVYSRLGSKVTVVEFQPQIGASMDGEVAKATQKFLKKQGLDFKLSTKVISAKRNDDKNVVEIVVEDTKTNKQENLEAEVLLVAVGRRPYIAGLGAEKIGLEVDKRGRLVIDDQFNSKFPHIKVVGDVTFGPMLAHKAEEEGIAAVEMLKTGHGHVNYNNIPSVMYSHPEVAWVGKTEEQLKEAGIDYKIGKFPFAANSRAKTNQDTEGFVKILIDSKTERILGAHIIGPNAGEMIAEAGLALEYGASAEDVARVCHAHPTLSEAFKEANMAAYDKAIHC');
INSERT INTO proteininfo VALUES ('14318499', 'NP_116633.1','Part of 23-member seripauperin multigene family encoded mainly in subtelomeric regions, active during alcoholic fermentation, regulated by anaerobiosis, negatively regulated by oxygen, repressed by heme; Pau5p [Saccharomyces cerevisiae]','MVKLTSIAAGVAAIAAGASAAATTTLSQSDERVNLVELGVYVSDIRAHLAEYYSFQAAHPTETYPVEIAEAVFNYGDFTTMLTGIPADQVTRVITGVPWYSSRLKPAISSALSADGIYTIAN');
INSERT INTO proteininfo VALUES ('14318498', 'NP_116632.1','Transcriptional activator of genes involved in nitrogen catabolite repression, member of the GATA family of DNA binding proteins; activity and localization regulated by nitrogen limitation and Ure2p; Gat1p [Saccharomyces cerevisiae]','MHVFFPLLFRPSPVLFIACAYIYIDIYIHCTRCTVVNITMSTNRVPNLDPDLNLNKEIWDLYSSAQKILPDSNRILNLSWRLHNRTSFHRINRIMQHSNSIMDFSASPFASGVNAAGPGNNDLDDTDTDNQQFFLSDMNLNGSSVFENVFDDDDDDDDVETHSIVHSDLLNDMDSASQRASHNASGFPNFLDTSCSSSFDDHFIFTNNLPFLNNNSINNNHSHNSSHNNNSPSIANNTNANTNTNTSASTNTNSPLLRRNPSPSIVKPGSRRNSSVRKKKPALKKIKSSTSVQSSATPPSNTSSNPDIKCSNCTTSTTPLWRKDPKGLPLCNACGLFLKLHGVTRPLSLKTDIIKKRQRSSTKINNNITPPPSSSLNPGAAGKKKNYTASVAASKRKNSLNIVAPLKSQDIPIPKIASPSIPQYLRSNTRHHLSSSVPIEAETFSSFRPDMNMTMNMNLHNASTSSFNNEAFWKPLDSAIDHHSGDTNPNSNMNTTPNGNLSLDWLNLNL');
INSERT INTO proteininfo VALUES ('14318497', 'NP_116631.1','Alpha subunit of cytoplasmic phenylalanyl-tRNA synthetase; Frs2p [Saccharomyces cerevisiae]','MSDFQLEILKKLDELDEIKSTLATFPQHGSQDVLSALNSLKAHNKLEFSKVDTVTYDLTKEGAQILNEGSYEIKLVKLIQELGQLQIKDVMSKLGPQVGKVGQARAFKNGWIAKNASNELELSAKLQNTDLNELTDETQSILAQIKNNSHLDSIDAKILNDLKKRKLIAQGKITDFNVTKGPEFSTDLTKLETDLTSDMVSTNAYKDLKFKPYNFNSQGVQISSGALHPLNKVREEFRQIFFSMGFTEMPSNQYVETGFWNFDALYVPQQHPARDLQDTFYIKDPLTADLPDDKTYMDNIKAVHEQGRFGSIGYRYNWKPEECQKLVLRTHSTAISARMLHDLAKDPKPTRLFSIDRVFRNEAVDATHLAEFHQVEGVLADYNITLGDLIKFMEEFFERMGVTGLRFKPTYNPYTEPSMEIFSWHEGLQKWVEIGNSGMFRPEMLESMGLPKDLRVLGWGLSLERPTMIKYKVQNIRELLGHKVSLDFIETNPAARLDEDLYE');
INSERT INTO proteininfo VALUES ('14318495', 'NP_116629.1','Component of NuA4, which is an essential histone H4/H2A acetyltransferase complex; homologous to Drosophila Enhancer of Polycomb; Epl1p [Saccharomyces cerevisiae]','MPTPSNAIEINDGSHKSGRSTRRSGSRSAHDDGLDSFSKGDSGAGASAGSSNSRFRHRKISVKQHLKIYLPNDLKHLDKDELQQREVVEIETGVEKNEEKEVHLHRILQMGSGHTKHKDYIPTPDASMTWNEYDKFYTGSFQETTSYIKFSATVEDCCGTNYNMDERDETFLNEQVNKGSSDILTEDEFEILCSSFEHAIHERQPFLSMDPESILSFEELKPTLIKSDMADFNLRNQLNHEINSHKTHFITQFDPVSQMNTRPLIQLIEKFGSKIYDYWRERKIEVNGYEIFPQLKFERPGEKEEIDPYVCFRRREVRHPRKTRRIDILNSQRLRALHQELKNAKDLALLVAKRENVSLNWINDELKIFDQRVKIKNLKRSLNISGEDDDLINHKRKRPTIVTVEQREAELRKAELKRAAAAAAAAKAKNNKRNNQLEDKSSRLTKQQQQQLLQQQQQQQQNALKTENGKQLANASSSSTSQPITSHVYVKLPSSKIPDIVLEDVDALLNSKEKNARKFVQEKMEKRKIEDADVFFNLTDDPFNPVFDMSLPKNFSTSNVPFASIASSKFQIDRSFYSSHLPEYLKGISDDIRIYDSNGRSRNKDNYNLDTKRIKKTELYDPFQENLEIHSREYPIKFRKRVGRSNIKYVDRMPNFTTSSTKSACSLMDFVDFDSIEKEQYSREGSNDTDSINVYDSKYDEFVRLYDKWKYDSPQNEYGIKFSDEPARLNQISNDTQVIRFGTMLGTKSYEQLREATIKYRRDYITRLKQKHIQHLQQQQQQQQQQQQQAQQQKQKSQNNNSNSSNSLKKLNDSLINSEAKQNSSITQKNSS');
INSERT INTO proteininfo VALUES ('14318494', 'NP_116628.1','Protein that negatively regulates COPII vesicle formation; functionally complements mammalian PGAP1, which is a GPI inositol-deacylase involved in GPI maturation; negative regulator of COPII vesicle formation; Bst1p [Saccharomyces cerevisiae]','MGIRRLVSVITRPIINKVNSSGQYSRVLATREDQDKASPKYMNNDKIAKKPYTYRLFSILGILSICSLLLISLLKPFNGADAPQCESIYMFPSYARIDGFDERYTPLAHKYHLYLYREQSVDREPLNGDELQLDGIPVLFIPGNAGSFRQCRSIASACSNIYFDSNTRATLRNENVRNLDFFTADFNEDFTAFHGETMLDQAEYLNDAIKYILSLYERTPDYPHPKPQSVIIVGHSMGGIVSRVMLTLKNHVPGSISTILTLSSPHAASPVTFDGDILKLYKNTNEYWRKQLSQNDSFFSKNISLVSITGGILDTTLPADYASVEDLVSLENGFTSFTTTIPDVWTPIDHLAIVWCKQLREVLARLLLESIDASKPEKVKPLNQRLQIARKLLLSGFEDYSWMNSKLNYPQENLQEFSDNFFSDYATLEMNDVLDFEMFNLEKWHNNYTKINIPSNISSTEHLHFTLLTSLDMPMIYFCTESRVNLSCITAVDSILTVPRSSKDTQFAADSSFGEAKNPFKAVSVGKNILQKYDYLMISKPTYGEFSEQEGMEDNQGFLLALLRNVSNVQIVNTTPSQILLFGEQLHLDGKDIEQVISFSNLWDSLLSYKLETKIEASNEGIASEETLFQPFIRQWVYEPFESKWHLNIINKSLDINMHNVAPFIPLNESEPRSLQLSFFIPPGMSLEAKMTINWSLTLKMLFIRYRLALASFPVAFIALVLSYQFYWYNKTSEFPSFDSTLGYILRKHGILMFFTLFLASPVVNNKLVQRILYLLDPVGLNYPFLLSERNMHANFYYLGIRDWFMSTIGILFGVMTVGLLALVSKIFGSLEILVIFLQRKLSKKNTEDKEAFDTIEHKAYGKGRLMASVLLLLLVFFHIPYQMAFVISLVIQIATCIRVALLKLSNNEQKLNLLNYNMTLLLLLLFVSAINIPIIIVFLHNVAIKWETSFRSHHNILAVAPIIFLVGNNSIFKMPNSVPLDTWDGKVTIILFVYLTVFSFIYGIRNLYWIHHLVNIICAWLLFFETIH');
INSERT INTO proteininfo VALUES ('14318493', 'NP_116627.1','alpha-factor pheromone receptor; seven-transmembrane domain protein; Ste2p [Saccharomyces cerevisiae]','MSDAAPSLSNLFYDPTYNPGQSTINYTSIYGNGSTITFDELQGLVNSTVTQAIMFGVRCGAAALTLIVMWMTSRSRKTPIFIINQVSLFLIILHSALYFKYLLSNYSSVTYALTGFPQFISRGDVHVYGATNIIQVLLVASIETSLVFQIKVIFTGDNFKRIGLMLTSISFTLGIATVTMYFVSAVKGMIVTYNDVSATQDKYFNASTILLASSINFMSFVLVVKLILAIRSRRFLGLKQFDSFHILLIMSCQSLLVPSIIFILAYSLEPNQGTDVLTTVATLLAVLSLPLSSMWATAANNASKTNTITSDFTTSTDRFYPGTLSSFQTDSINNDAKSSLRSRLYDLYPRRKETTSDKHSERTFVSETADDIEKNQFYQLPTPTSSKNTRIGPFADASYKEGEVEPVDMYTPDTAADEEARKFWTEDNNNL');
INSERT INTO proteininfo VALUES ('14318491', 'NP_116625.1','CCR4 associated factor; ABC ATPase; Caf16p [Saccharomyces cerevisiae]','MVSQFAIEVRNLTYKFKESSDPSVVDINLQIPWNTRSLVVGANGAGKSTLLKLLSGKHLCLDGKILVNGLDPFSPLSMNQVDDDESVEDSTNYQTTTYLGTEWCHMSIINRDIGVLELLKSIGFDHFRERGERLVRILDIDVRWRMHRLSDGQKRRVQLAMGLLKPWRVLLLDEVTVDLDVIARARLLEFLKWETETRRCSVVYATHIFDGLAKWPNQVYHMKSGKIVDNLDYQKDVEFSEVVNAKVNGQVAFENDNNKVVISKVNSLHPLALEWLKRDNQIPDKEIGI');
INSERT INTO proteininfo VALUES ('14318490', 'NP_116624.1','binds and phosphorylates Cdc28p; Cyclin-dependent kinase-activating kinase; Cak1p [Saccharomyces cerevisiae]','MKLDSIDITHCQLVKSTRTARIYRSDTYAIKCLALDFDIPPHNAKFEVSILNKLGNKCKHILPLLESKATDNNDLLLLFPFEEMNLYEFMQMHYKRDRRKKNPYYDLLNPSIPIVADPPVQKYTNQLDVNRYSLSFFRQMVEGIAFLHENKIIHRDIKPQNIMLTNNTSTVSPKLYIIDFGISYDMANNSQTSAEPMDSKVTDISTGIYKAPEVLFGVKCYDGGVDVWSLLIIISQWFQRETSRMGHVPAMIDDGSDDMNSDGSDFRLICSIFEKLGIPSIQKWEEVAQHGSVDAFVGMFGADGDGKYVLDQEKDVQISIVERNMPRLDEIADVKVKQKFINCILGMVSFSPNERWSCQRILQELEKP');
INSERT INTO proteininfo VALUES ('14318489', 'NP_116623.1','Alanine : glyoxylate aminotransferase, catalyzes the synthesis of glycine from glyoxylate, which is one of three pathways for glycine biosynthesis in yeast; has similairty to mammalian and plant alanine : glyoxylate aminotransferases; Agx1p [Saccharomyces cerevisiae]','MTKSVDTLLIPGPIILSGAVQKALDVPSLGHTSPEFVSIFQRVLKNTRAVFKSAAASKSQPFVLAGSGTLGWDIFASNFILSKAPNKNVLVVSTGTFSDRFADCLRSYGAQVDVVRPLKIGESVPLELITEKLSQNSYGAVTVTHVDTSTAVLSDLKAISQAIKQTSPETFFVVDAVCSIGCEEFEFDEWGVDFALTASQKAIGAPAGLSISLCSSRFMDYALNDSKNGHVHGYFSSLRRWTPIMENYEAGKGAYFATPPVQLINSLDVALKEILEEGLHKRWDLHREMSDWFKDSLVNGLQLTSVSRYPSNMSAHGLTAVYVADPPDVIAFLKSHGVVIAGGIHKDIGPKYIRIGHMGVTACNKNLPYMKNCFDLIKLALQRKK');
INSERT INTO proteininfo VALUES ('14318488', 'NP_116622.1','bZIP transcription factor (ATF/CREB1 homolog) that regulates the unfolded-protein response, via UPRE binding, and membrane biogenesis; ER stress-induced splicing pathway utilizing Ire1p, Trl1p and Ada5p facilitates efficient Hac1p synthesis; Hac1p [Saccharomyces cerevisiae]','MEMTDFELTSNSQSNLAIPTNFKSTLPPRKRAKTKEEKEQRRIERILRNRRAAHQSREKKRLHLQYLERKCSLLENLLNSVNLEKLADHEDALTCSHDAFVASLDEYRDFQSTRGASLDTRASSHSSSDTFTPSPLNCTMEPATLSPKSMRDSASDQETSWELQMFKTENVPESTTLPAVDNNNLFDAVASPLADPLCDDIAGNSLPFDNSIDLDNWRNPEAQSGLNSFELNDFFITS');
INSERT INTO proteininfo VALUES ('14318486', 'NP_116620.1','RIM15 is glucose-repressed; RIM15 is required for IME2 expression; Trehalose-associated protein kinase related to S. pombe cek1+; Rim15p [Saccharomyces cerevisiae]','MFNRSNTAGGSQAMKEGLGINKLSPISSNSNPSSLTSSNYEKYLQLATEKNPCMILELELDGKVRYGSPQWNTITGVADDSGSSPTYIADLILGSDQDKGVFQKATDMLLMNDDTSCTITFKIKAADYEGSAGCDDESTITTLEARGILIRDGHTQLPSHTMWIVKPRTNDWSDFYANEDAQDDMVIQLSDNCDDIDIQLPEEFAKTLGFGAKIFVQYLKRIRLEMIIDEFNLPLPKMELCRVCENFVPVWWLETHSQSCVCEHRTESLIQLLHDNLLEQQAILANFTKDSEYKGSQIQVRSNNFLNQVLDSLRELCQDAIDINPSEMVPDLYHSLSTFPQDNGNNNNNNNNNNNNNNALLDQFPIQKDTVSLNSYFQFSPRTNHNIQNVTSWQSRFFLNDDQDPGLALLIHDTLDLARKKVDAVLRLDNAMTYSLKIKNEVNNYVVQLIREQIEINKHAILTHPMNLRSSSIFHSPLPQIHSQQPEAENLIYSSSTPLQVQHDQCASFEAPSKSHLEPIPFPVSSIEETPTANDIRHPSPLPRSCSNTVMKLPTPRRKLDSNGLFSDAYLNADIIPNPSIESTISIDRDNNTNSRGSSMKQYGIGEATDSRTSNSERPSSSSSRLGIRSRSITPRQKIEYSHVDNDDRTNEMLSRDKDSLQPQPSVDTTITSSTQATTTGTKTNSNNSTNSVLPKLMTSISLTPRRGSPSFGNLASHSMQQTNSFKLIHDKSPISSPFTFSKDFLTPEQHPSNIARTDSINNAMLTSPNMPLSPLLLATNQTVKSPTPSIKDYDILKPISKGAYGSVYLARKKLTGDYFAIKVLRKSDMIAKNQVTNVKSERAIMMVQSDKPYVARLFASFQNKDNLFLVMEYLPGGDLATLIKMMGYLPDQWAKQYLTEIVVGVNDMHQNGIIHHDLKPENLLIDNAGHVKLTDFGLSRAGLIRRHKFVPHKSSLSISSTLPIDNPANNFTMNNNNSNHSQLSTPDSFTSDHKQYNRSKKSSLGQQYEHSEYSSTSNSHSMTPTPSTNTVVYPSYYRGKDRSHGSSNIDLPASLRRSESQLSFSLLDISRSSTPPLANPTNSNANNIMRRKSLTENKSFSNDLLSSDAIAATNTNINSNNNISLSPAPSDLALFYPDDSKQNKKFFGTPDYLAPETIEGKGEDNKQCDWWSVGCIFFELLLGYPPFHAETPDAVFKKILSGVIQWPEFKNEEEEREFLTPEAKDLIEKLLVVDPAKRLGAKGIQEIKDHPYFKNVDWDHVYDEEASFVPTIDNPEDTDYFDLRGAELQDFGDDIENDNANILFGKHGINTDVSELSAANLSPPLNHKNILSRKLSMSNTTNRSSNNSNSSVHDFGAHTPVNKLSIASVLESVPQETGYITPNGTGTTTTSAKNSPNLKNLSLAIPPHMRDRRSSKLNDSQTEFGSFNFRNLSALDKANKDAINRLKSEHFSEQPGVHRRTSSASLMGSSSDGSVSTPGSNASNTTSGGKLKIHKPTISGSPSTFGTFPKTFLRSDSFSTRSYSPERSISIDSSTLSRKGSIIGDNQQTTANSSDSPTMTKFKSPLSPANTTTVSSYFSRQRVLSKSFSQRTNSSDLSAEESDRLQAISRVNSLRNRRRSGRKSSSTSEIGYHMDVLVCEPIPIHRYRVTKDLENLGCTVVSVGAGDELVSRATSGVSFDLIMTALKLPKLGAIDIVQLLKQTNGANSTTPIVAITNYFQEAATSRVFDDVLEKPVKLDELKKLVAKYALKKSQEDEEHTILSDSDETH');
INSERT INTO proteininfo VALUES ('14318485', 'NP_116583.1','Possible integral membrane protein that interacts with Rpp0p, which is a component of the ribosomal stalk; Yfl034wp [Saccharomyces cerevisiae]','MSDSEEDLGVQLKGLKIARHLKESGEHTDEESNSSPEHDCGLSNQDDLTVMHTQAKEEVFKRREEDGTRTEDALHEGEAGKEGTGFPSSQSVCSPNEADSGIDRADKPILLDPFKSVHDTDPVPGTKSRSNSDSDSDSDDGGWQEMPAVSSFNIYNHRGELELTSKVRNSEQASETSPTVPPGKNCKSVNDSRFDYTKMAAEQQAQRSYRTNKKTDFLFDHKVLKKKINSSQTSVNLTSSPSTTSLNNEKNNDDDDDDSYDEYEDDVEPVNDLNRDSQLNITKNLLSDMEKFAYVGAINILANQMCTNLATLCLCIDIKSHKNLAHRLQFTQKDMAAWKTVVLSRLYDHLGISQEEIVMIEKLSLHKIQLEDLCKCLKTTQSIDNPWENDRDHEEDGIEETTERMSPNEQNGSVQASTPDPEQSATPETPKAKQSPLSSDVPGKVLDPENVKSQDKLNIDVAWTIICDLFLICLQSSTYDSRSRTLLINFAKVLNMTSLEICEFERRVTDSLDMEQSTEDQVWDEQDHMRNRRRSKRRKKMAYVALAMVGGSLVLGLSGGLLAPVIGGGIAAGLSTIGITGATSFLTGVGGTTVVAVSSTAIGANIGARGMSKRMGSVRTFEFRPLHNNRRVNLILTVSGWMVGNEDDVRLPFSTVDPVEGDLYSLYWEPEMLKSIGQTVSIVATEIFTTSLQQILGATVLTALISSIQWPMALSKLGYILDNPWNVSLDRAWSAGKILADTLIARNLGARPITLVGFSIGARVIFSCLIELCKKKALGLIENVYLFGTPAVMKKEQLVMARSVVSGRFVNGYSDKDWFLAYLFRAAAGGFSAVMGISTIENVEGIENINCTEFVDGHLNYRKSMPKLLKRIGIAVLSEEFVEIEEMMNPEEVKRKRKLINDVDAAQKKLSERKKHNSWVPKWLKPKKSKWKVMVEEAVEEGRDMQDLPENDVNNNENENPDEHEGIARQKRRDAALVDHGALMHELQLIKQAMHEDEIKNKACLPGEDKEVESSNDFLGESHYKPPSTPKINPPQSPNNFQLLSAGRTILPEDDDFDPRGKKKVEFSFPDDI');
INSERT INTO proteininfo VALUES ('14318484', 'NP_116619.1','Protein component of the large (60S) ribosomal subunit, has similarity to Rpl22Ap and to rat L22 ribosomal protein; Rpl22bp [Saccharomyces cerevisiae]','MAPNTSRKQKVIKTLTVDVSSPTENGVFDPASYSKYLIDHIKVDGAVGNLGNAIEVTEDGSIVTVVSSAKFSGKYLKYLTKKYLKKNQLRDWIRFVSIRQNQYKLVFYQVTPEDADEEEDDE');
INSERT INTO proteininfo VALUES ('14318483', 'NP_116618.1','Component of the RAM signalling netwrok, localizes and activates the Ace2p in the daughter cell nucleus to direct daughter cell-specific transcription of several genes involved in cell separation; Mob1p-like protein; Mob2p [Saccharomyces cerevisiae]','MSFFNFKAFGRNSKKNKNQPLNVAQPPAMNTIYSSPHSSNSRLSLRNKHHSPKRHSQTSFPAQKSTPQSQQLTSTTPQSQQQEASERSESQQIMFLSEPFVRTALVKGSFKTIVQLPKYVDLGEWIALNVFEFFTNLNQFYGVVAEYVTPDAYPTMNAGPHTDYLWLDANNRQVSLPASQYIDLALTWINNKVNDKNLFPTKNGLPFPQQFSRDVQRIMVQMFRIFAHIYHHHFDKIVHLSLEAHWNSFFSHFISFAKEFKIIDRKEMAPLLPLIESFEKQGKIIYN');
INSERT INTO proteininfo VALUES ('14318482', 'NP_116617.1','mitochondrial RNA polymerase; Rpo41p [Saccharomyces cerevisiae]','MLRPAYKSLVKTSLLQRRLISSKGSKLFKPSPDSTSTILISEDPLVTGSSPTSSTTSGIISSNDFPLFNKNRKDAKSSISYQWKNPSELEFDPFNKSHASAVTSMTRTRDVMQLWSLLEACLQSNLMKRAFSILESLYLVPEHKQRFIEDYNMYLNSFSKNDPNFPILKMNEKLTNDLETSFKDVNYNDKTLAIMIHHALNFHSTTSSMLLKPIISAYLKMSVNGIREIFSCLDILTISDLNILMNDLKVITPSQLPNSVRPILESLTLSPTPVNNIENEEGLNKVEAENDSKLHKASNASSDSIKKPSLDPLREVSFHGSTEVLSKDAEKLIAVDTIGMRVIRHTLLGLSLTPEQKEQISKFKFDANDNVLKMKPTKNDDNNNSINFFEIYNSLPTLEEKKAFESALNIFNQDRQKVLENRATEAARERWKHDFEEAKARGDISIEKNLNVKLWKWYNEMLPLVKEEINHCRSLLSEKLSDKKGLNKVDTNRLGYGPYLTLIDPGKMCVITILELLKLNSTGGVIEGMRTARAVISVGKAIEMEFRSEQVLKSESQAFRDVNKKSPEFKKLVQNAKSVFRSSQIEQSKILWPQSIRARIGSVLISMLIQVAKVSVQGVDPVTKAKVHGEAPAFAHGYQYHNGSKLGVLKIHKTLIRQLNGERLIASVQPQLLPMLVEPKPWVNWRSGGYHYTQSTLLRTKDSPEQVAYLKAASDNGDIDRVYDGLNVLGRTPWTVNRKVFDVVSQVWNKGEGFLDIPGAQDEMVLPPAPPKNSDPSILRAWKLQVKTIANKFSSDRSNRCDTNYKLEIARAFLGEKLYFPHNLDFRGRAYPLSPHFNHLGNDMSRGLLIFWHGKKLGPSGLKWLKIHLSNLFGFDKLPLKDRVAFTESHLQDIKDSAENPLTGDRWWTTADKPWQALATCFELNEVMKMDNPEEFISHQPVHQDGTCNGLQHYAALGGDVEGATQVNLVPSDKPQDVYAHVARLVQKRLEIAAEKGDENAKILKDKITRKVVKQTVMTNVYGVTYVGATFQIAKQLSPIFDDRKESLDFSKYLTKHVFSAIRELFHSAHLIQDWLGESAKRISKSIRLDVDEKSFKNGNKPDFMSSVIWTTPLGLPIVQPYREESKKQVETNLQTVFISDPFAVNPVNARRQKAGLPPNFIHSLDASHMLLSAAECGKQGLDFASVHDSYWTHASDIDTMNVVLREQFIKLHEVDLVLRLKEEFDQRYKNYVKIGKLKRSTDLAQKIIRIRKDLSRKLGRSTTLADEIYFEKKRQELLNSPLIEDRNVGEKMVTTVSLFEDITDLDALELENGGDENSGMSVLLPLRLPEIPPKGDFDVTVLRNSQYFFS');
INSERT INTO proteininfo VALUES ('14318481', 'NP_116616.1','Beta-tubulin; associates with alpha-tubulin (Tub1p and Tub3p) to form tubulin dimer, which polymerizes to form microtubules; Tub2p [Saccharomyces cerevisiae]','MREIIHISTGQCGNQIGAAFWETICGEHGLDFNGTYHGHDDIQKERLNVYFNEASSGKWVPRSINVDLEPGTIDAVRNSAIGNLFRPDNYIFGQSSAGNVWAKGHYTEGAELVDSVMDVIRREAEGCDSLQGFQITHSLGGGTGSGMGTLLISKIREEFPDRMMATFSVLPSPKTSDTVVEPYNATLSVHQLVEHSDETFCIDNEALYDICQRTLKLNQPSYGDLNNLVSSVMSGVTTSLRYPGQLNSDLRKLAVNLVPFPRLHFFMVGYAPLTAIGSQSFRSLTVPELTQQMFDAKNMMAAADPRNGRYLTVAAFFRGKVSVKEVEDEMHKVQSKNSDYFVEWIPNNVQTAVCSVAPQGLDMAATFIANSTSIQELFKRVGDQFSAMFKRKAFLHWYTSEGMDELEFSEAESNMNDLVSEYQQYQEATVEDDEEVDENGDFGAPQNQDEPITENFE');
INSERT INTO proteininfo VALUES ('14318480', 'NP_116615.1','Ras-like small GTPase, involved in the ER-to-Golgi step of the secretory pathway; complex formation with the Rab escort protein Mrs6p is required for prenylation of Ypt1p by protein geranylgeranyltransferase type II (Bet2p-Bet4p); Ypt1p [Saccharomyces cerevisiae]','MNSEYDYLFKLLLIGNSGVGKSCLLLRFSDDTYTNDYISTIGVDFKIKTVELDGKTVKLQIWDTAGQERFRTITSSYYRGSHGIIIVYDVTDQESFNGVKMWLQEIDRYATSTVLKLLVGNKCDLKDKRVVEYDVAKEFADANKMPFLETSALDSTNVEDAFLTMARQIKESMSQQNLNETTQKKEDKGNVNLKGQSLTNTGGGCC');
INSERT INTO proteininfo VALUES ('14318479', 'NP_116614.1','Actin, structural protein involved in cell polarization, endocytosis, and other cytoskeletal functions; Act1p [Saccharomyces cerevisiae]','MDSEVAALVIDNGSGMCKAGFAGDDAPRAVFPSIVGRPRHQGIMVGMGQKDSYVGDEAQSKRGILTLRYPIEHGIVTNWDDMEKIWHHTFYNELRVAPEEHPVLLTEAPMNPKSNREKMTQIMFETFNVPAFYVSIQAVLSLYSSGRTTGIVLDSGDGVTHVVPIYAGFSLPHAILRIDLAGRDLTDYLMKILSERGYSFSTTAEREIVRDIKEKLCYVALDFEQEMQTAAQSSSIEKSYELPDGQVITIGNERFRAPEALFHPSVLGLESAGIDQTTYNSIMKCDVDVRKELYGNIVMSGGTTMFPGIAERMQKEITALAPSSMKVKIIAPPERKYSVWIGGSILASLTTFQQMWISKQEYDESGPSIVHHKCF');
INSERT INTO proteininfo VALUES ('14318478', 'NP_116613.1','Hypothetical ORF; Yfl040wp [Saccharomyces cerevisiae]','MTAMKAIVWRLPKMPKIKITKTYEVTKITAILTLVGFIMGLEVPSLATFLTNKTFNEYFKYPTPLQQGLLMGSTPLGGIMGCFICCIMNDRFSRIYQFQSGIIIWNIVTLLNFCIWDILGLLICRMIKGMILGNFSILVASYANEVIPRGKRGSTMSYIQLCLTIGILVMHYLCIALSLWDSHFAFRIAWCIGIIPGLLFWMASYALPESYHWLVLHGKMSEAQEIQHNLAKKFNESQPRDAVPEMSKIELAGDFWIGVNDLDFSKKLPRGSFKPLILGMTLQLLVQFSGINIILGYITYICEIVGLEGNVKLFTSSIPYFINMVLSLLPITFIDYTSRKLITLLGGFPISGLLITIGALFVKYGQDTKPIDGNRSLVWSIGENPFVGGWILTLCFLIVGIFAMSLSSIPWVYTNEMLPSRVKVKGFAICVTFGWLGNFILTFLCPVMIERLKGTTFIIFGSLTFLISLSVLIWFPETKGMSIEDIDKFFEFESKEGTNLHGEKGIKTPDSNSNGGSTRSSQEGQLHKPIKLKSDEEMII');
INSERT INTO proteininfo VALUES ('14318477', 'NP_116612.1','Multicopper oxidase, integral membrane protein with similarity to Fet3p; may have a role in iron transport; Fet5p [Saccharomyces cerevisiae]','MLFYSFVWSVLAASVALAKTHKLNYTASWVTANPDGLHEKRMIGFNGEWPLPDIHVEKGDRVELYLTNGFQDNTATSLHFHGLFQNTSLGNQLQMDGPSMVTQCPIVPGQTYLYNFTVPEQVGTFWYHAHMGAQYGDGMRGAFIIHDPEEPFEYDHERVITLSDHYHENYKTVTKEFLSRYNPTGAEPIPQNILFNNTMNVTLDFTPGETYLFRFLNVGLFVSQYIILEDHEMSIVEVDGVYVKPNFTDSIYLSAGQRMSVLIKAKDKMPTRNYAMMQIMDETMLDVVPPELQLNQTIQMRYGHSLPEARALNIEDCDLDRATNDFYLEPLIERDLLAHYDHQIVMDVRMVNLGDGVKYAFFNNITYVTPKVPTLTTLLTSGKLASDPRIYGDNINAQLLKHNDIIEVVLNNYDSGRHPFHLHGHNFQIVQKSPGFHVDEAYDESEQDEMTVPYNESAPLQPFPERPMVRDTVVLEPSGHVVLRFRADNPGVWYFHCHVDWHLQQGLASVFIEAPVLLQEREKLNENYLDICKAADIPVVGNAAGHSNDWFDLKGLPRQPEPLPKGFTTEGYLALIISTIIGVWGLYSIAQYGIGEVIPNDEKVYHTLREILAENEIEVSRG');
INSERT INTO proteininfo VALUES ('14318476', 'NP_116611.1','Due to a sequence change (deletion of G at 46151), YFL043C is now part of YFL042C.; Yfl042cp [Saccharomyces cerevisiae]','MSDVDNWEPVSDNEDSTDSVKQLGPPFEHASNNDNAGDTEAESLQEVPLNTETNDVRKNLVVITNQSAADEHPTEIKHDQSRTSSTSSFFSGMISSFKSNVPSPVSRSTTPTSPVSQPSIISHRREPSMGSKRRSSRRISNATIAEIGSPLQQVEKPDEVKTRLTPSQMKEDNYDHRRFVEERYMDTPYHYASEQRNKDFHETFKSVPKDDRLLDDFNCGLNRELLYQGKLYITETHLCFNSNVLGWIAKVLIAFEDVTFMEKTSAAGLFPSAISIETKMGKTLFNGFISRDAAFGLMKEVWSRTLLQKDMASENINTKAEKSGNGKEIDDAINSIDEENNDKDANDNDTNENDDENISTNETTPNSTSSSPDKEKEKAYKLRADSSYQYDGPIYHHSTSFPAEPMANNEFVLKELPFDCAPGILFEIMFNSEQNEFLLDFLRGQEGSQITTIPNFTSIDGSSMTLKREYSYEKALHFPAGPKSTTCYVAEVIKRKDPDTYYEVISSIRTPNVPSGGSFSTKTRYLIRWNDEITCLLRVSFWVEWTGSSWIKGMVENGCKNGQLEAAQLMERILSKFIKNNVEECQITISKEEEEQDDKEVKNKLKEVDLEQPREAVVTAPAIAEQQGLKVTMETWLFLYLIVVVLLLFNLFYIRSIAVSLHQLVKLQLVELKL');
INSERT INTO proteininfo VALUES ('14318475', 'NP_116610.1','Yeast OTU Deubiquitinating enzyme 1; Yod1p [Saccharomyces cerevisiae]','MKLKVTGAGINQVVTLKQDATLNDLIEHINVDVKTMRFGYPPQRINLQGEDASLGQTQLDELGINSGEKITIESSDSNESFSLPPPQPKPKRVLKSTEMSIGGSGENVLSVHPVLDDNSCLFHAIAYGIFKQDSVRDLREMVSKEVLNNPVKFNDAILDKPNKDYAQWILKMESWGGAIEIGIISDALAVAIYVVDIDAVKIEKFNEDKFDNYILILFNGIHYDSLTMNEFKTVFNKNQPESDDVLTAALQLASNLKQTGYSFNTHKAQIKCNTCQMTFVGEREVARHAESTGHVDFGQNR');
INSERT INTO proteininfo VALUES ('14318474', 'NP_116609.1','involved in synthesis of GDP-mannose and dolichol-phosphate-mannose; required for protein assembly in endoplasmic reticulum; phosphomannomutase; Sec53p [Saccharomyces cerevisiae]','MSIAEFAYKEKPETLVLFDVDGTLTPARLTVSEEVRKTLAKLRNKCCIGFVGGSDLSKQLEQLGPNVLDEFDYSFSENGLTAYRLGKELASQSFINWLGEEKYNKLAVFILRYLSEIDLPKRRGTFLEFRNGMINVSPIGRNASTEERNEFERYDKEHQIRAKFVEALKKEFPDYGLTFSIGGQISFDVFPAGWDKTYCLQHVEKDGFKEIHFFGDKTMVGGNDYEIFVDERTIGHSVQSPDDTVKILTELFNL');
INSERT INTO proteininfo VALUES ('14318473', 'NP_116608.1','The authentic, non-tagged protein was localized to the mitochondria; Fmp32p [Saccharomyces cerevisiae]','MLKRIVGLPARRCFHRTSFLLGSDFETVHIPNTNHFKDLLIENGKFQEDQATTIVEIMTDAIRGGVNHVSQDLAKREKLTQLSYQQRVDFAKLRDQLLSADRSEFHNIQNEYESVKNDLEKLRNKLREEITKTNAGFKLDLSLEKGRIREESSHHDLQIKEIDTKIEQEVTNMKMQIDSVKTQVMQWLIGVCTGTFALVLAYMRLLT');
INSERT INTO proteininfo VALUES ('14318471', 'NP_116606.1','Integral membrane component of endoplasmic reticulum-derived COPII-coated vesicles, which function in ER to Golgi transport; Emp47p [Saccharomyces cerevisiae]','MMMLITMKSTVLLSVFTVLATWAGLLEAHPLGDTSDASKLSSDYSLPDLINARKVPNNWQTGEQASLEEGRIVLTSKQNSKGSLWLKQGFDLKDSFTMEWTFRSVGYSGQTDGGISFWFVQDSNVPRDKQLYNGPVNYDGLQLLVDNNGPLGPTLRGQLNDGQKPVDKTKIYDQSFASCLMGYQDSSVPSTIRVTYDLEDDNLLKVQVDNKVCFQTRKVRFPSGSYRIGVTAQNGAVNNNAESFEIFKMQFFNGVIEDSLIPNVNAMGQPKLITKYIDQQTGKEKLIEKTAFDADKDKITNYELYKKLDRVEGKILANDINALETKLNDVIKVQQELLSFMTTITKQLSSKPPANNEKGTSTDDAIAEDKENFKDFLSINQKLEKVLVEQEKYREATKRHGQDGPQVDEIARKLMIWLLPLIFIMLVMAYYTFRIRQEIIKTKLL');
INSERT INTO proteininfo VALUES ('14318470', 'NP_116605.1','Hypothetical ORF; Yfl049wp [Saccharomyces cerevisiae]','MLGEDEGNTVLEKGNNPSVKQGEVGAVFIVPKILIREHERVILKQILQILDQDELVQPPLDKFPYKKLELPKYIDELKTRDATNTSYKMIQLDAYGEKKVGSNGELFGGRHYLFNTFTFTAHMGVLLVLLQDVIKVLYQSNATHDEDEFIVQHDQILVMETSEEQTKFLAKNGVIPEESKGSFKYITARSAFVEFGASVIAGGQRIVDDYWESLAKKQNLSSHQRVFKLSTNLISKISLLRPSFQNNRISNANEISANTNNTCTISTSKFESQYPIVTEQPSAEIREAYIENFAKGEHISAIVPGQSISGTLELSAQFRVPRYHSKNSFQQALQMKAMDIPIGRHEELLAQYESQAPDGSASISLPNHIPSVNPSNKPIKRMLSSILDINVSSSKNKKSEENEMIKPMNKGQHKNNTSLNINGWKFESLPLKSAENSGKQQYYRGLPLYEKNTLLERLKQLTPNEIKELEHLHDAVFVNTGLQNVRKVRTKKWKKYWQYKAGIPIGLKRSQLDEFKNKYLKDVLAQTSVTTNFNEITNTDETITTKRVPNPNFLGNCNIKDFKPPYIYSHVNKVPQNVAGDKTAVKLDTEVKNTNANPVVATDPVAAKPDNLANFSNEVAMNN');
INSERT INTO proteininfo VALUES ('14318469', 'NP_116604.1','Probable Mg(2+) transporter; overexpression confers increased tolerance to Al(3+) and Ga(3+) ions; Alr2p [Saccharomyces cerevisiae]','MSSLSTSFDSSSDLPRSKSVDNTAASMKTGKYPKLENYRQYSDAQPIRHEALALKVDETKDSRHKFSSSNGENSGVENGGYVEKTNISTSGRMDFEGEAEAEAVKRYQLRSFALLSSNARPSRLAKSETHQKQIHVESIAPSLPKNAALERGHDTALPAGTSSNRCNLEASSSARTFTSARKASLVSAIFETSAESEHGTHPKQAKLKRRTYSTISTHSSVNPTTLLTRTASQKSDMGNDTRRIKPLRMDSRVSFHSEISQASRDSQETEEDVCFPMFRLLHTRVNGVDFDELEEYAQISNAERNLSLANHQRHSERTYNHTDQDTGFTNSASTSGSSAALKYTPEISRTLEKNCSVNEMYVSENNESVREDDKPDLHPDVTFGRNKIEGEKEGNDSSYSRAYYTLQNTEYQIPSRFSFFRSESDETVHASDIPSLISEGQTFYELFKGGDPTWWLDCSCPTDDEMRCIAKTFGIHPLTAEDIRMQETREKVELFKSYYFVCFHTFENDKESENYLEPINVYIVVFRSGVLTFHFDPISHCANVRRRVRQLRDYVSVNSDWLCYALIDDITDSFAPVIQSIEYEADSIDDSVFMTRDMDFAAMLQRIGESRRKTMTLMRLLSGKADVIKMFAKRCQDETNGIGPVLKSQTNMVNLQAEQENVNQNNSNNQISLSNSYMQTTSQPRGDIALYLGDIQDHLLTMFQNLLAYEKIFSRSHANYLAQLQVESFNSNNKVTEMLGKVTMLGTMLVPLNVITGLFGMNVKVPGRNGSIAWWYGILGVLLLLAVISWFLASYWIKKIDPPATLNEAAGSGAKSVISSFLPKRDKRFNDDSKNGNARVGVRRKSTVSLPSRYSRYN');
INSERT INTO proteininfo VALUES ('14318468', 'NP_116576.1','Hypothetical ORF; Yfl051cp [Saccharomyces cerevisiae]','MSIPHSVFSALLVFVALATTTLASTEACLPTNKREDGMNINFYEYTIGDQTTYLEPEYMGYEYSNTKKLGSVSGQTNLSIYYSPPCESTPTCVTYAVLKRDEDGYDPCGPLYETKKRDTEYCDPNTAYWSSDLFGFYTTPTNVTVEMTGYLIWSMGNRRR');
INSERT INTO proteininfo VALUES ('14318467', 'NP_116603.1','Hypothetical ORF; Yfl052wp [Saccharomyces cerevisiae]','MARNRQACDCCCIRRVKCDRKKPCKCCLQHNLQCTYLRPLKKRGPKPVKVRNLKKVDDVQVFSKSSSGGIMKVPKALIDQCLRLYNDKLYVIWPLLCYDDLYELLEKRYDETCVYWFLVSLSAATLSDLQTEIESEGGVTFTGIQLSSFCMSSRQEFDDFNGSDIFKIMTYYCLNRCYAQMSNSRTSYRLSCEAVGLIKLAGFHREETLKLLPFDEQQLGRKVYYLLLLTERYFSVYTHCATSLDTTIAPPQPENVTDPRLSLDSFLEMIRVFTVPGKCFFDALATDSANVTCTEDSLKKIWRELHTVPLEIEPWSYGYVDISFSRHWIRTLAWKLVLQISGMRISFLSNSKNTHIPVEIARDMLEDTFLIPKNLYAVHGPGISVKALEIADALVDVVNQYDQNAESEAWNFLFDISKFVFSLKHCDSTLVDKFTTKCQCALITLPLSNPLESTDGSKEDVDALP');
INSERT INTO proteininfo VALUES ('14318466', 'NP_116602.1','Dihydroxyacetone kinase, required for detoxification of dihydroxyacetone (DHA); involved in stress adaptation; Dak2p [Saccharomyces cerevisiae]','MSHKQFKSDGNIVTPYLLGLARSNPGLTVIKHDRVVFRTASAPNSGNPPKVSLVSGGGSGHEPTHAGFVGEGALDAIAAGAIFASPSTKQIYSAIKAVESPKGTLIIVKNYTGDIIHFGLAAERAKAAGMKVELVAVGDDVSVGKKKGSLVGRRGLGATVLVHKIAGAAASHGLELAEVAEVAQSVVDNSVTIAASLDHCTVPGHKPEAILGENEYEIGMGIHNESGTYKSSPLPSISELVSQMLPLLLDEDEDRSYVKFEPKEDVVLMVNNMGGMSNLELGYAAEVISEQLIDKYQIVPKRTITGAFITALNGPGFGITLMNASKAGGDILKYFDYPTTASGWNQMYHSAKDWEVLAKGQVPTAPSLKTLRNEKGSGVKADYDTFAKILLAGIAKINEVEPKVTWYDTIAGDGDCGTTLVSGGEALEEAIKNHTLRLEDAALGIEDIAYMVEDSMGGTSGGLYSIYLSALAQGVRDSGDKELTAETFKKASNVALDALYKYTRARPGYRTLIDALQPFVEALKAGKGPRAAAQAAYDGAEKTRKMDALVGRASYVAKEELRKLDSEGGLPDPGAVGLAALLDGFVTAAGY');
INSERT INTO proteininfo VALUES ('14318465', 'NP_116601.1','Hypothetical ORF; Yfl054cp [Saccharomyces cerevisiae]','MSYESGRSSSSSESTRPPTLKEEPNGKIAWEESVKKSRENNENDSTLLRRKLGETRKAIETGGSSRNKLSALTPLKKVVDERKDSVQPQVPSMGFTYSLPNLKTLNSFSDAEQARIMQDYLSRGVNQGNSNNYVDPLYRQLNPTMGSSRNRPVWSLNQPLPHVLDRGLAAKMIQKNMDARSRASSRRGSTDISRGGSTTSVKDWKRLLRGAAPGKKLGDIEAQTQRDNTVGADVKPTKLEPENPQKPSNTHIENVSRKKKRTSHNVNFSLGDESYASSIADAESRKLKNMQTLDGSTPVYTKLPEELIEEENKSTSALDGNEIGASEDEDADIMTFPNFWAKIRYHMREPFAEFLGTLVLVIFGVGGNLQATVTKGSGGSYESLSFAWGFGCMLGVYVAGGISGGHINPAVTISMAIFRKFPWKKVPVYIVAQIIGAYFGGAMAYGYFWSSITEFEGGPHIRTTATGACLFTDPKSYVTWRNAFFDEFIGASILVGCLMALLDDSNAPPGNGMTALIIGFLVAAIGMALGYQTSFTINPARDLGPRIFASMIGYGPHAFHLTHWWWTWGAWGGPIAGGIAGALIYDIFIFTGCESPVNYPDNGYIENRVGKLLHAEFHQNDGTVSDESGVNSNSNTGSKKSVPTSS');
INSERT INTO proteininfo VALUES ('14318464', 'NP_116600.1','Low-affinity amino acid permease, may act to supply the cell with amino acids as nitrogen source in nitrogen-poor conditions; transcription is induced under conditions of sulfur limitation; Agp3p [Saccharomyces cerevisiae]','MAVLNLKRETVDIEETAKKDIKPYFASNVEAVDIDEDPDVSRYDPQTGVKRALKNRHISLLALGGVIGPGCLVGAGNALNKGGPLALLLGFSIIGIIAFSVMESIGEMITLYPSGGGFTTLARRFHSDALPAVCGYAYVVVFFAVLANEYNTLSSILQFWGPQVPLYGYILIFWFAFEIFQLVGVGLFGETEYWLAWLKIVGLVAYYIFSIVYISGDIRNRPAFGFHYWNSPGALSHGFKGIAIVFVFCSTFYSGTESVALAATESKNPGKAVPLAVRQTLWRILVVYIGIAVFYGATVPFDDPNLSASTKVLKSPIAIAISRAGWAGGAHLVNAFILITCISAINGSLYIGSRTLTHLAHEGLAPKILAWTDRRGVPIPAITVFNALGLISLMNVSVGAANAYSYIVNLSGVGVFIVWGVISYTHLRIRKAWVAQGRSIEELPYEALFYPWTPVLSLAANIFLALIQGWSYFVPFDAGNFVDAYILLPVGILLYIGICVFKSNHFRTVDLRSINLDEGRRKDMEADLSDQESSLASSETMKDYKSATFFRYLSNIFT');
INSERT INTO proteininfo VALUES ('14318463', 'NP_116599.1','Putative aryl-alcohol dehydrogenase with similarity to P. chrysosporium aryl-alcohol dehydrogenase, involved in the oxidative stress response; Aad6p [Saccharomyces cerevisiae]','MADLFAPAPEPSTELGRLRVLSKSAGIRVSPLILGGMSIGDAWSEILGSMSKERAFELLDAFYEAGGNFIDTANNYQNEQSEAWIGEWMVSRKLRDQIVIATKFTTDYKKYDVGGGKSANYCGNHKRSLHVSVRDSLRKLQTDWIDILYVHWWDYMSSIEEVMDSLHILVQQARSSIWVCLIRLPGLFLRQITTLNLMVKPLLASIKVNGTC');
INSERT INTO proteininfo VALUES ('14318462', 'NP_116598.1','Putative aryl-alcohol dehydrogenase with similarity to P. chrysosporium aryl-alcohol dehydrogenase; mutational analysis has not yet revealed a physiological role; Aad16p [Saccharomyces cerevisiae]','MARHFGMALAPWDVMGGGRFQSKKAMEERRKNGEGIRSFVGASEQTDAEIKISEALAKVAEEHGTESVTAIAIAYVRSKAKNVFPLVGGRKIEHLKQNIEALSIKLTPEQIKYLESIIPFDVGFPTNFIGDDPAVTKKASLLTAMSAQISFD');
INSERT INTO proteininfo VALUES ('14318461', 'NP_116597.1','Protein involved in synthesis of the thiamine precursor hydroxymethylpyrimidine (HMP); member of a subtelomeric gene family including THI5, THI11, THI12, and THI13; Thi5p [Saccharomyces cerevisiae]','MSTDKITFLLNWQPTPYHIPIFLAQTKGYFKEQGLDMAILEPTNPSDVTELIGSGKVDMGLKAMIHTLAAKARGFPVTSVASLLDEPFTGVLYLKGSGITEDFQSLKGKKIGYVGEFGKIQIDELTKHYGMKPEDYTAVRCGMNVAKYIIEGKIDAGIGIECMQQVELEEYLAKQGRPASDAKMLRIDKLACLGCCCFCTVLYICNDEFLKKNPEKVRKFLKAIKKATDYVLADPVKAWKEYIDFKPQLNNDLSYKQYQRCYAYFSSSLYNVHRDWKKVTGYGKRLAILPPDYVSNYTNEYLSWPEPEEVSDPLEAQRLMAIHQEKCRQEGTFKRLALPA');
INSERT INTO proteininfo VALUES ('14318460', 'NP_116596.1','Snooze: stationary phase-induced gene family; member of the stationary phase-induced gene family; Snz3p [Saccharomyces cerevisiae]','MSEFKVKTGLAQMLKGGVIMDVVTPEQAIIAERAGACAVMALERIPADMRKSGQVCRMSDPRMIKEIMEAVSIPVMAKVRIGHFVEAQILEELQVDYIDESEVLTPADWTHHIEKHNFKVPFVCGAKDLGEALRRINEGAAMIRTKGEAGTGDVSEAVKHITKIKAEIQQYKENLKTESDFAAKATELRVPVDLLKTTLSEGKLPVVNFAAGGVATPADAALLMQLGCEGVFVGSGIFKSSDPEKLACAIVEATTHYDNPAKLLQVSSDLGDLMGGISIQSINEAGGKNGARLSEIGW');
INSERT INTO proteininfo VALUES ('14318459', 'NP_116595.1','Protein of unknown function, nearly identical to Sno2p; expression is induced before the diauxic shift and also in the absence of thiamin; Sno3p [Saccharomyces cerevisiae]','MTVVIGVLALQGAFIEHVRHVEKCIVENRDFYEKKLSVMTVKDKNQLAQCDALIIPGGESTAMSLIAERTGFYDDLYAFVHNPSKVTWGTCAGLIYISQQLSNEAKLVKTLNLLKVKVKRNAFGRQAQSSTRICDFSNFIPHCNDFPATFIRAPVIEEVLDPEHVQVLYKLDGKDNGGQELIVAAKQKNNILATSFHPELAENDIRFHDWFIREFVLKNYSK');
INSERT INTO proteininfo VALUES ('14318458', 'NP_116594.1','Hypothetical ORF; Ddi2p [Saccharomyces cerevisiae]','MSQYGFVRVPREVEKAIPVVNAPRPRAVVPPPNSETARLVREYAAKELTAPVLNHSLRVFQYSVAIIRDQFPAWDLDQEVLYVTCLLHDIATTDKNMRATKMSFEYYGGILSRELVFNATGGNQDYADAVTEAIIRHQDLTGTGYITTLGLILQIATTLDNVGSNTDLIHIDTVSAINEQFPRLHWLSCFATVVDTENSRKPWGHTSSLGDDFSKKVICNTFGYN');
INSERT INTO proteininfo VALUES ('14318457', 'NP_116593.1','Protein of unknown function, member of a family of conserved, often subtelomerically-encoded proteins; Cos4p [Saccharomyces cerevisiae]','MKENELKNEKSVDVLSFKQLESQKIVLPQDLFRSSFTWFCYEIYKSLAFRIWMLLWLPLSVWWKLSNNWIYPLMVSLLVLFWGPVFVLVIFRLSRKRSLSKQLTQFCKEITKSTPSSDPHDWEVVAANLNSYLYENKAWNIRYFFFNAMGCQEAFRTTLLEPFSLKKDEAAKVKSFKDSVPYIEEALGVYFREVEKQWKLFNSEKSWSPVGLEDAKLPKEAYRFKLTWFLKRISNIFMLIPFLNFLCCIYVSRGMCLLLRTLYLGWILFMLVQGFQNIRVLIMSMEHKMQFLSTIINEQESGANGWDEIARKMNRYLFEKKVWKNEEFFFDGIDCEWFFSHFFYRVLSAKKSMRALSLNVELWPYIKEAQLSCSEESLA');
INSERT INTO proteininfo VALUES ('14318455', 'NP_116591.1','Hypothetical ORF; Yfl064cp [Saccharomyces cerevisiae]','MKVSDRRKFEKANFDEFESALNNKNDLVHCPSITLFESIPTEVRSFYEDEKSGLIKVVKFRTGAMNRKRSFEKIVISVMVGKNVQKFLTFVEDEPDFQGGPIPSKYLIPKKINLMVYTLFQVHTLKFNRKDYDTLSLFYLNRGYYNELSFPCPGTLSRNSECQAERQLYDAYFH');
INSERT INTO proteininfo VALUES ('14318454', 'NP_116590.1','Hypothetical ORF; Yfl065cp [Saccharomyces cerevisiae]','MRTFTDFVSGAPIVRSLQKSTIRKYGYNLAPHMFLLLHVDELSIFSAYQASLPGEKKVDTERLKRDLCPRKPIEIKYFSQICNDMMNKKDRLGDVLRVCCPS');
INSERT INTO proteininfo VALUES ('14318453', 'NP_116589.1','Hypothetical ORF; Yfl066cp [Saccharomyces cerevisiae]','MADTPSVAVQAPPGYGKTELFHLPLIALASKGDVKYVSFLFVPYTVLLANCMIRLGRRGCLNVAPVRNFIEEGYDGVTDLYVGIYDDLASTNFTDRIAAWENIVECTFRTNNVKLGYLIVDEFHNFETEVYRQSQFGGITNLDFDAFEKAIFLSGTAPEAVADAALQRIGLTGLAKKSMDINELKRSEDLSRGLSSYPTRMFNLIKEKSEVPLGHVHKIWKKVESQPEEALKLLLALFEIEPESKAIVVASTTNEVEELACSWRKYFRVVWIHGKLGAAEKVSRTKEFVTDGSMQVLIGTKLVTEGIDIKQLMMVIMLDNRLNIIELIQGVGRLRDGGLCYLLSRKNSWAARNRKGELPPIKEGCITEQVREFYGLESKKGKKGQHVGCCVC');
INSERT INTO proteininfo VALUES ('14318452', 'NP_116588.1','Hypothetical ORF; Yfl067wp [Saccharomyces cerevisiae]','MESIILSIAIFIGVLLGTSVGAGSGSSISPDVDAGSGSRTSPDVDAGSGSRISAGVGTFSGSSTSPDVDAGSGSSTSPDVGAGSGSSISAGVGSRIGTGIGSRIGTGIGTGIGSRISTSIGSRISPDVGTSSGNRISTGVSTGISTTMNARVAVLITAAILSAPVTAIALLEARR');
INSERT INTO proteininfo VALUES ('14318451', 'NP_116587.1','Hypothetical ORF; Yfl068wp [Saccharomyces cerevisiae]','MMPAKLQLDVLRTLQSSARHGTQTLKNSNFLERFHKDRIVFCLPFFPALFLVPVQKVLQHLCLRFTQVAPYFIIQLFDLPSRHAENLAPLLASCRIQYTNCFSSSSNGQVPSIISLYLRVDLSPFYAKKFQIPYRVPMIWLDVFQVFFVFLVISQHSLHS');
INSERT INTO proteininfo VALUES ('14318440', 'NP_116582.1','Member of a family of microtubule-associated proteins (MAPs) that function at the mitotic spindle midzone; required for spindle elongation; undergoes cell cycle-regulated degradation by anaphase promoting complex; potential Cdc28p substrate; Ase1p [Saccharomyces cerevisiae]','METATSSPLPIKSRRNSENSGSTTVIPHMNPSLATPLTVSTMVNQSNSKEFMKLTPVRIRDFGSPLKNVSTNYHFLDSENGKGNTMDNMYRENFILISKDLEKLLENLNVIYQNIGYSNTEIITKEKIIFTTISNSIKQFFEQADEELKRLSAENGIEQDILNNILERINDPSGIKTIPDLYIRNAILLQESKTVPQSPKKPLSLLSKKAALDTAKKFVLGSFLPRLRDYLKSLITLKHLIQSVKENLPGLTEADNEAIAEFPELSTLTAYLLQIENGKGDIGLSMKFIIDNRKDILKGSAFKTINEESVKHMNEVIKIYEEEYERRFKSVLTKKVSISSICEQLGTPLATLIGEDFEQDLRSYGEEENSTSEIPNFHPVDRERMSKIDITLEKLQAIHKERADKKRLLMEQCQKLWTRLKISQEYIKTFMRNNSSLSTESLGRISKEVMRLEAMKKKLIKKLISDSWDKIQELWRTLQYSEESRSKFIIVFEELRNSATTLQEDELLLETCENELKRLEEKLTLYKPILKLISDFESLQEDQEFLERSSKDSSRLLSRNSHKILLTEEKMRKRITRHFPRVINDLRIKLEEADGLFDQPFLFKGKPLSEAIDIQQQEIEAKYPRCRVRMQRSKKGKCGANKENKVIKNTFKATESSIRVPIGLNLNDANITYKTPSKKTIQGLTKNDLSQENSLARHMQGTTKLSSPNRRATRLLAPTVISRNSKGNIERPTLNRNRSSDLSSSPRINHTHGEHAVKPRQLFPIPLNKVDTKGSHIPQLTKEKALELLKRSTGTTGKENVRSPERKSSLEDYAQKLSSPYKEPEHSIYKLSMSPEGKFQLNIQQKDIESGFDDTSMMEDENDKDFITWKNEQVSKLNGFSFTDI');
INSERT INTO proteininfo VALUES ('14318438', 'NP_116579.1','Sulfite reductase beta subunit, involved in amino acid biosynthesis, transcription repressed by methionine; Ecm17p [Saccharomyces cerevisiae]','MTASDLLTLPQLLAQYSSSAPQNKVFYTTSTKNSHSSFKGLESVATDATHLLNNQDPLNTIKDQLSKDILTTVFTDETTLVKSIHHLYSLPNKLPLVITVDLNLQDYSAIPALKDLSFPILISSDLQTAISNADSSYKIATSSLTPVFHFLNLEKIGTSTAIEQDIDFPTLEIANEETKVALSEATDSLTNFELVKGKESITTVIVNLSPYDAEFSSVLPSNVGLIKIRVYRPWNFSKFLEILPSSVTKIAVLQGVSKKSQSNEFQPFLLDFFGNFNELVSRNIEQVVLTNIGNVNDYGNVINTVISNINKKEPDNNLFLGESNEKAEEQAEVTQLISSVKKVVNLEDAYIKVLKQLFSSNLQILNQFSSETIEPSNPEFGFGRFLKQEAQREELISLAKTSLDPSLYLSEDANKIVQLLSKWLSFNGRDLDEAQLQEANATGLEIFQLLQSNQDSSTVLKFLKIAPTSDSFIFKSSWLIGSDAWSYDLGHSGIQQVLSSRKNINVLLIDSEPYDHRKQNQDRKKDVGLYAMNYYSAYVASVAVYASYTQLLTAIIEASKYNGPSIVLAYLPYNSENDTPLEVLKETKNAVESGYWPLYRFNPVYDDPSTDKEAFSLDSSVIRKQLQDFLDRENKLTLLTRKDPSLSRNLKQSAGDALTRKQEKRSKAAFDQLLEGLSGPPLHVYYASDGGNAANLAKRLAARASARGLKATVLSMDDIILEELPGEENVVFITSTAGQGEFPQDGKSFWEALKNDTDLDLASLNVAVFGLGDSEYWPRKEDKHYFNKPSQDLFKRLELLSAKALIPLGLGDDQDADGFQTAYSEWEPKLWEALGVSGAAVDDEPKPVTNEDIKRESNFLRGTISENLKDTSSGGVTHANEQLMKFHGIYTQDDRDIREIRKSQGLEPYYMFMARARLPGGKTTPQQWLALDHLSDTSGNGTLKLTTRATFQIHGVLKKNLKHTLRGMNAVLMDTLAAAGDVNRNVMVSALPTNAKVHQQIADMGKLISDHFLPKTTAYHEVWLEGPEEQDDDPSWPSIFENRKDGPRKKKTLVSGNALVDIEPIYGPTYLPRKFKFNIAVPPYNDVDVLSIDVGLVAIVNPETQIVEGYNVFVGGGMGTTHNNKKTYPRLGSCLGFVKTEDIIPPLEGIVIVQRDHGDRKDRKHARLKYTVDDMGVEGFKQKVEEYWGKKFEPERPFEFKSNIDYFGWIKDETGLNHFTAFIENGRVEDTPDLPQKTGIRKVAEYMLKTNSGHFRLTGNQHLVISNITDEHVAGIKSILKTYKLDNTDFSGLRLSSSSCVGLPTCGLAFAESERFLPDIITQLEDCLEEYGLRHDSIIMRMTGCPNGCSRPWLGELALVGKAPHTYNLMLGGGYLGQRLNKLYKANVKDEEIVDYIKPLFKRYALEREEGEHFGDFCIRVGIIKPTTEGKYFHEDVSEDAY');
INSERT INTO proteininfo VALUES ('14318437', 'NP_116578.1','Threonyl-tRNA synthetase, cytoplasmic; Ths1p [Saccharomyces cerevisiae]','MSASEAGVTEQVKKLSVKDSSNDAVKPNKKENKKSKQQSLYLDPEPTFIEERIEMFDRLQKEYNDKVASMPRVPLKIVLKDGAVKEATSWETTPMDIAKGISKSLADRLCISKVNGQLWDLDRPFEGEANEEIKLELLDFESDEGKKVFWHSSAHVLGESCECHLGAHICLGPPTDDGFFYEMAVRDSMKDISESPERTVSQADFPGLEGVAKNVIKQKQKFERLVMSKEDLLKMFHYSKYKTYLVQTKVPDGGATTVYRCGKLIDLCVGPHIPHTGRIKAFKLLKNSSCYFLGDATNDSLQRVYGISFPDKKLMDAHLKFLAEASMRDHRKIGKEQELFLFNEMSPGSCFWLPHGTRIYNTLVDLLRTEYRKRGYEEVITPNMYNSKLWETSGHWANYKENMFTFEVEKETFGLKPMNCPGHCLMFKSRERSYRELPWRVADFGVIHRNEFSGALSGLTRVRRFQQDDAHIFCTHDQIESEIENIFNFLQYIYGVFGFEFKMELSTRPEKYVGKIETWDAAESKLESALKKWGGNWEINAGDGAFYGPKIDIMISDALRRWHQCATIQLDFQLPNRFELEFKSKDQDSESYERPVMIHRAILGSVERMTAILTEHFAGKWPFWLSPRQVLVVPVGVKYQGYAEDVRNKLHDAGFYADVDLTGNTLQKKVRNGQMLKYNFIFIVGEQEMNEKSVNIRNRDVMEQQGKNATVSVEEVLKQLRNLKDEKRGDNVLA');
INSERT INTO proteininfo VALUES ('14318436', 'NP_011628.2','Component of the DASH complex, localized to intranuclear spindles and spindle pole bodies; interacts with Duo1p and Mps1p; key Ipl1p target for regulating kinetochore-microtubule attachments; Dam1p [Saccharomyces cerevisiae]','MSEDKAKLGTTRSATEYRLSIGSAPTSRRSSMGESSSLMKFADQEGLTSSVGEYNENTIQQLLLPKIRELSDSIITLDSNFTRLNFIHESLADLNESLGSLLYGIMSNSWCVEFSQAPHDIQDDLIAIKQLKSLEDEKNNLVMELSNMERGIKRKKDEQGENDLAKASQNKQFNQPLFPSSQVRKYRSYDNRDKRKPSKIGNNLQVENEEDYEDDTSSEASFVLNPTNIGMSKSSQGHVTKTTRLNNNTNSKLRRKSILHTIRNSIASGADLPIENDNVVNLGDLHPNNRISLGSGAARVVNGPVTKNRNSMFSGRAERKPTESRHSVAKKTEKKINTRPPFR');
INSERT INTO proteininfo VALUES ('14318435', 'NP_116577.1','transport protein that interacts with Sec20p; required for protein transport from the endoplasmic reticulum to the golgi apparatus; Tip20p [Saccharomyces cerevisiae]','MNGIDDLLNINDRIKQVQNERNELASKLQNLKQSLASNDTEVALSEVIAQDIIEVGASVEGLEQLRAKYGDLQILNKLEKVAVQQTQMQAGVDKLDSFERQLDELAEQPPDQFTLDDVKALHSKLTSVFATVPQINNIDSQYAAYNKLKSKVTGKYNDVIIQRLATNWSNTFDQKLLEAQWDTQKFASTSVGLVKCLRENSTKLYQLSLLYLPLEEETQNGDSERPLSRSNNNQEPVLWNFKSLANNFNVRFTYHFHATSSSSKIETYFQFLNDYLAENLYKCINIFHDDCNGLTKPVIHEQFINYVLQPIRDKVRSTLFQNDLKTLIVLISQILATDKNLLNSFHYHGLGLVSLISDEVWEKWINYEVEMANRQFINITKNPEDFPKSSQNFVKLINKIYDYLEPFYDLDFDLLVRYKLMTCSLIFMNLTSSYLDYILTVDSLNETRTKEQELYQTMAKLQHVNFVYRKIKSLSSNFIFIQLTDIVNSTESKKYNSLFQNVENDYEKAMSTDMQNSIVHRIQKLLKETLRNYFKISTWSTLEMSVDENIGPSSVPSAELVNSINVLRRLINKLDSMDIPLAISLKVKNELLNVIVNYFTESILKLNKFNQNGLNQFLHDFKSLSSILSLPSHATNYKCMSLHELVKILKLKYDPNNQQFLNPEYIKTGNFTSLKEAYSIKYLKDTKIQDALYRIIYGNIL');
INSERT INTO proteininfo VALUES ('14270689', 'NP_116327.1','Protein that stimulates the activity of serine palmitoyltransferase (Lcb1p, Lcb2p) several-fold; involved in sphingolipid biosynthesis; Tsc3p [Saccharomyces cerevisiae]','MTQHKSSMVYIPTTKEAKRRNGKSEGILNTIEEVVEKLYWTYYIHLPFYLMASFDSFFLHVFFLTIFSLSFFGILKYCFL');
INSERT INTO proteininfo VALUES ('14270688', 'NP_009551.2','Possible snoRNA-binding protein, based on computational analysis of large-scale protein-protein interaction data; Utp20p [Saccharomyces cerevisiae]','MAKQRQTTKSSKRYRYSSFKARIDDLKIEPARNLEKRVHDYVESSHFLASFDQWKEINLSAKFTEFAAEIEHDVQTLPQILYHDKKIFNSLVSFINFHDEFSLQPLLDLLAQFCHDLGPDFLKFYEEAIKTLINLLDAAIEFESSNVFEWGFNCLAYIFKYLSKFLVKKLVLTCDLLIPLLSHSKEYLSRFSAEALSFLVRKCPVSNLREFVRSVFEKLEGDDEQTNLYEGLLILFTESMTSTQETLHSKAKAIMSVLLHEALTKSSPERSVSLLSDIWMNISKYASIESLLPVYEVMYQDFNDSLDATNIDRILKVLTTIVFSESGRKIPDWNKITILIERIMSQSENCASLSQDKVAFLFALFIRNSDVKTLTLFHQKLFNYALTNISDCFLEFFQFALRLSYERVFSFNGLKFLQLFLKKNWQSQGKKIALFFLEVDDKPELQKVREVNFPEEFILSIRDFFVTAEINDSNDLFEIYWRAIIFKYSKLQNTEIIIPLLERIFSTFASPDNFTKDMVGTLLKIYRKEDDASGNNLLKTILDNYENYKESLNFLRGWNKLVSNLHPSESLKGLMSHYPSLLLSLTDNFMLPDGKIRYETLELMKTLMILQGMQVPDLLSSCMVIEEIPLTLQNARDLTIRIKNVGAEFGKTKTDKLVSSFFLKYLFGLLTVRFSPVWTGVFDTLPNVYTKDEALVWKLVLSFIKLPDENQNLDYYQPLLEDGANKVLWDSSVVRLRDTIDTFSHIWSKYSTQNTSIISTTIERRGNTTYPILIRNQALKVMLSIPQVAENHFVDIAPFVYNDFKTYKDEEDMENERVITGSWTEVDRNVFLKTLSKFKNIKNVYSATELHDHLMVLLGSRNTDVQKLALDALLAYKNPTLNKYRDNLKNLLDDTLFKDEITTFLTENGSQSIKAEDEKVVMPYVLRIFFGRAQVPPTSGQKRSRKIAVISVLPNFKKPYINDFLSLASERLDYNYFFGNSHQINSSKATLKTIRRMTGFVNIVNSTLSVLRTNFPLHTNSVLQPLIYSIAMAYYVLDTESTEEVHLRKMASNLRQQGLKCLSSVFEFVGNTFDWSTSMEDIYAVVVKPRISHFSDENLQQPSSLLRLFLYWAHNPSLYQFLYYDEFATATALMDTISNQHVKEAVIGPIIEAADSIIRNPVNDDHYVDLVTLICTSCLKILPSLYVKLSDSNSISTFLNLLVSITEMGFIQDDHVRSRLISSLISILKGKLKKLQENDTQKILKILKLIVFNYNCSWSDIEELYTTISSLFKTFDERNLRVSLTELFIELGRKVPELESISKLVADLNSYSSSRMHEYDFPRILSTFKGLIEDGYKSYSELEWLPLLFTFLHFINNKEELALRTNASHAIMKFIDFINEKPNLNEASKSISMLKDILLPNIRIGLRDSLEEVQSEYVSVLSYMVKNTKYFTDFEDMAILLYNGDEEADFFTNVNHIQLHRRQRAIKRLGEHAHQLKDNSISHYLIPMIEHYVFSDDERYRNIGNETQIAIGGLAQHMSWNQYKALLRRYISMLKTKPNQMKQAVQLIVQLSVPLRETLRIVRDGAESKLTLSKFPSNLDEPSNFIKQELYPTLSKILGTRDDETIIERMPIAEALVNIVLGLTNDDITNFLPSILTNICQVLRSKSEELRDAVRVTLGKISIILGAEYLVFVIKELMATLKRGSQIHVLSYTVHYILKSMHGVLKHSDLDTSSSMIVKIIMENIFGFAGEEKDSENYHTKVKEIKSNKSYDAGEILASNISLTEFGTLLSPVKALLMVRINLRNQNKLSELLRRYLLGLNHNSDSESESILKFCHQLFQESEMSNSPQIPKKKVKDQVDEKEDFFLVNLESKSYTINSNSLLLNSTLQKFALDLLRNVITRHRSFLTVSHLEGFIPFLRDSLLSENEGVVISTLRILITLIRLDFSDESSEIFKNCARKVLNIIKVSPSTSSELCQMGLKFLSAFIRHTDSTLKDTALSYVLGRVLPDLNEPSRQGLAFNFLKALVSKHIMLPELYDIADTTREIMVTNHSKEIRDVSRSVYYQFLMEYDQSKGRLEKQFKFMVDNLQYPTESGRQSVMELINLIITKANPALLSKLSSSFFLALVNVSFNDDAPRCREMASVLISTMLPKLENKDLEIVEKYIAAWLKQVDNASFLNLGLRTYKVYLKSIGFEHTIELDELAIKRIRYILSDTSVGSEHQWDLVYSALNTFSSYMEATESVYKHGFKDIWDGIITCLLYPHSWVRQSAANLVHQLIANKDKLEISLTNLEIQTIATRILHQLGAPSIPENLANVSIKTLVNISILWKEQRTPFIMDVSKQTGEDLKYTTAIDYMVTRIGGIIRSDEHRMDSFMSKKACIQLLALLVQVLDEDEVIAEGEKILLPLYGYLETYYSRAVDEEQEELRTLSNECLKILEDKLQVSDFTKIYTAVKQTVLERRKERRSKRAILAVNAPQISADKKLRKHARSREKRKHEKDENGYYQRRNKRKRA');
INSERT INTO proteininfo VALUES ('14270687', 'NP_009484.2','Peripheral membrane protein that interacts with the plasma membrane ATPase Pma1p and has a role in its targeting to the plasma membrane, possibly by influencing its incorporation into lipid rafts; Ast1p [Saccharomyces cerevisiae]','MAKDILKNQDPKLQAMIVEHSAPAPKEIPMDAPVLKRVARPLRHVKFIPIKSLIFHTKTGPMDFSYEKKIKTPIPKNKIVVRVSNVGLNPVDMKIRNGYTSSIYGEIGLGREYSGVITEVGENLNYAWHVGDEVYGIYYHPHLAVGCLQSSILVDPKVDPILLRPESVSAEEAAGSLFCLATGYNILNKLSKNKYLKQDSNVLINGGTSSVGMFVIQLLKRHYKLQKKLVIVTSANGPQVLQEKFPDLADEMIFIDYLTCRGKSSKPLRKMLEEKKISQYDPVEDKETILNYNEGKFDVVLDFVGGYDILSHSSSLIHGGGAYVTTVGDYVANYKEDIFDSWDNPSANARKMFGSIIWSYNYTHYYFDPNAKTASANNDWIEQCGDFLKNGTVKCVVDKVYDWKDHKEAFSYMATQRAQGKLIMNVEKF');
INSERT INTO proteininfo VALUES ('13432314', 'NP_085069.1','Possible shared subunit of Cop9 signalosome (CSN) and eIF3, binds eIF3b subunit Prt1p, has possible dual functions in transcriptional and translational control, contains a PCI (Proteasome-COP9 signalosome (CSN)-eIF3) domain; Pci8p [Saccharomyces cerevisiae]','MFHGAKGPLLIERIGHLLSINYGEKEERKRWAMQGISYLQEVQCTSTPYLEILVEESGLRPVSLLNSQLVGKPHFSLLGGFDENIARDIISHNFQNAIFQMESEEVPLTKRYQHLEKITQISLLCKNFKGIEEIEYNVKNIIQGRKNFDMLNSMEKDRISHEVVQDDSFSLLRIQMLLCVSYFLQERYFDCCTKFFTMMTSEPLTLKVLSEHLDCMNFISKEEFIMMVNISVLISIPLDNYDDFIYLSDLKQFFQMTPLLVNCLELLINTNFNKFFKIWHGEINKICMESLFLEPSWSSSAAVIMRCKIYFFYLRISKKLQFSYLSSTLGIDLEDIKEELTKLIISGQLNFEIDGDVIHFEDSSILQSIVNEISRNGTMINEVIDKLKNENTDLKDIIQGNPLMYSGGNNTATIINNESSDDMDIDEVNDRSDISDSEGGLFEC');
INSERT INTO proteininfo VALUES ('13129188', 'NP_076910.1','Hypothetical ORF identified by homology. See FEBS Letters [2000] 487:31-36.; Yol086w-ap [Saccharomyces cerevisiae]','MNDDEDRAQLKARLWIRVEERLQQVLSSEDIKYTPRFINSLLELAYLQLGEMGSDLQAFARHAGRGVVNKSDLMLYLRKQPDLQERVTQE');
INSERT INTO proteininfo VALUES ('13129187', 'NP_076909.1','Hypothetical ORF identified by homology. See FEBS Letters [2000] 487:31-36.; Yol159c-ap [Saccharomyces cerevisiae]','MQYCELDLSGQWLDTVYCEENFSDFVFIKFLNPSQFEEKIYCYTLHITKRTLENKRLLLYYEDEFKKHGHDINELVGDGIILRSCWNPRQ');
INSERT INTO proteininfo VALUES ('13129184', 'NP_076906.1','Hypothetical ORF identified by homology. See FEBS Letters [2000] 487:31-36.; Ynl162w-ap [Saccharomyces cerevisiae]','MSDKPDSQVFCPNCNERLQKCLVQQNYAIIICPSLVCGYPFNQREVLENLTYVDDNDVLKVAKKRLSSRSKP');
INSERT INTO proteininfo VALUES ('13129183', 'NP_076905.1','Hypothetical ORF identified by homology. See FEBS Letters [2000] 487:31-36.; Ymr013w-ap [Saccharomyces cerevisiae]','MMISTFHDGQLRFSNVYRLTLMIFRL');
INSERT INTO proteininfo VALUES ('13129182', 'NP_076904.1','Hypothetical ORF identified by homology. See FEBS Letters [2000] 487:31-36.; Yml007c-ap [Saccharomyces cerevisiae]','MVHFIFIALRSMRFMRRLVRNLQYLLLPITSSLLFI');
INSERT INTO proteininfo VALUES ('13129181', 'NP_076903.1','Hypothetical ORF identified by homology. See FEBS Letters [2000] 487:31-36.; Ylr363w-ap [Saccharomyces cerevisiae]','MPQKPLKVTKKAKDPRRVTKKQKNLRKAAPLQLKSKKKSLQHLKKLKKSSSLTETTERLVASKVGHLELLRGTRKELEKGKKNSK');
INSERT INTO proteininfo VALUES ('13129179', 'NP_076901.1','Hypothetical ORF identified by homology. See FEBS Letters [2000] 487:31-36.; Ylr099w-ap [Saccharomyces cerevisiae]','MADSEDTSVILQGIDTINSVEGLEEDGYLSDEDTSLSNELADAQRQWEESLQQLNKLLNWVLLPLLGKYIGRRMAKTLWSRFIEHFV');
INSERT INTO proteininfo VALUES ('13129177', 'NP_076899.1','Hypothetical ORF identified by homology. See FEBS Letters [2000] 487:31-36.; Ykl018c-ap [Saccharomyces cerevisiae]','MLGMIRWVVEGTLVAMLLSAIRRETGMIFFYNQYQLGGWIHRYLSWGEMCYTRTLKMVKRSKFFRKQLNEDGFGRINDSGPKRRGRDQSQYSSRFVELD');
INSERT INTO proteininfo VALUES ('13129176', 'NP_076898.1','Hypothetical ORF identified by homology. See FEBS Letters [2000] 487:31-36.; Ykl106c-ap [Saccharomyces cerevisiae]','MPFPSILHLTIGRYASYDSNNHMRRRAKLMEAIFRIRTI');
INSERT INTO proteininfo VALUES ('13129173', 'NP_076895.1','Hypothetical ORF identified by homology. See FEBS Letters [2000] 487:31-36.; Yjl052c-ap [Saccharomyces cerevisiae]','MHLRSRWWLALLYCKDPVSRSATTPKVETRASCLLSRAF');
INSERT INTO proteininfo VALUES ('13129172', 'NP_076894.1','Hypothetical ORF identified by homology. See FEBS Letters [2000] 487:31-36.; Yjl062w-ap [Saccharomyces cerevisiae]','MVLNPSKYQDTRTWKMTPAMIRARKPFFKGNMLGLTLLLGVTGSVYYYTYHFLHKDNDFADVPIPPIDPQELEALKKEYEAKKKA');
INSERT INTO proteininfo VALUES ('13129169', 'NP_076891.1','Hypothetical ORF identified by homology. See FEBS Letters [2000] 487:31-36.; Ygr271c-ap [Saccharomyces cerevisiae]','MDANTLNVSFEEILKGKKLDEDSIGLTLSPDKDHEDGSQVSPTQDRKELDQVVGEDEKDDFFE');
INSERT INTO proteininfo VALUES ('13129168', 'NP_076890.1','Hypothetical ORF identified by homology. See FEBS Letters [2000] 487:31-36.; Ygl258w-ap [Saccharomyces cerevisiae]','MAFERQGKIEKKISYSLFLNGPNVHFGSILFGAVDKSKYAEELCTHPMRQAYNTLDSNSRIIITVQSVAILDGKLVW');
INSERT INTO proteininfo VALUES ('13129167', 'NP_076889.1','Hypothetical ORF identified by homology. See FEBS Letters [2000] 487:31-36.; Yfr012w-ap [Saccharomyces cerevisiae]','MLPRKYKPAYKKQAHRVKSNPQPAYTFQ');
INSERT INTO proteininfo VALUES ('13129166', 'NP_076888.1','Hypothetical ORF identified by homology. See FEBS Letters [2000] 487:31-36.; Ydr379c-ap [Saccharomyces cerevisiae]','MPKRLSGLQKEVLHLYRASIRTAHTKPKENQVNFVNYIHEEFGKYRNLPRKDFTTIEHLLRVGNKKIATFSHPELTNIH');
INSERT INTO proteininfo VALUES ('13129164', 'NP_076886.1','Component of the RNA polymerase II general transcription and DNA repair factor TFIIH; involved in transcription initiation; homolog of the Chlamydomonas reinhardtii REX1-S protein which is involved in DNA repair; Tfb5p [Saccharomyces cerevisiae]','MARARKGALVQCDPSIKALILQIDAKMSDIVLEELDDTHLLVNPSKVEFVKHELNRLLSKNIYNPMDEEENQ');
INSERT INTO proteininfo VALUES ('13129162', 'NP_076884.1','Hypothetical ORF identified by homology. See FEBS Letters [2000] 487:31-36.; Ydl159w-ap [Saccharomyces cerevisiae]','MYNQIINTFIDDCLFLQTPMLQSPISSKIVLSFFLRNFFPSLF');
INSERT INTO proteininfo VALUES ('13129156', 'NP_076878.1','Hypothetical ORF identified by homology. See FEBS Letters [2000] 487:31-36.; Ycl001w-bp [Saccharomyces cerevisiae]','MDDFLEHLSKDDNKAWYGAEETERAAKLDAIETLLITDSVLKRNDVKKREKYLDLIENSGNNNGKIFVLSTSKITVSNLTNQQI');
INSERT INTO proteininfo VALUES ('13129152', 'NP_076874.1','Protein of unknown function; green fluorescent protein (GFP)-fusion protein localizes to the cell periphery; has potential orthologs in Saccharomyces species and in Yarrowia lipolytica; Ybl029c-ap [Saccharomyces cerevisiae]','MSFIPIVCGMKSFDSSYDTVPGHQNLYCPNCHNYSVGPIKRKEFFTIWFIPLVPVFWGKQLHCPICNWRQDFKNDEQLNKVIQEQQNLRQKQPN');
INSERT INTO proteininfo VALUES ('13129151', 'NP_076873.1','Hypothetical ORF identified by homology. See FEBS Letters [2000] 487:31-36.; Ybl108c-ap [Saccharomyces cerevisiae]','MLTGIAPDQVTRMITGVPWYSSRLKPAISSALSKDGIYTIAN');
INSERT INTO proteininfo VALUES ('13112038', 'NP_076437.1','Protein involved in bud-site selection; diploid mutants display a random budding pattern instead of the wild-type bipolar pattern; Bud25p [Saccharomyces cerevisiae]','MFCTWDSWDTGTSRKSHSPHRNCLAVRFLQLPFSSFLPCVITYMKSWQTSIGDSEFPLTSFQILVTDAEVVVQRIFDCINGYLPGWHYRNTVFIEHTTSYHRSHFCIFVEGVWVCGEFVKKWFEIPFDNRIENYTKQFPWILIGFGNQVSKAL');
INSERT INTO proteininfo VALUES ('12621478', 'NP_075208.1','Hypothetical ORF; Ydl085c-ap [Saccharomyces cerevisiae]','MARGNQRDLARQKNLKKQKDMAKNQKKSGDPKKRMESDAEILRQKQAAADARREAEKLEKLKAEKTRR');
INSERT INTO proteininfo VALUES ('12621476', 'NP_075206.1','Similar to pombe uvi31, putative DNA repair protein; Yal044w-ap [Saccharomyces cerevisiae]','MFKRAMSTDGPVARTILKRLECGFPDYKNFAFGLYNDSHKHKGHAGVQGNVSAETHFRIEMVSKKFEGLKLPQRHRMVYSLLQDEMAQANGIHALQLSLKTPQEYESKAK');
INSERT INTO proteininfo VALUES ('10383811', 'NP_010017.2','Component of the CCR4-NOT complex, which has multiple roles in regulating mRNA levels including regulation of transcription and destabilizing mRNAs by deadenylation; basal transcription factor; Cdc39p [Saccharomyces cerevisiae]','MLSATYRDLNTASNLETSKEKQAAQIVIAQISLLFTTLNNDNFESVEREIRHILDRSSVDIYIKVWERLLTLSSRDILQAGKFLLQENLLHRLLLEFAKDLPKKSTDLIELLKERTFNNQEFQKQTGITLSLFIDLFDKSANKDIIESLDRSSQINDFKTIKMNHTNYLRNFFLQTTPETLESNLRDLLHSLEGESLNDLLALLLSEILSPGSQNLQNDPTRSWLTPPMVLDATNRGNVIARSISSLQANQINWNRVFNLMSTKYFLSAPLMPTTASLSCLFAALHDGPVIDEFFSCDWKVIFKLDLAIQLHKWSVQNGCFDLLNAEGTRKVSETIPNTKQSLLYLLSIASLNLELFLQREELSDGPMLAYFQECFFEDFNYAPEYLILALVKEMKRFVLLIENRTVIDEILITLLIQVHNKSPSSFKDVISTITDDSKIVDAAKIIINSDDAPIANFLKSLLDTGRLDTVINKLPFNEAFKILPCARQIGWEGFDTFLKTKVSPSNVDVVLESLEVQTKMTDTNTPFRSLKTFDLFAFHSLIEVLNKCPLDVLQLQRFESLEFSLLIAFPRLINFGFGHDEAILANGDIAGINNDIEKEMQNYLQKMYSGELAIKDVIELLRRLRDSDLPRDQEVFTCITHAVIAESTFFQDYPLDALATTSVLFGSMILFQLLRGFVLDVAFRIIMRFAKEPPESKMFKFAVQAIYAFRIRLAEYPQYCKDLLRDVPALKSQAQVYQSIVEAATLANAPKERSRPVQEMIPLKFFAVDEVSCQINQEGAPKDVVEKVLFVLNNVTLANLNNKVDELKKSLTPNYFSWFSTYLVTQRAKTEPNYHDLYSKVIVAMGSGLLHQFMVNVTLRQLFVLLSTKDEQAIDKKHLKNLASWLGCITLALNKPIKHKNIAFREMLIEAYKENRLEIVVPFVTKILQRASESKIFKPPNPWTVGILKLLIELNEKANWKLSLTFEVEVLLKSFNLTTKSLKPSNFINTPEVIETLSGALGSITLEQQQTEQQRQIILMQQHQQQMLIYQQRQQQQQQRQQQQQHHISANTIADQQAAFGGEGSISHDNPFNNLLGSTIFVTHPDLKRVFQMALAKSVREILLEVVEKSSGIAVVTTTKIILKDFATEVDESKLKTAAIIMVRHLAQSLARATSIEPLKEGIRSTMQSLAPNLMSLSSSPAEELDTAINENIGIALVLIEKASMDKSTQDLADQLMQAIAIRRYHKERRADQPFITQNTNPYSLSLPEPLGLKNTGVTPQQFRVYEEFGKNIPNLDVIPFAGLPAHAPPMTQNVGLTQPQQQQAQMPTQILTSEQIRAQQQQQQLQKSRLNQPSQSAQPPGVNVPNPQGGIAAVQSDLEQNQRVLVHLMDILVSQIKENATKNNLAELGDQNQIKTIIFQILTFIAKSAQKDQLALKVSQAVVNSLFATSESPLCREVLSLLLEKLCSLSLVARKDVVWWLVYALDSRKFNVPVIRSLLEVNLIDATELDNVLVTAMKNKMENSTEFAMKLIQNTVLSDDPILMRMDFIKTLEHLASSEDENVKKFIKEFEDTKIMPVRKGTKTTRTEKLYLVFTEWVKLLQRVENNDVITTVFIKQLVEKGVISDTDNLLTFVKSSLELSVSSFKESDPTDEVFIAIDALGSLIIKLLILQGFKDDTRRDYINAIFSVIVLVFAKDHSQEGTTFNERPYFRLFSNILYEWATIRTHNFVRISDSSTRQELIEFDSVFYNTFSGYLHALQPFAFPGFSFAWVTLLSHRMLLPIMLRLPNKIGWEKLMLLIIDLFKFLDQYTSKHAVSDAVSVVYKGTLRVILGISNDMPSFLIENHYELMNNLPPTYFQLKNVILSAIPKNMTVPNPYDVDLNMEDIPACKELPEVFFDPVIDLHSLKKPVDNYLRIPSNSLLRTILSAIYKDTYDIKKGVGYDFLSVDSKLIRAIVLHVGIEAGIEYKRTSSNAVFNTKSSYYTLLFNLIQNGSIEMKYQIILSIVEQLRYPNIHTYWFSFVLMNMFKSDEWNDQKLEVQEIILRNFLKRIIVNKPHTWGVSVFFTQLINNNDINLLDLPFVQSVPEIKLILQQLVKYSKKYTTSEQDDQSATINRRQTPLQSNA');
INSERT INTO proteininfo VALUES ('10383810', 'NP_010015.2','Putative serine/threonine protein kinase most similar to cyclic nucleotide-dependent protein kinase subfamily and the protein kinase C subfamily; Kin82p [Saccharomyces cerevisiae]','MTQQEYRSPSQRLSKGRSMSLPKIFARNLRSLQNNAPPGKNINVNCLNVNSCSLSASPSSQINMACNGNKQDLPIPFPLHVECNDSWSSSKLNKFKSMFNHNRSKSSGTTDASTSEKGTHKREPRSTIHTELLQSSIIGEPNVHSTTSSTLIPNEAICSTPNEISGSSSPDAELFTFDMPTDPSSFHTPSSPSYIAKDSRNLSNGSLNDINENEELQNFHRKISENGSASPLANLSLSNSPIDSPRKNSETRKDQIPMNITPRLRRAASEPFNTAKDGLMREDYIALKQPPSLGDIVEPRRSRRLRTKSFGNKFQDITVEPQSFEKIRLLGQGDVGKVYLMRERDTNQIFALKVLNKHEMIKRKKIKRVLTEQEILATSDHPFIVTLYHSFQTKDYLYLCMEYCMGGEFFRALQTRKSKCIAEEDAKFYASEVVAALEYLHLLGFIYRDLKPENILLHQSGHVMLSDFDLSIQATGSKKPTMKDSTYLDTKICSDGFRTNSFVGTEEYLAPEVIRGNGHTAAVDWWTLGILIYEMLFGCTPFKGDNSNETFSNILTKDVKFPHDKEVSKNCKDLIKKLLNKNEAKRLGSKSGAADIKRHPFFKKVQWSFLRNQDPPLIPALNDNGCELPFILSCNKHPKRNSVSEQETKMFCEKVANDDEIDEADPFHDFNSMSLTKKDHNILTYSENYTYGKILYKATCTRPRHNSSHRSFFKDIIPEL');
INSERT INTO proteininfo VALUES ('10383809', 'NP_010013.2','Cell wall adhesin, expressed specifically during mating; may be involved in maintenance of cell wall integrity during mating; Fig2p [Saccharomyces cerevisiae]','MNSFASLGLIYSVVNLLTRVEAQIVFYQNSSTSLPVPTLVSTSIADFHESSSTGEVQYSSSYSYVQPSIDSFTSSSFLTSFEAPTETSSSYAVSSSLITSDTFSSYSDIFDEETSSLISTSAASSEKASSTLSSTAQPHRTSHSSSSFELPVTAPSSSSLPSSTSLTFTSVNPSQSWTSFNSEKSSALSSTIDFTSSEISGSTSPKSLESFDTTGTITSSYSPSPSSKNSNQTSLLSPLEPLSSSSGDLILSSTIQATTNDQTSKTIPTLVDATSSLPPTLRSSSMAPTSGSDSISHNFTSPPSKTSGNYDVLTSNSIDPSLFTTTSEYSSTQLSSLNRASKSETVNFTASIASTPFGTDSATSLIDPISSVGSTASSFVGISTANFSTQGNSNYVPESTASGSSQYQDWSSSSLPLSQTTWVVINTTNTQGSVTSTTSPAYVSTATKTVDGVITEYVTWCPLTQTKSQAIGVSSSISSVPQASSFSGSSILSSNSSTLAASNNVPESTASGSSQYQDWSSSSLPLSQTTWVVINTTNTQGSVTSTTSPAYVSTATKTVDGVITEYVTWCPLTQTKSQAIGISSSTISATQTSKPSSILTLGISTLQLSDATFKGTETINTHLMTESTSITEPTYFSGTSDSFYLCTSEVNLASSLSSYPNFSSSEGSTATITNSTVTFGSTSKYPSTSVSNPTEASQHVSSSVNSLTDFTSNSTETIAVISNIHKTSSNKDYSLTTTQLKTSGMQTLVLSTVTTTVNGAATEYTTWCPASSIAYTTSISYKTLVLTTEVCSHSECTPTVITSVTATSSTIPLLSTSSSTVLSSTVSEGAKNPAASEVTINTQVSATSEATSTSTQVSATSATATASESSTTSQVSTASETISTLGTQNFTTTGSLLFPALSTEMINTTVVSRKTLIISTEVCSHSKCVPTVITEVVTSKGTPSNGHSSQTLQTEAVEVTLSSHQTVTMSTEVCSNSICTPTVITSVQMRSTPFPYLTSSTSSSSLASTKKSSLEASSEMSTFSVSTQSLPLAFTSSEKRSTTSVSQWSNTVLTNTIMSSSSNVISTNEKPSSTTSPYNFSSGYSLPSSSTPSQYSLSTATTTINGIKTVYTTWCPLAEKSTVAASSQSSRSVDRFVSSSKPSSSLSQTSIQYTLSTATTTISGLKTVYTTWCPLTSKSTLGATTQTSSTAKVRITSASSATSTSISLSTSTESESSSGYLSKGVCSGTECTQDVPTQSSSPASTLAYSPSVSTSSSSSFSTTTASTLTSTHTSVPLLPSSSSISASSPSSTSLLSTSLPSPAFTSSTLPTATAVSSSTFIASSLPLSSKSSLSLSPVSSSILMSQFSSSSSSSSSLASLPSLSISPTVDTVSVLQPTTSIATLTCTDSQCQQEVSTICNGSNCDDVTSTATTPPSTVTDTMTCTGSECQKTTSSSCDGYSCKVSETYKSSATISACSGEGCQASATSELNSQYVTMTSVITPSAITTTSVEVHSTESTISITTVKPVTYTSSDTNGELITITSSSQTVIPSVTTIITRTKVAITSAPKPTTTTYVEQRLSSSGIATSFVAAASSTWITTPIVSTYAGSASKFLCSKFFMIMVMVINFI');
INSERT INTO proteininfo VALUES ('10383808', 'NP_010003.2','Hypothetical ORF; Ycr079wp [Saccharomyces cerevisiae]','MRLGNAYAYCKPSQNVGLKLDLLRGLPGYVGHATSRINRLENQDNYSIKMMRSWPNAYGSALNCSVFDGHGEKGAQLSQLLADKLCSSLDFPEPSWDKQDLKKLVQEYARRFPEGNYWKHKLSTFEKFYNKFIKNCNSKQELLLMKEGDSAILGQNGGRMIFDKMGNIIDKIALLTELDRLRLFYGFARFDLDQCCGLGTAAGSTASSIFLYPYDDPNAPIDEGKDDDSWIISHSGLLKLIVTQVGDSKIILCDQDGIAHALTTTHHINSSRERHRLSIDPSRLDPDAFGETRFLNNFANTRSFGDVAGKPYGISSEPDIFSFLVGNTLHLPRSERSKLPFNGDECFLALVTDGITNKLADQEVVDLITSTVNSWGLKKATPQFVAEETIKFIQAIATKHSDNATCVVVRLSNWGNWPNVDRTGPQRETKLMNAQSNETKLN');
INSERT INTO proteininfo VALUES ('10383807', 'NP_010002.2','Topoisomerase II-associated deadenylation-dependent mRNA-decapping factor; also required for faithful chromosome transmission, maintenance of rDNA locus stability, and protection of mRNA 3'-UTRs from trimming; functionally linked to Pab1p; Pat1p [Saccharomyces cerevisiae]','MSFFGLENSGNARDGPLDFEESYKGYGEHELEENDYLNDETFGDNVQVGTDFDFGNPHSSGSSGNAIGGNGVGATARSYVAATAEGISGPRTDGTAAAGPLDLKPMESLWSTAPPPAMAPSPQSTMAPAPAPQQMAPLQPILSMQDLERQQRQMQQQFMNFHAMGHPQGLPQGPPQQQFPMQPASGQPGPSQFAPPPPPPGVNVNMNQMPMGPVQVPVQASPSPIGMSNTPSPGPVVGATKMPLQSGRRSKRDLSPEEQRRLQIRHAKVEKILKYSGLMTPRDKDFITRYQLSQIVTEDPYNEDFYFQVYKIIQRGGITSESNKGLIARAYLEHSGHRLGGRYKRTDIALQRMQSQVEKAVTVAKERPSKLKDQQAAAGNSSQDNKQANTVLGKISSTLNSKNPRRQLQIPRQQPSDPDALKDVTDSLTNVDLASSGSSSTGSSAAAVASKQRRRSSYAFNNGNGATNLNKSGGKKFILELIETVYEEILDLEANLRNGQQTDSTAMWEALHIDDSSYDVNPFISMLSFDKGIKIMPRIFNFLDKQQKLKILQKIFNELSHLQIIILSSYKTTPKPTLTQLKKVDLFQMIILKIIVSFLSNNSNFIEIMGLLLQLIRNNNVSFLTTSKIGLNLITILISRAALIKQDSSRSNILSSPEISTWNEIYDKLFTSLESKIQLIFPPREYNVHIMRLQNDKFMDEAYIWQFLASLALSGKLNHQRIIIDEVRDEIFATINEAETLQKKEKELSVLPQRSQELDTELKSIIYNKEKLYQDLNLFLNVMGLVYRDGEISELK');
INSERT INTO proteininfo VALUES ('10383806', 'NP_009999.2','multicopy suppressor of los1-1; shows similarity to glucose-6-phosphate dehydrogenase non-catalytic domains; homologous to Sol1p and Sol3p; Sol2p [Saccharomyces cerevisiae]','MTTTVPKIFAFHEFSDVAEAVADHVVHAQDGALAPKNERKHSVPNISMNALDMTREASCKSTASAAEGKSGSSGSGSGSSKPKKEKRFKIALSGGSLIEVLHEGLLKRDDVRWGDWDIYFADERLVPFSSNESNYGCAKRKILDLIDTAKYGTPKVYHIDESLIDDPQECADNYEKVLIRGFAGRDSVKLPMFDLFLLGCAPDGHIASLFPNFQDNLREKLAWVVPVENAPSGPSTRISLTIPVICHSHRVTFVVEGATKAPIIKTIMERPEKGLPSSIVNEGAAGRVSWFVDDDALTDVLVTKKKYKFHQGLSI');
INSERT INTO proteininfo VALUES ('10383805', 'NP_009998.2','functionally redundant with, and homologous to, SSK2; protein kinase; Ssk22p [Saccharomyces cerevisiae]','MMMDILNTQQQKAAEGGRVLAPHTISSKLVKRLSSHSSHKLSRSDLKALGGSETISDGPSQLTFKDRYVFNESLYLKKLKKTALDDYYTRGIKLTNRYEEDDGDDEIIRLSNGDRIDEDLHSGVKFFSTTPYCRKMRSDSDELAWNEIATERFKWQSMLARVLKGDIVKGEKTRIANQVKKPGLNKELSDEIWLELKAWLNGRTMQEMEQSLTYLRDSSDSVFEEIMKFQIPQGKILSLDALEAILQDLMNRYHSVVSYWPNLKKMYKDKPITNTAEFTARIDVMNSWLNFKTNLTLRRQELDDWINRFSPISSSDNCQEDFDGVPQWNCKMKILAEQLMKEKNIESIFQKKIFYPLSPWMFKLKLHFIVYRETLTKMNIKYPYERLRSLLAFPVYLIKEVILTRLSYARKLKNPTMMMIDQMIDDFNAFIRLSVQLKYTLTKYCSNLPFDVDFDPTFENTVIEAIRYLFFLLNLKLIDSSKQNFKAPDLLLKYWDHLKNTGHYINGAETVIPNEFLKLTLRLVHKLQFYLLKQQNFPPTFANASEAEKWLSSIFENLGAMKRKLNRFSNILVKAFQNSAVYQINHNAQLVKKLKDAHYFLVYSGNTFESSGVYMFAAPELLGCDNDTILRILRNKSIGCDLVPKLDIGNNLNVYDITTKETDLNILVSKGEDSKGIPYYRVVANSSSDLDRHAHQSKKKNFSTDPFDQHLDEKNNEVFELEVALSSLGALVVLYPGEPVVWDGPVYKLPGNNLFASNEMDLGKIGNPNTLILLNQGSNYALTYQIDKFNQTVGDSVSFIEKRCSLNSIESSLQKINKAYYKLTYTVLNNYKGILGSFMKQCPGNELLNSIFMFGRDFGRSFLKYNAFSSKRKYVIIFLMVKLGMNWLKFLVEECDPTDQRTFRWCVLAMDFAMQMTSGYNILALNVKQFQELKERVSVCMSLLISHFDVMGARATEAENGMQQARLNIDTEENIDEEATLEINSRLRLEAIKTLEKTMKRNPRQMGKVLDATDQGNKYLLSLASSLSNVSMRWQKRSFIGGGTFGQVYSAINLENGEILAVKEIKIHDTTTMKKIFPLIKEEMTVLEMLNHPNIVQYYGVEVHRDKVNIFMEYCEGGSLASLLDHGRIEDEMVTQVYTFELLEGLAYLHQSGVVHRDIKPENILLDFNGIIKYVDFGTARTVVGSRTRTVRNAAVQDFGVETKSLNEMMGTPMYMAPETISGSAVKGKLGADDVWALGCVVLEMATGRRPWSNLDNEWAIMYHVAAGRIPQLPNRDEMTAAGRAFLERCLVQDPTMRATAVELLIDPWMIQIREIAFGNSEKDQVPILSS');
INSERT INTO proteininfo VALUES ('10383804', 'NP_009997.2','Protein required for cell viability; Ycr072cp [Saccharomyces cerevisiae]','MSTLIPPPSKKQKKEAQLPREVAIIPKDLPNVSIKFQALDTGDNVGGALRVPGAISEKQLEELLNQLNGTSDDPVPYTFSCTIQGKKASDPVKTIDITDNLYSSLIKPGYNSTEDQITLLYTPRAVFKVKPVTRSSSAIAGHGSTILCSAFAPHTSSRMVTGAGDNTARIWDCDTQTPMHTLKGHYNWVLCVSWSPDGEVIATGSMDNTIRLWDPKSGQCLGDALRGHSKWITSLSWEPIHLVKPGSKPRLASSSKDGTIKIWDTVSRVCQYTMSGHTNSVSCVKWGGQGLLYSGSHDRTVRVWDINSQGRCINILKSHAHWVNHLSLSTDYALRIGAFDHTGKKPSTPEEAQKKALENYEKICKKNGNSEEMMVTASDDYTMFLWNPLKSTKPIARMTGHQKLVNHVAFSPDGRYIVSASFDNSIKLWDGRDGKFISTFRGHVASVYQVAWSSDCRLLVSCSKDTTLKVWDVRTRKLSVDLPGHKDEVYTVDWSVDGKRVCSGGKDKMVRLWTH');
INSERT INTO proteininfo VALUES ('10383803', 'NP_009996.2','Mitochondrial ribosomal protein of the small subunit; Img2p [Saccharomyces cerevisiae]','MISSCVTRCFGRGKCLPGPATASIYQTIRCISTNSNKAAEAPIFPKLEDVKMHELIGNNNFGKKTYYVERSRTGNLPVYSAYKNGGNKIITEIRKIEGDVIQLRNDLQEQLPFIPKKSWSVVMQSKKIIIKGNAVEAVKRVLTKKF');
INSERT INTO proteininfo VALUES ('10383802', 'NP_009994.2','Lipase, required for intravacuolar lysis of autophagic bodies; located in the endoplasmic reticulum membrane and targeted to intravacuolar vesicles during autophagy via the multivesicular body (MVB) pathway; Atg15p [Saccharomyces cerevisiae]','MLHKSPSRKRFASPLHLGCILTLTVLCLIAYYFALPDYLSVGKSSSRGAMDQKSDGTFRLKSIYRHGVGANHRLHQRLEVTPEVISAAGMLYQETTTQGQDFEDQEPLWTTNAEYATTNPFDFEFELRRMPLLMKRMKERDPEFIESYIYGETYMTEEEEHAMWIDDDIVAPNITDRGTVVSLALMSSNAYVRIPQTGDWRNVTEPWNETEPEDFGWDGDGIRGHVFYNEVENIVVLSIKGTSAQGLPGSGEDETTGNDKINDNLLFSCCCARVSYLWTTVCDCYVKSYICDESCLEKELRRKDRFYSAVVDIYKGVLKEYPDAAIWVTGHSLGGALASLLGRTFGLPAVAFESPGELLPSKRLHLPFPPGLPSYMEGIWHFGHNADPIFMGTCNGASSSCSLVGYAMETACHTGRVCVYDVVNDKGWSVNMFNHRIHKVIDEVLLGYEQAAKCVEPEPCVDCYNWKFIPSRDWESSSRLITKTKSHAAPTTTTRTTATTTSSSTCVGRNWLGFCTKYEL');
INSERT INTO proteininfo VALUES ('10383801', 'NP_009991.2','Forkhead transcription factor involved in cell cycle specific transcription of SPC110, encoding a spindle pole body (SPB) calmodulin binding protein; dosage-dependent suppressor of calmodulin mutants with specific defects in SPB assembly; Hcm1p [Saccharomyces cerevisiae]','MMNEDISIIDGHNSFLTEKSTVLLTQAKRTLEDEKEMITPPSSTVRKTMKEVNKRPSHPLSPDHSSPIAPSKAKRQRSDTCARSNGNLTLEEILQSLERRRINGELAKKPPYSYATLICLAILQSQEGKLTLSQIYHWIHVHFPYYKQKDASWQNSIRHNLSLNDAFIKTEKSCDGKGHFWEVRPGAETKFFKGENRGYEFVKDSLQDIGKYFEIDSTLDELEQVESGEGNDDLPDEEEREEAGKFPSIEIQLNSSPILRVSQLHHIPQLKTDNSVLNPHENLESMRNMIENDVNNIDSLEPPYVMKKYHTSLGLPSLVNAKDHFQAGVKNNNITQANRFNTLPITSAKSPQNFRKYFTSFNSNFEDLSPLRSNVGAGSLLDPLPYSPLKLYDQKNLALMSKPQSQQSYSNSQLPPPPSSHGSDLLKTPKMRHSDGLEKTPSRLISTPKDGNSILRKWQTPSHLFEDLYCSPLFRAIETPIRYITTPGGTLETQISPRKSSAPDVLTSATNSKFASSGLFGVDVYSVWKRATEKISDGNNTTDSNQKHHPYHNHPSNDSGNEKN');
INSERT INTO proteininfo VALUES ('10383800', 'NP_009987.2','Protein of unknown function; green fluorescent protein (GFP)-fusion protein localizes to the cytoplasm in a punctate pattern; Ycr061wp [Saccharomyces cerevisiae]','MVRFVSILSLFGCAATLVTAHDDMDMDMDMDMDMDMNIDTTTSQSIDVSSTASIVPVPHEPKHLHGLPILQSPSLTPAERLYWENYNTTTYFTTQAGNRSALRYHIITLLLVAFVLYPVSLALSAARSRWYLPLLFVNLCICISSVMALSVFKNTFPEEDWYAHNIYGTTSVLLLVFMLVHFFAAVLSVPVSLASKKEYRPVDTIPLNDLESTPVMVNSARGSPSPSSNRDTLFSLSSDTTTATATNNNKRRRAEGEDEGDNTSNHDTLRDEDYDNDDDEIASIEAPPLLPQDIPVFRILFTNTKYQMLAAHLSCVANVVFHMLTYPLFMYIFVDLIIGFAVGNLLGKGIRIFNLLAHWIKGGVFFTLGVVSLARYCGFAAKYGWAWNNISFTSQLTQTRSSNLLFRFAPAGTFTMEFVESFLIFFYGSTNIFLEHLAGNGGAWTAKDLQHVSIAFMFIGTGLCGLLTEYKLNHWRFEHARKRPQTDVVAATPGYSPNPFPAFTIFWTGILMSQHAQSSQFSTTIHTQWGYLLSYGSFFRLLTFLILFLVPNTNSAASKPFTELITSFCLLCGGLVFMESTDQSIEAMEYRGFTPMFTFNLSVGFVSLLMAWEMILFIWKDWLIKTRKTSL');
INSERT INTO proteininfo VALUES ('10383799', 'NP_009967.2','GTP/GDP exchange factor for Rsr1p (Bud1p) required for both axial and bipolar budding patterns; mutants exhibit random budding in all cell types; Bud5p [Saccharomyces cerevisiae]','MSPKNKYVYICVEYIYIYFAKIHKQSTLSSDTTKMFVLIDNVLAYLLEQDDLFVTARFAIQGQIVSRRVNKIHISNITDVLLQQFISHTLPYNDNIVPKKILDSMRTAVRQLLEATACVSRECPLVKRSQDIKRARKRLLSDWYRLGADANMDAVLLVVNSAWRFLAVWRPFVNSIQHATQELYQNIAHYLLHGNVNIQRVTALIQLVMGQDDLLFSMDDVLQEVFRIQLYLNKMLPHNSHKWQKPSPFDSANLLLNFRDWTTDNALLQELLLSYPTINKNKHKNHSVPRLIQIWVESYWQDSETTLKDILNFWYSHLAEYYEYQELFADIVQLFINKKRTRQLKIHYIGLTDKEIEENKPPLDYENLFLQYEIDKTNANDELCGATDLSDLLFQWKQGELLEVEAFALNVSPWSLAKTLTLLESSLYLDIETIEFTRHFKHNDTTIDSVFTLSNQLSSYVLETTLQQTHTISYWLQVALSCLYLRNLNSLASIITSLQNHSIERLSLPIDVKSDHLFQRLKVVVHPNNNYNVYRRTIKHIFHSQLPCVPFTSLLIRDITFIRDGNDTFTKDGNNVNMQKFNQITKIVAFAQYLQQKQYEDIHCSNTTARSLLGAMIKVHTLYNDNKDRAYQVSIAKVPRLT');
INSERT INTO proteininfo VALUES ('10383798', 'NP_009966.2','Low-affinity inorganic phosphate (Pi) transporter, involved in activation of PHO pathway; expression is independent of Pi concentration and Pho4p activity; contains 12 membrane-spanning segments; Pho87p [Saccharomyces cerevisiae]','MRFSHFLKYNAVPEWQNHYLDYNELKNLIYTLQTDELKQETPTGDLNDDADSQTPGPIADIESNIAAGEPSSSKRRFTHKLKRKLFGSKTPSGSKRGDSDEKAIDGNNINEETIELDELSPQGKTTSFNKNFIRKKFFESRSSSVSSEGKTLFSSYDTFVTNLSDEKLKVDDFYKRMEAKFYERFDHLINDLEKEGIVTRLNETFNPEIQALPPLREIISGTSETHSSNNPFEIHSSNIDSELRNRFDYSEEEMDEDDDVDVFADTTDNTALLNYSQFNIKSQKKSLLKQTIINLYIDLCQLKSFIELNRMGFSKITKKSDKVLHMNTRQELIESEEFFKDTYIFQHETLSSLNSKIAQLIEFYAVLMGQPGNVDSCKQELKSYLHDHIVWERSNTWKDMLGLSSQNNDIITIEDEAEKLMQEKLQIEYFKYPLPKPINLKFTKIENLAVPKLFFGKRAMKIGFIIIVTGVLLGVKTFNDPVEHRCMALVECCAFLWASEAIPLHITGLLVPLLTVLFRVLKDDDGKVMGAAAASTEILGTMWSSTIMILLAGFTLGEALSQYNVAKVLASWLLALAGTKPRNVLLMAMSVVFFLSMWISNVASPVLTYSLLTPLLDPLDYTSPFAKALVMGVALSADIGGMASPISSPQNIISMQYLKPYGIGWGQFFAVALPTGILSMLCSWALMILTFKIGKTKLEKFKPIRTRFTIKQYFIIIVTIATILLWCVESQIESAFGSSGEIAVIPIVLFFGTGLLSTKDFNTFPWSIVVLAMGGIALGKAVSSSGLLVTIARALQKKIQNDGVFAILCIFGILMLVVGTFVSHTVSAIIIIPLVQEVGDKLSDPKAAPILVFGCALLASCGMGLASSGFPNVTAISMTDKKGNRWLTVGAFISRGVPASLLAFVCVITLGYGISSSVLKGST');
INSERT INTO proteininfo VALUES ('10383797', 'NP_009965.2','ribokinase; Rbk1p [Saccharomyces cerevisiae]','MGITVIGSLNYDLDTFTDRLPNAGETFRANHFETHAGGKGLNQAAAIGKLKNPSSRYSVRMIGNVGNDTFGKQLKDTLSDCGVDITHVGTYEGINTGTATILIEEKAGGQNRILIVEGANSKTIYDPKQLCEIFPEGKEEEEYVVFQHEIPDPLSIIKWIHANRPNFQIVYNPSPFKAMPKKDWELVDLLVVNEIEGLQIVESVFDNELVEEIREKIKDDFLGEYRKICELLYEKLMNRKKRGIVVMTLGSRGVLFCSHESPEVQFLPAIQNVSVVDTTGAGDTFLGGLVTQLYQGETLSTAIKFSTLASSLTIQRKGAAESMPLYKDVQKDA');
INSERT INTO proteininfo VALUES ('10383796', 'NP_009964.2','Ribosomal RNA Processing; Component of the exosome 3->5 exoribonuclease complex with Rrp4p, Rrp41p, Rrp42p and Dis3p (Rrp44p).; Rrp43p [Saccharomyces cerevisiae]','MAESTTLETIEIHPITFPPEVLARISPELSLQRHLSLGIRPCLRKYEEFRDVAIENNTLSRYADAGNIDTKNNILGSNVLKSGKTIVITSITGGIIEETSAAIKDLDDFGEEELFEVTKEEDIIANYASVYPVVEVERGRVGACTDEEMTISQKLHDSILHSRILPKKALKVKAGVRSANEDGTFSVLYPDELEDDTLNETNLKMKRKWSYVLYAKIVVLSRTGPVFDLCWNSLMYALQSVKLPRAFIDERASDLRMTIRTRGRSATIRETYEIICDQTKSVPLMINAKNIAFASNYGIVELDPECQLQNSDNSEEEEVDIDMDKLNTVLIADLDTEAEETSIHSTISILAAPSGNYKQLTLVGGGAKITPEMIKRSLLLSRVRADDLSTRFNI');
INSERT INTO proteininfo VALUES ('10383795', 'NP_009962.2','Snt1p [Saccharomyces cerevisiae]','MGYPPPTRRLGDKKRYHYSNNPNRRHPSAVYSKNSFPKSSNNGFVSSPTADNSTNPSVTPSTASVPLPTAAPGSTFGIEAPRPSRYDPSSVSRPSSSSYSSTRKIGSRYNPDVERSSSTTSSTPESMNTSTITHTNTDIGNSRYSRKTMSRYNPQSTSSTNVTHFPSALSNAPPFYVANGSSRRPRSMDDYSPDVTNKLETNNVSSVNNNSPHSYYSRSNKWRSIGTPSRPPFDNHVGNMTTTSNTNSIHQREPFWKANSTTILKSTHSQSSPSLHTKKFHDANKLDKPEASVKVETPSKDETKAISYHDNNFPPRKSVSKPNAPLEPDNIKVGEEDALGKKEVHKSGREIAKEHPTPVKMKEHDELEARAKKVSKINIDGKQDEIWTTAKTVASAVEVSKESQKELTRSVERKESPEIRDYERAYDPKALKTDVTKLTVDNDNKSYEEPLEKVEGCIFPLPKAETRLWELKNQKRNKIISEQKYLLKKAIRNFSEYPFYAQNKLIHQQATGLILTKIISKIKKEEHLKKINLKHDYFDLQKKYEKECEILTKLSENLRKEEIENKRKEHELMEQKRREEGIETEKEKSLRHPSSSSSSRRRNRADFVDDAEMENVLLQIDPNYKHYQAAATIPPLILDPIRKHSYKFCDVNNLVTDKKLWASRILKDASDNFTDHEHSLFLEGYLIHPKKFGKISHYMGGLRSPEECVLHYYRTKKTVNYKQLLIDKNKKRKMSAAAKRRKRKERSNDEEVEVDESKEESTNTIEKEEKSENNAEENVQPVLVQGSEVKGDPLGTPEKVENMIEQRGEEFAGELENAERVNDLKRAHDEVGEESNKSSVIETNNGVQIMDPKGAVQNGYYPEETKELDFSLENALQRKKHKSAPEHKTSYWSVRESQLFPELLKEFGSQWSLISEKLGTKSTTMVRNYYQRNAARNGWKLLVDETDLKRDGTSSESVQQSQILIQPERPNINAYSNIPPQQRPALGYFVGQPTHGHNTSISSIDGSIRPFGPDFHRDTFSKISAPLTTLPPPRLPSIQFPRSEMAEPTVTDLRNRPLDHIDTLADAASSVTNNQNFSNERNAIDIGRKSTTISNLLNNSDRSMKSSFQSASRHEAQLEDTPSMNNIVVQEIKPNITTPRSSSISALLNPVNGNGQSNPDGRPLLPFQHAISQGTPTFPLPAPRTSPISRAPPKFNFSNDPLAALAAVASAPDAMSSFLSKKENNN');
INSERT INTO proteininfo VALUES ('10383794', 'NP_009961.2','Protein homologous to human Chediak-Higashi syndrome protein and murine beige gene, which are implicated in disease syndromes due to defective lysosomal trafficking; Bph1p [Saccharomyces cerevisiae]','MNSIINAASKVLRLQDDVKKATIILGDILILQPINHEVEPDVENLVQHELTKIIQGYPIQDNMIINSKKGTVEDDLCELNNYTCFALSKSFDLCHDSRNFNIAQPKRWIQLLETLTDSVSFAVIVQIILTLSNISLINKQTLGKLKKLRIRIFEILSNKNDSWKSTLLQKNLIEWYIFMLSVDCTPLELQNLYLHKELKFCNGILNSLTLQVSDPRSQNYLQFENTYKLFQIQKSSRINNSFLFYIEFNSVTSNRIMTIERHIYLEIKEGQFCISNDNYIIGLFENFEFEAGTLYFIGVLIDHNNRITLYVDGSMINQLTLFENSICQLSTCELGSMICSIKVYRFYLWDGLLTEFAINILQAIGTNYQYTFSKKKEGPEVLSLCQDFLIAKAHLMARPTTEISSTKYIDEIELLEMENIIIDVNPNDILQDFTESSNFTVKFEESTNSKNIPEVGKCYFYRSSNLVSKFVSIDSIRLAFLNMTESGSIDDLFHHVSHLMNLLRNIDILNWFKKDFGFPLFAYTLKQKITQDLSQPLNIQFFNLFLEFCGWDFNDISKSIILDTDAYENIVLNLDLWYMNEDQSSLASGGLEIIRFLFFQISSLMEASIYSKFNSNKFNDMNILEKLCLSYQAVTKRENQNSKFNELSSDLISVFVTLLKSNTDKRHLQWFLHLSYYFIKRKDVRSTEIILQAVDQLFSFYLDQGSDENAKILSEIIPLKLILMIMDQIVENNESNPITCLNILFKVVLTNKPLFKQFYKNDGLKLILTMLCKVGKSYREEIISLLLTYSIGNYTTANEIFSGAEDMIGGISNDKITAKEIIYLAVNFIEWHVINSNASDSSSVLDLNNHILRFVEDLKSLSAVPINESVFDPKKSYVMVSLLDLSIALNESEDISKFKSSSKVISELIKGNIMCALTKYAAYDFEVYMSTFFCHSTEYKLVYPKTVMNNSSYLELSFIVTLLPEILNDLVDSNNNLNLMMLKHPYTMSNLLYFLRKFRPDTSQIVMPKDFYFSSYTCLLHCVIQIDKSSFYHFKNVSKSQLLQDFKICIMNLIYSNTLKQIIWEKEEYEMFSESLMAHQEVLFAHGACDNETVGLLLIFFANRLRDCGYNKAVFNCMKVIIKNKERKLKEVACFFDPANKSEVLEGLSNILSCNNSETMNLITEQYPFFFNNTQQVRFINIVTNILFKNNNFSPISVRQIKNQVYEWKNARSEYVTQNNKKCLILFRKDNTSLDFKIKKSISRYTYNLKTDREENAVFYRNNLNLLIFHLKHTLEIQSNPNSSCKWSSDFAEDFDGMKRRLLPAWEPKYEPLINEEDANQDTITGGNRQRRESGSILSYEFIEHMETLESEPVGDLNENRKILRLLKDNDSIATIWNCSLIIGLEIKEGILIHGSNYLYFVSDYYFSLEDKKILKLSEVSQESRDMTVSLINGPDVKRVSTFLKHEVFVWKLLDITFVTKRPFLLRDVAIELLFKERVSAFFSFYNKRVRDDVLRVLNKIPKHLPADPIFSSVLQEINDRGNSIVARNGIGKASIASKFTSVFSANNSLIDGFEISKKWVRGEISNFYYLLSINILAGRSFNDLTQYPVFPWVIADYESNVLDLENPKTYRDLSKPMGAQSEKRKLQFIERYEALASLENADSAPFHYGTHYSSAMIVSSYLIRLKPFVESFLLLQGGSFGPADRLFSSLERAWSSASSENTTDVRELTPEFFFLPEFLINVNSYDFGTDQSGKKVDDVVLPPWANGDPKVFIQKNREALESPYVSAHLHEWIDLIFGYKQKGDIAVKSVNVFNRLSYPGAVNLDNIDDENERRAITGIIHNFGQTPLQIFQEPHPEKIACNVQQLTTEVWRKVPMKPIFEKTIFNLNEKNRSVDYVIHDPSYFDSLYWRGFAFPNLFFRTEESLVSLRIVHKNWLKIGLDIFKKTHMAQITSFAYWKLGEFITGDKNGLIKVWKYRKDKHSVSGNLENKKTMFGHLCELKEMRCYHDYNTLLTLDISGLVYVWDMINFELVRQITNDAQKVAISQHAGSIMVLTKNNAISIFNLNGQIYTSKKFEPAKIVSSIDFFDFTKLDAGYRKHIYWKEMEILLVGFEDGTIEIYELFLNFHNEWAIKLLKQLCTEKGKAITSIKGQGKTYLSQKRRKDTAEPHEIEVIAGTLDGRLAIWY');
INSERT INTO proteininfo VALUES ('10383793', 'NP_009960.2','Ribosomal protein 59 (rp59) of the small (40S) ribosomal subunit, required for ribosome assembly; mutations confer resistance to cryptopleurine; nearly identical to Rps14Bp and similar to E. coli S11 and rat S14 ribosomal proteins; Rps14ap [Saccharomyces cerevisiae]','MSNVVQARDNSQVFGVARIYASFNDTFVHVTDLSGKETIARVTGGMKVKADRDESSPYAAMLAAQDVAAKCKEVGITAVHVKIRATGGTRTKTPGPGGQAALRALARSGLRIGRIEDVTPVPSDSTRKKGGRRGRRL');
INSERT INTO proteininfo VALUES ('10383792', 'NP_009959.2','Protein with a potential role in actin cytoskeletal organization; overexpression suppresses a pfy1 (profilin) null mutation; Syp1p [Saccharomyces cerevisiae]','MTEQRTKYADSILTTKSPYEATETIRIRLSQVKLLNKDFYLLFKELANLKRNYAQQLRKIIAENEDITKILNAQMIESNVLTPQEMSAFRFNSLGELRNVWDTVIEELKSDLKSSTEYYNTLDQQVVRELKESVENNTSWRESKDLHSKLSKNAASIEHYSKNNENSSHLEEARRQWDQQSPYLFELFETIDYNRLDTLKNCMLRFQTSFSDYLLNTTKECETVMTKFLAFEPQSEIDRFAKDASQYNFQLSSSSKEVVPNNASPASATGARPVSVSNGAANTEREKKSPQKDKRKSAFGNIGHRLASASSSLTHNDLMNNEFSDSTNNSSLKSKKSSHTLRSKVGSIFGRNKTKNKRQQQSSSNSHIQASITETPNNSSTRVSSTATSSIYQKQRRPTYSSSKSNNWTPGEASDTPPLPPHATPKNVDAPVTADTPPAQTFTPSEVPPSTPQQSSPPTAKEPDSSNLPKTVPISISQPPLQPQSKTKPLPVEPASPSISLPTATVDNQPSGQVDSRPLHIRAPALPPSRKQNFIHNRDSQLYDSLPNHGSGATPTSSSLSSIPQERPVSTLSSQITGELRELNPQATGSSTSLVGQSLFQHSSLDTSQFGLNASIAEVLNASFKDGMLQNSQLIGEIALNYLPNSVMNSPLPIGINLRINNGAKFEKVILNQAFIERVAPEEFKVNPSFIDSRTLGAIKYSIKEPIAPIVIHPVWRFESHQASVVLTVKMSPSLPDEISQIVIEDLVVFVNIDGANATSALSKPQGSFSKEKKRITWRFKEPVVLTRNGEGQRLIARFITDGLAHESAKGVITKFTISETDNVALPHSGAGSGITLTCQELDENNPFGGEWLDVNTKRTLTTGNYHGLA');
INSERT INTO proteininfo VALUES ('10383791', 'NP_009958.2','Single-stranded DNA-binding protein that is essential for mitochondrial genome maintenance; Single-stranded zinc finger DNA-binding protein; Rim1p [Saccharomyces cerevisiae]','MFLRTQARFFHATTKKMDFSKMSIVGRIGSEFTEHTSANNNRYLKYSIASQPRRDGQTNWYNITVFNEPQINFLTEYVRKGALVYVEADAANYVFERDDGSKGTTLSLVQKDINLLKNGKKLEDAEGQENAASSE');
INSERT INTO proteininfo VALUES ('10383790', 'NP_009956.2','rheb homologue; GTP-binding protein, ras family; Rhb1p [Saccharomyces cerevisiae]','MEYATMSSSNSTHNFQRKIALIGARNVGKTTLTVRFVESRFVESYYPTIENEFTRIIPYKSHDCTLEILDTAGQDEVSLLNIKSLTGVRGIILCYSIINRASFDLIPILWDKLVDQLGKDNLPVILVGTKADLGRSTKGVKRCVTKAEGEKLASTIGSQDKRNQAAFIECSAELDYNVEETFMLLLKQMERVEGTLGLDAENNNKCSIM');
INSERT INTO proteininfo VALUES ('10383789', 'NP_009955.2','Hypothetical ORF; Ycr026cp [Saccharomyces cerevisiae]','MELQNDLESLDNELNDFSEDPFRDDFITDEDAVRSGWRSAWTRMKYWFYKNRLKWTNNPIVIGDAKDSRDGSNFRRGIPLYELDANGQPIDTELVDENELSFGTGFHSKVPFKIIFRTLFGSLVFAIFLILMINIAKPHHSTRVLSHFGSPEFDPYVKYFNGTHEFFPLTIVISLDGFHPSLISKRNTPFLHDLYELKYDGGMNITSTPFMVPSFPTETFPNHWTLVTGQYPIHHGIVSNVFWDPDLNEEFHPGVLDPRIWNNNDTEPIWQTVQSAFDGDIPFKAATHMWPGSDVNYTKYNEEKLQPEHKNPIARERTPFYFDEFNAKEPLSQKLSKIIEYVDMSTLNERPQLILGYVPNVDAFGHKHGYPSESEYYYEDFTETLGEVDTFLKQLVESLQERNLTSFTNLVIVSDHGMSDIVVPSNVIIWEDLLDEKLRKDYVSHAYLEGPMMAISLKDSGNINEVYHNLKTSIDEDKYTVYVNGNFPKEWNFNDGKNHHMASIWIVPEPGYAVMKKEQLKKVAKGDHKDKNEDNVFTIGSHGYDNNAIDMRSVFIGMGPYFPQGYIEPFQNTEIYNLLCDICGVAEKDRNSNDGTGMLMNQLREPQSSEEVEIEDDFDYLVSKFGEFSTYNIIWGGYPEETEQDNVDNDNDDNDDGNTDEIAAMPSSSLTIKLEMTTSIPSATETLLGETSPSSRSSSSSSIQASATASTVGDWLQDIINDAKDLIDDIIDSIDDLVDSDT');
INSERT INTO proteininfo VALUES ('10383787', 'NP_009952.2','Hypothetical ORF; Ycr023cp [Saccharomyces cerevisiae]','MARQKLTFKEQMDGFPWVQLVVVSLVRFSEPIAFSSLFPYVYFMVRDFNIAPNDAQVSKYSGYLSSSFALCQVISAYHWGRFSEKHGRKITLTCGLIGTSVSLLILGFSRNFYQALVARSLMGLLNGNVGVIRTIIGEIATERKHQALAFSTMPLLFQFGAVVGPMIGGFLVFRDGTMNEVPLWFPHFAKRIIRSYPYALPNVVVCMFLMFGLTNATLFLEETHPAFKDRRDYGLEVGDFIKKNIFGIQPKRRPWQKRIQDDSENIHHRNENVNSIRGQDSEEDENSPLVNTTNDDDTESIQSIDPILTRRQSVGLIRTYSLHEPTDAVHANIDTAPDGCKESSIFHHVFHTKVFYPISVNFIMALHLIVYNEFLPVFLAYDLAVDPENPKKLASKFPWKISGGIGYEPEQTGTLLSTTGIFGCFVVIFIFPIVDRNFDCLTIFRTLVKLYPIMYVMVPYVVFLQNERIPSWYTVVYLYIITGIKTFCGALTSPQIMLLIHNSSPLSCRSVINGATISISASARFIGPLVWGYIMSWSQQNDVAWVSWWSLSLFCMVALYQSYKIAPIDDNENELHGQGSEDAYNSQSQSSDLRMAHRSSLSSLSNQRCTT');
INSERT INTO proteininfo VALUES ('10383786', 'NP_009944.2','involved in the processing of pre-rRNA to mature rRNA; Transcription regulator; Srd1p [Saccharomyces cerevisiae]','MRYNNYDNSGSSFLTRVVKKSDMEKTLLLNREIDDWKSNDKKKAYKERGRVYASCSFIEVSFSQIRAVDVEKKIENAEQLRDLTRNIVKNKTSSLNEITPSKNRVTSACNSERRTTSQEANNLEGYHSCAQGTSRSASITKKYSKKTTSRPKREKRQTILPNGEIKECSKCKDTWTIQWRSGPDQNRELCSPCGLAYGKRLKKENEKKRQAADKRIDRNNP');
INSERT INTO proteininfo VALUES ('10383785', 'NP_009943.2','Putative sensor/transporter protein involved in cell wall biogenesis; contains 14-16 transmembrane segments and several putative glycosylation and phosphorylation sites; null mutation is synthetically lethal with pkc1 deletion; Cwh43p [Saccharomyces cerevisiae]','MLIINGKIIPIAHTICAFSAFFAALVTGYSLHFHKIVTNAHYTYPDEWFPSVSATIGDRYPERSIFQILIALTAFPRFLLLLGHYYLNQSKVCFLVGVLRTVSCGGWVYITSTDDHDIHDIFMITYIVLTLPWDIMITRYSSPLTSKNKGLTATIFFGTLFPMIYWYIQHSVQQRAGAYSIYAYFEWSLILLDIAFDAFAYADFKKIDIVLAFNEKPGNTSFFQIRDSSPINYGEEKSSELQKSGEKKVEKEKPVARSATGSYFRFDSFFYLLTNIFNGFLFWSNVTSLLCSIWHFPLWYMGISGYEAAILGYLGPIFLYLPFVSEAFTQYGVLLGGIIAIGAYIVQMPELRLISVAVGTSITVATFVQNLRYITNAETSFSFALTWLLGLVASVILKMGFYTNNPTWVILDERNGGYNKTALVLTVLFGMLSPYVNSINFEGKRNAQAKSASLIGKLFLAVGFGSLLFGIHQLLTDSSTTIYWAWEGYNESHGPLPWPWGALTCTVMLFASLSSVKFMGKPLVPCLLLLISTAVLSARSITQWPKYIFGGLLYAIAMLWLVPSYFSALGQVQNIWVYVLSFSVYIIFVLAHVWVVAYAFVPMGWVLREKIETVLAFSSTFIIIGALTCKNLNIQLVTMGKKFFIYVFFFAVALLSLTARFVYDIRPTGIPQPYHPDSQLITAGIWTIHFGLDNDMWASEDRMINLIKDMELDVVGLLETDTQRITMGNRDLTSKLAHDLNMYADFGPGPNKHTWGCVLLSKFPIVNSTHHLLPSPVGELAPAIHATLQTYNDTLVDVFVFHSGQEEDEEDRRLQSNYMAKLMGNTTRPAILLSYLVVDPGEGNYNTYVSETSGMHDIDPSDDDRWCEYILYRGLRRTGYARVARGTITDTELQVGKFQVLSEQALVEHSDSMYEYGHMSEPEYEDMKFPDKFLGEGERGHFYHVFDEPRYYL');
INSERT INTO proteininfo VALUES ('10383784', 'NP_009942.2','Hypothetical ORF; Ycr016wp [Saccharomyces cerevisiae]','MSENHVPAWKRIALKRQTISSGDESKEKGQSNLIDDDPLNITTHLSTGNLTKKEKKRIINGESKSSTKKGKRVSKPGTKKKEKLSKDEKNSKKNKILKDQLRYLIEFFRTKSESKFPTGILELESVKENYGDSLIKDEPSESGVVEVWKFSKQKQNWLIKHFFNLDEIPSVYNDLLLLYFRDLQGKSKEELISKCKGKLKQWNDYVEDQETKIKALIAEDKASEPINGEEKEEGEKDGNAEQGKQKEVQDEQEEVQMPNKELVQRSLKLLEIWKNDDSEQIELKNFFVDV');
INSERT INTO proteininfo VALUES ('10383783', 'NP_009941.2','Hypothetical ORF; Ycr015cp [Saccharomyces cerevisiae]','MKTIIISDFDETITRVDTICTIAKLPYLLNPRLKPEWGHFTKTYMDGYHKYKYNGTRSLPLLSSGVPTIISQSNFNKLFADELKYQNHNRVVELNSVNEITKQQIFKSISLDQMKTFARDQNHEDCLLRDGFKTFCSSVVKNFESDFYVLSINWSKEFIHEVIGDRRLKNSHIFCNDLKKVSDKCSQSYNGEFDCRLLTGSDKVKILGEILDKIDSGCNKEGNSCSYWYIGDSETDLLSILHPSTNGVLLINPQENPSKFIKITEKIIGIPKDKISSFEADNGPAWLQFCEKEGGKGAYLVKSWDSLKDLIMQVTKM');
INSERT INTO proteininfo VALUES ('10383782', 'NP_009940.2','Probable homolog of mammalian DNA polymerase beta; may function in double-stranded DNA break repair; DNA polymerase IV; Pol4p [Saccharomyces cerevisiae]','MSLKGKFFAFLPNPNTSSNKFFKSILEKKGATIVSSIQNCLQSSRKEVVILIEDSFVDSDMHLTQKDIFQREAGLNDVDEFLGKIEQSGIQCVKTSCITKWVQNDKFAFQKDDLIKFQPSIIVISDNADDGQSSTDKESEISTDVESERNDDSNNKDMIQASKPLKRLLQGDKGRASLVTDKTKYKNNELIIGALKRLTKKYEIEGEKFRARSYRLAKQSMENCDFNVRSGEEAHTKLRNIGPSIAKKIQVILDTGVLPGLNDSVGLEDKLKYFKNCYGIGSEIAKRWNLLNFESFCVAAKKDPEEFVSDWTILFGWSYYDDWLCKMSRNECFTHLKKVQKALRGIDPECQVELQGSYNRGYSKCGDIDLLFFKPFCNDTTELAKIMETLCIKLYKDGYIHCFLQLTPNLEKLFLKRIVERFRTAKIVGYGERKRWYSSEIIKKFFMGVKLSPRELEELKEMKNDEGTLLIEEEEEEETKLKPIDQYMSLNAKDGNYCRRLDFFCCKWDELGAGRIHYTGSKEYNRWIRILAAQKGFKLTQHGLFRNNILLESFNERRIFELLNLKYAEPEHRNIEWEKKTA');
INSERT INTO proteininfo VALUES ('10383781', 'NP_009938.2','3-phosphoglycerate kinase; Pgk1p [Saccharomyces cerevisiae]','MSLSSKLSVQDLDLKDKRVFIRVDFNVPLDGKKITSNQRIVAALPTIKYVLEHHPRYVVLASHLGRPNGERNEKYSLAPVAKELQSLLGKDVTFLNDCVGPEVEAAVKASAPGSVILLENLRYHIEEEGSRKVDGQKVKASKEDVQKFRHELSSLADVYINDAFGTAHRAHSSMVGFDLPQRAAGFLLEKELKYFGKALENPTRPFLAILGGAKVADKIQLIDNLLDKVDSIIIGGGMAFTFKKVLENTEIGDSIFDKAGAEIVPKLMEKAKAKGVEVVLPVDFIIADAFSADANTKTVTDKEGIPAGWQGLDNGPESRKLFAATVAKAKTIVWNGPPGVFEFEKFAAGTKALLDEVVKSSAAGNTVIIGGGDTATVAKKYGVTDKISHVSTGGGASLELLEGKELPGVAFLSEKK');
INSERT INTO proteininfo VALUES ('10383780', 'NP_009937.2','Shows homology to ATP-dependent permeases; Active transport ATPase; Adp1p [Saccharomyces cerevisiae]','MGSHRRYLYYSILSFLLLSCSVVLAKQDKTPFFEGTSSKNSRLTAQDKGNDTCPPCFNCMLPIFECKQFSECNSYTGRCECIEGFAGDDCSLPLCGGLSPDESGNKDRPIRAQNDTCHCDNGWGGINCDVCQEDFVCDAFMPDPSIKGTCYKNGMIVDKVFSGCNVTNEKILQILNGKIPQITFACDKPNQECNFQFWIDQLESFYCGLSDCAFEYDLEQNTSHYKCNDVQCKCVPDTVLCGAKGSIDISDFLTETIKGPGDFSCDLETRQCKFSEPSMNDLILTVFGDPYITLKCESGECVHYSEIPGYKSPSKDPTVSWQGKLVLALTAVMVLALFTFATFYISKSPLFRNGLGSSKSPIRLPDEDAVNNFLQNEDDTLATLSFENITYSVPSINSDGVEETVLNEISGIVKPGQILAIMGGSGAGKTTLLDILAMKRKTGHVSGSIKVNGISMDRKSFSKIIGFVDQDDFLLPTLTVFETVLNSALLRLPKALSFEAKKARVYKVLEELRIIDIKDRIIGNEFDRGISGGEKRRVSIACELVTSPLVLFLDEPTSGLDASNANNVIECLVRLSSDYNRTLVLSIHQPRSNIFYLFDKLVLLSKGEMVYSGNAKKVSEFLRNEGYICPDNYNIADYLIDITFEAGPQGKRRRIRNISDLEAGTDTNDIDNTIHQTTFTSSDGTTQREWAHLAAHRDEIRSLLRDEEDVEGTDGRRGATEIDLNTKLLHDKYKDSVYYAELSQEIEEVLSEGDEESNVLNGDLPTGQQSAGFLQQLSILNSRSFKNMYRNPKLLLGNYLLTILLSLFLGTLYYNVSNDISGFQNRMGLFFFILTYFGFVTFTGLSSFALERIIFIKERSNNYYSPLAYYISKIMSEVVPLRVVPPILLSLIVYPMTGLNMKDNAFFKCIGILILFNLGISLEILTIGIIFEDLNNSIILSVLVLLGSLLFSGLFINTKNITNVAFKYLKNFSVFYYAYESLLINEVKTLMLKERKYGLNIEVPGATILSTFGFVVQNLVFDIKILALFNVVFLIMGYLALKWIVVEQK');
INSERT INTO proteininfo VALUES ('10383778', 'NP_009923.2','17 kDa phosphatidylglycerolphosphate synthase; Pgs1p [Saccharomyces cerevisiae]','MTTRLLQLTRPHYRLLSLPLQKPFNIKRQMSAANPSPFGNYLNTITKSLQQNLQTCFHFQAKEIDIIESPSQFYDLLKTKILNSQNRIFIASLYLGKSETELVDCISQALTKNPKLKVSFLLDGLRGTRELPSACSATLLSSLVAKYGSERVDCRLYKTPAYHGWKKVLVPKRFNEGLGLQHMKIYGFDNEVILSGANLSNDYFTNRQDRYYLFKSRNFSNYYFKLHQLISSFSYQIIKPMVDGSINIIWPDSNPTVEPTKNKRLFLREASQLLDGFLKSSKQSLPITAVGQFSTLVYPISQFTPLFPKYNDKSTEKRTILSLLSTITSNAISWTFTAGYFNILPDIKAKLLATPVAEANVITASPFANGFYQSKGVSSNLPGAYLYLSKKFLQDVCRYRQDHAITLREWQRGVVNKPNGWSYHAKGIWLSARDKNDANNWKPFITVIGSSNYTRRAYSLDLESNALIITRDEELRKKMKAELDNLLQYTKPVTLEDFQSDPERHVGTGVKIATSILGKKL');
INSERT INTO proteininfo VALUES ('10383777', 'NP_009922.2','Hypothetical ORF; Ycl005wp [Saccharomyces cerevisiae]','MFVVDWSVQLCMGVISPLFRALVQLPLSIFVWNGFQLVALPINIPLRLFLGTSLSRLVAQTSTLDFYVVLTLFQYFAVLCAFGSIIGLIFGFILGVFHSICGVPSVYISLEWKRWFAPIRTVLERASTSIVNIMRGQTIAPIPMPKPNPTHISKPNMKKFHDEPGADDMTITHDVNCYITPCQTPTNEKIQHYNNDSFNTTTTDDEPTDIWDRSDTYQNSFVTNETLMSLSNRAKLRRNASDADIVNIKILRRNSR');
INSERT INTO proteininfo VALUES ('10383775', 'NP_009914.2','Protein involved in bud-site selection and required for axial budding pattern; localizes with septins to bud neck in mitosis and may constitute an axial landmark for next round of budding; Bud3p [Saccharomyces cerevisiae]','MEKDLSSLYSEKKDKENDETLFNIKLSKSVVETTPLNGHSLFDDDKSLSDWTDNVFTQSVFYHGSDDLIWGKFFVCVYKSPNSNKLNAIIFDKLGTSCFESVDISSNSQYYPAIENLSPSDQESNVKKCIAVILLQRYPLLSPSDLSQILSNKSENCDYDPPYAGDLASSCQLITAVPPEDLGKRFFTSGLLQNRFVSSTLLDVIYENNESTIELNNRLVFHLGEQLEQLFNPVTEYSPEQTEYGYKAPEDELPTESDDDLVKAICNELLQLQTNFTFNLVEFLQKFLIALRVRVLNEEINGLSTTKLNRLFPPTIDEVTRINCIFLDSLKTAIPYGSLEVLKACSITIPYFYKAYTRHEAATKNFSKDIKLFIRHFSNVIPEREVYTEMKIESIIKGPQEKLLKLKLIIERLWKSKKWRPKNQEMAKKCYNNIIDVIDSFGKLDSPLHSYSTRVFTPSGKILTELAKCWPVELQYKWLKRRVVGVYDVVDLNDENKRNLLVIFSDYVVFINILEAESYYTSDGSNRPLISDILMNSLINEVPLPSKIPKLKVERHCYIDEVLVSILDKSTLRFDRLKGKDSFSMVCKLSSAFISSSSVADLITKARILEKDTAFHLFKASRSHFTLYSTAHELCAYDSEKIKSKFALFLNIPPSKEILEVNNLHLAFFARFCSNDGRDNIVILDVLTKHDDKHIEVTSDNIVFTIINQLAIEIPICFSSLNSSMAKDLLCVNENLIKNLEHQLEEVKHPSTDEHRAVNSKLSGASDFDATHEKKRSYGTITTFRSYTSDLKDSPSGDNSNVTKETKEILPVKPTKKSSKKPREIQKKTKTNASKAEHIEKKKPNKGKGFFGVLKNVFGSKSKSKPSPVQRVPKKISQRHPKSPVKKPMTSEKKSSPKRAVVSSPKIKKKSTSFSTKESQTAKSSLRAVEFKSDDLIGKPPDVGNGAHPQENTRISSVVRDTKYVSYNPSQPVTENTSNEKNVEPKADQSTKQDNISNFADVEVSASSYPEKLDAETDDQIIGKATNSSSVHGNKELPDLAEVTTANRVSTTSAGDQRIDTQSEFLRAADVENLSDDDEHRQNESRVFNDDLFGDFIPKHYRNKQENINSSSNLFPEGKVPQEKGVSNENTNISLKTNEDASTLTQKLSPQASKVLTENSNELKDTNNEGKDAKDIKLGDDYSDKETAKEITKPKNFVEGITERKEIFPTIPRLAPPASKINFQRSPSYIELFQGMRVVLDKHDAHYNWKRLASQVSLSEGLKVNTEEDAAIINKSQDDAKAERMTQISEVIEYEMQQPIPTYLPKAHLDDSGIEKSDDKFFEIEEELKEELKGSKTGNEDVGNNNPSNSIPKIEKPPAFKVIRTSPVRIIGRTFEDTRKYENGSPSDISFTYDTHNNDEPDKRLMELKFPSQDEIPDDRFYTPAEEPTAEFPVEELPNTPRSINVTTSNNKSTDDKLSSGNIDQKPTELLDDLEFSSFNIAFGNTSMSTDNMKISSDLSSNKTVLGNAQKVQESPSGPLIYVLPQSSTKHEKEGFLRKKQKDEPIWVSPSKIDFADLSRRTKALTPERNTVPLKNNDSRKYKYTGEGSIGNMTNMLLTKDASYAYLKDFVALSDDEDEDGKQNCAVGGPEKLKFY');
INSERT INTO proteininfo VALUES ('10383774', 'NP_009913.2','Defective in sister Chromatid Cohesion; Dcc1p [Saccharomyces cerevisiae]','MSINLHSAPEYDPSYKLIQLTPELLDIIQDPVQNHQLRFKSLDKDKSEVVLCSHDKTWVLKQRKHSNTVLLMREFVPEQPITFDETLLFGLSKPYMDVVGFAKTESEFETRETHGELNLNSVPIYNGELDFSDKIMKRSSTKVIGTLEELLENSPCSALEGISKWHKIGGSVKDGVLCILSQDFLFKALHVLLMSAMAESLDLQHLNVEDTHHAVGKDIEDEFNPYTREIIETVLNKFAVQEQEAENNTWRLRIPFIAQWYGIQALRKYVSGISMPIDEFLIKWKSLFPPFFPCDIDIDMLRGYHFKPTDKTVQYIAKSTLPMDPKERFKVLFRLQSQWDLEDIKPLIEELNSRGMKIDSFIMKYARRKRLGKKTVVTSR');
INSERT INTO proteininfo VALUES ('10383773', 'NP_009912.2','Required for the post-transcriptional thio-modification of both mitochondrial and cytoplasmic tRNAs, also functions in mitochondrial iron-sulfur cluster biogenesis; NifS-like protein; Nfs1p [Saccharomyces cerevisiae]','MLKSTATRSITRLSQVYNVPAATYRACLVSRRFYSPPAAGVKLDDNFSLETHTDIQAAAKAQASARASASGTTPDAVVASGSTAMSHAYQENTGFGTRPIYLDMQATTPTDPRVLDTMLKFYTGLYGNPHSNTHSYGWETNTAVENARAHVAKMINADPKEIIFTSGATESNNMVLKGVPRFYKKTKKHIITTRTEHKCVLEAARAMMKEGFEVTFLNVDDQGLIDLKELEDAIRPDTCLVSVMAVNNEIGVIQPIKEIGAICRKNKIYFHTDAAQAYGKIHIDVNEMNIDLLSISSHKIYGPKGIGAIYVRRRPRVRLEPLLSGGGQERGLRSGTLAPPLVAGFGEAARLMKKEFDNDQAHIKRLSDKLVKGLLSAEHTTLNGSPDHRYPGCVNVSFAYVEGESLLMALRDIALSSGSACTSASLEPSYVLHALGKDDALAHSSIRFGIGRFSTEEEVDYVVKAVSDRVKFLRELSPLWEMVQEGIDLNSIKWSGH');
INSERT INTO proteininfo VALUES ('10383772', 'NP_009911.2','Beta-isopropylmalate dehydrogenase, catalyzes the third step in the leucine biosynthesis pathway; Leu2p [Saccharomyces cerevisiae]','MSAPKKIVVLPGDHVGQEITAEAIKVLKAISDVRSNVKFDFENHLIGGAAIDATGVPLPDEALEASKKADAVLLGAVGGPKWGTGSVRPEQGLLKIRKELQLYANLRPCNFASDSLLDLSPIKPQFAKGTDFVVVRELVGGIYFGKRKEDDGDGVAWDSEQYTVPEVQRITRMAAFMALQHEPPLPIWSLDKANVLASSRLWRKTVEETIKNEFPTLKVQHQLIDSAAMILVKNPTHLNGIIITSNMFGDIISDEASVIPGSLGLLPSASLASLPDKNTAFGLYEPCHGSAPDLPKNKVNPIATILSAAMMLKLSLNLPEEGKAIEDAVKKVLDAGIRTGDLGGSNSTTEVGDAVAEEVKKILA');
INSERT INTO proteininfo VALUES ('10383771', 'NP_009910.2','TyA Gag protein; the main structural constituent of virus-like particles (VLPs); Ycl020wp [Saccharomyces cerevisiae]','MESQQLHQNPRSLHGSAYASVTSKEVPSNQDPLAVSASNLPEFDRDSTKVNSQQETTPGTSAVPENHHHVSPQPASVPPPQNGQYQQHGMMTPNKAMASNWAHYQQPSMMTCSHYQTSPAYYQPDPHYPLPQYIPPLSTSSPDPIDSQNQHSEVPQAETKVRNNVLPPHTLTSEENFSTWVKFYIRFLKNSNLGDIIPNDQGEIKRQMTYEEHAYIYNTFQAFAPFHLLPTWVKQILEINYADILTVLCKSVSKMQTNNQELKDWIALANLEYDGSTSADTFEITVSTIIQRLKENNINVSDRLACQLILKGLSGDFKYLRNQYRTKTNMKLSQLFAEIQLIYDENKIMNLNKPSQYKQHSEYKNVSRTSPNTTNTKVTTRNYQRTNSSKPRAAKAHNIATSSKFSRVNNDHINESTVSSQYLSDDNELSLRPATERI');
INSERT INTO proteininfo VALUES ('10383770', 'NP_009909.2','TyB Gag-Pol protein; proteolytically processed to make the Gag, RT, PR, and IN proteins that are required for retrotransposition; Ycl019wp [Saccharomyces cerevisiae]','MESQQLHQNPRSLHGSAYASVTSKEVPSNQDPLAVSASNLPEFDRDSTKVNSQQETTPGTSAVPENHHHVSPQPASVPPPQNGQYQQHGMMTPNKAMASNWAHYQQPSMMTCSHYQTSPAYYQPDPHYPLPQYIPPLSTSSPDPIDSQNQHSEVPQAETKVRNNVLPPHTLTSEENFSTWVKFYIRFLKNSNLGDIIPNDQGEIKRQMTYEEHAYIYNTFQAFAPFHLLPTWVKQILEINYADILTVLCKSVSKMQTNNQELKDWIALANLEYDGSTSADTFEITVSTIIQRLKENNINVSDRLACQLILKGLSGDFKYLRNQYRTKTNMKLSQLFAEIQLIYDENKIMNLNKPSQYKQHSEYKNVSRTSPNTTNTKVTTRNYQRTNSSKPRAAKAHNIATSSKFSRVNNDHINESTVSSQYLSDDNELSLGQQQKESKPTHTIDSNDELPDHLLIDSGASQTLVRSAHYLHHATPNSEINIVDAQKQDIPINAIGNLHFNFQNGTKTSIKALHTPNIAYDLLSLSELANQNITACFTRNTLERSDGTVLAPIVKHGDFYWLSKKYLIPSHISKLTINNVNKSKSVNKYPYPLIHRMLGHANFRSIQKSLKKNAVTYLKESDIEWSNASTYQCPDCLIGKSTKHRHVKGSRLKYQESYEPFQYLHTDIFGPVHHLPKSAPSYFISFTDEKTRFQWVYPLHDRREESILNVFTSILAFIKNQFNARVLVIQMDRGSEYTNKTLHKFFTNRGITACYTTTADSRAHGVAERLNRTLLNDCRTLLHCSGLPNHLWFSAVEFSTIIRNSLVSPKNDKSARQHAGLAGLDITTILPFGQPVIVNNHNPDSKIHPRGIPGYALHPSRNSYGYIIYLPSLKKTVDTTNYVILQDKQSKLDQFNYDTLTFDDDLNRLTAHNQSFIEQNETEQSYDQNTESDHDYQSEIEINSDPLVNDFSSQSINPLQLDKEPVQKVRAPKEVDADISEYNILPSPVRSRTPHIINKESTEMGGTVESDTTSPRHSSTFTARNQKRPGSPNDMIDLTSQDRVNYGLENIKTTRLGGTEEPYIQRNSDTNIKYRTTNSTPSIDDRSSNSESTTPIISIETKAVCDNTPSIDTDPPEYRSSDHATPNIMPDKSSKNVTADSILDDLPLPDLTHQSPTDTSDVSKDIPHIHSRQTNSSLGGMDDSNVLTTTKSKKRSLEDNETEIEVSRDTWNNKNMRSLEPPRSKKRINLIAAIKGVKSIKPVRTTLRYDEAITYNKDNKEKDRYVEAYHKEISQLLKMNTWDTNKYYDRNDIDPKKVINSMFIFNKKRDGTHKARFVARGDIQHPDTYDSDMQSNTVHHYALMTSLSIALDNDYYITQLDISSAYLYADIKEELYIRPPPHLGLNDKLLRLRKSLYGLKQSGANWYETIKSYLINCCDMQEVRGWSCVFKNSQVTICLFVDDMILFSKDLNANKKIITTLKKQYDTKIINLGESDNEIQYDILGLEIKYQRSKYMKLGMEKSLTEKLPKLNVPLNPKGKKLRAPGQPGHYIDQDELEIDEDEYKEKVHEMQKLIGLASYVGYKFRFDLLYYINTLAQHILFPSRQVLDMTYELIQFMWDTRDKQLIWHKNKPTKPDNKLVAISDASYGNQPYYKSQIGNIFLLNGKVIGGKSTKASLTCTSTTEAEIHAVSEAIPLLNNLSHLVQELNKKPIIKGLLTDSRSTISIIKSTNEEKFRNRFFGTKAMRLRDEVSGNNLYVYYIETKKNIADVMTKPLPIKTFKLLTNKWIH');
INSERT INTO proteininfo VALUES ('10383769', 'NP_065437.1','Hypothetical ORF; Ycl021w-ap [Saccharomyces cerevisiae]','MVLTDAEELRSPVITSDMSFFDLESNHSSDSVHLLCEKYTHKLPIESESQTTFRLAPTKQRLYRQSTLYVPLSLKQRVFLFTERVKSIWAGLPRCKPNKYFKVAFALAVLTPLAIWIFYIDFRVH');
INSERT INTO proteininfo VALUES ('10383767', 'NP_009907.2','Protein kinase of the bud neck involved in the septin checkpoint, associates with septin proteins, negatively regulates Swe1p by phosphorylation, shows structural homology to bud neck kinases Gin4p and Hsl1p; Kcc4p [Saccharomyces cerevisiae]','MTVANTETHSAAKPSSTIGPWKLGETLGFGSTGKVQLAQHERTGHRTAVKVISKSIFNNNGNHSNDDSVLPYNIEREIVIMKLLSHPNVLSLYDVWETNNNLYLILEYAEKGELFNLLVDHGPLPEREAINCFRQIIIGISYCHALGIVHRDLKPENLLLDSFYNIKIADFGMAALQTDADLLETSCGSPHYAAPEIVSGLPYEGFASDVWSCGVILFALLTGRLPFDEENGNVRDLLLKVQKGQFEMPNDTEISRDAQDLIGKILVVDPRQRIKIRDILSHPLLKKYQTIKDSKSIKDLPRENTYLYPLADSNNHTSASIDDSILQNLVVLWHGRHADDIVSKLKENGTNKEKILYALLYRFKLDSVRGSNKKNRNKIKKTKKNKRSSTLSSSSSLLLNNRSIQSTPRRRTSKRHSREFSSSRKRSSFLLSSNPTDSSPIPLRSSKRITHINVASANTQATPSGVPNPHKRNSKKRSSKRLSYMPNTKRSSLTSKSLSNFTNLIDDDDWEYIEKDAKRTSSNFATLIDEIFEPEKFELAKREKAELQRKVQEAKRQSVNAQKINEDEFGSEVSDGMKELKKINDKVSSPLINYEFSQQELLQDIDTLLTNRYQLSSYTRPISRLDPGLTPVTETLPNNLKEKTALLQDTEKKIIETIRRSKFLGSLLNVRGGLSPGKSELAPIEESPIVSTTPLIYNDRMEPRRISDVEVPHFTRKSKHFTTANNRRSVLSLYAKDSIKDLNEFLIKEDPDLPPQGSTDNESRSEDPEIAESITDSRNIQYDEDDSKDGDNVNNDNILSDFPQGVGISQEYDMKDKNPNQSPISKSAEPTLVVKLPSLSSFQGKNASGLGLYQREPSKVTLPSLTSNNSSVGENIEDGAEKGTESEKIAASLSDDDLKEDNDKKDNDTVNAPTTVKKPPNSVLLKKFSKGKILELEIHAKIPEKRLYEGLHKLLEGWKQYGLKNLVFNITNMIITGKLVNDSILFLRSTLFEIMVLPNGDGRSLIKFNKKTGSTKTLTKLATEIQIILQKEGVLDK');
INSERT INTO proteininfo VALUES ('10383766', 'NP_009905.2','Low-affinity amino acid permease with broad substrate range, involved in uptake of asparagine, glutamine, and other amino acids; expression is regulated by the SPS plasma membrane amino acid sensor system (Ssy1p-Ptr3p-Ssy5p); Agp1p [Saccharomyces cerevisiae]','MSSSKSLYELKDLKNSSTEIHATGQDNEIEYFETGSNDRPSSQPHLGYEQHNTSAVRRFFDSFKRADQGPQDEVEATQMNDLTSAISPSSRQAQELEKNESSDNIGANTGHKSDSLKKTIQPRHVLMIALGTGIGTGLLVGNGTALVHAGPAGLLIGYAIMGSILYCIIQACGEMALVYSNLTGGYNAYPSFLVDDGFGFAVAWVYCLQWLCVCPLELVTASMTIKYWTTSVNPDVFVIIFYVLVITINIFGARGYAEAEFFFNCCKILMMTGFFILGIIIDVGGAGNDGFIGGKYWHDPGAFNGKHAIDRFKGVAATLVTAAFAFGGSEFIAITTAEQSNPRKAIPGAAKQMIYRILFLFLATIILLGFLVPYNSDQLLGSTGGGTKASPYVIAVASHGVRVVPHFINAVILLSVLSMANSSFYSSARLFLTLSEQGYAPKVFSYIDRAGRPLIAMGVSALFAVIAFCAASPKEEQVFTWLLAISGLSQLFTWTAICLSHLRFRRAMKVQGRSLGELGFKSQTGVWGSAYACIMMILILIAQFWVAIAPIGEGKLDAQAFFENYLAMPILIALYVGYKVWHKDWKLFIRETRST');
INSERT INTO proteininfo VALUES ('10383765', 'NP_009904.2','Protein of unknown function, involved in the integration of lipid signaling pathways with cellular homeostasis; Frm2p [Saccharomyces cerevisiae]','MSPTGNYLNAITNRRTIYNLKPELPQGVGLDDVKRTVHVILKNTPTAFNSQVNRAVIIVGDTHKRIWDAVASAMPTAEAKKRPESCRDEAYGSVIFFTDEGPTEKLQRDFPALAAAFPTCAAHTTGAVQIQSWTALELLGLGANLQHYNDYVKSALPQDVPIAWTVQSQLVFGVPTALPEEKTFINNVINVYH');
INSERT INTO proteininfo VALUES ('10383764', 'NP_065436.1','Hypothetical ORF; Ycl026c-bp [Saccharomyces cerevisiae]','MSAVATYLKTLTARRTIYALKPELPGEITINDIQSVVQTIIKETPTAFNSQPNRAVILTGETHKKVWDEVTKAIESPAGQKRPASARDEAFGSVIFFTDDKVTEKLKADFPAYAAAFPSFADHTSGAAQINSWVALEAMGLGGHLQHYNGYIKAALPSKIPESWTVQAQLVFGTPAAPPGEKTYIKNDVEIFN');
INSERT INTO proteininfo VALUES ('10383763', 'NP_009903.2','Membrane protein localized to the shmoo tip, required for cell fusion; expression regulated by mating pheromone; proposed to coordinate signaling, fusion, and polarization events required for fusion; potential Cdc28p substrate; Fus1p [Saccharomyces cerevisiae]','MVATIMQTTTTVLTTVAAMSTTLASNYISSQASSSTSVTTVTTIATSIRSTPSNLLFSNVAAQPKSSSASTIGLSIGLPIGIFCFGLLILLCYFYLKRNSVSISNPPMSATIPREEEYCRRTNWFSRLFWQSKCEDQNSYSNRDIEKYNDTQWTSGDNMSSKIQYKISKPIIPQHILTPKKTVKNPYAWSGKNISLDPKVNEMEEEKVVDAFLYTKPPNIVHIESSMPSYNDLPSQKTVSSKKTALKTSEKWSYESPLSRWFLRGSTYFKDYGLSKTSLKTPTGAPQLKQMKMLSRISKGYFNESDIMPDERSPILEYNNTPLDANDSVNNLGNTTPDSQITSYRNNNIDLITARPHSVIYGTTAQQTLETNFNDHHDCNKSTEKHELIIPTPSKPLKKRKKRRQSKMYQHLQHLSRSKPLPLTPNSKYNGEASVQLGKTYTVIQDYEPRLTDEIRISLGEKVKILATHTDGWCLVEKCNTQKGSIHVSVDDKRYLNEDRGIVPGDCLQEYD');
INSERT INTO proteininfo VALUES ('10383762', 'NP_009902.2','[PIN(+)] prion; Rnq1p [Saccharomyces cerevisiae]','MDTDKLISEAESHFSQGNHAEAVAKLTSAAQSNPNDEQMSTIESLIQKIAGYVMDNRSGGSDASQDRAAGGGSSFMNTLMADSKGSSQTQLGKLALLATVMTHSSNKGSSNRGFDVGTVMSMLSGSGGGSQSMGASGLAALASQFFKSGNNSQGQGQGQGQGQGQGQGQGQGSFTALASLASSFMNSNNNNQQGQNQSSGGSSFGALASMASSFMHSNNNQNSNNSQQGYNQSYQNGNQNSQGYNNQQYQGGNGGYQQQQGQSGGAFSSLASMAQSYLGGGQTQSNQQQYNQQGQNNQQQYQQQGQNYQHQQQGQQQQQGHSSSFSALASMASSYLGNNSNSNSSYGGQQQANEYGRPQQNGQQQSNEYGRPQYGGNQNSNGQHESFNFSGNFSQQNNNGNQNRY');
INSERT INTO proteininfo VALUES ('10383761', 'NP_009900.2','Multifunctional enzyme containing phosphoribosyl-ATP pyrophosphatase, phosphoribosyl-AMP cyclohydrolase, and histidinol dehydrogenase activities; catalyzes the second, third, ninth and tenth steps in histidine biosynthesis; His4p [Saccharomyces cerevisiae]','MVLPILPLIDDLASWNSKKEYVSLVGQVLLDGSSLSNEEILQFSKEEEVPLVALSLPSGKFSDDEIIAFLNNGVSSLFIASQDAKTAEHLVEQLNVPKERVVVEENGVFSNQFMVKQKFSQDKIVSIKKLSKDMLTKEVLGEVRTDRPDGLYTTLVVDQYERCLGLVYSSKKSIAKAIDLGRGVYYSRSRNEIWIKGETSGNGQKLLQISTDCDSDALKFIVEQENVGFCHLETMSCFGEFKHGLVGLESLLKQRLQDAPEESYTRRLFNDSALLDAKIKEEAEELTEAKGKKELSWEAADLFYFALAKLVANDVSLKDVENNLNMKHLKVTRRKGDAKPKFVGQPKAEEEKLTGPIHLDVVKASDKVGVQKALSRPIQKTSEIMHLVNPIIENVRDKGNSALLEYTEKFDGVKLSNPVLNAPFPEEYFEGLTEEMKEALDLSIENVRKFHAAQLPTETLEVETQPGVLCSRFPRPIEKVGLYIPGGTAILPSTALMLGVPAQVAQCKEIVFASPPRKSDGKVSPEVVYVAEKVGASKIVLAGGAQAVAAMAYGTETIPKVDKILGPGNQFVTAAKMYVQNDTQALCSIDMPAGPSEVLVIADEDADVDFVASDLLSQAEHGIDSQVILVGVNLSEKKIQEIQDAVHNQALQLPRVDIVRKCIAHSTIVLCDGYEEALEMSNQYAPEHLILQIANANDYVKLVDNAGSVFVGAYTPESCGDYSSGTNHTLPTYGYARQYSGANTATFQKFITAQNITPEGLENIGRAVMCVAKKEGLDGHRNAVKIRMSKLGLIPKDFQ');
INSERT INTO proteininfo VALUES ('10383760', 'NP_009896.2','LAs17 Binding protein; Lsb5p [Saccharomyces cerevisiae]','MGFLSDHPHTAITETIFRIVSSRDYTLEVELAPLIQLIKADHNDYNYTVNQEEAARALRKKIKYGNRLQQSRTLDLLDLFISQGVKFTVMYNDDKLLQRLRGMATNSENSGSGEKYEPRIIKKCAAYAISWLNYITQNNLENARAYSGLYQLGQTVKQRYSKSSRSRRSGGGSGGRSNFMDDSADDTLYQSNSLTSADRLYRIPQINMNKEAPRIRLIISDALASAVSLQNSLIGLPKGKFSTDDEEATSKFIQARAIRRKVLRYLQLVTEGEFLGSLIHANDELVAALTAYDDRSAQDDSSDESDHGSYDDGIYDENEQDNSRYIDSESSEEESLSSYQPSTISNPFGDHNKI');
INSERT INTO proteininfo VALUES ('10383759', 'NP_009889.2','Hypothetical ORF; Ycl042wp [Saccharomyces cerevisiae]','MEKKKILDAALAPRIISGVPTDGQPLSGGPLSWAWCHTTLKRWALMKTRPYKYPLSTEPPTPPSVPNSASVNHNTTTNTTLSYTRCHSTTYTKPLRERSSRPWTRSATISRLPPRSWTN');
INSERT INTO proteininfo VALUES ('10383758', 'NP_009881.2','Hypothetical ORF; Ycl049cp [Saccharomyces cerevisiae]','MFSKYLVTASSLFVALTSAASTVDLDALLLLPGVESHDGVDTVFSTKDFYQVSFVKSIAPAIVNSSVIFHDVSRGVAMGNVKSRASIFNPEETYYDWEQYQVVNNGDWRTEWAPASDCIWREEKDNSDETPDRFPISVPYNWTSQYSIVDYDTDANEDNLDFRFIKSLLDKKNWLKKINQTVSQSSIMVAPMIRPYNVVQLWYSKDMVWANVQRQYCSGVYPGGTQCSAWSRYYHVDAPTCDEPVASYMTKMLENEVQCPNERNATTLEPLRLNKQGDSDFSLTFEEEEEEETGSKSLWSTLKKIFSKRSIS');
INSERT INTO proteininfo VALUES ('10383757', 'NP_009880.2','Diadenosine 5',5''-P1,P4-tetraphosphate phosphorylase I (AP4A phosphorylase), involved in catabolism of bis(5'-nucleosidyl) tetraphosphates; has similarity to Apa2p; Apa1p [Saccharomyces cerevisiae]','MSIPADIASLISDKYKSAFDNGNLKFIQTETTKTKDPKTSMPYLISHMPSLIEKPERGQTPEGEDPLGKPEEELTVIPEFGGADNKAYKLLLNKFPVIPEHTLLVTNEYQHQTDALTPTDLLTAYKLLCALDNEESDKRHMVFYNSGPASGSSLDHKHLQILQMPEKFVTFQDRLCNGKEHFLPTFNTEPLQDAKVSFAHFVLPMPESEETVDEDLLAMCYISILQRALTFFQDWLNENPELKKSYNLMLTKEWICVVPRSKAFSDEMKIGFNSTGYCGMILTKNDEVFSKITEKPELINDILLECGFPNTSGQKPNEYNY');
INSERT INTO proteininfo VALUES ('10383756', 'NP_009879.2','involved in laminarase resistance; Lre1p [Saccharomyces cerevisiae]','MPNTHTQHVQISEPNPVNTLSTPSKRGHRHRRSLAISGDFDFLKQPAAIVNLPPPQAAENCPSTAPTAVSSTLSPIRYNRFPCKTNEDAGTLDLPEPRFYPLSPKNNLQTPSPRFFISEEPSFSSPVKGVPDAIINLDDALKTRPRSFKSHRRSESAPPDLEVMVDKGNCAAGSNSMIKEEEDSLIEPESKNEYYEQKLPTALLSPLRPSLCVSEQAIDVDDSALNGSPTHHNHGMQNANARNSNTFNSLKIKGQKQRYYHYTKQLPLTVGCDSQSPKEQRSAASMTINQAMTPSSLAYTPSKLASTPATPVSFYDSNADINLESDNFPLKDNPRYAKDGYPKKCGNSQLNRVLDSDKRQDFSGESRRRRSGSPISHMQHRNLIDNMKGRRNSNTINSIFNYKSQHYEMPYDDMMKNENINAQSMPFSVNGVNNENSIGGVITRADDAPLQHSVVKSCTPDGKEEMNRLKSNDSNEYSKSEGQIRTNSQLSKDILMGEPGDMVDLSSFVNAQRKASNETGDLVFSLSQDDDALKTFHASNSAATSNESWCISDDALGKQAQDSEVRRKRKSKLGLFRHIFSRK');
INSERT INTO proteininfo VALUES ('10383755', 'NP_065435.1','Hypothetical ORF, has similarity to proteins in S. pombe, C. elegans, D. melanogaster.; Ycl057c-ap [Saccharomyces cerevisiae]','MSEQAQTQQPAKSTPSKDSNKNGSSVSTILDTKWDIVLSNMLVKTAMGFGVGVFTSVLFFKRRAFPVWLGIGFGVGRGYAEGDAIFRSSAGLRSSKV');
INSERT INTO proteininfo VALUES ('10383754', 'NP_009871.2','S-phase checkpoint protein found at replication forks, required for DNA replication; also required for Rad53p activation during DNA replication stress, where it forms a replication-pausing complex with Tof1p and is phosphorylated by Mec1p; protein involved in replication checkpoint; Mrc1p [Saccharomyces cerevisiae]','MDDALHALSSLTAKKRTTTYKKVAVPILDENDNTNGNGPNDIDNPPELTGNGFLFANATLNRVKNRLEGKKAPEQNHNNGKDRSENSLPTQLISNLYDGGEELEKSEVKDNSYSEKNVSSSFTQTQRIPVSIQQDKVFNVPIHSVNDGKPTQLIKEDGLVNETSQALKTPLTTGRPGATQRIDSSGATSQTQPIKSIEPQSQIITTSSNHSNALSPKIPIIPTELIGTSPLFQSIQNRGPDTQMDVPPQTAHDEDKTQAIGIPQATHQEQKTQIDTVAQTLQDEVPHTLKIREIQSELASEDSKREKARNVEYKKPQKPIPTKKFFSKESFLADFDDSSSNEDDDIKLENAHPKPVQNDDELHENKSVELNLTDETRINEKRVPLLSSYANNLKREIDSSKCITLDLDSDSDEYGDDDMDSIKLSKDESVLPISQLSKATILNLKARLSKQNQKLSQRPNKSKDPKVDHNVLLNTLRKASRKQILDHQKEVIETKGLKLEDMAKEKEIVENLLEQEILRNKRIRQKEKRREKLEENDFQLNAHDSGSDSGSESSGFALSGNEIADYESSGSENDNRRESDSEKEDDEIILKQKKSHHVKHIINESDSDTEVEAKPKEKADESLPKRIAINLGHYGDNIGEDTDKFQETNVLDTQNIEEVMAERNTIENEVKDDVYVNEEADEAIRRQLIDKEKLQLKQKEKEHEAKIKELKKRGVTNFFEMEAEESEDEWHGIGGADGEGSDDYDSDLEKMIDDYSKNNFNPHEIREMLAAENKEMDIKMINKILYDIKNGGFRNKRAKNSLELELSDDDEDDVLQQYRLKRRELMRKRRLEIGDDAKLVKNPKSSAFFESMVEDIIEYKNPFGAEEEYNLDITSTATDLDTQDNSINVGDNTGNNEQKPVDQKNKKVIISEDFVQKSLSFLKSNNYEDFETDKELSRIQHGNDEAIEDLYTLKQNSSIKSFTNSQTDSTTSKTVNTIIDLEKRPEDEDEVENGDTSLVGVFKHPSIIKSFASRTDINDKFKEGNKTVKILKSYKTVGSSKASITYMGKTRKLIAPKRKTEGSHRYHHDHHNKKMKMKTKTKSNKLFESGQDSFDN');
INSERT INTO proteininfo VALUES ('10383753', 'NP_009869.2','catabolism of hydroxy amino acids; catabolic serine (threonine) dehydratase; Cha1p [Saccharomyces cerevisiae]','MSIVYNKTPLLRQFFPGKASAQFFLKYECLQPSGSFKSRGIGNLIMKSAIRIQKDGKRSPQVFASSGGNAGFAAATACQRLSLPCTVVVPTATKKRMVDKIRNTGAQVIVSGAYWKEADTFLKTNVMNKIDSQVIEPIYVHPFDNPDIWEGHSSMIDEIVQDLKSQHISVNKVKGIVCSVGGGGLYNGIIQGLERYGLADRIPIVGVETNGCHVFNTSLKIGQPVQFKKITSIATSLGTAVISNQTFEYARKYNTRSVVIEDKDVIETCLKYTHQFNMVIEPACGAALHLGYNTKILENALGSKLAADDIVIIIACGGSSNTIKDLEEALDSMRKKDTPVIEVADNFIFPEKNIVNLKSA');
INSERT INTO proteininfo VALUES ('10383751', 'NP_009865.2','Hypothetical ORF; Ycl068cp [Saccharomyces cerevisiae]','MFVLIDNVLAYLLEQDDLFVTARFAIQGQIVSRRVNKIHISNITDVLLQQFISHTLPYNDNIVPKKILDSMRTAVRQLLEATACVSRECPLVKRSQDIKRARKRLLSDWYRLGADANMDAVLLVVNSAWRFLAVWRPFVNSIQHATQELYQNIAHYLLHGNVNIQRVTALLQLVMGQDDLLFSMDDVLQEVFRIQLYLNKMLPHNSHKWQKPSPFDSANLLLNFRDWTTDNALLQELLLSYPTINKNKHKNHSVPRLIQV');
INSERT INTO proteininfo VALUES ('10383750', 'NP_009863.2','Protein of unconfirmed function; displays a topology characteristic of the Major Facilitators Superfamily of membrane proteins; coding sequence 98% identical to that of YKR106W; Ycl073cp [Saccharomyces cerevisiae]','MSSSVVGASSNKKSGIRQSCEIIERERHSNDDTYSMTSTFFKLKENEIMSAQFDSLKYKILLISTAFVCGFGISLDYTLRSTYTGYATNSYSEHSLLSTVQVINAVVSVGSQVVYSRLSDHFGRLRLFLVATIFYIMGTIIQSQATRLTMYAAGSVFYNCGYVGTNLLLTLILSDFSSLKWRMFYQYASYWPYIIIPWISGNIITAANPQKNWSWNIAMWAFIYPLSALPIIFLILYMKYKSSKTAEWRSLKEQARKERTGGLFENLVFLFWKLDIVGILLITVSLGCILVPLTLANETSQKWHNSKIIATLVSGGCLFFIFLYWEAKFAKSPLLPFKLLSDRGIWAPLGVTFFNFFTFFISCDYLYPVLLVSMKESSTSAARIVNLPDFVAATASPFYSLLVAKTRKLKLSVIGGCAAWMVCMGLFYKYRGGSGSHEGVIAASVIMGLSGLLCSNSVIVILQAMTTHSRMAVITGIQYTFSKLGAAIGASVSGAIWTQTMPNQLYKNLGNDTLAEIAYASPYTFISDYPWGSPERDAVVESYRYVQRIIMTVGLACTVPFFAFTMFMRDPELIDKATHEEFTEDGLVVLPDEENIFSQIKALFRHNRSNKKLGC');
INSERT INTO proteininfo VALUES ('9864778', 'NP_014882.2','Nonessential protein that binds actin filaments and localizes to actin patches and cables, has similarity to S-adenosylmethionine (AdoMet)-dependent methyltransferases; Abp140p [Saccharomyces cerevisiae]','MGVADLIKKFESISKEEGDATVDTNSSSKPLKSNDETKELHQQESTAVPQEVDVNEEFENEPETINSSRTAEKPLETNLPKPETNEEDEEEGSMSENKIYSKGENADINVNDFQEYKEMENTGAEVLASSVEESDAIQEGVAEETEGIATPKQKENEKNDESEEESANNASEPAEEYSQSEEDADIEQSNGKETENAENASQQANDGSTSTTTSKNKKKKNKKKNKKKRNGNVNTNANVDDSTKTGENDDTTGDTTSSTTSAIQEVNDLEVVDDSCLGIDQQHNREHLKALTQDVKEETLENIAHEGRGDNTGDQNAVEKSDFEKSDTEGSRIGRDLPFEFGKRNLTEESDVWDHNAWDNVEWGEEQVQQAEEKIKEQFKHPVPEFDKKLYNENPARYWDIFYKNNKENFFKDRKWLQIEFPILYASTRKDAEPVTIFEIGCGAGNTFFPILKDNENENLRIIAADFAPRAVELVKNSEQFNPKYGHATVWDLANPDGNLPDGVEPHSVDIAVMIFVFSALAPNQWDQAMDNLHKILKPGGKIIFRDYGAYDLTQVRFKKNRILEENFYVRGDGTRVYFFSEEKLREIFTKKYFLENKIGTDRRLLVNRKRQLKMYRCWVQAVFDVPQ');
INSERT INTO proteininfo VALUES ('9755360', 'NP_061495.1','Hypothetical ORF; Yor396wp [Saccharomyces cerevisiae]','MQICALGNSYDAFNHDPWMDVVGFEDPDQVTNRDISRIVLYSYMFLNTAKGCLVEYATFRQYMRELPKNAPQKLNFREMRQGLIALGRHCVGSRFETDLYESATSELMANHSVQTGRNIYGVDSFSLTSVSGTTATLLQERASERWIQWLGLESDYHCSFSSTRNAEDVVAGEAASSDHDQKISRVTRKRPREPKSTNDILVAGQKLFGSSFEFRDLHQLRLCHEIYMADTPSVAVQAPPGYGKTELFHLPLIALASKGDVKYVSFLFVPYTVLLANCMIRLSRCGCLNVAPVRNFIEEGCDGVTDLYVGIYDDLASTNFTDRIAAWENIVECTFRTNNVKLGYLIVDEFHNFETEVYRQSQFGGITNLDFDAFEKAIFLSGTAPEAVADAALQRIGLTGLAKKSMDINELKRSEDLSRGLSSYPTRMFNLIKEKSEVPLGHVHKIWKKVESQPEEALKLLLALFEIEPESKAIVVASTTNEVEELACSWRKYFRVVWIHGKLGAAEKVSRTKEFVTDGSMRVLIGTKLVTEGIDIKQLMMVIMLDNRLNIIELIQGVGRLRDGGLCYLLSRKNSWAARNRKGELPPIKEGCITEQVREFYGLESKKGKKGQHVGCCGSRTDLSADTVELIERMDRLAEKQATASMSIIALPSSFQESNSSDRCRKYCSSDEDSDTCIHGSANASTNATTNSSTNATTTASTNVRTSATTTASINVRTSAITTESTNSSTNATTTASTNVRTSATTTASINVRTSATTTESTNSNTSATTTESTDSNTSATTTESTDSNTSATTTASTNSSTNATTTASTNSSTNATTTESTNASAKEDANKDGNAEDNRFHPVTDINKESYKRKGSQMVLLERKKLKAQFPNTSENMNVLQFLGFRSDEIKHLFLYGIDVYFCPEGVFTQYGLCKGCQKMFELCVCWAGQKVSYRRMAWEALAVERMLRNDEEYKEYLEDIEPYHGDPVGYLKYFSVKRGEIYSQIQRNYAWYLAITRRRETISVLDSTRGKQGSQVFRMSGRQIKELYYKVWSNLRESKTEVLQYFLNWDEKKCREEWEAKDDTVFVEALEKVGVFQRLRSMTSAGLQGPQYVKLQFSRHHRQLRSRYELSLGMHLRDQLALGVTPSKVPHWTAFLSMLIGLFYNKTFRQKLEYLLEQISEVWLLPHWLDLANVEVLAADNTRVPLYMLMVAVHKELDSDDVPDGRFDIILLCRDSSREVGE');
INSERT INTO proteininfo VALUES ('9755359', 'NP_014595.2','Protein of unknown function; green fluorescent protein (GFP)-fusion protein localizes to the cytoplasm in a punctate pattern; Yol047cp [Saccharomyces cerevisiae]','MSTRPQPDWYYHRHPYASTPLAEGEEPQLLPIQDQGNHKKSKIWMAYKAPIVRWYKNAMLVKDNFWKDLESSHQIIWYPYKGISESVGNSDYLHLFFLIFGYYLLNLLLIVAFTSILAWSLLVCIYLPFLGLFALPLAYMQTILISTTLCNSMVKGTDFVLFTRIYGVTFARKGLTELSEACETISFTPFVYRRSHRLGGLFSKRFYLVSLPQFFIFFFWYIFIAFMFLLLLLVPIVGPITINMLPFSPGMGFYYFEPYFVDVLHLDSRKLSKVYYKGFAKWLLYSISSGLLESIPILGGLFIGTNAVGASLWIVKEIKDRDQPAVPPSPPAEPEEPTVGSYAPPIQQSIAHINPP');
INSERT INTO proteininfo VALUES ('9755344', 'NP_015150.2','UDP-GlcNAc-binding and catalytic subunit of the enzyme that mediates the first step in glycosylphosphatidylinositol (GPI) biosynthesis, mutations cause defects in transcription and in biogenesis of cell wall proteins; Spt14p [Saccharomyces cerevisiae]','MGFNIAMLCDFFYPQLGGVEFHIYHLSQKLIDLGHSVVIITHAYKDRVGVRHLTNGLKVYHVPFFVIFRETTFPTVFSTFPIIRNILLREQIQIVHSHGSASTFAHEGILHANTMGLRTVFTDHSLYGFNNLTSIWVNKLLTFTLTNIDRVICVSNTCKENMIVRTELSPDIISVIPNAVVSEDFKPRDPTGGTKRKQSRDKIVIVVIGRLFPNKGSDLLTRIIPKVCSSHEDVEFIVAGDGPKFIDFQQMIESHRLQKRVQLLGSVPHEKVRDVLCQGDIYLHASLTEAFGTILVEAASCNLLIVTTQVGGIPEVLPNEMTVYAEQTSVSDLVQATNKAINIIRSKALDTSSFHDSVSKMYDWMDVAKRTVEIYTNISSTSSADDKDWMKMVANLYKRDGIWAKHLYLLCGIVEYMLFFLLEWLYPRDEIDLAPKWPKKTVSNETKEARET');
INSERT INTO proteininfo VALUES ('9755343', 'NP_061494.1','Hypothetical ORF; Ynr034w-ap [Saccharomyces cerevisiae]','MKSSIPITEVLPRAVGSLTFDENYNLLDTSGVAKVIEKSPIAEIIRKSNAELGRLGYSVYEDAQYIGHAFKKAGHFIVYFTPKNKNREGVVPPVGITN');
INSERT INTO proteininfo VALUES ('9755342', 'NP_014386.2','Meiosis-specific protein with similarity to phospholipase B, required for meiotic spindle pole body duplication and separation; required for spore formation; Spo1p [Saccharomyces cerevisiae]','MQKLLFVFSVLLTVVLATAPFQVQCPSSPLIREAKHELCPEETLYLKKKKIKTKNKLIQFLKSLTEAKFSSKFYKRVLKDPPKIGIAISGGGYRSMLVGTGFISQMNDYGLFEYSDYIAGLSGGSWILMDLVVQNFEVKSLLQEWDLEEDLLLGIPEFDISEEEIVTNAKKEYNDNDLKMKKRQGGSLITSSSNFYEQIEEIMNSIEEIPEDYMITKRNLNPLARLKKIFFPNNTFTGTDAKIETFKKVLDFYKSLHLKIKPKKMEGFQISFTDYWGKAIVQRLKKNFDDDPNHSFSFSKLVNSSKKFKECSVPIPIFVANCKNGLLSNVIFEFTPFEFGSWENILRLFVKLPYLGSKIVSGKAEKCINNFDDLGFITATSSSIFNNVLIFIWNLASQSSREAMKALNMVMGIFGLGKEEIFSISKDSSRLETDYAVYQPNPFYLYPEKDNVLTNKNHLYLVDGGEDGENIPLRTLVIPERELDVIFVLDSSSDIDNYPNGSKLKRIFEKLDEENVHYQFPNNVKTFTHPIVIGCNATKRTGHDSFLPIIIYHANANHGNASNTSTFKITYNQSEVSSMLPTGRGVFSNDYDLYYKNCLGCILTKRTMDRLPRKKKFSPFCLQCFKDYCYS');
INSERT INTO proteininfo VALUES ('9755341', 'NP_013863.2','Protein component of the small (40S) ribosomal subunit; identical to Rps16Bp and has similarity to E. coli S9 and rat S16 ribosomal proteins; Rps16ap [Saccharomyces cerevisiae]','MSAVPSVQTFGKKKSATAVAHVKAGKGLIKVNGSPITLVEPEILRFKVYEPLLLVGLDKFSNIDIRVRVTGGGHVSQVYAIRQAIAKGLVAYHQKYVDEQSKNELKKAFTSYDRTLLIADSRRPEPKKFGGKGARSRFQKSYR');
INSERT INTO proteininfo VALUES ('9755340', 'NP_061493.1','Hypothetical ORF; Ymr122w-ap [Saccharomyces cerevisiae]','MASSTSTSASASSSIKTNSALVSNNVVAASSVSATSTASSSAAKNTTSSSKNAAPGMVANPVSSKYGIIMAAFAAVSFVLGTGI');
INSERT INTO proteininfo VALUES ('9755339', 'NP_013420.2','tRNA-specific adenosine-34 deaminase subunit Tad3p; Tad3p [Saccharomyces cerevisiae]','MVKKVNNPLKIDYQNGIIENRLLQIRNFKDVNTPKLINVWSIRIDPRDSKKVIELIRNDFQKNDPVSLRHLKRIRKDIETSTLEVVLCSKEYICDEGEINNKLKSIWVGTKKYELSDDIEVPEFAPSTKELNNAWSVKYWPLIWNGNPNDQILNDYKIDMQEVRNELSRASTLSVKMATAGKQFPMVSVFVDPSRKKDKVVAEDGRNCENSLPIDHSVMVGIRAVGERLREGVDEDANSYLCLDYDVYLTHEPCSMCSMALIHSRVRRVVFLTEMQRTGSLKLTSGDGYCMNDNKQLNSTYEAFQWIGEEYPVGQVDRDVCC');
INSERT INTO proteininfo VALUES ('9755338', 'NP_013312.2','Hypothetical ORF; Ylr211cp [Saccharomyces cerevisiae]','MSTLAEVYTIIEDAEQECRKGDFTNAKAKYQEAIEVLGPQNENLSQNKLSSDVTQAIDLLKQDITAKIQELELLIEKQSSEENNIGMVNNNMLIGSVILNNKSPINGISNARNWDNPAYQDTLSPINDPLLMSILNRLQFNLNNDIQLKTEGGKNSKNSEMKINLRLEQFKKELVLYEQKKFKEYGMKIDEITKENKKLANEIGRLRERWDSLVESAKQRRDKQKN');
INSERT INTO proteininfo VALUES ('9755337', 'NP_013194.2','v-SNARE component of the vacuolar SNARE complex involved in vesicle fusion; inhibits ATP-dependent Ca(2+) transport activity of Pmc1p in the vacuolar membrane; Nyv1p [Saccharomyces cerevisiae]','MKRFNVSYVEVIKNGETISSCFQPFQKNENYGTITSANEQITPVIFHNLIMDMVLPKVVPIKGNKVTKMSMNLIDGFDCFYSTDDHDPKTVYVCFTLVDMPKILPIRILSGLQEYESNATNELLSSHVGQILDSFHEELVEYRNQTLNSSGNGQSSNGNGQNTISDIGDATEDQIKDVIQIMNDNIDKFLERQERVSLLVDKTSQLNSSSNKFRRKAVNIKEIMWWQKVKNITLLTFTIILFVSAAFMFFYLW');
INSERT INTO proteininfo VALUES ('9755336', 'NP_012924.2','Class E Vps protein of the ESCRT-III complex, required for sorting of integral membrane proteins into lumenal vesicles of multivesicular bodies, and for delivery of newly synthesized vacuolar enzymes to the vacuole, involved in endocytosis; Did4p [Saccharomyces cerevisiae]','MSLFEWVFGKNVTPQERLKKNQRALERTQRELEREKRKLELQDKKLVSEIKKSAKNGQVAAAKVQAKDLVRTRNYIQKFDNMKAQLQAISLRIQAVRSSDQMTRSMSEATGLLAGMNRTMNLPQLQRISMEFEKQSDLMGQRQEFMDEAIDNVMGDEVDEDEEADEIVNKVLDEIGVDLNSQLQSTPQNLVSNAPIAETAMGIPEPIGAGSEFHGNPDDDLQARLNTLKKQT');
INSERT INTO proteininfo VALUES ('9755335', 'NP_012765.2','Zinc-dependent metallopeptidase yscII, may have a role in obtaining leucine from dipeptide substrates; sequence coordinates have changed since RT-PCR analysis showed that the adjacent ORF YKL158W comprises the 5' exon of APE2/YKL157W; Ape2p [Saccharomyces cerevisiae]','MPIVRWLLLKSAVRGSSLIGKAHPCLRSIAAHPRYLSNVYSPPAGVSRSLRINVMWKQSKLTPPRFVKIMNRRPLFTETSHACAKCQKTSQLLNKTPNREILPDNVVPLHYDLTVEPDFKTFKFEGSVKIELKINNPAIDTVTLNTVDTDIHSAKIGDVTSSEIISEEEQQVTTFAFPKGTMSSFKGNAFLDIKFTGILNDNMAGFYRAKYEDKLTGETKYMATTQMEPTDARRAFPCFDEPNLKASFAITLVSDPSLTHLSNMDVKNEYVKDGKKVTLFNTTPKMSTYLVAFIVAELKYVESKNFRIPVRVYATPGNEKHGQFAADLTAKTLAFFEKTFGIQYPLPKMDNVAVHEFSAGAMENWGLVTYRVVDLLLDKDNSTLDRIQRVAEVVQHELAHQWFGNLVTMDWWEGLWLNEGFATWMSWYSCNEFQPEWKVWEQYVTDTLQHALSLDSLRSSHPIEVPVKKADEINQIFDAISYSKGASLLRMISKWLGEETFIKGVSQYLNKFKYGNAKTEDLWDALADASGKDVRSVMNIWTKKVGFPVISVSEDGNGKITFRQNRYLSTADVKPDEDKTIYPVFLALKTKNGVDSSVVLSERSKTIELEDPTFFKVNSEQSGIYITSYTDERWAKLGQQADLLSVEDRVGLVADVKTLSASGYTSTTNFLNLVSKWNNEKSFVVWDQIINSISSMKSTWLFEPKETQDALDNFTKQLISGMTHHLGWEFKSSDSFSTQRLKVTMFGAACAARDADVEKAALKMFTDYCSGNKEAIPALIKPIVFNTVARVGGAENYEKVYKIYLDPISNDEKLAALRSLGRFKEPKLLERTLGYLFDGTVLNQDIYIPMQGMRAHQEGVEALWNWVKKNWDELVKRLPPGLSMLGSVVTLGTSGFTSMQKIDEIKKFFATKSTKGFDQSLAQSLDTITSKAQWG');
INSERT INTO proteininfo VALUES ('9755334', 'NP_011515.2','Protein with similarity to methyltransferase family members; required for replication of Brome mosaic virus in S. cerevisiae, which is a model system for studying replication of positive-strand RNA viruses in their natural hosts; Ygr001cp [Saccharomyces cerevisiae]','MSDSDSDSDYELTLSANALAALEEFKREEQQHQEAFQKLYDETDEDFQKKKKEEGMKLFKEDWQLSQFWYSDDTAAILADAILEGADENTVIAIVSAPSVYAAIQKKPTNEIPTEHIYLFEFDKRFELLAGRDHFFFYDYNKPLDFSDEIKGKVDRLLIDPPFLNEDCQTKSSITAKCLLAPNDNSKTKKGVFKHRLISCTGERMSEVISKVYSDTRITTFLPEHSNGLSNEFRCYANFECSSWKFAS');
INSERT INTO proteininfo VALUES ('9755333', 'NP_011482.2','Meiosis-specific protein that localizes to chromosomes, preventing synapsis between nonhomologous chromosomes and ensuring synapsis between homologs; complexes with Mnd1p to promote homolog pairing and meiotic double-strand break repair; Hop2p [Saccharomyces cerevisiae]','MAPKKKSNDRAIQAKGSEAEQLIEDYLVSQYKPFSVNDIVQNLHNKVTKTTATKALENLVNEKRIVSKTFGKIIIYSCNEQDTALPSNIDPSQFDFETVLQLRNDLIELERDKSTAKDALDSVTKEPENEDLLTIIENEENELKKIESKLQSLQDDWDPANDEIVKRIMSEDTLLQKEITKRSKICKNLIATIKDSVCPKNMNEFLVCILNIFRDLFF');
INSERT INTO proteininfo VALUES ('9755332', 'NP_011263.2','Meoisis specific DNA helicase involved in the conversion of double-standed breaks to later recombination intermediates and in crossover control; catalyzes the unwinding of Holliday junctions; has ssDNA and dsDNA stimulated ATPase activity; Hfm1p [Saccharomyces cerevisiae]','MKTKFDRLGTGKRSRPSPNNIDFNDQSATFKRNKKNSRQPSFKVGLSYNSLLDDCDDENETEEIFEGRGLQFFDKDDNFSITADDTQVTSKLFDHDLEQTPDEEAKKPKKVTIRKSAKKCLSTTILPDSFRGVFKFTEFNKMQSEAFPSIYESNENCIISSPTGSGKTVLFELAILRLIKETNSDTNNTKIIYIAPTKSLCYEMYKNWFPSFVNLSVGMLTSDTSFLETEKAKKCNIIITTPEKWDLLTRRWSDYSRLFELVKLVLVDEIHTIKEKRGASLEVILTRMNTMCQNIRFVALSATVPNIEDLALWLKTNNELPANILSFDESYRQVQLTKFVYGYSFNCKNDFQKDAIYNSKLIEIIEKHADNRPVLIFCPTRASTISTAKFLLNNHIFSKSKKRCNHNPSDKILNECMQQGIAFHHAGISLEDRTAVEKEFLAGSINILCSTSTLAVGVNLPAYLVIIKGTKSWNSSEIQEYSDLDVLQMIGRAGRPQFETHGCAVIMTDSKMKQTYENLIHGTDVLESSLHLNLIEHLAAETSLETVYSIETAVNWLRNTFFYVRFGKNPAAYQEVNRYVSFHSVEDSQINQFCQYLLDTLVKVKIIDISNGEYKSTAYGNAMTRHYISFESMKQFINAKKFLSLQGILNLLATSEEFSVMRVRHNEKKLFKEINLSPLLKYPFLTEKKQSQIIDRVSQKVSLLIQYELGGLEFPSYEGASKLHQTLVQDKFLVFRHCFRLLKCMVDTFIEKSDGTSLKNTLFLLRSLNGHCWENTPMVLRQLKTIGLVSVRRLIRHGITNLEEMGHLSDTQIEYYLNLKIGNGIKIKNDISLLPCLNIRTKLENCKIENEELWLTFKVEISATFKSSIWHGQHLSLDIETEKSSGELIDFRRLQVNKLQSPRGFRISAKISPKLEKIEFSIHCQEIAGLGKTIVYSTDHLASQFSAKTPNIRKDLNSLEKCLFYESSSDGEVGKTSRVSHKDGLEESLSSDDSILDYLNERKKSSKAVESAAVIHPEAHSSSHFSNGRQVRSNGNYECFHSCKDKTQCRHLCCKEGIPVKYIKEKGPSSIKPVSKPDQIRQPLLAKNINTTPHLEKRLNSKPKQWQEENTDIATVHTLPSKIYNLSQQMSSMEAGEQVLKSGPENCPEIIPIDLESSDSYSSNTAASSISDPNGDLDFLGSDIEFE');
INSERT INTO proteininfo VALUES ('9755331', 'NP_010977.2','Protein component of the large (60S) ribosomal subunit, nearly identical to Rpl34Bp and has similarity to rat L34 ribosomal protein; Rpl34ap [Saccharomyces cerevisiae]','MAQRVTFRRRNPYNTRSNKIKVVKTPGGILRAQHVKKLATRPKCGDCGSALQGISTLRPRQYATVSKTHKTVSRAYGGSRCANCVKERIIRAFLIEEQKIVKKVVKEQTEAAKKSEKKAKK');
INSERT INTO proteininfo VALUES ('9755330', 'NP_061492.1','Hypothetical ORF; Yer053c-ap [Saccharomyces cerevisiae]','MQDLEIFLSIFAFIFVFYFGAHRTVMNRNKSDVPYLQ');
INSERT INTO proteininfo VALUES ('9755329', 'NP_010423.2','Related to ubiquitin (53% identical). Homolog of mammalian ubiquitin-like protein NEDD8. Matures by proteolytic removal of C-terminal asparagine (ASN) residue. Requires the proteins ULA1 & UBA3 for activation; ubiquitin-like protein; Rub1p [Saccharomyces cerevisiae]','MIVKVKTLTGKEISVELKESDLVYHIKELLEEKEGIPPSQQRLIFQGKQIDDKLTVTDAHLVEGMQLHLVLTLRGGN');
INSERT INTO proteininfo VALUES ('9755328', 'NP_010092.2','RNA-Binding Suppressor of PAS kinase; Rbs1p [Saccharomyces cerevisiae]','MTALDSRNWGLTPAMETGLFQKPQDRIFIIELENSIVSFINSNTESFQLRPMNSYYRLLSHQIAEYHNLNHVLARTQDSCVILFKGENFQKIEGKPLLQELQLNKKPEECASSSESIEKSNNNRIFRILKRKEVGNECDYKIDGNTRTPNSNLTANSNKDQKIEIDDKSSTDLEQERIEKERLYEQRKQEIFDKLNKSEDDVKSTNSSGSSDSDNEWSDWLNGDDSNTQTSNGSVSSSSPFNSSVTTIQVNKPQQQFYDSRRGRGGRRRGTNNYKDAYRGQSRRNKENGGYQSGYSSPYLVYPPPQMGGNSLPTYPLMYNPAGPAPGPAPSPMVMGNNTVFMNPYMYNMNPQGSCSFGTPIPMYPPYQYQYQYQYNTQYHSGPYSNTPSYNSNNYTRSSANKYHHFQGKNSYSGAIPKRSDDSNSNKNEGIRRASVEGSPSSRDTDSVEMKFDKLNI');
INSERT INTO proteininfo VALUES ('9755327', 'NP_009745.2','Nucleolar component of the pachytene checkpoint, which prevents chromosome segregation when recombination and chromosome synapsis are defective; also represses meiotic interhomolog recombination in the rDNA; Pch2p [Saccharomyces cerevisiae]','MSYIVDLQVRGSSLRVIKCMFREDEQISSLHSGSDSKQNSNKKLGEFLNLLKAVVKRKLESFPKDRLKTSIITGQELMREGQGSIEIKDPPTEAQQHLIRSLAKVLLHQFSSINGKVNTVNEGQDNLFLSLFVKKISIEQQSTSHVSIKLNFHEKINLGQHIDSILDSEETNESDTYHMGSVDEFIIYPFCCLEEQDELKNGSILSTEFDKIDLELDEDDGFEGETLNNCINSVGNFDIPLSKQTLNLVNISYLPGTTFEGQWESLYFGNNIKERLYSYATISLKIARFKQTGDSNQEDITTLITNNKLLLVHGPPGTGKTTLCKALCQKLSVRREFSDGSDTIDTNYKGIIIELSCARIFSKWFGESSKNISIVFKDIEELLKVNEGRGIFICLLIDEVEAIASSRTNLSSRNESTDGIRVVNTLLTQLDRLKKYHNFLALATSNLLDSLDDAFVDRADGVFYVGNPTAEGILHILKVCIEEMITSGIILFHARSTGVKFFNKYQDILRKIAIKCSTVDISGRTIRKLPLMCLSEYFRTFPVDDDEFVLALAMSARKLSAARK');
INSERT INTO proteininfo VALUES ('9755326', 'NP_061491.1','Hypothetical ORF; Ybr085c-ap [Saccharomyces cerevisiae]','MSSALYKQSTNFTHSTGSFLQSAPVELTTVSGYQEFLKKQEKKNYEIQTVLSEDKSHGYVLKDGEVIANIIGEAKDYLLDLAGQA');
INSERT INTO proteininfo VALUES ('7839211', 'NP_058195.1','TyB Gag-Pol protein; proteolytically processed to make the Gag, RT, PR, and IN proteins that are required for retrotransposition; Ypr158c-dp [Saccharomyces cerevisiae]','MESQQLSNYSPISHGSACASVTSKEVHTNQDPLDVSASKTEECEKASTKANSQQTTTPASSAVPENPHHASPQPASVPPPQNGPYPQQCMMTQNQANPSGWSFYGHPSMIPYTPYQMSPMYFPPGPQSQFPQYPSSVGTPLSTPSPESGNTFTDSSSADSDMTSTKKYVRPPPMLTSPNDFPNWVKTYIKFLQNSNLGGIIPTVNGKPVRQITDDELTFLYNTFQIFAPSQFLPTWVKDILSVDYTDIMKILSKSIEKMQSDTQEANDIVTLANLQYNGSTPADAFETKVTNIIDRLNNNGIHINNKVACQLIMRGLSGEYKFLRYTRHRHLNMTVAELFLDIHAIYEEQQGSRNSKPNYRRNLSDEKNDSRSYTNTTKPKVIARNPQKTNNSKSKTARAHNVSTSNNSPSTDNDSISKSTTEPIQLNNKHDLHLGQELTESTVNHTNHSDDELPGHLLLDSGASRTLIRSAHHIHSASSNPDINVVDAQKRNIPINAIGDLQFHFQDNTKTSIKVLHTPNIAYDLLSLNELAAVDITACFTKNVLERSDGTVLAPIVQYGDFYWVSKRYLLPSNISVPTINNVHTSESTRKYPYPFIHRMLAHANAQTIRYSLKNNTITYFNESDVDWSSAIDYQCPDCLIGKSTKHRHIKGSRLKYQNSYEPFQYLHTDIFGPVHNLPKSAPSYFISFTDETTKFRWVYPLHDRREDSILDVFTTILAFIKNQFQASVLVIQMDRGSEYTNRTLHKFLEKNGITPCYTTTADSRAHGVAERLNRTLLDDCRTQLQCSGLPNHLWFSAIEFSTIVRNSLASPKSKKSASQHAGLAGLDISTLLPFGQPVIVNDHNPNSKIHPRGIPGYALHPSRNSYGYIIYLPSLKKTVDTTNYVILQGKESRLDQFNYDALTFDEDLNRLTASYHSFIASNEIQESNDLNIESDHDFQSDIELHPEQPRNVLSKAVSPTDSTPPSTHTEDSKPISEINLRAPREVDPNISESNILPSKKRSSTPQISNIESTGSGGMHKLNVPLLAPMSQSNTHESSHASKSKDFRHSDSYSNNETNHTNVPISSTGGTNNKTVPQISDQETEKRIIHRSPSIDASPPENNSSHNIVPIKTPTTVSEQNTEESIIADLPLPDPPPEPPTELSDSFKELPPINSRQTNSSLGGIGDSNAYTTINSKKRSLEDNETEIKVSRDTWNTKNMRSLEPPRSKKRIHLIAAVKAVKSIKPIRTTLRYDEAITYNKDIKEKEKYIEAYHKEVNQLLKMKTWDTDRYYDRKEIDPKRVINSMFIFNKKRDGTHKARFVARGDIQHPDTYDTGMQSNTVHHYALMTSLSLALDNNYYITQLDISSAYLYADIKEELYIRPPPHLGMNDKLIRLKKSHYGLKQSGANWYETIKSYLIKQCGMEEVRGWSCVFKNSQVTICLFVDDMILFSKDLNANKKIITTLKKQYDTKIINLGESDNEIQYDILGLEIKYQRGKYMKLGMENSLTEKIPKLNVPLNPKGRKLSAPGQPGLYIDQDELEIDEDEYKEKVHEMQKLIGLASYVGYKFRFDLLYYINTLAQHILFPSRQVLDMTYELIQFMWDTRDKQLIWHKNKPTEPDNKLVAISDASYGNQPYYKSQIGNIYLLNGKVIGGKSTKASLTCTSTTEAEIHAISESVPLLNNLSHLVQELNKKPITKGLLTDSKSTISIIISNNEEKFRNRFFGTKAMRLRDEVSGNHLHVCYIETKKNIADVMTKPLPIKTFKLLTNKWIH');
INSERT INTO proteininfo VALUES ('7839210', 'NP_058196.1','TyA Gag protein; the main structural constituent of virus-like particles (VLPs); Ypr158c-cp [Saccharomyces cerevisiae]','MESQQLSNYSPISHGSACASVTSKEVHTNQDPLDVSASKTEECEKASTKANSQQTTTPASSAVPENPHHASPQPASVPPPQNGPYPQQCMMTQNQANPSGWSFYGHPSMIPYTPYQMSPMYFPPGPQSQFPQYPSSVGTPLSTPSPESGNTFTDSSSADSDMTSTKKYVRPPPMLTSPNDFPNWVKTYIKFLQNSNLGGIIPTVNGKPVRQITDDELTFLYNTFQIFAPSQFLPTWVKDILSVDYTDIMKILSKSIEKMQSDTQEANDIVTLANLQYNGSTPADAFETKVTNIIDRLNNNGIHINNKVACQLIMRGLSGEYKFLRYTRHRHLNMTVAELFLDIHAIYEEQQGSRNSKPNYRRNLSDEKNDSRSYTNTTKPKVIARNPQKTNNSKSKTARAHNVSTSNNSPSTDNDSISKSTTEPIQLNNKHDLHLRPGTY');
INSERT INTO proteininfo VALUES ('7839209', 'NP_058193.1','TyB Gag-Pol protein; proteolytically processed to make the Gag, RT, PR, and IN proteins that are required for retrotransposition; Ypr158w-bp [Saccharomyces cerevisiae]','MESQQLSNYPHISHGSACASVTSKEVHTNQDPLDVSASKIQEYDKASTKANSQQTTTPASSAVPENPHHASPQPASVPPPQNGPYPQQCMMTQNQANPSGWSFYGHPSMIPYTPYQMSPMYFPPGPQSQFPQYPSSVGTPLSTPSPESGNTFTDSSSADSDMTSTKKYVRPPPMLTSPNDFPNWVKTYIKFLQNSNLGGIIPTVNGKPVRPITDDELTFLYNTFQIFAPSQFLPTWVKDILSVDYTDIMKILSKSIEKMQSDTQEANDIVTLANLQYNGSTPADAFETKVTNIIDRLNNNGIHINNKVACQLIMRGLSGEYKFLRYTRHRHLNMTVAELFLDIHAIYEEQQGSRNSKPNYRRNPSDEKNDSRSYTNTTKPKVIARNPQKTNNSKSKTARAHNVSTSNNSPSTDNDSISKSTTEPIQLNNKHDLHLGQKLTESTVNHTNHSDDELPGHLLLDSGASRTLIRSAHHIHSASSNPDINVVDAQKRNIPINAIGDLQFHFQDNTKTSIKVLHTPNIAYDLLSLNELAAVDITACFTKNVLERSDGTVLAPIVKYGDFYWVSKKYLLPSNISVPTINNVHTSESTRKYPYPFIHRMLAHANAQTIRYSLKNNTITYFNESDVDWSSAIDYQCPDCLIGKSTKHRHIKGSRLKYQNSYEPFQYLHTDIFGPVHNLPKSAPSYFISFTDETTKFRWVYPLHDRREDSILDVFTTILAFIKNQFQASVLVIQMDRGSEYTNRTLHKFLEKKNGITPCYTTTADSRAHGVAERLNRTLLDDCRTQLQCSGLPNHLWFSAIEFSTIVRNSLASPKSKKSARQHAGLAGLDISTLLPFGQPVIVNDHNPNSKIHPRGIPGYALHPSRNSYGYIIYLPSLKKTVDTTNYVILQGKESRLDQFNYDALTFDEDLNRLTASYHSFIASNEIQESNDLNIESDHDFQSDIELHPEQPRNVLSKAVSPTDSTPPSTHTEDSKRVSKTNIRAPREVDPNISESNILPSKKRSSTPQISNIESTGSGGMHKLNVPLLAPMSQSNTHESSHASKSKDFRHSDSYSENETNHTNVPISSTGGTNNKTVPQISDQETEKRIIHRSPSIDASPPENNSSHNIVPIKTPTTVSEQNTEESIIADLPLPDLPPESPTEFPDPFKELPPINSHQTNSSLGGIGDSNAYTTINSKKRSLEDNETEIKVSRDTWNTKNMRSLEPPRSKKRIHLIAAVKAVKSIKPIRTTLRYDEAITYNKDIKEKEKYIEAYHKEVNQLLKMNTWDTDKYYDRKEIDPKRVINSMFIFNRKRDGTHKARFVARGDIQHPDTYDSGMQSNTVHHYALMTSLSLALDNNYYITQLDISSAYLYADIKEELYIRPPPHLGMNDKLIRLKKSLYGLKQSGANWYETIKSYLIKQCGMEEVRGWSCVFKNSQVTICLFVDDMILFSKDLNANKKIITTLKKQYDTKIINLGESDNEIQYDILGLEIKYQRGKYMKLGMENSLTEKIPKLNVPLNPKGRKLSAPGQPGLYIDQDELEIDEDEYKEKVHEMQKLIGLASYVGYKFRFDLLYYINTLAQHILFPSRQVLDMTYELIQFMWDTRDKQLIWHKNKPTEPDNKLVAISDASYGNQPYYKSQIGNIYLLNGKVIGGKSTKASLTCTSTTEAEIHAISESVPLLNNLSHLVQELNKKPITKGLLTDSKSTISIIISNNEEKFRNRFFGTKAMRLRDEVSGNHLHVCYIETKKNIADVMTKPLPIKTFKLLTNKWIH');
INSERT INTO proteininfo VALUES ('7839208', 'NP_058194.1','TyA Gag protein; the main structural constituent of virus-like particles (VLPs); Ypr158w-ap [Saccharomyces cerevisiae]','MESQQLSNYPHISHGSACASVTSKEVHTNQDPLDVSASKIQEYDKASTKANSQQTTTPASSAVPENPHHASPQPASVPPPQNGPYPQQCMMTQNQANPSGWSFYGHPSMIPYTPYQMSPMYFPPGPQSQFPQYPSSVGTPLSTPSPESGNTFTDSSSADSDMTSTKKYVRPPPMLTSPNDFPNWVKTYIKFLQNSNLGGIIPTVNGKPVRPITDDELTFLYNTFQIFAPSQFLPTWVKDILSVDYTDIMKILSKSIEKMQSDTQEANDIVTLANLQYNGSTPADAFETKVTNIIDRLNNNGIHINNKVACQLIMRGLSGEYKFLRYTRHRHLNMTVAELFLDIHAIYEEQQGSRNSKPNYRRNPSDEKNDSRSYTNTTKPKVIARNPQKTNNSKSKTARAHNVSTSNNSPSTDNDSISKSTTEPIQLNNKHDLHLRPETY');
INSERT INTO proteininfo VALUES ('7839207', 'NP_058191.1','TyB Gag-Pol protein; proteolytically processed to make the Gag, RT, PR, and IN proteins that are required for retrotransposition; Ypr137c-bp [Saccharomyces cerevisiae]','MESQQLSQHSPISHGSACASVTSKEVHTNQDPLDVSASKTEECEKASTKANSQQTTTPASSAVPENPHHASPQTAQSHSPQNGPYPQQCMMTQNQANPSGWSFYGHPSMIPYTPYQMSPMYFPPGPQSQFPQYPSSVGTPLSTPSPESGNTFTDSSSADSDMTSTKKYVRPPPMLTSPNDFPNWVKTYIKFLQNSNLGGIIPTVNGKPVRQITDDELTFLYNTFQIFAPSQFLPTWVKDILSVDYTDIMKILSKSIEKMQSDTQEANDIVTLANLQYNGSTPADAFETKVTNIIDRLNNNGIHINNKVACQLIMRGLSGEYKFLRYTRHRHLNMTVAELFLDIHAIYEEQQGSRNSKPNYRRNPSDEKNDSRSYTNTTKPKVIARNPQKTNNSKSKTARAHNVSTSNNSPSTDNDSISKSTTEPIQLNNKHDLHLGQKLTESTVNHTNHSDDELPGHLLLDSGASRTLIRSAHHIHSASSNPDINVVDAQKRNIPINAIGDLQFHFQDNTKTSIKVLHTPNIAYDLLSLNELAAVDITACFTKNVLERSDGTVLAPIVKYGDFYWVSKKYLLPSNISVPTINNVHTSESTRKYPYPFIHRMLAHANAQTIRYSLKNNTITYFNESDVDWSSAIDYQCPDCLIGKSTKHRHIKGSRLKYQNSYEPFQYLHTDIFGPVHNLPKSAPSYFISFTDETTKFRWVYPLHDRREDSILDVFTTILAFIKNQFQASVLVIQMDRGSEYTNRTLHKFLEKNGITPCYTTTADSRAHGVAERLNRTLLDDCRTQLQCSGLPNHLWFSAIEFSTIVRNSLASPKSKKSARQHAGLAGLDISTLLPFGQPVIVNDHNPNSKIHPRGIPGYALHPSRNSYGYIIYLPSLKKTVDTTNYVILQGKESRLDQFNYDALTFDEDLNRLTASYHSFIASNEIQESNDLNIESDHDFQSDIELHPEQPRNVLSKAVSPTDSTPPSTHTEDSKRVSKTNIRAPREVDPNISESNILPSKKRSSTPQISNIESTGSGGMHKLNVPLLAPMSQSNTHESSHASKSKDFRHSDSYSENETNHTNVPISSTGGTNNKTVPQISDQETEKRIIHRSPSIDASPPENNSSHNIVPIKTPTTVSEQNTEESIIADLPLPDLPPESPTEFPDPFKELPPINSHQTNSSLGGIGDSNAYTTINSKKRSLEDNETEIKVSRDTWNTKNMRSLEPPRSKKRIHLIAAVKAVKSIKPIRTTLRYDEAITYNKDIKEKEKYIEAYHKEVNQLLKMNTWDTDKYYDRKEIDPKRVINSMFIFNKKRDGTHKARFVARGDIQHPDTYDTGMQSNTVHHYALMTSLSLALDNNYYITQLDISSAYLYADIKEELYIRPPPHLGMNDKLIRLKKSHYGLKQSGANWYETIKSYLIKQCGMEEVRGWSCVFKNSQVTICLFVDDMILFSKDLNANKKIITTLKKQYDTKIINLGESDNEIQYDILGLEIKYQRGKYMKLGMENSLTEKIPKLNVPLNPKGRKLSAPGQPGLYIDQDELEIDEDEYKEKVHEMQKLIGLASYVGYKFRFDLLYYINTLAQHILFPSRQVLDMTYELIQFMWDTRDKQLIWHKNKPTEPDNKLVAISDASYGNQPYYKSQIGNIFLLNGKVIGGKSTKASLTCTSTTEAEIHAVSEAIPLLNNLSHLVQELNKKPIIKGLLTDSRSTISIIKSTNEEKFRNRFFGTKAMRLRDEVSGNNLYVYYIETKKNIADVMTKPLPIKTFKLLTNKWIH');
INSERT INTO proteininfo VALUES ('7839206', 'NP_058192.1','TyA Gag protein; the main structural constituent of virus-like particles (VLPs); Ypr137c-ap [Saccharomyces cerevisiae]','MESQQLSQHSPISHGSACASVTSKEVHTNQDPLDVSASKTEECEKASTKANSQQTTTPASSAVPENPHHASPQTAQSHSPQNGPYPQQCMMTQNQANPSGWSFYGHPSMIPYTPYQMSPMYFPPGPQSQFPQYPSSVGTPLSTPSPESGNTFTDSSSADSDMTSTKKYVRPPPMLTSPNDFPNWVKTYIKFLQNSNLGGIIPTVNGKPVRQITDDELTFLYNTFQIFAPSQFLPTWVKDILSVDYTDIMKILSKSIEKMQSDTQEANDIVTLANLQYNGSTPADAFETKVTNIIDRLNNNGIHINNKVACQLIMRGLSGEYKFLRYTRHRHLNMTVAELFLDIHAIYEEQQGSRNSKPNYRRNPSDEKNDSRSYTNTTKPKVIARNPQKTNNSKSKTARAHNVSTSNNSPSTDNDSISKSTTEPIQLNNKHDLHLRPETY');
INSERT INTO proteininfo VALUES ('7839205', 'NP_058189.1','TyB Gag-Pol protein; proteolytically processed to make the Gag, RT, PR, and IN proteins that are required for retrotransposition; Ypl257w-bp [Saccharomyces cerevisiae]','MESQQLSQHSPISHGSACASVTSKEVHTNQDPLDVSASKTEECEKASTKANSQQTTTPASSAVPENPHHASPQPASVPPPQNGPYPQQCMMTQNQANPSGWSFYGHPSMIPYTPYQMSPMYFPPGPQSQFPQYPSSVGTPLSTPSPESGNTFTDSSSADSDMTSTKKYVRPPPMLTSPNDFPNWVKTYIKFLQNSNLGGIIPTVNGKPVRQITDDELTFLYNTFQIFAPSQFLPTWVKDILSVDYTDIMKILSKSIEKMQSDTQEANDIVTLANLQYNGSTPADAFETKVTNIIDRLNNNGIHINNKVACQLIMRGLSGEYKFLRYTRHRHLNMTVAELFLDIHAIYEEQQGSRNSKPNYRRNLSDEKNDSRSYTNTTKPKVIARNPQKTNNSKSKTARAHNVSTSNNSPSTDNDSISKSTTEPIQLNNKHDLHLGQELTESTVNHTNHSDDELPGHLLLDSGASRTLIRSAHHIHSASSNPDINVVDAQKRNIPINAIGDLQFHFQDNTKTSIKVLHTPNIAYDLLSLNELAAVDITACFTKNVLERSDGTVLAPIVKYGDFYWVSKKYLLPSNISVPTINNVHTSESTRKYPYPFIHRMLAHANAQTIRYSLKNNTITYFNESDVDWSSAIDYQCPDCLIGKSTKHRHIKGSRLKYQNSYEPFQYLHTDIFGPVHNLPNSAPSYFISFTDETTKFRWVYPLHDRREDSILDVFTTILAFIKNQFQASVLVIQMDRGSEYTNRTLHKFLEKNGITPCYTTTADSRAHGVAERLNRTLLDDCRTQLQCSGLPNHLWFSAIEFSTIVRNSLASPKSKKSARQHAGLAGLDISTLLPFGQPVIVNDHNPNSKIHPRGIPGYALHPSRNSYGYIIYLPSLKKTVDTTNYVILQGKESRLDQFNYDALTFDEDLNRLTASYHSFIASNEIQESNDLNIESDHDFQSDIELHPEQPRNVLSKAVSPTDSTPPSTHTEDSKRVSKTNIRAPREVDPNISESNILPSKKRSSTPQISNIESTGSGGMHKLNVPLLAPMSQSNTHESSHASKSKDFRHSDSYSENETNHTNVPISSTGGTNNKTVPQISDQETEKRIIHRSPSIDASPPENNSSHNIVPIKTPTTVSEQNTEESIIADLPLPDLPPESPTEFPDPFKELPPINSRQTNSSLGGIGDSNAYTTINSKKRSLEDNETEIKVSRDTWNTKNMRSLEPPRSKKRIHLIAAVKAVKSIKPIRTTLRYDEAITYNKDIKEKEKYIEAYHKEVNQLLKMKTWDTDEYYDRKEIDPKRVINSMFIFNKKRDGTHKARFVARGDIQHPDTYDSGMQSNTVHHYALMTSLSLALDNNYYITQLDISSAYLYADIKEELYIRPPPHLGMNDKLIRLKKSLYGLKQSGANWYETIKSYLIKQCGMEEVRGWSCVFKNSQVTICLFVDDMILFSKDLNANKKIITTLKKQYDTKIINLGESDNEIQYDILGLEIKYQRGKYMKLGMENSLTEKIPKLNVPLNPKGRKLSAPGQPGLYIDQDELEIDEDEYKEKVHEMQKLIGLASYVGYKFRFDLLYYINTLAQHILFPSRQVLDMTYELIQFMWDTRDKQLIWHKNKPTEPDNKLVAISDASYGNQPYYKSQIGNIYLLNGKVIGGKSTKASLTCTSTTEAEIHAISESVPLLNNLSYLIQELNKKPIIKGLLTDSRSTISIIKSTNEEKFRNRFFGTKAMRLRDEVSGNNLYVYYIETKKNIADVMTKPLPIKTFKLLTNKWIH');
INSERT INTO proteininfo VALUES ('7839204', 'NP_058190.1','TyA Gag protein; the main structural constituent of virus-like particles (VLPs); Ypl257w-ap [Saccharomyces cerevisiae]','MESQQLSQHSPISHGSACASVTSKEVHTNQDPLDVSASKTEECEKASTKANSQQTTTPASSAVPENPHHASPQPASVPPPQNGPYPQQCMMTQNQANPSGWSFYGHPSMIPYTPYQMSPMYFPPGPQSQFPQYPSSVGTPLSTPSPESGNTFTDSSSADSDMTSTKKYVRPPPMLTSPNDFPNWVKTYIKFLQNSNLGGIIPTVNGKPVRQITDDELTFLYNTFQIFAPSQFLPTWVKDILSVDYTDIMKILSKSIEKMQSDTQEANDIVTLANLQYNGSTPADAFETKVTNIIDRLNNNGIHINNKVACQLIMRGLSGEYKFLRYTRHRHLNMTVAELFLDIHAIYEEQQGSRNSKPNYRRNLSDEKNDSRSYTNTTKPKVIARNPQKTNNSKSKTARAHNVSTSNNSPSTDNDSISKSTTEPIQLNNKHDLHLRPGTY');
INSERT INTO proteininfo VALUES ('7839201', 'NP_058185.1','TyB Gag-Pol protein; proteolytically processed to make the Gag, RT, PR, and IN proteins that are required for retrotransposition; Yor192c-bp [Saccharomyces cerevisiae]','MESQQLSQNSPTFHGSAYASVTSKEVPSNQDPLAVSASNLPEFDRDSTKVNSQQETTPGTSAVPENHHHVSPQPASVPPPQNGQYQQHGMMTPNKAMASNWAHYQQPSMMTCSHYQTSPAYYQPDPHYPLPQYIPPLSTSSPDPIGSQDQHSEVPQAKTKVRNNVLPPHTLTSEENFSTWVKFYIRFLKNSNLGDIIPNDQGEIKRQMTYEEHAYIYNTFQAFAPFHLLPTWVKQILEINYSDILTVLCKSVSKMQTNNQELKDWIALANLEYNGSTSADTFEITVSTIIQRLKENNINVSDRLACQLILKGLSGDFKYLRNQYRTKTNMKLSQLFAEIQLIYDENKIMNLNKPSQYKQHSEYKNVSRTSPNTTNTKVTTRNYHRTNSSKPRAAKAHNIATSSKFSRVNNDHINESTVSSQYLSDDNELSLGQQQKESKPTRTIDSNDELPDHLLIDSGASQTLVRSAHYLHHATPNSEINIVDAQKQDIPINAIGNLHFNFQNGTKTSIKALHTPNIAYDLLSLSELANQNITACFTRNTLERSDGTVLAPIVKHGDFYWLSKKYLIPSHISKLTINNVNKSKSVNKYPYPLIHRMLGHANFRSIQKSLKKNAVTYLKESDIEWSNASTYQCPDCLIGKSTKHRHVKGSRLKYQESYEPFQYLHTDIFGPVHHLPKSAPSYFISFTDEKTRFQWVYPLHDRREESILNVFTSILAFIKNQFNARVLVIQMDRGSEYTNKTLHKFFTNRGITACYTTTADSRAHGVAERLNRTLLNDCRTLLHCSGLPNHLWFSAVEFSTIIRNSLVSPKNDKSARQHAGLAGLDITTILPFGQPVIVNNHNPDSKIHPRGIPGYALHPSRNSYGYIIYLPSLKKTVDTTNYVILQNKQTKLDQFDYDTLTFDDDLNRLTAHNQSFIEQNETEQSYDQNTESDHDYQSEIEINSDPLVNDFSSQSLNPLQLDKEPVQKVRAPKEVDADISEYNILPSTIRSRTPHIINKESTEMGGTIESDTTSPRHSSTFTARNQKRPGSPNDMIDLTSQDRVNYGLENIKTTRLGGTEEPYIQRNSDTNIKYRTTNSTPSIDDRSSNSESTTPIISIETKAACDNTPSIDTDPPEYRSSDHATPNIMPDKSSKNVTADSILDDLPLPDLTHQSPTDTSDVSKDIPHIHSRQTNSSLGGMDDSNVLTTTKSKKRSLEDNETEIEVSRDTWNNKNMRSLEPPRSKKRINLIAAIKGVKSIKPVRTTLRYDEAITYNKDNKEKDRYVEAYHKEISQLLKMNTWDTNKYYDRNDIDPKKVINSMFIFNKKRDGTHKARFVARGDIQHPDTYDSDMQSNTVHHYALMTSLSIALDNDYYITQLDISSAYLYADIKEELYIRPPPHLGLNDKLLRLRKSLYGLKQSGANWYETIKSYLINCCDMQEVRGWSCVFKNSQVTICLFVDDMILFSKDLNANKKIITTLKKQYDTKIINLGEGDNEIQYDILGLEIKYQRSKYMKLGMEKSLTEKLPKLNVPLNPKGKKLRAPGQPGHYIDQDELEIDEDEYKEKVHEMQKLIGLASYVGYKFRFDLLYYINTLAQHILFPSRQVLDMTYELIQFMWDTRDKQLIWHKNKPTKPDNKLVAISDASYGNQPYYKSQIGNIFLLNGKVIGGKSTKASLTCTSTTEAEIHAVSEAIPLLNNLSHLVQELNKKPIIKGLLTDSRSTISIIKSTNEEKFRNRFFGTKAMRLRDEVSGNNLYVYYIETNKNIADVMTKPLPIKTFKLLTNKWIH');
INSERT INTO proteininfo VALUES ('7839200', 'NP_058186.1','TyA Gag protein; the main structural constituent of virus-like particles (VLPs); Yor192c-ap [Saccharomyces cerevisiae]','MESQQLSQNSPTFHGSAYASVTSKEVPSNQDPLAVSASNLPEFDRDSTKVNSQQETTPGTSAVPENHHHVSPQPASVPPPQNGQYQQHGMMTPNKAMASNWAHYQQPSMMTCSHYQTSPAYYQPDPHYPLPQYIPPLSTSSPDPIGSQDQHSEVPQAKTKVRNNVLPPHTLTSEENFSTWVKFYIRFLKNSNLGDIIPNDQGEIKRQMTYEEHAYIYNTFQAFAPFHLLPTWVKQILEINYSDILTVLCKSVSKMQTNNQELKDWIALANLEYNGSTSADTFEITVSTIIQRLKENNINVSDRLACQLILKGLSGDFKYLRNQYRTKTNMKLSQLFAEIQLIYDENKIMNLNKPSQYKQHSEYKNVSRTSPNTTNTKVTTRNYHRTNSSKPRAAKAHNIATSSKFSRVNNDHINESTVSSQYLSDDNELSLRPATERI');
INSERT INTO proteininfo VALUES ('7839199', 'NP_058183.1','TyB Gag-Pol protein; proteolytically processed to make the Gag, RT, PR, and IN proteins that are required for retrotransposition; Yor142w-bp [Saccharomyces cerevisiae]','MESQQLSNYPHISHGSACASVTSKEVHTNQDPLDVSASKIQEYDKASTKANSQQTTTPASSAVPENPHHASPQPASVPPPQNGPYPQQCMMTQNQANPSGWSFYGHPSMIPYTPYQMSPMYFPPGPQSQFPQYPSSVGTPLSTPSPESGNTFTDSSSADSDMTSTKKYVRPPPMLTSPNDFPNWVKTYIKFLQNSNLGGIIPTVNGKPVRPITDDELTFLYNTFQIFAPSQFLPTWVKDILSVDYTDIMKILSKSIEKMQSDTQEANDIVTLANLQYNGSTPADAFETKVTNIIDRLNNNGIHINNKVACQLIMRGLSGEYKFLRYTRHRHLNMTVAELFLDIHAIYEEQQGSRNSKPNYRRNPSDEKNDSRSYTNTTKPKVIARNPQKTNNSKSKTARAHNVSTSNNSPSTDNDSISKSTTEPIQLNNKHDLHLGQKLTESTVNHTNHSDDELPGHLLLDSGASRTLIRSAHHIHSASSNPDINVVDAQKRNIPINAIGDLQFHFQDNTKTSIKVLHTPNIAYDLLSLNELAAVDITACFTKNVLERSDGTVLAPIVKYGDFYWVSKKYLLPSNISVPTINNVHTSESTRKYPYPFIHRMLAHANAQTIRYSLKNNTITYFNESDVDWSSAIDYQCPDCLIGKSTKHRHIKGSRLKYQNSYEPFQYLHTDIFGPVHNLPKSAPSYFISFTDETTKFRWVYPLHDRREDSILDVFTTILAFIKNQFQASVLVIQMDRGSEYTNRTLHKFLEKNGITPCYTTTADSRAHGVAERLNRTLLDDCRTQLQCSGLPNHLWFSAIEFSTIVRNSLASPKSKKSARQHAGLAGLDISTLLPFGQPVIVNDHNPNSKIHPRGIPGYALHPSRNSYGYIIYLPSLKKTVDTTNYVILQGKESRLDQFNYDALTFDEDLNRLTASYHSFIASNEIQESNDLNIESDHDFQSDIELHPEQPRNVLSKAVSPTDSTPPSTHTEDSKRVSKTNIRAPREVDPNISESNILPSKKRSSTPQISNIESTGSGGMHKLNVPLLAPMSQSNTHESSHASKSKDFRHSDSYSENETNHTNVPISSTGGTNNKTVPQISDQETEKRIIHRSPSIDASPPENNSSHNIVPIKTPTTVSEQNTEESIIADLPLPDLPPESPTEFPDPFKELPPINSRQTNSSLGGIGDSNAYTTINSKKRSLEDNETEIKVSRDTWNTKNMRSLEPPRSKKRIHLIAAVKAVKSIKPIRTTLRYDEAITYNKDIKEKEKYIEAYHKEVNQLLKMKTWDTDKYYDRKEIDPKRVINSMFIFNRKRDGTHKARFVARGDIQHPDTYDSGMQSNTVHHYALMTSLSLALDNNYYITQLDISSAYLYADIKEELYIRPPPHLGMNDKLIRLKKSLYGLKQSGANWYETIKSYLIKQCGMEEVRGWSCVFKNSQVTICLFVDDMILFSKDLNSNKRIIAKLKMQYDTKIINLGESDDEIQYDILGLEIKYQRGKYMKLGMENSLTEKIPKLNVPLNPNGRKLGAPGQPGLYINQQELELEEDDYKMKVHEMQKLIGLASYVGYKFRFDLLYYINTLAQHILFPSKQVLDMTYELIQFIWNTRDKQLIWHKSKPVKPTNKLVVISDASYGNQPYYKSQIGNIYLLNGKVIGGKSTKASLTCTSTTEAEIHAISESVPLLNNLSYLIQELDKKPITKGLLTDSKSTISIIISNNEEKFRNRFFGTKAMRLRDEVSGNHLHVCYIETKKNIADVMTKPLPIKTFKLLTNKWIH');
INSERT INTO proteininfo VALUES ('7839198', 'NP_058184.1','TyA Gag protein; the main structural constituent of virus-like particles (VLPs); Yor142w-ap [Saccharomyces cerevisiae]','MESQQLSNYPHISHGSACASVTSKEVHTNQDPLDVSASKIQEYDKASTKANSQQTTTPASSAVPENPHHASPQPASVPPPQNGPYPQQCMMTQNQANPSGWSFYGHPSMIPYTPYQMSPMYFPPGPQSQFPQYPSSVGTPLSTPSPESGNTFTDSSSADSDMTSTKKYVRPPPMLTSPNDFPNWVKTYIKFLQNSNLGGIIPTVNGKPVRPITDDELTFLYNTFQIFAPSQFLPTWVKDILSVDYTDIMKILSKSIEKMQSDTQEANDIVTLANLQYNGSTPADAFETKVTNIIDRLNNNGIHINNKVACQLIMRGLSGEYKFLRYTRHRHLNMTVAELFLDIHAIYEEQQGSRNSKPNYRRNPSDEKNDSRSYTNTTKPKVIARNPQKTNNSKSKTARAHNVSTSNNSPSTDNDSISKSTTEPIQLNNKHDLHLRPETY');
INSERT INTO proteininfo VALUES ('7839197', 'NP_058181.1','TyB Gag-Pol protein; proteolytically processed to make the Gag, RT, PR, and IN proteins that are required for retrotransposition; Yol103w-bp [Saccharomyces cerevisiae]','MESQQLSNYPQISHGSACASVTSKEVHTNQDPLDVSASKTEECEKASTKANSQQTTTPASSAVPENPHHASPQPASVPPPQNGPYPQQCMMTQNQANPSGWSFYGHPSMIPYTPYQMSPMYFPPGPQSQFPQYPSSVGTPLSTPSPESGNTFTDSSSADSDMTSTKKYVRPPPMLTSPNDFPNWVKTYIKFLQNSNLGGIIPTVNGKPVRQITDDELTFLYNTFQIFAPSQFLPTWVKDILSVDYTDIMKILSKSIEKMQSDTQEANDIVTLANLQYNGSTPADAFETKVTNIINRLNNNGIHINNKVACQLIMRGLSGEYKFLRYTRHRHLNMTVAELFLDIHAIYEEQQGSRNSKPNYRRNLSDEKNDSRSYTNTTKPKVIARNPQKTNNSKSKTARAHNVSTSNNSPSTDNDSISKSTTEPIQLNNKHDLHLGQELTESTVNHTNHSDDELPGHLLLDSGASRTLIRSAHHIHSASSNPDINVVDAQKRNIPINAIGDLQFHFQDNTKTSIKVLHTPNIAYDLLSLNELAAVDITACFTKNVLERSDGTVLAPIVKYGDFYWVSKKYLLPSNISVPTINNVHTSESTRKYPYPFIHRMLAHANAQTIRYSLKNNTITYFNESDVDWSSAIDYQCPDCLIGKSTKHRHIKGSRLKYQNSYEPFQYLHTDIFGPVHNLPKSAPSYFISFTDETTKFRWVYPLHDRREDSILDVFTTILAFIKNQFQASVLVIQMDRGSEYTNRTLHKFLEKNGITPCYTTTADSRAHGVAERLNRTLLDDCRTQLQCSGLPNHLWFSAIEFSTIVRNSLASPKSKKSARQHAGLAGLDISTLLPFGQPVIVNDHNPNSKIHPRGIPGYALHPSRNSYGYIIYLPSLKKTVDTTNYVILQGKESRLDQFNYDALTFDEDLNRLTASYQSFIASNEIQQSDDLNIESDHDFQSDIELHPEQPRNVLSKAVSPTDSTPPSTHTEDSKRVSKTNIRAPREVDPNISESNILPSKKRSSTPQISNIESTGSGGMHKLNVPLLAPMSQSNTHESSHASKSKDFRHSDSYSENETNHTNVPISSTGGTNNKTVPQISDQETEKRIIHRSPSIDASPPENNSSHNIVPIKTPTTVSEQNTEESIIADLPLPDLPPESPTEFPDPFKELPPINSHQTNSSLGGIGDSNAYTTINSKKRSLEDNETEIKVSRDTWNTKNMRSLEPPRSKKRIHLIAAVKAVKSIKPIRTTLRYDEAITYNKDIKEKEKYIEAYHKEVNQLLKMKTWDTDEYYDRKEIDPKRVINSMFIFNKKRDGTHKARFVARGDIQHPDTYDSGMQSNTVHHYALMTSLSLALDNNYYITQLDISSAYLYADIKEELYIRPPPHLGMNDKLIRLKKSLYGLKQSGANWYETIKSYLIKQCGMEEVRGWSCVFKNSQVTICLFVDDMILFSKDLNANKKIITTLKKQYDTKIINLGESDNEIQYDILGLEIKYQRGKYMKLGMENSLTEKIPKLNVPLNPKGRKLSAPGQPGLYIDQDELEIDEDEYKEKVHEMQKLIGLASYVGYKFRFDLLYYINTLAQHILFPSRQVLDMTYELIQFMWDTRDKQLIWHKNKPTEPDNKLVAISDASYGNQPYYKSQIGNIYLLNGKVIGGKSTKASLTCTSTTEAEIHAISESVPLLNNLSYLIQELNKKPIIKGLLTDSRSTISIIKSTNEEKFRNRFFGTKAMRLRDEVSGNNLYVYYIETKKNIADVMTKPLPIKTFKLLTNKWIH');
INSERT INTO proteininfo VALUES ('7839196', 'NP_058182.1','TyA Gag protein; the main structural constituent of virus-like particles (VLPs); Yol103w-ap [Saccharomyces cerevisiae]','MESQQLSNYPQISHGSACASVTSKEVHTNQDPLDVSASKTEECEKASTKANSQQTTTPASSAVPENPHHASPQPASVPPPQNGPYPQQCMMTQNQANPSGWSFYGHPSMIPYTPYQMSPMYFPPGPQSQFPQYPSSVGTPLSTPSPESGNTFTDSSSADSDMTSTKKYVRPPPMLTSPNDFPNWVKTYIKFLQNSNLGGIIPTVNGKPVRQITDDELTFLYNTFQIFAPSQFLPTWVKDILSVDYTDIMKILSKSIEKMQSDTQEANDIVTLANLQYNGSTPADAFETKVTNIINRLNNNGIHINNKVACQLIMRGLSGEYKFLRYTRHRHLNMTVAELFLDIHAIYEEQQGSRNSKPNYRRNLSDEKNDSRSYTNTTKPKVIARNPQKTNNSKSKTARAHNVSTSNNSPSTDNDSISKSTTEPIQLNNKHDLHLRPGTY');
INSERT INTO proteininfo VALUES ('7839195', 'NP_058180.1','TyA Gag protein; the main structural constituent of virus-like particles (VLPs); Ynl054w-ap [Saccharomyces cerevisiae]','MESQQLSQHSPISHGSACASVTSKEVHTNQDPLDVSASKIQEYDKASTKANSQQTTTPASSAVPENPHHASPQTAQSHSPQNGPYPQQCMMTQNQANPSDWSFYGRPSMIPYTPYQMSPMYFPPGPHSQFPQYPSSVGTPLSTPSPESGNTFTDSSSADSDMTSTKKYVRPPPMLTSPNDFLNWVKTYIKFLQNSNLGGIIPTVNGKPVRQITDDELTFLYNTFQIFAPSQFLPTWVKDILSVDYTDIMKILSKSIEKMQSDTQEANDIVTLANLQYNGSTPADAFETKVTNIIDRLNNNGIHINNKVACQLIMRGLSGEYKFLRYTRHRHLNMTVAELFLDIHAIYEEQQGSRNSKPNYRRNPSDEKNDSRSYTNTTKPKVIARNPQKTNNSKSKTARAHNVSTSNNSPSTDNDSISKSTTEPIQLNNKHDLHLRPETY');
INSERT INTO proteininfo VALUES ('7839194', 'NP_058178.1','TyB Gag-Pol protein; proteolytically processed to make the Gag, RT, PR, and IN proteins that are required for retrotransposition; Ynl284c-bp [Saccharomyces cerevisiae]','MESQQLSQHSPISHGSACASVTSKEVHTNQDPLDVSASKIQEYDKASTKANSQQTTTPASSAVPENPHHASPQTAQSHSPQNGPYQQQCMMTQNQANPSGWSFYGRPSMIPYTPYQMSPMYFPPGPHSQFPQYPSSVGTPLSTPSPESGNTFTDSSSADSDMTSTKKYVRPPPMLTSPNDFLNWVKTYIKFLQNSNLGDIIPTATRKAVRQMTDDELTFLCHTFQLFAPSQFLPTWVKDILSADYTDIMKILSKSINKMQSDTQEVNDITTLATLHYNGSTPADAFEAEVTNILDRLNNNGIPINNKVACQFIMRGLSGEYKFLRYARHRYIHMTVADLFSDIHSMYEEQQESKRNKSTYRRNPSDEKKDSRTYTNTTKPKSITRNSQKPNNSQSRTARAHNVSTSNNSSGPDNDLIRGSTTEPIQLKNKHDLHLGQELTESTVNHTNHSDDELPGHLLLDSGASRTLIRSAHHIHSASSNPGINVVDAQKRNIPINAIGDLQFHFQDNTKTSIKVLHTPNIAYDLLSLNELAAVDITACFTKNVLERSDGTVLAPIVKYGDFYWVSKKYLLPSNISVPTINNVHTSESTRKYPYPFIHRMLAHANAQTIRYSLKNNTITYFNESDVDWSSAIDYQCPDCLIGKSTKHRHIKGSRLKYQNSYEPFQYLHTDIFGPVHNLPKSAPSYFISFTDETTKFRWVYPLHDRREDSILDVFTTILAFIKNQFQASVLVIQMDRGSEYTNRTLHKFLEKNGITPCYTTTADSRAHGVAERLNRTLLDDCRTQLQCSGLPNHLWFSAIEFSTIVRNSLASPKSKKSARQHAGLAGLDISTLLPFGQPVIVNDHNPNSKIHPRGIPGYALHPSRNSYGYIIYLPSLKKTVDTTNYVILQGKESRLDQFNYDALTFDEDLNRLTASYQSFIASNEIQQSDDLNIESDHDFQSDIELHPEQPRNVLSKAVSPTDSTPPSTHTEDSKRVSKTNIRAPREVDPNISKSNILPSKKRSSTPQISDIESTGSGGMHRLDVPLLAPMSQYNTHESSHTSKSKDFRHSDSYSDNETNHTNVPISSTGGTNNKTVPQTSEQETEKRIIHRSPSIDTSSSESNSLHHVVPIKTSDTCPKENTEESIIADLPLPDLPPEPPTKLSDSFKELPPINSRQTNSSLGGIGDSNAYTTINSKKRSLEDNETEIKVSRDTWNTKNMRSLEPPRSKKRIHLIAAVKAVKSIKPIRTTLRYDEAITYNKDIKEKEKYIEAYHKEVNQLLKMKTWDTDRYYDRKEIDPKRVINSMFIFNRKRDGTHKARFVARGDIQHPDTYDSGMQSNTVHHYALMTSLSLALDNNYYITQLDISSAYLYADIKEELYIRPPPHLGMNDKLIRLKKSLYGLKQSGANWYETIKSYLIQQCGMEEVRGWSCVFKNSQVTICLFVDDMVLFSKNLNSNKRIIEKLKMQYDTKIINLGESDEEIQYDILGLEIKYQRGKYMKLGMENSLTEKIPKLNVPLNPKGRKLSAPGQPGLYIDQQELELEEDDYKMKVHEMQKLIGLASYVGYKFRFDLLYYINTLAQHILFPSKQVLDMTYELIQFIWNTRDKQLIWHKSKPVKPTNKLVVISDASYGNQPYYKSQIGNIYLLNGKVIGGKSTKASLTCTSTTEAEIHAISESVPLLNNLSYLIQELDKKPITKGLLTDSKSTISIIISNNEEKFRNRFFGTKAMRLRDEVSGNHLHVCYIETKKNIADVMTKPLPIKTFKLLTNKWIH');
INSERT INTO proteininfo VALUES ('7839193', 'NP_058179.1','TyA Gag protein; the main structural constituent of virus-like particles (VLPs); Ynl284c-ap [Saccharomyces cerevisiae]','MESQQLSQHSPISHGSACASVTSKEVHTNQDPLDVSASKIQEYDKASTKANSQQTTTPASSAVPENPHHASPQTAQSHSPQNGPYQQQCMMTQNQANPSGWSFYGRPSMIPYTPYQMSPMYFPPGPHSQFPQYPSSVGTPLSTPSPESGNTFTDSSSADSDMTSTKKYVRPPPMLTSPNDFLNWVKTYIKFLQNSNLGDIIPTATRKAVRQMTDDELTFLCHTFQLFAPSQFLPTWVKDILSADYTDIMKILSKSINKMQSDTQEVNDITTLATLHYNGSTPADAFEAEVTNILDRLNNNGIPINNKVACQFIMRGLSGEYKFLRYARHRYIHMTVADLFSDIHSMYEEQQESKRNKSTYRRNPSDEKKDSRTYTNTTKPKSITRNSQKPNNSQSRTARAHNVSTSNNSSGPDNDLIRGSTTEPIQLKNKHDLHLRPGTY');
INSERT INTO proteininfo VALUES ('7839191', 'NP_058176.1','TyA Gag protein; the main structural constituent of virus-like particles (VLPs); Yml045w-ap [Saccharomyces cerevisiae]','MESQQLSNYPNISHGSACASVTSKEVHTNQDPLDVSASKIQEYDKASTKANSQQTTTPASSAVPENLHHASPQPASVPPPQNGPYPQQCMMTQNQANPSGWSFYGHPSMIPYTPYQMSPMYFPPGPQSQFPQYPSSVGTPLSTPSPESGNTFTDSSSADSDMTSTKKYVRPPPMLTSPNDFPNWVKTYIKFLQNSNLGGIIPTVNGKPVRQITDDELTFLYNTFQIFAPSQFLPTWVKDILSVDYTDIMKILSKSIEKMQSDTQEANDIVTLANLQYNGSTPADAFETKVTNIIDRLNNNGIHINNKVACQLIMRGLSGEYKFLRYTRHRHLNMTVAELFLDIHAIYEEQQGSRNSKPNYRRNPSDEKNDSRSYTNTTKPKVIARNPQKTNNSKSKTARAHNVSTSNNSPSTDNDSISKSTTEPIQLNNKHDLHLRPETY');
INSERT INTO proteininfo VALUES ('7839190', 'NP_058174.1','TyB Gag-Pol protein; proteolytically processed to make the Gag, RT, PR, and IN proteins that are required for retrotransposition; Ylr410w-bp [Saccharomyces cerevisiae]','MESQQLHQNPHSLHGSAYASVTSKEVPSNQDPLAVSASNLPEFDRDSTKVNSQQETTPGTSAVPENHHHVSPQPASVPPPQNGQYQQHGMMTPNKAMASNWAHYQQPSMMTCSHYQTSPAYYQPDPHYPLPQYIPPLSTSSPDPIDLKNQHSEIPQAKTKVGNNVLPPHTLTSEENFSTWVKFYIRFLKNSNLGDIIPNDQGEIKRQMTYEEHAYIYNTFQAFAPFHLLPTWVKQILEINYADILTVLCKSVSKMQTNNQELKDWIALANLEYDGSTSADTFEITVSTIIQRLKENNINVSDRLACQLILKGLSGDFKYLRNQYRTKTNMKLSQLFAEIQLIYDENKIMNLNKPSQYKQHSEYKNVSRTSPNTTNTKVTTRNYHRTNSSKPRAAKAHNIATSSKFSRVNNDHINESTVSSQYLSDDNELSLGQQQKESKPTHTIDSNDELPDHLLIDSGASQTLVRSAHYLHHATPNSEINIVDAQKQDIPINAIGNLHFNFQNGTKTSIKALHTPNIAYDLLSLSELANQNITACFTRNTLERSDGTVLAPIVKHGDFYWLSKKYLIPSHISKLTINNVNKSKSVNKYPYPLIHRMLGHANFRSIQKSLKKNAVTYLKESDIEWSNASTYQCPDCLIGKSTKHRHVKGSRLKYQESYEPFQYLHTDIFGPVHHLPKSAPSYFISFTDEKTRFQWVYPLHDRREESILNVFTSILAFIKNQFNARVLVIQMDRGSEYTNKTLHKFFTNRGITACYTTTADSRAHGVAERLNRTLLNDCRTLLHCSGLPNHLWFSAVEFSTIIRNSLVSPKNDKSARQHAGLAGLDITTILPFGQPVIVNNHNPDSKIHPRGIPGYALHPSRNSYGYIIYLPSLKKTVDTTNYVILQDNQSKLDQFNYDTLTFDDDLNRLTAHNQSFIEQNETEQSYDQNTESDHDYQSEIEINSDPLVNDFSSQSMNPLQLDHEPVQKVRAPKEVDADISEYNILPSPVRSRTPHIINKESTEMGGTIESDTTSPRHSSTFTARNQKRPGSPNDMIDLTSQDRVNYGLENIKTTRLGGTEEPYIQRNSDTNIKYRTTNSTPSIDDRSSNSESTTPIISIETKAVCDNTPSIDTDPPEYRSSDHATPNIMPDKSSKNVTADSILDDLPLPDLTHKSPTDTSDVSKDIPHIHSRQTNSSLGGMDDSNVLTTTKSKKRSLEDNETEIEVSRDTWNNKNMRSLEPPRSKKRINLIAAIKGVKSIKPVRTTLRYDEAITYNKDNKEKDRYVEAYHKEISQLLKMNTWDTNKYYDRNDIDPKKVINSMFIFNKKRDGTHKARFVARGDIQHPDTYDSDMQSNTVHHYALMTSLSIALDNDYYITQLDISSAYLYADIKEELYIRPPPHLGLNDKLLRLRKSLYGLKQSGANWYETIKSYLINCCDMQEVRGWSCVFKNSQVTICLFVDDMILFSKDLNANKKIITTLKKQYDTKIINLGERDNEIQYDILGLEIKYQRSKYMKLGMEKSLTEKLPKLNVPLNPKGKKLRAPGQPGHYIDQDELEIDEDEYKEKVHEMQKLIGLASYVGYKFRFDLLYYINTLAQHILFPSRQVLDMTYELIQFMWDTRDKQLIWHKNKPTKPDNKLVAISDASYGNQPYYKSQIGNIFLLNGKVIGGKSTKASLTCTSTTEAEIHAVSEAIPLLNNLSHLVQELNKKPIIKGLLTDSRSTISIIKSTNEEKFRNRFFGTKAMRLRDEVSGNNLYVYYIETKKNIADVMTKPLPIKTFKLLTNKWIH');
INSERT INTO proteininfo VALUES ('7839189', 'NP_058175.1','TyA Gag protein; the main structural constituent of virus-like particles (VLPs); Ylr410w-ap [Saccharomyces cerevisiae]','MESQQLHQNPHSLHGSAYASVTSKEVPSNQDPLAVSASNLPEFDRDSTKVNSQQETTPGTSAVPENHHHVSPQPASVPPPQNGQYQQHGMMTPNKAMASNWAHYQQPSMMTCSHYQTSPAYYQPDPHYPLPQYIPPLSTSSPDPIDLKNQHSEIPQAKTKVGNNVLPPHTLTSEENFSTWVKFYIRFLKNSNLGDIIPNDQGEIKRQMTYEEHAYIYNTFQAFAPFHLLPTWVKQILEINYADILTVLCKSVSKMQTNNQELKDWIALANLEYDGSTSADTFEITVSTIIQRLKENNINVSDRLACQLILKGLSGDFKYLRNQYRTKTNMKLSQLFAEIQLIYDENKIMNLNKPSQYKQHSEYKNVSRTSPNTTNTKVTTRNYHRTNSSKPRAAKAHNIATSSKFSRVNNDHINESTVSSQYLSDDNELSLRPATERI');
INSERT INTO proteininfo VALUES ('7839188', 'NP_058173.1','TyA Gag protein; the main structural constituent of virus-like particles (VLPs); Ylr256w-ap [Saccharomyces cerevisiae]','MESQQLSQHPHISHGSACASVTSKEVHTNQDPLDVSASKTEECEKASTKANSQQTTTPASSAVPENPHHASPQPASVPPPQNGPYPQQCMMTQNQANPSGWSFYGHPSMIPYTPYQMSPMYFPPGPQSQFPQYPSSVGTPLSTPSPESGNTFTDSSSADSDMTSTKKYVRPPPMLTSPNDFPNWVKTYIKFLQNSNLGGIIPTVNGKPVRQITDDELTFLYNTFQIFAPSQFLPTWVKDILSVDYTDIMKILSKSIEKMQSDTQEANDIVTLANLQYNGSTPADAFETKVTNIIDRLNNNGIHINNKVACQLIMRGLSGEYKFLRYTRHRHLNMTVAELFLDIHAIYEEQQGSRNSKPNYRRNLSDEKNDSRSYTNTTKPKVIARNPQKTNNSKSKTARAHNVSTSNNSPSTDNDSISKSTTEPIQLNNKHDLHLRPGTY');
INSERT INTO proteininfo VALUES ('7839187', 'NP_058171.1','TyB Gag-Pol protein; proteolytically processed to make the Gag, RT, PR, and IN proteins that are required for retrotransposition; Ylr227w-bp [Saccharomyces cerevisiae]','MESQQLSQHSHISHGSACASVTSKEVHTNQDPLDVSASKTEECEKASTKANSQQTTTPASSAVPENPHHASPQPASVPPPQNGPYPQQCMMTQNQANPSGWSFYGHPSMIPYTPYQMSPMYFPPGPQSQFPQYPSSVGTPLSTPSPESGNTFTDSSSADSDMTSTKKYVRPPPMLTSPNDFPNWVKTYIKFLQNSNLGGIIPTVNGKPVRQITDDELTFLYNTFQIFAPSQFLPTWVKDILSVDYTDIMKILSKSIEKMQSDTQEANDIVTLANLQYNGSTPADAFETKVTNIIDRLNNNGIHINNKVACQLIMRGLSGEYKFLRYTRHRHLNMTVAELFLDIHAIYEEQQGSRNSKPNYRRNLSDEKNDSRSYTNTTKPKVIARNPQKTNNSKSKTARAHNVSTSNNSPSTDNDSISKSTTEPIQLNNKHDLHLGQELTESTVNHTNHSDDELPGHLLLDSGASRTLIRSAHHIHSASSNPDINVVDAQKRNIPINAIGDLQFHFQDNTKTSIKVLHTPNIAYDLLSLNELAAVDITACFTKNVLERSDGTVLAPIVQYGDFYWVSKRYLLPSNISVPTINNVHTSESTRKYPYPFIHRMLAHANAQTIRYSLKNNTITYFNESDVDWSSAIDYQCPDCLIGKSTKHRHIKGSRLKYQNSYEPFQYLHTDIFGPVHNLPKSAPSYFISFTDETTKFRWVYPLHDRREDSILDVFTTILAFIKNQFQASVLVIQMDRGSEYTNRTLHKFLEKNGITPCYTTTADSRAHGVAERLNRTLLDDCRTQLQCSGLPNHLWFSAIEFSTIVRNSLASPKSKKSASQHAGLAGLDISTLLPFGQPVIVNDHNPNSKIHPRGIPGYALHPSRNSYGYIIYLPSLKKTVDTTNYVILQGKESRLDQFNYDALTFDEDLNRLTASYHSFIASNEIQESNDLNIESDHDFQSDIELHPEQPRNVLSKAVSPTDSTPPSTHTEDSKPISEINLRAPREVDPNISESNILPSKKRSSTPQISNIESTGSGGMHKLNVPLLAPMSQSNTHESSHASKSKDFRHSDSYSNNETNHTNVPISSTGGTNNKTVPQISDQETEKRIIHRSPSIDASPPENNSSHNIVPIKTPTTVSEQNTEESIIADLPLPDPPPEPPTELSDSFKELPPINSRQTNSSLGGIGDSNAYTTINSKKRSLEDNETEIKVSRDTWNTKNMRSLEPPRSKKRIHLIAAAKAVKSIKPIRTTLRYDEAITYNKDIKEKEKYIEAYHKEVNQLLKMNTWDTDKYYDRKEIDPKRVINSMFIFNKKRDGTHKARFVARGDIQHPDTYDTGMQSNTVHHYALMTSLSLALDNNYYITQLDISSAYLYADIKEELYIRPPPHLGMNDKLIRLKKSHYGLKQSGANWYETIKSYLIKQCGMEEVRGWSCVFKNSQVTICLFVDDMILFSKDLNANKKIITTLKKQYDTKIINLGESDNEIQYDILGLEIKYQRGKYMKLGMENSLTEKIPKLNVPLNPKGRKLSAPGQPGLYIDQDELEIDEDEYKEKVHEMQKLIGLASYVGYKFRFDLLYYINTLAQHILFPSRQVLDMTYELIQFMWDTRDKQLIWHKNKPTEPDNKLVAISDASYGNQPYYKSQIGNIFLLNGKVIGGKSTKASLTCTSTTEAEIHAVSEAIPLLNNLSHLVQELNKKPIIKGLLTDSRSTISIIKSTNEEKFRNRFFGTKAMRLRDEVSGNNLYVYYIETKKNIADVMTKPLPIKTFKLLTNKWIH');
INSERT INTO proteininfo VALUES ('7839186', 'NP_058172.1','TyA Gag protein; the main structural constituent of virus-like particles (VLPs); Ylr227w-ap [Saccharomyces cerevisiae]','MESQQLSQHSHISHGSACASVTSKEVHTNQDPLDVSASKTEECEKASTKANSQQTTTPASSAVPENPHHASPQPASVPPPQNGPYPQQCMMTQNQANPSGWSFYGHPSMIPYTPYQMSPMYFPPGPQSQFPQYPSSVGTPLSTPSPESGNTFTDSSSADSDMTSTKKYVRPPPMLTSPNDFPNWVKTYIKFLQNSNLGGIIPTVNGKPVRQITDDELTFLYNTFQIFAPSQFLPTWVKDILSVDYTDIMKILSKSIEKMQSDTQEANDIVTLANLQYNGSTPADAFETKVTNIIDRLNNNGIHINNKVACQLIMRGLSGEYKFLRYTRHRHLNMTVAELFLDIHAIYEEQQGSRNSKPNYRRNLSDEKNDSRSYTNTTKPKVIARNPQKTNNSKSKTARAHNVSTSNNSPSTDNDSISKSTTEPIQLNNKHDLHLRPGTY');
INSERT INTO proteininfo VALUES ('7839185', 'NP_058169.1','TyB Gag-Pol protein; proteolytically processed to make the Gag, RT, PR, and IN proteins that are required for retrotransposition; Ylr157c-bp [Saccharomyces cerevisiae]','MESQQLSQHSPISHGSACASVTSKEVHTNQDPLDVSASKTEECEKASTKANSQQTTTPASSAVPENPHHASPQPASVPPPQNGPYPQQCMMTQNQANPSGWSFYGHPSMIPYTPYQMSPMYFPPGPQSQFPQYPSSVGTPLSTPSPESGNTFTDSSSADSDMTSTKKYVRPPPMLTSPNDFPNWVKTYIKFLQNSNLGGIIPTVNGKPVRQITDDELTFLYNTFQIFAPSQFLPTWVKDILSVDYTDIMKILSKSIEKMQSDTQEANDIVTLANLQYNGSTPADAFETKVTNIIDRLNNNGIHINNKVACQLIMRGLSGEYKFLRYTRHRHLNMTVAELFLDIHAIYEEQQGSRNSKPNYRRNLSDEKNDSRSYTNTTKPKVIARNPQKTNNSKSKTARAHNVSTSNNSPSTDNDSISKSTTEPIQLNNKHDLHLGQELTESTVNHTNHSDDELPGHLLLDSGASRTLIRSAHHIHSASSNPDINVVDAQKRNIPINAIGDLQFHFQDNTKTSIKVLHTPNIAYDLLSLNELAAVDITACFTKNVLERSDGTVLAPIVKYGDFYWVSKKYLLPSNISVPTINNVHTSESTRKYPYPFIHRMLAHANAPTIRYSLKNNTITYFNESDVDWSSAIDYQCPDCLIGKSTKHRHIKGSRLKYQNSYEPFQYLHTDIFGPVHNLPNSAPSYFISFTDETTKFRWVYPLHDRREDSILDVFTTILAFIKNQFQASVLVIQMDRGSEYTNRTLHKFLEKNGITPCYTTTADSRAHGVAERLNRTLLDDCRTQLQCSGLPNHLWFSAIEFSTIVRNSLASPKSKKSARQHAGLAGLDISTLLPFGQPVIVNDHNPNSKIHPRGIPGYALHPSRNSYGYIIYLPSLKKTVDTTNYVILQGKESRLDQFNYDALTFDEDLNRLTASYHSFIASNEIQESNDLNIESDHDFQSDIELHPEQPRNVLSKAVSPTDSTPPSTHTEDSKRVSKTNIRAPREVDPNISESNILPSKKRSSTPQISNIESTGSGGMHKLNVPLLAPMSQSNTHESSHASKSKDFRHSDSYSENETNHTNVPISSTGGTNNKTVPQISDQETEKRIIHRSPSIDASPPENNSSHNIVPIKTPTTVSEQNTEESIIADLPLPDLPPESPTEFPDPFKELPPINSRQTNSSLGGIGDSNAYTTINSKKRSLEDNETEIKVSRDTWNTKNMRSLEPPRSKKRIHLIAAVKAVKSIKPIRTTLRYDEAITYNKDIKEKEKYIEAYHKEVNQLLKMKTWDTDEYYDRKEIDPKRVINSMFIFNKKRDGTHKARFVARGDIQHPDTYDSGMQSNTVHHYALMTSLSLALDNNYYITQLDISSAYLYADIKEELYIRPPPHLGMNDKLIRLKKSLYGLKQSGANWYETIKSYLIKQCGMEEVRGWSCVFKNSQVTICLFVDDMILFSKDLNANKKIITTLKKQYDTKIINLGESDNEIQYDILGLEIKYQRGKYMKLGMENSLTEKIPKLNVPLNPKGRKLSAPGQPGLYIDQDELEIDEDEYKEKVHEMQKLIGLASYVGYKFRFDLLYYINTLAQHILFPSRQVLDMTYELIQFMWDTRDKQLIWHKNKPTEPDNKLVAISDASYGNQPYYKSQIGNIYLLNGKVIGGKSTKASLTCTSTTEAEIHAISESVPLLNNLSYLIQELNKKPIIKGLLTDSRSTISIIKSTNEEKFRNRFFGTKAMRLRDEVSGNNLYVYYIETKKNIADVMTKPLPIKTFKLLTNKWIH');
INSERT INTO proteininfo VALUES ('7839184', 'NP_058170.1','TyA Gag protein; the main structural constituent of virus-like particles (VLPs); Ylr157c-ap [Saccharomyces cerevisiae]','MESQQLSQHSPISHGSACASVTSKEVHTNQDPLDVSASKTEECEKASTKANSQQTTTPASSAVPENPHHASPQPASVPPPQNGPYPQQCMMTQNQANPSGWSFYGHPSMIPYTPYQMSPMYFPPGPQSQFPQYPSSVGTPLSTPSPESGNTFTDSSSADSDMTSTKKYVRPPPMLTSPNDFPNWVKTYIKFLQNSNLGGIIPTVNGKPVRQITDDELTFLYNTFQIFAPSQFLPTWVKDILSVDYTDIMKILSKSIEKMQSDTQEANDIVTLANLQYNGSTPADAFETKVTNIIDRLNNNGIHINNKVACQLIMRGLSGEYKFLRYTRHRHLNMTVAELFLDIHAIYEEQQGSRNSKPNYRRNLSDEKNDSRSYTNTTKPKVIARNPQKTNNSKSKTARAHNVSTSNNSPSTDNDSISKSTTEPIQLNNKHDLHLRPGTY');
INSERT INTO proteininfo VALUES ('7839183', 'NP_058168.1','Mitochondrial intermembrane space protein mediating import and insertion of polytopic inner membrane proteins; Tim8p [Saccharomyces cerevisiae]','MSSLSTSDLASLDDTSKKEIATFLEGENSKQKVQMSIHQFTNICFKKCVESVNDSNLSSQEEQCLSNCVNRFLDTNIRIVNGLQNTR');
INSERT INTO proteininfo VALUES ('7839181', 'NP_058135.1','Constituent of small nucleolar ribonucleoprotein particles containing H/ACA-type snoRNAs, which are required for pseudouridylation and processing of pre-18S rRNA; Nop10p [Saccharomyces cerevisiae]','MHLMYTLGPDGKRIYTLKKVTESGEITKSAHPARFSPDDKYSRQRVTLKKRFGLVPGQ');
INSERT INTO proteininfo VALUES ('7839180', 'NP_058133.1','TyB Gag-Pol protein; proteolytically processed to make the Gag, RT, PR, and IN proteins that are required for retrotransposition; Yhl009w-bp [Saccharomyces cerevisiae]','MATPVRDETRNVIDDNISARIQSKVKTNDTVRQTPSSLRKVSIKDEQVKQYQRNLNRFKTILNGLKAEEEKLSETDDIQMLAEKLLKLGETIDKVENRIVDLVEKIQLLETNENNNILHEHIDATGTYYLFDTLTSTNKRFYPKDCVFDYRTNNVENIPILLNNFKKFIKKYQFDDVFENDIIEIDPRENEILCKIIKEGLGESLDIMNTNTTDIFRIIDGLKNKYRSLHGRDVRIRAWEKVLVDTTCRNSALLMNKLQKLVLMEKWIFSKCCQDCPNLKDYLQEAIMGTLHESLRNSVKQRLYNIPHNVGINHEEFLINTVIETVIDLSPIADDQIENSCMYCKSVFHCSINCKKKPNRELGLTRPISQKPIIYKVHRDNNNLSPVQNEQKSWNKTQKKSNKVYNSKKLVIIDTGSGVNITNDKTLLHNYEDSNRSTRFFGIGKNSSVSVKGYGYIKIKNGHNNTDNKCLLTYYVPEEESTIISCYDLAKKTKMVLSRKYTRLGNKIIKIKTKIVNGVIHVKMNELIERPSDDSKINAIKPTSSPGFKLNKRSITLEDAHKRMGHTGIQQIENSIKHNHYEESLDLIKEPNEFWCQTCKISKATKRNHYTGSMNNHSTDHEPGSSWCMDIFGPVSSSNADTKRYMLIMVDNNTRYCMTSTHFNKNAETILAQIRKNIQYVETQFDRKVREINSDRGTEFTNDQIEEYFISKGIHHILTSTQDHAANGRAERYIRTIVTDATTLLRQSNLRVKFWEYAVTSATNIRNCLEHKSTGKLPLKAISRQPVTVRLMSFLPFGEKGIIWNHNHKKLKPSGLPSIILCKDPNSYGYKFFIPSKNKIVTSDNYTIPNYTMDGRVRNTQNIYKSHQFSSHNDNEEDQIETVTNLCEALENYEDDNKPITRLEDLFTEEELSQIDSNAKYPSPSNNLEGDLDYVFSDVEESGDYDVESELSTTNTSISTDKNKILSNKDFNSELASTEISISEIDKKGLINTSHIDEDKYDEKVHRIPSIIQEKLVGSKNTIKINDENRISDRIRSKNIGSILNTGLSRCVDITDESITNKDESMHNAKPELIQEQFNKTNHETSFPKEGSIGTNVKFRNTDNEISLKTGDTSLPIKTLESINNHHSNDYSTNKVEKFEKENHHPPPIEDIVDMSDQTDMESNCQDGNNLKELKVTDKNVPTDNGTNVSPRLEQNIEASGSPVQTVNKSAFLNKEFSSLNMKRKRKRHDKNNSLTSYELERDKKRSKRNRVKLIPDNMETVSAQKIRAIYYNEAISKNPDLKEKHEYKQAYHKELQNLKDMKVFDVDVKYSRSEIPDNLIVPTNTIFTKKRNGIYKARIVCRGDTQSPDTYSVITTESLNHNHIKIFLMIANNRNMFMKTLDINHAFLYAKLEEEIYIPHPHDRRCVVKLNKALYGLKQSPKEWNDHLRQYLNGIGLKDNSYTPGLYQTEDKNLMIAVYVDDCVIAASNEQRLDEFINKLKSNFELKITGTLIDDVLDTDILGMDLVYNKRLGTIDLTLKSFINRMDKKYNEELKKIRKSSIPHMSTYKIDPKKDVLQMSEEEFRQGVLKLQQLLGELNYVRHKCRYDINFAVKKVARLVNYPHERVFYMIYKIIQYLVRYKDIGIHYDRDCNKDKKVIAITDASVGSEYDAQSRIGVILWYGMNIFNVYSNKSTNRCVSSTEAELHAIYEGYADSETLKVTLKELGEGDNNDIVMITDSKPAIQGLNRSYQQPKEKFTWIKTEIIKEKIKEKSIKLLKITGKGNIADLLTKPVSASDFKRFIQVLKNKITSQDILASTDY');
INSERT INTO proteininfo VALUES ('7839179', 'NP_058134.1','TyA Gag protein; the main structural constituent of virus-like particles (VLPs); Yhl009w-ap [Saccharomyces cerevisiae]','MATPVRDETRNVIDDNISARIQSKVKTNDTVRQTPSSLRKVSIKDEQVKQYQRNLNRFKTILNGLKAEEEKLSETDDIQMLAEKLLKLGETIDKVENRIVDLVEKIQLLETNENNNILHEHIDATGTYYLFDTLTSTNKRFYPKDCVFDYRTNNVENIPILLNNFKKFIKKYQFDDVFENDIIEIDPRENEILCKIIKEGLGESLDIMNTNTTDIFRIIDGLKNKYRSLHGRDVRIRAWEKVLVDTTCRNSALLMNKLQKLVLMEKWIFSKCCQDCPNLKDYLQEAIMGTLHESLRNSVKQRLYNIPHNVGINHEEFLINTVIETVIDLSPIADDQIENSCMYCKSVFHCSINCKKKPNRELRPDSTNFSKTYYLQGAQRQQQLKSSAKRTKVLEQDTKKVKQSVQQQKTGNY');
INSERT INTO proteininfo VALUES ('7839178', 'NP_058165.1','TyB Gag-Pol protein; proteolytically processed to make the Gag, RT, PR, and IN proteins that are required for retrotransposition; Ygr161c-dp [Saccharomyces cerevisiae]','MESQQLSNYPHISHGSACASVTSKEVHTNQDPLDVSASKIQEYDKASTKANSQQTTTPASSAVPENPHHASPQPASVPPPQNGPYPQQCMMTQNQANPSGWSFYGHPSMIPYTPYQMSPMYFPPGPQSQFPQYPSSVGTPLSTPSPESGNTFTDSSSADSDMTSTKKYVRPPPMLTSPNDFPNWVKTYIKFLQNSNLGGIIPTVNGKPVRQITDDELTFLYNTFQIFAPSQFLPTWVKDILSVDYTDIMKILSKSIEKMQSDTQEANDIVTLANLQYNGSTPADAFETKVTNIIDRLNNNGIHINNKVACQLIMRGLSGEYKFLRYTRHRHLNMTVAELFLDIHAIYEEQQGSRNSKPNYRRNPSDEKNDSRSYTNTTKPKVIARNPQKTNNSKSKTARAHNVSTSNNSPSTDNDSISKSTTEPIQLNNKHDLHLGQKLTESTVNHTNHSDDELPGHLLLDSGASRTLIRSAHHIHSASSNPDINVVDAQKRNIPINAIGDLQFHFQDNTKTSIKVLHTPNIAYDLLSLNELAAVDITACFTKNVLERSDGTVLAPIVKYGDFYWVSKKYLLPSNISVPTINNVHTSESTRKYPYPFIHRMLAHANAQTIRYSLKNNTITYFNESDVDWSSAIDYQCPDCLIGKSTKHRHIKGSRLKYQNSYEPFQYLHTDIFGPVHNLPKSAPSYFISFTDETTKFRWVYPLHDRREDSILDVFTTILAFIKNQFQASVLVIQMDRGSEYTNRTLHKFLEKNGITPCYTTTADSRAHGVAERLNRTLLDDCRTQLQCSGLPNHLWFSAIEFSTIVRNSLASPKSKKSARQHAGLAGLDISTLLPFGQPVIVNDHNPNSKIHPRGIPGYALHPSRNSYGYIIYLPSLKKTVDTTNYVILQGKESRLDQFNYDALTFDEDLNRLTASYHSFIASNEIQESNDLNIESDHDFQSDIELHPEQPRNVLSKAVSPTDSTPPSTHTEDSKRVSKTNIRAPREVDPNISESNILPSKKRSSTPQISNIESTGSGGMHKLNVPLLAPMSQSNTHESSYASKSKDFRHSDSYSDNETNHTNVPISSTGGTNNKTVPQTSEQETEKRIIHRSPSIDTSSSESNSLHHVVPIKTSDTCPKENTEESIIADLPLPDLPPEPPTELSDSFKELPPINSRQTNSSLGGIGDSNAYTTINSKKRSLEDNETEIKVSRDTWNTKNMRSLEPPRSKKRIHLIAAVKAVKSIKPIRTTLRYDEAITYNKDIKEKEKYIEAYHKEVNQLLKMNTWDTDKYYDRKEIDPKRVINSMFIFNRKRDGTHKARFVARGDIQHPDTYDSGMQSNTVHHYALMTSLSLALDNNYYITQLDISSAYLYADIKEELYIRPPPHLGMNDKLIRLKKSLYGLKQSGANWYETIKSYLIKQCGMEEVRGWSCVFKNSQVTICLFVDDMILFSKDLNSNKRIIAKLKMQYDTKIINLGESDDEIQYDILGLEIKYQRGKYMKLGMENSLTEKIPKLNVPLNPNGRKLGAPGQPGLYINQQELELEEDDYKMKVHEMQKLIGLASYVGYKFRFDLLYYINTLAQHILFPSKQVLDMTYELIQFIWNTRDKQLIWHKSKPVKPTNKLVVISDASYGNQPYYKSQIGNIYLLNGKVIGGKSTKASLTCTSTTEAEIHAISESVPLLNNLSYLIQELDKKPITKGLLTDSKSTISIIISNNEEKFRNRFFGTKAMRLRDEVSGNHLHVCYIETKKNIADVMTKPLPIKTFKLLTNKWIH');
INSERT INTO proteininfo VALUES ('7839177', 'NP_058166.1','TyA Gag protein; the main structural constituent of virus-like particles (VLPs); Ygr161c-cp [Saccharomyces cerevisiae]','MESQQLSNYPHISHGSACASVTSKEVHTNQDPLDVSASKIQEYDKASTKANSQQTTTPASSAVPENPHHASPQPASVPPPQNGPYPQQCMMTQNQANPSGWSFYGHPSMIPYTPYQMSPMYFPPGPQSQFPQYPSSVGTPLSTPSPESGNTFTDSSSADSDMTSTKKYVRPPPMLTSPNDFPNWVKTYIKFLQNSNLGGIIPTVNGKPVRQITDDELTFLYNTFQIFAPSQFLPTWVKDILSVDYTDIMKILSKSIEKMQSDTQEANDIVTLANLQYNGSTPADAFETKVTNIIDRLNNNGIHINNKVACQLIMRGLSGEYKFLRYTRHRHLNMTVAELFLDIHAIYEEQQGSRNSKPNYRRNPSDEKNDSRSYTNTTKPKVIARNPQKTNNSKSKTARAHNVSTSNNSPSTDNDSISKSTTEPIQLNNKHDLHLRPETY');
INSERT INTO proteininfo VALUES ('7839176', 'NP_058163.1','TyB Gag-Pol protein; proteolytically processed to make the Gag, RT, PR, and IN proteins that are required for retrotransposition; Ygr161w-bp [Saccharomyces cerevisiae]','MESQQLHQNPHSLHGSAYASVTSKEVPSNQDPLAVSASNLPEFDRDSTKVNSQQETTPGTSAVPENHHHVSPQPASVPPPQNGQYQQHGMMTPNKAMASNWAHYQQPSMMTCSHYQTSPAYYQPDPHYPLPQYIPPLSTSSPDPIDSQNQHSEVPQAETKVRNNVLPPHTLTSEENFSTWVKFYIRFLKNSNLGDIIPNDQGEIKSQMTYEEHAYIYNTFQAFAPFHLLPTWVKQILEINYADILTVLCKSVSKMQTNNQELKDWIALANLEYDGSTSADTFEITVSTIIQRLKENNINVSDRLACQLILKGLSGDFKYLRNQYRTKTNMKLSQLFAEIQLIYDENKIMNLNKPSQYKQHSEYKNVSRTSPNTTNTKVTTRNYHRTNSSKPRAAKAHNIATSSKFSRVNNDHINESTVSSQYLSDDNELSLGQQQKESKPTHTIDSNDELPDHLLIDSGASQTLVRSAHYLHHATPNSEINIVDAQKQDIPINAIGNLHFNFQNGTKTSIKALHTPNIAYDLLSLSELANQNITACFTRNTLERSDGTVLAPIVKHGDFYWLSKKYLIPSHISKLTINNVNKSKSVNKYPYPLIHRMLGHANFRSIQKSLKKNAVTYLKESDIEWSNASTYQCPDCLIGKSTKHRHVKGSRLKYQESYEPFQYLHTDIFGPVHHLPKSAPSYFISFTDEKTRFQWVYPLHDRREESILNVFTSILAFIKNQFNARVLVIQMDRGSEYTNKTLHKFFTNRGITACYTTTADSRAHGVAERLNRTLLNDCRTLLHCSGLPNHLWFSAVEFSTIIRNSLVSPKNDKSARQHAGLAGLDITTILPFGQPVIVNNHNPDSKIHPRGIPGYALHPSRNSYGYIIYLPSLKKTVDTTNYVILQDKQSKLDQFNYDTLTFDDDLNRLTAHNQSFIEQNETEQSYDQNTESDHDYQSEIEINSDPLVNDFSSQSINPLQLDKEPVQKVRAPKEVDADISEYNILPSTIRSRTPHIINKESTEMGGTVESDTTSPRHSSTFTARNQNRPGSTNEMIDLTSQDRVNYGLENIKTTRLGGTEEPYIQRNSDTNIKYRTTNSTPSIDDRSSNSESTTPIISIETKAVCDNTPSIDTDPPEYRSSDHATPNIMPDKSSKNVTADSILDDLPLPDLTHKSPTDTSDVSKDIPHIHSRQTNSSLGGMDDSNVLTTTKSKKRSLEDNETEIEVSRDTWNNKNMRSLEPPRSKKRINLIAAIKGVKSIKPVRTTLRYDEAITYNKDNKEKDRYVEAYHKEISQLLKMNTWDTNKYYDRNDIDPKKVINSMFIFNKKRDGTHKARFVARGDIQHPDTYDSDMQSNTVHHYALMTSLSIALDNDYYITQLDISSAYLYADIKEELYIRPPPHLGLNDKLLRLRKSLYGLKQSGANWYETIKSYLINCCDMQEVRGWSCVFKNSQVTICLFVDDMILFSKDLNANKKIITTLKKQYDTKIINLGESDNEIQYDILGLEIKYQRSKYMKLGMEKSLTEKLPKLNVPLNPKGKKLRAPGQPGHYIDQDELEIDEDEYKEKVHEMQKLIGLASYVGYKFRFDLLYYINTLAQHILFPSRQVLDMTYELIQFMWDTRDKQLIWHKNKPTKPDNKLVAISDASYGNQPYYKSQIGNIFLLNGKVIGGKSTKASLTCTSTTEAEIHAVSEAIPLLNNLSHLVQELNKKPIIKGLLTDSRSTISIIKSTNEEKFRNRFFGTKAMRLRDEVSGNNLYVYYIETKKNIADVMTKPLPIKTFKLLTNKWIH');
INSERT INTO proteininfo VALUES ('7839175', 'NP_058164.1','TyA Gag protein; the main structural constituent of virus-like particles (VLPs); Ygr161w-ap [Saccharomyces cerevisiae]','MESQQLHQNPHSLHGSAYASVTSKEVPSNQDPLAVSASNLPEFDRDSTKVNSQQETTPGTSAVPENHHHVSPQPASVPPPQNGQYQQHGMMTPNKAMASNWAHYQQPSMMTCSHYQTSPAYYQPDPHYPLPQYIPPLSTSSPDPIDSQNQHSEVPQAETKVRNNVLPPHTLTSEENFSTWVKFYIRFLKNSNLGDIIPNDQGEIKSQMTYEEHAYIYNTFQAFAPFHLLPTWVKQILEINYADILTVLCKSVSKMQTNNQELKDWIALANLEYDGSTSADTFEITVSTIIQRLKENNINVSDRLACQLILKGLSGDFKYLRNQYRTKTNMKLSQLFAEIQLIYDENKIMNLNKPSQYKQHSEYKNVSRTSPNTTNTKVTTRNYHRTNSSKPRAAKAHNIATSSKFSRVNNDHINESTVSSQYLSDDNELSLRPATERI');
INSERT INTO proteininfo VALUES ('7839174', 'NP_058162.1','TyA Gag protein; the main structural constituent of virus-like particles (VLPs); Ygr109w-ap [Saccharomyces cerevisiae]','MSFMDQIPGGGNYPKLPVECLPNFPIQPSLTFRGRNDSHKLKNFISEIMLNMSMISWPNDASRIVYCRRHLLNPAAQWANDFVQEQGILEITFDTFIQGLYQHFYKPPDINKIFNAITQLSEAKLGIERLNQRFRKIWDRMPPDFMTEKAAIMTYTRLLTKETYNIVRMHKPETLKDAMEEAYQTTALTERFFPGFELDADGDTIIGATTHLQEEYDSDYDSEDNLTQNGYVHTVRTRRSYNKPMSNHRNRRNNNPSREECIKNRLCFYCKKEGHRLNECRARKASSNRS');
INSERT INTO proteininfo VALUES ('7839173', 'NP_058160.1','TyB Gag-Pol protein; proteolytically processed to make the Gag, RT, PR, and IN proteins that are required for retrotransposition; Ygr038c-bp [Saccharomyces cerevisiae]','MESQQLSQHSHISHGSACASVTSKEVHTNQDPLDVSASKIQEYDKASTKANSQQTTTPASSAVPENPHHASPQPASVPPPQNGPYPQQCMMTQNQANPSGWSFYGHPSMIPYTPYQMSPMYFPPGPQSQFPQYPSSVGTPLSTPSPESGNTFTDSSSADSDMTSTKKYVRPPPMLTSPNDFPNWVKTYIKFLQNSNLGGIIPTVNGKPVRQITDDELTFLYNTFQIFAPSQFLPTWVKDILSVDYTDIMKILSKSIEKMQSDTQEANDIVTLANLQYNGSTPADAFETKVTNIIDRLNNNGIHINNKVACQLIMRGLSGEYKFLRYTRHRHLNMTVAELFLDIHAIYEEQQGSRNSKPNYRRNPSDEKNDSRSYTNTTKPKVIARNPQKTNNSKSKTARAHNVSTSNNSPSTDNDSISKSTTEPIQLNNKHDLHLGQELTESTVNHTNHSDDELPGHLLLDSGASRTLIRSAHHIHSASSNPGINVVDAQKRNIPINAIGDLQFHFQDNTKTSIKVLHTPNIAYDLLSLNELAAVDITACFTKNVLERSDGTVLAPIVKYGDFYWVSKKYLLPSNISVPTINNVHTSESTRKYPYPFIHRMLAHANAQTIRYSLKNNTITYFNESDVDWSSAIDYQCPDCLIGKSTKHRHIKGSRLKYQNSYEPFQYLHTDIFGPVHNLPNSAPSYFISFTDETTKFRWVYPLHDRREDSILDVFTTILAFIKNQFQASVLVIQMDRGSEYTNRTLHKFLEKNGITPCYTTTADSRAHGVAERLNRTLLDDCRTQLQCSGLPNHLWFSAIEFSTIVRNSLASPKSKKSARQHAGLAGLDISTLLPFGQPVIVNDHNPNSKIHPRGIPGYALHPSRNSYGYIIYLPSLKKTVDTTNYVILQGKESRLDQFNYDALTFDEDLNRLTASYHSFIASNEIQESNDLNIESDHDFQSDIELHPEQPRNVLSKAVSPTDSTPPSTHTEDSKRVSKTNIRAPREVDPNISESNILPSKKRSSTPQISNIESTGSGGMHKLNVPLLAPMSQSNTHESSHASKSKDFRHSDSYSENETNHTNVPISSTGGTNNKTVPQISDQETEKRIIHRSPSIDASPPENNSSHNIVPIKTPTTVSEQNTEESIIADLPLPDLPPESPTEFPDPFKELPPINSHQTNSSLGGIGDSNAYTTINSKKRSLEDNETEIKVSRDTWNTKNMRSLEPPRSKKRIHLIAAVKAVKSIKPIRTTLRYDEAITYNKDIKEKEKYIEAYHKEVNQLLKMNTWDTDKYYDRKEIDPKRVINSMFIFNRKRDGTHKARFVARGDIQHPDTYDSGMQSNTVHHYALMTSLSLALDNNYYITQLDISSAYLYADIKEELYIRPPPHLGMNDKLIRLKKSLYGLKQSGANWYETIKSYLIKQCGMEEVRGWSCVFKNSQVTICLFVDDMILFSKDLNANKKIITTLKKQYDTKIINLGESDNEIQYDILGLEIKYQRGKYMKLGMENSLTEKIPKLNVPLNPKGRKLSAPGQPGLYIDQDELEIDEDEYKEKVHEMQKLIGLASYVGYKFRFDLLYYINTLAQHILFPSRQVLDMTYELIQFMWDTRDKQLIWHKNKPTEPDNKLVAISDASYGNQPYYKSQIGNIFLLNGKVIGGKSTKASLTCTSTTEAEIHAVSEAIPLLNNLSHLVQELNKKPIIKGLLTDSRSTISIIKSTNEEKFRNRFFGTKAMRLRDEVSGNNLYVYYIETKKNIADVMTKPLPIKTFKLLTNKWIH');
INSERT INTO proteininfo VALUES ('7839172', 'NP_058161.1','TyA Gag protein; the main structural constituent of virus-like particles (VLPs); Ygr038c-ap [Saccharomyces cerevisiae]','MESQQLSQHSHISHGSACASVTSKEVHTNQDPLDVSASKIQEYDKASTKANSQQTTTPASSAVPENPHHASPQPASVPPPQNGPYPQQCMMTQNQANPSGWSFYGHPSMIPYTPYQMSPMYFPPGPQSQFPQYPSSVGTPLSTPSPESGNTFTDSSSADSDMTSTKKYVRPPPMLTSPNDFPNWVKTYIKFLQNSNLGGIIPTVNGKPVRQITDDELTFLYNTFQIFAPSQFLPTWVKDILSVDYTDIMKILSKSIEKMQSDTQEANDIVTLANLQYNGSTPADAFETKVTNIIDRLNNNGIHINNKVACQLIMRGLSGEYKFLRYTRHRHLNMTVAELFLDIHAIYEEQQGSRNSKPNYRRNPSDEKNDSRSYTNTTKPKVIARNPQKTNNSKSKTARAHNVSTSNNSPSTDNDSISKSTTEPIQLNNKHDLHLRPGTY');
INSERT INTO proteininfo VALUES ('7839171', 'NP_058158.1','TyB Gag-Pol protein; proteolytically processed to make the Gag, RT, PR, and IN proteins that are required for retrotransposition; Ygr027w-bp [Saccharomyces cerevisiae]','MESQQLSQHSHISHGSACASVTSKEVHTNQDPLDVSASKTEECEKASTKANSQQTTTPASSAVPENPHHASPQTAQSHSPQNGPYPQQCMMTQNQANPSGWSFYGHPSMIPYTPYQMSPMYFPPGPQSQFPQYPSSVGTPLSTPSPESGNTFTDSSSADSDMTSTKKYVRPPPMLTSPNDFPNWVKTYIKFLQNSNLGGIIPTVNGKPVRQITDDELTFLYNTFQIFAPSQFLPTWVKDILSVDYTDIMKILSKSIEKMQSDTQEANDIVTLANLQYNGSTPADAFETKVTNIIDRLNNNGIHINNKVACQLIMRGLSGEYKFLRYTRHRHLNMTVAELFLDIHAIYEEQQGSRNSKPNYRRNLSDEKNDSRSYTNTTKPKVIARNPQKTNNSKSKTARAHNVSTSNNSPSTDNDSISKSTTEPIQLNNKHDLHLGQELTESTVNHTNHSDDELPGHLLLDSGASRTLIRSAHHIHSASSNPDINVVDAQKRNIPINAIGDLQFHFQDNTKTSIKVLHTPNIAYDLLSLNELAAVDITACFTKNVLERSDGTVLAPIVQYGDFYWVSKRYLLPSNISVPTINNVHTSESTRKYPYPFIHRMLAHANAQTIRYSLKNNTITYFNESDVDWSSAIDYQCPDCLIGKSTKHRHIKGSRLKYQNSYEPFQYLHTDIFGPVHNLPKSAPSYFISFTDETTKFRWVYPLHDRREDSILDVFTTILAFIKNQFQASVLVIQMDRGSEYTNRTLHKFLEKNGITPCYTTTADSRAHGVAERLNRTLLDDCRTQLQCSGLPNHLWFSAIEFSTIVRNSLASPKSKKSARQHAGLAGLDISTLLPFGQPVIVNDHNPNSKIHPRGIPGYALHPSRNSYGYIIYLPSLKKTVDTTNYVILQGKESRLDQFNYDALTFDEDLNRLTASYHSFIASNEIQESNDLNIESDHDFQSDIELHPEQPRNVLSKAVSPTDSTPPSTHTEDSKRVSKTNIRAPREVDPNISESNILPSKKRSSTPQISNIESTGSGGMHKLNVPLLAPMSQSNTHESSHASKSKDFRHSDSYSENETNHTNVPISSTGGTNNKTVPQISDQETEKRIIHRSPSIDASPPENNSSHNIVPIKTPTTVSEQNTEESIIADLPLPDLPPESPTEFPDPFKELPPINSRQTNSSLGGIGDSNAYTTINSKKRSLEDNETEIKVSRDTWNTKNMRSLEPPRSKKRIHLIAAVKAVKSIKPIRTTLRYDEAITYNKDIKEKEKYIEAYHKEVNQLLKMKTWDTDEYYDRKEIDPKRVINSMFIFNKKRDGTHKARFVARGDIQHPDTYDSGMQSNTVHHYALMTSLSLALDNNYYITQLDISSAYLYADIKEELYIRPPPHLGMNDKLIRLKKSLYGLKQSGANWYETIKSYLIQQCGMEEVRGWSCVFKNSQVTICLFVDDMVLFSKNLNSNKRIIDKLKMQYDTKIINLGESDEEIQYDILGLEIKYQRGKYMKLGMENSLTEKIPKLNVPLNPKGRKLSAPGQPGLYIDQQELELEEDDYKMKVHEMQKLIGLASYVGYKFRFDLLYYINTLAQHILFPSKQVLDMTYELIQFIWNTRDKQLIWHKSKPVKPTNKLVVISDASYGNQPYYKSQIGNIYLLNGKVIGGKSTKASLTCTSTTEAEIHAISESVPLLNNLSYLIQELDKKPITKGLLTDSKSTISIIISNNEEKFRNRFFGTKAMRLRDEVSGNHLHVCYIETKKNIADVMTKPLPIKTFKLLTNKWIH');
INSERT INTO proteininfo VALUES ('7839170', 'NP_058159.1','TyA Gag protein; the main structural constituent of virus-like particles (VLPs); Ygr027w-ap [Saccharomyces cerevisiae]','MESQQLSQHSHISHGSACASVTSKEVHTNQDPLDVSASKTEECEKASTKANSQQTTTPASSAVPENPHHASPQTAQSHSPQNGPYPQQCMMTQNQANPSGWSFYGHPSMIPYTPYQMSPMYFPPGPQSQFPQYPSSVGTPLSTPSPESGNTFTDSSSADSDMTSTKKYVRPPPMLTSPNDFPNWVKTYIKFLQNSNLGGIIPTVNGKPVRQITDDELTFLYNTFQIFAPSQFLPTWVKDILSVDYTDIMKILSKSIEKMQSDTQEANDIVTLANLQYNGSTPADAFETKVTNIIDRLNNNGIHINNKVACQLIMRGLSGEYKFLRYTRHRHLNMTVAELFLDIHAIYEEQQGSRNSKPNYRRNLSDEKNDSRSYTNTTKPKVIARNPQKTNNSKSKTARAHNVSTSNNSPSTDNDSISKSTTEPIQLNNKHDLHLRPGTY');
INSERT INTO proteininfo VALUES ('7839169', 'NP_058157.1','TyA Gag protein; the main structural constituent of virus-like particles (VLPs); Yfl002w-bp [Saccharomyces cerevisiae]','MESQQLHQNPHSLHGSAYASVTSKEVPSNQDPLAVSASNLPEFDRDSTKVNSQQETTPGTSAVPENHHHVSPQPASVPPPQNGQYQQHGMMTPNKAMASNWAHYQQPSMMTCSHYQTSPAYYQPDPHYPLPQYIPPLSTSSPDPIDSQNQHSEVPQAETKVRNNVLPPHTLTSEENFSTWVKFYIRFLKNSNLGDIIPNDQGEIKSQMTYEEHAYIYNTFQAFAPFHLLPTWVKQILEINYADILTVLCKSVSKMQTNNQELKDWIALANLEYDGSTSADTFEITVSTIIQRLKENNINVSDRLACQLILKGLSGDFKYLRNQYRTKTNMKLSQLFAEIQLIYDENKIMNLNKPSQYKQHSEYKNVSRTSPNTTNTKVTTRNYHRTNSSKPRAAKAHNIATSSKFSRVNNDHINESTVSSQYLSDDNELSLRPATERI');
INSERT INTO proteininfo VALUES ('7839168', 'NP_058156.1','TyA Gag protein; the main structural constituent of virus-like particles (VLPs); Yer159c-ap [Saccharomyces cerevisiae]','MESQQLSNYPHISHGSACASVTSKEVHTNQDPLDVSASKIQEYDKASTKANSQQTTTPASSAVPENPHHASPQPASVPPPQNGPYPQQCMMTQNQANPSGWSFYGHPSMIPYTPYQMSPMYFPPGPQSQFPQYPSSVGTPLSTPSPESGNTFTDSSSADSDMTSTKKYVRPPPMLTSPNDFPNWVKTYIKFLQNSNLGGIIPTVNGKPVRQITDDELTFLYNTFQIFAPSQFLPTWVKDILSVDYTDIMKILSKSIEKMQSDTQEANDIVTLANLQYNGSTPADAFETKVTNIIDRLNNNGIHINNKVACQLIMRGLSGEYKFLRYTRHRHLNMTVAELFLDIHAIYEEQQGSRNSKPNYRRNPSDEKNDSRSYTNTTKPKVIARNPQKTNNSKSKTARAHNVSTSNNSPSTDNDSISKSTTEPIQLNNKHDLHLRPETY');
INSERT INTO proteininfo VALUES ('7839167', 'NP_058155.1','TyA Gag protein; the main structural constituent of virus-like particles (VLPs); Yer137c-ap [Saccharomyces cerevisiae]','MESQQLSQHSPISHGSACASVTSKEVHTNQDPLDVSASKTEECEKASTKANSQQTTTPASSAVPENPHHASPQPASVPPPQNGPYPQQCMMTQNQANPSGWSFYGHPSMIPYTPYQMSPMYFPPGPQSQFPQYPSSVGTPLSTPSPESGNTFTDSSSADSDMTSTKKYVRPPPMLTSPNDFPNWVKTYIKFLQNSNLGGIIPTVNGKPVRQITDDELTFLYNTFQIFAPSQFLPTWVKDILSVDYTDIMKILSKSIEKMQSDTQEANDIVTLANLQYNGSTPADAFETKVTNIIDRLNNNGIHINNKVACQLIMRGLSGEYKFLRYTRHRHLNMTVAELFLDIHAIYEEQQGSRNSKPNYRRNLSDEKNDSRSYTNTTKPKVIARNPQKTNNSKSKTARAHNVSTSNNSPSTDNDSISKSTTEPIQLNNKHDLHLRPGTY');
INSERT INTO proteininfo VALUES ('7839166', 'NP_058154.1','Protein whose overexpression suppresses the imp1 mutation, may be required for the function of the Imp1p mitochondrial inner membrane peptidase and/or the protein sorting machinery; Som1p [Saccharomyces cerevisiae]','MAPPTTIRTRDQALAPLATLDSQTNCRLKELVQWECQFKGAEYVCSPFKRLFEHCIAPDKSATNYEVTDTYTNS');
INSERT INTO proteininfo VALUES ('7839165', 'NP_010758.2','outer membrane protein required for for mitochondrial fusion; Ugo1p [Saccharomyces cerevisiae]','MNNNNVTEATSRAQIRPYYDPDSFNAGYSAVFKPDEGVVDPHGYTIASKLNVINSSPTTKRMANALFKSSPMKKLSNSVNDGLSLEGSNGEITGLNNFEWAELVNIQKWRKIFGQLLDMFFRKYFQLLIQQPFDVARLLIQVGEFKIFKTTVDTNKPQAPIILRDEEGDGAAREGEEDAYDEEEIDFFPIERKIAEANSTAPIMAEETDHSHHEPTDISLTIAPQSLHTIDVINALFDQEGIRGLWKANNTTFIYNFLSLSIDTWFTGLLSSFLGVPDPYFMEVINSPDISKSFILALGAGVFTSIILLPVDLIRTRLIVTSFKKKKNVKTDGKNMVTNTRSLRQLIRCWSWRKNGVSIPLDMWSLTILQSINNSFFNKLFDLVIYNQFHIEKYSQTVMYNTMKFFSKSLELFIKLPLENLLRRCQLNYLLNDQRLSFKVDSTELIVKPKKYNGIWDVIRNNSNTNRGQLWNGWKVGVISLICGYGLQMMNKVDINMEQEKF');
INSERT INTO proteininfo VALUES ('7839164', 'NP_058152.1','TyB Gag-Pol protein; proteolytically processed to make the Gag, RT, PR, and IN proteins that are required for retrotransposition; Ydr365w-bp [Saccharomyces cerevisiae]','MESQQLSQHSPISHGSACASVTSKEVHTNQDPLDVSASKTEECEKASTKANSQQTTTPASSAVPENPHHASPQPASVPPPQNGPYPQQCMMTQNQANPSGWSFYGHPSMIPYTPYQMSPMYFPPGPQSQFPQYPSSVGTPLSTPSPESGNTFTDSSSADSDMTSTKKYVRPPPMLTSPNDFPNWVKTYIKFLQNSNLGGIIPTVNGKPVRQITDDELTFLYNTFQIFAPSQFLPTWVKDILSVDYTDIMKILSKSIEKMQSDTQEANDIVTLANLQYNGSTPADAFETKVTNIIDRLNNNGIHINNKVACQLIMRGLSGEYKFLRYTRHRHLNMTVAELFLDIHAIYEEQQGSRNSKPNYRRNLSDEKNDSRSYTNTTKPKVIARNPQKTNNSKSKTARAHNVSTSNNSPSTDNDSISKSTTEPIQLNNKHDLHLGQELTESTVNHTNHSDDELPGHLLLDSGASRTLIRSAHHIHSASSNPDINVVDAQKRNIPINAIGDLQFHFQDNTKTSIKVLHTPNIAYDLLSLNELAAVDITACFTKNVLERSDGTVLAPIVQYGDFYWVSKRYLLPSNISVPTINNVHTSESTRKYPYPFIHRMLAHANAQTIRYSLKNNTITYFNESDVDWSSAIDYQCPDCLIGKSTKHRHIKGSRLKYQNSYEPFQYLHTDIFGPVHNLPNSAPSYFISFTDETTKFRWVYPLHDRREDSILDVFTTILAFIKNQFQASVLVIQMDRGSEYTNRTLHKFLEKNGITPCYTTTADSRAHGVAERLNRTLLDDCRTQLQCSGLPNYLWFSAIEFSTIVRNSLASPKSKKSARQHAGLAGLDISTLLPFGQPVIVNDHNPNSKIHPRGIPGYALHPSRNSYGYIIYLPSLKKTVDTTNYVILQGKESRLDQFNYDALTFDEDLNRLTASYHSFIASNEIQESNDLNIESDHDFQSDIELHPEQPRNVLSKAVSPTDSTPPSTHTEDSKRVSKTNIRAPREVDPNISESNILPSKKRSSTPQISNIESTGSGGMHKLNVPLLAPMSQSNTHESSHASKSKDFRHSDSYSENETNHTNVPISSTGGTNNKTVPQISDQETEKRIIHRSPSIDASPPENNSSHNIVPIKTPTTVSEQNTEESIIADLPLPDLPPESPTEFPDPFKELPPINSRQTNSSLGGIGDSNAYTTINSKKRSLEDNETEIKVSRDTWNTKNMRSLEPPRSKKRIHLIAAVKAVKSIKPIRTTLRYDEAITYNKDIKEKEKYIEAYHKEVNQLLKMKTWDTDEYYDRKEIDPKRVINSMFIFNKKRDGTHKARFVARGDIQHPDTYDSGMQSNTVHHYALMTSLSLALDNNYYITQLDISSAYLYADIKEELYIRPPPHLGMNDKLIRLKKSLYGLKQSGANWYETIKSYLIQQCGMEEVRGWSCVFKNSQVTICLFVDDMVLFSKNLNSNKRIIEKLKMQYDTKIINLGESDEEIQYDILGLEIKYQRGKYMKLGMENSLTEKIPKLNVPLNPKGRKLSAPGQPGLYIDQDELEIDEDEYKEKVHEMQKLIGLASYVGYKFRFDLLYYINTLAQHILFPSRQVLDMTYELIQFMWDTRDKQLIWHKNKPTKPDNKLVAISDASYGNQPYYKSQIGNIFLLNGKVIGGKSTKASLTCTSTTEAEIHAVSEAIPLLNNLSHLVQELNKKPIIKGLLTDSRSTISIIKSTNEEKFRNRFFGTKAMRLRDEVSGNNLYVYYIETKKNIADVMTKPLPIKTFKLLTNKWIH');
INSERT INTO proteininfo VALUES ('7839163', 'NP_058153.1','TyA Gag protein; the main structural constituent of virus-like particles (VLPs); Ydr365w-ap [Saccharomyces cerevisiae]','MESQQLSQHSPISHGSACASVTSKEVHTNQDPLDVSASKTEECEKASTKANSQQTTTPASSAVPENPHHASPQPASVPPPQNGPYPQQCMMTQNQANPSGWSFYGHPSMIPYTPYQMSPMYFPPGPQSQFPQYPSSVGTPLSTPSPESGNTFTDSSSADSDMTSTKKYVRPPPMLTSPNDFPNWVKTYIKFLQNSNLGGIIPTVNGKPVRQITDDELTFLYNTFQIFAPSQFLPTWVKDILSVDYTDIMKILSKSIEKMQSDTQEANDIVTLANLQYNGSTPADAFETKVTNIIDRLNNNGIHINNKVACQLIMRGLSGEYKFLRYTRHRHLNMTVAELFLDIHAIYEEQQGSRNSKPNYRRNLSDEKNDSRSYTNTTKPKVIARNPQKTNNSKSKTARAHNVSTSNNSPSTDNDSISKSTTEPIQLNNKHDLHLRPGTY');
INSERT INTO proteininfo VALUES ('7839162', 'NP_058150.1','TyB Gag-Pol protein; proteolytically processed to make the Gag, RT, PR, and IN proteins that are required for retrotransposition; Ydr316w-bp [Saccharomyces cerevisiae]','MESQQLSNYPHISHGSACASVTSKEVHTNQDPLDVSASKIQEYDKASTKANSQQTTTPASSAVPENPHHASPQPASVPPPQNGPYPQQCMMTQNQANPSGWSFYGHPSMIPYTPYQMSPMYFPPGPQSQFPQYPSSVGTPLSTPSPESGNTFTDSSSADSDMTSTKKYVRPPPMLTSPNDFPNWVKTYIKFLQNSNLGGIIPTVNGKPVRQITDDELTFLYNTFQIFAPSQFLPTWVKDILSVDYTDIMKILSKSIEKMQSDTQEANDIVTLANLQYNGSTPADAFETKVTNIIDRLNNNGIHINNKVACQLIMRGLSGEYKFLRYTRHRHLNMTVAELFLDIHAIYEEQQGSRNSKPNYRRNPSDEKNDSRSYTNTTKPKVIARNPQKTNNSKSKTARAHNVSTSNNSPSTDNDSISKSTTEPIQLNNKHDLHLGQKLTESTVNHTNHSDDELPGHLLLDSGASRTLIRSAHHIHSASSNPDINVVDAQKRNIPINAIGDLQFHFQDNTKTSIKVLHTPNIAYDLLSLNELAAVDITACFTKNVLERSDGTVLAPIVKYGDFYWVSKKYLLPSNISVPTINNVHTSESTRKYPYPFIHRMLAHANAQTIRYSLKNNTITYFNESDVDWSSAIDYQCPDCLIGKSTKHRHIKGSRLKYQNSYEPFQYLHTDIFGPVHNLPNSAPSYFISFTDETTKFRWVYPLHDRREDSILDVFTTILAFIKNQFQASVLVIQMDRGSEYTNRTLHKFLEKNGITPCYTTTADSRAHGVAERLNRTLLDDCRTQLQCSGLPNHLWFSAIEFSTIVRNSLASPKSKKSARQHAGLAGLDISTLLPFGQPVIVNDHNPNSKIHPRGIPGYALHPSRNSYGYIIYLPSLKKTVDTTNYVILQGKESRLDQFNYDALTFDEDLNRLTASYHSFIASNEIQESNDLNIESDHDFQSDIELHPEQPRNVLSKAVSPTDSTPPSTHTEDSKRVSKTNIRAPREVDPNISESNILPSKKRSSTPQISNIESTGSGGMHKLNVPLLAPMSQSNTHESSHASKSKDFRHSDSYSENETNHTNVPISSTGGTNNKTVPQISDQETEKRIIHRSPSIDASPPENNSSHNIVPIKTPTTVSEQNTEESIIADLPLPDLPPESPTEFPDPFKELPPINSHQTNSSLGGIGDSNAYTTINSKKRSLEDNETEIKVSRDTWNTKNMRSLEPPRSKKRIHLIAAVKAVKSIKPIRTTLRYDEAITYNKDIKEKEKYIEAYHKEVNQLLKMNTWDTDKYYDRKEIDPKRVINSMFIFNRKRDGTHKARFVARGDIQHPDTYDSGMQSNTVHHYALMTSLSLALDNNYYITQLDISSAYLYADIKEELYIRPPPHLGMNDKLIRLKKSLYGLKQSGANWYETIKSYLIKQCGMEEVRGWSCVFKNSQVTICLFVDDMILFSKDLNANKKIITTLKKQYDTKIINLGESDNEIQYDILGLEIKYQRGKYMKLGMENSLTEKIPKLNVPLNPKGRKLSAPGQPGLYIDQDELEIDEDEYKEKVHEMQKLIGLASYVGYKFRFDLLYYINTLAQHILFPSRQVLDMTYELIQFMWDTRDKQLIWHKNKPTEPDNKLVAISDASYGNQPYYKSQIGNIYLLNGKVIGGKSTKASLTCTSTTEAEIHAISESVPLLNNLSHLVQELNKKPITKGLLTDSKSTISIIISNNEEKFRNRFFGTKAMRLRDEVSGNHLHVCYIETKKNIADVMTKPLPIKTFKLLTNKWIH');
INSERT INTO proteininfo VALUES ('7839161', 'NP_058151.1','TyA Gag protein; the main structural constituent of virus-like particles (VLPs); Ydr316w-ap [Saccharomyces cerevisiae]','MESQQLSNYPHISHGSACASVTSKEVHTNQDPLDVSASKIQEYDKASTKANSQQTTTPASSAVPENPHHASPQPASVPPPQNGPYPQQCMMTQNQANPSGWSFYGHPSMIPYTPYQMSPMYFPPGPQSQFPQYPSSVGTPLSTPSPESGNTFTDSSSADSDMTSTKKYVRPPPMLTSPNDFPNWVKTYIKFLQNSNLGGIIPTVNGKPVRQITDDELTFLYNTFQIFAPSQFLPTWVKDILSVDYTDIMKILSKSIEKMQSDTQEANDIVTLANLQYNGSTPADAFETKVTNIIDRLNNNGIHINNKVACQLIMRGLSGEYKFLRYTRHRHLNMTVAELFLDIHAIYEEQQGSRNSKPNYRRNPSDEKNDSRSYTNTTKPKVIARNPQKTNNSKSKTARAHNVSTSNNSPSTDNDSISKSTTEPIQLNNKHDLHLRPETY');
INSERT INTO proteininfo VALUES ('7839160', 'NP_058148.1','TyB Gag-Pol protein; proteolytically processed to make the Gag, RT, PR, and IN proteins that are required for retrotransposition; Ydr261c-dp [Saccharomyces cerevisiae]','MESQQLSQHSPISHGSACASVTSKEVHTNQDPLDVSASKTEECEKASTKANSQQTTTPASSAVPENPHHASPQPASVPPPQNGPYPQQCMMTQNQANPSGWSFYGHPSMIPYTPYQMSPMYFPPGPQSQFPQYPSSVGTPLSTPSPESGNTFTDSSSADSDMTSTKKYVRPPPMLTSPNDFPNWVKTYIKFLQNSNLGGIIPTVNGKPVRQITDDELTFLYNTFQIFAPSQFLPTWVKDILSVDYTDIMKILSKSIEKMQSDTQEANDIVTLANLQYNGSTPADAFETKVTNIIDRLNNNGIHINNKVACQLIMRGLSGEYKFLRYTRHRHLNMTVAELFLDIHAIYEEQQGSRNSKPNYRRNPSDEKNDSRSYTNTTKPKVIARNPQKTNNSKSKTARAHNVSTSNNSPSTDNDSISKSTTEPIQLNNKHDLHLGQKLTESTVNHTNHSDDELPGHLLLDSGASRTLIRSAHHIHSASSNPDINVVDAQKRNIPINAIGDLQFHFQDNTKTSIKVLHTPNIAYDLLSLNELAAVDITACFTKNVLERSDGTVLAPIVKYGDFYWVSKKYLLPSNISVPTINNVHTSESTRKYPYPFIHRMLAHANAQTIRYSLKNNTITYFNESDVDWSSAIDYQCPDCLIGKSTKHRHIKGSRLKYQNSYEPFQYLHTDIFGPVHNLPNSAPSYFISFTDETTKFRWVYPLHDRREDSILDVFTTILAFIKNQFQASVLVIQMDRGSEYTNRTLHKFLEKNGITPCYTTTADSRAHGVAERLNRTLLDDCRTQLQCSGLPNHLWFSAIEFSTIVRNSLASPKSKKSARQHAGLAGLDISTLLPFGQPVIVNDHNPNSKIHPRGIPGYALHPSRNSYGYIIYLPSLKKTVDTTNYVILQGKESRLDQFNYDALTFDEDLNRLTASYHSFIASNEIQESNDLNIESDHDFQSDIELHPEQPRNVLSKAVSPTDSTPPSTHTEDSKRVSKTNIRAPREVDPNISESNILPSKKRSSTPQISNIESTGSGGMHKLNVPLLAPMSQSNTHESSHASKSKDFRHSDSYSENETNHTNVPISSTGGTNNKTVPQISDQETEKRIIHRSPSIDASPPENNSSHNIVPIKTPTTVSEQNTEESIIADLPLPDLPPESPTEFPDPFKELPPINSRQTNSSLGGIGDSNAYTTINSKKRSLEDNETEIKVSRDTWNTKNMRSLEPPRSKKRIHLIAAVKAVKSIKPIRTTLRYDEAITYNKDIKEKEKYIEAYHKEVNQLLKMKTWDTDEYYDRKEIDPKRVINSMFIFNKKRDGTHKARFVARGDIQHPDTYDSGMQSNTVHHYALMTSLSLALDNNYYITQLDISSAYLYADIKEELYIRPPPHLGMNDKLIRLKKSLYGLKQSGANWYETIKSYLIQQCGMEEVRGWSCVFKNSQVTICLFVDDMVLFSKNLNSNKRIIEKLKMQYDTKIINLGESDEEIQYDILGLEIKYQRGKYMKLGMENSLTEKIPKLNVPLNPKGRKLSAPGQPGLYIDQDELEIDEDEYKEKVHEMQKLIGLASYVGYKFRFDLLYYINTLAQHILFPSRQVLDMTYELIQFMWDTRDKQLIWHKHKTSSDKNI');
INSERT INTO proteininfo VALUES ('7839159', 'NP_058149.1','TyA Gag protein; the main structural constituent of virus-like particles (VLPs); Ydr261c-cp [Saccharomyces cerevisiae]','MESQQLSQHSPISHGSACASVTSKEVHTNQDPLDVSASKTEECEKASTKANSQQTTTPASSAVPENPHHASPQPASVPPPQNGPYPQQCMMTQNQANPSGWSFYGHPSMIPYTPYQMSPMYFPPGPQSQFPQYPSSVGTPLSTPSPESGNTFTDSSSADSDMTSTKKYVRPPPMLTSPNDFPNWVKTYIKFLQNSNLGGIIPTVNGKPVRQITDDELTFLYNTFQIFAPSQFLPTWVKDILSVDYTDIMKILSKSIEKMQSDTQEANDIVTLANLQYNGSTPADAFETKVTNIIDRLNNNGIHINNKVACQLIMRGLSGEYKFLRYTRHRHLNMTVAELFLDIHAIYEEQQGSRNSKPNYRRNPSDEKNDSRSYTNTTKPKVIARNPQKTNNSKSKTARAHNVSTSNNSPSTDNDSISKSTTEPIQLNNKHDLHLRPETY');
INSERT INTO proteininfo VALUES ('7839158', 'NP_058146.1','TyB Gag-Pol protein; proteolytically processed to make the Gag, RT, PR, and IN proteins that are required for retrotransposition; Ydr261w-bp [Saccharomyces cerevisiae]','MESQQLHQNPHSLHGSAAASVTSKEVPSNQDPLAVSASNLPEFDRDSTKVNSQQETTPGTSAVPENHHHVSPQPASVPPPQNGQYQQHGMMTPNKAMASNWAHYQQPSMMTCSHYQTSPAYYQPDPHYPLPQYIPPLSTSSPDPIDSQNQHSEVPQAKTKVRNNVLPPHTLTSEENFSTWVKFYIRFLKNSNLGDIIPNDQGEIKRQMTYEEHAYIYNTFQAFAPFHLLPTWVKQILEINYADILTVLCKSVSKMQTNNQELKDWIALANLEYDGSTSADTFEITVSTIIQRLKENNINVSDRLACQLILKGLSGDFKYLRNQYRTKTNMKLSQLFAEIQLIYDENKIMNLNKPSQYKQHSEYKNVSRTSPNTTNTKVTSRNYHRTNSSKPRAAKAHNIATSSKFSRVNNDHINESTVSSQYLSDDNELSLGQQQKESKPTRTIDSNDELPDHLLIDSGASQTLVRSAHYLHHATPNSEINIVDAQKQDIPINAIGNLHFNFQNGTKTSIKALHTPNIAYDLLSLSELANQNITACFTRNTLERSDGTVLAPIVKHGDFYWLSKKYLIPSHISKLTINNVNKSKSVNKYPYPLIHRMLGHANFRSIQKSLKKNAVTYLKESDIEWSNASTYQCPDCLIGKSTKHRHIKGSRLKYQESYEPFQYLHTDIFGPVHHLPKSAPSYFISFTDEKTRFQWVYPLHDRREESILNVFTSILAFIKNQFNARVLVIQMDRGSEYTNKTLHKFFTNRGITACYTTTADSRAHGVAERLNRTLLNDCRTLLHCSGLPNHLWFSAVEFSTIIRNSLVSPKNDKSARQHAGLAGLDITTILPFGQPVIVNNHNPDSKIHPRGIPGYALHPSRNSYGYIIYLPSLKKTVDTTNYVILQDNQSKLDQFNYDTLTFDDDLNRLTAHNQSFIEQNETEQSYDQNTESDHDYQSEIEINSDPLVNDFSSQSLNPLQLDKEPVQKVRAPKEVDADISEYNILPSTIRSRTPHIINKESTEMGGTIESDTTSPRHSSTFTARNQKRPGSPNDMIDLTSQDRVNYGLENIKTTRLGGTEEPYIQRNSDTNIKYRTTNSTPSIDDRSSNSESTTPIISIETKAVCDNTPSIDTDPPEYRSSDHATPNIMPDKSSKNVTADSILDDLPLPDLTNKSPTDTSDVSKDIPHIHSRQTNSSLGGMDDSNVLTTTKSKKRSLEDNETEIEVSRDTWNNKNMRSLEPPRSKKRINLIAAIKGVKSIKPVRTTLRYDEAITYNKDNKEKDRYVEAYHKEISQLLKMNTWDTNKYYDRNDIDPKKVINSMFIFNKKRDGTHKARFVARGDIQHPDTYDSDMQSNTVHHYALMTSLSIALDNDYYITQLDISSAYLYADIKEELYIRPPPHLGLNDKLLRLRKSLYGLKQSGANWYETIKSYLINCCDMQEVRGWSCVFKNSQVTICLFVDDMILFSKDLNANKKIITTLKKQYDTKIINLGEGDNEIQYDILGLEIKYQRSKYMKLGMEKSLTEKLPKLNVPLNPKGKKLRAPGQPGHYIDQDELEIDEDEYKEKVHEMQKLIGLASYVGYKFRFDLLYYINTLAQHILFPSRQVLDMTYELIQFIWNTRDKQLIWHKSKPVKPTNKLVVISDASYGNQPYYKSQIGNIYLLNGKVIGGKSTKASLTCTSTTEAEIHAVSEAIPLLNNLSHLVQELNKKPIIKGLLTDSRSTISIIKSTNEEKFRNRFFGTKAMRLRDEVSGNNLYVYYIETKMNIADVMTKPLPIKTFKLLTNKWIH');
INSERT INTO proteininfo VALUES ('7839157', 'NP_058147.1','TyA Gag protein; the main structural constituent of virus-like particles (VLPs); Ydr261w-ap [Saccharomyces cerevisiae]','MESQQLHQNPHSLHGSAAASVTSKEVPSNQDPLAVSASNLPEFDRDSTKVNSQQETTPGTSAVPENHHHVSPQPASVPPPQNGQYQQHGMMTPNKAMASNWAHYQQPSMMTCSHYQTSPAYYQPDPHYPLPQYIPPLSTSSPDPIDSQNQHSEVPQAKTKVRNNVLPPHTLTSEENFSTWVKFYIRFLKNSNLGDIIPNDQGEIKRQMTYEEHAYIYNTFQAFAPFHLLPTWVKQILEINYADILTVLCKSVSKMQTNNQELKDWIALANLEYDGSTSADTFEITVSTIIQRLKENNINVSDRLACQLILKGLSGDFKYLRNQYRTKTNMKLSQLFAEIQLIYDENKIMNLNKPSQYKQHSEYKNVSRTSPNTTNTKVTSRNYHRTNSSKPRAAKAHNIATSSKFSRVNNDHINESTVSSQYLSDDNELSLRPATERI');
INSERT INTO proteininfo VALUES ('7839154', 'NP_058142.1','TyB Gag-Pol protein; proteolytically processed to make the Gag, RT, PR, and IN proteins that are required for retrotransposition; Ydr210w-bp [Saccharomyces cerevisiae]','MESQQLHQNPHSQHGSAYASVTSKEVPSNQDPLAVSASNLPEFDRDSTKVNSQEETTPGTSAVPENHHHVSPQPASVPPPQNGQYQQHGMMTPNKAMASNWAHYQQPSMMTCSHYQTSPAYYQPDPHYPLPQYIPPLSTSSPDPIDSQDQHSEVPQAKTKVRNNVLPPHTLTSEENFSTWVKFYIRFLKNSNLGDIIPNDQGEIKRQMTYEEHAYIYNTFQAFAPFHLLPTWVKQILEINYSDILTVLCKSVSKMQTNNQELKDWIALANLEYNGSTSADTFEITVSTIIQRLKENNINVSDRLACQLILKGLSGDFKYLRNQYRTKTNMKLSQLFAEIQLIYDENKIMNLNKPSQYKQHSEYKNVSRTSPNTTNTKVTTRNYHRTNSSKPRAAKAHNIATSSKFSRVNSDHINESTVSSQYLSDDNELSLGQQQKESKPTRTIDSNDELPDHLLIDSGASQTLVRSAHYLHHATPNSEINIVDAQKQDIPINAIGNLHFNFQNGTKTSIKALHTPNIAYDLLSLSELANQNITACFTRNTLERSDGTVLAPIVKHGDFYWLSKKYLIPSHISKLTINNVNKSKSVNKYPYPLIHRMLGHANFRSIQKSLKKNAVTYLKESDIEWSNASTYQCPDCLIGKSTKHRHVKGSRLKYQESYEPFQYLHTDIFGPVHHLPKSAPSYFISFTDEKTRFQWVYPLHDRREESILNVFTSILAFIKNQFNARVLVIQMDRGSEYTNKTLHKFFTNRGITACYTTTADSRAHGVAERLNRTLLNDCRTLLHCSGLPNHLWFSAVEFSTIIRNSLVSPKNDKSARQHAGLAGLDITTILPFGQPVIVNNHNPDSKIHPRGIPGYALHPSRNSYGYIIYLPSLKKTVDTTNYVILQNNQTKLDQFDYDTLTFDDDLNRLTAHNQSFIEQNETEQSYDQNTESDHDYQSEIEINSDPLVNDFSSQSLNPLQLDKEPVQKVRAPKEVDADISEYNILPSTIRSRTPHIINKESTEMGGTIESDTTSPRHSSTFTARNQKRPGSPNDMIDLTSQDRVNYGLENIKTTRLGGTEEPYIQRNSDTNIKYRTTNSTPSIDDRSSNSESTTPIISIETKAVCDNTPSIDTDPPEYRSSDHATPNIMPDKSSKNVTADSILDDLPLPDLTHKSPTDTSDVAKDIPHIHSRQTNSSLGGMDDSNVLTTTKSKKRSLEDNETEIEVSRDTWNNKNMRSLEPPRSKKRINLIAAIKGVKSIKPVRTTLRYDEAITYNKDNKEKDRYVEAYHKEISQLLKMNTWDTNKYYDRNDIDPKKVINSMFIFNKKRDGTHKARFVARGDIQHPDTYDSDMQSNTVHHYALMTSLSIALDNDYYITQLDISSAYLYADIKEELYIRPPPHLGLNDKLLRLRKSLYGLKQSGANWYETIKSYLINCCDMQEVRGWSCVFKNSQVTICLFVDDMILFSKDLNANKKIITTLKKQYDTKIINLGEGDNEIQYDILGLEIKYQRSKYMKLGMEKSLTEKLPKLNVPLNPKGKKLRAPGQPGHYIDQDELEIDEDEYKEKVHEMQKLIGLASYVGYKFRFDLLYYINTLAQHILFPSRQVLDMTYELIQFMWDTRDKQLIWHKNKPTKPDNKLVAISDASYGNQPYYKSQIGNIFLLNGKVIGGKSTKASLTCTSTTEAEIHAVSEAIPLLNNLSHLVQELNKKPIIKGLLTDSRSTISIIKSTNEEKFRNRFFGTKAMRLRDEVSGNNLYVYYIETKKNIADVMTKPLPIKTFKLLTNKWIH');
INSERT INTO proteininfo VALUES ('7839153', 'NP_058143.1','TyA Gag protein; the main structural constituent of virus-like particles (VLPs); Ydr210w-ap [Saccharomyces cerevisiae]','MESQQLHQNPHSQHGSAYASVTSKEVPSNQDPLAVSASNLPEFDRDSTKVNSQEETTPGTSAVPENHHHVSPQPASVPPPQNGQYQQHGMMTPNKAMASNWAHYQQPSMMTCSHYQTSPAYYQPDPHYPLPQYIPPLSTSSPDPIDSQDQHSEVPQAKTKVRNNVLPPHTLTSEENFSTWVKFYIRFLKNSNLGDIIPNDQGEIKRQMTYEEHAYIYNTFQAFAPFHLLPTWVKQILEINYSDILTVLCKSVSKMQTNNQELKDWIALANLEYNGSTSADTFEITVSTIIQRLKENNINVSDRLACQLILKGLSGDFKYLRNQYRTKTNMKLSQLFAEIQLIYDENKIMNLNKPSQYKQHSEYKNVSRTSPNTTNTKVTTRNYHRTNSSKPRAAKAHNIATSSKFSRVNSDHINESTVSSQYLSDDNELSLRPATERI');
INSERT INTO proteininfo VALUES ('7839152', 'NP_058140.1','TyB Gag-Pol protein; proteolytically processed to make the Gag, RT, PR, and IN proteins that are required for retrotransposition; Ydr098c-bp [Saccharomyces cerevisiae]','MESQQLSNYPHISHGSACASVTSKEVHTNQDPLDVSASKIQEYDKASTKANSQQTTTPASSAVPENPHHASPQPASVPPPQNGPYPQQCMMTQNQANPSGWSFYGHPSMIPYTPYQMSPMYFPPGPQSQFPQYPSSVGTPLSTPSPESGNTFTDSSSADSDMTSTKKYVRPPPMLTSPNDFPNWVKTYIKFLQNSNLGGIIPTVNGKPVRQITDDELTFLYNTFQIFAPSQFLPTWVKDILSVDYTDIMKILSKSIEKMQSDTQEANDIVTLANLQYNGSTPADAFETKVTNIIDRLNNNGIHINNKVACQLIMRGLSGEYKFLRYTRHRHLNMTVAELFLDIHAIYEEQQGSRNSKPNYRRNPSDEKNDSRSYTNTTKPKVIARNPQKTNNSKSKTARAHNVSTSNNSPSTDNDSISKSTTEPIQLNNKHDLHLGQELTESTVNHTNHSDDELPGHLLLDSGASRTLIRSAHHIHSASSNPGINVVDAQKRNIPINAIGDLQFHFQDNTKTSIKVLHTPNIAYDLLSLNELAAVDITACFTKNVLERSDGTVLAPIVKYGDFYWVSKKYLLPSNISVPTINNVHTSESTRKYPYPFIHRMLAHANAQTIRYSLKNNTITYFNESDVDWSSAIDYQCPDCLIGKSTKHRHIKGSRLKYQNSYEPFQYLHTDIFGPVHNLPNSAPSYFISFTDETTKFRWVYPLHDRREDSILDVFTTILAFIKNQFQASVLVIQMDRGSEYTNRTLHKFLEKNGITPCYTTTADSRAHGVAERLNRTLLDDCRTQLQCSGLPNHLWFSAIEFSTIVRNSLASPKSKKSARQHAGLAGLDISTLLPFGQPVIVNDHNPNSKIHPRGIPGYALHPSRNSYGYIIYLPSLKKTVDTTNYVILQGKESRLDQFNYDALTFDEDLNRLTASYHSFIASNEIQESNDLNIESDHDFQSDIELHPEQPRNVLSKAVSPTDSTPPSTHTEDSKRVSKTNIRAPREVDPNISESNILPSKKRSSTPQISNIESTGSGGMHKLNVPLLAPMSQSNTHESSHASKSKDFRHSDSYSENETNHTNVPISSTGGTNNKTVPQISDQETEKRIIHRSPSIDASPPENNSSHNIVPIKTPTTVSEQNTEESIIADLPLPDLPPESPTEFPDPFKELPPINSHQTNSSLGGIGDSNAYTTINSKKRSLEDNETEIKVSRDTWNTKNMRSLEPPRSKKRIHLIAAVKAVKSIKPIRTTLRYDEAITYNKDIKEKEKYIEAYHKEVNQLLKMNTWDTDKYYDRKEIDPKRVINSMFIFNRKRDGTHKARFVARGDIQHPDTYDSGMQSNTVHHYALMTSLSLALDNNYYITQLDISSAYLYADIKEELYIRPPPHLGMNDKLIRLKKSLYGLKQSGANWYETIKSYLIKQCGMEEVRGWSCVFKNSQVTICLFVDDMILFSKDLNANKKIITTLKKQYDTKIINLGEGDNEIQYDILGLEIKYQRSKYMKLGMEKSLTEKLPKLNVPLNPKGKKLRAPGQPGHYIDQDELEIDEDEYKEKVHEMQKLIGLASYVGYKFRFDLLYYINTLAQHILFPSRQVLDMTYELIQFMWDTRDKQLIWHKNKPTKPDNKLVAISDASYGNQPYYKSQIGNIFLLNGKVIGGKSTKASLTCTSTTEAEIHAVSEAIPLLNNLSHLVQELNKKPIIKGSLTDSRSTISIIKSTNEEKFRNRFFGTKAMRLRDEVSGNNLYVYYIETKKNIADVMTKPLPIKTFKLLTNKWIH');
INSERT INTO proteininfo VALUES ('7839151', 'NP_058141.1','TyA Gag protein; the main structural constituent of virus-like particles (VLPs); Ydr098c-ap [Saccharomyces cerevisiae]','MESQQLSNYPHISHGSACASVTSKEVHTNQDPLDVSASKIQEYDKASTKANSQQTTTPASSAVPENPHHASPQPASVPPPQNGPYPQQCMMTQNQANPSGWSFYGHPSMIPYTPYQMSPMYFPPGPQSQFPQYPSSVGTPLSTPSPESGNTFTDSSSADSDMTSTKKYVRPPPMLTSPNDFPNWVKTYIKFLQNSNLGGIIPTVNGKPVRQITDDELTFLYNTFQIFAPSQFLPTWVKDILSVDYTDIMKILSKSIEKMQSDTQEANDIVTLANLQYNGSTPADAFETKVTNIIDRLNNNGIHINNKVACQLIMRGLSGEYKFLRYTRHRHLNMTVAELFLDIHAIYEEQQGSRNSKPNYRRNPSDEKNDSRSYTNTTKPKVIARNPQKTNNSKSKTARAHNVSTSNNSPSTDNDSISKSTTEPIQLNNKHDLHLRPGTY');
INSERT INTO proteininfo VALUES ('7839150', 'NP_058138.1','TyB Gag-Pol protein; proteolytically processed to make the Gag, RT, PR, and IN proteins that are required for retrotransposition; Ydr034c-dp [Saccharomyces cerevisiae]','MESQQLSQNSPNLHGSAYASVTSKEVPSNQDPLAVSASNLPEFDRDSTKVNSQQETTPGTSAVPENHHHVSPQPASVPPPQNGQYQQHGMMTPNKAMASNWAHYQQPSMMTCSHYQTSPAYYQPDPHYPLPQYIPPLSTSSPDPIDLKNQHSEIPQAKTKVGNNVLPPHTLTSEENFSTWVKFYIRFLKNSNLGDIIPNDQGEIKRQMTYEEHAYIYNTFQAFAPFHLLPTWVKQILEINYADILTVLCKSVSKMQTNNQELKDWIALANLEYDGSTSADTFEITVSTIIQRLKENNINVSDRLACQLILKGLSGDFKYLRNQYRTKTNMKLSQLFAEIQLIYDENKIMNLNKPSQYKQHSEYKNVSRTSPNTTNTKVTTRNYQRTNSSKPRAAKAHNIATSSKFSRVNNDHINESTVSSQYLSDDNELSLGQQQKESKPTHTIDSNDELPDHLLIDSGASQTLVRSAHYLHHATPNSEINIVDAQKQDIPINAIGNLHFNFQNGTKTSIKALHTPNIAYDLLSLSELANQNITACFTRNTLERSDGTVLAPIVKHGDFYWLSKKYLIPSHISKLTINNVNKSKSVNKYPYPLIHRMLGHANFRSIQKSLKKNAVTYLKESDIEWSNASTYQCPDCLIGKSTKHRHVKGSRLKYQESYEPFQYLHTDIFGPVHHLPKSAPSYFISFTDEKTRFQWVYPLHDRREESILNVFTSILAFIKNQFNARVLVIQMDRGSEYTNKTLHKFFTNRGITACYTTTADSRAHGVAERLNRTLLNDCRTLLHCSGLPNHLWFSAVEFSTIIRNSLVSPKNDKSARQHAGLAGLDITTILPFGQPVIVNNHNPDSKIHPRGIPGYALHPSRNSYGYIIYLPSLKKTVDTTNYVILQDKQSKLDQFNYDTLTFDDDLNRLTAHNQSFIEKNETEQSYDQNTESDHDYQSEIEINSDPLVNDFSSQSINPLQLDKEPVQKVRAPKEVDADISEYNILPSTIRSRTPHIINKESTEMGGTIESDTTSPRHSSTFTARNQKRPGSPNDMIDLTSQDRVNYGLENIKTTRLGGTEEPYIQRNSDTNIKYRTTNSTPSIDDRSSNSESTTPIISIETKAACDNTPSIDTDPPEYRSSDHATPNIMPDKSSKNVTADSILDDLPLPDLTNKSPTDTSDVSKDIPHIHSRQTNSSLGGMDDSNVLTTTKSKKRSLEDNETEIEVSRDTWNNKNMRSLEPPRSKKRINLIAAIKGVKSIKPVRTTLRYDEAITYNEDNKEKDRYIEAYHKEINQLLRMNTWDTNKYYDRNDIDPKKVINSMFIFNKKRDGTHKARFVARGDIQHPDTYDSDMQSNTVHHYALMTSLSIALDNDYYITQLDISSAYLYADIKEELYIRPPPHLGLNDKLLRLRKSLYGLKQSGANWYETIKSYLINCCDMQEVRGWSCVFKNSQVTICLFVDDMILFSKDLNANKKIITTLKKQYDTKIINLGEGDNEIQYDILGLEIKYQRSKYMKLGMEKSLTEKLPKLNVPLNPKGKKLRAPGQPGHYIDQDELEIDEDEYKEKVHEMQKLIGLASYVGYKFRFDLLYYINTLAQHILFPSRQVLDMTYELIQFMWDTRDKQLIWHKNKPTKPDNKLVAISDASYGNQPYYKSQIGNIFLLNGKVIGGKSTKASLTCTSTTEAEIHAVSEAIPLLNNLSHLVQELNKKPIIKGLLTDSRSTISIIKSTNEEKFRNRFFGTKAMRLRDEVSGNNLYVYYIETKKNIADVMTKPLPIKTFKLLTNKWIH');
INSERT INTO proteininfo VALUES ('7839149', 'NP_058139.1','TyA Gag protein; the main structural constituent of virus-like particles (VLPs); Ydr034c-cp [Saccharomyces cerevisiae]','MESQQLSQNSPNLHGSAYASVTSKEVPSNQDPLAVSASNLPEFDRDSTKVNSQQETTPGTSAVPENHHHVSPQPASVPPPQNGQYQQHGMMTPNKAMASNWAHYQQPSMMTCSHYQTSPAYYQPDPHYPLPQYIPPLSTSSPDPIDLKNQHSEIPQAKTKVGNNVLPPHTLTSEENFSTWVKFYIRFLKNSNLGDIIPNDQGEIKRQMTYEEHAYIYNTFQAFAPFHLLPTWVKQILEINYADILTVLCKSVSKMQTNNQELKDWIALANLEYDGSTSADTFEITVSTIIQRLKENNINVSDRLACQLILKGLSGDFKYLRNQYRTKTNMKLSQLFAEIQLIYDENKIMNLNKPSQYKQHSEYKNVSRTSPNTTNTKVTTRNYQRTNSSKPRAAKAHNIATSSKFSRVNNDHINESTVSSQYLSDDNELSLRPATERI');
INSERT INTO proteininfo VALUES ('7839147', 'NP_058137.1','May regulate plasma membrane H(+)-ATPase; Proteolipid associated with plasma membrane H(+)-ATPase (Pma1p); Pmp1p [Saccharomyces cerevisiae]','MTLPGGVILVFILVGLACIAIIATIIYRKWQARQRGLQRF');
INSERT INTO proteininfo VALUES ('7839146', 'NP_058136.1','Hypothetical ORF; Yal064c-ap [Saccharomyces cerevisiae]','MTGYFLPPQTSSYTFRFAKVDDSAILSVGGDVAFGCCAQEQPPITSTNFTINGIKPWQGRLPDNIAGTVYMYAGFYCPMKIVYSNAVSWHTLPVSVELPDVTTVSDDFAGHVYSFDDDLTAQLYYP');
INSERT INTO proteininfo VALUES ('7276233', 'NP_011049.2','plasma membrane-bound casein kinase I homolog; Yck3p [Saccharomyces cerevisiae]','MSQRSSQHIVGIHYAVGPKIGEGSFGVIFEGENILHSCQAQTGSKRDSSIIMANEPVAIKFEPRHSDAPQLRDEFRAYRILNGCVGIPHAYYFGQEGMHNILIIDLLGPSLEDLFEWCGRKFSVKTTCMVAKQMIDRVRAIHDHDLIYRDIKPDNFLISQYQRISPEGKVIKSCASSSNNDPNLIYMVDFGMAKQYRDPRTKQHIPYRERKSLSGTARYMSINTHFGREQSRRDDLESLGHVFFYFLRGSLPWQGLKAPNNKLKYEKIGMTKQKLNPDDLLLNNAIPYQFATYLKYARSLKFDEDPDYDYLISLMDDALRLNDLKDDGHYDWMDLNGGKGWNIKINRRANLHGYGNPNPRVNGNTARNNVNTNSKTRNTTPVATPKQQAQNSYNKDNSKSRISSNPQSFTKQQHVLKKIEPNSKYIPETHSNLQRPIKSQSQTYDSISHTQNSPFVPYSSSKANPKRSNNEHNLPNHYTNLANKNINYQSQRNYEQENDAYSDDENDTFCSKIYKYCCCCFCCC');
INSERT INTO proteininfo VALUES ('6862572', 'NP_036195.1','TyA Gag protein; the main structural constituent of virus-like particles (VLPs); Yhr214c-cp [Saccharomyces cerevisiae]','MESQQLSNYPHISHGSACASVTSKEVHTNQDPLDVSASKIQEYDKASTKANSQQTTTPASSAVPENLHHASPQPASVPPPQNGPYPQQCMMTQNQANPSGWSFYGHPSMIPYTPYQMSPMYFPPGPQSQFPQYPSSVGTPLSTPSPESGNTFTDSSSADSDMTSTKKYVRPPPMLTSPNDFPNWVKTYIKFLQNSNLGGIIPTVNGKPVPPMLTSPNDFPNWVKTYIKFLQNSNLGGIIPTVNGKPVRQITDDELTFLYNTFQIFAPSQFLPTWVKDILSVDYTDIMKILSKSIEKMQSDTQEANDIVTLANLQYNGSTPADAFETKVTNIIDRLNNNGIHINNKVACQLIMRGLSGEYKFLRYTRHRHLNMTVAELFLDIHAIYEEQQGSRNSKPNYRRNPSDEKNDSRSYTNTTKPKVIARNPQKTNNSKSKTARAHNVSTSNNSPSTDNDSISKSTTEPIQLNNKHDLHLRPETY');
INSERT INTO proteininfo VALUES ('6862571', 'NP_036194.1','Hypothetical ORF; Yhr132w-ap [Saccharomyces cerevisiae]','MSEDLSPTSSRVDLSNPHGFTKEGVDLSKLSPQELKLYKMYGKLPSKKDLLRHKMQDRQYFDSGDYALKKAGVIKSDDVIVNNSSNNLPVTNPSGLRESIIRRRMSSSSGGDSISRQGSISSGPPPRSPNK');
INSERT INTO proteininfo VALUES ('6681850', 'NP_014354.2','Interacts with YPT proteins; Yip3p [Saccharomyces cerevisiae]','MNQLGALAQVSRFTQNFSMENIKSEFQSLQSKLATLRTPQEFFNFKKISKPQNFGEVQSRVAYNLKYFSSNYGLIIGCLSIYTLLTNLLLLFVIVLVVAGIVGINKLKGEELVTPFGSFKTNQLYTGLVCVAVPIGFLASPISTLLWLIGASAVSVFGHASLMEKPIETVFDEETV');
INSERT INTO proteininfo VALUES ('6681849', 'NP_014237.2','Protein component of the large (60S) ribosomal subunit, identical to Rpl42Bp and has similarity to rat L44 ribosomal protein; Rpl42ap [Saccharomyces cerevisiae]','MVNVPKTRKTYCKGKTCRKHTQHKVTQYKAGKASLFAQGKRRYDRKQSGFGGQTKPVFHKKAKTTKKVVLRLECVKCKTRAQLTLKRCKHFELGGEKKQKGQALQF');
INSERT INTO proteininfo VALUES ('6681848', 'NP_012160.2','Mps One Binder; (putative) transcriptional regulator involved in mitosis; Mob1p [Saccharomyces cerevisiae]','MSFLQNFHISPGQTIRSTRGFKWNTANAANNAGSVSPTKATPHNNTINGNNNNANTINNRADFTNNPVNGYNESDHGRMSPVLTTPKRHAPPPEQLQNVTDFNYTPSHQKPFLQPQAGTTVTTHQDIKQIVEMTLGSEGVLNQAVKLPRGEDENEWLAVHCVDFYNQINMLYGSITEFCSPQTCPRMIATNEYEYLWAFQKGQPPVSVSAPKYVECLMRWCQDQFDDESLFPSKVTGTFPEGFIQRVIQPILRRLFRVYAHIYCHHFNEILELNLQTVLNTSFRHFCLFAQEFELLRPADFGPLLELVMELRDR');
INSERT INTO proteininfo VALUES ('6681847', 'NP_011741.2','Required for sporulation, highly induced during sporulation; activator of meiotic anaphase promoting complex; Required for sporulation; highly induced during sporulation; Ama1p [Saccharomyces cerevisiae]','MATPHLYHRYNSKSSNKNINSSGNSTEVDRFIPKSVSRNAYKSIPMLNGFDISYSELCEKSPSPERLSSPEFFNELRNTGHYESISTTNEFSMSSISSSSESQVTRSGSARASRNDYSKLTKEQKDHRKNIAHSLGFQLPDRVFTFETTSAEILEKNKAIKNCFGPGSCAEIRSTFDFSTLSPDVARYYIANSNARSASPQRQIQRPAKRVKSHIPYRVLDAPCLRNDFYSNLISWSRTTNNVLVGLGCSVYIWSEKEGAVSILDHQYLSEKRDLVTCVSFCPYNTYFIVGTKFGRILLYDQKEFFHSSNTNEKEPVFVFQTESFKGICCLEWFKPGEICKFYVGEENGNVSLFEIKSLHFPIKNWSKRQKLEDENLIGLKLHSTYQAQAQQVCGISLNEHANLLAVGGNDNSCSLWDISDLDKPIKKFVLPHKAAVKAIAFCPWSKSLLATGGGSKDRCIKFWHTSTGTLLDEICTSGQVTSLIWSLRHKQIVATFGFGDTKNPVLITLYSYPKLSKLLEVRSPNPLRVLSAVISPSSMAICVATNDETIRFMNCGTIRRK');
INSERT INTO proteininfo VALUES ('6681846', 'NP_011543.2','Flavin-linked sulfhydryl oxidase localized to the mitochondrial intermembrane space, has a role in the maturation of cytosolic iron-sulfur proteins; ortholog of human hepatopoietin (ALR); Erv1p [Saccharomyces cerevisiae]','MKAIDKMTDNPPQEGLSGRKIIYDEDGKPCRSCNTLLDFQYVTGKISNGLKNLSSNGKLAGTGALTGEASELMPGSRTYRKVDPPDVEQLGRSSWTLLHSVAASYPAQPTDQQKGEMKQFLNIFSHIYPCNWCAKDFEKYIRENAPQVESREELGRWMCEAHNKVNKKLRKPKFDCNFWEKRWKDGWDE');
INSERT INTO proteininfo VALUES ('6681845', 'NP_031358.1','Hypothetical ORF; Ybl059c-ap [Saccharomyces cerevisiae]','MHPQLEAERFHSCLDFINALDKCHQKEYYKRIFGLCNNEKDALNKCLKEASLNNKKRAVIESRIKRADVEKRWKKIEEEEYGEDAILKTILDRQYAKKKQESDNDANSK');
INSERT INTO proteininfo VALUES ('6579194', 'NP_013844.2','Large subunit of the nuclear cap-binding protein complex; transcriptional activator of glycolytic genes; Sto1p [Saccharomyces cerevisiae]','MFNRKRRGDFDEDENYRDFRPRMPKRQRIPPVVQLCKEMMPDIRTIGESVKAFEDDIKFLSEAIMNEYGHEDYFNNALLSTLNAVVVEQPQKQAAIALLTMVVNSKNNVAGKSIINYFFEELQKWCKQTYNDEFKSTSNETGPWNKIKLILRFLSILSPMFLVDELINIYKSLFELSIELNNLDPGNRVPLSEAIYTNTLLNIPYLFFFNRNNDGLRTKVEELLAYVEQNYLVKTTDINLLREYNGEPPYEMVELVRVVLPNVKKALINNLEQLNELFPDWNHLLTPQTGDEGFNDALTLPSVDDLKSFVRLNKNFGSVDSMWKTPRYAFHVYLPNSAGNFETVVPISTYAGQLFNDIIIDLVESLEFNRKEVARQVITLDLFFKAGIFTEPGESIAQLIATYEENPLAPTFKIEDLAIETILGLIFKLPSVSQPFAYFYTLLVDICQNSPKAIAPVFGRAFRFFYSHLDSLDFELKLRYLDWFSIQMSNFNFSWKWNEWEDDSIKFGKYFYNPKVNFAKNLIQKELRLTSNFSEVEDSLPQEFTKYLDTSYIPRDQLINYYQSLFTGYTVEEDSVRKNDLYFRQEGVPMENTVRKILDYTHKANNSREVTELESILGELKNEYGSIISDFNRFVIILLVQAVTDSGSRSLSHANKYINDLKEDLKTIFAKIELDIETKEYIIIEAVLTFWNANPQTGFLVADAFKYAGLLTSRTIFTFIFNETGLKNNGLIEATAIEAVFRNLSQQISEENESGNNFEFVFERLCTIANSTIDLLDVNADEDIEIPKVNGEMDIDDIEDDKLDLKWKYFTVIGFIKSILRRYSHEYRELADKFIANIDNAIPHESTRRTISNWIQETKEV');
INSERT INTO proteininfo VALUES ('6579193', 'NP_011944.2','Component of the nonsense-mediated mRNA decay (NMD) pathway; Highly acidic C-terminus; Nmd2p [Saccharomyces cerevisiae]','MDDGRKKELHDLNTRAWNGEEVFPLKSKKLDSSIKRNTGFIKKLKKGFVKGSESSLLKDLSEASLEKYLSEIIVTVTECLLNVLNKNDDVIAAVEIISGLHQRFNGRFTSPLLGAFLQAFENPSVDIESERDELQRITRVKGNLRVFTELYLVGVFRTLDDIESKDAIPNFLQKKTGRKDPLLFSILREILNYKFKLGFTTTIATAFIKKFAPLFRDDDNSWDDLIYDSKLKGALQSLFKNFIDATFARATELHKKVNKLQREHQKCQIRTGKLRDEYVEEYDKLLPIFIRFKTSAITLGEFFKLEIPELEGASNDDLKETASPMITNQILPPNQRLWENEDTRKFYEILPDISKTVEESQSSKTEKDSNVNSKNINLFFTDLEMADCKDIIDDLSNRYWSSYLDNKATRNRILKFFMETQDWSKLPVYSRFIATNSKYMPEIVSEFINYLDNGFRSQLHSNKINVKNIIFFSEMIKFQLIPSFMIFHKIRTLIMYMQVPNNVEILTVLLEHSGKFLLNKPEYKELMEKMVQLIKDKKNDRQLNMNMKSALENIITLLYPPSVKSLNVTVKTITPEQQFYRILIRSELSSLDFKHIVKLVRKAHWDDVAIQKVLFSLFSKPHKISYQNIPLLTKVLGGLYSYRRDFVIRCIDQVLENIERGLEINDYGQNMHRISNVRYLTEIFNFEMIKSDVLLDTIYHIIRFGHINNQPNPFYLNYSDPPDNYFRIQLVTTILLNINRTPAAFTKKCKLLLRFFEYYTFIKEQPLPKETEFRVSSTFKKYENIFGNTKFERSENLVESASRLESLLKSLNAIKSKDDRVKGSSASIHNGKESAVPIESITEDDEDEDDENDDGVDLLGEDEDAEISTPNTESAPGKHQAKQDESEDEDDEDDDEDDDDDDDDDDDDGEEGDEDDDEDDDDEDDDDEEEEDSDSDLEYGGDLDADRDIEMKRMYEEYERKLKDEEERKAEEELERQFQKMMQESIDARKSEKVVASKIPVISKPVSVQKPLLLKKSEEPSSSKETYEELSKPKKIAFTFLTKSGKKTQSRILQLPTDVKFVSDVLEEEEKLKTERNKIKKIVLKRSFD');
INSERT INTO proteininfo VALUES ('6579192', 'NP_010904.2','Ubiquitin-conjugating enzyme that negatively regulates gluconeogenesis by mediating the glucose-induced ubiquitination of fructose-1,6-bisphosphatase (FBPase); cytoplasmic enzyme that catalyzes the ubiquitination of histones in vitro; Ubc8p [Saccharomyces cerevisiae]','MSSSKRRIETDVMKLLMSDHQVDLINDSMQEFHVKFLGPKDTPYENGVWRLHVELPDNYPYKSPSIGFVNKIFHPNIDIASGSICLDVINSTWSPLYDLINIVEWMIPGLLKEPNGSDPLNNEAATLQLRDKKLYEEKIKEYIDKYATKEKYQQMFGGDNDSDDSDSGGDLQEEDSDSDEDMDGTGVSSGDDSVDELSEDLSDIDVSDDDDYDEVANQ');
INSERT INTO proteininfo VALUES ('6381999', 'NP_009311.2','Protein of unknown function, encoded within an intron of the mitochondrial COX1 gene; translational initiation codon is predicted to be ATA rather than ATG; Ai5_betap [Saccharomyces cerevisiae]','MLMLLMMILTNNKVFMETLYYYLMFNFQLMSPFGVPVPGPAPETKDIKNLYESIMNNYINILNKYTININKDNINKLKFLDNYTEEEKGYYLSGLFEGDGNIYTRCFSITFSLEDVLLANYLCTYFKIGHITAKYNFNKELTAVKWNIMKKKEQEVFMNYINGKLLTYKRYDQYFKYNFNNRLNIKLLKPKEFDLTLNPWLTGFNDADGYFYTGFQKHKNSQWLKFHLELSQKDSYILDIIKKYFKTGGILKRDYKSGATAYIYKAQSSKAMKPFIEYFNNYQPLSTRRYKQYLLLNIAYLLKLNKLHMLTNSLLMLKELMLLQSVKNMSLEMKNELNNRVKIIINKTHYNNIE');
INSERT INTO proteininfo VALUES ('6325462', 'NP_015530.1','subtelomerically-encoded DNA helicase; Ypr204wp [Saccharomyces cerevisiae]','MADTPSVAVQAPPGYGKTELFHLPLIALASKGDVKYVSFLFVPYTVLLANCMIRLGRCGCLNVAPVRNFIEEGCDGVTDLYVGIYDDLASTNFTDRIAAWENIVECTFRTNNVKLGYLIVDEFHNFETEVYRQSQFGGITNLDFDAFEKAIFLSGTAPEAVADAALQRIGLTGLAKKSMDINELKRSEDLSRGLSSYPTRMFNLIKEKSEVPLGHVHKIWKKVESQPEEALKLLLALFEIEPESKAIVVASTTNEVEELACSWRKYFRVVWIHGKLGAAEKVSRTKEFVTDGSMRVLIGTKLVTEGIDIKQLMMVIMLDNRLNIIELIQGVGRLRDGGLCYLLSRKNSWAARNRKGELPPIKEGCITEQVREFYGLESKKGKKGQHVGCCGSRTDLSADTVELIERMDRLAEKQATASMSIVALPSSFQESNSSDRCRKYCSSDEDSNTCIHGSANASTNATTNSSTNATTTASTNVRTSATTTASINVRTSATTTESTNSSTNATTTASTNVRTSATTTASINVRTSATTTESTNSNTSATTTESTDSNTSATTTESTNSSTNATTTASINVRTSATTTESTNSNTNATTTESTNSSTNATTTEGTNSNTSATTTASTNSSTNATTTESTNASAKEDANKDGNAEDNRFHPVTDINKESYKRKGSQMVLLERKKLKAQFPNTSENMNVLQFLGFRSDEIKHLFLYGIDVYFCPEGVFTQYGLCKGCQKMFELCVCWAGQKVSYRRMAWEALAVERMLRNDEEYKEYLEDIEPYHGDPVGYLKYFSVKRGEIYSQIQRNYAWYLAITRRRETISVLDSTRGKQGSQVFRMSGRQIKELYYKVWSNLRESKTEVLQYFLNWDEKKCREEWEAKDDTVFVEALEKVGVFQRLRSMTSAGLQGPQYVKLQFSRHHRQLRSRYELSLGMHLRDQLALGVTPSKVPHWTAFLSMLIGLFCNKTFRQKLEYLLEQISEVWLLPHWLDLANVEVLAADNTRVPLYMLMVAVHKELDSDDVPDGRFDILLCRDSSREVGE');
INSERT INTO proteininfo VALUES ('6325461', 'NP_015529.1','Hypothetical ORF; Ypr203wp [Saccharomyces cerevisiae]','MRTFTDFVSGAPIVRSLQKSTIRKYGYNLAPHMFLLLHVDELSIFSAYQASLPGEKKVDTERLKRDLCPRKPIEIKYFSQICNDMMNKKDRLGDVLHVCCPS');
INSERT INTO proteininfo VALUES ('6325460', 'NP_015528.1','similar to other subtelomerically-encoded proteins; Ypr202wp [Saccharomyces cerevisiae]','MEIENEQICTCIAQILHLLNSLIITFSDDDKTETGQSFVYIDGFLVKKHNNQHTIVNFETYKNKMKVSDRRKFEKANFDEFESALNNKNDLVHCPSITLFESIPTEVRSFYEDEKSGLIKVVKFRTGAMDRKRSFEKIVISVMVGKNVQKFLTFVEDEPDFQGGPIPSKYLIPKKINLMVYTLFQVHTLKFNRKDYDTLSLFYLNRGYYNELSFPCPGTLSRNSECQAERQLYDAYFH');
INSERT INTO proteininfo VALUES ('6325459', 'NP_015527.1','Arsenite transporter of the plasma membrane, required for resistance to arsenic compounds; transcription is activated by Arr1p in the presence of arsenite; Arr3p [Saccharomyces cerevisiae]','MSEDQKSENSVPSKVNMVNRTDILTTIKSLSWLDLMLPFTIILSIIIAVIISVYVPSSRHTFDAEGHPNLMGVSIPLTVGMIVMMIPPICKVSWESIHKYFYRSYIRKQLALSLFLNWVIGPLLMTALAWMALFDYKEYRQGIIMIGVARCIAMVLIWNQIAGGDNDLCVVLVITNSLLQMVLYAPLQIFYCYVISHDHLNTSNRVLFEEVAKSVGVFLGIPLGIGIIIRLGSLTIAGKSNYEKYILRFISPWAMIGFHYTLFVIFISRGYQFIHEIGSAILCFVPLVLYFFIAWFLTFALMRYLSISRSDTQRECSCDQELLLKRVWGRKSCEASFSITMTQCFTMASNNFELSLAIAISLYGNNSKQAIAATFGPLLEVPILLILAIVARILKPYYIWNNRN');
INSERT INTO proteininfo VALUES ('6325458', 'NP_015526.1','Arsenate reductase required for arsenate resistance; converts arsenate to arsenite which can then be exported from cells by Arr3p; Arr2p [Saccharomyces cerevisiae]','MVSFITSRQLKGLIENQRKDFQVVDLRREDFARDHITNAWHVPVTAQITEKQLNQLIKGLSDTFSSSQFVKVIFHCTGSKNRGPKVAAKFETYLQEEDITSKFESCILVGGFYAWETHCRESNLKLIVSG');
INSERT INTO proteininfo VALUES ('6325457', 'NP_015525.1','Transcriptional activator of the bZIP family, required for transcription of genes involved in resistance to arsenic compounds; Arr1p [Saccharomyces cerevisiae]','MAKPRGRKGGRKPSLTPPKNKRAAQLRASQNAFRKRKLERLEELEKKEAQLTVTNDQIHILKKENELLHFMLRSLLTERNMPSDERNISKACCEEKPPTCNTLDGSVVLSSTYNSLEIQQCYVFFKQLLSVCVGKNCTVPSPLNSFDRSFYPIGCTNLSNDIPGYSFLNDAMSEIHTFGDFNGELDSTFLEFSGTEIKEPNNFITENTNAIETAAASMVIRQGFHPRQYYTVDAFGGDVLLSAMDIWSFMKVHPKVNTFDLEILGTELKKSATCSNFDILISLKHFIKVFSSKL');
INSERT INTO proteininfo VALUES ('6325455', 'NP_015524.1','Member of drug-resistance protein family; multicopy suppressor of gal11 null mutation; Sge1p [Saccharomyces cerevisiae]','MKSTLSLTLCVISLLLTLFLAALDIVIVVTLYDTIGIKFHDFGNIGWLVTGYALSNAVFMLLWGRLAEILGTKECLMISVIVFEIGSLISALSNSMATLISGRVVAGFGGSGIESLAFVVGTSIVRENHRGIMITALAISYVIAEGVGPFIGGAFNEHLSWRWCFYINLPIGAFAFIILAFCNTSGEPHQKMWLPSKIKKIMNYDYGELLKASFWKNTFEVLVFKLDMVGIILSSAGFTLLMLGLSFGGNNFPWNSGIIICFFTVGPILLLLFCAYDFHFLSLSGLHYDNKRIKPLLTWNIASNCGIFTSSITGFLSCFAYELQSAYLVQLYQLVFKKKPTLASIHLWELSIPAMIATMAIAYLNSKYGIIKPAIVFGVLCGIVGSGLFTLINGELSQSIGYSILPGIAFGSIFQATLLSSQVQITSDDPDFQNKFIEVTAFNSFAKSLGFAFGGNMGAMIFTASLKNQMRSSQLNIPQFTSVETLLAYSTEHYDGPQSSLSKFINTAIHDVFYCALGCYALSFFFGIFTSSKKTTISAKKQQ');
INSERT INTO proteininfo VALUES ('6325454', 'NP_015522.1','nuclear protein (putative); Ypr196wp [Saccharomyces cerevisiae]','MSIVRQSCDCCRVRRVKCDRNRPCDRCRQRNLRCTYLQPLRKRGPKSIGESNLERAAEIQMVTVNNNIMAAPVMYKKVPKKVIDQCLRLYHDQLYVIWPMLSYDDLYKLLEENYEDCSTYWFLVSLSAATLSDLHTKIEYKKGFFFAGEQLCNLCMSSRRFFDDLSNSDIFRIMTYYCLHRCYAQFADTRTSYRLSCEAIGLIKIAGFHREETYEFLPFGEQQLIRKVYYLLLMTERYYAVYIKCVTSLDTTISPPQPEIVTDSRLSLDSFLEVIKVFTVPGKYFYDALATNSVNGSYTEDSLKRIWNELHISSLDIEPYSYGYIDYLFSRHWVRTLAWKLVLNKKDMRMNFFSNTNATHIPVEIAKDMLQDTLLTPIDLYDVHGPVIPMKALEIANALVDVVSKYDHNMKLEAWNILCDVSKFVFSLKHCNHKMFQRFSTKCQSALIDLPISRPLRLNDDSKDEVDIIP');
INSERT INTO proteininfo VALUES ('6325452', 'NP_015520.1','Oligopeptide transporter; member of the OPT family, with potential orthologs in S. pombe and C. albicans; Opt2p [Saccharomyces cerevisiae]','MSETVKDKVIIDEKVSTKGTVDYAEGAEYSERLSNHSSDFSQWYTDEQILHFMKKLGYENRTLYDIPEDVAYILKKMPELTLEDSFKILKDSIIYFKDDENIPHDQYEEWKRLVDLEDLDSKEGIDEYDSFDIRAFASAIKFHSPYQEVRAVVDPEDDPTIPVETFRAYFLAIIWSVIGSGFNEFFSHRVVSISLNTPIIQMFLYICGKAWAKTIPCWTITIRGRKYGINIDKPWTQKEQMFSTLLYAICQGAFYTHYNILTQKLFYHSAFSFGYQFLLSLSVQFIGFGFAGILRKFVVYPARALWPTVMPTIAINKALLGKEKHESGMSRYKFFFLTFFIMFIYNWFPTYIINILNTFNWMTWIKPSNINLANITGGVTGLGINPISSFDWNVISFNSPLVYPFWSYLTQYLGCILAALIVIAVYYSNYMSCQYLPIFTNSLYTNTGHSFKVTEVLDSDNKLDVKKYQSYSPPYYSAGNLVSYGAFICAYPLMITWSFIVHSKLLFNAFKDWALNLWAMRKLKSWVTMFKSDYRALDDYDDPHSNAMKNYKEVPDWWYFAILIGSLVVGIAVVEHYPTNTPVWGLFVCLGFNFVFLIPTTILQATTGYSFGLNLLIEMVMGYALPGNPIAIMILKAFGYNIDGQADNYVSNLKIAHYCKIPPMALFRGQCVIVFIQIFVNLGVLNWQISNIKDFCTPHQNAKFTCPDAVTYYNASVVWGAIGPKRIFNYIYPIFKWCWLIGACIGIFFGVWKRWGKFYPRYFDPMLFVGGMLNMSPPYNLMYYTSGMIVSYISQYYMKRHHLNLWEKYNYVLSAGFSTGLVLSAIIIFFAVQYKDTAFNWWGNTVPYAGADGVGYPLKNITDTANGYFGYAPGHYP');
INSERT INTO proteininfo VALUES ('6325451', 'NP_015519.1','Tetrameric histone acetyltransferase with similarity to Gcn5p, Hat1p, Elp3p, and Hpa3p; acetylates histones H3 and H4 in vitro and exhibits autoacetylation activity; Hpa2p [Saccharomyces cerevisiae]','MSNTSEDNITVRFVTENDKEGWQRLWKSYQDFYEVSFPDDLDDFNFGRFLDPNIKMWAAVAVESSSEKIIGMINFFNHMTTWDFKDKIYINDLYVDENSRVKGAGGKLIQFVYDEADKLGTPSVYWCTDESNHRAQLLYVKVGYKAPKILYKRKGY');
INSERT INTO proteininfo VALUES ('6325450', 'NP_015518.1','Water channel that mediates the transport of water across cell membranes and may be involved in freeze tolerance; Aqy1p [Saccharomyces cerevisiae]','MSSNDSNDTDKQHTRLDPTGVDDAYIPPEQPETKHHRFKISRDTLRDHFIAAVGEFCGTFMFLWCAYVICNVANHDVALVAAPDGSHPGQLIMIAIGFGFSVMFSIWCFAGVSGGALNPAMSLSLCLARAVSPTRCVVMWVSQIVAGMAAGGAASAMTPGEVLFANSLGLGCSRTRGLFLEMFGTAILCLTVLMTAVEKRETNFMAALPIGISLFIAHVALTAYTGTGVNPARSLGAAVAARYFPHYHWIYWIGTLLGSILAWSVWQLLQILDYTTYVTAEKAASTKEKAQKKGETSSSSAVAEV');
INSERT INTO proteininfo VALUES ('6325449', 'NP_015517.1','40 kDa ubiquinol cytochrome-c reductase core protein 2; Qcr2p [Saccharomyces cerevisiae]','MLSAARLQFAQGSVRRLTVSARDAPTKISTLAVKVHGGSRYATKDGVAHLLNRFNFQNTNTRSALKLVRESELLGGTFKSTLDREYITLKATFLKDDLPYYVNALADVLYKTAFKPHELTESVLPAARYDYAVAEQCPVKSAEDQLYAITFRKGLGNPLLYDGVERVSLQDIKDFADKVYTKENLEVSGENVVEADLKRFVDESLLSTLPAGKSLVSKSEPKFFLGEENRVRFIGDSVAAIGIPVNKASLAQYEVLANYLTSALSELSGLISSAKLDKFTDGGLFTLFVRDQDSAVVSSNIKKIVADLKKGKDLSPAINYTKLKNAVQNESVSSPIELNFDAVKDFKLGKFNYVAVGDVSNLPYLDEL');
INSERT INTO proteininfo VALUES ('6325448', 'NP_015516.1','RNA polymerase III subunit C82; Rpc82p [Saccharomyces cerevisiae]','MDELLGEALSAENQTGESTVESEKLVTPEDVMTISSLEQRTLNPDLFLYKELVKAHLGERAASVIGMLVALGRLSVRELVEKIDGMDVDSVKTTLVSLTQLRCVKYLQETAISGKKTTYYYYNEEGIHILLYSGLIIDEIITQMRVNDEEEHKQLVAEIVQNVISLGSLTVEDYLSSVTSDSMKYTISSLFVQLCEMGYLIQISKLHYTPIEDLWQFLYEKHYKNIPRNSPLSDLKKRSQAKMNAKTDFAKIINKPNELSQILTVDPKTSLRIVKPTVSLTINLDRFMKGRRSKQLINLAKTRVGSVTAQVYKIALRLTEQKSPKIRDPLTQTGLLQDLEEAKSFQDEAELVEEKTPGLTFNAIDLARHLPAELDLRGSLLSRKPSDNKKRSGSNAAASLPSKKLKTEDGFVIPALPAAVSKSLQESGDTQEEDEEEEDLDADTEDPHSASLINSHLKILASSNFPFLNETKPGVYYVPYSKLMPVLKSSVYEYVIASTLGPSAMRLSRCIRDNKLVSEKIINSTALMKEKDIRSTLASLIRYNSVEIQEVPRTADRSASRAVFLFRCKETHSYNFMRQNLEWNMANLLFKKEKLKQENSTLLKKANRDDVKGRENELLLPSELNQLKMVNERELNVFARLSRLLSLWEVFQMA');
INSERT INTO proteininfo VALUES ('6325447', 'NP_015515.1','dsRNA virus protection family member, contains 8 copies of the tetratricopeptide (TPR) domain; Ski3p [Saccharomyces cerevisiae]','MSDIKQLLKEAKQELTNRDYEETIEISEKVLKLDPDNYFAHIFLGKALSSLPASNNVSSNRNLERATNHYVSAAKLVPDNLLAWKGLFLLFRTTEVVPDILSYDEYFDLCGQYADALLKQEQSQVELINDIKLLKKTHPDCQKAFYQHLKPGSLMAETIGRHLSTPQDALLNLIKILSNIETTEIGKTLSQNRLKLKASDPDYQIKLNSFSWEIIKNSEIDQLYNQLVNILADDQKRSEIENQWLEYRIKVLKSMPLDVKKDFFTKVKEMVEDMVLVNHQSLLAWQKYFEWTDYEDLDNMDAPLIIKYFKKFPKDPLAMILYSWLSSKLSKYDIKSLESANKPPEGHKKTEKETDIKDVDETNEDEVKDRVEDEVKDRVEDEVKDQDEEAKEDEEEDLDDIEIGLLEEEVVTVLTENIVKCKNNILAHRILCQYYLLTKEYEAALPYIKNGISLIAYNIKDLGVHLPLTKREFSLDLATVYTYVDAPKDHNAALKLYDNILSGDFSNIQAKMGKGIIFIERKNWKDAMTLLTQVHEQSPNNLEVLSELSWSKAHMGYMDEALAGLDTVIKGIKGMDLRSIDFRALNLWRQAKVYIMKHASINDAKQENVKCAFKLLIQSIKILDTFAPGFSTLGDIYCHYYKDHLRAFKCYFKAFDLDAGDYTAAKYITETYASKPNWQAASSIASRLIKGEKAKAELRSNNWPFRVVGIAHLEKQEESDSIEWFQSALRVDPNDVESWVGLGQAYHACGRIEASIKVFDKAIQLRPSHTFAQYFKAISLCDVGEYLESLDILEKVCQEAATEESFQIGLVEVLMRCSLDLYSQGFLLKSVSIAKDTIERIKIIISELKCENQQVWIYLSQVLRLFIWIESKVDTLPVESLVSIFENSQFSGSEEIDSVDNIKIDTLLDSTTDDNVSIACKFLILASKYSVSDQKFTDIAGTVRASYWYNIGISELTAFITLKEPQYRDAAIFAFKKSIQLQSNTSETWIGLGIATMDINFRVSQHCFIKATALEPKATNTWFNLAMLGLKKKDTEFAQQVLNKLQSLAPQDSSPWLGMALILEEQGDIIGSSKLFAHSFILSNGRSKAAQFMYAKNVLENHINNGDDERDIETVEKLTTASIALEQFFKKSPDSQFALQCALLTLERLHHYENANELANRLIGILEKKFEKTQDERELFNFAIIKGQFARIHLGLGNFELSIENADLSQGIISESSDEKSMKTKISNHICLGLSYFFLNDFDQTLNQFQELLSISKDSKHLVVLIAKVLYDVGESDTKEIALQELTEYIATSGADLLVTLTIAAMSILDDKREDLSIILEELKALPLSKQIIDKHKDAPYLIEEITKRLYRNDTGKQVWQRSAYFFPNNLKVWERLDKNIQRRIASNGQNKVTAEEMSKLYCESKNLRSIQRGMFLCPWNVTAVKALNECF');
INSERT INTO proteininfo VALUES ('6325446', 'NP_015514.1','Regulatory light chain for the type II myosin, Myo1p; binds to an IQ motif of Myo1p, localization to the bud neck depends on Myo1p; involved in the disassembly of the Myo1p ring; putative light chain for Myo1p; Mlc2p [Saccharomyces cerevisiae]','MDHSESLTFNQLTQDYINKLKDAFQMLDEDEDGLISRGDLTKIYATLGKTLTDEEWSKMVPDNDTSTAEVGEEGVSFPIFLSIMGKNLSQFPEREELEESLKAIGRGHDLNVPLNEVIDSLKEAGFENPEEEFAKLFKLFTTNQQATEERTFRGKLFLDSITD');
INSERT INTO proteininfo VALUES ('6325445', 'NP_015513.1','subunit common to RNA polymerases I, II, and III; Rpo26p [Saccharomyces cerevisiae]','MSDYEEAFNDGNENFEDFDVEHFSDEETYEEKPQFKDGETTDANGKTIVTGGNGPEDFQQHEQIRRKTLKEKAIPKDQRATTPYMTKYERARILGTRALQISMNAPVFVDLEGETDPLRIAMKELAEKKIPLVIRRYLPDGSFEDWSVEELIVDL');
INSERT INTO proteininfo VALUES ('6325444', 'NP_015512.1','Transcription factor IIIA (TFIIIA) with putative Zn-fingers; Pzf1p [Saccharomyces cerevisiae]','MGGEVLNNEGMPLAELKQETIPISRSESSESLNSLTSTRSSSSNRPKTYFCDYDGCDKAFTRPSILTEHQLSVHQGLRAFQCDKCAKSFVKKSHLERHLYTHSDTKPFQCSYCGKGVTTRQQLKRHEVTHTKSFICPEEGCNLRFYKHPQLRAHILSVHLHKLTCPHCNKSFQRPYRLRNHISKHHDPEVENPYQCTFAGCCKEFRIWSQLQSHIKNDHPKLKCPICSKPCVGENGLQMHMIIHDDSLVTKNWKCHICPDMSFSRKHDLLTHYGSIHTEEDIPLELKYKISDIQQLVQDHGVQLGNSKHSNEQDEEKISNRLRKRRKLTENNNVEFLQNEVDLEKRLESGENGLNLLLNTVGRKYRCFYNNCSRTFKTKEKYEKHIDKHKVHELKLKILQEKEENKTLVDQNHKEPFIIQKETQSAGDK');
INSERT INTO proteininfo VALUES ('6325443', 'NP_015511.1','Phosphorylated protein that interacts with Vac8p, required for the cytoplasm-to-vacuole targeting (Cvt) pathway and autophagy; Atg13p [Saccharomyces cerevisiae]','MVAEEDIEKQVLQLIDSFFLKTTLLICSTESSRYQSSTENIFLFDDTWFEDHSELVSELPEIISKWSHYDGRKELPPLVVETYLDLRQLNSSHLVRLKDHEGHLWNVCKGTKKQEIVMERWLIELDNSSPTFKSYSEDETDVNELSKQLVLLFRYLLTLIQLLPTTELYQLLIKSYNGPQNEGSSNPITSTGPLVSIRTCVLDGSKPILSKGRIGLSKPIINTYSNALNESNLPAHLDQKKITPVWTKFGLLRVSVSYRRDWKFEINNTNDELFSARHASVSHNSQGPQNQPEQEGQSDQDIGKRQPQFQQQQQPQQQQQQQQQQQRQHQVQTQQQRQIPDRRSLSLSPCTRANSFEPQSWQKKVYPISRPVQPFKVGSIGSQSASRNPSNSSFFNQPPVHRPSMSSNYGPQMNIEGTSVGSTSKYSSSFGNIRRHSSVKTTENAEKVSKAVKSPLQPQESQEDLMDFVKLLEEKPDLTIKKTSGNNPPNINISDSLIRYQNLKPSNDLLSEDLSVSLSMDPNHTYHRGRSDSHSPLPSISPSMHYGSLNSRMSQGANASHLIARGGGNSSTSALNSRRNSLDKSSNKQGMSGLPPIFGGESTSYHHDNKIQKYNQLGVEEDDDDENDRLLNQMGNSATKFKSSISPRSIDSISSSFIKSRIPIRQPYHYSQPTTAPFQAQAKFHKPANKLIDNGNRSNSNNNNHNGNDAVGVMHNDEDDQDDDLVFFMSDMNLSKEG');
INSERT INTO proteininfo VALUES ('6325442', 'NP_015510.1','Glycogen debranching enzyme containing glucanotranferase and alpha-1,6-amyloglucosidase activities, required for glycogen degradation; Gdb1p [Saccharomyces cerevisiae]','MNRSLLLRLSDTGEPITSCSYGKGVLTLPPIPLPKDAPKDQPLYTVKLLVSAGSPVARDGLVWTNCPPDHNTPFKRDKFYKKIIHSSFHEDDCIDLNVYAPGSYCFYLSFRNDNEKLETTRKYYFVALPMLYINDQFLPLNSIALQSVVSKWLGSDWEPILSKIAAKNYNMVHFTPLQERGESNSPYSIYDQLQFDQEHFKSPEDVKNLVEHIHRDLNMLSLTDIVFNHTANNSPWLVEHPEAGYNHITAPHLISAIELDQELLNFSRNLKSWGYPTELKNIEDLFKIMDGIKVHVLGSLKLWEYYAVNVQTALRDIKAHWNDESNESYSFPENIKDISSDFVKLASFVKDNVTEPNFGTLGERNSNRINVPKFIQLLKLINDGGSDDSESSLATAQNILNEVNLPLYREYDDDVSEILEQLFNRIKYLRLDDGGPKQGPVTVDVPLTEPYFTRFKGKDGTDYALANNGWIWNGNPLVDFASQNSRAYLRREVIVWGDCVKLRYGKSPEDSPYLWERMSKYIEMNAKIFDGFRIDNCHSTPIHVGEYFLDLARKYNPNLYVVAELFSGSETLDCLFVERLGISSLIREAMQAWSEEELSRLVHKHGGRPIGSYKFVPMDDFSYPADINLNEEHCFNDSNDNSIRCVSEIMIPKILTATPPHALFMDCTHDNETPFEKRTVEDTLPNAALVALCSSAIGSVYGYDEIFPHLLNLVTEKRHYDISTPTGSPSIGITKVKATLNSIRTSIGEKAYDIEDSEMHVHHQGQYITFHRMDVKSGKGWYLIARMKFSDNDDPNETLPPVVLNQSTCSLRFSYALERVGDEIPNDDKFIKGIPTKLKELEGFDISYDDSKKISTIKLPNEFPQGSIAIFETQQNGVDESLDHFIRSGALKATSSLTLESINSVLYRSEPEEYDVSAGEGGAYIIPNFGKPVYCGLQGWVSVLRKIVFYNDLAHPLSANLRNGHWALDYTISRLNYYSDEAGINEVQNWLRSRFDRVKKLPSYLVPSYFALIIGILYGCCRLKAIQLMSRNIGKSTLFVQSLSMTSIQMVSRMKSTSILPGENVPSMAAGLPHFSVNYMRCWGRDVFISLRGMLLTTGRFDEAKAHILAFAKTLKHGLIPNLLDAGRNPRYNARDAAWFFLQAVQDYVYIVPDGEKILQEQVTRRFPLDDTYIPVDDPRAFSYSSTLEEIIYEILSRHAKGIKFREANAGPNLDRVMTDKGFNVEIHVDWSTGLIHGGSQYNCGTWMDKMGESEKAGSVGIPGTPRDGAAIEINGLLKSALRFVIELKNKGLFKFSDVETQDGGRIDFTEWNQLLQDNFEKRYYVPEDPSQDADYDVSAKLGVNRRGIYRDLYKSGKPYEDYQLRPNFAIAMTVAPELFVPEHAIKAITIADEVLRGPVGMRTLDPSDYNYRPYYNNGEDSDDFATSKGRNYHQGPEWVWLYGYFLRAFHHFHFKTSPRCQNAAKEKPSSYLYQQLYYRLKGHRKWIFESVWAGLTELTNKDGEVCNDSSPTQAWSSACLLDLFYDLWDAYEDDS');
INSERT INTO proteininfo VALUES ('6325441', 'NP_015509.1','Dolichol phosphate mannose (Dol-P-Man) synthase of the ER membrane, catalyzes the formation of Dol-P-Man from Dol-P and GDP-Man; required for glycosyl phosphatidylinositol membrane anchoring, O mannosylation, and protein glycosylation; Dpm1p [Saccharomyces cerevisiae]','MSIEYSVIVPAYHEKLNIKPLTTRLFAGMSPEMAKKTELIFVDDNSQDGSVEEVDALAHQGYNVRIIVRTNERGLSSAVLKGFYEAKGQYLVCMDADLQHPPETVPKLFESLHDHAFTLGTRYAPGVGIDKDWPMYRRVISSTARMMARPLTIASDPMSGFFGLQKKYLENCNPRDINSQGFKIALELLAKLPLPRDPRVAIGEVPFTFGVRTEGESKLSGKVIIQYLQQLKELYVFKFGANNLILFITFWSILFFYVCYQLYHLVF');
INSERT INTO proteininfo VALUES ('6325440', 'NP_015508.1','Sm or Sm-like snRNP protein; Smx3p [Saccharomyces cerevisiae]','MSESSDISAMQPVNPKPFLKGLVNHRVGVKLKFNSTEYRGTLVSTDNYFNLQLNEAEEFVAGVSHGTLGEIFIRCNNVLYIRELPN');
INSERT INTO proteininfo VALUES ('6325439', 'NP_015507.1','cytoplasmic GTPase-activating protein; Sec23p [Saccharomyces cerevisiae]','MDFETNEDINGVRFTWNVFPSTRSDANSNVVPVGCLYTPLKEYDELNVAPYNPVVCSGPHCKSILNPYCVIDPRNSSWSCPICNSRNHLPPQYTNLSQENMPLELQSTTIEYITNKPVTVPPIFFFVVDLTSETENLDSLKESIITSLSLLPPNALIGLITYGNVVQLHDLSSETIDRCNVFRGDREYQLEALTEMLTGQKPTGPGGAASHLPNAMNKVTPFSLNRFFLPLEQVEFKLNQLLENLSPDQWSVPAGHRPLRATGSALNIASLLLQGCYKNIPARIILFASGPGTVAPGLIVNSELKDPLRSHHDIDSDHAQHYKKACKFYNQIAQRVAANGHTVDIFAGCYDQIGMSEMKQLTDSTGGVLLLTDAFSTAIFKQSYLRLFAKDEEGYLKMAFNGNMAVKTSKDLKVQGLIGHASAVKKTDANNISESEIGIGATSTWKMASLSPYHSYAIFFEIANTAANSNPMMSAPGSADRPHLAYTQFITTYQHSSGTNRIRVTTVANQLLPFGTPAIAASFDQEAAAVLMARIAVHKAETDDGADVIRWLDRTLIKLCQKYADYNKDDPQSFRLAPNFSLYPQFTYYLRRSQFLSVFNNSPDETAFYRHIFTREDTTNSLIMIQPTLTSFSMEDDPQPVLLDSISVKPNTILLLDTFFFILIYHGEQIAQWRKAGYQDDPQYADFKALLEEPKLEAAELLVDRFPLPRFIDTEAGGSQARFLLSKLNPSDNYQDMARGGSTIVLTDDVSLQNFMTHLQQVAVSGQA');
INSERT INTO proteininfo VALUES ('6325438', 'NP_015506.1','Nuclear protein that acts as a heterodimer with Uba2p to activate Smt3p (SUMO) before its conjugation to proteins (sumoylation), which may play a role in protein targeting; essential for viability; Aos1p [Saccharomyces cerevisiae]','MDMKVEKLSEDEIALYDRQIRLWGMTAQANMRSAKVLLINLGAIGSEITKSIVLSGIGHLTILDGHMVTEEDLGSQFFIGSEDVGQWKIDATKERIQDLNPRIELNFDKQDLQEKDEEFFQQFDLVVATEMQIDEAIKINTLTRKLNIPLYVAGSNGLFAYVFIDLIEFISEDEKLQSVRPTTVGPISSNRSIIEVTTRKDEEDEKKTYERIKTKNCYRPLNEVLSTATLKEKMTQRQLKRVTSILPLTLSLLQYGLNQKGKAISFEQMKRDAAVWCENLGVPATVVKDDYIQQFIKQKGIEFAPVAAIIGGAVAQDVINILGKRLSPLNNFIVFDGITLDMPLFEF');
INSERT INTO proteininfo VALUES ('6325437', 'NP_015505.1','Subunit of a possibly tetrameric trichostatin A-sensitive class II histone deacetylase complex that contains an Hda1p homodimer and an Hda2p-Hda3p heterodimer; required for the activity of the complex; has similarity to Hda2p; Hda3p [Saccharomyces cerevisiae]','MDLLRILDTKPIPTIVDATTLGISGNTSGDYWLPTTMSLYQKELTDQIVSLHYSDILRYFETSHYKEDVILESMKTMCLNGSLVATHPYLLIDHYMPKSLITRDVPAHLAENSGKFSVLRDLINLVQEYETETAIVCRPGRTMDLLEALLLGNKVHIKRYDGHSIKSKQKANDFSCTVHLFSSEGINFTKYPIKSKARFDMLICLDTTVDTSQKDIQYLLQYKRERKGLERYAPIVRLVAINSIDHCRLFFGKKFDKNSREYLENVTAAMVILRDRLGTLPPDLRPIYSQKLHYLVEWLENPTVPWPLPDIYPLKQYTSMDVERSLLTEVHFKKSDDQLEDAFSNCSKKRGRHGANKAASSTVAGIEDNITPSFYSTKRLKNDYYTNPLKQDMTQLTGITTADNSSNVNYHLSSGIITHKLIQSMGEVYMDICVQKQELDDYSCLDDLQNDHLKFFSNEDEKIIKEYETVLRTNNENLNRSHELEVENNLKFSQIETLEKDIETLKGSLMAQGETLSKLKDAFVKTDNVQDEIEKEERVSVSRDTEKKYMEQEIKRAVDAIRENEEETHKLNEKQNGLESELKLKFEKSEISTKELNEKIGFLKKELKLENDLNEELVGQLSKTMDNLENLTIPRVRTQNGNTKKKSRAKKPGNV');
INSERT INTO proteininfo VALUES ('6325435', 'NP_015504.1','Splicing factor, component of the U4/U6-U5 snRNP complex; Prp4p [Saccharomyces cerevisiae]','MSKYIALENLPVDLQHKGATQNESTADILKQLPHERLQAVLEKIPEEDLEVRRLLSILKKPEVVENEDVQQRRIRLAEILMVDEIDLENINNMENINGEEVDEEDDEDFFTPATSELIFARRFLINYSLERSRKRLQKEMERHQKFNTRQELLSRRTELQRMANLELAGSQLVSTKPISAVSLSTDDMVVATGSWAGDLQVLNSQTLQPLTQKLDSHVGKIGAIDWHPDSNNQMISCAEDGLIKNFQYSNEEGGLRLLGDLVGHERRISDVKYHPSGKFIGSASHDMTWRLWDASTHQELLLQEGHDKGVFSLSFQCDGSLVCSGGMDSLSMLWDIRSGSKVMTLAGHSKPIYTVAWSPNGYQVATGGGDGIINVWDIRKRDEGQLNQILAHRNIVTQVRFSKEDGGKKLVSCGYDNLINVYSSDTWLKMGSLAGHTDKIISLDISNNSHFLVSGGWDRSIKLWN');
INSERT INTO proteininfo VALUES ('6325434', 'NP_015502.1','Beta subunit of Type II geranylgeranyltransferase required for vesicular transport between the endoplasmic reticulum and the Golgi; provides a membrane attachment moiety to Rab-like proteins Ypt1p and Sec4p; Bet2p [Saccharomyces cerevisiae]','MSGSLTLLKEKHIRYIESLDTKKHNFEYWLTEHLRLNGIYWGLTALCVLDSPETFVKEEVISFVLSCWDDKYGAFAPFPRHDAHLLTTLSAVQILATYDALDVLGKDRKVRLISFIRGNQLEDGSFQGDRFGEVDTRFVYTALSALSILGELTSEVVDPAVDFVLKCYNFDGGFGLCPNAESHAAQAFTCLGALAIANKLDMLSDDQLEEIGWWLCERQLPEGGLNGRPSKLPDVCYSWWVLSSLAIIGRLDWINYEKLTEFILKCQDEKKGGISDRPENEVDVFHTVFGVAGLSLMGYDNLVPIDPIYCMPKSVTSKFKKYPYK');
INSERT INTO proteininfo VALUES ('6325432', 'NP_015500.1','Protein of unknown function; green fluorescent protein (GFP)-fusion protein localizes to the nuclear periphery; potential Cdc28p substrate; Ypr174cp [Saccharomyces cerevisiae]','MGIQEKTLGIRKERKLVVVPRERNHVRHASQRTRSKNYKNISKKRAQQHAFGFNIAKTLAKIQAFVWGSPADEEEESVVPLSKNSQDCVPLQWQAKFAQLRQQLHSTQKELQFVKEKCHLLQSVLDDANIDQRYLESRRDMKNIERDNLKPTENLPPSPVRAVNPLVTSSPIHMSPLQSRQRPVSSLQPPKGPNFYAKYPKLPQTNILRESPTEDSVPHAE');
INSERT INTO proteininfo VALUES ('6325431', 'NP_015499.1','Defective in vacuolar protein sorting; homologous to mouse SKD1 and to human hVPS4; AAA-type ATPase; Vps4p [Saccharomyces cerevisiae]','MSTGDFLTKGIELVQKAIDLDTATQYEEAYTAYYNGLDYLMLALKYEKNPKSKDLIRAKFTEYLNRAEQLKKHLESEEANAAKKSPSAGSGSNGGNKKISQEEGEDNGGEDNKKLRGALSSAILSEKPNVKWEDVAGLEGAKEALKEAVILPVKFPHLFKGNRKPTSGILLYGPPGTGKSYLAKAVATEANSTFFSVSSSDLVSKWMGESEKLVKQLFAMARENKPSIIFIDEVDALTGTRGEGESEASRRIKTELLVQMNGVGNDSQGVLVLGATNIPWQLDSAIRRRFERRIYIPLPDLAARTTMFEINVGDTPCVLTKEDYRTLGAMTEGYSGSDIAVVVKDALMQPIRKIQSATHFKDVSTEDDETRKLTPCSPGDDGAIEMSWTDIEADELKEPDLTIKDFLKAIKSTRPTVNEDDLLKQEQFTRDFGQEGN');
INSERT INTO proteininfo VALUES ('6325430', 'NP_015498.1','Protein of unknown function, transcriptionally activated by Yrm1p along with genes involved in multidrug resistance; Ypr172wp [Saccharomyces cerevisiae]','MAWTSTLPAHLLNLIKNSKYVHVATCSKDCIPSVALMNYIYVPGEKLFGQTDNKNDYIIFVSPQDTQKFYNIKENPKVALLFHDWIIANNLSVGKESISGTPTPTSIPHEEQRQSELLNLLQELNQAELNQMSASIGGETEIVNPESEESKYYKDLILKANPDAKAFIFEKNTAVVKVRIDNARVSNNENRTMFLSKGKS');
INSERT INTO proteininfo VALUES ('6325429', 'NP_015497.1','Binding protein of Synaptojanin Polyphosphoinositide phosphatase domain; may function to link synaptojanins Inp52p and Inp53p to the cortical actin cytoskeleton; Bsp1p [Saccharomyces cerevisiae]','MTKYERDPELVNFLSKVEDLNSKRYSNIPSSKPAGEALSPVRSHNSGEYRRADMMTGKNVEGCDNLAYRSAYNYEMTFSPKKTHYSLSELNLERITPRPDLEGSASQKEKKFLISEEDYLLLQKLKASQTYNDSNADKNLPSFEKGPRMPSRGRPRPREKEIITIQYDFELPGRADIPSSSSSSSPPPLPTRRDHIKITDGNEEKPLLPTRPNKAEVTESPSSRSIKPDAVVPERVKPAPPVSRSTKPASFLSSLEDNKLTKAKSYNSEMETPKTTVKSSHIDYLDSIQLKPTTLSPTMKNKPKPTPPSPPAKRIPRSESFIKSMLNSNLTTTSKPSLPEKPQKLRNANLAAHKTKPSIPPKKVELNIVLPELRPVETSPTKQNFENSIDLPKLRSSNRNIKKEEEDSIPEAIKGIQNLKKTKQQKPAIPQKKSFLTNNSKNTTLKNGDDINKLNDEIEALSLRNNLKKRPPTAPQRKISLPEALRKVELMKKSKTEPVLESSNELSINAKLDAIIASRNLRASNTLPELSGVNTNIATSDKYTTSRDETVKETKPLVHPNKNRTRGPRRKLPTRV');
INSERT INTO proteininfo VALUES ('6325427', 'NP_015495.1','Nucleolar protein of unknown function, exhibits a physical interaction with Bre1p; Jip5p [Saccharomyces cerevisiae]','MASSPQLEEEAAGKLETIHASAMAKSKKKTDVVDSTNLPILELLSLKAPIFQSLLHPELPIIITGFGTGHIVCHRYDPAKLQSHLDRRRRIDTATTGKDAKKGVCPWIRLDIDLETGDLKFVDIEEQQQQKQTGKDEDLGVKTLWKTKRHKGSVRAMCFDSKGDNIFSVGSDNVLKKANTMTGKVVKKVNLSSLFNSEEKKNDKFTKLCASQTHPFILIGDESGNIHVINSENLALSNSIRSIHFGDSINDIFHFDKRSAYKFISLGQTTLAYFDVRDKDAKPNVAGNEDGKILISDDQEDEVLCGCFVDPEVADTLLCGMGEGIVTVWKPNKNDLEDQMSRIKISKDESIDCIVPTLQDDNCVWCGCSNGNIYKVNAKLGKVVEIRNHSELDEVSFVDLDFEYRVVSGGLENIKIWELSSDDVEENASVESDSDEPLSHSDEDLSDDTSSDDETTLVGLSKEELLDELDKDLKEDHQEEKESNSKSVKKRKIMKENNKKKDLYEHGIKKFDDL');
INSERT INTO proteininfo VALUES ('6325426', 'NP_015494.1','Component of the RNA polymerase II mediator complex, which is required for transcriptional activation and also has a role in basal transcription; Nut2p [Saccharomyces cerevisiae]','MNGNSTNNEQLQQELATTQDQVASIIESFVELGVSIYDFPGTPEATKGMITNLQRNVDRLYKLNVRSNDPQSSLSKVDIPLEVVQYIEDGRNPDIYTREFVEAIRRSNQYQRGKMHGLKQLRDSLADKIVDEFPELKEPVEDIIKRTSPIDNVSNTH');
INSERT INTO proteininfo VALUES ('6325425', 'NP_015493.1','3'-phosphoadenylsulfate reductase, reduces 3'-phosphoadenylyl sulfate to adenosine-3',5'-bisphosphate and free sulfite using reduced thioredoxin as cosubstrate, involved in sulfate assimilation and methionine metabolism; Met16p [Saccharomyces cerevisiae]','MKTYHLNNDIIVTQEQLDHWNEQLIKLETPQEIIAWSIVTFPHLFQTTAFGLTGLVTIDMLSKLSEKYYMPELLFIDTLHHFPQTLTLKNEIEKKYYQPKNQTIHVYKPDGCESEADFASKYGDFLWEKDDDKYDYLAKVEPAHRAYKELHISAVFTGRRKSQGSARSQLSIIEIDELNGILKINPLINWTFEQVKQYIDANNVPYNELLDLGYRSIGDYHSTQPVKEGEDERAGRWKGKAKTECGIHEASRFAQFLKQDA');
INSERT INTO proteininfo VALUES ('6325424', 'NP_015492.1','Mitochondrial ribosomal protein of the small subunit; Mrp2p [Saccharomyces cerevisiae]','MGNFRFPIKTKLPPGFINARILRDNFKRQQFKENEILVKSLKFIARNMNLPTKLRLEAQLKLNALPNYMRSTQIKNRCVDSGHARFVLSDFRLCRYQFRENALKGNLPGVKKGIW');
INSERT INTO proteininfo VALUES ('6325423', 'NP_015491.1','Gtp-binding protein of the rho subfamily of ras-like proteins; GTP-binding protein of the rho subfamily of ras-like proteins; Rho1p [Saccharomyces cerevisiae]','MSQQVGNSIRRKLVIVGDGACGKTCLLIVFSKGQFPEVYVPTVFENYVADVEVDGRRVELALWDTAGQEDYDRLRPLSYPDSNVVLICFSIDLPDSLENVQEKWIAEVLHFCQGVPIILVGCKVDLRNDPQTIEQLRQEGQQPVTSQEGQSVADQIGATGYYECSAKTGYGVREVFEAATRASLMGKSKTNGKAKKNTTEKKKKKCVLL');
INSERT INTO proteininfo VALUES ('6325422', 'NP_015490.1','sensitive to methyl methanesulfonate (MMS), diepoxybutane, and mitomycin C; sensitive to diepoxybutane and mitomycin C; Mms1p [Saccharomyces cerevisiae]','MLGLRTHGLDRYEHYIRRPSDFGKLELQDWLNHKSFRVSPNLLIDSSTTREWNEPELFYQNTEDETWVRPCVGPKLEPSMMMLRYHDSNIGQMPQFCYPISSPINFKPVLKYILQERSELSDGFPQKYNTLIGSLFDIDKNPETLDDSDIEALDDIEMSSDSGNVKEPKIELQALEEIQQKHFSLIVSNNGIFQTGSTSITYIQSGISGSIAIKPNNVAILILLTQPSGHLLSILPLDDGKETYLLQYWNLGQKGQWNIIKHQNEKQFVLIHKELGICKFFEFHLPFTFQLVNNLTLTDSVIMNGSFFPTNYTDLDPYFIIFITAIRYERIVYFVIEWNNNEIKKKEVYQLTVFDGEKTNMTIPIGLNACLVETPLKFSLVSANQIMSGETEFHSFQLKALKGIKSFFPAPLLLLKLQELHPHTFKKFQYCTIISSSTGNICFCVTERSTIVNGNLKFYELTRFKGLKSISPLPSNPINLDSRSSSYVLVVISFSRTLELTLSLEDLRCLDKKDVIKPLKNITFKHTIDSSTEENSQILAFTSSKFYNTHTGSNINDTRNSQVWLTSPNAITQPCIDYKLRKTHQLIHLKQFQIFRHLRIWKCKNLDIALLQRLGINQSNTESSLIFATDAVSNNRIFLLDLTMTTTIDNDDPVQGLINIEDLLCDTENETILLNFTKNNLIQVTRDTIYIDPIGGDKELRKISPGWEFENVTYNDGILIVWNAGLGCVSYIENIDAVDESGALVSNLSSSKGMSKFFKQLGTVTSVNFQIKESTDDPTKYDIWILLPDCVIRTPFSDWISDSLDFSDVYILSVQQALINGPYFCSLDYESYFEVHTLQNNCFKKGSRCTSRVNFQGKDIKFRSFGVNQCLAFSAFEIFVINLTPIHDSRELDFYKLKLPHLGNNNSILEVCPDIENNQLFILYSDGLRILELSYLTSNNGNFLLKSTRSKNKKFLYLDKINRMLVLNQDLREWECIRLSDGKAVGLDSQLLKDDSEEILEIKELPIATEDNPLEKKTVLLISFTSSLKLVLLTAAKNKISNQIIDSYKLDNSRLLNHLVITPRGEIFFLDYKVMGTDNEMSFNKLKVTKHCIDQEERNNTTLRLTLETRFTFKSWSTVKTFTVVGDNIIATTNMGEKLYLIKDFSSSSDESRRVYPLEMYPDSKVQKIIPLNECCFVVAAYCGNRNDLDSRLIFYSLPTIKVGLNNETGSLPDEYGNGRVDDIFEVDFPEGFQFGTMALYDVLHGERHVNRYSEGIRSENDEAEVALRQRRNLLLFWRNHSSTPKPSLRRAATIVYEDHVSSRYFEDISSILGSTAMRTKRLSPYNAVALDKPIQDISYDPAVQTLYVLMADQTIHKFGKDRLPCQDEYEPRWNSGYLVSRRSIVKSDLICEVGLWNLSDNCKNTV');
INSERT INTO proteininfo VALUES ('6325421', 'NP_015489.1','Suppressor of translation mutants; Translation initiation factor eIF-4B; Tif3p [Saccharomyces cerevisiae]','MAPPKKTVKKMDLTSFLNDDTFGSSWAEEDVDLNKITIPIETANANTIPLSELAHAKNNSNNTRSGGFGGSFGGRSRLDPALGGGSSDRREEYPVPDAPPYRAVINNIPWDITPEGVQAWVEDGLVKPEAVEEVVLPKNLRDPTRLKGNAFVTLKERADLVAVLKFNGTKLNERTVYVSVAAPRRGGGADVDWSSARGSNFQGDGREDAPDLDWGAARGSNFRGPRREREEVDIDWTAARGSNFQGSSRPPRREREEVDIDWSAARGSNFQGSSRPPRREREEPDIDWSAARGSNFQSSSRPPRREREEPDIDWSAARGSNFQSSSRPPRREREKEEPALDWGAARGAQFGKPQQTKNTYKDRSLTNKKTTDEQPKIQKSVYDVLRTEDDDEDEEAEKQNGDAKENKVDAAVEKLQDKTAQLTVEDGDNWEVVGKK');
INSERT INTO proteininfo VALUES ('6325420', 'NP_015488.1','Subunit of the origin recognition complex, which directs DNA replication by binding to replication origins and is also involved in transcriptional silencing; Orc4p [Saccharomyces cerevisiae]','MTISEARLSPQVNLLPIKRHSNEEVEETAAILKKRTIDNEKCKDSDPGFGSLQRRLLQQLYGTLPTDEKIIFTYLQDCQQEIDRIIKQSIIQKESHSVILVGPRQSYKTYLLDYELSLLQQSYKEQFITIRLNGFIHSEQTAINGIATQLEQQLQKIHGSEEKIDDTSLETISSGSLTEVFEKILLLLDSTTKTRNEDSGEVDRESITKITVVFIFDEIDTFAGPVRQTLLYNLFDMVEHSRVPVCIFGCTTKLNILEYLEKRVKSRFSQRVIYMPQIQNLDDMVDAVRNLLTVRSEISPWVSQWNETLEKELSDPRSNLNRHIRMNFETFRSLPTLKNSIIPLVATSKNFGSLCTAIKSCSFLDIYNKNQLSNNLTGRLQSLSDLELAILISAARVALRAKDGSFNFNLAYAEYEKMIKAINSRIPTVAPTTNVGTGQSTFSIDNTIKLWLKKDVKNVWENLVQLDFFTEKSAVGLRDNATAAFYASNYQFQGTMIPFDLRSYQMQIILQELRRIIPKSNMYYSWTQL');
INSERT INTO proteininfo VALUES ('6325419', 'NP_015487.1','CDC28/cdc2 related protein kinase; Sgv1p [Saccharomyces cerevisiae]','MSDNGSPAVLPKTEFNKYKIGKVKSTPAIQRDAKTNLTYIKLRKRSSEKVYGCTVFQNHYREDEKLGQGTFGEVYKGIHLETQRQVAMKKIIVSVEKDLFPITAQREITILKRLNHKNIIKLIEMVYDHSPDITNAASSNLHKSFYMILPYMVADLSGVLHNPRINLEMCDIKNMMLQILEGLNYIHCAKFMHRDIKTANILIDHNGVLKLADFGLARLYYGCPPNLKYPGGAGSGAKYTSVVVTRWYRAPELVLGDKQYTTAVDIWGVGCVFAEFFEKKPILQGKTDIDQGHVIFKLLGTPTEEDWAVARYLPGAELTTTNYKPTLRERFGKYLSETGLDFLGQLLALDPYKRLTAMSAKHHPWFKEDPLPSEKITLPTEESHEADIKRYKEEMHQSLSQRVPTAPRGHIVEKGESPVVKNLGAIPRGPKKDDASFLPPSKNVLAKPPPSKIRELHQNPRPYHVNSGYAKTAIPPPAAPAGVNRYGPNNSSRNNRFSGNSTAPNNSRNPVNRFHPETNVSSKYNKVPLPLGPQSRYQGNSNESRYKNSPNDSRYHNPRYVNKPETNFNRQPQKYSRQESNAPINKNYNPSNGSRNMAGDHHQGSRPSHPQFPISPSQGQHQLTSKPIEKKNGSFKDERAKPDESKEFQNSDIADLY');
INSERT INTO proteininfo VALUES ('6325418', 'NP_015486.1','Releases glucose-1-phosphate from glycogen; Glycogen phosphorylase; Gph1p [Saccharomyces cerevisiae]','MPPASTSTTNDMITEEPTSPHQIPRLTRRLTGFLPQEIKSIDTMIPLKSRALWNKHQVKKFNKAEDFQDRFIDHVETTLARSLYNCDDMAAYEAASMSIRDNLVIDWNKTQQKFTTRDPKRVYYLSLEFLMGRALDNALINMKIEDPEDPAASKGKPREMIKGALDDLGFKLEDVLDQEPDAGLGNGGLGRLAACFVDSMATEGIPAWGYGLRYEYGIFAQKIIDGYQVETPDYWLNSGNPWEIERNEVQIPVTFYGYVDRPEGGKTTLSASQWIGGERVLAVAYDFPVPGFKTSNVNNLRLWQARPTTEFDFAKFNNGDYKNSVAQQQRAESITAVLYPNDNFAQGKELRLKQQYFWCAASLHDILRRFKKSKRPWTEFPDQVAIQLNDTHPTLAIVELQRVLVDLEKLDWHEAWDIVTKTFAYTNHTVMQEALEKWPVGLFGHLLPRHLEIIYDINWFFLQDVAKKFPKDVDLLSRISIIEENSPERQIRMAFLAIVGSHKVNGVAELHSELIKTTIFKDFVKFYGPSKFVNVTNGITPRRWLKQANPSLAKLISETLNDPTEEYLLDMAKLTQLGKYVEDKEFLKKWNQVKLNNKIRLVDLIKKENDGVDIINREYLDDTLFDMQVKRIHEYKRQQLNVFGIIYRYLAMKNMLKNGASIEEVAKKYPRKVSIFGGKSAPGYYMAKLIIKLINCVADIVNNDESIEHLLKVVFVADYNVSKAEIIIPASDLSEHISTAGTEASGTSNMKFVMNGGLIIGTVDGANVEITREIGEDNVFLFGNLSENVEELRYNHQYHPQDLPSSLDSVLSYIESGQFSPENPNEFKPLVDSIKYHGDYYLVSDDFESYLATHELVDQEFHNQRSEWLKKSVLSVANVGFFSSDRCIEEYSDTIWNVEPVT');
INSERT INTO proteininfo VALUES ('6325417', 'NP_015485.1','cell wall beta-glucan assembly; potential beta-glucan synthase; Kre6p [Saccharomyces cerevisiae]','MPLRNLTETHNFSSTNLDTDGTGDDHDGAPLSSSPSFGQQNDNSTNDNAGLTNPFMGSDEESNARDGESLSSSVHYQPQGSDSSLLHDNSRLDLSQNKGVSDYKGYYSRNNSRAVSTANDNSFLQPPHRAIASSPSLNSNLSKNDILSPPEFDRYPLVGSRVTSMTQLNHHGRSPTSSPGNESSASFSSNPFLGEQDFSPFGGYPASSFPLMIDEKEEDDYLHNPDPEEEARLDRRRFIDDFKYMDKRSASGLAGVLLLFLAAIFIFIVLPALTFTGAIDHESNTEEVTYLTQYQYPQLSAIRTSLVDPDTPDTAKTREAMDGSKWELVFSDEFNAEGRTFYDGDDPYWTAPDVHYDATKDLEWYSPDASTTVNGTLQLRMDAFKNHGLYYRSGMLQSWNKVCFTQGALEISANLPNYGRVSGLWPGLWTMGNLGRPGYLASTQGVWPYSYESCDAGITPNQSSPDGISYLPGQKLSICTCDGEDHPNQGVGRGAPEIDVLEGETDTKIGVGIASQSLQIAPFDIWYMPDYDFIEVYNFTTTTMNTYAGGPFQQAVSAVSTLNVTWYEFGEYGGYFQKYAIEYLNDDDNGYIRWFVGDTPTYTIHAKALHPDGNIGWRRISKEPMSIILNLGISNNWAYIDWQYIFFPVVMSIDYVRIYQPSNAISVTCDPSDYPTYDYIQSHLNAFQNANLTTWEDAGYTFPKNILTGKCTSSKFKLSS');
INSERT INTO proteininfo VALUES ('6325416', 'NP_015484.1','Hypothetical ORF; Ypr158wp [Saccharomyces cerevisiae]','MAAACICQPNLLEINVSDGPLDMIRKKRKIQQPQLRPPLRENKCQPHFSVRKVNQSYIISLHKEITCQLIAEIVKQKLSRIWEKVYIPSYELISDKDGNQIYVEQSVDENRLTSEIMEKLDPNNIDIEAIEILFDDYHLELSRLTNGIIISSANDHFYREFSFNNIIDDNFKICGTSMSADSFDKIYGVMWIEVPFNGNGLQNDSAVNRVSTSHNQIEELNDIEQEIRAFNISRSNQESIIKKEVSRRLNGR');
INSERT INTO proteininfo VALUES ('6325415', 'NP_015483.1','Hypothetical ORF; Ypr157wp [Saccharomyces cerevisiae]','MHCVLARILLWFLIVDLSVIRALVLPPLKDYDPLEPLMKRDMAMGQRNRFKVDGQLPPILNSTDVTDDQRSLHTPGEIPSYVINHCPLVHLYSEEKYWPSDIAEYVQNFQIKDKNGNSISTHENLTLHDLKAEYHVDLFGNKTETHIPSSEVFLTSLDDFDKDPKWLLGHLPEYGTGYNSKAPAILIVVDKGNGWVDAFWFFFYPFNHGPFIMGHGPWGNHVGDWEHSLVRFYKGIPKYLWMSAHSSGTGYRYEAVEKFKKLRKRKQQDSDDGGDTILERPLIFSARGTHANYASAGQHAHDIPFFFMPLSDFTDRGPLWDPSLNFYSYTFDGKTVTPSSEREESLGLDWLHFQGGWGDQQLPARDPRQKWCVAQWKYIGGPRGPLFKKLDRLNLCGGVKKWNFWNGGCPARRLIKKAEGLDSESTDLMGDNCGVLLYRIRPKWLRGILRFLMWRGILCSLMEFFTN');
INSERT INTO proteininfo VALUES ('6325414', 'NP_015482.1','Polyamine transport protein; Tpo3p [Saccharomyces cerevisiae]','MNRQESINSFNSDETSSLSDVESQQPQQYIPSESGSKSNMAPNQLKLTRTETVKSLQDMGVSSKAPVPDVNAPQSSKNKIFPEEYTLETPTGLVPVATLHSIGRTSTAISRTRTRQIDGASSPSSNEDALESDNNEKGKEGDSSGANDEAPDLDPEIEFVTFVTGDPENPHNWPAWIRWSYTVLLSILVICVAYGSACISGGLGTVEKKYHVGMEAAILSVSLMVIGFSLGPLIWSPVSDLYGRRVAYFVSMGLYVIFNIPCALAPNLGSLLACRFLCGVWSSSGLCLVGGSIADMFPSETRGKAIAFFAFAPYVGPVVGPLVNGFISVSTGRMDLIFWVNMAFAGVMWIISSAIPETYAPVILKRKAARLRKETGNPKIMTEQEAQGVSMGEMMRACLLRPLYFSVTEPVLVATCFYVCLIYSLLYAFFFAFPVIFGELYGYKDNLVGLMFIPIVIGALWALATTFYCENKYLQIVKQRKPTPEDRLLGAKIGAPFAAIALWILGATAYKHIIWVGPASAGLAFGFGMVLIYYSLNNYIIDCYVQYASSALATKVFLRSAGGAAFPLFTIQMYHKLNLHWGSWLLAFISTAMIALPFAFSYWGKGLRHKLSKKDYSIDSIE');
INSERT INTO proteininfo VALUES ('6325413', 'NP_015481.1','Regulates proper expression of subunits 6 (Atp6p) and 8 (Atp8p) of the Fo-F1 ATP synthase; Regulates expression of mitochondrial ATP synthase; Nca2p [Saccharomyces cerevisiae]','MIINRRILKSFEEISHSLEESLREVAFDSQQQLIQDVREENEELSRLQDQLQLIRSIVEKICISIKTDNIDSYCSVPFDLLYNICKDIADPSSFEDGDLQYLVSQAIFEYIILLCYYSVTNECVQGLPAVYEAEQYYKTVSDSILKSFLYCLQNSVSTIRLLSQTVLKDVNKKKLSHQKWSLKALSVDLLEKIRPRINKFMVIRNFRFVGLPKKPIEIASLVSDIPRGIVHERLDMVTQSSKYYTIKLGQLITEFDQQPEENGMFTEVHLPNYERRLKSLQDFFGLAMSDSNLLDVIRCSAKFHKDHPLRRFTKPSILTRYWPSILLCLLYGPSSVMSLWNSRYFIQDFIKTNVVDFAKGLILNWLWAPLKQVWSTVKHDEGSAISVTSQETLNSDMDSLTRMIVSFVVDNSDSTSNSPIDPILLSTKVEHGDLTEFMEIYETQLHHPIKNIATGGLVRSLLIQLQKTKVDGSMALNGIDKMLKSQQLVFGVVALSPALVILYSSIVALKRFVKLGNVWSNEKRYREQISISLNNVERVLNYSKQGADADEEHLNQGLLVIEVSNLYKLGSFLIPRSRKKEWFRDVEELVDTNLDSGAHINVVNRIYHVYGRFLIH');
INSERT INTO proteininfo VALUES ('6325412', 'NP_015480.1','[PSI+] induction; Pin3p [Saccharomyces cerevisiae]','MSASLINRSLTNIRTELDFLKGSNVISNDVYDQINKSLPAKWDPANAPRNASPASLEYVEALYQFDPQQDGDLGLKPGDKVQLLEKLSPEWYKGSCNGRTGIFPANYVKPAFSGSNGPSNLPPPPQYKAQELQQIPTQNSAASSYQQQPFPPPSTNYYQQPQQQPQQAPPPQQQQQQQQHQSSHSHLKSFGSKLGNAAIFGAGASIGSDIVNNIF');
INSERT INTO proteininfo VALUES ('6325411', 'NP_015479.1','Hypothetical ORF; Ypr153wp [Saccharomyces cerevisiae]','MFPVLRSFVTNNDIPVGYVTPKFPSLYWPINNSKYNTAFLYYISDIWKFSLYWTLIFNGAFYVTAGVYASLTHRKKAGSVWIFVMYVLYGGVQGLTTGTVMGFLIGAIYRSGLFSMSTWVPLCCAVVQILFDVVLSYSMVGSVM');
INSERT INTO proteininfo VALUES ('6325410', 'NP_015478.1','Hypothetical ORF; Ypr152cp [Saccharomyces cerevisiae]','MRGEWQEFKTPAGKKYYYNKNTKQSRWEKPNLKKGSNLESNAKESQTERKPTFSLELVNGWHLIIYNDGTKLYFNDDSKEFKNDISQEDDSRCRSLIESLDKEKLVLLIGVARGYTMREEDIDKILESCNEEIHLFKRNQDEVERKDEISEEAGDVKSPLQESHTGLVSGYGSSSGEEDEEEDEEEDEENEEQIVNQDISIIDDLNRIDTDDIDERNIFFELFDRYKLDKFSTWSLQSKKIENDPDFYKIRDDTVRESLFEEWCGERSGNATAEESDSEDNSEDDSEVLEPTKYHYLAQIVANAGTIAPDTIPQDIRKQQKALYKAYKIKEYIPSKRDQDKFVSQLLFYYKTFDLEQRKEIFCDCLRDHERDFTGAVESLRQDKELIDRWQTLLKAPADSSSIEDILLSIEHRCCVSPIVVTEPRYYVVGILEKTVVWVRWLAAEVGPSSRFTPVGAGNEPINPE');
INSERT INTO proteininfo VALUES ('6325409', 'NP_015477.1','Mitochondrial protein required for degradation of unstable forms of cytochrome c; Sue1p [Saccharomyces cerevisiae]','MILLKRTKIRGVSVSFVSLQRRTHSRLVNPIRQQHQQITKQRSSKILKNAHFYDFRSLPKVPTTQYLEARELTRDILYSGYRPVMYPVKENPLFRDKKRKSLQTLLTMNEKTNAEAKTIDEKKHKNILFGERGTGGIMSGGVNGTWKYNPTVPNELLPFNWWSTSSMGMEYFPEWKNVPPYMMRKLKPFDKALQMRLTHKSKKKMK');
INSERT INTO proteininfo VALUES ('6325407', 'NP_015475.1','involved in secretion of proteins that lack classical secretory signal sequences; Involved in secretion of proteins that lack classical secretory signal sequences; Nce102p [Saccharomyces cerevisiae]','MLALADNILRIINFLFLVISIGLISSLLNTQHRHSSRVNYCMFACAYGIFTDSLYGVFANFIEPLAWPLVLFTLDFLNFVFTFTAGTVLAVGIRAHSCNNSSYVDSNKITQGSGTRCRQAQAAVAFLYFSCAIFLAKTLMSVFNMISNGAFGSGSFSKRRRTGQVGVPTISQV');
INSERT INTO proteininfo VALUES ('6325406', 'NP_015474.1','Protein of unknown function; green fluorescent protein (GFP)-fusion protein localizes to the cytoplasm in a punctate pattern; Ypr148cp [Saccharomyces cerevisiae]','MSGYFSGFSLNKITDSIATAAHKTQDTLNNALANANVNLNDPQTRLSIKSRTRFVQESLGTVSDISKLPPQYQFLEKKSDSLEKVCKRILLVSKTFEVEGYDYPPNLTESISDWWSLNKDGWFGSKKSESSTKKKGSNHDDAFLPRSFAQAISKAAVDCECEFQNLEHNEKAELKKKKESIKTAQTTEAQGADHNEEDEEDEEDEEDDEDLSNLIKVFDSWSTCYKNIDEGKAEMDSMMVKEFNKKLETLINQDFKKVHDLRKKVEESRLKFDTMRYEVKAKEAELEAKKAEATGEAHSKDVSAKDISANTTTSFDETPSTEDEKPKSEGAEEESKKEANEPTVDDVADRKEDLKSNKVNDEPPIEESEDNKLLEKLEDEFVSNTTAAVETMEEITDSSEILGLIKLFQNFQLVYFRQCVQEVEANLKVLNGLEI');
INSERT INTO proteininfo VALUES ('6325405', 'NP_015473.1','Hypothetical ORF; Ypr147cp [Saccharomyces cerevisiae]','MTVKEYTKSKLPCSILNIKPTVTKSGEDAPLLVWIPGNPGLLYYYQEMLHHLHLKHPDWEILGISHAGMTLNAHSNTPIFSLQDQVDHQVEVINNFSCKNRKIIIMGHSVGAYIVQKVCLSNKLVGSVQKVGLVTPTVMDIHTSEMGIKMTAALRYIPPLAHVVSLFSYIFFYWILSEGFSRFIIDKFMGCGSTGYQAVLSTRIFLTHRQFVRQSLGLAAQEMEEITTNWEFQDRFINYCEENGISIWFLFSSNDHWVSGKTRSHLSDYYKDKVKQERLKIDVTDKIPHSFVVKHAEYAINAFF');
INSERT INTO proteininfo VALUES ('6325403', 'NP_015471.1','Asparagine synthetase, isozyme of Asn2p; catalyzes the synthesis of L-asparagine from L-aspartate in the asparagine biosynthetic pathway; Asn1p [Saccharomyces cerevisiae]','MCGIFAAFRHEDVHRYKPKALQLSKRIRHRGPDWSGNAIKNSTIFVHERLAIVGVESGAQPITSSDGEYMLCVNGEIYNHIQLREECADYEFGTLSDCEPIIPMYLKHDIDAPKYLDGMFAWTLYDAKQDRIVAARDPIGITTLYMGRSSASPKTVYFASELKCLTDDCDTITAFPPGHVYDSKTDKITRYFTPDWLDEKRIPSTPIDYMAIRHSLEKAVRKRLMAEVPYGVLLSGGLDSSLIASIAARETAKATNDVEPSTYDSKARHLAGIDDDGKLHTAGWTSLHSFAIGLPNAPDLQAARKVAKFIGSIHHEHTFTLQEGLDALDDVIYHLETYDVTTIRASTPMFLLSRKIKAQGVKMVLSGEGSDEIFGGYLYFAQAPSAAEFHTESVQRVKNLHLADCLRANKSTMAWGLEARVPFLDREFLQLCMNIDPNEKMIKPKEGRIEKYILRKAFDTTGEPDAKPYLPEEILWRQKEQFSDGVGYSWIDGLKDTAEAVISDEMFASPKAEWGSDIPTTKEAFWYRLKFDALFPQKTVADTVMRWIPKADWGCAEDPSGRYAQIHEKHIE');
INSERT INTO proteininfo VALUES ('6325402', 'NP_015470.1','Nucleolar protein, forms a complex with Nop14p that mediates maturation and nuclear export of 40S ribosomal subunits; Noc4p [Saccharomyces cerevisiae]','MVLLISEIKDIAKRLTAAGDRKQYNSIIKLINELVIPENVTQLEEDETEKNLRFLVMSLFQIFRKLFSRGDLTLPSSKKSTLEKEQFVNWCRKVYEAFKTKLLAIISDIPFETSLGLDSLDVYLQLAELESTHFASEKGAPFFPNKTFRKLIIALWSSNMGEIEDVKSSGASENLIIVEFTEKYYTKFADIQYYFQSEFNQLLEDPAYQDLLLKNVGKWLALVNHDKHCSSVDADLEIFVPNPPQAIENESKFKSNFEKNWLSLLNGQLSLQQYKSILLILHKRIIPHFHTPTKLMDFLTDSYNLQSSNKNAGVVPILALNGLFELMKRFNLEYPNFYMKLYQIINPDLMHVKYRARFFRLMDVFLSSTHLSAHLVASFIKKLARLTLESPPSAIVTVIPFIYNLIRKHPNCMIMLHNPAFISNPFQTPDQVANLKTLKENYVDPFDVHESDPELTHALDSSLWELASLMEHYHPNVATLAKIFAQPFKKLSYNMEDFLDWNYDSLLNAESSRKLKTLPTLEFEAFTNVFDNEDGDSEASSQGNVYLPGVAW');
INSERT INTO proteininfo VALUES ('6325400', 'NP_015469.1','Essential protein involved in pre-rRNA processing; Rrp15p [Saccharomyces cerevisiae]','MGSKHRVDTKDKKRTRKNAEFGREKRNSGNQELSNEPEKDTIMEGDEAEEDEQNSSSDESSKIIDNEQSDAEEDDDEEEEDDDFPRKKKSKNSKHDDGSTGFSAAVNAILSSHLKAYDRKDPIMARNKKVLKQSESEKLEYKAKKALLAEKKKLLGKARKTDIIPIASGEDRSENIRKVLEKETALRKIAQKGAVKLFNAILATQVKTEKEVSENLSEIKNKEEKKELITEVSKEKFLDLVKAAAGSDNE');
INSERT INTO proteininfo VALUES ('6325399', 'NP_015467.1','Minus-end-directed microtubule motor that functions in mitosis and meiosis, localizes to the spindle pole body and localization is dependent on functional Cik1p, required for nuclear fusion during mating; potential Cdc28p substrate; Kar3p [Saccharomyces cerevisiae]','MESLPRTPTKGRSTQHLSTPSPKNDILAMNGHKRRNTTTPPPKHTLLKPQRTDIHRHSLASQSRISMSPNRELLKNYKGTANLIYGNQKSNSGVTSFYKENVNELNRTQAILFEKKATLDLLKDELTETKEKINAVNLKFETLREEKIKIEQQLNLKNNELISIKEEFLSKKQFMNEGHEIHLKQLAASNKKELKQMENEYKTKIEKLKFMKIKQFENERASLLDKIEEVRNKITMNPSTLQEMLNDVEQKHMLEKEEWLTEYQSQWKKDIELNNKHMQEIESIKKEIENTLKPELAEKKKLLTEKRNAYEAIKVKVKEKEEETTRLRDEVALKQKTNLETLEKIKELEEYIKDTELGMKELNEILIKEETVRRTLHNELQELRGNIRVYCRIRPALKNLENSDTSLINVNEFDDNSGVQSMEVTKIQNTAQVHEFKFDKIFDQQDTNVDVFKEVGQLVQSSLDGYNVCIFAYGQTGSGKTFTMLNPGDGIIPSTISHIFNWINKLKTKGWDYKVNCEFIEIYNENIVDLLRSDNNNKEDTSIGLKHEIRHDQETKTTTITNVTSCKLESEEMVEIILKKANKLRSTASTASNEHSSRSHSIFIIHLSGSNAKTGAHSYGTLNLVDLAGSERINVSQVVGDRLRETQNINKSLSCLGDVIHALGQPDSTKRHIPFRNSKLTYLLQYSLTGDSKTLMFVNISPSSSHINETLNSLRFASKVNSTRLVSRK');
INSERT INTO proteininfo VALUES ('6325398', 'NP_015466.1','Putative acyltransferase, required for normal phospholipid content of mitochondrial membranes; may remodel the acyl groups of cardiolipin in the inner membrane; similar to human tafazzin, which is implicated in Barth syndrome; Taz1p [Saccharomyces cerevisiae]','MSFRDVLERGDEFLEAYPRRSPLWRFLSYSTSLLTFGVSKLLLFTCYNVKLNGFEKLETALERSKRENRGLMTVMNHMSMVDDPLVWATLPYKLFTSLDNIRWSLGAHNICFQNKFLANFFSLGQVLSTERFGVGPFQGSIDASIRLLSPDDTLDLEWTPHSEVSSSLKKAYSPPIIRSKPSWVHVYPEGFVLQLYPPFENSMRYFKWGITRMILEATKPPIVVPIFATGFEKIASEAVTDSMFRQILPRNFGSEINVTIGDPLNDDLIDRYRKEWTHLVEKYYDPKNPNDLSDELKYGKEAQDLRSRLAAELRAHVAEIRNEVRKLPREDPRFKSPSWWKRFNTTEGKSDPDVKVIGENWAIRRMQKFLPPEGKPKGKDD');
INSERT INTO proteininfo VALUES ('6325397', 'NP_015465.1','Vps66p [Saccharomyces cerevisiae]','MEKYTNWRDNGTGIAPFLPNTIRKPSKVMTACLLGILGVKTIIMLPLIMLYLLTGQNNLLGLILKFTFSWKEEITVQGIKKRDVRKSKHYPQKGKLYICNCTSPLDAFSVVLLAQGPVTLLVPSNDIVYKVSIREFINFILAGGLDIKLYGHEVAELSQLGNTVNFMFAEGTSCNGKSVLPFSITGKKLKEFIDPSITTMNPAMAKTKKFELQTIQIKTNKTAITTLPISNMEYLSRFLNKGINVKCKINEPQVLSDNLEELRVALNGGDKYKLVSRKLDVESKRNFVKEYISDQRKKRK');
INSERT INTO proteininfo VALUES ('6325396', 'NP_015464.1','ammonia permease of high capacity and low affinity; shows sequence similarity to Mep1p and Mep2p; NH4+ transporter, highly similar to Mep1p and Mep2p; Mep3p [Saccharomyces cerevisiae]','MARGDGHLWTETYDSSTVAFMILGAALVFFMVPGLGFLYSGLARRKSALALIWVVIMATLVGILQWYFWGYSLAFSKTATNNKFIGNLDSFGFRNVYGKISDDSTYPELIYAIFQMMFMCVALSIIAGATAERGKLFPHMVFLFVFATLVYCPITYWIWAPGGWAYQWGVLDWAGGGNIEILSAVAGFVYSYFLGRRKENLLINFRPHNVSMVTLGTSILWFGWLLFNAASSLSPNMRSVYAFMNTCLSATTGGMTWCLLDYRSEKKWSTVGLCSGIICGLVAATPSSGCITLYGSLIQGIIAGVVCNFATKIKYYLKVDDSLDLLAEHGIAGVVGLIFNALFAADWVIGMDGTTKHKGGWLTHNWKQMYIQIAYIGASAGYCAVVTAIICFVLGKIPGVHLRVTEEAEALGLDEDQIGEFAYDYVEVRRDYYQWGVDTDALHTTCNGANSASETNPTEDSQNSSLSSATVSGQNEKSNNPKLHHAKEA');
INSERT INTO proteininfo VALUES ('6325394', 'NP_015463.1','part of small (ribosomal) subunit (SSU) processosome (contains U3 snoRNA); Rrp9p is an ortholog of the human U3-55k protein; the human cDNA partially complements a yeast rrp9 null mutant. (Pluk et al. (1998) Mol. Cell. Biol. 18, 488-498.); U3 small nucleolar ribonucleoprotein-associated protein involved in pre-ribosomal RNA processing.; Rrp9p [Saccharomyces cerevisiae]','MSDVTQQKKRKRSKGEVNPSKPTVDEEITDPSSNEDEQLEVSDEEDALESEEEFEGENPADKRRRLAKQYLENLKSEANDILTDNRNAEEKDLNNLKERTIDEYNNFDAGDLDKDIIASRLKEDVAEQQGRVFRYFGDKLLISEAKQSFTRVGENNLTCISCFQPVLNKYTFEESSNGDKNKGRLFAYTVSKDLQLTKYDITDFSKRPKKLKYAKGGAKYIPTSKHEYENTTEGHYDEILTVAASPDGKYVVTGGRDRKLIVWSTESLSPVKVIPTKDRRGEVLSLAFRKNSDQLYASCADFKIRTYSINQFSQLEILYGHHDIVEDISALAMERCVTVGARDRTAMLWKIPDETRLTFRGGDEPQKLLRRWMKENAKEGEDGEVKYPDESEAPLFFCEGSIDVVSMVDDFHFITGSDNGNICLWSLAKKKPIFTERIAHGILPEPSFNDISGETDEELRKRQLQGKKLLQPFWITSLYAIPYSNVFISGSWSGSLKVWKISDNLRSFELLGELSGAKGVVTKIQVVESGKHGKEKFRILASIAKEHRLGRWIANVSGARNGIYSAVIDQTGF');
INSERT INTO proteininfo VALUES ('6325393', 'NP_015461.1','Chromatin-associated protein, required for sister chromatid cohesion; interacts with DNA polymerase alpha (Pol1p) and may link DNA synthesis to sister chromatid cohesion; Ctf4p [Saccharomyces cerevisiae]','MVSVIDKLVFDFGGKTLVSLAPDNNTLCVANKNGLTKILKTNNPEEEPETLDSSKLVSSIKCYSNSHFLMTTMQGDALRYNIDSSQEELLARFALPLRDCCVIHSGKMAVFGGDDLELILLELDDETHKKHAIKIDEQVSQISYNSQMNILAVSMINGKVQIFSLTSTIPNKVHELNDYIVANSYDDTHRDKILSNMMDDIDKDNDNDLSETADPDENNVADPEFCAANRICTRVAWHPKGLHFALPCADDTVKIFSIKGYSLQKTLSTNLSSTKAHFIDLQFDPLRGTYIAAVDLNNKLTVWNWETSEIHYTREFKRKITNIAWKIQADSKTLDLVLGTWSGSIAIVQNLAESVVSNIPDQSVAESSTKHGLFVDSESDLENLEGNDDINKSDKLFSDITQEANAEDVFTQTHDGPSGLSEKRKYNFEDEEDFIDDDDGAGYISGKKPHNEHSYSRVHKTHSFPISLANTGKFRYMPFSPAGTPFGFTDRRYLTMNEVGYVSTVKNSEQYSITVSFFDVGRFREYHFEDLFGYDLCFLNEKGTLFGQSKTGQIQYRPHDSIHSNWTKIIPLQAGERITSVAATPVRVIVGTSLGYFRSFNQFGVPFAVEKTSPIVALTAQNYRVFSVHYSQFHGLSYSLSELGTSSKRYYKRECPLPMSLPNINSDMKKDANLDYYNFNPMGIKSLFFSSYGDPCIFGSDNTLLLLSKWRSPEESKWLPILDSNMEIWKMSGGKETTDIHVWPLALAYDTLNCILVKGKHIWPEFPLPLPSEMEIRMPVFVKSKLLEENKAILNKKNEIGADTEAEEGEEDKEIQIPVSMAAEEEYLRSKVLSELLTDTLENDGEMYGNENEVLAALNGAYDKALLRLFASACSDQNVEKALSLAHELKQDRALTAAVKISERAELPSLVKKINNIREARYEQQLK');
INSERT INTO proteininfo VALUES ('6325392', 'NP_015460.1','Protein involved in splicing intron a15beta of COX1; Involved in splicing of mitochondrial COX1 transcript; Mss18p [Saccharomyces cerevisiae]','MGLPEVNFLRKNCILVELKLFYQTVYPPKELYWNNRITAELSTFSNIKYARPTFAVNNGTFQRTRPKLDLVLASSDIRKLATVLFNLKALIMNTKGEEPTLTTMTSVQTNEEKNDNLEQKYSSLLDRWNGKVEVHDSPFLQLQRDSNLLFAERPVRYVSTTEGEGVDISSEEFFRLEEEQCRRNYDVLVDEHSTPSVGMKDGQYGPNIIHFEPSLYHTYSSLPMSMKFWLNGLEDDETTMMNIDEKSAENLDILLHGFKGFSNKRVKG');
INSERT INTO proteininfo VALUES ('6325391', 'NP_015459.1','Translocase of the Outer Mitochondrial membrane; Membrane protein involved in protein translocation to the mitochondria; Tom5p [Saccharomyces cerevisiae]','MFGLPQQEVSEEEKRAHQEQTEKTLKQAAYVAAFLWVSPMIWHLVKKQWK');
INSERT INTO proteininfo VALUES ('6325390', 'NP_015458.1','Protein that interacts with Spt6p and copurifies with Spt5p and RNA polymerase II, probable transcriptional elongation factor; metazoan homologs contain an acidic N terminus; mutations in the gene confer an Spt- phenotype; Iws1p [Saccharomyces cerevisiae]','MSTADQEQPKVVEATPEDGTASSQKSTINAENENTKQNQSMEPQETSKGTSNDTKDPDNGEKNEEAAIDENSNVEAAERKRKHISTDFSDDDLEKEEHNDQSLQPTVENRASKDRDSSATPSSRQELEEKLDRILKKPKVRRTRRDEDDLEQYLDEKILRLKDEMNIAAQLDIDTLNKRIETGDTSLIAMQKVKLLPKVVSVLSKANLADTILDNNLLQSVRIWLEPLPDGSLPSFEIQKSLFAALNDLPVKTEHLKESGLGRVVIFYTKSKRVEAQLARLAEKLIAEWTRPIIGASDNYRDKRIMQLEFDSEKLRKKSVMDSAKNRKKKSKSGEDPTSRGSSVQTLYEQAAARRNRAAAPAQTTTDYKYAPVSNLSAVPTNARAVGVGSTLNNSEMYKRLTSRLNKKHK');
INSERT INTO proteininfo VALUES ('6325389', 'NP_015457.1','Ribosomal protein 28 (rp28) of the small (40S) ribosomal subunit, required for translational accuracy; nearly identical to Rps23Ap and similar to E. coli S12 and rat S23 ribosomal proteins; deletion of both RPS23A and RPS23B is lethal; Rps23bp [Saccharomyces cerevisiae]','MGKGKPRGLNSARKLRVHRRNNRWAENNYKKRLLGTAFKSSPFGGSSHAKGIVLEKLGIESKQPNSAIRKCVRVQLIKNGKKVTAFVPNDGCLNFVDENDEVLLAGFGRKGKAKGDIPGVRFKVVKVSGVSLLALWKEKKEKPRS');
INSERT INTO proteininfo VALUES ('6325386', 'NP_015454.1','Protein containing an Lsm domain, may bind RNA and have a role in RNA processing; overproduction suppresses a null mutation in CHC1, which encodes the heavy chain of clathrin; Scd6p [Saccharomyces cerevisiae]','MSQYIGKTISLISVTDNRYVGLLEDIDSEKGTVTLKEVRCFGTEGRKNWGPEEIYPNPTVYNSVKFNGSEVKDLSILDANINDIQPVVPQMMPPASQFPPQQAQSPPQAQAQAHVQTNPQVPKPESNVPAAVAGYGVYTPTSTETATASMNDKSTPQDTNVNSQSRERGKNGENEPKYQRNKNRSSNRPPQSNRNFKVDIPNEDFDFQSNNAKFTKGDSTDVEKEKELESAVHKQDESDEQFYNKKSSFFDTISTSTETNTNMRWQEEKMLNVDTFGQASARPRFHSRGLGRGRGNYRGNRGNRGRGGQRGNYQNRNNYQNDSGAYQNQNDSYSRPANQFSQPPSNVEF');
INSERT INTO proteininfo VALUES ('6325385', 'NP_015453.1','adenine nucleotide transporter; Adenine Nucleotide Transporter; Ant1p [Saccharomyces cerevisiae]','MLTLESALTGAVASAMANIAVYPLDLSKTIIQSQVSPSSSEDSNEGKVLPNRRYKNVVDCMINIFKEKGILGLYQGMTVTTVATFVQNFVYFFWYTFIRKSYMKHKLLGLQSLKNRDGPITPSTIEELVLGVAAASISQLFTSPMAVVATRQQTVHSAESAKFTNVIKDIYRENNGDITAFWKGLRTGLALTINPSITYASFQRLKEVFFHDHSNDAGSLSAVQNFILGVLSKMISTLVTQPLIVAKAMLQSAGSKFTTFQEALLYLYKNEGLKSLWKGVLPQLTKGVIVQGLLFAFRGELTKSLKRLIFLYSSFFLKHNGQRKLAST');
INSERT INTO proteininfo VALUES ('6325384', 'NP_015452.1','Hypothetical ORF; Ypr127wp [Saccharomyces cerevisiae]','MSVADLKNNIHKLDTGYGLMSLTWRAEPIPQSQAFEAMHRVVELSRERGHKAFFNVGEFYGPDFINLSYVHDFFAKYPDLRKDVVISCKGGADNATLTPRGSHDDVVQSVKNSVSAIGGYIDIFEVARIDTSLCTKGEVYPYESFEALAEMISEGVIGGISLSEVNEEQIRAIHKDWGKFLTCVEVELSLFSNDILHNGIAKTCAELGLSIICYSPLGRGLLTGQLKSNADIPEGDFRKSLKRFSDESLKKNLTLVRFLQEEIVDKRPQNNSITLAQLALGWVKHWNKVPEYSGAKFIPIPSGSSISKVNENFDEQKTKLTDQEFNAINKYLTTFHTVGDRYEMA');
INSERT INTO proteininfo VALUES ('6325382', 'NP_015450.1','Hypothetical ORF; Ypr125wp [Saccharomyces cerevisiae]','MLKYRSLPIKRAIHHPAPGITPISPRIMVSRLRVIPSFNLKFNRWNSSVPESSKKELKTTDGNQESASKVSPVKEKEKVPFKVKMQKALRHYWDGSKLLGLEIKISSKLLMKSAAGYPLTRRENLQLKRTTQDIVRLVPFAAFLIIPFAELLLPFALKLFPNLLPSTYESSKKRENKLENLRNTRKLMSEIIKNNKSHFKPNNISEEQKALFNRFYTHVRATGVPESRQQLIEVARLFTDDTVLDNVTRPYLIALAKYMNLQPFGTDVMLRYRIRYKMLELKKDDLSIYYEDAEQLSLSELKTACASRGIRSVDVEPSVLYSNLRLWLNMRLKDKIPSTLLIMATAYNYGNVQSKESLYDALCDVLIGIPDELYHEVKVNVVKEDEASAKQKLKQLREQEEIMKEEEQQEENAIVSVKDELSLDDQDKNIDAAAPDVKPHDTKPIGEAAAIKEK');
INSERT INTO proteininfo VALUES ('6325380', 'NP_015449.1','High-affinity copper transporter of the plasma membrane, mediates nearly all copper uptake under low copper conditions; transcriptionally induced at low copper levels and degraded at high copper levels; Ctr1p [Saccharomyces cerevisiae]','MEGMNMGSSMNMDAMSSASKTVASSMASMSMDAMSSASKTILSSMSSMSMEAMSSASKTLASTMSSMASMSMGSSSMSGMSMSMSSTPTSSASAQTTSDSSMSGMSGMSSSDNSSSSGMDMDMSMGMNYYLTPTYKNYPVLFHHLHANNSGKAFGIFLLFVVAAFVYKLLLFVSWCLEVHWFKKWDKQNKYSTLPSANSKDEGKHYDTENNFEIQGLPKLPNLLSDIFVPSLMDLFHDIIRAFLVFTSTMIIYMLMLATMSFVLTYVFAVITGLALSEVFFNRCKIAMLKRWDIQREIQKAKSCPGFGNCQCGRHPEPSPDPIAVADTTSGSDQSTRLEKNNESKVAISENNQKKTPTQEEGCNCATDSGKNQANIERDILENSKLQEQSGNMDQNLLPAEKFTHN');
INSERT INTO proteininfo VALUES ('6325379', 'NP_015447.1','Haploid specific endoprotease that performs one of two N-terminal cleavages during maturation of a-factor mating pheromone; required for axial budding pattern of haploid cells; Axl1p [Saccharomyces cerevisiae]','MSLREVTNYEVSFYIPLSYSNRTHKVCKLPNGILALIISDPTDTSSSCSLTVCTGSHNDPKDIAGLAHLCEHMILSAGSKKYPDPGLFHTLIAKNNGSQNAFTTGEQTTFYFELPNTQNNGEFTFESILDVFASFFKEPLFNPLLISKEIYAIQSEHEGNISSTTKIFYHAARILANPDHPFSRFSTGNIHSLSSIPQLKKIKLKSSLNTYFENNFFGENITLCIRGPQSVNILTKLALSKFGDIKPKSAVKERSISIRTRSFRRSKSLKKRQDSSKNDYSDLKTFKILNTTWEKKYKNTMCFQQFPECNSIFINSNKVPIMRLLFPVSDKNTRFTKDDIKIYSHLWCELFGDESPGSLSYYLASKGWLTGCFAFTSEFAIGDIGLILELELTNSGWENIKRITTIVLNRLLPSFYVMNIDYLITFLKEQNLIDLVSFLYQSSEDLPMEECSKLSGILQDDLECLTPPNIFKGFKSLIEIDDPNIEKYENTKANIQWWTGQAIKFQNFLKSFMNHDNMRLLLLGNIKSGNIFDKMKNKSDICTDFFYEFEYYTANVHLASDNKFHSNSSYEFNFPTGNLFLPDCVSDPLKLQQLFLECSLKSKFATLRPQIYSEPTRTKPQLVSENQNYEMWILKEDPNFASDNKSVVSFEVLGLGIKPSPEATIHLEVLAQALFIITSSFLYPALRIGYTYEIASSSKGNVTLRFTISGFPEGVFTIVKTFVDTLKLIATDPTFLSKDTLRKARILVRNKYKNASSDNCVKLASVGLLIVLEKYIWTLEDRINALELTELESFEKFCFLFWRNPKHLVLFMQGSLEYADAINRYLNNNFTQHLKISNEGSKPTIRLYPPPSTKDLDQGTNAFISYNGHQDDPNNSIVYFIQTAQRDDIKNLTLTFLTEYLFSLTLVPDLRNKKQIGYIVLGGLRVLTDTVGIHITVMSGSSGHNLETRINEYLSYLQLQVLNRFTEFDFRRILLEPFLNLLKQNSTKQFEGSAGPVDLLNEIVANVQNGDNYTLNNKQMRQHRKVRNKIAEGRLNFQEDHEMIDISFLQKLTLKKYLAFFESKISIYSAQRSKLSIMITSPMAEKEIASRKMFLQLEAFLKINGFAIKNEDLKKIVEHSKGNPILLVKNLFTYFRRRNEVFKLGTVVLQEILKIIGMNLKQRYGSILGFSSQDGEGQEIEKFWNNDTSPIVPLQELPEPNFFRKAAF');
INSERT INTO proteininfo VALUES ('6325378', 'NP_015446.1','Protein with similarity to hydroxymethylpyrimidine phosphate kinases; member of a gene family with THI20 and THI21; not required for thiamine biosynthesis; Thi22p [Saccharomyces cerevisiae]','MVIILLGLCTLGFPRTAFCPSIMTNSTVSINTPPPYLTLACNEKLPTVMSIAGSDSSGGAGVEADIKTITAHRCYAMTCVTTLTAQTPVKVYGAHNIPKKMVSQILDANLQDMKCNVIKTGMLTVDAIEVLHEKLLQLGENRPKLVIDPVLCAASDSSPTGKDVVSLIIEKISPFADILTPNISDCFMLLGENREVSKLQDVLEIAKDLSRITNCSNILVKGGHIPCDDGKEKHITDVLYLGAEQKFITFKGQFVNTTRTHGAGCTLASAIASNLARGYSLSQSVYGGIEYVQNAIAIGCDVTKKAVKVGPINHVYAVEIPLEKMLTDECFTASDAVPKKPIEGSLDKIPGGSFFNYLINHPKVKPHWDAYVNHEFVKRVADGTLERKKFQFFIEQDYLYLIDYVRVCCVTGSKSPTLEDLEKDLVIADCARNELNEHERRLREEFGVKDPDYLQKIKRGPALRAYCRYLIDISRRGNWQEIVVALNPCLMGYVYAVDKVKDKITAAEGSIYSEWCDTCASSFCYQAVLEGERLMNHILETYPPDQLDSLVTIFARGCELETNFWTAAMEYE');
INSERT INTO proteininfo VALUES ('6325377', 'NP_015445.1','role in DNA replication during S phase; additional functional role in formation of mitotic spindles along with Clb3 and Clb4; B-type cyclin; Clb5p [Saccharomyces cerevisiae]','MGENHDHEQSIKRNSMIYNENERQLCNSNLKILQNKRALSKNDSSSKQQVQDSKPRRALTDVPVNNNPLSQNKRIVAGSKAAKVRREENIRPIVSAVQKRQIYNDRTAAEQEEEEEEEGEDDDAASIVNKKRRIDAEGVSEIVGWQDLDYVEKDDTAMVAEYSAEIFAFLYRRELETLPSHNYLLDKTSKYYLRPSMRTILVDWLVEVHEKFQCYPETLFLSINLMDRFLAKNKVTMNKLQLLAVTSLFIAAKFEEVNLPKLAEYAYITDGAASKNDIKNAEMFMLTSLEFNIGWPNPLNFLRRISKADDYDPVNRNIGKFILEYAYCCHQFIHLPPSTVSAMAMYIARRMTNRNKNELWNGTLQHYSGGIDPIHDEAFQSLCIDLVKDIASSKTHLDSLILKYKKPRYGSVYFQTFKWCTSEMHSNFQNLFNLK');
INSERT INTO proteininfo VALUES ('6325376', 'NP_015444.1','Involved in mitotic induction; G(sub)2-specific B-type cyclin; Clb2p [Saccharomyces cerevisiae]','MSNPIENTENSQNTSSSRFLRNVQRLALNNVTNTTFQKSNANNPALTNFKSTLNSVKKEGSRIPQFTRESVSRSTAAQEEKRTLKENGIQLPKNNLLDDKENQDPSSQQFGALTSIKEGRAELPANISLQESSSAKEIIQHDPLKGVGSSTEVVHNSVENEKLHPARSQLQVRNTESETDSGKKRPISTIVEQELPKKFKVCDENGKEEYEWEDLDAEDVNDPFMVSEYVNDIFEYLHQLEVITLPKKEDLYQHRNIHQNRDILVNWLVKIHNKFGLLPETLYLAINIMDRFLGKELVQLDKLQLVGTSCLFIASKYEEVYSPSIKHFASETDGACTEDEIKEGEKFILKTLKFNLNYPNPMNFLRRISKADDYDIQSRTLAKFLLEISLVDFRFIGILPSLCAAAAMFMSRKMLGKGKWDGNLIHYSGGYTKEELAPVCHMIMDYLVSPIVHDEFHRKYQSRRFMKASIISVQWALKVRKNGYDIMTLHE');
INSERT INTO proteininfo VALUES ('6325375', 'NP_015443.1','Methylthioribose-1-phosphate isomerase, catalyzes the isomerization of 5-methylthioribose-1-phosphate to 5-methylthioribulose-1-phosphate in the methionine salvage pathway; Ypr118wp [Saccharomyces cerevisiae]','MSLEAIVFDRSEPENVSVKVLDQLLLPYTTKYVPIHTIDDGYSVIKSMQVRGAPAIAIVGSLSVLTEVQLIKHNPTSDVATLYSLVNWESTKTVLNKRLDFLLSSRPTAVNLSNSLVEIKNILKSSSDLKAFDGSLYNYVCELIDEDLANNMKMGDNGAKYLIDVLQKDGFKDEFAVLTICNTGSLATSGYGTALGVIRSLWKDSLAKTDKADSGLDNEKCPRMGHVFPLETRPYNQGSRLTAYELVYDKIPSTLITDSSIAYRIRTSPIPIKAAFVGADRIVRNGDTANKIGTLQLAVICKQFGIKFFVVAPKTTIDNVTETGDDIIVEERNPEEFKVVTGTVINPENGSLILNESGEPITGKVGIAPLEINVWNPAFDITPHELIDGIITEEGVFTKNSSGEFQLESLF');
INSERT INTO proteininfo VALUES ('6325374', 'NP_015442.1','Hypothetical ORF; Ypr117wp [Saccharomyces cerevisiae]','MSMLPWSQIRDVSKLLLGFMLFIISIQKIASILMSWILMLRHSTIRKISFGYFFGTSIRRAFILTDFAQIYIGKITLRIGWKPGIVFHNVDLKLFGKDSHITAHSTKDSRTYFNPRDQTFTFVINRRVLSILKLVFSFSTFFHTLALTVPNGKQYKLNIGSITISHPHDDTIKLEAFLHDFTHPETKDTLNHTGFFMVCKIGKEDDTGSNCTKVILKNWKSSLKISDVCWHLPEKKGKNLHSEPVEPFSAGDDAEMLTSYRKMLKPFHYPLKTLNILDLKVENVKLIYKKKFTIRISSAQLYLESISILNNVSALELLPLNKPTWGDFELSLSANAVVVDIDGNTAVRIPFGNVILTSDILLFLLDNVPLRRTKVSSILNIINPSVFLTIHQVLEVLHLVDKFDSPETSSCTNTNDRSLNILDLDIDRLPSFNFELLMSNFISRLHISDEENVTFKVFSTHALFSRNNLSMTPKKGQVMQIRPDWPFAKTALVSDQLSNYIKIVGTSLSYLRIPTEQDANPVSIPVCGFERLDTFLDEFSNSKLIVQSTLRHSYVSLENIEVLHTLSRAFDKIYLLISSRTKRNAAHKANGGKLGDLNEAKKTFNWSLKLRMKDISCSLLVAGFLPKNLDPVEAENFNLSDVTRGAKVVFTESILLADSQEKNFTIIDASVYRFMDGTTYKPSPEVIIQFTNLLLSFNDSDEIHFSLPKIKFKMDVNIIWLWFYIRSIWIKFRPNSKLSRNSVSSVKSVNVLDRLRVDIGKMIIELTLPHNTEVLLIFERIGLSSSTKNLTIASLSAYVVSVYVKHIKVYVSLLNINDFELDTEELICKKSAVINTSLIHFHAEYHFRFYMITDNIVTLYKSFKQIKLAFSNLNEFKRLYPQQQFPKKVPNLHICCQDFLIDIEEDPFEQELGLILKVGVLEQRERLKKLEEFKEKLSTYEDMNVRLRSLYDTSRGQSFFPEFYANDQEYEQKAYLRLLENFSTSWIARYRKAKLSFYGMPYRVISREELGTKYHLFTRQKTSTVANLVVKDLDFKLGSPSFPLDNYMDFVYQYGKKVPKSTEYTLLIILGLKIKSALWELRLRDYPIPAISFPDTFTTGDVVFAEKMPAPCALHTVYVPFVSSAQRSPYNDANTIYGLHIIRTINSVKTYFNIRSMVTSSSSARITWGKSLQPGYESLMLWFDFLTKPLIDPSKKLGFWDKFRYLVHGKWIYEFSEESEIHLNIKGSHDPYKITDDGAGLAFCWSGGTTIYVHNSTDPKEFLKIESQRFQLAVPDFAKVSKFDKVFMKLDGRVIWTLGLLFEQGDISKAGDEERFLPNRPHYEIQLMNPDGVADLDHHDTYKGFRTSFIHMSFGVYSSEHGSINSLYLAPYALTHFFKWWNLFHTYTSGPIRQGRLFTDVLQNKTKFGRSLFTIAYQLHLKRLMVTHIYRHITTQYDLEKDRKITFTGLKGRFDSLKIDLHQKRVKLTHTNQKLNKSKPVWKFKMSRGEIDCAEADIRILSTLFDQEAVKEILTSGLDGILEDEPSRPITPQDVEYLRESDWYDYEDYIDLNQVPLGSSLPLKLEAIPLLYSPRISYFRKINDDGYVLAYPFGTEESHNCLIGKNHPELTQEKLATERKREIEEQLKLLHITLSELQSNKGGGSVSGNSERYARELKAEVAELNHRLHTVNTILSDLKISETIPGGNTDGDSSSSLSDTDVNLENAPPIQNRISLLRTNTVESFVSMRKASTMQVESTYDNRFMVHNIELKIDNKIRHHLLEYASSAFERKSMRFAVTYKSVTILKELLGNVLTGVRTSVEDYGSILEDDLASNSEFIEHFEKLIREVPSDDFDYVDNYLFRLISPQVQIKSDVERNAAVILAARDIEMGIIDIVQVYGKSGKRIPVDVDTIVETRYSAVSKDIQLFTLFKKDLEGPEGRFFHKNGYGSDKESDIWPPWIPLEMCFDGSLLDKHVFLKRRSMFLTYVAPNPLFFSANDTSAFSYDSRFRIAFPGLVLTSDCQQYCAVYAIAEDLLSFGSSLDEKVEKLSRILFTDEVRNNLENLDVSVVTALQERIKELYYTRAYLKLHEPRLFMKSGQELTFDIQTSTLKLTLLMTAIKKTYDRMGSGNRVIQKRLRWQVGTDELIWELYDESKTPFVTIGLGPSTFIRSETSDGTNSNKVSISSLQCFNQQENPVYTELLAPFYENSSYNKNAPMVEIFWILGPSVGGISDLQDLIVSLQPLIFKMDHKTSEKLMNYLFPKIEQTSIEPNSPELVPRSSTSSFFSSSPVLRHSLSNGSLSVYDAKDVDSWDLRSIQSKEGIKKHKGDHRKLSASLFVQPDYNINEMVKRSGTFFNVKSIIIRKTLMSVCYKGSHSLLTDVNNLIVRVPVLKYHNKLWSREEFFTALKRDVVRIVLQHLGNIIGNKFLPHKKENKKKTSMEIHRLLSPDSQNRDNSHILEVEGHNSFYSSTHSSDIRSINSDETYNENDGNGVKPFYPVTSEFSKNK');
INSERT INTO proteininfo VALUES ('6325373', 'NP_015441.1','Hypothetical ORF; Ypr116wp [Saccharomyces cerevisiae]','MGLPKSAYKKLLIDCPTRVINKNCAQRVKDVSPLITNFEKWSDKRKKLYFKDEEEMVGQFHLENFNLKNNLYGRLLASPMRAEKISKLKSCRELLIPLKVVPSTGKDQHADKDKLKLVPTLDYSKSYKSSYVLNSASIVQDNLAAATSWFPISVLQTSTPKSLEVDSSTFITEYNANLHAFIKARLSVIPNVGPSSINRVLLICDKRKTPPIEIQVVSHGKGLPITQSVFNLGYLHEPTLEAIVSKDAVTNGIYLDADNDKDLIKHLYSTLLFHSVN');
INSERT INTO proteininfo VALUES ('6325372', 'NP_015440.1','Hypothetical ORF; Ypr115wp [Saccharomyces cerevisiae]','MSDYFTFPKQENGGISKQPATPGSTRSSSRNLELPKNYRSFGGSSDELASMYSADSQYLMDMIPDSLTLKNEPASGNTQMNGPDGKENKDIKLDEYILPKTDPRSPYYINMPIPKKLPKSEGKARAKQKVNRADPSDLDVENIYETSGEFVREYPTDILIDRFHKWKKILKSLIAYFREAAYSQEQIARINYQMKNAVKFAFLTDLEDETNKLVDPSISKLPTKKPQPVPLAAQKLDSKYDTDVEQPQSIQSVPSEEVASASSGFMKFGSGSIQDIQVILKKYHLSLGSQQYKISKEILAYIIPKLTDLRKDLTTKMKEIKELNGDFKTNIGEHIKITSRLLNKYIASVKLLDEASTSGDKQGEKLKPKHDPYLLKLQLDLQLKRQLLEENYLREAFLNLQSAALQLEKIVYSKIQSALQRYSALIDSEARLMIKNLCHELQQGILSRPPAVEWDNFVSHHPTCLMNLKSTDPPPQPRRLSDIVYPNMKSPLAKCIRVGYLLKKTESSKSFTKGYFVLTTNYLHEFKSSDFFLDSKSPRSKNKPVVEQSDISRVNKDGTNAGSHPSSKGTQDPKLTKRRKGLSSSNLYPISSLSLNDCSLKDSTDSTFVLQGYASYHSPEDTCTKESSTTSDLACPTKTLASNKGKHQRTPSALSMVSVPKFLKSSSVPKEQKKAKEEANINKKSICEKRVEWTFKIFSASLEPTPEESKNFKKWVQDIKALTSFNSTQERSNFIEEKILKSRNHNNGKSSQRSKNSTYITPVDSFVNLSEKVTPSSSVTTLNTRKRANRPRYIDIPKSANMNAGAMNSVYRSKVNTPAIDENGNLAIVGETKNSAPQNGMSYTIRTPCKSPYSPYTGEGMLYNRSADNLMASSSRKASAPGEVPQIAVSNHGDEAIIPASAYSDSSHKSSRASSVASIHNQRVDFYPSPLMNLPGVSPSCLALDGNANGYFGIPLNCNSEARRGSDLSPFEMESPLFEENRTQNCSGSRKSSACHIPHQCGPRKEGNDSRLIYGNEKGASQSRLTLKEPLTSKGVEAPYSSLKKTYSAENVPLTSTVSNDKSLHSRKEGSTNTVPATSASSK');
INSERT INTO proteininfo VALUES ('6325371', 'NP_015439.1','Hypothetical ORF; Ypr114wp [Saccharomyces cerevisiae]','MDVLLSLPQPELFKTTVIPFLANRNIIKSEAILSNLHSIFYVAIFYHIWFLFGKWILFPHLVKWKLDYDQKHNVKKDEKTTSERQAQHYKKKYTSLINQSSVHLISLLQSIVVLYYSLKFLLDPKASAEPYQTSHSRVFTENRDTQVICIFAIGYFVWDIYISTMYSTFPFVVHGIISTVVFCIGLKPYIQYYAPVFLMFELSNPSLNFRWFGIKFLPQKSKFCSLLLLLNNLTLMVVFFAARIAWGWFQIGKLCYDFYQVRNEPGFLVFDTIVILAGNFVLDILNVIWFSTMVSVAAKVLKKGESVDKVTKNEQ');
INSERT INTO proteininfo VALUES ('6325370', 'NP_015438.1','phosphatidylinositol synthase; Pis1p [Saccharomyces cerevisiae]','MSSNSTPEKVTAEHVLWYIPNKIGYVRVITAALSFFVMKNHPTAFTWLYSTSCLLDALDGTMARKYNQVSSLGAVLDMVTDRSSTAGLMCFLCVQYPQWCVFFQLMLGLDITSHYMHMYASLSAGKTSHKSVGEGESRLLHLYYTRRDVLFTICAFNELFYAGLYLQLFSNSATFGKWTTIISFPGYVFKQTANVVQLKRAALILADNDAKNANEKNKTY');
INSERT INTO proteininfo VALUES ('6325369', 'NP_015437.1','Essential conserved protein that associates with 35S precursor rRNA and is required for its initial processing at the A(0)-A(2) cleavage sites, shows partial nucleolar localization, contains five consensus RNA-binding domains; Mrd1p [Saccharomyces cerevisiae]','MSRIIVKGLPVYLTDDNLREHFTKRLRQKHSHQAVNGSGPDLITDVKILRDRNGESRRFGFIGYRNEEDAFDAVEYFNGSFINTSKIEVSMAKSFADPRVPQPMKEKRREALKRFREKEEKLLQEENRKKKKVDENKHSNIDDEIRKNKQLQEFMETMKPSSQVTSWEKVGIDKSIEDEKLKREEEDSSVQGNSLLAHALALKEENNKDEAPNLVIENESDDEYSALNRNRDEDQEDAGEEEKMISISNLKDTDIGLVNDDANSDEKENEKRRNLAQDEKVSDLDWFKQRRVRIKESEAETREKSSSYATEQNESLDTKKEEQPERAVPQKTDEELAIEKINQTGRLFLRNILYTSKEEDFRKLFSPFGELEEVHVALDTRTGQSKGFAYVLFKDSKNAVNAYVELDKQIFQGRLLHILPGEEKKSHRLDEFDLKNMPLKKQKELKRKAAASRQTFSWNSLYMNQDAVLGSVAAKLGLEKSQLIDAENSSSAVKQALAEAHVIGDVRKYFESKGVDLTKFSQLKSTNQRDDKVILVKNFPFGTTREELGEMFLPYGKLERLLMPPAGTIAIVQFRDTTSARAAFTKLSYKRFKDGIIYLERGPKDCFTKPAEADDLINNTSAKEEENPVEVKPSSNDLMEANKDVTEGSSNAHDEDVIDGPTVSIFIKNLNFSTTNQNLTDRFKVFTGFVVAQVKTKPDPKHQGKTLSMGFGFVEFRTKEQANAVIAAMDGTVIDGHKIQLKLSHRQASQSGNTKTKSNKKSGKIIVKNLPFEATRKDVFELFNSFGQLKSVRVPKKFDKSARGFAFVEFLLPKEAENAMDQLHGVHLLGRRLVMQYAEEDAVDAEEEIARMTKKVRKQVATNEMAALRNGGGRKKLDVDDEENEGF');
INSERT INTO proteininfo VALUES ('6325368', 'NP_015436.1','Ser/Thr kinase involved in late nuclear division, one of the mitotic exit network (MEN) proteins; necessary for the execution of cytokinesis; Dbf20p [Saccharomyces cerevisiae]','MFSRSDREVDDLAGNMSHLGFYDLNIPKPTSPQAQYRPARKSENGRLTPGLPRSYKPCDSDDQDTFKNRISLNHSPKKLPKDFHERASQSKTQRVVNVCQLYFLDYYCDMFDYVISRRQRTKQVLRYLEQQRSVKNVSNKVLNEEWALYLQREHEVLRKRRLKPKHKDFQILTQVGQGGYGQVYLAKKKDSDEICALKILNKKLLFKLNETNHVLTERDILTTTRSDWLVKLLYAFQDPESLYLAMEFVPGGDFRTLLINTRILKSGHARFYISEMFCAVNALHELGYTHRDLKPENFLIDATGHIKLTDFGLAAGTVSNERIESMKIRLEEVKNLEFPAFTERSIEDRRKIYHNMRKTEINYANSMVGSPDYMALEVLEGKKYDFTVDYWSLGCMLFESLVGYTPFSGSSTNETYENLRYWKKTLRRPRTEDRRAAFSDRTWDLITRLIADPINRVRSFEQVRKMSYFAEINFETLRTSSPPFIPQLDDETDAGYFDDFTNEEDMAKYADVFKRQNKLSAMVDDSAVDSKLVGFTFRHRDGKQGSSGILYNGSEHSDPFSTFY');
INSERT INTO proteininfo VALUES ('6325367', 'NP_015435.1','RNA polymerase subunit, common to RNA polymerase I and III; Rpc40p [Saccharomyces cerevisiae]','MSNIVGIEYNRVTNTTSTDFPGFSKDAENEWNVEKFKKDFEVNISSLDAREANFDLINIDTSIANAFRRIMISEVPSVAAEYVYFFNNTSVIQDEVLAHRIGLVPLKVDPDMLTWVDSNLPDDEKFTDENTIVLSLNVKCTRNPDAPKGSTDPKELYNNAHVYARDLKFEPQGRQSTTFADCPVVPADPDILLAKLRPGQEISLKAHCILGIGGDHAKFSPVSTASYRLLPQINILQPIKGESARRFQKCFPPGVIGIDEGSDEAYVKDARKDTVSREVLRYEEFADKVKLGRVRNHFIFNVESAGAMTPEEIFFKSVRILKNKAEYLKNCPITQ');
INSERT INTO proteininfo VALUES ('6325366', 'NP_015434.1','Hypothetical ORF; Ypr109wp [Saccharomyces cerevisiae]','MDNFESTAEGNLSIGNKRVYELRKRNFQRNLVNNLSFLGYVLISLEYIKYDRTVWTLITRAIVQSLISSPFPSDAKLRRLATLGADNNTTGVATLPGGRSIRFPGMFGTEMLYNSSSEAEQQDHDDTAIVSMKKQIRKFLFHGCLSLNMLFIILTILFPIDFFEPLSGSEPVDDGPKNTPSPFSNSDGLLLGERRGGLFLQMIGERLPKSNFSGNLGLVMFEFSILIVQFTLFSLTCVVLADLDFEEPERLEPVNSDGYDGSVIVARIPLNKTMNAILNDGNINDNNENASNSV');
INSERT INTO proteininfo VALUES ('6325365', 'NP_015433.1','Essential, non-ATPase regulatory subunit of the 26S proteasome, similar to another S. cerevisiae regulatory subunit, Rpn5p, as well as to mammalian proteasome subunits; Rpn7p [Saccharomyces cerevisiae]','MVDVEEKSQEVEYVDPTVNRVPNYEVSEKAFLLTQSKVSIEQRKEAAEFVLAKIKEEEMAPYYKYLCEEYLVNNGQSDLEHDEKSDSLNEWIKFDQELYNELCKKNESKIKELNEKIQKLEEDDEGELEQAQAWINLGEYYAQIGDKDNAEKTLGKSLSKAISTGAKIDVMLTIARLGFFYNDQLYVKEKLEAVNSMIEKGGDWERRNRYKTYYGIHCLAVRNFKEAAKLLVDSLATFTSIELTSYESIATYASVTGLFTLERTDLKSKVIDSPELLSLISTTAALQSISSLTISLYASDYASYFPYLLETYANVLIPCKYLNRHADFFVREMRRKVYAQLLESYKTLSLKSMASAFGVSVAFLDNDLGKFIPNKQLNCVIDRVNGIVETNRPDNKNAQYHLLVKQGDGLLTKLQKYGAAVRLTGSDRV');
INSERT INTO proteininfo VALUES ('6325364', 'NP_015432.1','Essential RNA-binding component of cleavage and polyadenylation factor, contains five zinc fingers; required for pre-mRNA 3'-end processing and polyadenylation; Yth1p [Saccharomyces cerevisiae]','MSLIHPDTAKYPFKFEPFLRQEYSFSLDPDRPICEFYNSREGPKSCPRGPLCPKKHVLPIFQNKIVCRHWLRGLCKKNDQCEYLHEYNLRKMPECVFFSKNGYCTQSPDCQYLHIDPASKIPKCENYEMGFCPLGSSCPRRHIKKVFCQRYMTGFCPLGKDECDMEHPQFIIPDEGSKLRIKRDDEINTRKMDEEKERRLNAIINGEV');
INSERT INTO proteininfo VALUES ('6325363', 'NP_015431.1','Predicted protein kinase, overexpression causes sensitivity to staurosporine, which is a potent inhibitor of protein kinase C; Isr1p [Saccharomyces cerevisiae]','MNSTPPTSPVTRVSDGSFPSISNNSKGFAYRQPQKHKSNFAYSHLVSPVEEPTAKFSEAFQTDYSSKAPVATSEAHLKNDLDVLFTTPRFYSPENLALMFRLSNTVSSLEFLDEFLMGILLAPEMDFLSNPSYSLPSNKLVGQGSYSYVYPISSSASSRCNNDSGVVLKFAKSQHKSKVILQEALTLAYLQYMSPSTNESHIIPFYGLTYITKSHFRRLRSNECVPGLILPKCEMSLYHFNTAVSHKLSLITKRKIWWRLMKQMIDALKSLKTNGIIHGDIKTANILITEMHVLNGGHCKDFDFYLADFTSAFHINQTPTDLNTTVEYCAPELIDSSSDHVPTFESDLYAVGLCLLSFISQHEPYNELQALVSHGSSPGIGSSSIQQSQWLINALLKKDPINLNMLRNDLFQDWKSELALLSRILVDRLPLENLITILDSNYI');
INSERT INTO proteininfo VALUES ('6325362', 'NP_015430.1','Component of the conserved oligomeric Golgi complex; Cog4p [Saccharomyces cerevisiae]','MEGQKSNASWESSIIEGQLSKNLARYTLLLDKLSTLSQIDKLSEVIANDYAKQSKQLNAFVQQSQSSLNKESRKLELQRTNLTTTLTQFHETVATISSSNARAKAIHDDIETVDQERALVNKTLQFVKDVRTLKNNISLAHSALETKDYLVAATAINEIRSLPDKKLIVSEFAKKVVPSSEIPEEPAILIKNWCKELTSLFQEQFMEATRTQDIKELTLMFKMFPMIGQDVLGLDLYSKYVCDIIADESRKIMSNSMENSTKFQGFFSQVLLHLFKIVSTIINDHSKVIATCYGKKHMVHVMEKVEKEADLQASLILDIFMETRKIERTIHDINEWEHSQKNEDVNIDSNQSDIETDGETEKSSIISIHDLALLIMEFSQILQNWSMYSRFYSVKWNEFSDLHPHVLQPPPPIADGKFALKLKQDKVFDEFQVFVLNHLQRSFRNSISLEELPSLNDLITAVPLNDHDNISYPVTSVLDDLILLVRKNLISVVNTGQFKLLASFLNELVKFFQNRFLVKFMQNKFKLLQSKLASNVSLKRYIPKGEEQSATSRSVSPPANKFSPLSRFTFRGAAASALTNIQSNLQAVVAEDEDSILALHHYLIYLNTLYLSKVYVHRLLSIEILEDDSQRILRDNFPFDNDAAQLQNLIINSEKLVLEQTDKLSKWAVKYLFQNILQNRVRNLLGTVFVNSASSNSSTSNQKNVSRDYSAGSNQKNYITSIEDFEDLSQINSFNSKWNQLIIPYKNILHNEAYAELLSVIVDYIVTTLEQRIWTLEFNELGVTKLDRELSLFIGNMCGLNYNLREKFLKLTQIVLLLGLDDDNFDLTTGDIKDDFNGTFDWVINSQERIKARNMKIDRTQ');
INSERT INTO proteininfo VALUES ('6325361', 'NP_015429.1','Putative transcriptional regulator with similarity to DNA-binding domain of Drosophila forkhead; required for rRNA processing; Fhl1p [Saccharomyces cerevisiae]','MDGEMAIIESSNHVGTSSPTTETQFTIDSSALKDQETKESITNSPTSEVPIETKLPKSSDIVTEEKHPQNTTTDIENEVENPVTDDNGNLKLELPDNLDNADFSKLLEFDAKNDEALFNSNELLSHTMDPVNNIDLTHDHSREVSSKEDINIEPVNPDEDEREKTQDNTAAVKTEGIRNSEDTSIQKDEPTADAIYTDVHKLSVNKDTETLPTLVDEKNNMLHMRNNSITPIMFQQHELVGQPPQNTVTENNSTDAETTQRKLSEPIDASLPLPNEQPTIFAYARLDFQSFTFYVQTLHAIIGRRSENDFSHKVDVNLGPSKSISRRHAQIFYNFGTGRFELSIIGKNGAFVDDIFVEKGNTVPLRNKTKIQIGQIPFQFILPEQERNDDSKSPENADIAESEINTRNLKKNEPKSKKKITTGAKPKKAQTKPAVKKEKKPPKIPKKVYTLEEIPVEYRTKPTVSYSAMLTTCIRKYSTAKGMSLSEIYAGIRELFPYYKYCPDGWQSSVRHNLSLNKSFRKVSKEGKGWLWGLDEEYIAERERQKKKQSEIAVAKAQAAQLKLEQQQHKLQQVPQRGKKDIVSQRSNVNARKQNISQTLAANRAASNRKNTASDNQRTMKYLQEQLVILTRDRKGLSKQVIAAILTQALAMTINQVTQAAKNKGITGNPLTALMDKNPQHLNLILAAAVNAATAKVTKGEVKQLVNPETTAAAALAAKAQHSKPIRQPIVQTPHVPDRPPSQLSASASSHPNNYLHDKQPGSFDPSSLSRFFQPRQNARATSSVAATSVPAAASQNVDAQPKPKPAQDNDLESESGTSSSSSSSSESGSESDSGSDDGSASGSGDNSSTSSESESESDSGSEVDEKNNKNEKIDSESIKNNESKDDIPSKDENSSNDNREISKTDEEGHDSKRRKVSEDINEGITEVNVSLEEKL');
INSERT INTO proteininfo VALUES ('6325360', 'NP_015428.1','20S proteasome beta-type subunit, responsible for the chymotryptic activity of the proteasome; Pre2p [Saccharomyces cerevisiae]','MQAIADSFSVPNRLVKELQYDNEQNLESDFVTGASQFQRLAPSLTVPPIASPQQFLRAHTDDSRNPDCKIKIAHGTTTLAFRFQGGIIVAVDSRATAGNWVASQTVKKVIEINPFLLGTMAGGAADCQFWETWLGSQCRLHELREKERISVAAASKILSNLVYQYKGAGLSMGTMICGYTRKEGPTIYYVDSDGTRLKGDIFCVGSGQTFAYGVLDSNYKWDLSVEDALYLGKRSILAAAHRDAYSGGSVNLYHVTEDGWIYHGNHDVGELFWKVKEEEGSFNNVIG');
INSERT INTO proteininfo VALUES ('6325359', 'NP_015427.1','Protein component of the large (60S) ribosomal subunit, nearly identical to Rpl11Bp; involved in ribosomal assembly; depletion causes degradation of proteins and RNA of the 60S subunit; has similarity to E. coli L5 and rat L11; Rpl11ap [Saccharomyces cerevisiae]','MSAKAQNPMRDLKIEKLVLNISVGESGDRLTRASKVLEQLSGQTPVQSKARYTVRTFGIRRNEKIAVHVTVRGPKAEEILERGLKVKEYQLRDRNFSATGNFGFGIDEHIDLGIKYDPSIGIFGMDFYVVMNRPGARVTRRKRCKGTVGNSHKTTKEDTVSWFKQKYDADVLDK');
INSERT INTO proteininfo VALUES ('6325358', 'NP_015426.1','Component of a protein complex associated with the splicing factor Prp19p, essential for mRNA splicing; Snt309p [Saccharomyces cerevisiae]','MDGLSFVDKGKIPDGYKNEIDQLVKKEFANIKREPVHPEIRGILAKRKGADNSVSTLTNALYTEYLKQRNNKKRRTPDFNDDDDTLFLEEYRRKYPRIDTSRYIPNESSEVSLLGIVDSYLKHQEIVLDTLLPQTVSNQWRINNDYIRQTCTIVEEMNIQQRKQINDLEIYRKRL');
INSERT INTO proteininfo VALUES ('6325356', 'NP_015425.1','Mitochondrial ribosomal protein of the large subunit; Mrpl51p [Saccharomyces cerevisiae]','MVVKAIARNSIGRNGVGAFVFPCRKITLQFCNWGGSSEGMRKFLTSKRLDKWGQEFPWIQFEVMRKSGHPLLRAEYTNGREKVICVRNLNIDNVENKLKLLKDSDGDILRRRTKNDNVESLNSSVRGIWSPLHAAKRHRI');
INSERT INTO proteininfo VALUES ('6325354', 'NP_015422.1','Hypothetical ORF; Ypr097wp [Saccharomyces cerevisiae]','MITQDTPALNPTEEHYLKRELLRCQLDYEIGKLNDQFALRKFGYPFSPNDPTAPQPISNNDSSPVLGGKGHFSVNYPMLSYVLQEFISTFPLLSTNLLVDEKFWQSKVQVFFEHFMSLGFSESYDREEASKRKKVSKKLSKVILLLFNSGVGSFQEQAYYNEDKFVLQSGQARKRSNIEKFAMPTRENLENLLTNESVFINGWDVNIISVFNKNSRKCTESVDNDKSSKSTPTSSPKSHAIKSFASTSKWMKNAFNNTINSTINSMPESSASLFSKLSLGVPSTKSKQSRKHHYFLIKIKKQDDDDQDNSNEENSNLDHHAGYFYVTRTYSDFKKLSHDLKSEFPGKKCPRLPHRNKKVTSMITKTEVLHNGQTKSAAREKIVNTFDTDLQSASESDNSSFLQTTNELSATETVLTEKETETLRKNILNEIKEEDNIDEDEYEEEGEGEESDFDEYKDASDSKINTLVGEKMRTSLRQYLRTLCKDAEVSQSSSIRRFFLSGPNLDIKDINPKIADDIRNRALIDVSNLENQIRFQQMALEKSLKLQDSMKDFKTSLLKDEKYLMSLLVEIKDNTKVEDLSPLLQDFVEWCKIYISSMIYQMFLGNDNSYELYTQIRRLHKLMPYTVMGQIMKFTNPIAIMRGMIELFMAQPFGGHSLLQTMFSTILTDDLKTQKVAIKELERKIAEMDPGASVVTKCLKDFVFNNDTKDEHDTKLFTMDAVNAESESMNMPVPLIVLMKSAAANLIPDEVVAGLIESYSSWKLQKEDTDALNVTSEDQSGIYFTHVKDLWQLYIKEHDKQLMRQLWQDPELTQMLKAIVTMIYEPMVKIFKVARMDVALKNFEKFMGDLIRLVDDVINGQLGVSTQFDVVEEIHNLVTKHQDAFFEFIHDVYLNDSEGIFEGFITWITTIVKFLQKSKFGGPSERIDFNKLICRDDIDIDVKLLKVQVNNVLNKKIGARKIYKKLLDLKVKQGTKQNNKHAAGILQKNWSDINSLVMPSSSGSFGLGDGDLVDLDLDTGDYDFLHKENEVELEKQYKDLLNLVVDESEIDKLRSQVFAQELKNYLEAQIAKK');
INSERT INTO proteininfo VALUES ('6325352', 'NP_015420.1','Suppressor of Ypt3; Syt1p [Saccharomyces cerevisiae]','MNQSISSLIKLKFLQSHSNDKNGNKKGGSNVSTGIDKLRESESYRSPFLQLAEIQEHTNNDDDKLDVKECEPTKKHSKLSRIRRKMGRLDLNFRSANEKGSEDDEILVAQHLRNGQDPEEMPFKSENNIDSIEKVPKPDGERVTLTSSGSDNVKRNSKHAPFIPVKPALEKFPSSNRLSRDYRKSQEPTLFNGDRLVPTLPTVSRISTSSSVGSSTAASRYFNPSKRAVVASSSSSSSSIKFNSLHAIPLDATPQIELAKQQDEISKRRFGRRRSRTVDVFDYINKNNTAKNKPPLSPSSFIRTIDEKNTNSLMQDPMGSRGPLLPDDANIISNDTDGAEASHPDHQVLSRSRSQSTSFVQGKGGKRKSIEDEGYHNKLGLPHGSGPTSVYNNKSNANSTITGMSRRSSSIVNALSSFVNLRSSSLSSSRQQHLQQQQQLQQKLDVSLEDLPPVPAPEFSDSCKDFLIKLAPYGKFIGIILTEKDDEFKKNCLNYLLTNCFEFKNDPLDIALRKLLMFLELPKETQQIDRLIMAFSFAYYKAQKSYSKKKGIECPWSNADQVYFIAFSLLMLHTDYFNPNNKSKMTKHDFVDLVHNDKYSGGNEIPMAVLTYFYENVTAKESPKFNYFLMSPMALDDSILDKDAFDTNFAITLSSNSMYSPIDMIKRGSIIPKEASLSPIFYPLTNSISASGIAPSTAASCPPSTSGTINGANLGTANSNSNRPASNSISSYFSYNPSSSSSGNATLVQDDINVYSHIINDTLNEVNLFPEVSKYWNKNALKANLLRNEEHKYEKYYSIMNDTKGGYLRFHKSQLNKLNLPNFEILNDNSRSGCKNSDYKYCKILQMGAIMNLGMPSRKFSIVNSAKIHWKKEFAILTSLGLLICDKMDWINPQMMKDPKSGTTNYIIDFKSGFSFVPGSTIDVYNGLFADRERDSLGKSHFASLVLAYTEHHSTGSHTSNTTAASSSAKHNEGVFEPSSDEEDSITNSTDGTSSVSNGESDNDSVSSSDNQLSSNDSNEDYHSIKDEYPIFEDENADCLLYLHTCHRNFIWKCANKYERDNWIDSINLFSAYDGCYVEIGSIANTICNKRKLTILQRMERLRSIKSAKWEKLKKFESTLMLMGKCVPISTKTKTDMINRIRQLAVRMDWLIYEIKRSELFVSIIKEVTRKQAEKNILEHGKGEEEGQGNNDDSDGIDDIEESFLFNENSLQVCVSDSSYDEYSNE');
INSERT INTO proteininfo VALUES ('6325351', 'NP_015419.1','Well-conserved 12-kDa protein with five CxxC zinc fingers that has been implicated in the activation of certain drug transport genes and in the pre-mRNA splicing pathway; Protein required for cell viability; Rds3p [Saccharomyces cerevisiae]','MSRHQFDLIMCLKQPGVQTGLLCEKCDGKCPICDSYVRPKRKVRVCENCSFGKQAKNCIICNLNVGVNDAFYCWECCRLGKDKDGCPRILNLGSNRLDRHFEKKKKV');
INSERT INTO proteininfo VALUES ('6325349', 'NP_015416.1','Hypothetical ORF; Ypr091cp [Saccharomyces cerevisiae]','MASLKVFLAVYLLGGITFLPLVLFTLYKIHLLYSNLKSASKKELDHDTADEIDEKTRLLARDIDPEFKARKLEEQLGVKVFNKGWITVTKQYYYHSSEVAVILKNSNNNKDSDTALQEQILQRTDLKKKQRFFAVLRHGNLFLYKDDSQNANLVHAISLQNRFITIWPRFDELGKEELPDASLFTKRTCIAIFKNDLVSIDSKNHNVILPHFDPLTSAESNNGDISTNDTTHEYQSQFHSSNQFFLYFDNNMDKEDWYYQLINASKNSNSLSTGLLDPNVSANAAHLKTKDMLQLIQDINSTENQLTTKWLNALLGRLFLSLQQTDTLNKFIHEKICKKLNKIKTPGFLDDLVVEKVDVGDSAPLFTSPELLELSPEGSTKIAIDVQYRGNLTIIIATKASINLGSRFKQREVSLQLSIKIKEFSGPLLFLIKPPPSNRIWYAFRTEPIMDFEIEPIVSSSKLSYNVVTNAIKSKFAEAVKESLVVPFMDDIVFYPTPNEVYRGGIWEEQDPEAAARARTAAAASDMNNTSAKEHLEALQEGGMKTQSRIKKALRPERKKENLKDLVDASGVATKTTTQTTVTTATNDDVSSSENSTKSRKYFKNSIKKIGRWYKDNVGNSSDTEDMDEIDVQDKKNDDSADERESDNPILTSNPKMISNRRPVPRRPSQPLNTLSPKLEGRKEKDTENFPVPPSASNMNASKMFANKENRKFSVSSNDSQNSLKNGDPHVKASKLESSQAFVKKTSQNRFNDGFFKQDLEFEEQREPKL');
INSERT INTO proteininfo VALUES ('6325345', 'NP_015413.1','Signal recognition particle subunit (homolog of mammalian SRP54); Srp54p [Saccharomyces cerevisiae]','MVLADLGKRINSAVNNAISNTQDDFTTSVDVMLKGIVTALLESDVNIALVSKLRNNIRSQLLSENRSEKSTTNAQTKKLIQKTVFDELCKLVTCEGSEEKAFVPKKRKTNIIMFVGLQGSGKTTSCTKLAVYYSKRGFKVGLVCADTFRAGAFDQLKQNAIRARIPFYGSYTETDPAKVAEEGINKFKKEKFDIIIVDTSGRHHQEEELFQEMIEISNVIKPNQTIMVLDASIGQAAEQQSKAFKESSDFGAIILTKMDGHARGGGAISAVAATNTPIIFIGTGEHIHDLEKFSPKSFISKLLGIGDIESLFEQLQTVSNKEDAKATMENIQKGKFTLLDFKKQMQTIMKMGPLSNIAQMIPGMSNMMNQVGEEETSQKMKKMVYVLDSMTKEELESDGRMFIEEPTRMVRVAKGSGTSVFEVEMILMQQQMMARMAQTATQQQPGAPGANARMPGMPNMPGMPNMPGMPNMPGMPKVTPQMMQQAQQKLKQNPGLMQNMMNMFGGGMGGGMGGGMPDMNEMMKMMQDPQMQQMAKQFGMG');
INSERT INTO proteininfo VALUES ('6325343', 'NP_015411.1','transcription factor TFIIB homolog; Sua7p [Saccharomyces cerevisiae]','MMTRESIDKRAGRRGPNLNIVLTCPECKVYPPKIVERFSEGDVVCALCGLVLSDKLVDTRSEWRTFSNDDHNGDDPSRVGEASNPLLDGNNLSTRIGKGETTDMRFTKELNKAQGKNVMDKKDNEVQAAFAKITMLCDAAELPKIVKDCAKEAYKLCHDEKTLKGKSMESIMAASILIGCRRAEVARTFKEIQSLIHVKTKEFGKTLNIMKNILRGKSEDGFLKIDTDNMSGAQNLTYIPRFCSHLGLPMQVTTSAEYTAKKCKEIKEIAGKSPITIAVVSIYLNILLFQIPITAAKVGQTLQVTEGTIKSGYKILYEHRDKLVDPQLIANGVVSLDNLPGVEKK');
INSERT INTO proteininfo VALUES ('6325341', 'NP_015409.1','Hypothetical ORF; Ypr084wp [Saccharomyces cerevisiae]','MSEKASEERPIRLAVLGGTSTGKTSLVSRLTVNIVHEVHYPTRNQTNWLFGFVPSSILARAILDEQAHERLCLRSPSSQTLEPIFPSPQVSKNVLLSPLVFQASTDNFQSVRLHNKSHSRRSLSLDKSDSPLYQTFSNDINSQSVPKIKADQLNVIEHFKLPLNYIPPTYAPIQIDIIDTPGFSPDNVVPFLEVSLFRNLGKSILHGLADEPRRPVSTTSLLVASGASELNGKVDGYILVYSAVPELNHIGGPPEYGDDVMNTDTENVSDGGFELLKVIRNCILDAWTEFRNYEKRWEEGKEDDIYSLVYSLRHLWSKNSKEKSAKIEQLRSYNTKLKSIELDPSSPDSPPPCIIVCSHVNHELASPMLIEMGRQLATKWKYGFVGIDSMDDLNVDVAVSLLIKEISEKMKLLVSNSNGSSSSGNSSSIYNSHLMNDKKKNNNAGLNKNMLKKIIK');
INSERT INTO proteininfo VALUES ('6325340', 'NP_015408.1','Mitochondrial Distribution and Morphology; Mdm36p [Saccharomyces cerevisiae]','MDENGTVKPGYELKGLNSGNSRSNMDKDPIVSKFHRAGLNDSADEEDTDINGNRNTSWITSMISEEKRKVEGKSMLNDEEDLHLSKATLNKCDALVKILADIIKLEFVIHQSWYIRSLHKSVLIQFEVETSGGNKNSAGDSGDDDDDNHNGNLDDSFYKDLSLKCIKKCEKSSLALESLSRDIDQIRDFIMSNTIEDNRVDRLLQNSMTLLLECWIYSMKRLRRLRMKIAGIFVRSKLLLIDHELVTIWHFLQEQNEHETVNNENELKLAETIKSYRAFIKIFIQQLEDSESGSPSSSLFEECLHVFLDIESMYNSLNLNWLLNENKALQERLLSPSSTSENDHTNNLPVIDETKEIEDISSFVNSIVDASMLTHDLTPINSSDSDNLSNGEIDRLDGRRLSSSTSDMSLMMQRTSLQKQLPSLLTAFNNARRLEQELQNACKVNDNKHSTKDTDSNIRRNEHAMSSSVSSIISQNSTLASPSPPMSSSFISTAPSQSSSRMSTLPLSPSSSLLESQSQTLKNNMSQWLNQSRSGLNGTKLIPTNHIGFHSNVLNTLYGIGGGPVSKSYKSNQPSSQNT');
INSERT INTO proteininfo VALUES ('6325339', 'NP_015407.1','17-kDa component of the U4/U6aU5 tri-snRNP, plays an essential role in pre-mRNA splicing, orthologue of the human U5-specific 15-kDa protein; Dib1p [Saccharomyces cerevisiae]','MASVLLPQLRTGWHVDQAIVTETKRLVVIRFGRKNDRQCMIMDELLSSIAERVRNFAVIYLCDIDEVSDFDEMYELTDPMTVMFFYHNKHMMCDFGTGNNNKLNFIVDDKQEMIDILETIFRGARKNKGLVVSPYDYNHKRVS');
INSERT INTO proteininfo VALUES ('6325338', 'NP_015406.1','Protein with sequence similarity to Grs1p, which is a glycyl-tRNA synthetase; cannot substitute for Grs1p; possible pseudogene that is expressed at very low levels; Grs2p [Saccharomyces cerevisiae]','MPLMSNSERDKLESTLRRRFFYTPSFEIYGGVSGLFDLGPPGCQLQNNLIRLWREHFIMEENMLQVDGPMLTPYDVLKTSGHVDKFTDWMCRNPKTGEYYRADHLIEQTLKKRLLDKDVNPQDMKNMEKILTTIDGFSGPELNLVMQEYNINDPVTNDVLDALTSFNLMFETKIGASGQLKAFLRPETAQGQFLNFNKLLEINQGKIPFASASIGKSFRNEISPRSGLLRVREFLMAEIEHFVDPLNKSHAKFNEVLNEEIPLLSRRLQESGEVQLPVKMTIGEAVNSGMVENETLGYFMARVHQFLLNIGINKDKFRFRQHLKNEMAHYATDCWDGEILTSYGWIECVGCADRAAFDLTVHSKKTGRSLTVKQKLDTPKERTEWVVEVNKKFFGSKFKQKAKLIESVLSKFSQDELIRRHEELEKNGEFTCQVNGQIVKLDSSLVTIKMKTTLQHIREYIPNVIEPSFGLGRIIYCIFDHCFQVRVDSESRGFFSFPLQIAPIKVFVTTISNNDGFPAILKRISQALRKREIYFKIDDSNTSIGKKYARNDELGTPFGITIDFETIKDQTVTLRERNSMRQVRGTITDVISTIDKMLHNPDESDWDKSTFGLSPVKI');
INSERT INTO proteininfo VALUES ('6325337', 'NP_015405.1','functions in the binding reaction of aminoacyl-tRNA (AA-tRNA) to ribosomes; translational elongation factor EF-1 alpha; Tef1p [Saccharomyces cerevisiae]','MGKEKSHINVVVIGHVDSGKSTTTGHLIYKCGGIDKRTIEKFEKEAAELGKGSFKYAWVLDKLKAERERGITIDIALWKFETPKYQVTVIDAPGHRDFIKNMITGTSQADCAILIIAGGVGEFEAGISKDGQTREHALLAFTLGVRQLIVAVNKMDSVKWDESRFQEIVKETSNFIKKVGYNPKTVPFVPISGWNGDNMIEATTNAPWYKGWEKETKAGVVKGKTLLEAIDAIEQPSRPTDKPLRLPLQDVYKIGGIGTVPVGRVETGVIKPGMVVTFAPAGVTTEVKSVEMHHEQLEQGVPGDNVGFNVKNVSVKEIRRGNVCGDAKNDPPKGCASFNATVIVLNHPGQISAGYSPVLDCHTAHIACRFDELLEKNDRRSGKKLEDHPKFLKSGDAALVKFVPSKPMCVEAFSEYPPLGRFAVRDMRQTVAVGVIKSVDKTEKAAKVTKAAQKAAKK');
INSERT INTO proteininfo VALUES ('6325336', 'NP_015404.1','Mannose 6-phosphate Receptor Like; Mrl1p [Saccharomyces cerevisiae]','MLKRSSLIYLSCVLIITIPILLHVYNGPGLSHEANEHRASHKQKRTLANPDKPKSENDEDLFCAVTNPVTGSYIDLSQLSSTPNKLREGQKQISGNNKHESSKTKWSVRGWGYDTNFTLGICSSPVGEAESQQLSNLTGAFYVDQLNENNLVSIGDFSTRPALVGGSTAKKLTLKYENGSMCPNGKDKKATLLNFVCDKEIQSKAQISYIGNLHNCSYFFEVRSIHACPTSNKKNEVNVLGIFIGIFAIFFLVEFAGRRWIYAKLNRHLKNDDELHDISPSLNEQPHWDLIEDGSRWSKFFNGIIKTTRRFTKSLMRSLVRGRNSRQGGIRLRSSPSASSSSLANREFFRDMEAQNEIIDSLDINSHTTESDHPTLADNSV');
INSERT INTO proteininfo VALUES ('6325335', 'NP_015403.1','Hypothetical ORF; Ypr078cp [Saccharomyces cerevisiae]','MQTISGVLPTVLSPSELRSDDERTFQFDEEAEITTHLTESEDLRRLINETAQLGVRVDHIHDKTDQEIARLEKVIKEVTESDTFFRSCSGWFKTNKNFSDSESSSNTQLKSLSQLHGRYDRDWRQRLNKWFRKNKSKLALPSDNNLEEVNDDKVYGYGEDLMERGKTPYFSDIDDFMNGLNIISPLTPDDFENDDTLVKIDETCQIHSASEPEKTSISPTFGKNIKKELVTDDTESIISGPPLQENKKTLLKYRYVRTSLDMLGSEKSSSKNNSGGMFRIFHKSANFGDKNQENVPRVWDTLRNNLGREIYLLQGRFKKWTTKHQNLKKGQPCKDEDAVTVPLPSSDPGKETQLETKLCFVPEPGDQPLVQA');
INSERT INTO proteininfo VALUES ('6325333', 'NP_015400.1','Protein of unknown function, overproduction blocks cell cycle arrest in the presence of mating pheromone; Opy2p [Saccharomyces cerevisiae]','MSSSSKASASSSLSSTATSSTSATRGSDGCVVCDSTASCPVCASGEYCVMTSLTCDKCPSTYCAKQSDSQLSSLSSSSSSSSSSNSNEKTSLIVGFTVGIVGGAMLIALVALYFINKRYWKPKRQKNKALKLEEASQSYGNEEEYFDDEDDDDEDDEDDGGMRKDESHTLFNTSLVPPTLNVPGNRSSASTTRTRASNILPIAYIPGVTSGLSTDKLQSKLRSSSKRQNAAGDIRSHITLGSSILDGLDDEDDEHNQVLNKDADDNLITAIRAKPKLVQIAEEESDKEIQDLDVIEEQTEADDLSHMAKSEASHGNNDEDDDEEGSFILDLEIPESIRESTQGSRTESPFEDKFEIHDER');
INSERT INTO proteininfo VALUES ('6325331', 'NP_015399.1','Transketolase 1; Tkl1p [Saccharomyces cerevisiae]','MTQFTDIDKLAVSTIRILAVDTVSKANSGHPGAPLGMAPAAHVLWSQMRMNPTNPDWINRDRFVLSNGHAVALLYSMLHLTGYDLSIEDLKQFRQLGSRTPGHPEFELPGVEVTTGPLGQGISNAVGMAMAQANLAATYNKPGFTLSDNYTYVFLGDGCLQEGISSEASSLAGHLKLGNLIAIYDDNKITIDGATSISFDEDVAKRYEAYGWEVLYVENGNEDLAGIAKAIAQAKLSKDKPTLIKMTTTIGYGSLHAGSHSVHGAPLKADDVKQLKSKFGFNPDKSFVVPQEVYDHYQKTILKPGVEANNKWNKLFSEYQKKFPELGAELARRLSGQLPANWESKLPTYTAKDSAVATRKLSETVLEDVYNQLPELIGGSADLTPSNLTRWKEALDFQPPSSGSGNYSGRYIRYGIREHAMGAIMNGISAFGANYKPYGGTFLNFVSYAAGAVRLSALSGHPVIWVATHDSIGVGEDGPTHQPIETLAHFRSLPNIQVWRPADGNEVSAAYKNSLESKHTPSIIALSRQNLPQLEGSSIESASKGGYVLQDVANPDIILVATGSEVSLSVEAAKTLAAKNIKARVVSLPDFFTFDKQPLEYRLSVLPDNVPIMSVEVLATTCWGKYAHQSFGIDRFGASGKAPEVFKFFGFTPEGVAERAQKTIAFYKGDKLISPLKKAF');
INSERT INTO proteininfo VALUES ('6325330', 'NP_015398.1','Homologous to mammalian phosphotyrosine phosphatase; 18-kDa phosphotyrosine phosphatase of unknown function; Ltp1p [Saccharomyces cerevisiae]','MTIEKPKISVAFICLGNFCRSPMAEAIFKHEVEKANLENRFNKIDSFGTSNYHVGESPDHRTVSICKQHGVKINHKGKQIKTKHFDEYDYIIGMDESNINNLKKIQPEGSKAKVCLFGDWNTNDGTVQTIIEDPWYGDIQDFEYNFKQITYFSKQFLKKEL');
INSERT INTO proteininfo VALUES ('6325329', 'NP_015397.1','Subunit of the CCR4-NOT complex, which is a global transcriptional regulator with roles in transcription initiation and elongation and in mRNA degradation; Not5p [Saccharomyces cerevisiae]','MSQRKLQQDIDKLLKKVKEGIEDFDDIYEKFQSTDPSNSSHREKLESDLKREIKKLQKHRDQIKTWLSKEDVKDKQSVLMTNRRLIENGMERFKSVEKLMKTKQFSKEALTNPDIIKDPKELKKRDQVLFIHDCLDELQKQLEQYEAQENEEQTERHEFHIANLENILKKLQNNEMDPEPVEEFQDDIKYYVENNDDPDFIEYDTIYEDMGCEIQPSSSNNEAPKEGNNQTSLSSIRSSKKQERSPKKKAPQRDVSISDRATTPIAPGVESASQSISSTPTPVSTDTPLHTVKDDSIKFDNSTLGTPTTHVSMKKKESENDSEQQLNFPPDRTDEIRKTIQHDVETNAAFQNPLFNDELKYWLDSKRYLMQPLQEMSPKMVSQLESSLLNCPDSLDADSPCLYTKPLSLPHPTSIFFPNEPIRFVYPYDVPLNLTNNENDTDNKFGKDSKAKSKKDDDIYSRTSLARIFMKFDLDTLFFIFYHYQGSYEQFLAARELFKNRNWLFNKVDRCWYYKEIEKLPPGMGKSEEESWRYFDYKKSWLARRCGNDFVYNEEDFEKL');
INSERT INTO proteininfo VALUES ('6325328', 'NP_015396.1','Hypothetical ORF; Ypr071wp [Saccharomyces cerevisiae]','MQNGTEDKSNIPARSNDDVLPPLAVRLTMKVMRLIFIGKMFAYSFVPFPPFKLLTFDNTVGWFVAYSAIVSIWGFAVWMERGYRHKINLLPPRCTKIRCSRCNTRIRSPNWFKYKNWLYFFLLYVSLTTSNLIIQLASFMTEMSRRGISVPGTKDPGKRDYLGLIIPMRFIGAFIHYMTANLFKEYYLHNGPLEKNDRPSTDEKTSENETL');
INSERT INTO proteininfo VALUES ('6325327', 'NP_015395.1','Subunit 1 of the Mediator complex essential for transcriptional regulation; Med1p [Saccharomyces cerevisiae]','MVEGDSYVETLDSMIELFKDYKPGSITLENITRLCQTLGLESFTEELSNELSRLSTASKIIVIDVDYNKKQDRIQDVKLVLASNFDNFDYFNQRDGEHEKSNILLNSLTKYPDLKAFHNNLKFLYLLDAYSHIESDSTSHNNGSSDKSLDSSNASFNNQGKLDLFKYFTELSHYIRQCFQDNCCDFKVRTNLNDKFGIYILTQGINGKEVPLAKIYLEENKSDSQYRFYEYIYSQETKSWINESAENFSNGISLVMEIVANAKESNYTDLIWFPEDFISPELIIDKVTCSSNSSSSPPIIDLFSNNNYNSRIQLMNDFTTKLINIKKFDISNDNLDLISEILKWVQWSRIVLQNVFKLVSTPSSNSNSSELEPDYQAPFSTSTKDKNSSTSNTEPIPRSNRHGSVVEASRRRRSSTNKSKRPSITEAMMLKEEGLQQFNLHEILSEPAIEEENGDSIKEHSTTMDGANDLGFTASVSNQENAGTDIVMEDHGVLQGTSQNYGTATADDADIEMKDVSSKPSKPESSVLQLIVSEDHIILDTISECNLYDDVKCWSKFIEKFQDIVS');
INSERT INTO proteininfo VALUES ('6325326', 'NP_015394.1','biosynthesis of spermidine; putrescine aminopropyltransferase (spermidine synthase); Spe3p [Saccharomyces cerevisiae]','MAQEITHPTIVDGWFREISDTMWPGQAMTLKVEKVLHHEKSKYQDVLIFKSTTYGNVLVLDNVIQATERDEFAYQEMIAHLALNSHPNPKKVLVIGGGDGGVLREVVKHDSVEEAWLCDIDEAVIRLSKEYLPEMAASYSHPKVKTHIGDGFQFLRDYQNTFDVIITDSSDPEGPAETLFQKEYFQLLNSALTEKGVITTQAESMWIHLPIIKDLKKACSEVFPVAEYSFVTIPTYPTGTIGFMVCSKDKTCNVKKPLREISDEKEAELYRYYNKKIHEASFVLPTWAAKELN');
INSERT INTO proteininfo VALUES ('6325325', 'NP_015393.1','Putative class I histone deacetylase (HDAC) with sequence similarity to Hda1p, Rpd3p, Hos2p, and Hos3p; deletion results in increased histone acetylation at rDNA repeats; interacts with the Tup1p-Ssn6p corepressor complex; Hos1p [Saccharomyces cerevisiae]','MSKLVISTSIFQSQVADLLPCNNHQKSQLTYSLINAYDLLQHFDEVLTFPYARKDDLLEFHSKSYIDYLINGRFNKMMAQDVNNPMVESKWSELSELADNWNEKIDYNPSQDLQRFTTRENLYNYYLNHSQALENNMDCINNSEVPTNDKPTDTYILNSETKQYNLEGDCPIFSYLPMYCQVITGATLNLLDHLSPTERLIGINWDGGRHHAFKQRASGFCYINDVVLLIQRLRKAKLNKITYVDFDLHHGDGVEKAFQYSKQIQTISVHLYEPGFFPGTGSLSDSRKDKNVVNIPLKHGCDDNYLELIASKIVNPLIERHEPEALIIECGGDGLLGDRFNEWQLTIRGLSRIIINIMKSYPRAHIFLLGGGGYNDLLMSRFYTYLTWCVTKQFSNLRCGDNNSFQIDPFDVCDGDDSEQFIREHDLVEMYNEENYQYWIYEMEGSSRMKMLRNDNKDRDMVELMKFYEL');
INSERT INTO proteininfo VALUES ('6325324', 'NP_015392.1','Protein required for maturation of mitochondrial and cytosolic Fe/S proteins, localizes to the mitochondrial intermembrane space, overexpression of ISA2 suppresses grx5 mutations; Isa2p [Saccharomyces cerevisiae]','MQAKLLFTRLNFRRPSTTLRQFPLTCFLFHSKAFYSDLVTKEPLITPKRIINKTPGLNLSISERASNRLAEIYRNSKENLRISVESGGCHGFQYNLTLEPATKPDIKNDVKDKEFSDDLDDDDSKDIIYVLPEDKGRVIIDSKSLNILNNTTLTYTNELIGSSFKIINGSLKSSCGCGSSFDIEN');
INSERT INTO proteininfo VALUES ('6325323', 'NP_015391.1','Protein that acts together with Ula1p to activate Rub1p before its conjugation to proteins (neddlyation), which may play a role in protein degradation; GFP-fusion protein localizes to the cytoplasm in a punctate pattern; Uba3p [Saccharomyces cerevisiae]','MDCKILVLGAGGLGCEILKNLTMLSFVKQVHIVDIDTIELTNLNRQFLFCDKDIGKPKAQVAAQYVNTRFPQLEVVAHVQDLTTLPPSFYKDFQFIISGLDAIEPRRFINETLVKLTLESNYEICIPFIDGGTEGLKGHVKTIIPGITACWECSIDTLPSQQDTVPMCTIANNPRCIEHVVEYVSTIQYPDLNIESTADMEFLLEKCCERAAQFSISTEKLSTSFILGIIKSIIPSVSTTNAMVAATCCTQMVKIYNDLIDLENGNNFTLINCSEGCFMYSFKFERLPDCTVCSNSNSN');
INSERT INTO proteininfo VALUES ('6325322', 'NP_015390.1','Heme-dependent repressor of hypoxic genes; contains an HMG domain that is responsible for DNA bending activity; Rox1p [Saccharomyces cerevisiae]','MNPKSSTPKIPRPKNAFILFRQHYHRILIDEWTAQGVEIPHNSNISKIIGTKWKGLQPEDKAHWENLAEKEKLEHERKYPEYKYKPVRKSKKKQLLLKEIEQQQQQQQKEQQQQKQSQPQLQQPFNNNIVLMKRAHSLSPSSSVSSSNSYQFQLNNDLKRLPIPSVNTSNYMVSRSLSGLPLTHDKTARDLPQLSSQLNSIPYYSAPHDPSTRHHYLNVAQAQPRANSTPQLPFISSIINNSSQTPVTTTTTSTTTATSSPGKFSSSPNSSVLENNRLNSINNSNQYLPPPLLPSLQDFQLDQYQQLKQMGPTYIVKPLSHTRNNLLSTTTPTHHHIPHIPNQNIPLHQIINSSNTEVTAKTSLVSPK');
INSERT INTO proteininfo VALUES ('6325320', 'NP_015388.1','Hypothetical ORF; Ypr063cp [Saccharomyces cerevisiae]','MTLNNVARPDLCVSYKKIAPPKGLYSATPSISGVVNQSMPMAAIFLRNKFIAWFSLIQSVHYYLNTDEDIIVAYKENKAPSPMDQPPAIKLFMSLIGLCVCYMNLVFPQQIAQPSSSGSKGNTETTIETTTEVETETAKQ');
INSERT INTO proteininfo VALUES ('6325319', 'NP_015387.1','Cytosine deaminase, involved in salvage pathways of pyrimidine metabolism; Fcy1p [Saccharomyces cerevisiae]','MVTGGMASKWDQKGMDIAYEEAALGYKEGGVPIGGCLINNKDGSVLGRGHNMRFQKGSATLHGEISTLENCGRLEGKVYKDTTLYTTLSPCDMCTGAIIMYGIPRCVVGENVNFKSKGEKYLQTRGHEVVVVDDERCKKIMKQFIDERPQDWFEDIGE');
INSERT INTO proteininfo VALUES ('6325318', 'NP_015386.1','Probable Hsp40p co-chaperone, has a DnaJ-like domain and appears to be involved in ER-associated degradation of misfolded proteins containing a tightly folded cytoplasmic domain; inhibits replication of Brome mosaic virus in S. cerevisiae; Jid1p [Saccharomyces cerevisiae]','MLHHKFVYPFLFKWHLSCVEKCPPQITFIAKYATANDKNGNRKLTIRDEQWPELADPTPYDIFGIPKAGSGNPKLDKKSLKKKYHRYVKLYHPDHSDNIQIFSSEKVTNSDSKSPLLLTSSEKLHRFKVISQAYDILCDPKKKIVYDTTRQGWTTSYSPRSNVNTENYQYAGSYGYHSNAQYEYWNAGTWEDANSMKNERIQENINPWTVIGIICGLAICIEGTALLAKIQESLSKAEFTHDESGLHLIQSYTNYGLDTDKFSRLRRFLWFRTWGLYKSKEDLDREAKINEEMIRKLKAAK');
INSERT INTO proteininfo VALUES ('6325317', 'NP_015385.1','Chorismate mutase, catalyzes the conversion of chorismate to prephenate to initiate the tyrosine/phenylalanine-specific branch of aromatic amino acid biosynthesis; Aro7p [Saccharomyces cerevisiae]','MDFTKPETVLNLQNIRDELVRMEDSIIFKFIERSHFATCPSVYEANHPGLEIPNFKGSFLDWALSNLEIAHSRIRRFESPDETPFFPDKIQKSFLPSINYPQILAPYAPEVNYNDKIKKVYIEKIIPLISKRDGDDKNNFGSVATRDIECLQSLSRRIHFGKFVAEAKFQSDIPLYTKLIKSKDVEGIMKNITNSAVEEKILERLTKKAEVYGVDPTNESGERRITPEYLVKIYKEIVIPITKEVEVEYLLRRLEE');
INSERT INTO proteininfo VALUES ('6325315', 'NP_015383.1','Putative mitochondrial inner membrane transporter, member of the mitochondrial carrier (MCF) family; Ymc1p [Saccharomyces cerevisiae]','MSEEFPSPQLIDDLEEHPQHDNARVVKDLLAGTAGGIAQVLVGQPFDTTKVRLQTSSTPTTAMEVVRKLLANEGPRGFYKGTLTPLIGVGACVSLQFGVNEAMKRFFHHRNADMSSTLSLPQYYACGVTGGIVNSFLASPIEHVRIRLQTQTGSGTNAEFKGPLECIKKLRHNKALLRGLTPTILREGHGCGTYFLVYEALIANQMNKRRGLERKDIPAWKLCIFGALSGTALWLMVYPLDVIKSVMQTDNLQKPKFGNSISSVAKTLYANGGIGAFFKGFGPTMLRAAPANGATFATFELAMRLLG');
INSERT INTO proteininfo VALUES ('6325314', 'NP_015382.1','Protein involved in snRNP biogenesis; Spliceosomal snRNP component; Brr1p [Saccharomyces cerevisiae]','MKRGESQAPDAIFGQSRAFALSDSSVNPDVIEYLKSVRQEALRTNAISIKNHMNLQKRTRHKSSMYDDEDEGALKRHAISPSLIRLQRNVEIWVRWFNSVKATVLTNAYEFTGYEDETLDLLLLFLKNYLEDMPSKCTTVEKIISVLNQHSFPEKAEEKEENLQIDEEWAKNILVRLEKTKIDSVEDVKKVITEGDKHELVGYNQWFQYLINNEPQHTTFHEKITSKQLWVLIKYMSNTWIKEIHKKGRHYRRLQDWLFYILVHTPERVTAEYTSILRDLGKKCLELIQKKPVEAHENKITLPKEMAELNVEIPAAVENMTITELTVSVIAVNYGQKDLIE');
INSERT INTO proteininfo VALUES ('6325313', 'NP_015381.1','Subunit of TFIIH complex, involved in transcription initiation, similar to 34 kDa subunit of human TFIIH; Tfb4p [Saccharomyces cerevisiae]','MDAISDPTFKHARSRKQVTEESPSLLTVIIEIAPKLWTTFDEEGNEKGSIIKVLEALIVFLNAHLAFNSANKVAVIAAYSQGIKYLYPESTSALKASESENKTRSDLKIINSDMYRRFRNVDETLVEEIYKLFELEKKQIEQNSQRSTLAGAMSAGLTYVNRISKESVTTSLKSRLLVLTCGSGSSKDEIFQYIPIMNCIFSATKMKCPIDVVKIGGSKESTFLQQTTDATNGVYLHVESTEGLIQYLATAMFIDPSLRPIIVKPNHGSVDFRTSCYLTGRVVAVGFICSVCLCVLSIIPPGNKCPACDSQFDEHVIAKLKRKPVVPRLKAKKKVTKP');
INSERT INTO proteininfo VALUES ('6325312', 'NP_015380.1','Essential 121kDa subunit of the exocyst complex (Sec3p, Sec5p, Sec6p, Sec8p, Sec10p, Sec15p, Exo70p, and Exo84p), which has the essential function of mediating polarized targeting of secretory vesicles to active sites of exocytosis; Sec8p [Saccharomyces cerevisiae]','MDYLKPAQKGRRRGLSINSLSETQQSAMNSSLDHLQNDLNRINLQWNRILSDNTNPLELALAFLDDTSVGLGHRYEEFNQLKSQIGSHLQDVVNEHSQVFNTNVASYGKAVSSIMQAQEQTLNLKNCLKEANEKITTDKGSLQELNDNNLKYTKMIDVLVNIEELLQIPEKIEENIRKENFHQVQILLERGFILMNNKSLKTVEILKPINQQLELQEHLLFNNLIEEIHDIMYSKSNKTNFTRVTNNDIFKIISISHNGFTSLENYLYNIVNIDIMEHSKTINKNLEQFIHDQSLNKGNIMLQENAATQAPLAPSRNQENEGFNRIGFLLKTINNINKLPVAFNIITERAKEEIHNIIVKSTESIRSKHPSLLKMATSLKNDNHFGLPVQDILSIILRECFWEIFLKLLYAIQCHRAIFEMSNILQPTSSAKPAFKFNKIWGKLLDEIELLLVRYINDPELISSNNGSIKPINGATNNAPTLPKRKNPKIFSLEYNIEDNSSVKDQAFELKALLKDIFPGFSVSSNMDLDSIYVKDESFEQDEPLVPPSVFNMKVILDPFLLFTQSTSTIVPSVLTQNTISSLTFFDDYMNKSFLPKIQMTMDYLFTVEVESNNPYALELSDENHNIFKTALDFQRLFYNLLNVFNTANTFREKISYCILDLLNHFYNYYLGLFNSLIGTSDRHLTRKIITAWLQNGILMDQEQKILNGDETLFHEESIELFKEIPHFYQAGKGLSKSDLFNNLTLDTILQFSASVLWILNWLPGLKKAINIDEVSQEPMLDADRLRSSWTFSESMDLNYSNPSSSPNSLGNLKILLDDKASKKFDETIDGFKTLKFKLITILRFNIRALCIYDIGSFFQNTKIWNMDVGSIELDQNIASLISELRRTESKLKQQLPEKEKNSIFIGLDIVNNYALIKGAKSIKVLNHNGIKKMLRNVNVLQHAYRNLSSEPSKINMNVTMNFYSLCGSSEAELFEYIKDNELPHCSVEDLKTILRLQFSEEMHRQLKRQSTSSTKGSIKPSNKRYTEALEKLSNLEKEQSKEGARTKIGKLKSKLNAVHTANEK');
INSERT INTO proteininfo VALUES ('6325311', 'NP_015379.1','Mitogen-activated protein kinase required for spore morphogenesis that is expressed as a middle sporulation-specific gene; Smk1p [Saccharomyces cerevisiae]','MNCTLTDNTRAINVASNLGAPQQRTIFAKERISIPGYYEIIQFLGKGAYGTVCSVKFKGRSPAARIAVKKISNIFNKEILLKRAIRELKFMNFFKGHKNIVNLIDLEIVTSSPYDGLYCYQELIDYDLAKVIHSSVQLSEFHIKYFLYQILCGLKYIHSADVIHRDLKPGNILCTLNGCLKICDFGLARGIHAGFFKCHSTVQPHITNYVATRWYRAPELLLSNQPYSKSVDIWAVGCILAEFYARKPVFMGRDSMHQIFEIIKVLGTPDKDILIKFGTIKAWNLGKNSNNPVYKKIPWSNIFPFASHEAINLIESLLHWDSTHRLNVEQAISHPFLNEVRKPDDEPVCLQGPFDFTYESELNSMSKLRDYLVEEVKNFKTDLSSSSL');
INSERT INTO proteininfo VALUES ('6325309', 'NP_015377.1','Homologous to mammalian high mobility group proteins 1 and 2; functions redundantly with the highly homologous gene, NHP6B; high-mobility group non-histone chromatin protein; 11-kDa nonhistone chromosomal protein; Nhp6ap [Saccharomyces cerevisiae]','MVTPREPKKRTTRKKKDPNAPKRALSAYMFFANENRDIVRSENPDITFGQVGKKLGEKWKALTPEEKQPYEAKAQADKKRYESEKELYNATLA');
INSERT INTO proteininfo VALUES ('6325307', 'NP_015376.1','N-acetyltransferase; Mak3p [Saccharomyces cerevisiae]','MEIVYKPLDIRNEEQFASIKKLIDADLSEPYSIYVYRYFLNQWPELTYIAVDNKSGTPNIPIGCIVCKMDPHRNVRLRGYIGMLAVESTYRGHGIAKKLVEIAIDKMQREHCDEIMLETEVENSAALNLYEGMGFIRMKRMFRYYLNEGDAFKLILPLTEKSCTRSTFLMHGRLAT');
INSERT INTO proteininfo VALUES ('6325306', 'NP_015374.1','Peripheral membrane protein required for delivery of aminopeptidase I (Lap4p) to the vacuole in the cytoplasm-to-vacuole targeting pathway; also required for peroxisomal degradation (pexophagy); Atg11p [Saccharomyces cerevisiae]','MADADEYSTAPTQQEITPLQTTATIINAISGECITTNVDFFVSLDKFKQFIARKWKIPPDQLLILLPYGNKLKPSMFKELLINRSFTLNDFYVYDRRLFSLVSKPTPTNLLTSKDSNPMNSPNSNDLTETLEYLIKNSHISQYQGSDTIMIKPMPSPLEDADVDLSRLNYHSVTSLLTTNLGWLSALEIDVHYFKSLIPDIIAHIKRIFDGLTVCSQYLKLYCFDVESLYNSNVQFLNQLVDNGMTSKWEKCFNDTLSKLTALEGDSLQKFINIESLLENEKSVKILNHSINGKLNKIKREIDENASFRDIITVNIDRLRQMFTPNESKFELEDQMAESFEVLVSEMRTRSRNVLDKEEEEFNSQEFLKSMNVMLEKDKKESVKTLFTISQALYSQIGELIDLKKSLQKHAVAILGNIAFTQMEILGIKRLLLNECNKDLELYKKYEVEFAQVEDLPLIYGLYLIEKYRRLSWFQQILSFISNFNQDLELFKQNELRTRNKWVKNFGSIATVFCEDLLSSSDFKRLNEYHSHTSPPNEDEEDENENSIANYRQDLVKVSQAIDNYMTQIKETDVSEPIIDLLSKTLFETKRFHIIYSNFKNNNNNSSNGNSISPEGSIALKSDDVVKGYKTRIKKLESLLHEFQYSDIGHWPQGVLNTHLKPFRGSATSINKKKFLGASVLLEPANISEVNIDSVSQANNHQIQELESNVDDLLHQLQLLKEENNRKSMQISEMGKKISDLEVEKTAYRETLTNLNQELARLTNEEQSHRTEIFTLNASFKKQLNDIISQDNEKIEKLTGDYDDVSKSRERLQMDLDESNKKHEQEVNLLKADIERLGKQIVTSEKSYAETNSSSMEKGEKFETIPLAEDPGRENQISAYTQTLQDRIFDIISTNIFILENIGLLLTFDNNNNIQIRRVKGLKKGTAQSNILDESTQMLDAHDNSLIKSPVFQKLKDEYELIKSVANGSEKDTQQSIFLGNITQLYDNKLYEVAVIRRFKDIETLAKKLTKENKIKRTLLERFQREKVTLRNFQIGDLALFLPTRENVNSVGSMSSSTSSLSSSFSSVDLSTPPPLDAMSIQSSPSVIHSNVINQASISGRDKNKLMRPWAAFTAFEESTRYFLKDEKGLTKGKEWFVGRIVTLEHFVADSPSNNPFRLPKGSVWFQVTAVVVSYQGV');
INSERT INTO proteininfo VALUES ('6325305', 'NP_015373.1','Protein with a potential role in DNA replication; displays synthetic lethal genetic interaction with the pol3-13 allele of POL3, which encodes DNA polymerase delta; Tah18p [Saccharomyces cerevisiae]','MSSSKKIVILYGSETGNAHDFATILSHRLHRWHFSHTFCSIGDYDPQDILKCRYLFIICSTTGQGELPRNVNALKGERPVTFWSFLKRKNLPSNLLNHIQTAMLGLGDSSYPKFNYGIRKLHQRIVTQLGANELFDRLEADDQAMAGSNKGTGLGIESVYFEYEKKVLSFLLSKYPNRKVNGQIIKREELDPEVYLEPASYLQLSDEHANEKFTSTKVIFEGDESLKVGRVNINKRITSEGHFQDVRQFKFSNVDKIQENYEPGDTVTIYPCNTDEDVSRFLANQSHWLEIADKPLNFTSGVPNDLKDGGLVRPMTLRNLLKYHCDFMSIPRTSFFLKIWTFATDVTKMERGQEQLNDQREKLRQFATDQDMQDLYDYCNRPRRSILEVLEDFISVKLPWKYVLDYLPIIKPRYYSISSGPGDPNIELTVAIVKYKTILRKIRRGICTNYIARLQEGEQIRYKLQNNHIIKKEFLNKPMILVGPGVGLAPLLSVVKAEISKDIKLLFGCRYKDKDYIYKDMLEDWFRKGKIALHSSFSRDEENSPGVKYVQDYLWRLGEEITNLVVNKDAVFFLCGSSGKMPIQVRLTFIEMLKKWGNFSDEETAKKYLKEMEKSDRYIQETW');
INSERT INTO proteininfo VALUES ('6325303', 'NP_015371.1','Involved in a nonessential role that governs the kinetochore-microtubule mediated process of chromosome segregation; Involved in chromosome segregation; Mcm16p [Saccharomyces cerevisiae]','MTNSSEKQWERIQQLEKEHVEVYRELLITLDRLYLIRKHNHAVILSHTQQRLLEIRHQLQINLEKTALLIRLLEKPDNTNVLFTKLQNLLEESNSLDYELLQSLGAQSSLHKQLIESRAERDELMSKLIELSSKFPKPTIPPDDSDTAGKQVEVEKENETIQELMIALQIHSGYTNISYTI');
INSERT INTO proteininfo VALUES ('6325302', 'NP_015370.1','Hypothetical ORF; Ypr045cp [Saccharomyces cerevisiae]','MQNPYGHFTNNTTEDREASSQGGPFGQSLNRPLDYAGSFPSLTYNNNNFIANQQPSLPLPEPRLSWNNVNQVSNPLMVTPLPGLQKRMNKNIKKKLPRVSKKASALSNGVSGNVMSNSNIVGHGAVGSASGWKVEMGGSDELERRKRRAERFSQGPSATTNSNDNLNEDFANLNAISSKSHQYDKKIHVVGRCQTLEKSYLRLTSEPNPDLIRPPNILQKMYCLLMDKYQSKTATYTYLCDQFKSMRQDLRVQMIENSFTIKVYQTHARIALENGDLGEFNQCQNRIMALFENPTIPKKSYSEFICYSVLYSMLTEDYPSISHLKLKLIDDGSSEILEDEHVKMIFELSDMKLVGNYHYFMKNYLKLHKFEKCLINSFLNLEKLIFLTIICKSYNQVNLDFVKSEFNFNSIEETTNFLNEQNLTEFILNKQITDSNGKSSNIKILNTKGCRVQLIQNYMKSKKIDIKGQK');
INSERT INTO proteininfo VALUES ('6325300', 'NP_015368.1','Protein component of the large (60S) ribosomal subunit, identical to Rpl43Bp and has similarity to rat L37a ribosomal protein; null mutation confers a dominant lethal phenotype; Rpl43ap [Saccharomyces cerevisiae]','MAKRTKKVGITGKYGVRYGSSLRRQVKKLEIQQHARYDCSFCGKKTVKRGAAGIWTCSCCKKTVAGGAYTVSTAAAATVRSTIRRLREMVEA');
INSERT INTO proteininfo VALUES ('6325299', 'NP_015367.1','mRNA binding protein; Puf2p [Saccharomyces cerevisiae]','MDNKRLYNGNLSNIPEVIDPGITIPIYEEDIRNDTRMNTNARSVRVSDKRGRSSSTSPQKIGSYRTRAGRFSDTLTNLLPSISAKLHHSKKSTPVVVVPPTSSTPDSLNSTTYAPRVSSDSFTVATPLSLQSTTTRTRTRNNTVSSQITASSSLTTDVGNATSANIWSANAESNTSSSPLFDYPLATSYFEPLTRFKSTDNYTLPQTAQLNSFLEKNGNPNIWSSAGNSNTDHLNTPIVNRQRSQSQSTTNRVYTDAPYYQQPAQNYQVQVPPRVPKSTSISPVILDDVDPASINWITANQKVPLVNQISALLPTNTISISNVFPLQPTQQHQQNAVNLTSTSLATLCSQYGKVLSARTLRGLNMALVEFSTVESAICALEALQGKELSKVGAPSTVSFARVLPMYEQPLNVNGFNNTPKQPLLQEQLNHGVLNYQLQQSLQQPELQQQPTSFNQPNLTYCNPTQNLSHLQLSSNENEPYPFPLPPPSLSDSKKDILHTISSFKLEYDHLELNHLLQNALKNKGVSDTNYFGPLPEHNSKVPKRKDTFDAPKLRELRKQFDSNSLSTIEMEQLAIVMLDQLPELSSDYLGNTVIQKLFENSSNIIRDIMLRKCNKYLTSMGVHKNGTWVCQKIIKMANTPRQINLVTSGVSDYCTPLFNDQFGNYVIQGILKFGFPWNSFIFESVLSHFWTIVQNRYGSRAVRACLEADSIITQCQLLTITSLIIVLSPYLATDTNGTLLITWLLDTCTLPNKNLILCDKLVNKNLVKLCCHKLGSLTVLKILNLRGGEEEALSKNKIIHAIFDGPISSDSILFQILDEGNYGPTFIYKVLTSRILDNSVRDEAITKIRQLILNSNINLQSRQLLEEVGLSSAGISPKQSSKNHRKQHPQGFHSPGRARGVSVSSVRSSNSRHNSVIQMNNAGPTPALNFNPAPMSEINSYFNNQQVVYSGNQNQNQNGNSNGLDELNSQFDSFRIANGTNLSLPIVNLPNVSNNNNNYNNSGYSSQMNPLSRSVSHNNNNNTNNYNNNDNDNNNNNNNNNNNNNNNNNNNNNSNNSNNNNNNDTSLYRYRSYGY');
INSERT INTO proteininfo VALUES ('6325298', 'NP_015366.1','eIF5 mediates hydrolysis of eIF2-GTP (SUI2,SUI3,GCD11) at start codons; Translation initiation factor eIF-5; Tif5p [Saccharomyces cerevisiae]','MSINICRDNHDPFYRYKMPPIQAKVEGRGNGIKTAVLNVADISHALNRPAPYIVKYFGFELGAQTSISVDKDRYLVNGVHEPAKLQDVLDGFINKFVLCGSCKNPETEIIITKDNDLVRDCKACGKRTPMDLRHKLSSFILKNPPDSVSGSKKKKKAATASANVRGGGLSISDIAQGKSQNAPSDGTGSSTPQHHDEDEDELSRQIKAAASTLEDIEVKDDEWAVDMSEEAIRARAKELEVNSELTQLDEYGEWILEQAGEDKENLPSDVELYKKAAELDVLNDPKIGCVLAQCLFDEDIVNEIAEHNAFFTKILVTPEYEKNFMGGIERFLGLEHKDLIPLLPKILVQLYNNDIISEEEIMRFGTKSSKKFVPKEVSKKVRRAAKPFITWLETAESDDDEEDDE');
INSERT INTO proteininfo VALUES ('6325297', 'NP_015365.1','Protein involved in regulation of the TOR pathway; Tip41p [Saccharomyces cerevisiae]','MSKRNTPPLRSSGINTIQINAAREMHAQTVRARRMPMPTSGITTPSVQPTAAPATPPRHICNNPNNPQCLHCGSVIIPSPRATLPLEDNPSISINDWTISSRKKPILNSQELDIWENEKLKGLTLPEMIFGNNYIRIENSKQHWSIEFNALDALKEVQLQDSGIRVAYSNDWINSKKRQNSTNGAQRFTNDVNDDSLNIIHKYDWTYTTRYKGTESSPESKFRLDNDQKLPLDKLAVHDKILFYDDMILFEDELADNGISILNVKIRVMNERLLLLSRFFLRVDDVLVRVYDTRIYVEFDENVVIRESKEFEGKYQDVLAKHRLSQSHDPKAALRDSNWVAQNTPMIKRQCEIIQF');
INSERT INTO proteininfo VALUES ('6325296', 'NP_015362.1','Flavin-linked sulfhydryl oxidase localized to the endoplasmic reticulum lumen, involved in disulfide bond formation within the ER; Erv2p [Saccharomyces cerevisiae]','MKQIVKRSHAIRIVAALGIIGLWMFFSSNELSIATPGLIKAKSGIDEVQGAAAEKNDARLKEIEKQTIMPLMGDDKVKKEVGRASWKYFHTLLARFPDEPTPEEREKLHTFIGLYAELYPCGECSYHFVKLIEKYPVQTSSRTAAAMWGCHIHNKVNEYLKKDIYDCATILEDYDCGCSDSDGKRVSLEKEAKQHG');
INSERT INTO proteininfo VALUES ('6325293', 'NP_015361.1','vacuolar ATPase V1 domain subunit H (54 kDa); Vma13p [Saccharomyces cerevisiae]','MGATKILMDSTHFNEIRSIIRSRSVAWDALARSEELSEIDASTAKALESILVKKNIGDGLSSSNNAHSGFKVNGKTLIPLIHLLSTSDNEDCKKSVQNLIAELLSSDKYGDDTVKFFQEDPKQLEQLFDVSLKGDFQTVLISGFNVVSLLVQNGLHNVKLVEKLLKNNNLINILQNIEQMDTCYVCIRLLQELAVIPEYRDVIWLHEKKFMPTLFKILQRATDSQLATRIVATNSNHLGIQLQYHSLLLIWLLTFNPVFANELVQKYLSDFLDLLKLVKITIKEKVSRLCISIILQCCSTRVKQHKKVIKQLLLLGNALPTVQSLSERKYSDEELRQDISNLKEILENEYQELTSFDEYVAELDSKLLCWSPPHVDNGFWSDNIDEFKKDNYKIFRQLIELLQAKVRNGDVNAKQEKIIIQVALNDITHVVELLPESIDVLDKTGGKADIMELLNHSDSRVKYEALKATQAIIGYTFK');
INSERT INTO proteininfo VALUES ('6325292', 'NP_015360.1','Glutamine synthetase (GS), synthesizes glutamine from glutamate and ammonia; with Glt1p, forms the secondary pathway for glutamate biosynthesis from ammonia; expression regulated by nitrogen source and by amino acid limitation; Gln1p [Saccharomyces cerevisiae]','MAEASIEKTQILQKYLELDQRGRIIAEYVWIDGTGNLRSKGRTLKKRITSIDQLPEWNFDGSSTNQAPGHDSDIYLKPVAYYPDPFRRGDNIVVLAACYNNDGTPNKFNHRHEAAKLFAAHKDEEIWFGLEQEYTLFDMYDDVYGWPKGGYPAPQGPYYCGVGAGKVYARDMIEAHYRACLYAGLEISGINAEVMPSQWEFQVGPCTGIDMGDQLWMARYFLHRVAEEFGIKISFHPKPLKGDWNGAGCHANVSTKEMRQPGGTKYIEQAIEKLSKRHAEHIKLYGSDNDMRLTGRHETASMTAFSSGVANRGSSIRIPRSVAKEGYGYFEDRRPASNIDPYLVTGIMCETVCGAIDNADMTKEFERESS');
INSERT INTO proteininfo VALUES ('6325291', 'NP_015359.1','involved in transcriptional regulation; actin related protein, subunit of the chromatin remodeling Snf/Swi complex; Arp7p [Saccharomyces cerevisiae]','MTLNRKCVVIHNGSHRTVAGFSNVELPQCIIPSSYIKRTDEGGEAEFIFGTYNMIDAAAEKRNGDEVYTLVDSQGLPYNWDALEMQWRYLYDTQLKVSPEELPLVITMPATNGKPDMAILERYYELAFDKLNVPVFQIVIEPLAIALSMGKSSAFVIDIGASGCNVTPIIDGIVVKNAVVRSKFGGDFLDFQVHERLAPLIKEENDMENMADEQKRSTDVWYEASTWIQQFKSTMLQVSEKDLFELERYYKEQADIYAKQQEQLKQMDQQLQYTALTGSPNNPLVQKKNFLFKPLNKTLTLDLKECYQFAEYLFKPQLISDKFSPEDGLGPLMAKSVKKAGASINSMKANTSTNPNGLGTSHINTNVGDNNSTASSSNISPEQVYSLLLTNVIITGSTSLIEGMEQRIIKELSIRFPQYKLTTFANQVMMDRKIQGWLGALTMANLPSWSLGKWYSKEDYETLKRDRKQSQATNATN');
INSERT INTO proteininfo VALUES ('6325290', 'NP_015358.1','Nuclear gene that specifies two messages for cytoplasmic and mitochondrial forms; cytoplasmic and mitochondrial histidine tRNA synthetases; Hts1p [Saccharomyces cerevisiae]','MLSRSLNKVVTSIKSSSIIRMSSATAAATSAPTANAANALKASKAPKKGKLQVSLKTPKGTKDWADSDMVIREAIFSTLSGLFKKHGGVTIDTPVFELREILAGKYGEDSKLIYNLEDQGGELCSLRYDLTVPFARYVAMNNIQSIKRYHIAKVYRRDQPAMTKGRMREFYQCDFDVAGTFESMVPDSECLSILVEGLTSLGIKDFKIKLNHRKILDGIFQIAGVKDEDVRKISSAVDKLDKSPWEAVKKEMTEEKGQSEETADKIGEYVKLNGSLKEIHAVLSADANITSNEKAKQGLDDIATLMKYTEAFDIDSFISFDLSLARGLDYYTGLIYEVVTSASAPPENASELKKKAKSAEDASEFVGVGSIAAGGRYDNLVNMFSEASGKKSTQIPCVGISFGVERIFSLIKQRINSSTTIKPTATQVFVMAFGGGKDWTGYLPERMKVTKQLWDAGIEAEYVYKAKANPRKQFDAAEKAGCHIAVILGKEEYLEGKLRVKRLGQEFADDDGELVSAADIVPIVQEKLSQIHEDGLNEVTRLIKGL');
INSERT INTO proteininfo VALUES ('6325289', 'NP_015357.1','Suppressor of rho3; yeast homolog of the Drosphila tumor suppressor, lethal giant larvae; Sro7p [Saccharomyces cerevisiae]','MFGSKRLKNVKEAFKSLKGQNSETPIENSKASFKSKNSKTSTISKDAKSSSSLKIPISSNNKNKIFSLAETNKYGMSSKPIAAAFDFTQNLLAIATVTGEVHIYGQQQVEVVIKLEDRSAIKEMRFVKGIYLVVINAKDTVYVLSLYSQKVLTTVFVPGKITSIDTDASLDWMLIGLQNGSMIVYDIDRDQLSSFKLDNLQKSSFFPAARLSPIVSIQWNPRDIGTVLISYEYVTLTYSLVENEIKQSFIYELPPFAPGGDFSEKTNEKRTPKVIQSLYHPNSLHIITIHEDNSLVFWDANSGHMIMARTVFETEINVPQPDYIRDSSTNAAKISKVYWMCENNPEYTSLLISHKSISRGDNQSLTMIDLGYTPRYSITSYEGMKNYYANPKQMKIFPLPTNVPIVNILPIPRQSPYFAGCHNPGLILLILGNGEIETMLYPSGIFTDKASLFPQNLSWLRPLATTSMAASVPNKLWLGALSAAQNKDYLLKGGVRTKRQKLPAEYGTAFITGHSNGSVRIYDASHGDIQDNASFEVNLSRTLNKAKELAVDKISFAAETLELAVSIETGDVVLFKYEVNQFYSVENRPESGDLEMNFRRFSLNNTNGVLVDVRDRAPTGVRQGFMPSTAVHANKGKTSAINNSNIGFVGIAYAAGSLMLIDRRGPAIIYMENIREISGAQSACVTCIEFVIMEYGDDGYSSILMVCGTDMGEVITYKILPASGGKFDVQLMDITNVTSKGPIHKIDAFSKETKSSCLATIPKMQNLSKGLCIPGIVLITGFDDIRLITLGKSKSTHKGFKYPLAATGLSYISTVEKNNDRKNLTVIITLEINGHLRVFTIPDFKEQMSEHIPFPIAAKYITESSVLRNGDIAIRVSEFQASLFSTVKEQDTLAPVSDTLYINGIRIPYRPQVNSLQWARGTVYCTPAQLNELLGGVNRPASKYKESIIAEGSFSERSSDDNNANHPEHQYTKPTRKGRNSSYGVLRNVSRAVETRWDAVEDRFNDYATAMGETMNEAVEQTGKDVMKGALGF');
INSERT INTO proteininfo VALUES ('6325288', 'NP_015356.1','Component of the histone acetyltransferase complex; Nto1p [Saccharomyces cerevisiae]','MNRGSLDDGPKLREEKHFQDFYPDLNADTLLPFIVPLVETKDNSTDTDSDDISNRNNREIGSVKSVQTKELIFKGRVTTEPLVLKKNEVEFQKCKITTNELKGKKNPYCVRFNESFISRYYHINKVRNRKSYKQQQKEFDGVEAPYFTKFSSKEAPNITISTSTKSAIQKFASISPNLVNFKPQYDMDEQDELYLHYLNKRYFKDQMSHEIFEILMTTLETEWFHIEKHIPSTNSLIARHNILRDCKNYELYGSDDGTGLSMDQACAVCLGTDSDNLNTIVFCDGCDIAVHQECYGIIFIPEGKWLCRRCMISKNNFATCLMCPSHTGAFKQTDTGSWVHNICALWLPELYFSNLHYMEPIEGVQNVSVSRWKLNCYICKKKMGACIQCFQRNCFTAYHVTCARRAGLYMSKGKCTIQELASNQFSQKYSVESFCHKHAPRGWQTSIEGINKARKYFSLLSTLQTETPQHNEANDRTNSKFNKTIWKTPNQTPVAPHVFAEILQKVVDFFGLANPPAGAFDICKYWSMKRELTGGTPLTACFENNSLGSLTEEQVQTRIDFANDQLEDLYRLKELTTLVKKRTQASNSLSRSRKKVFDIVKSPQKYLLKINVLDIFIKSEQFKALERLVTEPKLLVILEKCKHCDFDTVQIFKEEIMHFFEVLETLPGASRILQTVSSKAKEQVTNLIGLIEHVDIKKLLSRDFIINDDKIEERPWSGPVIMEEEGLSDAEELSAGEHRMLKLILNSG');
INSERT INTO proteininfo VALUES ('6325287', 'NP_015355.1','Nuclear protein with a potential regulatory role in utilization of galactose and nonfermentable carbon sources; overproduction suppresses the lethality at high temperature of a chs5 spa2 double null mutation; potential Cdc28p substrate; Csr2p [Saccharomyces cerevisiae]','MQSTVPIAIASNGNKRDVVQNVSAGDEGDILQRLARNREMISTSLSPQKSSGFSGRRRSSSVRDALSSFFGTGNSPTSSMDDYSNLMNRNYSTASTAMCRGNSFPSDVGTKAYNITGSYQPDRHRNSVPYTTIDQLHTRQDTGLRRESDPVAAKQISSNNDIVRSFITHHASNSTMFINRVLSDYLADRGFIKQTPLYNKKSVLEISIATSAESVFLPTTKSDETEYLSLIHGSLNQARTQPVGSTNTAESDFLPSCPTMDTLNENNDLSLFPLHTQRTSPSNTARTGNAMDTSNSDRASPASNNNTTDADSFVASGNNNPMNNNNSPARNRHPNSHSRSLPNAWNSQMPSFSFALIFSLNKSTTLSDIKVELTSNVRVVWFNGLPPTKNVNEECYNIGSLDWTLNADNFNLFIPQGAKSPLDIVENHSNNRKLKVLQKLSMRKRRSFSNKAVLRENILNNLNASNSTNKLNAGVYVFTIPIVLASRIPESLYYPSARVSYSLRLATKLKDEHTQLVASRPRSSSISSPQKLRSYSCSDSYEYSQIDDTIEGETYNNDKNSTGKIAFPSSWLKSAKGRLKRNNSNGRSDNNGASSSGLAMQHDSEDTINLQYPLNLVRTPPEISVTTANKPLYINKVWENCLSYEISFAQKYVPLNGEIPITIKVAPLVKSLSVKRIRVSCREKISYRSKDYQYDFDQLDPLASDPCNPYHMRYLVRKKKDRSLPLFEVASKCTSGPSIREEVVTNTVDDNLLAYTSSKENNKDIPFSESFTVKTKLKFPKYCEVDATKAASLPPYGIDLFDPIKDPTQSENTSNNGNVLGFLVGRPNRASKTVHKIPQDKNHNEVNDTNGNSNTSLQTSSNVPIQHYTRLNKPRRGLYLDSMHFKNIQCSHKLEIVLRVSKTDSGSSKIIRHYEVIVDTPIYLISDLCNTSNIDLPTYDMATTESSKVLPPTFEEATSVSASPRSSVSYYPDDISMQQLNLSRSTSLANGYLSTLHPKTTAVSDSSNGAPIRDQQEQQARPLRTEDYALQMGNENNAYSNMDGLLSQDIFEQETAATLFKRDIVTMNFNNNIFTPRYSPRTFTNTDYNYNDNDNNDNDTEGPGPIIHPGPEPPRYDEISS');
INSERT INTO proteininfo VALUES ('6325286', 'NP_015354.1','Gamma-adaptin, large subunit of the clathrin-associated protein (AP) complex; Apl4p [Saccharomyces cerevisiae]','MGSSLRSFIKDVRGAKTLADERAIITKQSAKIRTKLRDDHLPHEKRRVNIQKLLYLYILGEKTHFGQVESINLIASDDFVDKRLGYLAATLLLDESEDLLTLLTNMLNNDLHHPNKYAVSLALTSLGFLSSPELARDLYPDVENIIKNSRDPFLLKKALQCAAKLIFKDVSLLEIFNIEDITKILSSHSICTHGVLLGVTKIIQSILLIGLNRKKDEDEDEDGIDYSNDILSPLSLLLRDFFIRLENMNSKNIEPGYDVQGICDPFLQCEIIYTLKLYFQVGELLNSNNVLDYKDNFCDLLTRIATNTDSTKNSGQAILYETVKTIFSLDLNQPLRVLGINILAKFLAGKDNNTKYVSLNTLLKVVPQEPTAVQRHRKFISHCLQDTDVSIRMRALELSFAILDDSNLVELVNELMKFLAKQDEDSKDLIIYTIDHLIDTFDTRVVKDESWKLDVFFNILKLVGSFINYEKINDILIIINNTSQLSDKSEFLRKMLTISLNGTSAEISEENIGWQLVLIWCIGEYGDLVLNEGNKNGADIINESSITDYLLTLQELYTATNLKIINYILTAALKLSVRFHDAKNIEKLRQLILSYTDSTDLSLQMKSNQYEIFFNQSISVKKIILETMPKFEKITEEQDNGKALSKNLISNEPVDLLSDLLGEDSKAESKASTGDNVKPIDILEEIFGEKNDIAQVPKNANKEESINHSSAVEANSGVTLPLDANKIYDSSSLNVYASLLSANSGLAHLDLYFQAKSLISDLKTFCAVPKAQKLTLGQLYPSSTINASQICKQSLKISGSGKLKLRVKLDFHLNGSSSITNEQFDHKFDETL');
INSERT INTO proteininfo VALUES ('6325285', 'NP_015353.1','Protein that regulates vesicular traffic in stressed cells either to facilitate membrane turnover or to decrease unnecessary secretion; Yop1p [Saccharomyces cerevisiae]','MSEYASSIHSQMKQFDTKYSGNRILQQLENKTNLPKSYLVAGLGFAYLLLIFINVGGVGEILSNFAGFVLPAYLSLVALKTPTSTDDTQLLTYWIVFSFLSVIEFWSKAILYLIPFYWFLKTVFLIYIALPQTGGARMIYQKIVAPLTDRYILRDVSKTEKDEIRASVNEASKATGASVH');
INSERT INTO proteininfo VALUES ('6325284', 'NP_015352.1','Hypothetical ORF; Ypr027cp [Saccharomyces cerevisiae]','MVGIYRILASFVPLLGLLFAFHDDDMIDTVTIIKTVYETVTSTSTAPAPAATKSVSEKKLDDTKLTLQVIQTMVSCFSVGENPANMISCGLGVVILMFSLIIELINKLENDGINEPQRLYDLIKPKYVELPSNYVNEKIKTTFEPLDLYLGVNMNTSGSELNQNCLILKLGEKTALPFPGLAQQICYTKGASNEFTNYKLSDIQGNLNENSQGIANGVFQKISNIRKISGNFKSQLYQISEKITDENWDGSAVGFTAHGREKGPNKSQISVSFYRDN');
INSERT INTO proteininfo VALUES ('6325283', 'NP_015351.1','Vacuolar acid trehalase, required for trehalose utilization; Ath1p [Saccharomyces cerevisiae]','MKRIRSLWFNAEASYSNLNNSPSLRNKNSTGNNSRSKNYRSFSRFDLINSILLLMMLFLLAIFVTALYLTKSSRLTYSHASRAALFNPLGVISPSLGNHTLNYDPEARESSKKLYELLSDFNTAYYDDENMILGSNLFSKNTYSRQPYVANGYIGSRIPNIGFGYALDTLNFYTDAPGALNNGWPLRNHRFAGAFVSDFYCLQPKLNSTNFPELDDVGYSTVISSIPQWTNLQFSLVNDSKWFNPQNVTLDDVTNYSQNLSMKDGIVTTELDWLNSQIHVKSEIWAHRHIHPLGVVSLEISLNTDHLPSDFDSLDVNIWDILDFNTSHRTVLHSTGTDEKNNAVFMIVQPDNVPSSNCAIYSTCTVKYENSTNPINSSESFEEKDVSSNIYNVILTEDQPKIIVHKYVGIMSTEFNKNKEQQDNTNIGLAKMIALNSKGNYEKLLSSHKRAWYDLYNDAFIEIPSDSLLEMTARSSLFHLLANTRDYNVSSDRGLPVGVSGLSSDSYGGMVFWDADIWMEPALLPFFPNVAQNMNNYRNATHSQAKLNAEKYGYPGAIYPWTSGKYANCTSTGPCVDYEYHINVDVAMASFSIYLNGHEGIDDEYLRYTTWPIIKNAAQFFTAYVKYNSSLGLYETYNLTDPDEFANHINNGAFTNAGIKTLLKWATDIGNHLGEVVDPKWSEISKDIYIPRSSSNITLEYSGMNSSVEIKQADVTLMVYPLGYINDESILNNAIKDLYYYSERQSASGPAMTYPVFVAAAAGLLNHGSSSQSYLYKSVLPYLRAPFAQFSEQSDDNFLTNGLTQPAFPFLTANGGFLQSILFGLTGIRYSYEVDPDTKKINRLLRFNPIELPLLPGGIAIRNFKYMNQVLDIIIDDHNGTIVHKSGDVPIHIKIPNRSLIHDQDINFYNGSENERKPNLERRDVDRVGDPMRMDRYGTYYLLKPKQELTVQLFKPGLNARNNIAENKQITNLTAGVPGDVAFSALDGNNYTHWQPLDKIHRAKLLIDLGEYNEKEITKGMILWGQRPAKNISISILPHSEKVENLFANVTEIMQNSGNDQLLNETIGQLLDNAGIPVENVIDFDGIEQEDDESLDDVQALLHWKKEDLAKLIEQIPRLNFLKRKFVKILDNVPVSPSEPYYEASRNQSLIEILPSNRTTFTIDYDKLQVGDKGNTDWRKTRYIVVAVQGVYDDYDDDNKGATIKEIVLND');
INSERT INTO proteininfo VALUES ('6325282', 'NP_015350.1','essential for cell proliferation; novel cyclin gene; encodes subunits of TFIIK, a subcomplex of transcription factor TFIIH; Ccl1p [Saccharomyces cerevisiae]','MTDIQLNGKSTLDTPSATMSAKEKEAKLKSADENNKPPNYKRISDDDLYRHSSQYRMWSYTKDQLQEKRVDTNARAIAYIEENLLKFREAHNLTEEEIKVLEAKAIPLTMEEELDLVNFYAKKVQVIAQHLNLPTEVVATAISFFRRFFLENSVMQIDPKSIVHTTIFLACKSENYFISVDSFAQKAKSTRDSVLKFEFKLLESLKFSLLNHHPYKPLHGFFLDIQNVLYGKVDLNYMGQIYDRCKKRITAALLTDVVYFYTPPQITLATLLIEDEALVTRYLETKFPSREGSQESVPGNEKEEPQNDASTTEKNKEKSTESEEYSIDSAKLLTIIRECKSIIEDCKPPSTEEAKKIAAKNYYCQNPSTLIQKLKRKLNGEDTSSTVEKKQKT');
INSERT INTO proteininfo VALUES ('6325281', 'NP_015349.1','Mitochondrial inner membrane protease of the AAA family, responsible for degradation of unfolded or misfolded mitochondrial gene products; mutation causes an elevated rate of mitochondrial turnover; Yme1p [Saccharomyces cerevisiae]','MNVSKILVSPTVTTNVLRIFAPRLPQIGASLLVQKKWALRSKKFYRFYSEKNSGEMPPKKEADSSGKASNKSTISSIDNSQPPPPSNTNDKTKQANVAVSHAMLATREQEANKDLTSPDAQAAFYKLLLQSNYPQYVVSRFETPGIASSPECMELYMEALQRIGRHSEADAVRQNLLTASSAGAVNPSLASSSSNQSGYHGNFPSMYSPLYGSRKEPLHVVVSESTFTVVSRWVKWLLVFGILTYSFSEGFKYITENTTLLKSSEVADKSVDVAKTNVKFDDVCGCDEARAELEEIVDFLKDPTKYESLGGKLPKGVLLTGPPGTGKTLLARATAGEAGVDFFFMSGSEFDEVYVGVGAKRIRDLFAQARSRAPAIIFIDELDAIGGKRNPKDQAYAKQTLNQLLVELDGFSQTSGIIIIGATNFPEALDKALTRPGRFDKVVNVDLPDVRGRADILKHHMKKITLADNVDPTIIARGTPGLSGAELANLVNQAAVYACQKNAVSVDMSHFEWAKDKILMGAERKTMVLTDAARKATAFHEAGHAIMAKYTNGATPLYKATILPRGRALGITFQLPEMDKVDITKRECQARLDVCMGGKIAEELIYGKDNTTSGCGSDLQSATGTARAMVTQYGMSDDVGPVNLSENWESWSNKIRDIADNEVIELLKDSEERARRLLTKKNVELHRLAQGLIEYETLDAHEIEQVCKGEKLDKLKTSTNTVVEGPDSDERKDIGDDKPKIPTMLNA');
INSERT INTO proteininfo VALUES ('6325280', 'NP_015348.1','Esa1p-associated factor, nonessential component of the NuA4 acetyltransferase complex, homologous to Drosophila dosage compensation protein MSL3; Eaf3p [Saccharomyces cerevisiae]','MVDLEQEFALGGRCLAFHGPLMYEAKILKIWDPSSKMYTSIPNDKPGGSSQATKEIKPQKLGEDESIPEEIINGKCFFIHYQGWKSSWDEWVGYDRIRAYNEENIAMKKRLANEAKEAKKSLLEQQKKKKLSTSLGGPSNGGKRKGDSRSNASISKSTSQSFLTSSVSGRKSGRSSANSLHPGSSLRSSSDQNGNDDRRRSSSLSPNMLHHIAGYPTPKISLQIPIKLKSVLVDDWEYVTKDKKICRLPADVTVEMVLNKYEHEVSQELESPGSQSQLSEYCAGLKLYFDKCLGNMLLYRLERLQYDELLKKSSKDQKPLVPIRIYGAIHLLRLISVLPELISSTTMDLQSCQLLIKQTEDFLVWLLMHVDEYFNDKDPNRSDDALYVNTSSQYEGVALGM');
INSERT INTO proteininfo VALUES ('6325279', 'NP_015347.1','Hypothetical ORF; Ypr022cp [Saccharomyces cerevisiae]','MHGKELAGRLRKRENDNDLSPNSSSSPAERFRCPHPECNKTFSRQEHLSRHKLNHWPKEIYVCSYVLPTTNAPCNKTFVRKDLLIRHEKRHSKVKNRLSRPSKDQISSSNKDFSKNAPYNPSEVPLSTQSGTSTINLIKNSVNPPPSITQESKFRPFLQQAQQPQQVQQSQQPQQIQQLQQLQFPQQLRAPLQQPMLQQQMHPQQASPTFPSYDPRIRNNGQNGNQFFNLIFDNRTGVNGFEVDAANNNGNGNDQNMNINPAVQQQRYQDRNFASSSYQQPLQPLTQDQQQEQYFQQQKLAQQQQQQQQQQQQQQQLPPQNPFGDPLTSSSSGANLSVMQDLFSTNFLNSDPLQSFMQELSEAPQVSIEDTFSDKNTIPPNEKPVQQDEGFQNPPVMFELPQDNIKIPKAQPKFNDNPSTSVKDNLSSQKLNINELKRRSSKDSGVGNNSSLNYKEQLRHSMKSVPSFFHPDPLTKYKISKEKCQEMFSFVPELRYVSIESIHKSLKSFWLNFHPQYGLLHKPSFHVDKQPAILNLALIMTGASFLGSEYREQISDPICGPLRWIIFSHADFQPPSKTYIIQSLLLVEGYEKTSTNRYLHERSFLHHGTTIQLLRRTPSLGGHPLMVKTGKTSGENSIQDPQEVYKRWIDFEMLKRIAFYAFYMDTTHAVVFGYWNLFINSNQIQLTLPCPDQVWESYDLSYETLMEHGYGSTKRDENNTFLSALMQLMKNVIQILRNNNIRRNKVNNGGIESTPTDLESTTDWNIQSLFGKKILLAGIISILFQCQEEVNGDYFITNFRGGITDHLGLSWKDILSFAMNYWLHEVQKSCTDPKACRISTPSEETLTNRKIDEDNGDGLCDDDLDLLSSDNPSNCKIPVIHISQIVLRILHHDYYIYAGAPWRMNVPIGRDEYDMISRRILQFAKDPYNGGVAVVYAFQFLFEMFIIKENNVPTVVKSYNINSDPVITRPYAIALTSLLIWSCNFALHGCEVSIWDNTEASKDECFQPDDSNGGNILGNTDNNGSTIANNNLKEKNNYIPIESFEVYLLRMYRNLYVDSSLDVVSFQNDVWAKASLLQHISNTHFLCGMMQFMRDIFNKSYWDLGREFGKLFDNCLERSLGKTSPTCHNMFDV');
INSERT INTO proteininfo VALUES ('6325278', 'NP_015346.1','Mitochondrial transporter, acts both as a glutamate uniporter and as an aspartate-glutamate exchanger; involved in nitrogen metabolism, ornithine synthesis, and the malate-aspartate NADH shuttle; Agc1p [Saccharomyces cerevisiae]','MEQINSNSRKKKQQLEVFKYFASVLTKEDKPISISNGMLDMPTVNSSKLTAGNGKPDTEKLTGELILTYDDFIELISSSKTIYSKFTDHSFNLNQIPKNVFGCIFFAIDEQNKGYLTLNDWFYFNNLLEYDNYHLIILYEFFRKFDVENLKAKQKKELGSSSFNLKAADDRIKSINYGNRFLSFDDLLLNLNQFKDTIRLLHESIDDNFVKDNKLLLDWNDFRFLKFYKCYHENEEYLSLNSLVTILQNDLKNEKIFIGFDRLAQMDSQGHRLALSKNQLTYLLRLFYSHRVSADIFSSLNLSNTELLKADNNSIPYNVFKDIFYLFQNFDLLNQIFHKYVTENNLNEQDIREQIVTKNDFMTVLNAQYNKVNNIIEFSPSQINLLFSIVANSKENRRLRKRNQDRDDELLNDHHYDSDIDFFIHNEYLHGVSRSRKNLESFNDYYHDLSDGFDQDSGVKKASKASTGLFESVFGGKKDKATMRSDLTIEDFMKILNPNYLNDLVHQMELQKNQNESLYINYYFYPIFDSLYNFSLGSIAGCIGATVVYPIDFIKTRMQAQRSLAQYKNSIDCLLKIISREGIKGLYSGLGPQLIGVAPEKAIKLTVNDFMRNRLTDKNGKLSLFPEIISGASAGACQVIFTNPLEIVKIRLQVQSDYVGENIQQANETATQIVKKLGLRGLYNGVAACLMRDVPFSAIYFPTYAHLKKDLFDFDPNDKTKRNRLKTWELLTAGAIAGMPAAFLTTPFDVIKTRLQIDPRKGETKYNGIFHAIRTILKEESFRSFFKGGGARVLRSSPQFGFTLAAYELFKGFIPSPDNKLKSREGRKRFCIDDDAGNEETVVHSNGELPQQKFYSDDRKHANYYYKSCQIAKTFIDLDNNFSRFDSSVYKNFQEHLRSING');
INSERT INTO proteininfo VALUES ('6325277', 'NP_015345.1','Subunit g of the mitochondrial F1F0 ATP synthase, which is a large enzyme complex required for ATP synthesis; associated only with the dimeric form of ATP synthase; Atp20p [Saccharomyces cerevisiae]','MLSRIQNYTSGLVSKANLLSSKALYYGKVGAEISKQIYLKEGLQPPTVAQFKSVYSNLYKQSLNFALKPTEVLSCLKNIQKNELLKYGAYGIQLIGFYSVGEIIGRRKLVGYKHH');
INSERT INTO proteininfo VALUES ('6325276', 'NP_015344.1','Essential helicase component of heterohexameric MCM2-7 complexes which bind pre-replication complexes on DNA and melt the DNA prior to replication; accumulates in the nucleus in G1; homolog of S. pombe Cdc21p; Cdc54p [Saccharomyces cerevisiae]','MSQQSSSPTKEDNNSSSPVVPNPDSVPPQLSSPALFYSSSSSQGDIYGRNNSQNLSQGEGNIRAAIGSSPLNFPSSSQRQNSDVFQSQGRQGRIRSSASASGRSRYHSDLRSDRALPTSSSSLGRNGQNRVHMRRNDIHTSDLSSPRRIVDFDTRSGVNTLDTSSSSAPPSEASEPLRIIWGTNVSIQECTTNFRNFLMSFKYKFRKILDEREEFINNTTDEELYYIKQLNEMRELGTSNLNLDARNLLAYKQTEDLYHQLLNYPQEVISIMDQTIKDCMVSLIVDNNLDYDLDEIETKFYKVRPYNVGSCKGMRELNPNDIDKLINLKGLVLRSTPVIPDMKVAFFKCNVCDHTMAVEIDRGVIQEPARCERIDCNEPNSMSLIHNRCSFADKQVIKLQETPDFVPDGQTPHSISLCVYDELVDSCRAGDRIEVTGTFRSIPIRANSRQRVLKSLYKTYVDVVHVKKVSDKRLDVDTSTIEQELMQNKVDHNEVEEVRQITDQDLAKIREVAAREDLYSLLARSIAPSIYELEDVKKGILLQLFGGTNKTFTKGGRYRGDINILLCGDPSTSKSQILQYVHKITPRGVYTSGKGSSAVGLTAYITRDVDTKQLVLESGALVLSDGGVCCIDEFDKMSDSTRSVLHEVMEQQTISIAKAGIITTLNARSSILASANPIGSRYNPNLPVTENIDLPPPLLSRFDLVYLVLDKVDEKNDRELAKHLTNLYLEDKPEHISQDDVLPVEFLTMYISYAKEHIHPIITEAAKTELVRAYVGMRKMGDDSRSDEKRITATTRQLESMIRLAEAHAKMKLKNVVELEDVQEAVRLIRSAIKDYATDPKTGKIDMNLVQTGKSVIQRKLQEDLSREIMNVLKDQASDSMSFNELIKQINEHSQDRVESSDIQEALSRLQQEDKVIVLGEGVRRSVRLNNRV');
INSERT INTO proteininfo VALUES ('6325275', 'NP_015343.1','Chromatin Assembly Complex, subunit 1: largest (p90) subunit of three-subunit protein complex (yeast CAF-I) involved in DNA-replication-linked nucleosome assembly. Homol. to p150 subunit human Chromatin Assembly Factor-I (CAF-I); p90 subunit of yeast Chromatin Assembly Factor-I (CAF-I); Rlf2p [Saccharomyces cerevisiae]','MEQHLKSIPLQDDTKKKGILSFFQNTTTVKSNKFLTKEKDVITLDDPKEDVSGPMIETVKQETMKSINKECADEMKTTPKKANAEDKLLCYKNSPIQSTKYDRNTNKQVPNGNIIAIETKSRSSSPCSKRELSSSKKEEAKREKELKKQQRAEEKHRKELLRQEEKKKKELKVEEERQRRAELKKQKEEEKRRKEEARLEAKRRKEEERLKKEEEIRLKEEAKERAQSRIGNFFKKLSDSNTPVVEKSDYEKFFLPFYAKDGVRVSNKWKLTKVELEGSKRKIDDELLNSKDKTSSDDLLNWLQSRRLPRGHKIKRKAVDVLQQMPLKEKTDDELQSLLAQVPHKYIKFYENVRPPFIGTYSMDFTLPPNDPFSTKGTGFNYDYDSDVEWVNEEEEGEVDNLESGEEEEEEEDDEDVPSEGEFDGFLDSEENSDLDGLPCAKRKFVGPLIPTICLKSNFENLSEENKRYLQQLKAEVIIETDGPIDPFKEPKTSSLPSKRSNSDLQAQTASQSQSPEKKQKAMITDPMDLLRLFDGVQDSTFSLGTVTEIAQKNLPQYNKQTIKNTIKEYAIRSSGKGDLPRKWVIKDAQNWENLRANANMPTPSL');
INSERT INTO proteininfo VALUES ('6325274', 'NP_015342.1','Nucleotide release factor functioning in the post-Golgi secretory pathway, required for ER-to-Golgi transport, binds zinc, found both on membranes and in the cytosol; guanine nucleotide dissociation stimulator; Dss4p [Saccharomyces cerevisiae]','MSKATCSFEGCHSAVITINDDNIINLPEQVHSEFKLLENRTMRDATPSESNFLVVPDVWDFDNVGVSREIPSSILGDLSDKSDFVFEYGNSSWKIKKCLKYLICADCDKGPIGIICKVQDQTKNEERVLHLLSLRSLQIMGRN');
INSERT INTO proteininfo VALUES ('6325273', 'NP_015341.1','Protein with similarity to human translation initiation factor 6 (eIF6), possibly involved in the biogenesis and or stability of 60S ribosomal subunits; Tif6p [Saccharomyces cerevisiae]','MATRTQFENSNEIGVFSKLTNTYCLVAVGGSENFYSAFEAELGDAIPIVHTTIAGTRIIGRMTAGNRRGLLVPTQTTDQELQHLRNSLPDSVKIQRVEERLSALGNVICCNDYVALVHPDIDRETEELISDVLGVEVFRQTISGNILVGSYCSLSNQGGLVHPQTSVQDQEELSSLLQVPLVAGTVNRGSSVVGAGMVVNDYLAVTGLDTTAPELSVIESIFRLQDAQPESISGNLRDTLIETYS');
INSERT INTO proteininfo VALUES ('6325272', 'NP_015340.1','Hypothetical ORF; Ypr015cp [Saccharomyces cerevisiae]','MWRTKTLESMLCSPMKCSSSNIGGSYAQSSKEVSNTTKREVHLPPCSSIMHAPLTPEINQAALPPPAYHYAPSSLHQTEDPVWRSSPNSIIFSPVIATPQPFPLTFVERQSCCPIYSTAASSYTAQSVPPSMQHFQEENHRAVSNEQYSLPNVHIGQNPGTLLSQTQTDLDLIQKQLRAVVKLRKQCPICGKVCSRPSTLRTHYLIHTGDTPFKCTWEHCNKSFNVKSNMLRHLRTHQKKIAKKKHQ');
INSERT INTO proteininfo VALUES ('6325270', 'NP_015338.1','Hypothetical ORF; Ypr013cp [Saccharomyces cerevisiae]','MNFSLSKQSSEKQSSYTDKSRSPNIGMCTVNYKSNLPLQVSAVDQLSTGKGTQFYGHNSYKNERECYNSTKINLPPISSLLPNFENNTPPNVDSRVQFPPQQVYQSMNVVPIVNEIYTPISMNATSDQYPIYYTESQQPIPHSQSPHLTSSAPLMMPVMVPTVYKPLTPYDKEPITIASEPNFTAISMASHPNAALELCHDRPKSVPPGYGVLPTMQEASNGRTKSEPGAVLNGSATFSDWKTDTRISSTKLRKQCPVCGKICSRPSTLKTHYLIHTGDTPFKCTWEGCTKSFNVKSNMLRHLKSHERKRNKVLNTT');
INSERT INTO proteininfo VALUES ('6325268', 'NP_015336.1','Hypothetical ORF; Ypr011cp [Saccharomyces cerevisiae]','MAEVLTVLEQPNSIKDFLKQDSNIAFLAGGVAGAVSRTVVSPFERVKILLQVQSSTTSYNRGIFSSIRQVYHEEGTKGLFRGNGLNCIRIFPYSAVQFVVYEACKKKLFHVNGNNGQEQLTNTQRLFSGALCGGCSVVATYPLDLIKTRLSIQTANLSSLNRSKAKSISKPPGIWQLLSETYRLEGGLRGLYRGVWPTSLGVVPYVALNFAVYEQLREFGVNSSDAQPSWKSNLYKLTIGAISGGVAQTITYPFDLLRRRFQVLAMGGNELGFRYTSVWDALVTIGRAEGVSGYYKGLAANLFKVVPSTAVSWLVYEVVCDSVRNW');
INSERT INTO proteininfo VALUES ('6325267', 'NP_015335.1','RNA polymerase I subunit A135; Rpa135p [Saccharomyces cerevisiae]','MSKVIKPPGQARTADFRTLERESRFINPPKDKSAFPLLQEAVQPHIGSFNALTEGPDGGLLNLGVKDIGEKVIFDGKPLNSEDEISNSGYLGNKLSVSVEQVSIAKPMSNDGVSSAVERKVYPSESRQRLTSYRGKLLLKLKWSVNNGEENLFEVRDCGGLPVMLQSNRCHLNKMSPYELVQHKEESDEIGGYFIVNGIEKLIRMLIVQRRNHPMAIIRPSFANRGASYSHYGIQIRSVRPDQTSQTNVLHYLNDGQVTFRFSWRKNEYLVPVVMILKALCHTSDREIFDGIIGNDVKDSFLTDRLELLLRGFKKRYPHLQNRTQVLQYLGDKFRVVFQASPDQSDLEVGQEVLDRIVLVHLGKDGSQDKFRMLLFMIRKLYSLVAGECSPDNPDATQHQEVLLGGFLYGMILKEKIDEYLQNIIAQVRMDINRGMAINFKDKRYMSRVLMRVNENIGSKMQYFLSTGNLVSQSGLDLQQVSGYTVVAEKINFYRFISHFRMVHRGSFFAQLKTTTVRKLLPESWGFLCPVHTPDGSPCGLLNHFAHKCRISTQQSDVSRIPSILYSLGVAPASHTFAAGPSLCCVQIDGKIIGWVSHEQGKIIADTLRYWKVEGKTPGLPIDLEIGYVPPSTRGQYPGLYLFGGHSRMLRPVRYLPLDKEDIVGPFEQVYMNIAVTPQEIQNNVHTHVEFTPTNILSILANLTPFSDFNQSPRNMYQCQMGKQTMGTPGVALCHRSDNKLYRLQTGQTPIVKANLYDDYGMDNFPNGFNAVVAVISYTGYDMDDAMIINKSADERGFGYGTMYKTEKVDLALNRNRGDPITQHFGFGNDEWPKEWLEKLDEDGLPYIGTYVEEGDPICAYFDDTLNKTKIKTYHSSEPAYIEEVNLIGDESNKFQELQTVSIKYRIRRTPQIGDKFSSRHGQKGVCSRKWPTIDMPFSETGIQPDIIINPHAFPSRMTIGMFVESLAGKAGALHGIAQDSTPWIFNEDDTPADYFGEQLAKAGYNYHGNEPMYSGATGEELRADIYVGVVYYQRLRHMVNDKFQVRSTGPVNSLTMQPVKGRKRHGGIRVGEMERDALIGHGTSFLLQDRLLNSSDYTQASVCRECGSILTTQQSVPRIGSISTVCCRRCSMRFEDAKKLLTKSEDGEKIFIDDSQIWEDGQGNKFVGGNETTTVAIPFVLKYLDSELSAMGIRLRYNVEPK');
INSERT INTO proteininfo VALUES ('6325266', 'NP_015334.1','Involved in sterol uptake; homologous to SUT1; Sut2p [Saccharomyces cerevisiae]','MKPNNRTCDVITNKDESLPALLLPALNSYTCDDSLLKGQISSNGRYQPFGFSDCSLLPKRLNIQAGQGSMPVSSIQCADHSYSNWQKESEKTKLPKLGCPTEYTEYYKTVSSGETTDSAVVSSIATNRLKRKRQRDGPSCDSCRIKKIKCNATIIIFLQDRNLISSISSNLHYTLSQDDINQFRMKFFRKLPDVMGTYEVIKHLDKIVLFKACTSCSRRNQKNGKCLFSRGFTKSDMNVFPKINSKLKDKSIFEMTVDDYVAAGFQTL');
INSERT INTO proteininfo VALUES ('6325265', 'NP_015333.1','Transcriptional activator involved in the transcription of TPO2, HSP30 and other genes encoding membrane stress proteins; despite sequence similarity with the transcription factor Ace1p, it is not subject to metalloregulation; Haa1p [Saccharomyces cerevisiae]','MVLINGIKYACERCIRGHRVTTCNHTDQPLMMIKPKGRPSTTCDYCKQLRKNKNANPEGVCTCGRLEKKKLAQKAKEEARAKAKEKQRKQCTCGTDEVCKYHAQKRHLRKSPSSSQKKGRSISRSQPMFERVLSSTSLDSNMLSGHGALSDTSSILTSTFLDSEPGVGKISKDYHHVPSLASISSLQSSQSLDQNFSIPQSPPLSSMSFNFLTGNINETNQNHSNHQHSKSGNNWQDSSVSLPAKADSRLNMMDKNNSVGLDLLGHSKRISPISNSRVGEVSVPLEEYIPSDIDGVGRVTDKSSLVYDWPFDESIERNFSTTATAATGESKFDINDNCNRINSKSYSKTNSMNGNGMNNSNNNNINSNGNDKNNNNSSRQEHQGNGLFDMFTDSSSISTLSRANLLLQEKIGSQENSVKQENYSKNPQLRHQLTSRSRSFIHHPANEYLKNTFGNSHSNDIGKGVEVLSLTPSFMDIPEKERETERSPSSNYITDRPFTRKPRSSSIDVNHRYPPMAPTTVATSPGALNNAVASNLDDQLSLTSLNSQPSSIANMMMDPSNLAEQSSIHSVPQSINSPRMPKTGSRQDKNIHTKKEERNPLNNIHDLSQLENVPDEMNQMFSPPLKSMNRPDAIRENSSSSNFIIQGNSMISTPSGRNDLPDTSPMSSIQTASPPSQLLTDQGFADLDNFMSSL');
INSERT INTO proteininfo VALUES ('6325264', 'NP_015332.1','Meoisis-specific component of sister chromatid cohesion complex; maintains cohesion between sister chromatids during meiosis I; maintains cohesion between centromeres of sister chromatids until meiosis II; homolog of S. pombe Rec8p; Rec8p [Saccharomyces cerevisiae]','MAPLSLNFKDDKKYKGLTTVWLLSALGNSIVKESNNYYSNKSNSTGNISSSTVKKKDIVNISIPKTCDEIQNFENDFSLRYISNLLYGVTICYNKKTEYVLNDLNHLLVQLQKNDVYAFKAKNKSTRINGLNSNNSIIGNKNNNYTWEECVFFDDDPLYDITKVPALEFLNTTLQDNVSFIEEAKSIRRQDYINELSNSNRFELHGDMTNSDAQSNLGSNVRNSFPLDEIPVDVDFNLDLDDIVSHQGTPLGSHSSSQKDGNDFKFNYQGDELVLNFENDNENNSNGGEDTSVENEGPVANLKDYELGLEAQASEEENDLQQKLNTRMQRGHRADVGGQFSKVQFDAKTSYPNEVLKFNHGNYSHLMEKNRIRKLTGQNFLTSNISSLVRSCGEEEFFSTNWLSIFNDFSNIKTSEWDLYPQGFSSVERGRKRAHSLVSTQSSSSTRSHEYGRKSFRNNKNDNYSSDMENDNLLLNLEQINEDLEDGHYIEENSQGNILDFNLNLPPSSFGRSHTRNSTRSSGFNEDIVGALRRRVGPSEQNFAEEDDSSNSCFSDGSQQNLQQDKTNFQDVILDYQTKKFYDYIKERSIVVGRTTRSNPPFKRKMLLVDIIPSRMGEAQTGANFDDVERGVSRQIAASAFLSLLNLATKGMVKLNEYPVADAVTKDLKLRREDEIIVYA');
INSERT INTO proteininfo VALUES ('6325263', 'NP_015331.1','2-methylisocitrate lyase of the mitochondrial matrix, functions in the methylcitrate cycle to catalyze the conversion of 2-methylisocitrate to succinate and pyruvate; ICL2 transcription is repressed by glucose and induced by ethanol; Icl2p [Saccharomyces cerevisiae]','MITMINNKTFNRKTTGTLKKLVLSSDKSLRRSFNGASSTKDFVFSESSKVEEWWESARFKNISRPYSATDVVKHRGSLPANTSIYPSSYQARKLFNLLEENFKNGTPLHTLGVIDPVQMSQLARCRNIKVAYISGWACSSTLVGSTNEVSPDFGDYPYDTVPNQVERIFKAQQLHDRKAFLEASIKGSTPVDYLKPIIADADMGHGGPTTVMKVAKLFAEKGAAGIHLEDQMVGGKRCGHLSGAVLVPTATHLMRLISTRFQWDIMGTENLVIARTDSCNGKLLSSSSDPRDHEFIRGIIRDNVVPWSEKLIEMEDKKIPNSAIADMEKEWYHENELFTFEEALEKQFTASEFESYKEKKEDLMVNKLGRAYLSLREMKLLAQEVTPLKKIIFDWDAPRTKEGYYMFNGCIEAAIRRSLVFAPYSDMIWLETKTPDLEQARSFSRKIHKQLPATKLVYNLSPSFNWSAHGFDDKALKSFVWDLAKEGFTLQLVSLAGLHSDGVSFWELANSFQSDGMKAYVEKVQKREKETNCDIMTHQLWSGAEYVDSLMKVVQNGASSQTLSTSGESFTETQF');
INSERT INTO proteininfo VALUES ('6325262', 'NP_015330.1','Cytoplasmic protein involved in halotolerance; decreases intracellular Na+ (via Ena1p) and increases intracellular K+ by decreasing efflux; expression repressed by Ssn6p-Tup1p and Sko1p and induced by NaCl, KCl, and sorbitol through Gcn4p; Hal1p [Saccharomyces cerevisiae]','MHFKDLGLHDYTLKNLMYENNCCKFYDAVDENNISYVLKFVPSDVTSEGDTFPFVDRFQVKEGVFLVYSSNDFGKEGTDYFTYTGSGGNEVHISGTSSEAGIKPQFIETCHPKHLKRGTKEQEDINSSTSKKSAVINNFSGEKTPNPRPQSSNISERETYVGILNVKCKNKNSSKIRSEKLVSSVIETKHTPGLASILSKEGTTYPNNADGKHISIVNPSSKIYHSSHKQIVKTPIPKSGLSPIERCPFNGQNIKCYSPRPLDHESPQRDFNNNFQLRILKSSVLQRRQSTQNS');
INSERT INTO proteininfo VALUES ('6325261', 'NP_015329.1','Hypothetical ORF; Ypr004cp [Saccharomyces cerevisiae]','MFKSLAAVLPRASKAKFLQKNYASTLAFIESSKDGSVSRSSLSLLAAAQKLSNPITAVITGSKAEKTAEALKSSYSCSNLEKLVIFEDSKLDTCLPEQLTPLLVKLLKGGDYSHFVVSNSSVGKSVLPRVGALLDVQPVCEVTVIKDPKTFIRPIYAGNIISTIECQAEKKLLIIRASAFPPIAEGSMDSVTIEKRTDIPPCDLNVTWVKTILTKSERPELTSAQNVVTGGRALKDKETFEKLLSPLADVLHAAIGATRASVDNGLCDNSLQIGQTGKVVAPNLYIAIGVSGAVQHLAGMKDSKVIVAINNDPDAPIFNVADYGLQGDLYKIVPELTEKLGKYK');
INSERT INTO proteininfo VALUES ('6325260', 'NP_015328.1','Hypothetical ORF; Ypr003cp [Saccharomyces cerevisiae]','MTSNNSLLGRGRMSYSSTAPPRFKRSVDQRDTFSDNFDYDKDSSNRGRTYIAASNSTTGVPPPNNSRSGCTNNTNNTNNTSNTSNTNNNDSVDENTVFETLPYYLPCFSWLPEYTFNKLWGDVIAGISVASFQIPLALSYTTSIAHVPPLCGLYSLAISPFVYGILGSVPQMIVGPESAISLVVGQAVESITLHKENVSLIDISTVITFVSGTILLFSGISRFGFLGNVLSKALLRGFISSVGLVMIINSLISELKLDKFLVSLPQHYHTPFEKILFLIDYAPAQYHIPTAIFSGCCLIVLFLTRLLKRKLMKYHKSAIFFPDILLVVIVTILISMKFNLKHRYGISIIGDFSMDNFDELKNPLTRPRRKLIPDLFSASLIVAMLGFFESTTASKSLGTTYNLTVSSNRELVALGFMNIVISLFGALPAFGGYGRSKINALSGAQSVMSGVFMGVITLITMNLLLQFVHYIPNCVLSVITTIIGISLLEEVPGDIKFHLRCGGFSELFVFAVTFCTTIFYSIEAGICIGCVYSIINIIKHSAKSRIQILARVAGTSNFTNLDDYMMNMKRNSLDVEGTEEIEGCMIVRIPEPLTFTNSEDLKQRLDRIERYGSSKIHPGRKSLRSKDSIKYVIFDLGGMTSIDSSAAQVLEEIITSYKRRNVFIYLVNVSINDKVRRRLFKAGVAASVERAQANNNENNTSNTFSDAGETYSPYFDSIDAALYEIEKMKIKGNNVPNNDSESFMSNTLFNSSLV');
INSERT INTO proteininfo VALUES ('6325258', 'NP_015326.1','Mitochondrial protein that participates in respiration, induced by diauxic shift; homologous to E. coli PrpD, may take part in the conversion of 2-methylcitrate to 2-methylisocitrate; Pdh1p [Saccharomyces cerevisiae]','MFLAKNLKNNKIKVCLPKKKFAALSTASIQTNERPNPDKVLKDIAKYVHETPLKSSLALDTARLCFLDTLGCGLAALKFKQAQNIIKPIVPGTIVPSGTKILGTSYVMDPVKGAFAIGTLIRWLDYNDCWLAAEWGHPSDNLGGILAVADHLSRLNKATHGKNGKQFLVKDVLEAMIKAHEIQGIIALENSFNKVGLDHVVLVKVATAGVVSKMLGLSQEQTIEALSQAFVDGQSLRTYRHAPNTGSRKSWAAGDAVSRAVNLAYLVKNANVGTIPSVLTARTWGFYDVLFKGKPFSFQQRSKYDSYVMENVLFKISFPAEFHAQTAVEAAVKAYRILAKQGKTFKDIKSIRIRTQEAAMRIIDKSGPLYNYADRDHCIQYMIAVPLITGNLTATDYSDEVARNPEIDNLRSKMYCIEDTHLTQNYHDPDKRSIGNALLIELNDGTQLDEIFVEYPVGHKFRREEGIPLLMNKFQRHLREHFVESPDKVDLIMKVSSKTNFLNMQIDKYMDLFTEG');
INSERT INTO proteininfo VALUES ('6325257', 'NP_015325.1','Mitochondrial isoform of citrate synthase; Cit3p [Saccharomyces cerevisiae]','MVQRLLPGAHICRRSFNSSAIIKSSALTLKEALENVIPKKRDAVKKLKACYGSTFVGPITISSVLGGMRGNQSMFWQGTSLDPEHGIKFQGLTIEECQNRLPNTGIDGDNFLPESMLWLLMTGGVPTFQQAASFRKELAIRGRKLPHYTEKVLSSLPKDMHPMTQLAIGLASMNKGSLFATNYQKGLIGKMEFWKDTLEDSLNLIASLPLLTGRIYSNITNEGHPLGQYSEEVDWCTNICSLLGMTNGTNSSNTCNLTSQQSLDFINLMRLYTGIHVDHEGGNVSAHTTHLVGSALSDPYLSYSSGIMGLAGPLHGLAAQEVVRFLIEMNSNISSIAREQEIKDYLWKILNSNRVIPGYGHAVLRKPDPRFTAMLEFAQKRPIEFENDKNVLLMQKLAEIAPKVLLEHGKSKNPFPNVDSASGILFYHYGIRELLFFTVIFGCSRAMGPLTQLVWDRILGLPIERPKSLNLEGLEALTKASNVNKL');
INSERT INTO proteininfo VALUES ('6325256', 'NP_015324.1','Catalytic subunit of the Hat1p-Hat2p histone acetyltransferase complex that uses the cofactor acetyl coenzyme A, to acetylate free nuclear and cytoplasmic histone H4; involved in telomeric silencing and DNA double-strand break repair; Hat1p [Saccharomyces cerevisiae]','MSANDFKPETWTSSANEALRVSIVGENAVQFSPLFTYPIYGDSEKIYGYKDLIIHLAFDSVTFKPYVNVKYSAKLGDDNIVDVEKKLLSFLPKDDVIVRDEAKWVDCFAEERKTHNLSDVFEKVSEYSLNGEEFVVYKSSLVDDFARRMHRRVQIFSLLFIEAANYIDETDPSWQIYWLLNKKTKELIGFVTTYKYWHYLGAKSFDEDIDKKFRAKISQFLIFPPYQNKGHGSCLYEAIIQSWLEDKSITEITVEDPNEAFDDLRDRNDIQRLRKLGYDAVFQKHSDLSDEFLESSRKSLKLEERQFNRLVEMLLLLNNSPSFELKVKNRLYIKNYDALDQTDPEKAREALQNSFILVKDDYRRIIESINKSQG');
INSERT INTO proteininfo VALUES ('6325255', 'NP_015323.1','appears to be functionally related to SNF7; involved in glucose derepression; Snf8p [Saccharomyces cerevisiae]','MKQFGLAAFDELKDGKYNDVNKTILEKQSVELRDQLMVFQERLVEFAKKHNSELQASPEFRSKFMHMCSSIGIDPLSLFDRDKHLFTVNDFYYEVCLKVIEICRQTKDMNGGVISFQELEKVHFRKLNVGLDDLEKSIDMLKSLECFEIFQIRGKKFLRSVPNELTSDQTKILEICSILGYSSISLLKANLGWEAVRSKSALDEMVANGLLWIDYQGGAEALYWDPSWITRQL');
INSERT INTO proteininfo VALUES ('6325254', 'NP_015322.1','Protein that acts together with Uba3p to activate Rub1p before its conjugation to proteins (neddlyation), which may play a role in protein degradation; Ula1p [Saccharomyces cerevisiae]','MERYDRQLRLWGALGQDSLNRSRVCVVGPATPLLQEVFKNLVLAGISSLTWLKVECAVQSGSLFLAELKKDLEPLASKQLEYEENDLRKTLQQPQYDWTRFSVVILTCIGEQTAMLDLNEIRRQRGTKFPPVLNTFVSGFYGYIYLVLSETHFVLQAHPDSKKYDLRLQNPWPELINYVDTFDLSKMDTATFSGIPYTVLLMKCIAKLERDGNNGRITIDQMKKVLDQICLPLGNDVIYEPNYVEAKRYAYLACSQNDCCKELEDLLRNLEISDYGNDWHDTYNYEILTLLLTLKNIAKENGELSFQPLTGTLPDMESTTENYIRLKKLYEVKAKLDKSRVEESLARSKKIVSQDVLETFCSHYGEVRKILPPKSDLLGIFSTSNALLDALVMVQFWEQPAVTAEDKDEFIGLRVDDNYSVMAFFGGAVVQEAIKLITHHYVPIDNLFLYNGINNSSATYKI');
INSERT INTO proteininfo VALUES ('6325253', 'NP_015321.1','Long chain base-responsive inhibitor of protein kinases Phk1p and Phk2p, acts along with Pil1p to down-regulate heat stress resistance via regulation of the Pkc1p and Ypk1p pathways; phosphorylated by Phk1p and Phk2p; Lsp1p [Saccharomyces cerevisiae]','MHRTYSLRNQRAPTAAELQAPPPPPSSTKSKFFGKASIASSFRKNAAGNFGPELARKLSQLVKTEKGVLRAMEVVASERREAAKQLSLWGADNDDDVSDVTDKLGVLIYELGELQDQFIDKYDQYRVTLKSIRNIEASVQPSRDRKEKITDEIAHLKYKDPQSTKIPVLEQELVRAEAESLVAEAQLSNITREKLKAAYSYMFDSLRELSEKFALIAGYGKALLELLDDSPVTPGEARPAYDGYEASRQIIMDAESALESWTLDMAAVKPTLSFHQTVDDVYEDEDGEEEEEPEIQNGDIPGQVVEEEEVEWTTEVPVDDEAHEADHHVSQNGHTSGSENI');
INSERT INTO proteininfo VALUES ('6325252', 'NP_015320.1','Peripheral mitochondrial inner membrane protein, located on the matrix face of the membrane; stabilizes the bicistronic AAP1-ATP6 mRNA encoding subunits 6 and 8 of the ATP synthase complex; Aep3p [Saccharomyces cerevisiae]','MNTLRCLTQALSKSGREAPKLYQKVIFPGLFREGIPIANVKKVDEKIIDSPTSTSVNGEAKKIVRHGVKYEREQVKEYLSSLPTLTLSRKQIRDDYDEERAKRMYMFSKQTNSSNKFQKLLTAKSQEFTRELLTLLIDCTSNEKNSGPERFTRKFLKFSNDEIPPLPDFSKNPQLFENYIGILSHTKFNFRSSSKLNGIVRKMLRHLLHPTNKTTLPLRSAQVYNDSIYFFSEHFDFASCREIFAQMKAEGTKPNTITFNLLLRNVVKNSHIRKTKHPDDEVLFYLRSMRNHGVFADVITWTTCYNFLRDEVSRQLYIVQMGEHLGNFNVNFVYTVLRNGDYRAEDCLKVLAANSLPISRKTFYLCIERLLNEEQLETASKLLDYGFQHLKSNFKLDSEAMNHFMRVFANKGRSDLAFLCYNTCRKIYKIKPDSQTFEMLFKALVRNGNTKNFGAVLQYIKDLKVSEGFGLRTSYWRTKADSIFKFGSPNTLSEKSIEKARKLLGNLIASEGEFSWKIWKESDSSQKKILRFLGCIPTTLRCTNTAQDHQKPTNLPSNISQKKREYRNRVKAIATKAALEKRMAYIKDNDVAFKKELVKRRIVGEV');
INSERT INTO proteininfo VALUES ('6325251', 'NP_015319.1','A transmembrane glycoprotein that is homologous to human Niemann-Pick Type C (NPC) gene; involved in sphingolipid metabolism; predicted transmembrane protein; Ncr1p [Saccharomyces cerevisiae]','MNVLWIIALVGQLMRLVQGTATCAMYGNCGKKSVFGNELPCPVPRSFEPPVLSDETSKLLVEVCGEEWKEVRYACCTKDQVVALRDNLQKAQPLISSCPACLKNFNNLFCHFTCAADQGRFVNITKVEKSKEDKDIVAELDVFMNSSWASEFYDSCKNIKFSATNGYAMDLIGGGAKNYSQFLKFLGDAKPMLGGSPFQINYKYDLANEEKEWQEFNDEVYACDDAQYKCACSDCQESCPHLKPLKDGVCKVGPLPCFSLSVLIFYTICALFAFMWYYLCKRKKNGAMIVDDDIVPESGSLDESETNVFESFNNETNFFNGKLANLFTKVGQFSVENPYKILITTVFSIFVFSFIIFQYATLETDPINLWVSKNSEKFKEKEYFDDNFGPFYRTEQIFVVNETGPVLSYETLHWWFDVENFITEELQSSENIGYQDLCFRPTEDSTCVIESFTQYFQGALPNKDSWKRELQECGKFPVNCLPTFQQPLKTNLLFSDDDILNAHAFVVTLLLTNHTQSANRWEERLEEYLLDLKVPEGLRISFNTEISLEKELNNNNDISTVAISYLMMFLYATWALRRKDGKTRLLLGISGLLIVLASIVCAAGFLTLFGLKSTLIIAEVIPFLILAIGIDNIFLITHEYDRNCEQKPEYSIDQKIISAIGRMSPSILMSLLCQTGCFLIAAFVTMPAVHNFAIYSTVSVIFNGVLQLTAYVSILSLYEKRSNYKQITGNEETKESFLKTFYFKMLTQKRLIIIIFSAWFFTSLVFLPEIQFGLDQTLAVPQDSYLVDYFKDVYSFLNVGPPVYMVVKNLDLTKRQNQQKICGKFTTCERDSLANVLEQERHRSTITEPLANWLDDYFMFLNPQNDQCCRLKKGTDEVCPPSFPSRRCETCFQQGSWNYNMSGFPEGKDFMEYLSIWINAPSDPCPLGGRAPYSTALVYNETSVSASVFRTAHHPLRSQKDFIQAYSDGVRISSSFPELDMFAYSPFYIFFVQYQTLGPLTLKLIGSAIILIFFISSVFLQNIRSSFLLALVVTMIIVDIGALMALLGISLNAVSLVNLIICVGLGVEFCVHIVRSFTVVPSETKKDANSRVLYSLNTIGESVIKGITLTKFIGVCVLAFAQSKIFDVFYFRMWFTLIIVAALHALLFLPALLSLFGGESYRDDSIEAED');
INSERT INTO proteininfo VALUES ('6325250', 'NP_015318.1','Transcription factor for RNA polymerase III; 60 kDa subunit of TFIIIC (tau60); Tfc8p [Saccharomyces cerevisiae]','MKLLKDLLVDRKEFEDWKNNLTWARDGTLYLTTFPDISIGQPKYAKDINCNSKNLFHVKEFPLEFENKLDFELAQQNGLLNSQPVCYPRVCKPSPIDDWMAVLSNNGNVSVFKDNKMLTNLDSKGNLSSRTYHCFEWNPIESSIVVGNEDGELQFFSIRKNSENTPEFYFESSIRLSDAGSKDWVTHIVWYEDVLVAALSNNSVFSMTVSASSHQPVSRMIQNASRRKITDLKIVDYKVVLTCPGYVHKIDLKNYSISSLKTGSLENFHIIPLNHEKESTILLMSNKTSYKVLLEDELHVTADNIIAPYLEKKFKKWSTIWNEFNNYETTLVIHGISLSPDGYSIAIVYDMERVAFKYKIASEQSFNIMFAPLYHTWTISERAVGLAWYQTYQIYNQSLPKLPENFSMNKKLLNGNYPISLDFQSYLNALMKSEEMRIIMFLNMTIDKPSILSFLEALYEYAINKKSELTNSFDLACVLSIAAILKREAPIYNGTLLMKNSFLEETFNLESFTADPETVTSTTNNTWKRCGVTLLPILTTHVKICPVSKQRVIDIKRDDLNDYGWFTRGLLERFNEISVYCGTTLEVM');
INSERT INTO proteininfo VALUES ('6325249', 'NP_015317.1','Required for mitotic chromosome segregation, needed for wild-type levels of meiotic recombination and spore viability; kinetochore protein in the DEAH box family; Chl1p [Saccharomyces cerevisiae]','MDKKEYSETFYHPYKPYDIQVQLMETVYRVLSEGKKIAILESPTGTGKTLSLICATMTWLRMNKADIFTRMETNIKTNEDDSENLSDDEPDWVIDTYRKSVLQEKVDLLNDYEKHLNEINTTSCKQLKTMCDLDKEHGRYKSVDPLRKKRKGARHLDVSLEEQDFIPRPYESDSENNDTSKSTRGGRISDKDYKLSELNSQIITLLDKIDGKVSRDPNNGDRFDVTNQNPVKIYYASRTYSQLGQFTSQLRLPSFPSSFRDKVPDEKVKYLPLASKKQLCINPKVMKWKTLEAINDACADLRHSKEGCIFYQNTNEWRHCPDTLALRDMIFSEIQDIEDLVPLGKSLGICPYYASREALPIAEVVTLPYQYLLSESTRSSLQINLENSIVIIDEAHNLIETINSIYSSQISLEDLKNCHKGIVTYFNKFKSRLNPGNRVNLLKLNSLLMTLIQFIVKNFKKIGQEIDPNDMFTGSNIDTLNIHKLLRYIKVSKIAYKIDTYNQALKEEESSKNENPIKETHKKSVSSQPLLFKVSQFLYCLTNLTSEGQFFFEKNYSIKYMLLEPSKPFESILNQAKCVVLAGGTMEPMSEFLSNLLPEVPSEDITTLSCNHVIPKENLQTYITNQPELEFTFEKRMSPSLVNNHLFQFFVDLSKAVPKKGGIVAFFPSYQYLAHVIQCWKQNDRFATLNNVRKIFYEAKDGDDILSGYSDSVAEGRGSLLLAIVGGKLSEGINFQDDLCRAVVMVGLPFPNIFSGELIVKRKHLAAKIMKSGGTEEEASRATKEFMENICMKAVNQSVGRAIRHANDYANIYLLDVRYNRPNFRKKLSRWVQDSINSEHTTHQVISSTRKFFSMRSLNSR');
INSERT INTO proteininfo VALUES ('6325248', 'NP_015316.1','Hypothetical ORF; Ypl009cp [Saccharomyces cerevisiae]','MKQRISALDLLLLARELKQDLEGYRLSNIYNIADSSKQFLLKFNKPDSKLNVVVDCGLRIYLTEFSRPIPPTPSGFVVKLRKHLKAKRLTALKQVDQDRILVLQFADGHFYLVLEFFSAGNVILLDENRRIMALQRVVLEHENKVGQIYEMFDESLFTTNNESADESIEKNRKAEYTSELVNEWIKAVQAKYESDITVIKQLNIQGKEGAKKKKVKVPSIHKLLLSKVPHLSSDLLSKNLKVFNIDPSESCLNLLEETDSLAELLNSTQLEYNQLLTTTDRKGYILAKRNENYISEKDTADLEFIYDTFHPFKPYINGGDTDSSCIIEVEGPYNRTLDKFFSTIESSKYALRIQNQESQAQKKIDDARAENDRKIQALLDVQELNERKGHLIIENAPLIEEVKLAVQGLIDQQMDWNTIEKLIKSEQKKGNRIAQLLNLPLNLKQNKISVKLDLSSKELNTSSDEDNESEGNTTDSSSDSDSEDMESSKERSTKSMKRKSNEKINVTIDLGLSAYANATEYFNIKKTSAQKQKKVEKNVGKAMKNIEVKIDQQLKKKLKDSHSVLKKIRTPYFFEKYSWFISSEGFLVMMGKSPAETDQIYSKYIEDDDIYMSNSFNSHVWIKNPEKTEVPPNTLMQAGILCMSSSEAWSKKISSSPWWCFAKNVSKFDGSDNSILPEGAFRLKNENDQNHLPPAQLVMGFGFLWKVKTSGNEDNGDDDEEEEEEEEEEEEEEEEEEEEEEEEKEEEEKEEEQQQDEDDSNEVNGLEKGGDSNDSTKNNSFEHDNLEKDIEKHCTISSDTDSDSGNAKAKNDNSSTQRILDEPGVPISLIENINSNVRGKRGKLKKIQKKYADQDETERLLRLEALGTLKGIEKQQQRKKEEIMKREVREDRKNKREKQRRLQALKFTKKEKARVNYDKHKSELKPSLDKGDVVDDIIPVFAPWPALLKYKYKVKIQPGSAKKTKTLTEILHYFKSRPLDGSSTDNEMDWPQEHEMIKGLKEQDLVLLLCVDKLKVTIAGQKSTKNGGNSSKKGKKKR');
INSERT INTO proteininfo VALUES ('6325247', 'NP_015315.1','vesicle coat component; Ret3p [Saccharomyces cerevisiae]','MSSLSLYTVQAVLILDQQGERIYAKYYQPPHRSDEGHQLLFNSVKKQKEFEKQLYRKTHKQDSEILIFEDHLVLYKEYIDITIYLVASLEENEIVLQQGFSAIRGALDLILNSGMDKKNIQENYDMVLLAIDETIDNGVILETDSNTIASRVSKPPTNEPQMALDLDKGFLGAWGFAKSKFQERLQQGL');
INSERT INTO proteininfo VALUES ('6325246', 'NP_015314.1','TFIID subunit (47 kDa), involved in promoter binding and RNA polymerase II transcription initiation; Taf3p [Saccharomyces cerevisiae]','MTTNNDFYFALLRISILQLLKAQGFDRARPSLVDVMTDLYAKFLSLLASEVSSIAQARCDQDDTIALQDITLALENLGIVKPTNVLDVYDENSELSSSRGMEKFKDWCIYSTQLTDARITALPTVELLQSEEKESDPLSAIPDYLNQLLQNKGAKQKLETKNRKTELIEDLINNNGLDDWIKLVIARQRINMIERASKKESQNVPALPHIAGYKSSILSRHHHTTITNEDRMPSAMTPRDEDALTEIQENPFVTSKLPIMRKENRLENITLSFEDEELESLGEVEGPNQKSQENNNEESFKENNKSLTESPHGDDRDISMFQFDSNVDTKWAEQEDMDSTFQRRTSLDYGGYF');
INSERT INTO proteininfo VALUES ('6325245', 'NP_015313.1','Protein required for normal pre-rRNA Processing; member of a group of seven genes whose expression is repressed during growth on glucose before and during the diauxic shift; Rrp12p [Saccharomyces cerevisiae]','MDQDKVAFLLELEDKLAKIRSQVNSKLENQKHIAIILTAVEENIAGQATNDVSKNIVNYIISFMSLLDQAVDPSTHEIKDIQLASSSTYLLDLIFHYSPKVLLRSKFSEILTKIAPCITAEKANAPLIRAAIGCLESLLIAQDAQAWNNTYDLNVTPKRGLQGILELSLDVRPKVRKRALDAVHAVLLNPPVAPTAEHVAAVFVADFCDKQLAGILNDLSNLSNKQLKAQKTKEDINASVMRSLRLITSVVSTGQWPSSQIEPLCDVLLGVTKSSEQYLVSASFECFESMFKTMAETTISSGLAENKYLRVLDTIFALKPSNVDTLLTKSWIAVVIKGMSTYATHQPLKALRKIPGVFHIMCTYLASETPEVYQAASQCLISILSESVKDDLLLYTPSVDEKVFKNVDEIISQIAKTFIDFLSIRYSHCSREILKILVAAFNKFRYRSNPHFLKSLKIVDTWRVNEEQFMDLRNEIELVIGASISAMGPEMILAEAPLNLDNPSSERPGRAWLLPLIRDYTKNANLATFQNELAPYIKSFQSKFDKVPEESIQLRVFQTIVDQIWSTLPRFCELPMDLRESFTDEFASELSSLLYSEVELRTTICHALKVLAESNVSYAEESSSHNVLLLQRFPISEAQKNIEYLSTKSTNLLAVLFNVYTQTTPNARSYILETIDQYLKITSKEDLEKTFNNVCGLLKNSMNEESSGNVNKEKKKPQLTATLLDLIICMITYLPVSSYSALFSMFSLTVNSADALIQKRAYRIITKLSELKSGSTAVAQFISDIENVMVDSASSVQTSAKAARLTAIKTIVELLPLDHLDFIVRTVAEVILSTKDVNEKSRETAFDTLICMGRKMNEPNGIIKLFQIPGYDPTTPDQSSSISEFFKIISAGLIGESQHMVSSSITGYACLVFEFKNELDSGILMDIYDTIELYLTSNSREIVKSAIGFTKVCVLGLPEELMRPKVPELLLKLLRWSHEHTGHFKAKVKHIIERLIRRFGYDYIEANFPEEDRRLLTNIRKMRNRNKRKDEEVTTGVSDVAATKGSRFMSAFDEAVYGSDEENDNGSDQEENVAGGKMKNGAKQFIVESGDNPLDLLDSQTLAHISSTRPKKFNKNQNRARFNDDAFNFDSEGKLVVKGQPKPSTNVDDPLSAVTSGINAYLEAVKSGPVRGQRNKLKFRKNGKDSDEFGDDDDGEKDSRLMRGRVNQGNKIGKHNKKGPKFKSRKKL');
INSERT INTO proteininfo VALUES ('6325244', 'NP_015312.1','Mitochondrial ribosomal protein of the small subunit; Mrps16p [Saccharomyces cerevisiae]','MTCGLVRIRLARFGRKNSPVYNIVVANSRKARDAKPIEVLGTYVPVPSPVTKRELKRGVVPIKDVKLDFDRTKYWIGVGAQPSETVTKLLRKAGILNDAWATSKNSNVNRKVVFERMETLE');
INSERT INTO proteininfo VALUES ('6325243', 'NP_015311.1','Hypothetical ORF; Ypl014wp [Saccharomyces cerevisiae]','MLLERLHKRLHAGSSRRSQENKDKNCKPEDALPIQPEAQHQTQDPQPLLNCDYDDMIAFDRNLSTPVFTPVMTPINNSSSNQAKSSDASYFPPYLNANRTRQNSASSLASSVSDFAQNFKQHTFYNNNAQFTSFTPQFVGLLLEVYQNTCSDPTITPFDTTNPPSGILNRVAKAAIQQSELQQLDIGCDRNSWLLTLVRQRLLQEVRKDGYLSRNTSLTSLPPPPPPQFSEMLRVPSPFVNADITDPIPLSNTNSNPNVSSTTSLTNTLNWYSLQRSNVSMKNRNGSSQYISELQPQPILARTNSNNSVSNSNAFSLLTPTPTTDSAFNFNIALLSRQRSNIISSPLASTRLPTANVSTEESSILPNESLKLKRDLLRLKR');
INSERT INTO proteininfo VALUES ('6325242', 'NP_015310.1','Member of the silencing information regulator 2 (Sir2) family of NAD(+)-dependent protein deacetylases that are implicated in transcriptional silencing, DNA repair, genome stability and longevity; similar to Sir2p; Hst2p [Saccharomyces cerevisiae]','MSVSTASTEMSVRKIAAHMKSNPNAKVIFMVGAGISTSCGIPDFRSPGTGLYHNLARLKLPYPEAVFDVDFFQSDPLPFYTLAKELYPGNFRPSKFHYLLKLFQDKDVLKRVYTQNIDTLERQAGVKDDLIIEAHGSFAHCHCIGCGKVYPPQVFKSKLAEHPIKDFVKCDVCGELVKPAIVFFGEDLPDSFSETWLNDSEWLREKITTSGKHPQQPLVIVVGTSLAVYPFASLPEEIPRKVKRVLCNLETVGDFKANKRPTDLIVHQYSDEFAEQLVEELGWQEDFEKILTAQGGMGDNSKEQLLEIVHDLENLSLDQSEHESADKKDKKLQRLNGHDSDEDGASNSSSSQKAAKE');
INSERT INTO proteininfo VALUES ('6325241', 'NP_015309.1','Global transcription activator that acts in complex with Snf2p, Snf5p, Snf6p, and Swi3p to assist gene-specific activators; involved in the regulation of expression of many genes, including ADH1, ADH2, GAL1, HO, INO1 and SUC2; Zinc-finger transcription factor; Swi1p [Saccharomyces cerevisiae]','MDFFNLNNNNNNNNTTTTTTTTNNNNTNNNNTNNNNNPANNTNNNNSTGHSSNTNNNTNNNNTNTGASGVDDFQNFFDPKPFDQNLDSNNNNSNSNNNDNNNSNTVASSTNFTSPTAVVNNAAPANVTGGKAANFIQNQSPQFNSPYDSNNSNTNLNSLSPQAILAKNSIIDSSNLPLQAQQQLYGGNNNNNSTGIANDNVITPHFITNVQSISQNSSSSTPNTNSNSTPNANQQFLPFNNSASNNGNLTSNQLISNYAASNSMDRSSSASNEFVPNTSDNNNNSNNHNMRNNSNNKTSNNNNVTAVPAATPANTNNSTSNANTVFSERAAMFAALQQKQQQRFQALQQQQQQQQNQQQQNQQPQQQQQQQQNPKFLQSQRQQQQRSILQSLNPALQEKISTELNNKQYELFMKSLIENCKKRNMPLQSIPEIGNRKINLFYLYMLVQKFGGADQVTRTQQWSMVAQRLQISDYQQLESIYFRILLPYERHMISQEGIKETQAKRIFLQQFLQELLKKVQQQQQAAALANANNNINSASSAPTPAAPGASVPATAAPGTEAGIVPVSANTPKSLNSNININVNNNNIGQQQVKKPRKQRVKKKTKKELELERKEREDFQKRQQKLLEDQQRQQKLLLETKLRQQYEIELKKLPKVYKRSIVRNYKPLINRLKHYNGYDINYISKIGEKIDSNKPIFLFAPELGAINLHALSMSLQSKNLGEINTALNTLLVTSADSNLKISLVKYPELLDSLAILGMNLLSNLSQNVVPYHRNTSDYYYEDAGSNQYYVTQHDKMVDKIFEKVNNNATLTPNDSNDEKVTILVDSLTGNQLPTPTPTEMEPDLDTECFISMQSTSPAVKQWDLLPEPIRFLPNQFPLKIHRTPYLTSLKKIKDEIDDPFTKINTRGAEDPKVLINDQLSTISMILRNISFSDNNSRIMSRNFYLKRFISDLLWLVLIHPENFTCNRKILNFKKDLVIVLSNISHLLEIASSIDCLLILILVISFGQPKLNPMASSSSFGSESLTFNEFQLQWGKYQTFGVDILAKLFSLEKPNLNYFKSILLNKNTGNNLYDRNSNNNHKDKKLLRRLLNLYNDNNKNNNNRHNLLNDVVSFLFSAIPLQQVLSQSADPSLLIDQFSPVISQSLTSILVIVQKILPLSNEVFEISENNSDSNSNNNGNKDSSFNFNKNLPFVWLSSEENIGSGLLKLSEIILNINNSTSKNTLLQQQNYSKVLLPSINISCVQLIKCLVEKSICFENCLNNDPEILKKIASIPNLFPTDLEIFQLFTNPSVDIQIINQYQLLYNLKNDILTNLE');
INSERT INTO proteininfo VALUES ('6325240', 'NP_015308.1','Putative S-adenosylmethionine-dependent methyltransferase of the seven beta-strand family; Ypl017cp [Saccharomyces cerevisiae]','MGGEDEILSTMEDFAAVYDVLVIGCGPGGFTAAMQASQAGLLTACVDQRASLGGAYLVDGAVPSKTLLYESYLYRLLQQQELIEQRGTRLFPAKFDMQAAQSALKHNIEELGNVYKRELSKNNVTVYKGTAAFKDPHHVEIAQRGMKPFIVEAKYIVVATGSAVIQCPGVAIDNDKIISSDKALSLDYIPSRFTIMGGGTIGLEIACIFNNLGSRVTIVESQSEICQNMDNELASATKTLLQCQGIAFLLDTRVQLAEADAAGQLNITLLNKVSKKTYVHHCDVLMVSIGRRPLLKGLDISSIGLDERDFVENVDVQTQSLLKYPHIKPIGDVTLGPMLALKAEEQAIRAIQSIGCTGSDGTSNCGFPPNVLYCQPQIGWVGYTEEGLAKARIPYQKGRVLFSQNVRYNTLLPREENTTVSPFIKVLIDSRDMKILGVHMINDDANELLSQASMAVSLGLTAHDVCKVPFPHPSLSESFKQAVQLAMANGTSPGVHVRE');
INSERT INTO proteininfo VALUES ('6325239', 'NP_015307.1','Outer kinetochore protein, required for accurate mitotic chromosome segregation; forms a complex with Mcm21p and Okp1p that binds to centromeres via the CBF3 complex; Ctf19p [Saccharomyces cerevisiae]','MDFTSDTTNSHDTSNSHLSLEDAVGTHHAGEADVNIDGDEKQQLSLLDDDQVRALKLQEEKDALLTRRNTLLQEIQTYQNILMKENNSKTKNGDILQNDITQDFLNLISISSSNPNSAISDRKRVERINGLTNLQKELVTKYDTLPLLNMNLRLSYLRDHTYPHLQVSVQSRDRVHNDGIEVLVVNYKFCRNTMNPFEIQFKMFYKFEDSTLLKWEILRISTNVRLKAKQLLATRNFQKCLLSLYEFDKIKSKKTGIFQNLINLLKRKTRCYLMNNSDSLIVERVIREGRLTTIKLQINFIITMPGERGKPRNCFLPMSKISIALWKGGERFNQIDLDEICYGLIKEYGVKTGLKEICNVCLFPDMYAR');
INSERT INTO proteininfo VALUES ('6325238', 'NP_015306.1','Phosphate metabolism; transcription is regulated by PHO system; polyphosphate synthetase (putative); Vtc3p [Saccharomyces cerevisiae]','MLFGIKLANDVYPPWKDSYIDYERLKKLLKESVIHDGRSSVDSWSERNESDFVEALDKELEKVYTFQISKYNAVLRKLDDLEENTKSAEKIQKINSEQFKNTLEECLDEAQRLDNFDRLNFTGFIKIVKKHDKLHPNYPSVKSLLQVRLKELPFNNSEEYSPLLYRISYLYEFLRSNYDHPNTVSKSLASTSKLSHFSNLEDASFKSYKFWVHDDNIMEVKARILRHLPALVYASVPNENDDFVDNLESDVRVQPEARLNIGSKSNSLSSDGNSNQDVEIGKSKSVIFPQSYDPTITTLYFDNDFFDLYNNRLLKISGAPTLRLRWIGKLLDKPDIFLEKRTFTENTETGNSSFEEIRLQMKAKFINNFIFKNDPSYKNYLINQLRERGTQKEELEKLSRDFDNIQNFIVEEKLQPVLRATYNRTAFQIPGDQSIRVTIDSNIMYIREDSLDKNRPIRNPENWHRDDIDSNIPNPLRFLRAGEYSKFPYSVMEIKVINQDNSQMPNYEWIKDLTNSHLVNEVPKFSLYLQGVASLFGEDDKYVNILPFWLPDLETDIRKNPQEAYEEEKKTLQKQKSIHDKLDNMRRLSKISVPDGKTTERQGQKDQNTRHVIADLEDHESSDEEGTALPKKSAVKKGKKFKTNAAFLKILAGKNISENGNDPYSDDTDSASSFQLPPGVKKPVHLLKNAGPVKVEAKVWLANERTFNRWLSVTTLLSVLTFSIYNSVQKAEFPQLADLLAYVYFFLTLFCGVWAYRTYLKRLTLIKGRSGKHLDAPVGPILVAVVLIVTLVVNFSVAFKEAARRERGLVNVSSQPSLPRTLKPIQDFIFNLVGE');
INSERT INTO proteininfo VALUES ('6325237', 'NP_015305.1','Ubl (ubiquitin-like protein)-specific protease 1; initially processes Smt3; also acts as a deconjugating enzyme for Smt3; Ulp1p [Saccharomyces cerevisiae]','MSVEVDKHRNTLQYHKKNPYSPLFSPISTYRCYPRVLNNPSESRRSASFSGIYKKRTNTSRFNYLNDRRVLSMEESMKDGSDRASKAGFIGGIRETLWNSGKYLWHTFVKNEPRNFDGSEVEASGNSDVESRSSGSRSSDVPYGLRENYSSDTRKHKFDTSTWALPNKRRRIESEGVGTPSTSPISSLASQKSNCDSDNSITFSRDPFGWNKWKTSAIGSNSENNTSDQKNSYDRRQYGTAFIRKKKVAKQNINNTKLVSRAQSEEVTYLRQIFNGEYKVPKILKEERERQLKLMDMDKEKDTGLKKSIIDLTEKIKTILIENNKNRLQTRNENDDDLVFVKEKKISSLERKHKDYLNQKLKFDRSILEFEKDFKRYNEILNERKKIQEDLKKKKEQLAKKKLVPELNEKDDDQVQKALASRENTQLMNRDNIEITVRDFKTLAPRRWLNDTIIEFFMKYIEKSTPNTVAFNSFFYTNLSERGYQGVRRWMKRKKTQIDKLDKIFTPINLNQSHWALGIIDLKKKTIGYVDSLSNGPNAMSFAILTDLQKYVMEESKHTIGEDFDLIHLDCPQQPNGYDCGIYVCMNTLYGSADAPLDFDYKDAIRMRRFIAHLILTDALK');
INSERT INTO proteininfo VALUES ('6325236', 'NP_015304.1','Non-essential protein of unconfirmed function; affects pre-rRNA processing, may act as a negative regulator of the transcription of genes involved in pseudohyphal growth; homologous to Srd1p; Ecm23p [Saccharomyces cerevisiae]','MLYNKEQGTSGASSSGRRTKFHFDRFVQMVLFIAANPNYCCSVASIPKSGVTPDLKRADILEQKIKSLNSALSPKLKEESRLGGPLHNPSILPAPSFSSLPISSNGKKSLAGYRPKSRKKQTILPNGQPKECATCGDTWTSQWRSGPNGNVELCSRCGIAYRKKMEKKIRSQQSSDDGTKNFIFKNK');
INSERT INTO proteininfo VALUES ('6325235', 'NP_015303.1','Single-stranded DNA endonuclease (with Rad10p), cleaves single-stranded DNA during nucleotide excision repair and double-strand break repair; subunit of Nucleotide Excision Repair Factor 1 (NEF1); homolog of human ERCC1 protein; Rad1p [Saccharomyces cerevisiae]','MSQLFYQGDSDDELQEELTRQTTQASQSSKIKNEDEPDDSNHLNEVENEDSKVLDDDAVLYPLIPNEPDDIETSKPNINDIRPVDIQLTLPLPFQQKVVENSLITEDALIIMGKGLGLLDIVANLLHVLATPTSINGQLKRALVLVLNAKPIDNVRIKEALEELSWFSNTGKDDDDTAVESDDELFERPFNVVTADSLSIEKRRKLYISGGILSITSRILIVDLLSGIVHPNRVTGMLVLNADSLRHNSNESFILEIYRSKNTWGFIKAFSEAPETFVMEFSPLRTKMKELRLKNVLLWPRFRVEVSSCLNATNKTSHNKVIEVKVSLTNSMSQIQFGLMECLKKCIAELSRKNPELALDWWNMENVLDINFIRSIDSVMVPNWHRISYESKQLVKDIRFLRHLLKMLVTSDAVDFFGEIQLSLDANKPSVSRKYSESPWLLVDEAQLVISYAKKRIFYKNEYTLEENPKWEQLIHILHDISHERMTNHLQGPTLVACSDNLTCLELAKVLNASNKKRGVRQVLLNKLKWYRKQREETKKLVKEVQSQDTFPENATLNVSSTFSKEQVTTKRRRTRGASQVAAVEKLRNAGTNVDMEVVFEDHKLSEEIKKGSGDDLDDGQEENAANDSKIFEIQEQENEILIDDGDAEFDNGELEYVGDLPQHITTHFNKDLWAEHCNEYEYVDRQDEILISTFKSLNDNCSLQEMMPSYIIMFEPDISFIRQIEVYKAIVKDLQPKVYFMYYGESIEEQSHLTAIKREKDAFTKLIRENANLSHHFETNEDLSHYKNLAERKLKLSKLRKSNTRNAGGQQGFHNLTQDVVIVDTREFNASLPGLLYRYGIRVIPCMLTVGDYVITPDICLERKSISDLIGSLQNNRLANQCKKMLKYYAYPTLLIEFDEGQSFSLEPFSERRNYKNKDISTVHPISSKLSQDEIQLKLAKLVLRFPTLKIIWSSSPLQTVNIILELKLGREQPDPSNAVILGTNKVRSDFNSTAKGLKDGDNESKFKRLLNVPGVSKIDYFNLRKKIKSFNKLQKLSWNEINELINDEDLTDRIYYFLRTEKEEQEQESTDENLESPGKTTDDNALHDHHNDVPEAPV');
INSERT INTO proteininfo VALUES ('6325234', 'NP_015302.1','Isozyme of methylenetetrahydrofolate reductase, catalyzes the reduction of 5,10-methylenetetrahydrofolate to 5-methyltetrahydrofolate in the methionine biosynthesis pathway; Met12p [Saccharomyces cerevisiae]','MSIRDLYHARASPFISLEFFPPKTELGTRNLMERMHRMTALDPLFITVTWGAGGTTAEKTLTLASLAQQTLNIPVCMHLTCTNTEKAIIDDALDRCYNAGIRNILALRGDPPIGEDWLDSQSNESPFKYAVDLVRYIKQSYGDKFCVGVAAYPEGHCEGEAEGHEQDPLKDLVYLKEKVEAGADFVITQLFYDVEKFLTFEMLFRERISQDLPLFPGLMPINSYLLFHRAAKLSHASIPPAILSRFPPEIQSDDNAVKSIGVDILIELIQEIYQRTSGRIKGFHFYTLNLEKAIAQIVSQSPVLSHIVNESSEEEGEDETSGEIGSIENVPIEDADGDIVLDDSNEETVANRKRRRHSSLDSAKLIFNRAIVTEKGLRYNNENGSMPSKKALISISKGHGTLGRDATWDEFPNGRFGDSRSPAYGEIDGYGPSIKVSKSKALELWGIPKTIGDLKDIFIKYLEGSTDAIPWSDLGLSAETALIQEELIQLNYRGYLTLASQPATNATLSSDKIFGWGPAKGRLYQKAFVEMFIHRQQWETTLKPKLDHYGRRKFSYYAGDSSGSFETNLDPHSSSVVTWGVFPNSPVKQTTIIEEESFKAWRDEAFSIWSEWAKLFPRNTPANILLRLVHKDYCLVSIVHHDFKETDELWEMLLDQA');
INSERT INTO proteininfo VALUES ('6325233', 'NP_015301.1','involved in cell separation; Nce4p [Saccharomyces cerevisiae]','MSFSSILSQDITDDITPPAYSATLGSREQIVFRAYQNEPWLAGTASNLILDKKLVIVDRELLFQVLMVENITKSKLTQIDDIKTKLDPKKQKVDRLRSGAQGNGAKKYEVITQVDMEDDGNVADNNCAKENNSNNNSSAAKNKAVFKLTLQSKSGDVFFAINSTPISWSSCMLGSKIVILPGTVFNRGVFILKDSQVIFLGGINRVWNENRDQKFCDYLESKLQRDKQLVNGGSKKRKAND');
INSERT INTO proteininfo VALUES ('6325231', 'NP_015299.1','multicopy suppressor of snf3 and grr1 mutants; serine/threonine protein kinase homologous to Ran1p; Sks1p [Saccharomyces cerevisiae]','MLSDCLLNNFRITAQIGSGAYGLVFHVVDILTSREYAVKTVFKSSSMDEFYNKNGLNNNSQVARTTLLQTQLYHFFKSFQKKLFLPSVDLDSILQLTENELNRLPHYREIAFQLRVQSHGNIVKIHQVLESSIATFIVMDYYDRDLFTSIVDDKHFVNHGILIKKVFLQLCSALDHCHRLGIYHCDIKPENVLLDRNDNAYLCDFGLSTKSKYLAPNVCVGSSYYMAPERILYCLNTTTNGIHVDECCSSLPTDTGDIWSLGIILINLTCIRNPWLKAHQKEDNTFQHFANDNNVLKKILPISDELFTVLTKILQLNPYTRIDMKTLMSEVSSLTSFTREGPLSQVPILSSEVYMTHIIRNENLFLSDLSHFSADQEQQQQQQQQQQQVQEQEQEQKQEQIQNQEQAQQQQEEEDAEPESDIPSTYNSDGSMEKYEYTNNHNNSTFLTSSMDSTPYQSDIDDVSASKDCKFQQDTLRNRLLCLQMNFSTLTDGPNEKWLPDY');
INSERT INTO proteininfo VALUES ('6325230', 'NP_015298.1','Spore Membrane Assembly; Sma1p [Saccharomyces cerevisiae]','MACTNDGPNKYPEIVSVKHLFQHSGSKHEFSAGKRFSKSIGKIFKRNSALKTSRTETANHKMELKKREGVTLLPPVPESLLHKLNSWLETFSSTKNMKIEENKIVINEKEIRDSVSYYPDKNGGSAVFCYLPDLVLYYKPPIKVTGKQCPIKRSPWESMEIQYQKFMYPLERLERQFEEVPFRPWYFAMRLKELYRCCERSFTNAANRGKARLLRGKQRTKKSYHKTVNLVSAKISTHSNAPSPG');
INSERT INTO proteininfo VALUES ('6325229', 'NP_015297.1','Acetyl-CoA C-acetyltransferase (acetoacetyl-CoA thiolase), cytosolic enzyme that transfers an acetyl group from one acetyl-CoA molecule to another, forming acetoacetyl-CoA; involved in the first step in mevalonate biosynthesis; Erg10p [Saccharomyces cerevisiae]','MSQNVYIVSTARTPIGSFQGSLSSKTAVELGAVALKGALAKVPELDASKDFDEIIFGNVLSANLGQAPARQVALAAGLSNHIVASTVNKVCASAMKAIILGAQSIKCGNADVVVAGGCESMTNAPYYMPAARAGAKFGQTVLVDGVERDGLNDAYDGLAMGVHAEKCARDWDITREQQDNFAIESYQKSQKSQKEGKFDNEIVPVTIKGFRGKPDTQVTKDEEPARLHVEKLRSARTVFQKENGTVTAANASPINDGAAAVILVSEKVLKEKNLKPLAIIKGWGEAAHQPADFTWAPSLAVPKALKHAGIEDINSVDYFEFNEAFSVVGLVNTKILKLDPSKVNVYGGAVALGHPLGCSGARVVVTLLSILQQEGGKIGVAAICNGGGGASSIVIEKI');
INSERT INTO proteininfo VALUES ('6325228', 'NP_015296.1','ATP-dependent RNA helicase, component of the mitochondrial degradosome along with the RNase Msu1p; the degradosome associates with the ribosome and mediates turnover of aberrant or unprocessed RNAs; Suv3p [Saccharomyces cerevisiae]','MALVKYSTVFFPLRSLRLFVSIKKAYYHSEPHSIDLFHDKDWIVKRPKFLNLPKNEHSKLDIFQFNFNKSESNNVYLQDSSFKDNLDKAMQFIYNDKLSSLDAKQVPIKNLAWLKLRDYIYQQLKDPKLQAKTYVPSVSEIIHPSSPGNLISLLINCNKISNLVWKSVLKYSLSNNITTLDKFIHVLQQTFDHVYEQEILPMMTNTDDTDGAHNVDITNPAEWFPEARKIRRHIIMHIGPTNSGKTYRALQKLKSVDRGYYAGPLRLLAREVYDRFHAEKIRCNLLTGEEVIRDLDDRGNSAGLTSGTVEMVPINQKFDVVVLDEIQMMSDGDRGWAWTNALLGVVSKEVHLCGEKSVLPLVKSIVKMTGDKLTINEYERLGKLSVEEKPIKDGIKGLRKGDCVVAFSKKKILDLKLKIEKDTNLKVAVIYGSLPPETRVQQAALFNNGEYDIMVASDAIGMGLNLSIDRVVFTTNMKYNGEELMEMTSSQIKQIGGRAGRFKSRSASGGVPQGFITSFESKVLKSVRKAIEAPVEYLKTAVTWPTDEICAQLMTQFPPGTPTSVLLQTISDELEKSSDNLFTLSDLKSKLKVIGLFEHMEDIPFFDKLKLSNAPVKDMPMVTKAFTKFCETIAKRHTRGLLSYRLPFNLLDYNCIPNESYSLEVYESLYNIITLYFWLSNRYPNYFIDMESAKDLKYFCEMIIFEKLDRLKKNPYAHKPFGSTRGHLSSSRRRLRT');
INSERT INTO proteininfo VALUES ('6325227', 'NP_015295.1','Hypothetical ORF; Ypl030wp [Saccharomyces cerevisiae]','MTGDGSAHISKNNQNQHKDRFKFIVNDKSILGPQWLSLYQTDGKVTFAKSHFEQAMMNVIREPNINSTVILRADILKEINHAAEAGSEPKFDESVLKKFEIDNGNESGEEDVKKINIEDLNIRSCETSESLKLSPVHEFVRRIIPRNFYKDAIINQTCLILNSKDPNFQETSLIVYTPHINSEKDCPFYIPRTQSVGILLHQSVLSVHYIPFPEDKTAFTDESERVVRTAYRLLQTANKHSKGVMQGYEKRVNHDQVVNKVNFQNTYIVLKKKYSKFLVENWAESTDPKKHVFEDIAIAAFLIELWIKVYGPDFRSKMQFRDLGCGNGALCYILLSESIKGLGIDARKRKSWSIYPPEVQSSLKEQVIIPSILLRPHPALKRQVPHLEHNGRFFPVKVTHEVIAPATVVYSSEDLLKSPQVNTAEFPPDTFIIGNHSDELTCWIPLLGHPYMVIPCCSHNFSGQRVRFNVRKRSPRSNEIKNQNNSKSTYSGLVDHVEYISSRVGWKVEKEMLRIPSTRNAAIIGVENATLKHFPTQAVYDMIWEDGGAEGWIQNTMSLLKRNPRNH');
INSERT INTO proteininfo VALUES ('6325226', 'NP_015294.1','Cyclin-dependent kinase, with ten cyclin partners; involved in environmental stress response; in phosphate-rich conditions, Pho85p-Pho80p complex phosphorylates Pho4p which in turn represses PHO5; Pho85p [Saccharomyces cerevisiae]','MSSSSQFKQLEKLGNGTYATVYKGLNKTTGVYVALKEVKLDSEEGTPSTAIREISLMKELKHENIVRLYDVIHTENKLTLVFEFMDNDLKKYMDSRTVGNTPRGLELNLVKYFQWQLLQGLAFCHENKILHRDLKPQNLLINKRGQLKLGDFGLARAFGIPVNTFSSEVVTLWYRAPDVLMGSRTYSTSIDIWSCGCILAEMITGKPLFPGTNDEEQLKLIFDIMGTPNESLWPSVTKLPKYNPNIQQRPPRDLRQVLQPHTKEPLDGNLMDFLHGLLQLNPDMRLSAKQALHHPWFAEYYHHAS');
INSERT INTO proteininfo VALUES ('6325225', 'NP_015293.1','Protein of unknown function, mutant phenotype suggests a potential role in vacuolar function; green fluorescent protein (GFP)-fusion protein localizes to the cell periphery, cytoplasm, bud, and bud neck; Svl3p [Saccharomyces cerevisiae]','MSSSSLRVLAIGNNPNILFYTSRFQLAKNIDLYHVNDSKSCQFEIETEYYGKDRFELENHFTSIEHLTEALSSKSSEAVFDIIIMSAPSLQELSSLASKLTSIIDSNTKIFLESSGFIQLEPFVKLSMESPHVNVFSILTDLDIRQIGPNHFKHFPSTAKENTIYLGESKSSTEKYSSGVITLLTTFEKLFAKLFSNIKINLCNFSSIEFLSQQWKLAISRICFDPLLIMFEQENPSDLDQQIIAKPLISGLVTEIITVAKTMGARLNSSHDNENSLLSLWKNSYHSTNKPPALVYHFIHQTTPLNIDILLLQTILLADDFGIKTPYLEFLYSVLSQFERLNSGKSKWFIRSDEKTQILQSLQKSQKNESALQTQITSLQGQISKLRQELLMQAKQHEMETNELKEKHQVALKAQAQAQAQAQSQAQTSIEALTPTEATNQSDTNEYKATGTPNLRDIEDMALYSVNYGDSPVRSPPPVVSSQPQMNSPLSSHSQTFGENNGTNDKLLQERELQLRKKELELQERELEFQKRALQQQRFNNSNNSIPRKPSFPQLQQSANVRSNSRGMHGTNGAMSQPASAGNFVDPISSSIAAYDPQQPPSLPLQQPQQSVQVQPFHSHSIKPTSRKNRNSNMPNIGNPSSINMSDFGRPPNNSSQTRLNSMPTHSIVNQNRLRSQQSKNKLNMPHATNPNNTFNQVPAPSLNNHVPTQRQFSSSTMIEVTNNNNKVNNSSSNPDISTNSVVHNAMQFTNTNNNTSSTVDINDPKNIAPPPTTSVSAPSTPTLSSSSQMANMASPSTDNGDNEEKNGGKKKRFGLFKKKNKSKK');
INSERT INTO proteininfo VALUES ('6325224', 'NP_015292.1','Hypothetical ORF; Ypl033cp [Saccharomyces cerevisiae]','MKKTIYKVLVSFYQYVGLGKKFHPSHDTVLIIGGSSNELGIELCETFIEDYHTKVINIDTIDSINGKNARRSEKLYTFISCKDFSDIKCLEESMLYLQNLEIIPTVLINNMQEGIESTLLKEDKFLRLDEESLNEFEKIVRYNLQSVILITKFCLSNIFPKVQAEAQEKAKGFYIVNISSVLTLKPCKSGTHFITSKCGINSFHDGITSELKLKDSNLNVKTLIAYLPSFESEAHWKRLSPSISKHLVHCLLEGRYGDTILESKRSIGDILLITGFKSSFT');
INSERT INTO proteininfo VALUES ('6325222', 'NP_015291.1','Hypothetical ORF; Ypl034wp [Saccharomyces cerevisiae]','MTTRKTVDSRLLEWQTTCKHPVINLTPEKVDKLYHLKLKSESKNISSNRLLPISLSSLQKKMEKLFIKDKSHSHKPSLPDPKVPTLRTYKDGGFFISGKGSMKLPDIESAIHKFLWKKYGKGLVYCYGCDPTGKKRHTEWFNVPVLELPSVLRLIDSYCLGGESR');
INSERT INTO proteininfo VALUES ('6325221', 'NP_015289.1','plasma membrane ATPase; Pma2p [Saccharomyces cerevisiae]','MSSTEAKQYKEKPSKEYLHASDGDDPANNSAASSSSSSSTSTSASSSAAAVPRKAAAASAADDSDSDEDIDQLIDELQSNYGEGDESGEEEVRTDGVHAGQRVVPEKDLSTDPAYGLTSDEVARRRKKYGLNQMAEENESLIVKFLMFFVGPIQFVMEAAAILAAGLSDWVDVGVICALLLLNASVGFIQEFQAGSIVDELKKTLANTATVIRDGQLIEIPANEVVPGEILQLESGTIAPADGRIVTEDCFLQIDQSAITGESLAAEKHYGDEVFSSSTVKTGEAFMVVTATGDNTFVGRAAALVGQASGVEGHFTEVLNGIGIILLVLVIATLLLVWTACFYRTVGIVSILRYTLGITIIGVPVGLPAVVTTTMAVGAAYLAKKQAIVQKLSAIESLAGVEILCSDKTGTLTKNKLSLHEPYTVEGVSPDDLMLTACLAASRKKKGLDAIDKAFLKSLIEYPKAKDALTKYKVLEFHPFDPVSKKVTAVVESPEGERIVCVKGAPLFVLKTVEEDHPIPEDVHENYENKVAELASRGFRALGVARKRGEGHWEILGVMPCMDPPRDDTAQTINEARNLGLRIKMLTGDAVGIAKETCRQLGLGTNIYNAERLGLGGGGDMPGSELADFVENADGFAEVFPQHKYRVVEILQNRGYLVAMTGDGVNDAPSLKKADTGIAVEGATDAARSAADIVFLAPGLSAIIDALKTSRQIFHRMYSYVVYRIALSLHLEIFLGLWIAILNNSLDINLIVFIAIFADVATLTIAYDNAPYAPEPVKWNLPRLWGMSIILGIVLAIGSWITLTTMFLPNGGIIQNFGAMNGVMFLQISLTENWLIFVTRAAGPFWSSIPSWQLAGAVFAVDIIATMFTLFGWWSENWTDIVSVVRVWIWSIGIFCVLGGFYYIMSTSQAFDRLMNGKSLKEKKSTRSVEDFMAAMQRVSTQHEKSS');
INSERT INTO proteininfo VALUES ('6325220', 'NP_015288.1','Subunit beta1 of the nascent polypeptide-associated complex (NAC) involved in protein targeting, associated with cytoplasmic ribosomes; enhances DNA binding of the Gal4p activator; homolog of human BTF3b; Egd1p [Saccharomyces cerevisiae]','MPIDQEKLAKLQKLSANNKVGGTRRKLNKKAGSSAGANKDDTKLQSQLAKLHAVTIDNVAEANFFKDDGKVMHFNKVGVQVAAQHNTSVFYGLPQEKNLQDLFPGIISQLGPEAIQALSQLAAQMEKHEAKAPADAEKKDEAIPELVEGQTFDADVE');
INSERT INTO proteininfo VALUES ('6325219', 'NP_015287.1','Zinc-finger DNA-binding protein, involved in regulating expression of the methionine biosynthetic genes, similar to Met32p; Met31p [Saccharomyces cerevisiae]','MKLAQDMNVDEIFLKQAAEAIAVISSSPTHTDPIIRELLHRIRQSSPLSAVIPAPENVLKAGEPENMARGLIRIPETQTKRTGGNNHSKEGAQLYSCAKCQLKFSRSSDLRRHEKVHSLVLPHICSNCGKGFARKDALKRHSNTLTCQRNRKKLSEGSDVDVDELIKDAIKNGTGLL');
INSERT INTO proteininfo VALUES ('6325218', 'NP_015286.1','Hypothetical ORF; Ypl039wp [Saccharomyces cerevisiae]','MLKEEYNLSGADNMASAELSFKKQKVVLKKFMIAQVTKGIMQRYASLLVTMPSDDDNAIIGTNHLKTTKFLEIILHRAKSSHLQFKKVCCIVIKFLDCCSKETNYMKFLKFSLHKLFVAAFILSVPNVVGDDRDRITTRDETYHLYSQITGLPLEEVINCCSIVRPVLIRRSRQQRRQMLSRREQHSYFLRSSFMNSNSSASPFFSTNRSADDLHVHTRAYSLHSHSDGEGQDRRSEHEETHSMGADADTYRQTTFIPDTPNGLHSRSLIECGIEPTQVSDSGEWSGQSNGYVLVTELQEFNKMGKKLVQEAFRIV');
INSERT INTO proteininfo VALUES ('6325217', 'NP_015285.1','Mitochondrial isoleucyl-tRNA synthetase, null mutant is deficient in respiratory growth; Ism1p [Saccharomyces cerevisiae]','MKRSRLVPQHIFSIISKRYLAKHAYQKTLNLPKTKFPNRSNLEITLRELIPKSSQLVYKEQLRDFFEEFSKLNTTDEKLEFIKEKLFILHDGPPYANGELHLGHALNKILKDIINRYQLSQGKYIFYKPGWDCHGLPIEIKALKDLSAQQIESISPLKIRSMALKHAQKAIKRQRETFQHFAILTDWETPYLTMDKDYEINQLNIFKEMYERGLIKRQNKPVYWGTETRTALAEGELEYNENHKSIAAYVKFPLEKKSQMDLCKKLGITNNLPIYCLIWTSTPWTLLSNRAICFNQDFSYSLLRLNSELILVETGSIDKLGLTTNSFETIKQFQGTHLNGLYYQNLLVDDKVGRPLLHGAHVTSGTGTGLVHTAPGHGQDDYLIGIQNGLEIYSPVDHQGRYQLNELPQSVRSIVRDEGDLTKGRQVLDAETAKIILCKLSDLNLLYKSHEYTHSYPYDWRSKKPVIIRATPQWFADLHDVKNLALESISRVKFCPKRGYSRLSSFMKSRNEWCISRQRSWGIPILSFYKKSEPDSVLMNSEILAHAIEKIKQKGINAWFNDKDNDMKEWLPEKYHDVAHEYCRSQDTMDVWFDSGSSWSVIKDFYEKSLKLSKLPSPLYQVCLEGSDQHRGWFQSSLLTKVASSNVPVAPYEEVITHGFTLDENGLKMSKSVGNTISPEAIIRGDENLGLPALGVDGLRYLIAQSNFTTDIVAGPTVMKHVGEALKKVRLTFRYLLSNLQKSQDFNLLPIEQLRRVDQYTLYKINELLETTREHYQKYNFSKVLITLQYHLNNELSAFYFDISKDILYSNQISSLARRQVQTTLVHILNAYRAILAPILPVMVQEVWKYIPEGWLQGQEHIDINPMRGKWPFLDSNTEIVTSFENFELKILKQFQEEFKRLSLEEGVTKTTHSHVTIFTKHHLPFSSDELCDILQSSAVDILQMDDNNNSLPTIELGSGINVQILVERSKRHNCPRCWKANSAEEDKLCDRCKEAVDHLMS');
INSERT INTO proteininfo VALUES ('6325216', 'NP_015284.1','Hypothetical ORF; Ypl041cp [Saccharomyces cerevisiae]','MTVMNLFFRPCQLQMGSGPLELMLKRPTQLTTFMNTRPGGSTQIRFISGNLDPVKRREDRLRKIFSKSRLLTRLNKNPKFSHYFDRLSEAGTVPTLTSFFILHEVTAILPLFLLWWLLYNLDLSDDFKLPNFLNGLMDSCHTAMEKFVGKRYQECLNKNKLILSGTVAYVTVKLLYPVRIFISIWGAPYFGKWLLLPFQKLKHLIKK');
INSERT INTO proteininfo VALUES ('6325215', 'NP_015283.1','Component of RNA polymerase II holoenzyme, involved in RNA pol II carboxy-terminal domain phosphorylation; Ssn3p [Saccharomyces cerevisiae]','MYNGKDRAQNSYQPMYQRPMQVQGQQQAQSFVGKKNTIGSVHGKAPMLMANNDVFTIGPYRARKDRMRVSVLEKYEVIGYIAAGTYGKVYKAKRQINSGTNSANGSSLNGTNAKIPQFDSTQPKSSSSMDMQANTNALRRNLLKDEGVTPGRIRTTREDVSPHYNSQKQTLIKKPLTVFYAIKKFKTEKDGVEQLHYTGISQSACREMALCRELHNKHLTTLVEIFLERKCVHMVYEYAEHDLLQIIHFHSHPEKRMIPPRMVRSIMWQLLDGVSYLHQNWVLHRDLKPANIMVTIDGCVKIGDLGLARKFHNMLQTLYTGDKVVVTIWYRAPELLLGARHYTPAVDLWSVGCIFAELIGLQPIFKGEEAKLDSKKTVPFQVNQLQRILEVLGTPDQKIWPYLEKYPEYDQITKFPKYRDNLATWYHSAGGRDKHALSLLYHLLNYDPIKRIDAFNALEHKYFTESDIPVSENVFEGLTYKYPARRIHTNDNDIMNLGSRTKNNTQASGITAGAAANALGGLGVNRRILAAAAAAAAAVSGNNASDEPSRKKNRR');
INSERT INTO proteininfo VALUES ('6325213', 'NP_015282.1','Nucleolar protein, essential for processing and maturation of 27S pre-rRNA and large ribosomal subunit biogenesis; contains four RNA recognition motifs (RRMs); Nop4p [Saccharomyces cerevisiae]','MEETIENVEVPSSNVSKQNDDGLDMKTLFVRSIPQDVTDEQLADFFSNFAPIKHAVVVKDTNKRSRGFGFVSFAVEDDTKEALAKARKTKFNGHILRVDIAKRRDRSKKTSEVVEKSTPESSEKITGQNNEDEDDADGEDSMLKGKPKLIIRNMPWSCRDPVKLKKIFGRYGTVVEATIPRKRDGKLCGFAFVTMKKISNCRIALENTKDLKIDGRKVAVDFAVQKNRWEDYKKAQPEMNDKDDNESGNEDAEENHDDEEDENEEEDRQVDQASKNKESKRKAQNKREDFSVFVRNVPYDATEESLAPHFSKFGSVKYALPVIDKSTGLAKGTAFVAFKDQYTYNECIKNAPAAGSTSLLIGDDVMPEYVYEGRVLSITPTLVREDAGRMAEKNAAKRKEALGKAPGEKDRRNLYLLNEGRVVEGSKMADLLTNTDMEIREKSYKLRVEQLKKNPSLHLSMTRLAIRNLPRAMNDKALKALARKAVVEFATEVKNKERHPLSKEEIIRSTKEKYKFMGPDEIEAQKKKDKKSGVVKQAKVIMEVKGSTAGRSRGYGFVEFRDHKNALMGLRWLNCHAVTSDEILEGLNDDEKKQVDNDLGKGRRLCVEFAIENSNVVKRRREQLKQARTKRTRPDNEDTGDVGESENKKPKKEEATTPTNPDDKKMGDDIKRIIGFKRKRKHAKK');
INSERT INTO proteininfo VALUES ('6325212', 'NP_015280.1','Vacuolar sorting protein; Vps16p [Saccharomyces cerevisiae]','MKNPSFDWERLKDVFYRSRAIGELKWPTQYEEFKCALSLTVIAVEIQDFIQVYNYFGQLLGKINLQRIHEDIIKFEFDKDEKLILVTKSSIKIVKGWSPLTIESVPLQDPTIDTIWDYHNGIMLLAKSRDIYKLNGNEWELLYENKDKKYNLLTKNHWSCNDDSIILLDVDHVYQVSTSNGALLKLITDSSWHKVTISSRGFICLYNMKDNKLQIFRDPARILMEHNLDSTPDDICWCGNDTVACSFEDEIKLYGPDGLYVTFWYPFTVTNLRAEVDGLKVITTEKIYFLSRVQPQTSNIFRIGSTEPGAMLVDSFSLLEDHAPKAIEILKNFVLEKGVLDCIAAAIDEFEPKLQKMLLNAASYGKASLQYKSFDASIFVNACNTIKLLNCFRSFGIFLTVEEYRCISLKGVIDRLLKYHRYYECIQICKLANERFLLGYVFTEWAKDKIKGSPDMEDDELLDKIKSRLSVIDMTDTLQMVAVAKVAYLEGRFQLSRNLALLEKNEEARIEQLYNLDDDSIALKECIKVQNYSLTISLLIALSKKLTNSQLTKLLIIDMFNNPLYLYYMRMDKAYLYDFYRQTDRFIDLAHVLLQQGKEQQSLHSFLPQIKDLYSQVQNSEVVNNTIEQLQRQEKLWIYQESLGKRFAISFTNMTLDQTLSKLIETGQDKQVKEIVKKFKISEKKLYHLKCKTLVEAKKFDELLQFAQSRKSPIGYMPFYTYLKSRGHMDKASPYVNMIPGLSYQEKKKLYVECRGFRDAIQLAGKEKDIPGLKEIYNIIPPNEPELKALANETMSRI');
INSERT INTO proteininfo VALUES ('6325211', 'NP_015279.1','Elongin C, forms heterodimer with Ela1p that participates in transcription elongation; expression dramatically upregulated during sporulation; widely conserved among eukaryotes; Elc1p [Saccharomyces cerevisiae]','MSQDFVTLVSKDDKEYEISRSAAMISPTLKAMIEGPFRESKGRIELKQFDSHILEKAVEYLNYNLKYSGVSEDDDEIPEFEIPTEMSLELLLAADYLSI');
INSERT INTO proteininfo VALUES ('6325210', 'NP_015278.1','11kDa subunit of the SAGA histone acetyltransferase complex involved in regulation of transcription of a subset of SAGA-regulated genes; Sgf11p [Saccharomyces cerevisiae]','MTEETITIDSISNGILNNLLTTLIQDIVARETTQQQLLKTRYPDLRSYYFDPNGSLDINGLQKQQESSQYIHCENCGRDVSANRLAAHLQRCLSRGARR');
INSERT INTO proteininfo VALUES ('6325209', 'NP_015277.1','Calcium and phospholipid binding protein homologous to translation elongation factor 1-gamma (EF-1gamma); Cam1p [Saccharomyces cerevisiae]','MSQGTLYANFRIRTWVPRGLVKALKLDVKVVTPDAAAEQFARDFPLKKVPAFVGPKGYKLTEAMAINYYLVKLSQDDKMKTQLLGADDDLNAQAQIIRWQSLANSDLCIQIANTIVPLKGGAPYNKKSVDSAMDAVDKIVDIFENRLKNYTYLATENISLADLVAASIFTRYFESLFGTEWRAQHPAIVRWFNTVRASPFLKDEYKDFKFADKPLSPPQKKKEKKAPAAAPAASKKKEEAKPAATETETSSKKPKHPLELLGKSTFVLDDWKRKYSNEDTRPVALPWFWEHYNPEEYSLWKVTYKYNDELTLTFMSNNLVGGFFNRLSASTKYMFGCLVVYGENNNNGIVGAVMVRGQDYVPAFDVAPDWESYDYAKLDPTNDDDKEFINNMWAWDKPVSVNGEPKEIVDGKVLK');
INSERT INTO proteininfo VALUES ('6325208', 'NP_015276.1','Regulatory protein of unknown function, constitutively-expressed, involved in the regulation of mating-specific genes and the invasive growth pathway, required for MAP-kinase imposed repression, inhibits pheromone-responsive transcription; Dig1p [Saccharomyces cerevisiae]','MAVSARLRTTAEDTSIAKSTQDPIGDTEISVANAKGSSDSNIKNSPGGNSVGQESELEHVPEEDDSGDKEADHEDSETATAKKRKAQPLKNPKKSLKRGRVPAPLNLSDSNTNTHGGNIKDGNLASSNSAHFPPVANQNVKSAPAQVTQHSKFQPRVQYLGKASSRQSIQVNNSSNSYGKPHMPSAGIMSAMNPYMPMNRYIMSPYYNPYGIPPPHMLNKPIMTPYVSYPYPMGPRTSIPYAMQGGNARPYEENEYSASNYRNKRVNDSYDSPLSGTASTGKTRRSEEGSRNSSVGSSANAGPTQQRADLRPADMIPAEEYHFERDALLSANTKARSASTSTSTSTSTNRDRSSWHEAEPNKDEEEGTDLAIEDGAVPTPTFTTFQRTSQPQQQSPSLLQGEIRLSSHIFAFEFPLSSSNVDKKMFMSICNKVWNESKELTKKSSSHHRTGK');
INSERT INTO proteininfo VALUES ('6325207', 'NP_015275.1','Subunit of Golgi mannosyltransferase complex also containing Anp1p, Mnn10p, Mnn11p, and Hoc1p that mediates elongation of the polysaccharide mannan backbone; forms a separate complex with Van1p that is also involved in backbone elongation; Mnn9p [Saccharomyces cerevisiae]','MSLSLVSYRLRKNPWVNIFLPVLAIFLIYIIFFQRDQSLLGLNGQSISQHKWAHEKENTFYFPFTKKYKMPKYSYKKKSGWLFNDHVEDIIPEGHIAHYDLNKLHSTSEAAVNKEHILILTPMQTFHQQYWDNLLQLNYPRELIELGFITPRTATGDLALKKLENAIKKVQTDKKTQRFSKITILRQNSQSFDKLMEKERHALDVQKERRAAMALARNELLFSTIGPHTSWVLWLDADIIETPPSLIQDMTKHNKAILAANIYQRFYDEEKKQPSIRPYDFNNWQESDTGLEIASQMGDDEIIVEGYAEIATYRPLMAHFYDANGVPGEEMALDGVGGGCTLVKAEVHRDGAMFPNFPFYHLIETEGFAKMAKRLNYDVFGLPNYLVYHIEEENH');
INSERT INTO proteininfo VALUES ('6325206', 'NP_015274.1','Protein similar to ADP-ribosylation factor, involved in the carboxypeptidase Y pathway; Arl3p [Saccharomyces cerevisiae]','MFHLVKGLYNNWNKKEQYSILILGLDNAGKTTFLETLKKEYSLAFKALEKIQPTVGQNVATIPVDSKQILKFWDVGGQESLRSMWSEYYSLCHGIIFIVDSSDRERLDECSTTLQSVVMDEEIEGVPILMLANKQDRQDRMEVQDIKEVFNKIAEHISARDSRVLPISALTGEGVKDAIEWMIVRLERNKKSRPPIYK');
INSERT INTO proteininfo VALUES ('6325205', 'NP_015273.1','Hypothetical ORF; Ypl052wp [Saccharomyces cerevisiae]','MESQFILDYNVPSKNKGNNQKSVAKLLKNKLVNDMKTTLKRLIYNENTKQYKNNNSHDGYNWRKLGSQYFILYLPLFTQELIWCKLNENYFHVVLPSLLNSRNVHDNHSTYINKDWLLALLELTSNLNQNFKFEYMKLRLYILRDDLINNGLDLLKNLNWVGGKLIKNEDREVLLNSTDLATDSISHLLGDENFVILEFEC');
INSERT INTO proteininfo VALUES ('6325204', 'NP_015272.1','Carboxypeptidase B-like processing protease, cleaves lys and arg residues from the C-terminus of peptides and proteins, including killer toxin and alpha factor precursor YGL203C; Ktr6p [Saccharomyces cerevisiae]','MHVLLSKKIARFLLISFVFVLALMVTINHPKTKQMSEQYVTPYLPKSLQPIAKISAEEQRRIQSEQEEAELKQSLEGEAIRNATVNAIKEKIKSYGGNETTLGFMVPSYINHRGSPPKACFVSLITERDSMTQILQSIDEVQVKFNKNFAYPWVFISQGELDGMKQEMIRQAITDSMNGDPELINIKFAEIPADEWVYPEWIDENKAAESLISLANVPDGDSRAVRYQARYFAGFFWRHPVLDEFDWYWRVDPGIKLYCDIDHDLFRWMQDEGKVFGFTLSMSEAKEANEKIWDVTKKFAKDFPKFISENNFKSFITKKDSEDFNNCEFTSNFEIGNLNFYRSPAYRKFFNYIDEEGGIFYWKWSDSIIHTIGLSMLLPKDKIHFFENIGFHYDKYNNCPLNDDIWNQYNCNCDQGNDFTFRSGSCGGHYFDIMKKDKPEGWDRLP');
INSERT INTO proteininfo VALUES ('6325203', 'NP_015271.1','Protein of unknown function; Lee1p [Saccharomyces cerevisiae]','MDAFENMSVSNHPGGNARRNSQSANEMLASQIQDFQNIPRSFNDSNANVNLSKNCTVGNQLPFSSRQQKIIMEHLLITKNNSQQQKDYSHVPCKFFKMGNCQAGSSCPFSHSPDIISSANNLPCKYFAKGNCKFGNKCVNAHVLPNGFKMNSKEPIDITPPSQNNYLSHARSASFSTYTSPPLSAQTEFSHSASNANYFSSQYLMYSPQKSPEALYTEFFSPPSSSSSYINYSYNNSNINAYSPVSSSSSNIWQEQGQTTLSNPSVNQNLRYRTGPAIQEESDNEIEDLLIHNFNSRYCHE');
INSERT INTO proteininfo VALUES ('6325202', 'NP_015270.1','Protein of unknown function; null mutant forms abnormally large cells; Lge1p [Saccharomyces cerevisiae]','MSGYTGNNYSRYSSTPPRQRGGYHHARRSRGGAGGSYYRGGNASYGARYNSDYEQPPQEGDLRQTGAYYRNGYTDTRPYYSANSRHYQAQPSPRYNNGTNSYHLPQRGNSQDTNGRTTSASQEDNDEKRVKSRYRNMQADHPRQQPMSVGSTSSRNGSSGNSSTSSTSNGLPPPPSVSSITNNRSYHSSAYPYSSSHTYNNYHHRETPPPPPSNGYYAKGYPVHVPENRSNSDGSSSSVVKKKRILDMKDSPFIYLTDFDKNVKKTNNTESECEKAREVFKESDSIDSALEELNLKINSNELELRLLNNQCDKHALNIQLTQEKLDSLLLMQ');
INSERT INTO proteininfo VALUES ('6325201', 'NP_015269.1','Hypothetical ORF; Ypl056cp [Saccharomyces cerevisiae]','MKNAALCEALPLLATCSHEIPPTPHTVCFVFPPALLLSPSKLTLLNSRRVASRCVIIIDPRLLRLFSCSRPQQLPRDKNQSFAKPSFSFFFFLLTSLLSPF');
INSERT INTO proteininfo VALUES ('6325200', 'NP_015268.1','Probable catalytic subunit of a mannosylinositol phosphorylceramide (MIPC) synthase, forms a complex with probable regulatory subunit Csg2p; function in sphingolipid biosynthesis is overlapping with that of Csh1p; Sur1p [Saccharomyces cerevisiae]','MRKELKYLICFNILLLLSIIYYTFDLLTLCIDDTVKDAILEEDLNPDAPPKPQLIPKIIHQTYKTEDIPEHWKEGRQKCLDLHPDYKYILWTDEMAYEFIKEEYPWFLDTFENYKYPIERADAIRYFILSHYGGVYIDLDDGCERKLDPLLAFPAFLRKTSPLGVSNDVMGSVPRHPFFLKALKSLKHYDKYWFIPYMTIMGSTGPLFLSVIWKQYKRWRIPKNGTVRILQPAYYKMHSYSFFSITKGSSWHLDDAKLMKALENHILSCVVTGFIFGFFILYGEFTFYCWLCSKNFSNLTKNWKLNAIKVRFVTILNSLGLRLKLSKSTSDTASATLLARQQKRLRKDSNTNIVLLKSSRKSDVYDLEKNDSSKYSLGNNSS');
INSERT INTO proteininfo VALUES ('6325199', 'NP_015267.1','Plasma membrane weak-acid-inducible ATP-binding cassette (ABC) transporter, required for weak organic acid resistance, strongly induced by sorbate and benzoate, regulated by War1p, mutants exhibit sorbate hypersensitivity; Pdr12p [Saccharomyces cerevisiae]','MSSTDEHIEKDISSRSNHDDDYANSVQSYAASEGQVDNEDLAATSQLSRHLSNILSNEEGIERLESMARVISHKTKKEMDSFEINDLDFDLRSLLHYLRSRQLEQGIEPGDSGIAFKNLTAVGVDASAAYGPSVEEMFRNIASIPAHLISKFTKKSDVPLRNIIQNCTGVVESGEMLFVVGRPGAGCSTFLKCLSGETSELVDVQGEFSYDGLDQSEMMSKYKGYVIYCPELDFHFPKITVKETIDFALKCKTPRVRIDKMTRKQYVDNIRDMWCTVFGLRHTYATKVGNDFVRGVSGGERKRVSLVEAQAMNASIYSWDNATRGLDASTALEFAQAIRTATNMVNNSAIVAIYQAGENIYELFDKTTVLYNGRQIYFGPADKAVGYFQRMGWVKPNRMTSAEFLTSVTVDFENRTLDIKPGYEDKVPKSSSEFEEYWLNSEDYQELLRTYDDYQSRHPVNETRDRLDVAKKQRLQQGQRENSQYVVNYWTQVYYCMIRGFQRVKGDSTYTKVYLSSFLIKALIIGSMFHKIDDKSQSTTAGAYSRGGMLFYVLLFASVTSLAEIGNSFSSRPVIVKHKSYSMYHLSAESLQEIITEFPTKFVAIVILCLITYWIPFMKYEAGAFFQYILYLLTVQQCTSFIFKFVATMSKSGVDAHAVGGLWVLMLCVYAGFVLPIGEMHHWIRWLHFINPLTYAFESLVSTEFHHREMLCSALVPSGPGYEGISIANQVCDAAGAVKGNLYVSGDSYILHQYHFAYKHAWRNWGVNIVWTFGYIVFNVILSEYLKPVEGGGDLLLYKRGHMPELGTENADARTASREEMMEALNGPNVDLEKVIAEKDVFTWNHLDYTIPYDGATRKLLSDVFGYVKPGKMTALMGESGAGKTTLLNVLAQRINMGVITGDMLVNAKPLPASFNRSCGYVAQADNHMAELSVRESLRFAAELRQQSSVPLEEKYEYVEKIITLLGMQNYAEALVGKTGRGLNVEQRKKLSIGVELVAKPSLLLFLDEPTSGLDSQSAWSIVQFMRALADSGQSILCTIHQPSATLFEQFDRLLLLKKGGKMVYFGDIGPNSETLLKYFERQSGMKCGVSENPAEYILNCIGAGATASVNSDWHDLWLASPECAAARAEVEELHRTLPGRAVNDDPELATRFAASYMTQIKCVLRRTALQFWRSPVYIRAKFFECVACALFVGLSYVGVNHSVGGAIEAFSSIFMLLLIALAMINQLHVFAYDSRELYEVREAASNTFHWSVLLLCHAAVENFWSTLCQFMCFICYYWPAQFSGRASHAGFFFFFYVLIFPLYFVTYGLWILYMSPDVPSASMINSNLFAAMLLFCGILQPREKMPAFWRRLMYNVSPFTYVVQALVTPLVHNKKVVCNPHEYNIMDPPSGKTCGEFLSTYMDNNTGYLVNPTATENCQYCPYTVQDQVVAKYNVKWDHRWRNFGFMWAYICFNIAAMLICYYVVRVKVWSLKSVLNFKKWFNGPRKERHEKDTNIFQTVPGDENKITKK');
INSERT INTO proteininfo VALUES ('6325198', 'NP_015266.1','Hydroperoxide and superoxide-radical responsive glutathione-dependent oxidoreductase; mitochondrial matrix protein involved in the synthesis/assembly of iron-sulfur centers; monothiol glutaredoxin subfamily member along with Grx3p and Grx4p; Grx5p [Saccharomyces cerevisiae]','MFLPKFNPIRSFSPILRAKTLLRYQNRMYLSTEIRKAIEDAIESAPVVLFMKGTPEFPKCGFSRATIGLLGNQGVDPAKFAAYNVLEDPELREGIKEFSEWPTIPQLYVNKEFIGGCDVITSMARSGELADLLEEAQALVPEEEEETKDR');
INSERT INTO proteininfo VALUES ('6325197', 'NP_015265.1','Mitochondrial inner membrane magnesium transporter, involved in maintenance of magnesium concentrations inside mitochondria; indirectly affects splicing of group II introns; functionally and structurally related to Mrs2p; Lpe10p [Saccharomyces cerevisiae]','MRAFPRVLPFRHQRSYNNILLRTVRLFGSSLSSFDFSRQMPKVDPDNTAAMLLQKNLIQRNNMLYGYGSGTIRCTLLDSTGRAKSPLVEIKREDLVSKHGLLPRDLRKIEKSRKNDLVPSLLVRENSILISLLTVKALIKPDMVIIFDSAGSGITLNSEAHKDFINDMKLRLKNQETSELNSDPLPYEFRALETIFISALSNLTSEMKVLLTICKGVLQDLEFSITRDKLRFLLGQNKKLSSFNKKAVLVKDMLDDLLEQDDMLCDMYLTDKKAGKIRVQDDHTEIEMLLETYHNYVDEIVQKSESAISDVKTTEEIINIILDSNRNELMLLGIRYAIGMLSLGGALFLGSIYGMNLESFIEESNYAYLTVTILGLISTVWLYAKGIRHLHKLQRMTLLSKIKTDSVHELLKK');
INSERT INTO proteininfo VALUES ('6325196', 'NP_015264.1','Cytosolic aldehyde dehydrogenase that is activated by Mg2+ and utilizes NADP+ as the preferred coenzyme; Ald6p [Saccharomyces cerevisiae]','MTKLHFDTAEPVKITLPNGLTYEQPTGLFINNKFMKAQDGKTYPVEDPSTENTVCEVSSATTEDVEYAIECADRAFHDTEWATQDPRERGRLLSKLADELESQIDLVSSIEALDNGKTLALARGDVTIAINCLRDAAAYADKVNGRTINTGDGYMNFTTLEPIGVCGQIIPWNFPIMMLAWKIAPALAMGNVCILKPAAVTPLNALYFASLCKKVGIPAGVVNIVPGPGRTVGAALTNDPRIRKLAFTGSTEVGKSVAVDSSESNLKKITLELGGKSAHLVFDDANIKKTLPNLVNGIFKNAGQICSSGSRIYVQEGIYDELLAAFKAYLETEIKVGNPFDKANFQGAITNRQQFDTIMNYIDIGKKEGAKILTGGEKVGDKGYFIRPTVFYDVNEDMRIVKEEIFGPVVTVAKFKTLEEGVEMANSSEFGLGSGIETESLSTGLKVAKMLKAGTVWINTYNDFDSRVPFGGVKQSGYGREMGEEVYHAYTEVKAVRIKL');
INSERT INTO proteininfo VALUES ('6325194', 'NP_015262.1','Protein of the inner mitochondrial membrane, required for import of mitochondrial matrix proteins; Tim50p [Saccharomyces cerevisiae]','MLSILRNSVRLNSRALRVVPSAANTLTSVQASRRLLTSYSSFLQKETKDDKPKSILTDDMLFKAGVDVDEKGQGKNEETSGEGGEDKNEPSSKSEKSRRKRQTSTDIKREKYANWFYIFSLSALTGTAIYMARDWEPQESEELKKDIDNGYTLSLMYKRFKARFNSMFTYFQEPPFPDLLPPPPPPPYQRPLTLVITLEDFLVHSEWSQKHGWRTAKRPGADYFLGYLSQYYEIVLFSSNYMMYSDKIAEKLDPIHAFVSYNLFKEHCVYKDGVHIKDLSKLNRDLSKVIIIDTDPNSYKLQPENAIPMEPWNGEADDKLVRLIPFLEYLATQQTKDVRPILNSFEDKKNLAEEFDHRVKKLKDKFYGDHKSGGNWAMTALGLGNSLGGSTKFPLDLIHEEGQKNYLMFMKMIEEEKEKIRIQQEQMGGQTFTLKDYVEGNLPSPEEQMKIQLEKQKEVDALFEEEKKKKKIAESK');
INSERT INTO proteininfo VALUES ('6325193', 'NP_015261.1','Component of a complex containing Cef1p, putatively involved in pre-mRNA splicing; has similarity to S. pombe Cwf27p; Cwc27p [Saccharomyces cerevisiae]','MSSNIEPQTTAKCILYTTKGNIAIELWAKECPETCKRFLSMLSDGTFTNGEFKELKPTQWLMFNANSTGEYRTVAEEKNPRIRFNRDGLLGWDRRRNTWFITVLADSKHVLNDCNVFGKIVGKSIYIFREILGGEIEASSRDNDVKRFMYPAVLKDVEITIPFFEDIFGSKRRLEDNEKKEQEPAKKLVKSAKVKMVYEDEQEDDDGDVQKLKPRKRMILPAWIKDDSRSEGIKLDASLDQPQEALIREKTELHDNVDEATTKETESQENIKEEPMDKRERETLAMLSKFQERIKNKNILK');
INSERT INTO proteininfo VALUES ('6325192', 'NP_015260.1','soluble, hydrophilic protein involved in transport of precursors for soluble vauolar hydrolases from the late endosome to the vacuole; involved in vacuolar protein targeting; Vps28p [Saccharomyces cerevisiae]','MQKHNIKLNQNQDISQLFHDEVPLFDNSITSKDKEVIETLSEIYSIVITLDHVEKAYLKDSIDDTQYTNTVDKLLKQFKVYLNSQNKEEINKHFQSIEAFCDTYNITASNAITRLERGIPITAEHAISTTTSAPSGDNKQSSSSDKKFNAKYVAEATGNFITVMDALKLNYNAKDQLHPLLAELLISINRVTRDDFENRSKLIDWIVRINKLSIGDTLTETQIRELLFDLELAYKSFYALLD');
INSERT INTO proteininfo VALUES ('6325191', 'NP_015259.1','Hypothetical ORF; Ypl066wp [Saccharomyces cerevisiae]','MTHPVISLKPSYNSVIRGCPGLPDTLPRIECQLRVRSNNSLPFKLVKIEIVLKTIEIYFNKNLYSSNNSSFTPFNRPSDPSNGHSDTSNQNISIHYKKNIVLSHPTHDGDDLNNDLIGIDIPLTIGLPDDIKETNYNPKFGKTQTFLDCTVFYTEVGGGSSNKKRNFLYPVNVERYTYLPSPSYFRPINRSNITSPDQKFLISYSIENPCVSMNNDTLKLSISIRLNPFPNNATTPSSNDFDVSTPTLFSTKKKFKSKLKLKSITTQILEYLEILKNQSEFSSTQTTNILQTSVRQVDQIISMNSMIFQFNLKIFTKDKILQSFRSSESSCPETKVLINKIDDIPLQYHSSITTIGQHFNVSHYLSIRFKFNKSLKNFEINHPLIISFWSVSQLPLIENLILQERQTAKFAKKFYKNFGRIKNTSNNNNSSNCLEYPSLPPIIYNFNDPETNNRFNILYSQKDPSRTDPSKLRRVPVIQ');
INSERT INTO proteininfo VALUES ('6325190', 'NP_015258.1','Hypothetical ORF; Ypl067cp [Saccharomyces cerevisiae]','MQQDIVNDHQEEAQGWKWEQIKEIIESGELARLKRSRQMTDKYHEHKKRTAGLDMNQYVLQKLGWSLDEPQLENAAAKAFSSSTLYAVRANDFPYNFEPGVVHLVLWSKVALPVHSPDKAVREAARARMNAFLQAQPLLRPLLSSGHVAWFVNYPELQSVARIFHAHVLLFFPRERYSAEQVKTTVDDILSHGFEPLA');
INSERT INTO proteininfo VALUES ('6325189', 'NP_015257.1','Hypothetical ORF; Ypl068cp [Saccharomyces cerevisiae]','MHMQLRKRKRVDYSGRNQTSDPPSTTTAAVPSIIVPKKRKVVAQNMVSPAIRATTTTLGTSNIIIPKPLQRPKFHNSASLSSPDDDPEKISVLEVQKNLSNLIKRQQRLFYKDIHKPTLAGLKNFEMLRLPNDLKLLQNIVNLLYSFEQLNSDSKTRPVTTSKLKASSQAHSDKLKKMLAERKPPFSHPSHSGTAYHNDIIHEIANLHSINLVDLINLEVYNNNCHTNNTALQTTANSLTLNSIIKKLDKPILKERNNSLVWPHKSRFKAKRNQPSPGQSLINNTDITLYNDV');
INSERT INTO proteininfo VALUES ('6325188', 'NP_015256.1','Required for membrane attachment of YPT1 and SEC4; geranylgeranyl diphosphate synthase; Bts1p [Saccharomyces cerevisiae]','MEAKIDELINNDPVWSSQNESLISKPYNHILLKPGKNFRLNLIVQINRVMNLPKDQLAIVSQIVELLHNSSLLIDDIEDNAPLRRGQTTSHLIFGVPSTINTANYMYFRAMQLVSQLTTKEPLYHNLITIFNEELINLHRGQGLDIYWRDFLPEIIPTQEMYLNMVMNKTGGLFRLTLRLMEALSPSSHHGHSLVPFINLLGIIYQIRDDYLNLKDFQMSSEKGFAEDITEGKLSFPIVHALNFTKTKGQTEQHNEILRILLLRTSDKDIKLKLIQILEFDTNSLAYTKNFINQLVNMIKNDNENKYLPDLASHSDTATNLHDELLYIIDHLSEL');
INSERT INTO proteininfo VALUES ('6325187', 'NP_015255.1','Portein of unknown function, localized to the cytoplasm; computational analysis of large-scale protein-protein interaction data suggests a possible role in transcriptional regulation; Muk1p [Saccharomyces cerevisiae]','MARQLFTPPITNPRFDPNQSIRESYKNTTGGMQFQQNLHEDQNDNERSSCDGDENSTTGERLENNKSPILTKQEIDEALNTVTNLPPELSKLIDIFIDDLKQPKYVRPLSVLQLSSLFQSFYIKFDKASFQHVSSANNNGYYFSGGGSSSFLAAKETLSSGLSGIFGRSRSSSGNSLMRPRRSSSLFSNESISNSTNATQMLSPEEIKKQLKINELNNMKIEKYMELCERDVFKKILIVGTSVSSPNKMKTFKPHQLQTFKVGNLFRNSVEFTEYNKLLNEKILCLSKLSTMNKINLIKFLSLNNGIDPEPKFEEIKDILYEFTYHSISPCEKIKALLKLHEIMTYSQEMSNDDYLSLLIYYIITIVPRDIFLNAEFIRLFRYKKKLVETESFALTNLEAALVFVEGLTKNDFSNELQDKLTVNESKILENSISSRVSLPSKTAIMHKNNGNNGSNLGDIVTPTIQRPDVTRSNSYDGFRTVFDSSLKNIIGKIRSYTPPHPNNTSNNNLHSSNNLNIPRSSSQLSMELSNRDTTEMSRDGSRSTSSSSRSSASLEHGNREFTGDLTVTASINGADKKEFQKSWKKYKGYKFEDLTICELRDLFEIYQKMMQ');
INSERT INTO proteininfo VALUES ('6325186', 'NP_015254.1','Hypothetical ORF; Ypl071cp [Saccharomyces cerevisiae]','MSSRFARSNGNPNHIRKRNHSPDPIGIDNYKRKRLIIDLENLSLNDKGPKNGHADDNNLIHNNIVFTDAIDDKVLKEIIKCSTSKRGDNDLFYDKIWERLREKRLQIIKWVDYKEIAYLSWWKWFHNQMTSKYTYDGEADTDVEMMAVDTDVDMDA');
INSERT INTO proteininfo VALUES ('6325184', 'NP_015253.1','Putative ubiquitin-specific protease; Ubp16p [Saccharomyces cerevisiae]','MSWIKNVTESPTSLIKKVSCGLIIAASLYAIAPSLSALVFGDSKQSIGKYTTVGLINRGNDCFITSSLQGLAGIPRFVEYLKRIRTVLLELETKLSNNAKGDNPTVDNTTRHSRLENSSNSLAPLHESLTSLILDLISVKDRKTSISPKIVINTLESIFKSKISSKQNDAHEFTLILLQTLQEERSKLIDYSKQICNLNIPKFPFEGETSKFLVCLKCKGLSEPSYKQTFIRELSVPQQTSENLSNILAHDETEIIDDYSCLICQIRAILNHEEYRNFKDCTPDEILMLDRLKNYATKAPINENLPFEVEQYVKRYSKGNLQVSNIKGKVIKKDVVVQLPDILIVHLSRSTFNGITYSRNPCNVKFGERITLSEYTLAESGTITENRQVKYNLKSVVKHTGSHSSGHYMCYRRKTEIRFGKEDESSFRRAPVVNNEVNKNREQNVAHNDYKKSRYKKVKNALRYPYWQISDTAIKESTASTVLNEQKYAYMLYYERVNK');
INSERT INTO proteininfo VALUES ('6325183', 'NP_015251.1','Putative ATPase of the CDC48/PAS1/SEC18 (AAA) family, localized to the cortex of mother cells but not to daughter cells; Yta6p [Saccharomyces cerevisiae]','MAHEKFSIPENFTLAQSLQLLYSVVKNQYKNLADLIINSKGNKDTVTYGKIHKNLDTLLVYVNEGLRKIEKTYTLKKGLGNLVVDHPELRSIIEDFQILGQDIRIARRKAETLMAEGNGSPSLSSSSSVLGLGTGNGLRFPKLWRMGSKRDKLKEADEKEAKINKQADNIRRARKLEEEKKLGAKLQYERDLELQREKLIELKVKEKVEFEVAQKLEEERVKREEEERKHREQAEKKRISTLKHERKTNYKSRASLDNFSSSSKSSGKIDNSLIKRRSLDVVRTSGERVRTPVRKSMEAAEIGMAAQLAWSQYQNGANHSKVSNNGSHSNELQIRYKPTPPLKKRYDYKKPTVNRPIIKSPTLNRQNSKSSRNIPTNSKLKASKSNTNKVSRRNEQNLEPSSPVLVSATAVPAESKPMRSKSGTPDKESSASSSLDSRKEDILKSVQGVDRNACEQILNEILVTDEKVYWEDIAGLRNAKNSLKEAVVYPFLRPDLFKGLREPVRGMLLFGPPGTGKTMIAKAVATESNSTFFSVSASSLLSKYLGESEKLVRALFYMAKKLSPSIIFIDEIDSMLTARSDNENESSRRIKTELLIQWSSLSSATAQSEDRNNTLDSRVLVLGATNLPWAIDDAARRRFSRKLYIPLPDYETRLYHLKRLMAKQKNSLQDLDYELITEMTEGFSGSDLTSLAKEAAMEPIRDLGDKLMFADFDKIRGIEIKDFQNALLTIKKSVSSESLQKYEEWSSKFGSNGS');
INSERT INTO proteininfo VALUES ('6325182', 'NP_015250.1','Transcriptional activator of genes involved in glycolysis, functions and interacts with Gcr2p; Gcr1p [Saccharomyces cerevisiae]','MVCTSTSSNFYSIAQYILQSYFKVNVDSLNSLKLVDLIVDQTYPDSLTLRKLNEGATGQPYDYFNTVSRDADISKCPIFALTIFFVIRWSHPNPPISIENFTTVPLLDSNFISLNSNPLLYIQNQNPNSNSSVKVSRSQTFEPSKELIDLVFPWLSYLKQDMLLIDRTNYKLYSLCELFEFMGRVAIQDLRYLSQHPLLLPNIVTFISKFIPELFQNEEFKGIGSIKNSNNNALNNVTGIETQFLNPSTEEVSQKVDSYFMELSKKLTTENIRLSQEITQLKADMNSVGNVCNQILLLQRQLLSGNQAIGSKSENIVSSTGGGILILDKNSINSNVLSNLVQSIDPNHSKPNGQAQTHQRGPKGQSHAQVQSTNSPALAPINMFPSLSNSIQPMLGTLAPQPQDIVQKRKLPLPGSIASAATGSPFSPSPVGESPYSKRFKLDDKPTPSQTALDSLLTKSISSPRLPLSTLANTAVTESFRSPQQFQHSPDFVVGGSSSSTTENNSKKVNEDSPSSSSKLAERPRLPNNDSTTSMPESPTEVAGDDVDREKPPESSKSEPNDNSPESKDPEKNGKNSNPLGTDADKPVPISNIHNSTEAANSSGTVTKTAPSFPQSSSKFEIINKKDTKAGPNEAIKYKLSRENKTIWDLYAEWYIGLNGKSSIKKLIENYGWRRWKVSEDSHFFPTRRIIMDYIETECDRGIKLGRFTNPQQPREDIRKILVGDLEKFRINNGLTLNSLSLYFRNLTKNNKEICIFENFKNWNVRSMTEEEKLKYCKRRHNTPS');
INSERT INTO proteininfo VALUES ('6325181', 'NP_015249.1','Protein involved in the synthesis of N-acetylglucosaminyl phosphatidylinositol (GlcNAc-PI), the first intermediate in the synthesis of glycosylphosphatidylinositol (GPI) anchors; homologous to the human PIG-C protein; Gpi2p [Saccharomyces cerevisiae]','MTRSPWKRLLWLKQEYPDNYTDPSFIELRARQKAESNQKSDRKLSEAARAQIRLDFISFYQTILNTSFIYITFTYIYYYGFDPIPPTIFLSFITLIISRTKVDPLLSSFMDVKSSLIITFAMLTLSPVLKSLSKTTASDSIWTLSFWLTLWYIFVISSTKSKDKPSNLSTNILVALVAVLSSRLSTTIDVFCFLLICIQLNIILPTYLSVTNKVVPIISNIIVYSFLNVALGWIYMLLIFFASVFYITVLPKWFIYWKINYHKRDNDLLSTWDARTPILD');
INSERT INTO proteininfo VALUES ('6325180', 'NP_015248.1','Hypothetical ORF; Ypl077cp [Saccharomyces cerevisiae]','MKDLQKKSSVRRQITNEDDERYGEDSIHDLPRTIPNVNPYIRNSGFRPSYSSQIPSTRSLFNNYYNRSSANTVGNDTIDTDSVSYNGVAKFRRNSVDIPLQTHNRLEVRPIIDRQDYLWREIDALDDVKRQAQATELYDQFPPGFENKLMQLRQAHSKLLQVLRDRNAKIEEEQRREVAVATAAAMMTRTPSPTGKSVGDEATSNNMHSSSAIRNPNGPTVDPEEGKYIQELVNTIRELQ');
INSERT INTO proteininfo VALUES ('6325179', 'NP_015247.1','Subunit b of the stator stalk of mitochondrial F1F0 ATP synthase, which is a large, evolutionarily conserved enzyme complex required for ATP synthesis; Atp4p [Saccharomyces cerevisiae]','MSMSMGVRGLALRSVSKTLFSQGVRCPSMVIGARYMSSTPEKQTDPKAKANSIINAIPGNNILTKTGVLGTSAAAVIYAISNELYVINDESILLLTFLGFTGLVAKYLAPAYKDFADARMKKVSDVLNASRNKHVEAVKDRIDSVSQLQNVAETTKVLFDVSKETVELESEAFELKQKVELAHEAKAVLDSWVRYEASLRQLEQRQLAKSVISRVQSELGNPKFQEKVLQQSISEIEQLLSKLK');
INSERT INTO proteininfo VALUES ('6325178', 'NP_015246.1','Protein component of the large (60S) ribosomal subunit, nearly identical to Rpl21Ap and has similarity to rat L21 ribosomal protein; Rpl21bp [Saccharomyces cerevisiae]','MGKSHGYRSRTRYMFQRDFRKHGAVHMSTYLKIYKVGDIVDIKANGSIQKGMPHKFYQGKTGVVYNVTKSSVGVIINKMVGNRYLEKRLNLRVEHIKHSKCRQEFLERVKANAAKRAEAKAQGVAVQLKRQPAQPRESRIVSTEGNVPQTLAPVPYETFI');
INSERT INTO proteininfo VALUES ('6325176', 'NP_015244.1','Protein component of the small (40S) ribosomal subunit; nearly identical to Rps9Ap and has similarity to E. coli S4 and rat S9 ribosomal proteins; Rps9ap [Saccharomyces cerevisiae]','MPRAPRTYSKTYSTPKRPYESSRLDAELKLAGEFGLKNKKEIYRISFQLSKIRRAARDLLTRDEKDPKRLFEGNALIRRLVRVGVLSEDKKKLDYVLALKVEDFLERRLQTQVYKLGLAKSVHHARVLITQRHIAVGKQIVNIPSFMVRLDSEKHIDFAPTSPFGGARPGRVARRNAARKAEASGEAADEADEADEE');
INSERT INTO proteininfo VALUES ('6325175', 'NP_015243.1','Essential abundant protein involved in regulation of transcription, removes Spt15p (TBP) from DNA via its C-terminal ATPase activity, forms a complex with TBP that binds TATA DNA with high affinity but with altered specificity; Mot1p [Saccharomyces cerevisiae]','MTSRVSRLDRQVILIETGSTQVVRNMAADQMGDLAKQHPEDILSLLSRVYPFLLVKKWETRVTAARAVGGIVAHAPSWDPNESDLVGGTNEGSPLDNAQVKLEHEMKIKLEEATQNNQLNLLQEDHHLSSLSDWKLNEILKSGKVLLASSMNDYNVLGKADDNIRKQAKTDDIKQETSMLNASDKANENKSNANKKSARMLAMARRKKKMSAKNTPKHPVDITESSVSKTLLNGKNMTNSAASLATSPTSNQLNPKLEITEQADESKLMIESTVRPLLEQHEIVAGLVWQFQGIYELLLDNLMSENWEIRHGAALGLRELVKKHAYGVSRVKGNTREENNLRNSRSLEDLASRLLTVFALDRFGDYVYDTVVAPVRESVAQTLAALLIHLDSTLSIKIFNCLEQLVLQDPLQTGLPNKIWEATHGGLLGIRYFVSIKTNFLFAHGLLENVVRIVLYGLNQSDDDVQSVAASILTPITSEFVKLNNSTIEILVTTIWSLLARLDDDISSSVGSIMDLLAKLCDHQEVLDILKNKALEHPSEWSFKSLVPKLYPFLRHSISSVRRAVLNLLIAFLSIKDDSTKNWLNGKVFRLVFQNILLEQNPELLQLSFDVYVALLEHYKVKHTEKTLDHVFSKHLQPILHLLNTPVGEKGKNYAMESQYILKPSQHYQLHPEKKRSISETTTDSDIPIPKNNEHINIDAPMIAGDITLLGLDVILNTRIMGAKAFALTLSMFQDSTLQSFFTNVLVRCLELPFSTPRMLAGIIVSQFCSSWLQKHPEGEKLPSFVSEIFSPVMNKQLLNRDEFPVFRELVPSLKALRTQCQSLLATFVDVGMLPQYKLPNVAIVVQGETEAGPHAFGVETAEKVYGEYYDKMFKSMNNSYKLLAKKPLEDSKHRVLMAINSAKESAKLRTGSILANYASSILLFDGLPLKLNPIIRSLMDSVKEERNEKLQTMAGESVVHLIQQLLENNKVNVSGKIVKNLCGFLCVDTSEVPDFSVNAEYKEKILTLIKESNSIAAQDDINLAKMSEEAQLKRKGGLITLKILFEVLGPSILQKLPQLRSILFDSLSDHENEEASKVDNEQGQKIVDSFGVLRALFPFMSDSLRSSEVFTRFPVLLTFLRSNLSVFRYSAARTFADLAKISSVEVMAYTIREILPLMNSAGSLSDRQGSTELIYHLSLSMETDVLPYVIFLIVPLLGRMSDSNEDVRNLATTTFASIIKLVPLEAGIADPKGLPEELVASRERERDFIQQMMDPSKAKPFKLPIAIKATLRKYQQDGVNWLAFLNKYHLHGILCDDMGLGKTLQTICIIASDQYLRKEDYEKTRSVESRALPSLIICPPSLTGHWENEFDQYAPFLKVVVYAGGPTVRLTLRPQLSDADIIVTSYDVARNDLAVLNKTEYNYCVLDEGHIIKNSQSKLAKAVKEITANHRLILTGTPIQNNVLELWSLFDFLMPGFLGTEKMFQERFAKPIAASRNSKTSSKEQEAGVLALEALHKQVLPFMLRRLKEDVLSDLPPKIIQDYYCELGDLQKQLYMDFTKKQKNVVEKDIENSEIADGKQHIFQALQYMRKLCNHPALVLSPNHPQLAQVQDYLKQTGLDLHDIINAPKLSALRTLLFECGIGEEDIDKKASQDQNFPIQNVISQHRALIFCQLKDMLDMVENDLFKKYMPSVTYMRLDGSIDPRDRQKVVRKFNEDPSIDCLLLTTKVGGLGLNLTGADTVIFVEHDWNPMNDLQAMDRAHRIGQKKVVNVYRIITKGTLEEKIMGLQKFKMNIASTVVNQQNSGLASMDTHQLLDLFDPDNVTSQDNEEKNNGDSQAAKGMEDIANETGLTGKAKEALGELKELWDPSQYEEEYNLDTFIKTLR');
INSERT INTO proteininfo VALUES ('6325174', 'NP_015242.1','Subunit of the tRNA splicing endonuclease, which is composed of Sen2p, Sen15p, Sen34p, and Sen54p; Sen54p [Saccharomyces cerevisiae]','MQFAGKKTDQVTTSNPGFEEEEEEEEELQQDWSQLASLVSKNAALSLPKRGEKDYEPDGTNLQDLLLYNASKAMFDTISDSIRGTTVKSEVRGYYVPHKHQAVLLKPKGSFMQTMGRADSTGELWLDFHEFVYLAERGTILPYYRLEAGSNKSSKHETEILLSMEDLYSLFSSQQEMDQYFVFAHLKRLGFILKPSNQEAAVKTSFFPLKKQRSNLQAITWRLLSLFKIQELSLFSGFFYSKWNFFFRKYTTSPQLYQGLNRLVRSVAVPKNKKELLDAQSDREFQKVKDIPLTFKVWKPHSNFKKRDPGLPDFQVFVYNKNDDLQHFPTYKELRSMFSSLDYKFEFLSEIEDDDDWETNSYVEDIPRKEYIHKRSAKSQTEKSESSMKASFQKKTAQSSTKKKRKAYPPHIQQNRRLKTGYRSFIIAIMDNGLISFVKMSEADFGSESVWYTPNTQKKVDQRWKKH');
INSERT INTO proteininfo VALUES ('6325173', 'NP_015241.1','BCK1-like resistance to osmotic shock; Bro1p [Saccharomyces cerevisiae]','MKPYLFDLKLKDTEKLDWKKGLSSYLKKSYGSSQWRTFYDEKATSELDHLRNNANGELAPSSLSEQNLKYYSFLEHLYFRLGSKGSRLKMDFTWYDAEYSSAQKGLKYTQHTLAFEKSCTLFNIAVIFTQIARENINEDYKNSIANLTKAFSCFEYLSENFLNSPSVDLQSENTRFLANICHAEAQELFVLKLLNDQISSKQYTLISKLSRATCNLFQKCHDFMKEIDDDVAIYGEPKWKTTVTCKLHFYKSLSAYYHGLHLEEENRVGEAIAFLDFSMQQLISSLPFKTWLVEFIDFDGFKETLEKKQKELIKDNDFIYHESVPAVVQVDSIKALDAIKSPTWEKILEPYMQDVANKCDSLYRGIIPLDVYEKESIYSEEKATLLRKQVEETETANLEYSSFIEFTNLPRLLSDLEKQFSDGNIFSNTDTQGQLMRDQIQTWCKFIQTNEFRDIEEQMNKIVFKRKQILEILSALPNDQKENVTKLKSSLVAASNSDEKLFACVKPHIVEINLLNDNGKIWKKFDEFNRNTPPQPSLLDIDDTKNDKILELLKQVKGHAEDLRTLKEERSRNLSELRDEINNDDITKLLIINKGKSDVELKDLFEVELEKFEPLSTRIEATIYKQSSMIDDIKAKLDEIFHLSNFKDKSSGEEKFLEDRKNFFDKLQEAVKSFSIFASDLPKGIEFYDSLFNMSRDLAERVRVAKQTEDSTANSPAPPLPPLDSKASVVGGPPLLPQKSAAFQSLSRQGLNLGDQFQNLKISAGSDLPQGPGIPPRTYEASPYAATPTMAAPPVPPKQSQEDMYDLRRRKAVENEERELQENPTSFYNRPSVFDENMYSKYSS');
INSERT INTO proteininfo VALUES ('6325172', 'NP_015240.1','Multidomain vesicle coat component that interacts with Sec23p; Sec16p [Saccharomyces cerevisiae]','MTPEAKKRKNQKKKLKQKQKKAAEKAASHSEEPLELPESTINSSFNDDSVNRTESDIASKSDVPPVSSSTNISPANETQLEIPDTQELHHKLLNDSDQHDITADSNDLPDNSIVEHDSVITQTKPAMSQEYEETAAHLSSRNPSLDVVAGELHNNNEHTQKIAVSAVEEDSFNEEEGENHDSIIISSLNDATPSQYNHFLPSDGNLLSPELSSGDTPTHNVPLGTKDNEINDDEYCNDKEISLNANNVLPDELSKEEDERLKLETHVSTEEKKQDIADQETAENLFTSSTEPSENKIRNSGDDTSMLFQDDESDQKVPWEEDVKKDFHNENTNNTQESAPNTDDRDKGYEGNEALKKSESCTAADERSYSEETSEDIFHGHDKQVVEGQNDFTGKNIENESQKLMGEGNHKLPLSAEADIIEPGKDIQDQAEDLFTQSSGDLGEVLPWESTDKNADVTSKSQEKHEDLFAASGNDEKLPWEVSDGEVSSGKTENSMQTSTEKIAEQKFSFLENDDDLLDDDDSFLASSEEEDTVPNTDNTTNLTSKPVEEKKASRYKPIIEEEAGMRQEQVHFTNTTGIVTPQQFHGLTKTGLGTPNQQVSVPNIVSPKPPVVKDNRSNFKINEEKKKSDAYDFPLEIISESSKKGHAKPVAVPTQRFGSGNSFSSLDKPIPQSRKGSNNSNRPPVIPLGTQEPRSSRTNSAISQSPVNYAFPNPYKIQQLQQAPIQSGMPLPNTNIPPPALKVETTVSAPPIRARGVSNASVGSSASFGARHATQYGLNNGVPPVSPYGQATINLPTANKYAPVSPTVQQKQYPSVVQNLGASAVNTPNFVKTHRGHTSSISSYTPNQNEHASRYAPNYQQSYQVPYTSQPVGPVAGNSSYQSQTRSSYAVPMMPQAQTSASIQPHANIQPPTGILPLAPLRPLDPLQAATNLQPRASNITAANSLPLANLPLAENILPEIITHRATSSVAPPRQENNPIKIDNEALLRRQFPIFHWSAANKVVYAVPPIPDQSQYMISSSIVQEIKVTPIDQIIKPNDMLKSFPGPLGSAKLKKKDLTKWMETTIKSISENESSTDMTIWQLLEMKLNDKVNWKNISKLLYNSDELLMYLSQPFPNGDMIPNAYRLDINCQMRVLAFLQTGNHDEALRLALSKRDYAIALLVGSLMGKDRWSEVIQKYLYEGFTAGPNDQKELAHFLLLIFQVFVGNSKMAIKSFYTNNETSQWASENWKSIVAAVLINIPENNEDPLLIPPVVLEFLIEFGIFLTKKGLTAAASTLFIIGNVPLSNEPVMADSDVIFESIGNMNTFESILWDEIYEYIFSYDPKFKGFSSILPQKIYHASLLQEQGLNSLGTKYTDYLSSSVRKLPKKDILTINLTRELSEVASRLSESNTGWLAKPKLSSVWGQLDKSFNKYIGGDDIDALNKKNDKKKVFDGFTPGSSANSSTVDLTQTFTPFQAQVTSQSYVDTTALLHNAHNVPSHSVLHSKPSNVSKGLVEANLPYTHRIGDSLQGSPQRIHNTQFAAAEPQMASLRRVRTDQHTNEKALKSQQILEKKSTAYTPQFGQNHSVPMEKSNSNVPSLFADFPAPPKLGTVPSNYVSSPDLVRRESIISTGSEFLPPPKIGVPTKANSSQGSLMYSPSVEALPIDPVVPQVHETGYNDFGNKHSQKSMPEDESHTSHDNSNADQNTLKDSADVTDETMDIEGPGFNDVKNLLPMEPNHQPTSTVNPIQTISDDIQPILQTNVEVRGTDASKMENSLPSIENERSSEEQPENISKSASSAYLPSTGGLSLENRPLTQDENSISETVQSTYLPAGSISMEAKPISQVQDVPRNVNNKASKLVEQHMAPPKPKSTDATKMNYSPYVPQSTAASADGDESTILKTSPAIYARTHQAHASNPSQYFPLVNQANETASFELSESTSQAQSNGNVASENRFSPIKKAEVVEKDTFQPTIRKASTNQYRAFKPLESDADKYNDVIEDESDDDNMSTDEAKNRKEEKKNVNMKKETKPSNKDIDDKSNGWFGWLKKDTGDKKVYKAKLGHKNTLYYDEKLKRWVNKDATEEEKQKIIESSAPPPPPIVKRKDGGPKTKPRSGPINNSLPPVHATSVIPNNPITGEPLPIKTSPSPTGPNPNNSPSPSSPISRISGVNLTSKKANGLDDLLSLAGGPKPASTRRKKKTARGYVNVMDNIQ');
INSERT INTO proteininfo VALUES ('6325171', 'NP_015239.1','Histone acetyltransferase subunit of the Elongator complex, which is a component of the RNA polymerase II holoenzyme; activity is directed specifically towards histones H3 and H4; disruption confers resistance to K. lactis zymotoxin; Elp3p [Saccharomyces cerevisiae]','MARHGKGPKTNKKKLAPEKERFIQCCADITLELTDSLTSGTTREINLNGLITKYSKKYKLKQQPRLTDIINSIPDQYKKYLLPKLKAKPVRTASGIAVVAVMCKPHRCPHIAYTGNICVYCPGGPDSDFEYSTQSYTGYEPTSMRAIRARYDPYEQARGRVEQLKQLGHSIDKVEYVLMGGTFMSLPKEYREDFIVKLHNALSGFNGNDIDEAILYSQQSLTKCVGITIETRPDYCTQTHLDDMLKYGCTRLEIGVQSLYEDVARDTNRGHTVRSVCETFAVSKDAGYKVVSHMMPDLPNVGMERDIEQFKEYFENPDFRTDGLKIYPTLVIRGTGLYELWKTGRYKSYSANALVDLVARILALVPPWTRIYRVQRDIPMPLVTSGVDNGNLRELALARMKDLGTTCRDVRTREVGIQEVHHKVQPDQVELIRRDYYANGGWETFLSYEDPKKDILIGLLRLRKASKKYTYRKEFTSQRTSIVRELHVYGSVVPLHSRDPRKFQHQGFGTLLMEEAERIAKEEHGSEKISVISGVGVRNYYGKLGYELDGPYMSKRI');
INSERT INTO proteininfo VALUES ('6325170', 'NP_015238.1','Yeast dihydro-ceramidase; alkaline dihydroceramidase with minor reverse activity.; Ydc1p [Saccharomyces cerevisiae]','MLFSWPYPEAPIEGYWGKPTSLIDWCEENYVVSPYIAEWSNTITNSIFLMTAFYSTYSAWRNKLETRYILIGMGFSLVGIGSWLFHMTLQYRYQLLDELPMLYATIIPSWSIFAETQEILIKDEKKRKESSFRIQMVISFIMCGIVTILTWIYVVVQKPAIFQVLYGILTLLVVVLSGWLTYYHVHDSFAKKNLFITMVMGMIPFVIGFICWQLDIHLCSFWIYIRRTYLALPLGVLLELHAWWHLLTGTGVYIFVVYLQYLRILTHGNPNDFLFIWRWGFFPELVRKGLPIGTSYSLEYLGPIVNTQVDDETKKNN');
INSERT INTO proteininfo VALUES ('6325169', 'NP_015237.1','Putative aryl alcohol dehydrogenase; transcription is activated by paralogous transcription factors Yrm1p and Yrr1p along with genes involved in multidrug resistance; Ypl088wp [Saccharomyces cerevisiae]','MVLVKQVRLGNSGLKISPIVIGCMSYGSKKWADWVIEDKTQIFKIMKHCYDKGLRTFDTADFYSNGLSERIIKEFLEYYSIKRETVVIMTKIYFPVDETLDLHHNFTLNEFEELDLSNQRGLSRKHIIAGVENSVKRLGTYIDLLQIHRLDHETPMKEIMKALNDVVEAGHVRYIGASSMLATEFAELQFTADKYGWFQFISSQSYYNLLYREDERELIPFAKRHNIGLLPWSPNARGMLTRPLNQSTDRIKSDPTFKSLHLDNLEEEQKEIINRVEKVSKDKKVSMAMLSIAWVLHKGCHPIVGLNTTARVDEAIAALQVTLTEEEIKYLEEPYKPQRQRC');
INSERT INTO proteininfo VALUES ('6325168', 'NP_015236.1','serum response factor-like protein that may function downstream of MPK1 (SLT2) MAP-kinase pathway; serum response factor-like protein; Rlm1p [Saccharomyces cerevisiae]','MGRRKIEIQRISDDRNRAVTFIKRKAGLFKKAHELSVLCQVDIAVIILGSNNTFYEFSSVDTNDLIYHYQNDKNLLHEVKDPSDYGDFHKSASVNINQDLLRSSMSNKPSKSNVKGMNQSENDDDENNDEDDDDHGNFERNSNMHSNKKASDKNIPSAHMKLLSPTALISKMDGSEQNKRHPENALPPLQHLKRLKPDPLQISRTPQQQQQQNISRPYHSSMYNLNQPSSSSSSPSTMDFPKLPSFQNSSFNGRPPPISISPNKFSKPFTNASSRTPKQEHKINNSGSNNNDNSNYTQSPSNSLEDSIQQTVKARRKLSARPVLRVRIPNNNFSSNSAIPSEPSSASSTSANGNSMGSSQIMKENKTSRSSKISPLSASASGPLTLQKGNNGRMVIKLPNANAPNGSNNGNGSNNNNHPYPFGSGSSPLFSATQPYIATPLQPSNIPGGPFQQNTSFLAQRQTQQYQQMSFKKQSQTVPLTTTLTGRPPSTFSGPETSNGPPTGSLPSKFVHDLMSNSPNVSSISMFPDWSMGPNSAKPGNTNNPGTFPPVQTAVNNGNSSNISSTNNTNNNNNNNNNNSSNNNSNNGNDNNSNNSNNSYYSNNEDAPVNGAAISEHTTDGDSNNQSNSSTYDAAATAYNGNTGLTPYINTAQTPLGTKFFNFSTDISGEKNSSKI');
INSERT INTO proteininfo VALUES ('6325167', 'NP_015235.1','Protein component of the small (40S) ribosomal subunit; identical to Rps6Bp and has similarity to rat S6 ribosomal protein; Rps6ap [Saccharomyces cerevisiae]','MKLNISYPVNGSQKTFEIDDEHRIRVFFDKRIGQEVDGEAVGDEFKGYVFKISGGNDKQGFPMKQGVLLPTRIKLLLTKNVSCYRPRRDGERKRKSVRGAIVGPDLAVLALVIVKKGEQELEGLTDTTVPKRLGPKRANNIRKFFGLSKEDDVRDFVIRREVTKGEKTYTKAPKIQRLVTPQRLQRKRHQRALKVRNAQAQREAAAEYAQLLAKRLSERKAEKAEIRKRRASSLKA');
INSERT INTO proteininfo VALUES ('6325166', 'NP_015234.1','Cytosolic and mitochondrial glutathione oxidoreductase, converts oxidized glutathione to reduced glutathione; Glr1p [Saccharomyces cerevisiae]','MLSATKQTFRSLQIRTMSTNTKHYDYLVIGGGSGGVASARRAASYGAKTLLVEAKALGGTCVNVGCVPKKVMWYASDLATRVSHANEYGLYQNLPLDKEHLTFNWPEFKQKRDAYVHRLNGIYQKNLEKEKVDVVFGWARFNKDGNVEVQKRDNTTEVYSANHILVATGGKAIFPENIPGFELGTDSDGFFRLEEQPKKVVVVGAGYIGIELAGVFHGLGSETHLVIRGETVLRKFDECIQNTITDHYVKEGINVHKLSKIVKVEKNVETDKLKIHMNDSKSIDDVDELIWTIGRKSHLGMGSENVGIKLNSHDQIIADEYQNTNVPNIYSLGDVVGKVELTPVAIAAGRKLSNRLFGPEKFRNDKLDYENVPSVIFSHPEAGSIGISEKEAIEKYGKENIKVYNSKFTAMYYAMLSEKSPTRYKIVCAGPNEKVVGLHIVGDSSAEILQGFGVAIKMGATKADFDNCVAIHPTSAEELVTMR');
INSERT INTO proteininfo VALUES ('6325165', 'NP_015233.1','putative sulfite pump; major facilitator superfamily protein; Ssu1p [Saccharomyces cerevisiae]','MVANWVLALTRQFDPFMFMMVMGVGISSNILYSFPYPARWLRICSYIMFAIACLIFIAVQALQILHLIVYIKEKSFREYFNDFFRNMKHNLFWGTYPMGLVTIINFLGALSKANTTKSPTNARNLMIFVYVLWWYDLAVCLVIAWGISFLIWHDYYPLEGIGNYPSYNIKMASENMKSVLLLDIIPLVVVASSCGTFTMSEIFFHAFNRNIQLITLVICALTWLHAIIFVFILIAIYFWSLYINKIPPMTQVFTLFLLLGPMGQGSFGVLLLTDNIKKYAGKYYPTDNITREQEILTIAVPWCFKILGMVSAMALLAMGYFFTVISVVSILSYYNKKEIENETGKVKRVYTFHKGFWGMTFPMGTMSLGNEELYVQYNQYVPLYAFRVLGTIYGGVCVCWSILCLLCTLHEYSKKMLHAARKSSLFSESGTEKTTVSPYNSIESVEESNSALDFTRLA');
INSERT INTO proteininfo VALUES ('6325164', 'NP_015232.1','Putative GTPase that associates with free 60S ribosomal subunits in the nucleolus and is required for 60S ribosomal subunit biogenesis; member of the ODN family of nucleolar G-proteins; Nog1p [Saccharomyces cerevisiae]','MQLSWKDIPTVAPANDLLDIVLNRTQRKTPTVIRPGFKITRIRAFYMRKVKYTGEGFVEKFEDILKGFPNINDVHPFHRDLMDTLYEKNHYKISLAAISRAKSLVEQVARDYVRLLKFGQSLFQCKQLKRAALGRMATIVKKLRDPLAYLEQVRQHIGRLPSIDPNTRTLLICGYPNVGKSSFLRCITKSDVDVQPYAFTTKSLYVGHFDYKYLRFQAIDTPGILDRPTEEMNNIEMQSIYAIAHLRSCVLYFMDLSEQCGFTIEAQVKLFHSIKPLFANKSVMVVINKTDIIRPEDLDEERAQLLESVKEVPGVEIMTSSCQLEENVMEVRNKACEKLLASRIENKLKSQSRINNVLNKIHVAQPQARDDVKRTPFIPESVKNLKKYDPEDPNRRKLARDIEAENGGAGVFNVNLKDKYLLEDDEWKNDIMPEILDGKNVYDFLDPEIAAKLQALEEEEEKLENEGFYNSDDEEEIYDGFEASEVDDIKEKAAWIRNRQKTMIAEARNRKSLKNKAIMPRSKLTKSFGKMEEHMSTLGHDMSALQDKQNRAARKNRYVERGSDVVFGDQDALTASTENGVKLRQTDRLLDGVADGSMRSKADRMAKMERRERNRHAKQGESDRHNAVSLSKHLFSGKRGVGKTDFR');
INSERT INTO proteininfo VALUES ('6325162', 'NP_015230.1','Hypothetical ORF; Ypl095cp [Saccharomyces cerevisiae]','MFRSGYYPTVTPSHWGYNGTVKHVLGEKGTKSLAFRDSKRQIPLHEFVTKHVPTLKDGANFRLNSLLFTGYLQTLYLSAGDFSKKFQVFYGREIIKFSDGGVCTADWVMPEWEQTYSLNAEKASFNEKQFSNDEKATHPKGWPRLHPRTRYLSSEELEKCHSKGYSYPLVVVLHGLAGGSHEPLIRALSEDLSKVGDGKFQVVVLNARGCSRSKVTTRRIFTALHTGDVREFLNHQKALFPQRKIYAVGTSFGAAMLTNYLGEEGDNCPLNAAVALSNPWDFVHTWDKLAHDWWSNHIFSRTLTQFLTRTVKVNMNELQVPENFEVSHKPTVEKPVFYTYTRENLEKAEKFTDILEFDNLFTAPSMGLPDGLTYYRKASSINRLPNIKIPTLIINATDDPVTGENVIPYKQARENPCVLLCETDLGGHLAYLDNESNSWLTKQAAEFLGSFDELVL');
INSERT INTO proteininfo VALUES ('6325161', 'NP_015229.1','de-N-glycosylation enzyme; peptide:N-glycanase; Png1p [Saccharomyces cerevisiae]','MGEVYEKNNIDFDSIAKMLLIKYKDFILSKFKKAAPVENIRFQNLVHTNQFAQGVLGQSQHLCTVYDNPSWHSIVLETLDLDLIYKNVDKEFAKDGHAEGENIYTDYLVKELLRYFKQDFFKWCNKPDCNHCGQNTSENMTPLGSQGPNGEESKFNCGTVEIYKCNRCGNITRFPRYNDPIKLLETRKGRCGEWCNLFTLILKSFGLDVRYVWNREDHVWCEYFSNFLNRWVHVDSCEQSFDQPYIYSINWNKKMSYCIAFGKDGVVDVSKRYILQNELPRDQIKEEDLKFLCQFITKRLRYSLNDDEIYQLACRDEQEQIELIRGKTQETKSESVSAASKSSNRGRESGSADWKAQRGEDGK');
INSERT INTO proteininfo VALUES ('6325160', 'NP_015228.1','Tyrosyl-tRNA synthetase; Msy1p [Saccharomyces cerevisiae]','MLELRSCSNLVNSSRRLVPLVTYSGLSAITLPKSRFYSQPSALEVQGTSDSRSDNILDELKQRGLVSQVSQPESFLRTKLNGNDKIKLYCGVDPTAQSLHLGNLVPLMVLLHFYVKGHDIVTVIGGATGKVGDPSGRKTERDVMENDIRQSNVASISQQLQRFFKNGLEYYRNRCALTEDVPSGKYTPRNNFNWWKDIKMLDFLADFGRHIRVQSMLARDSISSRLQTKNGLGFNEFTYQVLQAYDFYHLYKEENVTIQVGGNDQWGNITAGIDLINRIQPIKNKGLPFGITVPLLTTATGEKFGKSAGNAVFIDPSINTAYDVYQFFYNTLDADVPKFLKIFTFLNSSEIKKIVETHIKSPSLRYGQTLLAKEVTDMLYGVGSGSDSEALSNIIFGRYDGTLSAAKLVDLCKKARILQYADREIDLIKLICKLVNCSVSEARRKLSQGSVYLHHSKSKVNENISNLAPFLIDDRVLILRIGKQKCFIIEMR');
INSERT INTO proteininfo VALUES ('6325159', 'NP_015227.1','Hypothetical ORF; Ypl098cp [Saccharomyces cerevisiae]','MPPLPQNYAQQQPSNWDKFKMGLMMGTTVGVCTGILFGGFAIATQGPGPDGVVRTLGKYIAGSAGTFGLFMSIGSIIRSDSESSPMSHPNLNLQQQARLEMWKLRAKYGIRKD');
INSERT INTO proteininfo VALUES ('6325158', 'NP_015226.1','The authentic, non-tagged protein was localized to the mitochondria; Fmp14p [Saccharomyces cerevisiae]','MLKRRSNALITLSRTKLFPITTVAYYHRRLLNQQRRAVSTSPKKEIKSLEDLANLDSLDGVDTELIRDLINEHTTKLNIKKELDMLKKFSQEEESGHEIPVKRFIRPLWMFILMGSSVYLLLHFSWWKLEHEERESQLKKEVEILEHQLNELIVQDKTHNTSRGKGSNESTHMKPWYRRWFW');
INSERT INTO proteininfo VALUES ('6325157', 'NP_015225.1','Phosphatidylinositol 3,5-bisphosphate-binding protein required for maturation of pro-aminopeptidase I, predicted to fold as a seven-bladed beta-propeller; displays punctate cytoplasmic localization; Atg21p [Saccharomyces cerevisiae]','MKVLQFNQDATCCVVAASSHQISIFNCDPFGKCFEIDTKNSKKKTSNNNGSASNSESRNNEESILITNGSRDRTDAEEEEDNEDNALVTGNILKEGEFVIEMLFSTSLIAIADRGQGLNKGKKLKIVNTKRKCTICEIVFPHEIVDVVMNRKRMCVLLESDQIFIYDISCMKPLETIDLWEDHYKRSQANSFSNASNTGTLEGDSANLNRVATNLLANATQKSVNGSNPSVRTRRNSLRSKIRPRMVLSNDDRSILCFTAYSSPKKNKPNSEALYDVVIYDTLNVTPVNYLNSVHKGNVACLAVSHDGKLLATASDKGTIIRVFHTGVDSDYMSSRSLFKEFRRGTRLCNLYQLAFDKSMTMIGCVGDTDTIHLFKLDDASNSLPGDNSSNGHWNEEEYILASNSNPSMGTPKEIPLSKPRIANYFSKKIKSSIPNQNLSRNFAYITVNESNRSCLGFPDEFPNQVYIASDDGTFSIYSIPSKPGECVLTKNNKFT');
INSERT INTO proteininfo VALUES ('6325155', 'NP_015224.1','Elongator protein, part of the HAP subcomplex of Elongator, which is a six-subunit component of the RNA polymerase II holoenzyme; required for Elongator structural integrity and histone acetyltransferase activity; Elp4p [Saccharomyces cerevisiae]','MSFRKRGEILNDRGSGLRGPLLRGPPRTSSTPLRTGNRRAPGNVPLSDTTARLKKLNIADESKTKMGLDSSHVGVRPSPATSQPTTSTGSADLDSILGHMGLPLGNSVLVEEQSTTEFHSILGKLFAAQGIVHNRISDSSADKTRNGDTHVIVLSLNQMFAKELPGIYKGSRKQMKKNLISEEESKVTVQNLNETQRSTPSRYKDLKIAWKYKLADEKRLGSPDRDDIQQNSEYKDYNHQFDITTRLMPAPIASELTFIAPTQPVSTILSQIEQTIKRNDKKLIRIVIPSLLHPAMYPPKMFESSEIIGLMHGVRSLVKKYYERVVLFASISIDIITPPLLVLLRNMFDSVINLEPFNQEMTEFLERVYKSQPGKIQHGLVHILKLPVFTDRGEMRVLKSEWAFKNGRKKFEIEQWGIPVDDAEGSAASEQSHSHSHSDEISHNIPAKKTKISLDY');
INSERT INTO proteininfo VALUES ('6325154', 'NP_015222.1','The authentic, non-tagged protein was localized to the mitochondria; Fmp30p [Saccharomyces cerevisiae]','MNFVTCHVQMRLLLQRRLVRLRESELFRPQTSLSTFKRHASQKTRPIQKCSRKYARILLLSVLVPYTGYAFYVSLATVKQIDLRNEMCQRLEENNNEVTYKGSLLKYSPLEVLGRFENPFEEYRIQTVFEFFANRVFELFERNRGGIPRDVHQMNKLMPVHKPTWGPNLVDVDPAEETALPLECKVLDELHIPTAVEENEGSKCPVYNTWLGQSCNYTVYNGLRILTDPLFSDFLIHKTLGPKRITQMPSQITEVPKPDIILVSHNHPDHLDLESLEYWSGKDSPLWIVPKGMKSYMTSNGCDNVLELSWWETLQVKKNNEIYHISATPAMHWSGRSLLDTNKSLWCSFLLTHHGNPILFHAGDTGYVKDLFVRIKERFGKGCKLALLPCGQYCPEWHQKPRHINPQEVLKIMKDLEARNVLGVHWGTFVLSGEYFLEPKEKLEMLAEWGGFKDRCYCPELGKTECFD');
INSERT INTO proteininfo VALUES ('6325153', 'NP_015221.1','Aspartyl-tRNA synthetase, mitochondrial; Msd1p [Saccharomyces cerevisiae]','MLARSRVCLQTITRRLADFPEANAIKKKFLFRKDTSTIKQLKGLSSGQKIVLNGWIEQKPKRVGKNLIFGLLRDSNGDIIQLVDNKSLLKGFTLEDVVQAVGILSLKRKLSNEDADEYEVQLEDITVLNASNKKPAQMQDFKLSAIYPPEFRYLQLRNPKYQDFLKKRSSISKEIRNSFNNFDFTEVETPMLFKATPEGAREFLVPTRTKRSDGKPSFYALDQSPQQYKQLLMASGVNKYYQMARCFRDEDLRADRQPEFTQVDMEMAFANSEDVMKIIEKTVSGVWSKFSKKRGLLTLDSKGTLVPAKKENGTVSIFRMTYEQAMTSYGIDKPDLRAPDLKIINLGEFNAFSHLNKKFPVFEVIILRSAFSNMEEYKERWSFLTNNSNYNYRVPIVLPIENDEQANSNWFENFHAIATFENPHLITKFLKLKKGDIVCGCTREPNHSIFENPTPLGRLRQLVLQSEHGKNIYHAVNKDVASWIVDFPLFSPVIIEDKSGKKEKLAYPEYEKDRLCSTHHPFTMVKLKDYEKLEKTPEKCLGRHYDLVVNGVELGGGSTRIHDPRLQDYIFEDILKIDNAYELFGHLLNAFDMGTPPHAGFAIGFDRMCAMICETESIRDVIAFPKSITGADLVVKSPSVIPESILEPYNIKYSNSKK');
INSERT INTO proteininfo VALUES ('6325152', 'NP_015220.1','Hypothetical ORF; Ypl105cp [Saccharomyces cerevisiae]','MNPINSLAFDLHSVKLADANSDTAALSNSNTPTMNNAALLQRPSSIMDSIGVQRVPSPFVPGSNAISGASTVPFNAYDAEITGSPLQISANQENNSAFSAASSNLHMNASSPSVLNKPSSTFPNVAPYLYNATGPAPNVGNQPPPPGIESQWKYIDSNGNIQGPFGTNNMSQWYQGGYFTPTLQICRLATSPEPFGVNDRFIRLGELTTLVNNYQDPFVAFDFIVIRALNAVPLVAPTSSEKQKVESRDLIPVADVHSDDFTYEEILGLKFEDGSYYHETQVWVPVDGRHITKVDRIPKISAYTAPLSTTSSRSNKTTSSHEEKVPSHEEASPEEQEVFSEEGRTVSNITNEEESIVKNPTKQEEESRGSEKEQNILDQVQPEIEEVDRKDVISTADEPKSKDTPQMTSEEQKRFAKAELMAQKLLEEQQRQEEEKKRREEQRKLKKEKKLKQKQKKEEEKLKKKKKEEGKLEKEKQKELLNNILTGDTETPSSENTATSITTNLAPWANKKPEGAVYNQISSALEDLKKENSSKKEKKPNRTQLDREQALKLQKEILSSAQIPKTQTGSAWGIKPQQPIKVDIKGELMKDSTKINSQSKINKANNGDIKPDSTFIEEQKKLWEQVQKKTKKFNRASSLDDFISRTPSPSSSALNSSNTSNAWTTVSSKSTTHIASTMPVAGNQSKSYISLDTLRSSGGLSTATKTKMSDKSKQIGSSTSIPTLKARQVKPSRIPAYPGNASVSKRQEFLRWCRSQLKLNTGVQPDNVLEMLLSLPPGSESKEIIADTIYSYSSTMDGRRFATDFIKKRLECEEEINDPLSWSEVLAMPEGSSEDWEFQVVGKKKGKRF');
INSERT INTO proteininfo VALUES ('6325151', 'NP_015219.1','HSP70 family member, highly homologous to Ssa1p and Sse2p; Sse1p [Saccharomyces cerevisiae]','MSTPFGLDLGNNNSVLAVARNRGIDIVVNEVSNRSTPSVVGFGPKNRYLGETGKNKQTSNIKNTVANLKRIIGLDYHHPDFEQESKHFTSKLVELDDKKTGAEVRFAGEKHVFSATQLAAMFIDKVKDTVKQDTKANITDVCIAVPPWYTEEQRYNIADAARIAGLNPVRIVNDVTAAGVSYGIFKTDLPEGEEKPRIVAFVDIGHSSYTCSIMAFKKGQLKVLGTACDKHFGGRDFDLAITEHFADEFKTKYKIDIRENPKAYNRILTAAEKLKKVLSANTNAPFSVESVMNDVDVSSQLSREELEELVKPLLERVTEPVTKALAQAKLSAEEVDFVEIIGGTTRIPTLKQSISEAFGKPLSTTLNQDEAIAKGAAFICAIHSPTLRVRPFKFEDIHPYSVSYSWDKQVEDEDHMEVFPAGSSFPSTKLITLNRTGDFSMAASYTDITQLPPNTPEQIANWEITGVQLPEGQDSVPVKLKLRCDPSGLHTIEEAYTIEDIEVEEPIPLPEDAPEDAEQEFKKVTKTVKKDDLTIVAHTFGLDAKKLNELIEKENEMLAQDKLVAETEDRKNTLEEYIYTLRGKLEEEYAPFASDAEKTKLQGMLNKAEEWLYDEGFDSIKAKYIAKYEELASLGNIIRGRYLAKEEEKKQAIRSKQEASQMAAMAEKLAAQRKAEAEKKEEKKDTEGDVDMD');
INSERT INTO proteininfo VALUES ('6325150', 'NP_015218.1','Hypothetical ORF; Ypl107wp [Saccharomyces cerevisiae]','MIRNQGWSLLYRIYPVRRFTRYSRVDMTFEGNTQDISTSVEERMTTVFGGRLKGEPPRSTSRVLSGGTKKIAGVQVPAKPQEPDNCCMSGCVNCVWEIYSEDLRDWKHRRKEAAEKIAGTKEKWPKDWNPPLGLLHMENVPVELREKKLETDSKKAEQPHDLSAIRSLFPKRKGPLPKSVLAAKRKNIALRHNYEQKDGGDQSVSESDADEGWEDIPVYVKAFAEFESKKRLQKIRRQEEIKKRTALV');
INSERT INTO proteininfo VALUES ('6325149', 'NP_015217.1','Hypothetical ORF; Ypl108wp [Saccharomyces cerevisiae]','MKEASDREEAPKMVEKNYSTGFRKAHGEKDQSVTKPISLDGRTGEVIVRKSTGKTKIRKGQTEEEYTQQLQHYFEVEQGPVRTKVGWMDEVDPLVEIREGKYDISNKHQRQVLSGFCHRLFYQCKYKECLDLSTYFLGLFEPFNVKNKMKRELEELEYMIERCRGHVL');
INSERT INTO proteininfo VALUES ('6325147', 'NP_015215.1','Hypothetical ORF; Ypl110cp [Saccharomyces cerevisiae]','MKFGKTFANHRIPEWSSQYVGYKSLKKMIKEITRLQEDIYRAHNKNSYDEGRPPTKMRDSSNSAQNYLDSPKIQKLLASFFFAVDRDIEKVDTFYNSQYAEYKKRFERLLSSNQFNEIKSTLVVDANKEDAVAQTLLTKDTREMNMLLKGTSQASRLSYHKDDLIEIQSILAELRKQFRNLKWYAELNKRAFGKILKKLDKKVGTNQQMSTMKTRILPLQFANDSLITKDLSLLKTIWEQVTFRINSYERVMRSTSPNANANDNTEFFKIICVFIEEDDSKGLIRELTNLYSELSLIPTRIMISVLNKAALSKSLACIDAILKVIPSLNDSEDINRRNFFHHHIIAIGKLIRKQEILSRKKKSQPSKYTNSEGEIVTDLRTLHTTLSAPAESDSITEEEKSSACTLSYILEELPIHLRPCLFQHDNYKRTPLHYSCQYGLSEVTKLIIKLMKEWNIWNEIPIDDVSAFGDAESLTPLHLCVLGAHPKTTEVLLQSLDPNVKLKSSSLLHLATEWNNYPLLHVLLSSKRFDINYQDNELHETPLYLACRLNFFEAAVCLLYNGADLEIREKLFGWTAIFVAAAEGFTDIVKLLIANNANFDIEDEGGWTPMEHAVLRGHLHIADMVQIRDELVTHPHSQLNSGSEEKEPLNEISAGELNERNENGNGGNKGSLGKLAGPIKSYGHRFLDNNESLILITLGSNDTRNKSPSISLSSEALAKVIGLETDCALSLVISCNDSIDKSSVILDLPLDDNVDAVDFKVPFKVDYSHTLYFDIVPTYGTRSLETHNRIDCQKNNNNYVMARGVSMLNKSYSSVGVNRSILNGSVTVPIIANHTLEILGTLKFEYIIITPFEHPQLPLERTETYWKSLVSTRVIGHRGLGKNNPNKSLQIGENTVESFIMAASLGASYVEFDVQLTKDNVPVVYHDFLVAETGVDIPMHELTLEQFLDLNNADKEHIQRGAGHSPHHVNGADTALQKYRGRSVDDSDVSTLRRAWDLHDNDPNGKSNNAHWSDNRMRLTKTFKKNNFKGNARGHSIASSFVTLKELFKKIPANVGFNIECKFPMLDEAEEEELGQIMMEMNHWVDTVLKVVFDNANGRDIIFSSFHPDICIMLSLKQPVIPILFLTEGGSEQMADLRASSLQNGIRFAKKWNLLGIVSAAAPILKAPRLVQVVKSNGLVCVTYGVDNNDPENASIQIEAGVDAVIVDSVLAIRRGLTKKNEK');
INSERT INTO proteininfo VALUES ('6325146', 'NP_015214.1','arginase; Car1p [Saccharomyces cerevisiae]','METGPHYNYYKNRELSIVLAPFSGGQGKLGVEKGPKYMLKHGLQTSIEDLGWSTELEPSMDEAQFVGKLKMEKDSTTGGSSVMIDGVKAKRADLVGEATKLVYNSVSKVVQANRFPLTLGGDHSIAIGTVSAVLDKYPDAGLLWIDAHADINTIESTPSGNLHGCPVSFLMGLNKDVPHCPESLKWVPGNLSPKKIAYIGLRDVDAGEKKILKDLGIAAFSMYHVDKYGINAVIEMAMKAVHPETNGEGPIMCSYDVDGVDPLYIPATGTPVRGGLTLREGLFLVERLAESGNLIALDVVECNPDLAIHDIHVSNTISAGCAIARCALGETLL');
INSERT INTO proteininfo VALUES ('6325145', 'NP_015213.1','required for regulation of peroxisome size and maintenance; Pex25p [Saccharomyces cerevisiae]','MSQFGTTDIVSGSETPPYSGASYQDAQDDNTHPHSSDAGAEKFSAGSGSESHTESSRSDDEDSQAKTKMVDNITILKYILDSLSGRDKLAKIIKYALDILKLFIEKSKRNLTVLDPSVLTYYTKILKNLTVKVALRHPITVIKVLLLSLLRNFDKKIDFISQQLSTFRYILRFGGTPFRVCSFLGKFNKTRKCNFQIDQIKKIWFNEASLREFLDLYYGIFDELDLLYKLKIWTNKSFYSFVSRQESLAWQYDILLSLKDHWLNLQSLQKRQLELEVQLKVQNNALLLSPILMHQAHKDDGSQSPIRKQLLNDLNVNNDAEVLIHKQLKAIKDEKTLVYLDIARLSFDCMANTSDILNLKTPKGTYAVLSLGSGLTGLVKLWITTKRSLCSSKD');
INSERT INTO proteininfo VALUES ('6325144', 'NP_015212.1','Putative dehydrogenase; Ypl113cp [Saccharomyces cerevisiae]','MITSIDIADVTYSAKPRILVPYKTQWEVASHLPEYRKLAERVEFYKYEMSTKDDFVKFLETHRINGFWLTEEFFTVLGNPSSYIEFFPASLKVILVPWVGCDFIDGKLLRSKGITLCNIGPHAADHVTELAIFLAISCFRMTSFWEYCFKYVENGNVEQCKKYISSDSYEIVTDSYHGQEMKFPSRTDKCKPNKDRKVVHLAEKYTVGGKKMESPMNKKVLILGFGSIGQNIGSNLHKVFNMSIEYYKRTGPVQKSLLDYNAKYHSDLDDPNTWKNADLIILALPSTASTNNIINRKSLAWCKDGVRIVNVGRGTCIDEDVLLDALESGKVASCGLDVFKNEETRVKQELLRRWDVTALPHIGSTVADMVIKQTLITLENVQDIFVEGGDGKYVLN');
INSERT INTO proteininfo VALUES ('6325142', 'NP_015210.1','Rho GTPase activating protein (RhoGAP) involved in control of the cytoskeleton organization; targets the essential Rho-GTPase Cdc42p, which controls establishment and maintenance of cell polarity, including bud-site assembly; Bem3p [Saccharomyces cerevisiae]','MTDNLTTTHGGSTTLELLAQYNDHRSKKDKSIEHIEKGTCSGKERNPSYDEIFTENIKLKLQVQEYETEIESLEKVIDMLQKNREASLEVVLEQVQNDSRDSYVNDQSFVLPPRSAERKAHIKSLNLPIPTLSPPLQQGSDVALETSVTPTVPQIGVTSNTSISRKHLQNMILNDEIEANSSFSSPKIINRSVSSPTKIHSEQLASPAASVTYTTSRITIKSPNKGSKSPLQERLRSPQNPNRMTAVINNHLHSPLKASTSNNLDELTESKSQQLTNDAIQKNDRVYSSITSSAYTTGTPTSAAKSPSSLLEVKEGENKALGFSPASKEKLDDFTQLLDSSFGEEDLVNTDSKDPLSIKSTINESLPPPPAPPTFFSPTSSGNIKNSTPLSSHLASPVILNKKDDNFGAQSAKNLKKPVLTSSLPNLSTKLSTTSQNASLPPNPPVESSSKQKQLGETASIHSTNTLNTFSSTPQGSLKTLRRPHASSVSTVKSVAQSLKSDIPLFVQPEDFGTIQIEVLSTLYRDNEDDLSILIAIIDRKSGKEMFKFSKSIHKVRELDVYMKSHVPDLPLPTLPDRQLFQTLSPTKVDTRKNILNQYYTSIFSVPEFPKNVGLKIAQFISTDTVMTPPMMDDNVKDGSLLLRRPKTLTGNSTWRVRYGILRDDVLQLFDKNQLTETIKLRQSSIELIPNLPEDRFGTRNGFLITEHKKSGLSTSTKYYICTETSKERELWLSAFSDYIDPSQSLSLSSSRNANDTDSASHLSAGTHHSKFGNATISATDTPSYVTDLTQEYNNNNNISNSSNNIANSDGIDSNPSSHSNFLASSSGNAEEEKDSRRAKMRSLFPFKKLTGPASAMNHIGITISNDSDSPTSPDSIIKSPSKKLMEVSSSSNSSTGPHVSTAIFGSSLETCLRLSSHKYQNVYDLPSVVYRCLEYLYKNRGIQEEGIFRLSGSSTVIKTLQERFDKEYDVDLCRYNESIEAKDDEASPSLYIGVNTVSGLLKLYLRKLPHLLFGDEQFLSFKRVVDENHNNPVQISLGFKELIESGLVPHANLSLMYALFELLVRINENSKFNKMNLRNLCIVFSPTLNIPISMLQPFITDFACIFQGGEPVKEEEREKVDIHIPQV');
INSERT INTO proteininfo VALUES ('6325141', 'NP_015209.1','Trichostatin A-insensitive homodimeric histone deacetylase (HDAC) with specificity in vitro for histones H3, H4, H2A, and H2B; similar to Hda1p, Rpd3p, Hos1p, and Hos2p; deletion results in increased histone acetylation at rDNA repeats; Hos3p [Saccharomyces cerevisiae]','MSSKHSDPLERFYKQFQAFVQNNPNVISAARAAAQIPESAKAVVVLSPYSLQHVFPREWVTKSYRKTIVERPERLLASSMGISAAITMYPSLFTLKSSHQRKGSLMAPHVLKVHGSSWPAELIELCQMADAKLLKGEIEVPDTWNSGDIYLSSKTIKALQGTIGAIETGVDSIFKGPSAEHISNRAFVAIRPPGHHCHYGTPSGFCLLNNAHVAIEYAYDTYNVTHVVVLDFDLHHGDGTQDICWKRAGFKPEEEPEDSSYDDFGKKFAEFPKVGYFSMHDINSFPTESGFATKENIKNASTCIMNSHDLNIWNIHLSKWTTEEEFNVLYRTKYRTLFAKADEFFRSAKLEMNQQGRPFKGLVVISAGFDASEFEQTSMQRHSVNVPTSFYTTFTKDALKLAQMHCHGKVLSLMEGGYSDKAICSGVFAHLIGLQNQDWVKEWGSEQVVKEIVRGCKPAWKPYKTKRAKDVIRIWAEEVIRLGRAMIPEFDDIIFKDAVNSAPSNSLLKATVEPASTSTIAQRIIRSHRSNASPEKELHENKPRSTEKQEQREIRSDTKVKQLSSNNRAAETQIPFLQQEFSSEDEDEEYVYDEELNKTFNRTVEDITIDDISRHLETLEIEKKGDEDSDHELKEKNWKNSHQRRLQGNGMYKIPSNTKPHRIRQPQNANTPTYDDSDISMISHVSRKHTTRSGGRW');
INSERT INTO proteininfo VALUES ('6325140', 'NP_015208.1','Isopentenyl diphosphate:dimethylallyl diphosphate isomerase (IPP isomerase), catalyzes an essential activation step in the isoprenoid biosynthetic pathway; required for viability; Idi1p [Saccharomyces cerevisiae]','MTADNNSMPHGAVSSYAKLVQNQTPEDILEEFPEIIPLQQRPNTRSSETSNDESGETCFSGHDEEQIKLMNENCIVLDWDDNAIGAGTKKVCHLMENIEKGLLHRAFSVFIFNEQGELLLQQRATEKITFPDLWTNTCCSHPLCIDDELGLKGKLDDKIKGAITAAVRKLDHELGIPEDETKTRGKFHFLNRIHYMAPSNEPWGEHEIDYILFYKINAKENLTVNPNVNEVRDFKWVSPNDLKTMFADPSYKFTPWFKIICENYLFNWWEQLDDLSEVENDRQIHRML');
INSERT INTO proteininfo VALUES ('6325139', 'NP_015207.1','Mitochondrial ribosomal protein of the large subunit; MRP51 exhibits genetic interactions with mutations in the COX2 and COX3 mRNA 5'-untranslated leader sequences; Mrp51p [Saccharomyces cerevisiae]','MTLAELLGRSRIAQVANNHKPLTYTGKKFHPTHQIIETKPSTLYRQEWGLKSAIPSKIKSRYLVYNDLDTLERITTFEPRGGTQWNRLRFQEMGVPIVSNIGRQNPFFKYISRPEDESHAKLSLFKEMKGDTDISPAAMKKRLKKITALIRSFQDEFKEWLVENHPDELKLNSNKLEDYVVKFLNKKLETKTNKKFNTEIIGTGGLSYSLPGKLKNSPNGVIQRTVVPGRILNVVKENNDNKWLAAIGGFVADVVFFQSPPSSFNSMGDFIRMKTFLFEILEASMEKNGSVSMHARLLEPQNDKTREFFNKRPIYKPLTSRRARRPSVGNIQEANNLLNIIKGN');
INSERT INTO proteininfo VALUES ('6325138', 'NP_015206.1','putative ATP-dependent RNA helicase; Dead box protein; Dbp1p [Saccharomyces cerevisiae]','MADLPQKVSNLSINNKENGGGGGKSSYVPPHLRSRGKPSFERSTPKQEDKVTGGDFFRRAGRQTGNNGGFFGFSKERNGGTSANYNRGGSSNYKSSGNRWVNGKHIPGPKNAKLEAELFGVHDDPDYHSSGIKFDNYDNIPVDASGKDVPEPILDFSSPPLDELLMENIKLASFTKPTPVQKYSIPIVTKGRDLMACAQTGSGKTGGFLFPLFTELFRSGPSPVPEKAQSFYSRKGYPSALVLAPTRELATQIFEEARKFTYRSWVRPCVVYGGAPIGNQMREVDRGCDLLVATPGRLNDLLERGKVSLANIKYLVLDEADRMLDMGFEPQIRHIVEECDMPSVENRQTLMFSATFPVDIQHLARDFLDNYIFLSVGRVGSTSENITQRILYVDDMDKKSALLDLLSAEHKGLTLIFVETKRMADQLTDFLIMQNFKATAIHGDRTQAERERALSAFKANVADILVATAVAARGLDIPNVTHVINYDLPSDIDDYVHRIGRTGRAGNTGVATSFFNSNNQNIVKGLMEILNEANQEVPTFLSDLSRQNSRGGRTRGGGGFFNSRNNGSRDYRKHGGNGSFGSTRPRNTGTSNWGSIGGGFRNDNEKNGYGNSNASWW');
INSERT INTO proteininfo VALUES ('6325137', 'NP_015205.1','Protein required for sorting and delivery of soluble hydrolases to the vacuole; Vps30p [Saccharomyces cerevisiae]','MKCQTCHLPLQLDPSLEGLSLTQRNLLLSNNSIITATNENVISNKGIEAADNCGPQIPKERLRRLGEIQNIKDLNLKDDKLITDSFVFLNHDDDDNANITSNSREDQRYGNANGNDNKKANSDTSDGTSTFRDHDEEEQEATDEDENQQIQLNSKTLSTQVNAMTNVFNILSSQTNIDFPICQDCCNILINRLKSEYDDAIKERDTYAQFLSKLESQNKEISESNKEKQYSHNLSEKENLKKEEERLLDQLLRLEMTDDDLDGELVRLQEKKVQLENEKLQKLSDQNLMDLNNIQFNKNLQSLKLQYELSLNQLDKLRKINIFNATFKISHSGPFATINGLRLGSIPESVVPWKEINAALGQLILLLATINKNLKINLVDYELQPMGSFSKIKKRMVNSVEYNNSTTNAPGDWLILPVYYDENFNLGRIFRKETKFDKSLETTLEIISEITRQLSTIASSYSSQTLTTSQDESSMNNANDVENSTSILELPYIMNKDKINGLSVKLHGSSPNLEWTTAMKFLLTNVKWLLAFSSNLLSKSITLSPTVNYNDKTISGN');
INSERT INTO proteininfo VALUES ('6325136', 'NP_015204.1','Meiotic protein required for synapsis and meiotic recombination; involved in meiosis, synapsis and recombination; Mei5p [Saccharomyces cerevisiae]','MHNQEEWLDKDKTLVNEEENTCINHSYTKKDTNNYRVGKSGIKDLKKPTNQKEIAIKNRELTKQLTLLRQENNHLQQACKILSENKIIENRKSIEKWRTICEMELSFILNSTLIKINRMGGYKDFLEKEMEAKKRRLEYQIDNGMEDQICEIKESDDFRQLSEVEKQEWESQMNEQLKELEKKKIAELEKLNKVLHDSEGKDFGMAELCTRLKLDYSLIFPQ');
INSERT INTO proteininfo VALUES ('6325135', 'NP_015203.1','Subunit of TFIIH and nucleotide excision repair factor 3 complexes, involved in transcription initiation, required for nucleotide excision repair, similar to 52 kDa subunit of human TFIIH; Tfb2p [Saccharomyces cerevisiae]','MSDYSLKHSVTQYLEEIPQQVQNRLYTSPATCLAIYRILPPLAKFFIMAMVFNENEVPLLDLDKWVNSNGKLQFQNAIKSMKSLHLLIPNKSSGTLMINLNPTFKISLRNALTGGEVQNSFGVVVEENVVSLDLLDEYSANKWETILHFMVGTPLAKIPSEKVLNLLKHSKLMEEVNSTGEFKITNEGFQFLLQEINSQLWTLLLQYLKMIETSKMDLVDVLHFIFMLGALEVGKAYKIDALSETQRIMLQDMRDYGLVFQKHSNDSIFYPTKLALMLTSDTKTIRSASNAMDSVLRQNREEPSVNEDGANGKSTTDITTSDDLNKAGLKNQDIPDGSLIVETNFKIYSYSNSPLQIAVLSLFVHLKARFVNMVLGQITRESIRRALTNGITADQIIAYLETHAHPQMRRLAEEKLEKKLELDPNCKEPLQVLPPTVVDQIRLWQLELDRVITYEGSLYSDFETSQEYNLLSKYAQDIGVLLWKDDKKKKFFISKEGNSQVLDFAKRKLKKKQ');
INSERT INTO proteininfo VALUES ('6325134', 'NP_015202.1','RNAse; member of the T(2) family of endoribonucleases; Rny1p [Saccharomyces cerevisiae]','MLLKNLHSLLQLPIFSNGADKGIEPNCPINIPLSCSNKTDIDNSCCFEYPGGIFLQTQFWNYFPSKNDLNETELVKELGPLDSFTIHGLWPDNCHGGYQQFCNRSLQIDDVYYLLHDKKFNNNDTSLQISGEKLLEYLDLYWKSNNGNHESLWIHEFNKHGTCISTIRPECYTEWGANSVDRKRAVYDYFRITYNLFKKLDTFSTLEKNNIVPSVDNSYSLEQIEAALSKEFEGKKVFIGCDRHNSLNEVWYYNHLKGSLLSEMFVPMDSLAIRTNCKKDGIKFFPKGYVPTFRRRPNKGARYRGVVRLSNINNGDQMQGFLIKNGHWMSQGTPANYELIKSPYGNYYLRTNQGFCDIISSSSNELVCKFRNIKDAGQFDFDPTKGGDGYIGYSGNYNWGGDTYPRRRNQSPIFSVDDEQNSKKYKFKLKFIKN');
INSERT INTO proteininfo VALUES ('6325133', 'NP_015201.1','Component of spindle pole body; Spc29p [Saccharomyces cerevisiae]','MDYSNFGNSASKKFQDDTLNRVRKEHEEALKKLREENFSSNTSELGNKKHYRAQERMSSPLHRLSPTGKSDDRKVKSPLDDKLRRQLREGNTRLPPPPFSSYGMPPTNRSNLDRIRRRTSSPVRTDKFASQNVIDDQRLEIKYLERIVYDQGTVIDNLTSRITRLESFILNSISDRGDKNFASLEHSRSFSGFPTNKTYGLQMGGLYENDMPYRRSSDNINKEGAREDRSSQIHIENESTEDILKILSSSFHN');
INSERT INTO proteininfo VALUES ('6325132', 'NP_015200.1','Karyopherin with a role in the assembly or export of 60S ribosomal subunits; Kap120p [Saccharomyces cerevisiae]','MASSLNELNLVQVLEQASNPQHIRSDVQKLAEQQLRQWETQAGFHYLLQSIYLNLSNSLQIRWLAVIQFKNGVDKYWRSTRINAIPKDEKASIRGRLFEMIDEQNNQLCIQNAQASARIARLDFPVEWPTLFEDLENLLNDEIIRKDSVKIYNILMHINQIVKVLGTARIGRCRPAMQSKVPLILPLIVRIYLQSFEEWTTSSNLNYEDLSSLQVSYLALKVLRRIICEGYDRPQTDQSVCDFIKLSVSHFEMLISNHENFKKFDIYEKFIKCLGKLYFNLVTGSPANFILLPCSTQILITYTRLIFDKAPKVYRENSDVTGDFWEQTAIRGLLILKRVINFIHKKGAITLKARSDKLTIDASINKINTEFLNENLITRLVDTLMEWYLRLRPTELENWFMDPEEWINEQMATSYEYQIRPCAENVFQDLMNTFSELLVPYLLKKIENDASKLSNSLDDFLRKDAIYASFQLSASAVSEMVDFDRLLIQVFLPEATNTNISGDELRIIRRRVALIINEWSTVKCSEESKSLCYKLFTNFLTDEDDKVVLLTTVQTVRTMVDDWNFNKDTFQPFLTENVHLLLRKILPSVSLTETRLYVLNTLSDIIIQTKPLISRDLLVEILQIIPNLWEIATNNASEAILANALLRLLRNLVSSLGSQSHLTWDIAIPVVALACDPSSMQYQLLSEDGYELWGMLLQNFSSHDQEFDDKFVELVPFLKYGIETHTEILPTLLEIIKSYALILNPVDFFSNNTFQDIFKQMSKYLLKLREDSFQLVLEIWEILILSNESDYENLLLQKFYETGVLSALFDAIFLEEAPSSYLCSQIIQIIARISYVNPDALMTFLATYHDNLPTSNENARMPESIRKIVSKDQTYDSVVNKLLTGWIVCFRDIFDPKFKKVHILGISSLLRTGLVPILTEFSSIASLWIEMLEEINETNRGDCEKYHLNDIVTEQSIAFHPLTAEQLRYHQLCKNNDPVHNISLKDFISQSMEYLESHLGVERYQEFLKTINPSLLENLQMFLSIQPQEARP');
INSERT INTO proteininfo VALUES ('6325131', 'NP_015199.1','part of small (ribosomal) subunit (SSU) processosome (contains U3 snoRNA); Net1-Associated Nucleolar protein 1; Net1-Associated Nucleolar protein 1; Nan1p [Saccharomyces cerevisiae]','MTQSLGIEQYKLSVVSGGKPALNNLSSVTGNKNIARLSQDQRNYIIPFNNQIKVYSVETRQCVKTLKFANNSLLSGIFLQEEENNESIVKILLGDITVPQQEDAHLITVFTNNGHVIVLNYKGKLVESPKHFKISLADEKLANVFHSEGNYRILTTFKDPSQKAHNSLQSYRLYALTFDDAKKQFEVAHQAEWHNVILSNISSNGKLLAHMCKDVSTKDHEHKSISVVSLFDDSVNLSFPLGSILSSQTQSLSYNTRYVSSMAIDNMGQQLAVGFASGVISIVSLADLQIRLLKWHIDSVLSLSFSHDGSYLLSGGWEKVMSLWQLETNSQQFLPRLNGIIIDCQVLGPQGNYYSLILQMTENNSNSDYQFLLLNASDLTSKLSINGPLPVFNSTIKHIQQPISAMNTKNSNSITSLNHSKKKQSRKLIKSRRQDFTTNVEINPINKNLYFPHISAVQIFDFYKNEQVNYQYLTSGVNNSMGKVRFELNLQDPIITDLKFTKDGQWMITYEIEYPPNDLLSSKDLTHILKFWTKNDNETNWNLKTKVINPHGISVPITKILPSPRSVNNSQGCLTADNNGGLKFWSFDSHESNWCLKKISLPNFNHFSNSVSLAWSQDGSLIFHGFDDKLQILDFDTFKKFESLENTKTVSEFTLDSEIQTVKLINDTNLIVATRTTLNAINLLRGQVINSFDLYPFVNGVYKNGHMDRLITCDERTGNIALVINQQLTDLDGVPTINYKSRIIIFDSDLSTKLGNFTHHEYISWIGWNYDTDFIFLDIESTLGVVGTTVNTQLSDEVNNEGILDGLVSNTITTSASNSDIFAEQLHKLSSRGKKSDTRDKNTNDNDEDEEDIALEFINGEKKDKLVNMNSFTSMFDNIQNVQMDTFFDRVMKVLT');
INSERT INTO proteininfo VALUES ('6325130', 'NP_015198.1','Histone H1, a linker histone required for nucleosome packaging at restricted sites; suppresses DNA repair involving homologous recombination; not required for telomeric silencing, basal transcriptional repression, or efficient sporulation; Hho1p [Saccharomyces cerevisiae]','MAPKKSTTKTTSKGKKPATSKGKEKSTSKAAIKKTTAKKEEASSKSYRELIIEGLTALKERKGSSRPALKKFIKENYPIVGSASNFDLYFNNAIKKGVEAGDFEQPKGPAGAVKLAKKKSPEVKKEKEVSPKPKQAATSVSATASKAKAASTKLAPKKVVKKKSPTVTAKKASSPSSLTYKEMILKSMPQLNDGKGSSRIVLKKYVKDTFSSKLKTSSNFDYLFNSAIKKCVENGELVQPKGPSGIIKLNKKKVKLST');
INSERT INTO proteininfo VALUES ('6325129', 'NP_015197.1','TTAGGG repeat binding factor; Tbf1p [Saccharomyces cerevisiae]','MDSQVPNNNESLNRFNDIIQSLPARTRLTICSLCLLDNISTQLLRFLILNANSPNIIAVLTDQTAFLSSGETEIFQTLVKLFKQIRMIYHTRSPLLSVHDVAPGLWFPNSPPPLILRGHEAFIITAIRKANLLTFLLTSLNCLNYGFELLQSIFLDIFCPNTNTVGNNSLEQSGKFLKSQAILYLDLKTQAYIAGLKEFQDETNEISLEKKQELLDLIFPSNLADILVQRRTGDSGDITLLTPSEKDFVERCDRRRENLKIVQDFNSLTQSYEWAQFIRELLDYCNKNMGLIIWGRKGRGKSPLYDFDVNEFDPQVLFSTGTRTVEFMDDQNQPSSASAFLSTARPNHYSTHTPTTDVSSKNPAITQSIVDAAVAASMSNSSSGPHSSHNNSSNSNNNGSIGLRKPKAKRTWSKEEEEALVEGLKEVGPSWSKILDLYGPGGKITENLKNRTQVQLKDKARNWKLQYLKSGKPLPDYLIKVTGNLEKIYKAKKKFSQSPNSSTIMEQNLSQHPSSAASATEDTQTHQEDSHGQNSDNMPSNGLFGNSTSDNTGFDPHLEDGM');
INSERT INTO proteininfo VALUES ('6325128', 'NP_015196.1','Subunit (30 kDa) of TFIID, TFIIF, and SWI/SNF complexes, involved in RNA polymerase II transcription initiation and in chromatin modification; Taf14p [Saccharomyces cerevisiae]','MVATVKRTIRIKTQQHILPEVPPVENFPVRQWSIEIVLLDDEGKEIPATIFDKVIYHLHPTFANPNRTFTDPPFRIEEQGWGGFPLDISVFLLEKAGERKIPHDLNFLQESYEVEHVIQIPLNKPLLTEELAKSGSTEETTANTGTIGKRRTTTNTTAEPKAKRAKTGSASTVKGSVDLEKLAFGLTKLNEDDLVGVVQMVTDNKTPEMNVTNNVEEGEFIIDLYSLPEGLLKSLWDYVKKNTE');
INSERT INTO proteininfo VALUES ('6325127', 'NP_015195.1','Meiosis-specific protein of unknown function, involved in completion of nuclear divisions; identified as a weak high-copy suppressor of the spo1-1 ts mutation; putative GPI-dependent cell-wall protein; Spo19p [Saccharomyces cerevisiae]','MKKQILIVAAQSILCSTVFGERSNVGLSTEELGGDSILYFNEDPIVIEIDKKAIDKKTLEQLASTRDVVLTDLPDTLEFIDFNEYAKMKSKSDMLLEYINEYEFDDFERSSEGGLEEEEEEDLIYDFNAQAEDLGKLGSNIYEVVEEKNIVNTYDGNLINASTTESTTTIRPFVTSHSYVASSTPYSNISSLNEDYDNASNFLTPTTVALAVLLTILLFIQAY');
INSERT INTO proteininfo VALUES ('6325126', 'NP_015194.1','Protein component of the large (60S) ribosomal subunit with similarity to E. coli L18 and rat L5 ribosomal proteins; binds 5S rRNA and is required for 60S subunit assembly; Rpl5p [Saccharomyces cerevisiae]','MAFQKDAKSSAYSSRFQTPFRRRREGKTDYYQRKRLVTQHKAKYNTPKYRLVVRFTNKDIICQIISSTITGDVVLAAAYSHELPRYGITHGLTNWAAAYATGLLIARRTLQKLGLDETYKGVEEVEGEYELTEAVEDGPRPFKVFLDIGLQRTTTGARVFGALKGASDGGLYVPHSENRFPGWDFETEEIDPELLRSYIFGGHVSQYMEELADDDEERFSELFKGYLADDIDADSLEDIYTSAHEAIRADPAFKPTEKKFTKEQYAAESKKYRQTKLSKEERAARVAAKIAALAGQQ');
INSERT INTO proteininfo VALUES ('6325125', 'NP_015193.1','Mitochondrial membrane protein required for assembly of active cytochrome c oxidase, probably involved in insertion of Cu(B) and magnesium; Cox11p [Saccharomyces cerevisiae]','MIRICPIVRSKVPLLGTFLRSDSWLAPHALALRRAICKNVALRSYSVNSEQPKHTFDISKLTRNEIQQLRELKRARERKFKDRTVAFYFSSVAVLFLGLAYAAVPLYRAICARTGFGGIPITDRRKFTDDKLIPVDTEKRIRISFTSEVSQILPWKFVPQQREVYVLPGETALAFYKAKNYSDKDIIGMATYSIAPGEAAQYFNKIQCFCFEEQKLAAGEEIDMPVFFFIDPDFASDPAMRNIDDIILHYTFFRAHYGDGTAVSDSKKEPEMNADEKAASLANAAILSPEVIDTRKDNSN');
INSERT INTO proteininfo VALUES ('6325124', 'NP_015192.1','Regulator of drug sensitivity; Transcriptional regulator; Rds2p [Saccharomyces cerevisiae]','MSANSGVKRASKAFKTCLFCKRSHVVCDKQRPCSRCVKRDIAHLCREDDIAVPNEMPSQHESSPNDNNIQGKYANKAHTGIPSDYQNEPVNKSGSTYGEELSPKLDSSLVNDTTSLLLPQQPVFVSENVGSEFSSLNEFLSMLENPLLTQTSLSSSSASNVHLENGSQTTQSPLEYQNDNRRDEIGVARQENRSPTIMSGSSNSISKGDKQDQEKEESRILANANENSAPTPKEQFFLTAADPSTEMTPEHRLKLVINAKLEAGLLKPYNYAKGYARLQDYMDKYMNQSSKQRILKPLSTIRPAFRTIARSLKDVDLVLVEESFERMLLSYDRVFTSMSMPACLCRRTGEIYRANKEFASLVDCTVDDLRDGKLAIYELMTEESAVNFWEKYGSIAFDKGQKAVLTSCSLRTKDGIRKRPCCFSFTIRRDRYNIPICIVGNFIPLS');
INSERT INTO proteininfo VALUES ('6325123', 'NP_015191.1','Mitochondrial inner membrane transporter, exports 2-oxoadipate and 2-oxoglutarate from the mitochondrial matrix to the cytosol for use in lysine and glutamate biosynthesis and in lysine catabolism; Odc1p [Saccharomyces cerevisiae]','MTSIDNRPLPFIYQFTAGAIAGVSELLVMYPLDVVKTRMQLQVTTKGHPAVVAAKAAVDHYTGVMDCLTKIVKKEGFSHLYKGITSPILMEAPKRAIKFSGNDTFQTFYKKIFPTPNGEMTQKIAIYSGASAGAVEAFVVAPFELVKIRLQDVNSQFKTPIEVVKNSVVKGGVLSLFNGLEATIWRHVLWNAGYFGIIFQIRKLLPAAKTSTEKTRNDLIAGAIGGTVGCLLNTPFDVVKSRIQRSSGPLRKYNWSLPSVLLVYREEGFKALYKGFAPKVMRLAPGGGLLLVVFTNVMDFFREVKYGKKQ');
INSERT INTO proteininfo VALUES ('6325122', 'NP_015190.1','Conserved protein of the mitochondrial matrix, performs a scaffolding function during assembly of iron-sulfur clusters, interacts physically and functionally with yeast frataxin (Yfh1p); isu1 isu2 double mutant is inviable; Isu1p [Saccharomyces cerevisiae]','MLPVITRFARPALMAIRPVNAMGVLRASSITKRLYHPKVIEHYTHPRNVGSLDKKLPNVGTGLVGAPACGDVMRLQIKVNDSTGVIEDVKFKTFGCGSAIASSSYMTELVQGMTLDDAAKIKNTEIAKELSLPPVKLHCSMLAEDAIKAAIKDYKSKRNTPTMLS');
INSERT INTO proteininfo VALUES ('6325121', 'NP_015188.1','Hypothetical ORF; Ypl137cp [Saccharomyces cerevisiae]','MITNTEFDVPVDWLYKGKSRRKTNTKPSRPSTSPASSSSTSSSKNGDNSTSGNRSSNDKPRARSSSVSNAALCNTEKPDLKRNDGNTSASDTDNIPLLTPINSGNRSDSADIDNPATVDAIDLIDNDDNGSSTQFVRKKRSTSISNAVVSSKPRLASSAINATASSSVGKGKHPPISSPSNATLKRSNSTSGEKTKRSIFGSLFSKRSTSSSASTAKKPLPVVNTSTTENESGGIKAVATPDPRVKEISSPMRGVAPTASKPQTPILPSPALAVKDLSTVSLKRVSFAVDKFESDPPQQLPSRTPKKGNILIPDDMISEVPSISVGISSSNQSAKSTNSNIKGPLYTKKSKEYILALENQKLALREAAKHQQEAHFAANRIAFEVANFKTASDAGGKLTEKSSEGTITKQREEVSPPNVEADRELENNKLAENLSKAGIDKPIHMHEHYFKEPDQDKYQDGHSIENNEVTLDVIYTRCCHLREILPIPSTLRQVKDKTAPLQILKFLNPKPTLIDILSFCDFITIAPIHTIVFDNVALNQDMFRIIISALVNSTVLDKLSLRNVRIDQDGWKLLCKFLLLNKSLNKLDISQTKIKSDLAESLYRHNMDWNLFTDVLSQRSHKPIEELLFNGIQFSKIPYSCFARLLTSFATQKNFPESGIRLGLAGATTSNISQDCLKFIFNWMSQYNVQGVDLAFNDLSTMIKPMVGKLSALSYDNLRYFILNSTNISTSYDLALLLKYLSKLPNLIFLDLSNLSQCFPDILPYMYKYLPRFPNLKRIHLDSNNLTLKELAVVCNILIKCKSLSHVSMTNQNVENFYLMNGTDSPVQQTNTDGDLDSSSTLDVKGQFAKNSFSSTLYAFARDSPNLIGLDFDYDLISEEIQSRIALCLMRNMKRTMDSTFQLDELDSQDDLLFDGSLVTMTAESVLEKLNLLSDKSTKVKKDTTKRYLLKKYIEKFHILHHNVQHTIDTMFEKRKSGELPLQEKENLVRLLLLEQNLCNILELFSHNPNLNDVLGSSRDDSKESVDSSEDSKLPALKHVESGYHVPEEKIQPENDVITARPHLMATDSGKTIDVFTGKPLVFKHTSSSTSVGCKKQEEEEGELHKWGFFVQQQRSLYPENESTRQTPFASGDTPINTETAGKSTSSPSVSTSNNETATTSLFSPANPKILPKIPSGAVLRSAIMKAKGIDSIDDLIQNVNSNNIELENIYGESIQNSASTFTPGVDSDVSAPNTDKGSVETLPAVSTDDPNCEVKVTATYDKLLNNLSMERSIRL');
INSERT INTO proteininfo VALUES ('6325119', 'NP_015187.1','Subunit of the COMPASS complex, which methylates histone H3 on lysine 4 and is required in transcriptional silencing near telomeres; similar to S. pombe SPCC594.05c and to human CGBP; contains PHD finger domain; Spp1p [Saccharomyces cerevisiae]','MSLPQWCPPHSTLKRNPTTGEDVYCICKRPDYGELMVGCDGCDDWFHFTCLHIPEQFKDLVFSFYCPYCQAGITGKNKDAIINGEGSLPKTLWKRKCRISDCYKPCLQDSKYCSEEHGREFVNDIWSRLKTDEDRAVVKKMVEQTGHIDKFKKFGQLDFIDNNIVVKTDDEKEIFDQIVVRDMTLKTLEDDLQEVQEISLPLFKKKLELLEVYLGWLDNVYTEMRKLDDDAASHVECGKEDSKGTKRKKKKNSSRSRARKNICGYCSTYERIPCSVEEFVRDFGSNEEATKIHEVCTKWKCNRHLDWVSTNQEQYLQQIDSLESMQERLQHLIQARKKQLNIQYYEEILRRGL');
INSERT INTO proteininfo VALUES ('6325118', 'NP_015186.1','Transcriptional modulator that acts as a negative regulator of meiosis; Ume1p [Saccharomyces cerevisiae]','MSTLDIAEDNKIKNEEFKIWKKSIPSLYQHISSLKPIFGSGVDESPSTLRSIVFTNDSSCNKSKGVLSVPLLYSQGSEIFEVDCIVPLGLHYKKPESISEPLVQPDYTMESQKVEQTVLIPKWEFKGETIAKMIYVDNSEINVKVIALSTNGSLAWFREGVKSPVYTMMEPSTSLSSASSGNQNKPCVDFAISNDSKTLTVTKEKHLDNENATIKLIDNSGKIGEVLRTIPVPGIKNIQEIKFLNNQIFATCSDDGIIRFWGNEIGKKPLWILNDSLDGKTTCFAASPFVDTLFMTGTSGGALKVWDIRAVIALGDADAELNINQGHNKVNELFKVHHFYSEQVSKIEFSSISPMEVVTIGGLGNVYHWNFEPVFAIYNEIHEDFQGIISDELEAESMAFYHTEGCRREIGENNKVNTVAYHKYIEDLVATVDSDGLLTVYKPFTGKVLDGSREVGAAKS');
INSERT INTO proteininfo VALUES ('6325117', 'NP_015185.1','Member of MAP kinase pathway involving PKC1, BCK1, and SLT2. Shows functional redundancy with MKK1; protein kinase; Mkk2p [Saccharomyces cerevisiae]','MASMFRPPESNRSHQKTPKLTLPVNLVQNAKSTNDGQHLNRSPYSSVNESPYSNNSTSATSTTSSMASNSTLLYNRSSTTTIKNRPVPPPLPPLVLTQKKDGIEYRVAGDSQLSERFSNLHVDITYKELLSSAPISTKLSNIDTTFIKKDLDTPEGEDSYPSTLLSAYDFSSSGSNSAPLSANNIISCSNLIQGKDVDQLEEEAWRFGHLKDEITTLGILGEGAGGSVAKCRLKNGKKVFALKTINTMNTDPEYQKQIFRELQFNKSFKSDYIVQYYGMFTDEQSSSIYIAMEYMGGKSLEATYKNLLKRGGRISERVIGKIAESVLRGLSYLHERKVIHRDIKPQNILLNEKGEIKLCDFGVSGEAVNSLAMTFTGTSFYMAPERIQGQPYSVTCDVWSLGLTLLEVAGGRFPFESDKITQNVAPIELLTMILTFSPQLKDEPELDISWSKTFRSFIDYCLKKDARERPSPRQMLKHPWIVGQMKKKVNMERFVKKCWEKEKDGI');
INSERT INTO proteininfo VALUES ('6325116', 'NP_015184.1','Hypothetical ORF; Ypl141cp [Saccharomyces cerevisiae]','MSYTNKRHTYYGGFTNDLSDTFQYPQRTDEQRRKHVTFGPYILGSTLGEGEFGKVKLGWPKNFSNSSNSTFDFPKQVAIKLIKRDSISNDYRKEVKIYREINALKHLSHPNIVKLEEVLQNSRYIGIVLEYACGGEFYKYIQKKRRLKEMNACRLFSQLISGVHYIHSKGLVHRDLKLENLLLDKNENLVITDFGFVNEFCSRNELMKTSCGSPCYAAPELVISAEPYEARKADIWSCGVILYAILAGYLPWDDDPNNPEGSDIGRLYNYINSTPLKFPDYILPIPRDLLRRMLVSDPKKRINLKQIKKHEWLKPHSSFLSITPDEWDKLNNTQSVFRLAKPRRRYGSRPQSSCSTSSLGSRSDKRDSLVIDSTLITFPAPPQESQNHIITRPASIASDQRLSPIRRSNRHNRSNSAASVALQAVVNADREYVLSHEQSLSPVQNIRQTTGNMTASLSPPPAISPGDIIIETTPIKRNTISGSSIVPSLEEESSTTMQTSKIQPNNMASSQNHQYNKNKTQNSLQSAKNFYRTSSSSHTKPRPTSYHPGSYTTPPYNSNTLSIYEINEKAKSSASSQTLNQRDTSPFDSTPYLALDTCITSSSSIESSPKLITHGQFSVAKPSVDLQSVSGDLIKYKRDADVVTRIYDEKYKQKRKSLRYSGIFSDISCDTVTEESDELRPPESPLQQHEGQESIDKAKTEDTSEKGSKSSNIAKATAQKHVNNHLERSLNEAESTKKRFSFLSLYSYDTSKSSLYSSMDSKRKPSPPSQRRPKKDDSYQTNSKNHYITASNMQTSHQVSKDLPAPTMVQNKCTLETKKAVRSNRSSIMVSEVNKASVDNKAAQSPEHSTAKRVLGFFKRRSMKI');
INSERT INTO proteininfo VALUES ('6325114', 'NP_015182.1','N-terminally acetylated ribosomal protein L37 of the large (60S) ribosomal subunit, nearly identical to Rpl33Bp and has similarity to rat L35a; rpl33a null mutant exhibits slow growth while rpl33a rpl33b double null mutant is inviable; Rpl33ap [Saccharomyces cerevisiae]','MAESHRLYVKGKHLSYQRSKRVNNPNVSLIKIEGVATPQDAQFYLGKRIAYVYRASKEVRGSKIRVMWGKVTRTHGNSGVVRATFRNNLPAKTFGASVRIFLYPSNI');
INSERT INTO proteininfo VALUES ('6325113', 'NP_015181.1','Hypothetical ORF; Ypl144wp [Saccharomyces cerevisiae]','MLVKTISRTIESESGFLQPTLDVIATLPADDRSKKIPISLVVGFKQEASLNSSSSLSCYYYAIPLMRDRHINLKSGGSNVVGIPLLDTKDDRIRDMARHMATIISERFNRPCYVTWSSLPSEDPSMLVANHLYILKKCLDLLKTELGE');
INSERT INTO proteininfo VALUES ('6325112', 'NP_015180.1','Member of the oxysterol binding protein family, which includes seven yeast homologs; involved in negative regulation of Sec14p-dependent Golgi complex secretory functions, peripheral membrane protein that localizes to the Golgi complex; Kes1p [Saccharomyces cerevisiae]','MSQYASSSSWTSFLKSIASFNGDLSSLSAPPFILSPISLTEFSQYWAEHPELFLEPSFINDDNYKEHCLIDPEVESPELARMLAVTKWFISTLKSQYCSRNESLGSEKKPLNPFLGELFVGKWENKEHPEFGETVLLSEQVSHHPPVTAFSIFNDKNKVKLQGYNQIKASFTKSLMLTVKQFGHTMLDIKDESYLVTPPPLHIEGILVASPFVELEGKSYIQSSTGLLCVIEFSGRGYFSGKKNSFKARIYKDSKDSKDKEKALYTISGQWSGSSKIIKANKKEESRLFYDAARIPAEHLNVKPLEEQHPLESRKAWYDVAGAIKLGDFNLIAKTKTELEETQRELRKEEEAKGISWQRRWFKDFDYSVTPEEGALVPEKDDTFLKLASALNLSTKNAPSGTLVGDKEDRKEDLSSIHWRFQRELWDEEKEIVL');
INSERT INTO proteininfo VALUES ('6325111', 'NP_015179.1','Protein required for cell viability; Ypl146cp [Saccharomyces cerevisiae]','MAPTNLTKKPSQYKQSSRKGKKAWRKNIDLSDVEQYMEKKIDHEITHGTSDITSLQNDALFHVDVEGDEILKNKLIKRKQIKKVLKSKEILDAVKTNSKIAALNHHKNSSGNPNKIQGVSKHELKKLMALAGRVHGESKIKNRVAKDGLVKTTAGDLWGEESNSKKQKVKLPSGIKLDVEKKDQIPEELLKKSTTSWSTASVRPSTLDIEPIAVKEFTEIPHAGKSYNPNNKAWSELINKEYKEEKAREDERIALEKYKERIRHLMETLDDNEEEESSSNEEEEEEEEENENENESTQCSGSDKEIKLSINKPVKNKKKTKYQRNKAKRHEEKVKLQQELKELRQRVKDLEEVINSEETEILSAIESDSNKVKKSKKNKKHKLGTKYSVIDERLEIKFSDELSDSLRKLKPEGNLLYDTVRKLQSSGKVETRVPVRKGRKYKQKITEKWTHKDFK');
INSERT INTO proteininfo VALUES ('6325110', 'NP_015178.1','Pxa1p and Pxa2p appear to be subunits of a peroxisomal ATP-binding cassette transporter necessary for transport of long-chain fatty acids into peroxisomes; ABC family long-chain fatty acid transporter; Pxa1p [Saccharomyces cerevisiae]','MSTTLAAPAKLKSLLLNLHTHCIGLHVNDVTPKVYFKLLIRHLLQISRSNAAHPKLRRRAQILLVSLFLSGVTLFSGVTYSTFKIILKCYKFYKFPWKRRNRRPLIRRTRSQMQLDSGARIMYIPEVELVDRQSPDDNKFMNATDKKKRKRIFIPPKDNDVYEHDKFLFKNVELERAKNSQLFYSKFLNQMNVLSKILIPTVFDKNFLLLTAQIFFLVMRTWLSLFVAKLDGQIVKNIIAGRGRSFLWDLGCWFLIAVPASYTNSAIKLLQRKLSLNFRVNLTRYIHDMYLDKRLTFYKLIFDAKASNSVIKNIDNSITNDVAKFCDATCSVFANIAKPVIDLIFFSVYLRDNLGTVGVAGIFVNYFITGFILRKYTPPLGKLAGERSASDGDYYNYHLNMINNSEEIAFYQGTAVERTKVKELYDVLMEKMLLVDKVKFGYNMLEDYVLKYTWSGLGYVFASIPIVMSTLATGINSEEKNMKEFIVNKRLMLSLADAGSRLMHSIKDISQLTGYTNRIFTLLSVLHRVHSLNFNYGAVPSILSIRTEDASRNSNLLPTTDNSQDAIRGTIQRNFNGIRLENIDVIIPSVRASEGIKLINKLTFQIPLHIDPITSKSNSIQDLSKANDIKLPFLQGSGSSLLILGPNGCGKSSIQRIIAEIWPVYNKNGLLSIPSENNIFFIPQKPYFSRGGTLRDQIIYPMSSDEFFDRGFRDKELVQILVEVKLDYLLKRGVGLTYLDAIADWKDLLSGGEKQRVNFARIMFHKPLYVVLDEATNAISVDMEDYLFNLLKRYRFNFISISQRPTLIKYHEMLLEIGENRDGKWQLQAVGTDEAITSIDNEIEELERKLERVKGWEDERTKLREKLEII');
INSERT INTO proteininfo VALUES ('6325108', 'NP_015176.1','Involved in autophagy; involved in autophagy; Atg5p [Saccharomyces cerevisiae]','MNDIKQLLWNGELNVLVSIDPSFLMKGSPREIAVLRIRVPRETYLVNYMPLIWNKIKSFLSFDPLTDSEKYFWFEHNKTPIPWNYPVGVLFDCLAGKSATFTTSFENQVKDVLTFLRIHLVMGDSLPPTIIPIASSKTQAEKFWFHQWKQVCFILNGSSKAIMSLSVNEARKFWGSVITRNFQDFIEISNKISSSRPRHIPLIIQTSRTSGTFRISQPTISMTGVNPTLKDIEGDILDVKEGINGNDVMVICQGIEIPWHMLLYDLYSKLRSFDGFLYITLVPIKGGDKASSEL');
INSERT INTO proteininfo VALUES ('6325107', 'NP_015175.1','Hypothetical ORF; Ypl150wp [Saccharomyces cerevisiae]','MVNPVGSSKLEQNNIKSIIGSSYNRLYSQFTSDELTEVGNYKILKQIGEGSFGKVYLALHRPTHRKVCLKTSDKNDPNIVREVFYHRQFDFPYITKLYEVIVTESKVWMALEYCPGKELYDHLLSLRRISLLECGELFAQISGAVYYAHSMHCVHRDLKLENILLDKNGNAKLTDFGFTRECMTKTTLETVCGTTVYMAPELIERRTYDGFKIDIWSLGVILYTLITGYLPFDDDDEAKTKWKIVNEEPKYDAKVIPDDARDLISRLLAKNPGERPSLSQVLRHPFLQPYGSVVLDQTQKILCRQRSGGTQFKSKLERRLLKRLKQSGVDTQAIKQSILKKKCDSLSGLWLLLLAQGKKQENCKYPKRSRSVLSVKKVIESATHNDTNGISEDVLKPSLELSRAASLSKMLNKGSDFVTSMTPVSRKKSKDSAKVLNPTLSKISSQRAYSHSIAGSPRKSNNFLQKVSSFFKSKKSSNSNSNNSIHTNVSESLIASNRGAPSSGSFLKKNSGSIQKSRTDTVANPSRTESIGSLNENVAGAIVPRSANNTTLENKKTSGNEIGLKVAPELLLNEHIRIEEPRLKRFKSSISSEISQTSTGNYDSESAENSRSISFDGKVSPPPIRNRPLSEISQISNDTYISEYSTDGNNSSFKISDTIKPSYIRKGSETTSQYSASSEKMTNGYGRKFVRRDLSIVSTASSTSERSSRTDSFYDITTATPVVTTDNRRNKNNNLKESVLPRFGTQRPWTGKRTYTTSRHGKNARRSSKRGLFKITSSNTDSIIQEVSSSEEEDHNVIYSKGKGLPTPVLQTKGLIENGLNERDEEGDDEYAIHTDGEFSIKPQFSDDVIDKQNHLPSVKAVATKRSLSEGSNWSSSYLDSDNNRRRVSSLLVEDGGNPTA');
INSERT INTO proteininfo VALUES ('6325106', 'NP_015174.1','Splicing factor that is found in the Cef1p subcomplex of the spliceosome; Prp46p [Saccharomyces cerevisiae]','MDGNDHKVENLGDVDKFYSRIRWNNQFSYMATLPPHLQSEMEGQKSLLMRYDTYRKESSSFSGEGKKVTLQHVPTDFSEASQAVISKKDHDTHASAFVNKIFQPEVAEELIVNRYEKLLSQRPEWHAPWKLSRVINGHLGWVRCVAIDPVDNEWFITGSNDTTMKVWDLATGKLKTTLAGHVMTVRDVAVSDRHPYLFSVSEDKTVKCWDLEKNQIIRDYYGHLSGVRTVSIHPTLDLIATAGRDSVIKLWDMRTRIPVITLVGHKGPINQVQCTPVDPQVVSSSTDATVRLWDVVAGKTMKVLTHHKRSVRATALHPKEFSVASACTDDIRSWGLAEGSLLTNFESEKTGIINTLSINQDDVLFAGGDNGVLSFYDYKSGHKYQSLATREMVGSLEGERSVLCSTFDKTGLRLITGEADKSIKIWKQDETATKESEPGLAWNPNLSAKRF');
INSERT INTO proteininfo VALUES ('6325105', 'NP_015173.1','Resistant to Rapamycin Deletion 2; similar to hosphotyrosyl phosphatase activator (PTPA) from several organisms; Rrd2p [Saccharomyces cerevisiae]','MLPEKRLLTPDDMKLWEESPTRAHFTKFIIDLAESVKGHENSQYKEPISESINSMMNLLSQIKDITQKHPVIKDADSSRFGKVEFRDFYDEVSRNSRKILRSEFPSLTDEQLEQLSIYLDESWGNKRRIDYGSGHELNFMCLLYGLYSYGIFNLSNDSTNLVLKVFIEYLKIMRILETKYWLEPAGSHGVWGLDDYHFLPFLFGAFQLTTHKHLKPISIHNNELVEMFAHRYLYFGCIAFINKVKSSASLRWHSPMLDDISGVKTWSKVAEGMIKMYKAEVLSKLPIMQHFYFSEFLPCPDGVSPPRGHIHDGTDKDDECNFEGHVHTTWGDCCGIKLPSAIAATEMNKKHHKPIPFD');
INSERT INTO proteininfo VALUES ('6325104', 'NP_015172.1','Protein kinase, required for cell-cycle arrest in response to DNA damage; activated by trans autophosphorylation when interacting with hyperphosphorylated Rad9p; Rad53p [Saccharomyces cerevisiae]','MENITQPTQQSTQATQRFLIEKFSQEQIGENIVCRVICTTGQIPIRDLSADISQVLKEKRSIKKVWTFGRNPACDYHLGNISRLSNKHFQILLGEDGNLLLNDISTNGTWLNGQKVEKNSNQLLSQGDEITVGVGVESDILSLVIFINDKFKQCLEQNKVDRIRSNLKNTSKIASPGLTSSTASSMVANKTGIFKDFSIIDEVVGQGAFATVKKAIERTTGKTFAVKIISKRKVIGNMDGVTRELEVLQKLNHPRIVRLKGFYEDTESYYMVMEFVSGGDLMDFVAAHGAVGEDAGREISRQILTAIKYIHSMGISHRDLKPDNILIEQDDPVLVKITDFGLAKVQGNGSFMKTFCGTLAYVAPEVIRGKDTSVSPDEYEERNEYSSLVDMWSMGCLVYVILTGHLPFSGSTQDQLYKQIGRGSYHEGPLKDFRISEEARDFIDSLLQVDPNNRSTAAKALNHPWIKMSPLGSQSYGDFSQISLSQSLSQQKLLENMDDAQYEFVKAQRKLQMEQQLQEQDQEDQDGKIQGFKIPAHAPIRYTQPKSIEAETREQKLLHSNNTENVKSSKKKGNGRFLTLKPLPDSIIQESLEIQQGVNPFFIGRSEDCNCKIEDNRLSRVHCFIFKKRHAVGKSMYESPAQGLDDIWYCHTGTNVSYLNNNRMIQGTKFLLQDGDEIKIIWDKNNKFVIGFKVEINDTTGLFNEGLGMLQEQRVVLKQTAEEKDLVKKLTQMMAAQRANQPSASSSSMSAKKPPVSDTNNNGNNSVLNDLVESPINANTGNILKRIHSVSLSQSQIDPSKKVKRAKLDQTSKGPENLQFS');
INSERT INTO proteininfo VALUES ('6325103', 'NP_015171.1','vacuolar proteinase A; Pep4p [Saccharomyces cerevisiae]','MFSLKALLPLALLLVSANQVAAKVHKAKIYKHELSDEMKEVTFEQHLAHLGQKYLTQFEKANPEVVFSREHPFFTEGGHDVPLTNYLNAQYYTDITLGTPPQNFKVILDTGSSNLWVPSNECGSLACFLHSKYDHEASSSYKANGTEFAIQYGTGSLEGYISQDTLSIGDLTIPKQDFAEATSEPGLTFAFGKFDGILGLGYDTISVDKVVPPFYNAIQQDLLDEKRFAFYLGDTSKDTENGGEATFGGIDESKFKGDITWLPVRRKAYWEVKFEGIGLGDEYAELESHGAAIDTGTSLITLPSGLAEMINAEIGAKKGWTGQYTLDCNTRDNLPDLIFNFNGYNFTIGPYDYTLEVSGSCISAITPMDFPEPVGPLAIVGDAFLRKYYSIYDLGNNAVGLAKAI');
INSERT INTO proteininfo VALUES ('6325102', 'NP_015170.1','kinesin-related protein; Kip2p [Saccharomyces cerevisiae]','MIQKMSPSLRRPSTRSSSGSSNIPQSPSVRSTSSFSNLTRNSIRSTSNSGSQSISASSTRSNSPLRSVSAKSDPFLHPGRIRIRRSDSINNNSRKNDTYTGSITVTIRPKPRSVGTSRDHVGLKSPRYSQPRSNSHHGSNTFVRDPWFITNDKTIVHEEIGEFKFDHVFASHCTNLEVYERTSKPMIDKLLMGFNATIFAYGMTGSGKTFTMSGNEQELGLIPLSVSYLFTNIMEQSMNGDKKFDVIISYLEIYNERIYDLLESGLEESGSRISTPSRLYMSKSNSNGLGVELKIRDDSQYGVKVIGLTERRCESSEELLRWIAVGDKSRKIGETDYNARSSRSHAIVLIRLTSTNVKNGTSRSSTLSLCDLAGSERATGQQERRKEGSFINKSLLALGTVISKLSADKMNSVGSNIPSPSASGSSSSSGNATNNGTSPSNHIPYRDSKLTRLLQPALSGDSIVTTICTVDTRNDAAAETMNTLRFASRAKNVALHVSKKSIISNGNNDGDKDRTIELLRRQLEEQRRMISELKNRSNIGEPLTKSSNESTYKDIKATGNDGDPNLALMRAENRVLKYKLENCEKLLDKDVVDLQDSEIMEIVEMLPFEVGTLLETKFQGLESQIRQYRKYTQKLEDKIMALEKSGHTAMSLTGCDGTEVIELQKMLERKDKMIEALQSAKRLRDRALKPLINTQQSPHPVVDNDK');
INSERT INTO proteininfo VALUES ('6325101', 'NP_015169.1','Pheromone-regulated protein, predicted to have 1 transmembrane segment; transcriptionally regulated by Ste12p during mating and by Cat8p during the diauxic shift; Prm4p [Saccharomyces cerevisiae]','MIADSSVLKKHTAIKRSTRIISLTLVLLGVFSFLLLTWNDSLEFYNSADPSENKKNSEEESEKKFVYKLPNLLKTADSFLSNENELNFQKVKEEISNIQSEVEVDIPEPSSKATSKFSSRSFQTDNVVTATTTTTLNPRSSSLALQKNCDHKKFDPRTDFLDIIRTSPAVLFIKSSQADSIFLKNLLQREFEISPELATVDLEKHSHGYELEKYIKQNKLNIDTSAALESIQSPYLFLNGISVINRGMVRDIIEPHSKGLLLPLLKSEARGNLLVEKKDIPSNS');
INSERT INTO proteininfo VALUES ('6325100', 'NP_015168.1','TrimethylGuanosine Synthase; Tgs1p [Saccharomyces cerevisiae]','MGRTFIHASKIKHAARKRKHHSNFRTLIKLLNNDAYKIESSKPLKNGKLFKYWKNRRRLFSKIDSASIYMTDELWFSVTPERIACFLANFVKACMPNAERILDVFCGGGGNTIQFAMQFPYVYGVDYSIEHIYCTAKNAQSYGVDDRIWLKRGSWKKLVSKQKLSKIKYDCVFGSPPWGGPEYLRNDVYDLEQHLKPMGITKMLKSFLKLSPNVIMFLPRNSDLNQLSRATRKVLGPFAKCKVLYVKENGYMKGIFCMWGECFFNYEPASTENSRRESSEKEELSSENEELSKRKKHESTTTTKDNTVDIYDVNG');
INSERT INTO proteininfo VALUES ('6325099', 'NP_015167.1','Hypothetical ORF; Ypl158cp [Saccharomyces cerevisiae]','MIIRAPIRTKTKSFRGDQMDFKFPSNESLPRGTLEEYHLNNHHLLNDVFAAENGVSRDEDGNSQTLSDYTSTSNTNTNSGYSSNGYYSFANISDNTTSSPRIVINQNETARLTSSDSNKSDFFASHDFPGNDSLHYSSSNVVKNQLHSMEAIPEGNITGSISTAFQTIPTADNVSYDIAPSSASSLLPRKSTSKSAILPSTQEAKPMTKLNMEKDIKTIELNNSVVPKPKKKLNRVPTIRRVESSRFSNSRYSSSVSSKSSSSRCSLKRSKAIRCKGGLLYYFTSLGIKIKKKLRKLRLVLRRRLFSYNVQKVPSATNSKTTKSKANINNKSKKRGTNLVNKNSNSTPRQKKSQRYVSNLQRSISSKSLVPVLAPQKKTKPLTVDTKFKANHPQSEDSKVGSNTPRSPLVSYTPSLRRTNSSIRRAASILTASATMTPANNKNSFISVPDNVSHAVTRNSSMYSRSRLVRSKPSTALNAIARQPSIVVENKVIPLSMNRYSIKEEDEYVIDTSSMRELSPVNSVCSSDYDRESSESYSNYADAMETTEVDNKDRVECNNEIQNVDANNEETSNEESYNLMKHYLSTVIAQRIMLRVQIARIQNYKSNVVYMNKSAETNSTIYEDLVDSLLTEYEADGSSSQIFDGVTVRADEEEEEDEDDEDDEEEEEENDDEEDEEDEEDDEDDEEEEEKRKEGEGRNLAKEVDELAELSPMRKQSDLSITLRSPFAMLNPAYSNSIISLPTGVVKRSLTLPVGMKI');
INSERT INTO proteininfo VALUES ('6325098', 'NP_015166.1','Protein required for respiratory growth and stability of the mitochondrial genome; Pet20p [Saccharomyces cerevisiae]','MLKLARPFIPPLSRNNAISSGIVLTSRRFQSSFTFLSNQSLLSKNQMKSKRKKGSKKAAYHRQPPEHEHTAPLIKQNKTITKKEHSDVRGSHLKKKRSDFSWLPRVPSTSHLKQSDMTTNVLYSGYRPLFINPNDPKLKEDTGSTLYEFAMKLEDLNEPLSPWISSATGLEFFSEWENIPSELLKNLKPFHPPKEKSMNTNELIHVSAKRNTLVDNKTSETLQRKMDEFSKRRGKGRKKSVVTLLQMKKKLEG');
INSERT INTO proteininfo VALUES ('6325097', 'NP_015165.1','Cytosolic leucyl tRNA synthetase, ligates leucine to the appropriate tRNA; Cdc60p [Saccharomyces cerevisiae]','MSSGLVLENTARRDALIAIEKKYQKIWAEEHQFEIDAPSIEDEPITMDSEELHRTYPKFMSSMAYPYMNGVMHAGHCFTLSKVEFSIGFERMNGKRALFPLGFHCTGMPILACADKLKREAELFGKNFDNVPAEEEEIKEETPAEKDHEDVTKFKAKKSKAAAKKGRGKYQFEIMLQLGIPREEIIKFADAKYWLTYFPPLCESDCTSLGARIDWRRSFVTTDANPYYDAFIRWQMNKLKAAGKIKFGERYTIYSEKDGQACMDHDRQSGEGVTPQEYIGVKIEALEFADDAAKIIDSSSDLDKSKKFYFVAATLRPETMYGQTCCFVSPTIEYGIFDAGDSYFITTERAFKNMSYQKLTPKRGFYKPIVTVPGKAFIGTKIHAPQSVYPELRILPMETVIATKGTGVVTCVPSNSPDDYITTKDLLHKPEYYGIKPEWIDHEIVPIMHTEKYGDLTAKAIVEEKKIQSPKDKNLLAEAKKIAYKEDYYTGTMIYGPYKGEKVEQAKNKVKADMIAAGEAFVYNEPESQVMSRSGDDCIVSLEDQWYVDYGEESWKKQAIECLEGMQLFAPEVKNAFEGVLDWLKNWAVCRTYGLGTRLPWDEKYLVESLSDSTIYQSFYTIAHLLFKDYYGNEIGPLGISADQMTDEVFDYIFQHQDDVKNTNIPLPALQKLRREFEYFYPLDVSISGKDLIPNHLTFFIYTHVALFPKKFWPKGIRANGHLMLNNSKMSKSTGNFMTLEQTVEKFGADAARIAFADAGDTVEDANFDESNANAAILRLFNLKEWAEEITKESNLRTGEITDFFDIAFEHEMNALIEKTYEQYALTNYKNALKYGLFDFQAARDYYREASGVMHKDLIARYIETQALLLAPIAPHFAEYIYREVLGNQTSVQNAKFPRASKPVDKGVLAALDYLRNLQRSIREGEGQALKKKKGKSAEIDASKPVKLTLLISESFPEWQSQCVEIVRKLFSEQTLDDNKKVREHIEPKEMKRAMPFISLLKQRLANEKPEDVFERELQFSEIDTVKAAARNVKKAAQALKIAEFSAISFPYGAKTGKDIFTGEEVEIPPVTKIVENAVPGNPGVVFQNI');
INSERT INTO proteininfo VALUES ('6325096', 'NP_015164.1','Protein involved in establishment of cell polarity and bud emergence; interacts with the Rho1p small GTP-binding protein and with the Rho-type GTPase Cdc42p; Bem4p [Saccharomyces cerevisiae]','MDYEEILFGLQPILNASSIKDVPMNDVYLGSYLAVMDQLAVSLREPSNRDIVGKTGLLLNLVRVLEQALDICFHDTSISINDKIAFYEISSEVIRCIANAIIDNDDNREILLDSGGKKLLNYYIGGVLQLDEISSDKSEDSLVDKLQMRSVVLLRNFCIGNLKYTENLAPFIRGPLFVLLKTTQYSYLSSPEKVVLGSDLLNDILKVNYSNVQISDLFFLSQYIKKISSNVQNKELQAMEDGAVEAYSNTETQKFAGQGNQEYIEKEEEDDEEDVNCELLLNLSTCLETIVAKDETINFTNEEQLVLSMQKNLILSLVCLESKTFNNKLIVMRRLISCAGNISANLTNSNKREQSLCIETIKSSASSYALAAALMILCNSVASKSDAVALLKLISLSELIQVGSLLQDPLQYQGFLDLLRKLLNLENTMWLDIKDLFTLFQIMRRCHEQTKYYNNLRSLLTNLLNKTLTVLPSSKIHNSISSDPTIISFIAEHGTLTSCIAMDKLLVSKKALPKEAITSLWDSIFKFQNLGQAEQLSISDLFHITKTVGIYLKDSSVTADVNPIENILFKDYIQKLTLILETILSFKENKDKGSESCFNNGKFIAGIILNIVKNTKCLTPEEQNLEALAKSFF');
INSERT INTO proteininfo VALUES ('6325095', 'NP_015163.1','Hypothetical ORF; Ypl162cp [Saccharomyces cerevisiae]','MYVSNGKDTCQLLGPVSLFVQTLMGMTAVIVLLVKRNYEHPRRKMIVWSYDIGKQIIGSLGIHFLNLGISILKKRRRSLFAITAKGNDDEDQCDWYFLNLLLDTTVGIPILWLCLYIIEKVLKSLHFQNIESGNYFPSKTVGSHPRKPLFSAFVKQLLIFIVGLGVMKFCVFLILNYLEDLAYWFADLILGWSDSWPNFQVFLVMFVFPILLNCFQYFCVDNVIRLHSESLTITNAENFETNTFLNDEIPDLSEVSNEVPNKDNNISSYGSII');
INSERT INTO proteininfo VALUES ('6325094', 'NP_015162.1','Cell wall and vacuolar protein, required for wild-type resistance to vanadate; Svs1p [Saccharomyces cerevisiae]','MIFKILCSLLLVTSNFASALYVNETTSYTPYTKTLTPTYSVSPQETTLTYSDETTTFYITSTFYSTYWFTTSQSAAIISTPTASTPTASTPSLTTSTNEYTTTYSDTDTTYTSTLTSTYIITLSTESANEKAEQISTSVTEIASTVTESGSTYTSTLTSTLLVTVYNSQASNTIATSTAGDAASNVDALEKLVSAEHQSQMIQTTSADEQYCSASTKYVTVTAAAVTEVVTTTAEPVVKYVTITADASNVTGSANNGTHI');
INSERT INTO proteininfo VALUES ('6325093', 'NP_015161.1','Mutl Homolog; MutL Homolog; Mlh3p [Saccharomyces cerevisiae]','MSQHIRKLDSDVSERLKSQACTVSLASAVREIVQNSVDAHATTIDVMIDLPNLSFAVYDDGIGLTRSDLNILATQNYTSKIRKMNDLVTMKTYGYRGDALYSISNVSNLFVCSKKKDYNSAWMRKFPSKSVMLSENTILPIDPFWKICPWSRTKSGTVVIVEDMLYNLPVRRRILKEEPPFKTFNTIKADMLQILVMHPMISLNVQYTDKLRINTEVLFRSKNITEGLTKHQQMSQVLRNVFGAIIPPDMLKKVSLKFNEYQIEGIISKMPVGLKDLQFIYINGRRYADSAFQGYVDSLFQAQDFGEKGMSLLKTKSVGKPYRSHPVFILDVRCPQTIDDLLQDPAKKIVKPSHIRTIEPLIVKTIRSFLTFQGYLTPDKSDSSFEIVNCSQKTATLPDSRIQISKRNQVLNSKMKIARINSYIGKPAVNGCRINNSTINYEKIKNIRIDGQKSRLRNKLSSRPYDSGFTEDYDSIGKTITDFSISRSVLAKYEVINQVDKKFILIRCLDQSIHNCPLLVLVDQHACDERIRLEELFYSLLTEVVTGTFVARDLKDCCIEVDRTEADLFKHYQSEFKKWGIGYETIEGTMETSLLEIKTLPEMLTSKYNGDKDYLKMVLLQHAHDLKDFKKLPMDLSHFENYTSVDKLYWWKYSSCVPTVFHEILNSKACRSAVMFGDELTRQECIILISKLSRCHNPFECAHGRPSMVPIAELK');
INSERT INTO proteininfo VALUES ('6325092', 'NP_015160.1','Set6p [Saccharomyces cerevisiae]','MTIDGDVHEISPFFQVRQTKWGGRACFSNGNIPKGTTVLQVSNFTGTSISYEFRKEVCHNCFAYANAKTMKYKLNYDYLRDLVCNAHYQINPKKFLGAGLWFCSEHCRTSYLQIPNIIELIECYEILLHHFPSMLKRYNYTSEQEEKLNSILISENVIQSSWDEIESKWIPRINNMKSAKRINQLPPTCEDEYCCIRFVCESLFNLKYMDPQCITYRAFNMLQSNELSKISKFPVLLHFQKLVFQTLYILLPSHLHRMLSIPLLRHILGTEYGNAFGLWQEGEASDSREYFGYWVFPEASYFNHSCNPNITKYRKGNSMLFTMNRDIKKDEQICIDYSGVLDLPTVKRRAFLADSWFFDCACERCKSELQSVH');
INSERT INTO proteininfo VALUES ('6325091', 'NP_015159.1','Protein of unknown function; green fluorescent protein (GFP)-fusion protein localizes to the cytoplasm in a punctate pattern; Ypl166wp [Saccharomyces cerevisiae]','MIMNSTNTVVYIKVKGRRPQGFLDPPKFEWNGTKERQLWTMVSNLNYSQDQIDWQNLSKIFETPEFFLKKRTYKLFAEHLELLQLQLEKKRDLEKYSNDQVNEGMSDLIHKYTPTLQNDNLLNVSASPLTTERQDSEEVETEVTNEALQHLQTSKILNIHKKTSDSENKPNDKLDKDGINKEMECGSSDDDLSSSLSVSKSALEEALMDRLQF');
INSERT INTO proteininfo VALUES ('6325090', 'NP_015158.1','Subunit of DNA polymerase zeta (Rev3p and Rev7p), which is unique in its ability to bypass thymine dimers during replication; Rev3p [Saccharomyces cerevisiae]','MSRESNDTIQSDTVRSSSKSDYFRIQLNNQDYYMSKPTFLDPSHGESLPLNQFSQVPNIRVFGALPTGHQVLCHVHGILPYMFIKYDGQITDTSTLRHQRCAQVHKTLEVKIRASFKRKKDDKHDLAGDKLGNLNFVADVSVVKGIPFYGYHVGWNLFYKISLLNPSCLSRISELIRDGKIFGKKFEIYESHIPYLLQWTADFNLFGCSWINVDRCYFRSPVLNSILDIDKLTINDDLQLLLDRFCDFKCNVLSRRDFPRVGNGLIEIDILPQFIKNREKLQHRDIHHDFLEKLGDISDIPVKPYVSSARDMINELTMQREELSLKEYKEPPETKRHVSGHQWQSSGEFEAFYKKAQHKTSTFDGQIPNFENFIDKNQKFSAINTPYEALPQLWPRLPQIEINNNSMQDKKNDDQVNASFTEYEICGVDNENEGVKGSNIKSRSYSWLPESIASPKDSTILLDHQTKYHNTINFSMDCAMTQNMASKRKLRSSVSANKTSLLSRKRKKVMAAGLRYGKRAFVYGEPPFGYQDILNKLEDEGFPKIDYKDPFFSNPVDLENKPYAYAGKRFEISSTHVSTRIPVQFGGETVSVYNKPTFDMFSSWKYALKPPTYDAVQKWYNKVPSMGNKKTESQISMHTPHSKFLYKFASDVSGKQKRKKSSVHDSLTHLTLEIHANTRSDKIPDPAIDEVSMIIWCLEEETFPLDLDIAYEGIMIVHKASEDSTFPTKIQHCINEIPVMFYESEFEMFEALTDLVLLLDPDILSGFEIHNFSWGYIIERCQKIHQFDIVRELARVKCQIKTKLSDTWGYAHSSGIMITGRHMINIWRALRSDVNLTQYTIESAAFNILHKRLPHFSFESLTNMWNAKKSTTELKTVLNYWLSRAQINIQLLRKQDYIARNIEQARLIGIDFHSVYYRGSQFKVESFLIRICKSESFILLSPGKKDVRKQKALECVPLVMEPESAFYKSPLIVLDFQSLYPSIMIGYNYCYSTMIGRVREINLTENNLGVSKFSLPRNILALLKNDVTIAPNGVVYAKTSVRKSTLSKMLTDILDVRVMIKKTMNEIGDDNTTLKRLLNNKQLALKLLANVTYGYTSASFSGRMPCSDLADSIVQTGRETLEKAIDIIEKDETWNAKVVYGDTDSLFVYLPGKTAIEAFSIGHAMAERVTQNNPKPIFLKFEKVYHPSILISKKRYVGFSYESPSQTLPIFDAKGIETVRRDGIPAQQKIIEKCIRLLFQTKDLSKIKKYLQNEFFKIQIGKVSAQDFCFAKEVKLGAYKSEKTAPAGAVVVKRRINEDHRAEPQYKERIPYLVVKGKQGQLLRERCVSPEEFLEGENLELDSEYYINKILIPPLDRLFNLIGINVGNWAQEIVKSKRASTTTTKVENITRVGTSATCCNCGEELTKICSLQLCDDCLEKRSTTTLSFLIKKLKRQKEYQTLKTVCRTCSYRYTSDAGIENDHIASKCNSYDCPVFYSRVKAERYLRDNQSVQREEALISLNDW');
INSERT INTO proteininfo VALUES ('6325089', 'NP_015157.1','Hypothetical ORF; Ypl168wp [Saccharomyces cerevisiae]','MTVLYTSASLKKMKCLAFNMGMNCVRTVSHARSGGAKFGGRNVFNIFDSKTPDSVRIKAFKNTIYQSAMGKGKTKFSAMEINLITSLVRGYKGEGKKNAINPLQTNVQILNKLLLTHRLTDKDILEGMNLAAGPVNVAIPRDITPQEEKKKVELRNRKAENMDLHPSRKMHIKELLHSLNLDMCNDEEVYQKISLYLQKNEESRTSVGASQQNHVDIDINSLKRYLQNIEKKARQKSAIDKQKKNQARIYQWNTQSFSEIVPLSAGNILFKREPNRLWKRLQNGISVFLGSNGGGKKSKTTKKVLQGNNILLHSLENNKDMTLSNNFDHSVFNINFTDLFGVINASGSPPDRVLNEINEIELKGWKCVGNLYDNNKIVVFQSSNPLLEDTKIPQKSFTNSKRFLISLSALLASFFAYYRYRLSQRQESKK');
INSERT INTO proteininfo VALUES ('6325088', 'NP_015156.1','Involved in nuclear mRNA export, binds both poly(A); a poly(A)+RNA binding protein; Mex67p [Saccharomyces cerevisiae]','MSGFHNVGNINMMAQQQMQQNRIKISVRNWQNATMNDLINFISRNARVAVYDAHVEGPLVIGYVNSKAEAESLMKWNGVRFAGSNLKFELLDNNGASAGTSDTISFLRGVLLKRYDPQTKLLNLGALHSDPELIQKGVFSSISTQSKMFPAMMKLASTEKSLIVESVNLADNQLKDISAISTLAQTFPNLKNLCLANNQIFRFRSLEVWKNKFKDLRELLMTNNPITTDKLYRTEMLRLFPKLVVLDNVIVRDEQKLQTVYSLPMKIQQFFFENDALGQSSTDFATNFLNLWDNNREQLLNLYSPQSQFSVSVDSTIPPSTVTDSDQTPAFGYYMSSSRNISKVSSEKSIQQRLSIGQESINSIFKTLPKTKHHLQEQPNEYSMETISYPQINGFVITLHGFFEETGKPELESNKKTGKNNYQKNRRYNHGYNSTSNNKLSKKSFDRTWVIVPMNNSVIIASDLLTVRAYSTGAWKTASIAIAQPPQQQASVLPQVASMNPNITTPPQPQPSVVPGGMSIPGAPQGAMVMAPTLQLPPDVQSRLNPVQLELLNKLHLETKLNAEYTFMLAEQSNWNYEVAIKGFQSSMNGIPREAFVQF');
INSERT INTO proteininfo VALUES ('6325087', 'NP_015155.1','Damage response protein, related to mammalian membrane progesterone receptors; deletion of DAP1 leads to sensitivity to MMS, elongated telomeres, loss of mitochondrial function, and partial arrest in sterol synthesis; Dap1p [Saccharomyces cerevisiae]','MSFIKNLLFGGVKTSEDPTGLTGNGASNTNDSNKGSEPVVAGNFFPRTLSKFNGHDDEKIFIAIRGKVYDCTRGRQFYGPSGPYTNFAGHDASRGLALNSFDLDVIKDWDQPIDPLDDLTKEQIDALDEWQEHFENKYPCIGTLIPEPGVNV');
INSERT INTO proteininfo VALUES ('6325086', 'NP_015154.1','Widely conserved NADPH oxidoreductase containing flavin mononucleotide (FMN), homologous to Oye2p with slight differences in ligand binding and catalytic properties; may be involved in sterol metabolism; Oye3p [Saccharomyces cerevisiae]','MPFVKGFEPISLRDTNLFEPIKIGNTQLAHRAVMPPLTRMRATHPGNIPNKEWAAVYYGQRAQRPGTMIITEGTFISPQAGGYDNAPGIWSDEQVAEWKNIFLAIHDCQSFAWVQLWSLGWASFPDVLARDGLRYDCASDRVYMNATLQEKAKDANNLEHSLTKDDIKQYIKDYIHAAKNSIAAGADGVEIHSANGYLLNQFLDPHSNKRTDEYGGTIENRARFTLEVVDALIETIGPERVGLRLSPYGTFNSMSGGAEPGIIAQYSYVLGELEKRAKAGKRLAFVHLVEPRVTDPSLVEGEGEYSEGTNDFAYSIWKGPIIRAGNYALHPEVVREQVKDPRTLIGYGRFFISNPDLVYRLEEGLPLNKYDRSTFYTMSAEGYTDYPTYEEAVDLGWNKN');
INSERT INTO proteininfo VALUES ('6325085', 'NP_015153.1','Heme A:farnesyltransferase, catalyzes the first step in the conversion of protoheme to the heme A prosthetic group required for cytochrome c oxidase activity; human ortholog is associated with mitochondrial disorders; Cox10p [Saccharomyces cerevisiae]','MSYFPRTYAHLMRNVLAHNKGNIYLQIGTQLHDTQIKIRFNGVRYISRNHGGKQQHINTAPIEFTPNFGYGDRTSNCNKKVESTAMKTLRCTDDISTSSGSEATTDASTQLPFNVKLVDPMVRKSKRPSHAISEGLNMKTLKKKVIMPYLQLTKPRLTILVMLSAICSYALSPYPASVNELLCLTVGTTLCSGSANAINMGREPEFDRQMVRTQARPVVRGDVTPTQAFEFAALIGTLGVSILYFGVNPTVAILGASNIALYGWAYTSMKRKHIINTWLGALVGMVPPLMGWAAASPLSHPGSWCLAGLLFAWQFPHFNTLSHNIRNEYKNAGYVMTAWKNPLLNARVSLRYSILMFPLCFGLSYFNITDWYYQIDSGLINAWLTFWAFKFYWQQRINYSAKTLKDNVKFNKGLSVANIYARKTFMASVLHLPAILILAIIHKKGRWDWIYPGEAKRPQERF');
INSERT INTO proteininfo VALUES ('6325084', 'NP_015152.1','Mitochondrial ribosomal protein of the large subunit; Mrpl40p [Saccharomyces cerevisiae]','MSGSYQHLSNVGSRVMKRLGNRPKNFLPHSEKFIKKSTPEFMKSDLKEVDEKTSFKSEKEWKFIPGDRVVVMSGASKGNIAVIKSFDKRTNSFILDENGPTKTVPVPKQFWLEGQTSHMITIPVSILGKDLRLVADIDDEKTPGKTRTVAVRDVSFNGSYYDADYKKVMPYRCVKGQPDLIIPWPKPDPIDVQTNLATDPVIAREQTFWVDSVVRNPIPKKAIPSIRNPHSKYKRGTLTAKDIAKLVAPEMPLTEVRKSHLAEKKELAEREVPKLTEEDMEAIGARVFEFLEKQKRE');
INSERT INTO proteininfo VALUES ('6325083', 'NP_015151.1','Nuclear import protein; (putative) large subunit of dynactin complex; Nip100p [Saccharomyces cerevisiae]','MRNAGVQVDTNMQKISLQDTVLVNEMKGRVKFIGETQFAKGIWYGIELDKPLGKNDGSANGIRYFDIDLKKANSNGGYYGLFCKKDTLQFYKPDDDEHSLLNGNAAQETIKNLQVKCESLASKLNKIKIENHELKTSVEKLSTNETVLLSKISRLDKLVKELKVENGNMKTHLDNFNHLLDASDSVMAPDLDKGTLLERSHLLQGLLDQTKLSYDKAMKVQEDLLEENTQLLEENAVLSKKISDLGLQLQQTNNTIGDLALQIEAQSKSSNIVDKLTNDNILLTSNIKALNNELEELQAKEKLDENLRITYEQLEQELRLQLSNLQSALENEKEIAGTYIEENSRLKATLESIEAKTSHKFQSLELKVNTLQEELYQNKLLKKFYQIYEPFAQPHLAALSSQLQYLAEVIESENFGKLENIEIHIILKVLSSISYALHIYTIKNTPDHLETTLQCFKVNIAPISMWLSEFLQRKFSSKQETAFSICQFLEDNKFLDKDVTLILKILHPILETTVPKLLAFLRTNSNFNDNDTLCLIGSLYERSLSLIARIDKLIGKEEISKQDNRLFLYPSCDITLSSILTILFSDALFLRQDYKRISSLKKLEVFFQGIESLLENITIFPEQPSQQTSDSESQCNIKEGNFSNSLLSDRLNEENIRLKEVLVQKENMLTELETKIKIIIGRDLERKTLEENIKTLKVELNNKNEENCGKTEILNKLKEENFNLVNRLKNMELKLYQIKDNNTLNKIYLDREKVDRVNLVSEIMELRETIRRQIKEQKRVSIDFSWLDELPAVENKQPFKEHINHSLDTLGIEMFNFVSTSRILDLKLDQPLAEDELWHERDHSYISYLKRKRKNIRLKSQNVVTYYK');
INSERT INTO proteininfo VALUES ('6325081', 'NP_015149.1','Hypothetical ORF; Ypl176cp [Saccharomyces cerevisiae]','MVNTRGYTTLPNVEEPANNSQDELNSQDFEQAIGMPSEPPVYVEEMGMEEPQAPEAFSEKVQRFRMCFENNVVIPVKKNVVDPLAQMISLASEKFDLFLSKIGNVMVMRRIFYIMMMSIIAALIIASDRLPNGKARGSNGSFSDHDLLLQYARKSIDLSKIERDLEYISSMPHMSGTSGDAAIRHYIKESFDKNGIRLAGEEEFMAYSNYPGNVSLRVYSKDDTEGFDIPLNEENFNPMSHNGQLNNIPVIYANKASLDDMASMQDQGLLNGDFILLVHYGDYVFQQMLTAQEYGAKAIIFISEPYQDNKDVIQMKSVALPQYGTGDALTPEWEGSIRDPIDATEAKCLPKIPSIPISANQGDKILAILSDTGVKFSNNLFSGSLNDCRLDLLVQTAIRERHPVHDIVGKIEGSEQAGRAIVIAAPRNSASYGTMYPSFGTVVLLSLIQLYQEMVYKFDWKPLRNIYFISFGGSEFNEAGATELMEKRTEALKSEIYTIIDVGQIGIWDDSNNLEIQCHPLLVDLFQKNMTSRKFNVKVDNVHQFGDWTPYLAQGIPVAIISSPGVMNREHPIYTVEDKFDFIKDKLRDKKKGEVLSEIMLYLVEKSLELIDDPFIPFSISNYVDFLSTTLKDLQKECPDTVNFDEVFLGTTLWENTKLQFEKWKSEWTELMYGAGTYIEPTIIAINRWSWNYLLSLIGVTQCLEEGLMDRTFYKNVIFGPKLWVDKGDPLRSWTFPEIRDTIAIKDWSSVQVQANTLGTILQNTARYFLENKNLHGINTNEF');
INSERT INTO proteininfo VALUES ('6325080', 'NP_015148.1','Homeodomain-containing transcriptional repressor of PTR2, which encodes a major peptide transporter; imported peptides activate ubiquitin-dependent proteolysis, resulting in degradation of Cup9p and de-repression of PTR2 transcription; Cup9p [Saccharomyces cerevisiae]','MNYNCEIQNRNSKNVDNQVSLPPIQVLFNSIEKRSMPELAFSNIEYSHGNLRSSTEEQNYPAPVLLPQHHSIAYPAINSGGTSTTATPTASTVETSKTSSSAMDTQSQYGSSKKSKSASDDAKPCYKSAPIYEIINKEKDAGAQYNRPFSDFVESKSRRKQNSGRRSNLPKETVQILNTWLLNHLNNPYPTQQEKRELLIKTGLTKIQLSNWFINVRRRKIFSDYYTLVNSIPNDNANNTPVERVQNVSAYHNTLSATNNTMYDATSTCSTDYELSKRFAHAPVTRRKKLIDRLEELKKLSNPDMN');
INSERT INTO proteininfo VALUES ('6325079', 'NP_015147.1','cap binding complex; Small subunit of the nuclear cap binding complex; Cbc2p [Saccharomyces cerevisiae]','MSLEEFDEVKYDHSTKRLDTPSRYLLRKARRNPNGLQELRESMKSSTIYVGNLSFYTSEEQIYELFSKCGTIKRIIMGLDRFKFTPCGFCFIIYSCPDEALNALKYLSDTKLDEKTITIDLDPGFEDGRQFGRGKSGGQVSDELRFDFDASRGGFAIPFAERVGVPHSRFDNSSSQSNTNNYIPPPDAMGTFRPGFDEEREDDNYVPQ');
INSERT INTO proteininfo VALUES ('6325078', 'NP_015146.1','Putative protein serine/threonine phosphatase; null mutation enhances efficiency of translational suppressors; Ppq1p [Saccharomyces cerevisiae]','MRRSPSRSNNNFAVPNCSTNSNSSQQQLTTPSDDLNSNEPNDPDDSRSLPTIKKFNNKHSINNYNTLASAGKNNNNKRASNDNLLIPGENAHKQKIYTKDENLKSLYLDIDVSVAKALSSSATAPKLINTARTSSTTTATTSNNILTSPSYRESNYSSPSSYSFSSYYSSATSASSSTSSFLKSSGLSSRVKSPSSSVKAGSFGAPSSPTSGIPNPKSSKKPIFLRRYSHDTSSNEGLDIDVAIEKLLQVGESREITKTSKKKNFPFHSWEIQLICYHAREIFLNQPTLLRLQAPIKVVGDVHGQFNDLLRILKLSGVPSDTNYLFLGDYVDRGKNSLETILLLLCYKIKYKDNFFMLRGNHESANVTKMYGFYDECKRRLSSKVWKMFVDVFNTLPLAAIIQDKIFCVHGGISPDLHDMKQIEKVARPTDIPESGLVTDLLWSDPDPQVTDWSENDRGVSYTFSKRNVLDFCAKFKFDLILRGHMVVEDGYEFFARKKFVTIFSAPNYCGEFHNWGAVMSVTTGMMCSFELLKPRALKNKKKLYKTKV');
INSERT INTO proteininfo VALUES ('6325077', 'NP_015145.1','Tor Complex One, 89 kDa subunit; Tor1p binding protein; Tco89p [Saccharomyces cerevisiae]','MVHRGRTLKSDTDVTSLNASTVSHQSKPFRQFSTRSRAKSNASFKGLRRVLTHDGTLDNDYFNKHNVSQKCKSSDALFRKRTISGLNMTALTRVKSNQGKRSASFHSPVHNTLLSPKNSSHSNTGTAGFGLKPRRSKSTQSVLSLRDAQESKKSESTTDEEVECFSEDNIEDGKVNNDKVIAEHVMPEEKKNVQQLNQNELQSPDSIDEQEEDKSGTDGKENHRAVSLPLPHLSSNNYFGESSHSIEHQKDGETSPSSIETKLNATSVINEEGQSKVTKEADIDDLSSHSQNLRASLVKAGDNISEAPYDKEKKILDVGNTLAAHKSNQKPSHSDEQFDQEDHIDAPRSNSSRKSDSSFMSLRRQSSKQHKLLNEEEDLIKPDDISSAGTKDIEGHSLLENYAPNMILSQSTGVERRFENSSSIQNSLGNEIHDSGEHMASGDTFNELDDGKLRKSKKNGGRSQLGQNIPNSQSTFPTIANIGSKDNNVPQHNFSTSISSLTNNLRRAAPESFHGSRMNNIFHKKGNQNLLLRSNDLNKNSAAPASPLSNEHITSSTNSGSDANRQSNSGAKFNSFAQFLKSDGIDAESRTQRKLWLQRENSIMDLSSQNDGSDSIFMAGNIDAKREFERISHEYSNVKRFYNPLDEALLRVQPIITGNANNIRKKSHNDAQSIAHSSSDTDHKDEDDLLFTNYDKKFDDLYPHLASAKIQAVLSGIWKSESYLFNKDVNPINKNRTTSTNHSVGHTASQNARNLLRGPMGSSTTLHHQRVINSLQPTTRAVNRRMENVGYMHTQPQQR');
INSERT INTO proteininfo VALUES ('6325075', 'NP_015144.1','Protein that relieves transcriptional repression by binding to the Cyc8p-Tup1p corepressor and recruiting the SAGA complex to the repressed promoter; contains a PHD finger domain; Cti6p [Saccharomyces cerevisiae]','MESTAIVPKGPVVGSEDMEKAEVIASGSTDIISTTSTATTTAAIGSVQEESVKQEDVPMEGGEGEVEEEEGETRCICGELDTPDDSGFFIQCEQCSSWQHGYCVSITQDNAPDKYWCEQCRPELHQLFTTDTGEARSIYKPVQEKRRQSRRKARSAAASKSHAANEAEKSPRNTSNTDDNVDDIGDEEDEVEDEASAVALAKDGNTRSSRRRRRNSMDDASTDQYSLDPGDSDKKLLDRKRATFMAREEKQYQRMLEKALKESRRTSHQEDPESYENDADIYQGDTDNHNGTTRLQTDVMLTEGKPDSVTNDDMKESLRPSKEQSMEKTNDVEKEASQEKESSTGSAQDTEKTDEPILPLTSISSSEDDSRKASSRGSKRVSKPARKGNRTRRSNTSSDTNQNRRSADIGTDKPVKPRLPPQRTSLNEMRRRVSAILEFISRTQWELSEDQSDREEFVRFVENQHFVEKVDTIYNGYNESLSMMDDLTRELLLWEKKYSNNTNAIQ');
INSERT INTO proteininfo VALUES ('6325074', 'NP_015142.1','Hypothetical ORF; Ypl183cp [Saccharomyces cerevisiae]','MKDLSHYGPALCVKFYNDYVLAGYGPFIHVYDYHSATLINKCRLFHYNKVHGLSLSSEGKILAYGARSVTIVELEDVLKKESLVDFERINSDWITGATFSFDNLQIYLLTCYNKVLICDLNCEVLFRKSLGGERSILYSGIIKVFGPDKVYVNAGTVMGGVIIWDLFSETKIHNLLGHEGSIFYVNLSNNGRYVASCSDDRSIRLWDLETGKQLSVGWSHTARIWNLMFFDNDSKLISVSEDCTCRVWNIIESRENVAELSISNVYEVHLIKSIWGVDVKDDEMIAVTSGNDGRLKLIDLLQLKRHGDEETSFSLDDIAKQCGDIFEKNESIKGFQWFSFGVIAITSLGKILKYSDVTKQWKLLLTNEKFNSYPITNGIQTQNIAVFSNNKSDILLIKFSKDSADIIETEEFHLDELSKTNNCLVTEYDDDSFLLTLQSPNPREKFVCLEISLQNLKIKSKHCFNKPENFSSSCLTSFRNHILVGSRFSTLVIYNLLDESEEPFIIRRLSPGDTTTSIEFVEDKDNSAVFSVTNRDGYYVFIELTKNSLEEGPYRLSYKVLHSNKMMKGFLEGAFFNSKGEYITYGFKSSLFYLYNETNCYELASEVCGGSHRLWNLAKITDGHVLMYIKASRFHLRKIYNSIVPETLENGVHGREIRDISICPVSNTNTNDNFKDGHIFCTASEDTTIKLGYFNNRTGKVQNFWTQRKHVSGLQRCQFINHKLMISSSAREELFLWELNDKYNKRPYMTIRQALPVSTNNSDLRIMDFDVKFISQSGDFLLVTVYSDSTIKIWHYRENQNKFDLIMQGRYKTCCLFNVVFIALKEELLVVISPTDGHLVVYNITEYVPFSVDPISGDLVDHKLDATISNLPAPVAQLPVHQSGVKSLDYVANATRTSATILTGGDDNGLGLSNLKLDDSNKVTLKTSDFIAAAASSTITSGMLINGGKEVITTSVDQVIRAWEITAGKLSLVDKKRTTVADTGSLEIISNDEDADSEKTLLIGGVGLSIWKK');
INSERT INTO proteininfo VALUES ('6325073', 'NP_015141.1','Ypl183w-ap [Saccharomyces cerevisiae]','MFLQTLRLTMPRMFLHMKPSPITITRACTVPSLLSVAAPQPALVAANRPLVFNRGFKVRTSVKKFCSDCYLVRRKGRVYIYCKSNKKHKQRQG');
INSERT INTO proteininfo VALUES ('6325072', 'NP_015140.1','Hypothetical ORF; Ypl184cp [Saccharomyces cerevisiae]','MVVSYNNNNNNNNNNNNNNISNNNNNNNMFPPFPSSDDFAMYQQSSSSGPYQETYASGPQNFGDAVYPMNGNFTLLPSDFTREPNDSFFYENDGIFDYQRIQQQPTQFQTKQRNDSQQQRFSQEQNFEIDNEVVHNNNRYYEYERSSNEVSPFDDENPNVLSDGMSPTIMATATAVTNANAPLPVNAQANNPLNFTSAPSRTVYLGNVPPNLSVKELLDHVRSGVVEDVKIIPEKMCAFVSFIDESAALLFHSDAILKRLNIGDRDIKIGWGKPTRIDPIVAARISTDGATRNVYIGRMTIEGEESHLSEEQLRVDLEEYGEIDCIKIIKEKGIAFIHFASILNAIKVVTNLPIRNPYYQNKRIFYGKDRCAFITKTQQHNAAQFLGVQPGMEHMIEFSDREFISNALLQQSAAAAAIATSAGGPNNLGNRTVYLGSLPKDVKIEEICNAVRGGLLQSIKLLNDRYVCFVTFIDPTAAAQFYAMSSLYGFTVQKKRCKVGWGKHSGPLPNALALAVSNGASRNVYVGNIDFVGDSLRDERVFTESNLRHIFQQYGEVEQINFLPEKNCCFINYTNISNAILALDKIKSNPYFKDLKINFGKDRCGNVPHQSR');
INSERT INTO proteininfo VALUES ('6325071', 'NP_015138.1','Protein of unknown function; Uip4p [Saccharomyces cerevisiae]','MVTIVFDHPAEDFPELKIAGEFTNWEGVPMKINTSSGKWEYKFDESSVTKHNDKDKVHFKFIDQNGNWFADDEYPKEVDEHSNENNVATLNNEEDGGSAGEEKDEGDKTAHNTNENGSELYYEGPETPTPSLKGNVTFPSPKTAISQDGSAFAKETTRKERKYEHAPLNEVPVERDPKEENKELSPNFSQEQTENKQDKGLDNLSEGNDNDNTRVNEDTDVTDTQESEHEINGSDTENTDMSEQEEIQKIDKPADQNAKSIVKEGDANTEDYESVLKKLLGALGRFFGSWFSWLTTKMSSSEAS');
INSERT INTO proteininfo VALUES ('6325069', 'NP_015137.1','mating factor alpha; Mf(alpha)1p [Saccharomyces cerevisiae]','MRFPSIFTAVLFAASSALAAPVNTTTEDETAQIPAEAVIGYLDLEGDFDVAVLPFSNSTNNGLLFINTTIASIAAKEEGVSLDKREAEAWHWLQLKPGQPMYKREAEAEAWHWLQLKPGQPMYKREADAEAWHWLQLKPGQPMYKREADAEAWHWLQLKPGQPMY');
INSERT INTO proteininfo VALUES ('6325068', 'NP_015136.1','Mitochondrial NADH kinase, phosphorylates NADH; also phosphorylates NAD(+) with lower specificity; required for the response to oxidative stress; Pos5p [Saccharomyces cerevisiae]','MFVRVKLNKPVKWYRFYSTLDSHSLKLQSGSKFVKIKPVNNLRSSSSADFVSPPNSKLQSLIWQNPLQNVYITKKPWTPSTREAMVEFITHLHESYPEVNVIVQPDVAEEISQDFKSPLENDPNRPHILYTGPEQDIVNRTDLLVTLGGDGTILHGVSMFGNTQVPPVLAFALGTLGFLSPFDFKEHKKVFQEVISSRAKCLHRTRLECHLKKKDSNSSIVTHAMNDIFLHRGNSPHLTNLDIFIDGEFLTRTTADGVALATPTGSTAYSLSAGGSIVSPLVPAILMTPICPRSLSFRPLILPHSSHIRIKIGSKLNQKPVNSVVKLSVDGIPQQDLDVGDEIYVINEVGTIYIDGTQLPTTRKTENDFNNSKKPKRSGIYCVAKTENDWIRGINELLGFNSSFRLTKRQTDND');
INSERT INTO proteininfo VALUES ('6325067', 'NP_015135.1','Multimembrane-spanning protein and putative glycerol transporter that is essential for proton symport of glycerol; Gup1p homolog; Gup2p [Saccharomyces cerevisiae]','MSMLRIWSCIVHFFSVQALDSRIKPDIEFKRRQRIFINSSKEENGSSSSAVTVTRNPVLSSNSPSPPLWNTWEFRLYYLAFTVVVPFMIKAALATSSESNPNYYKFSGLLAHGWILGRKVDNSDPQYRFFRSNFFLLAILILLQIILKKVFVKFSKIPKTKFDFACGLVFVCFMYGINSVKLFTHAFIFFTLAHSLKRKRLIAAFAIWSYGIFTLFINQKMKNLPFNNIAIILSPMDQWYKGIVPRWDFFFNFTLLRLLSYSMDFLERWHEQLSRQPSIDYDDRRPEFRKSLSGSTLQTIYESGKNVLEEKERLVAEHHIQDYNFINFIAYITYAPLFLVGPIITFNDYLYQSENKLPSLTKKNIGFYALKVFSSLLLMEIILHYIYVGAIARTKAWNNDTPLQQAMIALFNLNIMYLKLLIPWRLFRLWAMVDGIDAPENMLRCVDNNYSTVGFWRAWHTSFNKWVIRYIYVPFGGSNNKILTSFAVFSFVAIWHDIQLRVLFWGWLTVLLLLGETYITNCFSRYRFRSWYRFVCGIGAAINICMMMIINVYGFCLGAEGTKLLLKGIFNNSHSPEFLTAVMVSLFIAVQVMFEIREEEKRHGINLKC');
INSERT INTO proteininfo VALUES ('6325066', 'NP_015134.1','May be required for packaging pre-mRNAs into ribonucleoprotein structures amenable to efficient nuclear RNA processing; nuclear polyadenylated RNA/single strand DNA-binding protein; Nab3p [Saccharomyces cerevisiae]','MSDENHNSDVQDIPSPELSVDSNSNENELMNNSSADDGIEFDAPEEEREAEREEENEEQHELEDVNDEEEEDKEEKGEENGEVINTEEEEEEEHQQKGGNDDDDDDNEEEEEEEEDDDDDDDDDDDDEEEEEEEEEEGNDNSSVGSDSAAEDGEDEEDKKDKTKDKEVELRRETLEKEQKDVDEAIKKITREENDNTHFPTNMENVNYDLLQKQVKYIMDSNMLNLPQFQHLPQEEKMSAILAMLNSNSDTALSVPPHDSTISTTASASATSGARSNDQRKPPLSDAQRRMRFPRADLSKPITEEEHDRYAAYLHGENKITEMHNIPPKSRLFIGNLPLKNVSKEDLFRIFSPYGHIMQINIKNAFGFIQFDNPQSVRDAIECESQEMNFGKKLILEVSSSNARPQFDHGDHGTNSSSTFISSAKRPFQTESGDMYNDDNGAGYKKSRRHTVSCNIFVKRTADRTYAIEVFNRFRDGTGLETDMIFLKPRMELGKLINDAAYNGVWGVVLVNKTHNVDVQTFYKGSQGETKFDEYISISADDAVAIFNNIKNNRNNSRPTDYRAMSHQQNIYGAPPLPVPNGPAVGPPPQTNYYQGYSMPPPQQQQQQPYGNYGMPPPSHDQGYGSQPPIPMNQSYGRYQTSIPPPPPQQQIPQGYGRYQAGPPPQPPSQTPMDQQQLLSAIQNLPPNVVSNLLSMAQQQQQQPHAQQQLVGLIQSMQGQAPQQQQQQLGGYSSMNSSSPPPMSTNYNGQNISAKPSAPPMSHQPPPPQQQQQQQQQQQQQQQQPAGNNVQSLLDSLAKLQK');
INSERT INTO proteininfo VALUES ('6325065', 'NP_015133.1','Hypothetical ORF; Ypl191cp [Saccharomyces cerevisiae]','MDLSFTTKSVKINGQNHRILLQNENGPCALLALANILILSPDHTRFSNELIRLVNKGSQISLKELIEVLADIALQVTDKPSTDISELLSLLPRLHEGLNINPEFNGSFENTKEMSIFRLFNVDVVHGWVINSFINENIDEKLSHYSYESAQRILTQAADINCGISQDENSDEVLRDAMHLGLFLNESPTQLTAFGLLRLREKLLHNKFSILFRNDHFSTLFKYEDRLYTLVTDFGYKNCKDIVWQSLDSVDGSCDAFFAGNFSAAEVNGQQLSTDIERDFGTGNLLLEEIQQIENDKELAKQLQEQEQERVTKFEAKRKIHSHKKNSEIHAPVKKDKFKRRSSLLNAKASEKEKSECVVM');
INSERT INTO proteininfo VALUES ('6325064', 'NP_015132.1','Pheromone-regulated protein required for karyogamy; localizes to the inner membrane of the nuclear envelope; Prm3p [Saccharomyces cerevisiae]','MTAMKEDNAALITLKKNNDQEKLRVHKLTDASSNSADGFVINKAKNGGPLNKKSLVNNEQHIKKAVSPGRVRKHKTTTSSTKSRTKSKKKDASESKVQRENKGSFYQGAIFGSFLGAAVTTVLSNLAVKALQN');
INSERT INTO proteininfo VALUES ('6325063', 'NP_015131.1','RiboSome Assembly; Rsa1p [Saccharomyces cerevisiae]','MNYNNFENSKGDGHSRLPKPTYSGTLSDGYDESKIKRQKTDSAFNAAYSPHMYPNSPYYEGSWNTGYTPQLHHVAPHNQYFHPIQPSTQYNYTSPPNYTENYIPPVHQNISYAPALNLQKWPSSYCENTQALKNDKDYQTSISYEDVAIPTVKEIQLIEKNRGKDTFMNEISPVPSSKDQASAEPTEIPRKDPELANSNAEDDHNNLGLEDDDRDEQLESEGLGKVVLVPGTSIALITDEDVKKWREERKKMWLLKISNNKQKHMQEMGIKEDELKSQPSIFKESRKEKQFIQSIQNQVQRGNPKIDLNLKLIQREFANENSQLLDFIRELGDVGLLEYELSQQEKDVLFGSSEDNNKNHYKPNYKNRKPNLSRANFTRNK');
INSERT INTO proteininfo VALUES ('6325062', 'NP_015130.1','DNA damage checkpoint protein, part of a PCNA-like complex required for DNA damage response, required for pachytene checkpoint to inhibit cell cycle in response to unrepaired recombination intermediates; potential Cdc28p substrate; Ddc1p [Saccharomyces cerevisiae]','MSFKATITESGKQNIWFRAIYVLSTIQDDIKITVTTNELIAWSMNETDTTLCQVRFQKSFFEEYEFKPHEIVFGENGVQVIEDTYGNSHKLYSFRVNGRHLTTISRKPDGDGIKSFTIAVNNTSTCPESLANRLIVVIEMDSLIVKEYCPQFQPIKYDPIIINLKYKRRFLDVFGTAASDRNPQEPLDPKLLDVFTNTERELTSALFNEEVESDIRKRNQLTAADEINYICCNSTLLKNFLDNCNVNVTDEVKLEINVHRLSITAFTKAVYGKNNDLLRNALSMSNTISTLDLEHYCLFTTIEDEKQDKRSHSKRREHMKSIIFKLKDFKNFITIGPSWKTTQDGNDNISLWFCHPGDPILMQMQKPGVKLELVEVTDSNINDDILEGKFIKTAISGSKEEAGLKDNKESCESPLKSKTALKRENLPHSVAGTRNSPLKVSYLTPDNGSTVAKTYRNNTARKLFVEEQSQSTNYEQDKRFRQASSVHMNMNREQSFDIGTTHEVACPRNESNSLKRSIADICNETEDPTQQSTFAKRADTTVTWGKALPAADDEVSCSNIDRKGMLKKEKLKHMQGLLNSQNDTSNHKKQDNKEMEDGLGLTQVEKPRGIFD');
INSERT INTO proteininfo VALUES ('6325061', 'NP_015129.1','Delta-like subunit of the yeast AP-3 complex which functions in transport of alkaline phosphatase to the vacuole via the alternate pathway, suppressor of loss of casein kinase 1 function; delta-like subunit of the yeast AP-3 adaptin component of the membrane-associated clathrin assembly complex; Apl5p [Saccharomyces cerevisiae]','MTSLYAPGAEDIRQRLRPFGFFFEKSLKDLIKGIRSHNETPEKLDQFFKQVLSECREEVNSPDLNSKTNAVLKLTYLEMYGFDMAWCNFHILEVMSSNKLQQKRVGYLAASQSFYKDSDILMLATNLLKKDLKYDGNNDVVKVGIALSGLSTIITPSLARDIADDLFTMLNSTRPYIRKKAITALFKVFLQYPEALRDNFDKFVSKLDDDDISVVSAAVSVICELSKKNPQPFIQLSPLLYEILVTIDNNWIIIRLLKLFTNLSQVEPKLRAKLLPKILELMESTVATSVIYESVNCIVKGNMLEEDDFETAMACLERLHTFCDSQDPNLRYISCILFYKIGKINTDFISRFDQLIIRLLSDVDVSIRSKAIELVEGIVDEDNLKAIVQTLMKQFVDEDVVILQTGSIVYEKSKRIPIIIPENYKIKMVNVIISICSADNYSSVNDFEWYNAVIMDLAMLCQDISDKSLGSKIGEQFRNLMIKVPSMREVTIANIIKLISNDNINKQLPTVLRECIWCLGEFSTLVENGNDLIKIMTENISYYSHSVQEVLILALVKVFSNWCNNFQEDKRFEIKMVLKELIEFFENLSYSSTFEVQERSVEVLEFLRLSLEALEEDTEGLPMLLSEVLPSFFNAYELAPIARGTQLKLAVDENLDLETPFLTKEAADELLDEQKSDAISDLMSDISMDEQVELKFVDDSDTSYEEKEKLDDFENPFEIEREKERMSNPYYLGEEDEERTKNSKDLLDLNEEESSDKKPETIRLNRTDNSLNSLSLSTTEISRKKKKGKKKNRVQVLSDEPVIEAAPKRKDAFQKPHDNHSTQNPLKKDKINLRMHSQLENFDFSNFGQSSNAGRGSQEEGNLRKEDELELSRLEANLIVKDEKDNLSDTEEVIVIKKKKKGKKSKSKNKLKTKAKNSPEPNEFLRDQSTDI');
INSERT INTO proteininfo VALUES ('6325060', 'NP_015128.1','Protein of unknown function required for normal levels of resistance to oxidative damage, null mutants are sensitive to hydrogen peroxide; member of a conserved family of proteins found in eukaryotes but not in prokaryotes; Oxr1p [Saccharomyces cerevisiae]','MFGVKDAIFKIKRSIAGTDSSDSTAYTTASESSPQLKDSHNPFRNKTTSERTIVEEGSLPPVRLNGYLPSTKNKLLTPEMCDEIRTLMPTRIQLYTEWNLLYSLEQHGSSLHSLYSNVAPDSKEFRRVGYVLVIKDRKNGIFGAYSNEAFHPNEHRQYTGNGECFLWKLDKVPDVNISEKEESEQEGKEGKEEGDKEERWRFSGYPYTGVNEFAIYCTSEFLSMGAGDGHYGLLCDDGLLHGVSNPCQTYGNEVLSKEGKKFSIVALEVWRVG');
INSERT INTO proteininfo VALUES ('6325058', 'NP_015126.1','Protein component of the large (60S) ribosomal subunit, nearly identical to Rpl7Ap and has similarity to E. coli L30 and rat L7 ribosomal proteins; contains a conserved C-terminal Nucleic acid Binding Domain (NDB2); Rpl7bp [Saccharomyces cerevisiae]','MSTEKILTPESQLKKTKAQQKTAEQIAAERAARKAANKEKRAIILERNAAYQKEYETAERNIIQAKRDAKAAGSYYVEAQHKLVFVVRIKGINKIPPKPRKVLQLLRLTRINSGTFVKVTKATLELLKLIEPYVAYGYPSYSTIRQLVYKRGFGKINKQRVPLSDNAIIEANLGKYGILSIDDLIHEIITVGPHFKQANNFLWPFKLSNPSGGWGVPRKFKHFIQGGSFGNREEFINKLVKAMN');
INSERT INTO proteininfo VALUES ('6325057', 'NP_015125.1','Hypothetical ORF; Ypl199cp [Saccharomyces cerevisiae]','MKGTGGVVVGTQNPVRDYNHSTDEEYQRLRRLADEAYKKRDQLSHESQTAYQQGDKKLAHELSEKSKAQLKTAEDFNMQAAEYVFVENNADSSSNEIDLHGLYVKEALFILQKRIKFAIDHNEPQLNVIVGKGLHSQNGIAKLKPSIEEFCAKHGIRNHLEKGNSGVLVLELQGVQMQMDGPAVNAPTNQYNAQPHPQYNNNGGQPQGQAQNYNNSGNDNKDSTLTSIFKIFCNCIQSLA');
INSERT INTO proteininfo VALUES ('6325056', 'NP_015124.1','Protein required for accurate chromosome segregation during meiosis; Csm4p [Saccharomyces cerevisiae]','MMDGSITRKVTSTLSNQLATWKWKLQLSLLERKLATINNDYFLLQWELLFITNEVMKWKEMIAFLESQLFCTTQNFVAQETHDRETFQSLVDDYNKQLSENNLIISVLKSRPQLSSFPIYLSDEVCSHLKFVIAELNSLIIVFFISLVFLWVSIEV');
INSERT INTO proteininfo VALUES ('6325055', 'NP_015123.1','Hypothetical ORF; Ypl201cp [Saccharomyces cerevisiae]','MGIPMQIYQDGKGVQFYHTRYQNVFDERASKYGNYTVNNDYPQLPDTIKEHIDQLTFSNVGEDGGDVGNYSEEDDDGDEEKELEDVFRSNRGLEFVRINNYFTTHDLQSFKSFRNFNSKYWIFYSNQAEDKKLLLYDFNGQHLIFIKQQFYGQLNLLLSDAIICMDCNFGYNSNTIQILVGFQNGKLLKLNCDLNGNVNNHLLLKDPSTSSHQSHLSILNVWAGLLPHFVVSFSLKDGLLITSLDHQQSNGSFQSFHTNIDLPVDLRTTTNVKSVLNFPQFTLYKGNDMIFHCKNLLGSDASTLNKEINFMLKIDEDVQKIDYLLKTNHILLETNMRYLSIPTRDPIENSNSSPPVSDSEVYPIFYKTQELHVHASGTGRQIANNGKYIFITEQHLYGTALSVYKYSISFKRWLFVGYSDIRAKYGIRSVKDLFVGNCPSVNSPVLTILTDDNNIQTILLK');
INSERT INTO proteininfo VALUES ('6325054', 'NP_015122.1','Activator of Iron (Fe) Transcription; Aft2p [Saccharomyces cerevisiae]','MKAKSMKSIISVPISVSKTGKMKLTASPDNLASMMSKDQNKLIHLDPVPSFEDRHEIKPWLQKIFYPQGIDIVIERSDSSKVTFKCRSVRSKVGLNPKSKGSSSRSHACPFRIRAAYSVRLQKWNVVVMNNIHSHELRFDLITKTDDYKKFKENLRQKNDEKAIKTFDELEYKASLNLPLVTPIISCDCGLTKEIEAFNNIFLPLSNPPLTSKKNLLKTNKNSVSKIKSRQMDNSKPRPRLKTKLDADLHDTGFLDNFKTRNSCVKIEKEDSLTNLNEIDFTNMFCNDNFIQNYNQGLMELLTEPTPGPSSSSCILPSTPTRPLSQSKMDIALSESTTSSPNFMETDAPYGDEIIKVSKDTKSNAPTADTDIATNLGKERNENFGMLNYNYEALLHFNDEHFNELNSIDPALISKY');
INSERT INTO proteininfo VALUES ('6325053', 'NP_015121.1','Involved in nutrient control of cell growth and division; cAMP-dependent protein kinase catalytic subunit; Tpk2p [Saccharomyces cerevisiae]','MEFVAERAQPVGQTIQQQNVNTYGQGVLQPHHDLQQRQQQQQQRQHQQLLTSQLPQKSLVSKGKYTLHDFQIMRTLGTGSFGRVHLVRSVHNGRYYAIKVLKKQQVVKMKQVEHTNDERRMLKLVEHPFLIRMWGTFQDARNIFMVMDYIEGGELFSLLRKSQRFPNPVAKFYAAEVILALEYLHAHNIIYRDLKPENILLDRNGHIKITDFGFAKEVQTVTWTLCGTPDYIAPEVITTKPYNKSVDWWSLGVLIYEMLAGYTPFYDTTPMKTYEKILQGKVVYPPYFHPDVVDLLSKLITADLTRRIGNLQSGSRDIKAHPWFSEVVWERLLAKDIETPYEPPITSGIGDTSLFDQYPEEQLDYGIQGDDPYAEYFQDF');
INSERT INTO proteininfo VALUES ('6325052', 'NP_015120.1','Similar to YCK1 and YCK2, two other casein kinase I isoforms; found primarily in nucleus; may be involved in DNA-damage repair; casein kinase I isoform; Hrr25p [Saccharomyces cerevisiae]','MDLRVGRKFRIGRKIGSGSFGDIYHGTNLISGEEVAIKLESIRSRHPQLDYESRVYRYLSGGVGIPFIRWFGREGEYNAMVIDLLGPSLEDLFNYCHRRFSFKTVIMLALQMFCRIQYIHGRSFIHRDIKPDNFLMGVGRRGSTVHVIDFGLSKKYRDFNTHRHIPYRENKSLTGTARYASVNTHLGIEQSRRDDLESLGYVLIYFCKGSLPWQGLKATTKKQKYDRIMEKKLNVSVETLCSGLPLEFQEYMAYCKNLKFDEKPDYLFLARLFKDLSIKLEYHNDHLFDWTMLRYTKAMVEKQRDLLIEKGDLNANSNAASASNSTDNKSETFNKIKLLAMKKFPTHFHYYKNEDKHNPSPEEIKQQTILNNNAASSLPEELLNALDKGMENLRQQQPQQQVQSSQPQPQPQQLQQQPNGQRPNYYPEPLLQQQQRDSQEQQQQVPMATTRATQYPPQINSNNFNTNQASVPPQMRSNPQQPPQDKPAGQSIWL');
INSERT INTO proteininfo VALUES ('6325050', 'NP_015118.1','Endoplasmic reticulum protein of unknown function; Ypl206cp [Saccharomyces cerevisiae]','MVEIVGHRAFKARYPENTLLAFEKAYAAGADVIETDLQMTSDGMVVVNHDSDTGRMWDKNLVIGESTWEEVKRLRCKEDGSLAMMTLKEILTWAVCHPGAKLMLDIKFTNEKIIMIKTFVIMLEVKNDLKFWQERITWGLWLLDWYDFGIETGVLKDFKVIVISLSLDIASQFVKRSLTLNDPHYKLFGISVHFVSSWTSQFRLRLLPVLMKNDIKVYLWTVNKPIDFKYLCELPIHGAITDDPIKARKLCDGHTVAKKPTAEKKFVAPSLASVDGLRFHAFIKVYNILCTLLYSKWVHIKLCGWSIAYVIFLFLRTIHFL');
INSERT INTO proteininfo VALUES ('6325049', 'NP_015117.1','Hypothetical ORF; Ypl207wp [Saccharomyces cerevisiae]','MDGFRVAGALVVGALTAAYLYFGGRFSIALVIIVGYGIYCNEASGGSQDSQEKLDLNKQQKKPCCSDKKIADGGKKTGGCCSDKKNGGGKGGGCCSSKGGKKGGCCSSKGGKKGGCCSSKKNIGDNENTATEVEKAVNYPVTVDFTEVFRKPTKKRSSTPKVFSKNSSSNSRVGKKLSVSKKIGPDGLIKSALTISNETLLSSQIYVLYSSLQGAASKAAKSVYDKLKELDELTNEPKLLNLDDLSDFDDYFINVPVENALYVLVLPSYDIDCPLDYFLQTLEENANDFRVDSFPLRKLVGYTVLGLGDSESWPEKFCYQAKRADHWISRLGGRRIFPLGKVCMKTGGSAKIDEWTSLLAETLKDDEPIIYEYDENADSEEDEEEGNGSDELGDVEDIGGKGSNGKFSGADEIKQMVAKDSPTYKNLTKQGYKVIGSHSGVKICRWTKNELRGKGSCYKKSLFNIASSRCMELTPSLACSSKCVFCWRHGTNPVSKNWRWEVDEPEYILENALKGHYSMIKQMRGVPGVIAERFAKAFEVRHCALSLVGEPILYPHINKFIQLLHQKGITSFLVCNAQHPEALRNIVKVTQLYVSIDAPTKTELKKVDRPLYKDFWERMVECLEILKTVQNHQRTVFRLTLVKGFNMGDVSAYADLVQRGLPGFIEVKGATFSGSSDGNGNPLTMQNIPFYEECVKFVKAFTTELQRRGLHYDLAAEHAHSNCLLIADTKFKINGEWHTHIDFDKFFVLLNSGKDFTYMDYLEKTPEWALFGNGGFAPGNTRVYRKDKKKQNKENQETTTRETPLPPIPA');
INSERT INTO proteininfo VALUES ('6325048', 'NP_015116.1','Hypothetical ORF; Ypl208wp [Saccharomyces cerevisiae]','MSSDALKALLQWGASFGVIVPEELKFLYTDLKGIICVCEKDIDNPSIKIPPEIVISRNLPMKFFGLSESTKNINGWLKLFFAKIKFDRDNDTIVDNVRVNDKFKPYLDALPSRLNSPLVWNPSELKRLSSTNIGNSIHEKFEGIFKEWFELVSSSDMFDLERVADDVQTFHNLDELTYEALYEKILKITELQRPTIWYSFPAFLWSHLIFISRAFPEYVLNRNCPDNSIVLLPIVDLLNHDYRSKVKWYPENGWFCYEKIGTASQSRELSNNYGGKGNEELLSGYGFVLEDNIFDSVALKVKLPLDVVSTILETEPSLKLPLLSDYTTYAFENKDCVQQEKKATRSATDYINGVTYFINIQNEQCLEPLLDLFTYLSKAEEEDLHDLRARLQGIQMLRNALQSKLNSITGPPATDDSYAIDPYRVYCADVYTKGQKQILKEALTRLKKLEKTMLSENKHQLLTMSKILKNDPAFAETELPSLFSNEDGEEVIFESTYDLLILWILLKTKKNSYPTKYEWVGQQYTNFKQTAYISDDAKAFHTAYFEKQDDVDLAEVDHAIQFVVDNSFTRTSSTTEETILVRK');
INSERT INTO proteininfo VALUES ('6325047', 'NP_015115.1','Aurora kinase involved in regulating kinetochore-microtubule attachments, associates with Sli5p, which stimulates Ipl1p kinase activity and promotes its association with the mitotic spindle, potential Cdc28p substrate; Ipl1p [Saccharomyces cerevisiae]','MQRNSLVNIKLNANSPSKKTTTRPNTSRINKPWRISHSPQQRNPNSKIPSPVREKLNRLPVNNKKFLDMESSKIPSPIRKATSSKMIHENKKLPKFKSLSLDDFELGKKLGKGKFGKVYCVRHRSTGYICALKVMEKEEIIKYNLQKQFRREVEIQTSLNHPNLTKSYGYFHDEKRVYLLMEYLVNGEMYKLLRLHGPFNDILASDYIYQIANALDYMHKKNIIHRDIKPENILIGFNNVIKLTDFGWSIINPPENRRKTVCGTIDYLSPEMVESREYDHTIDAWALGVLAFELLTGAPPFEEEMKDTTYKRIAALDIKMPSNISQDAQDLILKLLKYDPKDRMRLGDVKMHPWILRNKPFWENKRL');
INSERT INTO proteininfo VALUES ('6325045', 'NP_015113.1','Nip7p is required for 60S ribosome subunit biogenesis; involved in ribosome biogenesis; Nip7p [Saccharomyces cerevisiae]','MRQLTEEETKVVFEKLAGYIGRNISFLVDNKELPHVFRLQKDRVYYVPDHVAKLATSVARPNLMSLGICLGKFTKTGKFRLHITSLTVLAKHAKYKIWIKPNGEMPFLYGNHVLKAHVGKMSDDIPEHAGVIVFAMNDVPLGFGVSAKSTSESRNMQPTGIVAFRQADIGEYLRDEDTLFT');
INSERT INTO proteininfo VALUES ('6325044', 'NP_015112.1','Involved in tRNA biogenesis; intranuclear protein which exhibits a nucleotide-specific intron-dependent tRNA pseudouridine synthase activity; Pus1p [Saccharomyces cerevisiae]','MSEENLRPAYDDQVNEDVYKRGAQSKLTKARKADFDDEKDKKKDNDKHIDKRPKSGPRLDENGNPLPKEPRLPKRKVAVMVGYCGTGYHGMQYNPPNPTIESALFKAFVEAGAISKDNSNDLKKNGFMRAARTDKGVHAGGNLISLKMIIEDPDIKQKINEKLPEGIRVWDIERVNKAFDCRKMCSSRWYEYLLPTYSLIGPKPGSILYRDIEESKTELPGVLDEDLESKEFWEEFKKDANEKFSTEEIEAILAYVPPARDEFDINEELYQKVKKYKQLENAHRRRYRISAAKLAKFRASTSQYLGAHNFHNFTLGKDFKEPSAIRFMKDIKVSDPFVIGDAQTEWISIKIHGQSFMLHQIRKMVSMATLITRCGCPVERISQAYGQQKINIPKAPALGLLLEAPVFEGYNKRLEQFGYKAIDFSKYQDEVDKFKMKHIYDKIYKEEVDENVFNAFFSYIDSFNKVTGAQGEETADKSGPAVQKSIFEFLTAKGIPGLTDAPESNKKIKQRKRMEEEEAASKKAEISSTTQSNEPEVQPEAAAN');
INSERT INTO proteininfo VALUES ('6325043', 'NP_015111.1','Component of U2 snRNP; disruption causes reduced U2 snRNP levels; physically interacts with Msl1p; putative homolog of human U2A' snRNP protein; Lea1p [Saccharomyces cerevisiae]','MKFTPSIVIDAPQYYVDHFNGKYNVDKCVILRDLQLETDSESMPSSLKHLTKPTHILDLTNNDLIMIPDLSRRDDIHTLLLGRNNIVEVDGRLLPMNVQNLTLSNNSIRRFEDLQRLRRAPRTLKNLTLIGNQVCHLANYREHVLRLVPHLETLDFQNVTAEERKSAMSFPRQADGDTLGPVNTAIRDNGSRDKTMEIMNLVVSKMTVERRNELKKQLAEATSLEEIARLEKLLSGGV');
INSERT INTO proteininfo VALUES ('6325042', 'NP_015110.1','Bifunctional enzyme with thiamine-phosphate pyrophosphorylase and 4-methyl-5-beta-hydroxyethylthiazole kinase activities, required for thiamine biosynthesis; GFP-fusion protein localizes to the cytoplasm in a punctate pattern; Thi6p [Saccharomyces cerevisiae]','MVFTKEEVDYSLYLVTDSTMLPPGTTLCSQVEAGLKNGVTLVQIREKDIETKNFVAEALEVQKICKKYNVPLIINDRIDVAMAIDADGVHVGQDDMPIPMVRKLLGPSKILGWSVGKPSEVETLAKWGPDMVDYIGVGTLFPTSTKKNPKKSPMGPQGAIAILDALEEFKATWCRTVGIGGLHPDNIQRVLCQCVASNGKRSLDGISLVSDIMAAPDACAATKRLRGLLDATRYQFVECELNNTFPTTTSIQNVISQVSNNRPLVQHITNKVHQNFGANVTLALGSSPIMSEIESEVSELARIPNASLLLNTGSVAPIEMLKAAINAYNEVNRPITFDPVGYSATETRLCLNNTLLTYGQFACIKGNCSEILSLAKLNNHKMKGVDSSSGKTNIDTLVRATQIVAFQYRTVAVCTGEFDCVADGTFGGEYKLSSGTEGITAEDLPCVIIEDGPIPIMGDITASGCSLGSTIASFIGGLDSTGKLFDAVVGAVLLYKSAGKLASTRCQGSGSFHVELIDALYQLFHENKPEKWSASLKKFK');
INSERT INTO proteininfo VALUES ('6325041', 'NP_015109.1','Protein required for assembly of ubiquinol cytochrome-c reductase complex (cytochrome bc1 complex); involved in cytochrome-c reductase assembly; Cbp3p [Saccharomyces cerevisiae]','MMSVNRFTSGRLPVFLRKSPFYYSRAYLHQTCVFKQNKETAQDSPELLAKSSHLNSKPLDVSNKAPVKTAQNKIPLAHSKYESSKYELPKWKEALGELVIRAFHLDMDRVRAGPVAGSYYYKICKEQGLQYEDEPLSETAKYFYEDLKLPRTFSQWFQITVLHEWILFVRMRAMPFKYGRNYQQKLVDRTFSDIELRLFEEMKVNSGRIADQYLKDFNTQLRGAIFAYDEGFATDDGTLATAVWRNLFGGRKNIDMVHLESVVRYIYSQLYVLSRLSDREFATGKFKFVPPGVKVEKLTPKQEEELKAKTIAKYEALDKDPKTLPSERSRLSYTN');
INSERT INTO proteininfo VALUES ('6325040', 'NP_015108.1','Hypothetical ORF; Ypl216wp [Saccharomyces cerevisiae]','MVLLNRRKIQPKEIGQSADSFSETPWVIKESSERINDYDSDLKKLDFYKRDIFTCEISGKDGLSYFKALKSEEQHREKVRYLLPKELRKAIANFANFSPIRKVGHLVESAFQRFSNRFFIGDTVCLKTIQKNALITYKEGEPNLVESPTIENNVTLFLVKDVFQSNGMMESEKGEISAPKLSLYLITECLNRESKGAALIVGQNEIKRPESHFSKFIIACFLNEILIKVSNKEHAPWRVKQEYIERYDVNPKCSPNMIDYLPDRMNSSSSELYTPLTIPPESDVEPADWKETSETSETSETSLSKIKAIDDEISVSFDHIYDNVNSLAYNDLKGTVDDKELPFTGPSIPFENISYLDSSLEYKNIDQKWFKECSQFPTERLLVVYQFLSFFGRFIGLSHFNFDQFLTTIKCTSPEALVDEYVKINFLKTYNSKGSFTNEKPRNEIYNQVTSSNVSQREKANVFNADESQRIPSNFTRNQKMRKFITDKSTEFVMYSIFKGKPLKNDDMEFQSYEKVNILYIDIVCSLMCLMTDNEPDWNCNLMDNWTEEKRKEEGNKTEIDIAIEKCLNYGDTSWVKLLHNKNFSNGNWLICLLGILQQNTHMIAYSDVAKCITKKILPLSMNFVNLGDELWDNFRKRLSIKDKIDVLWVLVDFASNFSSYIKELVDKVPKLCNGIRLKLDSAKKEYIKLKRQLKTLTKNRVKLHSNVSMNRYGSDECKGKVNALKVKIAYLMEDIAFLEAKLIQSDIKRLEILGKDRNGNRYYWMDSNGSSSAISEKNEELYNCCFLWVQGPSEADINFCLDVDVESLKKWELLAKAKGTAYATKEVFSIFRSTDGSYYQIAQGENFMIINSNGILMRPTIPAFIDKKIISETPEKLLLSHHQWAFFNDIEDIHMLVDRLDDLRENEGQLKKALTSKMDRIEVSYKQQFKIKRRIECDETFKKNHKLLKNNEFTFPELKRIETTCTSNGQHFSNMEKISKKLSRTKNDLVLEAILKDVAHLGECERALLKKQQNLIYPLNFHFEQLRTIDLEFIVETKRKRQEDILTKLLNHQRYKHISHVSGYGISSQRVDKAAHLDVQGILEEIECQLISRRREDEERN');
INSERT INTO proteininfo VALUES ('6325039', 'NP_015107.1','GTP-binding protein required for processing of 35S pre-rRNA at sites A0,; Bms1p [Saccharomyces cerevisiae]','MEQSNKQHRKAKEKNTAKKKLHTQGHNAKAFAVAAPGKMARTMQRSSDVNERKLHVPMVDRTPEDDPPPFIVAVVGPPGTGKTTLIRSLVRRMTKSTLNDIQGPITVVSGKHRRLTFLECPADDLNAMIDIAKIADLVLLLIDGNFGFEMETMEFLNIAQHHGMPRVLGVATHLDLFKSQSTLRASKKRLKHRFWTEVYQGAKLFYLSGVINGRYPDREILNLSRFISVMKFRPLKWRNEHPYMLADRFTDLTHPELIETQGLQIDRKVAIYGYLHGTPLPSAPGTRVHIAGVGDFSVAQIEKLPDPCPTPFYQQKLDDFEREKMKEEAKANGEITTASTTRRRKRLDDKDKLIYAPMSDVGGVLMDKDAVYIDIGKKNEEPSFVPGQERGEGEKLMTGLQSVEQSIAEKFDGVGLQLFSNGTELHEVADHEGMDVESGEESIEDDEGKSKGRTSLRKPRIYGKPVQEEDADIDNLPSDEEPYTNDDDVQDSEPRMVEIDFNNTGEQGAEKLALETDSEFEESEDEFSWERTAANKLKKTESKKRTWNIGKLIYMDNISPEECIRRWRGEDDDSKDESDIEEDVDDDFFRKKDGTVTKEGNKDHAVDLEKFVPYFDTFEKLAKKWKSVDAIKERFLGAGILGNDNKTKSDSNEGGEELYGDFEDLEDGNPSEQAEDNSDKESEDEDENEDTNGDDDNSFTNFDAEEKKDLTMEQEREMNAAKKEKLRAQFEIEEGENFKEDDENNEYDTWYELQKAKISKQLEINNIEYQEMTPEQRQRIEGFKAGSYVRIVFEKVPMEFVKNFNPKFPIVMGGLLPTEIKFGIVKARLRRHRWHKKILKTNDPLVLSLGWRRFQTLPIYTTTDSRTRTRMLKYTPEHTYCNAAFYGPLCSPNTPFCGVQIVANSDTGNGFRIAATGIVEEIDVNIEIVKKLKLVGFPYKIFKNTAFIKDMFSSAMEVARFEGAQIKTVSGIRGEIKRALSKPEGHYRAAFEDKILMSDIVILRSWYPVRVKKFYNPVTSLLLKEKTEWKGLRLTGQIRAAMNLETPSNPDSAYHKIERVERHFNGLKVPKAVQKELPFKSQIHQMKPQKKKTYMAKRAVVLGGDEKKARSFIQKVLTISKAKDSKRKEQKASQRKERLKKLAKMEEEKSQRDKEKKKEYFAQNGKRTTMGGDDESRPRKMRR');
INSERT INTO proteininfo VALUES ('6325038', 'NP_015106.1','Secretion-Associated, Ras-related. Component of COPII coat of vesicles; required for ER to Golgi protein transport; GTP-binding protein of the ARF family; Sar1p [Saccharomyces cerevisiae]','MAGWDIFGWFRDVLASLGLWNKHGKLLFLGLDNAGKTTLLHMLKNDRLATLQPTWHPTSEELAIGNIKFTTFDLGGHIQARRLWKDYFPEVNGIVFLVDAADPERFDEARVELDALFNIAELKDVPFVILGNKIDAPNAVSEAELRSALGLLNTTGSQRIEGQRPVEVFMCSVVMRNGYLEAFQWLSQYI');
INSERT INTO proteininfo VALUES ('6325037', 'NP_015105.1','Cyclin, interacts with Pho85p cyclin-dependent kinase (Cdk) to phosphorylate and regulate glycogen synthase, also activates Pho85p for Glc8p phosphorylation; Pcl8p [Saccharomyces cerevisiae]','MANDQDPNKSLINDALTRSMSEFYDDDDDNDSDMCRANDEGEDVFDLPLKVGVSQSRNFSEVNDVLDPLSSLHGPSKKVRFEQQKQQQQHQQLHNDFNTDFNLKSPSSKKMGVEQLIQSANEINDYLANNIDKVNSFNSELLSGSGKLPGRVKSDTATQGTGRLDSMSNFALSDTELDNDDDNYLLDPLANASSTTPTVEHHGYSLLDKALSTSDKEKIYTNKVNSNSQIDTDNHSHESGNTTNNETDENESSEILDYTKFDSFPYPPSSAPNGEPPDLKVLSIECEQENEKELRRISLLLDHYESIPKIPELSDDEALSKFRENIELILQLSKKINDNANTLAISSEDPQKFVNFVMKNPPSLSFRDFIDRIQNKCMFGAVVYLGATYLLQLVFLTRDEMDGPIKLKAKLQEDQAHRIIISTIRIATKLLEDFVHSQNYICKVFGISKRLLTKLEISFMASVNFDGLMITCEKLEKTLHILDDTRQALGNT');
INSERT INTO proteininfo VALUES ('6325036', 'NP_015104.1','N-terminally acetylated protein component of the large (60S) ribosomal subunit, nearly identical to Rpl1Bp and has similarity to E. coli L1 and rat L10a ribosomal proteins; rpl1a rpl1b double null mutation is lethal; Rpl1ap [Saccharomyces cerevisiae]','MSKITSSQVREHVKELLKYSNETKKRNFLETVELQVGLKNYDPQRDKRFSGSLKLPNCPRPNMSICIFGDAFDVDRAKSCGVDAMSVDDLKKLNKNKKLIKKLSKKYNAFIASEVLIKQVPRLLGPQLSKAGKFPTPVSHNDDLYGKVTDVRSTIKFQLKKVLCLAVAVGNVEMEEDVLVNQILMSVNFFVSLLKKNWQNVGSLVVKSSMGPAFRLY');
INSERT INTO proteininfo VALUES ('6325035', 'NP_015103.1','Protein of unknown function, overproduction suppresses a pam1 slv3 double null mutation; Bop1p [Saccharomyces cerevisiae]','MQVLVTLWCLICTCLVLPVAAKKRTLTASSLVTCMENSQLSANSFDVSFSPDDRSLHYDLDMTTQIDSYIYAYVDVYAYGFKIITENFDVCSMGWKQFCPVHPGNIQIDSIEYIAQKYVKMIPGIAYQVPDIDAYVRLNIYNNVSENLACIQVFFSNGKTVSQIGVKWVTAVIAGIGLLTSAVLSTFGNSTAASHISANTMSLFLYFQSVAVVAMQHVDSVPPIAAAWSENLAWSMGLIRITFMQKIFRWYVEATGGSASLYLTATTMSVLTQRGLDYLKNTSVYKRAENVLYGNSNTLIFRGIKRMGYRMKIENTAIVCTGFTFFVLCGYFLAGFIMACKYSIELCIRCGWMRSDRFYQFRKNWRSVLKGSLLRYIYIGFTQLTILSFWEFTERDSAGVIVIACLFIVLSCGLMAWAAYRTIFFASKSVEMYNNPAALLYGDEYVLNKYGFFYTMFNAKHYWWNALLTTYILVKALFVGFAQASGKTQALAIFIIDLAYFVAIIRYKPYLDRPTNIVNIFICTVTLVNSFLFMFFSNLFNQKYAVSAIMGWVFFIMNAAFSLLLLLMILAFTTIILFSKNPDSRFKPAKDDRASFQKHAIPHEGALNKSVANELMALGNVAKDHTENWEYELKSQEGKSEDNLFGVEYDDEKTGTNSENAESSSKETTRPTFSEKVLRSLSIKRNKSKLGSFKRSAPDKITQQEVSPDRASSSPNSKSYPGVSHTRQESEANNGLINAYEDEQFSLMEPSILEDAASSTQMHAMPARDLSLSSVANAQDVTKKANILDPDYL');
INSERT INTO proteininfo VALUES ('6325034', 'NP_015102.1','The authentic, non-tagged protein was localized to the mitochondria.; Fmp40p [Saccharomyces cerevisiae]','MGEKRTIIKALKNSAASHFIKKLTADTSLSSIQEAINVVQQYNATDPVRLKLFHTPRMVSQGAHFAFCLPTKKPHYKPLLLSQNALDEFNLVQDQDLEKILSGEKVYYSDSIFPYSTVYSGFQFGSFAAQLGDGRVVNLFDLKDKCSGQWQTFQLKGAGMTPFSRFADGKAVLRSSIREFIMSEALHSIGIPSTRAMQLTLLPGTKAQRRNQEPCAVVCRFAPSWIRLGNFNLFRWRHDLKGLIQLSDYCIEELFAGGTQFEGKPDFNIFKRDFFPDTETKIDEQVEKDETEVSTMTGDNISTLSKYDEFFRHVVSLNANTVAHWQAYGFANGVLNTDNTSIMGLTIDYGPFAFLDKFEPSFTPNHDDTAKRYSFANQPSIIWWNLQQFAKDLACLLGPEARDLELLLKGELNSVDDALEKTMIERVQKLVELSANEYKYVFTTRYAQIMSQRLGVDLDLEKCMSSTNLKDIEHAAEKAKEFCDVIVEPLLDILQATKVDYNNFFIHLQNYKGPFFIKDKSDTATLFGAFDEEYLGMFFNSKQLQQMAETEEAFAAGEKVFDANGELRLLNEKLQEIRNWTQDYLTLVPPTETAARASLAKKANPLFVPRSWVLEEVVDDLMYSQRDGLQDPSSELDTSALKKLYLMSVNPYDRTKWDVTLRPELETKWADLSHQDDAKFMMQASCSS');
INSERT INTO proteininfo VALUES ('6325033', 'NP_015101.1','Hydrophilin of unknown function; stress induced (osmotic, ionic, oxidative, heat shock and heavy metals); regulated by the HOG pathway; Gre1p [Saccharomyces cerevisiae]','MSNLLNKFADKLHGNDHDERYEDDNDDQTRQQRHEKHQQREFRNQGSKADPYGEENQGNFPQRQQPQSNLGGNTQFGGNDFQQQTTDYTAGTGGGTYTQTYRETNTQGQLDDDEDDDFLTSGQQQKQGRTRGAQSNRYQSSNIGSGRRDLSGSGNDEYDDDSGNQGVW');
INSERT INTO proteininfo VALUES ('6325032', 'NP_015100.1','Protein involved in mitochondrial iron accumulation; involved in mitochondrial iron accumulation; Mmt2p [Saccharomyces cerevisiae]','MLRISIDSIKQFGSFVTGYNNTSYHAAGRAIRTSSLYSTMISANPRRCLHSSKLLNKEGQEEGYNEQLISKMSSQNGSNSRQNESEGKKEGKASSVKSLLQHTHSHSHTHMHDNPLLSLNVQQIKKNPGVRITWIGLASNVGMAVGKFVGGITFHSQALLADSVHALSDLVSDFLTLFSVQYASRKPTSEYPYGYGKVETVGSLAVSTILAMAGISIGWSSLCAIVGPVIPHAILESMAGLIGETHSHSQSLTQQATNVNAVWIAAGSILVKEWVFQATKKVAIQTNSNVLMANAWHHRVDSLTSLVALVAITSSYFFNIQSLDNLGGLVVSGLIIKTGGQGILSSLKELVDQSIPPTDPRYLEIESVIKDSIGSLKTDLDLKQSLHVRDLTILASGPNLRATTTLEVPVLHSGQEVGIRFLENAISTIREDLRMKVPNVGRWTSSLLM');
INSERT INTO proteininfo VALUES ('6325031', 'NP_015099.1','Hypothetical ORF; Ypl225wp [Saccharomyces cerevisiae]','MSTFNAETADNLEDIEKQFAVVAVEQAETYWKLLTSVPGSKLRLTKFDDEIYENFMERFPEYKDVERVKKFTEEELKTKEAKERWRKFFTIFEKKIEDYNFGTLLRTDASAEYGQFTTCFVVRLQFYAFEIARNKHGLNDWIVGQK');
INSERT INTO proteininfo VALUES ('6325030', 'NP_015098.1','This gene encodes a protein with an Q/N-rich amino terminal domain that acts as a prion, termed [NU]+.; New1p [Saccharomyces cerevisiae]','MPPKKFKDLNSFLDDQPKDPNLVASPFGGYFKNPAADAGSNNASKKSSYQQQRNWKQGGNYQQGGYQSYNSNYNNYNNYNNYNNYNNYNNYNKYNGQGYQKSTYKQSAVTPNQSGTPTPSASTTSLTSLNEKLSNLELTPISQFLSKIPECQSITDCKNQIKLIIEEFGKEGNSTGEKIEEWKIVDVLSKFIKPKNPSLVRESAMLIISNIAQFFSGKPPQEAYLLPFFNVALDCISDKENTVKRAAQHAIDSLLNCFPMEALTCFVLPTILDYLSSGAKWQAKMAALSVVDRIREDSANDLLELTFKDAVPVLTDVATDFKPELAKQGYKTLLDYVSILDNLDLSPRYKLIVDTLQDPSKVPESVKSLSSVTFVAEVTEPSLSLLVPILNRSLNLSSSSQEQLRQTVIVVENLTRLVNNRNEIESFIPLLLPGIQKVVDTASLPEVRELAEKALNVLKEDDEADKENKFSGRLTLEEGRDFLLDHLKDIKADDSCFVKPYMNDETVIKYMSKILTVDSNVNDWKRLEDFLTAVFGGSDSQREFVKQDFIHNLRALFYQEKERADEDEGIEIVNTDFSLAYGSRMLLNKTNLRLLKGHRYGLCGRNGAGKSTLMRAIANGQLDGFPDKDTLRTCFVEHKLQGEEGDLDLVSFIALDEELQSTSREEIAAALESVGFDEERRAQTVGSLSGGWKMKLELARAMLQKADILLLDEPTNHLDVSNVKWLEEYLLEHTDITSLIVSHDSGFLDTVCTDIIHYENKKLAYYKGNLAAFVEQKPEAKSYYTLTDSNAQMRFPPPGILTGVKSNTRAVAKMTDVTFSYPGAQKPSLSHVSCSLSLSSRVACLGPNGAGKSTLIKLLTGELVPNEGKVEKHPNLRIGYIAQHALQHVNEHKEKTANQYLQWRYQFGDDREVLLKESRKISEDEKEMMTKEIDIDDGRGKRAIEAIVGRQKLKKSFQYEVKWKYWKPKYNSWVPKDVLVEHGFEKLVQKFDDHEASREGLGYRELIPSVITKHFEDVGLDSEIANHTPLGSLSGGQLVKVVIAGAMWNNPHLLVLDEPTNYLDRDSLGALAVAIRDWSGGVVMISHNNEFVGALCPEQWIVENGKMVQKGSAQVDQSKFEDGGNADAVGLKASNLAKPSVDDDDSPANIKVKQRKKRLTRNEKKLQAERRRLRYIEWLSSPKGTPKPVDTDDEED');
INSERT INTO proteininfo VALUES ('6325029', 'NP_015097.1','UDP-glucose:dolichyl-phosphate glucosyltransferase, involved in asparagine-linked glycosylation in the endoplasmic reticulum; Alg5p [Saccharomyces cerevisiae]','MRALRFLIENRNTVFFTLLVALVLSLYLLVYLFSHTPRPPYPEELKYIAIDEKGHEVSRALPNLNEHQDDEEIFLSVVIPSYNETGRILLMLTDAISFLKEKYGSRWEIVIVDDGSTDNTTQYCLKICKEQFKLNYEQFRIIKFSQNRGKGGAVRQGFLHIRGKYGLFADADGASKFSDVEKLIDAISKIETSSTDLKTTKPAVAIGSRAHMVNTEAVIKRSMIRNCLMYGFHTLVFIFGIRSIKDTQCGFKLFNRAAILKIFPYLHTEGWIFDVEILILAIRKRIQIEEIPISWHEVDGSKMALAIDSIKMAKDLVIIRMAYLLGIYRDNKKC');
INSERT INTO proteininfo VALUES ('6325028', 'NP_015096.1','Interacts with Ceg1p, the mRNA capping enzyme alpha subunit; removes gamma-phosphate from triphosphate-terminated RNA; mRNA capping enzyme beta subunit (80 kDa), RNA 5'-triphosphatase; Cet1p [Saccharomyces cerevisiae]','MSYTDNPPQTKRALSLDDLVNHDENEKVKLQKLSEAANGSRPFAENLESDINQTETGQAAPIDNYKESTGHGSHSQKPKSRKSSNDDEETDTDDEMGASGEINFDSEMDFDYDKQHRNLLSNGSPPMNDGSDANAKLEKPSDDSIHQNSKSDEEQRIPKQGNEGNIASNYITQVPLQKQKQTEKKIAGNAVGSVVKKEEEANAAVDNIFEEKATLQSKKNNIKRDLEVLNEISASSKPSKYRNVPIWAQKWKPTIKALQSINVKDLKIDPSFLNIIPDDDLTKSVQDWVYATIYSIAPELRSFIELEMKFGVIIDAKGPDRVNPPVSSQCVFTELDAHLTPNIDASLFKELSKYIRGISEVTENTGKFSIIESQTRDSVYRVGLSTQRPRFLRMSTDIKTGRVGQFIEKRHVAQLLLYSPKDSYDVKISLNLELPVPDNDPPEKYKSQSPISERTKDRVSYIHNDSCTRIDITKVENHNQNSKSRQSETTHEVELEINTPALLNAFDNITNDSKEYASLIRTFLNNGTIIRRKLSSLSYEIFEGSKKVM');
INSERT INTO proteininfo VALUES ('6325027', 'NP_015095.1','Hypothetical ORF; Ypl229wp [Saccharomyces cerevisiae]','MMPYNTPPNIQEPMNFASSNPFGIIPDALSFQNFKYDRLQQQQQQQQQQQQNRTASSLQQPQQQQPISPPLFLVGAGTSENSNLNKNANTSTIPPLLFSRSSQHYVVPDIDHSSIIYKNNICKSFKDDLFFCPRSLLSLEEQQACEKMDRLTAEQMSLYHQNTQSSSNPGSMSSSPPNSASSIFNSRPKFNPYTSQSFNPLESVQE');
INSERT INTO proteininfo VALUES ('6325026', 'NP_015094.1','Up in StarVation; Ypl230wp [Saccharomyces cerevisiae]','MENTTNRNTAGVLTSSNGNFATNSVAASTPKRSKSARRKTFKCTGYDGCTMSFTRAEHLARHIRKHTGEKPFQCPACLKFFSRVDNLKQHRESVHAHKNHHSTSSHQRKPSSSSLSSSSSASSSSSASSSTSYSDPYRKTNINSGNMPMMAENEKAPQIIHSSPEFITSTRSIPPISPRSIYNTQRQQQHQQQQHQQAPYYFPSHPITDSYYQYPLPSNNNTINYLPSVDVQYPLNVSPSSTSHPASEVIISSFPPRSMPSTSFKYKDSADFQARTTMNKYNIRPSNINVNTSNINNHLDSFSPPFSPSTTVAEAKPIILPQYQQAFSQPPNGNKNNNMSSSKNGGKGGENFKNTDDRNDNNNKKRSETLSESDISVNTNKKRLSVDYILT');
INSERT INTO proteininfo VALUES ('6325025', 'NP_015093.1','Alpha subunit of fatty acid synthetase, which catalyzes the synthesis of long-chain saturated fatty acids; contains beta-ketoacyl reductase and beta-ketoacyl synthase activities; Fas2p [Saccharomyces cerevisiae]','MKPEVEQELAHILLTELLAYQFASPVRWIETQDVFLKDFNTERVVEIGPSPTLAGMAQRTLKNKYESYDAALSLHREILCYSKDAKEIYYTPDPSELAAKEEPAKEEAPAPTPAASAPAPAAAAPAPVAAAAPAAAAAEIADEPVKASLLLHVLVAHKLKKSLDSIPMSKTIKDLVGGKSTVQNEILGDLGKEFGTTPEKPEETPLEELAETFQDTFSGALGKQSSSLLSRLISSKMPGGFTITVARKYLQTRWGLPSGRQDGVLLVALSNEPAARLGSEADAKAFLDSMAQKYASIVGVDLSSAASASGAAGAGAAAGAAMIDAGALEEITKDHKVLARQQLQVLARYLKMDLDNGERKFLKEKDTVAELQAQLDYLNAELGEFFVNGVATSFSRKKARTFDSSWNWAKQSLLSLYFEIIHGVLKNVDREVVSEAINIMNRSNDALIKFMEYHISNTDETKGENYQLVKTLGEQLIENCKQVLDVDPVYKDVAKPTGPKTAIDKNGNITYSEEPREKVRKLSQYVQEMALGGPITKESQPTIEEDLTRVYKAISAQADKQDISSSTRVEFEKLYSDLMKFLESSKEIDPSQTTQLAGMDVEDALDKDSTKEVASLPNKSTISKTVSSTIPRETIPFLHLRKKTPAGDWKYDRQLSSLFLDGLEKAAFNGVTFKDKYVLITGAGKGSIGAEVLQGLLQGGAKVVVTTSRFSKQVTDYYQSIYAKYGAKGSTLIVVPFNQGSKQDVEALIEFIYDTEKNGGLGWDLDAIIPFAAIPEQGIELEHIDSKSEFAHRIMLTNILRMMGCVKKQKSARGIETRPAQVILPMSPNHGTFGGDGMYSESKLSLETLFNRWHSESWANQLTVCGAIIGWTRGTGLMSANNIIAEGIEKMGVRTFSQKEMAFNLLGLLTPEVVELCQKSPVMADLNGGLQFVPELKEFTAKLRKELVETSEVRKAVSIETALEHKVVNGNSADAAYAQVEIQPRANIQLDFPELKPYKQVKQIAPAELEGLLDLERVIVVTGFAEVGPWGSARTRWEMEAFGEFSLEGCVEMAWIMGFISYHNGNLKGRPYTGWVDSKTKEPVDDKDVKAKYETSILEHSGIRLIEPELFNGYNPEKKEMIQEVIVEEDLEPFEASKETAEQFKHQHGDKVDIFEIPETGEYSVKLLKGATLYIPKALRFDRLVAGQIPTGWNAKTYGISDDIISQVDPITLFVLVSVVEAFIASGITDPYEMYKYVHVSEVGNCSGSGMGGVSALRGMFKDRFKDEPVQNDILQESFINTMSAWVNMLLISSSGPIKTPVGACATSVESVDIGVETILSGKARICIVGGYDDFQEEGSFEFGNMKATSNTLEEFEHGRTPAEMSRPATTTRNGFMEAQGAGIQIIMQADLALKMGVPIYGIVAMAATATDKIGRSVPAPGKGILTTAREHHSSVKYASPNLNMKYRKRQLVTREAQIKDWVENELEALKLEAEEIPSEDQNEFLLERTREIHNEAESQLRAAQQQWGNDFYKRDPRIAPLRGALATYGLTIDDLGVASFHGTSTKANDKNESATINEMMKHLGRSEGNPVIGVFQKFLTGHPKGAAGAWMMNGALQILNSGIIPGNRNADNVDKILEQFEYVLYPSKTLKTDGVRAVSITSFGFGQKGGQAIVVHPDYLYGAITEDRYNEYVAKVSAREKSAYKFFHNGMIYNKLFVSKEHAPYTDELEEDVYLDPLARVSKDKKSGSLTFNSKNIQSKDSYINANTIETAKMIENMTKEKVSNGGVGVDVELITSINVENDTFIERNFTPQEIEYCSAQPSVQSSFAGTWSAKEAVFKSLGVKSLGGGAALKDIEIVRVNKNAPAVELHGNAKKAAEEAGVTDVKVSISHDDLQAVAVAVSTKK');
INSERT INTO proteininfo VALUES ('6325024', 'NP_015092.1','SSO1 and SSO2 encode syntaxin homologs (post-Golgi t-SNAREs); act in late stages of secretion; post-Golgi t-SNARE; Sso1p [Saccharomyces cerevisiae]','MSYNNPYQLETPFEESYELDEGSSAIGAEGHDFVGFMNKISQINRDLDKYDHTINQVDSLHKRLLTEVNEEQASHLRHSLDNFVAQATDLQFKLKNEIKSAQRDGIHDTNKQAQAENSRQRFLKLIQDYRIVDSNYKEENKEQAKRQYMIIQPEATEDEVEAAISDVGGQQIFSQALLNANRRGEAKTALAEVQARHQELLKLEKSMAELTQLFNDMEELVIEQQENVDVIDKNVEDAQLDVEQGVGHTDKAVKSARKARKNKIRCWLIVFAIIVVVVVVVVVPAVVKTR');
INSERT INTO proteininfo VALUES ('6325023', 'NP_015091.1','Essential component of the MIND kinetochore complex (Mtw1p Including Nnf1p-Nsl1p-Dsn1p) which joins kinetochore subunits contacting DNA to those contacting microtubules; required for accurate chromosome segregation; Nsl1p [Saccharomyces cerevisiae]','MSQGQSKKLDVTVEQLRSIYHQFHDILEEKTDLHLPKKEYDDDAVRREVQIQLQEFLLSAMTMASKSLEVVNADTVGKTVKQLIMESQEKYMEPFDLDLNEQVRKMYQEWEDETVKVAQLRQTGPAKINEVYNNSKDEYLAQLDGRIGVLQARMMQQQSADHDDSTDDADDHINWEHIKQDYVASLNELYQTQQDLPKVRYNVEKVKRLMDFLEED');
INSERT INTO proteininfo VALUES ('6325022', 'NP_015090.1','vacuolar ATPase V0 domain subunit c' (17 kDa); Tfp3p [Saccharomyces cerevisiae]','MSTQLASNIYAPLYAPFFGFAGCAAAMVLSCLGAAIGTAKSGIGIAGIGTFKPELIMKSLIPVVMSGILAIYGLVVAVLIAGNLSPTEDYTLFNGFMHLSCGLCVGFACLSSGYAIGMVGDVGVRKYMHQPRLFVGIVLILIFSEVLGLYGMIVALILNTRGSE');
INSERT INTO proteininfo VALUES ('6325021', 'NP_015089.1','RUVB-like protein, TIP49b Homologue; RUVB-like protein; Rvb2p [Saccharomyces cerevisiae]','MSIQTSDPNETSDLKSLSLIAAHSHITGLGLDENLQPRPTSEGMVGQLQARRAAGVILKMVQNGTIAGRAVLVAGPPSTGKTALAMGVSQSLGKDVPFTAIAGSEIFSLELSKTEALTQAFRKSIGIKIKEETELIEGEVVEIQIDRSITGGHKQGKLTIKTTDMETIYELGNKMIDGLTKEKVLAGDVISIDKASGKITKLGRSFARSRDYDAMGADTRFVQCPEGELQKRKTVVHTVSLHEIDVINSRTQGFLALFTGDTGEIRSEVRDQINTKVAEWKEEGKAEIVPGVLFIDEVHMLDIECFSFINRALEDEFAPIVMMATNRGVSKTRGTNYKSPHGLPLDLLDRSIIITTKSYNEQEIKTILSIRAQEEEVELSSDALDLLTKTGVETSLRYSSNLISVAQQIAMKRKNNTVEVEDVKRAYLLFLDSARSVKYVQENESQYIDDQGNVQISIAKSADPDAMDTTE');
INSERT INTO proteininfo VALUES ('6325020', 'NP_015088.1','Hypothetical ORF; Ypl236cp [Saccharomyces cerevisiae]','MISIVLELFQNLCCCRGFSDATIRVNDKRYRIQRLLGEGGMSFVYLVQLSKNSLIIDNGIATPELYALKKIICPSVESISNGMREIENYKRFQSPYVIKSIDSQVMQEKDGSKTIYIVLPYYSLGSLQDSINRRLLEGTFVSEAECVRIMLGVTRGLLCLHDPASRQDNATSRVNVDAVSMTYSDETAMLLEDTPLEMDMLSSNSAGSIAYAHRDITPSNILFSSDGLPVIGDLGSCSQADITIENRHQLSELQEWVNDNCTLPYTPPELLNLKLNQVLSSKVDIWSLGCTFYTLMFGISPFEREEQIHGASLTYAINTGKYSFPRNSRFSEGLLSVIKKCIQVDPIQRPTTSQLLNLLQDLDT');
INSERT INTO proteininfo VALUES ('6325018', 'NP_015087.1','Beta subunit of the translation initiation factor eIF2, involved in the identification of the start codon; proposed to be involved in mRNA binding; Sui3p [Saccharomyces cerevisiae]','MSSDLAAELGFDPALKKKKKTKKVIPDDFDAAVNGKENGSGDDLFAGLKKKKKKSKSVSADAEAEKEPTDDIAEALGELSLKKKKKKTKDSSVDAFEKELAKAGLDNVDAESKEGTPSANSSIQQEVGLPYSELLSRFFNILRTNNPELAGDRSGPKFRIPPPVCLRDGKKTIFSNIQDIAEKLHRSPEHLIQYLFAELGTSGSVDGQKRLVIKGKFQSKQMENVLRRYILEYVTCKTCKSINTELKREQSNRLFFMVCKSCGSTRSVSSIKTGFQATVGKRRRM');
INSERT INTO proteininfo VALUES ('6325017', 'NP_015085.1','YAR1 encodes a 200-amino-acid protein with two ANK repeat motifs and an acidic C terminus rich in PEST-like sequences; Yar1p [Saccharomyces cerevisiae]','MGLHSEPLDQEDQDTIILDARAGDLDSLKDIFTTLVSPELLSTCKESESDSTALHMAAANGHIETVRYILETVSRANSAEDLKAFVNEVNKTGNTALHWASLNGKLDVVKLLCDEYEADPFIRNKFGHDAIFEAENSGKEEVETYFLKKYDVEPEDDEEDTQTEGKNSVQITKGTEIEQVTKEATEALREETEKLNINKD');
INSERT INTO proteininfo VALUES ('6325016', 'NP_015084.1','Cytoplasmic chaperone (Hsp90 family) required for pheromone signaling and negative regulation of Hsf1p; docks with the mitochondrial import receptor Tom70p for preprotein delivery; interacts with co-chaperones Cns1p, Cpr6p, Cpr7p, and Sti1p; Hsp82p [Saccharomyces cerevisiae]','MASETFEFQAEITQLMSLIINTVYSNKEIFLRELISNASDALDKIRYKSLSDPKQLETEPDLFIRITPKPEQKVLEIRDSGIGMTKAELINNLGTIAKSGTKAFMEALSAGADVSMIGQFGVGFYSLFLVADRVQVISKSNDDEQYIWESNAGGSFTVTLDEVNERIGRGTILRLFLKDDQLEYLEEKRIKEVIKRHSEFVAYPIQLVVTKEVEKEVPIPEEEKKDEEKKDEEKKDEDDKKPKLEEVDEEEEKKPKTKKVKEEVQEIEELNKTKPLWTRNPSDITQEEYNAFYKSISNDWEDPLYVKHFSVEGQLEFRAILFIPKRAPFDLFESKKKKNNIKLYVRRVFITDEAEDLIPEWLSFVKGVVDSEDLPLNLSREMLQQNKIMKVIRKNIVKKLIEAFNEIAEDSEQFEKFYSAFSKNIKLGVHEDTQNRAALAKLLRYNSTKSVDELTSLTDYVTRMPEHQKNIYYITGESLKAVEKSPFLDALKAKNFEVLFLTDPIDEYAFTQLKEFEGKTLVDITKDFELEETDEEKAEREKEIKEYEPLTKALKEILGDQVEKVVVSYKLLDAPAAIRTGQFGWSANMERIMKAQALRDSSMSSYMSSKKTFEISPKSPIIKELKKRVDEGGAQDKTVKDLTKLLYETALLTSGFSLDEPTSFASRINRLISLGLNIDEDEETETAPEASTAAPVEEVPADTEMEEVD');
INSERT INTO proteininfo VALUES ('6325015', 'NP_015083.1','Tubulin folding factor C (putative) involved in beta-tubulin (Tub2p) folding; isolated as mutant with increased chromosome loss and sensitivity to benomyl; Cin2p [Saccharomyces cerevisiae]','MDFTAKIKELERELSETSDYKTLQKKTISLRSELNTLSHSLTSYEKEHFSNDIENVLKSINAKLSESKGKKRLFSFKQKNSSSAVHKNVERTELANAPAYTTTLKKHYVLEKGDSAFENLEFCTVTSTTDYSGNSALSGSLCFRNITKCVINLQRIFFQTGSIFITDCTDSIIFLRSPSDKDFQIRLRDLKNCKILIEKLSPSIDCKQVVIIENCHKCIFNASTRDHLIIQDFSNPFQSEETEDNSAFAFEDFDICNKDTMQLFRAYL');
INSERT INTO proteininfo VALUES ('6325014', 'NP_015082.1','Essential protein required for determination of budding pattern, promotes localization of axial markers Bud4p and Cdc12p and functionally interacts with Sec3p, localizes to the contractile ring during anaphase, member of the IQGAP family; Iqg1p [Saccharomyces cerevisiae]','MTAYSGSPSKPGNNNSYLNRYVENLGTNVTPPLRPQSSSKINSSLNIASPSHLKTKTSASNSSATILSKKVESSVSKLKPSLPNKLVGKYTVDLSNYSKIELRYYEFLCRVSEVKIWIEAVIEEALPSEIELCVGDSLRNGVFLAKLTQRINPDLTTVIFPAGDKLQFKHTQNINAFFGLVEHVGVPDSFRFELQDLYNKKNIPQVFETLHILISMINKKWPGKTPALTNVSGQISFTKEEIAACKKAWPRIRDFKSLGTNINTAPASPEEPKEKRSGLIKDFNKFERPNIPVEEILITPRKNITDANCSDFSNTPSPYNEAPKMSNLDVVVEKRKFTPIEPSLLGPTPSLEYSPIKNKSLSYYSPTISKYLTYDTEFYTRRSRAREEDLNYYQTFKYSPSHYSPMRRERMTEEQFLEKVVQLQNICRGVNTRFNLYIQKRLLNLFEQDILRFQACLRGNKFRVLSSMYLPIRRAKIDVPHVEAIQSRIKGSRIRYKYDKLKFTLSRFSCTVELLQAYCRSKLLKTTVNTKLNDIEISHYPLTKLQSYMRASYVRKKVMSLNTKLNDERESIMKFSAIIRGNVVRCSEDAILSAVHDVHKENISKLQSLIRGIFTRSCLASIIYSLGKENCNIIQLSACIRGNAVRHKVQSLFAPENNLSETVHDLQGLVRGILVRYTLDLVDDIVEYNNLALFQAFSRGALVRESLDQKSSFYKRNVRSVIMIQSWIRKSLQRSAYLELLDCPNPSLWAVKKFVHLLNGTATIEEVQNQLESCQASLDSENMKKERLLKSIRQQLNINGVLDKFGLLKDKDHELGISDSTIPKSKYQKYEKLFYMLQVDPSYWKLLYLKEPEFVAKNVYMTFGTVNQRMNDRERSYFTRFVCEMLQNAINEAPSIESFLDNRSQFWQTILQDFLRRESPEFFSIIVPVLDYLSDPVVDFESDPYKIYQEIHGFSSPQHCSPVDDASTKNKFIDNLRCLWHAIEMVAEIYTRKVHTIPVEIRYLCTKIFCYAADKNIEEIDSLRAISSILVNVFVSEYLVNREYYGYKDSNVQKNNQKIDILMKSLATVFEIKNFDGFLDPLNQYANEIKPHIKDVLYNVLVDPEYEQEGDRLIYLDMVSPSPKLELLTEKVLEISGKFEEYLNEFPEADILHDILEKNLDNSSFPRSGRVTLELDASAYRFLVSDDKMRKIYDQVKRAFVYMMQIEDVDTNLYDLSISTILPQDEPNFANFLEQNPKIRDDPMIQKLKPLKYFTLKNVTLKKIHELESTGTFCSSDNKLQNFLNDIANTIKNPNYAIDYVTQEIYITKETLTKISEMNHSLDIELSRLKKHVDHTIKDFQKAKDFSPVHKSKFGNFKNAVKKVQGRERSELQGMKFKWNTKQLYERGVLKTIRGEKLAELTVKVFGSSGPKFPDIIFKISTSDGSRFGIQMIDKRKGPDKRYSDDVDSFSFKDLIKTQVEPKIETWKLFHSNVVVNNSQLLHLIVSFFYKRNAL');
INSERT INTO proteininfo VALUES ('6325013', 'NP_015081.1','Component of the signal recognition particle (SRP) ribonucleoprotein (RNP) complex that functions in protein targeting to the endoplasmic reticulum (ER) membrane; Srp68p [Saccharomyces cerevisiae]','MVAYSPIIATYGNRAEQFLETDSDFAKYHAKLNKKLQHLRSRCHLVTKDTKKYSSKNKYGEINSEDYDNKTKLIGVLILLHAERDLALAETLKLRARQRGKLKKSEEKVLSTRLKKACKTADKLVNVTQNEQQWITRAQYLAFAKLVHSEYLINGKRFKRKDNAKISNNLALVFAALEHLKNLSLLAEEVVDNIVNKYQYSLKQYAGNLITTPEINNFIVERVQSDENKDDELVKLLLDNGFNMKKITTSTEDQKVTTNINWRSFNAKIIDAEVAQFLEQGLSIHPTQITQYTQRLSKLEKALDRHEFFIANHDDQDDIDEMVENSSENNQIILAYIKYNILLTSISRERDLFTHLWNQWLKLNTSLPSKLTKYKEMERIVKNLTKYLSDIMELPGVYSDDELLSQLDLCKLYFQLFLNTGCLSVLYQSKGRYMEALALYVDAYRRLENKLSEIESLDEILLPANLLSLNSVRSLQKRIENGGNSVITLAEYEKRNHGGSLGKYDLTVIEKLDSKKILPTDIQLKNLFPLKPKMLPIPSKPTLFDLAFNYITYDKQEPSASQVKDSVTETESISQTPISNEQTEGEPKKKRGFLGLFGR');
INSERT INTO proteininfo VALUES ('6325012', 'NP_015080.1','Protein with a role in UDP-galactose transport to the Golgi lumen, has similarity to human UDP-galactose transporter UGTrel1, exhibits a genetic interaction with S. cerevisiae ERO1; Hut1p [Saccharomyces cerevisiae]','MAGSTSSLVICAIGIYATFLTWALVQEPLATRTWPNSMGKFQFPNVISLIQASVAMMMGYLYLNWKKVEYPPRKMIKDHWKQLMLISFTQSSSGPLATTSLKHVDYLTYMLAKSCKMIPVLLVHLLLYRTPIASQKKVVALLVSLGVTIFTIGGNDGKKLKRSFNESGNDNKLQGFGLLFSSLFLDGLTNATQDKLLKANKAKEKGKQTLITGAHLMFTLNLFVILWNILYFIVIDCKQWDNAVSVLTMDPQVWGYLMLYSFCGAMGQCFIFYTLEQFGSLVLIMITVTRKMVSMILSIIVFGKSVRFQQWVGMFIVFGGITWEALNKKKANIPKAKSA');
INSERT INTO proteininfo VALUES ('6325011', 'NP_015079.1','Hypothetical ORF; Ypl245wp [Saccharomyces cerevisiae]','MHGPTSKAISRNVRSVKRPRRAPRPVVSTQAMNKLSNVTLSAEQEKLRERVLSFMRSNLSQYKSDWKHPAMFVIQGDAGTGKSVILNSLFNEIQKLSQFSPSSEDILHGTHNYLVVNHPEMLKLYIRISDSFKYISKSSLERPTSLINNLQKRKVMADVVIVDEAHLLATSKDAFKRFYGENHLKDLMSLCKVLVLVYDDKQALRMGSYWDEGSNNGATLKDFYNEIPPKSRDWYTLKQQFRVAAPQNVLNWIDQISVAGKIPPIESVLSKGNADCADDKIKNFDFKIWDDCGAMYEAIKEKDRQYGQCRMLSTYDFPYRLDGKDYYVECGDNFKVRWDRYTPREVTPWSERCDTIDEVGSVYTIQGFDLNYAGVILGRSIGYDAANDCIKLRPELYDDRAGFTKKKNIHNAEDVKQKIIMNSINVLLTRGVRGLYVYAYDPELRERLLRPSKK');
INSERT INTO proteininfo VALUES ('6325010', 'NP_015078.1','homologous to RBD1; Rbd2p [Saccharomyces cerevisiae]','MNWKSYVFPGGHPPAALTTGLVVFLTAIYLLSFIFALREDLSLAPESLFKLQMSRLSLYPLIHLSLPHLLFNVLAIWAPLNLFEETHGTVYTGVFLNLSALFAGILYCLLGKLLYPEALVAGASGWCFTLFAYYSFKESQIRPRTRIFRTDYSIPTLYTPLVLLVAIAVVIPGSSFWGHFFGLCVGYAIGYKESWFNKITPPGWIITKIEKSLDGLIRLIPWGIKYYRDEDIDRTKDYEPLMSTETPLPLHNDNSGTVLGTA');
INSERT INTO proteininfo VALUES ('6325009', 'NP_015077.1','Hypothetical ORF; Ypl247cp [Saccharomyces cerevisiae]','MDPFHNGNKRSSISFGSSQRQPYNKNNYLSGTNGPSSAAQDQGRGPSPFGMSGNTTNGGNSKRNSGCDLSATYYASRSPMYSPLDFSPPVFSPNHSQLQQARGYAANIPVVSNLMNPSMASVCEYQSHYPLFGLDWSADDYVCLGSYKEDSRNKLQVLHSNDLLSWESVVDADVVYPVSKIQWVPSQLYPRKLATCSDSLRIWSVSPEERQFQEQINLSLCKYNRQHPANPAAADDMKVIGTFPPITSFDWNTVDTNLIISSSIDTTCIVWDLQSSHYVKTQLIAHDSEVFDVRFLTKSTQLFASCGGDGSVRVFDLRSLAHSTIIYEPPSSSVSGATAGTITPSSKGSDALLRLEPSPYDPNVLATFAADSNKIIILDMRNPESPILNLQGHGSSVNGIKWHPTKRNVLLSCGDDCQVLYWDLNSSFMEINAAGSKSPSIHGTSLEDPDGDTEMTDGGAGSGLNEDPLSLNNNSKQVCKTLETPNMMYANKTQEINNIAWRPQRGDWFGCVSGKKFQNVRVL');
INSERT INTO proteininfo VALUES ('6325008', 'NP_015076.1','DNA-binding transcription factor required for the activation of the GAL genes in response to galactose; repressed by Gal80p and activated by Gal3p; Gal4p [Saccharomyces cerevisiae]','MKLLSSIEQACDICRLKKLKCSKEKPKCAKCLKNNWECRYSPKTKRSPLTRAHLTEVESRLERLEQLFLLIFPREDLDMILKMDSLQDIKALLTGLFVQDNVNKDAVTDRLASVETDMPLTLRQHRISATSSSEESSNKGQRQLTVSIDSAAHHDNSTIPLDFMPRDALHGFDWSEEDDMSDGLPFLKTDPNNNGFFGDGSLLCILRSIGFKPENYTNSNVNRLPTMITDRYTLASRSTTSRLLQSYLNNFHPYCPIVHSPTLMMLYNNQIEIASKDQWQILFNCILAIGAWCIEGESTDIDVFYYQNAKSHLTSKVFESGSIILVTALHLLSRYTQWRQKTNTSYNFHSFSIRMAISLGLNRDLPSSFSDSSILEQRRRIWWSVYSWEIQLSLLYGRSIQLSQNTISFPSSVDDVQRTTTGPTIYHGIIETARLLQVFTKIYELDKTVTAEKSPICAKKCLMICNEIEEVSRQAPKFLQMDISTTALTNLLKEHPWLSFTRFELKWKQLSLIIYVLRDFFTNFTQKKSQLEQDQNDHQSYEVKRCSIMLSDAAQRTVMSVSSYMDNHNVTPYFAWNCSYYLFNAVLVPIKTLLSNSKSNAENNETAQLLQQINTVLMLLKKLATFKIQTCEKYIQVLEEVCAPFLLSQCAIPLPHISYNNSNGSAIKNIVGSATIAQYPTLPEENVNNISVKYVSPGSVGPSPVPLKSGASFSDLVKLLSNRPPSRNSPVTIPRSTPSHRSVTPFLGQQQQLQSLVPLTPSALFGGANFNQSGNIADSSLSFTFTNSSNGPNLITTQTNSQALSQPIASSNVHDNFMNNEITASKIDDGNNSKPLSPGWTDQTAYNAFGITTGMFNTTTMDDVYNYLFDDEDTPPNPKKE');
INSERT INTO proteininfo VALUES ('6325007', 'NP_015075.1','GTPase-activating protein (GAP) for yeast Rab family members; Ypt1p is the preferred in vitro substrate but also acts on Sec4p; involved in ER to Golgi trafficking; interacts with the yeast amphiphysins, Rvs161p and Rvs167p; Gyp5p [Saccharomyces cerevisiae]','MSSDKSIEKNTDTIASEVHEGDNHSNNLGSMEEEIKSTPSDQYEEIAIIPTEPLHSDKELNDKQQSLGHEAPTNVSREEPIGISGDEDTQITEQNVNEQRQETREPSSEIDLNEPLDVEKDVTTDVQAPNGLNIEKEYDAVKENEKVYADTKEVVSSPENREVTGKNSGGEKSSSSKFLDDESGTTTAANANDISISSEVTPERSSENDNNQIHITNEVAAGINLNENKEQKAAIEDGPVTAENLSSETARKVPPIPTQIINEKGDNSSENEVSAIPTTSSPPLPPRQNVATSTSPKLPPRGKQREQPPKTKNAVPPPLEEEMKSEKFRKNFEETKRNSYHHVPLTGSKTAQLESTAEINLIASRYRKTSHHLNKEGEETRESLQEGQSFLKSTFTSFLENLSEYNEVENVNEEDREMFKIDWSFWTQVVNDYATVASNEPENLEAHVTNGIPPQIRGIIWQLMANSKSREMEDIYETLLDTECLHEATIRRDLRRTKFVAEDKMESLYKVIKVYSVYDPDVGYTQGMGFIAAPLLINCENEAESFGLLVGLMKNYGLRELFLPGMPGLMLMLYQFDRLLEEHSPSLYNRLIREGISSTMYATQWFLTFFAYKFPLEFVLRIFDIVFVEGIEVLLKFAVNLMLKNEETLVKLRFDELLDFLKDELFNYYLMGNQDDASVVQMGLSNGNSFKGNDDGTFSYNVDLFVHDAMTGVYITPLTLRRYRGEYVEIHEKEQKKEDHYESLRIQNHQLQREAQKLEHDYSILNKENISAANELIQNRLNMEMLLDEKNDLINTITDIKSQIEEEIRKQNLPNPDASLPKADLREDLERTISRNNEVMRENGQLEERITELQAEIDELININKEQVSTASLLERDSKAKGRKGWTGFKKVFK');
INSERT INTO proteininfo VALUES ('6325006', 'NP_015074.1','Protein component of the large (60S) ribosomal subunit, nearly identical to Rpl36Bp and has similarity to rat L36 ribosomal protein; binds to 5.8 S rRNA; Rpl36bp [Saccharomyces cerevisiae]','MAVKTGIAIGLNKGKKVTQMTPAPKISYKKGAASNRTKFVRSLVREIAGLSPYERRLIDLIRNSGEKRARKVAKKRLGSFTRAKAKVEEMNNIIAASRRH');
INSERT INTO proteininfo VALUES ('6325005', 'NP_015073.1','Protein that interacts with the cytoskeleton and is involved in chromatin organization and nuclear transport, interacts genetically with TCP1 and ICY1; potential Cdc28p substrate; Icy2p [Saccharomyces cerevisiae]','MSSVESSPISRYEDEVFPLSFSNVAFEPPMLSHSPDRSTYADDFSQSYQQELLTFPLSYPIVDESECTHTKDKTDSNIITSTEDDCMFDMEFNGNAASAVAAASKESNSASGFAFASNDAFANVAQQNYRLWLSSV');
INSERT INTO proteininfo VALUES ('6325004', 'NP_015071.1','Iron-sulfur protein of the mitochondrial matrix, homologous to human adrenodoxin; involved in heme a biosynthesis; Yah1p [Saccharomyces cerevisiae]','MLKIVTRAGHTARISNIAAHLLRTSPSLLTRTTTTTRFLPFSTSSFLNHGHLKKPKPGEELKITFILKDGSQKTYEVCEGETILDIAQGHNLDMEGACGGSCACSTCHVIVDPDYYDALPEPEDDENDMLDLAYGLTETSRLGCQIKMSKDIDGIRVALPQMTRNVNNNDFS');
INSERT INTO proteininfo VALUES ('6325002', 'NP_015070.1','Protein that forms a complex with Kar3p at the spindle pole body, possible regulator of Kar3p function in microtubule-mediated processes; required for sister chromatid cohesion; has similarity to Cik1p; Vik1p [Saccharomyces cerevisiae]','MASQQNKHAFLSKNRIFHNPDNVSSSKSRNLMDITNTTNTMNGSRPSSMKSSLALPPVKDSFPSVSRSASLNINMSKIKDLKDRQDKIRFQRHTLRTQLIECEREIKTIKFRDLNKSRFELYKKKSKQAKYLKQVRDLTQNLNSKDGERADLIKKNKSALATLQAELDQNLILKRQESQELYNNKLIFWENELQIMENVEPDHEITEEISQLKKTLQELNINWANLQKQNLERQVNHESQLRKDFIAFKEAKLKSMENLTNKHRELLDQIATLQSESEKLHKEIMDIDRQAEYSEQNISEINENIKQLELANNPLISKSLQNSQDLEHLQNQMENLKEMASKQEKFYNDTYNTVEKELLRSRRLENSIIEQKGTMRCYAYVMEQNLPENLLFDYENGVITQGLSEHVYKFNRVIPHLKVSEDKFFTQEYSVYHDMCLNQKKNFNLISLSTTPHGSLRESLIKFLAEKDTIYQKQYVITLQFVFLSDDEFSQDMLLDYSHNDKDSIKLKFEKHSISLDSKLVIIENGLEDLPLNFSCDEHPNLPHSGMGIIKVQFFPRDSKSDGNNDPVPVDFYFIELNNLKSIEQFDKSIFKKESCETPIALVLKKLISDTKSFFLLNLNDSKNVNKLLTISEEVQTQLCKRKKKLT');
INSERT INTO proteininfo VALUES ('6325001', 'NP_015069.1','Adaptor protein required for structural integrity of the SAGA complex, a histone acetyltransferase-coactivator complex that is involved in global regulation of gene expression through acetylation and transcription functions; Hfi1p [Saccharomyces cerevisiae]','MSAIQSPAPKPLQPTYPAASPASTNAYMKPGLIGSPAVSNHTEPNNGNNETAEPQGPNQRIDLGAMIEELTSLLGKESWTKYAQIISLFILGKLSRKELSNELELVFSPSAASLEKSNTNHHHSLVRLHNQLLLGIFANSLRENPLGRNGNESSWGFGNGSNNPNNKLKRINKHNSQIEVYKKIVMSLPLNDRNRLKMITKEAGKRGFIFCSVFQARLNNIPKIPIVTNPESLKRVKSNNLKTPLEWSQDIMNGFNVPLASESHSLPDTDSFYLRMVGIAREHGLVGTVDARCVELISLALDQYLKNIIEFTIDTVRYRRKKYSDYYDLNESGLYKSVSEMAADKRDAKIKQLDDDKNEDECADEAKSINNGNNSSKDDIGDISMSSITKAGEAVNEELHENRTISLTNEDIYDSLSIFPNLVEPSGSYYALTNLGLVNDDELVDMKSNIDDLPDFLNEKPTFTPLDERNVGTRHELNWLIKGILTED');
INSERT INTO proteininfo VALUES ('6325000', 'NP_015068.1','Protein required for the spindle pole body (SPB) duplication, localized at the central plaque periphery; forms a complex with a nuclear envelope protein Mps2p and SPB components Spc29p and Kar1p; required for mitotic functions of Cdc5p; Bbp1p [Saccharomyces cerevisiae]','MNQEDNTGGGGIFGLFKWTKDALFGTDISPSMKYKDQEERRDRSRYAQDDTNFSMKFGNDSNRRSTNLSRSNSWSGLDSTLHRKYELLPEYNENGFNSIVNGDHHSKERIRSLRSPAPIVPREPLRNEPTDTFGHRLHTKRRTINELSNSQIPFIPPQEDDPLLSKLFNKDGVNEVRRSPYKLSVKDIPGKFPSPLTKRDEIDNYYVRDEDACHKNREYKKAYFDLFAQMDLNSRDLEDLCEDVREQREQFHRNEQTYKQAYEEMRAELVNELKKSKTLFENYYSLGQKYKSLKKVLDQTISHEAELATSRERLYQEEDLKNFEIQTLKQRLSDLELKYTNLQIEKDMQRDNYESEIHDLLLQLSLRNNERKDTSAGSNIFSTGQ');
INSERT INTO proteininfo VALUES ('6324999', 'NP_015067.1','role in cell cycle START; G(sub)1 cyclin; Cln2p [Saccharomyces cerevisiae]','MASAEPRPRMGLVINAKPDYYPIELSNAELLSHFEMLQEYHQEISTNVIAQSCKFKPNPKLIDQQPEMNPVETRSNIITFLFELSVVTRVTNGIFFHSVRLYDRYCSKRIVLRDQAKLVVATCLWLAAKTWGGCNHIINNVVIPTGGRFYGPNPRARIPRLSELVHYCGDGQVFDESMFLQMERHILDTLNWNIYEPMINDYVLNVDENCLMQYELYENQVTYDKQCSEKRQSQLSQDSDATVDERPYQNEEEEEEDLKLKIKLINLKKFLIDVSAWQYDLLRYELFEVSHGIFSIINQFTNQDHGPFLMTPMTSESKNGEILSTLMNGIVSIPNSLMEVYKTVNGVLPFINQVKEYHLDLQRKLQIASNLNISRKLTISTPSCSFENSNSTSIPSPASSSQSHTPMRNMSSLSDNSVFSRNMEQSSPITPSMYQFGQQQSNSICGSTVSVNSLVNTNNKQRIYEQITGPNSNNATNDYIDLLNLNESNKENQNPATAHYLNGGPPKTSFINHGMFPSPTGTINSGKSSSASSLISFGMGNTQVI');
INSERT INTO proteininfo VALUES ('6324998', 'NP_015066.1','Hypothetical ORF; Ypl257wp [Saccharomyces cerevisiae]','MTAHANERISDVSPSARGSSSESKYDKLCRVLFFIAITKSSFTPEHILYKHSIFTDKPILADIVTFMYAAFVSIGWFLIWGERAYRTQEMGQPPMYSNINYHLLSFKKRHPKKFTCALWLVFFLAYTVLTVLIWLVQLIFRKGNVFQMLLQLIILDIAIALVNVAIAFTFEIYLSQKAAIEIRDEGLNNLDTA');
INSERT INTO proteininfo VALUES ('6324997', 'NP_015065.1','Hydroxymethylpyrimidine phosphate kinase, involved in the last steps in thiamine biosynthesis; member of a gene family with THI20 and THI22; functionally redundant with Thi20p; Thi21p [Saccharomyces cerevisiae]','MTYSTVNINTPPPYLALASNEKLPTVLSIAGTDPSGGAGVEADVKTITAHRCYAMTCITALNAQTPVKVYSINNTPKEVVSQILDANLQDMKCDVIKTGMLTTAAIEVLHEKLLQLGENRPKLVVDPVLVATSGSSLAGKDIASLITEKIAPFADILTPNIPECFKLLGEDREISKLRDIFEVAKDLAKITKCSNILVKGGHIPWNDEEGKYITDVLYLGAEQRFITFKGNFVNTTHTHGTGCTLASAIASNLARGYSLPQSVYGGIEYVQNAVAIGCDVTKETVKDNGPINHVYAIEIPLEKMLSDECFTASDAVHKKPVKSSLNKIPGGSFYKYLINHPKVKPHWDSYVNHDFVRKVADGSLEPKKFQFFIEQDYLYLVNYARISCIAGSKSPCLEDLEKELVIVECVRNGLCQHERRLREEFGIKDPDYLQKIQRGPALRAYCRYFNDVSRRGNWQELVIALNPCLMGYVHALTKIKDEVTAAEGSVYREWCETYSSSWCHEAMLEGEKLLNHILETYPPEKLDTLVTIYAEVCELEANFWTAALEYE');
INSERT INTO proteininfo VALUES ('6324996', 'NP_015064.1','medium subunit of the clathrin-associated protein complex; Apm1p [Saccharomyces cerevisiae]','MASAVYFCDHNGKPLLSRRYRDDIPLSAIDKFPILLSDLEEQSNLIPPCLNHNGLEYLFIQHNDLYVVAIVTSLSANAAAIFTFLHKLVEVLSDYLKTVEEESIRDNFVIIYELLDEVMDYGIPQITETKMLKQYITQKSFKLVKSAKKKRNATRPPVALTNSVSWRPEGITHKKNEAFLDIVESINMLMTQKGQVLRSEIIGDVKVNSKLSGMPDLKLGINDKGIFSKYLDDDTNIPSASATTSDNNTETDKKPSITSSSATNKKKVNIELEDLKFHQCVRLSKFENEKIITFIPPDGKFDLMNYRLSTTIKPLIWCDVNVQVHSNSRIEIHCKAKAQIKRKSTATNVEILIPVPDDADTPTFKYSHGSLKYVPEKSAILWKIRSFPGGKEYSMSAELGLPSISNNEDGNRTMPKSNAEILKGPVQIKFQIPYFTTSGIQVRYLKINEPKLQYKSYPWVRYITQSGDDYTIRLT');
INSERT INTO proteininfo VALUES ('6324994', 'NP_015063.1','Hypothetical ORF; Ypl260wp [Saccharomyces cerevisiae]','MFASAGQQHPQIVPKEEESILNYLLEVRSSLAKLKQNRTQYLNSKDVQTTYQHVLTKVRELDDIRKNSHETPAKSAATLIHSTELHNRVDSVLDDVFQLLSLCFLTVGLKNSAPATYASLSTVESLLEHLNESNVFTHHDLSPIKERLEEISKIVEQKNSSPAYDEDGNDDRLREIDNERKKNKIEEDLLLRAKLKHCKDEYDILEGKLEEIDPSLSTVMEKLFRIRRGLLSLVASAKKTMSKSDINTNSLLQEQNDLQTNNESLTDDKHLVSQEYVHEKLSVLKNELSELESNRDDSGKFKSLESHQVAEKGQSVLNGLLDDCHDLVNDLSHQKNGGLTLDPYLQPIYEQLIDIKTTLENLMITRRWTLRETDLFSYQKKLNEIDNKRINGKFPTKSQDSKGQSILLYLLRRCYAIIYKLLESSEPVSEALQPIHNQLSTVRRCLLELKRMGGVNNERELYPYQMKLASLDNLRTEGIFYDSDGNIPEGQGILNALLAECFDILHELKVEAEEKAQNSTSSDGSDDDDNGESGIDSNSNDSEPESEYQQE');
INSERT INTO proteininfo VALUES ('6324993', 'NP_015061.1','Fumarase, converts fumaric acid to L-malic acid in the TCA cycle; cytosolic and mitochondrial localization determined by the N-terminal mitochondrial targeting sequence and protein conformation; Fum1p [Saccharomyces cerevisiae]','MLRFTNCSCKTFVKSSYKLNIRRMNSSFRTETDAFGEIHVPADKYWGAQTQRSFQNFKIGGARERMPLPLVHAFGVLKKSAAIVNESLGGLDPKISKAIQQAADEVASGKLDDHFPLVVFQTGSGTQSNMNANEVISNRAIEILGGKIGSKQVHPNNHCNQSQSSNDTFPTVMHIAASLQIQNELIPELTNLKNALEAKSKEFDHIVKIGRTHLQDATPLTLGQEFSGYVQQVENGIQRVAHSLKTLSFLAQGGTAVGTGLNTKPGFDVKIAEQISKETGLKFQTAPNKFEALAAHDAIVECSGALNTLACSLFKIAQDIRYLGSGPRCGYHELMLPENEPGSSIMPGKVNPTQNEALTQVCVQVMGNNAAITFAGSQGQFELNVFKPVMIANLLNSIRLITDAAYSFRVHCVEGIKANEPRIHELLTKSLMLVTALNPKIGYDAASKVAKNAHKKGITLKESALELGVLTEKEFDEWVVPEHMLGPK');
INSERT INTO proteininfo VALUES ('6324992', 'NP_015060.1','Kelch-repeat protein, similar to Kel1 and Kel2; Kel3p [Saccharomyces cerevisiae]','MAKKNKKDKEAKKARAELKNQKNQKKQEKKFQKNKNKSLNGEEDDESDQDLDEILSSFSKKQIELEHVDITSVEKPSCRTHPLMFANPQHNKHELFIFGGEFTDPETKLTHFYNDLYSYSIKNNSWKKYVSQNAPLPRSSAAVAVHPSGIALLHGGEFSSPKQSKFYHYSDTWLFDCVERKFTKLEFGGRDSSPSARSGHRIIAWKNYFILFGGFRDLGNGQTSYLNDLWCFDISTYKWTKLETNSKPDARSGHCFIPTDNSAILMGGYCKIIAKNNKNLMKGKILNDAWKLNLTPDPKKWQWEKLKNFKNQPSPRVGYSFNLWKQNKSVAFGGVYDLQETEESLESVFYNDLYMFHLELNKWSKLRIKPQRQTNSKNSPATSKRKSNKDQEKELQDLLNSILAKSNLNDDDDDNDDNSTTGPNSIDDDEDNEDDSDLDNQEDITISNQLPHPRFNAATCVVGDSLFIYSGVWELGEKDYPINSFYSIDLNKLDGVKVYWEDLSAIEEAKRLGDRDSDEDEFEYEDDEEDEDDGEEEQDAGPLEGDEDEESESDDDKQAQMEIPDERSWLPHPKPFETLRAFYLREGANFLTWSISNNRNLKGKQLKTKSFELCEDRWWERRDQVTLEEERLEDTGGIIERDTTTKPSKRR');
INSERT INTO proteininfo VALUES ('6324991', 'NP_015059.1','Hypothetical ORF; Ypl264cp [Saccharomyces cerevisiae]','MTLQRISKDYLKPNYGLILLIVSYFFNSSMVVSTKVLENDPLETSQSRINPLQILLVRMSITYCCTLVYMHWNKQSVPDIPWGPAPCRKWLILRGIMGFFGVFGMYFSLMYLSISDAVLITFMSPTLTIFLSFLLLGEPFSKLEALGSLISFSGVVLIIRPTFLFGEQTQGQQSPQDDIVETQNPKLRLIAIGVSLLGVCGLSSVYIIIRYIGNKAHAIMSVSYFSLVTTVVAALGVLLIPSMSLQLPHSWKQWGLFLNLGISGFIHQILLTMGIQRERAGRGSLMTYTQVIYAVFWDVVLFHHWPNIWTWCGMAVIVSSTIWVINMRASKQNVVATAELLSTSDFELDDLED');
INSERT INTO proteininfo VALUES ('6324990', 'NP_015058.1','Dicarboxylic amino acid permease, mediates high-affinity and high-capacity transport of L-glutamate and L-aspartate; also a transporter for Gln, Asn, Ser, Ala, and Gly; Dip5p [Saccharomyces cerevisiae]','MKMPLKKMFTSTSPRNSSSLDSDHDAYYSKQNPDNFPVKEQEIYNIDLEENNVSSRSSTSTSPSARDDSFAVPDGKDENTRLRKDLKARHISMIAIGGSLGTGLLIGTGTALLTGGPVAMLIAYAFVGLLVFYTMACLGEMASYIPLDGFTSYASRYVDPALGFAIGYTYLFKYFILPPNQLTAAALVIQYWISRDRVNPGVWITIFLVVIVAINVVGVKFFGEFEFWLSSFKVMVMLGLILLLFIIMLGGGPNHDRLGFRYWRDPGAFKEYSTAITGGKGKFVSFVAVFVYSLFSYTGIELTGIVCSEAENPRKSVPKAIKLTVYRIIVFYLCTVFLLGMCVAYNDPRLLSTKGKSMSAAASPFVVAIQNSGIEVLPHIFNACVLVFVFSACNSDLYVSSRNLYALAIDGKAPKIFAKTSRWGVPYNALILSVLFCGLAYMNVSSGSAKIFNYFVNVVSMFGILSWITILIVYIYFDKACRAQGIDKSKFAYVAPGQRYGAYFALFFCILIALIKNFTVFLGHKFDYKTFITGYIGLPVYIISWAGYKLIYKTKVIKSTDVDLYTFKEIYDREEEEGRMKDQEKEERLKSNGKNMEWFYEKFLGNIF');
INSERT INTO proteininfo VALUES ('6324989', 'NP_015057.1','Essential 18S rRNA dimethylase, responsible for conserved m6(2)Am6(2)A dimethylation in 3'-terminal loop of 18 S rRNA, part of 90S and 40S pre-particles in nucleolus, involved in pre-ribosomal RNA processing; Dim1p [Saccharomyces cerevisiae]','MGKAAKKKYSGATSSKQVSAEKHLSSVFKFNTDLGQHILKNPLVAQGIVDKAQIRPSDVVLEVGPGTGNLTVRILEQAKNVVAVEMDPRMAAELTKRVRGTPVEKKLEIMLGDFMKTELPYFDICISNTPYQISSPLVFKLINQPRPPRVSILMFQREFALRLLARPGDSLYCRLSANVQMWANVTHIMKVGKNNFRPPPQVESSVVRLEIKNPRPQVDYNEWDGLLRIVFVRKNRTISAGFKSTTVMDILEKNYKTFLAMNNEMVDDTKGSMHDVVKEKIDTVLKETDLGDKRAGKCDQNDFLRLLYAFHQVGIHFS');
INSERT INTO proteininfo VALUES ('6324988', 'NP_015056.1','Protein of unknown function, potential Cdc28p substrate; Ypl267wp [Saccharomyces cerevisiae]','MISPSKKRTILSSKNINQKPRAVVKGNELRSPSKRRSQIDTDYALRRSPIKTIQISKAAQFMLYEETAEERNIAVHRHNEIYNNNNSVSNENNPSQVKENLSPAKICPYERAFLREGGRIALKDLSVDEFKGYIQDPLTDETIPLTLPLGDKKISLPSFITPPRNSKISIFFTSKHQGQNPETKISRSTDDVSEKKVVRKLSFHVYEDE');
INSERT INTO proteininfo VALUES ('6324987', 'NP_015055.1','Phosphoinositide-specific phospholipase C, hydrolyzes phosphatidylinositol 4,5-biphosphate (PIP2) to generate inositol 1,4,5-triphosphate (IP3) and 1,2-diacylglycerol (DAG); affects kinetochore function possibly by modulating the structure of centromeric chromatin; Plc1p [Saccharomyces cerevisiae]','MTESAIDDQRFNLTKELQRHSCRDQGKITQKDDALDFISYSSFQSSFNTDQKSANNGSTVRRSIRSIFRRAAELPRVHMGPLTYSHGINELVNKKLRKDCDLSTLCRVLQRGIRMIRMTRRRRKFYEFKLINNNGQIIWKDGSKYLELDSVKDIRIGDTASTYQEEVDPKRLRSDSKLWIAIIYKVSNKLKALHVVALNELDFNTFLSCICGLVKLRRELMESILLPDNSQFARIHWQITVSEKEEDEKKDTLSFADVKKLCDKFHIYVSTGQLLEFFQLADINHNGLLNYFEFEKFIKILKNRKEVNMIWSKFTKPPHSHLSFENFFQFLITEQHEQVDRQTAWSYFIKYREPTQLTMGQDGFTKFLKEQPYLVEVKEELYSKPLNHYFIASSHNTYLLGKQIAETPSVEGYIQVLQQGCRCVEIDIWDGENGPVVCHGFLTSAIPLKTVIRVIKKYAFITSPYPLIISLEINCNKDNQKLASLIMREVLAEQLYFVGTRTDKLPSPRELKHKILLKSKKTSEATRGLSVNEPFPSSFSSSYESANEQELRMKDDSTNSSSATNSSSMQRIKRIGLKKHADIINDVSNISGIHGIKFRNFSLPESKTIAHCFSLNERKVEYMIKDKHLKLSLDKHNRRYLMRVYPHVLRYKSSNFNPIPFWKAGVQMVATNWQTNDIGQQLNLAMFQILDHQPDGSFKSGYVLKPKKLLPVVTKAKMIPLIYEHFENGSDPVTVKIRILSTQLLPRLNDTSPSRNNTNSFVKVEFHTDDEPTMPISIDKGTRISATEASTKSSQGNGFNPIWDAEVSITLKDTDLTFIKFMVISEETQIASVCLKLNYLRMGYRHIPLFNMEGEQYIFCTLFIHTQIL');
INSERT INTO proteininfo VALUES ('6324986', 'NP_015054.1','Karyogamy protein required for correct positioning of the mitotic spindle and for orienting cytoplasmic microtubules, localizes at the shmoo tip in mating cells and at the tip of the growing bud in small-budded cells through anaphase; Kar9p [Saccharomyces cerevisiae]','MDNDGPRSMTIGDDFQENFCERLERIHNTLHSINDCNSLNESTTSISETLLVQFYDDLENVASVIPDLVNKKRLGKDDILLFMDWLLLKKYMLYQFISDVHNIEEGFAHLLDLLEDEFSKDDQDSDKYNRFSPMFDVIEESTQIKTQLEPWLTNLKELLDTSLEFNEISKDHMDTLHKIINSNISYCLEIQEERFASPIRHTPSFTLEQLVKLLGTHTETTEPKVPKFSPAEDILSRKFLNLKKNIPPIEKSLTDILPQRIVQFGHRNITNITTLQTILQKKYELIMKDYRFMNSEFRELKVELIDKRWNILFINLNHELLYILDEIERLQSKLLTTKYTKDITIRLERQLERKSKTVSKTFNIIYRALEFSLLDAGVASKTNELAQRWLNIKPTADKILIKSSASNKIATSKKKIPKPKSLGFGRPNSVIGTITQDFQERVAINEGDSNKTPENSTTVALKGKKLGKALLQKMNIKPATSPNSSNAINPFFDPESPNKGKLILSSVPPLPYDETDETTLRVSRGENEKSPDSFITSRHENKVQITETPLMAKNKSVLDIEKDKWNHYRSLPSRIPIYKDKVVKVTVENTPIAKVFQTPPTKITTPNSQVWVPSTRRRTRLRPPTPLSQLLSPREGRLDKTPTY');
INSERT INTO proteininfo VALUES ('6324984', 'NP_015052.1','Epsilon subunit of the F1 sector of mitochondrial F1F0 ATP synthase, which is a large, evolutionarily conserved enzyme complex required for ATP synthesis; Atp15p [Saccharomyces cerevisiae]','MSAWRKAGISYAAYLNVAAQAIRSSLKTELQTASVLNRSQTDAFYTQYKNGTAASEPTPITK');
INSERT INTO proteininfo VALUES ('6324983', 'NP_015051.1','Hypothetical ORF; Ypl272cp [Saccharomyces cerevisiae]','MTTFRPLSSFEKKILTQSLNDQRNGTIFSSTYSKSLSRENDADWHSDEVTLGTNSSKDDSRLTLPLIATTLKRLIKSQPALFATVNEEWEFEPLKQLKTSDIVNVIEFETIKDKEVNCHWGVPPPYLLRHAFNKTRFVPGSNKPLWTLYVIDEALLVFHGHDVLFDIFSAANFHKLFLKELNEISTVTHSEDRILFDVNDINLSELKFPKSIYDSAKLHLPAMTPQIFHKQTQSFFKSIYYNTLKRPFGYLTNQTSLSSSVSATQLKKYNDILNAHTSLCGTTVFGIVNNQRFNYLKSIVNQEHICLRSFICGIAMICLKPLVKDFSGTIVFTIPINLRNHLGLGGSLGLFFKELRVECPLSLIDDELSANEFLTNSNDNEDNDDEFNERLMEYQFNKVTKHVSGFIMAKLRSWEKNGFNDDDIRRMKYDNDDDFHIQNSRTKLIQINDVSDISLSMNGDDKSFKIVSTGFTSSINRPTLMSLSYTYCEEMGLNICIHYPDSYNLESFVECFESFIE');
INSERT INTO proteininfo VALUES ('6324982', 'NP_015050.1','AdoMet-homocysteine methyltransferase; S-adenosylmethionine:homocysteine S-methyltransferase; Sam4p [Saccharomyces cerevisiae]','MARLPLKQFLADNPKKVLVLDGGQGTELENRGIKVANPVWSTIPFISESFWSDESSANRKIVKEMFNDFLNAGAEILMTTTYQTSYKSVSENTPIRTLSEYNNLLNRIVDFSRNCIGEDKYLIGCIGPWGAHICREFTGDYGAEPENIDFYQYFKPQLENFNKNDKLDLIGFETIPNIHELKAILSWDESILSRPFYIGLSVHEHGVLRDGTTMEEIAQVIKDLGDKINPNFSFLGINCVSFNQSPDILESLHQALPNMALLAYPNSGEVYDTEKKIWLPNSDKLNSWDTVVKQYISSGARIIGGCCRTSPKDIQEISAAVKKYT');
INSERT INTO proteininfo VALUES ('6324981', 'NP_015049.1','High affinity S-adenosylmethionine permease; Sam3p [Saccharomyces cerevisiae]','MDILKRGNESDKFTKIETESTTIPNDSDRSGSLIRRMKDSFKQSNLHVIPEDLENSEQTEQEKIQWKLASQPYQKVLSQRHLTMIAIGGTLGTGLFIGLGYSLASGPAALLIGFLLVGTSMFCVVQSAAELSCQFPVSGSYATHVSRFIDESVGFTVATNYALAWLISFPSELIGCALTISYWNQTVNPAVWVAIFYVFIMVLNLFGVRGFAETEFALSIIKVIAIFIFIIIGIVLIAGGGPNSTGYIGAKYWHDPGAFAKPVFKNLCNTFVSAAFSFGGSELVLLTSTESKNISAISRAAKGTFWRIAIFYITTVVIIGCLVPYNDPRLLSGSNSEDVSASPFVIALSNTGSMGAKVSNFMNVVILVAVVSVCNSCVYASSRLIQALGASGQLPSVCSYMDRKGRPLVGIGISGAFGLLGFLVASKKEDEVFTWLFALCSISSFFTWFCICMSQIRFRMALKAQGRSNDEIAYKSILGVYGGILGCVLNALLIAGEIYVSAAPVGSPSSAEAFFEYCLSIPIMIVVYFAHRFYRRDWKHFYIKRSEIDLDTGCSVENLELFKAQKEAEEQLIASKPFYYKIYRFWC');
INSERT INTO proteininfo VALUES ('6324978', 'NP_015046.1','Hypothetical ORF; Ypl277cp [Saccharomyces cerevisiae]','MRFHRQGISAIIGVLLIVLLGFCWKLSGSYGIVSTALPHNQSAIKSTDLPSIRWDNYHEFVRDIDFDNSTAIFNSIRAALRQSPSDIHPVGVSYFPAVIPKGTLMYHAGSKVPTTFEWLAMDHEFSYSFGLRSPSYGRKSLERRHGRFGNGTNGDHPKGPPPPPPPPDEKGRGSQKMLTYRAARDLNKFLYLDGASAAKTDSGEMDTQLMLSNVIKEKLNLTDDGENERMAERLYAARICKWGKPFGLDGIIRVEVGFEVVLCDFSADNVELVSMLEMVQPNQYLGLPAPTVISKEEGWPLDENGSLVEDQLTDDQKAILEREDGWEKAFSNFNAVKSFNQLRAGAAHDNGEHRIHIDYRYLVSGINRTYIAPDPNNRRLLDEGMTWEKQLDMVDDLEKALEVGFDATQSMDWQLAFDELVLKFAPLLKSVSNILNSDGDINESIAINATALTLNFCLPICEPIPGLKNGCRLFDLVICCQRCRRNC');
INSERT INTO proteininfo VALUES ('6324977', 'NP_015045.1','Hypothetical ORF; Ypl278cp [Saccharomyces cerevisiae]','MTDNTTSSDLIKNVETARSTIDGLIESLGWIELNYRCERQCNWDEVCYTPSWGPSPMGMTEPGSHNEGFGTHFDESRQRLVINSKLQCININDLMVNRNH');
INSERT INTO proteininfo VALUES ('6324976', 'NP_015044.1','Hypothetical ORF; Ypl279cp [Saccharomyces cerevisiae]','MIFNPVISNHKLSHYIHVFCTFTTFCILGTETRQAITALSTYTPAFVTAPTVLWSNCSSCMLMGIMQSLNAYTWMKDHQVLFLGVTTGYCGALSSFSSMLLEMFEHSTNLTNGNIANHTKLPNRAYGIMEFLSVLLVHLMVSMGSLIFGRQLGKEVIVAYGSSSFSKPYTPPSDTVKENAGDVDTQEMEKNILEFKFKTPAPFFKKFFDVVDKLAYALAFPLIILFVVLCAYYENYSRGKWTLPCLFGIFAGFLRYWLAEMFNKTNKKFPLGTFLANVFATLLIGIFTMVQRGKKHFSTDIPIVNSLNSCHIVSALISGFCGTLSTISTFINEGYKLSFINMLIYYTVSIGISYCLLVITLGSYAWTRGLTNPIC');
INSERT INTO proteininfo VALUES ('6324975', 'NP_015043.1','Possible chaperone and cysteine protease with similarity to E. coli Hsp31 and S. cerevisiae Hsp31p, Hsp33p, and Sno4p; member of the DJ-1/ThiJ/PfpI superfamily, which includes human DJ-1 involved in Parkinson's disease; Hsp32p [Saccharomyces cerevisiae]','MTPKRALISLTSYHGPFYKDGAKTGVFVVEILRSFDTFEKHGFEVDFVSETGGFGWDEHYLPKSFIGGEDKMNFETKNSAFNKALARIKTANEVNASDYKIFFASAGHGALFDYPKAKNLQDIASKIYANGGVIAAICHGPLLFDGLIDIKTTRPLIEGKAITGFPLEGEIALGVDDILRSRKLTTVERVANKNGAKYLAPIHPWDDYSITDGKLVTGVNANSSYSTTIRAINALYS');
INSERT INTO proteininfo VALUES ('6324974', 'NP_015042.1','Protein of unknown function, has similarity to enolases; Err2p [Saccharomyces cerevisiae]','MSITKVHARTVYDSRGNPTVEVEITTENGLFRAIVPSGASTGIHEAVELRDGNKSEWMGKGVTKAVSNVNSIIGPALIKSELCVTNQKGIDELMISLDGTSNKSRLGANAILGVSLCVARAAAAQKGITLYKYIAELADARQDPFVIPVPFFNVLNGGAHAGGSLAMQEFKIAPVGAQSFAEAMRMGSEVYHHLKILAKEQYGPSAGNVGDEGGVAPDIDTAEDALDMIVEAINICGYEGRVKVGIDSAPSVFYKDGKYDLNFKEPNSDPSHWLSPAQLAEYYHSLLKKYPIISLEDPYAEDDWSSWSAFLKTVNVQIIADDLTCTNKTRIARAIEEKCANTLLLKLNQIGTLTESIEAANQAFDAGWGVMISHRSGETEDPFIADLVVGLRCGQIKSGALSRSERLAKYNELLRIEEELGDDCIYAGHRFHDGNKL');
INSERT INTO proteininfo VALUES ('6324973', 'NP_015041.1','Hypothetical ORF; Ypl282cp [Saccharomyces cerevisiae]','MTNEGIGINRDTSTICLREYVFIHFFPVKLISALTNKTNTMVKLTSIAAGVAAIAAGVAAAPATTTLSPSDERVNLVELGVYVSDIRAHLAQYYLFQAAHPTETYPVEIAEAVFNYGDFTTMLTGIPAEQVTRVITGVPWYSTRLRPAISSALSKDGIYTAIPK');
INSERT INTO proteininfo VALUES ('6324972', 'NP_015040.1','Helicase encoded by the Y' element of subtelomeric regions, highly expressed in the mutants lacking the telomerase component TLC1; potentially phosphorylated by Cdc28p; Yrf1-7p [Saccharomyces cerevisiae]','MEIENEQICTCIAQILHLLNSLIITFLDDDKTETGQSFVYIDGFLVKKHNNQHTIVNFETYKNKMKVSDRRKFEKANFDEFESALNNKNDLVHCPSITLFESIPTEVRSFYEDEKSGLIKVVKFRTGAMDRKRSFEKIVVSVMVGKNVQKFLTFVEDEPDFQGGPIPSKYLIPKKINLMVYTLFQVHTLKFNRKDYDTLSLFYLNRGYYNELSFRVLERCYEIASARPNDSSTMRTFTDFVSGTPIVRGLQKSTIRKYGYNLAPYMFLLLHVDELSIFSAYQASLPGEKKVDTERLKRDLCPRKPTEIKYFSQICNDMMNKKDRLGDILHIILRACALNFGAGPRGGAGDEEDRSITNEEPIIPSVDEHGLKVCKLRSPNTPRRLRKTLDAVKALLVSSCACTARDLDIFDDNNGVAMWKWIKILYHEVAQETALKDSYRITLVPSSDGVSVCGKLFNREYVRGFYFACKAQFDNLWEELNDCFYMPTVVDIASLILRNREVLFREPKRGIDEYLENDSFLQMIPVKYREIVLPKLRRDTNKMTAALKNKVTVAIDELTVPLMWMIHFAVGYPYRYPELQLLAFAGPQRNVYVDDTTRRIQLYTDYNKNGSSEPRLKTLDGLTSDYVFYFVTVLRQMQICALGNSYDAFNHDPWMDVVGFEDPDQVTNRDISRIVLYSYMFLNTAKGCLVEYATFRQYMRELPKNAPQKLNFREMRQGLIALGRHCVGSRFETDLYESATSELMANHSVQTGRNIYGVDSFSLTSVSGTTATLLQERASERWIQWLGLESDYHCSFSSTRNAEDVVAGEAASSDHHQKISRVTRKRPREPKSTNDILVAGQKLFGSSFEFRDLHQLRLCHEIYMADTPSVAVQAPPGYGKTELFHLPLIALASKGDVKYVSFLFVPYTVLLANCMIRLSRCGCLNVAPVRNFIEEGCDGVTDLYVGIYDDLASTNFTDRIAAWENIVECTFRTNNVKLGYLIVDEFHNFETEVYRQSQFGGITNLDFDAFEKAIFLSGTAPEAVADAALQRIGLTGLAKKSMDINELKRSEDLSRGLSSYPTRMFNLIKEKSEVPLGHVHKIWKKVESQPEEALKLLLALFEIEPESKAIVVASTTNEVEELACSWRKYFRVVWIHGKLGAAEKVSRTKEFVTDGSMRVLIGTKLVTEGIDIKQLMMVIMLDNRLNIIELIQGVGRLRDGGLCYLLSRKNSWAARNRKGELPPIKEGCITEQVREFYGLESKKGKKGQHVGCCGSRTDLSADTVELIERMDRLAEKQATASMSIVALPSSFQESNSSDRCRKYCSSDEDSDTCIHGSANASTNATTNSSTNATTTASTNVRTSATTTASINVRTSATTTESTNSSTNATTTASTNVRTSATTTASINVRTSATTTESTNSNTSATTTESTDSNTSATTTESTDSNTSATTTASTNSSTNATTTASTNSSTNATTTESTNASAKEDANKDGNAEDNRFHPVTDINKESYKRKGSQMVLLERKKLKAQFPNTSENMNVLQFLGFRSDEIKHLFLYGIDVYFCPEGVFTQYGLCKGCQKMFELCVCWAGQKVSYRRMAWEALAVERMLRNDEEYKEYLEDIEPYHGDPVGYLKYFSVKRGEIYSQIQRNYAWYLAITRRRETISVLDSTRGKQGSQVFRMSGRQIKELYYKVWSNLRESKTEVLQYFLNWDEKKCREEWEAKDDTVFVEALEKVGVFQRLRSMTSAGLQGPQYVKLQFSRHHRQLRSRYELSLGMHLRDQLALGVTPSKVPHWTAFLSMLIGLFCNKTFRQKLEYLLEQISEVWLLPHWLDLANVEVLAADNTRVPLYMLMVAVHKELDSDDVPDGRFDILLCRDSSREVGE');
INSERT INTO proteininfo VALUES ('6324970', 'NP_015039.1','Hypothetical ORF; Yor394wp [Saccharomyces cerevisiae]','MTNEGIGINRDTSTICLREYVFIHFFPVKLISALTNKTNTMVKLTSIAAGVAAIAAGVAAAPATTTLSPSDERVNLVELGVYVSDIRAHLAQYYLFQAAHPTETYPVEIAEAVFNYGDFTTMLTGIPAEQVTRVITGVPWYSTRLRPAISSALSKDGIYTAIPK');
INSERT INTO proteininfo VALUES ('6324969', 'NP_015038.1','Protein of unknown function, has similarity to enolases; Err1p [Saccharomyces cerevisiae]','MSITKVHARTVYDSRGNPTVEVEITTENGLFRAIVPSGASTGIHEAVELRDGNKSEWMGKGVTKAVSNVNSIIGPALIKSELCVTNQKGIDELMISLDGTSNKSRLGANAILGVSLCVARAAAAQKGITLYKYIAELADARQDPFVIPVPFFNVLNGGAHAGGSLAMQEFKIAPVGAQSFAEAMRMGSEVYHHLKILAKEQYGPSAGNVGDEGGVAPDIDTAEDALDMIVEAINICGYEGRVKVGIDSAPSVFYKDGKYDLNFKEPNSDPSHWLSPAQLAEYYHSLLKKYPIISLEDPYAEDDWSSWSAFLKTVNVQIIADDLTCTNKTRIARAIEEKCANTLLLKLNQIGTLTESIEAANQAFDAGWGVMISHRSGETEDPFIADLVVGLRCGQIKSGALSRSERLAKYNELLRIEEELGDDCIYAGHRFHDGNKL');
INSERT INTO proteininfo VALUES ('6324967', 'NP_015036.1','Possible chaperone and cysteine protease with similarity to E. coli Hsp31 and S. cerevisiae Hsp32p, Hsp33p, and Sno4p; member of the DJ-1/ThiJ/PfpI superfamily, which includes human DJ-1 involved in Parkinson's disease; Hsp33p [Saccharomyces cerevisiae]','MTPKRALISLTSYHGPFYKDGAKTGVFVVEILRSFDTFEKHGFEVDFVSETGGFGWDEHYLPKSFIGGEDKMNFETKNSAFNKALARIKTANEVNASDYKVFFASAGHGALFDYPKAKNLQDIASKIYANGGVIAAICHGPLLFDGLIDIKTTRPLIEGKAITGFPLEGEIALGVDDILRSRKLTTVERVANKNGAKYLAPIHPWDDYSITDGKLVTGVNANSSYSTTIRAINALYS');
INSERT INTO proteininfo VALUES ('6324966', 'NP_015035.1','Hypothetical ORF; Yor390wp [Saccharomyces cerevisiae]','MIFNPVISNHKLSHYIHVFCTFTTFCILGTETRQAITALSTYTPAFVTAPTVLWSNCSSCMLMGIMQSLNAYTWMKDHQVLFLGVTTGYCGALSSFSSMLLEMFEHSTNLTNGNIANHTKLPNRAYGIMEFLSVLLVHLMVSMGSLIFGRQLGKEVIVAYGSSSFSKPYTPPSDTVKENAGDVDTQEMEKNILEFKFKTPAPFFKKFFDIVDKLAYALAFPLIILFVVLCAYYENYSRGKWTLPCLFGIFAGFLRYWLAEMFNKTNKKFPLGTFLANVFATLLIGIFTMVQRGKKHFSTDVPIVNSLNSCHIVSALISGFCGTLSTISTFINEGYKLSFINMLIYYTVSIAISYCLLVITLGSYAWTRGLTNPIC');
INSERT INTO proteininfo VALUES ('6324965', 'NP_015034.1','Hypothetical ORF; Yor389wp [Saccharomyces cerevisiae]','MRFHRQGTAATVGVLLIVLLGFCWKLSESYGIVSTALPHKQPATKITDTPSIRWDNYHEFVRDIDFDNSTAIFNSIRAALRQSPSDIHPVGVSYFPAVIPKGTLMYHAGSKVPTTFEWLAMDHEFSYSFGLRSPSYGRKSLERRHGRFGNGTHGDHPKGPPPPPPPDEKDRGSQKMLTYRAARDLNKFLYLDGASAAKTDSGEMDTQLMLSNVIKEKLNLTDDGENERMAERLYAARICKWGKPFGLDGIIRVEVGFEVVLCDFSADNVELVSMLEMVQPNQYLGLPAPTVISKEEGWPLDENGNLVEDQLTDDQKAILEREDGWEKTFSNFNAVKSFNQLRAGTAHDNGEHRIHIDYRYLVSGINRTYIAPDPNNRRLLDEGMTWEKQLDMVDDLEKALEVGFDATQSMDWQLAFDELVLKFAPLLKSVSNILNSNGDINESIAINATALTLNFCLRFEPASNNSDEFGSGKDFAVYQYVSPYQALKTDADFLIWSSAVSVVGEIVDAIYKVNDLLIPEVYSFMTDNTTSSDLIKNVETARSTIDGLIESLGWIELNYRCERQCNWDEVCYTPSWGPSPMGMTEPGSHNEGFGTHFDESRQRLVINSKLQCININDLMVNRNH');
INSERT INTO proteininfo VALUES ('6324964', 'NP_015033.1','NAD(+)-dependent formate dehydrogenase, may protect cells from exogenous formate; Fdh1p [Saccharomyces cerevisiae]','MSKGKVLLVLYEGGKHAEEQEKLLGCIENELGIRNFIEEQGYELVTTIDKDPEPTSTVDRELKDAEIVITTPFFPAYISRNRIAEAPNLKLCVTAGVGSDHVDLEAANERKITVTEVTGSNVVSVAEHVMATILVLIRNYNGGHQQAINGEWDIAGVAKNEYDLEDKIISTVGAGRIGYRVLERLVAFNPKKLLYYDYQELPAEAINRLNEASKLFNGRGDIVQRVEKLEDMVAQSDVVTINCPLHKDSRGLFNKKLISHMKDGAYLVNTARGAICVAEDVAEAVKSGKLAGYGGDVWDKQPAPKDHPWRTMDNKDHVGNAMTVHISGTSLDAQKRYAQGVKNILNSYFSKKFDYRPQDIIVQNGSYATRAYGQKK');
INSERT INTO proteininfo VALUES ('6324963', 'NP_015032.1','Hypothetical ORF; Yor387cp [Saccharomyces cerevisiae]','MSFLNIFTFFSVLVSVATAVRFDLTNVTCNNLHGPHCGTYVMEVVGQNGTFLGQSTFAGADVLTESAGDAWARYLGQETRFLPKLTTIASNDTKNFSPLIFTTNIYTCNPQSIGDAMVPFANTVTGEIEYNSWADTADNASFITGLANQLFNSTQYGVQVASCYPNFASVILSTPTVNIFAANETLPDYCTAIQLKAVCPPDAGFA');
INSERT INTO proteininfo VALUES ('6324962', 'NP_015031.1','photolyase; Phr1p [Saccharomyces cerevisiae]','MKRTVISSSNAYASKRSRLDIEHDFEQYHSLNKKYYPRPITRTGANQFNNKSRAKPMEIVEKLQKKQKTSFENVSTVMHWFRNDLRLYDNVGLYKSVALFQQLRQKNAKAKLYAVYVINEDDWRAHMDSGWKLMFIMGALKNLQQSLAELHIPLLLWEFHTPKSTLSNSKEFVEFFKEKCMNVSSGTGTIITANIEYQTDELYRDIRLLENEDHRLQLKYYHDSCIVAPGLITTDRGTNYSVFTPWYKKWVLYVNNYKKSTSEICHLHIIEPLKYNETFELKPFQYSLPDEFLQYIPKSKWCLPDVSEEAALSRLKDFLGTKSSKYNNEKDMLYLGGTSGLSVYITTGRISTRLIVNQAFQSCNGQIMSKALKDNSSTQNFIKEVAWRDFYRHCMCNWPYTSMGMPYRLDTLDIKWENNPVAFEKWCTGNTGIPIVDAIMRKLLYTGYINNRSRMITASFLSKNLLIDWRWGERWFMKHLIDGDSSSNVGGWGFCSSTGIDAQPYFRVFNMDIQAKKYDPQMIFVKQWVPELISSENKRPENYPKPLVDLKHSRERALKVYKDAM');
INSERT INTO proteininfo VALUES ('6324961', 'NP_015030.1','Hypothetical ORF; Yor385wp [Saccharomyces cerevisiae]','MRGFSGQPLSDDDNYRIEKTQRNTIPERLHFSRERNMPIASIFGTRGYFVFSSEQSYDKFKQTNFNISTLDADGVGVPLFHIVQSYNVIGKITRSSPDFYIYKYVLQGVQDPPLYSDCKVICQDKVFRLCKILYCEIYAHQGFFETKYDFFYPSKTQPVKKYQIIKQSNMRDLYSTLDGMRFRWHVKFYSDHFRLMFLDEDRLNYSNSNQKERQKPDQGKSKAPDFVIGHYTRTFSDILPRSTSKCSNLIIGEHSKPDSLGITTVPDLTQEFACQGALIHYLLHIERERK');
INSERT INTO proteininfo VALUES ('6324960', 'NP_015029.1','Putative ferric reductase with similarity to Fre2p; expression induced by low iron levels; Fre5p [Saccharomyces cerevisiae]','MLFARLVLLLVYLAPGSLAKPASTKKRTQWDQIAIDACAKELESHKFDTDVKGRHATLCTYEPALGSWLHCAKDVLDSRKKSKKIFEKTFSKINQYCHDYHKDEVVSNEEYYRIFANASLFIRPLDEVKENIRYPVTPNKASLDRWVWAYFGPLDNIDKGNVYGVTICLYWIGVLFIAAVYHFLNFSRLKQTVFKNKVSAFLRGHYVLPALVHNHAMSVGRWFFIGLVPTRLETLVLFGYVLLHGFLLSSYNFDHNELLSDRRSQVLIFLSDRAGILAFAHFPLIVLFGGKNSTMTWLTGIRYTAFITYHKWLGRFMLVDCTIHAIGYTYHAYIENYWKYVKYSDLWTSGRHAMIIVGILVFFSFFFFRRHYYELFVITHIILAIGFFHACWKHCYKLGWGEWIMACALFWIADRILRLIKIAIFGMPWAKLKLCGESMIEVRISKSSKWWKAEPGQYIYLYFLRPKIFWQSHPFTVMDSLVEDGELVVVITVKNGLTKKLQEYLLESEGYTEMRVLAEGPYGQSTRTHLFESLLFIAGGAGVPGPLSMAIKAGRQVKSNDSHQMIKFVWSVRNLDLLEVYRKEIMVLKELNIDTKIYFTGERKDESNTEEGAIANMSTEGRLLTTSKSAEMITDFGRPNIDEIIEEAVSGAKSLLVTCCGSEGFVDKTRELTAKRVLEHGDKWIEYVEEFQNW');
INSERT INTO proteininfo VALUES ('6324959', 'NP_015028.1','Mannoprotein that is incorporated into the cell wall via a glycosylphosphatidylinositol (GPI) anchor, involved in the retention of siderophore-iron in the cell wall; Fit3p [Saccharomyces cerevisiae]','MKFSSALVLSAVAATALAESITTTITATKNGHVYTKTVTQDATFVWGGEDSYASSTSAAESSAAETSAAETSAAATTSAAATTSAAETSSAAETSSADEGSGSSITTTITATKNGHVYTKTVTQDATFVWTGEGSSNTWSPSSTSTSSEAATSSASTTATTTAETSSSATSSSTAELSSYTGAADAITAGTGLMGAALAAVMLL');
INSERT INTO proteininfo VALUES ('6324958', 'NP_015027.1','Mannoprotein that is incorporated into the cell wall via a glycosylphosphatidylinositol (GPI) anchor, involved in the retention of siderophore-iron in the cell wall; Fit2p [Saccharomyces cerevisiae]','MKFSTIFGATTVMTAVSAAAVSSVMTTKTITATNGNNVYTKVVTDTADPIISYSTTRTVVVSNSDATYTKVVTEGPDTTSEKSTTKTLTLTNGSGSSTNLYTKTVTQAVESSTSSSSSSSSSSSSASSSGAAPAAFQGASVGALALGLISYLL');
INSERT INTO proteininfo VALUES ('6324957', 'NP_015026.1','Ferric reductase, reduces siderophore-bound iron prior to uptake by transporters; expression induced by low iron levels; Fre3p [Saccharomyces cerevisiae]','MYWVLLCGSILLCCLSGASASPAKTKMYGKLPLVLTDACMGVLGEVTWEYSSDDLYSSPACTYEPALQSMLYCIYESLNEKGYSNRTFEKTFAAIKEDCAYYTDNLQNMTNADFYNMLNNGTTYIIQYSEGSANLTYPIEMDAQVRENYYYSYHGFYANYDIGHTYGGIICAYFVGVMILASILHYLSYTPFKTALFKQRLVRYVRRYLTIPTIWGKHASSFSYLKIFTGFLPTRSEGVIILGYLVLHTVFLAYGYQYDPYNLIFDSRREQIARYVADRSGVLAFAHFPLIALFAGRNNFLEFISGVKYTSFIMFHKWLGRMMFLDAVIHGAAYTSYSVFYKDWAASKEETYWQFGVAALCIVGVMVFFSLAMFRKFFYEAFLFLHIVLGALFFYTCWEHVVELSGIEWIYAAIAIWTIDRLIRIVRVSYFGFPKASLQLVGDDIIRVTVKRPVRLWKAKPGQYVFVSFLHHLYFWQSHPFTVLDSIIKDGELTIILKEKKGVTKLVKKYVCCNGGKASMRLAIEGPYGSSSPVNNYDNVLLLTGGTGLPGPIAHAIKLGKTSAATGKQFIKLVIAVRGFNVLEAYKPELMCLEDLNVQLHIYNTMEVPALTPNDSLEISQQDEKADGKGVVMATTLEQSPNPVEFDGTVFHHGRPNVEKLLHEVGDLNGSLAVVCCGPPVFVDEVRDQTANLVLEKPAKAIEYFEEYQSW');
INSERT INTO proteininfo VALUES ('6324956', 'NP_015025.1','Repressor of drug resistance; Transcriptional repressor (zinc cluster protein); Rdr1p [Saccharomyces cerevisiae]','MASPGSTALPHKRQRVRKACVPCRERKRKCNGKSPCEMCVAYGYVCHYIDGRVPSASPQVQQVGETSPDTESRPFVLPGIHRNEQPQPINTQNVTSQNIVDPTKSRYTIQHSAVAFPRCLGLELRSTNPPRLHSFAWHCGIRPEENPNSHVLLSDLVTKEEYYRISKVYFSVVHPIFDVVNPEQLAKNVEKYWDGDVKTLEYGAVIAGVIALGSFFMGSLGHPREMDIVQYAKGILDDPTFSRIPTVEQVSAWVLRTIYLRATSRPHVAWLASCVTIHLSEAIGLHHEIDREDIAISNNVPPKRTTVVSEHTRRLFWCAWSINTILSYDYGRSSVTLNRITCKPVKETDGNFTAHLVALAHLIPQDSVNANAAQLLQALAAVHESPNAHPFLSLTKGDICLSLYRRLRLLNHILDKNVVLQIIDIGNTALSAAYALVKLDQAWWNVLSTSFQYVCVLLAIDTPESLSHVATAMKTLDNITQILGTRIAFEAQKTAKLLLEDSMKKKRQEIQQLEQATHQRSNLETTHLLDIDWDALLDPSDTLNFM');
INSERT INTO proteininfo VALUES ('6324954', 'NP_015023.1','Hypothetical ORF; Yor378wp [Saccharomyces cerevisiae]','MSTSSSVTQKNLDTNAEALKKEDKVLSEFDIQDERPKSLLWESAFVGVLCSAQLMTQAGLGQSLAPLHIIGNSFGTTNAGQLSWFASAYSLTVGTFILIAGRLGDIFGHKKFFVLGFFWYALWSLLAGFSVYSNQIFFDCCRAFQGMGPAFLLPNAIAILGRTYKPGRRKNMVFSLFGASAPGGFFLGAVFSSMLGQLAWWPWAYWIMGIACFVLAVAGYFVIPHTPMPSRDASSFKLLERIDFAGSVTGVVGLILFNFAWNQGPVVGWQTPYTYALLIVGTFFLVIFAYIESRAAFPLLPFAALSSDTAFVLSCIAAGWASFGIWIFYTWQFMEDSRGQTPLLSSAQFSPVAISGFCAAVTTGFLLSHTPPSTVMLFAMTAFTVGTILIATAPVHQTYWAQTFVSIIVMPWGMDMSFPAATIMLSDSMPHEHQGLAASLVNTVVNYSISIGLGIAGTIESRVNDGGAKPLKGYRCSWYMGIGLSGLGIFVAATYAWSTFMKSKKRISEKQHFIE');
INSERT INTO proteininfo VALUES ('6324953', 'NP_015022.1','Alcohol acetyltransferase with potential roles in lipid and sterol metabolism; responsible for the major part of volatile acetate ester production during fermentation; Atf1p [Saccharomyces cerevisiae]','MNEIDEKNQAPVQQECLKEMIQNGHARRMGSVEDLYVALNRQNLYRNFCTYGELSDYCTRDQLTLALREICLKNPTLLHIVLPTRWPNHENYYRSSEYYSRPHPVHDYISVLQELKLSGVVLNEQPEYSAVMKQILEEFKNSKGSYTAKIFKLTTTLTIPYFGPTGPSWRLICLPEEHTEKWKKFIFVSNHCMSDGRSSIHFFHDLRDELNNIKTPPKKLDYIFKYEEDYQLLRKLPEPIEKVIDFRPPYLFIPKSLLSGFIYNHLRFSSKGVCMRMDDVEKTDDVVTEIINISPTEFQAIKANIKSNIQGKCTITPFLHVCWFVSLHKWGKFFKPLNFEWLTDIFIPADCRSQLPDDDEMRQMYRYGANVGFIDFTPWISEFDMNDNKENFWPLIEHYHEVISEALRNKKHLHGLGFNIQGFVQKYVNIDKVMCDRAIGKRRGGTLLSNVGLFNQLEEPDAKYSICDLAFGQFQGSWHQAFSLGVCSTNVKGMNIVVASTKNVVGSQESLEELCSIYKALLLGP');
INSERT INTO proteininfo VALUES ('6324951', 'NP_015020.1','NADP(+)-dependent glutamate dehydrogenase, synthesizes glutamate from ammonia and alpha-ketoglutarate; rate of alpha-ketoglutarate utilization differs from Gdh3p; expression regulated by nitrogen and carbon sources; Gdh1p [Saccharomyces cerevisiae]','MSEPEFQQAYEEVVSSLEDSTLFEQHPEYRKVLPIVSVPERIIQFRVTWENDKGEQEVAQGYRVQYNSAKGPYKGGLRFHPSVNLSILKFLGFEQIFKNSLTGLDMGGGKGGLCVDLKGRSNNEIRRICYAFMRELSRHIGQDTDVPAGDIGVGGREIGYLFGAYRSYKNSWEGVLTGKGLNWGGSLIRPEATGYGLVYYTQAMIDYATNGKESFEGKRVTISGSGNVAQYAALKVIELGGTVVSLSDSKGCIISETGITSEQVADISSAKVNFKSLEQIVNEYSTFSENKVQYIAGARPWTHVQKVDIALPCATQNEVSGEEAKALVAQGVKFIAEGSNMGSTPEAIAVFETARSTATGPSEAVWYGPPKAANLGGVAVSGLEMAQNSQRITWTSERVDQELKRIMINCFNECIDYAKKYTKDGKVLPSLVKGANIASFIKVSDAMFDQGDVF');
INSERT INTO proteininfo VALUES ('6324950', 'NP_015019.1','Mitochondrial aldehyde dehydrogenase that utilizes NADP+ or NAD+ equally as coenzymes; expression is glucose repressed; Ald4p [Saccharomyces cerevisiae]','MFSRSTLCLKTSASSIGRLQLRYFSHLPMTVPIKLPNGLEYEQPTGLFINNKFVPSKQNKTFEVINPSTEEEICHIYEGREDDVEEAVQAADRAFSNGSWNGIDPIDRGKALYRLAELIEQDKDVIASIETLDNGKAISSSRGDVDLVINYLKSSAGFADKIDGRMIDTGRTHFSYTKRQPLGVCGQIIPWNFPLLMWAWKIAPALVTGNTVVLKTAESTPLSALYVSKYIPQAGIPPGVINIVSGFGKIVGEAITNHPKIKKVAFTGSTATGRHIYQSAAAGLKKVTLELGGKSPNIVFADAELKKAVQNIILGIYYNSGEVCCAGSRVYVEESIYDKFIEEFKAASESIKVGDPFDESTFQGAQTSQMQLNKILKYVDIGKNEGATLITGGERLGSKGYFIKPTVFGDVKEDMRIVKEEIFGPVVTVTKFKSADEVINMANDSEYGLAAGIHTSNINTALKVADRVNAGTVWINTYNDFHHAVPFGGFNASGLGREMSVDALQNYLQVKAVRAKLDE');
INSERT INTO proteininfo VALUES ('6324949', 'NP_015018.1','Component of the spindle pole body outer plaque, required for exit from mitosis; Nud1p [Saccharomyces cerevisiae]','MDMDTQEAELSSQLENLTINSPRKLRSNAHSNSGKVFKEYESNHDFQDSNFTSQVVEPAISDSVKKPPTMTVLNNYSTVHQKVPSGFSGTTATSHQEAQWKQYFPGIGSGGGTNFGGAVGTANKVPESDLIVSDLVKDLSGVLETNTFKRHLDMKNKTTTMQTHENHDTISISHSKDFFNAEKVSSSFSDDSDSGPAAEAHDVFDGILQKQKSNYLVGSYPSNSNNKNNNNNNNNNNNNSININNKDNARTKEEDEEDTSNSFEFSSSSSMSSSQTQSGRKSKVLKKPPLNTISPGQLGYQFNHTHGAWDPPLNQGLDVSSSHSLDNTSSNQSQFATMVPTGDNHTNGKAPSILDKKAYELTSTKPGDVGYRQKKIQEEENLANSDDTPLDTPKFNDLFTKNGTRAKVKGQMRTSRSISNSNLLEAHKKLKTFPAERVEDITSISEVNTSFNETEKQLISILTSKLSGSPSYDSDWEKILKVDLSRGKLKNMFGMQRLLPNVLVLNLSDNEMNTLEGIPSNVVQLFCSNNKITSAHCSLAGFHDLECLDLSYNLLNTSLKFLSLCHHLQEVNLSYNSIQSLEGIGSSRMKKLNLSNNEINGIIDFEQLILTNNSVVGGWLTVEVLDLSNNNIIGVRNINCLPRLKVLNLNGNPLVSIVESSKMENGTLRALSIKNTGGALSKLQNYKLDDQFTFPYQNLKILKLDGFAQLSKWQKWPATLQILEINGGLASSLPRFSSLKSTNLYSLTIANVRDFTHLPVDLSKELPFLQELHLPGNNLQNAHKLTKTLPRQSVKFLDLRNNPITTPRHDRASTSLHYRQLLQLAGLCQQQCPALATLWLDDTPAPTATNL');
INSERT INTO proteininfo VALUES ('6324948', 'NP_015017.1','Nuclear Division Defective 1; Ndd1p [Saccharomyces cerevisiae]','MDRDISYQQNYTSTGATATSSRQPSTDNNADTNFLKVMSEFKYNFNSPLPTTTQFPTPYSSNQYQQTQDHFANTDAHNSSSNESSLVENSILPHHQQIQQQQQQQQQQQQQQQALGSLVPPAVTRTDTSETLDDINVQPSSVLQFGNSLPSEFLVASPEQFKEFLLDSPSTNFNFFHKTPAKTPLRFVTDSNGAQQSTTENPGQQQNVFSNVDLNNLLKSNGKTPSSSCTGAFSRTPLSKIDMNLMFNQPLPTSPSKRFSSLSLTPYGRKILNDVGTPYAKALISSNSALVDFQKARKDITTNATSIGLENANNILQRTPLRSNNKKLFIKTPQDTINSTSTLTKDNENKQDIYGSSPTTIQLNSSITKSISKLDNSRIPLLASRSDNILDSNVDDQLFDLGLTRLPLSPTPNCNSLHSTTTGTSALQIPELPKMGSFRSDTGINPISSSNTVSFKSKSGNNNSKGRIKKNGKKPSKFQIIVANIDQFNQDTSSSSLSSSLNASSSAGNSNSNVTKKRASKLKRSQSLLSDSGSKSQARKSCNSKSNGNLFNSQ');
INSERT INTO proteininfo VALUES ('6324947', 'NP_015016.1','Proposed beta subunit of the heterotrimeric G protein that interacts with the receptor Grp1p, has signaling role in response to nutrients; involved in regulation of pseudohyphal growth through cAMP levels; homolog of Gpb2p; Gpb1p [Saccharomyces cerevisiae]','MPQASTFGSHSLEAHPLHIQPAVHIKLSKEERSHYREQYDSLKYISNYVSVFDQALSDNIDSRIRKENEALLKKYYESRKPFTFTSFRQGSVISSSDSSTGFTERTKTYCFLNDFVSNCVNEVDPYTLKMTVRNRNTALNMENLDDERKSKDDIYDFEDNTDDECNAKCHGAFHYSSERLEILRSRSTISYFKYYKKLLTVDLRDSDVLKRHNLWMPMITRRFRFLLVSSSKPEDVRLTTPIPTFSESDLDIFKNKTCPLFINGTDCVPRSYDTFSGSSVIASIFSEYKLPSLSYHCSVELNDQLFIVGGLMACHRYDEEAPDLKDFYVDGIKNLPPPLIPELINNPSMIPNPHLYCFSLTSSRLTRPDISGYIPPPLVCTQGCKLTERHIFLYGGFEIKSETQVDDKGRYFIRKRAFLNNTGYILDTVTFNFSKIELVAPPYQFAIYNNFSPRFGHMQASISNSNNNVSNENTTTSAKGRRSISPYRQGNGDHKIDDLVGSPGSTDYLEDDAIPPVTNPRSTDSLSSKHCSTATHICSSVNTILIFGGYSQTGDDKYEAMNDMWKINIPVVSRGKRNYYKFADTVTATKIPIIDDPELWPSRRAFSACCVPDYFTKDVEPIETRLLRNLKNDFSIDLEIRPGNKPSQPLFPNIPHSRKEKKSGRDSMHISNSNNSTSEDTSSKSTRNTTSSPPTSPKHTPPLNPSKKCASIGRTIAFHGGSDGYDVCSDMWWFDFDSETWTKIDLYAKTQEESDGLVPINLCMVGHSMTTVGHKVVLIGGLRQGDVDRIYRDETLPEEVISGVPLGSGVINVVDLNTQCLQGCKLIRNDGDTKESVIMDPHVGTPHQVLAVAGTIELVKGTMTLIGGVVAGREDISSLYLRGAVLQFILPSMNLAN');
INSERT INTO proteininfo VALUES ('6324946', 'NP_015015.1','Rab escort protein, forms a complex with the Ras-like small GTPase Ypt1p that is required for the prenylation of Ypt1p by protein geranylgeranyltransferase type II (Bet2p-Bet4p); Mrs6p [Saccharomyces cerevisiae]','MLSPERRPSMAERRPSFFSFTQNPSPLVVPHLAGIEDPLPATTPDKVDVLIAGTGMVESVLAAALAWQGSNVLHIDKNDYYGDTSATLTVDQIKRWVNEVNEGSVSCYKNAKLYVSTLIGSGKYSSRDFGIDLSPKILFAKSDLLSILIKSRVHQYLEFQSLSNFHTYENDCFEKLTNTKQEIFTDQNLPLMTKRNLMKFIKFVLNWEAQTEIWQPYAERTMSDFLGEKFKLEKPQVFELIFSIGLCYDLNVKVPEALQRIRRYLTSFDVYGPFPALCSKYGGPGELSQGFCRSAAVGGATYKLNEKLVSFNPTTKVATFQDGSKVEVSEKVIISPTQAPKDSKHVPQQQYQVHRLTCIVENPCTEWFNEGESAAMVVFPPGSLKSGNKEVVQAFILGAGSEICPEGTIVWYLSTTEQGPRAEMDIDAALEAMEMALLRESSSGLENDEEIVQLTGNGHTIVNSVKLGQSFKEYVPRERLQFLFKLYYTQYTSTPPFGVVNSSFFDVNQDLEKKYIPGASDNGVIYTTMPSAEISYDEVVTAAKVLYEKIVGSDDDFFDLDFEDEDEIQASGVANAEQFENAIDDDDDVNMEGSGEFVGEMEI');
INSERT INTO proteininfo VALUES ('6324945', 'NP_015014.1','Protein component of the small (40S) ribosomal subunit; has similarity to rat ribosomal protein S12; Rps12p [Saccharomyces cerevisiae]','MSDVEEVVEVQEETVVEQTAEVTIEDALKVVLRTALVHDGLARGLRESTKALTRGEALLVVLVSSVTEANIIKLVEGLANDPENKVPLIKVADAKQLGEWAGLGKIDREGNARKVVGASVVVVKNWGAETDELSMIMEHFSQQ');
INSERT INTO proteininfo VALUES ('6324944', 'NP_015013.1','Checkpoint protein, involved in the activation of the DNA damage and meiotic pachytene checkpoints; with Mec3p and Ddc1p, forms a clamp that is loaded onto partial duplex DNA; homolog of human and S. pombe Rad1 and U. maydis Rec1 proteins; Rad17p [Saccharomyces cerevisiae]','MRINSELANKFSASTVHLEHITTALSCLTPFGSKDDVLIFIDADGLSFVRENNHVIKIQLLLSRELFMSYSYRNETEDHMKLCVKINHILDSVSVMNRNSDDIVECTLSYDGHGSPFVLIFEDSFISERVEYSTYLIKDFDTNGLELDRERISFEAIIKGEALHSALKDLKEIGCKECYVYAKTEANDENVFALISKSQLGFSKIKLPSNRSILEKLQVFDGDSTTVIDGFAVIGFFDFTSFDKIRKSTKIASKVLFRMDVHGVLSVNILSQTDDVIITDTTRPSNNRPGSIRQLQLPKDYPGIVIEVCMLEKESIDEAAQTEIELLMETNELGNRNSFKKSTIRKRYGTDKGNETSNDNLLQLNGKKIKLPSEEENNKNRESEDEENHCKYPTKDIPIFF');
INSERT INTO proteininfo VALUES ('6324943', 'NP_015012.1','Component of yeast cortical actin cytoskeleton, binds and cross links actin filaments; originally identified by its homology to calponin (contains a calponin-like repeat) but the Scp1p domain structure is more similar to transgelin; Scp1p [Saccharomyces cerevisiae]','MSYDKKADVTSLDEDLRQLRESKFSPEAIQNIKIWVYKSVLKEIAPPGDLLECLKDGTVLCKLANILYEADTGEANHISWKSSKMPFVQMDQISQFLSFSRKYGVPEDELFQTIDLFEKKDPAIVFQTLKSLSRYANKKHTDRFPVLGPQLSTKKPRPPVKSKPKHLQDGTGWSTFEYGYMKGASQATEGVVLGQRRDIV');
INSERT INTO proteininfo VALUES ('6324942', 'NP_015010.1','Hypothetical ORF; Yor365cp [Saccharomyces cerevisiae]','MLPIKVFSLSRIFVLLAIFRQIHAISINSSTFQVSNSFTLLNNASTLFPVPFDAYTKEYLRTSALLTCAKDSQFSASYFEAAFFPRNNTLFFNVEAQTIMSENITIKAELIAYGLNVYTKVFDLCGIQDNLLCPLKPGNIELMGSYYVEAAVASQIPSITYNIPDLDAYIVVTAYSTIDKEFTKPLACVQVMLSNGRTVQTEYLSWNLVILTISGIMFSVVYSLQGYTVTSTRLASYSISLLLYFQNLAILAMISVSFLPPIVAAWTQNFQWSMGIIRINFMQRLFDWYVVATSGSPTVVYRNKEVLSISVQKRSLNSKIISASSNLNGIESSQKNDLLYTSNLRNSNDYLSKILVLRGIKRVSYKAGIEISNFFLTGFSFFIIFICMIILAFIIFKTFLKVLQKFKVKTIRYLHFHTHWSALLQGTLYRAVFIIYSEISLLALWEFTQTDSAATLVEAIVVFILITVLLSSASVRIWRKMIKSKKIFGQPSYLLFSSSKFLNKFGFLSSQFKSTKVWWLMATSAHMLIRSILVGSLQAHGKSQSIGIFLNEAIYLILLCWMQPYMDKTTNFFNISIHSLNLVNAFFFLFFSNLFQQPIAVSSFMGLIFFFLNAAFSLYLFIFILICFTMAIYYKHPDTRYKPIDDQRRSFLKGEMDDDAVYESVPELHEMKKAVLECNGIQKPQINKIDLCKQNSNCEYLYM');
INSERT INTO proteininfo VALUES ('6324939', 'NP_015008.1','peroxisome induction pathway 2 (PIP2); transcriptional activator of peroxisome proliferation; may form heterodimer with Oaf1 to activate oleate-inducible gene expression; activator of peroxisome proliferation; Pip2p [Saccharomyces cerevisiae]','MYFTDESSPAMNRVGKKRNRLSFVCQACRKAKTKCDQEKPRCGRCTKQNLFCIYDVARQAAPRNPNKDATIARLKKEIRYWRNKTVDLTQEKKDFYTALKRPTEELAARRTCKSLQENSFPISLYKTHPRLIMTKVMKREINPLSEKYLIFQDTFLKTLIASVLLSCSRNSMIPALNADISRSRTQPCVKNNVVKMREVLLKNSKYESQRKSINEFTDRLLQRKNPEEQIAVNKVISLLYSNRESSYLEDTCPTENDYSDLLKGYINEIEKTLPPKAIIEQYLSHFFEHIFHLIPFASKEMLEESIHTTVQYNELGEVRLSMGTTLIRNKMENLCILLLILRIAYISLTFIEDKIEDYSPYITKEMLEQYPIQSEVIFLAQQILASENWCACANENTISCLLYIWCAFVFSPTEGDFLLEQPSDVIINLVILIGTSIGLHRDPSDFPALNHPEASDKRLLNLRRIQWLSIISMATLESSLKGRLLVSPLSMIDLFIDVRDPNCVEIYKKRVKKDLTGSESDEQLLEIHEIFFHRAQLALFLSDLNNITISYSGSVPMDTLETLRVKANELLKNKFQLRSVDINIYDEEKTFQKLTFNSILNSISLSGQILGKLMMLRASIALMLYFETLAMERSECLSFFYKYFFQCCADTISLIRFFFLYFNGSYEKVLSSLVCFITTKVIQLAVPTTMFTLLVIIMRVELAKNMLLVKCNECNARGDISDLPEIKEKIKSLDTIKENFERLLLEVYLLASQNLRFKYFYIFKMLTLFDVFIQRLRKGQLFSGLFVKVDKDLTTKKIATMLELTLGINLDKSDHLIDRLKGKNLTVNFTLDQLYQIIKEFDRIKNIGVADPQNSLNPSKPNMKDNTPTIELLLNSSVENESVPPYSSSNDPTNVGNASTYSLAHNISNQNNEENMPPSIGSSESNRAAPNLNFMPINNNYNNSGSNINNNDNVKLPSNFKNYYDPPMSSLDISMDVPDIFGSLDFFDYDLLFQND');
INSERT INTO proteininfo VALUES ('6324938', 'NP_015007.1','20S proteasome alpha-type subunit; Pre10p [Saccharomyces cerevisiae]','MTSIGTGYDLSNSVFSPDGRNFQVEYAVKAVENGTTSIGIKCNDGVVFAVEKLITSKLLVPQKNVKIQVVDRHIGCVYSGLIPDGRHLVNRGREEAASFKKLYKTPIPIPAFADRLGQYVQAHTLYNSVRPFGVSTIFGGVDKNGAHLYMLEPSGSYWGYKGAATGKGRQSAKAELEKLVDHHPEGLSAREAVKQAAKIIYLAHEDNKEKDFELEISWCSLSETNGLHKFVKGDLLQEAIDFAQKEINGDDDEDEDDSDNVMSSDDENAPVATNANATTDQEGDIHLE');
INSERT INTO proteininfo VALUES ('6324937', 'NP_015006.1','Subunit of the core complex of translation initiation factor 3(eIF3), essential for translation; part of a subcomplex (Prt1p-Rpg1p-Nip1p) that stimulates binding of mRNA and tRNA(i)Met to ribosomes; Prt1p [Saccharomyces cerevisiae]','MKNFLPRTLKNIYELYFNNISVHSIVSRNTQLKRSKIIQMTTETFEDIKLEDIPVDDIDFSDLEEQYKVTEEFNFDQYIVVNGAPVIPSAKVPVLKKALTSLFSKAGKVVNMEFPIDEATGKTKGFLFVECGSMNDAKKIIKSFHGKRLDLKHRLFLYTMKDVERYNSDDFDTEFREPDMPTFVPSSSLKSWLMDDKVRDQFVLQDDVKTSVFWNSMFNEEDSLVESRENWSTNYVRFSPKGTYLFSYHQQGVTAWGGPNFDRLRRFYHPDVRNSSVSPNEKYLVTFSTEPIIVEEDNEFSPFTKKNEGHQLCIWDIASGLLMATFPVIKSPYLKWPLVRWSYNDKYCARMVGDSLIVHDATKNFMPLEAKALKPSGIRDFSFAPEGVKLQPFRNGDEPSVLLAYWTPETNNSACTATIAEVPRGRVLKTVNLVQVSNVTLHWQNQAEFLCFNVERHTKSGKTQFSNLQICRLTERDIPVEKVELKDSVFEFGWEPHGNRFVTISVHEVADMNYAIPANTIRFYAPETKEKTDVIKRWSLVKEIPKTFANTVSWSPAGRFVVVGALVGPNMRRSDLQFYDMDYPGEKNINDNNDVSASLKDVAHPTYSAATNITWDPSGRYVTAWSSSLKHKVEHGYKIFNIAGNLVKEDIIAGFKNFAWRPRPASILSNAERKKVRKNLREWSAQFEEQDAMEADTAMRDLILHQRELLKQWTEYREKIGQEMEKSMNFKIFDVQPEDASDDFTTIEEIVEEVLEETKEKVE');
INSERT INTO proteininfo VALUES ('6324936', 'NP_015005.1','low-Km (high-affinity) cAMP phosphodiesterase; Pde2p [Saccharomyces cerevisiae]','MSTLFLIGIHEIEKSQTIVQNEHYFDRVIELQDLDSLMVALYKDRVSPFPNVHNFETGVSIVLYDPSKFQLSVRQLDVLFKRFFPSFNISAIDHTREENLQRLECVERENSICRNRITRINHWMYHHHDDTPDGINKNSYGTVNGNSVPTQACEANIYTLLLHLNDSKAQHLRKASVPRLIRNIEFMSFLSDPIEKISQEGSHYWNILSTWDFCALSLSTQELIWCGFTLIKKLSKDAKVLIADNKLLLLLFTLESSYHQVNKFHNFRHAIDVMQATWRLCTYLLKDNPVQTLLLCMAAIGHDVGHPGTNNQLLCNCESEVAQNFKNVSILENFHRELFQQLLSEHWPQLLSISKKKFDFISEAILATDMALHSQYEDRLMHENPMKQITLISLIIKAADISNVTRTLSISARWAYLITLEFNDCALLETFHKAHRPEQDCFGDSYKNVDSPKEDLESIQNILVNVTDPDDIIKDHPHIPNGQIFFINTFAEVFFNALSQKFSGLKFLSDNVKINKEYWMKHKKPQ');
INSERT INTO proteininfo VALUES ('6324935', 'NP_015004.1','Vts1p [Saccharomyces cerevisiae]','MKHPYEEFPTGSKSPYNMSRGAHPGAVLLSPQSSAINKNNPGSNSGNNQGNSSVTANVLSPQSHSMSLNDMLDQQSFMLDTAGTRAQPLQQQQQQQQQQQQASLPSLNIQTVSSTAAGSAIVSPMMQSPKALQSTLSSTSMYLDSFQRSPNNILGIPSQSGSIPLPQSRQSQQQSQSQKNDPNMGTNFSQDINQLCSWISMLNSSQQNTVMDNILSILNDDVLKYTKLKIETLTNTPFISPPLPAIASPIPNRDDTQILNIDSVFSSSPITNDPENTDNLLYQNWSPQPHSIPISQPIYDNITDASQRSKSAEPHVNSSPNLIPVQKQFNNGNSTKYKKLPSENPNYLSHSLSSSHSFFQPKKRSNMGNEYNSHHHHSLHHPLHNTTSYFSNTSRPSGTDLNKSNQNVFNNTITHPNAGPTSATSTSTSSNGNTPLSSNSSMNPKSLTDPKLLKNIPMWLKSLRLHKYSDALSGTPWIELIYLDDETLEKKGVLALGARRKLLKAFGIVIDYKERDLIDRSAY');
INSERT INTO proteininfo VALUES ('6324934', 'NP_015003.1','Subunit of the heme-activated, glucose-repressed Hap2/3/4/5 CCAAT-binding complex, a transcriptional activator and global regulator of respiratory gene expression; required for assembly and DNA binding activity of the complex; Hap5p [Saccharomyces cerevisiae]','MTDRNFSPQQGQGPQESLPEGPQPSTMIQREEMNMPRQYSEQQQLQENEGEGENTRLPVSEEEFRMVQELQAIQAGHDQANLPPSGRGSLEGEDNGNSDGADGEMDEDDEEYDVFRNVGQGLVGHYKEIMIRYWQELINEIESTNEPGSEHQDDFKSHSLPFARIRKVMKTDEDVKMISAEAPIIFAKACEIFITELTMRAWCVAERNKRRTLQKADIAEALQKSDMFDFLIDVVPRRPLPQ');
INSERT INTO proteininfo VALUES ('6324933', 'NP_015002.1','Sorting nexin required to maintain late-Golgi resident enzymes in their proper location by recycling molecules from the prevacuolar compartment; contains a PX domain and sequence similarity to human Snx3p; Grd19p [Saccharomyces cerevisiae]','MPREFKSFGSTEKSLLSKGHGEPSYSEIYAEPENFLEIEVHNPKTHIPNGMDSKGMFTDYEIICRTNLPSFHKRVSKVRRRYSDFEFFRKCLIKEISMLNHPKVMVPHLPGKILLSNRFSNEVIEERRQGLNTWMQSVAGHPLLQSGSKVLVRFIEAEKFVG');
INSERT INTO proteininfo VALUES ('6324932', 'NP_015001.1','Hypothetical ORF; Yor356wp [Saccharomyces cerevisiae]','MIKFTNENLIRGIRMTISAKSRHLALGTDMTRKFSLSCRFLNKANLTEEEKELLNEPRARDYVDVCIVGGGPAGLATAIKLKQLDNSSGTGQLRVVVLEKSSVLGGQTVSGAILEPGVWKELFPDEKSDIGIPLPKELATLVTKEHLKFLKGKWAISVPEPSQMINKGRNYIVSLNQVVGYLGEKAEEVGVEVYPGIAVSDLIYDENNAVKGVITKDAGISKSGKPKETFERGMEFWARQTVLAEGCHGSLTKQALAKYDLRKGRQHQTYGLGIKEVWEVKPENFNKGFAAHTMGYPLTNDVYGGGFQYHFGDGLVTVGLVVGLDYKNPYVSPYKEFQKMKHHPYYSKVLEGGKCIAYAARALNEGGLQSVPKLNFPGGVLVGASAGFMNVPKIKGTHTAMKSGLLAAESIFESIKGLPVLEEVEDEDAKMAMFDKEATINLESYESAFKESSIYKELYEVRNIRPSFSGKLGGYGGMIYSGIDSLILKGKVPWTLKFDEKNDGEILEPASKYKPIEYPKPDGVISFDILTSVSRTGTYHDDDEPCHLRVPGQDMVKYAERSFPVWKGVESRFCPAGVYEFVKDEKSPVGTRLQINSQNCIHCKTCDIKAPRQDITWKVPEGGDGPKYTLT');
INSERT INTO proteininfo VALUES ('6324931', 'NP_015000.1','Protein of unknown function, required for growth on glycerol as a carbon source; Gds1p [Saccharomyces cerevisiae]','MALANSRPLQIPTLENEILHNSNSPVFQLNSMGFTTRADTISNPGTDLIGNQPGMALDDNNLAGSSFSSSQEIKATKPKKDFGAPKKDNPLLEISKLIPVTGERPKPENRDSPLDDDVLHAVFLILWEMDPNQQGMTVKQLCDLLLQKHPDMSNLSTKLSNLISAKLNAYVKKIEKGEKTLTYALSREWSNSSPRRMLYIYRGILSPDYKEHAQAVTMQLKQQLETSGDTSDFNSNGKKKRESSSNQLVNNDSYSSSMTDMKNMSSNSSFSKNLNVGNLAFSLSPEFNIPYSTSPVSLNLSPSMSNNQQQLLTPNSASKSKNNNKKRNYMDEDTNESMTEPKKTKTTKPGKQTKSQSLSVLSTPKKGSSASLSTFASSKNISPDSSLSHNASSNTYVTAAAAAPRLSKLLPKNGFKKNSRSSSELAAIHKVISTQTPIESSSESSQYNSSSSSPVNSAAASSAESLSDINSSQDNGRESNPSSQESRNEVTNWMKIVRNGFLTHDIESPESITLDDLENIFN');
INSERT INTO proteininfo VALUES ('6324930', 'NP_014999.1','Protein of unknown function, green fluorescent protein (GFP)-fusion protein localizes to mitochondria; msc6 mutants are defective in directing meiotic recombination events to homologous chromatids; Msc6p [Saccharomyces cerevisiae]','MLSHNALRAFDCSKVIISRRCLTSSTSIYQQSSVHLQETDDGHSGNREKHVSPFERVQNLAADLKNELKAPDSDINEVFNDFKDKIESLKQKLRNPSPMERSHLLANFSSDLLQELSYRSKNMTLDPYQVLNTLCQYKLARSQHFTIVLKYLLYNQSPQDVIALWVKYLETISENPVILLQNSSSRAHMQNIAITTIAYLSLPENTVDINILYKILQIDRKMGQVLPFNMIRRMLSTEFSSLERRDVIIKNLNTLYYQYTVQDSDHFLSQIENAPRWIDLRDLYGQYNKLEGEKNVEIISKFMDKFIDLDKPDQVVTIYNQYSKVFPNSTSLKDCLLRAVSHLRAKSSKEKLDRILAVWNSVIKPGDNIKNTSYATLVNALTDSGNFNHLKEFWEEELPKKFKKDPIVKEAFLLALCQTSPLKYDQVKGELAETVKTKKLFNKVLLLMLDDEKVSEEQFNTFYYNHYPSDGVLPPTLDTLSIKMYANYKFQAEDTRPQFDLLQSVSINPTDYEKVEKITKAFISVCPTVEPIRQLYKQLGTHLNARNYADFISAEFNKPDGTVAEAKNLFSDFLSYQKTRKRNVDNTPLNALLLGFCDKLYKSKHSEYVPYIEKYYNLAKDSSIRVSNLAVSKILFNLATFARNTQQLSDKEVAFINQFMRDLGTNEGFRPNPKDIQILKECDGITVPEKLT');
INSERT INTO proteininfo VALUES ('6324929', 'NP_014998.1','Protein required for cell viability; Sog2p [Saccharomyces cerevisiae]','MVATSSKRTLDPKEEHLPADKTSTNSSNTIISELATQEKSSSSGTTLKLIALNIKSISDEDVGYIQNVERLSLRKNHLTSLPASFKRLSRLQYLDLHNNNFKEIPYILTQCPQLEILDLSSNEIEALPDEISSFWQDNIRVLSLKDNNVTSIRNLKSITKLNKLSILDLEDNKIPKEELDQVQSYTPFHTGIPKEEYWAIAISRYLKDHPNLPTPEPKISRAAKRMGFINTNLSNGAMNENNIISLAPSANTTISASTAMVSSNQTSATSFSGTVNAESEQSGAVNGTELYNHTKYNDYFKRLSILPEESMSNGHQKISHAELVVSCRKLLFSFTECQQAIRKIASFCKEKAVAVNVVSLLYSVRSHTDNLVEVLQQTENEDESHDQALIKLCLTIITNFKQIITLLRKNFEIFFKEDDLCFIRMFYMTLMCAYMEMYNAWSFIKEDDQVSGSASKAPKKHSFSRHETSSSSITSGGGPAASTTSTHCSGNIKLLPKTRSTRTPSASALLSNSNILTGDTTAVPLLSPNLNGAHTHGPILGHQNAISNGSSQTNMNEVKTTSDTIPRQQLLQHNKSISDSKKESQAHEPKQHPVMTSSIINASNSNNVSNVNITPPPMNGGGAANSSANVVETNIDIQLYQTLSTVVKMVSVVYNQLTSEISKIAIASTMGKQILTDSLAPKIRDLTETCRQAMDLSKQLNERLNVLIPNDSNSEKYLTSLEKLKTWEIMNSFLKVIISILANTKIVMSDVPNLNELRPNLANLAKITKDVTVILDLSSYKAVSVSANSPE');
INSERT INTO proteininfo VALUES ('6324928', 'NP_014997.1','Hypothetical ORF; Yor352wp [Saccharomyces cerevisiae]','MSEPNTPLHAQPNEQLDLNNLNDLDEKDIDDLNLDPNSDVEISADSGDVVNSNIDNVIWQRNCNKKRRYHTPEFNDVYNETNNTINDVTMLDDVDDFQPRINVSSPFSSATKLSELLPNDHNGTSHPRRLSMSQQSKFISYVDDQLLQIQRKFVQSRGLNIKNGYASLTPLLQDLKTLVDFVWYSIAHVPNSDYLLQSEEKRHCPDSRNPKDTCGYSSYFGQGSYLIKIADDLIDYVEKFTFKNMEDSEINDTLSKLFKLFFILDRIFVILTDDNDNCKEVPKTSSASKNIAGLNGTDIVRLKGIAERTRVRLPIFLESQGIHGYHYELSKIYEGFLDHANSF');
INSERT INTO proteininfo VALUES ('6324927', 'NP_014996.1','Disp. for chr. pairing & chr. condensation seen by in situ hybrid. Required for full double strand breaks, normal length synaptonemal complexes, meiotic recomb. & spore viability. mek1 is rescued by spo13 & in early recomb. function; mRNA is induced in meiosis, encodes a meiosis-specific serine/threonine protein kinase which interacts with and is believed to phosphorylate Hop1p; Mek1p [Saccharomyces cerevisiae]','MRPLYSCNLATKDDIEMAGGVAPAHLEVNVGGYNTEQTIPIVKHQLVKVGRNDKECQLVLTNPSISSVHCVFWCVFFDEDSIPMFYVKDCSLNGTYLNGLLLKRDKTYLLKHCDVIELSQGSEENDIKKTRLVFMINDDLQSSLDPKLLDQMGFLREVDQWEITNRIVGNGTFGHVLITHNSKERDEDVCYHPENYAVKIIKLKPNKFDKEARILLRLDHPNIIKVYHTFCDRNNHLYIFQDLIPGGDLFSYLAKGDCLTSMSETESLLIVFQILQALNYLHDQDIVHRDLKLDNILLCTPEPCTRIVLADFGIAKDLNSNKERMHTVVGTPEYCAPEVGFRANRKAYQSFSRAATLEQRGYDSKCDLWSLGVITHIMLTGISPFYGDGSERSIIQNAKIGKLNFKLKQWDIVSDNAKSFVKDLLQTDVVKRLNSKQGLKHIWIAKHLSQLERLYYKKILCNNEGPKLESINSDWKRKLPKSVIISQAIPKKKKVLE');
INSERT INTO proteininfo VALUES ('6324926', 'NP_014995.1','similar to Lucilia illustris mitochondria cytochrome oxidase; Mne1p [Saccharomyces cerevisiae]','MKLLFKRYSSSHIGKLIKDSLITPEILPQLGRQPSSHKRLPNNKRTNSITDKWLKDALTRKDKLNEDKLQNVNLRLNVVLTTLQKLRTSDNPALYFALLNRIGTGHIKWLNKSGRQIDAFPPDRLPLEFYHELSNMLYKLSLRSANDKIALAKFSLQLLDRYYFLKTKSLTIEGKFRANIKFLRNCTLLIVKSQSNYYLRAIQRLFAENSEGQLLANLSQLAFYVETSQWTSMLDILSSCVPDSGLRGSKERERAIQLLELFSPCLVKSLKVMIAQNMENEACQILRSLSEWNFHFDQHDSSNLIQLSQNHSCLKVIETMNGLSSTTAVTRQFGLEKLPTDVSLKQSIHILSKDNFEPLKQDSFLQFLSFKLSDLPLNLEVWKKHIKEVDDQMQAESNLHSLRAFFIDMLLCHLSVRKDFDFMLSLVEHIVYEKNLWQPLLLTDNIVGNKENSTFHCLFHGASQDISTKLTLLALYNQLNEIGYQFTSHDFLSMLKVCKNYSDSDFFYFAFYNLLVTQSHKFFLFDKFSDKFSWRLPIQIGDAISEWLSSLEIDIQENTDRVLQITDDVGEWYVENKPFKSEKGTIQPINIMELRKIFGERKTLFHMDSEIFQKSKAKRDKEMRNEALFTANDAEYNFAADVSYAKRVENLFSYIRSKQMQQK');
INSERT INTO proteininfo VALUES ('6324925', 'NP_014994.1','Tubulin folding factor D involved in beta-tubulin (Tub2p) folding; isolated as mutant with increased chromosome loss and sensitivity to benomyl; Cin1p [Saccharomyces cerevisiae]','MNNIRALLDSIQSGVQTVSPEKHQQTIAAINKFQDDPALLDTILPRCVPLLTKSFFCMSQRDQKLVAELFYNLDKISHSKVLKSLDTSIFRLNEILNYLQDRASPSSFSDVLCVYLNLSWLSVILLSPYAFKDKFNKTLQVSSRFENYPICIPPINKIKAVLYFKNFTDAFDQLPEREQANVPFLNQFLKLFIQSSEKANYYFSNENLRHLQQVALSNDGIKLLPKLFQISFNHGSHDILDAIVEFFHDHLSSNSTDTRFQLAHSFAKIAKFLHQADPASFIELIDYTIENTVSLLQAPCDSIDSNELHTSLLIIAEVALAKILPIDLVDRVLTLIIPKTCHFQKSHFQIIKGHHIRDSTNFIIWSVIRSNRSNSLSPQVLQSLLSHLLINAFFDPELIIRYSSFAALQELLGRSNKSLALNQNDIALILQANWKDLPRSFEENSGLIRRLFNPENTSKSAVCVWKVFRDWSFNWNLLENLHLTTMKLNIDYNLVPLIKSKLSSPALLQEVLNKAGSSVTQNCQILYLYLKLFENDVNCPKISEICIDIYQKKIKFQLTTQAKRQFNDNSPELFQIFVILKYWQLTGQNDFNQELFWKFVDIVSPQKKLNLYNEFIPIIQQIISQCVSLNYTRIVQLIKSDNELTCRSICHMPDQEKMCSLFFSQFPLLSPQSRSLLIGELDHHWDVRISLLPSNSYRKFRNIIINCLDDYTITQQGDVGRLVRIQALKLMQSHPDFLSGDCDSINPKLTRLLAEPVPEIRKLSYQLLASATSQITVLSDSSILNFRHKQGLSEEFWKGYAVSAGAIHFTDSQLTSSIDSFIVYYRSLSPSQQLELCHDLIRIIPSAKQIAESRIRDRNKDPLTGGMRFDTIKFTIHCVKFWTRIMESGLVVLHPNFNFQGVFAKFYNLHLLDCTTLRVSVIKFFPFLAISCYHTMRENADQKNLSNIILKRLLVLVKREYAATKSKFMTDQNVALQGMFQIFLELGVTRQLQALQVACQKHELANILESDITL');
INSERT INTO proteininfo VALUES ('6324924', 'NP_014993.1','proline-specific permease (also capable of transporting alanine and glycine); putative proline-specific permease; Put4p [Saccharomyces cerevisiae]','MVNILPFHKNNRHSAGVVTCADDVSGDGSGGDTKKEEDVVQVTESPSSGSRNNHRSDNEKDDAIRMEKISKNQSASSNGTIREDLIMDVDLEKSPSVDGDSEPHKLKQGLQSRHVQLIALGGAIGTGLLVGTSSTLHTCGPAGLFISYIIISAVIYPIMCALGEMVCFLPGDGSDSAGSTANLVTRYVDPSLGFATGWNYFYCYVILVAAECTAASGVVEYWTTAVPKGVWITIFLCVVVILNFSAVKVYGESEFWFASIKILCIVGLIILSFILFWGGGPNHDRLGFRYWQHPGAFAHHLTGGSLGNFTDIYTGIIKGAFAFILGPELVCMTSAECADQRRNIAKASRRFVWRLIFFYVLGTLAISVIVPYNDPTLVNALAQGKPGAGSSPFVIGIQNAGIKVLPHIINGCILTSAWSAANAFMFASTRSLLTMAQTGQAPKCLGRINKWGVPYVAVGVSFLCSCLAYLNVSSSTADVFNWFSNISTISGFLGWMCGCIAYLRFRKAIFYNGLYDRLPFKTWGQPYTVWFSLIVIGIITITNGYAIFIPKYWRVADFIAAYITLPIFLVLWFGHKLYTRTWRQWWLPVSEIDVTTGLVEIEEKSREIEEMRLPPTGFKDKFLDALL');
INSERT INTO proteininfo VALUES ('6324923', 'NP_014992.1','Pyruvate kinase, glucose-repressed isoform; pyruvate kinase; Pyk2p [Saccharomyces cerevisiae]','MPESRLQRLANLKIGTPQQLRRTSIIGTIGPKTNSCEAITALRKAGLNIIRLNFSHGSYEFHQSVIENAVKSEQQFPGRPLAIALDTKGPEIRTGRTLNDQDLYIPVDHQMIFTTDASFANTSNDKIMYIDYANLTKVIVPGRFIYVDDGILSFKVLQIIDESNLRVQAVNSGYIASHKGVNLPNTDVDLPPLSAKDMKDLQFGVRNGIHIVFASFIRTSEDVLSIRKALGSEGQDIKIISKIENQQGLDNFDEILEVTDGVMIARGDLGIEILAPEVLAIQKKLIAKCNLAGKPVICATQMLDSMTHNPRPTRAEVSDVGNAVLDGADCVMLSGETAKGDYPVNAVNIMAATALIAESTIAHLALYDDLRDATPKPTSTTETVAAAATAAILEQDGKAIVVLSTTGNTARLLSKYRPSCPIILVTRHARTARIAHLYRGVFPFLYEPKRLDDWGEDVHRRLKFGVEMARSFGMVDNGDTVVSIQGFKGGVGHSNTLRISTVGQEF');
INSERT INTO proteininfo VALUES ('6324921', 'NP_014991.1','Protein required for mutagenesis by physical and chemical agents; deoxycytidyl transferase; Rev1p [Saccharomyces cerevisiae]','MGEHGGLVDLLDSDLEYSINRETPDKNNCLSQQSVNDSHLTAKTGGLNARSFLSTLSDDSLIEYVNQLSQTNKNNSNPTAGTLRFTTKNISCDELHADLGGGEDSPIARSVIEIQESDSNGDDVKKNTVYTREAYFHEKAHGQTLQDQILKDQYKDQISSQSSKIFKNCVIYINGYTKPGRLQLHEMIVLHGGKFLHYLSSKKTVTHIVASNLPLKKRIEFANYKVVSPDWIVDSVKEARLLPWQNYSLTSKLDEQQKKLDNCKTVNSIPLPSETSLHKGSKCVGSALLPVEQQSPVNLNNLEAKRIVACDDPDFLTSYFAHSRLHHLSAWKANLKDKFLNENIHKYTKITDKDTYIIFHIDFDCFFATVAYLCRSSSFSACDFKRDPIVVCHGTKNSDIASCNYVARSYGIKNGMWVSQAEKMLPNGIKLISLPYTFEQFQLKSEAFYSTLKRLNIFNLILPISIDEAVCVRIIPDNIHNTNTLNARLCEEIRQEIFQGTNGCTVSIGCSDSLVLARLALKMAKPNGYNITFKSNLSEEFWSSFKLDDLPGVGHSTLSRLESTFDSPHSLNDLRKRYTLDALKASVGSKLGMKIHLALQGQDDEESLKILYDPKEVLQRKSLSIDINWGIRFKNITQVDLFIERGCQYLLEKLNEINKTTSQITLKLMRRCKDAPIEPPKYMGMGRCDSFSRSSRLGIPTNEFGIIATEMKSLYRTLGCPPMELRGLALQFNKLVDVGPDNNQLKLRLPFKTIVTNRAFEALPEDVKNDINNEFEKRNYKRKESGLTSNSLSSKKKGFAISRLEVNDLPSTMEEQFMNELPTQIRAEVRHDLRIQKKIQQTKLGNLQEKIKRREESLQNEKNHFMGQNSIFQPIKFQNLTRFKKICQLVKQWVAETLGDGGPHEKDVKLFVKYLIKLCDSNRVHLVLHLSNLISRELNLCAFLNQDHSGFQTWERILLNDIIPLLNRNKHTYQTVRKLDMDFEV');
INSERT INTO proteininfo VALUES ('6324920', 'NP_014989.1','may be involved in glycolytic gene expression; TYE7, a 33 kDa serine-rich protein, is a potential member of the basic region/helix-loop-helix/leucine-zipper protein family; Tye7p [Saccharomyces cerevisiae]','MNSILDRNVRSSETTLIKPESEFDNWLSDENDGASHINVNKDSSSVLSASSSTWFEPLENIISSASSSSIGSPIEDQFISSNNEESALFPTDQFFSNPSSYSHSPEVSSSIKREEDDNALSLADFEPASLQLMPNMINTDNNDDSTPLKNEIELNDSFIKTNLDAKETKKRAPRKRLTPFQKQAHNKIEKRYRININTKIARLQQIIPWVASEQTAFEVGDSVKKQDEDGAETAATTPLPSAAATSTKLNKSMILEKAVDYILYLQNNERLYEMEVQRLKSEIDTLKQDQK');
INSERT INTO proteininfo VALUES ('6324918', 'NP_014987.1','Hypothetical ORF; Yor342cp [Saccharomyces cerevisiae]','MTILEELNDSSIPQRLDNHIFFGSVHSLTHTDFLVENNIRFFINVDLSTELISHIYHEVRSKFAHEIVIVNIDNDSQIPIESDLVRSFHWHNTSLLQQLIHHLDFLSGINNHGEPLTPPPESHYRNAYVQFDHPSDSVSILDKLLYGNKSEYSRTNIFQVTNEAKFQVFNDLITIFKYSIAQGGNTNSNILVLSENGSTDENLISLLMSTVLKENPTFNVYQALQFVKSIAVIPDTVRDEKILWVTGFINYQELIKKNEMYWGLGSQKGRKLTSFASPISKVERKQRRRDDQNIMRSKLPQQRQNPFCSTERPKRARCD');
INSERT INTO proteininfo VALUES ('6324917', 'NP_014986.1','RNA polymerase I subunit alpha; largest subunit of RNA polymerase I; Rpa190p [Saccharomyces cerevisiae]','MDISKPVGSEITSVDFGILTAKEIRNLSAKQITNPTVLDNLGHPVSGGLYDLALGAFLRNLCSTCGLDEKFCPGHQGHIELPVPCYNPLFFNQLYIYLRASCLFCHHFRLKSVEVHRYACKLRLLQYGLIDESYKLDEITLGSLNSSMYTDDEAIEDNEDEMDGEGSKQSKDISSTLLNELKSKRSEYVDMAIAKALSDGRTTERGSFTATVNDERKKLVHEFHKKLLSRGKCDNCGMFSPKFRKDGFTKIFETALNEKQITNNRVKGFIRQDMIKKQKQAKKLDGSNEASANDEESFDVGRNPTTRPKTGSTYILSTEVKNILDTVFRKEQCVLQYVFHSRPNLSRKLVKADSFFMDVLVVPPTRFRLPSKLGEEVHENSQNQLLSKVLTTSLLIRDLNDDLSKLQKDKVSLEDRRVIFSRLMNAFVTIQNDVNAFIDSTKAQGRTSGKVPIPGVKQALEKKEGLFRKHMMGKRVNYAARSVISPDPNIETNEIGVPPVFAVKLTYPEPVTAYNIAELRQAVINGPDKWPGATQIQNEDGSLVSLIGMSVEQRKALANQLLTPSSNVSTHTLNKKVYRHIKNRDVVLMNRQPTLHKASMMGHKVRVLPNEKTLRLHYANTGAYNADFDGDEMNMHFPQNENARAEALNLANTDSQYLTPTSGSPVRGLIQDHISAGVWLTSKDSFFTREQYQQYIYGCIRPEDGHTTRSKIVTLPPTIFKPYPLWTGKQIITTVLLNVTPPDMPGINLISKNKIKNEYWGKGSLENEVLFKDGALLCGILDKSQYGASKYGIVHSLHEVYGPEVAAKVLSVLGRLFTNYITATAFTCGMDDLRLTAEGNKWRTDILKTSVDTGREAAAEVTNLDKDTPADDPELLKRLQEILRDNNKSGILDAVTSSKVNAITSQVVSKCVPDGTMKKFPCNSMQAMALSGAKGSNVNVSQIMCLLGQQALEGRRVPVMVSGKTLPSFKPYETDAMAGGYVKGRFYSGIKPQEYYFHCMAGREGLIDTAVKTSRSGYLQRCLTKQLEGVHVSYDNSIRDADGTLVQFMYGGDAIDITKESHMTQFEFCLDNYYALLKKYNPSALIEHLDVESALKYSKKTLKYRKKHSKEPHYKQSVKYDPVLAKYNPAKYLGSVSENFQDKLESFLDKNSKLFKSSDGVNEKKFRALMQLKYMRSLINPGEAVGIIASQSVGEPSTQMTLNTFHFAGHGAANVTLGIPRLREIVMTASAAIKTPQMTLPIWNDVSDEQADTFCKSISKVLLSEVIDKVIVTETTGTSNTAGGNAARSYVIHMRFFDNNEYSEEYDVSKEELQNVISNQFIHLLEAAIVKEIKKQKRTTGPDIGVAVPRLQTDVANSSSNSKRLEEDNDEEQSHKKTKQAVSYDEPDEDEIETMREAEKSSDEEGIDSDKESDSDSEDEDVDMNEQINKSIVEANNNMNKVQRDRQSAIISHHRFITKYNFDDESGKWCEFKLELAADTEKLLMVNIVEEICRKSIIRQIPHIDRCVHPEPENGKRVLVTEGVNFQAMWDQEAFIDVDGITSNDVAAVLKTYGVEAARNTIVNEINNVFSRYAISVSFRHLDLIADMMTRQGTYLAFNRQGMETSTSSFMKMSYETTCQFLTKAVLDNEREQLDSPSARIVVGKLNNVGTGSFDVLAKVPNAA');
INSERT INTO proteininfo VALUES ('6324916', 'NP_014985.1','RNA polymerase I subunit A43; Rpa43p [Saccharomyces cerevisiae]','MSQVKRANENRETARFIKKHKKQVTNPIDEKNGTSNCIVRVPIALYVSLAPMYLENPLQGVMKQHLNPLVMKYNNKVGGVVLGYEGLKILDADPLSKEDTSEKLIKITPDTPFGFTWCHVNLYVWQPQVGDVLEGYIFIQSASHIGLLIHDAFNASIKKNNIPVDWTFVHNDVEEDADVINTDENNGNNNNEDNKDSNGGSNSLGKFSFGNRSLGHWVDSNGEPIDGKLRFTVRNVHTTGRVVSVDGTLISDADEEGNGYNSSRSQAESLPIVSNKKIVFDDEVSIENKESHKELDLPEVKEDNGSEIVYEENTSESNDGESSDSD');
INSERT INTO proteininfo VALUES ('6324915', 'NP_014984.1','Ubiquitin-conjugating enzyme most similar in sequence to Xenopus ubiquitin-conjugating enzyme E2-C, but not a true functional homolog of this E2; unlike E2-C, not required for the degradation of mitotic cyclin Clb2; Ubc11p [Saccharomyces cerevisiae]','MAVEEGGCVTKRLQNELLQLLSSTTESISAFPVDDNDLTYWVGYITGPKDTPYSGLKFKVSLKFPQNYPFHPPMIKFLSPMWHPNVDKSGNICLDILKEKWSAVYNVETILLSLQSLLGEPNNRSPLNAVAAELWDADMEEYRKKVLACYEEIDDY');
INSERT INTO proteininfo VALUES ('6324914', 'NP_014983.1','Hypothetical ORF; Yor338wp [Saccharomyces cerevisiae]','MLDNMQFHSPAPEHPQLNGGINKIPASHKIGYKLNQQVQRLAVVRNNIEERLNSMESSHGQISDSSVVRAIDASIDDFLIPSPPLSPKLRQCPIISQPQLVNVESDHRELIMLTPVWEAGLNSQKYNHNTRNFLSQYSFFRDMKTTKRIPNKENRKLKVVKSVVNSEALPKRRRYDRKIKRRSRELYEDDGNRSENYDEESAQEVPVRSVTPIRQVKRSLHTISSPLASQGVVNNVPKYIPSMSWEKLPDYSPPLHTLPNSNNKVLKVEWKGSPMDLNHDPLKQRLHPAELVLAQILRLPCDLYLDSKRRFFLEKVHRFKKGLPFRRTDAQKACRIDVNKASRLFAAFEKVGWLQDKHFEKYL');
INSERT INTO proteininfo VALUES ('6324913', 'NP_014982.1','Mutants are defective in Ty1 Enhancer-mediated Activation; Ty1 enhancer activator; Tea1p [Saccharomyces cerevisiae]','MTAPLWPNKNEKNHTVKRALSTDMTSNILSSTNASSNEENSRSSSAANVRSGTGANTLTNGGSTRKRLACTNCRNRRKKCDLGFPCGNCSRLELVCNVNDEDLRKKRYTNKYVKSLESHIAQLETNLKNLVQKIYPDDEQILNRMMVGDVLSALPDSSQVSINYTDQTPSLPIPATRGTFIIENDKVSQPLSSFNQQTEPSTLNSGIFNTQKQNFEESLDDQLLLRRSLTPQGEKKKKPLVKGSLYPEGPVSYKRKHPVKSDSLLPVSSLTAATDPSTFSDGITAGNSVLVNGELKKRISDLKTTVIVRGLNDDNPNSINNDPRILKSLSNFYKWLYPGYFIFVHRESFLYGFFNHSKNNYEDSSYCSVELIYAMCAVGSRLTPDLQEYSEVYYQRSKKTLLQLVFDEQSTARITTVQALFCLAFYELGKGNNQLGWYFSGLAIRVGYDMGFQLDPKVWYVDDNNLQLTQSELEIRSRIYWGCYIADHFICLMLGRTSTLSVSNSTMPESDELPEVNGTEEFRFIGRHVLQISLPLKNLIILSRLVQIFTSKIFIESEDIARKLKYLNTFNSQVYNWRQSLPEFLQWSKTLIENDDVSTDPTISYFWYCYYIVRLTFNKPFIEDSQESETVVIEIIDDLKTLLDNFGKKFGNYTKGNLYQLYSCLLAINCLKKLKEIRSSEQDSWNAQLDFFNHIFYTQLYPAYDLPKKLQEDTELETEQENQMLNQVGNINYTHDFSLSHEIDDLIRELFGVGTPQKL');
INSERT INTO proteininfo VALUES ('6324912', 'NP_014981.1','appears to function early in (1,6)-beta-D-glucan synthesis pathway; involved in cell wall biogenesis; Kre5p [Saccharomyces cerevisiae]','MRLLALVLLLLCAPLRAWTYSLRYGIPESAQVWSILVHLLGDVDNQLLTNLYPLVTGLDDEIDIQENLVALTSNVLRERYDKEDVADLLELYASLYPMGMIQHDISSNAEQDDANSSYFVLNGNRYEKPDDVFYLKSKDLTIQQKVPDVDVIQPYDVVIGTNSEAPILILYGCPTVIDSDFEEFNRNLFMEAMNGEGKFRFIWRSTCSLDGKSVEYPLTHPLEITLQNGSRMSSIPQLKKILYTVPKEILVGADNDDQLHDLEPEELRELDLRVTSLISEFYQYKKDITATLNFTKSIVNNFPLISKQLIKVSSVNKDIITSNEELNSKGFDYNMLGLYINGQNWKITSLTPYNLLTALKTEYQSLLKITNLLQELEPSKCILDSKFLLNKFSQFSLGKLQNLQPIKMDLHTIPGFSESVIYFNDIESDPQYDELVNSVQAFFDKSKFGELPEIKQNWSEIIFVIDFARLEDSEVKEALGGLVRAVNVVSQGYPQRVGLLPFSSDSDKSVVNKIYELKNSTDNLTELKSFLETMLLADGLSANAKHSKHIPVPDVFHLLDELQIDETSIIINGEIYPFRKNAWNYLIAKVIKKDTEFIRKELSNSSPKNKQISVRDLLHYKSANLRHNKYTPNYFADSVYSSVNNTALESVCSERIGYYTKNEEYNLLHTITLVDDFGSIHALKRLRNLLHTSFVGVRIRIIHVGDISDIWYQLRGSLSQKDPIGSINTFIDALKLKKVKSHTYKKSGLNQLGLHKWLPDIPLFELQKGSFIALNGRFIHLDQNEVPETEHFEAIIKREALRTIDSVFALDLLFPGFSQEIINPDLIEMISSILTRLFYQGTHIYNNGIDYTTESSLPRMDLSEFFRPNNLTMFEDGKSASIDLLLILDPLEERTQMILSLVEQFRPLKFVNIQVILMPTLELNIVPIRRIYVDDADIVKSITSEDSRSDPEVDIEMDVPNSFIVDNNYRIKKLLIELHSFSSKTVLSTGNIDGMGGVCLALVDSAGNIIDKTTTMKTFGYGQFHTDKFLKGCYIKSCDSRYTVQSFSTDGHPDFIPSDSLDILSYNPQKIAVKISEEPTHEEEYEEGRNNDTIINIFTILESGPDEEERYMQMILSILSKCPETQKVNFFILDQPFISDTLRKSCEYINSSDEMRGNVIFLNYEWPQWLRPQRFSSRRRDVSRFLFLDVLLPQNISKVLYMSPTEVPLDPFDIFQFQGLKRAPLGLFRMSGDGYWKEGYWEKMLRENNLEFYSTEPAFLVNLERFRELDAGDKYRIHYQRISTDAMSLVNIGQDLVNNLQLEVPIRFLKGSYKKKLVINDECVSEWKKKINKFASSPGDEDVPGESVSSKYQDSDNAAPLHDEL');
INSERT INTO proteininfo VALUES ('6324911', 'NP_014980.1','Cytoplasmic alanyl-tRNA synthetase, required for protein synthesis; point mutation (cdc64-1 allele) causes cell cycle arrest at G1; lethality of null mutation is functionally complemented by human homolog; Ala1p [Saccharomyces cerevisiae]','MTIGDKQKWTATNVRNTFLDYFKSKEHKFVKSSPVVPFDDPTLLFANAGMNQYKPIFLGTVDPASDFYTLKRAYNSQKCIRAGGKHNDLEDVGKDSYHHTFFEMLGNWSFGDYFKKEAITYSWTLLTEVYGIPKDRLYVTYFEGDEKLGLEPDTEARELWKNVGVPDDHILPGNAKDNFWEMGDQGPCGPCSEIHYDRIGGRNAASLVNMDDPDVLEVWNLVFIQFNREQDGSLKPLPAKHIDTGMGFERLVSVLQDVRSNYDTDVFTPLFERIQEITSVRPYSGNFGENDKDGIDTAYRVLADHVRTLTFALADGGVPNNEGRGYVLRRILRRGARYARKYMNYPIGNFFSTLAPTLISQVQDIFPELAKDPAFLFEILDEEEASFAKTLDRGERLFEKYASAASKTESKTLDGKQVWRLYDTYGFPVDLTELMAEEQGLKIDGPGFEKAKQESYEASKRGGKKDQSDLIKLNVHELSELNDAKVPKTNDEFKYGSANVEGTILKLHDGTNFVDEITEPGKKYGIILDKTCFYAEQGGQEYDTGKIVIDDAAEFNVENVQLYNGFVFHTGSLEEGKLSVGDKIIASFDELRRFPIKNNHTGTHILNFALKETLGNDVDQKGSLVAPEKLRFDFSHKKAVSNEELKKVEDICNEQIKENLQVFYKEIPLDLAKSIDGVRAVFGETYPDPVRVVSVGKPIEELLANPANEEWTKYSIEFCGGTHVNKTGDIKYFVILEESGIAKGIRRIVAVTGTEAFEAQRLAEQFAADLDAADKLPFSPIKEKKLKELGVKLGQLSISVITKNELKQKFNKIEKAVKDEVKSRAKKENKQTLDEVKTFFETNENAPYLVKFIDISPNAKAITEAINYMKSNDSVKDKSIYLLAGNDPEGRVAHGCYISNAALAKGIDGSALAKKVSSIIGGKAGGKGNVFQGMGDKPAAIKDAVDDLESLFKEKLSI');
INSERT INTO proteininfo VALUES ('6324909', 'NP_014979.1','Mitochondrial inner membrane Mg(2+) channel, required for maintenance of intramitochondrial Mg(2+) concentrations at the correct level to support splicing of group II introns; Mrs2p [Saccharomyces cerevisiae]','MNRRLLVRSISCFQPLSRITFGRPNTPFLRKYADTSTAANTNSTILRKQLLSLKPISASDSLFISCTVFNSKGNIISMSEKFPKWSFLTEHSLFPRDLRKIDNSSIDIIPTIMCKPNCIVINLLHIKALIERDKVYVFDTTNPSAAAKLSVLMYDLESKLSSTKNNSQFYEHRALESIFINVMSALETDFKLHSQICIQILNDLENEVNRLKLRHLLIKSKDLTLFYQKTLLIRDLLDELLENDDDLANMYLTVKKSPKDNFSDLEMLIETYYTQCDEYVQQSESLIQDIKSTEEIVNIILDANRNSLMLLELKVTIYTLGFTVASVLPAFYGMNLKNFIEESEWGFTSVAVFSIVSALYITKKNFNSLRSVTKMTMYPNSPANSSVYPKTSASIALTNKLKRRRKWWKSTKQRLGVLLYGSSYTNKANLSNNKINKGFSKVKKFNMENDIKNKQNRDMIWKWLIEDKKN');
INSERT INTO proteininfo VALUES ('6324907', 'NP_014977.1','vacuolar ATPase V1 domain subunit E (27 kDa); Vma4p [Saccharomyces cerevisiae]','MSSAITALTPNQVNDELNKMQAFIRKEAEEKAKEIQLKADQEYEIEKTNIVRNETNNIDGNFKSKLKKAMLSQQITKSTIANKMRLKVLSAREQSLDGIFEETKEKLSGIANNRDEYKPILQSLIVEALLKLLEPKAIVKALERDVDLIESMKDDIMREYGEKAQRAPLEEIVISNDYLNKDLVSGGVVVSNASDKIEINNTLEERLKLLSEEALPAIRLELYGPSKTRKFFD');
INSERT INTO proteininfo VALUES ('6324906', 'NP_014975.1','catalytic subunit of mitochondrial DNA polymerase; Mip1p [Saccharomyces cerevisiae]','MDYERTVLKKRSRWGLYVVVEQRGTSMTKLMVRSECMLRMVRRRPLRVQFCARWFSTKKNTAEAPRINPVGIQYLGESLQRQVFGSCGGKDEVEQSDKLMELSKKSLKDHGLWGKKTLITDPISFPLPPLQGRSLDEHFQKIGRFNSEPYKSFCEDKFTEMVARPAEWLRKPGWVKYVPGMAPVEVAYPDEELVVFDVETLYNVSDYPTLATALSSTAWYLWCSPFICGGDDPAALIPLNTLNKEQVIIGHNVAYDRARVLEEYNFRDSKAFFLDTQSLHIASFGLCSRQRPMFMKNNKKKEAEVESEVHPEISIEDYDDPWLNVSALNSLKDVAKFHCKIDLDKTDRDFFASTDKSTIIENFQKLVNYCATDVTATSQVFDEIFPVFLKKCPHPVSFAGLKSLSKCILPTKLNDWNDYLNSSESLYQQSKVQIESKIVQIIKDIVLLKDKPDFYLKDPWLSQLDWTTKPLRLTKKGVPAKCQKLPGFPEWYRQLFPSKDTVEPKITIKSRIIPILFKLSWENSPVIWSKESGWCFNVPHEQVETYKAKNYVLADSVSQEEEEIRTHNLGLQCTGVLFKVPHPNGPTFNCTNLLTKSYNHFFEKGVLKSESELAHQALQINSSGSYWMSARERIQSQFVVPSCKFPNEFQSLSAKSSLNNEKTNDLAIIIPKIVPMGTITRRAVENAWLTASNAKANRIGSELKTQVKAPPGYCFVGADVDSEELWIASLVGDSIFNVHGGTAIGWMCLEGTKNEGTDLHTKTAQILGCSRNEAKIFNYGRIYGAGAKFASQLLKRFNPSLTDEETKKIANKLYENTKGKTKRSKLFKKFWYGGSESILFNKLESIAEQETPKTPVLGCGITYSLMKKNLRANSFLPSRINWAIQSSGVDYLHLLCCSMEYIIKKYNLEARLCISIHDEIRFLVSEKDKYRAAMALQISNIWTRAMFCQQMGINELPQNCAFFSQVDIDSVIRKEVNMDCITPSNKTAIPHGEALDINQLLDKSNSKLGKPNLDIDSKVSQYAYNYREPVFEEYNKSYTPEFLKYFLAMQVQSDKRDVNRLEDEYLRECTSKEYARDGNTAEYSLLDYIKDVEKGKRTKVRIMGSNFLDGTKNAKADQRIRLPVNMPDYPTLHKIANDSAIPEKQLLENRRKKENRIDDENKKKLTRKKNTTPMERKYKRVYGGRKAFEAFYECANKPLDYTLETEKQFFNIPIDGVIDDVLNDKSNYKKKPSQARTASSSPIRKTAKAVHSKKLPARKSSTTNRNLVELERDITISREY');
INSERT INTO proteininfo VALUES ('6324905', 'NP_014974.1','Multicopy suppressor of clathrin deficiency and of ts ipl1 mutants; Scd5p [Saccharomyces cerevisiae]','MSFDWLNVPGLDLSSGDQAEKRPSNGLGPPSVSFDFGINTAAPHDSSFWDQGSRSHSDTTLSYRNNHSNTAADNATNVSSPQKDNPPNGEVRTLSGGDVYAESPEDMQVPLSLSQNQLTHEEIRTYLRWYHYICLRTHGKLVRLNDVFRFLTNFNLSQKVKDRIVEIFRSCKNALNIGQFFAVLRLVSRAIIYGILPLRRMILEKAPVPKPRPILSSENHEEVYEEVEDDDSSAKTGDQKVDFDSFASLLLTGKTTRKRVRRRIKNLNFKSKKVRFSEHITFQDPPNLNQESSNNSEARKQDPDAEDEDQDSNNDSPLDFTLPMDQLLKRLYKRRKNSGLVSSLPSEQQETEEEKKVLEDMKDSLSHFKQIQTVDSASLPISSVFLQNGNTLPTSNVNNTTVPQQLPLEPLKPTATGSANHLVREEYNQGLHPSNGAIQTGLQPLKPTATGSANYLMRSHMEQPQSIKPSSTPETVTNSGGLQPLKPTATGSANYLMKQHISPSVNNPVSSMFQAQFTNQSSSPQSTGPAFLNSPNITLPQSNQQQPYQEVNPTQAKIEPSNISPQHTYSNNVRINNGNIVSMPKVEITGAFPPQNTLPQHQQSHLLSPQNTIPQHQRSQLISPQNTFTQNQPILSPQHTYSNNQATMISPQNTYTNNQQQPQHLPPPPPPRAQQQQQGAIVPPQHMYSNVQKQNNLVPTQPSYTNSPSIQSPNFLSPQNAANSYFQSLLSSSPSPNPTPSNASTVNGNNASNGISSFQNTSAAMNNTQSHQTYIQQQQQQQTQQRIYGGQLSQMQQHPGQLHLNNSDIHSQPNKPNYGMLGQQVHQQQQQQQQQFPFTADVNRSNSSDILGNLQSLQQQVDALQIQYNRRP');
INSERT INTO proteininfo VALUES ('6324904', 'NP_014973.1','Putative ABC transporter highly similar to Pdr5p; Pdr10p [Saccharomyces cerevisiae]','MLQAPSSSNSGLNQGNAAPDGPPNETQPYEGLDAAAQEEIKELARTLTSQSSLLSQEKRITGTGDPNTLTAASSSSLSRSIFASDIKGVNPILLDVNDPDYDETLDPRSENFSSVRWVRNMAQICENDSDFYKPFSLGCAWKDLSASGDSADITYQGTFGNMPIKYLKMSWRCISRRLFHRTHGKSEDNDSGFQILKPMDGCINPGELLVVLGRPGAGCTTLLKSISVNTHGFKISPDTIITYNGFSNKEIKNHYRGEVVYNAESDIHIPHLTVFQTLYTVARLKTPRNRIKGVDRDTFAKHMTEVAMATYGLSHTADTKVGNDFVRGVSGGERKRVSIAEVSICGSKFQCWDNATRGLDSATALEFIKALKTQATITKSAATVAIYQCSKDAYDLFDKVCVLYDGYQIFFGPSKQAKKYFQRMGYVCPERQTTADYLTSITSPSERIKDKDMVKHGIMIPQTAYEMNQYWIQSEEYKQLQVQVNKHLDTDSSQQREQIKNAHIAKQSKRARPSSPYTVSFFLQVKYILIRDIWRIKNDPSIQLFTVLSHAAMALILGSMFYEVMLSTTTTTFYYRGAAIFFAILFNAFSSLLEIFSLYETRPITEKHKTYSLYRPSADAFASTFSDVPTKLATAVTFNIPYYFLINLKRDAGAFFFYFLINIITVFAMSHLFRCIGSVSKTLPQAMVPASVLLLAFAMYTGFAIPRVQMLGWSKWISYINPLSYLFESLMINEFHGRNFPCAQYIPSGPNYVNATGDEVTCSALGSIPGNNYVSGDDFIQTNYGYRHKNKWRSVGIGLAYIIFFLFLYLFFCEYNEGAKQNGEMLVFPHSVVKKMKKKGIVSEKKKKNQPTLSTSDAEKDVEMNNNSSATDSRFLRDSDAAIMGNDKTVAKEHYSSPSSSASQSNSFSKSDDIELSKSQAIFHWKNLCYDIPIKNGKRRILDNVDGWVKPGTLTALIGASGAGKTTLLDCLAERTTMGLITGDVFVDGRPRDQSFPRSIGYCQQQDLHLKTATVRESLRFSAYLRQADDVSIEEKDKYVEEVIEVLEMKLYADAIVGVPGEGLNVEQRKRLTIGVELAAKPKLLVFLDEPTSGLDSQTAWSTCQLMKKLASRGQAILCTIHQPSALLMQEFDRLLFLQEGGQTVYFGELGKGCKTMINYFEAHGAHKCPPDANPAEWMLEIVGAAPGTHASQDYFAIWRDSEEYREMQKELDWMERELPKRTEGSSNEEQKEFATSTLYQIKLVSYRLFHQYWRTPFYLWSKFFSTIVSELFIGFTFFKANTSLQGLQNQMLAIFMFTVVFNPILQQYLPLFVQQRELYEARERPSRTFSWKAFIVSQILVEIPWNLLAGTIAFFVYYYPVGFYRNASYANQLHERGALFWLFACAFYVYISSMGVLVISCIEIAENAANLASLFFIMSLSFCGVLATPNILPRFWIFMYRVSPLTYLIDALLSVGLANASVVCSSNELLKIVPPSGMTCSEYMEPYMQSTGTGYLLDGSSETECHFCQFSSTNDYLATVSSSYSRRWMNYGIFSAYIVFDYCAAIFLYWLVRVPKKSKKLKK');
INSERT INTO proteininfo VALUES ('6324903', 'NP_014972.1','mediate the targeting and transport of secretory proteins; vesicle-associated membrane protein (synaptobrevin) homolog; Snc2p [Saccharomyces cerevisiae]','MSSSVPYDPYVPPEESNSGANPNSQNKTAALRQEIDDTVGIMRDNINKVAERGERLTSIEDKADNLAISAQGFKRGANRVRKQMWWKDLKMRMCLFLVVIILLVVIIVPIVVHFS');
INSERT INTO proteininfo VALUES ('6324902', 'NP_014971.1','Type V myosin; plays a crucial role in polarized distribution of mitochondria; class V myosin; Myo2p [Saccharomyces cerevisiae]','MSFEVGTRCWYPHKELGWIGAEVIKNEFNDGKYHLELQLEDDEIVSVDTKDLNNDKDQSLPLLRNPPILEATEDLTSLSYLNEPAVLHAIKQRYSQLNIYTYSGIVLIATNPFDRVDQLYTQDMIQAYAGKRRGELEPHLFAIAEEAYRLMKNDKQNQTIVVSGESGAGKTVSAKYIMRYFASVEEENSATVQHQVEMSETEQKILATNPIMEAFGNAKTTRNDNSSRFGKYLEILFDKDTSIIGARIRTYLLERSRLVYQPPIERNYHIFYQLMAGLPAQTKEELHLTDASDYFYMNQGGDTKINGIDDAKEYKITVDALTLVGITKETQHQIFKILAALLHIGNIEIKKTRNDASLSADEPNLKLACELLGIDAYNFAKWVTKKQIITRSEKIVSNLNYSQALVAKDSVAKFIYSALFDWLVENINTVLCNPAVNDQISSFIGVLDIYGFEHFEKNSFEQFCINYANEKLQQEFNQHVFKLEQEEYVKEEIEWSFIEFNDNQPCIDLIENKLGILSLLDEESRLPAGSDESWTQKLYQTLDKSPTNKVFSKPRFGQTKFIVSHYALDVAYDVEGFIEKNRDTVSDGHLEVLKASTNETLINILEGLEKAAKKLEEAKKLELEQAGSKKPGPIRTVNRKPTLGSMFKQSLIELMNTINSTNVHYIRCIKPNADKEAWQFDNLMVLSQLRACGVLETIRISCAGFPSRWTFEEFVLRYYILIPHEQWDLIFKKKETTEEDIISVVKMILDATVKDKSKYQIGNTKIFFKAGMLAYLEKLRSNKMHNSIVMIQKKIRAKYYRKQYLQISQAIKYLQNNIKGFIIRQRVNDEMKVNCATLLQAAYRGHSIRANVFSVLRTITNLQKKIRKELKQRQLKQEHEYNAAVTIQSKVRTFEPRSRFLRTKKDTVVVQSLIRRRAAQRKLKQLKADAKSVNHLKEVSYKLENKVIELTQNLASKVKENKEMTERIKELQVQVEESAKLQETLENMKKEHLIDIDNQKSKDMELQKTIENNLQSTEQTLKDAQLELEDMVKQHDELKEESKKQLEELEQTKKTLVEYQTLNGDLQNEVKSLKEEIARLQTAMSLGTVTTSVLPQTPLKDVMGGGASNFNNMMLENSDLSPNDLNLKSRSTPSSGNNHIDSLSVDRENGVNATQINEELYRLLEDTEILNQEITEGLLKGFEVPDAGVAIQLSKRDVVYPARILIIVLSEMWRFGLTKQSESFLAQVLTTIQKVVTQLKGNDLIPSGVFWLANVRELYSFVVFALNSILTEETFKNGMTDEEYKEYVSLVTELKDDFEALSYNIYNIWLKKLQKQLQKKAINAVVISESLPGFSAGETSGFLNKIFANTEEYTMDDILTFFNSIYWCMKSFHIENEVFHAVVTTLLNYVDAICFNELIMKRNFLSWKRGLQLNYNVTRLEEWCKTHGLTDGTECLQHLIQTAKLLQVRKYTIEDIDILRGICYSLTPAQLQKLISQYQVADYESPIPQEILRYVADIVKKEAALSSSGNDSKGHEHSSSIFITPETGPFTDPFSLIKTRKFDQVEAYIPAWLSLPSTKRIVDLVAQQVVQDGH');
INSERT INTO proteininfo VALUES ('6324901', 'NP_014969.1','Tail-anchored endoplasmic reticulum membrane protein that is a substrate of the phosphatase calcineurin, interacts with homolog Frt2p, promotes cell growth in conditions of high Na+, alkaline pH, and cell wall stress; Frt1p [Saccharomyces cerevisiae]','MNLLIDRMENPGSRNCTLLPPSFPRGFCKGRRASSGDAVKIKESGLQPQPQPEPLQAKTNVAHFSKSSSRLPVIAVNDNPVVPRPSTEVNLGSLLQKEREKEKEEQPALHDRRHLYVTKNRAHGVRQRSLEMTSLPVLGSTKTGKFSDFLFEDDIDNRVGRHSRSYSGASSLDDPFRVSPKTDFNSNRARLSCLSKGRRGSMSVFQSCHTGLAFNQIQGSSSSQRRSSAGSFDYERKRLVNQFLQPSLGNSDPFDTLRESVVFEPSSTAGGIKLGNMHSQSQISVNSSPSTSLFYHDLDGSAVNDSSSFLYSRSNVPAFLSSSAFSSTSSTSSDSEDVDRRSLNGVYPSLGYLTNQRKPRNSSGSSTAPGTDTLGFKYLLNRQKSADSSTRFKSVLKVNNNNGSAATPDSSSNSISKSNSNLNDNIDELNYYQNHISTLLVKIENEMRRNLNDTIIKNENNVQKTIQKYDLLSGELTLLLDEMTTLRTTVINQFLVKLKSDFDEDDNKAFINELKISVEESVAQLQGLERRMEVCQERLNKQKSSLREMDSLIELKNVLNKSKNNTKSIYLYRYFIIDIIAFLLMGGFIVYVKNLLTRFFTR');
INSERT INTO proteininfo VALUES ('6324899', 'NP_014968.1','Gamma-glutamyl phosphate reductase, catalyzes the second step in proline biosynthesis; Pro2p [Saccharomyces cerevisiae]','MSSSQQIAKNARKAGNILKTISNEGRSDILYKIHDALKANAHAIEEANKIDLAVAKETGLADSLLKRLDLFKGDKFEVMLQGIKDVAELEDPVGKVKMARELDDGLTLYQVTAPVGVLLVIFESRPEVIANITALSIKSGNAAILKGGKESVNTFREMAKIVNDTIAQFQSETGVPVGSVQLIETRQDVSDLLDQDEYIDLVVPRGSNALVRKIKDTTKIPVLGHADGICSIYLDEDADLIKAKRISLDAKTNYPAGCNAMETLLINPKFSKWWEVLENLTLEGGVTIHATKDLKTAYFDKLNELGKLTEAIQCKTVDADEEQDFDKEFLSLDLAAKFVTSTESAIQHINTHSSRHTDAIVTENKANAEKFMKGVDSSGVYWNASTRFADGFRYGFGAEVGISTSKIHARGPVGLDGLVSYQYQIRGDGQVASDYLGAGGNKAFVHKDLDIKTVTL');
INSERT INTO proteininfo VALUES ('6324898', 'NP_014967.1','Hypothetical ORF; Yor322cp [Saccharomyces cerevisiae]','MAFSRLTSTHQSNHNGYSNSNKKGQSLPLTLSIDVESPPCVLYGSAMESSGAVLSGLFTVTVVDPYSSAEDKSLKNTESNVSTTSKSLKRKSTFGSALSSRLSSLSASTSNISPSTSSTSISHSPTPANLRIMAGYTKITITSVTLSLVQKIHFHKPFVPNISSMQTCMNCKTKITNMKSWEIQSNTQDLSVGSHSYPFSYLIPGSVPCSSSLGATAETQVKYELIAVVTYIDPHRNSFSSGHSTPRKEGSSSKKRLLQLAMPIAVTRSIPRGPDKNSLRVFPPTELTAAAVLPNVVYPKSTFPLEMKLDGVSSGDRRWRMRKLSWRIEETTRVKAHACPVHKHELRQLEEQVKIKESEKSKKPRSHIKRYGELGPQIRVAVNSLENMPSQRLPGEPGREQAPNSSGPASTGNVGLDDENPVNEDEEDQPGSEFIHPSDDALRQELLMQQQRARQQQLQQELKNNSSLFTEEVRIISKGEMKSGWKTDFDNNGKIELVTEIDCMGLNSGVSNPVMHASTLQTPSTGNKKPSINVACDIQDPNLGLYVSHILAVEIVVAEETLQYANGQPIRKPNSKNKKETNNNTMNVHNPDQRLAELSPIFANRNTPKVRRMGPEDITPVNSNKSNHSTNKEKASNGASNSNIVSVPTGAARVLRMQFRLTVTERSGLGISWDEEVPPIYQDVELLSPPCYELSINNGIKNKLYSTMSTPVRSEDDFVGGSDEDIGNYESQGLEPGPNVQEVTITQNKLTIPPTAHHYQPASSSQRSLTTVQSPPLESVVSVQGSVPFRGHVLTPHSTRDIRIQNFSDFLDSNRITQ');
INSERT INTO proteininfo VALUES ('6324897', 'NP_014966.1','Transfers mannose residues from dolichyl phosphate-D-mannose to specific serine/threonine residues of proteins in the secretory pathway; dolichyl phosphate-D-mannose:protein O-D-mannosyltransferase; Pmt3p [Saccharomyces cerevisiae]','MPYRVATGYSEKSTDDDLIWRTPIVKEELEDADNFLKDDAELYDKVKNESAVSHLDTIVMPIIFTVLGMFTRMYKIGRNNHVVWDEAHFGKFGSYYLRHEFYHDVHPPLGKMLVGLSGYLAGYNGSWDFPSGEVYPDYIDYVKMRLFQAMFSSLCVPLAYFTGRAIGFSRLSVWLFTILVIFENSYATLGKFILLDSMLLFFTVSSYFCLAKFHTMRKSPFSARWWLWLCLTGLNLGCAISVKMVGLFIISVVGIYTISELWNLLSDRSVSWKVYVNHWLARIFGLIIIPVCVFLLCFKIHFDLLSNSGPGDSTMPSLFQASLNGTKVGKGPRDVALGSSIISIKNQALGGALLHSHVQPFPEGSEQQQVTVYGYSDANNEWFFQRIRGVEPWTDAENKTIEFVKGGEMYRLMHRLTGKNLHTHEVPAPISKSEYEVSAYGDVDLGDYKDNWIIEIVEQVGEEDPTLLHPLSTSFRIKNSILGCYLAQSGKHLPEWGFRQGEVVCLKHASKRDKRTWWNIETHENERLPQGEDFVYPKTSFFRNFMQLNSAMMATNNALVPNPEKFDGIASSAWQWPTLNVGVRLCEWSEKSIKYFLLGSPASVWPSSIAVCALIIHVIFLTLKWQRQCVILSDPVERDVFVMAAFYPLLAWLLHYMPFVVMSRVVYAHHYLPTLYFALMILSYYFDMITKRWATRNTGKFLRLGAYIVYGSIVIAGFFYFSPFSFGMDGPVDDYAYLAWLPTWQIVEDIRNT');
INSERT INTO proteininfo VALUES ('6324896', 'NP_014965.1','N-acetylglucosaminyltransferase transferase capable of modification of N-linked glycans in the Golgi apparatus; N-acetylglucosaminyltransferase; Gnt1p [Saccharomyces cerevisiae]','MRLISKRRIRFIVFILFGVLTVFVVSRLVVHFQYNQEIKFYKKYFQQRKDGLHEIYNPLEIKQIPKETIDDLYTARLDKELKNGEVIEWSKFAYVNYVTNADYLCNTLIIFNDLKQEFETKAKLVLLISKDLLDPNTSSNVAYISSLLNKIQAIDEDQVVIKLIDNIVKPKDTTPWNESLTKLLVFNQTEFDRVIYLDNDAILRSSLDELFFLPNYIKFAAPLTYWFLSNSDLEKSYHETRHREKQPINLQSYTKVLTKRIGKGQMIYNHLPSLPHSLYLNSNNIAQDIISSTSSLSPLFDFQSSKKVGKLKFASNLMVINPSKEAFDEIVNVMLPKILNKKEKYDMDLINEEMYNLKKIIYKQFIFFRKVRKLFKPEVLVLPFARYGLLTGSLRNPRHYSIIYNDVLGYKTLDNDGNDIPVGLNDSVAYSKYIHFSDYPLAKPWNYPSMKEFECIVKEEDAEDSKLEHQACDLWNSVYASYIQSREICLV');
INSERT INTO proteininfo VALUES ('6324895', 'NP_014964.1','U2-snRNP associated splicing factor with similarity to the mammalian splicing factor SAP49; proposed to function as a U2-snRNP assembly factor along with Hsh155p and binding partner Cus1p; contains two RNA recognition motifs (RRM); Hsh49p [Saccharomyces cerevisiae]','MNYSADSGNTVYVGNIDPRITKEQLYELFIQINPVLRIKYPKDKVLQAYQGYAFIEFYNQGDAQYAIKIMNNTVRLYDRLIKVRQVTNSTGTTNLPSNISKDMILPIAKLFIKNLADSIDSDQLVKIFNKFGKLIREPEIFYLSNGKLKCAYVYFEDFEKADLAIKSLNNQLVANNRITVDYAFKENGKGNAKYGDDVDRLLNKEALKHNMLK');
INSERT INTO proteininfo VALUES ('6324893', 'NP_014962.1','Long chain fatty acyl-CoA synthetase with a preference for C12:0-C16:0 fatty acids; involved in the activation of imported fatty acids; Faa1p [Saccharomyces cerevisiae]','MVAQYTVPVGKAANEHETAPRRNYQCREKPLVRPPNTKCSTVYEFVLECFQKNKNSNAMGWRDVKEIHEESKSVMKKVDGKETSVEKKWMYYELSHYHYNSFDQLTDIMHEIGRGLVKIGLKPNDDDKLHLYAATSHKWMKMFLGAQSQGIPVVTAYDTLGEKGLIHSLVQTGSKAIFTDNSLLPSLIKPVQAAQDVKYIIHFDSISSEDRRQSGKIYQSAHDAINRIKEVRPDIKTFSFDDILKLGKESCNEIDVHPPGKDDLCCIMYTSGSTGEPKGVVLKHSNVVAGVGGASLNVLKFVGNTDRVICFLPLAHIFELVFELLSFYWGACIGYATVKTLTSSSVRNCQGDLQEFKPTIMVGVAAVWETVRKGILNQIDNLPFLTKKIFWTAYNTKLNMQRLHIPGGGALGNLVFKKIRTATGGQLRYLLNGGSPISRDAQEFITNLICPMLIGYGLTETCASTTILDPANFELGVAGDLTGCVTVKLVDVEELGYFAKNNQGEVWITGANVTPEYYKNEEETSQALTSDGWFKTGDIGEWEANGHLKIIDRKKNLVKTMNGEYIALEKLESVYRSNEYVANICVYADQSKTKPVGIIVPNHAPLTKLAKKLGIMEQKDSSINIENYLEDAKLIKAVYSDLLKTGKDQGLVGIELLAGIVFFDGEWTPQNGFVTSAQKLKRKDILNAVKDKVDAVYSSS');
INSERT INTO proteininfo VALUES ('6324892', 'NP_014961.1','Vacuolar transporter that mediates zinc transport into the vacuole; overexpression confers resistance to cobalt and rhodium; Cot1p [Saccharomyces cerevisiae]','MKLGSKQVKIISLLLLDTVFFGIEITTGYLSHSLALIADSFHMLNDIISLVVALWAVNVAKNRNPDSTYTYGWKRAEILGALINAVFLIALCVSILIEALQRIIAPPVIENPKFVLYVGVAGLISNTVGLFLFHDNDQEHGHGHGHSHGGIFADHEMHMPSSHTHTHAHVDGIENTTPMDSTDNISEIMPNAIVDSFMNENTRLLTPENASKTPSYSTSSHTIASGGNYTEHNKRKRSLNMHGVFLHVLGDALGNIGVMLSAFFIWKTDYSWKYYTDPLVSLIITGIIFSSALPLSCKASKILLQATPSTLSGDQVEGDLLKIPGIIAIHDFHIWNLTESIFIASLHIQLDISPEQFTDLAKIVRSKLHRYGIHSATLQPEFITREVTSTERAGDSQGDHLQNDPLSLRPKTYGTGISGSTCLIDDAANCNTADCLEDH');
INSERT INTO proteininfo VALUES ('6324891', 'NP_014960.1','Protein of unknown function, found in the cytoplasm and the nucleus; potential Cdc28p substrate; Yor315wp [Saccharomyces cerevisiae]','MDEMHSSDTLLLRTPKSKKKIGLVIPSTPSKKCKYSSGFIAEDTTPSKRFRLYQAKFKTSSKNVKAQTLSVSIKKNQGEITNPFMTEGYNDYRNIVSPGLSFDNDCFSEHELVSPLSDISSINSTSPDVEKIDSLDPFGVDSFVWNCKPLVNKEALELHRMIHSSFPMSPLESNSDVPLLLPKLKKRLSPVNRSTFKPTRYEPSHRLLKPKKSILTVPAKSLNLIVSSSRGSLNDATIFATEINSTLSNEENKLPAISSIWEKLTIPVNSSIKEKYKKLKDQIYGQASNFGEDEDNEEDNEDDLPDAAVIRGYEFQSGRRDELTQCNELQSTKDYKKVQWAKVLEQ');
INSERT INTO proteininfo VALUES ('6324889', 'NP_014958.1','sporulation-specific protein; Sps4p [Saccharomyces cerevisiae]','MPSNLNIVKVTKPQEENKNFLHKNTNEPNEMEQSQTQEAVTENFTENSNLSANEHAARRGRLNLKTVDHIETYPIVQETEEIAKKIALTRIILAQTKPRIDKVVVSRPVQAVAPVVNFFDKMANSTLSTVERVVPSLKTKTYKRLGEEIALPYTLSKKYGKQLRDTTARNGDNYVYQPVHGRLMKFRKYYNEKFIDTKGKPLIRGQLDPVLLPVNNTFEKVTVKYLPKGKKVPNDSFSCEFNRGLALEYNFMTRAVSAVSHQVVGIAKLPIAYGYHTNSVYNKNLDKQADLKMKNVLRGTWDTITDLEREIWASVTDRSLFRFFGNKSEGGDLPHLVQ');
INSERT INTO proteininfo VALUES ('6324888', 'NP_014957.1','Protein component of the large (60S) ribosomal subunit, nearly identical to Rpl20Ap and has similarity to rat L18a ribosomal protein; Rpl20bp [Saccharomyces cerevisiae]','MYLAHFKEYQVIGRRLPTESVPEPKLFRMRIFASNEVIAKSRYWYFLQKLHKVKKASGEIVSINQINEAHPTKVKNFGVWVRYDSRSGTHNMYKEIRDVSRVAAVETLYQDMAARHRARFRSIHILKVAEIEKTADVKRQYVKQFLTKDLKFPLPHRVQKSTKTFSYKRPSTFY');
INSERT INTO proteininfo VALUES ('6324887', 'NP_014956.1','ER membrane protein; Hsd1p [Saccharomyces cerevisiae]','MGTEDAIALPNSTLEPRTEAKQRLSSKSHQVSAKVTIPAKEEISSSDDDAHVPVTEIHLKSHEWFGDFITKHEIPRKVFHSSIGFITLYLYTQGINYKNVLWPLIYAFIILFILDLIRLNWPFFNMLYCRTVGALMRKKEIHTYNGVLWYILGLIFSFNFFSKDVTLISLFLLSWSDTAAATIGRKYGHLTPKVARNKSLAGSIAAFTVGVITCWVFYGYFVPAYSYVNKPGEIQWSPETSRLSLNMLSLLGGVVAALSEGIDLFNWDDNFTIPVLSSLFMNAVIKTFKK');
INSERT INTO proteininfo VALUES ('6324886', 'NP_014955.1','Protein involved in pre-rRNA processing, 18S rRNA synthesis, and snoRNA synthesis; component of the small subunit processome complex, which is required for processing of pre-18S rRNA; Nop58p [Saccharomyces cerevisiae]','MAYVLTETSAGYALLKASDKKIYKSSSLIQDLDSSDKVLKEFKIAAFSKFNSAANALEEANSIIEGKVSSQLEKLLEEIKKDKKSTLIVSETKLANAINKLGLNFNVVSDAVTLDIYRAIKEYLPELLPGMSDNDLSKMSLGLAHSIGRHKLKFSADKVDVMIIQAIALLDDLDKELNTYAMRCKEWYGWHFPELAKIVTDSVAYARIILTMGIRSKASETDLSEILPEEIEERVKTAAEVSMGTEITQTDLDNINALAEQIVEFAAYREQLSNYLSARMKAIAPNLTQLVGELVGARLIAHSGSLISLAKSPASTIQILGAEKALFRALKTKHDTPKYGLLYHASLVGQATGKNKGKIARVLAAKAAVSLRYDALAEDRDDSGDIGLESRAKVENRLSQLEGRDLRTTPKVVREAKKVEMTEARAYNADADTAKAASDSESDSDDEEEEKKEKKEKKRKRDDDEDSKDSKKAKKEKKDKKEKKEKKEKKEKKEKKEKKEKKSKKEKKEKK');
INSERT INTO proteininfo VALUES ('6324884', 'NP_014953.1','66kD U4/U6.U5 snRNP associated protein; Snu66p [Saccharomyces cerevisiae]','MNKTENLSIEETNEIREKLGMKPIPVFQEKNTDHKESLSIEETNELRASLGLKLIPPQQNFNSSPPNVHNTSKIDELREKITKFQKKANAPLRMAHLLEETNVNDDSSWLENMDAIPSSHESKRSSTLPRKGATKEDENIDLHNVQVSYNIEALSPKKDTILTLKESSIFDDTDSTEVLENVKAAEENADREKLRLRQMNKDRRQKKKILNVSSLDIEEEEEGEKHSITTTHLIIGAEQGVMKAPNTISAKPPTGKVKVNFDSANNMSDEDGGDFKPLKIKKRKIKDPRSTKARKSKITDKMEIVKLVDEDESLSWMEEEQPVTIINPRTSSNNELKGPEDLAREIEKARDEEKRRTESILKMREISNSIVVDEKVTFLNTLDTSLSERSATENKVKVHGEGEKNIGDVTNGHTKEGSGNNTLTEAVNNEPNYEGDAENAPNFFSGLASTLGYLRKKSVFTTGDVDLKPGKDVNNSESLRRDVRNKEHTGTGTYTKDKLHGLEQFTSSDSSNANTHSKRQDHYDPDIKLVYRDEKGNRLTTKEAYKKLSQKFHGTKSNKKKRAKMKSRIEARKNTPENGSLFEFDDN');
INSERT INTO proteininfo VALUES ('6324883', 'NP_014952.1','multicopy suppressor of ypt1 deletion; homolog of chloroplast phosphate transporter; Sly41p [Saccharomyces cerevisiae]','MIQTQSTAIKRRNSVHKNLFDPSLYQIPEPPRGGFQHQKKEYSKETFSNQVFGYDITSLKKRFTQLFPSNIQGYLPEVDLRITIICSIWYVTSSISSNLSKAILRTFNHPIALTELQFLVSAVLCVGFASIVNLFRLPRLKHTKFSKALNSFPDGILPEYLDGNFRSSILHKFLVPSKLVLMTTFPMGIFQFIGHITSHKAVSMIPVSLVHSVKALSPIITVGYYKFFEHRYYNSMTYYTLLLLIFGVMTTCWSTHGSKRASDNKSGSSLIGLLFAFISMIIFVAQNIFAKNILTIRRKVGILPSSSTDDVTSKEGQPSLDKTRFSPLQVDKITILFYCSCIGFSLTLLPFLTGELMHGGSVINDLTLETVALVAIHGIAHFFQAMLAFQLIGLLSSINYSVANIMKRIVVISVALFWETKLNFFQVFGVILTIAGLYGYDKWGLSKKDGRQA');
INSERT INTO proteininfo VALUES ('6324882', 'NP_014951.1','monocarboxylate permease homologue; Mch5p [Saccharomyces cerevisiae]','MSSDSLTPKDTIVPEEQTNQLRQPDLDEDSIHYDPEADDLESLETTASYASTSVSAKVYTKKEVNKGTDIESQPHWGENTSSTHDSDKEEDSNEEIESFPEGGFKAWVVTFGCFLGLIACFGLLNSTGVIESHLQDNQLSSESVSTIGWLFSLFLFVCSASCIISGTYFDRNGFRTIMIVGTVFHVAGLFATANSTKYWHFILSFAIVCGFGNGIVLSPLVSVPAHYFFKRRGTALAMATIGGSVGGVVFPIMLRSFFSMKSDTDPTYGFVWGIRTLGFLDLALLTLSIILVKERLPHVIENSKDGESRWRYILRVYILQCFDAKAFLDMKYLFCVLGTVFSELSINSALTYYGSYATSHGISANDAYTLIMIINVCGIPGRWVPGYLSDKFGRFNVAIATLLTLFIVMFVGWLPFGTNLTNMYVISALYGFCSGSVFSLLPVCCGQISKTEEFGKRYSTMYFVVGFGTLVGIPITGAIISIKTTADYQHYIIFSGLATFVSAVCYIISRAYCVGFKWVRF');
INSERT INTO proteininfo VALUES ('6324881', 'NP_014950.1','Hypothetical ORF; Yor305wp [Saccharomyces cerevisiae]','MIKNYLGRRWLNNPAIQAYVKQNAAVAHSTVFQGNLYEYTVMRELSEKLRMTKLRKTGGAHDGGVDIKGSWPVDDIYWKISSLMPNLEMASNIKRTNSQNGFVLKPLKYRIIDHTFEPLKVLVQCKAFTKSKLSPREFRELVGTFTSLVSHSQRNKTVCIMCSPHMLTKDTLNLINNITLPLIYLRVEMLKEKTDGHFDLINSGKLINYYENSYASTLMQDCKISEWLKLKLYKNSDFNSEK');
INSERT INTO proteininfo VALUES ('6324880', 'NP_014949.1','Protein of unknown function; green fluorescent protein (GFP)-fusion protein localizes to the cell periphery, cytoplasm, bud, and bud neck; Yor304c-ap [Saccharomyces cerevisiae]','MSTEKLEASEEPQAPLANTSETNSIKGDTENIVTVFDLANEIEKSLKDVQRQMKENDDEFSRSIQAIEDKLNKMSR');
INSERT INTO proteininfo VALUES ('6324879', 'NP_014948.1','has strong homology to Drosophila ISWI; ATPase component of a two subunit chromatin remodeling complex; Isw2p [Saccharomyces cerevisiae]','MTTQQEEQRSDTKNSKSESPSEVLVDTLDSKSNGSSDDDNIGQSEELSDKEIYTVEDRPPEYWAQRKKKFVLDVDPKYAKQKDKSDTYKRFKYLLGVTDLFRHFIGIKAKHDKNIQKLLKQLDSDANKLSKSHSTVSSSSRHHRKTEKEEDAELMADEEEEIVDTYQEDIFVSESPSFVKSGKLRDYQVQGLNWLISLHENKLSGILADEMGLGKTLQTISFLGYLRYVKQIEGPFLIIVPKSTLDNWRREFLKWTPNVNVLVLHGDKDTRADIVRNIILEARFDVLITSYEMVIREKNALKRLAWQYIVIDEAHRIKNEQSALSQIIRLFYSKNRLLITGTPLQNNLHELWALLNFLLPDIFGDSELFDEWFEQNNSEQDQEIVIQQLHSVLNPFLLRRVKADVEKSLLPKIETNVYVGMTDMQIQWYKSLLEKDIDAVNGAVGKREGKTRLLNIVMQLRKCCNHPYLFEGAEPGPPYTTDEHLIFNSGKMIILDKLLKRLKEKGSRVLIFSQMSRLLDILEDYCYFRDFEYCRIDGSTSHEERIEAIDEYNKPNSEKFVFLLTTRAGGLGINLVTADTVILFDSDWNPQADLQAMDRAHRIGQKKQVHVYRFVTENAIEEKVIERAAQKLRLDQLVIQQGTGKKTASLGNSKDDLLDMIQFGAKNMFEKKASKVTVDADIDDILKKGEQKTQELNAKYQSLGLDDLQKFNGIENQSAYEWNGKSFQKKSNDKVVEWINPSRRERRREQTTYSVDDYYKEIIGGGSKSASKQTPQPKAPRAPKVIHGQDFQFFPKELDALQEKEQLYFKKKVNYKVTSYDITGDIRNEGSDAEEEEGEYKNAANTEGHKGHEELKRRIEEEQEKINSAPDFTQEDELRKQELISKAFTNWNKRDFMAFINACAKYGRDDMENIKKSIDSKTPEEVEVYAKIFWERLKEINGWEKYLHNVELGEKKNEKLKFQETLLRQKIEQCKHPLHELIIQYPPNNARRTYNTLEDKFLLLAVNKYGLRADKLYEKLKQEIMMSDLFTFDWFIKTRTVHELSKRVHTLLTLIVREYEQPDANKKKRSRTSATREDTPLSQNESTRASTVPNLPTTMVTNQKDTNDHVDKRTKIDQEA');
INSERT INTO proteininfo VALUES ('6324878', 'NP_014947.1','Small subunit of carbamoyl phosphate synthetase, which catalyzes a step in the synthesis of citrulline, an arginine precursor; translationally regulated by an attenuator peptide encoded by YOR302W within the CPA1 mRNA 5'-leader; Cpa1p [Saccharomyces cerevisiae]','MSSAATKATFCIQNGPSFEGISFGANKSVAGETVFTTSLVGYPESMTDPSYRGQILVFTQPLIGNYGVPSGEARDEYNLLKYFESPHIHVVGIVVAEYAYQYSHWTAVESLAQWCQREGVAAITGVDTRELVQYLREQGSSLGRITLADHDPVPYVNPMKTNLVAQVTTKKPFHVSALPGKAKANVALIDCGVKENIIRCLVKRGANVTVFPYDYRIQDVASEFDGIFLSNGPGNPELCQATISNVRELLNNPVYDCIPIFGICLGHQLLALASGASTHKLKYGNRAHNIPAMDLTTGQCHITSQNHGYAVDPETLPKDQWKPYFVNLNDKSNEGMIHLQRPIFSTQFHPEAKGGPLDTAILFDKFFDNIEKYQLQSQAKSSISLKVTYSTDKSRLQSINVTKLAKERVLF');
INSERT INTO proteininfo VALUES ('6324877', 'NP_014946.1','CPA1 uORF , Arginine attenuator peptide, regulates translation of the CPA1 mRNA; Yor302wp [Saccharomyces cerevisiae]','MFSLSNSQYTCQDYISDHIWKTSSH');
INSERT INTO proteininfo VALUES ('6324876', 'NP_014945.1','Protein involved in determination of budding patters; a rax1 mutation converts the budding pattern of an axl1 null mutant from bipolar to axial; has similarity to B-chains of the insulin-related hormone superfamily; Rax1p [Saccharomyces cerevisiae]','MKEELSKVSSMQNFEMIQRERLPTLYEVLIQRTSQPVDLWTFYTFLSQFPYAINYLDFWVDLMTHTRLCKNYIELVRKSLINFPQEQQQNGSTSTATFDLLNALIEEGHLDPEAPDKLLENSGPDVPFSPKLNELLGDWKHQSGIGQEALRNEDVALIVDEIMKRRSQQDGKPQITTKQLLHSAVGLCNTYLVSPEQSERYLSNIPMETRNRIIESVQIERKYDIEIFDDLKNLTYQFLEMDCFPKFLSRVALHNIHDEISDWRFHSVGVTNEKSNRSRGQTHISRSPFSNHTSISRIGFGLLWLGIGFWIGYVLIFLAYSRAIRVVTVVPFTLGCYCIVCGMYQVDIVYSWFGVTQRLLHRHKNAGNDEGDASSDTDHVPMILAVFGGRRRLTRIEHPFTRQLLRKRGLWCLLLVVGATAAFTVIFSCVPGRRV');
INSERT INTO proteininfo VALUES ('6324874', 'NP_014943.1','Protein involved in bud-site selection; diploid mutants display an axial-like budding pattern; Bud7p [Saccharomyces cerevisiae]','MITQNSIPEVKEDFIGYALHERRIRLPQFQDLGPADLVTLTKYLPTSSNTNAINSTSRNGAAIIQSPAAVVADDSAASMATNGDASDTAVTTNYTNASIYSSSRNANDGAPMVAELHPLDKLKDEVGTFFYSMGVDTSGPTSIAIFLKEISEVISEKPQVWFGRKKTFNVARISFSTWNAFRRCDINVVVHIPGSIQNFIVDCNGESQNIEMCADYDLIWAETFVSGVVRSIMLMKENAEEGELQNLVETLILNPFTAGQIDDVPEMFIDLFPIVYHKGPLLGAPYYITNVTNTNNYLVETLVEIVKLTRNVSRAEIMLKNLATDNPEAIIILIKIFLVCDQELDAIKLTYDMLSQDKIINNTNNRMDYKSELLCLQAQFLIDKRQDYSLAQNIAQEAVNCSPSEFRPWYLLSKVYVKLNDIENALLILNSCPMSPLKEKYVLKRVAPLPSNNSLHLPLPIDVVLDEVTSLNPQDVQNEHRSADPMLVNLAASNLKSTFQLAYRLLTEIVQITGWENLLKYRSNIFVMEEEYQKSSSSLPKDVNKQEEQPLRAKRLCERWLDNLFMLLYEDLKMYTLWQTEQLYMDAQNNNHNKLTFEWELFGLCARRLGHFPEAAKAFQNGLSQRFSSRCARKLLEYCINERQRVKNFINSPNSHDMVPEIVSSRIRELDNSIIDLCVKICCWNHRWYTEFSISLLDCLSVVIQDMSLTKVSNEISSRYPETVLNLVQENLLNFFTTCTIGCYDA');
INSERT INTO proteininfo VALUES ('6324872', 'NP_014941.1','Hypothetical ORF; Yor298wp [Saccharomyces cerevisiae]','MGFVDFFETYMVGSRVQFKQLDISDWLSLTPRLLILFGYFYLHSFFTAINQFLQFINTNSFCLRLHLLYDRFWSHVPIIGEYKIRLLSRALTYSKLKIIPTLDKVLEAIEIWFQLHLVEMTFEKKKNVQIFITEGSDDLNFFKDSKFQTTLMICNHRSVNDYTLINYLFLKSCPTKFYTKWEFLQKLRKGEDLAEWPQLKFLGWGKMFNFPRLDLLKNIFFKDETLALSSNELRDILERQNNQAITIFPEVNIMSLELSIIQRKLHQDFPFVINFYNLLYPRFKNFTTLMAAFSSIKNIKRKKNRNNIIKEARYLFHRELDKLVHKSMKMESSKVSDKTTPPMIVDNSYLLTKKEEISSGKPKVVRINPYIYDVTIIYYRVKYTDSGHDHTNGDLRLHKGYQLEQISPTIFEMIQPEMESENNIKDKDPIVVMVNVKKHQIQPLLAYNDESLEKWLENRWIEKDRLIESLQKNIKIETK');
INSERT INTO proteininfo VALUES ('6324871', 'NP_014940.1','mitochondrial inner membrane translocase; Tim18p [Saccharomyces cerevisiae]','MLLFPGLKPVLNASTVIVNPVRAVFPGLVLSTKRSFYSINRLNAENKINDIANTSKEASSSVQMFKPPEFSQFKDSYQKDYERIAKYTLIPLTMVPFYASFTGGVINPLLDASLSSIFLIYLQYGFTSCIIDYIPKGKYPRWHKLALYCLYGGSMLSLYGIYELETKNNGFVDLVKKLWNENDDHLYIFGRN');
INSERT INTO proteininfo VALUES ('6324870', 'NP_014939.1','Hypothetical ORF; Yor296wp [Saccharomyces cerevisiae]','MNRTVSTLSSTVSDVSVEIPSICNVINTELPTSDVYLYTLKLILLDYINEPRFKEAALLSNRTGTSRVLSDKTNHQQTQHGKKLVVDKQDDMSERDIVQATLRILKGKLAQISGNKNLAPNEMHWKSIVKMYYSMLDSSSADTFSKMGQMEEVVGYFTNIASNELKKMTIKNSRDELFSEVAYFIDLVIDVLPDSCANIIKRLLDYKINLKKGETTVKKKRAASPATVPQYRSISGSTISNKQPSFKVQDISHMKYFMQLFETDETKLHQDVMAVKDDCTNPIFCGELRYLRKKIKKDNGTLTASDFSSDREYNLWKNYELLEIANLMDRFEIGEKVTSHGNRLIPKDAKSVFVRLIGLVLKKECSNAVNAINLSQEALFFFHKSARYWRIEYPSTISSLVYSAANLSVLGDEELNIPITENLFSVIRNKYLCSEDNLDPSAWNAQDRYLWAANLFHTTDQSMRTINNLLTAIFSGTKPKFSPVLSFYYSNIVGDPVMEFYETQSVAVKKYWIKLFKKTLFKASEDYFVSLLQDMLKANAIEIQNVQNLVETIIEAIKAIQKRYNKPLLDEISLPRQCAVFLCEVYGSDSLNLIKTAEKSTMKMTGQKLGPIDALDMYDVLKELRQIYLQVKPKGKFFFNLENYFIKYLTRLCDDVSRNVQKVIKSSLESENWQPVNDQDHFSRSVLDIFKMINESTSMLEKFGWQNEFQLAQMITVILKAFSDGMLSYSAQLMELIQRDLQEGDEPSYSLESSDTRSSLSLNNANVNHEKSRSSRLFEDLKNVVKSTPKMVAPAPYQFKKRTCVLLNDLDKTLFLLESFEEKADPSKISSVIAQYHSSHNLEDNGKSFDDQNMKQVYTLRIIGAENIKGFSKTGLSNTYVSMRNITLQREIGTTKIVARSITPKWDEEFVFESPFGKSNDIMFTIWHHPHSRLKNLAEDDLCGKANMKFTPRKLKDDGFPIDFSLTLNPQGTLYCQISLESEKIDAVSSMGRIYRSFSRSRDRAINLIVNKFSDFIAFAFSRTTLKTVCGHHGSALASDEAVYDAILPLFDYLNANLNILASELSQRLLFMVMLRAWNLVLENADLLLLPALNSAKVNILRSAKKSLWENTLSTTKTVSGYGRPLTQAEIEAVFKWLDALCVDFFHNKGEGPPLAELKNEYYQNILLIPAFYDKSVSELKDEVQRLIPLYEEYLRWFYLKKTPITFTNKSAGTISRKKSLVANIVKEPKEQLERDAEVMNIILRILIAKGQHDYVHRILHDRKELVNTMKNRRAVSRAVTPTGKKGRN');
INSERT INTO proteininfo VALUES ('6324869', 'NP_014938.1','Topoisomerase 1 and RAD52 epistasis group Interactions; Interacts with Top1p in the 2-hybrid system.; Uaf30p [Saccharomyces cerevisiae]','MAELNDYSTMIDILLSDMDLETVTTKKVRMALKEVYAIDVESQGKAINKLIRKHLDLVKERPRFERSLEDLLKENATLAIELTKEITVSKRSSGEEKNDSETKGTHVEKKKGTVSKSPISTRKVTLSKSLASLLGEHELTRTEVVRRLWAYIKAHNLQNPNNKKEILCDEKLELILGKSTNMFEMHKILASHMTEPKKISDCPPLIQEVRRKEKPIVSDSEQSDTKGI');
INSERT INTO proteininfo VALUES ('6324868', 'NP_014937.1','Essential protein that binds ribosomal protein L11 and is required for nuclear export of the 60S pre-ribosomal subunit during ribosome biogenesis; mouse homolog shows altered expression in Huntington's disease model mice; Rrs1p [Saccharomyces cerevisiae]','MSAEDYKNLPVTVEKPIPVVYDLGNLAAFDSNVLDKNDLDSSNARREEKIKSLTRDNVQLLINQLLSLPMKTTTESVGGTGGQSSVMTLLQLPDPTTDLPREKPLPKAKAMTKWEKFAAKKGIKPKERAGKMIYDEASGEWVPKWGYKGANKKLDDQWLVEVDDKVKGTDNELIDPRTLNRAERKRLVKKNEKQQRRNMKNAL');
INSERT INTO proteininfo VALUES ('6324867', 'NP_014936.1','Protein component of the small (40S) ribosomal subunit; nearly identical to Rps10Bp and has similarity to rat ribosomal protein S10; Rps10ap [Saccharomyces cerevisiae]','MLMPKEDRNKIHQYLFQEGVVVAKKDFNQAKHEEIDTKNLYVIKALQSLTSKGYVKTQFSWQYYYYTLTEEGVEYLREYLNLPEHIVPGTYIQERNPTQRPQRRY');
INSERT INTO proteininfo VALUES ('6324866', 'NP_014935.1','Hypothetical ORF; Yor292cp [Saccharomyces cerevisiae]','MPLQLFGRDQIVVHYDNGNMSNDDQNHQSVLGSWTRRAAAALRTLMNKRIQRITLTHWLLLVIWVTSLWKFTSHYRQLYANSAVFATLCTNILLFGISDILAQSIACFYSYHVDPIPQILNDTFHHVQNNRDVENGGGYESDELSIFNDFTSEHSSYTDNDDYPELDRPLATFKTDTFDFFRWGCFMFWGFFISFFQAPWYKFLNFFYTEDPTVVQVFERVLSDQLLYSPISLYCFFMFSNYVMEGGDKDTLGKKIQRLYISTLGCNYLVWPMVQFINFLIMPRDFQAPFSSSVGVVWNCFLSMRNASK');
INSERT INTO proteininfo VALUES ('6324865', 'NP_014934.1','Hypothetical ORF; Yor291wp [Saccharomyces cerevisiae]','MDIPSSNQIQHGQRSERNRRMPRASFSSTATTSTAATLTSAMVLDQNNSEPYAGATFEAVPSSIVSFHHPHSFQSSNLPSPHSSGNLEQRGRRLTESEPLVLSSAEQSRSSSRNPSHFRFFTQEQISNAEGASTLENTDYDMAWDATPAYEQDRIYGTGLSSRRSSIRSFSRASSLSNAKSYGSFSKRGRSGSRAPQRLGENSDTGFVYHSATHSSSSLSRYTTRERIPIELESQTDEILEDESSTHSLESSDSRRSASENNRGSFSGHDDVHNQHSEYLKPDYHEKFYPQYAPNLHYQRFYIAEEDLVIGIAAYQTSKFWYIIYNLCCFLTFGLVYLLTRWLPHLKVKLYGVKVPLAKAEWVVIENEFGEFVIQPIDRQWYNRPLSTVLPFENYPNPSYEPNDINLSHHHANEINPNVPILITFEYRYIKFIYSPLDDLFKTNNNWIDPDWVDLSTVSNGLTKGVQEDRELAFGKNQINLRMKTTSEILFNEVLHPFYVFQVFSIILWGIDEYYYYAACIFLISVLSIFDSLNEQKKVSRNLAEMSHFHCDVRVLRDKFWTTISSSELVPGDIYEVSDPNITILPCDSILLSSDCIVNESMLTGESVPVSKFPATEETMYQLCDDFQSTQISSFVSKSFLYNGTNIIRARIAPGQTAALAMVVRTGFSTTKGSLVRSMVFPKPTGFKFYRDSFKYIGFMSLIAIFGFCVSCVQFIKLGLDKKTMILRALDIITIVVPPALPATLTIGTNFALSRLKEKGIFCISPTRLNISGKIDVMCFDKTGTLTEDGLDVLGVQISEPNGVRGQKFGELLSDIRQVFPKFSLNDCSSPLDFKSRNFFMSLLTCHSLRSVDGNLLGDPLDFKMFQFTGWSFEEDFQKRAFHSLYEGRHEDDVFPENSEIIPAVVHPDSNNRENTFTDNDPHNFLGVVRSFEFLSELRRMSVIVKTNNDDVYWSFTKGAPEVISEICNKSTLPADFEEVLRCYTHNGYRVIACAGKTLPKRTWLYSQKVSREEVESNLEFLGFIIFQNKLKKETSETLKSLQDANIRTIMCTGDNILTAISVGREAGLIQCSRVYVPSINDTPLHGEPVIVWRDVNEPDKILDTKTLKPVKLGNNSVESLRECNYTLAVSGDVFRLLFRDENEIPEEYLNEILLNSSIYARMSPDEKHELMIQLQKLDYTVGFCGDGANDCGALKAADVGISLSEAEASVAAPFTSKIFNISCVLDVIREGRAALVTSFACFQYMSLYSAIQFITITILYSRGSNLGDFQFLYIDLLLIVPIAICMSWSKSYEKIDKKRPSANLVSPKILVPLLISVFLVFLFQFIPWIIVQKMSWYIKPIVGGDDAVQSSDNTVLFFVSNFQYILTAIVLSVGPPYREPMSKNFEFIVDITVSIGASLLLMTLDTESYLGKMLQLTPISNSFTMFIIVWVILNYYAQLYIPPSIKGWLKKKKSSKKYKLLIQEEMKLKEV');
INSERT INTO proteininfo VALUES ('6324864', 'NP_014933.1','involved in the coordinate regulation of phospholipid synthesis; transcriptional regulator; Snf2p [Saccharomyces cerevisiae]','MNIPQRQFSNEEVNRCYLRWQHLRNEHGMNAPSVPEFIYLTKVLQFAAKQRQELQMQRQQQGISGSQQNIVPNSSDQAELPNNASSHISASASPHLAPNMQLNGNETFSTSAHQSPIMQTQMPLNSNGGNNMLPQRQSSVGSLNATNFSPTPANNGENAAEKPDNSNHNNLNLNNSELQPQNRSLQEHNIQDSNVMPGSQINSPMPQQAQMQQAQFQAQQAQQAQQAQQAQQAQARLQQGRRLPMTMFTAEQSELLKAQITSLKCLVNRKPIPFEFQAVIQKSINHPPDFKRMLLSLSEFARRRQPTDQNNQSNLNGGNNTQQPGTNSHYNNTNTDNVSGLTRNAPLDSKDENFASVSPAGPSSVHNAKNGTLDKNSQTVSGTPITQTESKKEENETISNVAKTAPNSNKTHTEQNNPPKPQKPVPLNVLQDQYKEGIKVVDIDDPDMMVDSFTMPNISHSNIDYQTLLANSDHAKFTIEPGVLPVGIDTHTATDIYQTLIALNLDTTVNDCLDKLLNDECTESTRENALYDYYALQLLPLQKAVRGHVLQFEWHQNSLLTNTHPNFLSKIRNINVQDALLTNQLYKNHELLKLERKKTEAVARLKSMNKSAINQYNRRQDKKNKRLKFGHRLIATHTNLERDEQKRAEKKAKERLQALKANDEEAYIKLLDQTKDTRITHLLRQTNAFLDSLTRAVKDQQKYTKEMIDSHIKEASEEVDDLSMVPKMKDEEYDDDDDNSNVDYYNVAHRIKEDIKKQPSILVGGTLKDYQIKGLQWMVSLFNNHLNGILADEMGLGKTIQTISLLTYLYEMKNIRGPYLVIVPLSTLSNWSSEFAKWAPTLRTISFKGSPNERKAKQAKIRAGEFDVVLTTFEYIIKERALLSKVKWVHMIIDEGHRMKNAQSKLSLTLNTHYHADYRLILTGTPLQNNLPELWALLNFVLPKIFNSVKSFDEWFNTPFANTGGQDKIELSEEETLLVIRRLHKVLRPFLLRRLKKDVEKELPDKVEKVVKCKMSALQQIMYQQMLKYRRLFIGDQNNKKMVGLRGFNNQIMQLKKICNHPFVFEEVEDQINPTRETNDDIWRVAGKFELLDRILPKLKATGHRVLIFFQMTQIMDIMEDFLRYINIKYLRLDGHTKSDERSELLRLFNAPDSEYLCFILSTRAGGLGLNLQTADTVIIFDTDWNPHQDLQAQDRAHRIGQKNEVRILRLITTNSVEEVILERAYKKLDIDGKVIQAGKFDNKSTSEEQEALLRSLLDAEEERRKKRESGVEEEEELKDSEINEILARNDEEMAVLTRMDEDRSKKEEELGVKSRLLEKSELPDIYSRDIGAELKREESESAAVYNGRGARERKTATYNDNMSEEQWLRQFEVSDDEKNDKQARKQRTKKEDKSEAIDGNGEIKGENIDADNDGPRINNISAEDRADTDLAMNDDDFLSKKRKAGRPRGRPKKVKLEGSENSEPPALESSPVTGDNSPSEDFMDIPKPRTAGKTSVKSARTSTRGRGRGRGRGRGRGRGRGRPPKARNGLDYVRTPAAATSPIDIREKVAKQALDLYHFALNYENEAGRKLSDIFLSKPSKALYPDYYMIIKYPVAFDNINTHIETLAYNSLKETLQDFHLIFSNARIYNTEGSVVYEDSLELEKVVTKKYCEIMGDNSQLDFTEFDEQYGTRPLVLPPVVTSSVAESFTDEADSSMTEASV');
INSERT INTO proteininfo VALUES ('6324863', 'NP_014932.1','Hypothetical ORF; Yor289wp [Saccharomyces cerevisiae]','MALRLFRKSSFFAKISMEGPKGSSPFAFYAFYQLYSHLNPGKSSSLSLEDIRRRLYPDFKIDYNEKTSLFITWKKKSNKHHTIDTNEENYILRGCIGTFAKMPIAHGIEKYSLIAALEDRRFSPIQKRELVDLKCSCNILGNFKTIFRGGGNPNGDIFDWELGKHGIELYFKHPKTGTTCSATFLPDVMPEQHWNKEDTFANLIEKAGYWGNISEVMDNFETYFIEVIRYEGKKSSITYEEFNKQLKDIEA');
INSERT INTO proteininfo VALUES ('6324862', 'NP_014931.1','Disulfide isomerase related protein; Mpd1p [Saccharomyces cerevisiae]','MLFLNIIKLLLGLFIMNEVKAQNFYDSDPHISELTPKSFDKAIHNTNYTSLVEFYAPWCGHCKKLSSTFRKAAKRLDGVVQVAAVNCDLNKNKALCAKYDVNGFPTLMVFRPPKIDLSKPIDNAKKSFSAHANEVYSGARTLAPIVDFSLSRIRSYVKKFVRIDTLGSLLRKSPKLSVVLFSKQDKISPVYKSIALDWLGKFDFYSISNKKLKQLTDMNPTYEKTPEIFKYLQKVIPEQRQSDKSKLVVFDADKDKFWEYEGNSINKNDISKFLRDTFSITPNEGPFSRRSEYIAYLKTGKKPIKKNHSSSGNKHDEL');
INSERT INTO proteininfo VALUES ('6324861', 'NP_014930.1','Protein required for cell viability; Yor287cp [Saccharomyces cerevisiae]','MSYYFKNLKPDLNSDVEEDDGNLLESIMANKSKREIDEQESSDDELKTLSFGSLKKAETVIDEEDFKDTKPVHKKPITTTYREESFDEDEDSEDQSDEDAGFFEEDSEDETHHGQKVPKKKSKHAPVEQSSKKRVPRVRNIPGLEIPRNKRSNLYQDIRFDKSTGKALDSSIIRKRYQFLDEYREKEIDELQKLLQERKFLSKIDQGEREEMEQRLKSMKSRLQSMKNKDLEREILKEYENDMNKNNNTRYHLKKSEKRKVVQKWKFDHMKAKQREKVMERKRKKRLGKEFKQFEFHNRR');
INSERT INTO proteininfo VALUES ('6324860', 'NP_014929.1','The authentic, non-tagged protein was localized to the mitochondria; Fmp31p [Saccharomyces cerevisiae]','MFKHSTGILSRTVSARSPTLVLRTFTTKAPKIYTFDQVRNLVEHPNDKKLLVDVREPKEVKDYKMPTTINIPVNSAPGALGLPEKEFHKVFQFAKPPHDKELIFLCAKGVRAKTAEELARSYGYENTGIYPGSITEWLAKGGADVKPKK');
INSERT INTO proteininfo VALUES ('6324859', 'NP_014928.1','Hypothetical ORF; Yor285wp [Saccharomyces cerevisiae]','MWKAVMNAWNGTESQSKNVSNIQSYSFEDMKRIVGKHDPNVVLVDVREPSEYSIVHIPASINVPYRSHPDAFALDPLEFEKQIGIPKPDSAKELIFYCASGKRGGEAQKVASSHGYSNTSLYPGSMNDWVSHGGDKLDL');
INSERT INTO proteininfo VALUES ('6324858', 'NP_014927.1','Cytoplasmic protein of unknown function; computational analysis of large-scale protein-protein interaction data suggests a possible role in actin patch assembly; Hua2p [Saccharomyces cerevisiae]','MQQTKFGKMYLDHDSVVEYSEDEIVEADRITLGYKKRLSMIENQMRHLLEDFSLDVQQIEPILADLQKYYDAFLQLLQKRNKSLQCKRSTHQPVPSPMNSQTSTNAKVNLSGKLMKFQLNSVQKFDEENILRILQNKIEFEHYFQIDKGKKQKVLLLAVYQCLNGPTRLHKVLNIEGIIHNNSIRTILGKQVSSSKWTVFLYDVKLVLLAHRQDVPNLETSKMIVRYGDLFPCALYFKDHTAY');
INSERT INTO proteininfo VALUES ('6324857', 'NP_014926.1','Hypothetical ORF; Yor283wp [Saccharomyces cerevisiae]','MTKEVPYYCDNDDNNIIRLFIIRHGQTEHNVKKILQGHKDTSINPTGEEQATKLGHYLRSRGIHFDKVVSSDLKRCRQTTALVLKHSKQENVPTSYTSGLRERYMGVIEGMQITEAEKYADKHGEGSFRNFGEKSDDFVARLTGCVEEEVAEASNEGVKNLALVSHGGAIRMILQWLKYENHQAHKIIVFNTSVTIVDYVKDSKQFIVRRVGNTQHLGDGEFVVSDLRLR');
INSERT INTO proteininfo VALUES ('6324856', 'NP_014924.1','Essential protein with similarity to phosducins, which are GTPase inhibitors; lethality of null mutation is functionally complemented by expression of mouse phosducin-like protein MgcPhLP; Plp2p [Saccharomyces cerevisiae]','MQNEPMFQVQVDESEDSEWNDILRAKGVIPERAPSPTAKLEEALEEAIAKQHENRLEDKDLSDLEELEDDEDEDFLEAYKIKRLNEIRKLQERSKFGEVFHINKPEYNKEVTLASQGKKYEGAQTNDNGEEDDGGVYVFVHLSLQSKLQSRILSHLFQSAACKFREIKFVEIPANRAIENYPESNCPTLIVYYRGEVIKNMITLLELGGNNSKMEDFEDFMVKVGAVAEGDNRLIMNRDDEESREERKLHYGEKKSIRSGIRGKFNVGIGGNDDGNINDDDDGFFD');
INSERT INTO proteininfo VALUES ('6324854', 'NP_014923.1','Serine hydrolase that localizes to both the nucleus and cytoplasm. Sequence similary to Fsh1p and Fsh3p; Fsh3p [Saccharomyces cerevisiae]','MSEKKKVLMLHGFVQSDKIFSAKTGGLRKNLKKLGYDLYYPCAPHSIDKKALFQSESEKGRDAAKEFNTSATSDEVYGWFFRNPESFNSFQIDQKVFNYLRNYVLENGPFDGVIGFSQGAGLGGYLVTDFNRILNLTDEQQPALKFFISFSGFKLEDQSYQKEYHRIIQVPSLHVRGELDEVVAESRIMALYESWPDNKRTLLVHPGAHFVPNSKPFVSQVCNWIQGITSKEGQEHNAQPEVDRKQFDKPQLEDDLLDMIDSLGKL');
INSERT INTO proteininfo VALUES ('6324853', 'NP_014922.1','Repression Factor of MSE; Rfm1p [Saccharomyces cerevisiae]','MSTNTEIIKNSDLQSLINDKRRLINEIKDFNKSIKPLEFESYQDYFLIKTFKKGISASGHVDIDSLRNKEYGIYYKKIKRNSTQEVGEPIPRNTSSSSSSTRSNSSADISDTEYSGENTPTTTGAASRRRRTRSRAIQRENSLPASLPSISEANANNDDVTISEINGSELPFPIPISEVENIDIASDITERDGIRRRSSRISERDKRRSQSRLGSEEDEEGDGHDGDEGETKIQDLYESLVPKILESRRRSDWILPPKARYTPEKQMRTKPSFKSIKINELVGNKRIRSILSRFEGGVAGIRKRDWDSTQ');
INSERT INTO proteininfo VALUES ('6324852', 'NP_014921.1','Uroporphyrinogen III synthase, catalyzes the conversion of hydroxymethylbilane to uroporphyrinogen III, the fourth step in the heme biosynthetic pathway; Hem4p [Saccharomyces cerevisiae]','MSSRKKVRVLLLKNKTVPIDKYELECRSKAFEPIFVPLIKHTHVIQDFRNVLNTIPNYLNTINYIIITSQRTVESLNEAIIPTLTSEQKAALLSKTVYTVGPATANFIRRSGFINVKGGEDAGNGSILADIIIDDLSTDIKACPPSELLFLVGEIRRDIIPKKLHSKGIKVREVVTYKTEELSDGFKRFIHAMKECDEDEVFSDWVVVFSPQGTKEITQYLGDSNRLPGSHLRVASIGPTTKKYLDDNDVTSDVVSPKPDPKSLLDAIELYQRHK');
INSERT INTO proteininfo VALUES ('6324850', 'NP_014919.1','binds to eIF-4E, the mRNA cap-binding protein, and represses cap-dependent translation initiation by interfering with the interaction of eIF4E and eIF4G; mRNA cap-binding protein (eIF4F) 20K subunit; Caf20p [Saccharomyces cerevisiae]','MIKYTIDELFQLKPSLTLEVNFDAVEFRAIIEKVKQLQHLKEEEFNSHHVGHFGRRRSSHHHGRPKIKHNKPKVTTDSDGWCTFEAKKKGSGEDDEEETETTPTSTVPVATIAQETLKVKPNNKNISSNRPADTRDIVADKPILGFNAFAALESEDEDDEA');
INSERT INTO proteininfo VALUES ('6324849', 'NP_014918.1','Regulator of IME2; Rim20p [Saccharomyces cerevisiae]','MSELLAIPLKRTLEVDFATELSKLIDTTSFQTASFFQSDILKVVDARNNAIAPDISIDGLSALKEYYVILLQLEKKFPNNQIEFTWFQTLSQKSRGTSQYSLQWEKLTIIYNIGCMYSLLALNSNNDAAESLKTSCLYFQNAAGCFKHVLDHQKNLETIPVVDDATLNALTSLMLAQAQECFWFKAVQDKHKDSLIAKLSQQIVDFYCEAINDAQRGKLIRSDWINHLKAKKAYFSAVTYYRIALSFNEKKQFGNVVKALQMGLQFINESTLSSQAKFKTVVESSLKEAQRDNEFIYLQEVPSELPSIKPALMVKPSSSATLLPSIKKDETLFKDLIPIEVMEYCTAYNERQDEYVEQRVTNPLASLNKLLKESLTTFQIPQGLTKVSEAELSHYQASLNNLLINNKNVQVQLDNIEQILNEEAFTDNQLRLKHGTLNWTLPESSTTNTAYYEKLKKLRGYLDEGSAIDKQTNELFQSIDKNLIGSEIRLPESNDPLTNKIKMIIQERNDYIDRTRRKSSEYRILPKIITSYKKNGTVDFEPIFIGHLKYFDEDLRYVNSTKEENIKLIEEVNLSKKNNPGRSGIEPKKMVRIDPRELYIEDLRYSFKLLDEVKENLSAGTAFYENLITSTSNLYNEVQEYDTARRAEKARLDKSLTFEDQ');
INSERT INTO proteininfo VALUES ('6324848', 'NP_014917.1','Delta 2-isopentenyl pyrophosphate:tRNA isopentenyl transferase, required for biosynthesis of the modified base isopentenyladenosine in mitochondrial and cytoplasmic tRNAs; gene is nuclear and encodes two isozymic forms; Mod5p [Saccharomyces cerevisiae]','MLKGPLKGCLNMSKKVIVIAGTTGVGKSQLSIQLAQKFNGEVINSDSMQVYKDIPIITNKHPLQEREGIPHHVMNHVDWSEEYYSHRFETECMNAIEDIHRRGKIPIVVGGTHYYLQTLFNKRVDTKSSERKLTRKQLDILESTDPDVIYNTLVKCDPDIATKYHPNDYRRVQRMLEIYYKTGKKPSETFNEQKITLKFDTLFLWLYSKPEPLFQRLDDRVDDMLERGALQEIKQLYEYYSQNKFTPEQCENGVWQVIGFKEFLPWLTGKTDDNTVKLEDCIERMKTRTRQYAKRQVKWIKKMLIPDIKGDIYLLDATDLSQWDTNASQRAIAISNDFISNRPIKQERAPKALEELLSKGETTMKKLDDWTHYTCNVCRNADGKNVVAIGEKYWKIHLGSRRHKSNLKRNTRQADFEKWKINKKETVE');
INSERT INTO proteininfo VALUES ('6324847', 'NP_014916.1','Polyamine transport protein; Tpo4p [Saccharomyces cerevisiae]','MPSSLTKTESNSDPRTNIQQVPKALDKNVTNSGNLDSTSSSTGSITEDEKRSEPNADSNNMTGGEPIDPRDLDWDGPDDPDNPHNWSSLKKWYTTMTSAFLCLVVTMGSSLYVSSVPELVERYHVSQTLALAGLTFYLLGLSTVIGAPLSEVFGRKPVYLFSLPVSMLFTMGVGLSNGHMRIILPLRFLSGVFASPALSVGSGTILDIFDVDQVSVAMTYFVLSPFLGPVLSPIMAGFATEAKGWRWSEWIQLIAGGLILPFIALMPETHKGIILRKRAKKRNIALKKFSREAQKEFLKTTVTITILRPLKMLVVEPIVFVFSVYVAFIFAILFGFFEAYAVIYRGVYHMSMGISGLPFIGIGVGLWIGAFFYLYIDRKYLFPKPPAGTQPLTEKERTSKRTTPYRGARDAETGELLPVVPEKFLIACKFGSVALPIGLFWQAWTARSDVHWMAPVAAGVPFGFGLILIFFSVLMYFSTCYPPLTVASCLAANNLLRYVMSSVFPLFTIQMYTKMKIKWASTLFALVCVVMIPIPWVFEKWGSKLRHKSQFGYAAMEKEAETEGGIDDVNAVDGELNLTRMTTLRTMETDPSTREKPGERLSLRRTHTQPVPASFDREDGQHAQNRNEPISNSLYSAIKDNEDGYSYTEMATDASARMV');
INSERT INTO proteininfo VALUES ('6324846', 'NP_014915.1','microtubule-associated protein; Ytm1p [Saccharomyces cerevisiae]','MTEDKSQVKIRFFTREKDELLHVQDTPMYAPISLKRYGLSEIVNHLLGSEKPVPFDFLIEGELLRTSLHDYLTKKGLSSEASLNVEYTRAILPPSYLNSFSNEDWVSSLDVGDGSKHIISGSYDGIVRTWDLSGNVQKQYSGHSGPIRAVKYISNTRLVSAGNDRTLRLWKTKNDDLKLTSQQQAQEDDDDEVNIEDGKTLAILEGHKAPVVSIDVSDNSRILSASYDNSIGFWSTIYKEMTVVDPLEDINNPNNKISTAARKRRKLTMKDGTIRRRAPLSLLESHTAPVEQVIFDSTDNTVGYSVSQDHTIKTWDLVTARCIDTRTTSYSLLSIAQLSTLNLLACGSSARHITLHDPRVGASSKVTQQQLIGHKNFVSSLDTCPENEYILCSGSHDGTVKVWDVRSTSPMYTITREDKSVQKGVNDKVFAVKWAEKVGIISAGQDKKIQINKGDNIFKN');
INSERT INTO proteininfo VALUES ('6324845', 'NP_014914.1','Hypothetical ORF; Yor271cp [Saccharomyces cerevisiae]','MASSVPGPIDLPESRYDLSTYWGRIRHCAEISDPTMLLTTEKDLAHAREIISAYRHGELKETTPEFWRAKKQLDSTVHPDTGKTVLLPFRMSSNVLSNLVVTVGMLTPGLGTAGTVFWQWANQSLNVAVNSANANKSHPMSTSQLLTNYAAAVTASCGVALGLNNLVPRLKNISPHSKLILGRLVPFAAVVSAGIVNVFLMRGNEIRKGISVFDSNGDEVGKSKKAAFMAVGETALSRVINATPTMVIPPLILVRLQRGVLKGKSLGVQTLANLGLISVTMFSALPFALGIFPQRQAIHLNKLEPELHGKKDKDGKPIEKVYFNRGI');
INSERT INTO proteininfo VALUES ('6324844', 'NP_014913.1','vacuolar ATPase V0 domain subunit a (100 kDa); Vph1p [Saccharomyces cerevisiae]','MAEKEEAIFRSAEMALVQFYIPQEISRDSAYTLGQLGLVQFRDLNSKVRAFQRTFVNEIRRLDNVERQYRYFYSLLKKHDIKLYEGDTDKYLDGSGELYVPPSGSVIDDYVRNASYLEERLIQMEDATDQIEVQKNDLEQYRFILQSGDEFFLKGDNTDSTSYMDEDMIDANGENIAAAIGASVNYVTGVIARDKVATLEQILWRVLRGNLFFKTVEIEQPVYDVKTREYKHKNAFIVFSHGDLIIKRIRKIAESLDANLYDVDSSNEGRSQQLAKVNKNLSDLYTVLKTTSTTLESELYAIAKELDSWFQDVTREKAIFEILNKSNYDTNRKILIAEGWIPRDELATLQARLGEMIARLGIDVPSIIQVLDTNHTPPTFHRTNKFTAGFQSICDCYGIAQYREINAGLPTIVTFPFMFAIMFGDMGHGFLMTLAALSLVLNEKKINKMKRGEIFDMAFTGRYIILLMGVFSMYTGFLYNDIFSKTMTIFKSGWKWPDHWKKGESITATSVGTYPIGLDWAWHGTENALLFSNSYKMKLSILMGFIHMTYSYFFSLANHLYFNSMIDIIGNFIPGLLFMQGIFGYLSVCIVYKWAVDWVKDGKPAPGLLNMLINMFLSPGTIDDELYPHQAKVQVFLLLMALVCIPWLLLVKPLHFKFTHKKKSHEPLPSTEADASSEDLEAQQLISAMDADDAEEEEVGSGSHGEDFGDIMIHQVIHTIEFCLNCVSHTASYLRLWALSLAHAQLSSVLWTMTIQIAFGFRGFVGVFMTVALFAMWFALTCAVLVLMEGTSAMLHSLRLHWVESMSKFFVGEGLPYEPFAFEYKDMEVAVASASSSASS');
INSERT INTO proteininfo VALUES ('6324843', 'NP_014912.1','Protein involved in nuclear migration, part of the dynein/dynactin pathway; targets dynein to microtubule tips, which is necessary for sliding of microtubules along bud cortex; synthetic lethal with bni1; homolog of human LIS1; Pac1p [Saccharomyces cerevisiae]','MTNWQQQLPLTDTQKNELDKSVLRYLNWNYKQTVRHEHAQDYESVRHAIVTLSGFLLQESVDRQEFISNNDTSNESMVDIDELLLPKKWNSIVRLQKKIIELEQNTETLVSQIKDLNTQVSELAQFKPTTSNGTSAHNVLKWIPRNLPSCLINVESSVTSVKLHPNLPIVFVATDHGKLYAFDLFNYTIPLASLQSHTKAITSMDVLFTNYTNSSKKNYLVIVTASKDLQIHVFKWVSEECKFQQIRSLLGHEHIVSAVKIWQKNNDVHIASCSRDQTVKIWDFHNGWSLKTFQPHSQWVRSIDVLGDYIISGSHDTTLRLTHWPSGNGLSVGTGHEFPIEKVKFIHFIEDSPEIRFRTPSTDRYKNWGMQYCVSASRDRTIKIWEIPLPTLMAHRAPIPNPTDSNFRCVLTLKGHLSWVRDISIRGQYLFSCADDKSVRCWDLNTGQCLHVWEKLHTGFVNCLDLDVDFDSNVTPRQMMVTGGLDCKSNVFMR');
INSERT INTO proteininfo VALUES ('6324842', 'NP_014911.1','Hypothetical ORF; Yor268cp [Saccharomyces cerevisiae]','MVFVFPFPFFSYGFSSFLEAGKKASYKMYYAEPELKTTRTGRAVACDAGSPRIIRVTLKDKIGLSERFTGRVFCYLAVACAWLSQYYHHTCAFFILYVHVCVCFLFFRWCLFATVSLIHESQTQAGSAYYTK');
INSERT INTO proteininfo VALUES ('6324841', 'NP_014910.1','Protein kinase with a role in ion homeostasis; Hrk1p [Saccharomyces cerevisiae]','MPNLLSRNPFHGHHNDHHHDRENSSNNPPQLIRSSKSFLNFIGRKQSNDSLRSEKSTDSMKSTTTTTNYTTTNLNNNTHSHSNATSISTNNYNNNYETNHHHNISHGLHDYTSPASPKQTHSMAELKRFFRPSVNKKLSMSQLRSKKHSTHSPPPSKSTSTVNLNNHYRAQHPHGFTDHYAHTQSAIPPSTDSILSLSNNINIYHDDCILAQKYGKLGKLLGSGAGGSVKVLVRPTDGATFAVKEFRPRKPNESVKEYAKKCTAEFCIGSTLHHPNVIETVDVFSDSKQNKYYEVMEYCPIDFFAVVMTGKMSRGEINCCLKQLTEGVKYLHSMGLAHRDLKLDNCVMTSQGILKLIDFGSAVVFRYPFEDGVTMAHGIVGSDPYLAPEVITSTKSYDPQCVDIWSIGIIYCCMVLKRFPWKAPRDSDDNFRLYCMPDDIEHDYVESARHHEELLKERKEKRQRFLNHSDCSAINQQQPAHESNLKTVQNQVPNTPASIQGKSDNKPDIVEEETEENKEDDSNNDKESTPDNDKESTIDIKISKNENKSTVVSANPKKVDADADADCDANGDSNGRVDCKANSDCNDKTDCNANNDCSNESDCNAKVDTNVNTAANANPDMVPQNNPQQQQQQQQQQQQQQQQQQQQHHHHQHQNQDKAHSIASDNKSSQQHRGPHHKKIIHGPYRLLRLLPHASRPIMSRILQVDPKKRATLDDIFNDEWFAAIAACTMDSKNKVIRAPGHHHTLVREENAHLETYKV');
INSERT INTO proteininfo VALUES ('6324840', 'NP_014909.1','Involved in targeting of proteins to the mitochondrial inner membrane; Pentamidine resistance protein; involved in pentamidine resistance protein; Pnt1p [Saccharomyces cerevisiae]','MDSRVALVRKYIAPSVIKSDSIQLHGLVKAPLFKALNSRYKLGSLQIVQDVDWNAKTTPSDSPEPLAATLNSNRSLPMTKFPKQEILEQVKLDTKVGKWRKFMTGWFRIGLYLLKSYKTGIQNTLKVFWDTRNEEQKFSIKNGALANLVREIEMHEINTRLSSSSLPTSSSAKAPLRPLSINRKTLVELIRRDQIWKLPVFFTLVFIFEEVSVLIFTFFPRVCPYNCLTPGGYKKLSNSYIKGTTSTQGNYGLGPLEFTKQGTIKYEPPYAVPIENLYNFLTSFPQSMISNWKLYIYKKLKLQKLLCNEIEKIYQYLFIDDWLLLQSILNTDVEKTKIALSDRELVNCILERKLYHMGDDLNEMVNDTLGKEILLKRLFLYWTLRYNDTISLNGKHTFSEKWGVNNISLLKYNSELVATKDIQ');
INSERT INTO proteininfo VALUES ('6324839', 'NP_014908.1','binds to beta-tubulin and may participate in microtubule morphogenesis; beta-tubulin binding protein; Rbl2p [Saccharomyces cerevisiae]','MAPTQLDIKVKALKRLTKEEGYYQQELKDQEAHVAKLKEDKSVDPYDLKKQEEVLDDTKRLLPTLYEKIREFKEDLEQFLKTYQGTEDVSDARSAITSAQELLDSK');
INSERT INTO proteininfo VALUES ('6324837', 'NP_014907.1','Daughter cell-specific protein, may help establish daughter fate; Dse3p [Saccharomyces cerevisiae]','MPRKFLGNKIEKNVDAVRPSSLTLTADDLKYIPPIPQDFEDEDDKVLRTSNGGNRLSKRFGGTLKLKKRLESVPELFLHDFKKRPRSQLEVIREKKFTDMQVPKGPVCPQSTILPLRERKKVKSLPIQRKSLRRPTLSKPAVVQSLGHKTHSDHIIDKVFVSRPAPIVMPVKALTPINPVSLMQTQTQDCCRKNKYGKSGSEILFDEILSAYENVSTSDSTALNSEIDRIIDICASKQIAKKNEAFQVPYVVCPDDTETLFSSTTPKLKPVNSNTLNDVISSPEYTTSGCSTYSDQSNSDEELSEVESIVWNTNKRTMRSSIVSESTSEEGYCTAAETLPSTVSVEDLDIHNKLPKVAQTSSCNTLLNKLSIRKLKKVILDPPKIMHVMTFDDDSDDGDDNDDEDRALNILQKKIDCIEIASCSSSIYSE');
INSERT INTO proteininfo VALUES ('6324836', 'NP_014905.1','Protein required for cell viability; Yor262wp [Saccharomyces cerevisiae]','MPFAQIVIGPPGSGKSTYCNGCSQFFNAIGRHSQVVNMDPANDALPYPCAVDIRDFITLEEIMQEQQLGPNGGLMYAVESLDNSIDLFILQIKSLVEEEKAYLVFDCPGQVELFTHHSSLFNIFKKMEKELDIRFCVVNLIDCFYMTSPSQYISILLLALRSMLMMDLPHINVFSKIDMLKSYGELPFRLDYYTEVQDLDYLEPYIEKEGSSVLGKKYSKLTETIKELVSDFNLVSFEVLSVDDKESMINLQGVIDKANGYIFGASEVGGDTVWAEASREGALIANYDIQDRWIDNKEKYDKEEEEKRTALLKEQELQNKAVDVNEEDEWENALKEWEEKQGMDFVR');
INSERT INTO proteininfo VALUES ('6324835', 'NP_014904.1','Essential, non-ATPase regulatory subunit of the 26S proteasome; has similarityl to the human p40 proteasomal subunit and to another S. cerevisiae regulatory subunit, Rpn11p; Rpn8p [Saccharomyces cerevisiae]','MSLQHEKVTIAPLVLLSALDHYERTQTKENKRCVGVILGDANSSTIRVTNSFALPFEEDEKNSDVWFLDHNYIENMNEMCKKINAKEKLIGWYHSGPKLRASDLKINELFKKYTQNNPLLLIVDVKQQGVGLPTDAYVAIEQVKDDGTSTEKTFLHLPCTIEAEEAEEIGVEHLLRDVRDQAAGGLSIRLTNQLKSLKGLQSKLKDVVEYLDKVINKELPINHTILGKLQDVFNLLPNLGTPDDDEIDVENHDRINISNNLQKALTVKTNDELMVIYISNLVRSIIAFDDLIENKIQNKKIQEQRVKDKQSKVSDDSESESGDKEATAPLIQRKNKKN');
INSERT INTO proteininfo VALUES ('6324834', 'NP_014903.1','Gamma subunit of the translation initiation factor eIF2B, the guanine-nucleotide exchange factor for eIF2; activity subsequently regulated by phosphorylated eIF2; first identified as a negative regulator of GCN4 expression; Gcd1p [Saccharomyces cerevisiae]','MSIQAFVFCGKGSNLAPFTQPDFPFQTQNKDSTAATSGDKLNELVNSALDSTVINEFMQHSTRLPKALLPIGNRPMIEYVLDWCDQADFKEISVVAPVDEIELIESGLTSFLSLRKQQFELIYKALSNSNHSHHLQDPKKINFIPSKANSTGESLQKELLPRINGDFVILPCDFVTDIPPQVLVDQFRNRDDNNLAMTIYYKNSLDSSIDKKQQQKQKQQQFFTVYSENEDSERQPILLDVYSQRDVTKTKYLQIRSHLLWNYPNLTVSTKLLNSFIYFCSFELCQLLKLGPQSMSRQASFKDPFTGNQQQQNPPTTDDDEDRNHDDDDDYKPSATSIQPTYFKKKNDLILDPINCNKSLSKVFRDLSRRSWQHSKPREPIGIFILPNETLFIRANNLNAYMDANRFVLKIKSQTMFTKNIQIQSAAIGADAIVDPKCQISAHSNVKMSVLGTQANIGSRCRVAGSLLFPGVHLGDEVILENCIIGPMAKIGSKCKLSNCYIEGHYVVEPKNNFKGETLANVYLDEDEEDELIYDDSVIAGESEIAEETDSDDRSDEDSDDSEYTDEYEYEDDGLFER');
INSERT INTO proteininfo VALUES ('6324833', 'NP_014902.1','Proteasome Cap Subunit; ATPase; component of the 26S proteasome cap subunit; Rpt4p [Saccharomyces cerevisiae]','MSEEQDPLLAGLGETSGDNHTQQSHEQQPEQPQETEEHHEEEPSRVDPEQEAHNKALNQFKRKLLEHRRYDDQLKQRRQNIRDLEKLYDKTENDIKALQSIGQLIGEVMKELSEEKYIVKASSGPRYIVGVRNSVDRSKLKKGVRVTLDITTLTIMRILPRETDPLVYNMTSFEQGEITFDGIGGLTEQIRELREVIELPLKNPEIFQRVGIKPPKGVLLYGPPGTGKTLLAKAVAATIGANFIFSPASGIVDKYIGESARIIREMFAYAKEHEPCIIFMDEVDAIGGRRFSEGTSADREIQRTLMELLTQMDGFDNLGQTKIIMATNRPDTLDPALLRPGRLDRKVEIPLPNEAGRLEIFKIHTAKVKKTGEFDFEAAVKMSDGFNGADIRNCATEAGFFAIRDDRDHINPDDLMKAVRKVAEVKKLEGTIEYQKL');
INSERT INTO proteininfo VALUES ('6324832', 'NP_014901.1','Member of the third branch of the histidine triad (HIT) superfamily of nucleotide-binding proteins; similar to Aprataxin, a Hint related protein that is mutated in individuals with ataxia with oculomotor apraxia; Hnt3p [Saccharomyces cerevisiae]','MSWRYALKNYVTSPETVNDDTVTYFDDKVSIIRDSFPKSECHLLILPRTMQLSRSHPTKVIDAKFKNEFESYVNSAIDHIFRHFQEKFRIKKSDDDKDPCWDDILKDKNKFVRNFVQVGIHSVPSMANLHIHVISKDFHSVRLKNKKHYNSFNTGFFISWDDLPLNGKNLGTDKEIETTYLKEHDLLCCYCQRNFSNKFSLLKKHLELEFNSHFELK');
INSERT INTO proteininfo VALUES ('6324831', 'NP_014900.1','Component of the spindle pole body (SPB) half-bridge, required for SPB duplication in mitosis and meiosis II; homolog of mammalian centrin; interacts with Kar1p; Cdc31p [Saccharomyces cerevisiae]','MSKNRSSLQSGPLNSELLEEQKQEIYEAFSLFDMNNDGFLDYHELKVAMKALGFELPKREILDLIDEYDSEGRHLMKYDDFYIVMGEKILKRDPLDEIKRAFQLFDDDHTGKISIKNLRRVAKELGETLTDEELRAMIEEFDLDGDGEINENEFIAICTDS');
INSERT INTO proteininfo VALUES ('6324830', 'NP_014899.1','Protein required for cell viability; Yor256cp [Saccharomyces cerevisiae]','MRSSYQPVSTTNFEHENAIPTASSSHNLLMSQRFDDSPPSSNDNSIETNITPPPEPPSYEFDIEDPHDDLHKRTHLQRVSIGFQEKILEPLMENIIHPLLQISKFVPDKADYYLSKIGNPFILRRFFYIIFMSFIAYYVLSSGYLFNEKASGSKGMFSQHDILFEYAKKSVDLAKFERDLEYISSMPHGSGTKGDAAIYRYIQESFDNNGLKLVKEMGYSVYSNYPGNVSISYYDNKNEKHDLELSKENFNPLSSNGKLSKVSLIYGGKGTTYDLQHLKDSKTIEDGKDYVLLLQYDKLVSQQVLIAEKFGAKAVIFISEPYGENIDVVQSKPVGLPQYSTGDASGLNWDGSPVEEKDHKFWRQTHIPTIPISTRQGKELLSRLSSGGVTVDDGNSDRSNSGKMGDVLIDVDLQTNVREKHFIPNIVGKIEGREQSDKAIIIAASRNSINFGTTYPNFGTAALLSIVQLFQEVKYKFGWKPLRNIYFISFGGTEFNYAGSSELVEQRLTPLKDEIYSLIDISQLGIPFAEKYENGKTRGELSIETHPLLKKFFNRNAHGNFDISVDNVQHYGDWTPFLANGIPVSVISSDSTRNRDTPTETSEDKFERVEKILEDEQNQQSVKDLLVYLLHISMELIDDPLLHFDIISYVEDIDERLQRLEQAYPEKLNFTSIIKGLLFWKKIGSEWASWTQGWENIVWSHGDGIEPSLLSINRWTWNKKLTNIGRRTCSPAGLPNRSFYKNVLFGPTLIQEDKSKNGGNVDFWTFPGVMDAIYDDDWKRAQEQIDLIGKVLHQSAALFVEETNDIGYK');
INSERT INTO proteininfo VALUES ('6324829', 'NP_014898.1','Non-essential protein required for construction of the outer spore wall layers; Osw1p [Saccharomyces cerevisiae]','MRAPPSPRKSKSGHFFYLYFRLCQLFSGRKLKRRWHVHKLHIHQYNTRWNLSPLSEIHIEDMINEPSGLCPGSSKKKPLLIARFPKGCQESPRVYVLQRNNLSRLKLSKRKYALRFYHNEIFGNNLKRKDGSIHKVEHQQCAETVRKIKKVTANHADVKIIFHDKNTIRSDKLGGRSNKMQTRPSVLEEDVEEEVSSVYIRFCDDHSLRVKDYHSLHRHSKKSSKEKRNNQEIGKSKLLGKLFEEETSRQNKGVEKKLDTIVIQKFQNYPIVSFSRVI');
INSERT INTO proteininfo VALUES ('6324828', 'NP_014897.1','Protein involved in protein import into ER; ER protein translocation subcomplex subunit; Sec63p [Saccharomyces cerevisiae]','MPTNYEYDEASETWPSFILTGLLMVVGPMTLLQIYQIFFGANAEDGNSGKSKEFNEEVFKNLNEEYTSDEIKQFRRKFDKNSNKKSKIWSRRNIIIIVGWILVAILLQRINSNDAIKDAATKLFDPYEILGISTSASDRDIKSAYRKLSVKFHPDKLAKGLTPDEKSVMEETYVQITKAYESLTDELVRQNYLKYGHPDGPQSTSHGIALPRFLVDGSASPLLVVCYVALLGLILPYFVSRWWARTQSYTKKGIHNVTASNFVSNLVNYKPSEIVTTDLILHWLSFAHEFKQFFPDLQPTDFEKLLQDHINRRDSGKLNNAKFRIVAKCHSLLHGLLDIACGFRNLDIALGAINTFKCIVQAVPLTPNCQILQLPNVDKEHFITKTGDIHTLGKLFTLEDAKIGEVLGIKDQAKLNETLRVASHIPNLKIIKADFLVPGENQVTPSSTPYISLKVLVRSAKQPLIPTSLIPEENLTEPQDFESQRDPFAMMSKQPLVPYSFAPFFPTKRRGSWCCLVSSQKDGKILQTPIIIEKLSYKNLNDDKDFFDKRIKMDLTKHEKFDINDWEIGTIKIPLGQPAPETVGDFFFRVIVKSTDYFTTDLDITMNMKVRDSPAVEQVEVYSEEDDEYSTDDDETESDDESDASDYTDIDTDTEAEDDESPE');
INSERT INTO proteininfo VALUES ('6324827', 'NP_014896.1','Nat5p [Saccharomyces cerevisiae]','MGRDICTLDNVYANNLGMLTKLAHVTVPNLYQDAFFSALFAEDSLVAKNKKPSSKKDVHFTQMAYYSEIPVGGLVAKLVPKKQNELSLKGIQIEFLGVLPNYRHKSIGSKLLKFAEDKCSECHQHNVFVYLPAVDDLTKQWFIAHGFEQVGETVNNFIKGVNGDEQDAILLKKHIS');
INSERT INTO proteininfo VALUES ('6324826', 'NP_014895.1','Hypothetical ORF; Yor252wp [Saccharomyces cerevisiae]','MREDKIAAKKKLHQDKRVHELARVKFMQDVVNSDTFKGQPIFDHAHTREFIQSFIERDDTELDELKKKRRSNRPPSNRQVLLQQRRDQELKEFKAGFLCPDLSDAKNMEFLRNWNGTFGLLNTLRLIRINDKGEQVVGGNE');
INSERT INTO proteininfo VALUES ('6324825', 'NP_014894.1','catalyzes transfer of the sulfane atom of thiosulfate to cyanide to form sulfite and thiocyanate; Yor251cp [Saccharomyces cerevisiae]','MPLFDLISPKAFVKLVASEKVHRIVPVDATWYLPSWKLDNKVDFLTKPRIPNSIFFDIDAISDKKSPYPHMFPTKKVFDDAMSNLGVQKDDILVVYDRVGNFSSPRCAWTLGVMGHPKVYLLNNFNQYREFKYPLDSSKVAAFSPYPKSHYESSESFQDKEIVDYEEMFQLVKSGELAKKFNAFDARSLGRFEGTEPEPRSDIPSGHIPGTQPLPYGSLLDPETKTYPEAGEAIHATLEKALKDFHCTLDPSKPTICSCGTGVSGVIIKTALELAGVPNVRLYDGSWTEWVLKSGPEWIAENRD');
INSERT INTO proteininfo VALUES ('6324824', 'NP_014893.1','cleavage/polyadenylation factor IA subunit; interacts with Pcf11p in the 2-hybrid system; cleavage/polyadenylation factor IA subunit; Clp1p [Saccharomyces cerevisiae]','MASLPGIDEHTTSEELITGDNEWHKLVIPKGSDWQIDLKAEGKLIVKVNSGIVEIFGTELAVDDEYTFQNWKFPIYAVEETELLWKCPDLTTNTITVKPNHTMKYIYNLHFMLEKIRMSNFEGPRVVIVGGSQTGKTSLSRTLCSYALKFNAYQPLYINLDPQQPIFTVPGCISATPISDILDAQLPTWGQSLTSGATLLHNKQPMVKNFGLERINENKDLYLECISQLGQVVGQRLHLDPQVRRSGCIVDTPSISQLDENLAELHHIIEKLNVNIMLVLCSETDPLWEKVKKTFGPELGNNNIFFIPKLDGVSAVDDVYKRSLQRTSIREYFYGSLDTALSPYAIGVDYEDLTIWKPSNVFDNEVGRVELFPVTITPSNLQHAIIAITFAERRADQATVIKSPILGFALITEVNEKRRKLRVLLPVPGRLPSKAMILTSYRYLE');
INSERT INTO proteininfo VALUES ('6324823', 'NP_014892.1','subunit of the Anaphase Promoting Complex; all known APC subunits co-immunoprecipitate with epitope-tagged Apc5; subunit of the anaphase promoting complex; Apc5p [Saccharomyces cerevisiae]','MSKYGPLGITNFITPYDLCILILIHAHCSQDNGISVPTAVFLRLISPTRPSLEWNPLLKDNSNLRSSSIVPPPVLPILDNIIRILLDDKDGNKIALTLMGYLEAINGLDSINRLMMDLEKNCLVNNYRSMKMRTTSTRRQMTRASFLGTFLSTCIRKYQIGDFEMRETIWINLQNFKTVFKHTPLWLRFKDNVHIQKVKNCLLANDEISVEDQQMVEFFQHFNNGNDADSKTMNEENYGTLISIQHLQSIVNRQIVNWLDNTEFNLMGQEETSSTYEEQSGLVFDLLDTLSLNDATKFPLIFILKYLEAIKENSYQTALDSLHNYFDYKSTGNSQNYFHISLLSLATFHSSFNECDAAINSFEEATRIARENKDMETLNLIMIWIINFIEVHPEYANRFYITVEQIIKYLKNSSDVEDANIFSNAYKFETLLSMVKESKTAEVSSSLLKFMAITLQNVPSQNFDLFQSLVSYEVKFWKELGYESISDVYEKFLSKTSSSSLRNYDSSIINQDIKVAFKALEEDDFLKVKQYLLKSESLELDYDQKINLKYLRVKYLVKIGDYDLSMRLINQYVKECCEEVADSNWRFKFEIESINVLLLSDVGIRSLPKIIKLIDEYKEIGNPLRCVILLLKLCEVLIQVGKSMEAECLISCNLSTILEFPFVRKKTDELLESLSVEEDRDVQMT');
INSERT INTO proteininfo VALUES ('6324821', 'NP_014890.1','Suppressor of rad53 null mutant lethality; Srl1p [Saccharomyces cerevisiae]','MLQSVVFFALLTFASSVSAIYSNNTVSTTTTLAPSYSLVPQETTISYADDTTTFFVTSTVYSTSWFTSTSATITNAASSSLSTSSASGSVTPESTHEITSTSTITSTLLLTLHDSTTLSPSSTAASVSDEDSNNKDAKVKSFEQASTSNGCVPITKFVTVTNEPVTQYVTVTPNTTTQYVTVTGAPSVTTTSPGNVQWYNTTSITNSTSW');
INSERT INTO proteininfo VALUES ('6324820', 'NP_014889.1','Protein with similarity to oxidoreductases, found in lipid particles; required for replication of Brome mosaic virus in S. cerevisiae, which is a model system for studying replication of positive-strand RNA viruses in their natural hosts; Yor246cp [Saccharomyces cerevisiae]','MLDPRILPYYDPAVERKIAVVTGGNTGIGWYTVLHLYLHGFVVYICGRNSHKISKAIQEILAEAKKRCHEDDDGSSPGAGPGPSIQRLGSLHYIHLDLTDLKCVERAALKILKLEDHIDVLVNNAGIMAVPLEMTKDGFEVQLQTNYISHFIFTMRLLPLLRHCRGRIISLSSIGHHLEFMYWKLSKTWDYKPNMLFTWFRYAMSKTALIQCTKMLAIKYPDVLCLSVHPGLVMNTNLFSYWTRLPIVGIFFWLLFQVVGFFFGVSNEQGSLASLKCALDPNLSVEKDNGKYFTTGGKESKSSYVSNNVDEAASTWIWTVHQLRDRGFDI');
INSERT INTO proteininfo VALUES ('6324819', 'NP_014888.1','Diacylglycerol acyltransferase, catalyzes the terminal step of triacylglycerol (TAG) formation, acylates diacylglycerol using acyl-CoA as an acyl donor, localized to lipid particles; Dga1p [Saccharomyces cerevisiae]','MSGTFNDIRRRKKEEGSPTAGITERHENKSLSSIDKREQTLKPQLESCCPLATPFERRLQTLAVAWHTSSFVLFSIFTLFAISTPALWVLAIPYMIYFFFDRSPATGEVVNRYSLRFRSLPIWKWYCDYFPISLIKTVNLKPTFTLSKNKRVNEKNYKIRLWPTKYSINLKSNSTIDYRNQECTGPTYLFGYHPHGIGALGAFGAFATEGCNYSKIFPGIPISLMTLVTQFHIPLYRDYLLALGISSVSRKNALRTLSKNQSICIVVGGARESLLSSTNGTQLILNKRKGFIKLAIQTGNINLVPVFAFGEVDCYNVLSTKKDSVLGKMQLWFKENFGFTIPIFYARGLFNYDFGLLPFRAPINVVVGRPIYVEKKITNPPDDVVNHFHDLYIAELKRLYYENREKYGVPDAELKIVG');
INSERT INTO proteininfo VALUES ('6324818', 'NP_014887.1','Histone acetyltransferase catalytic subunit of the native multisubunit complex (NuA4) that acetylates four, conserved internal lysines of histone H4 N-terminal tail; required for cell cycle progression; Esa1p [Saccharomyces cerevisiae]','MSHDGKEEPGIAKKINSVDDIIIKCQCWVQKNDEERLAEILSINTRKAPPKFYVHYVNYNKRLDEWITTDRINLDKEVLYPKLKATDEDNKKQKKKKATNTSETPQDSLQDGVDGFSRENTDVMDLDNLNVQGIKDENISHEDEIKKLRTSGSMTQNPHEVARVRNLNRIIMGKYEIEPWYFSPYPIELTDEDFIYIDDFTLQYFGSKKQYERYRKKCTLRHPPGNEIYRDDYVSFFEIDGRKQRTWCRNLCLLSKLFLDHKTLYYDVDPFLFYCMTRRDELGHHLVGYFSKEKESADGYNVACILTLPQYQRMGYGKLLIEFSYELSKKENKVGSPEKPLSDLGLLSYRAYWSDTLITLLVEHQKEITIDEISSMTSMTTTDILHTAKTLNILRYYKGQHIIFLNEDILDRYNRLKAKKRRTIDPNRLIWKPPVFTASQLRFAW');
INSERT INTO proteininfo VALUES ('6324817', 'NP_014886.1','pseudouridylates U2 snRNA at position 35; Pus7p [Saccharomyces cerevisiae]','MSDSSEATVKRPLDAHVGPSENAAKKLKIEQRTQADGIHEADVGITLFLSPELPGFRGQIKQRYTDFLVNEIDQEGKVIHLTDKGFKMPKKPQRSKEEVNAEKESEAARRQEFNVDPELRNQLVEIFGEEDVLKIESVYRTANKMETAKNFEDKSVRTKIHQLLREAFKNELESVTTDTNTFKIARSNRNSRTNKQEKINQTRDANGVENWGYGPSKDFIHFTLHKENKDTMEAVNVITKLLRVPSRVIRYAGTKDRRAVTCQRVSISKIGLDRLNALNRTLKGMIIGNYNFSDASLNLGDLKGNEFVVVIRDVTTGNSEVSLEEIVSNGCKSLSENGFINYFGMQRFGTFSISTHTIGRELLLSNWKKAAELILSDQDNVLPKSKEARKIWAETKDAALALKQMPRQCLAENALLYSLSNQRKEEDGTYSENAYYTAIMKIPRNLRTMYVHAYQSYVWNSIASKRIELHGLKLVVGDLVIDTSEKSPLISGIDDEDFDEDVREAQFIRAKAVTQEDIDSVKYTMEDVVLPSPGFDVLYPSNEELKQLYVDILKADNMDPFNMRRKVRDFSLAGSYRTVIQKPKSLEYRIIHYDDPSQQLVNTDLDILNNTRAKESGQKYMKAKLDRYMPDKGGEKTAVVLKFQLGTSAYATMALRELMKLETSRRGDMCDVKENI');
INSERT INTO proteininfo VALUES ('6324816', 'NP_014885.1','Sporulation SPecific; involved in sporulation; Ssp2p [Saccharomyces cerevisiae]','MYKNYYSNTEVYKKHKDSGSLRKKALRSRRSSFFSFFNDSSSSNGNEFIGFRRFAKAYLFGREIGSCGTDSYTPVGANVNKRRLKKEDKNDQQLWKRQHHSQGCFFPIDDDSNKQTEAAVNKFYENGEYVNQDLIFKGKVYSEESEVVDEKTAGSQNPALLKTRSISLNDIPRGTGISSVLSQVRGGSLERIIVYRYDTPERSLHKVDLFFLNYEGAQSFMRYAKTNIFKVNGVQLKPEWIFLESTYENIMKEQSVNRIIEEEKFISRCLIVKKSSTTAMPNKSNLNKGQTLENIDIQELEKDFQNFGEVLEITPIVSRKLCVSIFFYDISSAMRAMEEYEQKGSYLYNKYFKTWTIWYGKDITDQPCIDL');
INSERT INTO proteininfo VALUES ('6324815', 'NP_014884.1','Folylpolyglutamate synthetase, catalyzes extension of the glutamate chains of the folate coenzymes, required for methionine synthesis and for maintenance of mitochondrial DNA, present in both the cytoplasm and mitochondria; Met7p [Saccharomyces cerevisiae]','MHKGKKNYPNLITSFRMNLKKIILNHDRFSHPERWKTNALLRFTFVYIKFLFDLMIIKNPLRMVGKTYRDAVTALNSLQSNYANIMAIRQTGDRKNTMTLLEMHEWSRRIGYSASDFNKLNIVHITGTKGKGSTAAFTSSILGQYKEQLPRIGLYTSPHLKSVRERIRINGEPISEEKFAKYFFEVWDRLDSTTSSLDKFPHMIPGSKPGYFKFLTLLSFHTFIQEDCKSCVYEVGVGGELDSTNIIEKPIVCGVTLLGIDHTFMLGDTIEEIAWNKGGIFKSGAPAFTVEKQPPQGLTILKERAEERKTTLTEVPPFKQLENVKLGIAGEFQKSNASLAVMLASEILHTSNILEEKIKCSSNASIPEKFIIGLQNTKWEGRCQVLEKGKNVWYIDGAHTKDSMVAASTWFRDMVRLSKRKKILLFNQQSRDANALVNNLYSSVSPEITFDDVIFTTNVTWKSGSYSADLVSMNTSQEDVEKLKVQESLVKNWNKIDDNRAKTHVTASIEEANELIETLYDEPADIFVTGSLHLVGGLLVVFDRIDVK');
INSERT INTO proteininfo VALUES ('6324811', 'NP_014880.1','Protein implicated in the regulation of ergosterol biosynthesis; one of a seven member gene family with a common essential function and non-essential unique functions; similar to human oxysterol binding protein (OSBP); Hes1p [Saccharomyces cerevisiae]','MSQHASSSSWTSFLKSISSFNGDLSSLSAPPFILSPTSLTEFSQYWAEHPALFLEPSLIDGENYKDHCPFDPNVESKEVAQMLAVVRWFISTLRSQYCSRSESMGSEKKPLNPFLGEVFVGKWKNDEHPEFGETVLLSEQVSHHPPMTAFSIFNEKNDVSVQGYNQIKTGFTKTLTLTVKPYGHVILKIKDETYLITTPPLHIEGILVASPFVELGGRSFIQSSNGMLCVIEFSGRGYFTGKKNSFKARIYRSPQEHSHKENALYLISGQWSGVSTIIKKDSQVSHQFYDSSETPTEHLLVKPIEEQHPLESRRAWKDVAEAIRQGNISMIKKTKEELENKQRALREQERVKGVEWQRRWFKQVDYMNENTSNDVEKASEDDAFRKLASKLQLSVKNVPSGTLIGGKDDKKDVSTALHWRFDKNLWMRENEITI');
INSERT INTO proteininfo VALUES ('6324810', 'NP_014879.1','Dihydrofolate reductase, part of the dTTP biosynthetic pathway, involved in folate metabolism, possibly required for mitochondrial function; Dfr1p [Saccharomyces cerevisiae]','MAGGKIPIVGIVACLQPEMGIGFRGGLPWRLPSEMKYFRQVTSLTKDPNKKNALIMGRKTWESIPPKFRPLPNRMNVIISRSFKDDFVHDKERSIVQSNSLANAIMNLESNFKEHLERIYVIGGGEVYSQIFSITDHWLITKINPLDKNATPAMDTFLDAKKLEEVFSEQDPAQLKEFLPPKVELPETDCDQRYSLEEKGYCFEFTLYNRK');
INSERT INTO proteininfo VALUES ('6324808', 'NP_014877.1','Ribosomal protein L37 of the large (60S) ribosomal subunit, nearly identical to Rpl33Ap and has similarity to rat L35a; rpl33b null mutant exhibits normal growth while rpl33a rpl33b double null mutant is inviable; Rpl33bp [Saccharomyces cerevisiae]','MAESHRLYVKGKHLSYQRSKRVNNPNVSLIKIEGVATPQEAQFYLGKRIAYVYRASKEVRGSKIRVMWGKVTRTHGNSGVVRATFRNNLPAKTFGASVRIFLYPSNI');
INSERT INTO proteininfo VALUES ('6324807', 'NP_014876.1','protein kinase; Kin4p [Saccharomyces cerevisiae]','MASVPKRHTYGGNVVTDRDRHSLQRNNEILHPIHKNQRKHATFGPYIIGSTLGEGEFGKVKLGWTKASSSNEVPKQVAIKLIRRDTIKKDADKEIKIYREINALKHLTHPNIIYLEEVLQNSKYIGIVLEFVSGGEFYKYIQRKRRLKESSACRLFAQLISGVNYMHYKGLVHRDLKLENLLLDKHENLVITDFGFVNEFFEDNELMKTSCGSPCYAAPELVVSTKAYEARKADVWSCGVILYAMLAGYLPWDDDHENPTGDDIARLYKYITQTPLKFPEYITPIPRDLLRRILVPNPRRRINLQTIKRHVWLKPHEAFLSIQPNYWDEHLQKERPKPPNKGDVGRHSTYSSSASSYSKSRDRNSLIIESTLEQHRMSPQLATSRPASPTFSTGSKVVLNDTKNDMKESNINGERTSASCRYTRDSKGNGQTQIEQVSARHSSRGNKHTSVAGLVTIPGSPTTARTRNAPSSKLTEHVKDSSQTSFTQEEFHRIGNYHVPRSRPRPTSYYPGLSRNTADNSLADIPVNKLGSNGRLTDAKDPVPLNAIHDTNKATISNNSIMLLSEGPAAKTSPVDYHYAIGDLNHGDKPITEVIDKINKDLTHKAAENGFPRESIDPESTSTILVTKEPTNSTDEDHVESQLENVGHSSNKSDASSDKDSKKIYEKKRFSFMSLYSSLNGSRSTVESRTSKGNAPPVSSRNPSGQSNRSNIKITQQQPRNLSDRVPNPDKKINDNRIRDNAPSYAESENPGRSVRASVMVSTLREENRSELSNEGNNVEAQTSTARKVLNFFKRRSMRV');
INSERT INTO proteininfo VALUES ('6324806', 'NP_014875.1','involved in protein import into mitochondria; GrpE homolog, mitochondrial matrix protein; Mge1p [Saccharomyces cerevisiae]','MRAFSAATVRATTRKSFIPMAPRTPFVTPSFTKNVGSMRRMRFYSDEAKSEESKENNEDLTEEQSEIKKLESQLSAKTKEASELKDRLLRSVADFRNLQQVTKKDIQKAKDFALQKFAKDLLESVDNFGHALNAFKEEDLQKSKEISDLYTGVRMTRDVFENTLRKHGIEKLDPLGEPFDPNKHEATFELPQPDKEPGTVFHVQQLGFTLNDRVIRPAKVGIVKGEEN');
INSERT INTO proteininfo VALUES ('6324805', 'NP_014874.1','Mitogen-activated kinase-kinase involved in protein kinase C pathway; protein kinase involved in protein kinase C pathway; Mkk1p [Saccharomyces cerevisiae]','MASLFRPPESAKCNPNSPRLKLPLLRNNQVDENNIYLTSNGSSTTAYSSHTPEPLTSSTSTLFSQTRLHPSDSSMTLNTMKKRPAPPSLPSLSINSQSKCKTLPELVPIADVSDGKHDLGLKQRVIAENELSGNSDLTPSSMASPFSHTNTSSPYLRNDLSNSVGSDFSNLISAYEQSSSPIKSSSQPKSSSESYIDLNSVRDVDQLDENGWKYANLKDRIETLGILGEGAGGSVSKCKLKNGSKIFALKVINTLNTDPEYQKQIFRELQFNRSFQSEYIVRYYGMFTDDENSSIYIAMEYMGGRSLDAIYKNLLERGGRISEKVLGKIAEAVLRGLSYLHEKKVIHRDIKPQNILLNENGQVKLCDFGVSGEAVNSLATTFTGTSFYMAPERIQGQPYSVTSDVWSLGLTILEVANGKFPCSSEKMAANIAPFELLMWILTFTPELKDEPESNIIWSPSFKSFIDYCLKKDSRERPSPRQMINHPWIKGQMKKNVNMEKFVRKCWKD');
INSERT INTO proteininfo VALUES ('6324804', 'NP_014873.1','WD repeat containing transcriptional modulator 1; Transcriptional modulator; Wtm1p [Saccharomyces cerevisiae]','MPKKVWKSSTPSTYEHISSLRPKFVSRVDNVLHQRKSLTFSNVVVPDKKNNTLTSSVIYSQGSDIYEIDFAVPLQEAASEPVKDYGDAFEGIENTSLSPKFVYQGETVSKMAYLDKTGETTLLSMSKNGSLAWFKEGIKVPIHIVQELMGPATSYASIHSLTRPGDLPEKDFSLAISDFGISNDTETIVKSQSNGDEEDSILKIIDNAGKPGEILRTVHVPGTTVTHTVRFFDNHIFASCSDDNILRFWDTRTSDKPIWVLGEPKNGKLTSFDCSQVSNNLFVTGFSTGIIKLWDARAAEAATTDLTYRQNGEDPIQNEIANFYHAGGDSVVDVQFSATSSSEFFTVGGTGNIYHWNTDYSLSKYNPDDTIAPPQDATEESQTKSLRFLHKGGSRRSPKQIGRRNTAAWHPVIENLVGTVDDDSLVSIYKPYTEESE');
INSERT INTO proteininfo VALUES ('6324803', 'NP_014872.1','WD repeat containing transcriptional modulator 2; Transcriptional modulator; Wtm2p [Saccharomyces cerevisiae]','MAKSKSSQGASGARRKPAPSLYQHISSFKPQFSTRVDDVLHFSKTLTWRSEIIPDKSKGTLTTSLLYSQGSDIYEIDTTLPLKTFYDDDDDDDNDDDDEEGNGKTKSAATPNPEYGDAFQDVEGKPLRPKWIYQGETVAKMQYLESSDDSTAIAMSKNGSLAWFRDEIKVPVHIVQEMMGPATRYSSIHSLTRPGSLAVSDFDVSTNMDTVVKSQSNGYEEDSILKIIDNSDRPGDILRTVHVPGTNVAHSVRFFNNHLFASCSDDNILRFWDTRTADKPLWTLSEPKNGRLTSFDSSQVTENLFVTGFSTGVIKLWDARAVQLATTDLTHRQNGEEPIQNEIAKLFHSGGDSVVDILFSQTSATEFVTVGGTGNVYHWDMEYSFSRNDDDNEDEVRVAAPEELQGQCLKFFHTGGTRRSSNQFGKRNTVALHPVINDFVGTVDSDSLVTAYKPFLASDFIGRGYDD');
INSERT INTO proteininfo VALUES ('6324802', 'NP_014871.1','Hypothetical ORF; Yor228cp [Saccharomyces cerevisiae]','MIKLHEVPPEPVDPASLPHDVNAHSPEGDGNPDKRKKIFGIPYPFSRSSCRRFLWNCQKISVLPMALYFPLHAANTLITPAVSPDSAPDDVLMMVREILPSITTKLLVAGITLHVSAGVLLRIVNNWNKPRRNRHRHLKISAEQDLSQDSIGLTGGISGYLFGLYKTFRIPPQVISGYILVPVLIYHLLIMKWVPNSISTEVDFASIKQLLSSKNRWWKWLGGLVPLAILLESGVYHIGSGLCRYFGVRKMTSRKKWSTAINLLTLVGFVSLIRLMKEDSTKLGPNQFESIFKKIRLLLHVN');
INSERT INTO proteininfo VALUES ('6324801', 'NP_014870.1','Hypothetical ORF; Yor227wp [Saccharomyces cerevisiae]','MSSKLKYTDIDVPLDWLYKGKRRNRTKSAASTRTSEATTTSVKKTATLPSTAAVPTKTIASPQRPLSGQNVNNELSNSKPAVSAEKVSQQGQVPTRRTRSHSVSYGLLQKKNNNDDTTDSPKISRIRTAQDQPVKETKSSTLAEPIVSKKGRSRSSSISTSLNERSKKSLFGSLFGRRPSTTPSHVVERPLSSQNDHKKSTELPPIDTRQSKISTPTSTPTTASSKPSSSGGNRHSDGSLTSKLLSIPHNILETSSTNFNAHHHIQSHHSSGREQDSPHSESSDLPPILEKETTQKQLQKVSKVNLKRVTIAVQEFNSDPPQQLPSRKPKRGNVLIPEDMISAPPLISLGITNSSDQSSFQSNISPSYSKDSKEYKLALENFKKAAKEAEKHQKDAYYVAERMAQEVANYKARQLKTSPLTGATNSAADSATDQESSSLDARASKLHIDKPINVGAHPFETHQDDNIKYSSHLEQTLDVAYTRCCHLREILPIPSTLRQVKGKTAPLQTLKFLNPKPTLVDILSFCDFIAITPIHNIIFDNVSLTHDMFKIVICSLVTSPVVEKLGLRNVVINEQSWKLLCKFLLQNKTLIKLDISQTKARTDLNDSNYRDQMDWELFCEVLRNREGRPLEELLLNGLRFDKMSFSHFKNILLTFAQMNPKNPIRLGMANVEFSTECFDFLFNWMSEYNVQGVDLAYNNLESLAKRMIKKLARLPYKHLEYFTLNSTNITSVDDMSYILKYLSRLPSIKFLDLSNLPQLFPGILTSGYKYFPQFPQLKRIHFDFDDLSIKETTMLVSILAKCETLSHVSLIGQSPMPDASKISDSTDEPDKSKDEKKEQIVFMRNTLWASLYAFVRDSHNLVSLDVDYDQVPDEIQSRIALCLMHNMKRIMDSSFKLDELTVQDDLIFDGSLITETAEEVLKRLNDKSLLQNDVGKKYLLKKYFEKMEKVHHNVQNTIDSMFEKRKSGELPLQEKENLLRLLLLEKNLSNILDIFASMPNIADVVPFSKADNSFPNIGDSTVSANYNDGIRPSLKHLDSDRLINDVSIPENDSSIRPHLMATDSGRIIDVTTGKALLFKSSSNTSLAGKRQEEEEGELHKWGVFVQHQSSRHNSGLPSSANSSRISGSLTPDSSVAGGKKGESSRTSGTRPKILPKIPTGAELRDAIIKAKGIDSVDDLIKNVTSEKVGLESLYGDELNSRSPSNDSLQESQQKAPLQRPLVEDETVTKKYDKLLNDLSNVRHSKT');
INSERT INTO proteininfo VALUES ('6324800', 'NP_014869.1','Conserved protein of the mitochondrial matrix, required for synthesis of mitochondrial and cytosolic iron-sulfur proteins, performs a scaffolding function in mitochondria during Fe/S cluster assembly; isu1 isu2 double mutant is inviable; Isu2p [Saccharomyces cerevisiae]','MFARLANPAHFKPLTGSHITRAAKRLYHPKVIDHYTNPRNVGSMDKSLANVGTGIVGAPACGDVIKLQIQVNDKSGIIENVKFKTFGCGSAIASSSYMTELVRGMSLDEAVKIKNTEIAKELSLPPVKLHCSMLAEDAIKAAIKDYKTKRNPSVLH');
INSERT INTO proteininfo VALUES ('6324798', 'NP_014867.1','RNA polymerase subunit, found in RNA polymerase complexes I, II, and III; Rpb8p [Saccharomyces cerevisiae]','MSNTLFDDIFQVSEVDPGRYNKVCRIEAASTTQDQCKLTLDINVELFPVAAQDSLTVTIASSLNLEDTPANDSSATRSWRPPQAGDRSLADDYDYVMYGTAYKFEEVSKDLIAVYYSFGGLLMRLEGNYRNLNNLKQENAYLLIRR');
INSERT INTO proteininfo VALUES ('6324797', 'NP_014866.1','Hypothetical ORF; Yor223wp [Saccharomyces cerevisiae]','MSAEPLLPTHNGSQGGEVRSPDQKFIVIRFSDVSVRDLQLNISNVPFSNINTHWLRRMCRELRPQQTQKRRLKFIRNGSILNTHSKIAEELTHYFDTANNSNVATGTSVAPEQNNYYIHCIIGTEELTQAELANEDLKDDATPSNDSMTTQAIGFDRLRSVGFTEQEIELLRQQFRATYGDLEEEEERLAQNGNRDDEGHDIRQLEEQWMESGSGTAQGNGAGGGNEDRFNSVPIANIKHNKDLLLGICVGFFFGVFGILLMKFDGLFNRRQKMAIFAGVIVNVMFCLVRGF');
INSERT INTO proteininfo VALUES ('6324796', 'NP_014865.1','Mitochondrial inner membrane transporter, exports 2-oxoadipate and 2-oxoglutarate from the mitochondrial matrix to the cytosol for use in lysine and glutamate biosynthesis and in lysine catabolism; Odc2p [Saccharomyces cerevisiae]','MSSDSNAKPLPFIYQFISGAVAGISELTVMYPLDVVKTRFQLEVTTPTAAAVGKQVERYNGVIDCLKKIVKKEGFSRLYRGISSPMLMEAPKRATKFACNDQYQKIFKNLFNTNETTQKISIAAGASAGMTEAAVIVPFELIKIRMQDVKSSYLGPMDCLKKTIKNEGIMGLYKGIESTMWRNALWNGGYFGVIYQVRNSMPVAKTKGQKTRNDLIAGAIGGTVGTMLNTPFDVVKSRIQSVDAVSSAVKKYNWCLPSLLVIYREEGFRALYKGFVPKVCRLAPGGSLMLVVFTGMMNFFRDLKYGH');
INSERT INTO proteininfo VALUES ('6324795', 'NP_014864.1','malonyl-CoA:ACP transferase; Mct1p [Saccharomyces cerevisiae]','MLVLRKLEENYRPLNILKMQKVSSSYMAFFGRQGTSISISILKAIIRNKSREFQTILSQNGKESNDLLQYIFQNPSSPGSIAVCSNLFYQLYQILSNPSDPQDQAPKNMTKIDSPDKKDNEQCYLLGHSLGELTCLSVNSLFSLKDLFDIANFRNKLMVTSTEKYLVAHNINRSNKFEMWALSSPRATDLPQEVQKLLNSPNLLSSSQNTISVANANSVKQCVVTGLVDDLESLRTELNLRFPRLRITELTNPYNIPFHNSTVLRPVQEPLYDYIWDILKKNGTHTLMELNHPIIANLDGNISYYIHHALDRFVKCSSRTVQFTMCYDTINSGTPVEIDKSICFGPGNVIYNLIRRNCPQVDTIEYTSLATIDAYHKAAEENKD');
INSERT INTO proteininfo VALUES ('6324794', 'NP_014863.1','Hypothetical ORF; Yor220wp [Saccharomyces cerevisiae]','MANQKQMRTQILITDIPSGKFTSKWPTQLEKTLFKEQFPNLQSHLQYYTPLPFLNRIIIIFDNEDDTLQVFKFLQELLAKENSGPMKLFVTESLLNNQHPRSRSTDDAVSLQDNNLALLEDHRNKPLLSINTDPGVTGVDSSSLNKGGSSLSPDKSSLESPTMLKLSTDSKPFSYQEPLPKLSRSSSSTSNLSLNRSSQTSLPSQLENKDKSASGTKCLFASKPLGLTIDTSTRSNAASCTENDVNATASNPPKSPSITVNEFFH');
INSERT INTO proteininfo VALUES ('6324793', 'NP_014862.1','dipeptidyl aminopeptidase; Ste13p [Saccharomyces cerevisiae]','MSASTHSHKRKNSHLFPQRKSSNSSMDKPFFPNNDSVANTDPQSNENGHTINEIRPTEATIDVTDVPQTPFLQEQYSMRPRRESFQFNDIENQHHTHSFFSVNKFNRRWGEWSLPEKRSYVLVFTLIALSVLVLLVILIPSKLLPTKITRPKTSAGDSSLGKRSFSIENVLNGDFAIPEDTFHFIDPPQRLLGQDSDPGLYFTTKEIDGHTNFIAKQLFDETFEVNLGGNRFLYEGVEFTVSTVQINYKLDKLIFGTNLESEFRHSSKGFYWIKDLNTGNIEPILPPEKSDDNYELGLSKLSYAHFSPAYNYIYFVYENNLFLQQVNSGVAKKVTEDGSKDIFNAKPDWIYEEEVLASDQAIWWAPDDSKAVFARFNDTSVDDIRLNRYTNMNEAYLSDTKIKYPKPGFQNPQFDLFLVNLQNGIIYSINTGGQKDSILYNGKWISPDTFRFEITDRNSKILDVKVYDIPSSQMLTVRNTNSNLFNGWIEKTKDILSIPPKPELKRMDYGYIDIHADSRGFSHLFYYPTVFAKEPIQLTKGNWEVTGNGIVGYEYETDTIFFTANEIGVMSQHLYSISLTDSTTQNTFQSLQNPSDKYDFYDFELSSSARYAISKKLGPDTPIKVAGPLTRVLNVAEIHDDSILQLTKDEKFKEKIKNYDLPITSYKTMVLDDGVEINYIEIKPANLNPKKKYPILVNIYGGPGSQTFTTKSSLAFEQAVVSGLDVIVLQIEPRGTGGKGWSFRSWAREKLGYWEPRDITEVTKKFIQRNSQHIDESKIAIWGWSYGGFTSLKTVELDNGDTFKYAMAVAPVTNWTLYDSVYTERYMNQPSENHEGYFEVSTIQNFKSFESLKRLFIVHGTFDDNVHIQNTFRLVDQLNLLGLTNYDMHIFPDSDHSIRYHNAQRIVFQKLYYWLRDAFAERFDNTEVLHL');
INSERT INTO proteininfo VALUES ('6324791', 'NP_014860.1','RFC is a DNA binding protein and ATPase that acts as a processivity factor for DNA polymerases delta and epsilon and loads proliferating cell nuclear antigen (PCNA) on DNA; Subunit 1 of Replication Factor C; homologous to human RFC 140 kDa subunit; Rfc1p [Saccharomyces cerevisiae]','MVNISDFFGKNKKSVRSSTSRPTRQVGSSKPEVIDLDTESDQESTNKTPKKMPVSNVIDVSETPEGEKKLPLPAKRKASSPTVKPASSKKTKPSSKSSDSASNITAQDVLDKIPSLDLSNVHVKENAKFDFKSANSNADPDEIVSEIGSFPEGKPNCLLGLTIVFTGVLPTLERGASEALAKRYGARVTKSISSKTSVVVLGDEAGPKKLEKIKQLKIKAIDEEGFKQLIAGMPAEGGDGEAAEKARRKLEEQHNIATKEAELLVKKEEERSKKLAATRVSGGHLERDNVVREEDKLWTVKYAPTNLQQVCGNKGSVMKLKNWLANWENSKKNSFKHAGKDGSGVFRAAMLYGPPGIGKTTAAHLVAQELGYDILEQNASDVRSKTLLNAGVKNALDNMSVVGYFKHNEEAQNLNGKHFVIIMDEVDGMSGGDRGGVGQLAQFCRKTSTPLILICNERNLPKMRPFDRVCLDIQFRRPDANSIKSRLMTIAIREKFKLDPNVIDRLIQTTRGDIRQVINLLSTISTTTKTINHENINEISKAWEKNIALKPFDIAHKMLDGQIYSDIGSRNFTLNDKIALYFDDFDFTPLMIQENYLSTRPSVLKPGQSHLEAVAEAANCISLGDIVEKKIRSSEQLWSLLPLHAVLSSVYPASKVAGHMAGRINFTAWLGQNSKSAKYYRLLQEIHYHTRLGTSTDKIGLRLDYLPTFRKRLLDPFLKQGADAISSVIEVMDDYYLTKEDWDSIMEFFVGPDVTTAIIKKIPATVKSGFTRKYNSMTHPVAIYRTGSTIGGGGVGTSTSTPDFEDVVDADDNPVPADDEETQDSSTDLKKDKLIKQKAKPTKRKTATSKPGGSKKRKTKA');
INSERT INTO proteininfo VALUES ('6324790', 'NP_014859.1','Golgi matrix protein that is involved in the structural organization of the cis-Golgi; Rud3p [Saccharomyces cerevisiae]','MGKNKKKTGKKAKSHPHVEDVDETVNKPEEIINSVNVTVPPKMSTDPEADGIVASPDDEGKDLSEGVDKQKVNDGLTVDTINPLEDKKAGDEMKELREEIERLKLELSHKKDQETPNEDFKNELANVIKERDEFKTQYDTLLSKISSMKSIFNKMKEAQKQLEEVQEQLTEYESQNLKLKKKLEATKTENSELQSTIVTLNTELENLEKEQESTEEVFLEYESRIEALEDEKHDIIEKHSKELNTYRKEKDQLNLQVQELMIILENNKQDISDLRTERDELRQALESHEKEKAVLKNSLNDLELKIEEVDNKREEEARERDQEVKSLRSQLDTEIETHNNDTEALESMKKQLEAMKEDASMKEKYEEESKQHILQIGKLRHEAIILNEHLTKALAMLKKSSDSESVDKELISNLLISFVSIPRADPRKFEVLELLSNFLNWDEDKKQQAGLISNNESKNSSAVSRTESFVSLWTNYLEKESEKD');
INSERT INTO proteininfo VALUES ('6324789', 'NP_014858.1','Hypothetical ORF; Yor215cp [Saccharomyces cerevisiae]','MFRQSIRPLVSNRLTFIRYNSSPAYTAAVSLLKGDLKKAMIAKDEMKKTAIRNMLSAIKNKEIALKGKSADEYSLYDMYSKLISQRKDSINEFLANKRDDLVAKEQGEMDIIKKYMDQLPVSSELDIDQNVKKLLDALKTKAGEKKVQIKEIMGEIDWKSLPTEWKTSPTAIKNSIVKQFKEIFK');
INSERT INTO proteininfo VALUES ('6324788', 'NP_014857.1','Hypothetical ORF; Yor214cp [Saccharomyces cerevisiae]','MLGLYLSSLFFAFFMAQVFATKYSITFTSDEYEEDETGQNEPGPLVFHLDKNSLPPALLNQMEFNPYLVLADLPEEPRAVDSQEHTDTVLASKSVIDFLLEDPLTIVEHKKFSQIESILHEIMEDSIQKKVGADEVFEEIPKPKIYAYEDILVTNMSIINNSEMPTSTATLTSTISYLSSTTSLALSTGVTSVEIFPTITPGNITTIGGYENSSSSLMPSMGILSFLFGLYLLLHP');
INSERT INTO proteininfo VALUES ('6324787', 'NP_014856.1','Protein involved in silencing at telomeres, HML, and HMR; Sas5p [Saccharomyces cerevisiae]','MDHSIEVTFRVKTQQVIIPEQNIRGNELPLRRWQMELLMLDATGKEVEPTILSKCIYHLHSSFKQPKRRLNSLPFFIKETGWGEFNLKIECFFIGNAGKFSIEHDLTFEDDAYAVDYTVDVPHEFSHLNSELSKYFDLPWKVVSPEEEMSLRIADLPWIKSLALIDEDMMTDVVQMILNDPAVQRAIENHPRREQFFMFITQLPDDLLMKIQAFLKLPNKNSTKQERTNFGSDAIHKDEPVKAHNKLK');
INSERT INTO proteininfo VALUES ('6324786', 'NP_014855.1','beta subunit of G protein coupled to mating factor receptor; Ste4p [Saccharomyces cerevisiae]','MAAHQMDSITYSNNVTQQYIQPQSLQDISAVEDEIQNKIEAARQESKQLHAQINKAKHKIQDASLFQMANKVTSLTKNKINLKPNIVLKGHNNKISDFRWSRDSKRILSASQDGFMLIWDSASGLKQNAIPLDSQWVLSCAISPSSTLVASAGLNNNCTIYRVSKENRVAQNVASIFKGHTCYISDIEFTDNAHILTASGDMTCALWDIPKAKRVREYSDHLGDVLALAIPEEPNSENSSNTFASCGSDGYTYIWDSRSPSAVQSFYVNDSDINALRFFKDGMSIVAGSDNGAINMYDLRSDCSIATFSLFRGYEERTPTPTYMAANMEYNTAQSPQTLKSTSSSYLDNQGVVSLDFSASGRLMYSCYTDIGCVVWDVLKGEIVGKLEGHGGRVTGVRSSPDGLAVCTGSWDSTMKIWSPGYQ');
INSERT INTO proteininfo VALUES ('6324785', 'NP_014854.1','involved in the propagation of functional mitochondria yeast; encodes protein with GTP-binding domain related to dynamin; Mgm1p [Saccharomyces cerevisiae]','MSNSTSLRAIPRVANYNTLVRMNASPVRLLILRRQLATHPAILYSSPYIKSPLVHLHSRMSNVHRSAHANALSFVITRRSISHFPKIISKIIRLPIYVGGGMAAAGSYIAYKMEEASSFTKDKLDRIKDLGESMKEKFNKMFSGDKSQDGGHGNDGTVPTATLIAATSLDDDESKRQGDPKDDDDEDDDDEDDENDSVDTTQDEMLNLTKQMIEIRTILNKVDSSSAHLTLPSIVVIGSQSSGKSSVLESIVGREFLPKGSNMVTRRPIELTLVNTPNSNNVTADFPSMRLYNIKDFKEVKRMLMELNMAVPTSEAVSEEPIQLTIKSSRVPDLSLVDLPGYIQVEAADQPIELKTKIRDLCEKYLTAPNIILAISAADVDLANSSALKASKAADPKGLRTIGVITKLDLVDPEKARSILNNKKYPLSMGYVGVITKTPSSINRKHLGLFGEAPSSSLSGIFSKGQHGQSSGEENTNGLKQIVSHQFEKAYFKENKKYFTNCQVSTKKLREKLIKILEISMSNALEPTSTLIQQELDDTSYLFKVEFNDRHLTPKSYLLNNIDVLKLGIKEFQEKFHRNELKSILRAELDQKVLDVLATRYWKDDNLQDLSSSKLESDTDMLYWHKKLELASSGLTKMGIGRLSTMLTTNAILKELDNILESTQLKNHELIKDLVSNTAINVLNSKYYSTADQVENCIKPFKYEIDLEERDWSLARQHSINLIKEELRQCNSRYQAIKNAVGSKKLANVMGYLENESNLQKETLGMSKLLLERGSEAIFLDKRCKVLSFRLKMLKNKCHSTIEKDRCPEVFLSAVSDKLTSTAVLFLNVELLSDFFYNFPIELDRRLTLLGDEQVEMFAKEDPKISRHIELQKRKELLELALEKIDSILVFKKSYKGVSKNL');
INSERT INTO proteininfo VALUES ('6324784', 'NP_014853.1','RNA polymerase subunit, found in RNA polymerase complexes I, II, and III; Rpb10p [Saccharomyces cerevisiae]','MIVPVRCFSCGKVVGDKWESYLNLLQEDELDEGTALSRLGLKRYCCRRMILTHVDLIEKFLRYNPLEKRD');
INSERT INTO proteininfo VALUES ('6324783', 'NP_014852.1','Nicotinate phosphoribosyltransferase, acts in the salvage pathway of NAD+ biosynthesis; required for silencing at rDNA and telomeres and has a role in silencing at mating-type loci; localized to the nucleus; Npt1p [Saccharomyces cerevisiae]','MSEPVIKSLLDTDMYKITMHAAVFTNFPDVTVTYKYTNRSSQLTFNKEAINWLKEQFSYLGNLRFTEEEIEYLKQEIPYLPSAYIKYISSSNYKLHPEEQISFTSEEIEGKPTHYKLKILVSGSWKDTILYEIPLLSLISEAYFKFVDIDWDYENQLEQAEKKAETLFDNGIRFSEFGTRRRRSLKAQDLIMQGIMKAVNGNPDRNKSLLLGTSNILFAKKYGVKPIGTVAHEWVMGVASISEDYLHANKNAMDCWINTFGAKNAGLALTDTFGTDDFLKSFRPPYSDAYVGVRQDSGDPVEYTKKISHHYHDVLKLPKFSKIICYSDSLNVEKAITYSHAAKENGMLATFGIGTNFTNDFRKKSEPQVKSEPLNIVIKLLEVNGNHAIKISDNLGKNMGDPATVKRVKEELGYTERSWSGDNEAHRWT');
INSERT INTO proteininfo VALUES ('6324782', 'NP_014851.1','protein tyrosine phosphatase; Ptp2p [Saccharomyces cerevisiae]','MDRIAQQYRNGKRDNNGNRMASSAISEKGHIQVNQTRTPGQMPVYRGETINLSNLPQNQIKPCKDLDDVNIRRNNSNRHSKILLLDLCAGPNTNSFLGNTNAKDITVLSLPLPSTLVKRSNYPFENLLKNYLGSDEKYIEFTKIIKDYDIFIFSDSFSRISSCLKTTFCLIEKFKKFICHFFPSPYLKFFLLEGSLNDSKAPSLGKNKKNCILPKLDLNLNVNLTSRSTLNLRINIPPPNDSNKIFLQSLKKDLIHYSPNSLQKFFQFNMPADLAPNDTILPNWLKFCSVKENEKVILKKLFNNFETLENFEMQRLEKCLKFKKKPLHQKQLSQKQRGPQSTDDSKLYSLTSLQRQYKSSLKSNIQKNQKLKLIIPKNNTSSSPSPLSSDDTIMSPINDYELTEGIQSFTKNRYSNILPYEHSRVKLPHSPKPPAVSEASTTETKTDKSYPMCPVDAKNHSCKPNDYINANYLKLTQINPDFKYIATQAPLPSTMDDFWKVITLNKVKVIISLNSDDELNLRKWDIYWNNLSYSNHTIKLQNTWENICNINGCVLRVFQVKKTAPQNDNISQDCDLPHNGDLTSITMAVSEPFIVYQLQYKNWLDSCGVDMNDIIKLHKVKNSLLFNPQSFITSLEKDVCKPDLIDDNNSELHLDTANSSPLLVHCSAGCGRTGVFVTLDFLLSILSPTTNHSNKIDVWNMTQDLIFIIVNELRKQRISMVQNLTQYIACYEALLNYFALQKQIKNALPC');
INSERT INTO proteininfo VALUES ('6324781', 'NP_014850.1','second-largest subunit of RNA polymerase III; Ret1p [Saccharomyces cerevisiae]','MVAATKRRKTHIHKHVKDEAFDDLLKPVYKGKKLTDEINTAQDKWHLLPAFLKVKGLVKQHLDSFNYFVDTDLKKIIKANQLILSDVDPEFYLKYVDIRVGKKSSSSTKDYLTPPHECRLRDMTYSAPIYVDIEYTRGRNIIMHKDVEIGRMPIMLRSNKCILYDADESKMAKLNECPLDPGGYFIVNGTEKVILVQEQLSKNRIIVEADEKKGIVQASVTSSTHERKSKTYVITKNGKIYLKHNSIAEEIPIAIVLKACGILSDLEIMQLVCGNDSSYQDIFAVNLEESSKLDIYTQQQALEYIGAKVKTMRRQKLTILQEGIEAIATTVIAHLTVEALDFREKALYIAMMTRRVVMAMYNPKMIDDRDYVGNKRLELAGQLISLLFEDLFKKFNNDFKLSIDKVLKKPNRAMEYDALLSINVHSNNITSGLNRAISTGNWSLKRFKMERAGVTHVLSRLSYISALGMMTRISSQFEKSRKVSGPRALQPSQFGMLCTADTPEGEACGLVKNLALMTHITTDDEEEPIKKLCYVLGVEDITLIDSASLHLNYGVYLNGTLIGSIRFPTKFVTQFRHLRRTGKVSEFISIYSNSHQMAVHIATDGGRICRPLIIVSDGQSRVKDIHLRKLLDGELDFDDFLKLGLVEYLDVNEENDSYIALYEKDIVPSMTHLEIEPFTILGAVAGLIPYPHHNQSPRNTYQCAMGKQAIGAIAYNQFKRIDTLLYLMTYPQQPMVKTKTIELIDYDKLPAGQNATVAVMSYSGYDIEDALVLNKSSIDRGFGRCETRRKTTTVLKRYANHTQDIIGGMRVDENGDPIWQHQSLGPDGLGEVGMKVQSGQIYINKSVPTNSADAPNPNNVNVQTQYREAPVIYRGPEPSHIDQVMMSVSDNDQALIKVLLRQNRRPELGDKFSSRHGQKGVCGIIVKQEDMPFNDQGIVPDIIMNPHGFPSRMTVGKMIELISGKAGVLNGTLEYGTCFGGSKLEDMSKILVDQGFNYSGKDMLYSGITGECLQAYIFFGPIYYQKLKHMVLDKMHARARGPRAVLTRQPTEGRSRDGGLRLGEMERDCVIAYGASQLLLERLMISSDAFEVDVCDKCGLMGYSGWCTTCKSAENIIKMTIPYAAKLLFQELLSMNIAPRLRLEDIFQQ');
INSERT INTO proteininfo VALUES ('6324780', 'NP_014849.1','Protein that forms a nucleolar complex with Mak21p that binds to 90S and 66S pre-ribosomes, as well as a nuclear complex with Noc3p that binds to 66S pre-ribosomes; both complexes mediate intranuclear transport of ribosomal precursors; Noc2p [Saccharomyces cerevisiae]','MGKVSKSTKKFQSKHLKHTLDQRRKEKIQKKRIQGRRGNKTDQEKADAAGTREQQQLKKSAKEEVFKDMSVETFFEKGIEIPKENKKLKKKTTKEQSDEDSSSSEEEEDMGQSMAKLAEKDPEFYKYLEENDKDLLDFAGTNPLDGIDSQDEGEDAERNSNIEEKSEQMELEKEKIELSLKLVRKWKKQLHDSPSLKLLRNIISAFKVAVNLNKEENIEDYKYAITDEKAFHELMFMVLKDVPQAIQKMAPYKIVKGARTLPNGGNVSRVSSIVKSHAGSLLILLNDITNTETAALVLHSVNELMPYLLSYRRILKELIKSIVGVWSTTRELETQIASFAFLINTTKEFKKSMLETTLKTTYSTFIKSCRKTNMRSMPLINFQKNSAAELFGIDEVLGYQVGFEYIRQLAIHLRNTMNATTKKSSKINSAEAYKIVYNWQFCHSLDFWSRVLSFACQPEKENGSESPLRQLIYPLVQVTLGVIRLIPTPQFFPLRFYLIKSLIRLSQNSGVFIPIYPLLSEILTSTAFTKAPKKSPNLAAFDFEHNIKCTQAYLNTKIYQEGLSEQFVDLLGDYFALYCKNIAFPELVTPVIISLRRYIKTSTNVKLNKRLSTVVEKLNQNSTFIQEKRSDVEFGPTNKSEVSRFLNDVAWNKTPLGSYVAVQREVKEEKARLMRESMEEQDKERETEEAKLLNSLESDDDNEDVEMSDA');
INSERT INTO proteininfo VALUES ('6324779', 'NP_014848.1','The authentic, non-tagged protein was localized to the mitochondria; Fmp38p [Saccharomyces cerevisiae]','MLNLCHALRGVRQFSCSVIVKVKCASCSIKLQDQDPSKPGYYTKPKSLPDSKLNPDLQDLKYLLFSQDIQLSKQATQNDPDLKTKRDLLLRVICKRCSNALHHNNYNPEEFPESTLNDILNYVPRGSNVMHIVPFVEFPLHLDPNVLKRNDLDTTLVLTKSDQVFKDKNAVSKKVPIFMKQFLKNTLRIDSNKTFAISALKNWNISMFYNYFKNYTYLLGNPNVGKSTLINTLLQKYLGYKVKIDSTGKINSPSEEVMQEAFTNPKNFFKIQAAGVSHIPNLTRSVQAYQVGGKILFDLPGYSTSTSRLRLEELIDERWLQRLRKTDLFNRKHIKQKTYESMKGTSQGGCYTVGGIFYLVPPKGSINQIVKYIPGPSKTFKNIEKGIDVFNSCNSSSGTHPLSRYCGIKSVICEKSQYKRYAIPPFIGSIEIVLKDIGYILLRTTGRYEFKGLHEIWIPRGIQVGIREPLENLIESGYQRYIETNGKESSCPRDRPIISSLYEMAPDEADTLNAVKKSYLEKTEKDLSARRFVDDDPYDLVQHLEKKKNPYWYYQW');
INSERT INTO proteininfo VALUES ('6324778', 'NP_014847.1','ATP-dependent DEAD (Asp-Glu-Ala-Asp)-box RNA helicase, required for translation initiation of all yeast mRNAs; Ded1p [Saccharomyces cerevisiae]','MAELSEQVQNLSINDNNENGYVPPHLRGKPRSARNNSSNYNNNNGGYNGGRGGGSFFSNNRRGGYGNGGFFGGNNGGSRSNGRSGGRWIDGKHVPAPRNEKAEIAIFGVPEDPNFQSSGINFDNYDDIPVDASGKDVPEPITEFTSPPLDGLLLENIKLARFTKPTPVQKYSVPIVANGRDLMACAQTGSGKTGGFLFPVLSESFKTGPSPQPESQGSFYQRKAYPTAVIMAPTRELATQIFDEAKKFTYRSWVKACVVYGGSPIGNQLREIERGCDLLVATPGRLNDLLERGKISLANVKYLVLDEADRMLDMGFEPQIRHIVEDCDMTPVGERQTLMFSATFPADIQHLARDFLSDYIFLSVGRVGSTSENITQKVLYVENQDKKSALLDLLSASTDGLTLIFVETKRMADQLTDFLIMQNFRATAIHGDRTQSERERALAAFRSGAATLLVATAVAARGLDIPNVTHVINYDLPSDVDDYVHRIGRTGRAGNTGLATAFFNSENSNIVKGLHEILTEANQEVPSFLKDAMMSAPGSRSNSRRGGFGRNNNRDYRKAGGASAGGWGSSRSRDNSFRGGSGWGSDSKSSGWGNSGGSNNSSWW');
INSERT INTO proteininfo VALUES ('6324776', 'NP_014845.1','Imidazoleglycerol-phosphate dehydratase, catalyzes the sixth step in histidine biosynthesis; mutations cause histidine auxotrophy and sensitivity to Cu, Co, and Ni salts; transcription is regulated by general amino acid control via Gcn4p; His3p [Saccharomyces cerevisiae]','MTEQKALVKRITNETKIQIAISLKGGPLAIEHSIFPEKEAEAVAEQATQSQVINVHTGIGFLDHMIHALAKHSGWSLIVECIGDLHIDDHHTTEDCGIALGQAFKEALGAVRGVKRFGSGFAPLDEALSRAVVDLSNRPYAVVELGLQREKVGDLSCEMIPHFLESFAEASRITLHVDCLRGKNDHHRSESAFKALAVAIREATSPNGTNDVPSTKGVLM');
INSERT INTO proteininfo VALUES ('6324775', 'NP_014844.1','Ribose methyltransferase that modifies a functionally critical, conserved nucleotide in mitochondrial 21S rRNA; Pet56p [Saccharomyces cerevisiae]','MTSLTNAVFKRYLAVTPSAHQALKTRIKKKSSSFDKFFPQQSNSRKKQWETLNEDKASWFKRKYAHVHAREQDRAADPYGKKKAHVEKLKEIKNQAKLNQKSHKSKFQNKDIALKLMNDNPIFEYVYGTNSVYAALLNPSRNCHSRLLYHGTIPSKFLQIVDELKVTTELVDKHRLNLLTNYGVHNNIALETKPLQPVEIAYLGDMDTSSAALSIHELGFNNENIPHELPYGTKTDAKKFPLGLYLDEITDPHNIGAIIRSAYFLGVDFIVMSRRNCSPLTPVVSKTSSGALELLPIFYVDKPLEFFTKSQEMGGWTFITSHLANATSEKYTVGKTISMHDLNGLCNELPVVLVVGNESQGVRTNLKMRSDFFVEIPFGGIEKGNRAPEPIVDSLNVSVATALLIDNILTCK');
INSERT INTO proteininfo VALUES ('6324772', 'NP_014841.1','Component of mRNP complexes associated with polyribosomes; implicated in secretion and nuclear segregation; multicopy suppressor of BFA (Brefeldin A) sensitivity; Bfr1p [Saccharomyces cerevisiae]','MSSQQHKFKRPDVSVRDKKLDTLNVQLKKIDTEIGLIRKQIDQHQVNDTTQQERKKLQDKNKEIIKIQADLKTRRSNIHDSIKQLDAQIKRKNNQIEEKLGKKAKFSSTAEAKQRINEIEESIASGDLSLVQEKLLVKEMQSLNKLIKDLVNIEPIRKSVDADKAKINQLKEELNGLNPKDVSNQFEENQQKLNDIHSKTQGVYDKRQTLFNKRAALYKKRDELYSQIRQIRADFDNEFKSFRAKLDKERLKREEEQRLSKLLEQKDVDMGKLQEKLTHAKIPAFTYEIGAIENSLLVLDPTYVKPKKNILPDLSSNALETKPARKVVADDLVLVTPKKDDFVNVAPSKSKKYKKKNQQKNTENEQPASIFNKVDGKFTLEPTLIATLAELDVTVPINSDDVKITVEQLKKKHEELLSKQEEQTKQNIESVEKEIEKLNLDYSNKEQQVKKELEEKRLKEQEESEKDKEN');
INSERT INTO proteininfo VALUES ('6324771', 'NP_014840.1','metacaspase; Mca1p [Saccharomyces cerevisiae]','MKMSLEVYLNYHQRRPTRFTIMYPGSGRYTYNNAGGNNGYQRPMAPPPNQQYGQQYGQQYEQQYGQQYGQQNDQQFSQQYAPPPGPPPMAYNRPVYPPPQFQQEQAKAQLSNGYNNPNVNASNMYGPPQNMSLPPPQTQTIQGTDQPYQYSQCTGRRKALIIGINYIGSKNQLRGCINDAHNIFNFLTNGYGYSSDDIVILTDDQNDLVRVPTRANMIRAMQWLVKDAQPNDSLFLHYSGHGGQTEDLDGDEEDGMDDVIYPVDFETQGPIIDDEMHDIMVKPLQQGVRLTALFDSCHSGTVLDLPYTYSTKGIIKEPNIWKDVGQDGLQAAISYATGNRAALIGSLGSIFKTVKGGMGNNVDRERVRQIKFSAADVVMLSGSKDNQTSADAVEDGQNTGAMSHAFIKVMTLQPQQSYLSLLQNMRKELAGKYSQKPQLSSSHPIDVNLQFIM');
INSERT INTO proteininfo VALUES ('6324770', 'NP_014839.1','Protein involved in biosynthesis of the coenzyme lipoic acid, has similarity to E. coli lipoic acid synthase; Lip5p [Saccharomyces cerevisiae]','MYRRSVGVLFVGRNTRWISSTIRCGTSATRPIRSNALNTDSDNASVRVPVGNSTEVENATSQLTGTSGKRRKGNRKRITEFKDALNLGPSFADFVSGKASKMILDPLEKARQNTEEAKKLPRWLKVPIPKGTNYHKLKGDVKELGLSTVCEEARCPNIGECWGGKDKSKATATIMLLGDTCTRGCRFCSVKTNRTPSKPDPMEPENTAEAIKRWGLGYVVLTTVDRDDLVDGGANHLAETVRKIKQKAPNTLVETLSGDFRGDLKMVDIMAQCGLDVYAHNLETVESLTPHVRDRRATYRQSLSVLERAKATVPSLITKTSIMLGLGETDEQITQTLKDLRNIQCDVVTFGQYMRPTKRHMKVVEYVKPEKFDYWKERALEMGFLYCASGPLVRSSYKAGEAFIENVLKKRNMK');
INSERT INTO proteininfo VALUES ('6324769', 'NP_014838.1','Kinetochore-associated protein required for normal segregation of chromosomes in meiosis and mitosis; component of the FEAR regulatory network, which promotes Cdc14p release from the nucleolus during anaphase; potential Cdc28p substrate; Slk19p [Saccharomyces cerevisiae]','MNEVPTTPVRLILGQAQQREQNSENCSQERNPRTFNSEPDSSFNSPGSSQFVIHPHEPLEKEKDEKQDLDRSIDYGRSSALNNKNNANPLENIDINKMFDDKKSDSGTNDDKGGASTSDKHVLALNYSPIRVEMNSSEKRSDKNVDVDENDKEGSHINKKLKLQLESVPDLKQSSTKDIINDKEEIMSSPMAIDMIETNISPNKFIINDGVERNDSFNINTDTLKLENDINEKQQEEDFIKSNSNNVVNIDNAYKEKEDEENDITNSHINRLTPLYETSARESNSNEEGRNDYDDDNQLDIRHDNFQIVAKRNEELTDQIYHLNQMLNSLISKNESLSFQYEKLNKNHQLLIDLTNEKLDKLNTERESDIAKVEKFKKRIKELNTEIKVLNSNQKILQEKFDASITEVNHIKGEHENTVNTLQQNEKILNDKNVELENMKAELKGNNDKLSEYETTLNDLNSRIVQLNDKIESTDIVLKSKENELDNLKLSLKETLSISKDFNDSDLIGQINELISTKNNLQQKMDDLNNLNDDNLKVVQDKLIKNEETLKLKEAEIDSLNSEMDELKKQITSKDDEFKMWQSKYETVEDEAKIRNAEVTELNGDIEDLKESKLHLEETITELENKVHKLENECELEKQKFEKTSLELESLQLKNSNIQAEHIKELENLHENLISLQNELKISSDRITTLTKENEVLMEQNNNNNNSVTLSNDQKDRDDEKIKSLGKQVQDWKEKYEAKEKDTNKRLKLLAEDLYIQYSSKHEQKVKLLKKGYENKYQNKFDQLNLENKTLSEEIEQLNKQLSSEREEKQELLKLLENEKK');
INSERT INTO proteininfo VALUES ('6324768', 'NP_014837.1','Transcription factor IIA, large chain; Toa1p [Saccharomyces cerevisiae]','MSNAEASRVYEIIVESVVNEVREDFENAGIDEQTLQDLKNIWQKKLTETKVTTFSWDNQFNEGNINGVQNDLNFNLATPGVNSSEFNIKEENTGNEGLILPNINSNNNIPHSGETNINTNTVEATNNSGATLNTNTSGNTNADVTSQPKIEVKPEIELTINNANITTVENIDDESEKKDDEEKEEDVEKTRKEKEQIEQVKLQAKKEKRSALLDTDEVGSELDDSDDDYLISEGEEDGPDENLMLCLYDKVTRTKARWKCSLKDGVVTINRNDYTFQKAQVEAEWV');
INSERT INTO proteininfo VALUES ('6324767', 'NP_014836.1','Involved in peroxisome proliferation; Pex27p [Saccharomyces cerevisiae]','MTSDPVNTNISSPTLTDRNADESWELLKREFNTLFSNLKTDSKEEGNFTDNKGVIAKKPIVLQDNDDSDFTQNQGKVATATSTTSDRSFKRTLGSIEMKKRYVKKNCQAKFVFNTLEGKEVCSKILQHTLGLLSLLLLTRKIRLLNFSSKLRLVIQQLSLFRYYLRFGNFAINLYKIIKRFRWLREMKKLHYKDQSILFYFKNFRFFDIIEAFYNLTDELILFHKLQSMFGKKNTSHANTNRLMTFVKEQHYILWEVLNILAINKNIEQWRQLIRDEIYLSIYNTSGNAIKEYELKYKLPTNDKVNLELRKNNITLDFYKIILNLLSNLINIKGKRDKYNSELAYEIISVGSGVTELLKLWNRAKVTSANEHTSAV');
INSERT INTO proteininfo VALUES ('6324766', 'NP_014835.1','Hypothetical ORF; Yor192cp [Saccharomyces cerevisiae]','MSFGTRISRALRFLEIPVKNRASVNFLRNPDLQPIKSVNQTWGFWSNFAYWGVLSFNVGMWIGGSSALTVGLSYSETIGAFIIADLLTILFALANSCPGYDWKVGFTLAQRFVFGIYGSALGIIIRILMSIVYYGSNAWLGGLCVNMILDSWSHHYLHLPNTLSSKVAMTTKELIGFIIFHILTAFCYFMKPYHMNYILIWSCVGTFFAMLGMVIYLTKSAHGVGDLFTSTHSTVTGSKKAWAWVYTISYWYGSVSPGCTNQSDFSRFGSSNCAIWTGTIVALLIPATLIPVFGIIGASACEKLYGQTFWMPMDIFDNWLTTNYSAGARAATFFCGFCFVMSQISYTISNCGFASGMDLAGLLPKYVDIKRGAIFAACVSWACLPWNFYNSSSTFLTVMSSFGVVMTPIITVMICDNFLIRKRQYSVTNAFVLKGEYYFTKGVNWRAIVAWVCGMAPGLPGIAWEVNNDYFHNTGIINFFYGDSFFSFLISFFVYWGLCLLFPFKITVKHDDKDYYGAFTDEEARKKGMVPYSEISEEEIRAYTLGECFTSGHEYKPESSDDELPELTKTSSENTKVFEIVHQKDNEKESSTSSEKQIA');
INSERT INTO proteininfo VALUES ('6324765', 'NP_014834.1','contains motifs that are present in a family of DNA-dependent ATPases, the SWI2/SNF2-like proteins; Ris1p [Saccharomyces cerevisiae]','MAAVPTIDLTLADSDNEDIFHSFSSSTSVDKIDIRKENGKLRMAGLEVAQSNDDAARQAFHVFKTNISNNETFDTILSKSKTITDSTFNNEKSSNEVKQQQVLKEETMGSSNDEKKTQESSPSAEMIKLFYENDDVPLSDSFKQKEEGKRINQDEQVKENICGISSSYVSKDYDGVEDDFEPNTCQDSNLDFQEEKLNLNNKPSQQQFSDPETKDNSLKSENKDQIKGVTTTSYRDLPIESSAFQDSETQNNSKNTIPNIVNEKRTPALPSNLSSVESSLKNETAKVEGKTTVRLPGLQNNVALLEQEQSELFKHFSEQPVDISDFGRKIKRKHSGDFADNKILKRPILPSKNMDHTTHNSHDSEQKNSSIIILSDEDESGAGINDIESPLKVSEPNTADALRSSVPEVISLLDLPNIDLNNSVIKEASGSNSIPTSETDAQSSSSSVLQGTIMTEQATQSSQHECNSSLDTLKKNHQKLLKDLNSRESELRNALSCCKTNSEILRRKLSRREKEVSDAEKHWQLLLTSMARGGRTISSTQQILVDEAENQLNKLKEKRQLTKSKLDSINLKMYNYNEQWKSFVHSKNINLQKSLAALERSARDSKASATVNKRNECLAEKEKLDQMLKEGTLSFSTYKQLTGEIQQKLNDLKLGDQRTTDINSVLPIVRQPLAKRDLFIKSIDTAKDLLAKNTSRTEMTKRILYRHLDNLVSYKNFFEDGRSLIDINRRHVAHESAQILFTNGVKMPIVFETLQDYGIKFSNPAIVNPDRRAQYFKSIEVARDLISKSTRSEDAKRKITRFLNIIEEFRKDIDTGFPPTPLKREGVGKAVVGLRQQGLKMDRLYENLRRYKIPITSEELLQQSYLFPVNADQRPPSNWNIVENTEDTSSTANDLSMQDEFHISNMHAAEDQEQIRALLENVKQSESIIDGEALTPEDMTVNLLKHQRLGLHWLLQVENSAKKGGLLADDMGLGKTIQAIALMLANRSEESKCKTNLIVAPVSVLRVWKGELETKVKKRAKFTTFIFGGSGNGKVKHWRDLARYDAVLVSYQTLANEFKKHWPKKLDGEQNQLPAVPHIQALNRLKTSNEYYSPFFCNDSTFYRILLDEGQNIKNKNTRASKACCTINGMYRWVLSGTPIQNSMDELYSLIRFLRIPPYHKEQRFKLDIGRFFQRNKQYQYDNEDRKNALRKVRVLLNAIMLRRSKADKIDGKPLLELPPKIVEVDESRLKGEELKFYTALESKNQALAKKLLNNSTRGSYSSVLTLLLRLRQACCHSELVVMGEKKAEGTKVANGKSFEDDWLRLYYKITHMSGEAQAQVITSMNSMTCFWCMEQLEPEAMSVLTGCGHLICDTCIEPFIEESSMLPQAKKTKGGAFAIPCKDCQRLTNEKDIVSHKLYDQVINQGFTEEDLHAEYLSEMEKQKIQQKNVYVPNFESLEPSTKIEQCIQVIQRVFDESATEKIIIFSQFTTFFEILEHFLKNKLNFPYLKYIGSMNAQRRSDVINEFYRDPEKRILLISMKAGNSGLTLTCANHVVIVDPFWNPYVEEQAQDRCYRISQTKKVQVHKLFIKDSVEDRISELQKRKKEMVDSAMDPGKIKEVNSLGRRELGFLFGLNAL');
INSERT INTO proteininfo VALUES ('6324764', 'NP_014833.1','Sporulation regulated genes; sporulation-specific exo-1,3-beta-glucanase; Spr1p [Saccharomyces cerevisiae]','MVSFRGLTTLTLLFTKLVNCNPVSTKNRDSIQFIYKEKDSIYSAINNQAINEKIHGVNLGGWLVLEPYITPSLFETFRTNPYNDDGIPVDEYHFCEKLGYEKAKERLYSHWSTFYKEEDFAKIASQGFNLVRIPIGYWAFTTLSHDPYVTAEQEYFLDRAIDWARKYGLKVWIDLHGAAGSQNGFDNSGLRDSYKFLEDENLSATMKALTYILSKYSTDVYLDTVIGIELLNEPLGPVIDMERLKNLLLKPAYDYLRNKINSNQIIVIHDAFQPYHYWDGFLNDEKNEYGVIIDHHHYQVFSQVELTRKMNERIKIACQWGKDAVSEKHWSVAGEFSAALTDCTKWLNGVGLGARYDGSWTKDNEKSHYINTCANNENIALWPEERKQNTRKFIEAQLDAFEMTGGWIMWCYKTENSIEWDVEKLIQLNIFPQPINDRKYPNQCH');
INSERT INTO proteininfo VALUES ('6324763', 'NP_014832.1','Protein that associates with the INO80 chromatin remodeling complex under low-salt conditions; Ies4p [Saccharomyces cerevisiae]','MSQESSVLSESQEQLANNPKIEDTSPPSANSRDNSKPVLPWDYKNKAIEIKSFSGYKVNFTGWIRRDVREERQRGSEFTASDVKGSDDKATRKKEPADEDPEVKQLEKEGEDGLDS');
INSERT INTO proteininfo VALUES ('6324762', 'NP_014831.1','Protein involved in positive requlation of both 1,3-beta-glucan synthesis and the Pkc1p-MAPK pathway, potential Cdc28p substrate; multicopy suppressor of temperature-sensitive mutations in CDC24 and CDC42, and of mutations in BEM4; Msb1p [Saccharomyces cerevisiae]','MNDMAKPLPTPPTAEIRKSRSNSPKKAQKTNLSPNKNQNNEKNVPRSNGRTKNEHNSMDDEEFEFFHQFSREKVKGVIHVITAELKEKGPDVEFLMIPFRPEQTNDKLLTLLNQLFPLGNGQPVNEKKQLRIVSKADVWTLFQCLKYIWCRLPNSEIIGWKSYLEFKFREEDKKFPRKSFLEIMPQCLASPNHASIVYDFFDLIISISSNSRVNKMSARKISKMCAIWAFSKQIPNSDIQDYDFESAAMKSFAPNNSIQDGLDQWIPASDAMFHLLLAFLRSFVPQDLESAKLPRTLKSLLFNNQYPPRKSTAYTSETILTIPLVTLKTDVFSRKPWQLLERCNDLLDFSDHDAFEAREDYALLKSLFRKKNTVEGISRKMSQESRRLMKAMSTKHSTFQPGWAPRECIENISHLKECIEVKRLDIDDYFIWTWLSSLSFEQTSEKKKIFGRSIILEFEFDGFKKWVVFQECDITLDYNKKGQLKKKTSAQSPTTEKELPPDDFELEDPPLSKSPTLSQTYKKFQAEVPQQSTVRRDSAPDNQGIYHTVISKNALTKNKHNVNLHSFEHKISKWNPLNNLRKKSGSNSSSSSFEEKSKDAPIREEYHTNKNHKSKKEERVLSQFSTLNPDEYQLPVIETGSSNFKIEIPELMYEHDDDDSDKLKNSQKRATDSAIEELNGMVEEMMINEPDDVKISITEAETFESLTKFDQYKPSNITDDDLQSSHSSAVHSLKLSTNTNDSCADSSKYTADRKLAEPRKISEESKVNDDSSSYYSPNINNLPASRMPSQPTYSNSDSKKAFTNESRLNVLQGAVSPSQQVTPKPYKNAPGDCVSPVQQKYYQNDRRNEMSPASAPVPPSAYSPARSPQFSTNSAGFKQNTINVPVGYNDPAHVLANQPHMTYRDQHNYPSHQQKQRPFQNNIVPPELKSRNQRADASPIPQHMVPVKQGVPNLPSNVPLYQQMERMNPNHQHPVNTYKVTQPPYHNNTTNAYGNSRAGNAHMLDGKWSNNPPQMVPKGVRPNQYPQQHVNRYSPQAQPVVPAEYYNGPPPMRAPPMMSHMVPAQEPIRYTAGANRRSFPQGMQQNAYSVPAQPMGAVNSEFYLPEAPQGNKLHGNINKRQERKKLYDNIRSGNFGI');
INSERT INTO proteininfo VALUES ('6324761', 'NP_014830.1','Translation elongation factor Tu, mitochondrial; Tuf1p [Saccharomyces cerevisiae]','MSALLPRLLTRTAFKASGKLLRLSSVISRTFSQTTTSYAAAFDRSKPHVNIGTIGHVDHGKTTLTAAITKTLAAKGGANFLDYAAIDKAPEERARGITISTAHVEYETAKRHYSHVDCPGHADYIKNMITGAAQMDGAIIVVAATDGQMPQTREHLLLARQVGVQHIVVFVNKVDTIDDPEMLELVEMEMRELLNEYGFDGDNAPIIMGSALCALEGRQPEIGEQAIMKLLDAVDEYIPTPERDLNKPFLMPVEDIFSISGRGTVVTGRVERGNLKKGEELEIVGHNSTPLKTTVTGIEMFRKELDSAMAGDNAGVLLRGIRRDQLKRGMVLAKPGTVKAHTKILASLYILSKEEGGRHSGFGENYRPQMFIRTADVTVVMRFPKEVEDHSMQVMPGDNVEMECDLIHPTPLEVGQRFNIREGGRTVGTGLITRIIE');
INSERT INTO proteininfo VALUES ('6324760', 'NP_014829.1','Hypothetical ORF; Yor186wp [Saccharomyces cerevisiae]','MTLAFTTFAISKINNSSTNEDSKVMILCDEHHPFEKGYFKSAIRAFGNSIKLGLMGNSRPEDAASIFQDKNIPHDLTTEEFRLQLVCMAFSWFIFGLFIACLLLCITLVLTSRYPGENENKATEVVPSSNIDDEEKQLSLSDMI');
INSERT INTO proteininfo VALUES ('6324759', 'NP_014828.1','GTP binding protein (mammalian Ranp homolog) involved in the maintenance of nuclear organization, RNA processing and transport; interacts with Kap121p, Kap123p and Pdr6p (karyophilin betas); Gsp1p homolog that is not required for viability; Gsp2p [Saccharomyces cerevisiae]','MSAPAQNNAEVPTFKLVLVGDGGTGKTTFVKRHLTGEFEKKYIATIGVEVHPLSFYTNFGEIKFDVWDTAGQEKFGGLRDGYYINAQCAIIMFDVTSRITYKNVPNWHRDLVRVCENIPIVLCGNKVDVKERKVKAKTITFHRKKNLQYYDISAKSNYNFEKPFLWLARKLAGNPQLEFVASPALAPPEVQVDEQLMHQYQQEMDQATALPLPDEDDADL');
INSERT INTO proteininfo VALUES ('6324758', 'NP_014827.1','phosphoserine transaminase; Ser1p [Saccharomyces cerevisiae]','MSLEREEPQHFGAGPAQMPTPVLQQAAKDLINFNDIGLGIGEISHRSKDATKVIEDSKKHLIELLNIPDTHEVFYLQGGGTTGFSSVATNLAAAYVGKHGKIAPAGYLVTGSWSQKSFEEAKRLHVPAEVIFNAKDYNNGKFGKIPDESLWEDKIKGKAFSYVYLCENETVHGVEWPELPKCLVNDPNIEIVADLSSDILSRKIDVSQYGVIMAGAQKNIGLAGLTLYIIKKSILKNISGASDETLHELGVPITPIAFDYPTVVKNNSAYNTIPIFTLHVMDLVFQHILKKGGVEAQQAENEEKAKILYEALDANSDFYNVPVDPKCRSKMNVVFTLKKDGLDDQFLKEAAARHLTGLKGHRSVGGFRASIYNALSVKAVQNLVDFIKEFAEKNA');
INSERT INTO proteininfo VALUES ('6324757', 'NP_014826.1','Protein of unknown function, required for survival upon exposure to K1 killer toxin; Fyv12p [Saccharomyces cerevisiae]','MRLLHHGEYGTKLIGGKCSIDGKLGHPCPLSRRRKKHLREKEMGPQYVRMYGPKRKAIIRTGNPDDGINLPDTGRGTLTAATIWSRAYHSNYSYLVRPKVVTLSKHRELMTTFLLYVLYVCIYISAFIK');
INSERT INTO proteininfo VALUES ('6324756', 'NP_014825.1','Protein component of the small (40S) ribosomal subunit; nearly identical to Rps30Ap and has similarity to rat S30 ribosomal protein; Rps30bp [Saccharomyces cerevisiae]','MAKVHGSLARAGKVKSQTPKVEKTEKPKKPKGRAYKRLLYTRRFVNVTLVNGKRRMNPGPSVQ');
INSERT INTO proteininfo VALUES ('6324755', 'NP_014824.1','Actin assembly factor, activates the Arp2/3 protein complex that nucleates branched actin filaments; localizes with the Arp2/3 complex to actin patches; homolog of the human Wiskott-Aldrich syndrome protein (WASP); Las17p [Saccharomyces cerevisiae]','MGLLNSSDKEIIKRALPKASNKIIDVTVARLYIAYPDKNEWQYTGLSGALALVDDLVGNTFFLKLVDINGHRGVIWDQELYVNFEYYQDRTFFHTFEMEECFAGLLFVDINEASHFLKRVQKRERYANRKTLLNKNAVALTKKVREEQKSQVVHGPRGESLIDNQRKRYNYEDVDTIPTTKHKAPPPPPPTAETFDSDQTSSFSDINSTTASAPTTPAPALPPASPEVRKEETHPKHSLPPLPNQFAPLPDPPQHNSPPQNNAPSQPQSNPFPFPIPEIPSTQSATNPFPFPVPQQQFNQAPSMGIPQQNRPLPQLPNRNNRPVPPPPPMRTTTEGSGVRLPAPPPPPRRGPAPPPPPHRHVTSNTLNSAGGNSLLPQATGRRGPAPPPPPRASRPTPNVTMQQNPQQYNNSNRPFGYQTNSNMSSPPPPPVTTFNTLTPQMTAATGQPAVPLPQNTQAPSQATNVPVAPPPPPASLGQSQIPQSAPSAPIPPTLPSTTSAAPPPPPAFLTQQPQSGGAPAPPPPPQMPATSTSGGGSFAETTGDAGRDALLASIRGAGGIGALRKVDKSQLDKPSVLLQEARGESASPPAAAGNGGTPGGPPASLADALAAALNKRKTKVGAHDDMDNGDDW');
INSERT INTO proteininfo VALUES ('6324754', 'NP_014823.1','Peroxisomal delta(3,5)-delta(2,4)-dienoyl-CoA isomerase, involved in fatty acid metabolism, contains peroxisome targeting signals at amino and carboxy termini; Dci1p [Saccharomyces cerevisiae]','MSSRVCYHINGPFFIIKLIDPKHLNSLTFEDFVYIALLLHKANDIDSVLFTVLQSSGKYFSSGGKFSAVNKLNDGDVTSEVEKVSKLVSAISSPNIFVANAFAIHKKVLVCCLNGPAIGLSASLVALCDIVYSQNDSVFLLFPFSNLGFVAEVGTSVTLTQKLGINSANEHMIFSTPVLFKELIGTIITKNYQLTNTETFNEKVLQDIKQNLEGLYPKSVLGMKELLHSEMKQKLIKAQAMETNGTLPFWASGEPFKRFKQLQEGNRRHKL');
INSERT INTO proteininfo VALUES ('6324753', 'NP_014822.1','Subunit of the APT subcomplex of cleavage and polyadenylation factor, may have a role in 3' end formation of both polyadenylated and non-polyadenylated RNAs; Syc1p [Saccharomyces cerevisiae]','MDLPKDKSDRTHQRINLNNSGTDRTNDLYLHIVQTFGCIETTATENATKLLMLGDVEVEISASSVSIEWTQKSMISQTIADSIVIMIIGLCASDKNVLSESELKERNHNVWKIQELQNLFREQFGDSFSIDEGIGKKENVKNGSVTIGKSKATIDFSTMKLIDCNSNPLKGRVESILSIGQKLTTPLC');
INSERT INTO proteininfo VALUES ('6324752', 'NP_014821.1','Regulatory subunit for Glc7p (protein phosphatase I) for glycogen synthesis; regulatory role also predicted for glucose repression and ion homeostatis; potential Cdc28p substrate; Gac1p [Saccharomyces cerevisiae]','MVIQTATTLSPAKARPSFPHNDLIKSMSDSLISRPTHPPIRKLKSSLKISHPEPISRSKSEIFCTSPEKNVRFAIELTTVKRFDKNAEPSSISNENSPTLSPVDSNTAADDVQLFNNEDCWFNDSSLVTNLLKNEKKFRYMNSLNNMFKLDLYDSEDEDDIDEHINSQAEYGYTYNSLSTRGKTSENKSATSSLATQATNICDWKLHCTDLVPFKIAPPLFTKTLSASDLQGQLTKYLNGQNVKLHSLTQLGDDSSKITGLVYVKNLSFEKYLEIKFTFNSWRDIHYVTANFNRTINSNVDEFKFTIDLNSLKYILLIKRIITMEKNTSSCPLNIELCCRYDVNNETYYDNNNGKNYHLFMTTFKKGGETKEKIPVVVEPASQTDAAMSPKEMKARFVSSNPTLSRFLPQSRKFSEDTDYYNTSPLKHLYHNDTTSWVKPKRLNVVLDKLENATPPPPSSALANDTARTGKITKDKNNVLAPPTASNSIDLPILGSQHQSLYSGSSSYSSSSSSISSSLSFASSNNSSTNSSSASCSFPLTELDNFDYANLYEPNDTFTTANLFNHSLNSLMPEISTPSFFGGFRNENTINNNDSKNLVTSLEDSYEDKQSVITDTTMDENNKTSTINNSTDTLIKPSKENGTVKENKSSANSTSAPSSSQNRASTILNDHSNGKSDLKYVNYQSLLDSHCFYNHPSSPNLQSTSFSSAAPFSGISQASDIFDYENEDSDSNQIAGEIDNNSFPPHFYLDEDDKSACLSDDALIDHHRNTNPFINTFSSSPPILSQEVDRWRL');
INSERT INTO proteininfo VALUES ('6324751', 'NP_014820.1','Component of the meiotic outer plaque, a membrane-organizing center which is assembled on the cytoplasmic face of the spindle pole body during meiosis II and triggers the formation of the prospore membrane; potential Cdc28p substrate; YOR177c; Mpc54p [Saccharomyces cerevisiae]','MPEDTSYSNSFEDYYNNSHAISPYKDSFYKEMTPSKPNVRFGDDDVNIFDQRKKVNEINKNNTVKRSIPSSISTTITPNKSSLKSPRGKRASKNSFDNETKLESKNETLKEVNDAVNRCYALCNIPTKHVSINSISDLAQTFETLAVGITHETNRKAECERSKNAIDSLYYHEQLEKKELNEKSLQMAIDHLLKVTKQNLRQADDGNKLKETEALKSFIEEIEEVDDNKISINSLQQQLLEEKTANNILRRDYYKLQERGRRLCHEFQELQDDYSKQMKQKEYEVQKLKNEIKVLLNMNDNLKAEKAHYSQKEKQYFQKYTYIEKYMNHVKEEYNRKEDECKKLNFIIDKSMKKIEHLERSLQTQFTAQNSFSTAMIQEEGPKDAHLKDRYHKVKEFMEQKLQTSKINDPSCSEAEALDNVLCLIESSMKTLDKNSKCYPIATKKCIKYVTDSPRLKENEHVTN');
INSERT INTO proteininfo VALUES ('6324750', 'NP_014819.1','Ferrochelatase, a mitochondrial inner membrane protein, catalyzes the insertion of ferrous iron into protoporphyrin IX, the eighth and final step in the heme biosynthetic pathway; Yfh1p mediates the use of iron by Hem15p; Hem15p [Saccharomyces cerevisiae]','MLSRTIRTQGSFLRRSQLTITRSFSVTFNMQNAQKRSPTGIVLMNMGGPSKVEETYDFLYQLFADNDLIPISAKYQKTIAKYIAKFRTPKIEKQYREIGGGSPIRKWSEYQATEVCKILDKTCPETAPHKPYVAFRYAKPLTAETYKQMLKDGVKKAVAFSQYPHFSYSTTGSSINELWRQIKALDSERSISWSVIDRWPTNEGLIKAFSENITKKLQEFPQPVRDKVVLLFSAHSLPMDVVNTGDAYPAEVAATVYNIMQKLKFKNPYRLVWQSQVGPKPWLGAQTAEIAEFLGPKVDGLMFIPIAFTSDHIETLHEIDLGVIGESEYKDKFKRCESLNGNQTFIEGMADLVKSHLQSNQLYSNQLPLDFALGKSNDPVKDLSLVFGNHEST');
INSERT INTO proteininfo VALUES ('6324749', 'NP_014818.1','Hypothetical ORF; Yor175cp [Saccharomyces cerevisiae]','MYNPVDAVLTKIITNYGIDSFTLRYAICLLGSFPLNAILKRIPEKRIGLKCCFIISMSMFYLFGVLNLVSGFRTLFISTMFTYLISRFYRSKFMPHLNFMFVMGHLAINHIHAQFLNEQTQTTVDITSSQMVLAMKLTSFAWSYYDGSCTSESDFKDLTEHQKSRAVRGHPPLLKFLAYAFFYSTLLTGPSFDYADFDSWLNCEMFRDLPESKKPMRRHHPGERRQIPKNGKLALWKVVQGLAWMILSTLGMKHFPVKYVLDKDGFPTRSFIFRIHYLFLLGFIHRFKYYAAWTISEGSCILCGLGYNGYDSKTQKIRWDRVRNIDIWTVETAQNTREMLEAWNMNTNKWLKYSVYLRVTKKGKKPGFRSTLFTFLTSAFWHGTRPGYYLTFATGALYQTCGKIYRRNFRPIFLREDGVTPLPSKKIYDLVGIYAIKLAFGYMVQPFIILDLKPSLMVWGSVYFYVHIIVAFSFFLFRGPYAKQVTEFFKSKQPKEIFIRKQKKLEKDISASSPNLGGILKAKIEHEKGKTAEEEEMNLGIPPIELEKWDNAKEDWEDFCKDYKEWRNKNGLEIEEENLSKAFERFKQEFSNAASGSGERVRKMSFSGYSPKPISKKEE');
INSERT INTO proteininfo VALUES ('6324748', 'NP_014817.1','Member of RNA Polymerase II transcriptional regulation mediator; Stoichiometric member of mediator complex; Med4p [Saccharomyces cerevisiae]','MSVQDTKAVEFSMGHIRSSSVSLVAEATSNTNSEDKLSKVQLYEDLCRYEDTLSKLVESVDRFKPNLDIAKDLIRTDEALFENVKLLAEYDNIYRNLQKIDKDSEELDSKTRKILEILNECHDELKALPMLEQVEFEKNTILQQRSKINSTELLDYATKLSKFTKIPPTFDKGAVGPNNFIWPAEDALRRGMLAMASLHSKELTRIPGEEVEETEVPTVPPSQSEEQKGQMAKKEGTPKTDSFIFDGTAKEVGDEADNTKDKEKEENNDDALDLDLDLFDPDDF');
INSERT INTO proteininfo VALUES ('6324747', 'NP_014816.1','Non-essential protein containing a HIT (histidine triad) motif; regulated by Msn2p, Msn4p, and the Ras-cAMP-cAPK signalling pathway, transcript accumulates under glucose limitation, similar to Dcs1p; Dcs2p [Saccharomyces cerevisiae]','MSIKAERRETEARGFRLVFKYMLGRYLFIAKLKRFERVKVKKYMMGSQDLASLIGRFKYVRVLDSNPHTKVISLLGSIDGKDAVLTAEKTHFIFDETVRRPSQSGRSTPIFFHREIDEYSFLNGITDLKELTSNDIYYWGLSVLKQHILHNPTAKVNLIWPASQFHIKGYDQQDLHVVRETPDMYRNIVVPFIQEMCTSERMKWVNNILYEGAEDDRVVYKEYSSRNKEDGFVILPDMKWDGINIDSLYLVAIVYRDDIKSLRDLNPNHRDWLIRLNKKIKTIIPQHYDYNVNPDELRVFIHYQPSYYHFHVHIVNIRHPGVGEERGSGMTILLEDVIEALGFLGPEGYMKKTLTYVIGENHDLWKKGFKEEVEKQLKHDGIATSPEKGSGFNTNLG');
INSERT INTO proteininfo VALUES ('6324746', 'NP_014815.1','Zn2-Cys6 zinc-finger transcription factor that activates genes involved in multidrug resistance; paralog of Yrr1p, acting on an overlapping set of target genes; Yrm1p [Saccharomyces cerevisiae]','MSKRGSLQDRASPSEETVKKAQKRRKPIKSCAFCRKRKLRCDQQKPMCSTCKTRGRSGCLYTEKFTHKIETKELFGSTPNIELLKRIEDLEKRLDDKELTEKDVALSTSPFRNPYANFYYLQCKGSGRRIVYGPTSLRTHLSNDDNRFVNTYNQLWSKVKIERNRWKARHKWTMKPETQLLEGPPLEKTGSDILQQVCNVLPSFEQSSKIITDFFNTELETNEVSEVLDKTKIINDFTSSFLPSDELLPNGERRIEKLLPSTKKNYYKIGVILMILCIRHFYKNTPEEIEKFLIMLTGLSTAKVYFIERAQFLLLKYYHRELIWACGDDSHMISLVDLLCSTAIMLGLHLNIREIYKNQENIVGSMESLENLWVWIILSDFNVSLNIGRCLAINSSYFQVDECENGERLPKNTNNYSSTVFFDQSNSCMGKLKRFLRLARPMLDQIYDRSAFPDLAENCKKLRNFVETEFHPISYYTDSELISKVPLCEIKVLAQVLNLLLTFYSLRYLIYKEKSVVLENNILQTILVSFSLVINTTILCFNLDEKHFPEFFDHNCVHLPPFMALSLVYTNFLFPRASTGFCAFLYHKLTLFEKGYYLSSNIKDQEVTDWDLSTLNIPLDKAMNLLTAFKIHSDIFAKWSNDNNKQLRIIMARSYTFVINIALESIYRAVLEKVIKYRTEVENTWLQQLQDELNGSYSLTDNVNTPIDPSLSDLGVTSASPLAGNSPGLPPEEVRNNSENASHNNETGPIETELAQTISNEFWTAYNLGWEELMSQPDYKYLFDTQ');
INSERT INTO proteininfo VALUES ('6324745', 'NP_014814.1','Sphingoid long-chain base kinase, responsible for synthesis of long-chain base phosphates, which function as signaling molecules, regulates synthesis of ceramide from exogenous long-chain bases, localizes to the Golgi and late endosomes; Lcb4p [Saccharomyces cerevisiae]','MVVQKKLRAILTDEGVLIKSQSHHMFNKHGQLRSGDSLSLLSCLSCLDDGTLSSDGGSFDEDDSLELLPLNTTIPFNRILNAKYVNVGQKGFNNGKISSNPFQTENLSSSSENDDVENHSLSNDKAPVSESQSFPKKDKWDTKTNTVKVSPDDSQDNSPSLGIKDNQQLIELTFAVPKGHDVIPQKLTLLIDHVSRKSRANTGEENISSGTVEEILEKSYENSKRNRSILVIINPHGGKGTAKNLFLTKARPILVESGCKIEIAYTKYARHAIDIAKDLDISKYDTIACASGDGIPYEVINGLYRRPDRVDAFNKLAVTQLPCGSGNAMSISCHWTNNPSYAALCLVKSIETRIDLMCCSQPSYMNEWPRLSFLSQTYGVIAESDINTEFIRWMGPVRFNLGVAFNIIQGKKYPCEVFVKYAAKSKKELKVHFLENKDKNKGCLTFEPNPSPNSSPDLLSKNNINNSTKDELSPNFLNEDNFKLKYPMTEPVPRDWEKMDSELTDNLTIFYTGKMPYIAKDTKFFPAALPADGTIDLVITDARIPVTRMTPILLSLDKGSHVLEPEVIHSKILAYKIIPKVESGLFSVDGEKFPLEPLQVEIMPMLCKTLLRNGRYIDTEFESM');
INSERT INTO proteininfo VALUES ('6324742', 'NP_014811.1','Glutamine tRNA synthetase, monomeric class I tRNA synthetase that catalyzes the specific glutaminylation of tRNA(Glu); N-terminal domain proposed to be involved in enzyme-tRNA interactions; Gln4p [Saccharomyces cerevisiae]','MSSVEELTQLFSQVGFEDKKVKEIVKNKKVSDSLYKLIKETPSDYQWNKSTRALVHNLASFVKGTDLPKSELIVNGIINGDLKTSLQVDAAFKYVKANGEASTKMGMNENSGVGIEITEDQVRNYVMQYIQENKERILTERYKLVPGIFADVKNLKELKWADPRSFKPIIDQEVLKLLGPKDERDLIKKKTKNNEKKKTNSAKKSSDNSASSGPKRTMFNEGFLGDLHKVGENPQAYPELMKEHLEVTGGKVRTRFPPEPNGYLHIGHSKAIMVNFGYAKYHNGTCYLRFDDTNPEKEAPEYFESIKRMVSWLGFKPWKITYSSDYFDELYRLAEVLIKNGKAYVCHCTAEEIKRGRGIKEDGTPGGERYACKHRDQSIEQNLQEFRDMRDGKYKPGEAILRMKQDLNSPSPQMWDLIAYRVLNAPHPRTGTKWRIYPTYDFTHCLVDSMENITHSLCTTEFYLSRESYEWLCDQVHVFRPAQREYGRLNITGTVLSKRKIAQLVDEKFVRGWDDPRLFTLEAIRRRGVPPGAILSFINTLGVTTSTTNIQVVRFESAVRKYLEDTTPRLMFVLDPVEVVVDNLSDDYEELATIPYRPGTPEFGERTVPFTNKFYIERSDFSENVDDKEFFRLTPNQPVGLIKVSHTVSFKSLEKDEAGKIIRIHVNYDNKVEEGSKPKKPKTYIQWVPISSKYNSPLRVTETRVYNQLFKSENPSSHPEGFLKDINPESEVVYKESVMEHNFGDVVKNSPWVVDSVKNSEFYVEEDKDSKEVCRFQAMRVGYFTLDKESTTSKVILNRIVSLKDATSK');
INSERT INTO proteininfo VALUES ('6324741', 'NP_014810.1','Protein component of the small (40S) ribosomal subunit; nearly identical to Rps28Ap and has similarity to rat S28 ribosomal protein; Rps28ap [Saccharomyces cerevisiae]','MDNKTPVTLAKVIKVLGRTGSRGGVTQVRVEFLEDTSRTIVRNVKGPVRENDILVLMESEREARRLR');
INSERT INTO proteininfo VALUES ('6324740', 'NP_014809.1','Hypothetical ORF; Yor166cp [Saccharomyces cerevisiae]','MTDEKRAFPKGNNHIRSETFNGSVSHKISESIKDIASLRPHGKYTVQDIDNIIASTSSHENRGQSGDSNGCINHDEEGDIPMCDLNDESDVEMISEYLSSQREMEAQSVANYMPKINDDLPLLNPPTLKTAFVVDTNFIISHLNTLEKLRSLSSTYHHLIIVPTTVIQELDGLKKSPDIARDNDDTTNQEHDRTIGTLARWGNDWIYKNLANLDSGLIGQKLKQSLNPGSLKDDSILDCCLYFKEILNCFVILLSNDKNLCTKALTEDILTVSFRKNMDAKIIAMRAYEENQLRFANLRDSTVNNFDQNVTSYAHIPGIETPPLQFDKVSQNVFEQVKETIFFAIDHTLRKEYGEDIGFIDYNPDKLTTIENASNYIYLFWVSVFSELFTCSKIKKNEWKSLPTVLKSKPTNLNDLRTFEQFWETVLHFLFSKFTNEEKQSLEKQIHEWKTSINAIST');
INSERT INTO proteininfo VALUES ('6324739', 'NP_014808.1','Synthetic Enhancement with YOP1; Sey1p [Saccharomyces cerevisiae]','MADRPAIQLIDEEKEFHQSALQYFQQCIGNRDVGLDYHVISVFGSQSSGKSTLLNVLFNTNFDTMDAQVKRQQTTKGIWLAHTKQVNTTIEIDNDRPDIFVLDVEGSDGSERGEDQDFERKAALFAIAVSEVLIVNMWEQQIGLYQGNNMALLKTVFEVNLSLFGKNDNDHKVLLLFVIRDHVGVTPLSSLSDSVTRELEKIWTELSKPAGCEGSSLYDYFDLKFVGLAHKLLQEDKFTQDVKKLGDSFVMKGTENYYFKPQYHHRLPLDGWTMYAENCWDQIERNKDLDLPTQQILVARFKTEEISNEALEEFISKYDESIAPLKGNLGSLTSQLVKLKEECLTKYDEQASRYARNVYMEKREALNTKLNSHISGTINEFLESLMEKLWDDLKLEVSSRDKATTSFVESVAAGKSKIEKEFNESMETFKKLGLLISNEEITCKFSDDIEERIKQLRDAELKAKIGRIKKNLVPELKDHVIHLLSHPSKKVWDDIMNDFESTIKDNISAYQVEKDKYDFKIGLSESENAKIYKNIRILAWRTLDTTVHDYLKIDTIVSILRDRFEDVFRYDAEGSPRLWKTEEEIDGAFRVAKEHALEVFEVLSLAVTSDNVEIIPDVPMAEEESGEDNEIYRDNEGVFHSRRFAHILTELQKENVLDQFRRQINITVLDSKRSIITTRTHIPPWIYVLLAVLGWNEFVAVIRNPLFVTLTLILGATFFVIHKFGLWGPVVNVVQSAVGETRTAIKDKLRQFVVEDHEVKESFEMKDFSKNEQKEK');
INSERT INTO proteininfo VALUES ('6324738', 'NP_014807.1','Hypothetical ORF; Yor164cp [Saccharomyces cerevisiae]','MVPAESNAVQAKLAKTLQRFENKIKAGDYYEAHQTLRTIANRYVRSKSYEHAIELISQGALSFLKAKQGGSGTDLIFYLLEVYDLAEVKVDDISVARLVRLIAELDPSEPNLKDVITGMNNWSIKFSEYKFGDPYLHNTIGSKLLEGDFVYEAERYFMLGTHDSMIKYVDLLWDWLCQVDDIEDSTVAEFFSRLVFNYLFISNISFAHESKDIFLERFIEKFHPKYEKIDKNGYEIVFFEDYSDLNFLQLLLITCQTKDKSYFLNLKNHYLDFSQAYKSELEFLGQEYFNIVAPKQTNFLQDMMSGFLGGSK');
INSERT INTO proteininfo VALUES ('6324737', 'NP_014806.1','Diadenosine polyphosphate hydrolase, member of the MutT family of nucleotide hydrolases with high specificity for diadenosine hexa- and pentaphosphates, required for efficient hydrolysis of diphosphorylated inositol polyphosphates; Ddp1p [Saccharomyces cerevisiae]','MGKTADNHGPVRSETAREGRENQVYSPVTGARLVAGCICLTPDKKQVLMITSSAHKKRWIVPKGGVEKDEPNYETTAQRETWEEAGCIGKIVANLGTVEDMRPPKDWNKDIKQFENSRKDSEVAKHPPRTEFHFYELEIENLLDKFPECHKRHRKLYSYTEAKQNLIDAKRPELLEALNRSAIIKDDK');
INSERT INTO proteininfo VALUES ('6324736', 'NP_014805.1','Zn2-Cys6 zinc-finger transcription factor that activates genes involved in multidrug resistance; paralog of Yrm1p, acting on an overlapping set of target genes; Yrr1p [Saccharomyces cerevisiae]','MKRRSDALLGSFQATNVTPPSDNSNSTAGGANGSNSGTPTSTSGKKRNKLIKSCGFCRRRKLRCDQQKPMCSTCISRNLTTCQYAEEFNKNIEKKATYGPYPNADLLKKVEELENKIRILEAEKNTNSSASSMYTSPNFPPLGTSVGRGSTETSSPLPDGVINPYADRYYLQSKHSGRSTLYGPTSMRTQIANSNWGFIEKYKQLWAKVKVERNKWKQNNQKTMCRELGLLDESDWQPDPLIKQICRFLPSYNKALSILDDFFNDGACNEINVILDKAKVRRDFLDYFMPEKEVKAEGDRSIVYILSNPKKNYYKAAVILLILCLKYFHTDVPTPIEKFFTLLKGASTAKVFYIERAQMLILFYYHRETYSFGGDGSDLVNINECLVTTVTTIGLHLNIRETFKEHEVFMGSIESLENVWLMAIFIDYNISCNVGRPLLINKFYLDENQDHCILNSKSKTYEGKLKRYLKLTRPMLLTLYDRDKFPDLKAYSKRIINFVEEELGPLGHYTGENISEEVPLRESRILSMAVGLLLSFYALIHSVLKVRNIESKNNTFQLVLINFSIIVNTTIRCYRIDKALYPEKFEASNPHLPPHMALSMSLTAGLFSKTLVFFCSLIYFKLTLFENGLCLSNDMEVGWSDLTKLTVPLDKDLSLGTAMSLYSSIFDRLFTVGNKELIRTMHRSSQFVIELAIERTYRTILGNVIEFRKLTEETWLAQIKQELDPQSDNPSSEAKIVSDRQRDLSLAVPTPTPSIIPMLPSPGETKNHAKSQSEIIQMLTDEFWANYNSGWEELINQSEFSTLFDDYKDN');
INSERT INTO proteininfo VALUES ('6324735', 'NP_014804.1','Protein of unknown function; has similarity to Torpedo californica tCTL1p, which is postulated to be a choline transporter, neither null mutation nor overexpression affects choline transport; Pns1p [Saccharomyces cerevisiae]','MPLNEKYERPPQPPPAYDPNHRPPSSSENSAAANVNDGQTPYHFRQDQYYNLNSKTSGAPIGSFDEAFPTENDNKPRWNDWPFTIFFLCTVGGFIAIAAITLRAWSQTYSSTGSGIYDGVNTGTLNTNAAILLVFVCIIALVFSVLGLTLCRIFPKQFIYCGMVINLVASLGTAIMYMSLRYWSAGIVFLVFTFMTAWCYWGMRSRIPLSVAVLKVVVDAMKKCPQIFFVSFVGALVASAFGFLFSAVIVATYIKYDPNSSNGGCDVSGGSCSHSKLIGVLVVVFFCGYYISEVIRNVIHCVISGVFGSWYYMSKSDQGMPRWPAFGALKRAMTYSFGSICFGSLLVALIDLLRQILQMIRHDVTSSGGGQIAIQILFMVFDWIIGFLKWLAEYFNHYAYSFIALYGKPYLRAAKETWYMLREKGMDALINDNLINIALGLFSMFASYMTALFTFLYLRFTSPQYNSNGAYNGALMAFSFVIALQICNIATEAIRSGTATFFVALGNDPEVFHHSYPHRFDEIFRAYPDVLRKLSHQNV');
INSERT INTO proteininfo VALUES ('6324734', 'NP_014803.1','Nuclear import receptor, mediates the nuclear localization of proteins involved in mRNA-nucleus export; Mtr10p [Saccharomyces cerevisiae]','MDNLQVSDIETALQCISSTASQDDKNKALQFLEQFQRSTVAWSICNEILSKEDPTNALLELNIFAAQTLRNKVTYDLSQLENNLPQFKDSLLTLLLSHNQKLIITQLNVALARLAIQFLEWQNPIFEIISLLNSSPSILLNFLRILPEETLDIASTSLTEVEFNSRIHELIDPIAEDVLKFLVSCIDLLQNTDGNSSSSISLEQILRCLNSWSYEFPVEQLLTVQPLINLVFETISNGNESDMEAFDSAIDCLCVILRESRDTTNEQLISALFHQLMLLQEKLLPTLFTDHPLNDEYDDDLLEGMTRLFVEAGEAWSVVISKNPDFFKPMVLVLLMLTCKNEDLDVVSYTFPFWFNFKQSLVLPRYQESRKAYSDIFVKLINGIITHLQYPSGQFSSKEEEDKFKDFRYHMGDVLKDCTAVVGTSEALSQPLIRIKSAIENNNSWQIMEAPLFSLRTMAKEISLTENTILPEIIKIICNLPEQAKIRYASTLVLGRYTEWTAKHPELLEVQLQYIFNGFQLHEGSSDMQSIITASSHALMFFCSDCSKLLVGYIDQLINFFLNVQSSIDIESQFELCQGLSAVINNQPEAKVSVIFQKLVDDNLRQIEALIPQWKANPTLLAPQIADKIDLLYALFEELKPRYNYPQQGSEPLLPRIEFIWKALRTLLVDAGAMTDSIIVERVAKLLRRIFERFHVFCEPILPSVAEFLIQGYLTTGFGSYLWCSGSLIVIFGDDESFPISPSLKDAVWKFALSQCETFILNFNKFDKLQLNDYHEAIIDFFSLISDLIMFYPGAFLNSTELLGPVLNVALECVNKLDNYDAYICILRCLDDIISWGFKTPPISTVSIEIVPDEWRKQVINEVVIAHGNQLILVLFIGLVTTFENTAHSDAISCIVKCLRILTEANNNDATICIDWIYKVVEQLGQVTLNERDNLAKAVVEGLNSKDYRKVREGIRAFVGWYSRKNINSRFE');
INSERT INTO proteininfo VALUES ('6324733', 'NP_014802.1','Required for pre-mRNA splicing, cap modification and U1, U2, U4 and U5 snRNA stability; homologue of human E core protein; Sme1p [Saccharomyces cerevisiae]','MSNKVKTKAMVPPINCIFNFLQQQTPVTIWLFEQIGIRIKGKIVGFDEFMNVVIDEAVEIPVNSADGKEDVEKGTPLGKILLKGDNITLITSAD');
INSERT INTO proteininfo VALUES ('6324732', 'NP_014801.1','Mitochondrial ribosomal protein of the small subunit; PET123 exhibits genetic interactions with PET122, which encodes a COX3 mRNA-specific translational activator; Pet123p [Saccharomyces cerevisiae]','MGKGAAKYGFKSGVFPTTRSILKSPTTKQTDIINKVKSPKPKGVLGIGYAKGVKHPKGSHRLSPKVNFIDVDNLIAKTVAEPQSIKSSNGSAQKVRLQKAELRRKFLIEAFRKEEARLLHKHEYLQKRTKELEKAKELELEKLNKEKSSDLTIMTLDKMMSQPLLRNRSPEESELLKLKRNYNRSLLNFQAHKKKLNELLNLYHVANEFIVTESQLLKKIDKVFNDETEEFTDAYDVTSNFTQFGNRKLLLSGNTTLQTQINNAIMGSLSNEKFFDISLVDSYLNKDLKNISNKIDSKLNPTSNGAGNNGNNNNTTNL');
INSERT INTO proteininfo VALUES ('6324731', 'NP_014800.1','putative proteasome subunit; Pup1p [Saccharomyces cerevisiae]','MAGLSFDNYQRNNFLAENSHTQPKATSTGTTIVGVKFNNGVVIAADTRSTQGPIVADKNCAKLHRISPKIWCAGAGTAADTEAVTQLIGSNIELHSLYTSREPRVVSALQMLKQHLFKYQGHIGAYLIVAGVDPTGSHLFSIHAHGSTDVGYYLSLGSGSLAAMAVLESHWKQDLTKEEAIKLASDAIQAGIWNDLGSGSNVDVCVMEIGKDAEYLRNYLTPNVREEKQKSYKFPRGTTAVLKESIVNICDIQEEQVDITA');
INSERT INTO proteininfo VALUES ('6324730', 'NP_014799.1','Interacts with C-terminus of CDC12. Contains two known protein motifs: SAP (DNA binding) and MIZ-finger; interacts with C-terminus of CDC12; Nfi1p [Saccharomyces cerevisiae]','MASVMSNNNNNNNNNNASYMFTNPLSNTGGGLINEIKDAINEMEQLKVLELKQICKSLDLSITGKKAVLQDRIKQFLRKSCDIGHIDPWRPKAIKILIAKVRINSSLPKYSTLWETLKTGAFKHPVASGQLPVTALQSTALPPYSQQQALAYSFTSPFYKPIVQIPDANKKLKQSAGRGCTKMKFKVSKSNHDLLKSNKSYKLYLFSGFSIPFIYETVGHEAIDFPYPCELVFNGTKLEDNVKGLKKQNGTGNPANLTPYLKVPTEMNHLDLHYLNIDKEYSISCFIVEVFSPEALLGKILKRPKIIKQATTAYIKRTLNEQDDDDIITTSTVLSLQCPISCTRMKYPAKTDQCKHIQCFDALWFLHSQSQVPTWQCPICQHPIKFDQLKISEFVDNIIQNCNEDVEQVEISVDGSWKPIHNSSAVITDTVNQNHSVKNENQGTVKQEQDYDSRNAFDTNLRNGSNHNEPEIISLDSSDDEAFIPASKSFPTHVNPRNDQLRADIFPSESEGSSDYNPNHTSTPKGSPTMDQDNYQDAFQMRSFLNQGATTNINDTPTNNSSINSFVTATNGDSRIFYNRGPSTPLLPAVLQNLTNQTEAQRNPYGPNYNTTAQDRNLLGIEGDLPPIPPVDPNSEAETELPTRTTSAAHLPPYIHVSTSGHGDDGKIRKRRHSNVSIYIPKNPYATLMKRRPQANHAIMNKTLAQTNDFNTSAQDNSEVVDLTSD');
INSERT INTO proteininfo VALUES ('6324729', 'NP_014798.1','Inosine 5'-monophosphate (IMP)-specific 5'-nucleotidase, catalyzes the breakdown of IMP to inosine, does not show similarity to known 5'-nucleotidases from other organisms; Isn1p [Saccharomyces cerevisiae]','MSSRYRVEYHLKSHRKDEFIDWVKGLLASPFVLHAVSHEGDYNDDLATTQRVRSQYADIFKDIEGLIKDKIEFDSRNMSQDEIEDGASSQSLNILGQSRLNLLVPSIGTFFTELPLEQAFLWEDSQRAISARRMVAPSFNDIRHILNTAQIFHFKKQENLHNGKVLRLVTFDGDVTLYEDGGSLVYTNPVIPYILKLLRCGINVGIVTAAGYDEAGTYENRLKGLIVALHDSTDIPVSQKQNLTIMGGESSYLFRYYEDPEEDNFGFRQIDKEEWLLPRMKAWSLEDVEKTLDFAERTLNRLRKRLNLPSEISIIRKVRAVGIVPGERYDEASKRQVPVKLDREQLEEIVLTLQNTLESFAPSRRIQFSCFDGGSDVWCDIGGKDLGVRSLQQFYNPESPIQPSETLHVGDQFAPVGSANDFKARLAGCTLWIASPQETVNYLHRLLETD');
INSERT INTO proteininfo VALUES ('6324728', 'NP_014797.1','Hypothetical ORF; Yor154wp [Saccharomyces cerevisiae]','MANRLLIYGLILWVSIIGSFALDRNKTAQNAKIGLHDTTVITTGSTTNVQKEHSSPLSTGSLRTHDFRQASKVDIRQADIRENGERKEQDALTQPATPRNPGDSSNSFLSFDEWKKVKSKEHSSGPERHLSRVREPVDPSCYKEKECIGEELEIDLGFLTNKNEWSEREENQKGFNEEKDIEKVYKKKFNYASLDCAATIVKSNPEAIGATSTLIESKDKYLLNPCSAPQQFIVIELCEDILVEEIEIANYEFFSSTFKRFRVSVSDRIPMVKNEWTILGEFEARNSRELQKFQIHNPQIWASYLKIEILSHYEDEFYCPISLIKVYGKSMMDEFKIDQLKAQEDKEQSIGTNNINNLNEQNIQDRCNNIETRLETPNTSNLSDLAGALSCTSKLIPLKFDEFFKVLNASFCPSKQMISSSSSSAVPVIPEESIFKNIMKRLSQLETNSSLTVSYIEEQSKLLSKSFEQLEMAHEAKFSHLVTIFNETMMSNLDLLNNFANQLKDQSLRILEEQKLENDKFTNRHLLHLERLEKEVSFQRRIVYASFFAFVGLISYLLITRELYFEDFEESKNGAIEKADIVQQAIR');
INSERT INTO proteininfo VALUES ('6324727', 'NP_014796.1','multidrug efflux transporter which mediates pleiotropic drug resistance to hundreds of unrelated compounds; multidrug resistance transporter; Pdr5p [Saccharomyces cerevisiae]','MPEAKLNNNVNDVTSYSSASSSTENAADLHNYNGFDEHTEARIQKLARTLTAQSMQNSTQSAPNKSDAQSIFSSGVEGVNPIFSDPEAPGYDPKLDPNSENFSSAAWVKNMAHLSAADPDFYKPYSLGCAWKNLSASGASADVAYQSTVVNIPYKILKSGLRKFQRSKETNTFQILKPMDGCLNPGELLVVLGRPGSGCTTLLKSISSNTHGFDLGADTKISYSGYSGDDIKKHFRGEVVYNAEADVHLPHLTVFETLVTVARLKTPQNRIKGVDRESYANHLAEVAMATYGLSHTRNTKVGNDIVRGVSGGERKRVSIAEVSICGSKFQCWDNATRGLDSATALEFIRALKTQADISNTSATVAIYQCSQDAYDLFNKVCVLDDGYQIYYGPADKAKKYFEDMGYVCPSRQTTADFLTSVTSPSERTLNKDMLKKGIHIPQTPKEMNDYWVKSPNYKELMKEVDQRLLNDDEASREAIKEAHIAKQSKRARPSSPYTVSYMMQVKYLLIRNMWRLRNNIGFTLFMILGNCSMALILGSMFFKIMKKGDTSTFYFRGSAMFFAILFNAFSSLLEIFSLYEARPITEKHRTYSLYHPSADAFASVLSEIPSKLIIAVCFNIIFYFLVDFRRNGGVFFFYLLINIVAVFSMSHLFRCVGSLTKTLSEAMVPASMLLLALSMYTGFAIPKKKILRWSKWIWYINPLAYLFESLLINEFHGIKFPCAEYVPRGPAYANISSTESVCTVVGAVPGQDYVLGDDFIRGTYQYYHKDKWRGFGIGMAYVVFFFFVYLFLCEYNEGAKQKGEILVFPRSIVKRMKKRGVLTEKNANDPENVGERSDLSSDRKMLQESSEEESDTYGEIGLSKSEAIFHWRNLCYEVQIKAETRRILNNVDGWVKPGTLTALMGASGAGKTTLLDCLAERVTMGVITGDILVNGIPRDKSFPRSIGYCQQQDLHLKTATVRESLRFSAYLRQPAEVSIEEKNRYVEEVIKILEMEKYADAVVGVAGEGLNVEQRKRLTIGVELTAKPKLLVFLDEPTSGLDSQTAWSICQLMKKLANHGQAILCTIHQPSAILMQEFDRLLFMQRGGKTVYFGDLGEGCKTMIDYFESHGAHKCPADANPAEWMLEVVGAAPGSHANQDYYEVWRNSEEYRAVQSELDWMERELPKKGSITAAEDKHEFSQSIIYQTKLVSIRLFQQYWRSPDYLWSKFILTIFNQLFIGFTFFKAGTSLQGLQNQMLAVFMFTVIFNPILQQYLPSFVQQRDLYEARERPSRTFSWISFIFAQIFVEVPWNILAGTIAYFIYYYPIGFYSNASAAGQLHERGALFWLFSCAFYVYVGSMGLLVISFNQVAESAANLASLLFTMSLSFCGVMTTPSAMPRFWIFMYRVSPLTYFIQALLAVGVANVDVKCADYELLEFTPPSGMTCGQYMEPYLQLAKTGYLTDENATDTCSFCQISTTNDYLANVNSFYSERWRNYGIFICYIAFNYIAGVFFYWLARVPKKNGKLSKK');
INSERT INTO proteininfo VALUES ('6324726', 'NP_014795.1','Hypothetical ORF; Yor152cp [Saccharomyces cerevisiae]','MFNLILWPLFLLTSVAIPLQLTLEVVYLTSSVDFSKASAAKTATSLGQSPVVITIYKSLLKYWSLYEFIHFIYLYTPIDAFLNFLPFTSLLMSFGSICLTRELVYDFIAFMESQNKLTGFLNKITEPNFNSYLLFSSIYNIWFADDTNDKFLFGKLTQILISVTKRYEFPRTFYLAKVSDFLQNLILTRLRPFVTEQPQGDKNRYQNGDRESTKNGAAYQKSSQQSSSFEQNFTSTEFPNDYDFMEDILDETTELD');
INSERT INTO proteininfo VALUES ('6324725', 'NP_014794.1','RNA polymerase II core subunit; Rpb2p [Saccharomyces cerevisiae]','MSDLANSEKYYDEDPYGFEDESAPITAEDSWAVISAFFREKGLVSQQLDSFNQFVDYTLQDIICEDSTLILEQLAQHTTESDNISRKYEISFGKIYVTKPMVNESDGVTHALYPQEARLRNLTYSSGLFVDVKKRTYEAIDVPGRELKYELIAEESEDDSESGKVFIGRLPIMLRSKNCYLSEATESDLYKLKECPFDMGGYFIINGSEKVLIAQERSAGNIVQVFKKAAPSPISHVAEIRSALEKGSRFISTLQVKLYGREGSSARTIKATLPYIKQDIPIVIIFRALGIIPDGEILEHICYDVNDWQMLEMLKPCVEDGFVIQDRETALDFIGRRGTALGIKKEKRIQYAKDILQKEFLPHITQLEGFESRKAFFLGYMINRLLLCALDRKDQDDRDHFGKKRLDLAGPLLAQLFKTLFKKLTKDIFRYMQRTVEEAHDFNMKLAINAKTITSGLKYALATGNWGEQKKAMSSRAGVSQVLNRYTYSSTLSHLRRTNTPIGRDGKLAKPRQLHNTHWGLVCPAETPEGQACGLVKNLSLMSCISVGTDPMPIITFLSEWGMEPLEDYVPHQSPDATRVFVNGVWHGVHRNPARLMETLRTLRRKGDINPEVSMIRDIREKELKIFTDAGRVYRPLFIVEDDESLGHKELKVRKGHIAKLMATEYQDIEGGFEDVEEYTWSSLLNEGLVEYIDAEEEESILIAMQPEDLEPAEANEENDLDVDPAKRIRVSHHATTFTHCEIHPSMILGVAASIIPFPDHNQSPRNTYQSAMGKQAMGVFLTNYNVRMDTMANILYYPQKPLGTTRAMEYLKFRELPAGQNAIVAIACYSGYNQEDSMIMNQSSIDRGLFRSLFFRSYMDQEKKYGMSITETFEKPQRTNTLRMKHGTYDKLDDDGLIAPGVRVSGEDVIIGKTTPISPDEEELGQRTAYHSKRDASTPLRSTENGIVDQVLVTTNQDGLKFVKVRVRTTKIPQIGDKFASRHGQKGTIGITYRREDMPFTAEGIVPDLIINPHAIPSRMTVAHLIECLLSKVAALSGNEGDASPFTDITVEGISKLLREHGYQSRGFEVMYNGHTGKKLMAQIFFGPTYYQRLRHMVDDKIHARARGPMQVLTRQPVEGRSRDGGLRFGEMERDCMIAHGAASFLKERLMEASDAFRVHICGICGLMTVIAKLNHNQFECKGCDNKIDIYQIHIPYAAKLLFQELMAMNITPRLYTDRSRDF');
INSERT INTO proteininfo VALUES ('6324724', 'NP_014793.1','Mitochondrial ribosomal protein of the large subunit; Mrpl23p [Saccharomyces cerevisiae]','MSQKIGHSGLAFARLWHHVDVARDKRTLGRLASAIAITLIGRHKPVYHPSQDCGDYVVVTNCQKIRVTGKKFEQKTYWSHSGRPGQLKLQTMNKVVADKGFGEILKKAVSGMLPKNKLRKQRLDRLKVFDGSENPYKQNITAFAHEQSSIPEPLKESIFNQLK');
INSERT INTO proteininfo VALUES ('6324723', 'NP_014792.1','Protein involved in glycosyl phosphatidyl inositol synthesis, most likely an alpha 1,2 mannosyltransferase utilized for addition of the fourth, side-branching mannose onto the GPI core structure; Smp3p [Saccharomyces cerevisiae]','MMRYQWWLYLVYAIGLMLCLGPSYIHPDEHFQCIEILAMQFMKVKGTIPWEFKSKFAARSYGPLLLVYGPLFTILESFPEIQDNPALILYSMRLQNYVMYLLCYHFLIPKLIRDERKAVQFMQKSLLLTSYVTWTYQTHTFSNSIETLALISTLTVMEDMVNEKNIQRSNFKNSVILGLIFSFGVFNRVTFPAFIFLPCLILFWKFYRVHWKSFSLLLLSFSFSSCLFVLIDTNIYNNGKGFVITPLNNLKYNLNVQNLQVHGLHPRYTHLLVNLPQIVGPVLLLAIFSGYKLDKLSTYAIISGLLFLSFFQHQELRFLVPLVPLLVTNLNWTPLSSTLVNKKIFKGTWLLFNIIMAFIMGISHQAGIIQFLGDYFHFRTEQMGVHIWWKTYSPPTWMYMSNNLTVSSLINTQDGIESIDEVAFSVGNHHVIDLKGCDLPLLTETIRRLRLNGSITPLTLVTPNSMTSELKKLKRDGTINLIPKRNYLFHLDLDHLDFNDFTTFKPGLTVYSIELL');
INSERT INTO proteininfo VALUES ('6324722', 'NP_014791.1','Required for final stages of splicesome maturation; promotes step 1 of splicing; spliceosome-associated protein; Spp2p [Saccharomyces cerevisiae]','MSKFSLKLGSKTLKKNISKKTKKKNSLQKANLFDWDDAETASLSHKPQSKIKIQSIDKFDLDEESSSKKKLVIKLSENADTKKNDAPLVEYVTEKEYNEVPVEEFGDALLRGMGWESDSEQDSKGDKTQSRNKDVSNVSQIHPDGLGIGAKLNKAINVEEASFMPVVKIDKITGTKVDDDKKNKS');
INSERT INTO proteininfo VALUES ('6324721', 'NP_014790.1','Mitochondrial Distribution and Morphology; Mdm32p [Saccharomyces cerevisiae]','MHIKVDSRFASRSIKTKGTYRLSGGGRFIKFMLITRLRVPTIKRPLLPITSHLVRHCIRTYVATNHGNVRPFITPYKSSLPVRCLIAQRHIRTFPSNDKFTTKASNIETILLRKNNEREFKQSLLADAKNFQERFKINLKWILIKNNRPFSLNEISIIASWLILSQILWLILSTTTFISFYLFVINSVFSQEYIHEKKIYERLLKWLLKDHKCSNQDLEITFSPEDKASMLVLSPDWESNSILIKRLNVRDEILDLDLKFHHINLNVSLKNWLLGRGLITNVSIYGIRGCLNLSNFINLVNSFQGDQKTENFLKTLNNVEITDSEILLKQSLSAQETPSLKFSIYNLSLPRLRLNHFISDILSAKTFSGSINNSLFNLFKRQQKLTAVIENNNKNRMASSKFDFTDNNQENYRTVTHQDDPNYVTTLRLNFININDLKFNGDGKFNWLKDGQVEILADIMLTNSTSHLSSESKYAVVDLKVTCRDLKTTFPQEPPVLSTGDSIVSLDELKPIITFINSYEGMANPILKDFSENERLTNSIIWNSPNVSINRQRKSYPLTTKVTSNSTKEIIKFHNQPNTNANEIVLRCKMVKNLSDLQLININQILDQITMELYVDLTKIVEDWEFKNKNDWMKQWGTTFASQLLLFGFGAMV');
INSERT INTO proteininfo VALUES ('6324720', 'NP_014788.1','Partner of Nob1; Protein required for cell viability; Pno1p [Saccharomyces cerevisiae]','MVAPTALKKATVTPVSGQDGGSSRIIGINNTESIDEDDDDDVLLDDSDNNTAKEEVEGEEGSRKTHESKTVVVDDQGKPRFTSASKTQGNKIKFESRKIMVPPHRMTPLRNSWTKIYPPLVEHLKLQVRMNLKTKSVELRTNPKFTTDPGALQKGADFIKAFTLGFDLDDSIALLRLDDLYIETFEVKDVKTLTGDHLSRAIGRIAGKDGKTKFAIENATRTRIVLADSKIHILGGFTHIRMARESVVSLILGSPPGKVYGNLRTVASRLKERY');
INSERT INTO proteininfo VALUES ('6324718', 'NP_014787.1','Protein required for S phase progression and telomere homeostasis, forms an alternative replication factor C complex important for DNA replication and genome integrity; mutants are sensitive to DNA damage; Elg1p [Saccharomyces cerevisiae]','MKRHVSLSDILTGNKRKVRRQDALQITIDDENDTESGTFDARTAKHDDSSVIFLNHSVVKPIEAVSTNHKSAKEFLMTKRTKEKCDDDDDDLIVISDKSPKSETNCSKIALSQEHEDDISIISTSRIKSSLLNERASKIKNFLKHETTDTFKRLNSISKLNEIEPPLPLHQSIFPVGDKELSDRSVDIPLPFRTIPPLNHNFLPSDYESLKDKNSASCIPVRYQAPVLLGTNIKRNTTLTWPQLFKPVTLKQVLIEPKLKLRIKNWIETSFHTLEKPTLRNRLLNRINPNKQQGSGDELANFIVPDLEEDENLRPDFYRNGEANSSLSEFVPLMILHGNSIGKKTLIQTIMREIAGDDNSYQIYEVNSNMNRSKKDLLDILLDFTTTHYVKDSSKRKSDYGLVLFNDVDVLFKEHDRGYWAMISKLCEFSRRPLVLTCKDLSLVPSELIALASEQNSLFHTKKISTSTVYAFLTKYLKSLEIEVCDDWLRDVVKQNNADIRKCLMHLQFWCVDTEADLISSKNRLPVLTSTLGSSVKDISQLTDLLSINDVIGQATLNRSMVRQEIDSTTMTPEKVNTFQDQNLDDEMKLKFDYVIDYKLHLNDPNRQPLLPFELNIYQHIQEQLEARYSYVREANHRLDNEYLVNRFKKMTESTLNFLASRIPKYDHLQSARRTRNSKKISDILNQFKGIYNDETLNENAEIDLLSATTQQIKAEINPFVFEIAKSDANVKNENKQIFELHSENVSERRYKDLVYQLSQEGVLKNVWFNADPSIVVRKWEHLHSGFSKNK');
INSERT INTO proteininfo VALUES ('6324717', 'NP_014786.1','Thiamine pyrophosphokinase, phosphorylates thiamine to produce the coenzyme thiamine pyrophosphate (thiamine diphosphate); Thi80p [Saccharomyces cerevisiae]','MSEECIENPERIKIGTDLINIRNKMNLKELIHPNEDENSTLLILNQKIDIPRPLFYKIWKLHDLKVCADGAANRLYDYLDDDETLRIKYLPNYIIGDLDSLSEKVYKYYRKNKVTIIKQTTQYSTDFTKCVNLISLHFNSPEFRSLISNKDNLQSNHGIELEKGIHTLYNTMTESLVFSKVTPISLLALGGIGGRFDQTVHSITQLYTLSENASYFKLCYMTPTDLIFLIKKNGTLIEYDPQFRNTCIGNCGLLPIGEATLVKETRGLKWDVKNWPTSVVTGRVSSSNRFVGDNCCFIDTKDDIILNVEIFVDKLIDFL');
INSERT INTO proteininfo VALUES ('6324716', 'NP_014785.1','alpha subunit of succinyl-CoA ligase (synthetase; ATP-forming), a mitochondrial enzyme of the TCA cycle; Succinate-CoA Ligase (ADP-Forming); Lsc1p [Saccharomyces cerevisiae]','MLRSTVSKASLKICRHFHRESIPYDKTIKNLLLPKDTKVIFQGFTGKQGTFHASISQEYGTNVVGGTNPKKAGQTHLGQPVFASVKDAIKETGATASAIFVPPPIAAAAIKESIEAEIPLAVCITEGIPQHDMLYIAEMLQTQDKTRLVGPNCPGIINPATKVRIGIQPPKIFQAGKIGIISRSGTLTYEAVQQTTKTDLGQSLVIGMGGDAFPGTDFIDALKLFLEDETTEGIIMLGEIGGKAEIEAAQFLKEYNFSRSKPMPVASFIAGTVAGQMKGVRMGHSGAIVEGSGTDAESKKQALRDVGVAVVESPGYLGQALLDQFAKFK');
INSERT INTO proteininfo VALUES ('6324715', 'NP_014784.1','actin-related protein; Arp8p [Saccharomyces cerevisiae]','MSQEEAESSIIYEEPIDIPLEDDDDEDELEEENSVPLSSQADQENAENESDDSVDNVVGSETPRSVTGLSVDPRDVADEEDEDEEGEDEDEDEDDNDVDNEDENDNDNANENENELGSSRDKRAPPAVQTSKRYKKYPKLDPAKAPPGKKVPLHLLEKRRLGRIKAAEEFAKTLKKIGIEKVETTTLPATGLFQPLMLINQKNYSSDYLKKDDQIFALRDRKFLRNNNTSQISSTNTPDVIDLKSLPHSEASAAPLNDEIDLNDPTATIVIHPGSNSIKIGFPKDDHPVVVPNCVAVPKKWLDLENSEHVENVCLQREQSEEFNNIKSEMEKNFRERMRYYKRKVPGNAHEQVVSFNENSKPEIISEKNDPSPIEWIFDDSKLYYGSDALRCVDEKFVIRKPFRGGSFNVKSPYYKSLAELISDVTKLLEHALNSETLNVKPTKFNQYKVVLVIPDIFKKSHVETFIRVLLTELQFQAVAIIQESLATCYGAGISTSTCVVNIGAAETRIACVDEGTVLEHSAITLDYGGDDITRLFALFLLQSDFPLQDWKIDSKHGWLLAERLKKNFTTFQDADVAVQLYNFMNRSPNQPTEKYEFKLFDEVMLAPLALFFPQIFKLIRTSSHKNSSLEFQLPESRDLFTNELNDWNSLSQFESKEGNLYCDLNDDLKILNRILDAHNIIDQLQDKPENYGNTLKENFAPLEKAIVQSIANASITADVTRMNSFYSNILIVGGSSKIPALDFILTDRINIWRPSLLSSASFPQFYKKLTKEIKDLEGHYVNAPDKTEDENKQILQAQIKEKIVEELEEQHQNIEHQNGNEHIFPVSIIPPPRDMNPALIIWKGASVLAQIKLVEELFITNSDWDVHGSRILQYKCIFTY');
INSERT INTO proteininfo VALUES ('6324713', 'NP_014783.1','Transcription factor with domains homologous to Hsf1p and to myc oncoprotein; required for normal cell surface assembly and flocculence; Sfl1p [Saccharomyces cerevisiae]','MSEEETVSAPAPASTPAPAGTDVGSGGAAAGIANAGAEGGDGAEDVKKHGSKMLVGPRPPQNAIFIHKLYQILEDESLHDLIWWTPSGLSFMIKPVERFSKALATYFKHTNITSFVRQLNIYGFHKVSHDHSSNDANSGDDANTNDDSNTHDDNSGNKNSSGDENTGGGVQEKEKSNPTKIWEFKHSSGIFKKGDIEGLKHIKRRASSRNNSSINSRKNSSNQNYDIDSGARVRPSSIQDPSTSSNSFGNFVPQIPGANNSIPEYFNNSHVTYENANHAPLESNNPEMQEQNRPPNFQDETLKHLKEINFDMVKIIESMQHFISLQHSFCSQSFTFKNVSKKKSENIVKDHQKQLQAFESDMLTFKQHVMSRAHRTIDSLCAVNAAATAASVAPAPAPTSTSAYAPKSQYEMMVPPGNQYVPQKSSSTTNIPSRFNTASVPPSQLLYNTNRSRNQHVTYASEPAHVPNFINQPIPIQQLPPQYADTFSTPQMMHNPFASKNNNKPGNTKRTNSVLMDPLTPAASVGVQGPLNYPIMNINPSVRDYNKPVPQNMAPSPIYPINEPTTRLYSQPKMRSLGSTSSLPNDRRNSPLKLTPRSSLNEDSLYPKPRNSLKSSISGTSLSSSFTLVANNPAPIRYSQQGLLRSLNKAANCAPDSVTPLDSSVLTGPPPKNMDNLPAVSSNLINSPMNVEHSSSLSQAEPAPQIELPQPSLPTTSTTKNTGEADNSKRKGSGVYSLLNQEDSSTSSADPKTEDKAAPALKKVKM');
INSERT INTO proteininfo VALUES ('6324712', 'NP_014781.1','Rup1p [Saccharomyces cerevisiae]','MMDNQAVKSLLEMGIPHEVAVDALQRTGGNLEAAVNFIFSNELPEQAEMGEENDGSQPRISENKIVAGTKPCDVPNNGDQDIDMPDVSGVDVDYDDDEDITDERSGSNSTSGCRVTAQNYDRYSISETSIPPPSYSIVQHNEFKSNVGDPTVVLPLPLNSLIESYFGLFALLTAVYFPHVFLKPDFKDLNYRADWFKGSSFTEPKYRLAYCEAEDGSTTSEIVLASGPNEGLQPHLLWQLQKLISVVNTRKCERAFVSAKVFTSSLEPQLRSKLADSEHLYEVLPAFIKSLAVDLEMCPGIRDRETRSLFISSALHTPNKNEPPMETFLSLFHFLPEEYDSNLYKMFNVLLYPEEEEEEEDVIRGGEQEEARYVEPENTLKEVAPVLTILFNELETNTESVSLPNGVDIPLEFYPQLYTKQCKDQLIRHIISKRKQARTRSRCLLQEINELKSYQGKNISTILESTLAYLQTIPDDANNEAAKQIASLKDTLNSARAAKMEEYKDLASKLHGEWNLSHPETHIINTAKQLGLIENPYILTMAALSPYSYFIRSRNGAWSWIQSNTLGTEFKVKKCSSPSVVQEAIKHGTKYASETPLMFIYCEEGKIPTEEVVAEALKSNSGCLKFAEDDQNSLKTLRSQFFDGMGDPEQATNNINNGNDNDNDDDIDSDN');
INSERT INTO proteininfo VALUES ('6324711', 'NP_014780.1','Suppressor of eIF5A; High-copy suppressor of temperature-sensitive tif51A-1; Sia1p [Saccharomyces cerevisiae]','MRLHYRRRFNFLRRILFILCITSLYLSRDSLKLHAKNVLMDHNVAEYHGGMIDDIQILRCYHWYRQCSSLYAPKLHPSNTAKKIKDKNSILWTRVSKNITVETLYSLQSGPFYNSYLYVHLKDFQSNPKNTIKELAIARDSALIPLQVLRDINKLVKSSDSSVFHNHVYLREKPTSSWWKLLFGISVDTDNIAVFGEEWVYKGSGIWCKYILNDDDNDAPITNLEIYLGSSFIESRPSWKEVIHEFHRNNIPSLPISITRKLETKNHHHKFSNGLLGSLRTPSKDINIQVDADYKITSPHIQFSRGQRSFKILQITDFHFKCTDNSMTVINEIKTVNFIDRVLASENPDLVVITGDLLDSHNTIDYQTCIMKVVQPMISNKIPYAISLGVSDESNLATSAQIRDFIRNLPYTFNNVASEEGHMAIEVSFKKKLTKNTLLERDIDTEDETNPSEALFFVFDSFAPVNNFLQDYNDLIGKIDFGLAFQYFPLSEYRPHGLFPIIGQYNERSTLTVDTPRSRGQVSMTINGKHYKSFLDILSLWNIKGVSCGHEHNNDCCLQSKNEMWLCYGGSAGIGLPRIQGIYPTVRLFNLDDILDEITSWKRNSNLVDEVYDYQYIYKGKQ');
INSERT INTO proteininfo VALUES ('6324709', 'NP_014779.1','Subunit of mitochondrial NAD(+)-dependent isocitrate dehydrogenase, which catalyzes the oxidation of isocitrate to alpha-ketoglutarate in the TCA cycle; Idh2p [Saccharomyces cerevisiae]','MLRNTFFRNTSRRFLATVKQPSIGRYTGKPNPSTGKYTVSFIEGDGIGPEISKSVKKIFSAANVPIEWESCDVSPIFVNGLTTIPDPAVQSITKNLVALKGPLATPIGKGHRSLNLTLRKTFGLFANVRPAKSIEGFKTTYENVDLVLIRENTEGEYSGIEHIVCPGVVQSIKLITRDASERVIRYAFEYARAIGRPRVIVVHKSTIQRLADGLFVNVAKELSKEYPDLTLETELIDNSVLKVVTNPSAYTDAVSVCPNLYGDILSDLNSGLSAGSLGLTPSANIGHKISIFEAVHGSAPDIAGQDKANPTALLLSSVMMLNHMGLTNHADQIQNAVLSTIASGPENRTGDLAGTATTSSFTEAVIKRL');
INSERT INTO proteininfo VALUES ('6324708', 'NP_014777.1','Rho GTPase activating protein (RhoGAP), stimulates the intrinsic GTPase activity of Rho1p, which plays a role in actin cytoskeleton organization and control of cell wall synthesis; structurally and functionally related to Sac7p; Bag7p [Saccharomyces cerevisiae]','MFNMNLLSTPSSEEGSPQNRSSSMSSVEGKKDRDTFTNLQNEFDGKVFGVSLEESLKVAQEEVIIQKSTNEIGSIPVVIAKSGKYLKENALDTTGIFRIAGSNKRVRELQAVFSKPPDYGRKFEGWCDFNVHDIATLLKRYLNSLSEPLVPLALYDIFRNPILENPKINEHKEQIIKDYEDIYMLLPQQNRHLILYLAALLNLFARNEKKNLMSASNLAAIVQPSLLSHPKDEMCPKEYEASRTVIEFLILHASDIIPNTEKANKDTMPHAGTVAKFNNITVPEMAIDSDEEDFVHPSIDDHMLPRSRALSDSNNFTIHHHHHHHHALFPSPIDFDNNGLSVPRSFKGRTLSAESLSPRLSKLLGNVGNSSNTGIKDPTERVPRGEHKTKHKQRQSWLRRLTSPSRTQP');
INSERT INTO proteininfo VALUES ('6324707', 'NP_014776.1','Elongation factor 2 (EF-2), also encoded by EFT2; catalyzes ribosomal translocation during protein synthesis; contains diphthamide, the unique posttranslationally modified histidine residue specifically ADP-ribosylated by diphtheria toxin; Eft1p [Saccharomyces cerevisiae]','MVAFTVDQMRSLMDKVTNVRNMSVIAHVDHGKSTLTDSLVQRAGIISAAKAGEARFTDTRKDEQERGITIKSTAISLYSEMSDEDVKEIKQKTDGNSFLINLIDSPGHVDFSSEVTAALRVTDGALVVVDTIEGVCVQTETVLRQALGERIKPVVVINKVDRALLELQVSKEDLYQTFARTVESVNVIVSTYADEVLGDVQVYPARGTVAFGSGLHGWAFTIRQFATRYAKKFGVDKAKMMDRLWGDSFFNPKTKKWTNKDTDAEGKPLERAFNMFILDPIFRLFTAIMNFKKDEIPVLLEKLEIVLKGDEKDLEGKALLKVVMRKFLPAADALLEMIVLHLPSPVTAQAYRAEQLYEGPADDANCIAIKNCDPKADLMLYVSKMVPTSDKGRFYAFGRVFAGTVKSGQKVRIQGPNYVPGKKDDLFIKAIQRVVLMMGRFVEPIDDCPAGNIIGLVGIDQFLLKTGTLTTSETAHNMKVMKFSVSPVVQVAVEVKNANDLPKLVEGLKRLSKSDPCVLTYMSESGEHIVAGTGELHLEICLQDLEHDHAGVPLKISPPVVAYRETVESESSQTALSKSPNKHNRIYLKAEPIDEEVSLAIENGIINPRDDFKARARIMADDYGWDVTDARKIWCFGPDGNGPNLVIDQTKAVQYLHEIKDSVVAAFQWATKEGPIFGEEMRSVRVNILDVTLHADAIHRGGGQIIPTMRRATYAGFLLADPKIQEPVFLVEIQCPEQAVGGIYSVLNKKRGQVVSEEQRPGTPLFTVKAYLPVNESFGFTGELRQATGGQAFPQMVFDHWSTLGSDPLDPTSKAGEIVLAARKRHGMKEEVPGWQEYYDKL');
INSERT INTO proteininfo VALUES ('6324706', 'NP_014775.1','Peripheral membrane protein required for vacuolar protein sorting; Vps17p [Saccharomyces cerevisiae]','MTSAVPYDPYDDLDNNPFAEPQEEDSEPAATTTDGSSSMSEERVGTEQTAASVQDNGTANNIQNGLGEEGNATRSKTSNEHNENQQPSQPSERVILPERSDEKKKYTLLAKVTGLERFGSATGKKENPTIIFDCSTNLPTFRKQQYKNVKKSYEEFHQLFKYLNVAIQESFVPTLPSAYTTFGINSEEDRMKVTRNFQLWFNRLSQDPLIIRNEEVAFFIESDFNTYTPINKSKSLASGLKRKTLKQLAPPYDEITELAEFRPLVKSIYVVSQSLQEKLLRVSRNRKMMVQEENAFGQDFVNLDEHNKLYRRYGKILTAVGDIDSIIATMDMATLYDGLEWIVRDAYAVKEALTNRHFIMRNLVQAQQNSKAKQEQARRFRSRRDINPMKIDEALRQLKAAAKNEQVLTLKLQRITSNMIIERKQWISWYEEWIRSSIKEFTLRKIEYERKKLTLLERVRSDIRKADENGGLSRLGRHAVSNNNSDTSQTLKGDSWTGESNRKSQIPINKIAHTEFDDELFTEDDGYNSQDSDTTSLNARHAASLLGMSTK');
INSERT INTO proteininfo VALUES ('6324705', 'NP_014774.1','Hypothetical ORF; Yor131cp [Saccharomyces cerevisiae]','MTKLQGLQGLKHIKAVVFDMDGTLCLPQPWMFPAMRNAIGLEDKSIDILHFIDTLPTEKEKKEAHDRIELVEAKAMKEMQPQPGLVDIMRYLTKNGISKNICTRNVGAPVETFVKRFIPSELSRFDYIVTREFRPTKPQPDPLLHIASKLNIRPLEMIMVGDSFDDMKSGRSAGCFTVLLKNHVNGHLLLEHKELVDVSVEDLSEIIELIQNMNKESF');
INSERT INTO proteininfo VALUES ('6324704', 'NP_014773.1','Ornithine transporter of the mitochondrial inner membrane, exports ornithine from mitochondria as part of arginine biosynthesis; human ortholog is associated with hyperammonaemia-hyperornithinaemia-homocitrullinuria (HHH) syndrome; Ort1p [Saccharomyces cerevisiae]','MEDSKKKGLIEGAILDIINGSIAGACGKVIEFPFDTVKVRLQTQASNVFPTTWSCIKFTYQNEGIARGFFQGIASPLVGACLENATLFVSYNQCSKFLEKHTNVFPLGQILISGGVAGSCASLVLTPVELVKCKLQVANLQVASAKTKHTKVLPTIKAIITERGLAGLWQGQSGTFIRESFGGVAWFATYEIVKKSLKDRHSLDDPKRDESKIWELLISGGSAGLAFNASIFPADTVKSVMQTEHISLTNAVKKIFGKFGLKGFYRGLGITLFRAVPANAAVFYIFETLSAL');
INSERT INTO proteininfo VALUES ('6324703', 'NP_014772.1','Putative component of the outer plaque of the spindle pole body; may be involved in cation homeostasis or multidrug resistance; Yor129cp [Saccharomyces cerevisiae]','MLRRELNNSISNRSIENESFPFERPNVSYIISAEFDNKLGPILKHQYPKDIPGFNQFSHEQRNGNTSVSMNLASLMIPSSIERNPGKQDITVFTLYYNKFTQNYQLFPVPKDPRFSFNLHHREQSDGSVTNSIYYDAENHQDAKNNRYTIVLEDDELECQEVQNNQKAIDNEPLFFINVANTVLDTTNDRGAVIKSIAIGTPLKTFFAFKNIIVLVLDLYMKAPTQAAATDILLDCFNMLNSIDLTLINDIHSKSSIQEVLHSIHDESIITKVFLDPDSTLKKLFCINGFDTKDKYGNIVTFHDQLIQYHFTRFQPKTLPPFLLKIPLQFNMIRREPIYIENDYNELVLKFLDKFVPYLLKAGQKVNAWKLVINSTKLSKEDLCAFILSLANITATYASDPQSYFKGNAALIFPYMDISLVDGLRAYVASNSDFVGCFAIIGTANPIFRYQLDIWDYYYDVDEGVFYENNSPEKEKPDTVAEVKIGPNPLRKIFNRPHFSTNAVNESQVNLGQKLFSLLIDEYHDSDTIMSVLRRLNVLQLENLLDALKRREIPPNIALKDEYIMFYKDFFIFPEFFDYFTLHSIELLSNLDNCLFSLGNTCQLFSTEQIYSQLSQILDIVKELFRMVSVSRTNIEKFLNACLNYSPFKILPTAQLHGDNISRWSFESEVRQGFDNFNSYMGIEKDPHGVIVSAIDLFTQIYSFDILAFFLTFITKESGQDLPFTKSLSRRRTYLTRIAQSSSLRQFLQLSTRPNIRILGGNGQGTGNSNYPEFTNASSVISPKLRASPLLERRASKICYAITKLLYRLECHPIGMALLKKYLHNQLREAYLESKRHFISKKGDSTNTSSTIASSSFAGASVPLSSNESGMLNGLKQINEQQESTLETTQKED');
INSERT INTO proteininfo VALUES ('6324702', 'NP_014771.1','Phosphoribosylaminoimidazole carboxylase, catalyzes a step in the 'de novo' purine nucleotide biosynthetic pathway; red pigment accumulates in mutant cells deprived of adenine; Ade2p [Saccharomyces cerevisiae]','MDSRTVGILGGGQLGRMIVEAANRLNIKTVILDAENSPAKQISNSNDHVNGSFSNPLDIEKLAEKCDVLTIEIEHVDVPTLKNLQVKHPKLKIYPSPETIRLIQDKYIQKEHLIKNGIAVTQSVPVEQASETSLLNVGRDLGFPFVLKSRTLAYDGRGNFVVKNKEMIPEALEVLKDRPLYAEKWAPFTKELAVMIVRSVNGLVFSYPIVETIHKDNICDLCYAPARVPDSVQLKAKLLAENAIKSFPGCGIFGVEMFYLETGELLINEIAPRPHNSGHYTIDACVTSQFEAHLRSILDLPMPKNFTSFSTITTNAIMLNVLGDKHTKDKELETCERALATPGSSVYLYGKESRPNRKVGHINIIASSMAECEQRLNYITGRTDIPIKISVAQKLDLEAMVKPLVGIIMGSDSDLPVMSAACAVLKDFGVPFEVTIVSAHRTPHRMSAYAISASKRGIKTIIAGAGGAAHLPGMVAAMTPLPVIGVPVKGSCLDGVDSLHSIVQMPRGVPVATVAINNSTNAALLAVRLLGAYDSSYTTKMEQFLLKQEEEVLVKAQKLETVGYEAYLENK');
INSERT INTO proteininfo VALUES ('6324701', 'NP_014770.1','putative GTPase-activating protein for the polarity-establishment protein Cdc42p or Rho1p; activates the pheromone-response pathway; rho type GTPase activating protein; Rga1p [Saccharomyces cerevisiae]','MASTAPNEQFPSCVRCKEFITTGHAYELGCDRWHTHCFACYKCEKPLSCESDFLVLGTGALICFDCSDSCKNCGKKIDDLAIILSSSNEAYCSDCFKCCKCGENIADLRYAKTKRGLFCLSCHEKLLAKRKYYEEKKRRLKKNLPSLPTPVIDNGHTDEVSASAVLPEKTFSRPASLVNEIPSGSEPSKDIETNSSDIVPHFITGYNDSDDNSGSSKFGSNVSIDVIGPEENSTEHVNDDVKEEAEAPSANMSLNVATDPTLSCKEPPSHSRNLLNKTPLRNSSGQYLAKSPSSYRQGIIVNDSLEESDQIDPPNNSSRNASELLTSVLHSPVSVNMKNPKGSNTDIFNTGEISQMDPSLSRKVLNNIVEETNALQRPVVEVVKEDRSVPDLAGVQQEQAEKYSYSNNSGKGRKISRSLSRRSKDLMINLKSRATGKQDSNVKLSPASKVTSRRSQDLMRDNDSHTGLDTPNSNSTSLDILVNNQKSLNYKRFTDNGTLRVTSGKETALEEQKNHSFKSPSPIDHLLQSPATPSNVSMYRTPPLDSSLTFDRRNGSSYSNQNYSIPSWQKTPKTQLENSDNFEEQKETLYENSESRNDPSLDKEIVTAEHYLKQLKINLKELESQREELMKEITEMKSMKEALRRHIESYNSEKNKLYLDSNELSNNPPMINEISLGESPPVKHVATASSVARSSVKPKFWKFFSSAKPQTEQSIQGVSTNNTNSIVKSAPVLLSAPSSGSNSGRLEISPPVLQNPNEFSDVRLVPIENDANMGQSKDGEEYLDGSNLYGSSLVARCNYENNEIPMILSVCIDFIESDEENMRSEGIYRKSGSQLVIEEIEKQFSAWKVQQNTETPNILTEQDLNVVTGVLKRYLRKLPNPIFTFQIYEPLMRLVKSKKMMENLPFVGGKLSLEAKNSDTYMSSKSALKNILEDLPREHYRVLRVLSEHIEKVTRYSHWNRMTLYNLALVFAPGLIRDFSGEKDIIDMKERNYIVAFIFGNYKDILT');
INSERT INTO proteininfo VALUES ('6324700', 'NP_014769.1','Isoamyl acetate-hydrolyzing esterase, required in balance with alcohol acetyltransferase to maintain optimal amounts of isoamyl acetate, which is particularly important in sake brewing; Iah1p [Saccharomyces cerevisiae]','MDYEKFLLFGDSITEFAFNTRPIEDGKDQYALGAALVNEYTRKMDILQRGFKGYTSRWALKILPEILKHESNIVMATIFLGANDACSAGPQSVPLPEFIDNIRQMVSLMKSYHIRPIIIGPGLVDREKWEKEKSEEIALGYFRTNENFAIYSDALAKLANEEKVPFVALNKAFQQEGGDAWQQLLTDGLHFSGKGYKIFHDELLKVIETFYPQYHPKNMQYKLKDWRDVLDDGSNIMS');
INSERT INTO proteininfo VALUES ('6324698', 'NP_014767.1','Ubiquitin-specific protease that removes ubiquitin from ubiquitinated proteins, cleaves at the C terminus of ubiquitin fusions; capable of cleaving polyubiquitin and possesses isopeptidase activity; Ubp2p [Saccharomyces cerevisiae]','MPNEDNELQKAIENHHNQLLNQDKENADRNGSVIEDLPLYGTSINQQSTPGDVDDGKHLLYPDIATNLPLKTSDRLLDDILCDTIFLNSTDPKVMQKGLQSRGILKESMLSYSTFRSSIRPNCLGSLTDQVVFQTKSEYDSISCPKYNKIHVFQAVIFNPSLAEQQISTFDDIVKIPIYHLKVSVKVRQELERLKKHVGVTQFHSLDHLHEYDRVDLSTFDSSDPNLLDYGIYVSDDTNKLILIEIFKPEFNSPEEHESFTADAIKKRYNAMCVKNESLDKSETPSQVDCFYTLFKIFKGPLTRKSKAEPTKTIDSGNLALNTHLNPEWLTSKYGFQASSEIDEETNEIFTEYVPPDMVDYVNDLETRKIRESFVRKCLQLIFWGQLSTSLLAPNSPLKNTKSVKGMSSLQTSFSTLPWFHLLGESRARILLNSNEQTHSPLDAEPHFINLSVSHYYTDRDIIRNYESLSSLDPENIGLYFDALTYIANRKGAYQLIAYCGKQDIIGQEALENALLMFKINPKECNISELNEATLLSIYKYETSNKSQVTSNHLTNLKNALRLLAKYTKSDKLKFYVDHEPYRALSQAYDTLSIDESVDEDIIKTAYSVKINDSPGLKLDCDRALYTIAISKRSLDLFNFLTEECPQFSNYYGPEKLDYQEALKLLQVNENASDETILKIFKQKWFDENVYEPDQFLILRAALTKISIERNSTLITNFLLTGTIDPNSLPPENWPTGINNIGNTCYLNSLLQYYFSIAPLRRYVLEYQKTVENFNDHLSNSGHIRRIGGREISRGEVERSIQFIYQLRNLFYAMVHTRERCVTPSKELAYLAFAPSNVEVEFEVEGNKVVDQTGVLSDSKKETTDDAFTTKIKDTSLIDLEMEDGLNGDVGTDANRKKNESNDAEVSENEDTTGLTSPTRVAKISSDQLENALEMGRQQDVTECIGNVLFQIESGSEPIRYDEDNEQYDLVKQLFYGTTKQSIVPLSATNKVRTKVERFLSLLINIGDHPKDIYDAFDSYFKDEYLTMEEYGDVIRTVAVTTFPTILQVQIQRVYYDRERLMPFKSIEPLPFKEVIYMDRYADTENPLLLAKKKETEEMKQKLKVMKNRQRELLSRDDSGLTRKDAFLESIKLLESDTIKKTPLKIEAANDVIKTLRNNVQNIDNELMKLYNDINSLEEKISHQFDDFKEYGYSLFSVFIHRGEASYGHYWIYIKDRNRNGIWRKYNDETISEVQEEEVFNFNEGNTATPYFLVYVKQGQEGDIEPLKRILK');
INSERT INTO proteininfo VALUES ('6324697', 'NP_014766.1','Component of the Paf1 complex, which associates with RNA polymerase II and is involved in histone methylation; Leo1p [Saccharomyces cerevisiae]','MSSESPQDQPQKEQISNNVGVTTNSTSNEETSRSQDDNVKEVNGNDDTKEEEQEEDAELDDLFGDDNDDDDDDDVKKSETEKSDSDSDEDDEGENINHRSRHRESLGLDDDEAEEQAMYTRKFYGEDANNFSDQDETTHTFKEENVELVRHIIPSKANVNETASHNEIFYARIPNFLTIDPIPFDPPSFEAKVNERASNSASREDQLDDRLIDENTVRWRYSRDKDQHVFKESNTQIVQWSDGTYSLKVGEECTDILVNDTSNTFLTVSHDQQELIQCYEGGEIKKTLMFIPTSTNSKIHQKLSKAVIRRNQRQSKGPGTYIVSMDPEVEKKELERKQSQILRDRRRRQLKEKEKQESPDAAFETGFRKQNSPTTYGASRRNEYEEDDFLVDDDEEEEAAFDDEEDDNEEEEEEEDADEENASRLRNLKREGAAMYREEEEEEKDRSETKRRRVAVIEDDEDED');
INSERT INTO proteininfo VALUES ('6324696', 'NP_014765.1','profilin (actin-binding protein); Pfy1p [Saccharomyces cerevisiae]','MSWQAYTDNLIGTGKVDKAVIYSRAGDAVWATSGGLSLQPNEIGEIVQGFDNPAGLQSNGLHIQGQKFMLLRADDRSIYGRHDAEGVVCVRTKQTVIIAHYPPTVQAGEATKIVEQLADYLIGVQY');
INSERT INTO proteininfo VALUES ('6324694', 'NP_014763.1','Putative NADP(+) coupled glycerol dehydrogenase, proposed to be involved in an alternative pathway for glycerol catabolism; Gcy1p [Saccharomyces cerevisiae]','MPATLHDSTKILSLNTGAQIPQIGLGTWQSKENDAYKAVLTALKDGYRHIDTAAIYRNEDQVGQAIKDSGVPREEIFVTTKLWCTQHHEPEVALDQSLKRLGLDYVDLYLMHWPARLDPAYIKNEDILSVPTKKDGSRAVDITNWNFIKTWELMQELPKTGKTKAVGVSNFSINNLKDLLASQGNKLTPAANQVEIHPLLPQDELINFCKSKGIVVEAYSPLGSTDAPLLKEPVILEIAKKNNVQPGHVVISWHVQRGYVVLPKSVNPDRIKTNRKIFTLSTEDFEAINNISKEKGEKRVVHPNWSPFEVFK');
INSERT INTO proteininfo VALUES ('6324693', 'NP_014762.1','Essential protein that plays a role in cell cycle progression, has similarity to  C. elegans ZK632.3 protein; Rio1p [Saccharomyces cerevisiae]','MSLEDKFDSLSVSQGASDHINNQLLEKYSHKIKTDELSFSRAKTSKDKANRATVENVLDPRTMRFLKSMVTRGVIADLNGCLSTGKEANVYHAFAGTGKAPVIDEETGQYEVLETDGSRAEYAIKIYKTSILVFKDRERYVDGEFRFRNSRSQHNPRKMIKIWAEKEFRNLKRIYQSGVIPAPKPIEVKNNVLVMEFLSRGNGFASPKLKDYPYKNRDEIFHYYHTMVAYMRLLYQVCRLVHADLSEYNTIVHDDKLYMIDVSQSVEPEHPMSLDFLRMDIKNVNLYFEKMGISIFPERVIFQFVISETLEKFKGDYNNISALVAYIASNLPIKSTEQDEAEDEIFRSLHLVRSLGGLEERDFDRYTDGKFDLLKSLIAHDNERNFAASEQFEFDNADHECSSGTEEFSDDEEDGSSGSEEDDEEEGEYYDDDEPKVLKGKKHEDKDLKKLRKQEAKDAKREKRKTKVKKHIKKKLVKKTKSKK');
INSERT INTO proteininfo VALUES ('6324692', 'NP_014761.1','Hypothetical ORF; Yor118wp [Saccharomyces cerevisiae]','MGQSSSISSSNEEGSSHSKKFTNSKDILAYFNNKAQQQVTIPELVSFKGNLQIEDLNTPISHKALCNSLYFPQNHAMIVGIVTNMLRVLSNFPLMKSSYEPITGYGLLKCILLLNRARCAKFLKTKSYDQLKLLFISLSLQKTDKEELSEESENDGNKELTIKQIITGFDDVDTEMLCIPADFMLQFLTWLLILTVDCPTTNSKLDNTETHDQWGNFKVSALNLLRTMNPDVVGDIESHSITFQQFSTAIRTVMPNLLKPLENLMEHFFYLQHDLVDHDTNLSSIQDSKVMTPALLAQLSTGLPKELFIHKLQSLYIGRKSGFSMRSLQAKVFKWMAPSILVVSGMRITNSEEYAAEKNPRYRHFLEEFPKLKESDQMMDASHLNKRKTTFAVYIDDPWKVTNKDYFGDLNTRIIEISPRQDIYKVNQKGTIYFNTIGGGIGIGDKQPLIKPASKRYIPGNVSLTFDSTLEFAVFRNTGYGGSLDPGLLSMERKEENSPYELHFLIQDVEVWGCGGEKELEEQIKQLEWEEAESKRRQQINLRSLGEDRALLEMAGLVGQHQGGGSM');
INSERT INTO proteininfo VALUES ('6324691', 'NP_014760.1','Probable 26S protease subunit and member of the CDC48/PAS1/SEC18 family of ATPases; 26S protease regulatory subunit; Rpt5p [Saccharomyces cerevisiae]','MATLEELDAQTLPGDDELDQEILNLSTQELQTRAKLLDNEIRIFRSELQRLSHENNVMLEKIKDNKEKIKNNRQLPYLVANVVEVMDMNEIEDKENSESTTQGGNVNLDNTAVGKAAVVKTSSRQTVFLPMVGLVDPDKLKPNDLVGVNKDSYLILDTLPSEFDSRVKAMEVDEKPTETYSDVGGLDKQIEELVEAIVLPMKRADKFKDMGIRAPKGALMYGPPGTGKTLLARACAAQTNATFLKLAAPQLVQMYIGEGAKLVRDAFALAKEKAPTIIFIDELDAIGTKRFDSEKSGDREVQRTMLELLNQLDGFSSDDRVKVLAATNRVDVLDPALLRSGRLDRKIEFPLPSEDSRAQILQIHSRKMTTDDDINWQELARSTDEFNGAQLKAVTVEAGMIALRNGQSSVKHEDFVEGISEVQARKSKSVSFYA');
INSERT INTO proteininfo VALUES ('6324690', 'NP_014759.1','RNA polymerase III large subunit; Rpo31p [Saccharomyces cerevisiae]','MKEVVVSETPKRIKGLEFSALSAADIVAQSEVEVSTRDLFDLEKDRAPKANGALDPKMGVSSSSLECATCHGNLASCHGHFGHLKLALPVFHIGYFKATIQILQGICKNCSAILLSETDKRQFLHELRRPGVDNLRRMGILKKILDQCKKQRRCLHCGALNGVVKKAAAGAGSAALKIIHDTFRWVGKKSAPEKDIWVGEWKEVLAHNPELERYVKRCMDDLNPLKTLNLFKQIKSADCELLGIDATVPSGRPETYIWRYLPAPPVCIRPSVMMQDSPASNEDDLTVKLTEIVWTSSLIKAGLDKGISINNMMEHWDYLQLTVAMYINSDSVNPAMLPGSSNGGGKVKPIRGFCQRLKGKQGRFRGNLSGKRVDFSGRTVISPDPNLSIDEVAVPDRVAKVLTYPEKVTRYNRHKLQELIVNGPNVHPGANYLLKRNEDARRNLRYGDRMKLAKNLQIGDVVERHLEDGDVVLFNRQPSLHRLSILSHYAKIRPWRTFRLNECVCTPYNADFDGDEMNLHVPQTEEARAEAINLMGVKNNLLTPKSGEPIIAATQDFITGSYLISHKDSFYDRATLTQLLSMMSDGIEHFDIPPPAIMKPYYLWTGKQVFSLLIKPNHNSPVVINLDAKNKVFVPPKSKSLPNEMSQNDGFVIIRGSQILSGVMDKSVLGDGKKHSVFYTILRDYGPQEAANAMNRMAKLCARFLGNRGFSIGINDVTPADDLKQKKEELVEIAYHKCDELITLFNKGELETQPGCNEEQTLEAKIGGLLSKVREEVGDVCINELDNWNAPLIMATCGSKGSTLNVSQMVAVVGQQIISGNRVPDGFQDRSLPHFPKNSKTPQSKGFVRNSFFSGLSPPEFLFHAISGREGLVDTAVKTAETGYMSRRLMKSLEDLSCQYDNTVRTSANGIVQFTYGGDGLDPLEMEGNAQPVNFNRSWDHAYNITFNNQDKGLLPYAIMETANEILGPLEERLVRYDNSGCLVKREDLNKAEYVDQYDAERDFYHSLREYINGKATALANLRKSRGMLGLLEPPAKELQGIDPDETVPDNVKTSVSQLYRISEKSVRKFLEIALFKYRKARLEPGTAIGAIGAQSIGEPGTQMTLKTFHFAGVASMNVTLGVPRIKEIINASKVISTPIINAVLVNDNDERAARVVKGRVEKTLLSDVAFYVQDVYKDNLSFIQVRIDLGTIDKLQLELTIEDIAVAITRASKLKIQASDVNIIGKDRIAINVFPEGYKAKSISTSAKEPSENDVFYRMQQLRRALPDVVVKGLPDISRAVINIRDDGKRELLVEGYGLRDVMCTDGVIGSRTTTNHVLEVFSVLGIEAARYSIIREINYTMSNHGMSVDPRHIQLLGDVMTYKGEVLGITRFGLSKMRDSVLQLASFEKTTDHLFDAAFYMKKDAVEGVSECIILGQTMSIGTGSFKVVKGTNISEKDLVPKRCLFESLSNEAALKAN');
INSERT INTO proteininfo VALUES ('6324689', 'NP_014758.1','Component of the targeting complex (TRAPP) involved in ER to Golgi membrane traffic; Trs33p [Saccharomyces cerevisiae]','MSSTHSNNVGHPQSSPQGPLTEQQRAQQQYQIFENSLPKVSQSVYQMLLNEMVPLAMGIERQISGDVISSDSNVTSENGNINNMIKRLKIEEHHTVDIIRSHNLIHELYKADEEEKEKVLARLRNIGFQIGLKLSELLIFSNNPNLKFKEMDLLLIMKFICRDVWKQIFGKQIDNLKTNHRGTFYLLDYDYRPIQSFSLEEDAKNEELKMIEPFLEIPVGIIRGVLSSLGYSSEEVICLASFIDRPTDRPKTAFPKGVSFHVQVTMPQ');
INSERT INTO proteininfo VALUES ('6324688', 'NP_014757.1','Hypothetical ORF; Yor114wp [Saccharomyces cerevisiae]','MKATLLLKAQLSPVSYTTKKSFQRQLNRTPYTAFQYFFQLEVQKLHNVSKYEDIINHVRGNSNFKRFARNEWDSMSLTKKRLYYASFCQSMDIDILNVSKIELAKRLEIPIPAMSEYLLFRNKFKVKFDSHCSSLERKDRKSVPRPSITRKVATTEICSKSRSNTPVGKINPRKRLVALKRISRSENTAKNHSHEAQNYLYDYMKRFQQMCKECRYAWNEEVDYDQKLEIRKKLQVWRAKFEEMMDNEIQILQKNMDIMSKFGLRSESYLTAANHDTNTQPNNILPMTYLLKKK');
INSERT INTO proteininfo VALUES ('6324687', 'NP_014756.1','Zinc-finger transcription factor, involved in induction of CLN3 transcription in response to glucose; genetic and physical interactions indicate a possible role in mitochondrial transcription or genome maintenance; Azf1p [Saccharomyces cerevisiae]','MPPPTAQFMGPTQAGQNESQNQSSGEAGEQNQEHGQGPTPILNQSQPASSQPQHQQQRNESISYYTNFNQPRYSTDASINSFLNISDNVPVTSTGGPSSGGAYSNLPRLSTSSTHQPPDLSQIGRGFSIVNNLFPQQQQLQNQHRQQQQQQQQQSHQQPPFKTPSFSTGLTGSSSQYQFLPRNDNTSQPPSKRNSVYLGPNDGPDFEFFSMQQSQQPQFQPSSRRESNSMRPPLLIPAATTKSQSNGTNNSGNMNTNADYESFFNTGTNNSNSNQNPYFLSSRNNSLKFNPEDFDFQFKRRNSFVRGTLDHSSQNAFIPESRLNSLSVNNKANGDPVADNVTNNMKGKSNEVDNDDGNDSSNNNNNNNNNNNNENNNDNNNDNNDNSINSATSTNIPNQEDHSLASTDTTSNSRKDLKEIEQRLRKHLNDEDNYSSAISRPLDKNDVIEGSEGLNKHIDESGMQPNIIKKRKKDDSTVYVKNEMPRTDPPMSKDNSTSAEGAAMANFSGKEPPIPDISSVSDDATNLIGATKVDQLMLIIQARKKGFTEKVNTTQDGDLLFNQTMDILPPKSELVGGVEKPKGTQNTRAVKKHECPYCHRLFSQATHLEVHVRSHIGYKPFVCDYCGKRFTQGGNLRTHERLHTGEKPYSCDICDKKFSRKGNLAAHLVTHQKLKPFVCKLENCNKTFTQLGNMKAHQNRFHKETLNALTAKLAEMNPSENIPLEERQLLEYFASIYKNSNRGIKGRGKGVGTKKSTISSPENHPASTILNPNTNANNAIANDSENNGNPEGNIDSSSNSNPGSHSMISPTQKDMGTLQSQFIQNNFNNSVNSSNPSNQPIINYNYTTLPHSRLGSSSSSNTNNNNSNFSVGAAPGVLMAPTTNNDFSFNLDQSNDNERSQQEQVRFKNINYKS');
INSERT INTO proteininfo VALUES ('6324686', 'NP_014755.1','Hypothetical ORF; Yor112wp [Saccharomyces cerevisiae]','MNFSSIFKSISNFQFPYTIEETAITETALWQCFDGTRKADSLPVTVFKAKRSPENESLILNAVHKSKILKIPGLCTVLETFDSDPQSTFIVTERVVPFPWDNLGSLSQNKFGVELGISQLLATLGFLKNFVLGTLSKDSVFINIKGEWVLFGLELCSSKEGLSAFEFASRARSYYNIIGSQLPCEDPNTIDSMGLGLLIKSLMAPSCLPKDWIVNVNMISDGKITIENFRKRLENTETWRSNPLINFYQELRELHIKDPQGKLVVMSNLENLYLESREIFRNLTPGMIENFIIPELCEIIKLLMTQSISSAASPIGMNFNASHKLVPFLAIVLDLTSETNTFPVGFNDLITQSFKLPDRQVRFLLLIYLPKLIGPLSKSEISSRIYPHFIQGLTDSDATLRLQTLKTIPCIVSCLTERQLNNELLRFLAKTQVDSDVEIRTWTVIIISKISTILSTSVGNRSNILATAFTKSLKDPQVKPRLAALYGLEKSIELFDVNTIANKILTVIAPGLLDKSPIVRGRAKILFEEYLEKLEKEAQLIQTNDSTADSEDVKDIDFENYGCDEEDMNKEDNLLAAQFLNNLRLNSPSATTPSNITESEIDSAQDGSGWDDLSDTDGFITNGTTESFDETTNPVTTASTPKLFGKPIKINKSWNDELNDDGWIQDESGPSKVPQKHTRPQNSTLAKSIAPSSRLSIKKKKTTILAPRNIASNSTVTTKSSLSNKTARSKPISSIRGSVTKKGNVDGWDDDGDSDSWDTNW');
INSERT INTO proteininfo VALUES ('6324685', 'NP_014754.1','Hypothetical ORF; Yor111wp [Saccharomyces cerevisiae]','MSGNSQLPPDVIGFICSKYDIILASTSPRRYEILHDIMGITDLKTMVSTFEENLDKMNYSTDPIGYVCDTSWHKAQNIIEILTDYEDENPNEIDKPKLIICADTIIIDKSGRIYEKPKTKEVQKKFLMKFCYEDDEPVNVVTAVTLIKWYGRENFELVPFRDETKVYFDNKIPLRILEEYVESGDGLEVGGGFKIQGQGAILIEKIEGDYYNVVGLPLNKTFKGLYAEANSI');
INSERT INTO proteininfo VALUES ('6324684', 'NP_014753.1','Transcription factor for RNA polymerase III; 55 kDa subunit of TFIIIC (tau55); Tfc7p [Saccharomyces cerevisiae]','MVVNTIYIARHGYRSNWLPEGPYPDPLTGIDSDVPLAEHGVQQAKELAHYLLSLDNQPEAAFASPFYRCLETVQPIAKLLEIPVYLERGIGEWYRPDRKPVIPVPAGYEILSKFFPGVISQEWDSTLTPNEKGETEQEMYMRFKKFWPLFIERVEKEYPNVECILLVTHAASKIALGMSLLGYDNPRMSLNENGDKIRSGSCSLDKYEILKKSYDTIDETDDQTSFTYIPFSDRKWVLTMNGNTEFLSSGEEMNWNFDCVAEAGSDADIKKRQMTKKTSSPIPEADDQTEVETVYISVDIPSGNYKERTEIAKSAILQYSGLETDAPLFRIGNRLYEGSWERLVGTELAFPNAAHVHKKTAGLLSPTEENETTNAGQSKGSSTANDPNIQIQEEDVGLPDSTNTSRDHTGDKEEVQSEKIYRIKERIVLSNVRPM');
INSERT INTO proteininfo VALUES ('6324683', 'NP_014752.1','Phosphatidylinositol 4,5-bisphosphate 5-phosphatase, synaptojanin-like protein with an N-terminal Sac1 domain, plays a role in a TGN (trans Golgi network)-to-early endosome pathway; hyperosmotic stress causes translocation to actin patches; Inp53p [Saccharomyces cerevisiae]','MIIFVSEEPERRLAIVSNLYALVLKPVGKKPSDKPLCAIELLQKNDLKKYGFKRLTSHEIFGVIGLIEVNGLLFVGAITGKSKVAQPCPGETVNKIFAVDFFCLNDNSWDFIEIDSSGYPVLPETASTEYQDALPKHPCYELKKLLSNGSFYYSSDFDLTSTLQHRGYGQHSLSTDTYEEEYMWNSFLMQEMITYRDHLDTNLKQILDDEGFLTTVIRGFAETFVSYVKKLKVALTIISKQSWKRAGTRFNARGVDDEANVANFVETEFIMYSSQYCYAFTQIRGSIPVFWEQGTSLINPRVQITRSFEATQPVFDKHIMKSVEKYGPVHVVNLLSTKSSEIELSKRYKEHLTHSKKLNFNKDIFLTEFDFHKETSQEGFSGVRKLIPLILDSLLSSGYYSYDVREKKNISEQHGIFRTNCLDCLDRTNLAQQIISLAAFRTFLEDFRLISSNSFIDDDDFVSKHNTLWADHGDQISQIYTGTNALKSSFSRKGKMSLAGALSDATKSVSRIYINNFMDKEKQQNIDTLLGRLPYQKAVQLYDPVNEYVSTKLQSMSDKFTSTSNINLLIGSFNVNGATKKVDLSKWLFPIGEKFKPDIVVLGLQEVIELSAGSILNADYSKSSFWENLVGDCLNQYDDKYLLLRVEQMTSLLILFFVKADKAKYVKQVEGATKKTGFRGMAGNKGAVSIRFEYGATSFCFVNSHLAAGATNVEERRSDYESIVRGITFTRTKMIPHHDSIFWLGDMNYRINLPNEDVRRELLNQEEGYIDKLLHFDQLTLGINSGSVFEGFKEPTLKFRPTYKYDPGTGTYDSSEKERTPSWTDRIIYKGENLLPLSYSDAPIMISDHRPVYAAYRAKITFVDDKERLSLKKRLFTEYKQEHPEEPGSLISDLLSLDLDNKSTDGFKSSSESSLLDIDPIMAQPTASSVASSSPVSSASASLQPVRTQNSSQSRTPIKKPVLRPPPPPAHKSVSAPAPSTSKEKSPTPQTSTASLSSVTKNIQENKPLAQNRRIPPPGFSQNILTPKSTSNLASPMSSKVDLYNSASESTRSAQDARQQTPTAFAASRDVNGQPEALLGDENPIEPEEKAKLNHMTLDSWQPLTPK');
INSERT INTO proteininfo VALUES ('6324682', 'NP_014751.1','Alpha-isopropylmalate synthase II (2-isopropylmalate synthase), catalyzes the first step in the leucine biosynthesis pathway; the minor isozyme, responsible for the residual alpha-IPMS activity detected in a leu4 null mutant; Leu9p [Saccharomyces cerevisiae]','MVKHSFIALAEHASKLRRSIPPVKLTYKNMLRDPSVKYRAFAPPKMVKRIWPDKTIQKAPRWLSTDLRDGNQSLPDPMSVAQKKEYFHKLINIGFKEIEVSFPSASQTDFDFTRYAVENAPDDVGIQCLVQSREHLIKRTVEALTGAKRATIHTYLATSDMFREIVFNMSREEAISKAVEATKLVRKLTKDDPSQQATRWSYEFSPECFSDTPGEFAVEICEAVKKAWEPTEENPIIFNLPATVEVASPNVYADQIEYFSTHITEREKVCISTHCHNDRGCGVAATELGMLAGADRVEGCLFGNGERTGNVDLVTVAMNMYTQGVSPNLDFSDLTSISEIVHRCNKIPIPPRAPYGGELVVSAFSGSHQDAIKKGFAIQNKKQAQGETRWRIPYLPLDPKDIGRDYEAVIRVNSQSGKGGAAWVIMRSLGLDVPRPMQVDFSNTLQKNADALGRELKSEEITKLFKETYNYNNNEHIYVTLLNYEVKKLNPERRALVGQVEINDKVVNIEGYGNGPISSLVDALSNLLNVKLSVQNYSEHSLGSGSATQAASFINLSYIKDINNHATSNMWGVGVSEDTGDASIKAVFATVNNIIHSGDVLLAE');
INSERT INTO proteininfo VALUES ('6324681', 'NP_014750.1','Regulator of G-protein Signalling for gpa2; belongs to the RGS protein family and acts on Gpa2; GTPase activating protein for Gpa2; Rgs2p [Saccharomyces cerevisiae]','MASVPSLCDILIPLEKNSRSDGDAESSNTVLIQLRKGHHERMRSPYTIQKFYKFLKRAHCEENLEFFEKAHQFLQLKQNRSISEEKLLEVWNKSLYIKYIAVDSPKECNFSQDTREIFEKCFANNEVPADVDVLCAISHVMGLLMDGYHRFVSSVNEKKYSATYAHNDSATEQDLKNESTTSFSSLGVEDISEDRNSYLKKPDINGLSTIIQETSANTTNESQCSDRTSRPSESSSSLNTTSSTYKNTSTRNLQKPQNTGILNSGKGLLQKLNFVKKRKSFKQPSGVICSHYNSNVQNRLKGQNSHQQR');
INSERT INTO proteininfo VALUES ('6324680', 'NP_014749.1','Syntaxin-related protein; required for vacuolar assembly; PEP12 homolog; member of the syntaxin family of proteins; predicted C-terminal TMD; Vam3p [Saccharomyces cerevisiae]','MSFFDIEAQSSKGNSQQEPQFSTNQKTKELSNLIETFAEQSRVLEKECTKIGSKRDSKELRYKIETELIPNCTSVRDKIESNILIHQNGKLSADFKNLKTKYQSLQQSYNQRKSLFPLKTPISPGTSKERKDIHPRTEAVRQDPESSYISIKVNEQSPLLHNEGQHQLQLQEEQEQQQQGLSQEELDFQTIIHQERSQQIGRIHTAVQEVNAIFHQLGSLVKEQGEQVTTIDENISHLHDNMQNANKQLTRADQHQRDRNKCGKVTLIIIIVVCMVVLLAVLS');
INSERT INTO proteininfo VALUES ('6324678', 'NP_014747.1','[PSI+] induction; Pin2p [Saccharomyces cerevisiae]','MNVCKLKEIVPLFPRSSFTDGVVSTGKSFRSWDTCMDNKACKIIAIVGIVLACILVIWLIGGLLTCFRQGVTGIGQFICWCCRCSNDRNGNNTMPVNEGFSRVNMGVAPPSTVIYQPIQQPESAYYRNDAKNDTFYDEVKTPSNEVYELEEDFDLEKQKEKTRKKQQKERNKEGRSPSRVAPLVYEEENFEGSSPQPQYDARNSFIQNAANTGSNNAHVASQSPIFDISDYGENYYYDNNNINNNLQGNSYNTPSSNHRSPYPTENYQSYQGYKPNQSDRYY');
INSERT INTO proteininfo VALUES ('6324675', 'NP_014744.1','ras proto-oncogene homolog; Ras1p [Saccharomyces cerevisiae]','MQGNKSTIREYKIVVVGGGGVGKSALTIQFIQSYFVDEYDPTIEDSYRKQVVIDDKVSILDILDTAGQEEYSAMREQYMRTGEGFLLVYSVTSRNSFDELLSYYQQIQRVKDSDYIPVVVVGNKLDLENERQVSYEDGLRLAKQLNAPFLETSAKQAINVDEAFYSLIRLVRDDGGKYNSMNRQLDNTNEIRDSELTSSATADREKKNNGSYVLDNSLTNAGTGSSSKSAVNHNGETTKRTDEKNYVNQNNNNEGNTKYSSNGNGNRSDISRGNQNNALNSRSKQSAEPQKNSSANARKESSGGCCIIC');
INSERT INTO proteininfo VALUES ('6324674', 'NP_014743.1','Mitochondrial inner membrane carnitine transporter, required for carnitine-dependent transport of acetyl-CoA from peroxisomes to mitochondria during fatty acid beta-oxidation; Crc1p [Saccharomyces cerevisiae]','MSSDTSLSESSLLKEESGSLTKSRPPIKSNPVRENIKSFVAGGVGGVCAVFTGHPFDLIKVRCQNGQANSTVHAITNIIKEAKTQVKGTLFTNSVKGFYKGVIPPLLGVTPIFAVSFWGYDVGKKLVTFNNKQGGSNELTMGQMAAAGFISAIPTTLVTAPTERVKVVLQTSSKGSFIQAAKTIVKEGGIASLFKGSLATLARDGPGSALYFASYEISKNYLNSRQPRQDAGKDEPVNILNVCLAGGIAGMSMWLAVFPIDTIKTKLQASSTRQNMLSATKEIYLQRGGIKGFFPGLGPALLRSFPANAATFLGVEMTHSLFKKYGI');
INSERT INTO proteininfo VALUES ('6324673', 'NP_014742.1','mannosyltransferase involved in O- and N-linked glycosylation; type 2 membrane protein; probable secretory protein; Ktr1p [Saccharomyces cerevisiae]','MAKIMIPASKQPVYKKLGLLLVAVFTVYVFFHGAQYARGSAPSPKYSTVLSSGSGYKYSKVELPKYTGPREKATFVTLVRNRDLYSLAESIKSVEDRFNSKFNYDWVFLNDEEFTDEFKNVTSALVSGTTKYGVIPKEHWSFPEWIDEEKAAQVRKEMGEKRIIYGDSISYRHMCRFESGFFYRHPLMDDYDWYWRVEPDIKLHCDIDYDVFKFMKDNKKKYAFAISIKEYEATIPTLWETTRKFMEAHPELIHENNMLDFVSDDQGLSYNLCHFWSNFEIAALDLWRSPAYSAYFDYLDREGGFFYERWGDAPVHSIGAALFLDRSEIHHFGDIGYYHVPFHSCPIDTSIRLANKCDCDPSKDFTWHSYSCTTKFYNINKLPKPAGWQNHIG');
INSERT INTO proteininfo VALUES ('6324672', 'NP_014741.1','Nuclear pore complex (NPC) subunit, involved in protein import/export and in export of RNAs, possible karyopherin release factor that accelerates release of karyopherin-cargo complexes after transport across NPC; potential Cdc28p substrate; Nup1p [Saccharomyces cerevisiae]','MSSNTSSVMSSPRVEKRSFSSTLKSFFTNPNKKRPSSKKVFSSNLSYANHLEESDVEDTLHVNKRKRVSGTSQHSDSLTQNNNNAPIIIYGTENTERPPLLPILPIQRLRLLREKQRVRNMRELGLIQSTEFPSITSSVILGSQSKSDEGGSYLCTSSTPSPIKNGSCTRQLAGKSGEDTNVGLPILKSLKNRSNRKRFHSQSKGTVWSANFEYDLSEYDAIQKKDNKDKEGNAGGDQKTSENRNNIKSSISNGNLATGPNLTSEIEDLRADINSNRLSNPQKNLLLKGPASTVAKTAPIQESFVPNSERSGTPTLKKNIEPKKDKESIVLPTVGFDFIKDNETPSKKTSPKATSSAGAVFKSSVEMGKTDKSTKTAEAPTLSFNFSQKANKTKAVDNTVPSTTLFNFGGKSDTVTSASQPFKFGKTSEKSENHTESDAPPKSTAPIFSFGKQEENGDEGDDENEPKRKRRLPVSEDTNTKPLFDFGKTGDQKETKKGESEKDASGKPSFVFGASDKQAEGTPLFTFGKKADVTSNIDSSAQFTFGKAATAKETHTKPSETPATIVKKPTFTFGQSTSENKISEGSAKPTFSFSKSEEERKSSPISNEAAKPSFSFPGKPVDVQAPTDDKTLKPTFSFTEPAQKDSSVVSEPKKPSFTFASSKTSQPKPLFSFGKSDAAKEPPGSNTSFSFTKPPANETDKRPTPPSFTFGGSTTNNTTTTSTKPSFSFGAPESMKSTASTAAANTEKLSNGFSFTKFNHNKEKSNSPTSFFDGSASSTPIPVLGKPTDATGNTTSKSAFSFGTANTNGTNASANSTSFSFNAPATGNGTTTTSNTSGTNIAGTFNVGKPDQSIASGNTNGAGSAFGFSSSGTAATGAASNQSSFNFGNNGAGGLNPFTSATSSTNANAGLFNKPPSTNAQNVNVPSAFNFTGNNSTPGGGSVFNMNGNTNANTVFAGSNNQPHQSQTPSFNTNSSFTPSTVPNINFSGLNGGITNTATNALRPSDIFGANAASGSNSNVTNPSSIFGGAGGVPTTSFGQPQSAPNQMGMGTNNGMSMGGGVMANRKIARMRHSKR');
INSERT INTO proteininfo VALUES ('6324671', 'NP_014740.1','Hypothetical ORF; Yor097cp [Saccharomyces cerevisiae]','MDLKRDWLRWKITIGSGPGSIVLDFPSFLVGCVFTTMMGPILQKLIGKLLVGLITVCKFLVIIGSIVFVIGVASKKYTYDDFKVSIKRSGEPGESHDMRTEPKRTAKTATVPMEKDEGVGSYNYFEIPITKETSTIPYINCDGTSSLRKPPNGPSSVGLSNSNRYENFINMARHK');
INSERT INTO proteininfo VALUES ('6324670', 'NP_014739.1','Protein component of the small (40S) ribosomal subunit, nearly identical to Rps7Bp; interacts with Kti11p; deletion causes hypersensitivity to zymocin; has similarity to rat S7 and Xenopus S8 ribosomal proteins; Rps7ap [Saccharomyces cerevisiae]','MSAPQAKILSQAPTELELQVAQAFVELENSSPELKAELRPLQFKSIREIDVAGGKKALAIFVPVPSLAGFHKVQTKLTRELEKKFQDRHVIFLAERRILPKPSRTSRQVQKRPRSRTLTAVHDKILEDLVFPTEIVGKRVRYLVGGNKIQKVLLDSKDVQQIDYKLESFQAVYNKLTGKQIVFEIPSETH');
INSERT INTO proteininfo VALUES ('6324669', 'NP_014738.1','Ribose-5-phosphate ketol-isomerase; Rki1p [Saccharomyces cerevisiae]','MAAGVPKIDALESLGNPLEDAKRAAAYRAVDENLKFDDHKIIGIGSGSTVVYVAERIGQYLHDPKFYEVASKFICIPTGFQSRNLILDNKLQLGSIEQYPRIDIAFDGADEVDENLQLIKGGGACLFQEKLVSTSAKTFIVVADSRKKSPKHLGKNWRQGVPIEIVPSSYVRVKNDLLEQLHAEKVDIRQGGSAKAGPVVTDNNNFIIDADFGEISDPRKLHREIKLLVGVVETGLFIDNASKAYFGNSDGSVEVTEK');
INSERT INTO proteininfo VALUES ('6324668', 'NP_014737.1','GTP-binding ADP-ribosylation factor; Arf3p [Saccharomyces cerevisiae]','MGNSISKVLGKLFGSKEMKILMLGLDKAGKTTILYKLKLNKIKTSTPTVGFNVETVTYKNVKFNMWDVGGQQRLRPLWRHYFPATTALIFVIDSSARNRMEEAKEELYSIIGEKEMENVVLLVWANKQDLKDAMKPQEVSDFLELEKNLKNQPWCVIGSNALSGQGLVEGLSWISNNTNVPKK');
INSERT INTO proteininfo VALUES ('6324667', 'NP_014736.1','Hypothetical ORF; Yor093cp [Saccharomyces cerevisiae]','MDFSIPPTLPLDLQSRLNELIQDYKDENLTRKGYETKRKQLLDKFEISQMRPYTPLRSPNSRKSKHLHRRNTSLASSITSLPNSIDRRHSIYRVTTINSTSANNTPRRRSKRYTASLQSSLPGSSDENGSVKDAVYNPMIPLLPRHTGAENTSSGDSAMTDSLPLILRGRFEHYDGQTAMISINSKGKETFITWDKLYLKAERVAHELNKSHLYKMDKILLWYNKNDVIEFTIALLGCFISGMAAVPVSFETYSLREILEIIKVTNSKFVLISNACHRQLDNLYSSSNHSKVKLVKNDVFQQIKFVKTDDLGTYTKAKKTSPTFDIPNISYIEFTRTPLGRLSGVVMKHNILINQFETMTKILNSRSMPHWKQKSQSIRKPFHKKIMATNSRFVILNSLDPTRSTGLIMGVLFNLFTGNLMISIDSSILQRPGGYENIIDKFRADILLNDQLQLKQVVINYLENPESAFSKKHKIDFSCIKSCLTSCTTIDTDVSEMVVHKWLKNLGCIDAPFCYSPMLTLLDFGGIFISIRDQLGNLENFPIHNSKLRLQNELFINREKLKLNEVECSITAMINSSSSFKDYLKLETFGFPIPDITLCVVNPDTNTLVQDLTVGEIWISSNHITDEFYQMDKVNEFVFKAKLNYSEMFSWAKYEMPTNEKSQAVTEQLDTILNICPANTYFMRTKLMGFVHNGKIYVLSLIEDMFLQNRLIRLPNWAHTSNLLYAKKGNQSAQPKGNTGAESTKAIDISSLSGETSSGYKRVVESHYLQQITETVVRTVNTVFEVAAFELQHHKEEHFLVMVVESSLAKTEEESKNGETTDTTLMKFAETQRNKLETKMNDLTDQIFRILWIFHKIQPMCILVVPRDTLPRRYCSLELANSTVEKKFLNNDLSAQFVKFQFDNVILDFLPHSAYYNESILSEHLSKLRKMALQEEYAMIEPAYRNGGPVKPKLALQCSGVDYRDESVDTRSHTKLTDFKSILEILEWRISNYGNETAFSDGTNTNLVNSSASNDNNVHKKVSWASFGKIVAGFLKKIVGSKIPLKHGDPIIIMCENSVEYVAMIMACLYCNLLVIPLPSVKESVIEEDLKGLVNIIQSYKVKRVFVDAKLHSLLNDNNVVNKCFKKYKSLIPKITVFSKVKTKNALTVSMFKNVLKQKFGAKPGTRIGMTPCVVWVNTEYDVTSNIHVTMTHSSLLNASKIVKETLQLRNNSPLFSICSHTSGLGFMFSCLLGIYTGASTCLFSLTDVLTDPKEFLIGLQNLNVKDLYLKLETLYALLDRASSLIEGFKNKKENINSAKNNTSGSLREDVFKGVRNIMIPFPNRPRIYTIENILKRYSTISLSCTQISYVYQHHFNPLISLRSYLDIPPVDLYLDPFSLREGIIREVNPNDVSAGNYIKIQDSGVVPVCTDVSVVNPETLLPCVDGEFGEIWCCSEANAFDYFVCNSSKNKLYKDPFITEQFKSKMKSEVNNTLSYLRTGDLGFIKNVSCTNSQGEVVNLNLLFVLGSIHESIEILGLTHFVSDLERTVKDVHSDIGSCLIAKAGGLLVCLIRCKERHNPILGNLTTLIVSELLNKHGVILDLCTFVRTKGISPKNSSMIMEVWAKNRASIMQAWFDQKIQIEAQFGINYGENISIYLLSDYEKDNI');
INSERT INTO proteininfo VALUES ('6324666', 'NP_014735.1','Non-essential protein of unknown function; Ecm3p [Saccharomyces cerevisiae]','MTHITLGQAIWASVRPIIKIYLIIGVGFGLCKMNILTVQATRSISDIVLTILLPCLSFNKIVANIEDNDIKDVGIICLTSVILFATGLGFAFIVRSVLPVPKRWRGGILAGGMFPNISDLPIAYLQSMDQGFIFTEAEGEKGVANVIIFLAMFLICVFNLGGFRLIENDFHYKGDDDEENTLTNDDSAQQPTQPIEGNSSSSSNQDILKEPNESTVPNSSQASYISEKNKKEKTELSVPKPTHTAPPAIDDRSSNSSAVVSIDSITHSLRTNHVDAQSVSELNDPTYRTRSQPIAYTTESRTSHVHNNRRNSITGSLRSIDMRELPAEGMSDLIREYSNVDQYGRRRKSSISSQGAPSVLQADGTISPNLTRTSTLQRVKTSNLTRIITSDATVSKKDIETSGSSLPKWLQKFPLTKFFVFFLKNCLRPCSMAVILALIIAFIPWVKALFVTTSNTPKIKQAPDNAPALTFIMDFTSYVGAASVPFGLILLGATLGRLKIGKLYPGFWKSAVVLVFLRQCIMPIFGVLWCDRLVKAGWLNWENDKMLLFVTAITWNLPTMTTLIYFTASYTPEDETEPVQMECTSFFLMLQYPLMVVSLPFLVSYFIKVQMKL');
INSERT INTO proteininfo VALUES ('6324665', 'NP_014734.1','Hypothetical ORF; Yor091wp [Saccharomyces cerevisiae]','MIMKKFLFPSDELVKIDNISFFNQCVLLFLESKGSHSISKPLGFTHIKSQESYISKMPPKKGKQAQAAGKKKDNVDKTFGMKNKNRSTKVQKYIKQVQSQSDPKKEEMRLKKLEEKKRREAEEAERRALFNPVADQRVRAGVDPKSMVCALFKLGNCNKGAKCKFSHDLNVGRRMEKKDLYQDTRSEKENDTMDNWDEEKLRKVILSKHGNPKTTTDKVCKYFIEAVENGKYGWFWICPNGGDKCMYRHSLPEGFVLKTNEQKRLERESLEKQPKITLEEFIETERGKLDKSKLTPITIANFAQWKKDHVIAKINAEKKLSSKRKPTGREIILKMSAENKSFETDNADMPDDVTQGSAWDLTEFTDALKKADHQDDGGIKDYGDGSNPTFDIKKANSATLA');
INSERT INTO proteininfo VALUES ('6324664', 'NP_014733.1','Phosphatase type Two C; Type 2C Protein Phosphatase; Ptc5p [Saccharomyces cerevisiae]','MSPLTRTVAIKKTVKVLSKCQSGREYTQKFLQRAYSTSHANSTYYSRTKLFISSHSKALNIALLSGSLLLTYSYYSPKKILSLDTINGIKDYSTNTSGNINMPSPNPKGTETQKSQRSQNDQSVLILNDSKIEAKLHDREESHFVNRGTGIFRYDVAQLPSNHPIEDDHVEQIITIPIESEDGKSIEKDLYFFGIFDGHGGPFTSEKLSKDLVRYVAYQLGQVYDQNKTVFHSDPNQLIDSAISKGFLKLDNDLVIESFRKLFQDPNNTNIANTLPAISGSCALLSLYNSTNSILKVAVTGDSRALICGLDNEGNWTVKSLSTDQTGDNLDEVRRIRKEHPGEPNVIRNGRILGSLQPSRAFGDYRYKIKEVDGKPLSDLPEVAKLYFRREPRDFKTPPYVTAEPVITSAKIGENTKFMVMGSDGLFELLTNEEIASLVIRWMDKNMNLAPVKAEPGKLPKVIDVSEDKEAQRPAFRYKDNNSSSPSGSNPEYLIEDKNVATHLIRNALSAGGRKEYVSALVSIPSPMSRRYRDDLTVTVAFFGDSGTPSIVSNATSIVMNPEATTKPKPRL');
INSERT INTO proteininfo VALUES ('6324663', 'NP_014732.1','Rab5-like GTPase involved in vacuolar protein sorting and endocytosis post vesicle internalization; geranylgeranylated; geranylgeranylation required for membrane association; Vps21p [Saccharomyces cerevisiae]','MNTSVTSIKLVLLGEAAVGKSSIVLRFVSNDFAENKEPTIGAAFLTQRVTINEHTVKFEIWDTAGQERFASLAPMYYRNAQAALVVYDVTKPQSFIKARHWVKELHEQASKDIIIALVGNKIDMLQEGGERKVAREEGEKLAEEKGLLFFETSAKTGENVNDVFLGIGEKIPLKTAEEQNSASNERESNNQRVDLNAANDGTSANSACSC');
INSERT INTO proteininfo VALUES ('6324660', 'NP_014729.1','Contains three calcium and lipid binding domains; green fluorescent protein (GFP)-fusion protein localizes to the cell periphery; C-terminal portion of Tcb1p, Tcb2p and Tcb3p interact; Tcb1p [Saccharomyces cerevisiae]','MAKEDTGVTAPKKPETAQVANINGIDKLEPPKTKEETESSKSVSSEKAAHASDESFKRSIHEASYVGWKQIGGWEDKDELTLDDELMDMTRETFLDNIIPDSLYGDWYHSVAIFFIGGVASFALGHYKFSMGSAFFVIVITSLLYRTSAKKYRGSIRELVQKEFTVQKVENDYESLEWLNAFLDKYWPILEPSVSQLIVQQANEQMATNEAIPKFITQLWIDELTLGVKPPRVDLVKTFQNTASDVVVMDWGISFTPHDLCDMSAKQVRNYVNELAVVKAKIFGITIPVSVSDIAFKAHARVKFKLMTPFPHVETVNIQLLKVPDFDFVATLFGRSIFNWEILAIPGLMTLIQKMAKKYMGPILLPPFSLQLNIPQLLSGSNLSIGILEITVKNAKGLKRTSSILNESIDPYLSFEFNDISIAKTRTVRDTLNPVWDETLYVLLNSFTDPLTISVYDKRAKLKDKVLGRIQYNLNTLHDKTTQRNLKAQFLRNSKPVGELTFDLRFFPTLEEKKLPDGSVEELPDLNTGIAKVVVEEGSRFAEEEQKVTAYVEVYLNAKLVLTTGKATDTGTLKWNSDYEAVIADRRKTRYKFVVKDGKGEEIGSTIQTLNDLIDRSQVNKNLIPLKNQKGDIKITTYWRPVRLEIGSNSVAYTPPIGAIRVFIEKANDLRNLEKFGTIDPYCKVLVNGLSKGRTDFKSQTLNPVWNQVIYVAVTSPNQRITLQCMDVETVNKDRSLGEFNVNVQDLFKKDENDKYEETIDEKAKVGRLVMPKKKPKGTITYYTSFYPALPVLTLEEIQDLDKVNKKKKALELRKSAIDEKKISKEDKAKFDQEWNEVKELEDMYSNRQKLDLPELLQYNQGVLAVTVLNGELPDSGLYVQAFFDDNGHPRFVSPRIPSRIVKNGWSGDVIIKELDKSITTFRVAKNKNYNRVEKCVCEVELPTQELVKNCYYKPSILHLSGEGSAKLMLQISWFPIDTKQLPANDLITNSGDLTIMSRSAENLIASDLNGYSDPYLKYYINNEEDCAYKTKVVKKTLNPKWNDEGTIQINNRLNDVLRIKVMDWDSTSADDTIGTAEIPLNKVKVEGTTELDVPVEGLENAGQDGGMLHLAFSFKPRYTISVSKREKKVGDIASKGLGTGLKAGTTVIGGGVGAIGKIKKGVFGGLGSLTNHKKNHEMGEEETKF');
INSERT INTO proteininfo VALUES ('6324659', 'NP_014728.1','Gamma subunit of the oligosaccharyltransferase complex of the ER lumen, which catalyzes aspargine-linked glycosylation of newly synthesized proteins; Ost3p is important for N-glycosylation of a subset of proteins; Ost3p [Saccharomyces cerevisiae]','MNWLFLVSLVFFCGVSTHPALAMSSNRLLKLANKSPKKIIPLKDSSFENILAPPHENAYIVALFTATAPEIGCSLCLELESEYDTIVASWFDDHPDAKSSNSDTSIFFTKVNLEDPSKTIPKAFQFFQLNNVPRLFIFKPNSPSILDHSVISISTDTGSERMKQIIQAIKQFSQVNDFSLHLPMDWTPIITSTIITFITVLLFKKQSKLMFSIISSRIIWATLSTFFIICMISAYMFNQIRNTQLAGVGPKGEVMYFLPNEFQHQFAIETQVMVLIYGTLAALVVVLVKGIQFLRSHLYPETKKAYFIDAILASFCALFIYVFFAALTTVFTIKSPAYPFPLLRLSAPFK');
INSERT INTO proteininfo VALUES ('6324658', 'NP_014727.1','Putative lipase of the peroxisomal matrix; transcriptionally activated by Yrm1p along with genes involved in multidrug resistance; Yor084wp [Saccharomyces cerevisiae]','MEQNRFKKETKTCSASWPRAPQSTLCATDRLELTYDVYTSAERQRRSRTATRLNLVFLHGSGMSKVVWEYYLPRLVAADAEGNYAIDKVLLIDQVNHGDSAVRNRGRLGTNFNWIDGARDVLKIATCELGSIDSHPALNVVIGHSMGGFQALACDVLQPNLFHLLILIEPVVITRKAIGAGRPGLPPDSPQIPENLYNSLRLKTCDHFANESEYVKYMRNGSFFTNAHSQILQNIIDFERTKASGDDEDGGPVRTKMEQAQNLLCYMNMQTFAPFLISNVKFVRKRTIHIVGARSNWCPPQNQLFLQKTLQNYHLDVIPGGSHLVNVEAPDLVIERINHHIHEFVLTSPLQSSHIPQLTLEERAVMFDRAFDSFKNEALVKTTKQKL');
INSERT INTO proteininfo VALUES ('6324656', 'NP_014726.1','Protein that regulates the critical cell size required for passage through Start and commitment to cell division; may act upstream of SCB binding factor (SBF) and MCB binding factor (MBF); periodically expressed in G1; Whi5p [Saccharomyces cerevisiae]','MSLRTPKRSRTSDEQEQEQEQEQVQNPDTHVNNEHQQRPGPTTLLSTPVRLKNGFGTPSPPSPPGITKSITKSRRRPSTTSLQGIFMSPVNKRRVGITAHGRVYDHNDDGHESESEDDENEEENENQKKYDGHVSMPLLPPTTPKSRRSEVFLSPSPRLRSPPTAARRSTGERPIREISHTLRTRLNYALVKLQNGWTDKTLPELETELAPAVQTPPRRYHNRFPDSADAGTSAHTAFLQALGGHPPREEATAVETLMLLSSPTKKQQHRPVPATSAGEPTDETEPESDTEVETS');
INSERT INTO proteininfo VALUES ('6324655', 'NP_014724.1','Protein of unknown function, localizes to lipid particles; potential Cdc28p substrate; Stc2p [Saccharomyces cerevisiae]','MSNTLPVTEFLLSKYYELSNTPATDSSSLFKWLYHKTLSRKQLLISDLSSQKKHAISYDQWNDIASRLDDLTGLSEWKTIDESSLYNYKLLQDLTIRMRHLRTTHDYHRLLYLIRTKWVRNLGNMNNVNLYRHSHTGTKQIIHDYLEESQAVLTALIHQSNMNDHYLLGILQQTRRNIGRTALVLSGGSTFGLFHIGVLAALFESDLMPKVISGSSAGAIVASIFCVHTTQEIPSLLTNVLNMEFNIFNDDNSKSPNENLLIKISRFCQNGTWFNNQPLINTMLSFLGNLTFREAYNKTGKILNITVSPASIYEQPKLLNNLTAPNVLIWSAVCASCSLPGVFPSTPLFEKDPHTGKIKEWGATNLHLSNMKFMDGSVDNDMPISRLSEMFNVDHIIACQVNIHVFPLLKFSNTCVGGEIEKEITARFRNQVTKIFKFFSDETIHFLDILKELEFHPYLMTKLKHLFLQQYSGNVTILPDLSMVGQFHEVLKNPSQLFLLHQTTLGARATWPKISMIQNNCGQEFALDKAITFLKEKIIISSSIKNPLQFYQPRFSEQIKSLSIMDADLPGVDLEESSSNSLSIIKSPNKTAAPGRFPLQPLPSPSSTFNKRKMDMLSPSPSPSTSPQRSKSSFTQQGTRQKANSLSFAIGASSLRLKKSPLKVPSRPQFKKRSSYYNQNMSAEMRKNRKKSGTISSYDVQTNSEDFPIPAIENGSFDNTLFNPSRFPMDAMSAATNDNFMNNSDIFQN');
INSERT INTO proteininfo VALUES ('6324654', 'NP_014723.1','Protein of unknown function, involved in invasive and pseudohyphal growth; Dia2p [Saccharomyces cerevisiae]','MSYKFITKNKKYTPMSSPGNSGVAIDSTVLKAIELGTRLFKSGEYLQAKRIFTNALRVCDSYSQEQIMRIRNAYQLDTARPDNKRLYHPRYIKILDNICACYEKLNDLKSCLDVSQRLLKLEPGNIKCYIRCTRTLIKLKDWKRAYKTCSRGLQLCNNDSNHLRQQKQFIKNNMVQKQDGKRSYIDPLEETKIAKKKKNNNVLESLPKKKIKGSTKKTDLVGNLPIEILPIIFQRFTTKELVTLSLVCNKWRDKILYHLDCFQEFNLAPINFKNFVKFMDFLQQNFTRTYRKYILSQVKVSSRITSEELRITQLLFSKMPKCINIERLILSMPTLTTTQIFKLMVRGGTDFFTRLLELSLMITYRPDKQHELEILQTCPLLKKIELIFVNSLVPIFDGNNSVGRDGSFNVMARHTNMQISTADNDEQGIVEEKVIYSELEKITLICDKKKIKNFPLCRALLRGQFPLLQKLTITGVTFPMNNQDIMNFQWLLNFPDLKELWIEDNDNCELSKFLQLLKFSNVWKNLEKLTFRENKLYPIVNLDEDQPVTNDDEVPSMLFYKENLQNLEKLDLMGTSISGSALTRLCEQEYLDGRKLRSLNIGNCPNIQFPNNHAHTARMILDVNAVLKRLSKLEEINLSHLSSLNDSTMKSFIINVPFLENLKRLDISHNFEITGISIYEFLKKFQMDHDNEAGGQPLAYLNIDGCSQVSHITVNMIRAQNLVTQVDCVYERDVWRKFGINSYSYS');
INSERT INTO proteininfo VALUES ('6324653', 'NP_014722.1','Golgi membrane protein involved in manganese homeostasis; overproduction suppresses the sod1 (copper, zinc superoxide dismutase) null mutation; Atx2p [Saccharomyces cerevisiae]','MKFLGVILLASFLLIATFLIGLIPLYYIDKQKSSIVTNQEGADSISDFTTNADTQTINDDVSSYRVKIAVLSQFGIGMLLGTSFMLVIPEGIKACVEHDGNVGVNLLIGFLGVYVLDRLVTLWVSRKQTVYTHDAVKFQSWKDIINHPRQIWMNLIQNNVVFALFIHGLSDGIALGTTTNNDSLLIVVLIAIVIHKIPAVLSLTSLMVSRQNLMKWEVICNVFLFASSTPIGYIVLSLLNLSHSPTMDWISGNLLLMSGGSLLYASFTAFVGGDSHDHDLSVEQEVVLPHDESVYVLIGVCIPLVISYCISEE');
INSERT INTO proteininfo VALUES ('6324652', 'NP_014721.1','Component of small ribosomal subunit (SSU) processosome that contains U3 snoRNA; originally isolated as bud-site selection mutant that displays a random budding pattern; Bud21p [Saccharomyces cerevisiae]','MSNGHVKFDADESQASASAVTDRQDDVLVISKKDKEVHSSSDEESDDDDAPQEEGLHSGKSEVESQITQREEAIRLEQSQLRSKRRKQNELYAKQKKSVNETEVTDEVIAELPEELLKNIDQKDEGSTQYSSSRHVTFDKLDESDENEEALAKAIKTKKRKTLKNLRKDSVKRGKFRVQLLSTTQDSKTLPPKKESSIIRSKDRWLNRKALNKG');
INSERT INTO proteininfo VALUES ('6324651', 'NP_014720.1','Basic zinc-finger protein, similar to human and mouse Kin17 proteins which are chromatin-associated proteins involved in UV response and DNA replication; Rts2p [Saccharomyces cerevisiae]','MADYDSAKYWSKQGARRGLQKTRYYCQICQRQCKDANGFQSHNKSPSHLRKISQVTAEDARRYNIQFEKGFLQLLKQRHGEKWIDANKVYNEYVQDRDHVHMNATMHRSLTQFVRYLGRAGKVDVDMDIDDTSENVEGPLLIRIHPSSLSSPSEDGMLRSQQEEQEVIAAELLKRQLNRAKRQTEKVYQPEMKSEISGDSTLKRVQVTFHGNGRVNKKKKKVPPRKDGIKFR');
INSERT INTO proteininfo VALUES ('6324650', 'NP_014719.1','Antiviral protein. Ski7p G protein appears to function as a signal-coupling factor between the two multi-complexes operating in the 3'-to-5' mRNA-decay pathway.; Ski7p [Saccharomyces cerevisiae]','MSLLEQLARKRIEKSKGLLSADQSHSTSKSASLLERLHKNRETKDNNAETKRKDLKTLLAKDKVKRSDFTPNQHSVSLSLKLSALKKSNSDLEKQGKSVTLDSKENELPTKRKSPDDKLNLEESWKAIKEMNHYCFLKNDPCINQTDDFAFTNFIIKDKKNSLSTSIPLSSQNSSFLSLKKHNNELLGIFVPCNLPKTTRKVAIENFNRPSPDDIIQSAQLNAFNEKLENLNIKSVPKAEKKEPINLQTPPTESIDIHSFIATHPLNLTCLFLGDTNAGKSTLLGHLLYDLNEISMSSMRELQKKSSNLDPSSSNSFKVILDNTKTERENGFSMFKKVIQVENDLLPPSSTLTLIDTPGSIKYFNKETLNSILTFDPEVYVLVIDCNYDSWEKSLDGPNNQIYEILKVISYLNKNSACKKHLIILLNKADLISWDKHRLEMIQSELNYVLKENFQWTDAEFQFIPCSGLLGSNLNKTENITKSKYKSEFDSINYVPEWYEGPTFFSQLYLLVEHNMNKIETTLEEPFVGTILQSSVLQPIAEINYVSLKVLINSGYIQSGQTIEIHTQYEDFHYYGIVSRMKNSKQILETNTKNNISVGLNPDILEVLVKIHNTEDFTKKQFHIRKGDIIIHSRKTNTLSPNLPNTLKLLALRLIKLSIQTHALSDPVDLGSELLLYHNLTHNAVKLVKILGTNDISINPNQSLIVEVEIIEPDFALNVIDSKYITNNIVLTSIDHKVIAVGRIACQ');
INSERT INTO proteininfo VALUES ('6324649', 'NP_014718.1','t-SNARE that resides on the endoplasmic reticulum and mediates retrograde traffic from the Golgi complex; potential Cdc28p substrate; endoplasmic reticulum t-SNARE, coprecipitates with Sec20p, Tip1p. and Sec22p; Ufe1p [Saccharomyces cerevisiae]','MMSDLTPIFRKYVAVIDDARNEQNGIDDHVERKQEDFGNSNETCEMFRDSFIKECARLLKFLVELNKVIKQIEKNYLDDFNMSDAEKDEFDMECRLQIQQYFKKFEFLENYEMERHNLSLKRFQSKSHRWSKILSNKNDNTKHVIHPQDIENGVYEFRLGVLRCLNLWIKYVSSKFTTIQQERLILENKMNFNSTPMPTLSNNADDFSADAIDISVSQSAPVETVQDEVKHYEETISKLTQEQLQVLETEHSELLNQKNEQLKKVETINKTILDIVNIQNELSNHLTVQSQNINLMLNNQDDIELNIKKGNKELRKAKRAAGRTAKMTTYGAIIMGVFILFLDYVG');
INSERT INTO proteininfo VALUES ('6324648', 'NP_014717.1','Thymidylate synthase, required for de novo biosynthesis of pyrimidine deoxyribonucleotides; expression is induced at G1/S; Cdc21p [Saccharomyces cerevisiae]','MTMDGKNKEEEQYLDLCKRIIDEGEFRPDRTGTDANLLSEQGVKIWDGNGSREYLDKMGFKDRKVGDLGPVYGFQWRHFGAKYKTCDDDYTGQGIDQLKQVIHKLKTNPYDRRIIMSAWNPADFDKMALPPCHIFSQFYVSFPKEGEGSGKPRLSCLLYQRSCDMGLGVPFNIASYALLTRMIAKVVDMEPGEFIHTLGDAHVYKDHIDALKEQITRNPRPFPKLKIKRDVKDIDDFKLTDFEIEDYNPHPRIQMKMSV');
INSERT INTO proteininfo VALUES ('6324647', 'NP_014716.1','Protein that protects centromeric Rec8p at meiosis I; required for accurate chromosomal segregation at meiosis II and for mitotic chromosome stability; evolutionarily conserved, with similarity to S. pombe Sgo1 and Drosophila MEI-S332; Sgo1p [Saccharomyces cerevisiae]','MPKRKIAPNKESSRRTVSHDDLTPQIQEFQNLMDLESQKVENIRQSYSRQNSLLAKDNSILKIKVNSLEKKISQLVQENVTLRSKTSISEAIYRERLSNQLQVIENGIIQRFDEIFYMFENVRKNENLPSSSLRTMLKRTSSRSRSCSLSSPTYSKSYTRLSNHENNLSHESSFNKDDGPDLEPKAKKRKSSRRQSMFVSTSLEPEDETGENEPMMENSSVEVPAESHESAQVEETIDALNPEEENSDSVSNFTNSIIEYSIPEENPTEPEHSSSKLEIFNDSTNMLSTVPSNPLPLPLPGPSATLPTTTSDASTVYPSSSSSTNSHPKTKIKHSMKPPRIELKKKVIDEVMPVSNMSSNSEISFTRTRRTRGKAVDYTLPSLRAKMRRPSEKLVDATTVIDIHDLQVSKRNRETSHKRKSLSQDSIPDEPQLREVVVSKDYGTPKGKKTEDEIHEDTAHLMTTSNNNSNNKNEKKLTSNNSPKKSSPLLDITNKSENKKKSTRTKKLFKNAIVNNLSDENSTTRPSKSSKGTSNNNNNYNNFDNNNSNINNVNNKSVSFRLNEDDLAVFDLFGNGKAVKHQPKTYRTKK');
INSERT INTO proteininfo VALUES ('6324645', 'NP_014714.1','Hypothetical ORF; Yor071cp [Saccharomyces cerevisiae]','MSFSSIVSKFLRYLEIPAKNRTAVNFLRNPDLQPIKSANQTWGFWSNLAYWGAVSFTAGTWMSGSAALSVGLSYPETIVSFLLGNVLTIIFTMANSYPGYDWKIGFTLAQRFVFGIYGSAFGIIIRILMSIVNYGSNAWLGGLSINMILDSWSHHYLHLPNTLSPSVAMTTKQLVGFIIFHVLTALCYFMKPYHMNYLLIWSCVATCFAMLGIVIYLTKNAHGVGELFTSTKSTVTGSKRAWAWVYMISYWFGSISPGSTNQSDYSRFGSSNLAIWTGSVCALLIPATLVPIFGVISASTCDKLYGKQFWMPMDIFDYWLTNNYSAGARAGAFFCGLCFTMSQMSSTISNCGFATGMDMAGLLPKYVDIKRGALFCACISWACLPWNFYNSSSTFLTVMSSFGVVMTPIIAVMICDNFLIRKRQYSITNAFILKGEYYFTKGVNWRAIVAWVCGMAPGLPGIAWEVNNNYFHDSGIVKFFYGDSFFSFLISFFVYWGLCVFFPFKITVRHDDKDYYGAFTDEEARKKGMIPYSEISEEEIRAYTLGECYTTGHEYKPESSDNESPELIKTSSENTNVFEIVHQKDDEKHSFSTTQQVV');
INSERT INTO proteininfo VALUES ('6324644', 'NP_014713.1','Cis-golgi GTPase-activating protein (GAP) for the Rab family members Ypt1p (in vivo) and for Ypt1p, Sec4p, Ypt7p, and Ypt51p (in vitro); involved in vesicle docking and fusion; Gyp1p [Saccharomyces cerevisiae]','MGVRSAAKEMHERDHNSDSSSLVTSLMKSWRISSASSSKKPSLYKMNTTESTSLPSGYASSADRDRRTSDGNFEAMAKQQASTRRTSNSYSPLRYVNPTLSTASNESPRPALLLRQHHQRHHHHQQPRHSSSGSVGNNCSNSTEPNKKGDRYFKDLDEDWSAVIDDYNMPIPILTNGGFGTPVAPTRTLSRKSTSSSINSISNMGTSAVRNSSSSFTYPQLPQLQKEKTNDSKKTQLEIENERDVQELNSIIQRISKFDNILKDKTIINQQDLRQISWNGIPKIHRPVVWKLLIGYLPVNTKRQEGFLQRKRKEYRDSLKHTFSDQHSRDIPTWHQIEIDIPRTNPHIPLYQFKSVQNSLQRILYLWAIRHPASGYVQGINDLVTPFFETFLTEYLPPSQIDDVEIKDPSTYMVDEQITDLEADTFWCLTKLLEQITDNYIHGQPGILRQVKNLSQLVKRIDADLYNHFQNEHVEFIQFAFRWMNCLLMREFQMGTVIRMWDTYLSETSQEVTSSYSMSSNDIKPPVTPTEPRVASFVTPTKDFQSPTTALSNMTPNNAVEDSGKMRQSSLNEFHVFVCAAFLIKWSDQLMEMDFQETITFLQNPPTKDWTETDIEMLLSEAFIWQSLYKDATSHWL');
INSERT INTO proteininfo VALUES ('6324642', 'NP_014711.1','[Abnormal]Vacuole Morphology; Vam10p [Saccharomyces cerevisiae]','MLFEVFGEVLASYIVSSKTKGELAFPVNNAPPDSLVAINCVVLFLRSAIGSCSGAKELIRSSALELSCSSSCGLPATDKPGSFHSGALSKSILSANEAVVSKSSLSFLSSFVDI');
INSERT INTO proteininfo VALUES ('6324641', 'NP_014710.1','adds glucose to the dolichol-linked oligosaccharide precursor prior to transfer to protein; glycosyl transferase; Alg8p [Saccharomyces cerevisiae]','MKGDRSRQNMAVTKKAKLKKNDEPKKVLKTAATEKGEGSKRYSLWNFWISTLFLKLLLIPDYFSTDFDVHRNWLAITNKLPISEWYYEHTSQWTLDYPPFFAYFEWFLSQFVPKSVRDDGCLDIVEIGKFGLPTIVFQRLTVIFSEILLFVILQIYINTTKLSERSQSFVVASSIVLSPGFLIIDHIHFQYNGFLFAILIGSIVAAKNKRYILCAVLYTTAICFKHIFLYLAPCYFVFLLRAYVLNVNNFKFKSYKDFLFLIRWANLLKLATVVVGIFTICFLPFAHQMPQVLSRLFPFSRGLTHAYWAPNFWALYSFMDKILTTVMLKLPYVHTFATKFIKPPLIPQNIKEINERLAANNNGSKGLVQDVFFVILPQIPPKLTFILTIFYQVLAVLPLLFDPSFKRFVGSLTLCGLASFLFGWHVHEKAIMLVIIPFTFLVGFDRRLLVPFMLVASAGYVSLYPLLYKGQDFFIKTLYTYVWCIIYFAAFRKTTKISSSVERRIFFLDRLALTYIFSLLPIVTVLQILDEVKWRYSFLQKFEFLGLMIYSVYCSLGIISSWFALSWLYNFDELLWQ');
INSERT INTO proteininfo VALUES ('6324640', 'NP_014709.1','Protein of unknown function; potential Cdc28p substrate; Yor066wp [Saccharomyces cerevisiae]','MDKSMIKKRGRPPITKDYPNPLQSPMAHSSMQVQKQGPHSFAKPLMKVGQSSPSPNKRRLSIDHHHNLAATTRKGRYRGVLLSTPTKKSSTNGSTPISTPSSNDSYNNTVFSETRKTFLQSSPPIMTSSPAFQKKNDYMFPSQEQFKLSLTITESGKAVIAGSLPFSPSSKSSHLMNNNNKKIMQNEKIHKGSKKNAPKFEKRRILSLLKQMKNEKYCDTDTLPEAPPAKPSRSDIIDTELPTIIETSASPIGSARNNNILLSQPPQSPPSSAQLKPPSTPKSSLQFRMGFTPNVALNSVSLSDTISKSTNAVGASNNNNQNGNSISNIADANTLLTLTNSPGVFLSPRNKMLPKSTTASNEQQQEFVFKFSSGDPLLLTDDADGNWPEMLFNVSNTPRRQKCFNTPPSWINFGSPGLFSPPRSSNVMVNGTTVATASDSGNVHRQLQAQLEAQVQVQSQSNSPTQRQQQQRQFQIPPPHINMNSSPPQINIASPPHQSMSRVSSIYFNKEKTTTGVANMLGNTKSENLQPPANLFTAAHGPSTPRNQEFQLPTLIECTPLIQQTMNGSLGTKYIPGTSISNSATPNLHGFPVGTGKAPSSFDDSLKQNPYSNKQDDARTALKRLIDDQ');
INSERT INTO proteininfo VALUES ('6324639', 'NP_014708.1','Cytochrome c1; Cyt1p [Saccharomyces cerevisiae]','MFSNLSKRWAQRTLSKSFYSTATGAASKSGKLTQKLVTAGVAAAGITASTLLYADSLTAEAMTAAEHGLHAPAYAWSHNGPFETFDHASIRRGYQVYREVCAACHSLDRVAWRTLVGVSHTNEEVRNMAEEFEYDDEPDEQGNPKKRPGKLSDYIPGPYPNEQAARAANQGALPPDLSLIVKARHGGCDYIFSLLTGYPDEPPAGVALPPGSNYNPYFPGGSIAMARVLFDDMVEYEDGTPATTSQMAKDVTTFLNWCAEPEHDERKRLGLKTVIILSSLYLLSIWVKKFKWAGIKTRKFVFNPPKPRK');
INSERT INTO proteininfo VALUES ('6324638', 'NP_014707.1','Yeast homolog of mammalian Ing1; histone acetyltransferase complex component; Yng1p [Saccharomyces cerevisiae]','MEHLANENSDSDIRYSFLSTLDHLPCELIRSLRLMQTIDLFKNEEDEPGMERACRDLLLVATYINDLVDDQIHFLKQHKKELEIQKSVTKNFNSSLENIKSKLTLEEPGAYKEPKLLLKINLKKAKSRERKESITSPTIGINQGDVTEGNNNQEEVYCFCRNVSYGPMVACDNPACPFEWFHYGCVGLKQAPKGKWYCSKDCKEIANQRSKSKRQKRRK');
INSERT INTO proteininfo VALUES ('6324637', 'NP_014706.1','Protein component of the large (60S) ribosomal subunit, has similarity to E. coli L3 and rat L3 ribosomal proteins; involved in the replication and maintenance of killer double stranded RNA virus; Rpl3p [Saccharomyces cerevisiae]','MSHRKYEAPRHGHLGFLPRKRAASIRARVKAFPKDDRSKPVALTSFLGYKAGMTTIVRDLDRPGSKFHKREVVEAVTVVDTPPVVVVGVVGYVETPRGLRSLTTVWAEHLSDEVKRRFYKNWYKSKKKAFTKYSAKYAQDGAGIERELARIKKYASVVRVLVHTQIRKTPLAQKKAHLAEIQLNGGSISEKVDWAREHFEKTVAVDSVFEQNEMIDAIAVTKGHGFEGVTHRWGTKKLPRKTHRGLRKVACIGAWHPAHVMWSVARAGQRGYHSRTSINHKIYRVGKGDDEANGATSFDRTKKTITPMGGFVHYGEIKNDFIMVKGCIPGNRKRIVTLRKSLYTNTSRKALEEVSLKWIDTASKFGKGRFQTPAEKHAFMGTLKKDL');
INSERT INTO proteininfo VALUES ('6324636', 'NP_014705.1','Protein of unknown function; similar to YKR075Cp and Reg1p; expression regulated by glucose and Rgt1p; Yor062cp [Saccharomyces cerevisiae]','MTSLDDSVLTKKNIALLDNATNYIRPAIDYFHFKFNYDSLDVSTTWRLLLKMRKHKLLRLPSCSSENEFDYSIYMARLYHCIWRRWSIKHFNLDEYKIDPLSINWNKEIDVTVLYGPDLVGIHEREQPTPTDFPMGNIKEQGKQLLDVRKEGSASSLLKKGSVFYSKGKWLSQRSISFDDTVRRRDIDKRGRFRESCVLINDVEQFQNYSIVWDESRHRYRRQALPDTYDYEHLYPNGDETPRNTPHDNIIIHQNLHSITEGSYIYIK');
INSERT INTO proteininfo VALUES ('6324635', 'NP_014704.1','may have a role in regulation and/or execution of the eukaryotic cell cycle; alpha' subunit of casein kinase II; Cka2p [Saccharomyces cerevisiae]','MPLPPSTLNQKSNRVYSVARVYKNACEERPQEYWDYEQGVTIDWGKISNYEIINKIGRGKYSEVFSGRCIVNNQKCVIKVLKPVKMKKIYRELKILTNLTGGPNVVGLYDIVQDADSKIPALIFEEIKNVDFRTLYPTFKLPDIQYYFTQLLIALDYCHSMGIMHRDVKPQNVMIDPTERKLRLIDWGLAEFYHPGVDYNVRVASRYHKGPELLVNLNQYDYSLDLWSVGCMLAAIVFKKEPFFKGSSNPDQLVKIATVLGTKELLGYLGKYGLHLPSEYDNIMRDFTKKSWTHFITSETKLAVPEVVDLIDNLLRYDHQERLTAKEAMDHKFFKTKFE');
INSERT INTO proteininfo VALUES ('6324634', 'NP_014703.1','Protein required for cell viability; Yor060cp [Saccharomyces cerevisiae]','MSRKLCTLNFTLSGKQGSLVIRDIQLWSNRPTASKSTSELRGQFIQYVDLAKLPLWVRSTNMNTYRCYSTSATAQAYFKSKLRNANRGIVIELFDKVDQRSQEPAYLIIFRENTELNCFQVDLTMKHEFDGQVTKLKQDIGKTRASVSKEGSIDIIIQQSQQRKIGTKTEVYRNVHINDKRLQFNETLSKLILGGLRLRGISNSITDYQKLYKITFDAAEFTHRDELKRISMGSGEEVSFESLQETVETLLKLFTKS');
INSERT INTO proteininfo VALUES ('6324633', 'NP_014702.1','Hypothetical ORF; Yor059cp [Saccharomyces cerevisiae]','MTSDKHLFVLIHGLWGNYTHMESMRTILSTTLKKEDVNDDMIYFLPKQNAMFKTFDGIEIIGYRTLIEVCEFIRDYKDGKITKLSVMGYSQGGLVARFMIGKMLTEFKELFEDIEPQLFITMATPHLGVEFYNPTGIAYKSALYSALRTLGSTILGKSGREMFIANSSNNILVKLSQGEYLEALSLFKWRIAFANVKNDRTVAFYTAFITDCDPFIDFDNKLKYTFEEKIPGSGYKGILPKIVDLNALNVNSHAPTKPTKTYKKWGRTILIILVATFLILPIALVMNGLGTAYSYIVTCKYRKMLSNGILHNEVRGKLGLTEQLKGYVTDAYGSIINSALDMDANYEASNSNLVNEEELPWKEFIQKYTTINDGVWKSKFKKLPFDENRKVILRNLNKLKWIRVPIYIKAVNAHGVIVARRGMDENTAATGIACIEFTAQLLAYLMHKSN');
INSERT INTO proteininfo VALUES ('6324631', 'NP_014700.1','Probable cochaperone, regulates activity of Cyr1p (adenylyl cyclase); involved in assembly of the kinetochore complex, associates with the SCF (Skp1p/Cdc53p/F box protein) ubiquitin ligase complex; Sgt1p [Saccharomyces cerevisiae]','MPVEKDLKTAYKALYDEKEPLKALHLYDEILKGSPTNLTALIFKAACLEKLYFGFSDWHSDATMENAKELLDKALMTAEGRGDRSKIGLVNFRYFVHFFNIKDYELAQSYFKKAKNLGYVDDTLPLWEDRLETKLNKKNKKQKDSTNKHTIKPVESIENRGDNNSSHSPISPLKIETAPQESPKFKIDWYQSSTSVTISLFTVNLPESKEQVNIYISPNDRRTLSISYQVPKSGSEFQYNAKLSHEVDPKAVSLKIFPKKLEITLSKIDSTQWKKLEEDILTESSRLSDEGKNSDSATRLLSAETASKERLSYPSSSKKKIDWSKLDIDEEADEEAGSADSFFQKLYAGADPDTKRAMMKSFIESNGTALSTDWEDVSKGTVKTSPPEGMEPKHW');
INSERT INTO proteininfo VALUES ('6324630', 'NP_014699.1','Essential nuclear protein that interacts with the proteasome; may act as a chaperone to facilitate binding of the 20S proteasome to the 19S regulatory particle during proteasome maturation; Nob1p [Saccharomyces cerevisiae]','MTENQTAHVRALILDATPLITQSYTHYQNYAQSFYTTPTVFQEIKDAQARKNLEIWQSLGTLKLVHPSENSIAKVSTFAKLTGDYSVLSANDLHILALTYELEIKLNNGDWRLRKKPGDALDASKADVGTDGKQKLTEDNKKEEDSESVPKKKNKRRGGKKQKAKREAREAREAENANLELESKAEEHVEEAGSKEQICNDENIKESSDLNEVFEDADDDGDWITPENLTEAIIKDSGEDTTGSLGVEASEEDRHVALNRPENQVALATGDFAVQNVALQMNLNLMNFMSGLKIKRIRNYMLRCHACFKIFPLPKDGKPKHFCASCGGQGTLLRCAVSVDSRTGNVTPHLKSNFQWNNRGNRYSVASPLSKNSQKRYGKKGHVHSKPQENVILREDQKEYEKVIKQEEWTRRHNEKILNNWIGGGSADNYISPFAITGLKQHNVRIGKGRYVNSSKRRS');
INSERT INTO proteininfo VALUES ('6324629', 'NP_014697.1','Regulatory subunit of Ppz1p, which is an isoform of serine/threonine protein phosphatase Z involved in regulation of potassium transport; overexpression suppresses the synthetic lethality of the hal3 sit4 double mutation; Vhs3p [Saccharomyces cerevisiae]','MTNKSSLKNNRKGVASNTLSGAEQANIGSSAMPDTNSTGPFSSVSSLDTPVVRKSTSPTGSQTKSIMNASGTSGAVVSNTPEPGLKRIPTVTFSDPKLGSLRSDVEQTPPNQVARQSSEKKATSVHIAAEGANQGRNLKDINTKVPKDGEASASSFSTPTSILSNADMGNNISSLLAKKLSFTGGTDSILNSDNSSDSPRKEHPHFYVEDPLHTPSVRSRSNSTSPRPSVVVNTFNPINIEREGSISKTGEPTLLESVLEEAMSPNAVSNPLKRENIMTNMDPRLPQDDGKLHVLFGATGSLSVFKLKHMIRKLEEIYGRDKICIQVILTNSATKFFAMKYMRKNKKQHNSIDTSFNSTNSNAGNITGNKKKVASLEKFSIQKTSSNSAASQTNNKQEEEKQMASTTGFPSTLGGSRTYSNSSNVVSQHPQIELPAHIQFWTDQDEWDVWRQRTDPVLHIELRRWADILVVAPLTANTLAKIALGLCDNLLTSVIRAWNPTFPIFLAPSMGSGTFNSIMTKKHFRIIQEEMPWVTVFKPSEKVMGINGDIGLSGMMDANEIVGKIVVKLGGYPDVSAGKEEEEDEDNDEEDDNKKNDTGGKDEDNDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDEDDEDEDEDDEGKKKEDKGGLQRS');
INSERT INTO proteininfo VALUES ('6324626', 'NP_014695.1','Hypothetical ORF; Yor052cp [Saccharomyces cerevisiae]','MSDINEIEIPSRKDEIRQVTPKDPMHEIEDKSTYHAKIKKSDSGTVLGAIPLNSRSSSNSSVTSTGQSSRRVTKKTTKKKKKNACYFDTCSSAASKFIGDCNFCKGHFCSKHRLMENHACNGLTSCKEQLHQRNADKLEAEQTKAPKIQI');
INSERT INTO proteininfo VALUES ('6324625', 'NP_014694.1','Nuclear protein that inhibits replication of Brome mosaic virus in S. cerevisiae, which is a model system for studying replication of positive-strand RNA viruses in their natural hosts; Yor051cp [Saccharomyces cerevisiae]','MAKRPLGLGKQSREKKRKVESVEKKSDEPSRESTPVRSQMSVELDDDADLDDELAQLKGLWSKYFHSDRDDEYVLNGIVHECDRLLRLSEEDKEIKKTLNDIFHGIYALALSELTIFKAGDEEATEEKRKKDVSSFFESAIERVELGLSHFPESQFLKLVLAKIIFQRIPLEYISNLHLKSKDKKLDLVGQLEHGKKHFSIYENDTEFTFEILQMVNDLLDIVENFGREQSIQEGIDSDNEEEEELIDIELEPEHPVYPLQQSLEANYEWLRNHFDKLLDNTNTDVKIYASIANTLGELYLKKAEEPSKVFLSLQYDDGGSEKVSDKEAKNAQETALKHTKKALEYLEKAKLEDDPDTWVQVAEAYIDLGNLLDNESAEQEEAYKTAEEILGKANKASHGKFQDVLDNFLQG');
INSERT INTO proteininfo VALUES ('6324623', 'NP_014692.1','Suppressor of sphingoid long chain base (LCB) sensitivity of an LCB-lyase mutation; putative integral membrane transporter or flippase that may transport LCBs from the cytoplasmic side toward the extracytoplasmic side of the membrane; Rsb1p [Saccharomyces cerevisiae]','MVPNLRFNITMIVIWGILLTIHVVQLLMRQYWFSIAFICTGILEVLGFIGRTWSHSNVADMDAFLLNMICLTIAPVFTMGGIYYQLAKLIEVYGHRFSLLPSPMAYSFIFICSDIVSLVVQAVGGGLCGVAVTDGTSTTTGNHVFIAGLAIQVASMAIFLMLWFHFLFRIYISVRWEHINSRPISLSLLKISQTEVDYLYREKFHFLRLEPKRWVFHYFNLAITVAVLTIFTRCCYRLAELVVGWDGYLITHEWYFIILDALMMAIATVTLTIFHPGFAFKGRSTSIPITPGHVDPETLPHTDDVEDILDTSDSKQFDIEKEEFQASMKYPISTFKQFMSKIANLFSSKKKAKL');
INSERT INTO proteininfo VALUES ('6324622', 'NP_014691.1','RNA trafficking protein; transcription activator; Rat1p [Saccharomyces cerevisiae]','MGVPSFFRWLSRKYPKIISPVLEEQPQIVDGVILPLDYSASNPNGELDNLYLDMNGIVHPCSHPENKPPPETEDEMLLAVFEYTNRVLNMARPRKVLVMAVDGVAPRAKMNQQRARRFRSARDAQIENEAREEIMRQREEVGEIIDDAVRNKKTWDSNAITPGTPFMDKLAAALRYWTAFKLATDPGWKNLQVIISDATVPGEGEHKIMNFIRSQRADPEYNPNTTHCIYGLDADLIFLGLATHEPHFKILREDVFAQDNRKRNNLKDTINMTEEEKQFLQKQNSEQPFLWLHINVLREYLSAELWVPGLPFTFDLERAIDDWVFMCFFCGNDFLPHLPCLDVRENSIDILLDIWKVVLPKLKTYMTCDGVLNLPSVETLLQHLGSREGDIFKTRHIQEARKKEAFERRKAQKNMSKGQDRHPTVATEQLQMYDTQGNLAKGSWNLTTSDMVRLKKELMLANEGNEEAIAKVKQQSDKNNELMKDISKEEIDDAVSKANKTNFNLAEVMKQKIINKKHRLEKDNEEEEIAKDSKKVKTEKAESECDLDAEIKDEIVADVNDRENSETTEVSRDSPVHSTVNVSEGPKNGVFDTDEFVKLFEPGYHERYYTAKFHVTPQDIEQLRKDMVKCYIEGVAWVLMYYYQGCASWNWFYPYHYAPLATDFHGFSHLEIKFEEGTPFLPYEQLMSVLPAASGHALPKIFRSLMSEPDSEIIDFYPEEFPIDMNGKKMSWQGIALLPFIDQDRLLTAVRAQYPLLSDAERARNIRGEPVLLISNKNANYERFSKKLYSKENNNNNVVVKFQHFKSGLSGIVSKDVEGFELNGKIVCPIQGGSLPNLSTTLILKMSYRLIPLPSRNKSIILNGFIPSEPVLTAYDLDSIMYKYNNQNYSRRWNFGNDLKQNIVPVGPKGITQYKPRTGGYRAFFYFAELSRNNVQPAHNYGRNSYNSQPGFNNSRYDGGNNNYRQNSNYRNNNYSGNRNSGQYSGNSYSRNNKQSRYDNSRANRR');
INSERT INTO proteininfo VALUES ('6324621', 'NP_014690.1','Protein that interacts with the Snf1p protein kinase and Spt15p in two-hybrid and in in vitro binding studies; Std1p [Saccharomyces cerevisiae]','MFVSPPPATARNQVLGKRKSKRHDENPKNVQPNADTEMTNSVPSIGFNSNLPHNNQEINTPNHYNLSSNSGNVRSNNNFVTTPPEYADRARIEIIKRLLPTAGTKPMEVNSNTAENANIQHINTPDSQSFVSDHSSSYESSIFSQPSTALTDITTGSSLIDTKTPKFVTEVTLEDALPKTFYDMYSPEVLMSDPANILYNGRPKFTKRELLDWDLNDIRSLLIVEQLRPEWGSQLPTVVTSGINLPQFRLQLLPLSSSDEFIIATLVNSDLYIEANLDRNFKLTSAKYTVASARKRHEEMTGSKEPIMRLSKPEWRNIIENYLLNVAVEAQCRYDFKQKRSEYKRWKLLNSNLKRPDMPPPSLIPHGFKIHDCTNSGSLLKKALMKNLQLKNYKNDAKTLGAGTQKNVVNKVSLTSEERAAIWFQCQTQVYQRLGLDWKPDGMS');
INSERT INTO proteininfo VALUES ('6324620', 'NP_014689.1','Cytoplasmic DExD/H-box protein essential for poly(A)+ RNA export; RNA helicase; Dbp5p [Saccharomyces cerevisiae]','MSDTKRDPADLLASLKIDNEKEDTSEVSTKETVKSQPEKTADSIKPAEKLVPKVEEKKTKQEDSNLISSEYEVKVKLADIQADPNSPLYSAKSFDELGLAPELLKGIYAMKFQKPSKIQERALPLLLHNPPRNMIAQSQSGTGKTAAFSLTMLTRVNPEDASPQAICLAPSRELARQTLEVVQEMGKFTKITSQLIVPDSFEKNKQINAQVIVGTPGTVLDLMRRKLMQLQKIKIFVLDEADNMLDQQGLGDQCIRVKRFLPKDTQLVLFSATFADAVRQYAKKIVPNANTLELQTNEVNVDAIKQLYMDCKNEADKFDVLTELYGLMTIGSSIIFVATKKTANVLYGKLKSEGHEVSILHGDLQTQERDRLIDDFREGRSKVLITTNVLARGIDIPTVSMVVNYDLPTLANGQADPATYIHRIGRTGRFGRKGVAISFVHDKNSFNILSAIQKYFGDIEMTRVPTDDWDEVEKIVKKVLKD');
INSERT INTO proteininfo VALUES ('6324619', 'NP_014688.1','involved in supporting the cooperativity between receptors and the general insertion pore and facilitating the release of preproteins from import components; outer mitochondrial membrane protein, component of the mitochondiral protein translocation complex, associates with TOM40; Tom6p [Saccharomyces cerevisiae]','MDGMFAMPGAAAGAASPQQPKSRFQAFKESPLYTIALNGAFFVAGVAFIQSPLMDMLAPQL');
INSERT INTO proteininfo VALUES ('6324618', 'NP_014687.1','Hypothetical ORF; Yor044wp [Saccharomyces cerevisiae]','MIEALEIVLLLVIQSLQYICRTCIAFLLIPFLGLYAFDLFLYVYRMILYLSQMFNYKRKLGRSKTNNRPHSPRLHKIYSSGDCMDTLIGQVRDLRVFLLSTIHSHSKRFFSTRFQTKSGINSAIDANDVETTSDVSSFTNLHLTRSSEEGYYIAGSI');
INSERT INTO proteininfo VALUES ('6324617', 'NP_014686.1','Protein required, with binding partner Psr1p, for full activation of the general stress response, possibly through Msn2p dephosphorylation; regulates growth during the diauxic shift; negative regulator of G1 cyclin expression; Whi2p [Saccharomyces cerevisiae]','MDDIITQVSPDNAESAPILQEQQQQQNSQYEGNEEDYGDSLIHLNIQENHYFITRDQLMSLPESLLLCLFPSGVFLDRCGQVITNLTRDDEVYIVNFPPDCFEYIMEIYTKAHDDLYNHPVEKFFDRPSSSFVSNAKGFFGLSSNNSISSNNEQDILHQKPAIIVLREDLDYYCVPQEEFQFDSTNEENNEDLLRHFMAQVKMAAGSYLTSKTSIFQGLYSSNRLKQQQQQQKIEKGSNSSSNTKSTSKKLGPAEQHLMDMLCSSGFTKETCWGNRTQETGKTVISSLSLCRLANETTEGFRQKFNEAKAKWEAEHKPSQDNFITPMQSNISINSLSASKSNSTISTARNLTSGSTAPATARDKRKSRLSKLADNVRSHSSSRHSSQTRSKPPELPKLYDLVPKPNINAKLLLFWRKPARKCWWGEEDIELEVEVFGSWKDESKKIIELILPTNVDPEAELHKIIVPVRLHIRRVWTLELSVIGVQ');
INSERT INTO proteininfo VALUES ('6324615', 'NP_014685.1','Protein containing a CUE domain that binds ubiquitin, which may facilitate intramolecular monoubiquitination; green fluorescent protein (GFP)-fusion protein localizes to the cytoplasm in a punctate pattern; Cue5p [Saccharomyces cerevisiae]','MEEKEGIKDSSLLEKSNVPESINEDISKTTDVDLNSDGKKDNDTSAKDGTPKVEEKVNKSSGIDEDEVVTPAEDAKEEEEEHPPLPARRKSEEEPSKENPILQELKDAFPNLEEKYIKAVIIASQGVLSPAFNALLFLSDPESGKDIELPTQPVRKNPEAPARRRQTQLEQDELLARQLDEQFNSSHSRRRNRDRATRSMHEQRRRRHNPNEREQHHEDSEEEDSWSQFVEKDLPELTDRAGRSLQDTANKVSNWISDAYRRNFASGNEQNDNQHGHQDQQEWEPEIVDLSQGGKNSRPQQPERRRFNSFGVQVGDDSLESHGITLHNEDGFEDDEDVPPQLPTRTKSGESTGKVVAETTYIDTPDTETKKKWQPLPPEPLDTTPTKVNAVSRNKKNPDEDEFLINSDDEM');
INSERT INTO proteininfo VALUES ('6324614', 'NP_014683.1','Mitochondrial glyoxalase II, catalyzes the hydrolysis of S-D-lactoylglutathione into glutathione and D-lactate; Glo4p [Saccharomyces cerevisiae]','MKFLLQQIRNMHVKPIKMRWLTGGVNYSYLLSTEDRRNSWLIDPAEPLEVSPKLSAEEKKSIDAIVNTHHHYDHSGGNLALYSILCQENSGHDIKIIGGSKSSPGVTEVPDNLQQYHLGNLRVTCIRTPCHTKDSICYYIKDLETGEQCIFTGDTLFIAGCGRFFEGTGRDMDMALNQIMLRAVGETNWNKVKIYPGHEYTKGNVSFIRAKIYSDIGQNKEFDALEQYCKSNECTTGHFTLRDELGYNPFMRLDDRAVRLAVGDTAGTYPRSVVMQELRKLKNAM');
INSERT INTO proteininfo VALUES ('6324613', 'NP_014682.1','protein kinase CK2, beta' subunit; Ckb2p [Saccharomyces cerevisiae]','MGSRSENVGTVTREGSRVEQDDVLMDDDSDSSEYVDMWIDLFLGRKGHEYFCDVDPEYITDRFNLMNLQKTVSKFSYVVQYIVDDLDDSILENMTHARLEQLESDSRKLYGLIHARYIITIKGLQKMYAKYKEADFGRCPRVYCNLQQLLPVGLHDIPGIDCVKLYCPSCEDLYIPKSSRHSSIDGAYFGTSFPGMFLQAFPDMVPKHPTKRYVPKIFGFELHKQAQLTRWQELQRLKLVEKLESKDVDLTKSGGFKT');
INSERT INTO proteininfo VALUES ('6324612', 'NP_014681.1','Non-essential transcriptional corepressor involved in the cell cycle-regulated transcription of histone H2A, H2B, H3, and H4 genes; recruits Swi-Snf complexes to histone gene promoters; promotes heterochromatic gene silencing with Asf1p; Hir2p [Saccharomyces cerevisiae]','MRLLKYPLDIHNEQVNALAALGPYIILAGSGGHVMAWRQQQLVDTAFDRVMIKDLKPEVSFQVDQDTTGDIFFITGDLETLYIGSEHRLWGYSGWLCRDTNNINSVEKMNSKLLFECKSPSTITDVKYDINLGILFVLLSNENKILLFRHKTFDKLSEITIDKASKPITGIIDPTGQTFTVMTSDRSILVYQINKTGTHKLINKLTQHVQMYPLHYRISMSPQADILPVINSVKGVPNNATSCTALLDRNNNYKVTKTLVTPSSNGCRVLVYSPAFYEKPNLKKGTSTRYNLIATSGSTDGTILVWNTKRMKPLFNALQVSSTAINDMSWSQDGFTLFAISNDATLYTFAFQEKDLGVALPQTEIKSLQEVNKKLPKLEEPLAEQIPKSFPENIKLEESASAAPIPNDIGRSAVGKKPTKKKTANNQTNGIKTIQSTSMEFNTPSYTVPRDLKRKPKEATPSNIAPGSKKQKKELQPIDFLDTGLLLPNTSFSRIRLATPKIRSTFKYSPINNPNLILDVKNGSGNEQRPTIVKLTSKVLDQDQVLFQDFIPKLITICTAGDTFWSFCSEDGSIYIYSDSGRKLMAPLVLGVSISFLEACGTYLLCLTSIGELYCWNIEQKKLAFPTNTIYPLLNPSLRYSDDILTRAENITLCSITKKGVPLVTLSNGDGYLFDKNMETWLLVSDGWWAYGSQYWDTTNTTGLSSSKANTDSFNGSESNINEIVSDIKNDNQSIINFLECKTNDELNRKGRIKNLQRFARTILMKEGFENMEEIVTLSHLENKILISIRLEEPEEFSKLMMVYCIRLSELGYMDRLNDVFQWLYDDLPISGTGSAFADKDFKRNLLKKILIACGDIRQVQRVTTRYAKEMNIIS');
INSERT INTO proteininfo VALUES ('6324610', 'NP_014679.1','integral membrane protein; c-terminal TMD; located in endosome; Pep12p [Saccharomyces cerevisiae]','MSEDEFFGGDNEAVWNGSRFSDSPEFQTLKEEVAAELFEINGQISTLQQFTATLKSFIDRGDVSAKVVERINKRSVAKIEEIGGLIKKVNTSVKKMDAIEEASLDKTQIIAREKLVRDVSYSFQEFQGIQRQFTQVMKQVNERAKESLEASEMANDAALLDEEQRQNSSKSTRIPGSQIVIERDPINNEEFAYQQNLIEQRDQEISNIERGITELNEVFKDLGSVVQQQGVLVDNIEANIYTTSDNTQLASDELRKAMRYQKRTSRWRVYLLIVLLVMLLFIFLIMKL');
INSERT INTO proteininfo VALUES ('6324609', 'NP_014678.1','Protein containing a UCS (UNC-45/CRO1/SHE4) domain, binds to myosin motor domains to regulate myosin function; involved in endocytosis, polarization of the actin cytoskeleton, and asymmetric mRNA localization; She4p [Saccharomyces cerevisiae]','MPLCEKGNDPIDSSTIDSLCAAFDKTLKSTPDVQKYNDAINTIFQLRQKSESGKMPADLTNSEALKDRQKIEEILTRSYQDHSESRVHLSKLIQNDIPFALNLFEILSRSSIHVFVGCFSNKDATIALLNELQIRIHYGEDTHVTYLLSIILQLLNKFKYNFKEVRFLVKELILRISEDEVKSMMLIIFAELQSSFQKDFDKAVVDFMSSLIVEAEIDVGNDPLSIIVKTLSELYPSLTTLCSEIFLTKGLSKLFKKRVFEEQDLQFTKELLRLLSSACIDETMRTYITENYLQLLERSLNVEDVQIYSALVLVKTWSFTKLTCINLKQLSEIFINAISRRIMPKIENVNESAVKLEEVPKVEMSVEALAYLSLKASVKIMIRSNESFTEILLTMIKSQKMTHCLYGLLVIMANLSTLPEESNGSSQSINDLKNYADLKGPGADKVGAEKESKEDILLFNEKYILRTELISFLKREMHNLSPNCKQQVVRVIYNITRSKNFIPQCISQGGTTIILEYLANKQDIGEPIRILGCRALTRMLIFTNPGLIFKKYSALNAIPFLFELLPRSTPVDDNPLHNDEQIKLTDNYEALLALTNLASSETSDGEEVCKHIVSTKVYWSTIENLMLDENVPLQRSTLELISNMMSHPLTIAAKFFNLENPQSLRNFNILVKLLQLSDVESQRAVAAIFANIATTIPLIAKELLTKKELIENAIQVFADQIDDIELRQRLLMLFFGLFEVIPDNGTNEVYPLLQENQKLKDALNMSLKRGDSGPEFSAAIPVILAKIKV');
INSERT INTO proteininfo VALUES ('6324608', 'NP_014677.1','Protein involved in constitutive endocytosis of Ste3p; involved in constitutive endocytosis of Ste3p; Akr2p [Saccharomyces cerevisiae]','MTSMSIIDDENVKKTSNGAAVVTDVAQHAVSDSDNNKAQLLGDGSNTEYVVDIFIEAAKDGDLKVVKDVVESGAVDINNDRIDELSGLHWACINNRFSVAKFLLLRGANPNQAAGPGGATALHWAARYGNIYIVDLLLKHGADPTLKDEQGLNIMHFSVYSSNILLVVYVLYFVVNNNDNVDIDSKDNNNRTPLLWAAYQGDFLTVELLLKFGSTVAWTDNRGFNALHCALVGGDQRVICDLILSGANFYERNNQKQDCFDLAEGMGTKSLFEQALQHHGYDRLGNQKDKLFKKSSHAQFTIFLSPFLLMVYIYLISLVLSPVLAIMLSLLVTVVMVNTLKKFVLPCLPRKNTYKVSLTRTPFFSGLFLSTFCFLIYIWTKKLYPYSVSDYTMKNVQFLVTSFLTVVLFLRLVRSDPGCLKTDDSLTSIQETIKQLIDLGKFDRENFCVETLERKPLRSKYSFFSGALVARYDHYCPWIYNDVGLKNHKLFVFFAVTVQYHMFLFMWLCLAYFKKTNYIYEQVEEYARCALLKNETLCKGSNYDPSTFFLFIWISVNFIWLGAMLIVQFFQILKGITTPELFILIKEEHKAKFINLIPFENSIYTSESKGVEDSDMIPEGPSATTITHTISIDGLEPRNRRRAILSACFSMMGINQWLVTIKEIVGITHILHGQVPQQHHSSLLRSFLVTNHWKTNLTDFWLNSDVTAPLWQRFFYSSDTSKAMLGGTEVDYYELYEYPAREGEVLRPN');
INSERT INTO proteininfo VALUES ('6324607', 'NP_014676.1','5'-3' exonuclease and flap-endonuclease involved in recombination, double-strand break repair and DNA mismatch repair; member of the Rad2p nuclease family, with conserved N and I nuclease domains; Exo1p [Saccharomyces cerevisiae]','MGIQGLLPQLKPIQNPVSLRRYEGEVLAIDGYAWLHRAACSCAYELAMGKPTDKYLQFFIKRFSLLKTFKVEPYLVFDGDAIPVKKSTESKRRDKRKENKAIAERLWACGEKKNAMDYFQKCVDITPEMAKCIICYCKLNGIRYIVAPFEADSQMVYLEQKNIVQGIISEDSDLLVFGCRRLITKLNDYGECLEICRDNFIKLPKKFPLGSLTNEEIITMVCLSGCDYTNGIPKVGLITAMKLVRRFNTIERIILSIQREGKLMIPDTYINEYEAAVLAFQFQRVFCPIRKKIVSLNEIPLYLKDTESKRKRLYACIGFVIHRETQKKQIVHFDDDIDHHLHLKIAQGDLNPYDFHQPLANREHKLQLASKSNIEFGKTNTTNSEAKVKPIESFFQKMTKLDHNPKVANNIHSLRQAEDKLTMAIKRRKLSNANVVQETLKDTRSKFFNKPSMTVVENFKEKGDSIQDFKEDTNSQSLEEPVSESQLSTQIPSSFITTNLEDDDNLSEEVSEVVSDIEEDRKNSEGKTIGNEIYNTDDDGDGDTSEDYSETAESRVPTSSTTSFPGSSQRSISGCTKVLQKFRYSSSFSGVNANRQPLFPRHVNQKSRGMVYVNQNRDDDCDDNDGKNQITQRPSLRKSLIGARSQRIVIDMKSVDERKSFNSSPILHEESKKRDIETTKSSQARPAVRSISLLSQFVYKGK');
INSERT INTO proteininfo VALUES ('6324606', 'NP_014675.1','C2H2 zinc-finger protein with similarity to myc-family transcription factors; overexpression confers hyperfilamentous growth and suppresses the pseudohyphal filamentation defect of a diploid mep1 mep2 homozygous null mutant; Hms1p [Saccharomyces cerevisiae]','MPNFQKPFSGSSDGNSVMNDLGNKVAIKVFDCRSAQDGSEEQNVNVTTNQMYLMFQSNNYNVPPPNYNTEDLGSQGPPTHAYYAPFQHPIHLQPPVPPVYKNNTYSATDQYSDSSFPNTSGHTPVIDSNYYNDALASIPTTTTGSTTMTTDNGNTIDSEEYIDNMEVFSSEENENIDNVKQTDLKSEKDSSLLSAASIVKKEQLSGFENFLPLSKTESPLVTADEIKSSLNLENIDNADSMSFKLKTSPIRKHFHVKPKRITRVRTGRVSHNIIEKKYRSNINDKIEQLRRTVPTLRVAYKKCNDLPITSRDLADLDGLEPATKLNKASILTKSIEYICHLERKCLQLSLANQHLSNDTRDSFVHLTEPSQPLSDNSSSEQVQKQTRSCQRQRQRQPRQQQPLHNIQYNIPHQNGLMSGTNNSHDMDFNNAGDF');
INSERT INTO proteininfo VALUES ('6324605', 'NP_014674.1','Copper-binding metallothionein, required for wild-type copper resistance; Crs5p [Saccharomyces cerevisiae]','MTVKICDCEGECCKDSCHCGSTCLPSCSGGEKCKCDHSTGSPQCKSCGEKCKCETTCTCEKSKCNCEKC');
INSERT INTO proteininfo VALUES ('6324604', 'NP_014673.1','Probable multiple transmembrane protein, involved in invasive growth upon nitrogen starvation; Dfg16p [Saccharomyces cerevisiae]','MIIRLHFYYLLTLVYHLGLVGAYEKAARKRIQPPDLIPGPPGHKLGDERPPHYDHRPPYKKHIDNIPAYNLTDLIDDKLLNKYENSCTVNVLTGGFISLASNSWHLRAYNYTLNYPSFLIRCDNGSANPNFSHVLQDFVYDINNKFNVQDDSSKYIGKDPFPLGMIMITFASGCICVATWMLFLVVLLLPSDNHNRRNKVVHVYVLFSAIIRTVFLNETIAVIFDSQYHDDYQDASQFESFIVETAPYKICELVANILSDINWIYIVHYLQSNYGKPTWNWIPFKMKKGTHIIITVGCFLSLADNILFANLLWRKNLVVLKVFYKLIELLIYTIFISIICYFTWHNFAYILLPKTAEINTDGKCKTKLRILWENYHETIPLLAYNILIFILFYFTTIFFAAFTKHVRGWTFNFVHLLKVLITVNVWGLIGVLEKRELHISKKTVLGRKINNRDKFFANPTVNYYGEDLGKHLSAITLNRDLNTTKSNTTSHDSSSLVGSPSPTWKSPIERIRDRRRRHKIMKSENKFGQNPSFGSKSNGKPNTKTTLSKYRQLLRKPRRKTNSYEPKNGIGQNKEGSTVRPGADKHIRDSNYLATDISDNESMETELRTNHIYNYENSD');
INSERT INTO proteininfo VALUES ('6324602', 'NP_014671.1','Basic leucine zipper transcriptional factor of the yAP-1 family that mediates pleiotropic drug resistance and salt tolerance; localizes constitutively to the nucleus; Cin5p [Saccharomyces cerevisiae]','MLMQIKMDNHPFNFQPILASHSMTRDSTKPKKMTDTAFVPSPPVGFIKEENKADLHTISVVASNVTLPQIQLPKIATLEEPGYESRTGSLTDLSGRRNSVNIGALCEDVPNTAGPHIARPVTINNLIPPSLPRLNTYQLRPQLSDTHLNCHFNSNPYTTASHAPFESSYTTASTFTSQPAASYFPSNSTPATRKNSATTNLPSEERRRVSVSLSEQVFNEGERYNNDGQLIGKTGKPLRNTKRAAQNRSAQKAFRQRREKYIKNLEEKSKLFDGLMKENSELKKMIESLKSKLKE');
INSERT INTO proteininfo VALUES ('6324601', 'NP_014670.1','Heat shock protein also induced by canavanine and entry into stationary phase; Sti1p [Saccharomyces cerevisiae]','MSLTADEYKQQGNAAFTAKDYDKAIELFTKAIEVSETPNHVLYSNRSACYTSLKKFSDALNDANECVKINPSWSKGYNRLGAAHLGLGDLDEAESNYKKALELDASNKAAKEGLDQVHRTQQARQAQPDLGLTQLFADPNLIENLKKNPKTSEMMKDPQLVAKLIGYKQNPQAIGQDLFTDPRLMTIMATLMGVDLNMDDINQSNSMPKEPETSKSTEQKKDAEPQSDSTTSKENSSKAPQKEESKESEPMEVDEDDSKIEADKEKAEGNKFYKARQFDEAIEHYNKAWELHKDITYLNNRAAAEYEKGEYETAISTLNDAVEQGREMRADYKVISKSFARIGNAYHKLGDLKKTIEYYQKSLTEHRTADILTKLRNAEKELKKAEAEAYVNPEKAEEARLEGKEYFTKSDWPNAVKAYTEMIKRAPEDARGYSNRAAALAKLMSFPEAIADCNKAIEKDPNFVRAYIRKATAQIAVKEYASALETLDAARTKDAEVNNGSSAREIDQLYYKASQQRFQPGTSNETPEETYQRAMKDPEVAAIMQDPVMQSILQQAQQNPAALQEHMKNPEVFKKIQTLIAAGIIRTGR');
INSERT INTO proteininfo VALUES ('6324600', 'NP_014669.1','Protein required for cell cycle arrest in response to loss of microtubule function; cell cycle checkpoint protein; Bub3p [Saccharomyces cerevisiae]','MQIVQIEQAPKDYISDIKIIPSKSLLLITSWDGSLTVYKFDIQAKNVDLLQSLRYKHPLLCCNFIDNTDLQIYVGTVQGEILKVDLIGSPSFQALTNNEANLGICRICKYGDDKLIAASWDGLIEVIDPRNYGDGVIAVKNLNSNNTKVKNKIFTMDTNSSRLIVGMNNSQVQWFRLPLCEDDNGTIEESGLKYQIRDVALLPKEQEGYACSSIDGRVAVEFFDDQGDDYNSSKRFAFRCHRLNLKDTNLAYPVNSIEFSPRHKFLYTAGSDGIISCWNLQTRKKIKNFAKFNEDSVVKIACSDNILCLATSDDTFKTNAAIDQTIELNASSIYIIFDYEN');
INSERT INTO proteininfo VALUES ('6324599', 'NP_014668.1','Homolog of SIR2; involved in telomeric silencing; Hst3p [Saccharomyces cerevisiae]','MTSVSPSPPASRSGSMCSDLPSSLQTEKLAHIIGLDADDEVLRRVTKQLSRSRRIACLTGAGISCNAGIPDFRSSDGLYDLVKKDCSQYWSIKSGREMFDISLFRDDFKISIFAKFMERLYSNVQLAKPTKTHKFIAHLKDRNKLLRCYTQNIDGLEESIGLTLSNRKLPLTSFSSHWKNLDVVQLHGDLKTLSCTKCFQTFPWSRYWSRCLRRGELPLCPDCEALINKRLNEGKRTLGSNVGILRPNIVLYGENHPSCEIITQGLNLDIIKGNPDFLIIMGTSLKVDGVKQLVKKLSKKIHDRGGLIILVNKTPIGESSWHGIIDYQIHSDCDNWVTFLESQIPDFFKTQDQIKKLRQLKREASDLRKQMKAQKDSIGTPPTTPLRTAQGIDIQGNNELNTKIKSLNTVKRKILSPENSSEEDEEENLDTRKRAKIRPTFGDNQAS');
INSERT INTO proteininfo VALUES ('6324597', 'NP_014666.1','Ada Histone acetyltransferase complex component ; protein of the Ada histone acetyltransferase complex; Ahc1p [Saccharomyces cerevisiae]','MMSPAQDKLQHQHHNPNSSSSSSSKMTNVYQVTTPKSPQDLENNMDEPFKMDTATSNPDKDSENTQRLKYECAKGEIQNVLNLHIMLNHKHVRHLRRNVQKVNAKLALLETLHKDTGLLNKIERTYQLKIKQHQQHSVLGGHFHDSTATENTNASNYNLSYPVLSDYNINCQPLSSSSNRNLSTTRIPHHHYHTRSKSNGLLLEPSALRPANSNIIDYRLTGSKSLSEAITKPTPVSLPHSNSDGISSPRSSSISPLDEQPGFQILPFKPSQMHLNHRRNYSSTCLTSNSGIIGKTENNEPIFRRYDGILVIITCSKCDRSGFTSAQGIVNHTRLKHSKLYSSQPLAVLNNQKLLPNDKQDPEILSKFKKLNLDPNKDYLPSDIAIPKPQSPINHSENHTRAPKTVKNTPHLEKLYQNKEDFKKLIDMVNETPDDLNEYLKQREIQLRYQKEQEEESSKSDDEASYVPSPSLSATATTTTTTDPPSPPVLSSSLQRKLLRKRKLSLNSSTPMEDLPLRERLRANPTDKKPRKAALLTNELEGPDPAAKSSSYYNLRSKSRLRGSHT');
INSERT INTO proteininfo VALUES ('6324596', 'NP_014665.1','Hypothetical ORF; Yor022cp [Saccharomyces cerevisiae]','MLRFTHRGLPSSTRFRNIFVRLNHIYVPWFYAIDVPNSKPYLPTYQTLHSPKKFKPFSVDDSNRLEKASKRQERRPVLVNEDYLFKVDLSHMELSPTYWEGPTYQVRRGVWFDSSNQPLSSDLTSEIEGLYKQLKFDDSNDDPTTTPPAESQDIFRLKGKYPVDKENEGEQKNGSSNKDENESTFKFILFANKQTAFLLSDLDGGKLQLAFLRSNLAQSLPINATMITRSYKYSSSATTKQTSTSFKAAKTPQTEVADGSNSSKSRSIETKLEKKVSNLFNLSDFLQLFNGNASKDQDDAQSLEKQMETDYNNADNSQGANASSKIEDGKNSGASDRQIRSNRRDVDNLILCVHGIGQTLGKKYEYVNFAHTVNLLRSNMKKIYNNSEKLQSLNTAPDYKSNCNVQVLPITWRHSISFQTDAKEENIENPDLPTLSQVTVNGVLPLRKLLADGLLDILLYVEPYYQDMILQQVTSQLNKTYRIFKEFNPEFDGKVHLVGHSLGSMILFDILSKQKKYELEFQVDNLFFIGSPIGLLKLIQRTKIGDRPEFPNDLERKLTVQRPQCKDIYNVYHVCDPISYRMEPLVSKEMAHYEQTYLPHCSEAYGLTSKVLEFGENIWKDLPGTDENNLQSKKTSPEKKEVKLSENLTRMLTGLNYTGRLDYAMSPSLLEVDFISAIKSHVSYFEEPDIAAFILKEILSKHENASEIYVKRKTG');
INSERT INTO proteininfo VALUES ('6324595', 'NP_014664.1','Hypothetical ORF; Yor021cp [Saccharomyces cerevisiae]','MKYIIEHMEEGFSEWVILEYSQILREVGAENLILSSLPESTTEKDIPQRLLKLGLRWTTKDLKGINEDFKDLELLKDGRVCLLDPRATIDLQPEDATKFDYFVFGGILGDHPPRDRTKELKTAYPNLLISRRLGDKQMTTDTAIRTTQLIIKDRIAFEDIKFIDYPEFRFNKNEATEMPFRYVLDKEGKPILPEGMLDLIKKDSAQSLDDLLM');
INSERT INTO proteininfo VALUES ('6324594', 'NP_014663.1','Mitochondrial matrix co-chaperonin that inhibits the ATPase activity of Hsp60p, a mitochondrial chaperonin; involved in protein folding and sorting in the mitochondria; 10 kD heat shock protein with similarity to E. coli groES; Hsp10p [Saccharomyces cerevisiae]','MSTLLKSAKSIVPLMDRVLVQRIKAQAKTASGLYLPEKNVEKLNQAEVVAVGPGFTDANGNKVVPQVKVGDQVLIPQFGGSTIKLGNDDEVILFRDAEILAKIAKD');
INSERT INTO proteininfo VALUES ('6324593', 'NP_014662.1','Hypothetical ORF; Yor019wp [Saccharomyces cerevisiae]','MISVCPQNDLQKCYRSLTFDVPGQQFEERNEQNLKKRAKKKGSFQPSVAFDTVPSTAGYSSIDDSREGFKGVPVPNYYTMEECYDDETDSFSPNLQYYLRDTFQSSPFLNTRKENKSESSSFPMRSSKLLEKNSDIKKYFLVSKNGKIVRRDYPSTPVIVNETLMINRFEKNWIKLWRQRKLQINERLNDKKKWFTYPELIFSEERIKPLYRGDDSAPCTKEQKRKHKILQQKVGYPNNPKTIVCHINGKKHTWVALDWTVYKFARNLDHIVVITTLPKMISNRKKTAKDDTEWAPGYQKEVIDQKLNDIFDYILQLVKVVKISVKITLEIIVGKIKKSLVDVINVHTPDFLVLATLKHERNENLITYKSKKLTDVFPVSYPIPTFVVPSKRMYSFELNLQREVNEHYVSKNHMKHEHTDVESMSSSMFKKNTISDISSHISVDSYAEDFKRQGYIKKQFNTSNDSIPRKLTGLAQHSRRKITGDIEKLQDDEKDRECTKEKLLLKKIDIIIRESLKSSLAIETLPGKNVSQSSHGDQISSFKNALIGNGSKNTKFRKSLIPYSSSEEQNTTTTIKLSSSPTSQIKFATSVKHKDGRAALGKARNLPDIRHSISFDKENSFDPSDKSSSVDNSIPLRKVKSAGALRKVKTNDSSSSAGSKKSSSSFSTVNTFTGGGVGIFKVFKSGSSSGNKSSSRRNSSSGDVFESDDRNDKKKKKKKKKKSLFLFGKI');
INSERT INTO proteininfo VALUES ('6324592', 'NP_014661.1','Membrane protein; overexpression confers resistance to the GST substrate o-dinitrobenzene as well as to zinc and calcium; contains a PY-motif, which is required for Rod1p interaction with Rsp5p, a hect-type ubiquitin ligase; Rod1p [Saccharomyces cerevisiae]','MFSSSSRPSKEPLLFDIRLRNLDNDVLLIKGPPDEASSVLLSGTIVLSITEPIQIKSLALRLFGRLRLNIPTVLQTVHGPHKRYSKFERNIYSHFWDDFNIKSYFQNLYDNHNNGKITISSKSSTNLAALPKRKRALSTASLISSNGQTSASKNYHTLVKGNYEFPFSAIIPGSLVESVEGLPNAAVTYALEATIERPKQPDLICKKHLRVIRTLAIDAVELSETVSVDNSWPEKVDYTISIPTKAIAIGSSTMINILIVPILKGLKLGPVRISLVENSQYCGSYGGVINQERMVAKLKLKDPLKHVAQIKKKRSLNEAADEGVDTDTGEFQDKWEVRALLNIPASLTKCSQDCRILSNIKVRHKIKFTISLLNPDGHISELRAALPVQLFISPFVPVNVKTSDVIERTLKTFGPSYQVTSQHDNSFSSKNFVDDSEEDVIFQRSASALQLSSMPTIVSGSTLNINSTDAEATAVADTTMVTSLMVPPNYGNHVYDRVYGEVTNEDETSASASSSAVESQAIHNIQNLYISDSNNSNNPILAPNPQIKIEDDSLNNCDSRGDSVNNSNLNLVNSNLTISENWNNNSPSANRYNNIINAGLNSPSLTPSFAHLSRRNSYSRQTSSTSLKNDLELTDLSRVPSYDKAMKSDMIGEDLPPAYPEEELGVQENKKIELERPQILHHKSTSSLLPLPGSSKSSNNLKRSSSRTHLSHSPLPRNNSGSSVSLQQLARNNTDSSFNLNLSFTSAKSSTGSRHFPFNMTTSFTSNSSSKNNSHFDKTDSTSDANKPREEENYTSATHNRRSRSSSVRSNNSNSPLRQGTGSFANLMEMFTKRDRS');
INSERT INTO proteininfo VALUES ('6324591', 'NP_014660.1','Protein with a role in mitochondrial RNA stability and/or processing, located in the mitochondrial membrane; Pet127p [Saccharomyces cerevisiae]','MGFYNCRFLSRRLSVEPCRIGSAAKSYQQRSIYHFGAALTNAPSGRETPDKLRSDLHSALEMVDEIYDTNSTVEDIGNKEKGGRQKYTEEMDKAINLLKTNIKKEYRHDKYLERTKVGTYPGRRTYPGRRTYPARRTYPASRTYSDSNSYTFRINVQKIRHALVRYNQDGVQKHNQKPPRIGHGLTRVLYQPLSLQKLRDNRSRMYNFDPAVENINPEYLEKKSEKDVNTDSSGEGQSKPIFITPHKDESLLKVAKEHRKKYISSSSSMTSVLSQLHYLLSNFRRLNIIDSSISKNFPQKNCNYSESAYFPSAVILRKKRNGICSIDSDRSLDREIVLSVLGHYLEDFLTEKSLKNSSKSENYHYSSIDEFIVRSQLDAYDPNLPGTGVFDLKTRAVSAIRYDLSHVESNNNQTGYEIDKVYGEFESLEREYFELIRSALLKYSLQARIGKMDGIFVAYHNISKMFGFQYLPLDELDYIIHSSYNSKFDSLLKEKNDITKGIYGEEDYILHYDRDDRKIACLVANREFKMSMNLFSNILKHVEQLLNSSNTKWEKCKIMLKTEVEEKRSKSGRFFNEPVLNIVALPLSPEYEDKSLLVKDTSNEQLTEELLNLRSYNENLLEEHLNSLVGFKVNVKHFYHHHPNTTHLPDFALKKNDILDTESRKYISDMMKRDWYKDIPSTQTPNFFHASDVSTWEVNSTFTDINDKQILRKLYFKYLDVKLNALKNQVITRQEPDMSKKDEIMNRIKSLQARNDHRDNGSNKRYSNFGPTRLQTKLRAYAKKGALRRKLLERSNKFHI');
INSERT INTO proteininfo VALUES ('6324590', 'NP_014659.1','Protein with similarity to Emp24p and Erv25p, member of the p24 family involved in ER to Golgi transport; Erp4p [Saccharomyces cerevisiae]','MRVFTLIAILFSSSLLTHAFSSNYAPVGISLPAFTKECLYYDLSSDKDVLVVSYQVLTGGNFEIDFDITAPDGSVIVTERQKKHSDFLLKSFGIGKYTFCLSNNYGTSPKKVEITLEKEKEIVSSHESKEDIIANNAIEEIDRNLNKITKTMDYLRAREWRNMYTVSSTESRLTWLSLLIMGVMVGISIVQALIIQFFFTSRQKNYV');
INSERT INTO proteininfo VALUES ('6324588', 'NP_014657.1','B-type regulatory subunit of protein phosphatase 2A (PP2A); Rts1p [Saccharomyces cerevisiae]','MMRGFKQRLIKKTTGSSSSSSSKKKDKEKEKEKSSTTSSTSKKPASASSSSHGTTHSSASSTGSKSTTEKGKQSGSVPSQGKHHSSSTSKTKTATTPSSSSSSSRSSSVSRSGSSSTKKTSSRKGQEQSKQSQQPSQSQKQGSSSSSAAIMNPTPVLTVTKDDKSTSGEDHAHPTLLGAVSAVPSSPISNASGTAVSSDVENGNSNNNNMNINTSNTQDANHASSQSIDIPRSSHSFERLPTPTKLNPDTDLELIKTPQRHSSSRFEPSRYTPLTKLPNFNEVSPEERIPLFIAKVDQCNTMFDFNDPSFDIQGKEIKRSTLDELIEFLVTNRFTYTNEMYAHVVNMFKINLFRPIPPPVNPVGDIYDPDEDEPVNELAWPHMQAVYEFFLRFVESPDFNHQIAKQYIDQDFILKLLELFDSEDIRERDCLKTTLHRIYGKFLSLRSFIRRSMNNIFLQFIYETEKFNGVAELLEILGSIINGFALPLKEEHKVFLVRILIPLHKVRCLSLYHPQLAYCIVQFLEKDPLLTEEVVMGLLRYWPKINSTKEIMFLNEIEDIFEVIEPLEFIKVEVPLFVQLAKCISSPHFQVAEKVLSYWNNEYFLNLCIENAEVILPIIFPALYELTSQLELDTANGEDSISDPYMLVEQAINSGSWNRAIHAMAFKALKIFLETNPVLYENCNALYLSSVKETQQRKVQREENWSKLEEYVKNLRINNDKDQYTIKNPELRNSFNTASENNTLNEENENDCDSEIQ');
INSERT INTO proteininfo VALUES ('6324586', 'NP_014655.1','Hypothetical ORF; Yor012wp [Saccharomyces cerevisiae]','MVASSINEESSLAVNLTSDVEKASKTLFKAFEKSYANDYLMKKFFHIPITEKVSRARINAMIHYYTTCYHDLDGEIAEANDFDAVAIWSRPGCHLPATLSDDESFNKIFFSRLDCEEARSHASGNGLLLPLCHRKRS');
INSERT INTO proteininfo VALUES ('6324585', 'NP_014654.1','Transporter of the ATP-binding cassette family, involved in uptake of sterols and anaerobic growth; Aus1p [Saccharomyces cerevisiae]','MSISKYFTPVADGSLTFNGANIQFGADAQGESKKSYDAEDSMPNPANQLNDITFQAEAGEMVLVLGYPTSTLFKTLFHGKTSLSYSPPGSIKFKNNEFKSFSEKCPHQIIYNNEQDVHFPFLTVEQTIDFALSCKFDIPKGERDQIRNELLREFGLSHVLKTIVGNDFFRGVSGGERKRISIIETFIANGSVYLWDNSTKGLDSATALDFLEILRKMAKATRSVNLVRISQASDKIVDKFDKILMLSDSYQLFYGTVDECLTYFRDTLGIEKDPNDCIIEYLTSILNFQFKNKNLGNLSNSSSASVLKTATGEVTKYTYNSDFDLYDQWKHSSYYRNIKQQIQGSSIDDSIKEVDPSDVSPIFNIPLKKQLLFCTKRAFQRSLGDKAYMTAQFISVVIQSLVIGSLFYEIPLTTIGSYSRGSLTFFSILFFTFLSLADMPIAFQRQPVVKKQSQLHFYTNWVETLSTTVFDYCFKLCLVIVFSIILYFLAHLQYKAARFFIFLLFLSFYNFCMVSLFALTTLVAPTISVANLFAGILLLAIAMYASYVIYLKNMHPWFVWIAYLNPAMYAMEAILSNELYNLKLDCSETIVPRGPTYNDVPFSHKACAWQGATLGNDYVRGRDYLKQGLSYTYHHVWRNFGIIIGFLVFFIACTLFASQYIKPYFNKDEIERNNSRLTRWLPFLNKKRGTRSSARNDSKYVGIPKSHSVSSSSSSLSAVPYQISPSNKEMALNDYNEQPITETVETQKHIISWKNINYTVGTKKLINNASGFISSGLTALMGESGAGKTTLLNVLSQRVETGVVSGEILIDGHPLTDEDAFKRSIGFVQQQDLHLDLLSVKESLEISCLLRGDGDRAYLDTVSNLLKLPSDILVADLNPTQRKLLSIGVELVTKPSLLLFLDEPTSGLDAEAALTIVKFLKQLSLQGQAIFCTIHQPSKSVISHFDNIFLLKRGGECVFFGPMDDACGYFMSHDNTLVYDKEHDNPADFVIDAVGNSNSSAGKDTAEEALTLNKEAIDWSALWESSVEKKLVKKETARLEDDARASGVDYTTSLWKQPSYLQQLALITRRQYICTKRDMTYVMAKYCLNGGAGLFIGFSFWHIKHNIIGLQDSIFFCFMALCVSSPLINQIQDKALKTKEVYVAREARSNTYHWTVLLLSQSIIELPLALTSSTLFFVCAFFSCGFNNAGWSAGVFFLNYMLFAAYYSTLGLWLIYTAPNLQTAAVFVAFIYSFTASFCGVMQPYSLFPTFWKFMYRVSPYTYFVETFVSILLHNWEIKCDMSEMVPGQPLTGQSCGQFMEAFIEEYGGYLHNKNTFTVCAYCTYTVGDDFLKNENMSYDHVWRNFGIEWAFVGFNFFAMFAGYYLTYVARIWPKVFKIITKVIPHRGKKPVQN');
INSERT INTO proteininfo VALUES ('6324584', 'NP_014653.1','Cold shock-induced protein of the Srp1p/Tip1p family of serine-alanine-rich proteins; Tir2p [Saccharomyces cerevisiae]','MAYIKIALLAAIAALASAQTQEEIDELNVILNDVKSNLQEYISLAEDSSSGFSLSSLPSGVLDIGLALASATDDSYTTLYSEVDFAAVSKMLTMVPWYSSRLLPELESLLGTSTTAASSTEASSAATSSAVASSSETTSSAVASSSEATSSAVASSSEASSSAATSSAVASSSEATSSTVASSTKAASSTKASSSAVSSAVASSTKASAISQISDGQVQATSTVSEQTENGAAKAVIGMGAGVMAAAAMLL');
INSERT INTO proteininfo VALUES ('6324583', 'NP_014652.1','Tir4p [Saccharomyces cerevisiae]','MAYSKITLLAALAAIAYAQTQAQINELNVVLDDVKTNIADYITLSYTPNSGFSLDQMPAGIMDIAAQLVANPSDDSYTTLYSEVDFSAVEHMLTMVPWYSSRLLPELEAMDASLTTSSSAATSSSEVASSSIASSTSSSVAPSSSEVVSSSVAPSSSEVVSSSVAPSSSEVVSSSVASSSSEVASSSVAPSSSEVVSSSVASSSSEVASSSVAPSSSEVVSSSVAPSSSEVVSSSVASSSSEVASSSVAPSSSEVVSSSVASSTSEATSSSAVTSSSAVSSSTESVSSSSVSSSSAVSSSEAVSSSPVSSVVSSSAGPASSSVAPYNSTIASSSSTAQTSISTIAPYNSTTTTTPASSASSVIISTRNGTTVTETDNTLVTKETTVCDYSSTSAVPASTTGYNNSTKVSTATICSTCKEGTSTATDFSTLKTTVTVCDSACQAKKSATVVSVQSKTTGIVEQTENGAAKAVIGMGAGALAAVAAMLL');
INSERT INTO proteininfo VALUES ('6324582', 'NP_014651.1','diepoxybutane and mitomycin C resistance; Yor008c-ap [Saccharomyces cerevisiae]','MWRSYLVFLFFMTPRIQTYCPVPVLRSMAVLNIISPLIIFVSPIKKQDSLHSSACYANLTLVEKLQLWHSMSND');
INSERT INTO proteininfo VALUES ('6324581', 'NP_014650.1','Protein involved in cell wall integrity and stress response; Slg1p [Saccharomyces cerevisiae]','MRPNKTSLLLALLSILSQANAYEYVNCFSSLPSDFSKADSYNWQSSSHCNSECSAKGASYFALYNHSECYCGDTNPSGSESTSSSCNTYCFGYSSEMCGGEDAYSVYQLDSDTNSNSISSSDSSTESTSASSSTTSSTTSSTTSTTSSTTSSTTSSMASSSTVQNSPESTQAAASISTSQSSSTVTSESSLTSDTLATSSTSSQSQDATSIIYSTTFHTEGGSTIFVTNTITASAQNSGSATGTAGSDSTSGSKTHKKKANVGAIVGGVVGGVVGAVAIALCILLIVRHINMKREQDRMEKEYQEAIKPVEYPDKLYASSFSSNHGPSSGSFEEEHTKGQTDINPFDDSRRISNGTFINGGPGGKNNVLTVVNPDEAD');
INSERT INTO proteininfo VALUES ('6324580', 'NP_014649.1','Glutamine-rich cytoplasmic protein of unknown function, contains tetratricopeptide (TPR) repeats, which often mediate protein-protein interactions; conserved in human and C. elegans; Sgt2p [Saccharomyces cerevisiae]','MSASKEEIAALIVNYFSSIVEKKEISEDGADSLNVAMDCISEAFGFEREAVSGILGKSEFKGQHLADILNSASRVPESNKKDDAENVEINIPEDDAETKAKAEDLKMQGNKAMANKDYELAINKYTEAIKVLPTNAIYYANRAAAHSSLKEYDQAVKDAESAISIDPSYFRGYSRLGFAKYAQGKPEEALEAYKKVLDIEGDNATEAMKRDYESAKKKVEQSLNLEKTVPEQSRDADVDASQGASAGGLPDLGSLLGGGLGGLMNNPQLMQAAQKMMSNPGAMQNIQKMMQDPSIRQMAEGFASGGGTPNLSDLMNNPALRNMAGNLFGGAGAQSTDETPDNENKQ');
INSERT INTO proteininfo VALUES ('6324579', 'NP_014648.1','Hypothetical ORF; Yor006cp [Saccharomyces cerevisiae]','MGKGKNKMHEPKNGRPQRGANGHSSRQNHRRMEMKYDNSEKMKFPVKLAMWDFDHCDPKRCSGKKLERLGLIKSLRVGQKFQGIVVSPNGKGVVCPDDLEIVEQHGASVVECSWARLEEVPFNKIGGKHERLLPYLVAANQVNYGRPWRLNCVEALAACFAIVGRMDWASELLSHFSWGMGFLELNKELLEIYQQCTDCDSVKRAEEEWLQKLEKETQERKSRAKEEDIWMMGNINRRGNGSQSDTSESEENSEQSDLEGNNQCIEYDSLGNAIRIDNMKSREAQSEESEDEESGSKENGEPLSYDPLGNLIR');
INSERT INTO proteininfo VALUES ('6324578', 'NP_014647.1','DNA ligase required for nonhomologous end-joining (NHEJ), forms stable heterodimer with required cofactor Lif1p, catalyzes DNA ligation as part of a complex with Lif1p and Nej1p; involved in meiosis, not essential for vegetative growth; Dnl4p [Saccharomyces cerevisiae]','MISALDSIPEPQNFAPSPDFKWLCEELFVKIHEVQINGTAGTGKSRSFKYYEIISNFVEMWRKTVGNNIYPALVLALPYRDRRIYNIKDYVLIRTICSYLKLPKNSATEQRLKDWKQRVGKGGNLSSLLVEEIAKRRAEPSSKAITIDNVNHYLDSLSGDRFASGRGFKSLVKSKPFLHCVENMSFVELKYFFDIVLKNRVIGGQEHKLLNCWHPDAQDYLSVISDLKVVTSKLYDPKVRLKDDDLSIKVGFAFAPQLAKKVNLSYEKICRTLHDDFLVEEKMDGERIQVHYMNYGESIKFFSRRGIDYTYLYGASLSSGTISQHLRFTDSVKECVLDGEMVTFDAKRRVILPFGLVKGSAKEALSFNSINNVDFHPLYMVFDLLYLNGTSLTPLPLHQRKQYLNSILSPLKNIVEIVRSSRCYGVESIKKSLEVAISLGSEGVVLKYYNSSYNVASRNNNWIKVKPEYLEEFGENLDLIVIGRDSGKKDSFMLGLLVLDEEEYKKHQGDSSEIVDHSSQEKHIQNSRRRVKKILSFCSIANGISQEEFKEIDRKTRGHWKRTSEVAPPASILEFGSKIPAEWIDPSESIVLEIKSRSLDNTETNMQKYATNCTLYGGYCKRIRYDKEWTDCYTLNDLYESRTVKSNPSYQAERSQLGLIRKKRKRVLISDSFHQNRKQLPISNIFAGLLFYVLSDYVTEDTGIRITRAELEKTIVEHGGKLIYNVILKRHSIGDVRLISCKTTTECKALIDRGYDILHPNWVLDCIAYKRLILIEPNYCFNVSQKMRAVAEKRVDCLGDSFENDISETKLSSLYKSQLSLPPMGELEIDSEVRRFPLFLFSNRIAYVPRRKISTEDDIIEMKIKLFGGKITDQQSLCNLIIIPYTDPILRKDCMNEVHEKIKEQIKASDTIPKIARVVAPEWVDHSINENCQVPEEDFPVVNY');
INSERT INTO proteininfo VALUES ('6324577', 'NP_014646.1','Protein required for cell viability; Yor004wp [Saccharomyces cerevisiae]','MRQKRAKSYRKQLLVYSHTFKFREPYQVLVDNQLVLECNNSNFNLPSGLKRTLQADVKVMITQCCIQALYETRNDGAINLAKQFERRRCNHSFKDPKSPAECIESVVNISGANKHRYVVASQDIDLRRKLRTVPGVPLIHLTRSVMVMEPLSTASAKASKITEEQKLYKGLNDPNIEKLQESGDGSGKESITKKRKLGPKAPNPLSVKKKKKVNSPSDEVKDKEDTSKEKKKRRRRKHKSNTNVPVSNGTTAAQ');
INSERT INTO proteininfo VALUES ('6324576', 'NP_014645.1','subtilisin-like protease III; Ysp3p [Saccharomyces cerevisiae]','MKFSTILPILWANCCLCMIIPDFDGIVRFIENIDGTRSVRAGEGLGQHDPGNFHTEHQHVAHKTEFLPYRYVIVFNEDISLQQIQSHMQVVQKDHSTSVGKLTENDAFWRVISSSVSSKSQFGGIDNFFDINGLFRGYTGYFTDEIIKIISQDPIIKFVEQETTVKISNSSLQEEAPWGLHRVSHREKPKYGQDLEYLYEDAAGKGVTSYVLDTGIDTEHEDFEGRAEWGAVIPANDEASDLNGHGTHCAGIIGSKHFGVAKNTKIVAVKVLRSNGEGTVSDVIKGIEYVTKEHIESSKKKNKEFKGSTANLSLGSSKSLAMEMAVNAAVDSGVHFAIAAGNEDEDACLSSPAGAEKSITVGASTFSDDRAFFSNWGTCVDVFAPGINIMSTYIGSRNATLSLSGTSMASPHVAGILSYFLSLQPAPDSEFFNDAPSPQELKEKVLKFSTQGVLGDIGDDTPNKLIYNGGGKKLDGFW');
INSERT INTO proteininfo VALUES ('6324575', 'NP_014644.1','Glucosyltransferase, involved in transfer of oligosaccharides from dolichyl pyrophosphate to asparagine residues of proteins during N-linked protein glycosylation; mutations in human ortholog are associated with disease; Alg6p [Saccharomyces cerevisiae]','MAIGKRLLVNKPAEESFYASPMYDFLYPFRPVGNQWLPEYIIFVCAVILRCTIGLGPYSGKGSPPLYGDFEAQRHWMEITQHLPLSKWYWYDLQYWGLDYPPLTAFHSYLLGLIGSFFNPSWFALEKSRGFESPDNGLKTYMRSTVIISDILFYFPAVIYFTKWLGRYRNQSPIGQSIAASAILFQPSLMLIDHGHFQYNSVMLGLTAYAINNLLDEYYAMAAVCFVLSICFKQMALYYAPIFFAYLLSRSLLFPKFNIARLTVIAFATLATFAIIFAPLYFLGGGLKNIHQCIHRIFPFARGIFEDKVANFWCVTNVFVKYKERFTIQQLQLYSLIATVIGFLPAMIMTLLHPKKHLLPYVLIACSMSFFLFSFQVHEKTILIPLLPITLLYSSTDWNVLSLVSWINNVALFTLWPLLKKDGLHLQYAVSFLLSNWLIGNFSFITPRFLPKSLTPGPSISSINSDYRRRSLLPYNVVWKSFIIGTYIAMGFYHFLDQFVAPPSKYPDLWVLLNCAVGFICFSIFWLWSYYKIFTSGSKSMKDL');
INSERT INTO proteininfo VALUES ('6324574', 'NP_014643.1','Exonuclease component of the nuclear exosome; contributes to the quality-control system that retains and degrades aberrant mRNAs in the nucleus; Rrp6p [Saccharomyces cerevisiae]','MTSENPDVLLSRVINVVRAASSLASQDVDFYKNLDRGFSKDLKSKADKLADMANEIILSIDEHHESFELKEEDISDLWNNFGNIMDNLLEMSDHSLDKLNCAINSKSRGSDLQYLGEFSGKNFSPTKRVEKPQLKFKSPIDNSESHPFIPLLKEKPNALKPLSESLRLVDDDENNPSHYPHPYEYEIDHQEYSPEILQIREEIPSKSWDDSVPIWVDTSTELESMLEDLKNTKEIAVDLEHHDYRSYYGIVCLMQISTRERDYLVDTLKLRENLHILNEVFTNPSIVKVFHGAFMDIIWLQRDLGLYVVGLFDTYHASKAIGLPRHSLAYLLENFANFKTSKKYQLADWRIRPLSKPMTAYARADTHFLLNIYDQLRNKLIESNKLAGVLYESRNVAKRRFEYSKYRPLTPSSEVYSPIEKESPWKILMYQYNIPPEREVLVRELYQWRDLIARRDDESPRFVMPNQLLAALVAYTPTDVIGVVSLTNGVTEHVRQNAKLLANLIRDALRNIKNTNEEATPIPSSETKADGILLETISVPQIRDVMERFSVLCNSNISKSRAKPVTNSSILLGKILPREEHDIAYSKDGLPNKVKTEDIRIRAQNFKSALANLEDIIFEIEKPLVVPVKLEEIKTVDPASAPNHSPEIDNLDDLVVLKKKNIQKKQPAKEKGVTEKDAVDYSKIPNILSNKPGQNNRQQKKRRFDPSSSDSNGPRAAKKRRPAAKGKNLSFKR');
INSERT INTO proteininfo VALUES ('6324573', 'NP_014642.1','Cyclin, negatively regulates phosphate metabolism; Pho80p-Pho85p (cyclin-CDK complex) phosphorylates Pho4p and Swi5p; deletion of PHO80 leds to aminoglycoside supersensitivity; truncated form of PHO80 affects vacuole inheritance; Pho80p [Saccharomyces cerevisiae]','MESTSGERSENIHEDQGIPKVILPADFNKCSRTDLVVLISRMLVSLIAINENSATKKSDDQITLTRYHSKIPPNISIFNYFIRLTKFSSLEHCVLMTSLYYIDLLQTVYPDFTLNSLTAHRFLLTATTVATKGLCDSFSTNAHYAKVGGVRCHELNILENDFLKRVNYRIIPRDHNITLCSIEQKQKKFVIDKNALGSLDLDSYSYVNRPKSGYNVLDKYYRRIVQLVGSFNASPDKSRKVDYVLPPNIDIVSESGSQTTQLKGSSSPNSHSSQKRYSEAKDAHIYNKRSKPD');
INSERT INTO proteininfo VALUES ('6324571', 'NP_014640.1','DHHC-CRD protein; Yol003cp [Saccharomyces cerevisiae]','MPVKLRWPWLGIAIPTFLISFIGYGAHYFILSNFLSVPKQITFEFCLSMIWLSYYLAICTNPGRPLPNYKPPPDIWRNFCKKCQSYKPERSHHCKTCNQCVLMMDHHCPWTMNCVGFANYPHFLRFLFWIIVTTSVLFCIQAKRIYFIWQQRHLPGYFFKKSELIFLTISSPLNSFVLLTITILFLRCLFNQILNGRSQIESWDMDRLESLFNSGRLTQKLIDNTWRIYPESRSFQNKKDAEEHLTKKRPRFDELVNFPYDFDLYTNALLYLGPIHLWLWPYGVPTGDGNNFPKNGISKYEANSSLEDHILSLPWPPDGGKTNTVFNHGSSTIEMRNESGEQLIRTRLPQNGRHASREKWYNDWGESLDDFGVDVDME');
INSERT INTO proteininfo VALUES ('6324570', 'NP_014639.1','DNA binding protein involved in transcriptional regulation; Sin3p [Saccharomyces cerevisiae]','MSQVWHNSNSQSNDVATSNDATGSNERNEKEPSLQGNKPGFVQQQQRITLPSLSALSTKEEDRRDSNGQQALTSHAAHILGYPPPHSNAMPSIATDSALKQPHEYHPRPKSSSSSPSINASLMNAGPAPLPTVGAASFSLSRFDNPLPIKAPVHTEEPKSYNGLQEEEKATQRPQDCKEVPAGVQPADAPDPSSNHADANDDNNNNENSHDEDADYRPLNVKDALSYLEQVKFQFSSRPDIYNLFLDIMKDFKSQAIDTPGVIERVSTLFRGYPILIQGFNTFLPQGYRIECSSNPDDPIRVTTPMGTTTVNNNISPSGRGTTDAQELGSFPESDGNGVQQPSNVPMVPSSVYQSEQNQDQQQSLPLLATSSGLPSIQQPEMPAHRQIPQSQSLVPQEDAKKNVDVEFSQAISYVNKIKTRFADQPDIYKHFLEILQTYQREQKPINEVYAQVTHLFQNAPDLLEDFKKFLPDSSASANQQVQHAQQHAQQQHEAQMHAQAQAQAQAQAQVEQQKQQQQFLYPASGYYGHPSNRGIPQQNLPPIGSFSPPTNGSTVHEAYQDQQHMQPPHFMPLPSIVQHGPNMVHQGIANENPPLSDLRTSLTEQYAPSSIQHQQQHPQSISPIANTQYGDIPVRPEIDLDPSIVPVVPEPTEPIENNISLNEEVTFFEKAKRYIGNKHLYTEFLKILNLYSQDILDLDDLVEKVDFYLGSNKELFTWFKNFVGYQEKTKCIENIVHEKHRLDLDLCEAFGPSYKRLPKSDTFMPCSGRDDMCWEVLNDEWVGHPVWASEDSGFIAHRKNQYEETLFKIEEERHEYDFYIESNLRTIQCLETIVNKIENMTENEKANFKLPPGLGHTSMTIYKKVIRKVYDKERGFEIIDALHEHPAVTAPVVLKRLKQKDEEWRRAQREWNKVWRELEQKVFFKSLDHLGLTFKQADKKLLTTKQLISEISSIKVDQTNKKIHWLTPKPKSQLDFDFPDKNIFYDILCLADTFITHTTAYSNPDKERLKDLLKYFISLFFSISFEKIEESLYSHKQNVSESSGSDDGSSIASRKRPYQQEMSLLDILHRSRYQKLKRSNDEDGKVPQLSEPPEEEPNTIEEEELIDEEAKNPWLTGNLVEEANSQGIIQNRSIFNLFANTNIYIFFRHWTTIYERLLEIKQMNERVTKEINTRSTVTFAKDLDLLSSQLSEMGLDFVGEDAYKQVLRLSRRLINGDLEHQWFEESLRQAYNNKAFKLYTIDKVTQSLVKHAHTLMTDAKTAEIMALFVKDRNASTTSAKDQIIYRLQVRSHMSNTENMFRIEFDKRTLHVSIQYIALDDLTLKEPKADEDKWKYYVTSYALPHPTEGIPHEKLKIPFLERLIEFGQDIDGTEVDEEFSPEGISVSTLKIKIQPITYQLHIENGSYDVFTRKATNKYPTIANDNTQKGMVSQKKELISKFLDCAVGLRNNLDEAQKLSMQKKWENLKDSIAKTSAGNQGIESETEKGKITKQEQSDNLDSSTASVLPASITTVPQDDNIETTGNTESSDKGAKIQ');
INSERT INTO proteininfo VALUES ('6324569', 'NP_014638.1','RNA polymerase II core subunit; Rpb11p [Saccharomyces cerevisiae]','MNAPDRFELFLLGEGESKLKIDPDTKAPNAVVITFEKEDHTLGNLIRAELLNDRKVLFAAYKVEHPFFARFKLRIQTTEGYDPKDALKNACNSIINKLGALKTNFETEWNLQTLAADDAF');
INSERT INTO proteininfo VALUES ('6324568', 'NP_014637.1','topoisomerase I; Top1p [Saccharomyces cerevisiae]','MTIADASKVNHELSSDDDDDVPLSQTLKKRKVASMNSASLQDEAEPYDSDEAISKISKKKTKKIKTEPVQSSSLPSPPAKKSATSKPKKIKKEDGDVKVKTTKKEEQENEKKKREEEEEEDKKAKEEEEEYKWWEKENEDDTIKWVTLKHNGVIFPPPYQPLPSHIKLYYDGKPVDLPPQAEEVAGFFAALLESDHAKNPVFQKNFFNDFLQVLKESGGPLNGIEIKEFSRCDFTKMFDYFQLQKEQKKQLTSQEKKQIRLEREKFEEDYKFCELDGRREQVGNFKVEPPDLFRGRGAHPKTGKLKRRVNPEDIVLNLSKDAPVPPAPEGHKWGEIRHDNTVQWLAMWRENIFNSFKYVRLAANSSLKGQSDYKKFEKARQLKSYIDAIRRDYTRNLKSKVMLERQKAVAIYLIDVFALRAGGEKSEDEADTVGCCSLRYEHVTLKPPNTVIFDFLGKDSIRFYQEVEVDKQVFKNLTIFKRPPKQPGHQLFDRLDPSILNKYLQNYMPGLTAKVFRTYNASKTMQDQLDLIPNKGSVAEKILKYNAANRTVAILCNHQRTVTKGHAQTVEKANNRIQELEWQKIRCKRAILQLDKDLLKKEPKYFEEIDDLTKEDEATIHKRIIDREIEKYQRKFVRENDKRKFEKEELLPESQLKEWLEKVDEKKQEFEKELKTGEVELKSSWNSVEKIKAQVEKLEQRIQTSSIQLKDKEENSQVSLGTSKINYIDPRLSVVFCKKYDVPIEKIFTKTLREKFKWAIESVDENWRF');
INSERT INTO proteininfo VALUES ('6324567', 'NP_014636.1','Appears to be a structural component of the chitin synthase 3 complex; Yol007cp [Saccharomyces cerevisiae]','MRLPEISIWKVILLLHLFALQEFQLVSAANLPSLSSSTKAADSSSKGSSSAKTTTSLGKSSVTSKDVSSSHNVTSSTKMPKITTSASTSLYTNSSLWSNNSVISTSSITPSSVYIPVTDGNKFLYQAHHPNGTVFIAFAGCLGAILLSLTGAWIALNIKSWRSARKENKLRNLENQYQHDPFYFQTNINDDESETSSHSDDSDISEKVLKNNSSRMSLYTLGSTSVLNLLNNKTDANDNFRSSMFISPTEILQSDANNSNTWSQSNESAIYDSLSSTPREPGATQILGKFTDSTNPFNYTSYNLSPDSEDRSTPKSNVSQGKVKKYRPPSVHLDQLLDGKE');
INSERT INTO proteininfo VALUES ('6324566', 'NP_014635.1','Hypothetical ORF; Yol008wp [Saccharomyces cerevisiae]','MVLIIRPSQTLILFRKAMLKPIGRYPLKRNFFGLSGTNHTIREQRYVLRKAINAPPSTVYAAVSEVAQYKEFIPYCVDSFVDKRNPVDNKPLIAGLRVGFKQYDEEFICNVTCKDTDHTYTVVAETISHNLFHLLISKWTIMPHPNRPNAAMVELLLRFKFKSRIYNSVSLIFAKTVTELVMNAFAKRAYHLVRLAMLKPSSKEGSP');
INSERT INTO proteininfo VALUES ('6324565', 'NP_014634.1','Required for normal mitochondrial morphology and distribution; Mdm12p is a mitochondrial outer membrane protein. An Mdm12p homolog exists in S. Pombe which confers a dominant negative phenotype when expressed in S. cerevisiae; Mdm12p [Saccharomyces cerevisiae]','MSFDINWSTLESDNRLNDLIRKHLNSYLQNTQLPSYVSNLRVLDFDLGKVGPAITLKEITDPLDEFYDSIREEADQETEENNDNKEDSEHICPDRTIANHEGPKDDFEAPVVMPSPNDIQFLLEVEYKGDLLVTIGADLVLNYPVEKFMTLPVKLSISDIGLHSLCIVACLSKQLFLSFLCDVSDPALDDNQTVLDPKGPILAATKPLERISIVRSMKIETEIGEQYQGQGSVLRSVGELEQFLFTIFKDFLRKELAWPSWINLDFNDGDE');
INSERT INTO proteininfo VALUES ('6324564', 'NP_014633.1','RNA terminal phosphate cyclase-like protein involved in rRNA processing at sites A0, A1, and A2; does not possess detectable RNA cyclase activity; Rcl1p [Saccharomyces cerevisiae]','MSSSAPKYTTFQGSQNFRLRIVLATLSGKPIKIEKIRSGDLNPGLKDYEVSFLRLIESVTNGSVIEISYTGTTVIYRPGIIVGGASTHICPSSKPVGYFVEPMLYLAPFSKKKFSILFKGITASHNDAGIEAIKWGLMPVMEKFGVRECALHTLKRGSPPLGGGEVHLVVDSLIAQPITMHEIDRPIISSITGVAYSTRVSPSLVNRMIDGAKKVLKNLQCEVNITADVWRGENSGKSPGWGITLVAQSKQKGWSYFAEDIGDAGSIPEELGEKVACQLLEEISKSAAVGRNQLPLAIVYMVIGKEDIGRLRINKEQIDERFIILLRDIKKIFNTEVFLKPVDEADNEDMIATIKGIGFTNTSKKIA');
INSERT INTO proteininfo VALUES ('6324563', 'NP_014632.1','Phospholipase B; phospholipase B/lysophospholipase; Plb3p [Saccharomyces cerevisiae]','MIRPLCSKIIISYIFAISQFLLAANAWSPTDSYVPGTVSCPDDINLVREATSISQNESAWLEKRNKVTSVALKDFLTRATANFSDSSEVLSKLFNDGNSENLPKIAVAVSGGGYRSMLTGAGVLAAMDNRTEGAYEHGLGGLLQSTTYLSGASGGNWLVGTLALNNWTSVQDILNNMQNDDSIWDLSDSIVTPGGINIFKTAKRWDHISNAVESKQNADYNTSLADIWGRALAYNFFPSLNRGGIGLTWSSIRDFPVFQNAEMPFPISVADGRYPGTKVINLNATVFEFNPFEMGSWDPSLNSFANVKYLGTNVSNGVPLERGKCTAGFDNAGFIMGTSSTLFNQFLLRINSTHLPSFITRLARHFLKDLSQDFNDIAVYSPNPFKDTKFLDSDYTTSIVDSDSLFLVDGGEDDENVPVLPLIQKERDVDIIFAVDNSADMRLAWPDGSSLVHTYERQFVKQGQGMSFPYVPDTNTFVNLGLNKKPTFFGCDANNLTDLQYIPPLVVYLPNAEYSFNSNQSAFKLSYSESQRRSMIQNGFEIATRNNFTDDPEFMGCVGCAIIRRKQQALNITLPPECETCFKNYCWNGTLDTTPLPDVEKDVHHSFINVNSFNSSIGQEESLYAGSSASQSSSSSSSSSSSSEIPSATATLEKKAATNSGSHLSGISVKFSAMIMLTLLMFTGAV');
INSERT INTO proteininfo VALUES ('6324562', 'NP_014631.1','Histone variant H2AZ, exchanged for histone H2A in nucleosomes by the SWR1 complex; involved in transcriptional regulation through prevention of the spread of silent heterochromatin; Htz1p [Saccharomyces cerevisiae]','MSGKAHGGKGKSGAKDSGSLRSQSSSARAGLQFPVGRIKRYLKRHATGRTRVGSKAAIYLTAVLEYLTAEVLELAGNAAKDLKVKRITPRHLQLAIRGDDELDSLIRATIASGGVLPHINKALLLKVEKKGSKK');
INSERT INTO proteininfo VALUES ('6324561', 'NP_014630.1','Ubiquitin-protein ligase required for endoplasmic reticulum-associated degradation (ERAD) of misfolded proteins; genetically linked to the unfolded protein response (UPR); regulated through association with Hrd3p; contains an H2 ring finger; Hrd1p [Saccharomyces cerevisiae]','MVPENRRKQLAIFVVVTYLLTFYCVYSATKTSVSFLQVTLKLNEGFNLMVLSIFILLNSTLLWQLLTKLLFGELRLIEHEHIFERLPFTIINTLFMSSLFHERYFFTVAFFGLLLLYLKVFHWILKDRLEALLQSINDSTTMKTLIFSRFSFNLVLLAVVDYQIITRCISSIYTNQKSDIESTSLYLIQVMEFTMLLIDLLNLFLQTCLNFWEFYRSQQSLSNENNHIVHGDPTDENTVESDQSQPVLNDDDDDDDDDRQFTGLEGKFMYEKAIDVFTRFLKTALHLSMLIPFRMPMMLLKDVVWDILALYQSGTSLWKIWRNNKQLDDTLVTVTVEQLQNSANDDNICIICMDELIHSPNQQTWKNKNKKPKRLPCGHILHLSCLKNWMERSQTCPICRLPVFDEKGNVVQTTFTSNSDITTQTTVTDSTGIATDQQGFANEVDLLPTRTTSPDIRIVPTQNIDTLAMRTRSTSTPSPTWYTFPLHKTGDNSVGSSRSAYEFLITNSDEKENGIPVKLTIENHEVNSLHGDGGEQIAKKIVIPDKFIQHI');
INSERT INTO proteininfo VALUES ('6324559', 'NP_014628.1','Hypothetical ORF; Yol014wp [Saccharomyces cerevisiae]','MRPHHFFCGNMGVMYTAMSGYETEDAQAYWACGRAYESAFATLTKKVPGTTFSADMPTSTWHGVLDCGYSSSINVAENKSSPIDYWNCGRTYARNYALSDALSLKPTNMLQYFLLVLFFICIIL');
INSERT INTO proteininfo VALUES ('6324558', 'NP_014627.1','Hypothetical ORF; Yol015wp [Saccharomyces cerevisiae]','MFIEYSRLPGFESINISFSRGMLRLAKFTNFATYKQKLEYFRLLAGSNKYIQRISVADFERHPDEINYIYIILISILQMEECMPVLVLCPTVYWVRFHWPGKCSVNSLNFTNETLKSAFHAVFTPYFALMKKVLGRIKNNMLLFAEPHANLNNLFVKHFHDLIYKSVKDEKTGEAILYLRTNVNVPNVFIDDKRAVFHGDGMKIGKFTGKFLCFSFKRTIRWSKLDSVDSFAVTTVNYRVSVNWEKTPRKTFLSLDSDTKNLHYISKKILNKKGKNATTSKTTKSSCTSENVCDDKTFSVEFPLTTSAKTEYLLRSNFSLEKINESNNPTLQELTLNRTHRLYRSNFRNEQSTTQRKFEKIGRTVSTDSGNKLLTFPEQKATRDSNPFSIELTHATVISSDESALKDTTNQAIAEMQRITPAIAKTISRRTANWVCSNPAPDPYGEPSTWSRILTPNLKIISESSPYYPVHLASPNSTFSRDQSVRSVVMRRSSVCVEKQNSFFRNYEHFKNILSRRTIKVKTSCPRLSVDVSDNKRENLSQEHLILPNKSREKVNRFKNCLHRVAEALRAAKENWDQHNPRNSIH');
INSERT INTO proteininfo VALUES ('6324557', 'NP_014626.1','Calmodulin-dependent protein kinase; Cmk2p [Saccharomyces cerevisiae]','MPKESEVINSEFHVDVQDPERLNGHPVAKFINKLSGQPESYVNRTNYIFGRTLGAGSFGVVRQARKLSTNEDVAIKILLKKALQGNNVQLQMLYEELSILQKLSHPNIVSFKDWFESKDKFYIVTQLATGGELFDRILSRGKFTEVDAVEIIVQILGAVEYMHSKNVVHRDLKPENVLYVDKSENSPLVIADFGIAKQLKGEEDLIYKAAGSLGYVAPEVLTQDGHGKPCDIWSIGVITYTLLCGYSPFIAESVEGFMEECTASRYPVTFHMPYWDNISIDVKRFILKALRLNPADRPTATELLDDPWITSKRVETSNILPDVKKGFSLRKKLRDAIEIVKLNNRIKRLRNMYSLGDDGDNDIEENSLNESLLDGVTHSLDDLRLQSQKKGGELTEEQMKLKSALTKDAFVQIVKAATKNKHKVLAGEEEDDSKKTLHDDRESKSED');
INSERT INTO proteininfo VALUES ('6324556', 'NP_014625.1','Protein involved in telomeric and mating-type locus silencing, interacts with Sir2p and also interacts with the Gal11p, which is a component of the RNA pol II mediator complex; Esc8p [Saccharomyces cerevisiae]','MTEIIDLDLVDDFIKKPMVKQQKNQSSKPRVKRRGQLTFDDFRNIKIVEEPVVLSHNSSIDESLDAATQNTKKREKYEGTCDEEMKTKEMEANMASKYSNIKTHSNDTNKVESISEHTTSNNRPLNTLNWSPNIPLRYSDFAKFMSDETVTESNWAPPLCTPLPYAGDVMKILSFIVKFKWVFSDDLLNLSFQDVEIGLELKVAGHSAKNIRICQDKMNLLFCSLLRLLFCSEKRADNQTHRNFTLKRFLSLKNPYGKLVGKLRSLIQEWGLPKEWRGNSDILSTLNFNGGGLLTMEPLDRIILLRCMIDWNCSYSALFHNEIQRLTHLKGDTGFNHQTFHASRFAMCGANNILDSCEVLCSLMSQKLENRKKRKPSDKGKLSKINSQMKFLKGVRKSLSEKVTTDRLRAAVKINEEWGEYFANEFTHTPIDDPTVDEIYKLRTSEFMIARIPRVGDFYLPPFWIGNECSSVNTSYSFNDMSTYLNYFVKFKEEGTKILPAKTAQNENKCQLKLIYRNTPACIRNLQFNDVHFAEVPHWFEVAGDSNSLSNFIEYLESLSSLTENDTDDTKKGIDNLIEFLKIFSIFINETIQRITAAPTGSTEGRHLRTSSQRRTTVHYSSDVNGDVSEESENEVDIDVSDDYDSEYLSEENTLTRKGEDRTDKSFGKRELHNGAKDCDRNCDDIEIFSEPVRQLQDNSREKRSLRRNARKGL');
INSERT INTO proteininfo VALUES ('6324555', 'NP_014624.1','member of the syntaxin family of t-SNAREs; tSNARE that affects a Late Golgi compartment; Tlg2p [Saccharomyces cerevisiae]','MFRDRTNLFLSYRRTFPHNITFSSGKAPLGDDQDIEMGTYPMMNMSHDISARLTDERKNKHENHSDALPPIFIDIAQDVDDYLLEVRRLSEQLAKVYRKNSLPGFEDKSHDEALIEDLSFKVIQMLQKCYAVMKRLKTIYNSQFVDGKQLSREELIILDNLQKIYAEKIQTESNKFRVLQNNYLKFLNKDDLKPIRNKASAENTLLLDDEEEEAAREKREGLDIEDYSKRTLQRQQQLHDTSAEAYLRERDEEITQLARGVLEVSTIFREMQDLVVDQGTIVDRIDYNLENTVVELKSADKELNKATHYQKRTQKCKVILLLTLCVIALFFFVMLKPHGGGSGGRNNGSNKYNNDDNKTVNNSHDDGSNTHINDEESNLPSIVEVTESENDALDDLL');
INSERT INTO proteininfo VALUES ('6324554', 'NP_014623.1','Protein of unknown function; green fluorescent protein (GFP)-fusion protein localizes to the cell periphery and vacuole; Yol019wp [Saccharomyces cerevisiae]','MKKNSSVVFFLVGLSQFVTMAFLIIGSITAPIFKQIGYSKYDEITYGTFGYCKEGSCSKASYNYHPDELSDSDSNWKLNSNARSILGKIIFITPIAAGLNFLGFLCTIMSVLLINVLSSDRVGSASAIMFFVNLTFSTLGFLSASLICIVVFLLFYPHVTWCSWVLIPGAALSLLVIPLIFSAYSRSSGSRDDDETEELEEKGMLLNDPYLSSKSGRFDIDADSEANLRGDSRTNLLGDNFKNGTNITVVPDIISHNQDPKLSNITTSTTSDISTFDKEAKDMENSNGSGLNEEEDDGMAYDKRRSTSTYSVIESESGLKNGSVSNNYVRNNGSNTSNNINYKVPLGKTEISSSASLASSDYSQREVIPHRNPSRLLNDIMETSFNEPNDSHINSMSSYNDKDSTLTSISQRGVNPEVYNQMPRETAAGPANIRPYAGQPHPAPLVYPQQRLQPQQQQPQQQYHQYNLYQRTTPAGPDPSNVILQSNPYFNVAPNQVPQHRNPVPGVGFAPNPLPNQSPITQGYKPAYKRRMQNKNLPRATTSLNNPYGFR');
INSERT INTO proteininfo VALUES ('6324553', 'NP_014622.1','Tryptophan permease, high affinity; Tat2p [Saccharomyces cerevisiae]','MTEDFISSVKRSNEELKERKSNFGFVEYKSKQLTSSSSHNSNSSHHDDDNQHGKRNIFQRCVDSFKSPLDGSFDTSNLKRTLKPRHLIMIAIGGSIGTGLFVGSGKAIAEGGPLGVVIGWAIAGSQIIGTIHGLGEITVRFPVVGAFANYGTRFLDPSISFVVSTIYVLQWFFVLPLEIIAAAMTVQYWNSSIDPVIWVAIFYAVIVSINLFGVRGFGEAEFAFSTIKAITVCGFIILCVVLICGGGPDHEFIGAKYWHDPGCLANGFPGVLSVLVVASYSLGGIEMTCLASGETDPKGLPSAIKQVFWRILFFFLISLTLVGFLVPYTNQNLLGGSSVDNSPFVIAIKLHHIKALPSIVNAVILISVLSVGNSCIFASSRTLCSMAHQGLIPWWFGYIDRAGRPLVGIMANSLFGLLAFLVKSGSMSEVFNWLMAIAGLATCIVWLSINLSHIRFRLAMKAQGKSLDELEFVSAVGIWGSAYSALINCLILIAQFYCSLWPIGGWTSGKERAKIFFQNYLCALIMLFIFIVHKIYYKCQTGKWWGVKALKDIDLETDRKDIDIEIVKQEIAEKKMYLDSRPWYVRQFHFWC');
INSERT INTO proteininfo VALUES ('6324552', 'NP_014621.1','Nucleolar exosome component, involved in rRNA processing and RNA degradation, binds Gsp1p/Ran and enhances the GEF activity of Srm1p, implicated in mitotic control, homologous to the E. coli RNase R of the RNase II family; Dis3p [Saccharomyces cerevisiae]','MSVPAIAPRRKRLADGLSVTQKVFVRSRNGGATKIVREHYLRSDIPCLSRSCTKCPQIVVPDAQNELPKFILSDSPLELSAPIGKHYVVLDTNVVLQAIDLLENPNCFFDVIVPQIVLDEVRNKSYPVYTRLRTLCRDSDDHKRFIVFHNEFSEHTFVERLPNETINDRNDRAIRKTCQWYSEHLKPYDINVVLVTNDRLNREAATKEVESNIITKSLVQYIELLPNADDIRDSIPQMDSFDKDLERDTFSDFTFPEYYSTARVMGGLKNGVLYQGNIQISEYNFLEGSVSLPRFSKPVLIVGQKNLNRAFNGDQVIVELLPQSEWKAPSSIVLDSEHFDVNDNPDIEAGDDDDNNESSSNTTVISDKQRRLLAKDAMIAQRSKKIQPTAKVVYIQRRSWRQYVGQLAPSSVDPQSSSTQNVFVILMDKCLPKVRIRTRRAAELLDKRIVISIDSWPTTHKYPLGHFVRDLGTIESAQAETEALLLEHDVEYRPFSKKVLECLPAEGHDWKAPTKLDDPEAVSKDPLLTKRKDLRDKLICSIDPPGCVDIDDALHAKKLPNGNWEVGVHIADVTHFVKPGTALDAEGAARGTSVYLVDKRIDMLPMLLGTDLCSLKPYVDRFAFSVIWELDDSANIVNVNFMKSVIRSREAFSYEQAQLRIDDKTQNDELTMGMRALLKLSVKLKQKRLEAGALNLASPEVKVHMDSETSDPNEVEIKKLLATNSLVEEFMLLANISVARKIYDAFPQTAMLRRHAAPPSTNFEILNEMLNTRKNMSISLESSKALADSLDRCVDPEDPYFNTLVRIMSTRCMMAAQYFYSGAYSYPDFRHYGLAVDIYTHFTSPIRRYCDVVAHRQLAGAIGYEPLSLTHRDKNKMDMICRNINRKHRNAQFAGRASIEYYVGQVMRNNESTETGYVIKVFNNGIVVLVPKFGVEGLIRLDNLTEDPNSAAFDEVEYKLTFVPTNSDKPRDVYVFDKVEVQVRSVMDPITSKRKAELLLK');
INSERT INTO proteininfo VALUES ('6324551', 'NP_014620.1','Protein required for cell viability; Yol022cp [Saccharomyces cerevisiae]','MSKIEELPPSDTDDHSYSSKPGDVFLAFVDAPVKETDDILVEDSFIGGEPKWLHPDSEPPAELLKCGACKSADNMKLLLQAFSPLDDEQMSAIQQRLGINNMSYINPQDDRVLYVFLCTECQRKGNSVRCIRGVKKNKNVDSLSEKMASTSLEKDFQINPFDLSNNSDSKCNAFSSNPFGGANANPFGADSINSNISQSKDEGKKKESATVSAKTARKLHDLQKDKEYDGNKCFKSCLLYVEEETFKNKKPAHLQLPKNLKIDKEALDLTGDEDLEKDPIKLDPRTEKLSKFLDDDTFQKFQEVVGYNPLQVLRYDLGGKPLLYAETKVDILSTVPRPGYNPSSQRIFEMQLMPKMIFDLEEVVSVDNGMEWGTILVFTDVENYMPEFDEHGVGYVEECVKVQWESRT');
INSERT INTO proteininfo VALUES ('6324550', 'NP_014619.1','Mitochondrial translation initiation factor 2; Ifm1p [Saccharomyces cerevisiae]','MLRRHGLFWLKTCPRLNVLLNQSIPIPHLLHSRDICQQRWYAKGKRRNQISKKELKPLNFSIPNYISVNKLANLLNCRVERLIKDLTALGFENITTTYILSKEYVELILQEYNFALPNLSTSTNLDNVYDELKSPVNPKLLTKRAPVVTIMGHVDHGKTTIIDYLRKSSVVAQEHGGITQHIGAFQITAPKSGKKITFLDTPGHAAFLKMRERGANITDIIVLVVSVEDSLMPQTLEAIKHAKNSGNEMIIAITKIDRIPQPKEREKKIEKVINDLIVQGIPVEKIGGDVQVIPISAKTGENMDLLEESIVLLSEVMDIRAENSPKTIAEGWIIESQVKKQVGNVATVLVKKGTLQKGKILICGNTFCKIKNLIDDKGIPILKATPSYATEVLGWKDVPHVGDEVIQVKSEAIAKKFISKRQDLIEVQKNSSIVEKLNEERALAKEQHLNKELEHENTVQEHEQNTGPKLINYIIKCDVSGSAEAVSESISSLGNDEVRCNVISSSVGIPTESDLKMAQITESTILCFNLGNLPSEVINNRAGIKIKQYNVIYKLIEDVTETLTENLKPIFEKKIVSTVDVRETFDFRLKKKIIRIAGCKVNNGVIKKNSLVQVVRGPNEDVIFDGKISTLKHNKDDVAEVSKGHECGITFESGFEGFKPGDKILVYENVRVPRYL');
INSERT INTO proteininfo VALUES ('6324549', 'NP_014618.1','Hypothetical ORF; Yol024wp [Saccharomyces cerevisiae]','MSKLSSYPHAADFINMEEPPKSKEFFDDLCAVPNLLKRRFPNSRRSTHYCEALNYSRKKLPVVLSKMTLQELRHNMSTFFLQEKDQINIYDTCKVIDMGDRVLLETMPPQPRDLFEKLHASKTNLVVQTAALDEPLLTVKAELQSSSFPQKSSLFLYEDYKKFIYQQLDMFS');
INSERT INTO proteininfo VALUES ('6324548', 'NP_014617.1','affects longevity; involved in determination of longevity; Lag2p [Saccharomyces cerevisiae]','MSLHISKLIEQYRSTKDNDLKYMLLRQNFKINDIEDELAPLVNELLLPVLVEEQDMEILNLVSFQVLPDLVLSMISDPAAAQLGWVISLICDPLLNQSMIHANRSFVLIETLRNVLQKIENSPHLDYHQPVNSSLEFISKFIVEMKRHMCDVDAAQLSHSLSESNMLIYIESLNLLLKFSFFSDAASPSVMVTLPFDILNDVFTIAQDYSATNTNESIDRITEKLLLTSTQLTHPVDLENLCPKMKYNTLAAVSRIWYKFGPIVDKLFTNRLLPVLFPPQMGEECNVEDVLEIVHNFHPYFSIRRLKDNRPLLSDSTISQLREGLFGMLSILNDSLTRTQNENDHGSDNLIDSDDGFGSDNDPEQQAYLDELVSEGYDENMYDGDTDDEDADDINVEKNDEATKDITETNKILLIFSELHYPQEERFSELLVELQTKIAINTSLIDKILSKETTELPTHNGEIADLNEILNEVKGNKPIRKNVIFCTLAHTLSLQSGSELSVLQLSIEVIDHLLVKNHSNNITRGEQFQLIKLILPHLKTNKSFIDTLKAGNFTQKIDEGVTLRTMILSLLLQLFPLDYSMLGEILPTIARYSVRDKDLGVRDLSFQLLDQILRTYYNYLIGIDWEWYKDDFYQVLQETCIKKDINTNLLLQFPPYLPHD');
INSERT INTO proteininfo VALUES ('6324547', 'NP_014616.1','Protein of unknown function proposed to be involved in mitochondrial import; Mim1p [Saccharomyces cerevisiae]','MTEVVGFWESVSDDESEDKDCMEVQNTVSADESPLVQSLVSFVGSCSINLLLPFLNGMMLGFGELFAHELCWRFNWFNHRNKGYKVYPESRKIAALKEISSPGTRGRVASKFL');
INSERT INTO proteininfo VALUES ('6324546', 'NP_014615.1','Mitochondrial Distribution and Morphology; Mdm38p [Saccharomyces cerevisiae]','MLNFASRASCVTRRQASLYFVKNQGPRLIASTIPSCHWPLRAQGVQPNYPLSLRFYSTDKSKSVTKPVAPTSTDAPAKPKETLMVKVKHALKHYANGTKLLGYEIKVSTKLLIKFAQGYELSRRERNQLRRTMGDVFRLIPFSAFLIIPFAELFLPFALKLFPNLLPSTYESGKDKQAKRNKLIEIRKKTSEFLHETLEESNLITYNTIENAEKKQKFLNFFRKLYSAKEGKIMTFQHDEISAIAQMFKNDSVLDNLSRPQLAAMSKFMSLRPFGNDNMLRYQIRSKLKDIMNDDKTIDYEGVESLSQEELYQACVSRGMKAYGVSKEDLVDNLKVWLELRLRQKIPSVLMVLSSTFTFGGLPKENYSKAFSPLAEKKETKSKYDDLLDLYYDGILQVLSSIPDPVYNVAKLDVSESKSSAAETEAEKQVAEKKIKTEEKPEETAIPKEEATAKESVIATTASAVTPKLVVVNEKAETAKTEEISQEKENAEPTDSAEATEAEEKKTSDDNEFKLNVLKEQEELIKKEEEEAKQRASREHVPDDINLDEEEEAKSVPPIPADQAAKTFVIKKD');
INSERT INTO proteininfo VALUES ('6324545', 'NP_014614.1','basic leucine zipper (bZIP) transcription factor; Yap7p [Saccharomyces cerevisiae]','MRQRRSVVAVSVKPKGFKLGHKQGSMSTTSPPPSSPDGNVSTSGPSAIKLSKNWELPQRLKPGRKPKSKRGDASANNDGSSKIKKVQTSNQKDQMTTKDHENEGAKGHEGKSDDEGNGSGDENGVDSVEKRRRQNRDAQRAYRERRTTRIQVLEEKVEMLHNLVDDWQRKYKLLESEFSDTKENLQKSIALNNELQKALPLIVNTPFQQQPENPPDNPISILEMVENFKPIGAVSLKKGKLKAHC');
INSERT INTO proteininfo VALUES ('6324544', 'NP_014613.1','Hypothetical ORF; Yol029cp [Saccharomyces cerevisiae]','MKPVTCCNQKNNIMPSLVPVCCSEKKIESDAKKSISKCCGDKEIYDSENRPITKEDGSWIPGSCKQCRSDPHSRNFCQSLSNKCSSSSFSSNSALSPDLNEQQTDVNYNSIKLPEICSCKNAQMNAASDAKRYLPISYTYQKIRQHMQKNKSIQEQLNPEDSTSISSALENIASGLHVRGQKVELQSIKDALHKMDKNVLE');
INSERT INTO proteininfo VALUES ('6324543', 'NP_014612.1','Putative 1,3-beta-glucanosyltransferase, has similarity to Gas1p; localizes to the cell wall; Gas5p [Saccharomyces cerevisiae]','MLLRSLTSAFVLSAGLAQAASSSNSSTPSIEIKGNAFFNSESGERFYIRGVDYQPGGSSNLTDPLADASVCDRDVPVLKDLGINTVRVYTVDNSQDHSHCMKLLQENGIYLILDVNTPTSAISRYDPACSYNADYLQNVFATIDTFADYDNVLGFFAGNEVINSVNTTNTATYVKAVVRDMKKYIKARKYRQIPVGYSAADIVANRQLAAEYFNCGDEADARIDMFGVNDYSWCGESSFVVSGYSTKMKLYQDYSVPVFLSEFGCNQVKSSRPFTEIEAIYSTQMSSVFSGGLVYEYSNETNNYGLVQIDGDKVTKLTDFENLKNEYSKVSNPEGNGGYSTSNNYSTCPDYEKGVWEANNTLPAMPSAASAYFTSGAGSPMGTGIATQQSCDAKDDDDEEDDDTSSSSSSSSSSSSSASSSSESSSSTSKASSSSPSASETSLLKSAASATSSSQSSSKSKGAAGIIEIPLIFRALAELYNLVL');
INSERT INTO proteininfo VALUES ('6324542', 'NP_014611.1','ER-localized protein required for protein translocation into the ER, interacts with the ATPase domain of the Kar2p chaperone suggesting some role in modulating its activity; homolog of Yarrowia lipolytica SLS1; GrpE-like protein in the ER; Sil1p [Saccharomyces cerevisiae]','MVRILPIILSALSSKLVASTILHSSIHSVPSGGEIISAEDLKELEISGNSICVDNRCYPKIFEPRHDWQPILPGQELPGGLDIRINMDTGLKEAKLNDEKNVGDNGSHELIVSSEDMKASPGDYEFSSDFKEMRNIIDSNPTLSSQDIARLEDSFDRIMEFAHDYKHGYKIITHEFALLANLSLNENLPLTLRELSTRVITSCLRNNPPVVEFINESFPNFKSKIMAALSNLNDSNHRSSNILIKRYLSILNELPVTSEDLPIYSTVVLQNVYERNNKDKQLQIKVLELISKILKADMYENDDTNLILFKRNAENWSSNLQEWANEFQEMVQNKSIDELHTRTFFDTLYNLKKIFKSDITINKGFLNWLAQQCKARQSNLDNGLQERDTEQDSFDKKLIDSRHLIFGNPMAHRIKNFRDEL');
INSERT INTO proteininfo VALUES ('6324541', 'NP_014610.1','Hypothetical ORF; Yol032wp [Saccharomyces cerevisiae]','MFAAIASGNPLQLSVEVPNSNGLQHTIVLSRTKPKLYSHITLFILPNVTFPQDYIATVYFKLSPQEEFKLFGYLSSEKPSAIFKVQIPSSKKDAGDTSDGLGEIDMDVDDGSGAADPFTDTNGSSSNNISELIIGISIEPREQGMMKLEEWKASMNAEAQKNNSLILSRPNLGIIRNITTAGQLAQVYPSLTQELAAKIVQHAYNYLSGFLDAQGNVPIKRFDTWWDKFRNRLANDGTFLDEVTKN');
INSERT INTO proteininfo VALUES ('6324540', 'NP_014609.1','Mitochondrial glutamyl-tRNA synthetase; Mse1p [Saccharomyces cerevisiae]','MIMLRIPTRSYCSPSKLIKGVGLSPLKKSLLSKKIKEDIHPSLPVRTRFAPSPTGFLHLGSLRTALYNYLLARNTNGQFLLRLEDTDQKRLIEGAEENIYEILKWCNINYDETPIKQSERKLIYDKYVKILLSSGKAYRCFCSKERLNDLRHSAMELKPPSMASYDRCCAHLGEEEIKSKLAQGIPFTVRFKSPERYPTFTDLLHGQINLQPQVNFNDKRYDDLILVKSDKLPTYHLANVVDDHLMGITHVIRGEEWLPSTPKHIALYNAFGWACPKFIHIPLLTTVGDKKLSKRKGDMSISDLKRQGVLPEALINFCALFGWSPPRDLASKKHECFSMEELETIFNLNGLTKGNAKVDDKKLWFFNKHFLQKRILNPSTLRELVDDIMPSLESIYNTSTISREKVAKILLNCGGSLSRINDFHDEFYYFFEKPKYNDNDAVTKFLSKNESRHIAHLLKKLGQFQEGTDAQEVESMVETMYYENGFSRKVTYQAMRFALAGCHPGAKIAAMIDILGIKESNKRLSEGLQFLQREKK');
INSERT INTO proteininfo VALUES ('6324539', 'NP_014608.1','Structural maintenance of chromosomes (SMC) protein; Protein required for cell viability; Smc5p [Saccharomyces cerevisiae]','MTSLIDLGRYVERTHHGEDTEPRSKRVKIAKPDLSSFQPGSIIKIRLQDFVTYTLTEFNLSPSLNMIIGPNGSGKSTFVCAVCLGLAGKPEYIGRSKKVEDFIKNGQDVSKIEITLKNSPNVTDIEYIDARDETIKITRIITRSKRRSDYLINDYQVSESVVKTLVAQLNIQLDNLCQFLSQERVEEFARLKSVKLLVETIRSIDASLLDVLDELRELQGNEQSLQKDLDFKKAKIVHLRQESDKLRKSVESLRDFQNKKGEIELHSQLLPYVKVKDHKEKLNIYKEEYERAKANLRAILKDKKPFANTKKTLENQVEELTEKCSLKTDEFLKAKEKINEIFEKLNTIRDEVIKKKNQNEYYRGRTKKLQATIISTKEDFLRSQEILAQTHLPEKSVFEDIDIKRKEIINKEGEIRDLISEIDAKANAINHEMRSIQRQAESKTKSLTTTDKIGILNQDQDLKEVRDAVLMVREHPEMKDKILEPPIMTVSAINAQFAAYLAQCVDYNTSKALTVVDSDSYKLFANPILDKFKVNLRELSSADTTPPVPAETVRDLGFEGYLSDFITGDKRVMKMLCQTSKIHTIPVSRRELTPAQIKKLITPRPNGKILFKRIIHGNRLVDIKQSAYGSKQVFPTDVSIKQTNFYQGSIMSNEQKIRIENEIINLKNEYNDRKSTLDALSNQKSGYRHELSELASKNDDINREAHQLNEIRKKYTMRKSTIETLREKLDQLKREARKDVSQKIKDIDDQIQQLLLKQRHLLSKMASSMKSLKNCQKELISTQILQFEAQNMDVSMNDVIGFFNEREADLKSQYEDKKKFVKEMRDTPEFQSWMREIRSYDQDTKEKLNKVAEKYEEEGNFNLSFVQDVLDKLESEIAMVNHDESAVTILDQVTAELRELEHTVPQQSKDLETIKAKLKEDHAVLEPKLDDIVSKISARFARLFNNVGSAGAVRLEKPKDYAEWKIEIMVKFRDNAPLKKLDSHTQSGGERAVSTVLYMIALQEFTSAPFRVVDEINQGMDSRNERIVHKAMVENACAENTSQYFLITPKLLTGLHYHEKMRIHCVMAGSWIPNPSEDPKMIHFGETSNYSFD');
INSERT INTO proteininfo VALUES ('6324536', 'NP_014606.1','Protein of unknown function; potential Cdc28p substrate; Yol036wp [Saccharomyces cerevisiae]','MEHQDSSPPRFRNSGSNRVTVYNGTTLPTMPKSATPTSSSTTVTTHLQNIKEEETNDDELTQVDRSSPRVLGRISSTSSSSSNIDLRDNLDMLHEIEKSNTNISLSAPNLHEELGVLSDKGNSKEELALLPPLPHTGEMEITPQFDINEAIFERDDISHSSRLEPDDVLTKLANSTRDATGEDQGFVVMTHGHDASTNDDSQLSATILDNQTSFDLSKALEMTSHSNISNIINSSGSEGRRSRTPVSNSTLKPNLSSPESAEREANTTSSSSTSDHGATMQYDPKKIITPIPVLPSSVREQQQNNAPLRERSRSNSSALASTLRDTIISGLPQNINSVERKLSRKSNRSRKNTVTFEDRLQKLPPLSTQISNQYAKVAPAENNIALHFHNLPTPVSNTQTPVTFQSESGLTGGEKKMPFLRRASSALLRKTSAKNCSNLTRTNTPTLSTSSTFESDLNARQPMLIRRSSTIDNKLPRRQLSCSKLYSRLNSDSKFANSSRASEEVLVSTPNDTEHVYRKTSLGSKIKRGFTRILSDSNNSKEILTLSPKSMVTTGPTELSFSSLSTVGGHPTTPVSKENDRVSIDGVSTFNRASTSLPESSTDDISPLREEGKINVPKRTSSRKILSKNSSKKNVLPEQQTKPSEIYLDKEALQSFVPVLSVTEGTHRINRSSLQTQSTIGLCITNLRNKEGMKLNAKEYVEILAQQQRKEDERYAVLERKFASCRWCSDKDLQYLKKKRISMNKIWSDYVRFYRGKLNNP');
INSERT INTO proteininfo VALUES ('6324535', 'NP_014604.1','20S proteasome alpha-type subunit; Pre6p [Saccharomyces cerevisiae]','MSGYDRALSIFSPDGHIFQVEYALEAVKRGTCAVGVKGKNCVVLGCERRSTLKLQDTRITPSKVSKIDSHVVLSFSGLNADSRILIEKARVEAQSHRLTLEDPVTVEYLTRYVAGVQQRYTQSGGVRPFGVSTLIAGFDPRDDEPKLYQTEPSGIYSSWSAQTIGRNSKTVREFLEKNYDRKEPPATVEECVKLTVRSLLEVVQTGAKNIEITVVKPDSDIVALSSEEINQYVTQIEQEKQEQQEQDKKKKSNH');
INSERT INTO proteininfo VALUES ('6324534', 'NP_014603.1','Homology to rat P2, human P2, and E.coli L12eIB; 60S acidic ribosomal protein P2A (L44) (A2) (YP2alpha); Rpp2ap [Saccharomyces cerevisiae]','MKYLAAYLLLNAAGNTPDATKIKAILESVGIEIEDEKVSSVLSALEGKSVDELITEGNEKLAAVPAAGPASAGGAAAASGDAAAEEEKEEEAAEESDDDMGFGLFD');
INSERT INTO proteininfo VALUES ('6324533', 'NP_014602.1','Protein component of the small (40S) ribosomal subunit; has similarity to E. coli S19 and rat S15 ribosomal proteins; Rps15p [Saccharomyces cerevisiae]','MSQAVNAKKRVFKTHSYRGVDLEKLLEMSTEDFVKLAPARVRRRFARGMTSKPAGFMKKLRAAKLAAPENEKPAPVRTHMRNMIIVPEMIGSVVGIYNGKAFNQVEIRPEMLGHYLGEFSITYTPVRHGRAGATTSRFIPLK');
INSERT INTO proteininfo VALUES ('6324532', 'NP_014601.1','Nucleolar protein, required for pre-25S rRNA processing; contains an RNA recognition motif (RRM) and has similarity to Nop13p, Nsr1p, and putative orthologs in Drosophila and S. pombe; Nop12p [Saccharomyces cerevisiae]','MSSAIDNLFGNIDEKKIESSVDKLFSSSCGPINKLEVKSKTRTVLPDSKKRERAAEADQEEKEASKPDVSDEQTEEVALPKVKKAKKSKRNDEDEDLEARYYAKLLNEEAEAEDDKPTVTKTDETSVPLTSAAKKVDFKEDELEKAERTVFIGNILSTVITSKKVYKEFKKLFGTNPIAETEESGNEKEEESSKKSDNNEFAIESIRFRSISFDEALPRKVAFVQQKFHKSRDTINAYIVYKNKSAVRKICSNLNAVVFQDHHLRVDSVAHPAPHDKKRSIFVGNLDFEEIEESLWKHFEPCGDIEYVRIIRDSKTNMGKGFAYVQFKDLQSVNKALLLNEKPMKSQKQEDENTKKPTKKARKLRVSRCKNMKKGTTIGTGLDRNGLTDSQRTRAGRAKKILGKADRATLGQEITIEGLRAKKGEGSTHLKKKKQRSATGRVTKRSIAFKKAQAEKSKK');
INSERT INTO proteininfo VALUES ('6324531', 'NP_014600.1','DNase/RNase (putative); CCR4 C-terminal homolog, homology to drosophila Angel gene; Ngl1p [Saccharomyces cerevisiae]','MFTRRFIPVVQSTKQNIGKYVRKDARFTLLTYNMLSPSYMWPQVYTYVAEPYKNWSYRHRLLEKELLNTFKADIMCLQEMTARDYEDYWHDSIGVDVNYGSKFISKTPPKYWKKPVKDMDGVSIFYNLAKFDFISSSGIYLNQLLNVFNQRELKYLYNKKVTLTDGASNVIGEDSLLDVLKGKNQVCLFVSLRHKETGTIFVVLNTHLYWKYDEVKLTQCMIIMRELSKIIKQLLPGDVKGQERVKILFTGDLNSTRDSLVVNFLQGQIVSHGDLNLINPMRPYLDRCVYDDIPKDYFVHTCYSGKLKGIFDYVWYHDSDFLLTKILTGNEVSDELLASNQLGLPNENHPSDHIPLLTEFKIL');
INSERT INTO proteininfo VALUES ('6324530', 'NP_014599.1','DNA N-glycosylase and apurinic/apyrimidinic (AP) lyase involved in base excision repair, localizes to the nucleus; Ntg2p [Saccharomyces cerevisiae]','MREESRSRKRKHIPVDIEEVEVRSKYFKKNERTVELVKENKINKDLQNYGGVNIDWIKALKPIEYFEWIESRTCDDPRTWGRPITKEEMINDSGAKVPESFLPIYNRVRLMRSKVKTPVDAMGCSMIPVLVSNKCGIPSEKVDPKNFRLQFLIGTMLSAQTRDERMAQAALNITEYCLNTLKIAEGITLDGLLKIDEPVLANLIRCVSFYTRKANFIKRTAQLLVDNFDSDIPYDIEGILSLPGVGPKMGYLTLQKGWGLIAGICVDVHVHRLCKMWNWVDPIKCKTAEHTRKELQVWLPHSLWYEINTVLVGFGQLICMARGKRCDLCLANDVCNARNEKLIESSKFHQLEDKEDIEKVYSHWLDTVTNGITTERHKKK');
INSERT INTO proteininfo VALUES ('6324529', 'NP_014598.1','44 kDa phosphorylated integral peroxisomal membrane protein; Pex15p [Saccharomyces cerevisiae]','MAASEIMNNLPMHSLDSSLRDLLNDDLFIESDESTKSVNDQRSEVFQECVNLFIKRDIKDCLEKMSEVGFIDITVFKSNPMILDLFVSACDIMPSFTKLGLTLQSEILNIFTLDTPQCIETRKIILGDLSKLLVINKFFRCCIKVIQFNLTDHTEQEEKTLELESIMSDFIFVYITKMRTTIDVVGLQELIEIFIFQVKVKLHHKKPSPNMYWALCKTLPKLSPTLKGLYLSKDVSIEDAILNSIDNKIQKDKAKSKGKQRGVKQKIHHFHEPMLHNSSEEQVKVEDAFNQRTSTDSRLQSTGTAPRKKNNDITVLAGSFWAVLKHHFTRSVLNKNGLLLTGLLLLLCLKKYKSLMAIFKHVPAAFHTVYPQIVGLLKLLASI');
INSERT INTO proteininfo VALUES ('6324527', 'NP_014597.1','PAS domain-containing Serine/threonine Kinase; Psk2p [Saccharomyces cerevisiae]','MTYPVSAAAPADISYSKNTPLVGLSKPPCLYQHASSSVDSFSSTFSDDDRSDLVAVPNESPHAFSYNPISPNSLGVRLTILRRSLEIMVNSPDILHELKKKAPVIAYPPSLRHTRNLTETATLSASRDPLNGSLISPLVSNMPSPASRPVIQRATSLMVLPDNDTASKLNPAKSELENLLFLLNLALENNSFERASDLHMLSLLNIKKINFDSDIQKSETLKKVLLDSLAEPFFENYKKFPHKDLGSKSQYNEYEEKHDDIVSLADIKPQQDYSRILHPFTSAKNSGPEAIFTCSQQYPWNFKAANDLACLTFGISKNVIKALTLLDLIHTDSRNFVLEKIMNAEDDNQEIVFTGETIPIVQPNSTSNNNVPNLIWASLWAKRKNGLLVCVFEKTPCDYIDVMLNLRDFSVDSIIDTTHFLENFDKKKQQESTSPMTEKKTVKFANEIHDIGSVSHSLSKLIDDVRFGKVFSADDDLLPLSIRVANHVNEERYFTLNCLSENIPCAVTTSVLENEIKLKIHSLPYQAGLFIVDSHTLSLLSFNKSVAKNMFGLRLHELAGSSVTKLVPSLADMISYINKTYPMLNITLPENKGLVLTEHFFRKIEAEMHHDKDSFYTSIGLDGCHKDGNLIKVDVQLRVLNTNAVLLWITHSRDVVIENYTTVPSQLPMLKENEIDVVGSRGSSSASSKKSSEKIPVNTLKAMADLSISSAETISNSDDEVDLNQVNEKLRETSCGKVRGIESNDNNNYDDDMTMVDDPELKHKIELTKMYTQDKSKFVKDDNFKVDEKFIMRIIEPINGEEIKKETNELDKRNSTLKATYLTTPEANIGSQKRIKKFSDFTILQVMGEGAYGKVNLCIHNREHYIVVIKMIFKERILVDTWVRDRKLGTIPSEIQIMATLNKNSQENILKLLDFFEDDDYYYIETPVHGETGSIDLFDVIEFKKDMVEHEAKLVFKQVVASIKHLHDQGIVHRDIKDENVIVDSHGFVKLIDFGSAAYIKSGPFDVFVGTMDYAAPEVLGGSSYKGKPQDIWALGVLLYTIIYKENPYYNIDEILEGELRFDKSEHVSEECISLIKRILTREVDKRPTIDEIYEDKWLKI');
INSERT INTO proteininfo VALUES ('6324524', 'NP_014593.1','Glutathione synthetase, catalyzes the ATP-dependent synthesis of glutathione (GSH) from gamma-glutamylcysteine and glycine; induced by oxidative stress and heat shock; Gsh2p [Saccharomyces cerevisiae]','MAHYPPSKDQLNELIQEVNQWAITNGLSMYPPKFEENPSNASVSPVTIYPTPIPRKCFDEAVQIQPVFNELYARITQDMAQPDSYLHKTTEALALSDSEFTGKLWSLYLATLKSAQYKKQNFRLGIFRSDYLIDKKKGTEQIKQVEFNTVSVSFAGLSEKVDRLHSYLNRANKYDPKGPIYNDQNMVISDSGYLLSKALAKAVESYKSQQSSSTTSDPIVAFIVQRNERNVFDQKVLELNLLEKFGTKSVRLTFDDVNDKLFIDDKTGKLFIRDTEQEIAVVYYRTGYTTTDYTSEKDWEARLFLEKSFAIKAPDLLTQLSGSKKIQQLLTDEGVLGKYISDAEKKSSLLKTFVKIYPLDDTKLGREGKRLALSEPSKYVLKPQREGGGNNVYKENIPNFLKGIEERHWDAYILMELIEPELNENNIILRDNKSYNEPIISELGIYGCVLFNDEQVLSNEFSGSLLRSKFNTSNEGGVAAGFGCLDSIILY');
INSERT INTO proteininfo VALUES ('6324522', 'NP_014591.1','Component of the Mediator complex; interacts with RNA polymerase II and the general transcription factors to form the RNA polymerase II holoenzyme; affects transcription by acting as target of activators and repressors; Gal11p [Saccharomyces cerevisiae]','MSAAPVQDKDTLSNAERAKNVNGLLQVLMDINTLNGGSSDTADKIRIHAKNFEAALFAKSSSKKEYMDSMNEKVAVMRNTYNTRKNAVTAAAANNNIKPVEQHHINNLKNSGNSANNMNVNMNLNPQMFLNQQAQARQQVAQQLRNQQQQQQQQQQQQRRQLTPQQQQLVNQMKVAPIPKQLLQRIPNIPPNINTWQQVTALAQQKLLTPQDMEAAKEVYKIHQQLLFKARLQQQQAQAQAQANNNNNGLPQNGNINNNINIPQQQQMQPPNSSANNNPLQQQSSQNTVPNVLNQINQIFSPEEQRSLLQEAIETCKNFEKTQLGSTMTEPVKQSFIRKYINQKALRKIQALRDVKNNNNANNNGSNLQRAQNVPMNIIQQQQQQNTNNNDTIATSATPNAAAFSQQQNASSKLYQMQQQQQAQAQAQAQAQAQAQAQAQAQAAQAAQAQAQAQAQAQAQAQAQAQAQAQAQAQAQAQAQAHAQHQPSQQPQQAQQQPNPLHGLTPTAKDVEVIKQLSLDASKTNLRLTDVTNSLSNEEKEKIKMKLKQGQKLFVQVSNFAPQVYIITKNENFLKEVFQLRIFVKEILEKCAEGIFVVKLDTVDRLIIKYQKYWESMRIQILRRQAILRQQQQMANNNGNPGTTSTGNNNNIATQQNMQQSLQQMQHLQQLKMQQQQQQQQQQQQQQQQQQQQQQQHIYPSSTPGVANYSAMANAPGNNIPYMNHKNTSSMDFLNSMENTPKVPVSAAATPSLNKTINGKVNGRTKSNTIPVTSIPSTNKKLSISNAASQQPTPRSASNTAKSTPNTNPSPLKTQTKNGTPNPNNMKTVQSPMGAQPSYNSAIIENAFRKEELLLKDLEIRKLEISSRFKHRQEIFKDSPMDLFMSTLGDCLGIKDEEMLTSCTIPKAVVDHINGSGKRKPTKAAQRARDQDSIDISIKDNKLVMKSKFNKSNRSYSIALSNVAAIFKGIGGNFKDLSTLVHSSSPSTSSNMDVGNPRKRKASVLEISPQDSIASVLSPDSNIMSDSKKIKVDSPDDPFMTKSGATTSEKQEVTNEAPFLTSGTSSEQFNVWDWNNWTSAT');
INSERT INTO proteininfo VALUES ('6324521', 'NP_014590.1','S-adenosylmethionine decarboxylase; Spe2p [Saccharomyces cerevisiae]','MTVTIKELTNHNYIDHELSATLDSTDAFEGPEKLLEIWFFPHKKSITTEKTLRNIGMDRWIEILKLVKCEVLSMKKTKELDAFLLSESSLFVFDHKLTMKTCGTTTTLFCLEKLFQIVEQELSWAFRTTQGGKYKPFKVFYSRRCFLFPCKQAAIHQNWADEVDYLNKFFDNGKSYSVGRNDKSNHWNLYVTETDRSTPKGKEYIEDDDETFEVLMTELDPECASKFVCGPEASTTALVEPNEDKGHNLGYQMTKNTRLDEIYVNSAQDSDLSFHHDAFAFTPCGYSSNMILAEKYYYTLHVTPEKGWSYASFESNIPVFDISQGKQDNLDVLLHILNVFQPREFSMTFFTKNYQNQSFQKLLSINESLPDYIKLDKIVYDLDDYHLFYMKLQKKI');
INSERT INTO proteininfo VALUES ('6324520', 'NP_014589.1','Multistress response protein, expression is activated by a variety of xenobiotic agents and environmental or physiological stresses; Ddr2p [Saccharomyces cerevisiae]','MKVSQVFISAISVFGLATSVNAQNASNTTSNAAPALHAQNGQLLNAGVVGAAVGGALAFLI');
INSERT INTO proteininfo VALUES ('6324519', 'NP_014588.1','Hypothetical ORF; Yol053wp [Saccharomyces cerevisiae]','MWGLCKKHFPSNKIQVQERNKALKPKKSGSEHKTKQLFPVFNCKKKEKGVMIRFAILRNANTSLLSARSICLFTQAPTYCHVRLNTLNKSITTKRNSLTESKRHVHDGKHFFTTPHQQQQTKLGEIEEGHSPNIKGEDLRSIGQAITHQRNKRRKQIWSAIFGGIFGVILGYSLIYRVIYLKEQSFLPLFPSSKIRKLSTRDLKKVDVNQVQKLSKLRVLEILSGHDMIKEQYGVPLLDKDGNSPTLNEFSMWCEDQDPCVTGIVMEPDDKRDSSHTWYRIPFVCKWRITHRPISIRGTIDDLLNRIGLETADLFEIISPERVYGSFKYEYPLQGDSHALHLWFHGEIELDDDSLIVYNGKYHVDVKLQEIDLFRREKNGQLIQYVLYKNEAGDK');
INSERT INTO proteininfo VALUES ('6324518', 'NP_014587.1','Nuclear protein, putative RNA polymerase II elongation factor; isolated as Pob3p/Spt16p-binding protein; Psh1p [Saccharomyces cerevisiae]','MGDELHNRLLHQNDGTKDAILYKIIESLVCSICHDYMFVPMMTPCGHNYCYGCLNTWFASNTQKELACPQCRSDITTIPALNTTLQQYLSFILEKLRDQNDESFKKLLTTKTKEENDYKNDKEKDTLFDKVFKNSALAVADDSDDGITRCSNCHWELDPDEVEDGNVCPHCNARIRNYAGGRDEFDEEEYSEGELDEIRESMRRRRENRFASTNPFANRDDVSSEDDDSSEEEPMREHIPLGRWARSHNRSIAVDAVDDEDDEEEDEEEEEEMDSDLKDFIEDDEDDEDEDGSRRNLVLSALKNRHVIITDDEEEEQRRHATEEEDRDSDFYEHNDDGFVSGDSLDEDQKEVTRIQSSSDSEDRSLSYSGSSDVKDNNDDNTEELDDPQPKRQKRFRVVLGDSDDE');
INSERT INTO proteininfo VALUES ('6324517', 'NP_014586.1','Hydroxymethylpyrimidine phosphate kinase, involved in the last steps in thiamine biosynthesis; member of a gene family with THI21 and THI22; functionally redundant with Thi21p; Thi20p [Saccharomyces cerevisiae]','MTYSTVSINTPPPYLTLACNEKLPTVLSIAGTDPSGGAGIEADVKTITAHRCYAMTCITALNAQTPVKVYSINNTPKEVVFQTLESNLKDMKCNVIKTGMLTAAAIEVLHEKLLQLGENRPKLVVDPVLVATSGSSLAGKDIVSLITEKVAPFADILTPNIPECYKLLGEERKVNGLQDIFQIAKDLAKITKCSNILVKGGHIPWNDEKEKYITDVLFLGAEQKFIIFKGNFVNTTHTHGTGCTLASAIASNLARGYSLPQSVYGGIEYVQNAVAIGCDVTKETVKDNGPINHVYAVEIPLEKMLSDECFTASDVIPKKPLKSAADKIPGGNFYEYLINHPKVKPHWDSYINHEFVKKVADGTLERKKFQFFIEQDYAYLVDYARVHCIAGSKAPCLEDMEKELVIVGGVRTEMGQHEKRLKEVFGVKDPDYFQKIKRGPALRAYSRYFNDVSRRGNWQELVASLTPCLMGYGEALTKMKGKVTAPEGSVYHEWCETYASSWYREAMDEGEKLLNHILETYPPEQLDTLVTIYAEVCELETNFWTAALEYE');
INSERT INTO proteininfo VALUES ('6324516', 'NP_014585.1','converts 3-phosphoglycerate to 2-phosphoglycerate in glycolysis; phosphoglycerate mutase; Gpm3p [Saccharomyces cerevisiae]','MTVTDTFKLFILRHGQSELNSENIFCGWIDAQLTEKGKSQARHSAKLIKQFCDSNNISLPQIGYTSRLIRTQQTMDVILEELGLKHTNYVITTNTNIKEELQDTRFEGSMPVLQTWRLNERHYGAWQGQRKPDILKEYGKEKYMYIRRDYNGKPPKVNLNLEMVQEENDQGSSTGYDFKEPNRHLKYGPEEKANERLPESESLCEVVVRLKPFLNNVVLSTANKISQESCVIVGHGSSVRSLLKVLEGISDEDIKDVDIPNGIPLVIELDRDNYSFVRKFYLDPESAKVNAQMVRDEGFEKNP');
INSERT INTO proteininfo VALUES ('6324515', 'NP_014584.1','Hypothetical ORF; Yol057wp [Saccharomyces cerevisiae]','MSHFFADHDAPLSMLSVKTEYFPQLTDKEQKYAHFMSKASHAGSRVVMRQVSHESEPIFDLILAIHSKLNGKYPEDDITQKQQTGLYLEYVSQFLSNLGNFKSFGDTKFIPRCEVKFFKQLLELAKINPCSSPLTLSPVDVNHEFTSHHLFSTINELIDIGIYHVEEKAALLGFPSQGYTSAYYLGLPVTPEDMALLKEQLFAELAILPENTRINKVGENSFQIWVASENVKNQITETYPSGQITLSNAVTKVEFIFGDHSREMRLVASYLKEAQKFAANDTQKAMLQEYINHFVTGSSQAHKEAQKLWVKDISPVIETNIGFIETYREPSGIIGEFESLVAIQNKERTAKFSSLVNNAEEFISLLPWSKDYEKPIFNPPDFTSLEVLTFTGSGIPAGINIPNYDDVRLKIGFKNVSLGNILSAAAKSSSKHPPSFISQEDRPIFEKYQSDSFEVQVGIHELLGHGSGKLLTEFTDGFNFDKENPPLGLDGKPVSTYYKVGETWGSKFGQLAGPFEECRAEVIAMFLLTNKKILDIFGFHDVESQDKVIYAGYLQMARAGLLALEYWNPKTGKWGQPHMQARFSIMKTFMKHSTDKNFLKLEMNSTNDDFAIKLDKSLIKTAGHECVKDYLKHLHVYKCSGDVEQGSKYFIDRSTVTPDLASLRDIVLSKRLPRRQFIQSNSYIDDNNKVTLKEYDETPQGMLQSFLDREL');
INSERT INTO proteininfo VALUES ('6324514', 'NP_014583.1','Arginosuccinate synthetase, catalyzes the formation of L-argininosuccinate from citrulline and L-aspartate in the arginine biosynthesis pathway; potential Cdc28p substrate; Arg1p [Saccharomyces cerevisiae]','MSKGKVCLAYSGGLDTSVILAWLLDQGYEVVAFMANVGQEEDFDAAKEKALKIGACKFVCVDCREDFVKDILFPAVQVNAVYEDVYLLGTSLARPVIAKAQIDVAKQEGCFAVSHGCTGKGNDQIRFELSFYALKPDVKCITPWRMPEFFERFAGRKDLLDYAAQKGIPVAQTKAKPWSTDENQAHISYEAGILEDPDTTPPKDMWKLIVDPMDAPDQPQDLTIDFERGLPVKLTYTDNKTSKEVSVTKPLDVFLAASNLARANGVGRIDIVEDRYINLKSRGCYEQAPLTVLRKAHVDLEGLTLDKEVRQLRDSFVTPNYSRLIYNGFLLHPECEYIRSMIQPSQNSVNGTVRVRLYKGNVIILGRSTKTEKLYDPTESSMDELTGFLPTDTTGFIAIQAIRIKKYGESKKTKGEELTL');
INSERT INTO proteininfo VALUES ('6324513', 'NP_014582.1','Involved in glycerol production via conversion of glyerol-3-phosphate and NAD+ to glycerol phosphate and NADH; Glycerol-3-phosphate dehydrogenase (NAD+); Gpd2p [Saccharomyces cerevisiae]','MLAVRRLTRYTFLKRTHPVLYTRRAYKILPSRSTFLRRSLLQTQLHSKMTAHTNIKQHKHCHEDHPIRRSDSAVSIVHLKRAPFKVTVIGSGNWGTTIAKVIAENTELHSHIFEPEVRMWVFDEKIGDENLTDIINTRHQNVKYLPNIDLPHNLVADPDLLHSIKGADILVFNIPHQFLPNIVKQLQGHVAPHVRAISCLKGFELGSKGVQLLSSYVTDELGIQCGALSGANLAPEVAKEHWSETTVAYQLPKDYQGDGKDVDHKILKLLFHRPYFHVNVIDDVAGISIAGALKNVVALACGFVEGMGWGNNASAAIQRLGLGEIIKFGRMFFPESKVETYYQESAGVADLITTCSGGRNVKVATYMAKTGKSALEAEKELLNGQSAQGIITCREVHEWLQTCELTQEFPLFEAVYQIVYNNVRMEDLPEMIEELDIDDE');
INSERT INTO proteininfo VALUES ('6324512', 'NP_014581.1','Protein required for normal mitochondrial morphology, has similarity to hemolysins; Mam3p [Saccharomyces cerevisiae]','MSFLPLRSRSRSGAPHWVYIILYHIFTIPKIYSLPLLSGSHVLNSRDVADSGHSVGDEASVTTYYIISIILVLLGGVFAGLTLGLMGQDEVYLKVISTSGSNSEKKLAKRVLDLISRGKHWVLVTLLLSNVITNETLPIVLDRCLGGGWQAVVSSTILIVIFGEIIPQSVCVKYGLQVGAFFCPFVLVLMYLMYPVAYPIATLLDYMLGEDHGTMYKKSGLKTLVTLHRTMGVERLTKDEVTIISAVLDLKAKRVEEIMTPIENVFTMSADTILDDKTVEKIFNSGFSRIPIFLPNEPNNFIGMLLVRVLISYDPDDCLPISHFPLATLPETSPNTSCLNILNYFQEGKAHMCVVSKEPGSSHGAIGVLTLEDVIEELIGEEIVDESDVFVDMHQHIMRQQPGPLSKRHITSYLHHLYTSSHKEHKAADQADESSPLLSPSNSNHPSEHPQQDLNNKSWKQKSNDGYDRSNAVLSPTPQVTEHGTIIPSNLASNPLNVNKSFVTIKKPANVPKIITTHTPHSSKEPSPAPHSNDKSLSAEEQQLLSDHAELSRQAVLHTQRSGQPTQVTTSTKTTRNSPDSISIPNSGANHGNENQNVTISTSYQNTKNGIVESVITVKGVPKTIIGPAKDWDESKSEYGNENINQENSNRSDDRESSSSNASLFSSIKNKFKNENANNNDRSNFTDSLSRTSNYDANGSSSTIKR');
INSERT INTO proteininfo VALUES ('6324511', 'NP_014580.1','5-phospho-ribosyl-1(alpha)-pyrophosphate synthetase, involved in nucleotide, histidine, and tryptophan biosynthesis; one of a five related enzymes, which are active as heteromultimeric complexes; Prs5p [Saccharomyces cerevisiae]','MSMSNIVVFGGDSHPELVTKICENLDIHPSKVELGKFSNGETNIALRESVREKDVYIIQSGCGQVNDTFMQLLILISACKSASASRVTAVMPYLCYSRQPDIPYTAKGAPIISKPKENYTFESHPGTPVSSSLMTQRPGAESSLKSLDSAIRSTINLENPQPIRTPNSSATANNNFDIKKTLSFSRIPMIPGGKLQNTSNSTDAGELFNAQNAGYKLWVVQAGTLIAHLLSAAGADHVITMDLHDPQFPGFFDIPVDNLYCKPIAQNYIQHRIPDYQDAVIVSPDAGGAKRATAIADALELSFALIHKERRSQLLKGPPDATLTSGGSLPVSPRPLVTTLVSSQNTTSSGATGVAALEMKKTTSTSSTSSQSSNSSKFVQTTMLVGDVRNKVCIIVDDLVDTSYTITRAAKLLKDQGSTKVYALITHGVFSGDALERIGQSSIDKLIISNTVPQDRTLQYLGKDRVDVIDVSCIIGEAIRRIHNGESISMLFEHGW');
INSERT INTO proteininfo VALUES ('6324510', 'NP_014579.1','Clathrin associated protein, medium subunit; Apm4p [Saccharomyces cerevisiae]','MISGVLVYSSRGELVLNKFFKNSLKRSISDIFRVQVINNLDVRSPVLTLGSTTFHHIRSRHGDNLWLVTITRSNANSAAIWEFLYKLDAVMNAYRLDREEALKEEFMIVHEMLDIMLGGNGIPIDTELNSVIAQMSVKPVRNMGGLLDSPDGNDVLSSSSSPTSSAGELHFPKFLTKRSSSFLGQGDSTSDFYDNNKITWRPKGIIHKKDEVFLYVNERINILVSRDGSILKSYVDGTIDITTHLSGTPICRFGLNDSLGMQSEDEKKWLAQQQRHSGSDFGNKNFIPKAAAGSVLLEDCKFHECVSLDKFNRNHIIEFVPPDGSMELMKYHVRDNINLPFKVTPIVTHSTRDNEIDYRITLKSLFPGKLSAKDVVLHIPVPPSTVDCKISVSNGHCKFVPEENAMIWRFNKYNGLTENTLSAVTVSTSDTTQLNLQQWTRPPISLEFEVMMFSNSGLVVRYFTISGKDSKHRAVKWIKYISKAGSYEVRY');
INSERT INTO proteininfo VALUES ('6324509', 'NP_014578.1','Hus1p [Saccharomyces cerevisiae]','MPPQIPNENDDLFTRWLKSRAIIQRAVSTRECFDSEVFLASGGWNITNEIITLKKYYQLKWPNSSCNSFHPKTVEFIKERLHNLEEHDSSWKIPNPAYSFKKAFLEDTKSAFSNLEPVWGPSRLLNPAELLLPQDEKLLVQEIPLEFAPFQYTNRFAYGGLQFKNNLFVTYGSYSFLAAGQCVEVHNFDILLNVSSLEICHALLPVIIPDDGDVRNFRNSSYVKFKDTQFNSIPELCSINFMKICNFMHQDFLLACGDNGIVYIWEINKVIKIFNKFTSDILGGKDNSRERYINVDPYMVLRVEESCWSVDVIDINGIIYIAVGHNKPGVTVFAFDKDVKKERRYIRPLDLPSSHNVPCVNFVPNSKDSVGYITLSYCSIFGNVVTVKLKEHDCTILTSFLDTQFFGDDLWTITPLTKKDFAKVDNFELLNLNYQDGFKESMLYSICRDDFLLGYYCDNAYLSGNFGIGTLLNQFQVPVTDLRLTSSAGIPDEVIPLRFTSFDRNYTTTGSIKYEYSREDFALILHAGDLDDMNDAVTKNTSCEQHLHQWTFWEDSGYKHYRATERGFSKYKDIINTFPQLITPSGRNKTSQYQNTSGRKICEPSTYKLTDLENDIEDISREFNRSIRNLKMDKQRQLRTSKEFKSLSSVNHIPNIESGNFLWYNTDAAADWRTLFGKDLNTVLKDPEICSLQLNSTEEDDVNSDPENEESGSSLTSFQRRYRDTEQRAHLKSESQKSWGFHNYVRNVKRLLESAVPGSEDSPLGYQLSEMHDEFFFLTTAHRLVLMKANPLIIISATHHEIFPLDGVVTCASKSLLQALNRINFVCHIKELNCIAVASQLGLISLLRLTEYRGIYSFRQEYILGWEVQDPVNPSPECRCNRNLFDAPMYGADGESSDTYCGVCDVYFPMGDICGLDYTYASDSEELKRKGYATLYVASRGSLRAFKITTEHGTTQQ');
INSERT INTO proteininfo VALUES ('6324508', 'NP_014577.1','Bisphosphate-3'-nucleotidase, involved in salt tolerance and methionine biogenesis; dephosphorylates 3'-phosphoadenosine-5'-phosphate and 3'-phosphoadenosine-5'-phosphosulfate, intermediates of the sulfate assimilation pathway; Met22p [Saccharomyces cerevisiae]','MALERELLVATQAVRKASLLTKRIQSEVISHKDSTTITKNDNSPVTTGDYAAQTIIINAIKSNFPDDKVVGEESSSGLSDAFVSGILNEIKANDEVYNKNYKKDDFLFTNDQFPLKSLEDVRQIIDFGNYEGGRKGRFWCLDPIDGTKGFLRGEQFAVCLALIVDGVVQLGCIGCPNLVLSSYGAQDLKGHESFGYIFRAVRGLGAFYSPSSDAESWTKIHVRHLKDTKDMITLEGVEKGHSSHDEQTAIKNKLNISKSLHLDSQAKYCLLALGLADVYLRLPIKLSYQEKIWDHAAGNVIVHEAGGIHTDAMEDVPLDFGNGRTLATKGVIASSGPRELHDLVVSTSCDVIQSRNA');
INSERT INTO proteininfo VALUES ('6324507', 'NP_014576.1','Phosphatidylinositol 4,5-bisphosphate 5-phosphatase with a role in secretion, localizes to the endoplasmic reticulum via the C-terminal tail; lacks the Sac1 domain and proline-rich region found in the other 3 INP proteins; Inp54p [Saccharomyces cerevisiae]','MNKTNWKVSVTTFNCGKEFPVENSKAIVKQLLFPYDDGISQLELQDLYVLGFQEVVPIWQGSFPAVNRDLIDRITTTAVNCLNEKVSATQGDEQYSCLGVNSLGAITIIVLYNNNALKVKDDILKRNGKCGWFGTHLKGGTLISFQMTRNGEENWERFSYICAHLNANEGVNNRNQRIDDYKRIMSEVCDSEVAKSDHFFFLGDLNFRVTSTYDPTTNYSSTTTLRRLLENHEELNLLRKGEDEPLCKGFQELKITFPPTYKFKLFEKETYNTKRIPSWCDRILYKSYAVPTFAQEGTYHSVPRSNALLFSDHQPVNLTVRLPRSTGTPVPLSLHIEKYPLSWSSGLIGQIGDAVIGYCGWLVTKNVHYWILGSLLLYLLLKIL');
INSERT INTO proteininfo VALUES ('6324506', 'NP_014575.1','N-terminal part related to RNA:pseudouridine (psi)-synthases; C-terminal portion contains the deaminase domain implicated in riboflavin synthesis; DRAP deaminase; Rib2p [Saccharomyces cerevisiae]','MEDSNNEASDDFNNLLNKEIESAKEVKLRKFANRNNNRNENSSKVKDASGFRLRVIQTDGHKTKKTDPDYEVTIDGPLRKIEPYFFTYKTFCKERWRDRKLVDVFVSEFRDREPSYYSKTIAEGKVYLNDEPANLDTIIRDGDLITHKVHRHEPPVTSKPIDIVFEDEDILVIDKPSSIPVHPTGRYRFNTITKMLERQLGYSVHPCNRLDKPTSGLMFLAKTPLGADRMGDQMKAREVTKEYVARVKGEFPIGIVEVDKPVRSVNPKVALNAVCEMSDENAKHAKTVFQRVSYDGQTSIVKCKPLTGRTHQIRVHLQYLGFPIANDPIYSNPDIWGPDLGRGGLQNYDDIVLKLDAIGKTNPAESWIHPHSEGEYLLGRQCEECEAEMYTDPGTNDLDLWLHAFRYESLERNSDTQKPLWSYRTKYPEWALEPHRRYMEMAVKEAGKCGPTKTAFSVGAVLVHGTQVLATGYSRELPGNTHAEQCALIKYSQLHPNCPTIVPMGTVLYTTMEPCSFRLSGNEPCCDRILATQGAIGTVFVGVMEPDTFVKNNTSLNKLESHGVNYIQIPGYEEECTIIAFKGHDNSDDKA');
INSERT INTO proteininfo VALUES ('6324505', 'NP_014574.1','Transcription factor (bHLH) involved in interorganelle communication between mitochondria, peroxisomes, and nucleus; Rtg1p [Saccharomyces cerevisiae]','MSSIPAGTDPGSCGANFKNDRKRRDKINDRIQELLSIIPKDFFRDYYGNSGSNDTLSESTPGALGLSSKAKGTGTKDGKPNKGQILTQAVEYISHLQNQVDTQNREEVELMVKATQLAKQTGTIVNDINLENTSAEVALSRIGVGPLAATNDDSVRPPAKRLSSFEYGGYGEYGNGS');
INSERT INTO proteininfo VALUES ('6324504', 'NP_014573.1','Homolog of SIR2; Hst1p [Saccharomyces cerevisiae]','MNILLMQRIVSFILVVSQGRYFHVGELTMTMLKRPQEEESDNNATKKLKTRLTYPCILGKDKVTGKFIFPAITKDDVMNARLFLKDNDLKTFLEYFLPVEVNSIYIYFMIKLLGFDVKDKELFMALNSNITSNKERSSAELSSIHAKAEDEDELTDPLEKKHAVKLIKDLQKAINKVLSTRLRLPNFNTIDHFTATLRNAKKILVLTGAGVSTSLGIPDFRSSEGFYSKIRHLGLEDPQDVFNLDIFLQDPSVFYNIAHMVLPPENMYSPLHSFIKMLQDKGKLLRNYTQNIDNLESYAGIDPDKLVQCHGSFATASCVTCHWQIPGEKIFENIRNLELPLCPYCYQKRKQYFPMSNGNNTVQTNINFNSPILKSYGVLKPDMTFFGEALPSRFHKTIRKDILECDLLICIGTSLKVAPVSEIVNMVPSHVPQILINRDMVTHAEFDLNLLGFCDDVASLVAKKCHWDIPHKKWQDLKKIDYNCTEIDKGTYKIKKQPRKKQQ');
INSERT INTO proteininfo VALUES ('6324503', 'NP_014572.1','Spindle pole body protein, required for chromosome segregation during mitosis; part of a centromeric complex along with Tid3p, Spc25p, and Spc24p; Nuf2p [Saccharomyces cerevisiae]','MSRNQDVFPILDLQELVICLQSCDFALATQENISRPTSDYMVTLYKQIIENFMGISVESLLNSSNQETGDGHLQEENENIYLDTLNVLVLNKICFKFFENIGVQDFNMTDLYKPEAQRTQRLLSAVVNYARFREERMFDCNSFILQMESLLGQLRSKFDDYNLIQQQLKQYEDVDGDNIPDEQELQKLEEQNKELEIQLKKLTKIQETLSIDYNDYKISKQSIFKDLEALSFQIVELESNRDKLIKISNTDMEELSEGIKELNDLLIQRKKTLDDLTAQQKNLQDTVTTFETIISELYDVLRIISSEVQESNRTETELVGLKQNLINNKLKLMNVLETGIMYKLEILQEQLDLQLKNLEKLSQDTKEESRLNDTKLMDLQIKYENEIKPKIDKTDIFIQEELISGKINKLNDEIKQLQKDFEVEVKEIEIEYSLLSGHINKYMNEMLEYMQ');
INSERT INTO proteininfo VALUES ('6324502', 'NP_014571.1','Protein of unknown function; green fluorescent protein (GFP)-fusion protein localizes to the cell periphery, cytoplasm, and bud neck; potential Cdc28p substrate; Yol070cp [Saccharomyces cerevisiae]','MSEEREENGISRATLNTQRLSAMIDSLNNEKDDRLFPSPTTTRTMITEEKADQSDVFKPPSRLLRSPAGDVSLPPGDNRSSMISNYSGIIQEGVEVSYVVKNRQQTQERRTSKDSNSLYSLKEPVSKNELPSLPMLPSEATLTKHLSDNQSTKSNTNADEIVIKPVTNAKPVGRFNSNTSKKVEGRGSLKLLSSPLRQEKVMRSSIGSGNLASESGSSTYNTKFHQSIQEQLEEEEEGNVSDKLSIVSSVIPELYTTTNEAPKAINPIRSETNDYNPTIPPRSKDRPRSRLFIEEGDGEGDLLTEEILPTPVQPGGHYKNSSQISTVSEQKSESYYSAATSMPPEEETYLTRPLPSTPNEDSRVTSNLKRDDTLKAIHDRANHTSTSTNKQDDDMYEDIIEETPKKTKLKKDTKKKLNKKKSVKELRSFDIDTLNQLLSVTKGTLIGSEFAQLGMKIEEKRALERLVDSLSRLTADMVLDPDRYEEGLKRLDKATKALEGF');
INSERT INTO proteininfo VALUES ('6324501', 'NP_014570.1','Non-essential protein of unknown function required for transcriptional induction of the early meiotic-specific transcription factor IME1, also required for sporulation; Emi5p [Saccharomyces cerevisiae]','MHNMFPALTKTLSLQGYKIINSQTGSAAWSCGRRWFSSDKDDHDDVVTRIKIAPIKRTNEPLDKKRARLIYQSRKRGILETDLLLSGFAAKYLKKMNEEELEEYDSLLNELDWDIYYWATKNFKTSPLPDKWANSKLLKQLQEFSENKEKEILSMPDLSKYQ');
INSERT INTO proteininfo VALUES ('6324500', 'NP_014569.1','Thp1p [Saccharomyces cerevisiae]','MDMANQLLDELAHGNFSHLTLNLSQNGREIAILQKQLTGFDDKQLETFVEQHPAMPNDTRFKIMCTSFLNYARDVDPWSAWSSSDLIFEFYQCLINCLINDNAPHIEMLIPVATRETEFIINLAGKLDSFHLQLHTRSHQFLSHISSILSRLFNSIKPPRGNASSTNIPGKQRILLYLVNKLNNIYFRIESPQLCSNIFKNFQPKSMLAHFNEYQLDQQIEYRYLLGRYYLLNSQVHNAFVQFNEAFQSLLNLPLTNQAITRNGTRILNYMIPTGLILGKMVKWGPLRPFLSQETIDNWSVLYKHVRYGNIQGVSLWLRQNERHLCARQLLIVLLEKLPMVTYRNLIKTVIKSWTTEWGQNKLPYSLIERVLQLSIGPTFEDPGAQEITIYNGIHSPKNVENVLVTLINLGLLRANCFPQLQLCVVKKTTMIQEIVPPVNERITKMFPAHSHVLW');
INSERT INTO proteininfo VALUES ('6324499', 'NP_014568.1','Hypothetical ORF; Yol073cp [Saccharomyces cerevisiae]','MSMEPPVGLTAMPVTKLAMITTLVVPLVASIASYKHIFLLQYDPFLQTYHQYYRLLIFQFCAINESDTVILALIWYLFRHLERLLGSHKYLTLIVLSWAYTTLGIWGLNLIWNAFIGQYKWLQWNNFSTGSLPIVLSLVHFYKEYTPQIYEWNIRLLGPRGGASSHNDNKREDKSAVEWKINDQFLLNGLILLLILNQGFAGILCGFISWMCGIFIDKGLLPGLDHWRIPFVSYFISQGPPTRANVAIAANAATNTAAARATVEAATAATGNGNTGNSGPTSLPLRGSSTTPTNTSSAGDDEPGADEPARPLGVQFLDTFRR');
INSERT INTO proteininfo VALUES ('6324498', 'NP_014567.1','Hypothetical ORF; Yol075cp [Saccharomyces cerevisiae]','MSQQENGDVATELIENRLSFSRIPRISLHVRDLSIVASKTNTTLVNTFSMDLPSGSVMAVMGGSGSGKTTLLNVLASKISGGLTHNGSIRYVLEDTGSEPNETEPKRAHLDGQDHPIQKHVIMAYLPQQDVLSPR